c;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Fortran -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; funalpqed.f --- 
c;; Author          : Friedrich Jegerlehner
c;; Created On      : Sun Jan 17 05:35:18 2010
c;; Last Modified By: Fred Jegerlehner
c;; Last Modified On: Tue Oct 14 22:45:16 2025
c;; RCS: $Id$
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; Copyright (C) 2025 Friedrich Jegerlehner
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; 
      function funalpqedcx(s,cerror,cerrorsta,cerrorsys,
     &     contributionflag,Wtopflag)
c calculating alpha complex of error cerror, statstical and systematic hadronic uncertainties in
c     provided separately via cerrorsta,cerrorsys
c     Wtopflag=0 no W, no top    ! to be set in MAIN via common.h
c              1 top, no W
c              2 top and W (in MSbar)      
c              3 W, no top
c     below the 2 MW threshold W does not except for the neutrino charge radius
c     which is taken seperatly in applications as a process dependnt contribution
c     the top quark contribution also only contributes above the 2 M_top threshold      
      implicit none
      character*3 contributionflag
      real*8 st2,als,mtop
      double precision s,error,null,rerr,ierr
      double complex funalpqedcx,cerror,cerrorsta,cerrorsys
      double complex cggvapx,cerrder,cerrdersta,cerrdersys,
     &     calept,cahadr,caltop,cDalphaweak1MSb
      double complex cone,calp,cvpt_new,cvpt_hig,cvpt_low,alphac,alphah
     &     ,alphal,alphact,alphaht,alphalt
      external cggvapx
      include 'common.h'
      common /parm/st2,als,mtop
      common /cres/calept,cahadr,caltop,cDalphaweak1MSb  ! complex results

      LEPTONflag=contributionflag
      iLEP=LFLAG(LEPTONflag)
c
      null=0.d0
      cone=DCMPLX(1.d0,null)
      calp=DCMPLX(alp,null)
c
      cvpt_new= cggvapx(s,cerrder,cerrdersta,cerrdersys)
      cvpt_hig= cvpt_new+cerrder
      cvpt_low= cvpt_new-cerrder
c
      if (Wtopflag.eq.0) then
         alphac =calp/(cone-cvpt_new)
         alphah =calp/(cone-cvpt_hig)
         alphal =calp/(cone-cvpt_low)
      else if (Wtopflag.eq.1) then
         alphac=calp/(cone-cvpt_new-caltop)
         alphah=calp/(cone-cvpt_hig-caltop)
         alphal=calp/(cone-cvpt_low-caltop)
      else if (Wtopflag.eq.2) then
         alphac=calp/(cone-cvpt_new-caltop-cDalphaweak1MSb)
         alphah=calp/(cone-cvpt_hig-caltop-cDalphaweak1MSb)
         alphal=calp/(cone-cvpt_low-caltop-cDalphaweak1MSb)
      else if (Wtopflag.eq.3) then
         alphac=calp/(cone-cvpt_new-cDalphaweak1MSb)
         alphah=calp/(cone-cvpt_hig-cDalphaweak1MSb)
         alphal=calp/(cone-cvpt_low-cDalphaweak1MSb)
      endif
      rerr=abs(DREAL(alphah-alphal))/2.d0
      ierr=abs(AIMAG(alphah-alphal))/2.d0
      cerror=DCMPLX(rerr,ierr)
      cerrorsta=alphac/calp*alphac*cerrdersta
      cerrorsys=alphac/calp*alphac*cerrdersys
      funalpqedcx=alphac
      return
      END

      function funalp2SMcx(s,cerror,cerrorsta,cerrorsys,
     &     contributionflag,Wtopflag)
      implicit none
      character*3 contributionflag,Ismooth
      real*8 s,null,rerr,ierr
      double complex funalp2SMcx,cegvapx,cerror,cerrorsta,cerrorsys
      real*8 st2,als,mtop,alp2
      double complex cglept,cghadr,cgetop,cvpt_new,cvpt_hig,cvpt_low
      double complex alpha2c,alpha2h,alpha2l,alpha2ct,alpha2ht,alpha2lt,
     &     cDalpha2weak1MSb,
     &     cone,calp2,cerrdeg,cerrdegsta,cerrdegsys
      external cegvapx
      include 'common.h'      
      common /parm/st2,als,mtop
      common /cesg/cglept,cghadr,cgetop,cDalpha2weak1MSb

      LEPTONflag=contributionflag
      iLEP=LFLAG(LEPTONflag)
c      
      alp2=alp/st2
      null=0.d0
      cone=DCMPLX(1.d0,null)
      calp2=DCMPLX(alp2,null)
c
      cvpt_new= cegvapx(s,cerrdeg,cerrdegsta,cerrdegsys)
      cvpt_hig= cvpt_new+cerrdeg
      cvpt_low= cvpt_new+cerrdeg

      if (Wtopflag.eq.0) then
         alpha2c =calp2/(cone-cvpt_new)
         alpha2h =calp2/(cone-cvpt_hig)
         alpha2l =calp2/(cone-cvpt_low)
      else if (Wtopflag.eq.1) then
         alpha2c=calp2/(cone-cvpt_new-cgetop)
         alpha2h=calp2/(cone-cvpt_hig-cgetop)
         alpha2l=calp2/(cone-cvpt_low-cgetop)
      else if (Wtopflag.eq.2) then
         alpha2c=calp2/(cone-cvpt_new-cgetop-cDalpha2weak1MSb)
         alpha2h=calp2/(cone-cvpt_hig-cgetop-cDalpha2weak1MSb)
         alpha2l=calp2/(cone-cvpt_low-cgetop-cDalpha2weak1MSb)
      else if (Wtopflag.eq.3) then
         alpha2c=calp2/(cone-cvpt_new-cDalpha2weak1MSb)
         alpha2h=calp2/(cone-cvpt_hig-cDalpha2weak1MSb)
         alpha2l=calp2/(cone-cvpt_low-cDalpha2weak1MSb)
      endif
      rerr=abs(DREAL(alpha2h-alpha2l))/2.d0
      ierr=abs(AIMAG(alpha2h-alpha2l))/2.d0
      cerror=DCMPLX(rerr,ierr)
      cerrorsta=alpha2c/calp2*alpha2c*cerrdegsta
      cerrorsys=alpha2c/calp2*alpha2c*cerrdegsys
      funalp2SMcx=alpha2c
      return
      END
      
