CCCCCCCCCCCCCCCCCCCCCCCCCCCCC -*- Mode: Fortran -*- CCCCCCCCCCCCCCCCCCCCCCCCCCC
CC funsin2theta.f -- 
CC Author          : Fred Jegerlehner
CC Created On      : Wed Oct 15 11:51:55 2025
CC Last Modified By: Fred Jegerlehner
CC Last Modified On: Wed Oct 15 14:11:14 2025
CC RCS: $Id$
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC Copyright (C) 2025 Friedrich Jegerlehner
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC 
c provides sin^2 theta effective defined as ratio of running couplings
c sin2theta=alpha/alpha_2       
c add process dependent vertex corrections in MAIN            
      function funsin2thetaSM(s,cerror,cerrorsta,cerrorsys,
     &     contributionflag,Wtopflag)
      implicit none
      character*3 contributionflag,Ismooth
      real*8 s,null,lam2,ilam2,lam3,MW2,MZ2,mu2
      double complex funsin2thetaSM,cerror,cerrorsta,cerrorsys
      double complex funalpqedcx,funalp2SMcx,alphaqed,alphasu2,
     &     caerror,caerrorsta,caerrorsys,cgerror,cgerrorsta,cgerrorsys
      real*8 st2,als,mtop,alp2,sW2,cW2,sin2wofq,sin2w
      double complex cglept,cghadr,cgetop,cDalpha2weak1MSb,
     &               calept,cahadr,caltop,cDalphaweak1MSb
      double complex alpha2c,alpha2h,alpha2l,alpha2ct,alpha2ht,alpha2lt,
     &     cone,calp2,cerrdeg,cerrdegsta,cerrdegsys
      double precision rLambda2Z,iLambda2Z,rLambda2W,iLambda2W,
     &     rLambda3W,deltakappae_vertex,deltamunue_verteandbox,
     &     sin2theta_e,sin2thetanumue,kappa,eps
      double complex cLambda2Z,clambda2W,clambda3W
      external funalpqedcx,funalp2SMcx,lam2,lam3
      include 'common.h'      
      common /parm/st2,als,mtop
      common /cres/calept,cahadr,caltop,cDalphaweak1MSb
      common /cesg/cglept,cghadr,cgetop,cDalpha2weak1MSb
      eps=1.d-2
c to be set in MAIN      
C      als=0.1189d0     ! +/- 0.0017
C      st2=0.23153d0    ! Reference value for weak mixing parameter used in calculation SU(2) coupling shift deg
C      mtop=172.4d0
C      contributionflag='all'
      LEPTONflag=contributionflag
      iLEP=LFLAG(LEPTONflag)
      call constants()
      alp2=alp/st2
      sin2theta_e=st2
      null=0.d0
      cone=DCMPLX(1.d0,null)
      calp2=DCMPLX(alp2,null)
      mu2=ml(2)**2
      MZ2=MZ**2
      MW2=MW**2
      sW2=st2
      cW2=1.d0-sW2
      alphaqed=funalpqedcx(s,caerror,caerrorsta,caerrorsys,
     &     contributionflag,Wtopflag)
      alphasu2=funalp2SMcx(s,cgerror,cgerrorsta,cgerrorsys,
     &     contributionflag,Wtopflag)*st2
c define sin2thta as alpha/alpha_2, add process dependent vertex corrections in MAIN      
C      rLambda2Z=lam2(s,MZ2)
C      iLambda2Z=ilam2(s,MZ2)
C      cLambda2Z=DCMPLX(rLambda2Z,iLambda2Z)
C      rLambda2W=lam2(s,MW2)
C      iLambda2W=ilam2(s,MW2)
C      cLambda2W=DCMPLX(rLambda2W,iLambda2W)
C      cLambda3W=DCMPLX(lam3(s,MW2),null)
C      deltamunue_verteandbox=alphasu2/st2/(4.d0*pi)*
C     &     (2.d0/3.d0*(dlog(MW2/mu2)+1.d0)
C     &     +((24.d0*cW2**2-14.d0*cW2+9.d0)/(4.d0*cW2)))
C      if ((s.gt.eps).and.(s.lt.MW2)) then
C         deltakappae_vertex=sqrt(2.d0)*gmu*MZ2/(16.d0*pi**2)*
C     &        (-(1.d0-4.d0*sW2)*(1.d0-2.d0*sW2)*cLambda2Z
C     &        +2.d0*cW2*cLambda2W
C     &        -12.d0*cW2**2*cLambda3W)
C      else
C         deltakappae_vertex=null
C      endif
c ACWM convention: sin2(Q^2)=kappa*sin2(M_Z^2)
      kappa=alphaqed/alphasu2
C      kappa=(alphaqed/alphasu2
C     &     +deltamunue_verteandbox+deltakappae_vertex)
      sin2thetanumue=sin2theta_e*kappa
C      write (*,*) alphaqed/alphasu2
C      write (*,*) deltamunue_verteandbox,deltakappae_vertex
C     write (*,*) sin2thetanumue
C      write (*,*) sinwofq,sin2w,kappa        
      funsin2thetaSM=sin2thetanumue
      return
      end
C
      function lam2(s,M2)
C     -------------------
      implicit none
      double precision lam2,s,M2,y,ddilog,rLambda2
      external ddilog
c     M=M_W or M_Z and s>0
      y=M2/s
      if (s.lt.4d0*M2) then
         rLambda2=-7.d0/2.d0-2.d0*y-(2.d0*y+3.d0)*dlog(y)
     &        +2.d0*(1.d0+y)**2*(dlog(y)*dlog((1.d0+y)/y)
     &        -ddilog(-1.d0/y))
      else
         write (*,*) 'lam2 --- out of range, y=M2/s=',y
      endif
      lam2=rLambda2
      return
      end
C
      function ilam2(s,M2)
C     -------------------
c imaginary pat of Lambda_2(s,M)      
      implicit none
      double precision pi,s,M2,ilam2,y,iLambda2
      data pi /3.141592653589793d0/
c     M=M_W or M_Z and s>0
      y=M2/s
      if (s.lt.4d0*M2) then
         iLambda2=-pi*(3.d0+2.d0*y-2.d0*(y+1.d0)**2*dlog((1.d0+y)/y))
      else
         write (*,*) 'ilam2 --- out of range, y=M2/s=',y
      endif
      ilam2=iLambda2
      return
      end
c
      function lam3(s,M2)
C     -------------------
      implicit none 
      double precision lam3,s,M2,y,rLambda3,rtx,aty
      y=M2/s
      if (s.lt.4d0*M2) then
         rtx=sqrt(4.d0*y-1.d0)
         aty=datan(1.d0/rtx)
         rLambda3=(5d0/2.d0-2.d0*y+2.d0*(2.d0*y+1.d0)*rtx*aty
     &        -8.d0*y*(y+2.d0)*aty**2)/3.d0
      else
         write (*,*) 'lam3 --- out of range, y=M2/s=',y
      endif
      lam3=rLambda3
      return
      end
      
      subroutine kappa_MoellerScattering(sin2w,Q2,kappaCM,
     &     dkappab,dkappaf,dkappab0)
c     Carnecki & Marciano, Int.J.Mod.Phys. A15 (2000) 2365-2376
c     ACWM convention: sin2(Q^2)=kappa*sin2(M_Z^2)
c     dkappab bosnic incl Neutrino charge radius; dkappab0 value at Q=0
c     dkappaf: leptons and effective quarks QCD at one loop
      implicit none
      integer i
      double precision Q2,MW2,MZ2,kappaCM,z,alpfac,sin2w,cos2w,
     &     sin2wz,sin2w0,dkappab,dkappaf,dkappab0,xxf,xxq,xxt,
     &     null,one,ha,two,third,four,twothird,
     &     fourrtb,fivethird,lograt,logratf,eps
      double precision st2,als,mtop
      double precision big,mf2,T3l,Ql,zf,rtb,rtf
      double precision mq(6),mp(6),T3q(6),Qq(6),qqi(6),t3qi(6)
      common /parm/st2,als,mtop
      include 'common.h'      
      call constants()
c quark masses MSbar mq, pole mp and thresholds th me errors dmp
      DATA MQ /0.005D0,0.009D0,0.190D0,1.286D0,4.164D0,163.4D0/
      DATA MP /0.005D0,0.009D0,0.190D0,1.666D0,4.800D0,171.3D0/
c               u,d,s,c,b,t
      data t3qi /1.0d0,-1.0d0,-1.0d0,1.0d0,-1.0d0,1.0d0/
      data qqi  /2.0d0,-1.0d0,-1.0d0,2.0d0,-1.0d0,2.0d0/
      null=0.d0
      one=1.d0
      eps=1.d-6
      if (Q2.le.eps) then
         kappaCM=one
         dkappab=null
         dkappaf=null
         dkappab0=null
         return
      endif
      big=1.d6
      ha=0.5d0
      twothird=2.d0/3.d0
      third   =1.d0/3.d0
      do i=1,6
         T3q(i)=t3qi(i)*ha
         Qq(i)=qqi(i)*third
      enddo
      Ql=-1.d0
      T3l=-ha
c C & M effective light quark masses      
      mq(1)=0.1d0
      mq(2)=mq(1)
      mq(3)=mq(1)
c      
      two=2.d0
      four=4.d0
      fivethird=5.d0/3.d0
      mw2=mw*mw
      mz2=mz*mz
      sin2w=0.23073d0  ! =/-0.00028  Czarnecki & Marciano sin2 theta_W(M_Z) MSbar
C      sin2w=sin2wz
C     st2=sin2w0
c sin2w now input
C     sin2w=st2         ! sin^2 Theta at LEP
      cos2w=one-sin2w
      alpfac=alp*0.5d0/pi/sin2w
c      
      z=mw2/Q2
            if (z.gt.big) then
               dkappab=-alpfac*(-(42.d0*cos2w+one)/12.d0*log(cos2w)
     &              +one/18.d0+(6.d0*cos2w+7.d0)/18.d0)
     &              -(444.d0*cos2w+43.d0)/720.d0/z
     &              +(530.d0*cos2w+71.d0)/8400.d0/z/z
            else
               rtb=sqrt(one+four*z)
               lograt=log((rtb+one)/(rtb-one))
               dkappab=-alpfac*(-(42.d0*cos2w+one)/12.d0*log(cos2w)
     &              +one/18.d0
     &              -(ha*rtb*lograt-one)*((7.d0-four*z)*cos2w
     &              +one/6.d0*(one+four*z))
     &         -z*(0.75d0-z+(z-1.5d0)*rtb*lograt+z*(2.d0-z)*lograt**2))
            endif
            dkappab0=-alpfac*(-(42.d0*cos2w+one)/12.d0*log(cos2w)+
     &           one/18.d0+(6.d0*cos2w+7.d0)/18.d0)
            xxf=null
            xxq=null
            xxt=null
c leptons
            do i=1,3
               mf2=ml(i)**2
               zf=mf2/Q2
               if (zf.gt.big) then
                  xxf=xxf+(T3l*Ql-two*sin2w*Ql**2)*(log(mf2/mz2)
     &                 +1.d0/5.d0/zf-3.d0/140.d0/zf/zf)
               else
                  rtf=sqrt(one+four*zf)
                  logratf=log((rtf+one)/(rtf-one))
                  xxf=xxf+(T3l*Ql-two*sin2w*Ql**2)*(log(mf2/mz2)
     &                 -fivethird+four*zf+(one-two*zf)*rtf*logratf)
               endif
            enddo
c light quarks
            do i=1,5
               mf2=mq(i)**2
               zf=mf2/Q2
               if (zf.gt.big) then
                  xxq=xxq+3.d0*(T3q(i)*Qq(i)-two*sin2w*Qq(i)**2)*(
     &                 log(mf2/mz2)
     &                 +1.d0/5.d0/zf-3.d0/140.d0/zf/zf)
               else
                  rtf=sqrt(one+four*zf)
                  logratf=log((rtf+one)/(rtf-one))
                  xxq=xxq+3.d0*(T3q(i)*Qq(i)-two*sin2w*Qq(i)**2)*(
     &                 log(mf2/mz2)
     &                 -fivethird+four*zf+(one-two*zf)*rtf*logratf)
               endif
            enddo
            i=6
            mf2=mq(i)**2
            zf=mf2/Q2
            if (zf.gt.big) then
               xxt=3.d0*(T3q(i)*Qq(i)-two*sin2w*Qq(i)**2)*(
     &              log(mf2/mz2)
     &              +1.d0/5.d0/zf-3.d0/140.d0/zf/zf)
            else
               rtf=sqrt(one+four*zf)
               logratf=log((rtf+one)/(rtf-one))
               xxt=3.d0*(T3q(i)*Qq(i)-two*sin2w*Qq(i)**2)*(
     &              log(mf2/mz2)
     &              -fivethird+four*zf+(one-two*zf)*rtf*logratf)
            endif
            dkappaf=-alpfac*(xxf+xxq+xxt)/3.d0
            kappaCM=one+dkappaf
     &           +dkappab
      return
      end
