c;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Fortran -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; hadr5n23.f ---
c;; Author          : Friedrich Jegerlehner
c;; Created On      : Thu Jul  6 12:20:17 2017
c;; Last Modified By: Fred Jegerlehner
c;; Last Modified On: Sat Sep 27 14:43:05 2025
c;; RCS: $Id$
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;; Copyright (C) 2023 Friedrich Jegerlehner
c;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
c;;
       subroutine hadr5x(e,st2,der,errdersta,errdersys,
     &     deg,errdegsta,errdegsys)
c Provides real part of 5 flavor hadronic contribution to photon vacuum polarization
c single precision HADR5 ; double precision DHADR5
c ******************************************************************
c *                                                                *
c *      subroutine for the evaluation of the light hadron         *
c *           contributions to Delta_r  and  Delta_g               *
c *                    using fits to the                           *
c *          QED vacuum polarization from e^+ e^- data             *
c *                                                                *
c *    F. Jegerlehner, Institut fr Physik                         *
c *                    Humboldt-Universitt zu Berlin              *
c *                    Newtonstrae 15, D-12489 Berlin, Germany    *
c *    E-mail: fjeger@physik.hu-berlin.de                          *
c *    Phone :   +49-3375 500 277                                  *
c *                                                                *
c *    Reference: F. Jegerlehner, Z. Phys. C32 (1986) 195          *
c *               H. Burkhardt et al., Z. Phys. C42 (1989) 497     *
c *               S. Eidelman, F. Jegerlehner, Z. Phys. C (1995)   *
c *               F. Jegerlehner,                                  *
c *                    Nucl.Phys.Proc.Suppl.131:213-222,2004       *
c *                    Nucl.Phys.Proc.Suppl.162:22-32,2006         *
c *                    Nucl.Phys.Proc.Suppl.181-182:135-140,2008   *
c *                                                                *
c ******************************************************************
c       VERSION: 23/12/2019
c
C  Notation: E energy ( momentum transfer ): E>0 timelike , E<0 spacelike
c      sin2ell=0.23153 ! pm 0.00016 LEPEEWG Phys Rep 427 (2006) 257
C            st2 is sin^2(Theta); st2=0.23153 is the reference value
C  the routine returns the hadronic contribution of 5 flavors (u,d,s,c,b)
C                 to   DER=Delta_r with hadronic error ERRDER
C                and   DEG=Delta_g with hadronic error ERRDEG
C  The effective value of the fine structure constant alphaQED at energy
C  E is alphaQED(E)=alphaQED(0)/(1-Delta_r) ,similarly for the SU(2)
C  coupling alphaSU2(E)=alphaSU2(0)/(1-Delta_g), where Delta_r(g) is the
C  sum of leptonic, hadronic contributions (top to be added).
C
      IMPLICIT NONE
      INTEGER NA,NB,NC,IJ,I,ini
      PARAMETER(NA=979,NB=2180,NC=200)
      real e,st2,der,errdersta,errdersys,deg,errdegsta,errdegsys,fac
      real dal(3),dg2(3)
      REAL ETA(NA),DAT(NA,3),DGT(NA,3)
      REAL ESA(NB),DAS(NB,3),DGS(NB,3)
      REAL EMA(NC),DAM(NC,3),DGM(NC,3)
      REAL XXX(NC),YGG(NC,3),Y3G(NC,3)
      COMMON /DATM25/EMA,DAM,DGM
      COMMON /DATT25/ETA,DAT,DGT
      COMMON /DATS25/ESA,DAS,DGS
      COMMON /DATH25/XXX,YGG,Y3G
      data ini/0/
C initialize data

      call dalhad_spacelike25

      call dalhad_spacelike1h25

      call dalhad_timelike25

      call dalhad_timelike1h25

c boundaries of data sets
c space-like high region            -2.0000E+04 - -1.0000E+03  (XXX,YGG)  [200]
c space-like and unphysical region  -1.0000E+03 - 0.27599999D0 (ETA,DAT)   [979]
c time-like R data range 0.28207018D0 - 38.29000000D0          (ESA,DAS)  [2180]
c time-like1 pQCD range 1.3005E+01 - 2.0000E+04                (EMA,DAM)   [200]
c 2 pion threshold at 0.27914....
c XXX(1) --- XXX(NC),ETA(1) --- ETA(NA),ESA(1) --- ESA(NB),EMA(1) --- EMA(NC)      

      if (st2.eq.0.0) then
         fac=1.0
      else
         fac=0.23153d0/st2
      endif
      if (e.eq.0.0) then
        der=0.0
        errdersta=0.0
        errdersys=0.0
        deg=0.0
        errdegsta=0.0
        errdegsys=0.0
        return
c first bridge cracks between regions
      else if ((e.ge.XXX(NC)).and.(e.lt.ETA(1))) then
        DO I=1,3
        dal(i)=YGG(NC,I)
     &    +(DAT(1,I)-YGG(NC,I))/(ETA(1)-XXX(NC))*(E-XXX(NC))
        dg2(i)=Y3G(NC,I)
     &    +(DAT(1,I)-Y3G(NC,I))/(ETA(1)-XXX(NC))*(E-XXX(NC))
        ENDDO
        der=dal(1)
        errdersta=dal(2)
        errdersys=dal(3)
        deg=dg2(1)*fac
        errdegsta=dg2(2)*fac
        errdegsys=dg2(3)*fac
        return
      else if ((e.ge.ETA(NA)).and.(e.lt.ESA(1))) then
        DO I=1,3
        dal(i)=DAT(NA,I)
     &    +(DAS(1,I)-DAT(NA,I))/(ESA(1)-ETA(NA))*(E-ETA(NA))
        dg2(i)=DGT(NA,I)
     &    +(DGS(1,I)-DGT(NA,I))/(ESA(1)-ETA(NA))*(E-ETA(NA))
        ENDDO
        der=dal(1)
        errdersta=dal(2)
        errdersys=dal(3)
        deg=dg2(1)*fac
        errdegsta=dg2(2)*fac
        errdegsys=dg2(3)*fac
        return
      else if ((e.lt.ETA(NA)).and.(e.ge.ETA(1))) then
        ij=NA
        do while (ETA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,3
        dal(i)=DAT(IJ,I)
     &    +(DAT(IJ+1,I)-DAT(IJ,I))/(ETA(IJ+1)-ETA(IJ))*(E-ETA(IJ))
        dg2(i)=DGT(IJ,I)
     &    +(DGT(IJ+1,I)-DGT(IJ,I))/(ETA(IJ+1)-ETA(IJ))*(E-ETA(IJ))
        ENDDO
        der=dal(1)
        errdersta=dal(2)
        errdersys=dal(3)
        deg=dg2(1)*fac
        errdegsta=dg2(2)*fac
        errdegsys=dg2(3)*fac
        return
      else if ((e.lt.EMA(NC)).and.(e.ge.EMA(1))) then
        ij=NC
        do while (EMA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,3
        dal(i)=DAM(IJ,I)
     &    +(DAM(IJ+1,I)-DAM(IJ,I))/(EMA(IJ+1)-EMA(IJ))*(E-EMA(IJ))
        dg2(i)=DGM(IJ,I)
     &    +(DGM(IJ+1,I)-DGM(IJ,I))/(EMA(IJ+1)-EMA(IJ))*(E-EMA(IJ))
        ENDDO
        der=dal(1)
        errdersta=dal(2)
        errdersys=dal(3)
        deg=dg2(1)*fac
        errdegsta=dg2(2)*fac
        errdegsys=dg2(3)*fac
        return
c### end point
      else if (e.eq.EMA(NC)) then
         ij=NC
         DO I=1,3
            dal(i)=DAM(IJ,I)
            dg2(i)=DGM(IJ,I)
         ENDDO
         der=dal(1)
         errdersta=dal(2)
         errdersys=dal(3)
         deg=dg2(1)*fac
         errdegsta=dg2(2)*fac
         errdegsys=dg2(3)*fac
         return
c ##        
      else if ((e.lt.ESA(NB)).and.(e.ge.ESA(1))) then
        if ((e.gt.3.96).and.(e.lt.4.52).and.(ini.eq.0)) then
c           write (*,*) ' ******************************************'
c           write (*,*) ' * Note: fluctuations in the Psi(4,5,6)   *'
c           write (*,*) ' * region are because we are using the    *'
c           write (*,*) ' * CB and BES data without any smoothing  *'
c           write (*,*) ' *********** FJ@HU Berlin *****************'
           ini=1
        endif
        ij=NB
        do while (ESA(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,3
        dal(i)=DAS(IJ,I)
     &    +(DAS(IJ+1,I)-DAS(IJ,I))/(ESA(IJ+1)-ESA(IJ))*(E-ESA(IJ))
        dg2(i)=DGS(IJ,I)
     &    +(DGS(IJ+1,I)-DGS(IJ,I))/(ESA(IJ+1)-ESA(IJ))*(E-ESA(IJ))
        ENDDO
        der=dal(1)
        errdersta=dal(2)
        errdersys=dal(3)
        deg=dg2(1)*fac
        errdegsta=dg2(2)*fac
        errdegsys=dg2(3)*fac
        return
      else if ((e.lt.XXX(NC)).and.(e.ge.XXX(1))) then
        ij=NC
        do while (XXX(ij).gt.e)
          ij=ij-1
        enddo
        DO I=1,3
        dal(i)=YGG(IJ,I)
     &    +(YGG(IJ+1,I)-YGG(IJ,I))/(XXX(IJ+1)-XXX(IJ))*(E-XXX(IJ))
        dg2(i)=Y3G(IJ,I)
     &    +(Y3G(IJ+1,I)-Y3G(IJ,I))/(XXX(IJ+1)-XXX(IJ))*(E-XXX(IJ))
        ENDDO
        der=dal(1)
        errdersta=dal(2)
        errdersys=dal(3)
        deg=dg2(1)*fac
        errdegsta=dg2(2)*fac
        errdegsys=dg2(3)*fac
        return
      else
         if (ini.le.10) then
            write(*,*) ' <hadr5n22> out of range! e=',e
            ini=ini+1
            if (ini.eq.10) write(*,*) ' Warning: continuing anyway ...'
         endif
      endif
      return
      end

       subroutine dhadr5x(de,dst2,dder,derrdersta,derrdersys,
     &     ddeg,derrdegsta,derrdegsys)
c **********************************************************************
c *    F. Jegerlehner, University of Silesia, PL-40007 Katowice, Poland *
c **********************************************************************
c Converts hadr5x to double precision variables in dhadr5x
c
       implicit none
       real *8 de,dst2,dder,ddeg,derrdersta,derrdersys,
     &      derrdegsta,derrdegsys
       real    se,sst2,sder,sdeg,serrdersta,serrdersys,
     &      serrdegsta,serrdegsys
       se  =sngl(de)
       sst2=sngl(dst2)
       call hadr5x(se,sst2,sder,serrdersta,serrdersys,sdeg,
     &      serrdegsta,serrdegsys)
       dder   =dble(sder)
       ddeg   =dble(sdeg)
       derrdersta=dble(serrdersta)
       derrdersys=dble(serrdersys)
       derrdegsta=dble(serrdegsta)
       derrdegsys=dble(serrdegsys)
       return
       end

c      ++++ dalhadt23 ++++  

c update 09/25/25 
       subroutine dalhad_spacelike25
       IMPLICIT NONE
       INTEGER NA,I,J
       PARAMETER(NA=979)
       REAL ETA(NA),DAT(NA,3),DGT(NA,3)
       COMMON /DATT25/ETA,DAT,DGT
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 14:28:50 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
       DATA  (ETA  (I), I=   1, 100) /
     &  -1.0000E+03,-9.9000E+02,-9.8000E+02,-9.7000E+02,-9.6000E+02,
     &  -9.5000E+02,-9.4000E+02,-9.3000E+02,-9.2000E+02,-9.1000E+02,
     &  -9.0000E+02,-8.9000E+02,-8.8000E+02,-8.7000E+02,-8.6000E+02,
     &  -8.5000E+02,-8.4000E+02,-8.3000E+02,-8.2000E+02,-8.1000E+02,
     &  -8.0000E+02,-7.9000E+02,-7.8000E+02,-7.7000E+02,-7.6000E+02,
     &  -7.5000E+02,-7.4000E+02,-7.3000E+02,-7.2000E+02,-7.1000E+02,
     &  -7.0000E+02,-6.9000E+02,-6.8000E+02,-6.7000E+02,-6.6000E+02,
     &  -6.5000E+02,-6.4000E+02,-6.3000E+02,-6.2000E+02,-6.1000E+02,
     &  -6.0000E+02,-5.9000E+02,-5.8000E+02,-5.7000E+02,-5.6000E+02,
     &  -5.5000E+02,-5.4000E+02,-5.3000E+02,-5.2000E+02,-5.1000E+02,
     &  -5.0000E+02,-4.9000E+02,-4.8000E+02,-4.7000E+02,-4.6000E+02,
     &  -4.5000E+02,-4.4000E+02,-4.3000E+02,-4.2000E+02,-4.1000E+02,
     &  -4.0000E+02,-3.9000E+02,-3.8000E+02,-3.7000E+02,-3.6000E+02,
     &  -3.5000E+02,-3.4000E+02,-3.3000E+02,-3.2000E+02,-3.1000E+02,
     &  -3.0000E+02,-2.9000E+02,-2.8000E+02,-2.7000E+02,-2.6000E+02,
     &  -2.5000E+02,-2.4000E+02,-2.3000E+02,-2.2000E+02,-2.1000E+02,
     &  -2.0000E+02,-1.9000E+02,-1.8000E+02,-1.7000E+02,-1.6000E+02,
     &  -1.5000E+02,-1.4000E+02,-1.3000E+02,-1.2000E+02,-1.1000E+02,
     &  -1.0000E+02,-9.9000E+01,-9.8000E+01,-9.7000E+01,-9.6000E+01,
     &  -9.5000E+01,-9.4000E+01,-9.3000E+01,-9.2000E+01,-9.1000E+01/
  
       DATA  (ETA  (I), I= 101, 200) /
     &  -9.0000E+01,-8.9000E+01,-8.8000E+01,-8.7000E+01,-8.6000E+01,
     &  -8.5000E+01,-8.4000E+01,-8.3000E+01,-8.2000E+01,-8.1000E+01,
     &  -8.0000E+01,-7.9000E+01,-7.8000E+01,-7.7000E+01,-7.6000E+01,
     &  -7.5000E+01,-7.4000E+01,-7.3000E+01,-7.2000E+01,-7.1000E+01,
     &  -7.0000E+01,-6.9000E+01,-6.8000E+01,-6.7000E+01,-6.6000E+01,
     &  -6.5000E+01,-6.4000E+01,-6.3000E+01,-6.2000E+01,-6.1000E+01,
     &  -6.0000E+01,-5.9000E+01,-5.8000E+01,-5.7000E+01,-5.6000E+01,
     &  -5.5000E+01,-5.4000E+01,-5.3000E+01,-5.2000E+01,-5.1000E+01,
     &  -5.0000E+01,-4.9000E+01,-4.8000E+01,-4.7000E+01,-4.6000E+01,
     &  -4.5000E+01,-4.4000E+01,-4.3000E+01,-4.2000E+01,-4.1000E+01,
     &  -4.0000E+01,-3.9000E+01,-3.8000E+01,-3.7000E+01,-3.6000E+01,
     &  -3.5000E+01,-3.4000E+01,-3.3000E+01,-3.2000E+01,-3.1000E+01,
     &  -3.0000E+01,-2.9000E+01,-2.8000E+01,-2.7000E+01,-2.6000E+01,
     &  -2.5000E+01,-2.4000E+01,-2.3000E+01,-2.2000E+01,-2.1000E+01,
     &  -2.0000E+01,-1.9000E+01,-1.8000E+01,-1.7000E+01,-1.6000E+01,
     &  -1.5000E+01,-1.4000E+01,-1.3000E+01,-1.2000E+01,-1.1000E+01,
     &  -1.0000E+01,-9.9100E+00,-9.8200E+00,-9.7300E+00,-9.6400E+00,
     &  -9.5500E+00,-9.4600E+00,-9.3700E+00,-9.2800E+00,-9.1900E+00,
     &  -9.1000E+00,-9.0100E+00,-8.9200E+00,-8.8300E+00,-8.7400E+00,
     &  -8.6500E+00,-8.5600E+00,-8.4700E+00,-8.3800E+00,-8.2900E+00/
  
       DATA  (ETA  (I), I= 201, 300) /
     &  -8.2000E+00,-8.1100E+00,-8.0200E+00,-7.9300E+00,-7.8400E+00,
     &  -7.7500E+00,-7.6600E+00,-7.5700E+00,-7.4800E+00,-7.3900E+00,
     &  -7.3000E+00,-7.2100E+00,-7.1200E+00,-7.0300E+00,-6.9400E+00,
     &  -6.8500E+00,-6.7600E+00,-6.6700E+00,-6.5800E+00,-6.4900E+00,
     &  -6.4000E+00,-6.3100E+00,-6.2200E+00,-6.1300E+00,-6.0400E+00,
     &  -5.9500E+00,-5.8600E+00,-5.7700E+00,-5.6800E+00,-5.5900E+00,
     &  -5.5000E+00,-5.4100E+00,-5.3200E+00,-5.2300E+00,-5.1400E+00,
     &  -5.0500E+00,-4.9600E+00,-4.8700E+00,-4.7800E+00,-4.6900E+00,
     &  -4.6000E+00,-4.5100E+00,-4.4200E+00,-4.3300E+00,-4.2400E+00,
     &  -4.1500E+00,-4.0600E+00,-3.9700E+00,-3.8800E+00,-3.7900E+00,
     &  -3.7000E+00,-3.6100E+00,-3.5200E+00,-3.4300E+00,-3.3400E+00,
     &  -3.2500E+00,-3.1600E+00,-3.0700E+00,-2.9800E+00,-2.8900E+00,
     &  -2.8000E+00,-2.7100E+00,-2.6200E+00,-2.5300E+00,-2.4400E+00,
     &  -2.3500E+00,-2.2600E+00,-2.1700E+00,-2.0800E+00,-1.9900E+00,
     &  -1.9000E+00,-1.8100E+00,-1.7200E+00,-1.6300E+00,-1.5400E+00,
     &  -1.4500E+00,-1.3600E+00,-1.2700E+00,-1.1800E+00,-1.0900E+00,
     &  -1.0000E+00,-9.9100E-01,-9.8200E-01,-9.7300E-01,-9.6400E-01,
     &  -9.5500E-01,-9.4600E-01,-9.3700E-01,-9.2800E-01,-9.1900E-01,
     &  -9.1000E-01,-9.0100E-01,-8.9200E-01,-8.8300E-01,-8.7400E-01,
     &  -8.6500E-01,-8.5600E-01,-8.4700E-01,-8.3800E-01,-8.2900E-01/
  
       DATA  (ETA  (I), I= 301, 400) /
     &  -8.2000E-01,-8.1100E-01,-8.0200E-01,-7.9300E-01,-7.8400E-01,
     &  -7.7500E-01,-7.6600E-01,-7.5700E-01,-7.4800E-01,-7.3900E-01,
     &  -7.3000E-01,-7.2100E-01,-7.1200E-01,-7.0300E-01,-6.9400E-01,
     &  -6.8500E-01,-6.7600E-01,-6.6700E-01,-6.5800E-01,-6.4900E-01,
     &  -6.4000E-01,-6.3100E-01,-6.2200E-01,-6.1300E-01,-6.0400E-01,
     &  -5.9500E-01,-5.8600E-01,-5.7700E-01,-5.6800E-01,-5.5900E-01,
     &  -5.5000E-01,-5.4100E-01,-5.3200E-01,-5.2300E-01,-5.1400E-01,
     &  -5.0500E-01,-4.9600E-01,-4.8700E-01,-4.7800E-01,-4.6900E-01,
     &  -4.6000E-01,-4.5100E-01,-4.4200E-01,-4.3300E-01,-4.2400E-01,
     &  -4.1500E-01,-4.0600E-01,-3.9700E-01,-3.8800E-01,-3.7900E-01,
     &  -3.7000E-01,-3.6100E-01,-3.5200E-01,-3.4300E-01,-3.3400E-01,
     &  -3.2500E-01,-3.1600E-01,-3.0700E-01,-2.9800E-01,-2.8900E-01,
     &  -2.8000E-01,-2.7100E-01,-2.6200E-01,-2.5300E-01,-2.4400E-01,
     &  -2.3500E-01,-2.2600E-01,-2.1700E-01,-2.0800E-01,-1.9900E-01,
     &  -1.9000E-01,-1.8100E-01,-1.7200E-01,-1.6300E-01,-1.5400E-01,
     &  -1.4500E-01,-1.3600E-01,-1.2700E-01,-1.1800E-01,-1.0900E-01,
     &  -1.0000E-01,-9.9100E-02,-9.8200E-02,-9.7300E-02,-9.6400E-02,
     &  -9.5500E-02,-9.4600E-02,-9.3700E-02,-9.2800E-02,-9.1900E-02,
     &  -9.1000E-02,-9.0100E-02,-8.9200E-02,-8.8300E-02,-8.7400E-02,
     &  -8.6500E-02,-8.5600E-02,-8.4700E-02,-8.3800E-02,-8.2900E-02/
  
       DATA  (ETA  (I), I= 401, 500) /
     &  -8.2000E-02,-8.1100E-02,-8.0200E-02,-7.9300E-02,-7.8400E-02,
     &  -7.7500E-02,-7.6600E-02,-7.5700E-02,-7.4800E-02,-7.3900E-02,
     &  -7.3000E-02,-7.2100E-02,-7.1200E-02,-7.0300E-02,-6.9400E-02,
     &  -6.8500E-02,-6.7600E-02,-6.6700E-02,-6.5800E-02,-6.4900E-02,
     &  -6.4000E-02,-6.3100E-02,-6.2200E-02,-6.1300E-02,-6.0400E-02,
     &  -5.9500E-02,-5.8600E-02,-5.7700E-02,-5.6800E-02,-5.5900E-02,
     &  -5.5000E-02,-5.4100E-02,-5.3200E-02,-5.2300E-02,-5.1400E-02,
     &  -5.0500E-02,-4.9600E-02,-4.8700E-02,-4.7800E-02,-4.6900E-02,
     &  -4.6000E-02,-4.5100E-02,-4.4200E-02,-4.3300E-02,-4.2400E-02,
     &  -4.1500E-02,-4.0600E-02,-3.9700E-02,-3.8800E-02,-3.7900E-02,
     &  -3.7000E-02,-3.6100E-02,-3.5200E-02,-3.4300E-02,-3.3400E-02,
     &  -3.2500E-02,-3.1600E-02,-3.0700E-02,-2.9800E-02,-2.8900E-02,
     &  -2.8000E-02,-2.7100E-02,-2.6200E-02,-2.5300E-02,-2.4400E-02,
     &  -2.3500E-02,-2.2600E-02,-2.1700E-02,-2.0800E-02,-1.9900E-02,
     &  -1.9000E-02,-1.8100E-02,-1.7200E-02,-1.6300E-02,-1.5400E-02,
     &  -1.4500E-02,-1.3600E-02,-1.2700E-02,-1.1800E-02,-1.0900E-02,
     &  -1.0000E-02,-9.9100E-03,-9.8200E-03,-9.7300E-03,-9.6400E-03,
     &  -9.5500E-03,-9.4600E-03,-9.3700E-03,-9.2800E-03,-9.1900E-03,
     &  -9.1000E-03,-9.0100E-03,-8.9200E-03,-8.8300E-03,-8.7400E-03,
     &  -8.6500E-03,-8.5600E-03,-8.4700E-03,-8.3800E-03,-8.2900E-03/
  
       DATA  (ETA  (I), I= 501, 600) /
     &  -8.2000E-03,-8.1100E-03,-8.0200E-03,-7.9300E-03,-7.8400E-03,
     &  -7.7500E-03,-7.6600E-03,-7.5700E-03,-7.4800E-03,-7.3900E-03,
     &  -7.3000E-03,-7.2100E-03,-7.1200E-03,-7.0300E-03,-6.9400E-03,
     &  -6.8500E-03,-6.7600E-03,-6.6700E-03,-6.5800E-03,-6.4900E-03,
     &  -6.4000E-03,-6.3100E-03,-6.2200E-03,-6.1300E-03,-6.0400E-03,
     &  -5.9500E-03,-5.8600E-03,-5.7700E-03,-5.6800E-03,-5.5900E-03,
     &  -5.5000E-03,-5.4100E-03,-5.3200E-03,-5.2300E-03,-5.1400E-03,
     &  -5.0500E-03,-4.9600E-03,-4.8700E-03,-4.7800E-03,-4.6900E-03,
     &  -4.6000E-03,-4.5100E-03,-4.4200E-03,-4.3300E-03,-4.2400E-03,
     &  -4.1500E-03,-4.0600E-03,-3.9700E-03,-3.8800E-03,-3.7900E-03,
     &  -3.7000E-03,-3.6100E-03,-3.5200E-03,-3.4300E-03,-3.3400E-03,
     &  -3.2500E-03,-3.1600E-03,-3.0700E-03,-2.9800E-03,-2.8900E-03,
     &  -2.8000E-03,-2.7100E-03,-2.6200E-03,-2.5300E-03,-2.4400E-03,
     &  -2.3500E-03,-2.2600E-03,-2.1700E-03,-2.0800E-03,-1.9900E-03,
     &  -1.9000E-03,-1.8100E-03,-1.7200E-03,-1.6300E-03,-1.5400E-03,
     &  -1.4500E-03,-1.3600E-03,-1.2700E-03,-1.1800E-03,-1.0900E-03,
     &  -1.0000E-03,-9.9100E-04,-9.8200E-04,-9.7300E-04,-9.6400E-04,
     &  -9.5500E-04,-9.4600E-04,-9.3700E-04,-9.2800E-04,-9.1900E-04,
     &  -9.1000E-04,-9.0100E-04,-8.9200E-04,-8.8300E-04,-8.7400E-04,
     &  -8.6500E-04,-8.5600E-04,-8.4700E-04,-8.3800E-04,-8.2900E-04/
  
       DATA  (ETA  (I), I= 601, 700) /
     &  -8.2000E-04,-8.1100E-04,-8.0200E-04,-7.9300E-04,-7.8400E-04,
     &  -7.7500E-04,-7.6600E-04,-7.5700E-04,-7.4800E-04,-7.3900E-04,
     &  -7.3000E-04,-7.2100E-04,-7.1200E-04,-7.0300E-04,-6.9400E-04,
     &  -6.8500E-04,-6.7600E-04,-6.6700E-04,-6.5800E-04,-6.4900E-04,
     &  -6.4000E-04,-6.3100E-04,-6.2200E-04,-6.1300E-04,-6.0400E-04,
     &  -5.9500E-04,-5.8600E-04,-5.7700E-04,-5.6800E-04,-5.5900E-04,
     &  -5.5000E-04,-5.4100E-04,-5.3200E-04,-5.2300E-04,-5.1400E-04,
     &  -5.0500E-04,-4.9600E-04,-4.8700E-04,-4.7800E-04,-4.6900E-04,
     &  -4.6000E-04,-4.5100E-04,-4.4200E-04,-4.3300E-04,-4.2400E-04,
     &  -4.1500E-04,-4.0600E-04,-3.9700E-04,-3.8800E-04,-3.7900E-04,
     &  -3.7000E-04,-3.6100E-04,-3.5200E-04,-3.4300E-04,-3.3400E-04,
     &  -3.2500E-04,-3.1600E-04,-3.0700E-04,-2.9800E-04,-2.8900E-04,
     &  -2.8000E-04,-2.7100E-04,-2.6200E-04,-2.5300E-04,-2.4400E-04,
     &  -2.3500E-04,-2.2600E-04,-2.1700E-04,-2.0800E-04,-1.9900E-04,
     &  -1.9000E-04,-1.8100E-04,-1.7200E-04,-1.6300E-04,-1.5400E-04,
     &  -1.4500E-04,-1.3600E-04,-1.2700E-04,-1.1800E-04,-1.0900E-04,
     &  -1.0000E-04,-9.9100E-05,-9.8200E-05,-9.7300E-05,-9.6400E-05,
     &  -9.5500E-05,-9.4600E-05,-9.3700E-05,-9.2800E-05,-9.1900E-05,
     &  -9.1000E-05,-9.0100E-05,-8.9200E-05,-8.8300E-05,-8.7400E-05,
     &  -8.6500E-05,-8.5600E-05,-8.4700E-05,-8.3800E-05,-8.2900E-05/
  
       DATA  (ETA  (I), I= 701, 800) /
     &  -8.2000E-05,-8.1100E-05,-8.0200E-05,-7.9300E-05,-7.8400E-05,
     &  -7.7500E-05,-7.6600E-05,-7.5700E-05,-7.4800E-05,-7.3900E-05,
     &  -7.3000E-05,-7.2100E-05,-7.1200E-05,-7.0300E-05,-6.9400E-05,
     &  -6.8500E-05,-6.7600E-05,-6.6700E-05,-6.5800E-05,-6.4900E-05,
     &  -6.4000E-05,-6.3100E-05,-6.2200E-05,-6.1300E-05,-6.0400E-05,
     &  -5.9500E-05,-5.8600E-05,-5.7700E-05,-5.6800E-05,-5.5900E-05,
     &  -5.5000E-05,-5.4100E-05,-5.3200E-05,-5.2300E-05,-5.1400E-05,
     &  -5.0500E-05,-4.9600E-05,-4.8700E-05,-4.7800E-05,-4.6900E-05,
     &  -4.6000E-05,-4.5100E-05,-4.4200E-05,-4.3300E-05,-4.2400E-05,
     &  -4.1500E-05,-4.0600E-05,-3.9700E-05,-3.8800E-05,-3.7900E-05,
     &  -3.7000E-05,-3.6100E-05,-3.5200E-05,-3.4300E-05,-3.3400E-05,
     &  -3.2500E-05,-3.1600E-05,-3.0700E-05,-2.9800E-05,-2.8900E-05,
     &  -2.8000E-05,-2.7100E-05,-2.6200E-05,-2.5300E-05,-2.4400E-05,
     &  -2.3500E-05,-2.2600E-05,-2.1700E-05,-2.0800E-05,-1.9900E-05,
     &  -1.9000E-05,-1.8100E-05,-1.7200E-05,-1.6300E-05,-1.5400E-05,
     &  -1.4500E-05,-1.3600E-05,-1.2700E-05,-1.1800E-05,-1.0900E-05,
     &  -1.0000E-05,-9.9100E-06,-9.8200E-06,-9.7300E-06,-9.6400E-06,
     &  -9.5500E-06,-9.4600E-06,-9.3700E-06,-9.2800E-06,-9.1900E-06,
     &  -9.1000E-06,-9.0100E-06,-8.9200E-06,-8.8300E-06,-8.7400E-06,
     &  -8.6500E-06,-8.5600E-06,-8.4700E-06,-8.3800E-06,-8.2900E-06/
  
       DATA  (ETA  (I), I= 801, 900) /
     &  -8.2000E-06,-8.1100E-06,-8.0200E-06,-7.9300E-06,-7.8400E-06,
     &  -7.7500E-06,-7.6600E-06,-7.5700E-06,-7.4800E-06,-7.3900E-06,
     &  -7.3000E-06,-7.2100E-06,-7.1200E-06,-7.0300E-06,-6.9400E-06,
     &  -6.8500E-06,-6.7600E-06,-6.6700E-06,-6.5800E-06,-6.4900E-06,
     &  -6.4000E-06,-6.3100E-06,-6.2200E-06,-6.1300E-06,-6.0400E-06,
     &  -5.9500E-06,-5.8600E-06,-5.7700E-06,-5.6800E-06,-5.5900E-06,
     &  -5.5000E-06,-5.4100E-06,-5.3200E-06,-5.2300E-06,-5.1400E-06,
     &  -5.0500E-06,-4.9600E-06,-4.8700E-06,-4.7800E-06,-4.6900E-06,
     &  -4.6000E-06,-4.5100E-06,-4.4200E-06,-4.3300E-06,-4.2400E-06,
     &  -4.1500E-06,-4.0600E-06,-3.9700E-06,-3.8800E-06,-3.7900E-06,
     &  -3.7000E-06,-3.6100E-06,-3.5200E-06,-3.4300E-06,-3.3400E-06,
     &  -3.2500E-06,-3.1600E-06,-3.0700E-06,-2.9800E-06,-2.8900E-06,
     &  -2.8000E-06,-2.7100E-06,-2.6200E-06,-2.5300E-06,-2.4400E-06,
     &  -2.3500E-06,-2.2600E-06,-2.1700E-06,-2.0800E-06,-1.9900E-06,
     &  -1.9000E-06,-1.8100E-06,-1.7200E-06,-1.6300E-06,-1.5400E-06,
     &  -1.4500E-06,-1.3600E-06,-1.2700E-06,-1.1800E-06,-1.0900E-06,
     &  -1.0000E-06, 0.0000E+00, 1.0000E-06, 3.0010E-03, 6.0010E-03,
     &   9.0010E-03, 1.2000E-02, 1.5000E-02, 1.8000E-02, 2.1000E-02,
     &   2.4000E-02, 2.7000E-02, 3.0000E-02, 3.3000E-02, 3.6000E-02,
     &   3.9000E-02, 4.2000E-02, 4.5000E-02, 4.8000E-02, 5.1000E-02/
  
       DATA  (ETA  (I), I= 901, 979) /
     &   5.4000E-02, 5.7000E-02, 6.0000E-02, 6.3000E-02, 6.6000E-02,
     &   6.9000E-02, 7.2000E-02, 7.5000E-02, 7.8000E-02, 8.1000E-02,
     &   8.4000E-02, 8.7000E-02, 9.0000E-02, 9.3000E-02, 9.6000E-02,
     &   9.9000E-02, 1.0200E-01, 1.0500E-01, 1.0800E-01, 1.1100E-01,
     &   1.1400E-01, 1.1700E-01, 1.2000E-01, 1.2300E-01, 1.2600E-01,
     &   1.2900E-01, 1.3200E-01, 1.3500E-01, 1.3800E-01, 1.4100E-01,
     &   1.4400E-01, 1.4700E-01, 1.5000E-01, 1.5300E-01, 1.5600E-01,
     &   1.5900E-01, 1.6200E-01, 1.6500E-01, 1.6800E-01, 1.7100E-01,
     &   1.7400E-01, 1.7700E-01, 1.8000E-01, 1.8300E-01, 1.8600E-01,
     &   1.8900E-01, 1.9200E-01, 1.9500E-01, 1.9800E-01, 2.0100E-01,
     &   2.0400E-01, 2.0700E-01, 2.1000E-01, 2.1300E-01, 2.1600E-01,
     &   2.1900E-01, 2.2200E-01, 2.2500E-01, 2.2800E-01, 2.3100E-01,
     &   2.3400E-01, 2.3700E-01, 2.4000E-01, 2.4300E-01, 2.4600E-01,
     &   2.4900E-01, 2.5200E-01, 2.5500E-01, 2.5800E-01, 2.6100E-01,
     &   2.6400E-01, 2.6700E-01, 2.7000E-01, 2.7100E-01, 2.7300E-01,
     &   0.27370000D0, 0.27599999D0, 0.27630001D0, 0.27700001D0/
  
         DATA ((DAT  (I,J), I=   1, 100), J=1,1) /
     &   4.1057E-02, 4.1005E-02, 4.0953E-02, 4.0901E-02, 4.0847E-02,
     &   4.0794E-02, 4.0739E-02, 4.0684E-02, 4.0628E-02, 4.0572E-02,
     &   4.0515E-02, 4.0457E-02, 4.0398E-02, 4.0339E-02, 4.0279E-02,
     &   4.0218E-02, 4.0156E-02, 4.0094E-02, 4.0030E-02, 3.9966E-02,
     &   3.9901E-02, 3.9835E-02, 3.9768E-02, 3.9700E-02, 3.9631E-02,
     &   3.9561E-02, 3.9490E-02, 3.9418E-02, 3.9345E-02, 3.9271E-02,
     &   3.9195E-02, 3.9118E-02, 3.9040E-02, 3.8961E-02, 3.8881E-02,
     &   3.8799E-02, 3.8715E-02, 3.8630E-02, 3.8544E-02, 3.8456E-02,
     &   3.8367E-02, 3.8275E-02, 3.8182E-02, 3.8088E-02, 3.7991E-02,
     &   3.7893E-02, 3.7792E-02, 3.7690E-02, 3.7585E-02, 3.7478E-02,
     &   3.7369E-02, 3.7257E-02, 3.7143E-02, 3.7026E-02, 3.6906E-02,
     &   3.6784E-02, 3.6658E-02, 3.6530E-02, 3.6398E-02, 3.6263E-02,
     &   3.6124E-02, 3.5981E-02, 3.5835E-02, 3.5684E-02, 3.5529E-02,
     &   3.5369E-02, 3.5204E-02, 3.5034E-02, 3.4859E-02, 3.4677E-02,
     &   3.4489E-02, 3.4295E-02, 3.4094E-02, 3.3885E-02, 3.3667E-02,
     &   3.3441E-02, 3.3205E-02, 3.2959E-02, 3.2701E-02, 3.2431E-02,
     &   3.2148E-02, 3.1850E-02, 3.1535E-02, 3.1201E-02, 3.0847E-02,
     &   3.0470E-02, 3.0066E-02, 2.9632E-02, 2.9162E-02, 2.8651E-02,
     &   2.8091E-02, 2.8032E-02, 2.7972E-02, 2.7912E-02, 2.7851E-02,
     &   2.7789E-02, 2.7727E-02, 2.7664E-02, 2.7600E-02, 2.7536E-02/
  
         DATA ((DAT  (I,J), I= 101, 200), J=1,1) /
     &   2.7471E-02, 2.7405E-02, 2.7339E-02, 2.7271E-02, 2.7203E-02,
     &   2.7134E-02, 2.7065E-02, 2.6994E-02, 2.6923E-02, 2.6850E-02,
     &   2.6777E-02, 2.6703E-02, 2.6628E-02, 2.6552E-02, 2.6475E-02,
     &   2.6397E-02, 2.6317E-02, 2.6237E-02, 2.6156E-02, 2.6073E-02,
     &   2.5990E-02, 2.5905E-02, 2.5819E-02, 2.5731E-02, 2.5643E-02,
     &   2.5552E-02, 2.5461E-02, 2.5368E-02, 2.5274E-02, 2.5178E-02,
     &   2.5080E-02, 2.4981E-02, 2.4880E-02, 2.4777E-02, 2.4673E-02,
     &   2.4566E-02, 2.4458E-02, 2.4347E-02, 2.4235E-02, 2.4120E-02,
     &   2.4003E-02, 2.3884E-02, 2.3762E-02, 2.3638E-02, 2.3511E-02,
     &   2.3381E-02, 2.3248E-02, 2.3112E-02, 2.2973E-02, 2.2831E-02,
     &   2.2685E-02, 2.2535E-02, 2.2382E-02, 2.2224E-02, 2.2063E-02,
     &   2.1896E-02, 2.1725E-02, 2.1549E-02, 2.1367E-02, 2.1180E-02,
     &   2.0986E-02, 2.0786E-02, 2.0579E-02, 2.0365E-02, 2.0143E-02,
     &   1.9912E-02, 1.9671E-02, 1.9421E-02, 1.9160E-02, 1.8887E-02,
     &   1.8601E-02, 1.8300E-02, 1.7984E-02, 1.7650E-02, 1.7297E-02,
     &   1.6922E-02, 1.6522E-02, 1.6094E-02, 1.5634E-02, 1.5136E-02,
     &   1.4593E-02, 1.4542E-02, 1.4490E-02, 1.4438E-02, 1.4386E-02,
     &   1.4333E-02, 1.4279E-02, 1.4225E-02, 1.4171E-02, 1.4116E-02,
     &   1.4060E-02, 1.4004E-02, 1.3948E-02, 1.3891E-02, 1.3833E-02,
     &   1.3775E-02, 1.3717E-02, 1.3658E-02, 1.3598E-02, 1.3538E-02/
  
         DATA ((DAT  (I,J), I= 201, 300), J=1,1) /
     &   1.3477E-02, 1.3415E-02, 1.3353E-02, 1.3290E-02, 1.3227E-02,
     &   1.3163E-02, 1.3098E-02, 1.3032E-02, 1.2966E-02, 1.2899E-02,
     &   1.2831E-02, 1.2763E-02, 1.2694E-02, 1.2624E-02, 1.2553E-02,
     &   1.2482E-02, 1.2409E-02, 1.2336E-02, 1.2262E-02, 1.2187E-02,
     &   1.2111E-02, 1.2034E-02, 1.1956E-02, 1.1877E-02, 1.1797E-02,
     &   1.1716E-02, 1.1634E-02, 1.1551E-02, 1.1467E-02, 1.1381E-02,
     &   1.1295E-02, 1.1207E-02, 1.1118E-02, 1.1028E-02, 1.0936E-02,
     &   1.0843E-02, 1.0748E-02, 1.0652E-02, 1.0555E-02, 1.0456E-02,
     &   1.0355E-02, 1.0253E-02, 1.0149E-02, 1.0044E-02, 9.9361E-03,
     &   9.8268E-03, 9.7155E-03, 9.6022E-03, 9.4869E-03, 9.3694E-03,
     &   9.2496E-03, 9.1276E-03, 9.0031E-03, 8.8761E-03, 8.7464E-03,
     &   8.6141E-03, 8.4789E-03, 8.3407E-03, 8.1994E-03, 8.0548E-03,
     &   7.9068E-03, 7.7551E-03, 7.5996E-03, 7.4401E-03, 7.2763E-03,
     &   7.1079E-03, 6.9346E-03, 6.7569E-03, 6.5728E-03, 6.3827E-03,
     &   6.1859E-03, 5.9821E-03, 5.7704E-03, 5.5502E-03, 5.3206E-03,
     &   5.0806E-03, 4.8290E-03, 4.5645E-03, 4.2858E-03, 3.9912E-03,
     &   3.6791E-03, 3.6469E-03, 3.6145E-03, 3.5819E-03, 3.5491E-03,
     &   3.5161E-03, 3.4829E-03, 3.4495E-03, 3.4159E-03, 3.3821E-03,
     &   3.3481E-03, 3.3139E-03, 3.2795E-03, 3.2449E-03, 3.2101E-03,
     &   3.1751E-03, 3.1398E-03, 3.1044E-03, 3.0688E-03, 3.0329E-03/
  
         DATA ((DAT  (I,J), I= 301, 400), J=1,1) /
     &   2.9969E-03, 2.9607E-03, 2.9242E-03, 2.8876E-03, 2.8507E-03,
     &   2.8136E-03, 2.7763E-03, 2.7388E-03, 2.7011E-03, 2.6633E-03,
     &   2.6252E-03, 2.5869E-03, 2.5484E-03, 2.5098E-03, 2.4709E-03,
     &   2.4319E-03, 2.3926E-03, 2.3532E-03, 2.3137E-03, 2.2739E-03,
     &   2.2340E-03, 2.1940E-03, 2.1537E-03, 2.1134E-03, 2.0729E-03,
     &   2.0322E-03, 1.9915E-03, 1.9506E-03, 1.9096E-03, 1.8685E-03,
     &   1.8273E-03, 1.7861E-03, 1.7447E-03, 1.7034E-03, 1.6619E-03,
     &   1.6205E-03, 1.5790E-03, 1.5375E-03, 1.4960E-03, 1.4546E-03,
     &   1.4132E-03, 1.3719E-03, 1.3306E-03, 1.2895E-03, 1.2484E-03,
     &   1.2076E-03, 1.1668E-03, 1.1263E-03, 1.0860E-03, 1.0459E-03,
     &   1.0060E-03, 9.6647E-04, 9.2723E-04, 8.8833E-04, 8.4981E-04,
     &   8.1168E-04, 7.7399E-04, 7.3676E-04, 7.0003E-04, 6.6383E-04,
     &   6.2819E-04, 5.9314E-04, 5.5874E-04, 5.2500E-04, 4.9197E-04,
     &   4.5968E-04, 4.2818E-04, 3.9749E-04, 3.6767E-04, 3.3874E-04,
     &   3.1077E-04, 2.8374E-04, 2.5773E-04, 2.3277E-04, 2.0889E-04,
     &   1.8614E-04, 1.6455E-04, 1.4415E-04, 1.2498E-04, 1.0708E-04,
     &   9.0462E-05, 8.8873E-05, 8.7297E-05, 8.5734E-05, 8.4185E-05,
     &   8.2649E-05, 8.1126E-05, 7.9617E-05, 7.8121E-05, 7.6639E-05,
     &   7.5170E-05, 7.3715E-05, 7.2273E-05, 7.0845E-05, 6.9430E-05,
     &   6.8029E-05, 6.6642E-05, 6.5268E-05, 6.3908E-05, 6.2562E-05/
  
         DATA ((DAT  (I,J), I= 401, 500), J=1,1) /
     &   6.1229E-05, 5.9910E-05, 5.8605E-05, 5.7314E-05, 5.6037E-05,
     &   5.4773E-05, 5.3523E-05, 5.2288E-05, 5.1066E-05, 4.9858E-05,
     &   4.8664E-05, 4.7484E-05, 4.6318E-05, 4.5166E-05, 4.4029E-05,
     &   4.2905E-05, 4.1795E-05, 4.0700E-05, 3.9619E-05, 3.8552E-05,
     &   3.7499E-05, 3.6460E-05, 3.5436E-05, 3.4425E-05, 3.3430E-05,
     &   3.2448E-05, 3.1481E-05, 3.0528E-05, 2.9589E-05, 2.8665E-05,
     &   2.7755E-05, 2.6859E-05, 2.5978E-05, 2.5112E-05, 2.4260E-05,
     &   2.3422E-05, 2.2599E-05, 2.1790E-05, 2.0996E-05, 2.0216E-05,
     &   1.9451E-05, 1.8701E-05, 1.7965E-05, 1.7243E-05, 1.6537E-05,
     &   1.5845E-05, 1.5167E-05, 1.4504E-05, 1.3856E-05, 1.3223E-05,
     &   1.2604E-05, 1.2000E-05, 1.1410E-05, 1.0836E-05, 1.0276E-05,
     &   9.7308E-06, 9.2005E-06, 8.6849E-06, 8.1840E-06, 7.6980E-06,
     &   7.2268E-06, 6.7704E-06, 6.3288E-06, 5.9020E-06, 5.4901E-06,
     &   5.0930E-06, 4.7108E-06, 4.3434E-06, 3.9909E-06, 3.6533E-06,
     &   3.3306E-06, 3.0227E-06, 2.7298E-06, 2.4517E-06, 2.1886E-06,
     &   1.9404E-06, 1.7071E-06, 1.4887E-06, 1.2852E-06, 1.0967E-06,
     &   9.2310E-07, 9.0656E-07, 8.9017E-07, 8.7393E-07, 8.5784E-07,
     &   8.4190E-07, 8.2611E-07, 8.1047E-07, 7.9498E-07, 7.7964E-07,
     &   7.6445E-07, 7.4940E-07, 7.3451E-07, 7.1976E-07, 7.0517E-07,
     &   6.9072E-07, 6.7643E-07, 6.6228E-07, 6.4828E-07, 6.3443E-07/
  
         DATA ((DAT  (I,J), I= 501, 600), J=1,1) /
     &   6.2073E-07, 6.0718E-07, 5.9379E-07, 5.8053E-07, 5.6743E-07,
     &   5.5448E-07, 5.4168E-07, 5.2903E-07, 5.1653E-07, 5.0417E-07,
     &   4.9197E-07, 4.7991E-07, 4.6801E-07, 4.5625E-07, 4.4465E-07,
     &   4.3319E-07, 4.2188E-07, 4.1072E-07, 3.9972E-07, 3.8886E-07,
     &   3.7815E-07, 3.6759E-07, 3.5718E-07, 3.4692E-07, 3.3681E-07,
     &   3.2684E-07, 3.1703E-07, 3.0737E-07, 2.9786E-07, 2.8849E-07,
     &   2.7928E-07, 2.7021E-07, 2.6130E-07, 2.5253E-07, 2.4392E-07,
     &   2.3545E-07, 2.2713E-07, 2.1897E-07, 2.1095E-07, 2.0308E-07,
     &   1.9536E-07, 1.8779E-07, 1.8037E-07, 1.7310E-07, 1.6598E-07,
     &   1.5901E-07, 1.5219E-07, 1.4551E-07, 1.3899E-07, 1.3262E-07,
     &   1.2640E-07, 1.2032E-07, 1.1440E-07, 1.0862E-07, 1.0300E-07,
     &   9.7521E-08, 9.2194E-08, 8.7018E-08, 8.1990E-08, 7.7113E-08,
     &   7.2385E-08, 6.7806E-08, 6.3378E-08, 5.9098E-08, 5.4968E-08,
     &   5.0988E-08, 4.7158E-08, 4.3476E-08, 3.9945E-08, 3.6563E-08,
     &   3.3331E-08, 3.0248E-08, 2.7314E-08, 2.4531E-08, 2.1897E-08,
     &   1.9412E-08, 1.7077E-08, 1.4892E-08, 1.2856E-08, 1.0970E-08,
     &   9.2329E-09, 9.0675E-09, 8.9035E-09, 8.7411E-09, 8.5801E-09,
     &   8.4206E-09, 8.2627E-09, 8.1062E-09, 7.9512E-09, 7.7977E-09,
     &   7.6458E-09, 7.4953E-09, 7.3463E-09, 7.1988E-09, 7.0528E-09,
     &   6.9083E-09, 6.7653E-09, 6.6238E-09, 6.4838E-09, 6.3452E-09/
  
         DATA ((DAT  (I,J), I= 601, 700), J=1,1) /
     &   6.2082E-09, 6.0727E-09, 5.9386E-09, 5.8061E-09, 5.6751E-09,
     &   5.5455E-09, 5.4175E-09, 5.2909E-09, 5.1658E-09, 5.0423E-09,
     &   4.9202E-09, 4.7996E-09, 4.6806E-09, 4.5630E-09, 4.4469E-09,
     &   4.3323E-09, 4.2192E-09, 4.1076E-09, 3.9975E-09, 3.8889E-09,
     &   3.7818E-09, 3.6762E-09, 3.5721E-09, 3.4694E-09, 3.3683E-09,
     &   3.2687E-09, 3.1705E-09, 3.0739E-09, 2.9788E-09, 2.8851E-09,
     &   2.7930E-09, 2.7023E-09, 2.6131E-09, 2.5255E-09, 2.4393E-09,
     &   2.3546E-09, 2.2714E-09, 2.1898E-09, 2.1096E-09, 2.0309E-09,
     &   1.9537E-09, 1.8780E-09, 1.8038E-09, 1.7311E-09, 1.6599E-09,
     &   1.5901E-09, 1.5219E-09, 1.4552E-09, 1.3900E-09, 1.3262E-09,
     &   1.2640E-09, 1.2032E-09, 1.1440E-09, 1.0862E-09, 1.0300E-09,
     &   9.7523E-10, 9.2196E-10, 8.7019E-10, 8.1992E-10, 7.7114E-10,
     &   7.2386E-10, 6.7807E-10, 6.3378E-10, 5.9099E-10, 5.4969E-10,
     &   5.0989E-10, 4.7158E-10, 4.3477E-10, 3.9945E-10, 3.6563E-10,
     &   3.3331E-10, 3.0248E-10, 2.7315E-10, 2.4531E-10, 2.1897E-10,
     &   1.9412E-10, 1.7077E-10, 1.4892E-10, 1.2856E-10, 1.0970E-10,
     &   9.2329E-11, 9.0675E-11, 8.9035E-11, 8.7411E-11, 8.5801E-11,
     &   8.4207E-11, 8.2627E-11, 8.1062E-11, 7.9512E-11, 7.7978E-11,
     &   7.6458E-11, 7.4953E-11, 7.3463E-11, 7.1988E-11, 7.0528E-11,
     &   6.9083E-11, 6.7653E-11, 6.6238E-11, 6.4838E-11, 6.3452E-11/
  
         DATA ((DAT  (I,J), I= 701, 800), J=1,1) /
     &   6.2082E-11, 6.0727E-11, 5.9386E-11, 5.8061E-11, 5.6751E-11,
     &   5.5455E-11, 5.4175E-11, 5.2909E-11, 5.1659E-11, 5.0423E-11,
     &   4.9202E-11, 4.7996E-11, 4.6806E-11, 4.5630E-11, 4.4469E-11,
     &   4.3323E-11, 4.2192E-11, 4.1076E-11, 3.9975E-11, 3.8889E-11,
     &   3.7818E-11, 3.6762E-11, 3.5721E-11, 3.4694E-11, 3.3683E-11,
     &   3.2687E-11, 3.1705E-11, 3.0739E-11, 2.9788E-11, 2.8851E-11,
     &   2.7930E-11, 2.7023E-11, 2.6131E-11, 2.5255E-11, 2.4393E-11,
     &   2.3546E-11, 2.2714E-11, 2.1898E-11, 2.1096E-11, 2.0309E-11,
     &   1.9537E-11, 1.8780E-11, 1.8038E-11, 1.7311E-11, 1.6599E-11,
     &   1.5901E-11, 1.5219E-11, 1.4552E-11, 1.3900E-11, 1.3262E-11,
     &   1.2640E-11, 1.2032E-11, 1.1440E-11, 1.0862E-11, 1.0300E-11,
     &   9.7523E-12, 9.2196E-12, 8.7019E-12, 8.1992E-12, 7.7114E-12,
     &   7.2386E-12, 6.7807E-12, 6.3378E-12, 5.9099E-12, 5.4969E-12,
     &   5.0989E-12, 4.7158E-12, 4.3477E-12, 3.9945E-12, 3.6563E-12,
     &   3.3331E-12, 3.0248E-12, 2.7315E-12, 2.4531E-12, 2.1897E-12,
     &   1.9412E-12, 1.7077E-12, 1.4892E-12, 1.2856E-12, 1.0970E-12,
     &   9.2329E-13, 9.0675E-13, 8.9035E-13, 8.7411E-13, 8.5801E-13,
     &   8.4207E-13, 8.2627E-13, 8.1062E-13, 7.9512E-13, 7.7978E-13,
     &   7.6458E-13, 7.4953E-13, 7.3463E-13, 7.1988E-13, 7.0528E-13,
     &   6.9083E-13, 6.7653E-13, 6.6238E-13, 6.4838E-13, 6.3452E-13/
  
         DATA ((DAT  (I,J), I= 801, 900), J=1,1) /
     &   6.2082E-13, 6.0727E-13, 5.9386E-13, 5.8061E-13, 5.6751E-13,
     &   5.5455E-13, 5.4175E-13, 5.2909E-13, 5.1659E-13, 5.0423E-13,
     &   4.9202E-13, 4.7996E-13, 4.6806E-13, 4.5630E-13, 4.4469E-13,
     &   4.3323E-13, 4.2192E-13, 4.1076E-13, 3.9975E-13, 3.8889E-13,
     &   3.7818E-13, 3.6762E-13, 3.5721E-13, 3.4694E-13, 3.3683E-13,
     &   3.2687E-13, 3.1705E-13, 3.0739E-13, 2.9788E-13, 2.8851E-13,
     &   2.7930E-13, 2.7023E-13, 2.6131E-13, 2.5255E-13, 2.4393E-13,
     &   2.3546E-13, 2.2714E-13, 2.1898E-13, 2.1096E-13, 2.0309E-13,
     &   1.9537E-13, 1.8780E-13, 1.8038E-13, 1.7311E-13, 1.6599E-13,
     &   1.5901E-13, 1.5219E-13, 1.4552E-13, 1.3900E-13, 1.3262E-13,
     &   1.2640E-13, 1.2032E-13, 1.1440E-13, 1.0862E-13, 1.0300E-13,
     &   9.7523E-14, 9.2196E-14, 8.7019E-14, 8.1992E-14, 7.7114E-14,
     &   7.2386E-14, 6.7807E-14, 6.3378E-14, 5.9099E-14, 5.4969E-14,
     &   5.0989E-14, 4.7158E-14, 4.3477E-14, 3.9945E-14, 3.6563E-14,
     &   3.3331E-14, 3.0248E-14, 2.7315E-14, 2.4531E-14, 2.1897E-14,
     &   1.9412E-14, 1.7077E-14, 1.4892E-14, 1.2856E-14, 1.0970E-14,
     &   9.2329E-15, 0.0000E+00,-9.2329E-15,-8.3153E-08,-3.3252E-07,
     &  -7.4816E-07,-1.3299E-06,-2.0784E-06,-2.9935E-06,-4.0755E-06,
     &  -5.3246E-06,-6.7411E-06,-8.3253E-06,-1.0078E-05,-1.1998E-05,
     &  -1.4088E-05,-1.6347E-05,-1.8776E-05,-2.1376E-05,-2.4146E-05/
  
         DATA ((DAT  (I,J), I= 901, 979), J=1,1) /
     &  -2.7089E-05,-3.0204E-05,-3.3492E-05,-3.6953E-05,-4.0590E-05,
     &  -4.4402E-05,-4.8391E-05,-5.2557E-05,-5.6902E-05,-6.1426E-05,
     &  -6.6131E-05,-7.1018E-05,-7.6088E-05,-8.1342E-05,-8.6782E-05,
     &  -9.2409E-05,-9.8224E-05,-1.0423E-04,-1.1044E-04,-1.1683E-04,
     &  -1.2341E-04,-1.3020E-04,-1.3718E-04,-1.4436E-04,-1.5174E-04,
     &  -1.5933E-04,-1.6713E-04,-1.7513E-04,-1.8335E-04,-1.9177E-04,
     &  -2.0042E-04,-2.0928E-04,-2.1837E-04,-2.2768E-04,-2.3722E-04,
     &  -2.4699E-04,-2.5699E-04,-2.6723E-04,-2.7771E-04,-2.8843E-04,
     &  -2.9940E-04,-3.1063E-04,-3.2211E-04,-3.3385E-04,-3.4586E-04,
     &  -3.5814E-04,-3.7069E-04,-3.8353E-04,-3.9665E-04,-4.0996E-04,
     &  -4.2367E-04,-4.3768E-04,-4.5201E-04,-4.6662E-04,-4.8159E-04,
     &  -4.9690E-04,-5.1255E-04,-5.2857E-04,-5.4494E-04,-5.6170E-04,
     &  -5.7885E-04,-5.9640E-04,-6.1450E-04,-6.3291E-04,-6.5179E-04,
     &  -6.7114E-04,-6.9099E-04,-7.1138E-04,-7.3233E-04,-7.5389E-04,
     &  -7.7610E-04,-7.9903E-04,-8.2184E-04,-8.2993E-04,-8.4670E-04,
     &  -8.52603215E-04,-8.73193004E-04,-8.75854969E-04,-8.82135543E-04/
  
         DATA ((DAT  (I,J), I=   1, 100), J=2,2) /
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05,
     &   5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05,
     &   5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05,
     &   5.3023E-05, 5.3023E-05, 5.3023E-05, 5.3023E-05, 5.3023E-05,
     &   5.3023E-05, 5.3023E-05, 5.3023E-05, 5.3022E-05, 5.3022E-05,
     &   5.3022E-05, 5.3022E-05, 5.3022E-05, 5.3021E-05, 5.3021E-05,
     &   5.3021E-05, 5.3020E-05, 5.3020E-05, 5.3020E-05, 5.3019E-05,
     &   5.3019E-05, 5.3018E-05, 5.3018E-05, 5.3017E-05, 5.3016E-05,
     &   5.3015E-05, 5.3015E-05, 5.3013E-05, 5.3012E-05, 5.3011E-05,
     &   5.3009E-05, 5.3008E-05, 5.3006E-05, 5.3003E-05, 5.3000E-05,
     &   5.2996E-05, 5.2992E-05, 5.2987E-05, 5.2980E-05, 5.2971E-05,
     &   5.2959E-05, 5.2958E-05, 5.2957E-05, 5.2955E-05, 5.2954E-05,
     &   5.2952E-05, 5.2951E-05, 5.2949E-05, 5.2947E-05, 5.2946E-05/
  
         DATA ((DAT  (I,J), I= 101, 200), J=2,2) /
     &   5.2944E-05, 5.2942E-05, 5.2940E-05, 5.2938E-05, 5.2936E-05,
     &   5.2934E-05, 5.2932E-05, 5.2929E-05, 5.2927E-05, 5.2925E-05,
     &   5.2922E-05, 5.2919E-05, 5.2917E-05, 5.2914E-05, 5.2911E-05,
     &   5.2908E-05, 5.2905E-05, 5.2901E-05, 5.2898E-05, 5.2894E-05,
     &   5.2890E-05, 5.2886E-05, 5.2882E-05, 5.2878E-05, 5.2873E-05,
     &   5.2869E-05, 5.2864E-05, 5.2859E-05, 5.2853E-05, 5.2848E-05,
     &   5.2842E-05, 5.2835E-05, 5.2829E-05, 5.2822E-05, 5.2815E-05,
     &   5.2807E-05, 5.2799E-05, 5.2790E-05, 5.2781E-05, 5.2772E-05,
     &   5.2761E-05, 5.2751E-05, 5.2739E-05, 5.2727E-05, 5.2714E-05,
     &   5.2700E-05, 5.2685E-05, 5.2669E-05, 5.2652E-05, 5.2634E-05,
     &   5.2615E-05, 5.2594E-05, 5.2571E-05, 5.2547E-05, 5.2520E-05,
     &   5.2491E-05, 5.2460E-05, 5.2426E-05, 5.2389E-05, 5.2348E-05,
     &   5.2303E-05, 5.2254E-05, 5.2200E-05, 5.2139E-05, 5.2072E-05,
     &   5.1997E-05, 5.1913E-05, 5.1818E-05, 5.1710E-05, 5.1588E-05,
     &   5.1448E-05, 5.1287E-05, 5.1101E-05, 5.0883E-05, 5.0627E-05,
     &   5.0322E-05, 4.9957E-05, 4.9515E-05, 4.8971E-05, 4.8295E-05,
     &   4.7439E-05, 4.7351E-05, 4.7262E-05, 4.7170E-05, 4.7075E-05,
     &   4.6979E-05, 4.6881E-05, 4.6780E-05, 4.6676E-05, 4.6570E-05,
     &   4.6462E-05, 4.6351E-05, 4.6237E-05, 4.6120E-05, 4.6001E-05,
     &   4.5878E-05, 4.5753E-05, 4.5624E-05, 4.5492E-05, 4.5356E-05/
  
         DATA ((DAT  (I,J), I= 201, 300), J=2,2) /
     &   4.5217E-05, 4.5074E-05, 4.4928E-05, 4.4777E-05, 4.4623E-05,
     &   4.4464E-05, 4.4301E-05, 4.4134E-05, 4.3962E-05, 4.3785E-05,
     &   4.3603E-05, 4.3417E-05, 4.3225E-05, 4.3027E-05, 4.2824E-05,
     &   4.2615E-05, 4.2400E-05, 4.2179E-05, 4.1951E-05, 4.1717E-05,
     &   4.1476E-05, 4.1227E-05, 4.0971E-05, 4.0707E-05, 4.0436E-05,
     &   4.0156E-05, 3.9867E-05, 3.9570E-05, 3.9263E-05, 3.8947E-05,
     &   3.8621E-05, 3.8285E-05, 3.7939E-05, 3.7581E-05, 3.7213E-05,
     &   3.6832E-05, 3.6440E-05, 3.6035E-05, 3.5618E-05, 3.5187E-05,
     &   3.4742E-05, 3.4283E-05, 3.3810E-05, 3.3322E-05, 3.2819E-05,
     &   3.2300E-05, 3.1764E-05, 3.1213E-05, 3.0644E-05, 3.0058E-05,
     &   2.9454E-05, 2.8833E-05, 2.8193E-05, 2.7535E-05, 2.6858E-05,
     &   2.6163E-05, 2.5449E-05, 2.4717E-05, 2.3966E-05, 2.3198E-05,
     &   2.2411E-05, 2.1608E-05, 2.0788E-05, 1.9952E-05, 1.9103E-05,
     &   1.8240E-05, 1.7365E-05, 1.6481E-05, 1.5589E-05, 1.4691E-05,
     &   1.3790E-05, 1.2890E-05, 1.1992E-05, 1.1100E-05, 1.0219E-05,
     &   9.3504E-06, 8.4995E-06, 7.6698E-06, 6.8650E-06, 6.0884E-06,
     &   5.3431E-06, 5.2704E-06, 5.1980E-06, 5.1259E-06, 5.0542E-06,
     &   4.9829E-06, 4.9119E-06, 4.8412E-06, 4.7709E-06, 4.7010E-06,
     &   4.6314E-06, 4.5621E-06, 4.4932E-06, 4.4247E-06, 4.3565E-06,
     &   4.2887E-06, 4.2212E-06, 4.1541E-06, 4.0873E-06, 4.0210E-06/
  
         DATA ((DAT  (I,J), I= 301, 400), J=2,2) /
     &   3.9549E-06, 3.8893E-06, 3.8240E-06, 3.7590E-06, 3.6944E-06,
     &   3.6302E-06, 3.5664E-06, 3.5029E-06, 3.4398E-06, 3.3770E-06,
     &   3.3146E-06, 3.2526E-06, 3.1909E-06, 3.1296E-06, 3.0687E-06,
     &   3.0081E-06, 2.9479E-06, 2.8880E-06, 2.8285E-06, 2.7694E-06,
     &   2.7107E-06, 2.6523E-06, 2.5943E-06, 2.5366E-06, 2.4793E-06,
     &   2.4224E-06, 2.3659E-06, 2.3097E-06, 2.2539E-06, 2.1985E-06,
     &   2.1434E-06, 2.0887E-06, 2.0344E-06, 1.9805E-06, 1.9270E-06,
     &   1.8739E-06, 1.8212E-06, 1.7689E-06, 1.7170E-06, 1.6655E-06,
     &   1.6144E-06, 1.5637E-06, 1.5135E-06, 1.4638E-06, 1.4145E-06,
     &   1.3656E-06, 1.3172E-06, 1.2693E-06, 1.2220E-06, 1.1751E-06,
     &   1.1287E-06, 1.0829E-06, 1.0377E-06, 9.9301E-07, 9.4894E-07,
     &   9.0548E-07, 8.6266E-07, 8.2050E-07, 7.7902E-07, 7.3824E-07,
     &   6.9820E-07, 6.5892E-07, 6.2043E-07, 5.8276E-07, 5.4593E-07,
     &   5.0999E-07, 4.7495E-07, 4.4087E-07, 4.0776E-07, 3.7567E-07,
     &   3.4464E-07, 3.1470E-07, 2.8588E-07, 2.5823E-07, 2.3179E-07,
     &   2.0658E-07, 1.8266E-07, 1.6006E-07, 1.3881E-07, 1.1895E-07,
     &   1.0052E-07, 9.8757E-08, 9.7009E-08, 9.5275E-08, 9.3555E-08,
     &   9.1851E-08, 9.0161E-08, 8.8486E-08, 8.6826E-08, 8.5181E-08,
     &   8.3550E-08, 8.1935E-08, 8.0334E-08, 7.8748E-08, 7.7178E-08,
     &   7.5622E-08, 7.4082E-08, 7.2557E-08, 7.1046E-08, 6.9551E-08/
  
         DATA ((DAT  (I,J), I= 401, 500), J=2,2) /
     &   6.8071E-08, 6.6607E-08, 6.5157E-08, 6.3723E-08, 6.2305E-08,
     &   6.0901E-08, 5.9513E-08, 5.8140E-08, 5.6783E-08, 5.5441E-08,
     &   5.4115E-08, 5.2804E-08, 5.1509E-08, 5.0229E-08, 4.8965E-08,
     &   4.7716E-08, 4.6483E-08, 4.5266E-08, 4.4064E-08, 4.2878E-08,
     &   4.1708E-08, 4.0554E-08, 3.9415E-08, 3.8292E-08, 3.7185E-08,
     &   3.6094E-08, 3.5019E-08, 3.3959E-08, 3.2916E-08, 3.1888E-08,
     &   3.0876E-08, 2.9881E-08, 2.8901E-08, 2.7938E-08, 2.6990E-08,
     &   2.6058E-08, 2.5143E-08, 2.4244E-08, 2.3361E-08, 2.2493E-08,
     &   2.1643E-08, 2.0808E-08, 1.9989E-08, 1.9187E-08, 1.8401E-08,
     &   1.7631E-08, 1.6877E-08, 1.6140E-08, 1.5419E-08, 1.4714E-08,
     &   1.4026E-08, 1.3354E-08, 1.2698E-08, 1.2059E-08, 1.1436E-08,
     &   1.0829E-08, 1.0239E-08, 9.6656E-09, 9.1083E-09, 8.5675E-09,
     &   8.0431E-09, 7.5352E-09, 7.0438E-09, 6.5689E-09, 6.1105E-09,
     &   5.6686E-09, 5.2432E-09, 4.8344E-09, 4.4421E-09, 4.0663E-09,
     &   3.7071E-09, 3.3645E-09, 3.0384E-09, 2.7290E-09, 2.4361E-09,
     &   2.1598E-09, 1.9001E-09, 1.6570E-09, 1.4306E-09, 1.2207E-09,
     &   1.0275E-09, 1.0091E-09, 9.9087E-10, 9.7279E-10, 9.5488E-10,
     &   9.3714E-10, 9.1956E-10, 9.0215E-10, 8.8491E-10, 8.6783E-10,
     &   8.5092E-10, 8.3417E-10, 8.1760E-10, 8.0118E-10, 7.8494E-10,
     &   7.6886E-10, 7.5294E-10, 7.3720E-10, 7.2162E-10, 7.0620E-10/
  
         DATA ((DAT  (I,J), I= 501, 600), J=2,2) /
     &   6.9095E-10, 6.7587E-10, 6.6096E-10, 6.4621E-10, 6.3162E-10,
     &   6.1721E-10, 6.0296E-10, 5.8887E-10, 5.7496E-10, 5.6121E-10,
     &   5.4762E-10, 5.3420E-10, 5.2095E-10, 5.0787E-10, 4.9495E-10,
     &   4.8219E-10, 4.6961E-10, 4.5719E-10, 4.4494E-10, 4.3285E-10,
     &   4.2093E-10, 4.0917E-10, 3.9759E-10, 3.8616E-10, 3.7491E-10,
     &   3.6382E-10, 3.5290E-10, 3.4214E-10, 3.3155E-10, 3.2113E-10,
     &   3.1087E-10, 3.0078E-10, 2.9086E-10, 2.8110E-10, 2.7151E-10,
     &   2.6209E-10, 2.5283E-10, 2.4374E-10, 2.3481E-10, 2.2605E-10,
     &   2.1746E-10, 2.0904E-10, 2.0078E-10, 1.9268E-10, 1.8476E-10,
     &   1.7700E-10, 1.6940E-10, 1.6198E-10, 1.5472E-10, 1.4762E-10,
     &   1.4069E-10, 1.3393E-10, 1.2734E-10, 1.2091E-10, 1.1465E-10,
     &   1.0855E-10, 1.0262E-10, 9.6862E-11, 9.1267E-11, 8.5837E-11,
     &   8.0574E-11, 7.5478E-11, 7.0548E-11, 6.5784E-11, 6.1187E-11,
     &   5.6757E-11, 5.2493E-11, 4.8395E-11, 4.4464E-11, 4.0700E-11,
     &   3.7102E-11, 3.3670E-11, 3.0405E-11, 2.7306E-11, 2.4374E-11,
     &   2.1608E-11, 1.9009E-11, 1.6577E-11, 1.4310E-11, 1.2211E-11,
     &   1.0277E-11, 1.0093E-11, 9.9108E-12, 9.7300E-12, 9.5508E-12,
     &   9.3733E-12, 9.1975E-12, 9.0233E-12, 8.8508E-12, 8.6800E-12,
     &   8.5108E-12, 8.3433E-12, 8.1774E-12, 8.0133E-12, 7.8507E-12,
     &   7.6899E-12, 7.5307E-12, 7.3732E-12, 7.2173E-12, 7.0631E-12/
  
         DATA ((DAT  (I,J), I= 601, 700), J=2,2) /
     &   6.9106E-12, 6.7597E-12, 6.6105E-12, 6.4630E-12, 6.3171E-12,
     &   6.1729E-12, 6.0304E-12, 5.8895E-12, 5.7503E-12, 5.6128E-12,
     &   5.4769E-12, 5.3427E-12, 5.2101E-12, 5.0792E-12, 4.9500E-12,
     &   4.8225E-12, 4.6966E-12, 4.5724E-12, 4.4498E-12, 4.3289E-12,
     &   4.2097E-12, 4.0921E-12, 3.9762E-12, 3.8620E-12, 3.7494E-12,
     &   3.6385E-12, 3.5293E-12, 3.4217E-12, 3.3158E-12, 3.2115E-12,
     &   3.1089E-12, 3.0080E-12, 2.9088E-12, 2.8112E-12, 2.7153E-12,
     &   2.6210E-12, 2.5284E-12, 2.4375E-12, 2.3482E-12, 2.2607E-12,
     &   2.1747E-12, 2.0905E-12, 2.0079E-12, 1.9269E-12, 1.8477E-12,
     &   1.7700E-12, 1.6941E-12, 1.6198E-12, 1.5472E-12, 1.4763E-12,
     &   1.4070E-12, 1.3394E-12, 1.2734E-12, 1.2091E-12, 1.1465E-12,
     &   1.0856E-12, 1.0263E-12, 9.6865E-13, 9.1268E-13, 8.5839E-13,
     &   8.0576E-13, 7.5479E-13, 7.0549E-13, 6.5785E-13, 6.1188E-13,
     &   5.6758E-13, 5.2493E-13, 4.8396E-13, 4.4465E-13, 4.0700E-13,
     &   3.7102E-13, 3.3670E-13, 3.0405E-13, 2.7306E-13, 2.4374E-13,
     &   2.1608E-13, 1.9009E-13, 1.6577E-13, 1.4310E-13, 1.2211E-13,
     &   1.0278E-13, 1.0093E-13, 9.9109E-14, 9.7300E-14, 9.5509E-14,
     &   9.3734E-14, 9.1975E-14, 9.0233E-14, 8.8508E-14, 8.6800E-14,
     &   8.5108E-14, 8.3433E-14, 8.1775E-14, 8.0133E-14, 7.8507E-14,
     &   7.6899E-14, 7.5307E-14, 7.3732E-14, 7.2173E-14, 7.0631E-14/
  
         DATA ((DAT  (I,J), I= 701, 800), J=2,2) /
     &   6.9106E-14, 6.7597E-14, 6.6105E-14, 6.4630E-14, 6.3171E-14,
     &   6.1729E-14, 6.0304E-14, 5.8895E-14, 5.7503E-14, 5.6128E-14,
     &   5.4769E-14, 5.3427E-14, 5.2101E-14, 5.0792E-14, 4.9500E-14,
     &   4.8225E-14, 4.6966E-14, 4.5724E-14, 4.4498E-14, 4.3289E-14,
     &   4.2097E-14, 4.0921E-14, 3.9762E-14, 3.8620E-14, 3.7494E-14,
     &   3.6385E-14, 3.5293E-14, 3.4217E-14, 3.3158E-14, 3.2115E-14,
     &   3.1089E-14, 3.0080E-14, 2.9088E-14, 2.8112E-14, 2.7153E-14,
     &   2.6210E-14, 2.5284E-14, 2.4375E-14, 2.3482E-14, 2.2607E-14,
     &   2.1747E-14, 2.0905E-14, 2.0079E-14, 1.9269E-14, 1.8477E-14,
     &   1.7700E-14, 1.6941E-14, 1.6198E-14, 1.5472E-14, 1.4763E-14,
     &   1.4070E-14, 1.3394E-14, 1.2734E-14, 1.2091E-14, 1.1465E-14,
     &   1.0856E-14, 1.0263E-14, 9.6865E-15, 9.1268E-15, 8.5839E-15,
     &   8.0576E-15, 7.5479E-15, 7.0549E-15, 6.5785E-15, 6.1188E-15,
     &   5.6758E-15, 5.2493E-15, 4.8396E-15, 4.4465E-15, 4.0700E-15,
     &   3.7102E-15, 3.3670E-15, 3.0405E-15, 2.7306E-15, 2.4374E-15,
     &   2.1608E-15, 1.9009E-15, 1.6577E-15, 1.4310E-15, 1.2211E-15,
     &   1.0278E-15, 1.0093E-15, 9.9109E-16, 9.7300E-16, 9.5509E-16,
     &   9.3734E-16, 9.1975E-16, 9.0233E-16, 8.8508E-16, 8.6800E-16,
     &   8.5108E-16, 8.3433E-16, 8.1775E-16, 8.0133E-16, 7.8507E-16,
     &   7.6899E-16, 7.5307E-16, 7.3732E-16, 7.2173E-16, 7.0631E-16/
  
         DATA ((DAT  (I,J), I= 801, 900), J=2,2) /
     &   6.9106E-16, 6.7597E-16, 6.6105E-16, 6.4630E-16, 6.3171E-16,
     &   6.1729E-16, 6.0304E-16, 5.8895E-16, 5.7503E-16, 5.6128E-16,
     &   5.4769E-16, 5.3427E-16, 5.2101E-16, 5.0792E-16, 4.9500E-16,
     &   4.8225E-16, 4.6966E-16, 4.5724E-16, 4.4498E-16, 4.3289E-16,
     &   4.2097E-16, 4.0921E-16, 3.9762E-16, 3.8620E-16, 3.7494E-16,
     &   3.6385E-16, 3.5293E-16, 3.4217E-16, 3.3158E-16, 3.2115E-16,
     &   3.1089E-16, 3.0080E-16, 2.9088E-16, 2.8112E-16, 2.7153E-16,
     &   2.6210E-16, 2.5284E-16, 2.4375E-16, 2.3482E-16, 2.2607E-16,
     &   2.1747E-16, 2.0905E-16, 2.0079E-16, 1.9269E-16, 1.8477E-16,
     &   1.7700E-16, 1.6941E-16, 1.6198E-16, 1.5472E-16, 1.4763E-16,
     &   1.4070E-16, 1.3394E-16, 1.2734E-16, 1.2091E-16, 1.1465E-16,
     &   1.0856E-16, 1.0263E-16, 9.6865E-17, 9.1268E-17, 8.5839E-17,
     &   8.0576E-17, 7.5479E-17, 7.0549E-17, 6.5785E-17, 6.1188E-17,
     &   5.6758E-17, 5.2493E-17, 4.8396E-17, 4.4465E-17, 4.0700E-17,
     &   3.7102E-17, 3.3670E-17, 3.0405E-17, 2.7306E-17, 2.4374E-17,
     &   2.1608E-17, 1.9009E-17, 1.6577E-17, 1.4310E-17, 1.2211E-17,
     &   1.0278E-17, 0.0000E+00, 1.0278E-17, 9.2561E-11, 3.7014E-10,
     &   8.3282E-10, 1.4805E-09, 2.3136E-09, 3.3324E-09, 4.5370E-09,
     &   5.9277E-09, 7.5049E-09, 9.2690E-09, 1.1220E-08, 1.3360E-08,
     &   1.5687E-08, 1.8204E-08, 2.0910E-08, 2.3806E-08, 2.6894E-08/
  
         DATA ((DAT  (I,J), I= 901, 979), J=2,2) /
     &   3.0173E-08, 3.3645E-08, 3.7311E-08, 4.1171E-08, 4.5227E-08,
     &   4.9479E-08, 5.3930E-08, 5.8579E-08, 6.3429E-08, 6.8481E-08,
     &   7.3736E-08, 7.9196E-08, 8.4861E-08, 9.0735E-08, 9.6818E-08,
     &   1.0311E-07, 1.0962E-07, 1.1634E-07, 1.2329E-07, 1.3045E-07,
     &   1.3783E-07, 1.4544E-07, 1.5327E-07, 1.6133E-07, 1.6963E-07,
     &   1.7816E-07, 1.8693E-07, 1.9594E-07, 2.0519E-07, 2.1469E-07,
     &   2.2445E-07, 2.3446E-07, 2.4472E-07, 2.5526E-07, 2.6606E-07,
     &   2.7713E-07, 2.8848E-07, 3.0012E-07, 3.1204E-07, 3.2426E-07,
     &   3.3677E-07, 3.4960E-07, 3.6274E-07, 3.7619E-07, 3.8998E-07,
     &   4.0410E-07, 4.1857E-07, 4.3339E-07, 4.4858E-07, 4.6414E-07,
     &   4.8009E-07, 4.9644E-07, 5.1319E-07, 5.3038E-07, 5.4800E-07,
     &   5.6609E-07, 5.8465E-07, 6.0371E-07, 6.2328E-07, 6.4340E-07,
     &   6.6409E-07, 6.8539E-07, 7.0731E-07, 7.2990E-07, 7.5321E-07,
     &   7.7729E-07, 8.0218E-07, 8.2796E-07, 8.5470E-07, 8.8250E-07,
     &   9.1146E-07, 9.4171E-07, 9.7343E-07, 9.8437E-07, 1.0068E-06,
     &   1.01490278E-06, 1.04221637E-06, 1.04587782E-06, 1.05451612E-06/
  
         DATA ((DAT  (I,J), I=   1, 100), J=3,3) /
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4122E-04,
     &   1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04,
     &   1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04,
     &   1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4121E-04,
     &   1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4121E-04,
     &   1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4120E-04,
     &   1.4120E-04, 1.4120E-04, 1.4120E-04, 1.4120E-04, 1.4120E-04,
     &   1.4120E-04, 1.4119E-04, 1.4119E-04, 1.4119E-04, 1.4119E-04,
     &   1.4119E-04, 1.4118E-04, 1.4118E-04, 1.4118E-04, 1.4118E-04,
     &   1.4117E-04, 1.4117E-04, 1.4117E-04, 1.4116E-04, 1.4116E-04,
     &   1.4116E-04, 1.4115E-04, 1.4115E-04, 1.4114E-04, 1.4113E-04,
     &   1.4113E-04, 1.4112E-04, 1.4111E-04, 1.4110E-04, 1.4109E-04,
     &   1.4107E-04, 1.4105E-04, 1.4103E-04, 1.4101E-04, 1.4097E-04,
     &   1.4093E-04, 1.4092E-04, 1.4092E-04, 1.4091E-04, 1.4091E-04,
     &   1.4090E-04, 1.4090E-04, 1.4089E-04, 1.4088E-04, 1.4088E-04/
  
         DATA ((DAT  (I,J), I= 101, 200), J=3,3) /
     &   1.4087E-04, 1.4087E-04, 1.4086E-04, 1.4085E-04, 1.4084E-04,
     &   1.4084E-04, 1.4083E-04, 1.4082E-04, 1.4081E-04, 1.4080E-04,
     &   1.4079E-04, 1.4078E-04, 1.4077E-04, 1.4076E-04, 1.4075E-04,
     &   1.4074E-04, 1.4073E-04, 1.4072E-04, 1.4071E-04, 1.4069E-04,
     &   1.4068E-04, 1.4067E-04, 1.4065E-04, 1.4064E-04, 1.4062E-04,
     &   1.4061E-04, 1.4059E-04, 1.4057E-04, 1.4055E-04, 1.4053E-04,
     &   1.4051E-04, 1.4049E-04, 1.4047E-04, 1.4044E-04, 1.4042E-04,
     &   1.4039E-04, 1.4036E-04, 1.4033E-04, 1.4030E-04, 1.4027E-04,
     &   1.4023E-04, 1.4020E-04, 1.4016E-04, 1.4012E-04, 1.4007E-04,
     &   1.4003E-04, 1.3998E-04, 1.3992E-04, 1.3987E-04, 1.3980E-04,
     &   1.3974E-04, 1.3967E-04, 1.3959E-04, 1.3951E-04, 1.3942E-04,
     &   1.3933E-04, 1.3922E-04, 1.3911E-04, 1.3899E-04, 1.3886E-04,
     &   1.3871E-04, 1.3855E-04, 1.3837E-04, 1.3818E-04, 1.3796E-04,
     &   1.3772E-04, 1.3745E-04, 1.3715E-04, 1.3682E-04, 1.3643E-04,
     &   1.3600E-04, 1.3551E-04, 1.3494E-04, 1.3428E-04, 1.3352E-04,
     &   1.3263E-04, 1.3157E-04, 1.3031E-04, 1.2880E-04, 1.2695E-04,
     &   1.2468E-04, 1.2445E-04, 1.2421E-04, 1.2397E-04, 1.2373E-04,
     &   1.2348E-04, 1.2323E-04, 1.2297E-04, 1.2270E-04, 1.2243E-04,
     &   1.2216E-04, 1.2187E-04, 1.2159E-04, 1.2129E-04, 1.2099E-04,
     &   1.2068E-04, 1.2037E-04, 1.2005E-04, 1.1972E-04, 1.1939E-04/
  
         DATA ((DAT  (I,J), I= 201, 300), J=3,3) /
     &   1.1905E-04, 1.1870E-04, 1.1834E-04, 1.1797E-04, 1.1760E-04,
     &   1.1722E-04, 1.1682E-04, 1.1642E-04, 1.1601E-04, 1.1560E-04,
     &   1.1517E-04, 1.1473E-04, 1.1428E-04, 1.1382E-04, 1.1335E-04,
     &   1.1287E-04, 1.1237E-04, 1.1187E-04, 1.1135E-04, 1.1082E-04,
     &   1.1028E-04, 1.0973E-04, 1.0916E-04, 1.0857E-04, 1.0798E-04,
     &   1.0737E-04, 1.0674E-04, 1.0610E-04, 1.0544E-04, 1.0476E-04,
     &   1.0407E-04, 1.0336E-04, 1.0264E-04, 1.0189E-04, 1.0113E-04,
     &   1.0035E-04, 9.9542E-05, 9.8719E-05, 9.7875E-05, 9.7009E-05,
     &   9.6122E-05, 9.5211E-05, 9.4277E-05, 9.3318E-05, 9.2334E-05,
     &   9.1325E-05, 9.0289E-05, 8.9226E-05, 8.8134E-05, 8.7012E-05,
     &   8.5861E-05, 8.4677E-05, 8.3461E-05, 8.2210E-05, 8.0924E-05,
     &   7.9601E-05, 7.8238E-05, 7.6835E-05, 7.5389E-05, 7.3899E-05,
     &   7.2360E-05, 7.0772E-05, 6.9131E-05, 6.7434E-05, 6.5679E-05,
     &   6.3861E-05, 6.1976E-05, 6.0022E-05, 5.7995E-05, 5.5889E-05,
     &   5.3703E-05, 5.1432E-05, 4.9072E-05, 4.6623E-05, 4.4081E-05,
     &   4.1447E-05, 3.8723E-05, 3.5910E-05, 3.3015E-05, 3.0047E-05,
     &   2.7016E-05, 2.6710E-05, 2.6404E-05, 2.6097E-05, 2.5790E-05,
     &   2.5482E-05, 2.5174E-05, 2.4866E-05, 2.4557E-05, 2.4248E-05,
     &   2.3939E-05, 2.3629E-05, 2.3319E-05, 2.3009E-05, 2.2699E-05,
     &   2.2389E-05, 2.2078E-05, 2.1767E-05, 2.1456E-05, 2.1145E-05/
  
         DATA ((DAT  (I,J), I= 301, 400), J=3,3) /
     &   2.0834E-05, 2.0523E-05, 2.0212E-05, 1.9901E-05, 1.9590E-05,
     &   1.9280E-05, 1.8969E-05, 1.8658E-05, 1.8348E-05, 1.8038E-05,
     &   1.7728E-05, 1.7418E-05, 1.7109E-05, 1.6800E-05, 1.6491E-05,
     &   1.6183E-05, 1.5875E-05, 1.5568E-05, 1.5262E-05, 1.4956E-05,
     &   1.4650E-05, 1.4346E-05, 1.4042E-05, 1.3739E-05, 1.3436E-05,
     &   1.3135E-05, 1.2834E-05, 1.2535E-05, 1.2237E-05, 1.1939E-05,
     &   1.1643E-05, 1.1349E-05, 1.1055E-05, 1.0763E-05, 1.0473E-05,
     &   1.0183E-05, 9.8959E-06, 9.6101E-06, 9.3261E-06, 9.0439E-06,
     &   8.7637E-06, 8.4854E-06, 8.2093E-06, 7.9354E-06, 7.6638E-06,
     &   7.3946E-06, 7.1280E-06, 6.8639E-06, 6.6026E-06, 6.3442E-06,
     &   6.0887E-06, 5.8363E-06, 5.5871E-06, 5.3412E-06, 5.0989E-06,
     &   4.8601E-06, 4.6251E-06, 4.3940E-06, 4.1669E-06, 3.9441E-06,
     &   3.7256E-06, 3.5115E-06, 3.3022E-06, 3.0977E-06, 2.8981E-06,
     &   2.7037E-06, 2.5147E-06, 2.3311E-06, 2.1532E-06, 1.9812E-06,
     &   1.8151E-06, 1.6553E-06, 1.5018E-06, 1.3549E-06, 1.2146E-06,
     &   1.0813E-06, 9.5498E-07, 8.3588E-07, 7.2416E-07, 6.1994E-07,
     &   5.2340E-07, 5.1417E-07, 5.0502E-07, 4.9595E-07, 4.8696E-07,
     &   4.7804E-07, 4.6921E-07, 4.6045E-07, 4.5177E-07, 4.4317E-07,
     &   4.3465E-07, 4.2621E-07, 4.1785E-07, 4.0957E-07, 4.0137E-07,
     &   3.9325E-07, 3.8521E-07, 3.7724E-07, 3.6936E-07, 3.6156E-07/
  
         DATA ((DAT  (I,J), I= 401, 500), J=3,3) /
     &   3.5384E-07, 3.4620E-07, 3.3864E-07, 3.3116E-07, 3.2377E-07,
     &   3.1645E-07, 3.0922E-07, 3.0206E-07, 2.9499E-07, 2.8800E-07,
     &   2.8109E-07, 2.7426E-07, 2.6751E-07, 2.6085E-07, 2.5427E-07,
     &   2.4777E-07, 2.4135E-07, 2.3501E-07, 2.2876E-07, 2.2259E-07,
     &   2.1650E-07, 2.1049E-07, 2.0457E-07, 1.9873E-07, 1.9298E-07,
     &   1.8730E-07, 1.8171E-07, 1.7620E-07, 1.7078E-07, 1.6544E-07,
     &   1.6018E-07, 1.5501E-07, 1.4992E-07, 1.4491E-07, 1.3999E-07,
     &   1.3515E-07, 1.3040E-07, 1.2573E-07, 1.2114E-07, 1.1664E-07,
     &   1.1222E-07, 1.0789E-07, 1.0364E-07, 9.9475E-08, 9.5396E-08,
     &   9.1401E-08, 8.7490E-08, 8.3665E-08, 7.9924E-08, 7.6268E-08,
     &   7.2698E-08, 6.9212E-08, 6.5811E-08, 6.2495E-08, 5.9265E-08,
     &   5.6120E-08, 5.3060E-08, 5.0085E-08, 4.7196E-08, 4.4393E-08,
     &   4.1674E-08, 3.9042E-08, 3.6495E-08, 3.4033E-08, 3.1657E-08,
     &   2.9367E-08, 2.7163E-08, 2.5044E-08, 2.3011E-08, 2.1064E-08,
     &   1.9203E-08, 1.7428E-08, 1.5739E-08, 1.4136E-08, 1.2618E-08,
     &   1.1187E-08, 9.8419E-09, 8.5828E-09, 7.4097E-09, 6.3227E-09,
     &   5.3219E-09, 5.2265E-09, 5.1321E-09, 5.0384E-09, 4.9457E-09,
     &   4.8538E-09, 4.7627E-09, 4.6726E-09, 4.5832E-09, 4.4948E-09,
     &   4.4072E-09, 4.3205E-09, 4.2346E-09, 4.1496E-09, 4.0654E-09,
     &   3.9821E-09, 3.8997E-09, 3.8182E-09, 3.7375E-09, 3.6576E-09/
  
         DATA ((DAT  (I,J), I= 501, 600), J=3,3) /
     &   3.5786E-09, 3.5005E-09, 3.4233E-09, 3.3469E-09, 3.2714E-09,
     &   3.1967E-09, 3.1229E-09, 3.0499E-09, 2.9778E-09, 2.9066E-09,
     &   2.8363E-09, 2.7668E-09, 2.6981E-09, 2.6304E-09, 2.5634E-09,
     &   2.4974E-09, 2.4322E-09, 2.3679E-09, 2.3044E-09, 2.2418E-09,
     &   2.1801E-09, 2.1192E-09, 2.0592E-09, 2.0000E-09, 1.9417E-09,
     &   1.8843E-09, 1.8277E-09, 1.7720E-09, 1.7172E-09, 1.6632E-09,
     &   1.6101E-09, 1.5578E-09, 1.5064E-09, 1.4559E-09, 1.4062E-09,
     &   1.3574E-09, 1.3094E-09, 1.2624E-09, 1.2161E-09, 1.1708E-09,
     &   1.1263E-09, 1.0826E-09, 1.0399E-09, 9.9794E-10, 9.5688E-10,
     &   9.1669E-10, 8.7737E-10, 8.3890E-10, 8.0130E-10, 7.6455E-10,
     &   7.2868E-10, 6.9366E-10, 6.5950E-10, 6.2621E-10, 5.9378E-10,
     &   5.6221E-10, 5.3151E-10, 5.0166E-10, 4.7268E-10, 4.4456E-10,
     &   4.1730E-10, 3.9091E-10, 3.6537E-10, 3.4070E-10, 3.1690E-10,
     &   2.9395E-10, 2.7187E-10, 2.5064E-10, 2.3028E-10, 2.1079E-10,
     &   1.9215E-10, 1.7438E-10, 1.5747E-10, 1.4142E-10, 1.2624E-10,
     &   1.1191E-10, 9.8450E-11, 8.5851E-11, 7.4115E-11, 6.3240E-11,
     &   5.3228E-11, 5.2274E-11, 5.1329E-11, 5.0393E-11, 4.9465E-11,
     &   4.8545E-11, 4.7635E-11, 4.6733E-11, 4.5839E-11, 4.4954E-11,
     &   4.4078E-11, 4.3211E-11, 4.2352E-11, 4.1501E-11, 4.0660E-11,
     &   3.9827E-11, 3.9002E-11, 3.8186E-11, 3.7379E-11, 3.6581E-11/
  
         DATA ((DAT  (I,J), I= 601, 700), J=3,3) /
     &   3.5791E-11, 3.5009E-11, 3.4236E-11, 3.3472E-11, 3.2717E-11,
     &   3.1970E-11, 3.1232E-11, 3.0502E-11, 2.9781E-11, 2.9069E-11,
     &   2.8365E-11, 2.7670E-11, 2.6984E-11, 2.6306E-11, 2.5637E-11,
     &   2.4976E-11, 2.4324E-11, 2.3681E-11, 2.3046E-11, 2.2420E-11,
     &   2.1802E-11, 2.1193E-11, 2.0593E-11, 2.0001E-11, 1.9418E-11,
     &   1.8844E-11, 1.8278E-11, 1.7721E-11, 1.7173E-11, 1.6633E-11,
     &   1.6101E-11, 1.5579E-11, 1.5065E-11, 1.4559E-11, 1.4063E-11,
     &   1.3574E-11, 1.3095E-11, 1.2624E-11, 1.2162E-11, 1.1708E-11,
     &   1.1263E-11, 1.0827E-11, 1.0399E-11, 9.9797E-12, 9.5691E-12,
     &   9.1672E-12, 8.7739E-12, 8.3892E-12, 8.0132E-12, 7.6457E-12,
     &   7.2869E-12, 6.9367E-12, 6.5952E-12, 6.2622E-12, 5.9379E-12,
     &   5.6222E-12, 5.3151E-12, 5.0167E-12, 4.7269E-12, 4.4457E-12,
     &   4.1731E-12, 3.9091E-12, 3.6538E-12, 3.4071E-12, 3.1690E-12,
     &   2.9395E-12, 2.7187E-12, 2.5065E-12, 2.3029E-12, 2.1079E-12,
     &   1.9215E-12, 1.7438E-12, 1.5747E-12, 1.4142E-12, 1.2624E-12,
     &   1.1191E-12, 9.8451E-13, 8.5852E-13, 7.4115E-13, 6.3240E-13,
     &   5.3228E-13, 5.2274E-13, 5.1329E-13, 5.0393E-13, 4.9465E-13,
     &   4.8545E-13, 4.7635E-13, 4.6733E-13, 4.5839E-13, 4.4954E-13,
     &   4.4078E-13, 4.3211E-13, 4.2352E-13, 4.1501E-13, 4.0660E-13,
     &   3.9827E-13, 3.9002E-13, 3.8186E-13, 3.7379E-13, 3.6581E-13/
  
         DATA ((DAT  (I,J), I= 701, 800), J=3,3) /
     &   3.5791E-13, 3.5009E-13, 3.4237E-13, 3.3472E-13, 3.2717E-13,
     &   3.1970E-13, 3.1232E-13, 3.0502E-13, 2.9781E-13, 2.9069E-13,
     &   2.8365E-13, 2.7670E-13, 2.6984E-13, 2.6306E-13, 2.5637E-13,
     &   2.4976E-13, 2.4324E-13, 2.3681E-13, 2.3046E-13, 2.2420E-13,
     &   2.1802E-13, 2.1193E-13, 2.0593E-13, 2.0001E-13, 1.9418E-13,
     &   1.8844E-13, 1.8278E-13, 1.7721E-13, 1.7173E-13, 1.6633E-13,
     &   1.6102E-13, 1.5579E-13, 1.5065E-13, 1.4559E-13, 1.4063E-13,
     &   1.3574E-13, 1.3095E-13, 1.2624E-13, 1.2162E-13, 1.1708E-13,
     &   1.1263E-13, 1.0827E-13, 1.0399E-13, 9.9797E-14, 9.5691E-14,
     &   9.1672E-14, 8.7739E-14, 8.3892E-14, 8.0132E-14, 7.6457E-14,
     &   7.2869E-14, 6.9367E-14, 6.5952E-14, 6.2622E-14, 5.9379E-14,
     &   5.6222E-14, 5.3151E-14, 5.0167E-14, 4.7269E-14, 4.4457E-14,
     &   4.1731E-14, 3.9091E-14, 3.6538E-14, 3.4071E-14, 3.1690E-14,
     &   2.9395E-14, 2.7187E-14, 2.5065E-14, 2.3029E-14, 2.1079E-14,
     &   1.9215E-14, 1.7438E-14, 1.5747E-14, 1.4142E-14, 1.2624E-14,
     &   1.1191E-14, 9.8451E-15, 8.5852E-15, 7.4115E-15, 6.3240E-15,
     &   5.3228E-15, 5.2274E-15, 5.1329E-15, 5.0393E-15, 4.9465E-15,
     &   4.8545E-15, 4.7635E-15, 4.6733E-15, 4.5839E-15, 4.4954E-15,
     &   4.4078E-15, 4.3211E-15, 4.2352E-15, 4.1501E-15, 4.0660E-15,
     &   3.9827E-15, 3.9002E-15, 3.8186E-15, 3.7379E-15, 3.6581E-15/
  
         DATA ((DAT  (I,J), I= 801, 900), J=3,3) /
     &   3.5791E-15, 3.5009E-15, 3.4237E-15, 3.3472E-15, 3.2717E-15,
     &   3.1970E-15, 3.1232E-15, 3.0502E-15, 2.9781E-15, 2.9069E-15,
     &   2.8365E-15, 2.7670E-15, 2.6984E-15, 2.6306E-15, 2.5637E-15,
     &   2.4976E-15, 2.4324E-15, 2.3681E-15, 2.3046E-15, 2.2420E-15,
     &   2.1802E-15, 2.1193E-15, 2.0593E-15, 2.0001E-15, 1.9418E-15,
     &   1.8844E-15, 1.8278E-15, 1.7721E-15, 1.7173E-15, 1.6633E-15,
     &   1.6102E-15, 1.5579E-15, 1.5065E-15, 1.4559E-15, 1.4063E-15,
     &   1.3574E-15, 1.3095E-15, 1.2624E-15, 1.2162E-15, 1.1708E-15,
     &   1.1263E-15, 1.0827E-15, 1.0399E-15, 9.9797E-16, 9.5691E-16,
     &   9.1672E-16, 8.7739E-16, 8.3892E-16, 8.0132E-16, 7.6457E-16,
     &   7.2869E-16, 6.9367E-16, 6.5952E-16, 6.2622E-16, 5.9379E-16,
     &   5.6222E-16, 5.3151E-16, 5.0167E-16, 4.7269E-16, 4.4457E-16,
     &   4.1731E-16, 3.9091E-16, 3.6538E-16, 3.4071E-16, 3.1690E-16,
     &   2.9395E-16, 2.7187E-16, 2.5065E-16, 2.3029E-16, 2.1079E-16,
     &   1.9215E-16, 1.7438E-16, 1.5747E-16, 1.4142E-16, 1.2624E-16,
     &   1.1191E-16, 9.8451E-17, 8.5852E-17, 7.4115E-17, 6.3240E-17,
     &   5.3228E-17, 0.0000E+00, 5.3228E-17, 4.7938E-10, 1.9170E-09,
     &   4.3130E-09, 7.6668E-09, 1.1981E-08, 1.7256E-08, 2.3492E-08,
     &   3.0690E-08, 3.8852E-08, 4.7980E-08, 5.8075E-08, 6.9139E-08,
     &   8.1174E-08, 9.4183E-08, 1.0817E-07, 1.2313E-07, 1.3908E-07/
  
         DATA ((DAT  (I,J), I= 901, 979), J=3,3) /
     &   1.5601E-07, 1.7392E-07, 1.9283E-07, 2.1274E-07, 2.3364E-07,
     &   2.5555E-07, 2.7846E-07, 3.0239E-07, 3.2733E-07, 3.5330E-07,
     &   3.8029E-07, 4.0832E-07, 4.3738E-07, 4.6750E-07, 4.9866E-07,
     &   5.3088E-07, 5.6417E-07, 5.9853E-07, 6.3397E-07, 6.7050E-07,
     &   7.0813E-07, 7.4686E-07, 7.8671E-07, 8.2768E-07, 8.6978E-07,
     &   9.1303E-07, 9.5744E-07, 1.0030E-06, 1.0498E-06, 1.0977E-06,
     &   1.1468E-06, 1.1972E-06, 1.2488E-06, 1.3016E-06, 1.3557E-06,
     &   1.4111E-06, 1.4677E-06, 1.5257E-06, 1.5849E-06, 1.6456E-06,
     &   1.7076E-06, 1.7709E-06, 1.8357E-06, 1.9019E-06, 1.9696E-06,
     &   2.0387E-06, 2.1094E-06, 2.1816E-06, 2.2553E-06, 2.3306E-06,
     &   2.4076E-06, 2.4862E-06, 2.5665E-06, 2.6486E-06, 2.7324E-06,
     &   2.8180E-06, 2.9056E-06, 2.9950E-06, 3.0864E-06, 3.1798E-06,
     &   3.2754E-06, 3.3731E-06, 3.4731E-06, 3.5753E-06, 3.6800E-06,
     &   3.7873E-06, 3.8971E-06, 4.0097E-06, 4.1251E-06, 4.2436E-06,
     &   4.3653E-06, 4.4903E-06, 4.6190E-06, 4.6627E-06, 4.7515E-06,
     &   4.78304724E-06, 4.88823283E-06, 4.90214533E-06, 4.93478289E-06/

c      ++++ deghadt23 ++++  

c update 09/25/25 
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 20:52:28 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
         DATA ((DGT  (I,J), I=   1, 100), J=1,1) /
     &   8.3890E-02, 8.3784E-02, 8.3677E-02, 8.3568E-02, 8.3459E-02,
     &   8.3348E-02, 8.3235E-02, 8.3122E-02, 8.3007E-02, 8.2890E-02,
     &   8.2772E-02, 8.2653E-02, 8.2532E-02, 8.2410E-02, 8.2286E-02,
     &   8.2161E-02, 8.2034E-02, 8.1905E-02, 8.1774E-02, 8.1642E-02,
     &   8.1507E-02, 8.1371E-02, 8.1233E-02, 8.1093E-02, 8.0951E-02,
     &   8.0807E-02, 8.0661E-02, 8.0512E-02, 8.0361E-02, 8.0208E-02,
     &   8.0052E-02, 7.9894E-02, 7.9733E-02, 7.9570E-02, 7.9404E-02,
     &   7.9235E-02, 7.9063E-02, 7.8888E-02, 7.8710E-02, 7.8529E-02,
     &   7.8344E-02, 7.8156E-02, 7.7965E-02, 7.7769E-02, 7.7570E-02,
     &   7.7367E-02, 7.7160E-02, 7.6949E-02, 7.6733E-02, 7.6512E-02,
     &   7.6287E-02, 7.6057E-02, 7.5821E-02, 7.5580E-02, 7.5334E-02,
     &   7.5081E-02, 7.4823E-02, 7.4558E-02, 7.4286E-02, 7.4007E-02,
     &   7.3721E-02, 7.3427E-02, 7.3125E-02, 7.2814E-02, 7.2494E-02,
     &   7.2165E-02, 7.1825E-02, 7.1474E-02, 7.1113E-02, 7.0739E-02,
     &   7.0352E-02, 6.9951E-02, 6.9536E-02, 6.9105E-02, 6.8657E-02,
     &   6.8190E-02, 6.7704E-02, 6.7197E-02, 6.6666E-02, 6.6110E-02,
     &   6.5525E-02, 6.4910E-02, 6.4261E-02, 6.3574E-02, 6.2844E-02,
     &   6.2066E-02, 6.1234E-02, 6.0339E-02, 5.9371E-02, 5.8318E-02,
     &   5.7163E-02, 5.7042E-02, 5.6919E-02, 5.6794E-02, 5.6669E-02,
     &   5.6542E-02, 5.6413E-02, 5.6284E-02, 5.6152E-02, 5.6020E-02/
  
         DATA ((DGT  (I,J), I= 101, 200), J=1,1) /
     &   5.5886E-02, 5.5750E-02, 5.5613E-02, 5.5474E-02, 5.5334E-02,
     &   5.5192E-02, 5.5049E-02, 5.4903E-02, 5.4756E-02, 5.4607E-02,
     &   5.4456E-02, 5.4304E-02, 5.4149E-02, 5.3992E-02, 5.3833E-02,
     &   5.3673E-02, 5.3509E-02, 5.3344E-02, 5.3177E-02, 5.3007E-02,
     &   5.2834E-02, 5.2659E-02, 5.2482E-02, 5.2302E-02, 5.2119E-02,
     &   5.1934E-02, 5.1745E-02, 5.1554E-02, 5.1359E-02, 5.1162E-02,
     &   5.0961E-02, 5.0756E-02, 5.0549E-02, 5.0337E-02, 5.0122E-02,
     &   4.9903E-02, 4.9680E-02, 4.9452E-02, 4.9221E-02, 4.8985E-02,
     &   4.8744E-02, 4.8498E-02, 4.8248E-02, 4.7992E-02, 4.7730E-02,
     &   4.7463E-02, 4.7190E-02, 4.6910E-02, 4.6624E-02, 4.6332E-02,
     &   4.6032E-02, 4.5724E-02, 4.5409E-02, 4.5085E-02, 4.4752E-02,
     &   4.4410E-02, 4.4058E-02, 4.3696E-02, 4.3323E-02, 4.2939E-02,
     &   4.2541E-02, 4.2131E-02, 4.1706E-02, 4.1267E-02, 4.0811E-02,
     &   4.0338E-02, 3.9845E-02, 3.9333E-02, 3.8798E-02, 3.8240E-02,
     &   3.7655E-02, 3.7042E-02, 3.6397E-02, 3.5716E-02, 3.4997E-02,
     &   3.4234E-02, 3.3422E-02, 3.2554E-02, 3.1622E-02, 3.0616E-02,
     &   2.9523E-02, 2.9420E-02, 2.9316E-02, 2.9211E-02, 2.9105E-02,
     &   2.8998E-02, 2.8891E-02, 2.8782E-02, 2.8673E-02, 2.8562E-02,
     &   2.8451E-02, 2.8339E-02, 2.8225E-02, 2.8111E-02, 2.7995E-02,
     &   2.7879E-02, 2.7761E-02, 2.7642E-02, 2.7523E-02, 2.7402E-02/
  
         DATA ((DGT  (I,J), I= 201, 300), J=1,1) /
     &   2.7279E-02, 2.7156E-02, 2.7031E-02, 2.6906E-02, 2.6778E-02,
     &   2.6650E-02, 2.6520E-02, 2.6389E-02, 2.6257E-02, 2.6123E-02,
     &   2.5988E-02, 2.5851E-02, 2.5713E-02, 2.5573E-02, 2.5431E-02,
     &   2.5288E-02, 2.5144E-02, 2.4997E-02, 2.4849E-02, 2.4699E-02,
     &   2.4548E-02, 2.4394E-02, 2.4239E-02, 2.4081E-02, 2.3922E-02,
     &   2.3760E-02, 2.3597E-02, 2.3431E-02, 2.3263E-02, 2.3093E-02,
     &   2.2920E-02, 2.2745E-02, 2.2568E-02, 2.2388E-02, 2.2205E-02,
     &   2.2019E-02, 2.1831E-02, 2.1640E-02, 2.1446E-02, 2.1249E-02,
     &   2.1048E-02, 2.0845E-02, 2.0638E-02, 2.0427E-02, 2.0213E-02,
     &   1.9995E-02, 1.9773E-02, 1.9547E-02, 1.9317E-02, 1.9083E-02,
     &   1.8844E-02, 1.8600E-02, 1.8351E-02, 1.8097E-02, 1.7838E-02,
     &   1.7574E-02, 1.7303E-02, 1.7026E-02, 1.6743E-02, 1.6453E-02,
     &   1.6156E-02, 1.5851E-02, 1.5539E-02, 1.5218E-02, 1.4888E-02,
     &   1.4548E-02, 1.4198E-02, 1.3837E-02, 1.3464E-02, 1.3079E-02,
     &   1.2679E-02, 1.2265E-02, 1.1834E-02, 1.1385E-02, 1.0916E-02,
     &   1.0424E-02, 9.9090E-03, 9.3665E-03, 8.7941E-03, 8.1886E-03,
     &   7.5469E-03, 7.4807E-03, 7.4140E-03, 7.3469E-03, 7.2794E-03,
     &   7.2115E-03, 7.1432E-03, 7.0745E-03, 7.0054E-03, 6.9359E-03,
     &   6.8660E-03, 6.7956E-03, 6.7248E-03, 6.6537E-03, 6.5821E-03,
     &   6.5100E-03, 6.4376E-03, 6.3647E-03, 6.2914E-03, 6.2177E-03/
  
         DATA ((DGT  (I,J), I= 301, 400), J=1,1) /
     &   6.1436E-03, 6.0690E-03, 5.9940E-03, 5.9186E-03, 5.8428E-03,
     &   5.7666E-03, 5.6899E-03, 5.6129E-03, 5.5354E-03, 5.4575E-03,
     &   5.3793E-03, 5.3006E-03, 5.2215E-03, 5.1421E-03, 5.0623E-03,
     &   4.9821E-03, 4.9015E-03, 4.8206E-03, 4.7393E-03, 4.6577E-03,
     &   4.5757E-03, 4.4935E-03, 4.4109E-03, 4.3281E-03, 4.2449E-03,
     &   4.1615E-03, 4.0779E-03, 3.9940E-03, 3.9099E-03, 3.8256E-03,
     &   3.7412E-03, 3.6566E-03, 3.5718E-03, 3.4870E-03, 3.4020E-03,
     &   3.3171E-03, 3.2320E-03, 3.1470E-03, 3.0621E-03, 2.9771E-03,
     &   2.8933E-03, 2.8086E-03, 2.7241E-03, 2.6398E-03, 2.5557E-03,
     &   2.4720E-03, 2.3885E-03, 2.3055E-03, 2.2229E-03, 2.1408E-03,
     &   2.0592E-03, 1.9801E-03, 1.8998E-03, 1.8201E-03, 1.7413E-03,
     &   1.6633E-03, 1.5862E-03, 1.5100E-03, 1.4348E-03, 1.3608E-03,
     &   1.2879E-03, 1.2162E-03, 1.1459E-03, 1.0769E-03, 1.0094E-03,
     &   9.4059E-04, 8.7614E-04, 8.1337E-04, 7.5235E-04, 6.9317E-04,
     &   6.3589E-04, 5.8061E-04, 5.2739E-04, 4.7632E-04, 4.2747E-04,
     &   3.8092E-04, 3.3674E-04, 2.9500E-04, 2.5578E-04, 2.1914E-04,
     &   1.8514E-04, 1.8189E-04, 1.7866E-04, 1.7547E-04, 1.7230E-04,
     &   1.6915E-04, 1.6604E-04, 1.6295E-04, 1.5989E-04, 1.5685E-04,
     &   1.5385E-04, 1.5087E-04, 1.4792E-04, 1.4500E-04, 1.4210E-04,
     &   1.3923E-04, 1.3639E-04, 1.3358E-04, 1.3080E-04, 1.2804E-04/
  
         DATA ((DGT  (I,J), I= 401, 500), J=1,1) /
     &   1.2532E-04, 1.2262E-04, 1.1995E-04, 1.1730E-04, 1.1469E-04,
     &   1.1210E-04, 1.0955E-04, 1.0702E-04, 1.0452E-04, 1.0205E-04,
     &   9.9602E-05, 9.7187E-05, 9.4801E-05, 9.2444E-05, 9.0115E-05,
     &   8.7816E-05, 8.5545E-05, 8.3303E-05, 8.1090E-05, 7.8906E-05,
     &   7.6752E-05, 7.4626E-05, 7.2529E-05, 7.0462E-05, 6.8424E-05,
     &   6.6414E-05, 6.4435E-05, 6.2484E-05, 6.0563E-05, 5.8671E-05,
     &   5.6809E-05, 5.4976E-05, 5.3173E-05, 5.1399E-05, 4.9655E-05,
     &   4.7940E-05, 4.6256E-05, 4.4600E-05, 4.2975E-05, 4.1379E-05,
     &   3.9813E-05, 3.8277E-05, 3.6771E-05, 3.5294E-05, 3.3848E-05,
     &   3.2431E-05, 3.1045E-05, 2.9688E-05, 2.8361E-05, 2.7065E-05,
     &   2.5798E-05, 2.4562E-05, 2.3356E-05, 2.2179E-05, 2.1033E-05,
     &   1.9918E-05, 1.8832E-05, 1.7777E-05, 1.6752E-05, 1.5757E-05,
     &   1.4792E-05, 1.3858E-05, 1.2954E-05, 1.2081E-05, 1.1238E-05,
     &   1.0425E-05, 9.6424E-06, 8.8905E-06, 8.1690E-06, 7.4779E-06,
     &   6.8173E-06, 6.1872E-06, 5.5876E-06, 5.0184E-06, 4.4798E-06,
     &   3.9717E-06, 3.4942E-06, 3.0472E-06, 2.6307E-06, 2.2448E-06,
     &   1.8895E-06, 1.8556E-06, 1.8221E-06, 1.7888E-06, 1.7559E-06,
     &   1.7233E-06, 1.6910E-06, 1.6590E-06, 1.6272E-06, 1.5958E-06,
     &   1.5647E-06, 1.5339E-06, 1.5035E-06, 1.4733E-06, 1.4434E-06,
     &   1.4138E-06, 1.3846E-06, 1.3556E-06, 1.3270E-06, 1.2986E-06/
  
         DATA ((DGT  (I,J), I= 501, 600), J=1,1) /
     &   1.2706E-06, 1.2428E-06, 1.2154E-06, 1.1883E-06, 1.1615E-06,
     &   1.1350E-06, 1.1088E-06, 1.0829E-06, 1.0573E-06, 1.0320E-06,
     &   1.0070E-06, 9.8233E-07, 9.5796E-07, 9.3390E-07, 9.1014E-07,
     &   8.8669E-07, 8.6355E-07, 8.4071E-07, 8.1818E-07, 7.9595E-07,
     &   7.7403E-07, 7.5241E-07, 7.3111E-07, 7.1010E-07, 6.8941E-07,
     &   6.6902E-07, 6.4893E-07, 6.2915E-07, 6.0968E-07, 5.9051E-07,
     &   5.7165E-07, 5.5310E-07, 5.3485E-07, 5.1691E-07, 4.9927E-07,
     &   4.8194E-07, 4.6492E-07, 4.4820E-07, 4.3179E-07, 4.1568E-07,
     &   3.9988E-07, 3.8439E-07, 3.6920E-07, 3.5432E-07, 3.3974E-07,
     &   3.2547E-07, 3.1151E-07, 2.9785E-07, 2.8450E-07, 2.7146E-07,
     &   2.5872E-07, 2.4628E-07, 2.3416E-07, 2.2234E-07, 2.1082E-07,
     &   1.9961E-07, 1.8871E-07, 1.7812E-07, 1.6783E-07, 1.5784E-07,
     &   1.4816E-07, 1.3879E-07, 1.2973E-07, 1.2097E-07, 1.1251E-07,
     &   1.0437E-07, 9.6527E-08, 8.8992E-08, 8.1763E-08, 7.4841E-08,
     &   6.8224E-08, 6.1914E-08, 5.5910E-08, 5.0212E-08, 4.4820E-08,
     &   3.9735E-08, 3.4955E-08, 3.0482E-08, 2.6315E-08, 2.2454E-08,
     &   1.8899E-08, 1.8560E-08, 1.8225E-08, 1.7892E-08, 1.7563E-08,
     &   1.7236E-08, 1.6913E-08, 1.6593E-08, 1.6275E-08, 1.5961E-08,
     &   1.5650E-08, 1.5342E-08, 1.5037E-08, 1.4735E-08, 1.4436E-08,
     &   1.4141E-08, 1.3848E-08, 1.3558E-08, 1.3272E-08, 1.2988E-08/
  
         DATA ((DGT  (I,J), I= 601, 700), J=1,1) /
     &   1.2708E-08, 1.2430E-08, 1.2156E-08, 1.1884E-08, 1.1616E-08,
     &   1.1351E-08, 1.1089E-08, 1.0830E-08, 1.0574E-08, 1.0321E-08,
     &   1.0071E-08, 9.8244E-09, 9.5806E-09, 9.3400E-09, 9.1023E-09,
     &   8.8678E-09, 8.6363E-09, 8.4079E-09, 8.1825E-09, 7.9602E-09,
     &   7.7409E-09, 7.5248E-09, 7.3116E-09, 7.1016E-09, 6.8946E-09,
     &   6.6906E-09, 6.4898E-09, 6.2920E-09, 6.0972E-09, 5.9055E-09,
     &   5.7169E-09, 5.5313E-09, 5.3488E-09, 5.1694E-09, 4.9930E-09,
     &   4.8197E-09, 4.6494E-09, 4.4822E-09, 4.3181E-09, 4.1570E-09,
     &   3.9990E-09, 3.8440E-09, 3.6921E-09, 3.5433E-09, 3.3976E-09,
     &   3.2548E-09, 3.1152E-09, 2.9786E-09, 2.8451E-09, 2.7146E-09,
     &   2.5872E-09, 2.4629E-09, 2.3416E-09, 2.2234E-09, 2.1083E-09,
     &   1.9962E-09, 1.8872E-09, 1.7812E-09, 1.6783E-09, 1.5784E-09,
     &   1.4817E-09, 1.3879E-09, 1.2973E-09, 1.2097E-09, 1.1252E-09,
     &   1.0437E-09, 9.6528E-10, 8.8993E-10, 8.1764E-10, 7.4841E-10,
     &   6.8225E-10, 6.1914E-10, 5.5910E-10, 5.0212E-10, 4.4820E-10,
     &   3.9735E-10, 3.4955E-10, 3.0482E-10, 2.6315E-10, 2.2454E-10,
     &   1.8899E-10, 1.8560E-10, 1.8225E-10, 1.7892E-10, 1.7563E-10,
     &   1.7236E-10, 1.6913E-10, 1.6593E-10, 1.6275E-10, 1.5961E-10,
     &   1.5650E-10, 1.5342E-10, 1.5037E-10, 1.4735E-10, 1.4436E-10,
     &   1.4141E-10, 1.3848E-10, 1.3558E-10, 1.3272E-10, 1.2988E-10/
  
         DATA ((DGT  (I,J), I= 701, 800), J=1,1) /
     &   1.2708E-10, 1.2430E-10, 1.2156E-10, 1.1885E-10, 1.1616E-10,
     &   1.1351E-10, 1.1089E-10, 1.0830E-10, 1.0574E-10, 1.0321E-10,
     &   1.0071E-10, 9.8244E-11, 9.5806E-11, 9.3400E-11, 9.1023E-11,
     &   8.8678E-11, 8.6363E-11, 8.4079E-11, 8.1825E-11, 7.9602E-11,
     &   7.7410E-11, 7.5248E-11, 7.3116E-11, 7.1016E-11, 6.8946E-11,
     &   6.6907E-11, 6.4898E-11, 6.2920E-11, 6.0972E-11, 5.9055E-11,
     &   5.7169E-11, 5.5313E-11, 5.3488E-11, 5.1694E-11, 4.9930E-11,
     &   4.8197E-11, 4.6494E-11, 4.4822E-11, 4.3181E-11, 4.1570E-11,
     &   3.9990E-11, 3.8440E-11, 3.6921E-11, 3.5433E-11, 3.3976E-11,
     &   3.2548E-11, 3.1152E-11, 2.9786E-11, 2.8451E-11, 2.7146E-11,
     &   2.5872E-11, 2.4629E-11, 2.3416E-11, 2.2234E-11, 2.1083E-11,
     &   1.9962E-11, 1.8872E-11, 1.7812E-11, 1.6783E-11, 1.5784E-11,
     &   1.4817E-11, 1.3879E-11, 1.2973E-11, 1.2097E-11, 1.1252E-11,
     &   1.0437E-11, 9.6528E-12, 8.8993E-12, 8.1764E-12, 7.4841E-12,
     &   6.8225E-12, 6.1914E-12, 5.5910E-12, 5.0212E-12, 4.4820E-12,
     &   3.9735E-12, 3.4955E-12, 3.0482E-12, 2.6315E-12, 2.2454E-12,
     &   1.8899E-12, 1.8560E-12, 1.8225E-12, 1.7892E-12, 1.7563E-12,
     &   1.7236E-12, 1.6913E-12, 1.6593E-12, 1.6275E-12, 1.5961E-12,
     &   1.5650E-12, 1.5342E-12, 1.5037E-12, 1.4735E-12, 1.4436E-12,
     &   1.4141E-12, 1.3848E-12, 1.3558E-12, 1.3272E-12, 1.2988E-12/
  
         DATA ((DGT  (I,J), I= 801, 900), J=1,1) /
     &   1.2708E-12, 1.2430E-12, 1.2156E-12, 1.1885E-12, 1.1616E-12,
     &   1.1351E-12, 1.1089E-12, 1.0830E-12, 1.0574E-12, 1.0321E-12,
     &   1.0071E-12, 9.8244E-13, 9.5806E-13, 9.3400E-13, 9.1023E-13,
     &   8.8678E-13, 8.6363E-13, 8.4079E-13, 8.1825E-13, 7.9602E-13,
     &   7.7410E-13, 7.5248E-13, 7.3116E-13, 7.1016E-13, 6.8946E-13,
     &   6.6907E-13, 6.4898E-13, 6.2920E-13, 6.0972E-13, 5.9055E-13,
     &   5.7169E-13, 5.5313E-13, 5.3488E-13, 5.1694E-13, 4.9930E-13,
     &   4.8197E-13, 4.6494E-13, 4.4822E-13, 4.3181E-13, 4.1570E-13,
     &   3.9990E-13, 3.8440E-13, 3.6921E-13, 3.5433E-13, 3.3976E-13,
     &   3.2548E-13, 3.1152E-13, 2.9786E-13, 2.8451E-13, 2.7146E-13,
     &   2.5872E-13, 2.4629E-13, 2.3416E-13, 2.2234E-13, 2.1083E-13,
     &   1.9962E-13, 1.8872E-13, 1.7812E-13, 1.6783E-13, 1.5784E-13,
     &   1.4817E-13, 1.3879E-13, 1.2973E-13, 1.2097E-13, 1.1252E-13,
     &   1.0437E-13, 9.6528E-14, 8.8993E-14, 8.1764E-14, 7.4841E-14,
     &   6.8225E-14, 6.1914E-14, 5.5910E-14, 5.0212E-14, 4.4820E-14,
     &   3.9735E-14, 3.4955E-14, 3.0482E-14, 2.6315E-14, 2.2454E-14,
     &   1.8899E-14, 0.0000E+00,-1.8899E-14,-1.7021E-07,-6.8064E-07,
     &  -1.5314E-06,-2.7223E-06,-4.2542E-06,-6.1274E-06,-8.3421E-06,
     &  -1.0899E-05,-1.3798E-05,-1.7041E-05,-2.0628E-05,-2.4560E-05,
     &  -2.8838E-05,-3.3462E-05,-3.8434E-05,-4.3755E-05,-4.9427E-05/
  
         DATA ((DGT  (I,J), I= 901, 979), J=1,1) /
     &  -5.5450E-05,-6.1826E-05,-6.8557E-05,-7.5644E-05,-8.3089E-05,
     &  -9.0893E-05,-9.9059E-05,-1.0759E-04,-1.1623E-04,-1.2548E-04,
     &  -1.3510E-04,-1.4509E-04,-1.5546E-04,-1.6620E-04,-1.7733E-04,
     &  -1.8883E-04,-2.0073E-04,-2.1301E-04,-2.2569E-04,-2.3876E-04,
     &  -2.5223E-04,-2.6611E-04,-2.8039E-04,-2.9508E-04,-3.1019E-04,
     &  -3.2572E-04,-3.4168E-04,-3.5806E-04,-3.7487E-04,-3.9213E-04,
     &  -4.0983E-04,-4.2797E-04,-4.4658E-04,-4.6564E-04,-4.8517E-04,
     &  -5.0518E-04,-5.2566E-04,-5.4664E-04,-5.6810E-04,-5.9007E-04,
     &  -6.1255E-04,-6.3555E-04,-6.5908E-04,-6.8314E-04,-7.0775E-04,
     &  -7.3292E-04,-7.5865E-04,-7.8497E-04,-8.1187E-04,-8.3938E-04,
     &  -8.6750E-04,-8.9625E-04,-9.2565E-04,-9.5571E-04,-9.8644E-04,
     &  -1.0179E-03,-1.0500E-03,-1.0829E-03,-1.1166E-03,-1.1510E-03,
     &  -1.1862E-03,-1.2223E-03,-1.2592E-03,-1.2971E-03,-1.3359E-03,
     &  -1.3757E-03,-1.4166E-03,-1.4585E-03,-1.5016E-03,-1.5471E-03,
     &  -1.5928E-03,-1.6401E-03,-1.6891E-03,-1.7058E-03,-1.7400E-03,
     &  -1.75225092E-03,-1.79342320E-03,-1.79893043E-03,-1.81180031E-03/
  
         DATA ((DGT  (I,J), I=   1, 100), J=2,2) /
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05,
     &   8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05,
     &   8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05,
     &   8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8182E-05, 8.8182E-05,
     &   8.8182E-05, 8.8182E-05, 8.8182E-05, 8.8182E-05, 8.8182E-05,
     &   8.8182E-05, 8.8182E-05, 8.8181E-05, 8.8181E-05, 8.8181E-05,
     &   8.8181E-05, 8.8181E-05, 8.8181E-05, 8.8180E-05, 8.8180E-05,
     &   8.8180E-05, 8.8180E-05, 8.8179E-05, 8.8179E-05, 8.8179E-05,
     &   8.8179E-05, 8.8178E-05, 8.8178E-05, 8.8178E-05, 8.8177E-05,
     &   8.8177E-05, 8.8176E-05, 8.8176E-05, 8.8175E-05, 8.8175E-05,
     &   8.8174E-05, 8.8174E-05, 8.8173E-05, 8.8172E-05, 8.8171E-05,
     &   8.8170E-05, 8.8169E-05, 8.8168E-05, 8.8167E-05, 8.8165E-05,
     &   8.8163E-05, 8.8161E-05, 8.8159E-05, 8.8157E-05, 8.8154E-05,
     &   8.8151E-05, 8.8147E-05, 8.8143E-05, 8.8138E-05, 8.8131E-05,
     &   8.8124E-05, 8.8115E-05, 8.8104E-05, 8.8090E-05, 8.8071E-05,
     &   8.8048E-05, 8.8045E-05, 8.8042E-05, 8.8039E-05, 8.8036E-05,
     &   8.8033E-05, 8.8030E-05, 8.8026E-05, 8.8023E-05, 8.8019E-05/
  
         DATA ((DGT  (I,J), I= 101, 200), J=2,2) /
     &   8.8016E-05, 8.8012E-05, 8.8008E-05, 8.8004E-05, 8.8000E-05,
     &   8.7995E-05, 8.7991E-05, 8.7986E-05, 8.7981E-05, 8.7976E-05,
     &   8.7971E-05, 8.7965E-05, 8.7960E-05, 8.7954E-05, 8.7948E-05,
     &   8.7942E-05, 8.7935E-05, 8.7928E-05, 8.7921E-05, 8.7914E-05,
     &   8.7906E-05, 8.7898E-05, 8.7889E-05, 8.7880E-05, 8.7871E-05,
     &   8.7862E-05, 8.7852E-05, 8.7841E-05, 8.7830E-05, 8.7818E-05,
     &   8.7806E-05, 8.7793E-05, 8.7780E-05, 8.7766E-05, 8.7751E-05,
     &   8.7735E-05, 8.7719E-05, 8.7701E-05, 8.7683E-05, 8.7663E-05,
     &   8.7643E-05, 8.7621E-05, 8.7598E-05, 8.7573E-05, 8.7547E-05,
     &   8.7519E-05, 8.7489E-05, 8.7457E-05, 8.7423E-05, 8.7386E-05,
     &   8.7347E-05, 8.7305E-05, 8.7260E-05, 8.7211E-05, 8.7158E-05,
     &   8.7101E-05, 8.7039E-05, 8.6971E-05, 8.6897E-05, 8.6817E-05,
     &   8.6729E-05, 8.6632E-05, 8.6526E-05, 8.6408E-05, 8.6278E-05,
     &   8.6133E-05, 8.5971E-05, 8.5789E-05, 8.5585E-05, 8.5354E-05,
     &   8.5091E-05, 8.4791E-05, 8.4446E-05, 8.4046E-05, 8.3580E-05,
     &   8.3031E-05, 8.2381E-05, 8.1600E-05, 8.0653E-05, 7.9488E-05,
     &   7.8033E-05, 7.7884E-05, 7.7733E-05, 7.7577E-05, 7.7419E-05,
     &   7.7257E-05, 7.7091E-05, 7.6921E-05, 7.6748E-05, 7.6570E-05,
     &   7.6389E-05, 7.6203E-05, 7.6013E-05, 7.5818E-05, 7.5618E-05,
     &   7.5414E-05, 7.5205E-05, 7.4990E-05, 7.4770E-05, 7.4545E-05/
  
         DATA ((DGT  (I,J), I= 201, 300), J=2,2) /
     &   7.4314E-05, 7.4078E-05, 7.3835E-05, 7.3586E-05, 7.3331E-05,
     &   7.3069E-05, 7.2800E-05, 7.2524E-05, 7.2240E-05, 7.1949E-05,
     &   7.1651E-05, 7.1344E-05, 7.1028E-05, 7.0704E-05, 7.0371E-05,
     &   7.0029E-05, 6.9677E-05, 6.9315E-05, 6.8942E-05, 6.8559E-05,
     &   6.8165E-05, 6.7759E-05, 6.7342E-05, 6.6912E-05, 6.6469E-05,
     &   6.6014E-05, 6.5544E-05, 6.5060E-05, 6.4562E-05, 6.4049E-05,
     &   6.3520E-05, 6.2974E-05, 6.2412E-05, 6.1833E-05, 6.1235E-05,
     &   6.0619E-05, 5.9984E-05, 5.9329E-05, 5.8653E-05, 5.7956E-05,
     &   5.7238E-05, 5.6497E-05, 5.5733E-05, 5.4945E-05, 5.4132E-05,
     &   5.3295E-05, 5.2431E-05, 5.1542E-05, 5.0625E-05, 4.9681E-05,
     &   4.8709E-05, 4.7708E-05, 4.6678E-05, 4.5620E-05, 4.4531E-05,
     &   4.3414E-05, 4.2266E-05, 4.1089E-05, 3.9884E-05, 3.8649E-05,
     &   3.7387E-05, 3.6097E-05, 3.4782E-05, 3.3442E-05, 3.2079E-05,
     &   3.0696E-05, 2.9294E-05, 2.7876E-05, 2.6446E-05, 2.5007E-05,
     &   2.3563E-05, 2.2118E-05, 2.0675E-05, 1.9241E-05, 1.7820E-05,
     &   1.6416E-05, 1.5035E-05, 1.3680E-05, 1.2357E-05, 1.1067E-05,
     &   9.8147E-06, 9.6915E-06, 9.5688E-06, 9.4464E-06, 9.3244E-06,
     &   9.2028E-06, 9.0817E-06, 8.9609E-06, 8.8405E-06, 8.7205E-06,
     &   8.6009E-06, 8.4817E-06, 8.3629E-06, 8.2445E-06, 8.1265E-06,
     &   8.0089E-06, 7.8917E-06, 7.7749E-06, 7.6585E-06, 7.5425E-06/
  
         DATA ((DGT  (I,J), I= 301, 400), J=2,2) /
     &   7.4269E-06, 7.3117E-06, 7.1969E-06, 7.0826E-06, 6.9686E-06,
     &   6.8550E-06, 6.7419E-06, 6.6292E-06, 6.5168E-06, 6.4049E-06,
     &   6.2934E-06, 6.1824E-06, 6.0717E-06, 5.9614E-06, 5.8516E-06,
     &   5.7422E-06, 5.6332E-06, 5.5247E-06, 5.4165E-06, 5.3089E-06,
     &   5.2016E-06, 5.0948E-06, 4.9884E-06, 4.8825E-06, 4.7770E-06,
     &   4.6720E-06, 4.5675E-06, 4.4634E-06, 4.3598E-06, 4.2567E-06,
     &   4.1541E-06, 4.0520E-06, 3.9504E-06, 3.8493E-06, 3.7488E-06,
     &   3.6488E-06, 3.5493E-06, 3.4505E-06, 3.3522E-06, 3.2545E-06,
     &   3.1575E-06, 3.0610E-06, 2.9653E-06, 2.8702E-06, 2.7759E-06,
     &   2.6822E-06, 2.5893E-06, 2.4972E-06, 2.4059E-06, 2.3155E-06,
     &   2.2259E-06, 2.1372E-06, 2.0495E-06, 1.9628E-06, 1.8771E-06,
     &   1.7924E-06, 1.7089E-06, 1.6266E-06, 1.5454E-06, 1.4656E-06,
     &   1.3871E-06, 1.3099E-06, 1.2342E-06, 1.1600E-06, 1.0874E-06,
     &   1.0165E-06, 9.4724E-07, 8.7979E-07, 8.1421E-07, 7.5057E-07,
     &   6.8895E-07, 6.2943E-07, 5.7210E-07, 5.1703E-07, 4.6430E-07,
     &   4.1401E-07, 3.6623E-07, 3.2105E-07, 2.7854E-07, 2.3878E-07,
     &   2.0185E-07, 1.9832E-07, 1.9481E-07, 1.9134E-07, 1.8789E-07,
     &   1.8447E-07, 1.8108E-07, 1.7773E-07, 1.7440E-07, 1.7110E-07,
     &   1.6783E-07, 1.6459E-07, 1.6138E-07, 1.5820E-07, 1.5505E-07,
     &   1.5193E-07, 1.4884E-07, 1.4578E-07, 1.4274E-07, 1.3975E-07/
  
         DATA ((DGT  (I,J), I= 401, 500), J=2,2) /
     &   1.3678E-07, 1.3384E-07, 1.3093E-07, 1.2805E-07, 1.2520E-07,
     &   1.2238E-07, 1.1960E-07, 1.1684E-07, 1.1412E-07, 1.1142E-07,
     &   1.0876E-07, 1.0613E-07, 1.0353E-07, 1.0096E-07, 9.8420E-08,
     &   9.5913E-08, 9.3437E-08, 9.0992E-08, 8.8579E-08, 8.6197E-08,
     &   8.3846E-08, 8.1527E-08, 7.9240E-08, 7.6984E-08, 7.4760E-08,
     &   7.2568E-08, 7.0407E-08, 6.8278E-08, 6.6182E-08, 6.4117E-08,
     &   6.2084E-08, 6.0083E-08, 5.8114E-08, 5.6178E-08, 5.4273E-08,
     &   5.2401E-08, 5.0561E-08, 4.8754E-08, 4.6978E-08, 4.5235E-08,
     &   4.3525E-08, 4.1847E-08, 4.0201E-08, 3.8588E-08, 3.7008E-08,
     &   3.5460E-08, 3.3945E-08, 3.2462E-08, 3.1013E-08, 2.9596E-08,
     &   2.8211E-08, 2.6860E-08, 2.5541E-08, 2.4256E-08, 2.3003E-08,
     &   2.1783E-08, 2.0597E-08, 1.9443E-08, 1.8322E-08, 1.7234E-08,
     &   1.6180E-08, 1.5158E-08, 1.4170E-08, 1.3214E-08, 1.2292E-08,
     &   1.1403E-08, 1.0548E-08, 9.7254E-09, 8.9363E-09, 8.1804E-09,
     &   7.4579E-09, 6.7686E-09, 6.1127E-09, 5.4902E-09, 4.9010E-09,
     &   4.3452E-09, 3.8227E-09, 3.3337E-09, 2.8781E-09, 2.4560E-09,
     &   2.0672E-09, 2.0302E-09, 1.9935E-09, 1.9571E-09, 1.9211E-09,
     &   1.8854E-09, 1.8501E-09, 1.8150E-09, 1.7803E-09, 1.7460E-09,
     &   1.7120E-09, 1.6783E-09, 1.6449E-09, 1.6119E-09, 1.5792E-09,
     &   1.5469E-09, 1.5148E-09, 1.4832E-09, 1.4518E-09, 1.4208E-09/
  
         DATA ((DGT  (I,J), I= 501, 600), J=2,2) /
     &   1.3901E-09, 1.3598E-09, 1.3298E-09, 1.3001E-09, 1.2708E-09,
     &   1.2418E-09, 1.2131E-09, 1.1848E-09, 1.1568E-09, 1.1291E-09,
     &   1.1018E-09, 1.0748E-09, 1.0481E-09, 1.0218E-09, 9.9578E-10,
     &   9.7013E-10, 9.4480E-10, 9.1982E-10, 8.9517E-10, 8.7085E-10,
     &   8.4686E-10, 8.2322E-10, 7.9990E-10, 7.7692E-10, 7.5428E-10,
     &   7.3197E-10, 7.1000E-10, 6.8836E-10, 6.6705E-10, 6.4608E-10,
     &   6.2545E-10, 6.0515E-10, 5.8518E-10, 5.6555E-10, 5.4626E-10,
     &   5.2729E-10, 5.0867E-10, 4.9038E-10, 4.7242E-10, 4.5480E-10,
     &   4.3751E-10, 4.2056E-10, 4.0394E-10, 3.8766E-10, 3.7172E-10,
     &   3.5610E-10, 3.4083E-10, 3.2588E-10, 3.1128E-10, 2.9700E-10,
     &   2.8307E-10, 2.6946E-10, 2.5619E-10, 2.4326E-10, 2.3066E-10,
     &   2.1840E-10, 2.0647E-10, 1.9488E-10, 1.8362E-10, 1.7270E-10,
     &   1.6211E-10, 1.5185E-10, 1.4194E-10, 1.3235E-10, 1.2310E-10,
     &   1.1419E-10, 1.0561E-10, 9.7367E-11, 8.9458E-11, 8.1884E-11,
     &   7.4645E-11, 6.7741E-11, 6.1172E-11, 5.4938E-11, 4.9039E-11,
     &   4.3474E-11, 3.8245E-11, 3.3351E-11, 2.8791E-11, 2.4567E-11,
     &   2.0677E-11, 2.0307E-11, 1.9940E-11, 1.9576E-11, 1.9215E-11,
     &   1.8858E-11, 1.8505E-11, 1.8154E-11, 1.7807E-11, 1.7463E-11,
     &   1.7123E-11, 1.6786E-11, 1.6452E-11, 1.6122E-11, 1.5795E-11,
     &   1.5471E-11, 1.5151E-11, 1.4834E-11, 1.4521E-11, 1.4210E-11/
  
         DATA ((DGT  (I,J), I= 601, 700), J=2,2) /
     &   1.3904E-11, 1.3600E-11, 1.3300E-11, 1.3003E-11, 1.2710E-11,
     &   1.2419E-11, 1.2133E-11, 1.1849E-11, 1.1569E-11, 1.1292E-11,
     &   1.1019E-11, 1.0749E-11, 1.0482E-11, 1.0219E-11, 9.9590E-12,
     &   9.7024E-12, 9.4491E-12, 9.1992E-12, 8.9526E-12, 8.7094E-12,
     &   8.4695E-12, 8.2330E-12, 7.9998E-12, 7.7700E-12, 7.5435E-12,
     &   7.3204E-12, 7.1006E-12, 6.8841E-12, 6.6711E-12, 6.4613E-12,
     &   6.2549E-12, 6.0519E-12, 5.8522E-12, 5.6559E-12, 5.4629E-12,
     &   5.2733E-12, 5.0870E-12, 4.9041E-12, 4.7245E-12, 4.5482E-12,
     &   4.3754E-12, 4.2058E-12, 4.0396E-12, 3.8768E-12, 3.7173E-12,
     &   3.5612E-12, 3.4084E-12, 3.2590E-12, 3.1129E-12, 2.9701E-12,
     &   2.8308E-12, 2.6947E-12, 2.5620E-12, 2.4327E-12, 2.3067E-12,
     &   2.1841E-12, 2.0648E-12, 1.9488E-12, 1.8362E-12, 1.7270E-12,
     &   1.6211E-12, 1.5186E-12, 1.4194E-12, 1.3235E-12, 1.2311E-12,
     &   1.1419E-12, 1.0561E-12, 9.7368E-13, 8.9459E-13, 8.1885E-13,
     &   7.4646E-13, 6.7742E-13, 6.1172E-13, 5.4938E-13, 4.9039E-13,
     &   4.3474E-13, 3.8245E-13, 3.3351E-13, 2.8791E-13, 2.4567E-13,
     &   2.0678E-13, 2.0307E-13, 1.9940E-13, 1.9576E-13, 1.9216E-13,
     &   1.8858E-13, 1.8505E-13, 1.8154E-13, 1.7807E-13, 1.7463E-13,
     &   1.7123E-13, 1.6786E-13, 1.6452E-13, 1.6122E-13, 1.5795E-13,
     &   1.5471E-13, 1.5151E-13, 1.4834E-13, 1.4521E-13, 1.4210E-13/
  
         DATA ((DGT  (I,J), I= 701, 800), J=2,2) /
     &   1.3904E-13, 1.3600E-13, 1.3300E-13, 1.3003E-13, 1.2710E-13,
     &   1.2419E-13, 1.2133E-13, 1.1849E-13, 1.1569E-13, 1.1292E-13,
     &   1.1019E-13, 1.0749E-13, 1.0482E-13, 1.0219E-13, 9.9590E-14,
     &   9.7024E-14, 9.4491E-14, 9.1992E-14, 8.9526E-14, 8.7094E-14,
     &   8.4695E-14, 8.2330E-14, 7.9998E-14, 7.7700E-14, 7.5435E-14,
     &   7.3204E-14, 7.1006E-14, 6.8841E-14, 6.6711E-14, 6.4613E-14,
     &   6.2549E-14, 6.0519E-14, 5.8522E-14, 5.6559E-14, 5.4629E-14,
     &   5.2733E-14, 5.0870E-14, 4.9041E-14, 4.7245E-14, 4.5482E-14,
     &   4.3754E-14, 4.2058E-14, 4.0396E-14, 3.8768E-14, 3.7173E-14,
     &   3.5612E-14, 3.4084E-14, 3.2590E-14, 3.1129E-14, 2.9701E-14,
     &   2.8308E-14, 2.6947E-14, 2.5620E-14, 2.4327E-14, 2.3067E-14,
     &   2.1841E-14, 2.0648E-14, 1.9488E-14, 1.8362E-14, 1.7270E-14,
     &   1.6211E-14, 1.5186E-14, 1.4194E-14, 1.3235E-14, 1.2311E-14,
     &   1.1419E-14, 1.0561E-14, 9.7368E-15, 8.9459E-15, 8.1885E-15,
     &   7.4646E-15, 6.7742E-15, 6.1172E-15, 5.4938E-15, 4.9039E-15,
     &   4.3474E-15, 3.8245E-15, 3.3351E-15, 2.8791E-15, 2.4567E-15,
     &   2.0678E-15, 2.0307E-15, 1.9940E-15, 1.9576E-15, 1.9216E-15,
     &   1.8858E-15, 1.8505E-15, 1.8154E-15, 1.7807E-15, 1.7463E-15,
     &   1.7123E-15, 1.6786E-15, 1.6452E-15, 1.6122E-15, 1.5795E-15,
     &   1.5471E-15, 1.5151E-15, 1.4834E-15, 1.4521E-15, 1.4210E-15/
  
         DATA ((DGT  (I,J), I= 801, 900), J=2,2) /
     &   1.3904E-15, 1.3600E-15, 1.3300E-15, 1.3003E-15, 1.2710E-15,
     &   1.2419E-15, 1.2133E-15, 1.1849E-15, 1.1569E-15, 1.1292E-15,
     &   1.1019E-15, 1.0749E-15, 1.0482E-15, 1.0219E-15, 9.9590E-16,
     &   9.7024E-16, 9.4491E-16, 9.1992E-16, 8.9526E-16, 8.7094E-16,
     &   8.4695E-16, 8.2330E-16, 7.9998E-16, 7.7700E-16, 7.5435E-16,
     &   7.3204E-16, 7.1006E-16, 6.8841E-16, 6.6711E-16, 6.4613E-16,
     &   6.2549E-16, 6.0519E-16, 5.8522E-16, 5.6559E-16, 5.4629E-16,
     &   5.2733E-16, 5.0870E-16, 4.9041E-16, 4.7245E-16, 4.5482E-16,
     &   4.3754E-16, 4.2058E-16, 4.0396E-16, 3.8768E-16, 3.7173E-16,
     &   3.5612E-16, 3.4084E-16, 3.2590E-16, 3.1129E-16, 2.9701E-16,
     &   2.8308E-16, 2.6947E-16, 2.5620E-16, 2.4327E-16, 2.3067E-16,
     &   2.1841E-16, 2.0648E-16, 1.9488E-16, 1.8362E-16, 1.7270E-16,
     &   1.6211E-16, 1.5186E-16, 1.4194E-16, 1.3235E-16, 1.2311E-16,
     &   1.1419E-16, 1.0561E-16, 9.7368E-17, 8.9459E-17, 8.1885E-17,
     &   7.4646E-17, 6.7742E-17, 6.1172E-17, 5.4938E-17, 4.9039E-17,
     &   4.3474E-17, 3.8245E-17, 3.3351E-17, 2.8791E-17, 2.4567E-17,
     &   2.0678E-17, 0.0000E+00, 2.0678E-17, 1.8623E-10, 7.4471E-10,
     &   1.6756E-09, 2.9786E-09, 4.6551E-09, 6.7049E-09, 9.1288E-09,
     &   1.1927E-08, 1.5101E-08, 1.8652E-08, 2.2579E-08, 2.6885E-08,
     &   3.1571E-08, 3.6637E-08, 4.2086E-08, 4.7918E-08, 5.4136E-08/
  
         DATA ((DGT  (I,J), I= 901, 979), J=2,2) /
     &   6.0741E-08, 6.7735E-08, 7.5120E-08, 8.2899E-08, 9.1072E-08,
     &   9.9644E-08, 1.0862E-07, 1.1799E-07, 1.2777E-07, 1.3796E-07,
     &   1.4856E-07, 1.5958E-07, 1.7102E-07, 1.8288E-07, 1.9516E-07,
     &   2.0787E-07, 2.2102E-07, 2.3461E-07, 2.4864E-07, 2.6312E-07,
     &   2.7805E-07, 2.9344E-07, 3.0930E-07, 3.2562E-07, 3.4242E-07,
     &   3.5970E-07, 3.7748E-07, 3.9574E-07, 4.1451E-07, 4.3379E-07,
     &   4.5359E-07, 4.7392E-07, 4.9478E-07, 5.1619E-07, 5.3815E-07,
     &   5.6068E-07, 5.8378E-07, 6.0748E-07, 6.3177E-07, 6.5668E-07,
     &   6.8221E-07, 7.0838E-07, 7.3521E-07, 7.6271E-07, 7.9089E-07,
     &   8.1979E-07, 8.4941E-07, 8.7978E-07, 9.1092E-07, 9.4285E-07,
     &   9.7560E-07, 1.0092E-06, 1.0437E-06, 1.0790E-06, 1.1154E-06,
     &   1.1526E-06, 1.1910E-06, 1.2304E-06, 1.2708E-06, 1.3125E-06,
     &   1.3554E-06, 1.3996E-06, 1.4452E-06, 1.4922E-06, 1.5408E-06,
     &   1.5911E-06, 1.6431E-06, 1.6971E-06, 1.7532E-06, 1.8116E-06,
     &   1.8726E-06, 1.9365E-06, 2.0036E-06, 2.0267E-06, 2.0744E-06,
     &   2.09154496E-06, 2.14965468E-06, 2.15745443E-06, 2.17586566E-06/
  
         DATA ((DGT  (I,J), I=   1, 100), J=3,3) /
     &   2.3094E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3092E-04, 2.3092E-04, 2.3092E-04, 2.3092E-04, 2.3092E-04,
     &   2.3092E-04, 2.3092E-04, 2.3092E-04, 2.3091E-04, 2.3091E-04,
     &   2.3091E-04, 2.3091E-04, 2.3091E-04, 2.3091E-04, 2.3091E-04,
     &   2.3090E-04, 2.3090E-04, 2.3090E-04, 2.3090E-04, 2.3090E-04,
     &   2.3090E-04, 2.3089E-04, 2.3089E-04, 2.3089E-04, 2.3089E-04,
     &   2.3089E-04, 2.3089E-04, 2.3088E-04, 2.3088E-04, 2.3088E-04,
     &   2.3088E-04, 2.3087E-04, 2.3087E-04, 2.3087E-04, 2.3087E-04,
     &   2.3087E-04, 2.3086E-04, 2.3086E-04, 2.3086E-04, 2.3085E-04,
     &   2.3085E-04, 2.3085E-04, 2.3085E-04, 2.3084E-04, 2.3084E-04,
     &   2.3083E-04, 2.3083E-04, 2.3083E-04, 2.3082E-04, 2.3082E-04,
     &   2.3081E-04, 2.3081E-04, 2.3080E-04, 2.3080E-04, 2.3079E-04,
     &   2.3079E-04, 2.3078E-04, 2.3078E-04, 2.3077E-04, 2.3076E-04,
     &   2.3075E-04, 2.3074E-04, 2.3074E-04, 2.3073E-04, 2.3071E-04,
     &   2.3070E-04, 2.3069E-04, 2.3068E-04, 2.3066E-04, 2.3064E-04,
     &   2.3062E-04, 2.3060E-04, 2.3057E-04, 2.3054E-04, 2.3051E-04,
     &   2.3047E-04, 2.3042E-04, 2.3036E-04, 2.3029E-04, 2.3020E-04,
     &   2.3008E-04, 2.3006E-04, 2.3005E-04, 2.3004E-04, 2.3002E-04,
     &   2.3000E-04, 2.2999E-04, 2.2997E-04, 2.2996E-04, 2.2994E-04/
  
         DATA ((DGT  (I,J), I= 101, 200), J=3,3) /
     &   2.2992E-04, 2.2990E-04, 2.2988E-04, 2.2986E-04, 2.2984E-04,
     &   2.2982E-04, 2.2980E-04, 2.2978E-04, 2.2976E-04, 2.2973E-04,
     &   2.2971E-04, 2.2968E-04, 2.2966E-04, 2.2963E-04, 2.2960E-04,
     &   2.2957E-04, 2.2954E-04, 2.2951E-04, 2.2947E-04, 2.2944E-04,
     &   2.2940E-04, 2.2937E-04, 2.2933E-04, 2.2929E-04, 2.2924E-04,
     &   2.2920E-04, 2.2915E-04, 2.2910E-04, 2.2905E-04, 2.2900E-04,
     &   2.2894E-04, 2.2889E-04, 2.2883E-04, 2.2876E-04, 2.2869E-04,
     &   2.2862E-04, 2.2855E-04, 2.2847E-04, 2.2839E-04, 2.2830E-04,
     &   2.2821E-04, 2.2811E-04, 2.2801E-04, 2.2790E-04, 2.2778E-04,
     &   2.2765E-04, 2.2752E-04, 2.2738E-04, 2.2723E-04, 2.2707E-04,
     &   2.2690E-04, 2.2672E-04, 2.2652E-04, 2.2631E-04, 2.2608E-04,
     &   2.2584E-04, 2.2557E-04, 2.2528E-04, 2.2497E-04, 2.2463E-04,
     &   2.2426E-04, 2.2386E-04, 2.2342E-04, 2.2293E-04, 2.2240E-04,
     &   2.2181E-04, 2.2116E-04, 2.2043E-04, 2.1963E-04, 2.1873E-04,
     &   2.1772E-04, 2.1658E-04, 2.1529E-04, 2.1382E-04, 2.1214E-04,
     &   2.1021E-04, 2.0798E-04, 2.0538E-04, 2.0233E-04, 1.9871E-04,
     &   1.9436E-04, 1.9393E-04, 1.9349E-04, 1.9304E-04, 1.9258E-04,
     &   1.9212E-04, 1.9165E-04, 1.9117E-04, 1.9068E-04, 1.9018E-04,
     &   1.8967E-04, 1.8915E-04, 1.8862E-04, 1.8808E-04, 1.8754E-04,
     &   1.8698E-04, 1.8641E-04, 1.8583E-04, 1.8524E-04, 1.8464E-04/
  
         DATA ((DGT  (I,J), I= 201, 300), J=3,3) /
     &   1.8402E-04, 1.8339E-04, 1.8275E-04, 1.8210E-04, 1.8144E-04,
     &   1.8076E-04, 1.8006E-04, 1.7936E-04, 1.7864E-04, 1.7790E-04,
     &   1.7715E-04, 1.7638E-04, 1.7560E-04, 1.7479E-04, 1.7398E-04,
     &   1.7314E-04, 1.7229E-04, 1.7142E-04, 1.7053E-04, 1.6962E-04,
     &   1.6869E-04, 1.6774E-04, 1.6677E-04, 1.6577E-04, 1.6476E-04,
     &   1.6372E-04, 1.6266E-04, 1.6158E-04, 1.6047E-04, 1.5934E-04,
     &   1.5818E-04, 1.5699E-04, 1.5578E-04, 1.5454E-04, 1.5328E-04,
     &   1.5198E-04, 1.5065E-04, 1.4930E-04, 1.4791E-04, 1.4649E-04,
     &   1.4505E-04, 1.4356E-04, 1.4205E-04, 1.4050E-04, 1.3891E-04,
     &   1.3729E-04, 1.3563E-04, 1.3393E-04, 1.3220E-04, 1.3042E-04,
     &   1.2860E-04, 1.2675E-04, 1.2485E-04, 1.2290E-04, 1.2091E-04,
     &   1.1887E-04, 1.1679E-04, 1.1465E-04, 1.1246E-04, 1.1021E-04,
     &   1.0791E-04, 1.0555E-04, 1.0312E-04, 1.0063E-04, 9.8064E-05,
     &   9.5425E-05, 9.2706E-05, 8.9902E-05, 8.7008E-05, 8.4018E-05,
     &   8.0924E-05, 7.7722E-05, 7.4403E-05, 7.0962E-05, 6.7392E-05,
     &   6.3687E-05, 5.9842E-05, 5.5855E-05, 5.1722E-05, 4.7446E-05,
     &   4.3031E-05, 4.2582E-05, 4.2132E-05, 4.1681E-05, 4.1229E-05,
     &   4.0775E-05, 4.0320E-05, 3.9863E-05, 3.9406E-05, 3.8947E-05,
     &   3.8488E-05, 3.8027E-05, 3.7565E-05, 3.7102E-05, 3.6638E-05,
     &   3.6172E-05, 3.5706E-05, 3.5239E-05, 3.4771E-05, 3.4302E-05/
  
         DATA ((DGT  (I,J), I= 301, 400), J=3,3) /
     &   3.3832E-05, 3.3361E-05, 3.2890E-05, 3.2417E-05, 3.1944E-05,
     &   3.1470E-05, 3.0995E-05, 3.0520E-05, 3.0044E-05, 2.9568E-05,
     &   2.9091E-05, 2.8613E-05, 2.8135E-05, 2.7657E-05, 2.7179E-05,
     &   2.6700E-05, 2.6221E-05, 2.5742E-05, 2.5263E-05, 2.4783E-05,
     &   2.4304E-05, 2.3825E-05, 2.3347E-05, 2.2868E-05, 2.2390E-05,
     &   2.1912E-05, 2.1435E-05, 2.0959E-05, 2.0483E-05, 2.0008E-05,
     &   1.9534E-05, 1.9061E-05, 1.8589E-05, 1.8118E-05, 1.7649E-05,
     &   1.7182E-05, 1.6715E-05, 1.6251E-05, 1.5789E-05, 1.5329E-05,
     &   1.4870E-05, 1.4415E-05, 1.3962E-05, 1.3511E-05, 1.3064E-05,
     &   1.2619E-05, 1.2178E-05, 1.1740E-05, 1.1306E-05, 1.0875E-05,
     &   1.0449E-05, 1.0027E-05, 9.6099E-06, 9.1973E-06, 8.7897E-06,
     &   8.3874E-06, 7.9906E-06, 7.5996E-06, 7.2147E-06, 6.8361E-06,
     &   6.4643E-06, 6.0993E-06, 5.7417E-06, 5.3916E-06, 5.0494E-06,
     &   4.7154E-06, 4.3900E-06, 4.0735E-06, 3.7662E-06, 3.4685E-06,
     &   3.1806E-06, 2.9031E-06, 2.6362E-06, 2.3802E-06, 2.1356E-06,
     &   1.9026E-06, 1.6816E-06, 1.4729E-06, 1.2768E-06, 1.0938E-06,
     &   9.2397E-07, 9.0773E-07, 8.9162E-07, 8.7566E-07, 8.5982E-07,
     &   8.4413E-07, 8.2857E-07, 8.1315E-07, 7.9787E-07, 7.8272E-07,
     &   7.6772E-07, 7.5285E-07, 7.3812E-07, 7.2352E-07, 7.0907E-07,
     &   6.9476E-07, 6.8058E-07, 6.6655E-07, 6.5266E-07, 6.3890E-07/
  
         DATA ((DGT  (I,J), I= 401, 500), J=3,3) /
     &   6.2529E-07, 6.1182E-07, 5.9849E-07, 5.8530E-07, 5.7225E-07,
     &   5.5934E-07, 5.4658E-07, 5.3395E-07, 5.2147E-07, 5.0914E-07,
     &   4.9694E-07, 4.8489E-07, 4.7298E-07, 4.6122E-07, 4.4960E-07,
     &   4.3812E-07, 4.2679E-07, 4.1560E-07, 4.0456E-07, 3.9366E-07,
     &   3.8291E-07, 3.7230E-07, 3.6184E-07, 3.5152E-07, 3.4135E-07,
     &   3.3133E-07, 3.2145E-07, 3.1172E-07, 3.0213E-07, 2.9269E-07,
     &   2.8340E-07, 2.7426E-07, 2.6526E-07, 2.5641E-07, 2.4771E-07,
     &   2.3915E-07, 2.3075E-07, 2.2249E-07, 2.1438E-07, 2.0642E-07,
     &   1.9861E-07, 1.9094E-07, 1.8343E-07, 1.7606E-07, 1.6885E-07,
     &   1.6178E-07, 1.5486E-07, 1.4809E-07, 1.4148E-07, 1.3501E-07,
     &   1.2869E-07, 1.2252E-07, 1.1650E-07, 1.1064E-07, 1.0492E-07,
     &   9.9354E-08, 9.3939E-08, 8.8675E-08, 8.3561E-08, 7.8598E-08,
     &   7.3787E-08, 6.9127E-08, 6.4618E-08, 6.0261E-08, 5.6055E-08,
     &   5.2000E-08, 4.8098E-08, 4.4347E-08, 4.0748E-08, 3.7301E-08,
     &   3.4005E-08, 3.0862E-08, 2.7871E-08, 2.5032E-08, 2.2346E-08,
     &   1.9811E-08, 1.7429E-08, 1.5199E-08, 1.3122E-08, 1.1197E-08,
     &   9.4249E-09, 9.2560E-09, 9.0887E-09, 8.9229E-09, 8.7586E-09,
     &   8.5959E-09, 8.4347E-09, 8.2750E-09, 8.1168E-09, 7.9601E-09,
     &   7.8050E-09, 7.6514E-09, 7.4994E-09, 7.3488E-09, 7.1998E-09,
     &   7.0523E-09, 6.9063E-09, 6.7619E-09, 6.6190E-09, 6.4776E-09/
  
         DATA ((DGT  (I,J), I= 501, 600), J=3,3) /
     &   6.3377E-09, 6.1994E-09, 6.0626E-09, 5.9273E-09, 5.7935E-09,
     &   5.6613E-09, 5.5306E-09, 5.4014E-09, 5.2737E-09, 5.1476E-09,
     &   5.0230E-09, 4.8999E-09, 4.7784E-09, 4.6583E-09, 4.5398E-09,
     &   4.4229E-09, 4.3074E-09, 4.1935E-09, 4.0811E-09, 3.9702E-09,
     &   3.8609E-09, 3.7531E-09, 3.6468E-09, 3.5420E-09, 3.4388E-09,
     &   3.3371E-09, 3.2369E-09, 3.1382E-09, 3.0411E-09, 2.9455E-09,
     &   2.8514E-09, 2.7589E-09, 2.6679E-09, 2.5784E-09, 2.4904E-09,
     &   2.4039E-09, 2.3190E-09, 2.2356E-09, 2.1538E-09, 2.0734E-09,
     &   1.9946E-09, 1.9173E-09, 1.8416E-09, 1.7674E-09, 1.6947E-09,
     &   1.6235E-09, 1.5538E-09, 1.4857E-09, 1.4191E-09, 1.3540E-09,
     &   1.2905E-09, 1.2285E-09, 1.1680E-09, 1.1090E-09, 1.0516E-09,
     &   9.9569E-10, 9.4131E-10, 8.8845E-10, 8.3712E-10, 7.8732E-10,
     &   7.3905E-10, 6.9230E-10, 6.4709E-10, 6.0339E-10, 5.6123E-10,
     &   5.2059E-10, 4.8148E-10, 4.4390E-10, 4.0784E-10, 3.7331E-10,
     &   3.4031E-10, 3.0883E-10, 2.7888E-10, 2.5046E-10, 2.2357E-10,
     &   1.9820E-10, 1.7436E-10, 1.5204E-10, 1.3126E-10, 1.1200E-10,
     &   9.4268E-11, 9.2579E-11, 9.0905E-11, 8.9246E-11, 8.7603E-11,
     &   8.5975E-11, 8.4362E-11, 8.2764E-11, 8.1182E-11, 7.9615E-11,
     &   7.8063E-11, 7.6527E-11, 7.5006E-11, 7.3500E-11, 7.2009E-11,
     &   7.0534E-11, 6.9074E-11, 6.7629E-11, 6.6199E-11, 6.4785E-11/
  
         DATA ((DGT  (I,J), I= 601, 700), J=3,3) /
     &   6.3386E-11, 6.2002E-11, 6.0634E-11, 5.9280E-11, 5.7942E-11,
     &   5.6620E-11, 5.5312E-11, 5.4020E-11, 5.2743E-11, 5.1482E-11,
     &   5.0235E-11, 4.9004E-11, 4.7789E-11, 4.6588E-11, 4.5403E-11,
     &   4.4233E-11, 4.3078E-11, 4.1939E-11, 4.0815E-11, 3.9706E-11,
     &   3.8612E-11, 3.7534E-11, 3.6471E-11, 3.5423E-11, 3.4391E-11,
     &   3.3373E-11, 3.2371E-11, 3.1385E-11, 3.0413E-11, 2.9457E-11,
     &   2.8516E-11, 2.7591E-11, 2.6680E-11, 2.5785E-11, 2.4905E-11,
     &   2.4041E-11, 2.3191E-11, 2.2357E-11, 2.1539E-11, 2.0735E-11,
     &   1.9947E-11, 1.9174E-11, 1.8417E-11, 1.7674E-11, 1.6947E-11,
     &   1.6235E-11, 1.5539E-11, 1.4858E-11, 1.4192E-11, 1.3541E-11,
     &   1.2905E-11, 1.2285E-11, 1.1680E-11, 1.1091E-11, 1.0516E-11,
     &   9.9571E-12, 9.4132E-12, 8.8847E-12, 8.3714E-12, 7.8734E-12,
     &   7.3906E-12, 6.9232E-12, 6.4709E-12, 6.0340E-12, 5.6124E-12,
     &   5.2060E-12, 4.8148E-12, 4.4390E-12, 4.0784E-12, 3.7331E-12,
     &   3.4031E-12, 3.0883E-12, 2.7888E-12, 2.5046E-12, 2.2357E-12,
     &   1.9820E-12, 1.7436E-12, 1.5205E-12, 1.3126E-12, 1.1200E-12,
     &   9.4268E-13, 9.2579E-13, 9.0905E-13, 8.9246E-13, 8.7603E-13,
     &   8.5975E-13, 8.4362E-13, 8.2765E-13, 8.1182E-13, 7.9615E-13,
     &   7.8064E-13, 7.6527E-13, 7.5006E-13, 7.3500E-13, 7.2009E-13,
     &   7.0534E-13, 6.9074E-13, 6.7629E-13, 6.6199E-13, 6.4785E-13/
  
         DATA ((DGT  (I,J), I= 701, 800), J=3,3) /
     &   6.3386E-13, 6.2002E-13, 6.0634E-13, 5.9280E-13, 5.7943E-13,
     &   5.6620E-13, 5.5312E-13, 5.4020E-13, 5.2743E-13, 5.1482E-13,
     &   5.0236E-13, 4.9004E-13, 4.7789E-13, 4.6588E-13, 4.5403E-13,
     &   4.4233E-13, 4.3078E-13, 4.1939E-13, 4.0815E-13, 3.9706E-13,
     &   3.8612E-13, 3.7534E-13, 3.6471E-13, 3.5423E-13, 3.4391E-13,
     &   3.3373E-13, 3.2371E-13, 3.1385E-13, 3.0413E-13, 2.9457E-13,
     &   2.8516E-13, 2.7591E-13, 2.6680E-13, 2.5785E-13, 2.4905E-13,
     &   2.4041E-13, 2.3191E-13, 2.2358E-13, 2.1539E-13, 2.0735E-13,
     &   1.9947E-13, 1.9174E-13, 1.8417E-13, 1.7674E-13, 1.6947E-13,
     &   1.6235E-13, 1.5539E-13, 1.4858E-13, 1.4192E-13, 1.3541E-13,
     &   1.2905E-13, 1.2285E-13, 1.1680E-13, 1.1091E-13, 1.0516E-13,
     &   9.9571E-14, 9.4132E-14, 8.8847E-14, 8.3714E-14, 7.8734E-14,
     &   7.3906E-14, 6.9232E-14, 6.4709E-14, 6.0340E-14, 5.6124E-14,
     &   5.2060E-14, 4.8148E-14, 4.4390E-14, 4.0784E-14, 3.7331E-14,
     &   3.4031E-14, 3.0883E-14, 2.7888E-14, 2.5046E-14, 2.2357E-14,
     &   1.9820E-14, 1.7436E-14, 1.5205E-14, 1.3126E-14, 1.1200E-14,
     &   9.4268E-15, 9.2579E-15, 9.0905E-15, 8.9246E-15, 8.7603E-15,
     &   8.5975E-15, 8.4362E-15, 8.2765E-15, 8.1182E-15, 7.9615E-15,
     &   7.8064E-15, 7.6527E-15, 7.5006E-15, 7.3500E-15, 7.2009E-15,
     &   7.0534E-15, 6.9074E-15, 6.7629E-15, 6.6199E-15, 6.4785E-15/
  
         DATA ((DGT  (I,J), I= 801, 900), J=3,3) /
     &   6.3386E-15, 6.2002E-15, 6.0634E-15, 5.9280E-15, 5.7943E-15,
     &   5.6620E-15, 5.5312E-15, 5.4020E-15, 5.2743E-15, 5.1482E-15,
     &   5.0236E-15, 4.9004E-15, 4.7789E-15, 4.6588E-15, 4.5403E-15,
     &   4.4233E-15, 4.3078E-15, 4.1939E-15, 4.0815E-15, 3.9706E-15,
     &   3.8612E-15, 3.7534E-15, 3.6471E-15, 3.5423E-15, 3.4391E-15,
     &   3.3373E-15, 3.2371E-15, 3.1385E-15, 3.0413E-15, 2.9457E-15,
     &   2.8516E-15, 2.7591E-15, 2.6680E-15, 2.5785E-15, 2.4905E-15,
     &   2.4041E-15, 2.3191E-15, 2.2357E-15, 2.1539E-15, 2.0735E-15,
     &   1.9947E-15, 1.9174E-15, 1.8417E-15, 1.7674E-15, 1.6947E-15,
     &   1.6235E-15, 1.5539E-15, 1.4858E-15, 1.4192E-15, 1.3541E-15,
     &   1.2905E-15, 1.2285E-15, 1.1680E-15, 1.1091E-15, 1.0516E-15,
     &   9.9571E-16, 9.4132E-16, 8.8847E-16, 8.3714E-16, 7.8734E-16,
     &   7.3906E-16, 6.9232E-16, 6.4709E-16, 6.0340E-16, 5.6124E-16,
     &   5.2060E-16, 4.8148E-16, 4.4390E-16, 4.0784E-16, 3.7331E-16,
     &   3.4031E-16, 3.0883E-16, 2.7888E-16, 2.5046E-16, 2.2357E-16,
     &   1.9820E-16, 1.7436E-16, 1.5205E-16, 1.3126E-16, 1.1200E-16,
     &   9.4268E-17, 0.0000E+00, 9.4268E-17, 8.4900E-10, 3.3950E-09,
     &   7.6387E-09, 1.3579E-08, 2.1220E-08, 3.0563E-08, 4.1610E-08,
     &   5.4363E-08, 6.8825E-08, 8.5000E-08, 1.0289E-07, 1.2250E-07,
     &   1.4384E-07, 1.6690E-07, 1.9170E-07, 2.1824E-07, 2.4652E-07/
  
         DATA ((DGT  (I,J), I= 901, 979), J=3,3) /
     &   2.7656E-07, 3.0836E-07, 3.4193E-07, 3.7727E-07, 4.1440E-07,
     &   4.5331E-07, 4.9403E-07, 5.3657E-07, 5.8092E-07, 6.2711E-07,
     &   6.7515E-07, 7.2504E-07, 7.7680E-07, 8.3044E-07, 8.8598E-07,
     &   9.4343E-07, 1.0028E-06, 1.0641E-06, 1.1274E-06, 1.1927E-06,
     &   1.2599E-06, 1.3292E-06, 1.4005E-06, 1.4738E-06, 1.5492E-06,
     &   1.6267E-06, 1.7064E-06, 1.7882E-06, 1.8721E-06, 1.9583E-06,
     &   2.0466E-06, 2.1372E-06, 2.2302E-06, 2.3254E-06, 2.4230E-06,
     &   2.5229E-06, 2.6253E-06, 2.7301E-06, 2.8374E-06, 2.9473E-06,
     &   3.0598E-06, 3.1748E-06, 3.2926E-06, 3.4131E-06, 3.5364E-06,
     &   3.6625E-06, 3.7915E-06, 3.9235E-06, 4.0585E-06, 4.1966E-06,
     &   4.3379E-06, 4.4825E-06, 4.6304E-06, 4.7817E-06, 4.9366E-06,
     &   5.0951E-06, 5.2574E-06, 5.4235E-06, 5.5936E-06, 5.7679E-06,
     &   5.9465E-06, 6.1296E-06, 6.3173E-06, 6.5098E-06, 6.7074E-06,
     &   6.9103E-06, 7.1188E-06, 7.3331E-06, 7.5536E-06, 7.7807E-06,
     &   8.0148E-06, 8.2564E-06, 8.5060E-06, 8.5911E-06, 8.7643E-06,
     &   8.82586563E-06, 9.03197622E-06, 9.05929956E-06, 9.12345572E-06/
       save
       RETURN
       END

c      ++++ dalhadthigh23 ++++  

c update 09/25/25 
       subroutine dalhad_spacelike1h25
       IMPLICIT NONE
       INTEGER NC,I,J
       PARAMETER(NC=200)
       REAL XXX(NC),YGG(NC,3),Y3G(NC,3)
       COMMON /DATH25/XXX,YGG,Y3G
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 22:59:02 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1,-2.0000E+04,-1.0000E+03, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
       DATA  (XXX  (I), I=   1, 100) /
     &  -2.0000E+04,-1.9701E+04,-1.9407E+04,-1.9117E+04,-1.8831E+04,
     &  -1.8550E+04,-1.8273E+04,-1.8000E+04,-1.7731E+04,-1.7466E+04,
     &  -1.7205E+04,-1.6948E+04,-1.6695E+04,-1.6445E+04,-1.6199E+04,
     &  -1.5957E+04,-1.5719E+04,-1.5484E+04,-1.5253E+04,-1.5025E+04,
     &  -1.4800E+04,-1.4579E+04,-1.4361E+04,-1.4147E+04,-1.3935E+04,
     &  -1.3727E+04,-1.3522E+04,-1.3320E+04,-1.3121E+04,-1.2925E+04,
     &  -1.2732E+04,-1.2542E+04,-1.2354E+04,-1.2170E+04,-1.1988E+04,
     &  -1.1809E+04,-1.1632E+04,-1.1459E+04,-1.1287E+04,-1.1119E+04,
     &  -1.0953E+04,-1.0789E+04,-1.0628E+04,-1.0469E+04,-1.0313E+04,
     &  -1.0158E+04,-1.0007E+04,-9.8572E+03,-9.7099E+03,-9.5648E+03,
     &  -9.4219E+03,-9.2811E+03,-9.1424E+03,-9.0058E+03,-8.8713E+03,
     &  -8.7387E+03,-8.6082E+03,-8.4796E+03,-8.3529E+03,-8.2281E+03,
     &  -8.1051E+03,-7.9840E+03,-7.8647E+03,-7.7472E+03,-7.6315E+03,
     &  -7.5174E+03,-7.4051E+03,-7.2945E+03,-7.1855E+03,-7.0781E+03,
     &  -6.9724E+03,-6.8682E+03,-6.7656E+03,-6.6645E+03,-6.5649E+03,
     &  -6.4668E+03,-6.3702E+03,-6.2750E+03,-6.1813E+03,-6.0889E+03,
     &  -5.9980E+03,-5.9083E+03,-5.8201E+03,-5.7331E+03,-5.6474E+03,
     &  -5.5631E+03,-5.4799E+03,-5.3981E+03,-5.3174E+03,-5.2380E+03,
     &  -5.1597E+03,-5.0826E+03,-5.0067E+03,-4.9319E+03,-4.8582E+03,
     &  -4.7856E+03,-4.7141E+03,-4.6437E+03,-4.5743E+03,-4.5059E+03/
  
       DATA  (XXX  (I), I= 101, 200) /
     &  -4.4386E+03,-4.3723E+03,-4.3070E+03,-4.2426E+03,-4.1792E+03,
     &  -4.1168E+03,-4.0553E+03,-3.9947E+03,-3.9350E+03,-3.8762E+03,
     &  -3.8183E+03,-3.7612E+03,-3.7050E+03,-3.6497E+03,-3.5951E+03,
     &  -3.5414E+03,-3.4885E+03,-3.4364E+03,-3.3850E+03,-3.3345E+03,
     &  -3.2847E+03,-3.2356E+03,-3.1872E+03,-3.1396E+03,-3.0927E+03,
     &  -3.0465E+03,-3.0010E+03,-2.9561E+03,-2.9120E+03,-2.8685E+03,
     &  -2.8256E+03,-2.7834E+03,-2.7418E+03,-2.7008E+03,-2.6605E+03,
     &  -2.6207E+03,-2.5816E+03,-2.5430E+03,-2.5050E+03,-2.4676E+03,
     &  -2.4307E+03,-2.3944E+03,-2.3586E+03,-2.3234E+03,-2.2887E+03,
     &  -2.2545E+03,-2.2208E+03,-2.1876E+03,-2.1549E+03,-2.1227E+03,
     &  -2.0910E+03,-2.0598E+03,-2.0290E+03,-1.9987E+03,-1.9688E+03,
     &  -1.9394E+03,-1.9104E+03,-1.8819E+03,-1.8538E+03,-1.8261E+03,
     &  -1.7988E+03,-1.7719E+03,-1.7454E+03,-1.7193E+03,-1.6937E+03,
     &  -1.6683E+03,-1.6434E+03,-1.6189E+03,-1.5947E+03,-1.5709E+03,
     &  -1.5474E+03,-1.5243E+03,-1.5015E+03,-1.4791E+03,-1.4570E+03,
     &  -1.4352E+03,-1.4137E+03,-1.3926E+03,-1.3718E+03,-1.3513E+03,
     &  -1.3311E+03,-1.3112E+03,-1.2916E+03,-1.2723E+03,-1.2533E+03,
     &  -1.2346E+03,-1.2162E+03,-1.1980E+03,-1.1801E+03,-1.1625E+03,
     &  -1.1451E+03,-1.1280E+03,-1.1111E+03,-1.0945E+03,-1.0782E+03,
     &  -1.0621E+03,-1.0462E+03,-1.0306E+03,-1.0152E+03,-1.0000E+03/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=1,1) /
     &   5.7093E-02, 5.7007E-02, 5.6920E-02, 5.6834E-02, 5.6747E-02,
     &   5.6661E-02, 5.6574E-02, 5.6488E-02, 5.6402E-02, 5.6315E-02,
     &   5.6229E-02, 5.6143E-02, 5.6057E-02, 5.5970E-02, 5.5884E-02,
     &   5.5798E-02, 5.5712E-02, 5.5626E-02, 5.5540E-02, 5.5454E-02,
     &   5.5368E-02, 5.5282E-02, 5.5196E-02, 5.5110E-02, 5.5024E-02,
     &   5.4938E-02, 5.4852E-02, 5.4766E-02, 5.4681E-02, 5.4595E-02,
     &   5.4509E-02, 5.4424E-02, 5.4338E-02, 5.4253E-02, 5.4167E-02,
     &   5.4082E-02, 5.3996E-02, 5.3911E-02, 5.3825E-02, 5.3740E-02,
     &   5.3655E-02, 5.3570E-02, 5.3485E-02, 5.3399E-02, 5.3314E-02,
     &   5.3229E-02, 5.3144E-02, 5.3059E-02, 5.2975E-02, 5.2890E-02,
     &   5.2805E-02, 5.2720E-02, 5.2636E-02, 5.2551E-02, 5.2467E-02,
     &   5.2382E-02, 5.2298E-02, 5.2213E-02, 5.2129E-02, 5.2045E-02,
     &   5.1961E-02, 5.1877E-02, 5.1793E-02, 5.1709E-02, 5.1625E-02,
     &   5.1541E-02, 5.1457E-02, 5.1374E-02, 5.1290E-02, 5.1207E-02,
     &   5.1123E-02, 5.1040E-02, 5.0957E-02, 5.0874E-02, 5.0790E-02,
     &   5.0707E-02, 5.0624E-02, 5.0542E-02, 5.0459E-02, 5.0376E-02,
     &   5.0293E-02, 5.0211E-02, 5.0129E-02, 5.0046E-02, 4.9964E-02,
     &   4.9882E-02, 4.9800E-02, 4.9718E-02, 4.9636E-02, 4.9554E-02,
     &   4.9472E-02, 4.9391E-02, 4.9309E-02, 4.9228E-02, 4.9147E-02,
     &   4.9065E-02, 4.8984E-02, 4.8903E-02, 4.8823E-02, 4.8742E-02/
  
         DATA ((YGG  (I,J), I= 101, 200), J=1,1) /
     &   4.8661E-02, 4.8581E-02, 4.8500E-02, 4.8420E-02, 4.8339E-02,
     &   4.8259E-02, 4.8179E-02, 4.8099E-02, 4.8020E-02, 4.7940E-02,
     &   4.7860E-02, 4.7781E-02, 4.7701E-02, 4.7622E-02, 4.7543E-02,
     &   4.7464E-02, 4.7385E-02, 4.7306E-02, 4.7228E-02, 4.7149E-02,
     &   4.7070E-02, 4.6992E-02, 4.6914E-02, 4.6836E-02, 4.6758E-02,
     &   4.6680E-02, 4.6602E-02, 4.6524E-02, 4.6446E-02, 4.6369E-02,
     &   4.6291E-02, 4.6214E-02, 4.6137E-02, 4.6060E-02, 4.5983E-02,
     &   4.5906E-02, 4.5829E-02, 4.5752E-02, 4.5676E-02, 4.5599E-02,
     &   4.5523E-02, 4.5446E-02, 4.5370E-02, 4.5294E-02, 4.5218E-02,
     &   4.5141E-02, 4.5065E-02, 4.4990E-02, 4.4914E-02, 4.4838E-02,
     &   4.4762E-02, 4.4687E-02, 4.4611E-02, 4.4535E-02, 4.4460E-02,
     &   4.4384E-02, 4.4309E-02, 4.4234E-02, 4.4158E-02, 4.4083E-02,
     &   4.4008E-02, 4.3933E-02, 4.3857E-02, 4.3782E-02, 4.3707E-02,
     &   4.3632E-02, 4.3557E-02, 4.3482E-02, 4.3407E-02, 4.3331E-02,
     &   4.3256E-02, 4.3181E-02, 4.3106E-02, 4.3031E-02, 4.2956E-02,
     &   4.2880E-02, 4.2805E-02, 4.2730E-02, 4.2654E-02, 4.2579E-02,
     &   4.2504E-02, 4.2428E-02, 4.2353E-02, 4.2277E-02, 4.2201E-02,
     &   4.2126E-02, 4.2050E-02, 4.1974E-02, 4.1898E-02, 4.1822E-02,
     &   4.1746E-02, 4.1670E-02, 4.1594E-02, 4.1517E-02, 4.1441E-02,
     &   4.1364E-02, 4.1288E-02, 4.1211E-02, 4.1134E-02, 4.1057E-02/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=2,2) /
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05/
  
         DATA ((YGG  (I,J), I= 101, 200), J=2,2) /
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3025E-05, 5.3025E-05/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=3,3) /
     &   1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04,
     &   1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04,
     &   1.4132E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04/
  
         DATA ((YGG  (I,J), I= 101, 200), J=3,3) /
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04/

c      ++++ deghadthigh23 ++++  

c update 09/25/25 
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 23:16:08 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1,-2.0000E+04,-1.0000E+03, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
         DATA ((Y3G  (I,J), I=   1, 100), J=1,1) /
     &   1.1695E-01, 1.1677E-01, 1.1659E-01, 1.1641E-01, 1.1624E-01,
     &   1.1606E-01, 1.1588E-01, 1.1570E-01, 1.1552E-01, 1.1535E-01,
     &   1.1517E-01, 1.1499E-01, 1.1481E-01, 1.1463E-01, 1.1446E-01,
     &   1.1428E-01, 1.1410E-01, 1.1392E-01, 1.1375E-01, 1.1357E-01,
     &   1.1339E-01, 1.1321E-01, 1.1304E-01, 1.1286E-01, 1.1268E-01,
     &   1.1251E-01, 1.1233E-01, 1.1215E-01, 1.1198E-01, 1.1180E-01,
     &   1.1162E-01, 1.1145E-01, 1.1127E-01, 1.1109E-01, 1.1092E-01,
     &   1.1074E-01, 1.1056E-01, 1.1039E-01, 1.1021E-01, 1.1004E-01,
     &   1.0986E-01, 1.0968E-01, 1.0951E-01, 1.0933E-01, 1.0916E-01,
     &   1.0898E-01, 1.0881E-01, 1.0863E-01, 1.0846E-01, 1.0828E-01,
     &   1.0811E-01, 1.0793E-01, 1.0776E-01, 1.0759E-01, 1.0741E-01,
     &   1.0724E-01, 1.0706E-01, 1.0689E-01, 1.0672E-01, 1.0654E-01,
     &   1.0637E-01, 1.0620E-01, 1.0602E-01, 1.0585E-01, 1.0568E-01,
     &   1.0550E-01, 1.0533E-01, 1.0516E-01, 1.0499E-01, 1.0481E-01,
     &   1.0464E-01, 1.0447E-01, 1.0430E-01, 1.0413E-01, 1.0396E-01,
     &   1.0378E-01, 1.0361E-01, 1.0344E-01, 1.0327E-01, 1.0310E-01,
     &   1.0293E-01, 1.0276E-01, 1.0259E-01, 1.0242E-01, 1.0225E-01,
     &   1.0208E-01, 1.0191E-01, 1.0174E-01, 1.0158E-01, 1.0141E-01,
     &   1.0124E-01, 1.0107E-01, 1.0090E-01, 1.0073E-01, 1.0057E-01,
     &   1.0040E-01, 1.0023E-01, 1.0007E-01, 9.9899E-02, 9.9732E-02/
  
         DATA ((Y3G  (I,J), I= 101, 200), J=1,1) /
     &   9.9566E-02, 9.9400E-02, 9.9234E-02, 9.9069E-02, 9.8903E-02,
     &   9.8738E-02, 9.8573E-02, 9.8408E-02, 9.8244E-02, 9.8079E-02,
     &   9.7915E-02, 9.7751E-02, 9.7588E-02, 9.7424E-02, 9.7261E-02,
     &   9.7098E-02, 9.6936E-02, 9.6773E-02, 9.6611E-02, 9.6449E-02,
     &   9.6287E-02, 9.6125E-02, 9.5964E-02, 9.5803E-02, 9.5642E-02,
     &   9.5481E-02, 9.5321E-02, 9.5161E-02, 9.5001E-02, 9.4841E-02,
     &   9.4681E-02, 9.4522E-02, 9.4363E-02, 9.4204E-02, 9.4045E-02,
     &   9.3886E-02, 9.3728E-02, 9.3570E-02, 9.3412E-02, 9.3254E-02,
     &   9.3096E-02, 9.2939E-02, 9.2781E-02, 9.2624E-02, 9.2467E-02,
     &   9.2310E-02, 9.2154E-02, 9.1997E-02, 9.1841E-02, 9.1685E-02,
     &   9.1529E-02, 9.1373E-02, 9.1217E-02, 9.1061E-02, 9.0905E-02,
     &   9.0750E-02, 9.0594E-02, 9.0439E-02, 9.0284E-02, 9.0129E-02,
     &   8.9974E-02, 8.9818E-02, 8.9663E-02, 8.9508E-02, 8.9354E-02,
     &   8.9199E-02, 8.9044E-02, 8.8889E-02, 8.8734E-02, 8.8579E-02,
     &   8.8424E-02, 8.8269E-02, 8.8114E-02, 8.7959E-02, 8.7804E-02,
     &   8.7649E-02, 8.7494E-02, 8.7339E-02, 8.7184E-02, 8.7028E-02,
     &   8.6873E-02, 8.6717E-02, 8.6561E-02, 8.6406E-02, 8.6250E-02,
     &   8.6094E-02, 8.5937E-02, 8.5781E-02, 8.5624E-02, 8.5468E-02,
     &   8.5311E-02, 8.5154E-02, 8.4997E-02, 8.4839E-02, 8.4682E-02,
     &   8.4524E-02, 8.4366E-02, 8.4207E-02, 8.4049E-02, 8.3890E-02/
  
  
         DATA ((Y3G  (I,J), I=   1, 100), J=2,2) /
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05,
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05,
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05/
  
         DATA ((Y3G  (I,J), I= 101, 200), J=2,2) /
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05/
  
  
         DATA ((Y3G  (I,J), I=   1, 100), J=3,3) /
     &   2.3117E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04,
     &   2.3116E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04,
     &   2.3116E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04,
     &   2.3115E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04,
     &   2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04,
     &   2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04,
     &   2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3113E-04,
     &   2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3112E-04,
     &   2.3112E-04, 2.3112E-04, 2.3112E-04, 2.3112E-04, 2.3112E-04,
     &   2.3112E-04, 2.3112E-04, 2.3112E-04, 2.3111E-04, 2.3111E-04,
     &   2.3111E-04, 2.3111E-04, 2.3111E-04, 2.3111E-04, 2.3111E-04,
     &   2.3111E-04, 2.3111E-04, 2.3111E-04, 2.3110E-04, 2.3110E-04,
     &   2.3110E-04, 2.3110E-04, 2.3110E-04, 2.3110E-04, 2.3110E-04,
     &   2.3110E-04, 2.3110E-04, 2.3109E-04, 2.3109E-04, 2.3109E-04,
     &   2.3109E-04, 2.3109E-04, 2.3109E-04, 2.3109E-04, 2.3109E-04,
     &   2.3109E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04,
     &   2.3108E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04,
     &   2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3107E-04,
     &   2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3106E-04,
     &   2.3106E-04, 2.3106E-04, 2.3106E-04, 2.3106E-04, 2.3106E-04/
  
         DATA ((Y3G  (I,J), I= 101, 200), J=3,3) /
     &   2.3106E-04, 2.3106E-04, 2.3106E-04, 2.3105E-04, 2.3105E-04,
     &   2.3105E-04, 2.3105E-04, 2.3105E-04, 2.3105E-04, 2.3105E-04,
     &   2.3105E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04,
     &   2.3104E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04,
     &   2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3103E-04,
     &   2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3102E-04,
     &   2.3102E-04, 2.3102E-04, 2.3102E-04, 2.3102E-04, 2.3102E-04,
     &   2.3102E-04, 2.3102E-04, 2.3101E-04, 2.3101E-04, 2.3101E-04,
     &   2.3101E-04, 2.3101E-04, 2.3101E-04, 2.3101E-04, 2.3101E-04,
     &   2.3101E-04, 2.3100E-04, 2.3100E-04, 2.3100E-04, 2.3100E-04,
     &   2.3100E-04, 2.3100E-04, 2.3100E-04, 2.3100E-04, 2.3099E-04,
     &   2.3099E-04, 2.3099E-04, 2.3099E-04, 2.3099E-04, 2.3099E-04,
     &   2.3099E-04, 2.3099E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04,
     &   2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3096E-04, 2.3096E-04,
     &   2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04,
     &   2.3096E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04,
     &   2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3094E-04, 2.3094E-04,
     &   2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04/
  
       save
       RETURN
       END
      
c      ++++ dalhadslow23 ++++  

c update 09/24/25 
       subroutine dalhad_timelike25
       IMPLICIT NONE
       INTEGER NB,I,J
       PARAMETER(NB=2180)
       REAL ESA(NB),DAS(NB,3),DGS(NB,3)
       COMMON /DATS25/ESA,DAS,DGS
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Wed Sep 24 12:55:38 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN:  1, Ismooth: 0, IGS: 0, DSET:     , iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
       DATA  (ESA  (I), I=   1, 100) /
     &   0.28207018D0, 0.28800000D0, 0.29400000D0, 0.30000000D0,
     &   0.30600000D0, 0.30900000D0, 0.31500000D0, 0.32600000D0,
     &   0.33100000D0, 0.33600000D0, 0.34100000D0, 0.34600000D0,
     &   0.35200000D0, 0.35600000D0, 0.36100000D0, 0.36600000D0,
     &   0.37100000D0, 0.37600000D0, 0.38000000D0, 0.38500000D0,
     &   0.38900000D0, 0.39400000D0, 0.39800000D0, 0.40300000D0,
     &   0.40700000D0, 0.41100000D0, 0.41600000D0, 0.41871100D0,
     &   0.42000000D0, 0.42400000D0, 0.42800000D0, 0.43200000D0,
     &   0.43600000D0, 0.44000000D0, 0.44400000D0, 0.44800000D0,
     &   0.45200000D0, 0.45600000D0, 0.46000000D0, 0.46400000D0,
     &   0.46700000D0, 0.47100000D0, 0.47500000D0, 0.47800000D0,
     &   0.48200000D0, 0.48600000D0, 0.48900000D0, 0.49300000D0,
     &   0.49600000D0, 0.50000000D0, 0.52000000D0, 0.54000000D0,
     &   0.56600000D0, 0.59200000D0, 0.60000000D0, 0.60200000D0,
     &   0.60800000D0, 0.61600000D0, 0.62400000D0, 0.63200000D0,
     &   0.64000000D0, 0.64300000D0, 0.64800000D0, 0.65600000D0,
     &   0.66300000D0, 0.67100000D0, 0.67800000D0, 0.68600000D0,
     &   0.68800000D0, 0.69300000D0, 0.69600000D0, 0.70000000D0,
     &   0.70700000D0, 0.71400000D0, 0.72100000D0, 0.72800000D0,
     &   0.73500000D0, 0.74200000D0, 0.74800000D0, 0.75000000D0,
     &   0.75500000D0, 0.75744000D0, 0.76007300D0, 0.76207300D0,
     &   0.76507300D0, 0.76851700D0, 0.77060500D0, 0.77205400D0,
     &   0.77314300D0, 0.77400300D0, 0.77470900D0, 0.77530500D0,
     &   0.77582000D0, 0.77627100D0, 0.77667300D0, 0.77726600D0,
     &   0.77746600D0, 0.77766900D0, 0.77795100D0, 0.77821500D0/
       DATA  (ESA  (I), I= 101, 200) /
     &   0.77846300D0, 0.77869800D0, 0.77892200D0, 0.77913700D0,
     &   0.77934400D0, 0.77954500D0, 0.77974200D0, 0.77993500D0,
     &   0.78012700D0, 0.78031800D0, 0.78051000D0, 0.78070600D0,
     &   0.78090800D0, 0.78112100D0, 0.78135100D0, 0.78161200D0,
     &   0.78193600D0, 0.78268000D0, 0.78341500D0, 0.78373400D0,
     &   0.78399100D0, 0.78421700D0, 0.78442600D0, 0.78462500D0,
     &   0.78481700D0, 0.78500500D0, 0.78519100D0, 0.78537800D0,
     &   0.78556600D0, 0.78575600D0, 0.78595100D0, 0.78615100D0,
     &   0.78635800D0, 0.78657300D0, 0.78679800D0, 0.78703400D0,
     &   0.78728400D0, 0.78755000D0, 0.78773500D0, 0.78793500D0,
     &   0.78814300D0, 0.78847900D0, 0.78884800D0, 0.78925800D0,
     &   0.78971900D0, 0.79024600D0, 0.79085900D0, 0.79158800D0,
     &   0.79248000D0, 0.79361500D0, 0.79513900D0, 0.79736300D0,
     &   0.79800000D0, 0.80000000D0, 0.80200000D0, 0.80400000D0,
     &   0.80600000D0, 0.80800000D0, 0.81200000D0, 0.81400000D0,
     &   0.81600000D0, 0.82000000D0, 0.82200000D0, 0.82400000D0,
     &   0.82600000D0, 0.82800000D0, 0.83000000D0, 0.83100000D0,
     &   0.83700000D0, 0.84300000D0, 0.84900000D0, 0.85400000D0,
     &   0.86000000D0, 0.86600000D0, 0.87200000D0, 0.87700000D0,
     &   0.88300000D0, 0.88900000D0, 0.89400000D0, 0.89700000D0,
     &   0.90250000D0, 0.90500000D0, 0.91100000D0, 0.91600000D0,
     &   0.92200000D0, 0.92700000D0, 0.93300000D0, 0.93800000D0,
     &   0.94300000D0, 0.94900000D0, 0.95200000D0, 0.95400000D0,
     &   0.95800000D0, 0.96000000D0, 0.96200000D0, 0.96400000D0,
     &   0.96600000D0, 0.96800000D0, 0.97000000D0, 0.97400000D0/
       DATA  (ESA  (I), I= 201, 300) /
     &   0.97800000D0, 0.98000000D0, 0.98070000D0, 0.98140000D0,
     &   0.98210000D0, 0.98280000D0, 0.98350000D0, 0.98420000D0,
     &   0.98490000D0, 0.98560000D0, 0.98630000D0, 0.98700000D0,
     &   0.98770000D0, 0.98840000D0, 0.98910000D0, 0.98980000D0,
     &   0.99050000D0, 0.99120000D0, 0.99190000D0, 0.99260000D0,
     &   0.99330000D0, 0.99400000D0, 0.99470000D0, 0.99540000D0,
     &   0.99610000D0, 0.99680000D0, 0.99750000D0, 0.99820000D0,
     &   0.99890000D0, 0.99960000D0, 0.99990000D0, 1.00001000D0,
     &   1.00030000D0, 1.00100000D0, 1.00170000D0, 1.00240000D0,
     &   1.00310000D0, 1.00380000D0, 1.00450000D0, 1.00520000D0,
     &   1.00590000D0, 1.00660000D0, 1.00730000D0, 1.00800000D0,
     &   1.00870000D0, 1.00940000D0, 1.01010000D0, 1.01080000D0,
     &   1.01150000D0, 1.01220000D0, 1.01290000D0, 1.01360000D0,
     &   1.01430000D0, 1.01500000D0, 1.01520000D0, 1.01540000D0,
     &   1.01560000D0, 1.01580000D0, 1.01600000D0, 1.01620000D0,
     &   1.01640000D0, 1.01660000D0, 1.01680000D0, 1.01700000D0,
     &   1.01720000D0, 1.01740000D0, 1.01770000D0, 1.01790000D0,
     &   1.01800000D0, 1.01820000D0, 1.01840000D0, 1.01860000D0,
     &   1.01880000D0, 1.01900000D0, 1.01920000D0, 1.01940000D0,
     &   1.01960000D0, 1.01980000D0, 1.02000000D0, 1.02020000D0,
     &   1.02040000D0, 1.02060000D0, 1.02080000D0, 1.02100000D0,
     &   1.02120000D0, 1.02140000D0, 1.02160000D0, 1.02180000D0,
     &   1.02200000D0, 1.02220000D0, 1.02240000D0, 1.02270000D0,
     &   1.02290000D0, 1.02300000D0, 1.02320000D0, 1.02340000D0,
     &   1.02360000D0, 1.02380000D0, 1.02400000D0, 1.02420000D0/
       DATA  (ESA  (I), I= 301, 400) /
     &   1.02440000D0, 1.02460000D0, 1.02480000D0, 1.02500000D0,
     &   1.02570000D0, 1.02640000D0, 1.02710000D0, 1.02780000D0,
     &   1.02850000D0, 1.02920000D0, 1.02990000D0, 1.03060000D0,
     &   1.03130000D0, 1.03200000D0, 1.03270000D0, 1.03340000D0,
     &   1.03410000D0, 1.03480000D0, 1.03550000D0, 1.03620000D0,
     &   1.03690000D0, 1.03760000D0, 1.03830000D0, 1.03900000D0,
     &   1.03970000D0, 1.03999000D0, 1.04001000D0, 1.04040000D0,
     &   1.04110000D0, 1.04180000D0, 1.04250000D0, 1.04320000D0,
     &   1.04390000D0, 1.04460000D0, 1.04530000D0, 1.04600000D0,
     &   1.04670000D0, 1.04740000D0, 1.04810000D0, 1.04880000D0,
     &   1.04950000D0, 1.05020000D0, 1.05090000D0, 1.05160000D0,
     &   1.05230000D0, 1.05300000D0, 1.05370000D0, 1.05440000D0,
     &   1.05510000D0, 1.05580000D0, 1.05650000D0, 1.05720000D0,
     &   1.05790000D0, 1.05860000D0, 1.05930000D0, 1.06000000D0,
     &   1.06200000D0, 1.06700000D0, 1.07700000D0, 1.08700000D0,
     &   1.09700000D0, 1.10700000D0, 1.11700000D0, 1.12700000D0,
     &   1.13700000D0, 1.13800000D0, 1.15200000D0, 1.16300000D0,
     &   1.16700000D0, 1.17700000D0, 1.18700000D0, 1.18800000D0,
     &   1.19700000D0, 1.20700000D0, 1.21200000D0, 1.21700000D0,
     &   1.22700000D0, 1.23700000D0, 1.24700000D0, 1.25700000D0,
     &   1.26300000D0, 1.26700000D0, 1.27700000D0, 1.28700000D0,
     &   1.28800000D0, 1.29700000D0, 1.30700000D0, 1.31200000D0,
     &   1.31700000D0, 1.32700000D0, 1.33700000D0, 1.34700000D0,
     &   1.35000000D0, 1.35700000D0, 1.36200000D0, 1.36700000D0,
     &   1.37700000D0, 1.38700000D0, 1.38800000D0, 1.39500000D0/
       DATA  (ESA  (I), I= 401, 500) /
     &   1.41000000D0, 1.41900000D0, 1.42700000D0, 1.43500000D0,
     &   1.43800000D0, 1.45200000D0, 1.45700000D0, 1.46000000D0,
     &   1.46400000D0, 1.47200000D0, 1.48100000D0, 1.49000000D0,
     &   1.49100000D0, 1.50000000D0, 1.50100000D0, 1.50600000D0,
     &   1.51000000D0, 1.52300000D0, 1.52500000D0, 1.53800000D0,
     &   1.53900000D0, 1.54000000D0, 1.55000000D0, 1.56000000D0,
     &   1.56200000D0, 1.57400000D0, 1.57500000D0, 1.58000000D0,
     &   1.58100000D0, 1.58700000D0, 1.59000000D0, 1.59900000D0,
     &   1.60000000D0, 1.61000000D0, 1.61900000D0, 1.62400000D0,
     &   1.62500000D0, 1.63800000D0, 1.64000000D0, 1.65000000D0,
     &   1.65700000D0, 1.66000000D0, 1.66200000D0, 1.66300000D0,
     &   1.67300000D0, 1.67500000D0, 1.68100000D0, 1.68700000D0,
     &   1.69000000D0, 1.70000000D0, 1.71000000D0, 1.71200000D0,
     &   1.71300000D0, 1.71900000D0, 1.72200000D0, 1.72500000D0,
     &   1.73800000D0, 1.74000000D0, 1.74600000D0, 1.75000000D0,
     &   1.75600000D0, 1.75700000D0, 1.76000000D0, 1.76200000D0,
     &   1.76400000D0, 1.76900000D0, 1.77500000D0, 1.78100000D0,
     &   1.79000000D0, 1.79900000D0, 1.80000000D0, 1.81200000D0,
     &   1.81900000D0, 1.82500000D0, 1.82600000D0, 1.83400000D0,
     &   1.83500000D0, 1.83800000D0, 1.84500000D0, 1.85700000D0,
     &   1.85900000D0, 1.87400000D0, 1.88100000D0, 1.88600000D0,
     &   1.90000000D0, 1.91900000D0, 1.92500000D0, 1.93000000D0,
     &   1.93800000D0, 1.94000000D0, 1.94500000D0, 1.94600000D0,
     &   1.95000000D0, 1.95500000D0, 1.96000000D0, 1.96200000D0,
     &   1.98100000D0, 1.99050000D0, 2.00500000D0, 2.05000000D0/
       DATA  (ESA  (I), I= 501, 600) /
     &   2.10000000D0, 2.15010000D0, 2.22000000D0, 2.23240000D0,
     &   2.26000000D0, 2.30000000D0, 2.40000000D0, 2.45000000D0,
     &   2.50000000D0, 2.55000000D0, 2.60000000D0, 2.65000000D0,
     &   2.70000000D0, 2.75000000D0, 2.80000000D0, 2.85000000D0,
     &   2.90000000D0, 2.91000000D0, 2.92000000D0, 2.93000000D0,
     &   2.94000000D0, 2.95000000D0, 2.96000000D0, 2.97000000D0,
     &   2.97200000D0, 2.97400000D0, 2.97600000D0, 2.97800000D0,
     &   2.98000000D0, 2.98200000D0, 2.98400000D0, 2.98600000D0,
     &   2.98800000D0, 2.99000000D0, 2.99900000D0, 3.00500000D0,
     &   3.00800000D0, 3.01000000D0, 3.01200000D0, 3.01400000D0,
     &   3.01600000D0, 3.01800000D0, 3.02000000D0, 3.02100000D0,
     &   3.02200000D0, 3.02300000D0, 3.02400000D0, 3.02500000D0,
     &   3.02600000D0, 3.02700000D0, 3.02800000D0, 3.02900000D0,
     &   3.03000000D0, 3.03100000D0, 3.03200000D0, 3.03300000D0,
     &   3.03400000D0, 3.03500000D0, 3.03600000D0, 3.03700000D0,
     &   3.03800000D0, 3.03900000D0, 3.04000000D0, 3.04100000D0,
     &   3.04200000D0, 3.04300000D0, 3.04400000D0, 3.04500000D0,
     &   3.04600000D0, 3.04700000D0, 3.04800000D0, 3.04900000D0,
     &   3.05000000D0, 3.05100000D0, 3.05200000D0, 3.05300000D0,
     &   3.05400000D0, 3.05500000D0, 3.05600000D0, 3.05700000D0,
     &   3.05800000D0, 3.05900000D0, 3.06000000D0, 3.06050000D0,
     &   3.06100000D0, 3.06150000D0, 3.06200000D0, 3.06250000D0,
     &   3.06300000D0, 3.06350000D0, 3.06400000D0, 3.06450000D0,
     &   3.06500000D0, 3.06550000D0, 3.06600000D0, 3.06650000D0,
     &   3.06700000D0, 3.06750000D0, 3.06800000D0, 3.06850000D0/
       DATA  (ESA  (I), I= 601, 700) /
     &   3.06900000D0, 3.06950000D0, 3.07000000D0, 3.07050000D0,
     &   3.07100000D0, 3.07150000D0, 3.07200000D0, 3.07250000D0,
     &   3.07300000D0, 3.07350000D0, 3.07400000D0, 3.07450000D0,
     &   3.07500000D0, 3.07550000D0, 3.07600000D0, 3.07650000D0,
     &   3.07700000D0, 3.07750000D0, 3.07800000D0, 3.07850000D0,
     &   3.07900000D0, 3.07970000D0, 3.08000000D0, 3.08050000D0,
     &   3.08100000D0, 3.08150000D0, 3.08200000D0, 3.08250000D0,
     &   3.08300000D0, 3.08350000D0, 3.08400000D0, 3.08450000D0,
     &   3.08500000D0, 3.08550000D0, 3.08587000D0, 3.08688300D0,
     &   3.08789600D0, 3.08890900D0, 3.08992200D0, 3.09093500D0,
     &   3.09194800D0, 3.09296100D0, 3.09397400D0, 3.09498700D0,
     &   3.09600000D0, 3.09605000D0, 3.09610000D0, 3.09615000D0,
     &   3.09620000D0, 3.09625000D0, 3.09630000D0, 3.09635000D0,
     &   3.09640000D0, 3.09645000D0, 3.09650000D0, 3.09655000D0,
     &   3.09660000D0, 3.09665000D0, 3.09665500D0, 3.09673500D0,
     &   3.09677100D0, 3.09679300D0, 3.09680900D0, 3.09682000D0,
     &   3.09682900D0, 3.09683600D0, 3.09684300D0, 3.09684800D0,
     &   3.09685300D0, 3.09685700D0, 3.09686100D0, 3.09686400D0,
     &   3.09686800D0, 3.09687000D0, 3.09687300D0, 3.09687600D0,
     &   3.09687800D0, 3.09688100D0, 3.09688300D0, 3.09688500D0,
     &   3.09688700D0, 3.09688900D0, 3.09689100D0, 3.09689300D0,
     &   3.09689500D0, 3.09689700D0, 3.09689900D0, 3.09690100D0,
     &   3.09690400D0, 3.09690600D0, 3.09690900D0, 3.09691200D0,
     &   3.09692000D0, 3.09692800D0, 3.09693100D0, 3.09693400D0,
     &   3.09693600D0, 3.09693900D0, 3.09694100D0, 3.09694300D0/
       DATA  (ESA  (I), I= 701, 800) /
     &   3.09694500D0, 3.09694700D0, 3.09694900D0, 3.09695100D0,
     &   3.09695300D0, 3.09695500D0, 3.09695700D0, 3.09695900D0,
     &   3.09696200D0, 3.09696400D0, 3.09696700D0, 3.09697000D0,
     &   3.09697200D0, 3.09697600D0, 3.09697900D0, 3.09698300D0,
     &   3.09698700D0, 3.09699200D0, 3.09699700D0, 3.09700400D0,
     &   3.09701100D0, 3.09702000D0, 3.09703100D0, 3.09704700D0,
     &   3.09706900D0, 3.09710500D0, 3.09715000D0, 3.09720000D0,
     &   3.09725000D0, 3.09730000D0, 3.09735000D0, 3.09740000D0,
     &   3.09745000D0, 3.09750000D0, 3.09755000D0, 3.09760000D0,
     &   3.09765000D0, 3.09770000D0, 3.09775000D0, 3.09780000D0,
     &   3.09785000D0, 3.09790000D0, 3.09795000D0, 3.09800000D0,
     &   3.09898700D0, 3.09997400D0, 3.10096100D0, 3.10194800D0,
     &   3.10293500D0, 3.10392200D0, 3.10490900D0, 3.10589600D0,
     &   3.10688300D0, 3.10787000D0, 3.10800000D0, 3.10900000D0,
     &   3.11000000D0, 3.11100000D0, 3.11200000D0, 3.11300000D0,
     &   3.11400000D0, 3.11500000D0, 3.11600000D0, 3.11700000D0,
     &   3.11800000D0, 3.11900000D0, 3.12000000D0, 3.12100000D0,
     &   3.12200000D0, 3.12300000D0, 3.12400000D0, 3.12500000D0,
     &   3.12600000D0, 3.12700000D0, 3.12800000D0, 3.12900000D0,
     &   3.13000000D0, 3.13100000D0, 3.13200000D0, 3.13300000D0,
     &   3.13400000D0, 3.13500000D0, 3.13600000D0, 3.13700000D0,
     &   3.13800000D0, 3.13900000D0, 3.14000000D0, 3.14100000D0,
     &   3.14200000D0, 3.14300000D0, 3.14400000D0, 3.14500000D0,
     &   3.14600000D0, 3.14700000D0, 3.14800000D0, 3.14900000D0,
     &   3.15000000D0, 3.15100000D0, 3.15200000D0, 3.15300000D0/
       DATA  (ESA  (I), I= 801, 900) /
     &   3.15400000D0, 3.15500000D0, 3.15600000D0, 3.15700000D0,
     &   3.15800000D0, 3.15900000D0, 3.16000000D0, 3.16100000D0,
     &   3.16200000D0, 3.16300000D0, 3.16400000D0, 3.16500000D0,
     &   3.16600000D0, 3.16700000D0, 3.16800000D0, 3.16900000D0,
     &   3.17000000D0, 3.17100000D0, 3.17200000D0, 3.17300000D0,
     &   3.17400000D0, 3.17500000D0, 3.17600000D0, 3.17700000D0,
     &   3.17800000D0, 3.17900000D0, 3.18000000D0, 3.18100000D0,
     &   3.18200000D0, 3.18300000D0, 3.18400000D0, 3.18500000D0,
     &   3.18600000D0, 3.18700000D0, 3.18800000D0, 3.18900000D0,
     &   3.19000000D0, 3.19100000D0, 3.19200000D0, 3.19300000D0,
     &   3.19400000D0, 3.19500000D0, 3.19600000D0, 3.19700000D0,
     &   3.19800000D0, 3.19900000D0, 3.19990000D0, 3.20100000D0,
     &   3.20200000D0, 3.20300000D0, 3.20400000D0, 3.20500000D0,
     &   3.20600000D0, 3.20700000D0, 3.20800000D0, 3.20900000D0,
     &   3.21000000D0, 3.25000000D0, 3.30000000D0, 3.37000000D0,
     &   3.40000000D0, 3.45000000D0, 3.50000000D0, 3.52000000D0,
     &   3.54000000D0, 3.54240000D0, 3.55380000D0, 3.56000000D0,
     &   3.56110000D0, 3.57500000D0, 3.59000000D0, 3.59500000D0,
     &   3.60020000D0, 3.60500000D0, 3.61000000D0, 3.61500000D0,
     &   3.62000000D0, 3.62500000D0, 3.63000000D0, 3.63500000D0,
     &   3.64000000D0, 3.64500000D0, 3.65000000D0, 3.65200000D0,
     &   3.65400000D0, 3.65600000D0, 3.65800000D0, 3.66000000D0,
     &   3.66200000D0, 3.66300000D0, 3.66400000D0, 3.66500000D0,
     &   3.66600000D0, 3.66700000D0, 3.66800000D0, 3.66900000D0,
     &   3.67000000D0, 3.67100000D0, 3.67200000D0, 3.67300000D0/
       DATA  (ESA  (I), I= 901,1000) /
     &   3.67400000D0, 3.67496000D0, 3.67551000D0, 3.67606000D0,
     &   3.67661000D0, 3.67716000D0, 3.67771000D0, 3.67826000D0,
     &   3.67881000D0, 3.67936000D0, 3.67991000D0, 3.68046000D0,
     &   3.68101000D0, 3.68156000D0, 3.68211000D0, 3.68266000D0,
     &   3.68321000D0, 3.68376000D0, 3.68431000D0, 3.68486000D0,
     &   3.68527300D0, 3.68541000D0, 3.68552000D0, 3.68569900D0,
     &   3.68574600D0, 3.68578100D0, 3.68580900D0, 3.68583200D0,
     &   3.68585100D0, 3.68586800D0, 3.68588300D0, 3.68589500D0,
     &   3.68590700D0, 3.68591800D0, 3.68592800D0, 3.68593700D0,
     &   3.68594600D0, 3.68595300D0, 3.68596100D0, 3.68596800D0,
     &   3.68597500D0, 3.68598200D0, 3.68598800D0, 3.68599500D0,
     &   3.68600100D0, 3.68600700D0, 3.68601300D0, 3.68602000D0,
     &   3.68602600D0, 3.68603300D0, 3.68603900D0, 3.68604700D0,
     &   3.68605500D0, 3.68606600D0, 3.68607500D0, 3.68608500D0,
     &   3.68609000D0, 3.68609500D0, 3.68610000D0, 3.68611400D0,
     &   3.68612500D0, 3.68613300D0, 3.68614100D0, 3.68614700D0,
     &   3.68615400D0, 3.68616000D0, 3.68616700D0, 3.68617300D0,
     &   3.68617900D0, 3.68618500D0, 3.68619200D0, 3.68619800D0,
     &   3.68620500D0, 3.68621200D0, 3.68621900D0, 3.68622700D0,
     &   3.68623400D0, 3.68624300D0, 3.68625200D0, 3.68626200D0,
     &   3.68627300D0, 3.68628500D0, 3.68629700D0, 3.68631200D0,
     &   3.68632900D0, 3.68634800D0, 3.68637100D0, 3.68639900D0,
     &   3.68643400D0, 3.68648100D0, 3.68654800D0, 3.68651000D0,
     &   3.68660000D0, 3.68667000D0, 3.68672000D0, 3.68685000D0,
     &   3.68690700D0, 3.68706000D0, 3.68761000D0, 3.68816000D0/
       DATA  (ESA  (I), I=1001,1100) /
     &   3.68871000D0, 3.68926000D0, 3.68981000D0, 3.69036000D0,
     &   3.69091000D0, 3.69146000D0, 3.69201000D0, 3.69256000D0,
     &   3.69311000D0, 3.69366000D0, 3.69421000D0, 3.69476000D0,
     &   3.69531000D0, 3.69586000D0, 3.69641000D0, 3.69696000D0,
     &   3.69796000D0, 3.69950000D0, 3.70050000D0, 3.70250000D0,
     &   3.70450000D0, 3.70700000D0, 3.71200000D0, 3.72128100D0,
     &   3.73082800D0, 3.73660200D0, 3.74060200D0, 3.74360300D0,
     &   3.74597300D0, 3.74791700D0, 3.74955600D0, 3.75096800D0,
     &   3.75220600D0, 3.75330900D0, 3.75430100D0, 3.75520500D0,
     &   3.75603600D0, 3.75680500D0, 3.75752300D0, 3.75819800D0,
     &   3.75883700D0, 3.75944400D0, 3.76002600D0, 3.76058600D0,
     &   3.76112800D0, 3.76165500D0, 3.76217200D0, 3.76268100D0,
     &   3.76318700D0, 3.76369200D0, 3.76420200D0, 3.76472200D0,
     &   3.76526100D0, 3.76582800D0, 3.76644200D0, 3.76713800D0,
     &   3.76800500D0, 3.77000000D0, 3.77199500D0, 3.77286200D0,
     &   3.77355800D0, 3.77417200D0, 3.77474000D0, 3.77527800D0,
     &   3.77579800D0, 3.77630800D0, 3.77681400D0, 3.77731900D0,
     &   3.77782800D0, 3.77834500D0, 3.77887200D0, 3.77941400D0,
     &   3.77997400D0, 3.78055600D0, 3.78116300D0, 3.78180200D0,
     &   3.78247700D0, 3.78319500D0, 3.78396400D0, 3.78479500D0,
     &   3.78569900D0, 3.78669100D0, 3.78779400D0, 3.78903200D0,
     &   3.79044400D0, 3.79208300D0, 3.79402700D0, 3.79639700D0,
     &   3.79939800D0, 3.80339800D0, 3.80917200D0, 3.81871900D0,
     &   3.82200000D0, 3.83200000D0, 3.85000000D0, 3.85200000D0,
     &   3.86700000D0, 3.87300000D0, 3.87800000D0, 3.88400000D0/
       DATA  (ESA  (I), I=1101,1200) /
     &   3.89000000D0, 3.89600000D0, 3.90000000D0, 3.90200000D0,
     &   3.90800000D0, 3.91400000D0, 3.92000000D0, 3.92600000D0,
     &   3.93200000D0, 3.93800000D0, 3.94400000D0, 3.95000000D0,
     &   3.95600000D0, 3.96200000D0, 3.96800000D0, 3.97400000D0,
     &   3.98000000D0, 3.98600000D0, 3.99200000D0, 3.99800000D0,
     &   4.00000000D0, 4.00400000D0, 4.01000000D0, 4.01600000D0,
     &   4.02000000D0, 4.02200000D0, 4.02800000D0, 4.03000000D0,
     &   4.03400000D0, 4.04000000D0, 4.04600000D0, 4.05000000D0,
     &   4.05200000D0, 4.05800000D0, 4.06400000D0, 4.07000000D0,
     &   4.07600000D0, 4.08200000D0, 4.08800000D0, 4.09000000D0,
     &   4.09400000D0, 4.10000000D0, 4.10500000D0, 4.10900000D0,
     &   4.11000000D0, 4.11300000D0, 4.11800000D0, 4.12100000D0,
     &   4.12500000D0, 4.12900000D0, 4.13000000D0, 4.13300000D0,
     &   4.13600000D0, 4.14100000D0, 4.14700000D0, 4.15000000D0,
     &   4.15300000D0, 4.15900000D0, 4.16500000D0, 4.17100000D0,
     &   4.17700000D0, 4.18000000D0, 4.18200000D0, 4.18500000D0,
     &   4.19000000D0, 4.19500000D0, 4.19900000D0, 4.20100000D0,
     &   4.20800000D0, 4.21200000D0, 4.21400000D0, 4.22000000D0,
     &   4.22600000D0, 4.23200000D0, 4.23800000D0, 4.24000000D0,
     &   4.24400000D0, 4.25000000D0, 4.25600000D0, 4.26200000D0,
     &   4.26800000D0, 4.27400000D0, 4.28000000D0, 4.29200000D0,
     &   4.30000000D0, 4.30400000D0, 4.31000000D0, 4.31600000D0,
     &   4.32800000D0, 4.33000000D0, 4.34000000D0, 4.35000000D0,
     &   4.35200000D0, 4.36400000D0, 4.37600000D0, 4.38000000D0,
     &   4.38200000D0, 4.38800000D0, 4.39000000D0, 4.39400000D0/
       DATA  (ESA  (I), I=1201,1300) /
     &   4.40000000D0, 4.40600000D0, 4.41000000D0, 4.41200000D0,
     &   4.41800000D0, 4.42400000D0, 4.43000000D0, 4.43600000D0,
     &   4.44000000D0, 4.44200000D0, 4.44800000D0, 4.45000000D0,
     &   4.46000000D0, 4.47200000D0, 4.48400000D0, 4.49600000D0,
     &   4.50450000D0, 4.54000000D0, 4.55000000D0, 4.57000000D0,
     &   4.60000000D0, 4.62000000D0, 4.65000000D0, 4.66000000D0,
     &   4.70000000D0, 4.71000000D0, 4.80000000D0, 4.90000000D0,
     &   4.98000000D0, 5.06500000D0, 5.15000000D0, 5.22500000D0,
     &   5.25000000D0, 5.30000000D0, 5.40000000D0, 5.45000000D0,
     &   5.50000000D0, 5.60000000D0, 5.70000000D0, 5.75000000D0,
     &   5.80000000D0, 5.85000000D0, 5.90000000D0, 5.95000000D0,
     &   6.00000000D0, 6.05000000D0, 6.10000000D0, 6.15000000D0,
     &   6.20000000D0, 6.25000000D0, 6.30000000D0, 6.35000000D0,
     &   6.40000000D0, 6.45000000D0, 6.50000000D0, 6.55000000D0,
     &   6.60000000D0, 6.65000000D0, 6.70000000D0, 6.75000000D0,
     &   6.80000000D0, 6.85000000D0, 6.90000000D0, 6.95000000D0,
     &   7.00000000D0, 7.05000000D0, 7.10000000D0, 7.15000000D0,
     &   7.20000000D0, 7.25000000D0, 7.30000000D0, 7.35000000D0,
     &   7.40000000D0, 7.44000000D0, 7.50000000D0, 7.60000000D0,
     &   7.70000000D0, 7.80000000D0, 7.90000000D0, 8.00000000D0,
     &   8.10000000D0, 8.20000000D0, 8.30000000D0, 8.40000000D0,
     &   8.50000000D0, 8.60000000D0, 8.70000000D0, 8.80000000D0,
     &   8.90000000D0, 8.91000000D0, 9.00000000D0, 9.10000000D0,
     &   9.20000000D0, 9.28000000D0, 9.30000000D0, 9.35000000D0,
     &   9.39000000D0, 9.40000000D0, 9.41000000D0, 9.41500000D0/
       DATA  (ESA  (I), I=1301,1400) /
     &   9.42000000D0, 9.42400000D0, 9.42800000D0, 9.43000000D0,
     &   9.43200000D0, 9.43400000D0, 9.43600000D0, 9.43800000D0,
     &   9.44000000D0, 9.44100000D0, 9.44200000D0, 9.44300000D0,
     &   9.44400000D0, 9.44500000D0, 9.44600000D0, 9.44700000D0,
     &   9.44800000D0, 9.44900000D0, 9.44937000D0, 9.44959000D0,
     &   9.44981000D0, 9.45003000D0, 9.45025000D0, 9.45047000D0,
     &   9.45069000D0, 9.45091000D0, 9.45113000D0, 9.45135000D0,
     &   9.45157000D0, 9.45179000D0, 9.45201000D0, 9.45223000D0,
     &   9.45245000D0, 9.45267000D0, 9.45289000D0, 9.45311000D0,
     &   9.45333000D0, 9.45355000D0, 9.45377000D0, 9.45399000D0,
     &   9.45421000D0, 9.45443000D0, 9.45465000D0, 9.45487000D0,
     &   9.45509000D0, 9.45531000D0, 9.45553000D0, 9.45575000D0,
     &   9.45597000D0, 9.45619000D0, 9.45641000D0, 9.45663000D0,
     &   9.45685000D0, 9.45707000D0, 9.45729000D0, 9.45751000D0,
     &   9.45773000D0, 9.45795000D0, 9.45817000D0, 9.45839000D0,
     &   9.45861000D0, 9.45883000D0, 9.45905000D0, 9.45927000D0,
     &   9.45949000D0, 9.45971000D0, 9.45993000D0, 9.46000000D0,
     &   9.46014595D0, 9.46019268D0, 9.46021366D0, 9.46022606D0,
     &   9.46023464D0, 9.46024132D0, 9.46024704D0, 9.46025085D0,
     &   9.46025467D0, 9.46025848D0, 9.46026039D0, 9.46026325D0,
     &   9.46026516D0, 9.46026802D0, 9.46026897D0, 9.46027088D0,
     &   9.46027279D0, 9.46027470D0, 9.46027565D0, 9.46027660D0,
     &   9.46027851D0, 9.46027946D0, 9.46028042D0, 9.46028233D0,
     &   9.46028328D0, 9.46028423D0, 9.46028519D0, 9.46028709D0,
     &   9.46028805D0, 9.46028900D0, 9.46029091D0, 9.46029186D0/
       DATA  (ESA  (I), I=1401,1500) /
     &   9.46029377D0, 9.46029568D0, 9.46030045D0, 9.46030426D0,
     &   9.46030617D0, 9.46030807D0, 9.46030998D0, 9.46031094D0,
     &   9.46031189D0, 9.46031284D0, 9.46031475D0, 9.46031570D0,
     &   9.46031666D0, 9.46031761D0, 9.46031952D0, 9.46032047D0,
     &   9.46032143D0, 9.46032333D0, 9.46032429D0, 9.46032619D0,
     &   9.46032715D0, 9.46032906D0, 9.46033096D0, 9.46033287D0,
     &   9.46033478D0, 9.46033669D0, 9.46033955D0, 9.46034145D0,
     &   9.46034527D0, 9.46034908D0, 9.46035290D0, 9.46035862D0,
     &   9.46036530D0, 9.46037388D0, 9.46038628D0, 9.46040726D0,
     &   9.46045494D0, 9.46059000D0, 9.46081000D0, 9.46103000D0,
     &   9.46125000D0, 9.46147000D0, 9.46169000D0, 9.46191000D0,
     &   9.46213000D0, 9.46235000D0, 9.46257000D0, 9.46279000D0,
     &   9.46301000D0, 9.46323000D0, 9.46345000D0, 9.46367000D0,
     &   9.46389000D0, 9.46411000D0, 9.46433000D0, 9.46455000D0,
     &   9.46477000D0, 9.46499000D0, 9.46521000D0, 9.46543000D0,
     &   9.46565000D0, 9.46587000D0, 9.46609000D0, 9.46631000D0,
     &   9.46653000D0, 9.46675000D0, 9.46697000D0, 9.46719000D0,
     &   9.46741000D0, 9.46763000D0, 9.46785000D0, 9.46807000D0,
     &   9.46829000D0, 9.46851000D0, 9.46873000D0, 9.46895000D0,
     &   9.46917000D0, 9.46939000D0, 9.46961000D0, 9.46983000D0,
     &   9.47005000D0, 9.47027000D0, 9.47049000D0, 9.47071000D0,
     &   9.47093000D0, 9.47115000D0, 9.47137000D0, 9.47337000D0,
     &   9.47500000D0, 9.47700000D0, 9.48000000D0, 9.48400000D0,
     &   9.49000000D0, 9.49500000D0, 9.50500000D0, 9.51000000D0,
     &   9.51500000D0, 9.52000000D0, 9.52500000D0, 9.53000000D0/
       DATA  (ESA  (I), I=1501,1600) /
     &   9.54000000D0, 9.55000000D0, 9.60000000D0, 9.70000000D0,
     &   9.80000000D0, 9.90000000D0, 9.95000000D0, 9.97500000D0,
     &   9.99000000D0,10.00000000D0,10.01000000D0,10.01100000D0,
     &  10.01200000D0,10.01226000D0,10.01281000D0,10.01336000D0,
     &  10.01391000D0,10.01446000D0,10.01501000D0,10.01556000D0,
     &  10.01611000D0,10.01666000D0,10.01721000D0,10.01776000D0,
     &  10.01831000D0,10.01886000D0,10.01941000D0,10.01996000D0,
     &  10.02051000D0,10.02106000D0,10.02161000D0,10.02216000D0,
     &  10.02250000D0,10.02253750D0,10.02257500D0,10.02261250D0,
     &  10.02265000D0,10.02268750D0,10.02272500D0,10.02276250D0,
     &  10.02280000D0,10.02283750D0,10.02287500D0,10.02291250D0,
     &  10.02295000D0,10.02298750D0,10.02302500D0,10.02306250D0,
     &  10.02310000D0,10.02313750D0,10.02317500D0,10.02321250D0,
     &  10.02322000D0,10.02322500D0,10.02323000D0,10.02323400D0,
     &  10.02323700D0,10.02324000D0,10.02324200D0,10.02324400D0,
     &  10.02324600D0,10.02324800D0,10.02324930D0,10.02324950D0,
     &  10.02324960D0,10.02324980D0,10.02324988D0,10.02324994D0,
     &  10.02325000D0,10.02325060D0,10.02325150D0,10.02325250D0,
     &  10.02325340D0,10.02325440D0,10.02325540D0,10.02325630D0,
     &  10.02325680D0,10.02325730D0,10.02325780D0,10.02325850D0,
     &  10.02325900D0,10.02325950D0,10.02325980D0,10.02325990D0,
     &  10.02325995D0,10.02326000D0,10.02326005D0,10.02326010D0,
     &  10.02326050D0,10.02326100D0,10.02326150D0,10.02326390D0,
     &  10.02326490D0,10.02326680D0,10.02326770D0,10.02326870D0,
     &  10.02326970D0,10.02327060D0,10.02327160D0,10.02327250D0/
       DATA  (ESA  (I), I=1601,1700) /
     &  10.02327350D0,10.02327440D0,10.02327540D0,10.02327630D0,
     &  10.02327730D0,10.02327820D0,10.02328010D0,10.02328110D0,
     &  10.02328210D0,10.02328300D0,10.02328490D0,10.02328590D0,
     &  10.02328750D0,10.02329000D0,10.02330000D0,10.02331000D0,
     &  10.02332000D0,10.02333000D0,10.02334000D0,10.02335000D0,
     &  10.02336250D0,10.02339000D0,10.02340000D0,10.02341000D0,
     &  10.02342000D0,10.02343750D0,10.02347500D0,10.02351250D0,
     &  10.02355000D0,10.02358750D0,10.02362500D0,10.02366250D0,
     &  10.02370000D0,10.02373750D0,10.02377500D0,10.02381250D0,
     &  10.02385000D0,10.02388750D0,10.02392500D0,10.02396250D0,
     &  10.02400000D0,10.02436000D0,10.02491000D0,10.02546000D0,
     &  10.02656000D0,10.02766000D0,10.02876000D0,10.02986000D0,
     &  10.03096000D0,10.03206000D0,10.03316000D0,10.03426000D0,
     &  10.03500000D0,10.03600000D0,10.03700000D0,10.03800000D0,
     &  10.03900000D0,10.04000000D0,10.04500000D0,10.05000000D0,
     &  10.05500000D0,10.06000000D0,10.06500000D0,10.07000000D0,
     &  10.07500000D0,10.08000000D0,10.20000000D0,10.25000000D0,
     &  10.26000000D0,10.27000000D0,10.28000000D0,10.29000000D0,
     &  10.29500000D0,10.30000000D0,10.31000000D0,10.32000000D0,
     &  10.33000000D0,10.34000000D0,10.34420000D0,10.34493333D0,
     &  10.34566667D0,10.34640000D0,10.34713333D0,10.34786667D0,
     &  10.34860000D0,10.34933333D0,10.35006667D0,10.35080000D0,
     &  10.35153333D0,10.35226667D0,10.35300000D0,10.35309167D0,
     &  10.35318333D0,10.35327500D0,10.35336667D0,10.35345833D0,
     &  10.35355000D0,10.35364167D0,10.35373333D0,10.35382500D0/
       DATA  (ESA  (I), I=1701,1800) /
     &  10.35391667D0,10.35400833D0,10.35410000D0,10.35419167D0,
     &  10.35428333D0,10.35437500D0,10.35440000D0,10.35446667D0,
     &  10.35455833D0,10.35465000D0,10.35474167D0,10.35483334D0,
     &  10.35492500D0,10.35501667D0,10.35510834D0,10.35512330D0,
     &  10.35514660D0,10.35515710D0,10.35516340D0,10.35516780D0,
     &  10.35517110D0,10.35517370D0,10.35517580D0,10.35517760D0,
     &  10.35517920D0,10.35518060D0,10.35518180D0,10.35518290D0,
     &  10.35518390D0,10.35518480D0,10.35518570D0,10.35518650D0,
     &  10.35518720D0,10.35518790D0,10.35518860D0,10.35518930D0,
     &  10.35518990D0,10.35519050D0,10.35519110D0,10.35519170D0,
     &  10.35519230D0,10.35519280D0,10.35519340D0,10.35519400D0,
     &  10.35519460D0,10.35519530D0,10.35519600D0,10.35519680D0,
     &  10.35519770D0,10.35519970D0,10.35520000D0,10.35520100D0,
     &  10.35520230D0,10.35520320D0,10.35520400D0,10.35520470D0,
     &  10.35520540D0,10.35520600D0,10.35520660D0,10.35520720D0,
     &  10.35520770D0,10.35520830D0,10.35520890D0,10.35520950D0,
     &  10.35521010D0,10.35521070D0,10.35521140D0,10.35521210D0,
     &  10.35521280D0,10.35521350D0,10.35521430D0,10.35521520D0,
     &  10.35521610D0,10.35521710D0,10.35521820D0,10.35521940D0,
     &  10.35522080D0,10.35522240D0,10.35522420D0,10.35522630D0,
     &  10.35522890D0,10.35523220D0,10.35523660D0,10.35524290D0,
     &  10.35525340D0,10.35527670D0,10.35529000D0,10.35529300D0,
     &  10.35529700D0,10.35531000D0,10.35532500D0,10.35538334D0,
     &  10.35547500D0,10.35556667D0,10.35565834D0,10.35575000D0,
     &  10.35584167D0,10.35593334D0,10.35602500D0,10.35611667D0/
       DATA  (ESA  (I), I=1801,1900) /
     &  10.35620834D0,10.35630000D0,10.35639167D0,10.35648334D0,
     &  10.35657500D0,10.35666667D0,10.35740000D0,10.35813333D0,
     &  10.35886667D0,10.35960000D0,10.36033333D0,10.36106667D0,
     &  10.36180000D0,10.36326667D0,10.36473333D0,10.36546667D0,
     &  10.36620000D0,10.37000000D0,10.37500000D0,10.38000000D0,
     &  10.38500000D0,10.39000000D0,10.39500000D0,10.40000000D0,
     &  10.40500000D0,10.41000000D0,10.41500000D0,10.42000000D0,
     &  10.42500000D0,10.43000000D0,10.43500000D0,10.44000000D0,
     &  10.44500000D0,10.45000000D0,10.45500000D0,10.46000000D0,
     &  10.46500000D0,10.47000000D0,10.47300000D0,10.52897000D0,
     &  10.54217000D0,10.54889000D0,10.55317000D0,10.55622000D0,
     &  10.55855000D0,10.56042000D0,10.56197000D0,10.56328000D0,
     &  10.56442000D0,10.56543000D0,10.56633000D0,10.56714000D0,
     &  10.56788000D0,10.56857000D0,10.56921000D0,10.56980000D0,
     &  10.57036000D0,10.57090000D0,10.57141000D0,10.57189000D0,
     &  10.57237000D0,10.57282000D0,10.57327000D0,10.57371000D0,
     &  10.57415000D0,10.57459000D0,10.57503000D0,10.57547000D0,
     &  10.57594000D0,10.57643000D0,10.57695000D0,10.57755000D0,
     &  10.57829000D0,10.58000000D0,10.58171000D0,10.58245000D0,
     &  10.58305000D0,10.58357000D0,10.58406000D0,10.58453000D0,
     &  10.58497000D0,10.58541000D0,10.58585000D0,10.58629000D0,
     &  10.58673000D0,10.58718000D0,10.58763000D0,10.58811000D0,
     &  10.58859000D0,10.58910000D0,10.58964000D0,10.59020000D0,
     &  10.59079000D0,10.59143000D0,10.59212000D0,10.59286000D0,
     &  10.59367000D0,10.59457000D0,10.59558000D0,10.59671000D0/
       DATA  (ESA  (I), I=1901,2000) /
     &  10.59803000D0,10.59958000D0,10.60145000D0,10.60378000D0,
     &  10.60683000D0,10.61111000D0,10.61783000D0,10.63103000D0,
     &  10.68700000D0,10.69000000D0,10.71309000D0,10.72975000D0,
     &  10.74256000D0,10.75286000D0,10.76141000D0,10.76869000D0,
     &  10.77500000D0,10.78057000D0,10.78554000D0,10.79004000D0,
     &  10.79414000D0,10.79791000D0,10.80141000D0,10.80468000D0,
     &  10.80775000D0,10.81065000D0,10.81341000D0,10.81604000D0,
     &  10.81858000D0,10.82102000D0,10.82339000D0,10.82570000D0,
     &  10.82796000D0,10.83019000D0,10.83240000D0,10.83460000D0,
     &  10.83681000D0,10.83906000D0,10.84135000D0,10.84374000D0,
     &  10.84626000D0,10.84900000D0,10.85212000D0,10.85601000D0,
     &  10.86500000D0,10.87288000D0,10.87627000D0,10.87895000D0,
     &  10.88128000D0,10.88340000D0,10.88539000D0,10.88728000D0,
     &  10.88910000D0,10.89088000D0,10.89262000D0,10.89434000D0,
     &  10.89605000D0,10.89775000D0,10.89946000D0,10.90119000D0,
     &  10.90292000D0,10.90468000D0,10.90648000D0,10.90830000D0,
     &  10.91017000D0,10.91208000D0,10.91406000D0,10.91609000D0,
     &  10.91820000D0,10.92038000D0,10.92266000D0,10.92504000D0,
     &  10.92754000D0,10.93017000D0,10.93295000D0,10.93590000D0,
     &  10.93905000D0,10.94242000D0,10.94606000D0,10.95000000D0,
     &  10.97500000D0,10.97638000D0,10.97771000D0,10.97900000D0,
     &  10.98025000D0,10.98146000D0,10.98263000D0,10.98377000D0,
     &  10.98489000D0,10.98598000D0,10.98705000D0,10.98810000D0,
     &  10.98913000D0,10.99014000D0,10.99114000D0,10.99213000D0,
     &  10.99310000D0,10.99407000D0,10.99504000D0,10.99600000D0/
       DATA  (ESA  (I), I=2001,2100) /
     &  10.99697000D0,10.99793000D0,10.99890000D0,10.99988000D0,
     &  11.00087000D0,11.00188000D0,11.00290000D0,11.00396000D0,
     &  11.00506000D0,11.00621000D0,11.00742000D0,11.00873000D0,
     &  11.01018000D0,11.01186000D0,11.01399000D0,11.01900000D0,
     &  11.02401000D0,11.02614000D0,11.02782000D0,11.02927000D0,
     &  11.03058000D0,11.03179000D0,11.03294000D0,11.03404000D0,
     &  11.03510000D0,11.03612000D0,11.03713000D0,11.03812000D0,
     &  11.03910000D0,11.04007000D0,11.04103000D0,11.04200000D0,
     &  11.04296000D0,11.04392000D0,11.04490000D0,11.04587000D0,
     &  11.04686000D0,11.04786000D0,11.04887000D0,11.04990000D0,
     &  11.05095000D0,11.05202000D0,11.05311000D0,11.05423000D0,
     &  11.05537000D0,11.05654000D0,11.05775000D0,11.05900000D0,
     &  11.06029000D0,11.06162000D0,11.06300000D0,11.07000000D0,
     &  11.09200000D0,11.11500000D0,11.13700000D0,11.16000000D0,
     &  11.18200000D0,11.20500000D0,11.22700000D0,11.25000000D0,
     &  11.27300000D0,11.29500000D0,11.31800000D0,11.34000000D0,
     &  11.50000000D0,11.65500000D0,11.67700000D0,11.70000000D0,
     &  11.72200000D0,11.74500000D0,11.76700000D0,11.79000000D0,
     &  11.81200000D0,11.83500000D0,11.85800000D0,11.88000000D0,
     &  11.90300000D0,11.92500000D0,11.94800000D0,11.97000000D0,
     &  11.99300000D0,12.01500000D0,12.03800000D0,12.06000000D0,
     &  12.08300000D0,12.10500000D0,12.12700000D0,12.15000000D0,
     &  12.17200000D0,12.19500000D0,12.21700000D0,12.24000000D0,
     &  12.26200000D0,12.28500000D0,12.30700000D0,12.33000000D0,
     &  12.35200000D0,12.37500000D0,12.39800000D0,12.42000000D0/
       DATA  (ESA  (I), I=2101,2180) /
     &  12.44300000D0,12.46500000D0,12.48800000D0,12.51000000D0,
     &  12.53300000D0,12.55500000D0,12.57800000D0,12.60000000D0,
     &  12.62300000D0,12.64500000D0,12.66700000D0,12.69000000D0,
     &  12.71200000D0,12.73500000D0,12.75700000D0,12.78000000D0,
     &  12.80200000D0,12.82500000D0,12.84700000D0,12.87000000D0,
     &  12.89200000D0,12.91500000D0,12.93800000D0,12.96000000D0,
     &  12.98300000D0,13.00500000D0,13.02800000D0,13.05000000D0,
     &  13.07300000D0,13.09500000D0,13.11800000D0,13.14000000D0,
     &  13.16300000D0,13.18500000D0,13.20800000D0,13.23000000D0,
     &  13.25200000D0,13.27500000D0,13.29700000D0,13.32000000D0,
     &  13.34200000D0,13.36500000D0,13.38700000D0,13.41000000D0,
     &  13.43200000D0,13.45500000D0,13.47700000D0,13.50000000D0,
     &  13.75000000D0,14.00000000D0,14.04000000D0,16.00000000D0,
     &  17.00000000D0,20.00000000D0,21.95000000D0,22.05000000D0,
     &  25.00000000D0,25.01000000D0,27.50000000D0,27.60000000D0,
     &  27.66000000D0,29.00000000D0,29.93000000D0,30.10000000D0,
     &  30.38000000D0,30.80000000D0,31.10000000D0,31.29000000D0,
     &  33.20000000D0,33.30000000D0,33.89000000D0,34.00000000D0,
     &  34.50000000D0,34.70000000D0,34.86000000D0,35.01000000D0,
     &  35.45000000D0,36.10000000D0,36.38000000D0,38.29000000D0/
  
         DATA ((DAS  (I,J), I=   1, 100), J=1,1) /
     &  -9.28997146E-04,-9.90335611E-04,-1.05020367E-03,-1.11149675E-03,
     &  -1.17695280E-03,-1.20567985E-03,-1.25774289E-03,-1.34911843E-03,
     &  -1.39220179E-03,-1.43311112E-03,-1.48891375E-03,-1.54208784E-03,
     &  -1.60568785E-03,-1.64873309E-03,-1.70018030E-03,-1.75165409E-03,
     &  -1.80407130E-03,-1.85619598E-03,-1.90093793E-03,-1.95784202E-03,
     &  -2.00434458E-03,-2.06152636E-03,-2.10671141E-03,-2.16199719E-03,
     &  -2.21221772E-03,-2.26334431E-03,-2.32228291E-03,-2.35585406E-03,
     &  -2.37002229E-03,-2.42153684E-03,-2.47519784E-03,-2.52680313E-03,
     &  -2.58030057E-03,-2.63355377E-03,-2.69013728E-03,-2.74897760E-03,
     &  -2.80907588E-03,-2.87094430E-03,-2.93362600E-03,-3.00010184E-03,
     &  -3.05059905E-03,-3.11965538E-03,-3.18577797E-03,-3.23681355E-03,
     &  -3.30533558E-03,-3.37634731E-03,-3.42930138E-03,-3.50650377E-03,
     &  -3.56794929E-03,-3.64519345E-03,-4.09354079E-03,-4.56698756E-03,
     &  -5.26583704E-03,-6.15133324E-03,-6.45676569E-03,-6.53693091E-03,
     &  -6.77529289E-03,-7.09867761E-03,-7.43710636E-03,-7.78760495E-03,
     &  -8.13293373E-03,-8.25897128E-03,-8.47985848E-03,-8.83803685E-03,
     &  -9.13607453E-03,-9.45501657E-03,-9.70748466E-03,-9.94651976E-03,
     &  -9.97257998E-03,-1.00485429E-02,-1.00889494E-02,-1.01019698E-02,
     &  -1.00024426E-02,-9.75718110E-03,-9.37571490E-03,-8.76971195E-03,
     &  -7.97589583E-03,-7.04708535E-03,-6.20102182E-03,-5.93337946E-03,
     &  -5.46169457E-03,-5.60091473E-03,-5.01696545E-03,-4.86209505E-03,
     &  -4.77075169E-03,-5.13901172E-03,-5.62170963E-03,-6.04376106E-03,
     &  -6.46691652E-03,-6.76811166E-03,-6.87462840E-03,-7.00613427E-03,
     &  -7.11976770E-03,-6.98541439E-03,-7.08993039E-03,-7.24410450E-03,
     &  -6.89904896E-03,-6.54881759E-03,-6.06228929E-03,-5.81692925E-03/
  
         DATA ((DAS  (I,J), I= 101, 200), J=1,1) /
     &  -5.52764618E-03,-5.24270087E-03,-4.90380432E-03,-4.53817409E-03,
     &  -4.13304507E-03,-3.47284805E-03,-2.82578927E-03,-2.19186875E-03,
     &  -1.50374032E-03,-7.69934058E-04, 7.53485913E-04, 1.43295076E-03,
     &   2.13321556E-03, 2.87161358E-03, 4.53362244E-03, 5.89263422E-03,
     &   7.49937460E-03, 1.17559873E-02, 1.61944899E-02, 1.78351554E-02,
     &   1.87956204E-02, 1.95292699E-02, 2.01310273E-02, 2.06179290E-02,
     &   2.10666280E-02, 2.13830863E-02, 2.16919085E-02, 2.20050918E-02,
     &   2.22280438E-02, 2.24429882E-02, 2.25666342E-02, 2.26944175E-02,
     &   2.28157488E-02, 2.29356488E-02, 2.31289173E-02, 2.31346150E-02,
     &   2.30236905E-02, 2.30375163E-02, 2.29025863E-02, 2.28404303E-02,
     &   2.28155638E-02, 2.26730269E-02, 2.23502205E-02, 2.20130464E-02,
     &   2.16003319E-02, 2.09455070E-02, 2.06263278E-02, 2.00445559E-02,
     &   1.94622510E-02, 1.86402385E-02, 1.75712675E-02, 1.67545548E-02,
     &   1.65561881E-02, 1.59623289E-02, 1.53684697E-02, 1.50418614E-02,
     &   1.48562743E-02, 1.46432357E-02, 1.40472815E-02, 1.38765876E-02,
     &   1.36565127E-02, 1.34600956E-02, 1.33379826E-02, 1.32236420E-02,
     &   1.30898350E-02, 1.29875709E-02, 1.28439758E-02, 1.27775376E-02,
     &   1.24169391E-02, 1.20535767E-02, 1.16996789E-02, 1.13920225E-02,
     &   1.10342301E-02, 1.06620789E-02, 1.02793028E-02, 9.95353134E-03,
     &   9.55276979E-03, 9.14887128E-03, 8.81382659E-03, 8.62705305E-03,
     &   8.27202193E-03, 8.10916592E-03, 7.72179805E-03, 7.39468822E-03,
     &   6.98573900E-03, 6.62981464E-03, 6.18073885E-03, 5.78271489E-03,
     &   5.36875875E-03, 4.83781035E-03, 4.55665197E-03, 4.36882640E-03,
     &   3.96876803E-03, 3.75212257E-03, 3.51914920E-03, 3.27260986E-03,
     &   3.01013473E-03, 2.73910506E-03, 2.47071414E-03, 1.89029588E-03/
  
         DATA ((DAS  (I,J), I= 201, 300), J=1,1) /
     &   1.19926193E-03, 7.96806819E-04, 6.42366745E-04, 4.90252722E-04,
     &   3.30944504E-04, 1.63481317E-04,-3.61331045E-06,-1.82423503E-04,
     &  -3.62173426E-04,-5.45029524E-04,-7.32604956E-04,-9.27953661E-04,
     &  -1.12665911E-03,-1.33233934E-03,-1.54071165E-03,-1.75698565E-03,
     &  -1.98435866E-03,-2.21946127E-03,-2.46391257E-03,-2.71539818E-03,
     &  -2.98483875E-03,-3.19318425E-03,-3.54644098E-03,-3.89035854E-03,
     &  -4.23529521E-03,-4.60462348E-03,-4.99916492E-03,-5.42550908E-03,
     &  -5.88292262E-03,-6.37398910E-03,-6.57830184E-03,-6.65741910E-03,
     &  -6.86600096E-03,-7.39919733E-03,-7.96406503E-03,-8.71259077E-03,
     &  -9.17062142E-03,-1.01704120E-02,-1.12469360E-02,-1.20579847E-02,
     &  -1.30660720E-02,-1.40573434E-02,-1.51271184E-02,-1.64761174E-02,
     &  -1.78251165E-02,-1.95563056E-02,-2.18682819E-02,-2.44376394E-02,
     &  -2.67773843E-02,-2.92083266E-02,-3.24340561E-02,-3.59059316E-02,
     &  -3.93291014E-02,-4.40055545E-02,-4.58785773E-02,-4.80337065E-02,
     &  -4.97293024E-02,-5.13753204E-02,-5.30525069E-02,-5.48118348E-02,
     &  -5.55427692E-02,-5.61733725E-02,-5.41919161E-02,-5.29823584E-02,
     &  -5.76299744E-02,-5.72211689E-02,-4.35620236E-02,-4.98990814E-02,
     &  -4.76171494E-02,-4.16442291E-02,-3.47664065E-02,-2.67337583E-02,
     &  -1.57733593E-02,-5.59654889E-03, 5.07246483E-03, 1.63490794E-02,
     &   2.79545379E-02, 3.78082190E-02, 4.52457900E-02, 5.11326141E-02,
     &   5.63575609E-02, 5.99985703E-02, 6.23453021E-02, 6.38138083E-02,
     &   6.47673571E-02, 6.50633790E-02, 6.42334719E-02, 6.30368452E-02,
     &   6.24050478E-02, 6.13375730E-02, 5.97167004E-02, 5.71426574E-02,
     &   5.61392712E-02, 5.53751713E-02, 5.38316752E-02, 5.24664295E-02,
     &   5.13945894E-02, 5.00338342E-02, 4.88264757E-02, 4.79689842E-02/
  
         DATA ((DAS  (I,J), I= 301, 400), J=1,1) /
     &   4.87967544E-02, 4.65349582E-02, 4.57231745E-02, 4.48555640E-02,
     &   4.20570855E-02, 3.99983857E-02, 3.78511480E-02, 3.54570956E-02,
     &   3.29772769E-02, 3.12675239E-02, 2.99108128E-02, 2.87592731E-02,
     &   2.77281535E-02, 2.68002240E-02, 2.59013574E-02, 2.49711691E-02,
     &   2.40032646E-02, 2.31272854E-02, 2.24057605E-02, 2.17795687E-02,
     &   2.12094981E-02, 2.07122796E-02, 2.01942711E-02, 1.97600073E-02,
     &   1.93222140E-02, 1.91935838E-02, 1.94028768E-02, 1.89453827E-02,
     &   1.83758864E-02, 1.79403166E-02, 1.75712230E-02, 1.72399020E-02,
     &   1.69351349E-02, 1.66323508E-02, 1.63526763E-02, 1.60977736E-02,
     &   1.58341327E-02, 1.56032792E-02, 1.53767113E-02, 1.51252183E-02,
     &   1.49488063E-02, 1.47545312E-02, 1.45456965E-02, 1.43676441E-02,
     &   1.41911284E-02, 1.40205635E-02, 1.38610819E-02, 1.37169133E-02,
     &   1.35249591E-02, 1.33821788E-02, 1.32503886E-02, 1.31087418E-02,
     &   1.29269785E-02, 1.28382818E-02, 1.27110595E-02, 1.25848076E-02,
     &   1.22356212E-02, 1.14741857E-02, 1.02775668E-02, 9.39604073E-03,
     &   8.71373089E-03, 8.16690423E-03, 7.69956297E-03, 7.29434306E-03,
     &   6.94226373E-03, 6.90972870E-03, 6.49904463E-03, 6.21624015E-03,
     &   6.11870397E-03, 5.88335096E-03, 5.65842739E-03, 5.63702232E-03,
     &   5.44636998E-03, 5.24884883E-03, 5.15438160E-03, 5.06068075E-03,
     &   4.89346548E-03, 4.73972965E-03, 4.59952319E-03, 4.47150240E-03,
     &   4.39671296E-03, 4.34563839E-03, 4.22115467E-03, 4.09756766E-03,
     &   4.08521458E-03, 3.98525899E-03, 3.89123130E-03, 3.84823626E-03,
     &   3.80389942E-03, 3.71643780E-03, 3.61442608E-03, 3.51295079E-03,
     &   3.48949726E-03, 3.42598135E-03, 3.38652363E-03, 3.35318947E-03,
     &   3.28833909E-03, 3.22051183E-03, 3.21330560E-03, 3.16286342E-03/
  
         DATA ((DAS  (I,J), I= 401, 500), J=1,1) /
     &   3.08085754E-03, 3.07201933E-03, 3.10556014E-03, 3.07598359E-03,
     &   3.06489239E-03, 3.14857664E-03, 3.16022797E-03, 3.16886064E-03,
     &   3.18209722E-03, 3.21357108E-03, 3.25946077E-03, 3.31612285E-03,
     &   3.32297618E-03, 3.36998555E-03, 3.37705419E-03, 3.41196252E-03,
     &   3.43803270E-03, 3.51142944E-03, 3.51987027E-03, 3.56054915E-03,
     &   3.56291169E-03, 3.56551497E-03, 3.58325269E-03, 3.59570962E-03,
     &   3.59866722E-03, 3.61655759E-03, 3.61835255E-03, 3.62849847E-03,
     &   3.63136751E-03, 3.65078764E-03, 3.66317989E-03, 3.70424288E-03,
     &   3.71193794E-03, 3.78538581E-03, 3.85509865E-03, 3.90250025E-03,
     &   3.91280815E-03, 4.06802921E-03, 4.09713421E-03, 4.27346121E-03,
     &   4.41689135E-03, 4.47806265E-03, 4.51998312E-03, 4.54080209E-03,
     &   4.75704223E-03, 4.80077127E-03, 4.92312096E-03, 5.05244079E-03,
     &   5.09760292E-03, 5.23205959E-03, 5.32533852E-03, 5.34461181E-03,
     &   5.35350710E-03, 5.40923184E-03, 5.43123676E-03, 5.45361174E-03,
     &   5.55848968E-03, 5.56933621E-03, 5.59387249E-03, 5.60034604E-03,
     &   5.60010130E-03, 5.60137172E-03, 5.59725446E-03, 5.59281410E-03,
     &   5.58790135E-03, 5.56943875E-03, 5.54434810E-03, 5.51598014E-03,
     &   5.46932218E-03, 5.42005673E-03, 5.41455936E-03, 5.32630585E-03,
     &   5.24844507E-03, 5.16773688E-03, 5.15230482E-03, 5.03254512E-03,
     &   5.01899553E-03, 4.98360523E-03, 4.96807529E-03, 4.98127100E-03,
     &   4.97767009E-03, 4.90816365E-03, 4.85877530E-03, 4.82956502E-03,
     &   4.71890090E-03, 4.61207836E-03, 4.58854503E-03, 4.57344516E-03,
     &   4.55467270E-03, 4.55021080E-03, 4.53666727E-03, 4.53397660E-03,
     &   4.52504896E-03, 4.51000741E-03, 4.48767374E-03, 4.48230303E-03,
     &   4.34810149E-03, 4.17176998E-03, 4.26198062E-03, 4.51784920E-03/
  
         DATA ((DAS  (I,J), I= 501, 600), J=1,1) /
     &   4.65652655E-03, 4.71000445E-03, 4.78461733E-03, 4.77924119E-03,
     &   4.80271543E-03, 4.80528175E-03, 4.72247435E-03, 4.63910366E-03,
     &   4.51852985E-03, 4.36685169E-03, 4.18969516E-03, 3.96410611E-03,
     &   3.67763314E-03, 3.29678915E-03, 2.77061615E-03, 2.01931095E-03,
     &   8.81014112E-04, 5.82846378E-04, 2.51460299E-04,-1.18971594E-04,
     &  -5.35134086E-04,-1.00852660E-03,-1.54957733E-03,-2.17500243E-03,
     &  -2.31205092E-03,-2.45355586E-03,-2.59962292E-03,-2.75059214E-03,
     &  -2.90660942E-03,-3.06794373E-03,-3.23511385E-03,-3.40793114E-03,
     &  -3.58724872E-03,-3.77317485E-03,-4.69528487E-03,-5.41667579E-03,
     &  -5.81402594E-03,-6.09349210E-03,-6.38563422E-03,-6.69173345E-03,
     &  -7.01294130E-03,-7.35034813E-03,-7.70518944E-03,-7.88957550E-03,
     &  -8.07874086E-03,-8.27303939E-03,-8.47269596E-03,-8.67793488E-03,
     &  -8.88888033E-03,-9.10579291E-03,-9.32902849E-03,-9.55880499E-03,
     &  -9.79535738E-03,-1.00390671E-02,-1.02902647E-02,-1.05493953E-02,
     &  -1.08167768E-02,-1.10927232E-02,-1.13776122E-02,-1.16720326E-02,
     &  -1.19763166E-02,-1.22910566E-02,-1.26168831E-02,-1.29544351E-02,
     &  -1.33042520E-02,-1.36670165E-02,-1.40434617E-02,-1.44344018E-02,
     &  -1.48406859E-02,-1.52633609E-02,-1.57029403E-02,-1.61611302E-02,
     &  -1.66388444E-02,-1.71373629E-02,-1.76580111E-02,-1.82025088E-02,
     &  -1.87721467E-02,-1.93688039E-02,-1.99946570E-02,-2.06517041E-02,
     &  -2.13424530E-02,-2.20695886E-02,-2.28360832E-02,-2.32350964E-02,
     &  -2.36452243E-02,-2.40668758E-02,-2.45005794E-02,-2.49468731E-02,
     &  -2.54063275E-02,-2.58796053E-02,-2.63671888E-02,-2.68697490E-02,
     &  -2.73881811E-02,-2.79230195E-02,-2.84752237E-02,-2.90461010E-02,
     &  -2.96355117E-02,-3.02448733E-02,-3.08752994E-02,-3.15278881E-02/
  
         DATA ((DAS  (I,J), I= 601, 700), J=1,1) /
     &  -3.22037760E-02,-3.29043436E-02,-3.36309189E-02,-3.43841394E-02,
     &  -3.51672545E-02,-3.59811444E-02,-3.68277331E-02,-3.77097407E-02,
     &  -3.86271144E-02,-3.95843477E-02,-4.05833342E-02,-4.16269407E-02,
     &  -4.27180384E-02,-4.38602751E-02,-4.50571374E-02,-4.63126490E-02,
     &  -4.76311665E-02,-4.90176914E-02,-5.04779563E-02,-5.20171281E-02,
     &  -5.36421608E-02,-5.60759592E-02,-5.71806650E-02,-5.91117334E-02,
     &  -6.11642656E-02,-6.33501939E-02,-6.56827789E-02,-6.81773476E-02,
     &  -7.08514389E-02,-7.37251981E-02,-7.68218788E-02,-8.01685088E-02,
     &  -8.37965887E-02,-8.77433871E-02,-9.08948116E-02,-1.00716070E-01,
     &  -1.12752975E-01,-1.27853454E-01,-1.47364763E-01,-1.73573194E-01,
     &  -2.10741850E-01,-2.69934477E-01,-3.61273795E-01,-5.53128425E-01,
     &  -1.16851198E+00,-1.23592294E+00,-1.31152839E+00,-1.39704305E+00,
     &  -1.49405186E+00,-1.60559709E+00,-1.73496575E+00,-1.88676754E+00,
     &  -2.06733728E+00,-2.28561291E+00,-2.55460565E+00,-2.89412342E+00,
     &  -3.32105441E+00,-3.92843620E+00,-3.99922123E+00,-5.58420902E+00,
     &  -6.73941012E+00,-7.66759138E+00,-4.78201803E+00,-9.09922016E+00,
     &  -9.29668799E+00,-1.00714938E+01,-1.05082016E+01,-1.08114658E+01,
     &  -1.10914768E+01,-1.12860249E+01,-1.14425964E+01,-1.15280669E+01,
     &  -1.15889258E+01,-1.15922889E+01,-1.15569838E+01,-1.14647351E+01,
     &  -1.13660492E+01,-1.11526140E+01,-1.09605530E+01,-1.07235178E+01,
     &  -1.02307611E+01,-9.74842625E+00,-9.21822843E+00,-8.64324243E+00,
     &  -8.72137313E+00,-8.13711497E+00,-7.48924022E+00,-6.77927968E+00,
     &  -5.60481919E+00,-4.75576836E+00,-3.43303560E+00,-1.96678084E+00,
     &   1.97987164E+00, 5.61411614E+00, 6.78690180E+00, 7.82733139E+00,
     &   8.44291524E+00, 9.24730845E+00, 9.24514025E+00, 9.76916868E+00/
  
         DATA ((DAS  (I,J), I= 701, 800), J=1,1) /
     &   1.02444270E+01, 1.06683818E+01, 1.09709153E+01, 1.12003619E+01,
     &   1.13174468E+01, 1.14339050E+01, 1.15177811E+01, 1.15726613E+01,
     &   1.16076032E+01, 8.99794375E+00, 9.52025172E+00, 1.14847810E+01,
     &   1.14165388E+01, 1.12474483E+01, 1.10981529E+01, 1.08779158E+01,
     &   1.06418761E+01, 1.03352022E+01, 1.00875151E+01, 9.35298152E+00,
     &   9.16787583E+00, 8.65083799E+00, 8.06818201E+00, 7.31879291E+00,
     &   6.39340492E+00, 5.38692329E+00, 4.43993616E+00, 3.70434393E+00,
     &   3.17356212E+00, 2.77391084E+00, 2.46272602E+00, 2.21383751E+00,
     &   2.01038291E+00, 1.84109096E+00, 1.69793969E+00, 1.57544781E+00,
     &   1.46942814E+00, 1.37678079E+00, 1.29513240E+00, 1.22263954E+00,
     &   1.15784789E+00, 1.09959480E+00, 1.04694024E+00, 9.99115558E-01,
     &   5.26662821E-01, 3.58923597E-01, 2.73179950E-01, 2.22425329E-01,
     &   1.85262757E-01, 1.59684236E-01, 1.40570893E-01, 1.25711186E-01,
     &   1.13818650E-01, 1.04081925E-01, 1.02929445E-01, 9.48961646E-02,
     &   8.80951665E-02, 8.22627716E-02, 7.72055389E-02, 7.27784070E-02,
     &   6.88704106E-02, 6.53952686E-02, 6.22845892E-02, 5.94838994E-02,
     &   5.69490963E-02, 5.46431968E-02, 5.25378506E-02, 5.06074752E-02,
     &   4.88310652E-02, 4.71908615E-02, 4.56718076E-02, 4.42608164E-02,
     &   4.29469049E-02, 4.17201909E-02, 4.05722665E-02, 3.94958379E-02,
     &   3.84850504E-02, 3.75330076E-02, 3.66351086E-02, 3.57869137E-02,
     &   3.49843529E-02, 3.42239315E-02, 3.35023514E-02, 3.28167492E-02,
     &   3.21644677E-02, 3.15431293E-02, 3.09505485E-02, 3.03847460E-02,
     &   2.98439945E-02, 2.93266531E-02, 2.88312410E-02, 2.83563643E-02,
     &   2.79007243E-02, 2.74633193E-02, 2.70430433E-02, 2.66388097E-02,
     &   2.62497104E-02, 2.58749685E-02, 2.55130165E-02, 2.51647136E-02/
  
         DATA ((DAS  (I,J), I= 801, 900), J=1,1) /
     &   2.48286183E-02, 2.45041113E-02, 2.41905790E-02, 2.38874691E-02,
     &   2.35941993E-02, 2.33103234E-02, 2.30354357E-02, 2.27691200E-02,
     &   2.25111429E-02, 2.22607739E-02, 2.20179003E-02, 2.17821944E-02,
     &   2.15533370E-02, 2.13310052E-02, 2.11150061E-02, 2.09049978E-02,
     &   2.07008067E-02, 2.05022080E-02, 2.03090205E-02, 2.01210191E-02,
     &   1.99380165E-02, 1.97598139E-02, 1.95863301E-02, 1.94174184E-02,
     &   1.92528086E-02, 1.90925456E-02, 1.89364768E-02, 1.87845055E-02,
     &   1.86365662E-02, 1.84926103E-02, 1.83526244E-02, 1.82166153E-02,
     &   1.80846247E-02, 1.79567069E-02, 1.78330369E-02, 1.77139688E-02,
     &   1.75998602E-02, 1.73133231E-02, 1.71901531E-02, 1.70699523E-02,
     &   1.69517061E-02, 1.68356935E-02, 1.67212419E-02, 1.66095795E-02,
     &   1.64997350E-02, 1.63919452E-02, 1.62972001E-02, 1.61806426E-02,
     &   1.60777897E-02, 1.59784569E-02, 1.58805870E-02, 1.57853327E-02,
     &   1.56916241E-02, 1.55995736E-02, 1.55090887E-02, 1.54204859E-02,
     &   1.53331505E-02, 1.26965269E-02, 1.08469509E-02, 9.21094105E-03,
     &   8.66115179E-03, 7.74483635E-03, 6.76648426E-03, 6.30849129E-03,
     &   5.78087431E-03, 5.71167372E-03, 5.35829586E-03, 5.14664341E-03,
     &   5.10747727E-03, 4.55875662E-03, 3.82167985E-03, 3.53243895E-03,
     &   3.19842432E-03, 2.87998595E-03, 2.48350769E-03, 2.03548766E-03,
     &   1.52763952E-03, 9.45573336E-04, 2.69542436E-04,-5.28685621E-04,
     &  -1.48953086E-03,-2.67180938E-03,-4.16715559E-03,-4.88396762E-03,
     &  -5.68762954E-03,-6.59547137E-03,-7.62974569E-03,-8.81951427E-03,
     &  -1.02035292E-02,-1.09844309E-02,-1.18353732E-02,-1.27663670E-02,
     &  -1.37892316E-02,-1.49184763E-02,-1.61716765E-02,-1.75708212E-02,
     &  -1.91429580E-02,-2.09221075E-02,-2.29533504E-02,-2.52939846E-02/
  
         DATA ((DAS  (I,J), I= 901,1000), J=1,1) /
     &  -2.80209650E-02,-3.10988796E-02,-3.31140386E-02,-3.53503112E-02,
     &  -3.78463807E-02,-4.06505347E-02,-4.38238501E-02,-4.74447398E-02,
     &  -5.16155931E-02,-5.64727353E-02,-6.22018256E-02,-6.90625308E-02,
     &  -7.74297773E-02,-8.78664235E-02,-1.01259615E-01,-1.19099397E-01,
     &  -1.44118602E-01,-1.82061199E-01,-2.49175303E-01,-3.67883025E-01,
     &  -5.37850388E-01,-6.36417361E-01,-7.44301530E-01,-1.01038093E+00,
     &  -1.10655685E+00,-1.13724363E+00,-1.25257933E+00,-1.29684992E+00,
     &  -1.35600396E+00,-1.39597087E+00,-1.40496067E+00,-1.43095745E+00,
     &  -1.47227861E+00,-1.48645340E+00,-1.49483849E+00,-1.49782539E+00,
     &  -1.49559578E+00,-1.48964139E+00,-1.47762396E+00,-1.46194962E+00,
     &  -1.44273603E+00,-1.41641601E+00,-1.38531952E+00,-1.34546156E+00,
     &  -1.30510577E+00,-1.25875602E+00,-1.20608954E+00,-1.13634173E+00,
     &  -1.06925196E+00,-9.82361639E-01,-9.00551051E-01,-7.81277313E-01,
     &  -6.51111224E-01,-4.56705076E-01,-2.87249855E-01,-9.20622999E-02,
     &   6.80434680E-03, 1.05672195E-01, 2.03902265E-01, 4.70340677E-01,
     &   6.64775276E-01, 7.94967010E-01, 9.14269677E-01, 9.96103616E-01,
     &   1.08302245E+00, 1.15013739E+00, 1.21991498E+00, 1.27260706E+00,
     &   1.31898223E+00, 1.35936655E+00, 1.39925273E+00, 1.43034015E+00,
     &   1.45668669E+00, 1.47595735E+00, 1.49165547E+00, 1.50369861E+00,
     &   1.50967427E+00, 1.51192961E+00, 1.50896670E+00, 1.50060639E+00,
     &   1.48645670E+00, 1.44497675E+00, 1.41901387E+00, 1.41022167E+00,
     &   1.37027929E+00, 1.31101809E+00, 1.26690622E+00, 1.15208312E+00,
     &   1.12092294E+00, 1.02476866E+00, 9.08517050E-01, 9.71630468E-01,
     &   8.32891237E-01, 7.47549739E-01, 6.96004040E-01, 5.89459234E-01,
     &   5.52306733E-01, 4.75349192E-01, 5.77237177E-01, 2.22574956E-01/
  
         DATA ((DAS  (I,J), I=1001,1100), J=1,1) /
     &   1.74310086E-01, 1.44209144E-01, 1.23427105E-01, 1.08163601E-01,
     &   9.64588547E-02, 8.71890182E-02, 7.96602977E-02, 7.34196933E-02,
     &   6.81569789E-02, 6.36446624E-02, 5.97563083E-02, 5.64190091E-02,
     &   5.34607394E-02, 5.08312192E-02, 4.84822643E-02, 4.63724972E-02,
     &   4.30206582E-02, 3.88370427E-02, 3.65936812E-02, 3.29174122E-02,
     &   3.00295142E-02, 2.71749152E-02, 2.31006167E-02, 1.85164805E-02,
     &   1.56375203E-02, 1.42972653E-02, 1.36000025E-02, 1.30843798E-02,
     &   1.27036058E-02, 1.23948031E-02, 1.21668124E-02, 1.19672737E-02,
     &   1.17986860E-02, 1.16548523E-02, 1.15301241E-02, 1.14484611E-02,
     &   1.13253650E-02, 1.12411420E-02, 1.11668357E-02, 1.11012996E-02,
     &   1.10437949E-02, 1.09932869E-02, 1.09492527E-02, 1.09112637E-02,
     &   1.08789220E-02, 1.08520613E-02, 1.07959599E-02, 1.08142913E-02,
     &   1.08034720E-02, 1.07983622E-02, 1.07981246E-02, 1.08062816E-02,
     &   1.08237085E-02, 1.08493761E-02, 1.08878732E-02, 1.09457210E-02,
     &   1.10380549E-02, 1.13356816E-02, 1.17288828E-02, 1.19161324E-02,
     &   1.20682675E-02, 1.22012786E-02, 1.23215287E-02, 1.24315150E-02,
     &   1.25332257E-02, 1.26282996E-02, 1.27166726E-02, 1.27991624E-02,
     &   1.28743398E-02, 1.29458564E-02, 1.29701029E-02, 1.30361789E-02,
     &   1.30924326E-02, 1.31508962E-02, 1.31921944E-02, 1.32338308E-02,
     &   1.32505032E-02, 1.32581512E-02, 1.32553567E-02, 1.32411194E-02,
     &   1.32142961E-02, 1.31734024E-02, 1.31095985E-02, 1.30318347E-02,
     &   1.29431413E-02, 1.28285553E-02, 1.26857405E-02, 1.25059543E-02,
     &   1.22813143E-02, 1.19943964E-02, 1.16074752E-02, 1.10504893E-02,
     &   1.08841079E-02, 1.04420560E-02, 9.77768318E-03, 9.70919816E-03,
     &   9.24940579E-03, 9.06244355E-03, 8.91359973E-03, 8.78684313E-03/
  
         DATA ((DAS  (I,J), I=1101,1200), J=1,1) /
     &   8.59033429E-03, 8.38169765E-03, 8.33610516E-03, 8.32948675E-03,
     &   8.29292464E-03, 8.22763417E-03, 8.19142124E-03, 8.20076674E-03,
     &   8.33518240E-03, 8.31907329E-03, 8.16895591E-03, 8.10763333E-03,
     &   7.99016561E-03, 7.88915515E-03, 7.78814468E-03, 7.68713422E-03,
     &   7.61518149E-03, 7.43903790E-03, 7.17566429E-03, 6.81354871E-03,
     &   6.58264561E-03, 6.22866991E-03, 5.99648520E-03, 6.11552851E-03,
     &   6.66636575E-03, 7.04343842E-03, 7.89304303E-03, 8.25119910E-03,
     &   8.54381805E-03, 8.86983728E-03, 9.12233992E-03, 9.06930861E-03,
     &   9.00208225E-03, 9.13200526E-03, 9.51321726E-03, 9.23188609E-03,
     &   8.88072939E-03, 8.94123539E-03, 9.05862384E-03, 9.14213997E-03,
     &   9.26312657E-03, 9.27744176E-03, 9.19323531E-03, 9.01472643E-03,
     &   8.90827934E-03, 8.70434541E-03, 8.67833252E-03, 8.81358996E-03,
     &   8.96647483E-03, 9.15743370E-03, 9.24170611E-03, 9.42020145E-03,
     &   9.49513179E-03, 9.39106123E-03, 9.48914048E-03, 9.71154177E-03,
     &   9.94782734E-03, 1.01870598E-02, 1.03290964E-02, 1.04495336E-02,
     &   1.05985354E-02, 1.07122111E-02, 1.07940759E-02, 1.08811558E-02,
     &   1.10050176E-02, 1.11117385E-02, 1.12052181E-02, 1.13016412E-02,
     &   1.11436958E-02, 1.06537565E-02, 1.05461283E-02, 1.06218454E-02,
     &   1.07813750E-02, 1.05916126E-02, 1.05884691E-02, 1.07227666E-02,
     &   1.08078303E-02, 1.00688855E-02, 9.28375632E-03, 9.02065721E-03,
     &   8.83161673E-03, 9.12799648E-03, 9.13387336E-03, 9.00767120E-03,
     &   8.89696550E-03, 8.83253153E-03, 8.74108721E-03, 8.61928982E-03,
     &   8.28045969E-03, 8.30310353E-03, 8.33079326E-03, 8.26853717E-03,
     &   8.24592305E-03, 8.23131323E-03, 8.28134945E-03, 8.30660709E-03,
     &   8.32048439E-03, 8.35802941E-03, 8.34493763E-03, 8.38575962E-03/
  
         DATA ((DAS  (I,J), I=1201,1300), J=1,1) /
     &   8.76436455E-03, 9.16859909E-03, 9.28216632E-03, 9.31570106E-03,
     &   9.33551168E-03, 9.20484276E-03, 9.47156968E-03, 9.80116388E-03,
     &   9.92708056E-03, 9.97928970E-03, 1.00693890E-02, 1.00826646E-02,
     &   9.99150545E-03, 9.83124470E-03, 9.77520133E-03, 9.88535324E-03,
     &   9.88382996E-03, 9.55673938E-03, 9.57111564E-03, 9.73656609E-03,
     &   9.69812591E-03, 9.52229454E-03, 9.43436190E-03, 9.46571809E-03,
     &   9.56804966E-03, 9.57369132E-03, 9.80280930E-03, 9.91322255E-03,
     &   1.01558047E-02, 1.04135483E-02, 1.04398087E-02, 1.04629797E-02,
     &   1.04707034E-02, 1.05476706E-02, 1.06876530E-02, 1.07517687E-02,
     &   1.08132447E-02, 1.09301677E-02, 1.10409172E-02, 1.10943497E-02,
     &   1.11466587E-02, 1.11979308E-02, 1.12482375E-02, 1.12976388E-02,
     &   1.13461860E-02, 1.13939231E-02, 1.14408885E-02, 1.14871158E-02,
     &   1.15326347E-02, 1.15774715E-02, 1.16216497E-02, 1.16651903E-02,
     &   1.17081122E-02, 1.17504324E-02, 1.17921661E-02, 1.18333271E-02,
     &   1.18739277E-02, 1.19139791E-02, 1.19534916E-02, 1.19924738E-02,
     &   1.20309334E-02, 1.20688776E-02, 1.21063122E-02, 1.21432426E-02,
     &   1.21796728E-02, 1.22156065E-02, 1.22510462E-02, 1.22859936E-02,
     &   1.23204497E-02, 1.23544145E-02, 1.23878872E-02, 1.24208659E-02,
     &   1.24533480E-02, 1.24789735E-02, 1.25168054E-02, 1.25782149E-02,
     &   1.26375106E-02, 1.26946017E-02, 1.27493651E-02, 1.28016375E-02,
     &   1.28512030E-02, 1.28977739E-02, 1.29409640E-02, 1.29807848E-02,
     &   1.30154193E-02, 1.30443425E-02, 1.30659655E-02, 1.30777724E-02,
     &   1.30755321E-02, 1.30742833E-02, 1.30514351E-02, 1.29891013E-02,
     &   1.28467559E-02, 1.25861322E-02, 1.24745211E-02, 1.19980847E-02,
     &   1.10730123E-02, 1.06321713E-02, 1.00010015E-02, 9.57239221E-03/
  
         DATA ((DAS  (I,J), I=1301,1400), J=1,1) /
     &   9.02899476E-03, 8.47810588E-03, 7.78030884E-03, 7.35729178E-03,
     &   6.87027915E-03, 6.30405429E-03, 5.63825145E-03, 4.84499983E-03,
     &   3.88515071E-03, 3.32596715E-03, 2.70198348E-03, 2.00157081E-03,
     &   1.21017105E-03, 3.09310396E-04,-7.24825173E-04,-1.92352076E-03,
     &  -3.32892160E-03,-5.00038325E-03,-5.70345251E-03,-6.14794981E-03,
     &  -6.61627285E-03,-7.12382363E-03,-7.60832522E-03,-8.11152086E-03,
     &  -6.77471508E-03,-9.21420032E-03,-9.81009330E-03,-1.04373917E-02,
     &  -1.10981495E-02,-1.17947902E-02,-1.25300791E-02,-1.33071313E-02,
     &  -1.41293450E-02,-1.50009320E-02,-1.59260049E-02,-1.69096153E-02,
     &  -1.79573547E-02,-1.90755539E-02,-2.02714062E-02,-2.15531179E-02,
     &  -2.29300904E-02,-2.44131310E-02,-2.60148021E-02,-2.77496191E-02,
     &  -2.96346303E-02,-3.16898897E-02,-3.39391692E-02,-3.64108560E-02,
     &  -3.91391160E-02,-4.21653632E-02,-4.55401116E-02,-4.93290425E-02,
     &  -5.36087037E-02,-5.84813788E-02,-6.40777527E-02,-7.05700315E-02,
     &  -7.81894787E-02,-8.72541433E-02,-9.82136869E-02,-1.11725227E-01,
     &  -1.28788263E-01, 9.57197063E-03,-1.81085680E-01,-2.24086287E-01,
     &  -2.90503880E-01,-4.06371986E-01,-6.57956992E-01,-8.18377078E-01,
     &  -1.58508567E+00,-2.21729872E+00,-2.67609963E+00,-3.02986380E+00,
     &   1.06283207E-02,-3.57573846E+00,-3.81242464E+00,-3.97714595E+00,
     &  -4.14436645E+00,-4.30912643E+00,-4.38855465E+00,-4.49987139E+00,
     &  -4.56729418E+00,-4.65086668E+00,-4.67101583E+00,-4.70801712E+00,
     &  -4.71624659E+00,-4.70625047E+00,-4.69099343E+00,-4.66796181E+00,
     &  -3.89084896E-02,-3.76541511E-02,-4.48108731E+00,-4.31922444E+00,
     &  -4.21873705E+00,-4.10545755E+00,-3.97485260E+00,-3.66431399E+00,
     &  -3.48325531E+00,-3.28704073E+00,-2.84102646E+00,-2.59413445E+00/
  
         DATA ((DAS  (I,J), I=1401,1500), J=1,1) /
     &  -7.78938539E-01,-1.45399283E+00, 1.84809841E-01, 1.48671571E+00,
     &   2.08640579E+00, 2.62892848E+00, 3.11102070E+00, 3.32773484E+00,
     &   3.52502502E+00, 3.70528768E+00, 4.01734086E+00, 4.14846493E+00,
     &   4.26557400E+00, 4.37343189E+00, 4.53175908E+00, 4.59347319E+00,
     &   4.64587360E+00, 4.71967436E+00, 4.74350091E+00, 4.76782785E+00,
     &   4.77000993E+00, 4.75739389E+00, 4.72620201E+00, 4.74649498E+00,
     &   4.70482842E+00, 4.55694562E+00, 4.44830461E+00, 4.36855175E+00,
     &   4.20080046E+00, 4.03372009E+00, 3.86890809E+00, 3.63213355E+00,
     &   3.37737979E+00, 3.08571789E+00, 2.73100595E+00, 2.27256288E+00,
     &   1.63077413E+00, 9.00988215E-01, 5.25160665E-01, 3.73992413E-01,
     &   2.92419618E-01, 2.41342136E-01, 2.06327292E-01, 1.80855027E-01,
     &   1.61376114E-01, 1.46072286E-01, 1.33702314E-01, 1.23491263E-01,
     &   1.14915403E-01, 1.07607966E-01, 1.01304392E-01, 9.58090527E-02,
     &   4.40711511E-02, 8.66878135E-02, 8.28538360E-02, 7.94115340E-02,
     &   7.62982168E-02, 7.34689293E-02, 7.08858356E-02, 6.85174937E-02,
     &   6.63376216E-02, 6.43240721E-02, 6.24580513E-02, 2.18818218E-02,
     &   5.91066395E-02, 5.75955343E-02, 5.61798373E-02, 5.48505150E-02,
     &   5.35996506E-02, 5.24202785E-02, 5.13062494E-02, 5.02521181E-02,
     &   4.92530537E-02, 4.83047671E-02, 4.74034585E-02, 4.65457884E-02,
     &   4.57288957E-02, 4.49505217E-02, 4.42095392E-02, 4.35090930E-02,
     &   4.28461252E-02, 4.21441628E-02, 4.14950837E-02, 4.08763536E-02,
     &   4.02833588E-02, 3.97135935E-02, 3.91652396E-02, 3.49606225E-02,
     &   3.22920178E-02, 2.96287567E-02, 2.64598642E-02, 2.31482951E-02,
     &   1.90946322E-02, 1.74280670E-02, 1.50851598E-02, 1.42183855E-02,
     &   1.46274979E-02, 1.47775397E-02, 1.48332332E-02, 1.48421294E-02/
  
         DATA ((DAS  (I,J), I=1501,1600), J=1,1) /
     &   1.47974715E-02, 1.47230789E-02, 1.43566558E-02, 1.39143739E-02,
     &   1.35871663E-02, 1.30400208E-02, 1.23251471E-02, 1.14796603E-02,
     &   1.03833480E-02, 8.87588006E-03, 5.10234422E-03, 4.38681037E-03,
     &   3.54421068E-03, 3.30004404E-03, 2.74350469E-03, 2.12512695E-03,
     &   1.43399068E-03, 6.56442157E-04,-2.24818698E-04,-1.23204332E-03,
     &  -2.39434355E-03,-3.75055862E-03,-5.35369276E-03,-7.27803029E-03,
     &  -9.63102873E-03,-1.25742226E-02,-1.63623189E-02,-2.14224125E-02,
     &  -2.85337945E-02,-3.93572394E-02,-5.70108864E-02,-9.22892496E-02,
     &  -1.39681208E-01,-1.47637423E-01,-1.56463659E-01,-1.66310724E-01,
     &  -1.77366378E-01,-1.89867180E-01,-2.04117166E-01,-2.20508572E-01,
     &  -2.39564073E-01,-2.61989096E-01,-2.88762248E-01,-3.21280795E-01,
     &  -3.61610704E-01,-4.12939365E-01,-4.80452810E-01,-5.73172957E-01,
     &  -7.08283618E-01,-9.22793634E-01,-1.31207939E+00,-2.19277483E+00,
     &  -2.50139194E+00,-2.63567847E+00,-3.01363377E+00,-3.24367125E+00,
     &  -3.41026954E+00,-2.95891398E+00,-2.59656081E+00,-3.91386124E+00,
     &  -3.78228677E+00,-2.55832277E-01,-1.35628556E+00,-1.32466407E+00,
     &  -1.30889340E+00,-3.13333830E+00,-3.11460386E+00,-3.10043383E+00,
     &  -3.08616258E+00,-2.93807328E+00,-2.69905099E+00,-2.41301092E+00,
     &  -2.14046136E+00,-2.25592223E+00,-1.91295161E+00,-1.57404233E+00,
     &  -1.37497467E+00,-1.18428527E+00,-9.71596168E-01,-6.64810879E-01,
     &  -4.40818652E-01, 4.03036291E-02, 4.04067961E-02, 4.04411605E-02,
     &   4.04583380E-02, 4.04755125E-02, 4.04926839E-02, 4.05098522E-02,
     &   4.06470874E-02, 4.08183525E-02, 4.09893063E-02, 1.69375886E+00,
     &   2.04535588E+00, 2.64170284E+00, 2.87247888E+00, 3.08882169E+00,
     &   3.24985000E+00, 3.16454083E+00, 3.36710542E+00, 3.55472482E+00/
  
         DATA ((DAS  (I,J), I=1601,1700), J=1,1) /
     &   3.61092250E+00, 3.64270206E+00, 3.65271246E+00, 3.65205459E+00,
     &   3.64055610E+00, 3.62241145E+00, 2.63418206E+00, 3.52664566E+00,
     &   3.48305620E+00, 3.43996447E+00, 3.33182937E+00, 3.27584919E+00,
     &   3.18492958E+00, 3.03957103E+00, 2.52909977E+00, 2.13134512E+00,
     &   1.82962056E+00, 1.59812778E+00, 1.41639948E+00, 1.24428487E+00,
     &   1.08037478E+00, 8.98051189E-01, 8.36581312E-01, 7.82977072E-01,
     &   7.35750445E-01, 6.65932915E-01, 5.53577096E-01, 4.74112715E-01,
     &   4.14981108E-01, 3.69282161E-01, 3.32910149E-01, 3.03281232E-01,
     &   2.78680865E-01, 2.57930027E-01, 2.40192481E-01, 2.24856035E-01,
     &   2.11464516E-01, 1.99670588E-01, 1.89204333E-01, 1.79853085E-01,
     &   1.71449487E-01, 1.19901853E-01, 8.45707271E-02, 6.69124340E-02,
     &   4.92829463E-02, 4.03269119E-02, 3.50116965E-02, 3.14762294E-02,
     &   2.89533416E-02, 2.70620696E-02, 2.55914030E-02, 2.44149478E-02,
     &   2.37475385E-02, 2.29687534E-02, 2.23032349E-02, 2.17279089E-02,
     &   2.12255706E-02, 2.07831292E-02, 1.91798965E-02, 1.81738203E-02,
     &   1.74824252E-02, 1.69769135E-02, 1.65896911E-02, 1.62789476E-02,
     &   1.60318505E-02, 1.58266690E-02, 1.41134843E-02, 1.36471551E-02,
     &   1.35286920E-02, 1.33908779E-02, 1.32259916E-02, 1.30201898E-02,
     &   1.28955946E-02, 1.27517616E-02, 1.23804340E-02, 1.18189051E-02,
     &   1.08386132E-02, 8.60749018E-03, 6.47536290E-03, 5.92505725E-03,
     &   5.29032417E-03, 4.55005236E-03, 3.67540924E-03, 2.62599967E-03,
     &   1.34347406E-03,-2.59864502E-04,-2.32214507E-03,-5.07448765E-03,
     &  -8.93827353E-03,-1.47580274E-02,-2.43360434E-02,-2.60059883E-02,
     &  -2.78278241E-02,-2.98236429E-02,-3.20197951E-02,-3.44547270E-02,
     &  -3.71424652E-02,-4.01565010E-02,-4.35470037E-02,-4.73900443E-02/
  
         DATA ((DAS  (I,J), I=1701,1800), J=1,1) /
     &  -5.17821348E-02,-5.68493420E-02,-6.27616201E-02,-6.97486584E-02,
     &  -7.81318730E-02,-8.83775800E-02,-9.15765714E-02,-1.01185428E-01,
     &  -1.17647388E-01,-1.39594185E-01,-1.70309201E-01,-2.16350418E-01,
     &  -2.92987150E-01,-4.45762652E-01,-8.97315274E-01,-1.06945588E+00,
     &  -1.51423330E+00,-1.73240844E+00,-2.13123189E+00,-2.37401862E+00,
     &  -2.59044445E+00,-2.78659968E+00,-2.95532586E+00,-3.19325251E+00,
     &  -3.26429658E+00, 3.20078831E-02,-3.53954662E+00,-3.65422655E+00,
     &  -3.75166248E+00,-3.83233330E+00,-2.65813792E+00,-3.96721172E+00,
     &  -4.01665258E+00,-4.06193778E+00,-4.10137321E+00,-4.13191669E+00,
     &  -4.20107113E+00,-4.13838054E+00,-4.11151393E+00,-3.85184378E+00,
     &  -3.63245123E+00, 8.69362569E-02,-3.82109736E+00,-3.65306457E+00,
     &  -3.44355785E+00,-3.14576900E+00,-2.79185311E+00,-2.32376339E+00,
     &  -1.77818752E+00, 8.19518819E-01, 1.40861776E-02, 8.25233055E-01,
     &   1.80646042E+00, 2.35400299E+00, 2.82760079E+00, 3.18500677E+00,
     &   2.68972327E+00, 2.98399669E+00, 3.26777087E+00, 3.53732023E+00,
     &   3.74811838E+00, 3.98074438E+00, 4.18711609E+00, 1.58824352E+00,
     &   1.72860057E+00, 1.87475871E+00, 2.98550538E-01, 2.24045856E+00,
     &   2.43701647E+00, 2.64281939E+00, 2.88882984E+00, 3.17762766E+00,
     &   3.47556103E+00, 3.81003825E+00, 3.61012918E+00, 3.33761809E+00,
     &   3.06320024E+00, 2.81901911E+00, 2.63607526E+00, 1.03212901E+00,
     &   2.62692503E+00, 2.39840296E+00, 2.16102224E+00, 1.88019212E+00,
     &   1.54245695E+00, 1.09768435E+00, 9.41936247E-01, 9.12724289E-01,
     &   6.13972239E-01, 7.76397045E-01, 6.86219406E-01, 4.73966500E-01,
     &   3.21216213E-01, 2.44576320E-01, 1.98534085E-01, 1.67823018E-01,
     &   1.45876035E-01, 1.29412348E-01, 1.16606701E-01, 1.06359963E-01/
  
         DATA ((DAS  (I,J), I=1801,1900), J=1,1) /
     &   9.79757018E-02, 9.09891743E-02, 8.50771708E-02, 8.00081587E-02,
     &   7.56165133E-02, 7.17730388E-02, 5.25556085E-02, 4.29470263E-02,
     &   3.71831665E-02, 3.33465232E-02, 3.05939971E-02, 2.85189969E-02,
     &   2.69112229E-02, 2.45756251E-02, 2.29592319E-02, 2.23240921E-02,
     &   2.17735088E-02, 1.97922183E-02, 1.83391416E-02, 1.74674442E-02,
     &   1.68845007E-02, 1.64659618E-02, 1.61496096E-02, 1.59006364E-02,
     &   1.56982372E-02, 1.55285560E-02, 1.52451587E-02, 1.52634349E-02,
     &   1.51577539E-02, 1.50620742E-02, 1.49745858E-02, 1.48938748E-02,
     &   1.48181250E-02, 1.47460702E-02, 1.46763616E-02, 1.46073991E-02,
     &   1.45368108E-02, 1.44582540E-02, 1.44050912E-02, 1.34132502E-02,
     &   1.31793338E-02, 1.28831907E-02, 1.26478641E-02, 1.24533280E-02,
     &   1.24316289E-02, 1.21609224E-02, 1.20345649E-02, 1.19358206E-02,
     &   1.18528230E-02, 1.17840347E-02, 1.17587370E-02, 1.16870555E-02,
     &   1.16572898E-02, 1.16390995E-02, 1.16324865E-02, 1.16369289E-02,
     &   1.16521495E-02, 1.16785614E-02, 1.17086360E-02, 1.17624287E-02,
     &   1.18222637E-02, 1.18911335E-02, 1.19738649E-02, 1.20688340E-02,
     &   1.21785258E-02, 1.23035968E-02, 1.24445139E-02, 1.26015041E-02,
     &   1.27868759E-02, 1.29990393E-02, 1.32440471E-02, 1.35494181E-02,
     &   1.39530292E-02, 1.49394327E-02, 1.58718822E-02, 1.62237148E-02,
     &   1.64786656E-02, 1.66760358E-02, 1.68415344E-02, 1.69817188E-02,
     &   1.70968970E-02, 1.71971522E-02, 1.72832369E-02, 1.73562593E-02,
     &   1.74215625E-02, 1.74664424E-02, 1.75055249E-02, 1.75364482E-02,
     &   1.75573233E-02, 1.75698568E-02, 1.75736540E-02, 1.75687519E-02,
     &   1.75557143E-02, 1.75331606E-02, 1.75013291E-02, 1.74604770E-02,
     &   1.74098868E-02, 1.73318066E-02, 1.72441833E-02, 1.71461493E-02/
  
         DATA ((DAS  (I,J), I=1901,2000), J=1,1) /
     &   1.70927679E-02, 1.69786478E-02, 1.68466168E-02, 1.66897481E-02,
     &   1.65085018E-02, 1.62879135E-02, 1.60105924E-02, 1.56351102E-02,
     &   1.49743019E-02, 1.49388825E-02, 1.47450567E-02, 1.46882108E-02,
     &   1.45695981E-02, 1.45137618E-02, 1.44687045E-02, 1.44311016E-02,
     &   1.43992381E-02, 1.43718805E-02, 1.43358183E-02, 1.43278626E-02,
     &   1.43102472E-02, 1.42951950E-02, 1.42807201E-02, 1.42714955E-02,
     &   1.42627746E-02, 1.42558932E-02, 1.42507574E-02, 1.42473335E-02,
     &   1.42233474E-02, 1.42249687E-02, 1.42471500E-02, 1.42502000E-02,
     &   1.42559250E-02, 1.42632784E-02, 1.42725553E-02, 1.42839773E-02,
     &   1.42977614E-02, 1.43142465E-02, 1.43337023E-02, 1.43569089E-02,
     &   1.43845827E-02, 1.44153935E-02, 1.44610591E-02, 1.45199304E-02,
     &   1.46719655E-02, 1.47857414E-02, 1.48608320E-02, 1.49004170E-02,
     &   1.49323788E-02, 1.49592496E-02, 1.49824482E-02, 1.50026090E-02,
     &   1.50202749E-02, 1.50358912E-02, 1.50495833E-02, 1.50616184E-02,
     &   1.50721445E-02, 1.50812291E-02, 1.50890305E-02, 1.50956168E-02,
     &   1.51009515E-02, 1.51051621E-02, 1.51082720E-02, 1.51102633E-02,
     &   1.51140664E-02, 1.51112843E-02, 1.51099260E-02, 1.51074973E-02,
     &   1.51040741E-02, 1.50995431E-02, 1.50938371E-02, 1.50869376E-02,
     &   1.50786901E-02, 1.50692551E-02, 1.50584337E-02, 1.50568358E-02,
     &   1.50445415E-02, 1.50301443E-02, 1.50131102E-02, 1.49798599E-02,
     &   1.48329923E-02, 1.48568266E-02, 1.48522183E-02, 1.48480565E-02,
     &   1.48443423E-02, 1.48410734E-02, 1.48382448E-02, 1.48358283E-02,
     &   1.48338059E-02, 1.48321864E-02, 1.48287123E-02, 1.48276418E-02,
     &   1.48275894E-02, 1.47821349E-02, 1.47826559E-02, 1.47837057E-02,
     &   1.48295687E-02, 1.48311497E-02, 1.48331799E-02, 1.48356952E-02/
  
         DATA ((DAS  (I,J), I=2001,2100), J=1,1) /
     &   1.48387387E-02, 1.48422624E-02, 1.48463530E-02, 1.48510389E-02,
     &   1.48563467E-02, 1.48623639E-02, 1.48690622E-02, 1.48766856E-02,
     &   1.48853061E-02, 1.48950793E-02, 1.49061803E-02, 1.49191058E-02,
     &   1.49344457E-02, 1.49534506E-02, 1.49791650E-02, 1.50445669E-02,
     &   1.51095942E-02, 1.51356944E-02, 1.51668305E-02, 1.51855329E-02,
     &   1.52015020E-02, 1.51893999E-02, 1.51997712E-02, 1.52090582E-02,
     &   1.52174104E-02, 1.52248893E-02, 1.52317549E-02, 1.52379661E-02,
     &   1.52436144E-02, 1.52487232E-02, 1.52533164E-02, 1.52575008E-02,
     &   1.52612381E-02, 1.52645099E-02, 1.52677724E-02, 1.52702101E-02,
     &   1.52720536E-02, 1.52738268E-02, 1.52752400E-02, 1.52763097E-02,
     &   1.52770341E-02, 1.52774128E-02, 1.52774446E-02, 1.52771291E-02,
     &   1.52764685E-02, 1.52754584E-02, 1.52752485E-02, 1.52731576E-02,
     &   1.52707028E-02, 1.52679101E-02, 1.52647164E-02, 1.52452569E-02,
     &   1.51632757E-02, 1.50709692E-02, 1.50377430E-02, 1.49842686E-02,
     &   1.49402974E-02, 1.48971746E-02, 1.48601400E-02, 1.48234951E-02,
     &   1.47887608E-02, 1.47539877E-02, 1.47177288E-02, 1.46818083E-02,
     &   1.46885592E-02, 1.46953102E-02, 1.47348656E-02, 1.47721516E-02,
     &   1.48047926E-02, 1.48364026E-02, 1.48646765E-02, 1.48925380E-02,
     &   1.49178198E-02, 1.49430327E-02, 1.49671733E-02, 1.49893915E-02,
     &   1.50118191E-02, 1.50325930E-02, 1.50536796E-02, 1.50733069E-02,
     &   1.50933151E-02, 1.51120097E-02, 1.51311315E-02, 1.51490517E-02,
     &   1.51674311E-02, 1.51846974E-02, 1.52016795E-02, 1.52191509E-02,
     &   1.52356106E-02, 1.52525725E-02, 1.52685762E-02, 1.52850907E-02,
     &   1.53006920E-02, 1.53168098E-02, 1.53320525E-02, 1.53478154E-02,
     &   1.53627361E-02, 1.53781789E-02, 1.53934698E-02, 1.54079603E-02/
  
         DATA ((DAS  (I,J), I=2101,2180), J=1,1) /
     &   1.54229739E-02, 1.54372105E-02, 1.54519698E-02, 1.54659732E-02,
     &   1.54804983E-02, 1.54942861E-02, 1.55085943E-02, 1.55221821E-02,
     &   1.55362885E-02, 1.55496900E-02, 1.55630048E-02, 1.55768352E-02,
     &   1.55899810E-02, 1.56036402E-02, 1.56166273E-02, 1.56278927E-02,
     &   1.56407832E-02, 1.56541887E-02, 1.56669455E-02, 1.56802150E-02,
     &   1.56928450E-02, 1.57059854E-02, 1.57190623E-02, 1.57315127E-02,
     &   1.57444697E-02, 1.57568081E-02, 1.57696508E-02, 1.57818822E-02,
     &   1.57946155E-02, 1.58067444E-02, 1.58195345E-02, 1.58315664E-02,
     &   1.58440950E-02, 1.58560317E-02, 1.58684626E-02, 1.58803076E-02,
     &   1.58921089E-02, 1.59044008E-02, 1.59161151E-02, 1.59283176E-02,
     &   1.59399478E-02, 1.59520637E-02, 1.59636125E-02, 1.60115722E-02,
     &   1.60230301E-02, 1.60349474E-02, 1.60462883E-02, 1.60580846E-02,
     &   1.61489377E-02, 1.62714887E-02, 1.62907531E-02, 1.71454316E-02,
     &   1.75298967E-02, 1.85406795E-02, 1.92178608E-02, 1.91373622E-02,
     &   1.98994356E-02, 1.99018536E-02, 2.04741522E-02, 2.04959867E-02,
     &   2.05091210E-02, 2.07935023E-02, 2.09829508E-02, 2.10169482E-02,
     &   2.10725155E-02, 2.11548812E-02, 2.12130016E-02, 2.12495086E-02,
     &   2.16039518E-02, 2.16218869E-02, 2.17300213E-02, 2.17493834E-02,
     &   2.20452266E-02, 2.18680294E-02, 2.19273860E-02, 2.19534621E-02,
     &   2.19957381E-02, 2.21041910E-02, 2.21502952E-02, 2.24554407E-02/
  
         DATA ((DAS  (I,J), I=   1, 100), J=2,2) /
     &   1.12188089E-06, 1.22122659E-06, 1.34016096E-06, 1.50952293E-06,
     &   1.75746395E-06, 1.85974270E-06, 2.55766466E-06, 2.14276333E-06,
     &   2.30366594E-06, 2.50905788E-06, 2.63705245E-06, 2.90799546E-06,
     &   2.99825564E-06, 3.11056908E-06, 3.17322307E-06, 3.31724635E-06,
     &   3.49218636E-06, 3.69240672E-06, 3.76614597E-06, 3.79991420E-06,
     &   3.88785690E-06, 4.02697541E-06, 4.13871430E-06, 4.22958530E-06,
     &   4.32387217E-06, 4.48267439E-06, 4.64456925E-06, 4.73375925E-06,
     &   4.76178101E-06, 4.90198230E-06, 5.08204347E-06, 5.13989660E-06,
     &   5.31693627E-06, 5.49453693E-06, 5.66921624E-06, 5.86676072E-06,
     &   6.09208415E-06, 6.40235336E-06, 6.68032442E-06, 6.96527120E-06,
     &   7.27017133E-06, 7.62290404E-06, 8.05249236E-06, 8.46171797E-06,
     &   9.12528881E-06, 1.01378372E-05, 1.09964967E-05, 1.12768960E-05,
     &   1.12158142E-05, 1.09295872E-05, 1.30413622E-05, 1.54874965E-05,
     &   1.71267820E-05, 1.72962437E-05, 1.91291389E-05, 1.96878072E-05,
     &   1.79391638E-05, 1.64692529E-05, 1.60636273E-05, 1.62897442E-05,
     &   1.69676893E-05, 1.69225472E-05, 1.73513004E-05, 1.73409588E-05,
     &   1.80279318E-05, 1.85153569E-05, 1.94340416E-05, 2.11372320E-05,
     &   2.18278323E-05, 2.21096225E-05, 2.35520826E-05, 2.28631749E-05,
     &   2.35930545E-05, 2.48940177E-05, 2.64765746E-05, 2.76034611E-05,
     &   2.85147949E-05, 3.07852848E-05, 3.38403441E-05, 6.25044767E-05,
     &   5.83960352E-05, 6.26471977E-05, 6.30334428E-05, 6.43203143E-05,
     &   6.77448687E-05, 7.95046766E-05, 9.76270625E-05, 1.03656787E-04,
     &   1.16505700E-04, 1.25633411E-04, 1.34938502E-04, 1.43224291E-04,
     &   1.50383991E-04, 1.52879185E-04, 1.54859338E-04, 1.57780310E-04,
     &   1.55520406E-04, 1.53226603E-04, 1.50040138E-04, 1.45461284E-04/
  
         DATA ((DAS  (I,J), I= 101, 200), J=2,2) /
     &   1.39380144E-04, 1.32160475E-04, 1.19139498E-04, 1.03630790E-04,
     &   9.16023572E-05, 8.23173784E-05, 7.32171752E-05, 6.43017477E-05,
     &   5.55529679E-05, 4.79056796E-05, 4.06851979E-05, 3.66319188E-05,
     &   3.24545598E-05, 2.80497207E-05, 3.67739620E-05, 4.53822777E-05,
     &   5.32157750E-05, 5.36395612E-05, 4.21764371E-05, 3.91869920E-05,
     &   4.00081640E-05, 4.21396497E-05, 4.52627982E-05, 4.97836297E-05,
     &   5.56325030E-05, 6.49825864E-05, 7.42413374E-05, 8.14836905E-05,
     &   8.63214412E-05, 9.14821500E-05, 9.59749850E-05, 1.00176891E-04,
     &   1.04458803E-04, 1.14209469E-04, 1.13458762E-04, 1.17271803E-04,
     &   1.02968892E-04, 1.24598847E-04, 1.26670463E-04, 1.28445671E-04,
     &   1.29780837E-04, 1.31103012E-04, 1.31510854E-04, 1.30341429E-04,
     &   1.29988244E-04, 1.25754660E-04, 1.19184167E-04, 1.10188529E-04,
     &   1.03116574E-04, 8.58246850E-05, 8.52306285E-05, 7.25212724E-05,
     &   7.08336390E-05, 6.29116863E-05, 5.49897335E-05, 4.93108135E-05,
     &   4.58649368E-05, 4.32356197E-05, 3.85837318E-05, 3.60655070E-05,
     &   3.43404282E-05, 3.16976452E-05, 3.07895312E-05, 2.93774262E-05,
     &   2.82888654E-05, 2.73157414E-05, 2.66410722E-05, 2.61400961E-05,
     &   2.39788511E-05, 2.26018753E-05, 2.19571092E-05, 2.13234313E-05,
     &   2.05173008E-05, 1.97864346E-05, 1.92927782E-05, 1.89565308E-05,
     &   1.86417500E-05, 1.83822838E-05, 1.84631137E-05, 1.84209764E-05,
     &   1.84808767E-05, 1.85304013E-05, 1.86777217E-05, 1.88880076E-05,
     &   1.93311449E-05, 1.97944407E-05, 2.06253352E-05, 2.13519679E-05,
     &   2.25079707E-05, 2.38127156E-05, 2.46843889E-05, 2.53382826E-05,
     &   2.69085187E-05, 2.77465567E-05, 2.84945261E-05, 2.96433937E-05,
     &   3.12658953E-05, 3.35106331E-05, 3.51715494E-05, 3.66010139E-05/
  
         DATA ((DAS  (I,J), I= 201, 300), J=2,2) /
     &   3.83648614E-05, 4.02411458E-05, 4.10090784E-05, 4.18343783E-05,
     &   4.27141231E-05, 4.36487297E-05, 4.46362305E-05, 4.56297599E-05,
     &   4.65959131E-05, 4.76213946E-05, 4.87074774E-05, 4.98622720E-05,
     &   5.10820423E-05, 5.23090919E-05, 5.35820841E-05, 5.49609764E-05,
     &   5.64071065E-05, 5.79464638E-05, 5.96041103E-05, 6.13920476E-05,
     &   6.33238540E-05, 6.54229343E-05, 6.77044906E-05, 7.02065763E-05,
     &   7.29612474E-05, 7.60203717E-05, 7.94299053E-05, 8.32988836E-05,
     &   8.77497465E-05, 9.34361009E-05, 9.71393838E-05, 9.80011229E-05,
     &   1.00272981E-04, 1.04494755E-04, 1.07736053E-04, 1.12447631E-04,
     &   1.17665979E-04, 1.22338291E-04, 1.26623371E-04, 1.32892333E-04,
     &   1.37725087E-04, 1.40986080E-04, 1.46532076E-04, 1.47095837E-04,
     &   1.47659597E-04, 1.47361169E-04, 1.45650885E-04, 1.44741827E-04,
     &   1.51147899E-04, 1.74892486E-04, 2.05065727E-04, 2.39448641E-04,
     &   2.60936993E-04, 2.74699065E-04, 2.73643702E-04, 2.80864629E-04,
     &   2.90949045E-04, 3.03657376E-04, 2.97402168E-04, 3.13186059E-04,
     &   3.23379284E-04, 3.22018526E-04, 3.31809956E-04, 3.30586238E-04,
     &   3.08385343E-04, 2.73754879E-04, 2.17261456E-04, 1.81648200E-04,
     &   1.65582528E-04, 1.44786472E-04, 1.18501771E-04, 8.88701615E-05,
     &   6.41397027E-05, 5.75734865E-05, 5.04322048E-05, 1.68620860E-05,
     &   8.39515051E-05, 1.33523107E-04, 1.54203582E-04, 1.80091075E-04,
     &   2.04845756E-04, 2.25209539E-04, 2.42881923E-04, 2.58916671E-04,
     &   2.74560017E-04, 2.92494988E-04, 3.07412505E-04, 2.98061094E-04,
     &   3.03703720E-04, 2.90736839E-04, 2.79667523E-04, 2.68610325E-04,
     &   2.62608488E-04, 2.57772278E-04, 2.53517242E-04, 2.52418154E-04,
     &   2.48752010E-04, 2.46193881E-04, 2.44246323E-04, 2.42683768E-04/
  
         DATA ((DAS  (I,J), I= 301, 400), J=2,2) /
     &   2.34628579E-04, 2.41710654E-04, 2.39531348E-04, 2.39045857E-04,
     &   2.35385505E-04, 2.29272856E-04, 2.18913794E-04, 2.11483853E-04,
     &   1.82015186E-04, 1.67789226E-04, 1.58635815E-04, 1.51013640E-04,
     &   1.44191837E-04, 1.38070856E-04, 1.32372818E-04, 1.26726714E-04,
     &   1.20707228E-04, 1.15084153E-04, 1.10442170E-04, 1.06315260E-04,
     &   1.01402355E-04, 9.79922140E-05, 9.71256417E-05, 9.17483747E-05,
     &   8.92127494E-05, 8.98199946E-05, 8.95180369E-05, 8.46482542E-05,
     &   8.06597602E-05, 7.74928885E-05, 7.47388240E-05, 7.22686726E-05,
     &   7.00225967E-05, 6.79605042E-05, 6.60556121E-05, 6.42876584E-05,
     &   6.26413572E-05, 6.11042798E-05, 5.96665489E-05, 5.83220096E-05,
     &   5.70587551E-05, 5.58659200E-05, 5.47303130E-05, 5.36775212E-05,
     &   5.26564107E-05, 5.16334841E-05, 5.06700399E-05, 4.97667426E-05,
     &   4.89235018E-05, 4.81433874E-05, 4.74301879E-05, 4.67253360E-05,
     &   4.59087810E-05, 4.51243007E-05, 4.43711438E-05, 4.36488810E-05,
     &   4.17566945E-05, 3.83200795E-05, 3.34846846E-05, 3.11526501E-05,
     &   2.89205659E-05, 2.71779828E-05, 2.57782877E-05, 2.49991566E-05,
     &   2.35083544E-05, 2.31711083E-05, 2.14224274E-05, 2.20734183E-05,
     &   2.18247771E-05, 2.09551484E-05, 2.07568492E-05, 2.04112026E-05,
     &   2.01694792E-05, 2.02440926E-05, 1.94010550E-05, 2.00858949E-05,
     &   1.93314581E-05, 1.95561695E-05, 1.92626563E-05, 1.97123471E-05,
     &   1.88785997E-05, 1.96043773E-05, 1.87548063E-05, 1.94243693E-05,
     &   1.91248899E-05, 1.91687514E-05, 1.95835816E-05, 1.89155005E-05,
     &   1.97758887E-05, 1.93205116E-05, 1.94053972E-05, 1.99688751E-05,
     &   1.97136683E-05, 2.11003281E-05, 2.03128436E-05, 2.11879954E-05,
     &   2.13042714E-05, 2.32643255E-05, 2.29562950E-05, 2.26048985E-05/
  
         DATA ((DAS  (I,J), I= 401, 500), J=2,2) /
     &   2.34952956E-05, 2.55447298E-05, 2.66133702E-05, 2.53534290E-05,
     &   2.48809511E-05, 2.55852858E-05, 2.68726522E-05, 2.79810628E-05,
     &   2.80897335E-05, 2.70449584E-05, 2.80242236E-05, 2.80846505E-05,
     &   2.87216793E-05, 3.10552295E-05, 3.03837438E-05, 2.87539868E-05,
     &   2.95261791E-05, 2.79691028E-05, 2.81791326E-05, 3.02133343E-05,
     &   3.05504068E-05, 3.11511093E-05, 3.22668029E-05, 3.14766692E-05,
     &   3.06123960E-05, 3.16931885E-05, 3.17349208E-05, 3.45203050E-05,
     &   3.45799274E-05, 3.40831211E-05, 3.55886600E-05, 3.42993454E-05,
     &   3.49340988E-05, 3.62014170E-05, 3.81458071E-05, 3.61506548E-05,
     &   3.62500383E-05, 3.56096521E-05, 3.69719793E-05, 4.01719847E-05,
     &   3.96542900E-05, 4.04706312E-05, 3.93955525E-05, 3.96033094E-05,
     &   3.89676138E-05, 3.85859458E-05, 4.26882873E-05, 4.01633809E-05,
     &   4.17965548E-05, 3.89583616E-05, 4.36619065E-05, 4.35468710E-05,
     &   4.37036008E-05, 4.41271869E-05, 4.17109079E-05, 3.92663688E-05,
     &   3.86481946E-05, 3.99515061E-05, 4.29068826E-05, 4.33370979E-05,
     &   4.33459732E-05, 4.28668444E-05, 4.30994473E-05, 4.22897174E-05,
     &   4.28740115E-05, 4.30195842E-05, 4.19078897E-05, 4.31277898E-05,
     &   4.54866975E-05, 4.46375792E-05, 4.53834901E-05, 4.62043598E-05,
     &   4.91971151E-05, 5.18246827E-05, 5.24096806E-05, 5.72062065E-05,
     &   5.92606905E-05, 5.72297105E-05, 5.62341814E-05, 5.42781642E-05,
     &   5.38173415E-05, 6.11993519E-05, 6.54867824E-05, 6.53094446E-05,
     &   5.73574099E-05, 5.96058102E-05, 6.21339805E-05, 6.44971406E-05,
     &   6.03775327E-05, 6.10690026E-05, 6.11581981E-05, 6.14763641E-05,
     &   6.33556490E-05, 6.33175547E-05, 6.00108952E-05, 5.87043539E-05,
     &   6.45626232E-05, 7.26125055E-05, 7.13417494E-05, 8.29169019E-05/
  
         DATA ((DAS  (I,J), I= 501, 600), J=2,2) /
     &   8.90524004E-05, 8.77803409E-05, 8.60055512E-05, 8.53108993E-05,
     &   7.27078103E-05, 7.53726111E-05, 8.38610613E-05, 8.53656885E-05,
     &   9.05394859E-05, 9.87321628E-05, 1.09596099E-04, 1.23267349E-04,
     &   1.40646340E-04, 1.63264776E-04, 1.93723915E-04, 2.36730629E-04,
     &   3.01637208E-04, 3.19083507E-04, 3.38082968E-04, 3.59605032E-04,
     &   3.83960996E-04, 4.11678063E-04, 4.43450647E-04, 4.80339751E-04,
     &   4.88412594E-04, 4.96764324E-04, 5.05402820E-04, 5.14339552E-04,
     &   5.23588732E-04, 5.33107995E-04, 5.42974871E-04, 5.53207219E-04,
     &   5.63825941E-04, 5.74843150E-04, 6.30016173E-04, 6.72845678E-04,
     &   6.96444043E-04, 7.13072043E-04, 7.30483117E-04, 7.48742096E-04,
     &   7.67901421E-04, 7.88033311E-04, 8.09212465E-04, 8.20221103E-04,
     &   8.31526047E-04, 8.43136099E-04, 8.55066917E-04, 8.67328740E-04,
     &   8.79938628E-04, 8.92908446E-04, 9.06256864E-04, 9.19997613E-04,
     &   9.34151223E-04, 9.48733562E-04, 9.63766054E-04, 9.79269790E-04,
     &   9.95267212E-04, 1.01178222E-03, 1.02884029E-03, 1.04646860E-03,
     &   1.06469618E-03, 1.08355408E-03, 1.10307550E-03, 1.12329605E-03,
     &   1.14425393E-03, 1.16599016E-03, 1.18854888E-03, 1.21197761E-03,
     &   1.23632763E-03, 1.26165430E-03, 1.28801753E-03, 1.31548221E-03,
     &   1.34411878E-03, 1.37400416E-03, 1.40522143E-03, 1.43786161E-03,
     &   1.47202416E-03, 1.50781806E-03, 1.54536292E-03, 1.58479036E-03,
     &   1.62624552E-03, 1.66988884E-03, 1.71589817E-03, 1.73985088E-03,
     &   1.76447115E-03, 1.78978675E-03, 1.81582805E-03, 1.84262619E-03,
     &   1.87021514E-03, 1.89862991E-03, 1.92790861E-03, 1.95809076E-03,
     &   1.98921927E-03, 2.02133890E-03, 2.05449815E-03, 2.08874787E-03,
     &   2.12414318E-03, 2.16074206E-03, 2.19860737E-03, 2.23780556E-03/
  
         DATA ((DAS  (I,J), I= 601, 700), J=2,2) /
     &   2.27840863E-03, 2.32049302E-03, 2.36414181E-03, 2.40944334E-03,
     &   2.45649349E-03, 2.50539548E-03, 2.55626078E-03, 2.60921001E-03,
     &   2.66437388E-03, 2.72189425E-03, 2.78192537E-03, 2.84463526E-03,
     &   2.91020725E-03, 2.97884180E-03, 3.05075854E-03, 3.12619856E-03,
     &   3.20542735E-03, 3.28873749E-03, 3.37645275E-03, 3.46893179E-03,
     &   3.56657359E-03, 3.71280179E-03, 3.77917634E-03, 3.89519228E-03,
     &   4.01849850E-03, 4.14980418E-03, 4.28991391E-03, 4.43974357E-03,
     &   4.60034099E-03, 4.77290987E-03, 4.95884061E-03, 5.15974726E-03,
     &   5.37751504E-03, 5.61435915E-03, 5.80342833E-03, 6.39242445E-03,
     &   7.11371529E-03, 8.01750663E-03, 9.18308631E-03, 1.07434453E-02,
     &   1.29400096E-02, 1.62614324E-02, 2.18688416E-02, 3.33583623E-02,
     &   7.01439916E-02, 7.41730698E-02, 7.86913829E-02, 8.37934424E-02,
     &   8.95996649E-02, 9.62658503E-02, 1.03997121E-01, 1.13068959E-01,
     &   1.23859904E-01, 1.36904107E-01, 1.52979144E-01, 1.73259431E-01,
     &   1.99598362E-01, 2.35077877E-01, 2.39307960E-01, 3.34024925E-01,
     &   4.03061247E-01, 4.58527945E-01, 5.06766966E-01, 5.43938991E-01,
     &   5.76417930E-01, 6.02447536E-01, 6.28378788E-01, 6.46192021E-01,
     &   6.62685602E-01, 6.74324065E-01, 6.83918668E-01, 6.89310361E-01,
     &   6.93334904E-01, 6.93677129E-01, 6.91651663E-01, 6.86034720E-01,
     &   6.79964130E-01, 6.66833366E-01, 6.55068307E-01, 6.40626811E-01,
     &   6.23281716E-01, 6.02815112E-01, 5.79026598E-01, 5.51742897E-01,
     &   5.20828624E-01, 4.86197800E-01, 4.47825555E-01, 4.05759221E-01,
     &   3.36039789E-01, 2.85497985E-01, 2.04480272E-01, 1.18637846E-01,
     &   1.18555984E-01, 3.35968106E-01, 4.05693298E-01, 4.67418716E-01,
     &   5.03925938E-01, 5.51694923E-01, 5.78983327E-01, 6.02776518E-01/
  
         DATA ((DAS  (I,J), I= 701, 800), J=2,2) /
     &   6.23247731E-01, 6.40597333E-01, 6.55043208E-01, 6.66812495E-01,
     &   6.76134759E-01, 6.83236545E-01, 6.88337228E-01, 6.91645992E-01,
     &   6.93676420E-01, 6.93337284E-01, 6.90694981E-01, 6.85921067E-01,
     &   6.81764404E-01, 6.71596939E-01, 6.62706227E-01, 6.49645830E-01,
     &   6.35642606E-01, 6.17372849E-01, 5.98747851E-01, 5.72776190E-01,
     &   5.47507850E-01, 5.16636023E-01, 4.81817603E-01, 4.37032795E-01,
     &   3.85693130E-01, 3.21587660E-01, 2.64997100E-01, 2.21038933E-01,
     &   1.89320157E-01, 1.65437364E-01, 1.46841164E-01, 1.31967680E-01,
     &   1.19809248E-01, 1.09689285E-01, 1.01137500E-01, 9.38172436E-02,
     &   8.74813983E-02, 8.19445815E-02, 7.70650638E-02, 7.27326714E-02,
     &   6.88604894E-02, 6.53790458E-02, 6.22321537E-02, 5.93738865E-02,
     &   3.11337507E-02, 2.11009088E-02, 1.59614509E-02, 1.28374958E-02,
     &   1.07378670E-02, 9.22974640E-03, 8.09404789E-03, 7.20798794E-03,
     &   6.49741157E-03, 5.91488755E-03, 5.84589430E-03, 5.36480758E-03,
     &   4.95726339E-03, 4.60759745E-03, 4.30429915E-03, 4.03872033E-03,
     &   3.80423764E-03, 3.59569266E-03, 3.40900816E-03, 3.24091892E-03,
     &   3.08877917E-03, 2.95042234E-03, 2.82405729E-03, 2.70819035E-03,
     &   2.60156602E-03, 2.50312135E-03, 2.41195036E-03, 2.32727612E-03,
     &   2.24842854E-03, 2.17482663E-03, 2.10596416E-03, 2.04139803E-03,
     &   1.98073868E-03, 1.92364231E-03, 1.86980427E-03, 1.81895372E-03,
     &   1.77084902E-03, 1.72527391E-03, 1.68203425E-03, 1.64095531E-03,
     &   1.60187933E-03, 1.56466357E-03, 1.52917854E-03, 1.49530650E-03,
     &   1.46294015E-03, 1.43198150E-03, 1.40234090E-03, 1.37393616E-03,
     &   1.34669177E-03, 1.32053826E-03, 1.29541160E-03, 1.27125269E-03,
     &   1.24800686E-03, 1.22562351E-03, 1.20405570E-03, 1.18325983E-03/
  
         DATA ((DAS  (I,J), I= 801, 900), J=2,2) /
     &   1.16319538E-03, 1.14382460E-03, 1.12511231E-03, 1.10702566E-03,
     &   1.08953397E-03, 1.07260852E-03, 1.05622241E-03, 1.04035045E-03,
     &   1.02496896E-03, 1.01005572E-03, 9.95589831E-04, 9.81551616E-04,
     &   9.67922545E-04, 9.54685147E-04, 9.41822930E-04, 9.29320326E-04,
     &   9.17162618E-04, 9.05335884E-04, 8.93826947E-04, 8.82623326E-04,
     &   8.71713189E-04, 8.61085314E-04, 8.50729048E-04, 8.40634275E-04,
     &   8.30791381E-04, 8.21191227E-04, 8.11825116E-04, 8.02684772E-04,
     &   7.93762314E-04, 7.85050234E-04, 7.76541378E-04, 7.68228927E-04,
     &   7.60106378E-04, 7.52167531E-04, 7.44406473E-04, 7.36817569E-04,
     &   7.29395445E-04, 7.22134980E-04, 7.15031301E-04, 7.08079781E-04,
     &   7.01276038E-04, 6.94615936E-04, 6.88095584E-04, 6.81711359E-04,
     &   6.75459964E-04, 6.69338410E-04, 6.63937861E-04, 6.57428053E-04,
     &   6.51626716E-04, 6.45937086E-04, 6.40356040E-04, 6.34880621E-04,
     &   6.29507954E-04, 6.24235279E-04, 6.19059935E-04, 6.13979376E-04,
     &   6.08990855E-04, 4.65430945E-04, 3.71099959E-04, 3.09633044E-04,
     &   3.06368582E-04, 3.00927813E-04, 3.31878656E-04, 3.56348531E-04,
     &   3.91438133E-04, 3.96590050E-04, 4.24174679E-04, 4.41636889E-04,
     &   4.44975485E-04, 4.93496477E-04, 5.63976902E-04, 5.93119125E-04,
     &   6.27289259E-04, 6.62838704E-04, 7.04915065E-04, 7.53176152E-04,
     &   8.09014527E-04, 8.74270539E-04, 9.51447266E-04, 1.04403011E-03,
     &   1.15701724E-03, 1.29785873E-03, 1.47810319E-03, 1.56510920E-03,
     &   1.66303158E-03, 1.77403591E-03, 1.90091781E-03, 2.04733049E-03,
     &   2.21812720E-03, 2.31465147E-03, 2.41993691E-03, 2.53522739E-03,
     &   2.66201853E-03, 2.80211504E-03, 2.95772446E-03, 3.13156737E-03,
     &   3.32704373E-03, 3.54845121E-03, 3.80130990E-03, 4.09282297E-03/
  
         DATA ((DAS  (I,J), I= 901,1000), J=2,2) /
     &   4.43257734E-03, 4.81618897E-03, 5.06733355E-03, 5.34601752E-03,
     &   5.65702934E-03, 6.00633601E-03, 6.40146850E-03, 6.85207047E-03,
     &   7.37069419E-03, 7.97398612E-03, 8.68450331E-03, 9.53358992E-03,
     &   1.05661138E-02, 1.18486319E-02, 1.34842762E-02, 1.56418197E-02,
     &   1.86176044E-02, 2.29835007E-02, 3.00009074E-02, 4.30841341E-02,
     &   6.36615341E-02, 7.53733636E-02, 8.81480076E-02, 1.19579597E-01,
     &   1.30903648E-01, 1.40249636E-01, 1.48186546E-01, 1.54869876E-01,
     &   1.60353206E-01, 1.65074643E-01, 1.68940581E-01, 1.71707437E-01,
     &   1.74058000E-01, 1.75721988E-01, 1.76708932E-01, 1.77065386E-01,
     &   1.76812256E-01, 1.76120583E-01, 1.74716848E-01, 1.72879992E-01,
     &   1.70404011E-01, 1.67218351E-01, 1.63868605E-01, 1.59175385E-01,
     &   1.54430439E-01, 1.48976802E-01, 1.42779475E-01, 1.34571686E-01,
     &   1.26676362E-01, 1.16450556E-01, 1.06822368E-01, 9.27849324E-02,
     &   7.74652538E-02, 5.45843317E-02, 3.46397653E-02, 1.16669265E-02,
     &   1.62054865E-04, 1.16086644E-02, 2.31698096E-02, 5.45291019E-02,
     &   7.74133879E-02, 9.27361013E-02, 1.06776958E-01, 1.16407906E-01,
     &   1.26637082E-01, 1.34535380E-01, 1.42746687E-01, 1.48947039E-01,
     &   1.54403680E-01, 1.59151589E-01, 1.63848188E-01, 1.67200746E-01,
     &   1.70389576E-01, 1.72868594E-01, 1.74708347E-01, 1.76115217E-01,
     &   1.76809478E-01, 1.77065725E-01, 1.76712158E-01, 1.75728167E-01,
     &   1.74067136E-01, 1.71719482E-01, 1.68955232E-01, 1.65092177E-01,
     &   1.60373569E-01, 1.54892937E-01, 1.48212334E-01, 1.40278115E-01,
     &   1.30934755E-01, 1.19613322E-01, 1.05888160E-01, 1.13339669E-01,
     &   9.69555274E-02, 8.68639030E-02, 8.07628400E-02, 6.81242419E-02,
     &   6.37028728E-02, 5.41851347E-02, 3.50851349E-02, 2.58871227E-02/
  
         DATA ((DAS  (I,J), I=1001,1100), J=2,2) /
     &   2.04989365E-02, 1.69644078E-02, 1.44687981E-02, 1.26132703E-02,
     &   1.11797904E-02, 1.00391809E-02, 9.11006872E-03, 8.33865588E-03,
     &   7.68795567E-03, 7.13170569E-03, 6.65074398E-03, 6.23076177E-03,
     &   5.86085932E-03, 5.53258856E-03, 5.23930008E-03, 4.97568868E-03,
     &   4.55898013E-03, 4.03883058E-03, 3.76063761E-03, 3.30604929E-03,
     &   2.95031875E-03, 2.60150149E-03, 2.10631769E-03, 1.56171616E-03,
     &   1.23996135E-03, 1.10621628E-03, 1.03148088E-03, 9.82872699E-04,
     &   9.48542038E-04, 9.22677156E-04, 9.02381725E-04, 8.85909795E-04,
     &   8.72141107E-04, 8.60394667E-04, 8.50168647E-04, 8.41110948E-04,
     &   8.32976168E-04, 8.25553928E-04, 8.18715307E-04, 8.12325632E-04,
     &   8.06276108E-04, 8.00537430E-04, 7.95005729E-04, 7.89625012E-04,
     &   7.84364393E-04, 7.79177958E-04, 7.74014227E-04, 7.68826602E-04,
     &   7.63569228E-04, 7.58203403E-04, 7.52661974E-04, 7.46872486E-04,
     &   7.40729284E-04, 7.34109055E-04, 7.26778455E-04, 7.18306423E-04,
     &   7.07618326E-04, 6.83588913E-04, 6.63111285E-04, 6.56132272E-04,
     &   6.51520444E-04, 6.48189432E-04, 6.45694110E-04, 6.43800956E-04,
     &   6.42361123E-04, 6.41254896E-04, 6.40405322E-04, 6.39737372E-04,
     &   6.39193331E-04, 6.38698717E-04, 6.38222391E-04, 6.37699997E-04,
     &   6.36990455E-04, 6.36253039E-04, 6.35209801E-04, 6.33913293E-04,
     &   6.32252859E-04, 6.30173049E-04, 6.27625426E-04, 6.24472625E-04,
     &   6.20675728E-04, 6.16127664E-04, 6.10650611E-04, 6.04032352E-04,
     &   5.96483902E-04, 5.87350050E-04, 5.76520642E-04, 5.63402892E-04,
     &   5.47707953E-04, 5.27575310E-04, 5.02124214E-04, 4.66640487E-04,
     &   4.56490478E-04, 4.25970163E-04, 3.83521901E-04, 3.79536365E-04,
     &   3.52695920E-04, 3.43891751E-04, 3.36801784E-04, 3.27416285E-04/
  
         DATA ((DAS  (I,J), I=1101,1200), J=2,2) /
     &   3.19314030E-04, 3.11840694E-04, 3.07471253E-04, 3.04825684E-04,
     &   2.98264593E-04, 2.91690218E-04, 2.86037987E-04, 2.80587851E-04,
     &   2.75537081E-04, 2.70723324E-04, 2.66070333E-04, 2.61705328E-04,
     &   2.57548669E-04, 2.53678625E-04, 2.49808581E-04, 2.45938537E-04,
     &   2.42361607E-04, 2.38800450E-04, 2.36389597E-04, 2.33401756E-04,
     &   2.33088319E-04, 2.30379179E-04, 2.28457185E-04, 2.24957660E-04,
     &   2.25700666E-04, 2.24781703E-04, 2.22177375E-04, 2.21330444E-04,
     &   2.17862615E-04, 2.17648028E-04, 2.15237553E-04, 2.15469148E-04,
     &   2.13994377E-04, 2.12325468E-04, 2.09139789E-04, 2.07489023E-04,
     &   2.05123446E-04, 2.04987923E-04, 2.03340486E-04, 2.03539416E-04,
     &   2.01467172E-04, 2.00840195E-04, 1.98273988E-04, 1.98367259E-04,
     &   1.99361209E-04, 1.98915378E-04, 1.95514263E-04, 1.93859398E-04,
     &   1.95828434E-04, 1.95593852E-04, 1.94890537E-04, 1.92719238E-04,
     &   1.91967112E-04, 1.92131250E-04, 1.89741795E-04, 1.89807192E-04,
     &   1.88647290E-04, 1.88502800E-04, 1.84968417E-04, 1.86485301E-04,
     &   1.86246393E-04, 1.87318428E-04, 1.85726983E-04, 1.86227737E-04,
     &   1.86465471E-04, 1.81803051E-04, 1.81406929E-04, 1.81130011E-04,
     &   1.80684575E-04, 1.79239780E-04, 1.78893014E-04, 1.79548158E-04,
     &   1.75957532E-04, 1.77093818E-04, 1.76941239E-04, 1.78217220E-04,
     &   1.76861434E-04, 1.77162010E-04, 1.76298367E-04, 1.79043754E-04,
     &   1.79356681E-04, 1.76755680E-04, 1.73586011E-04, 1.71682413E-04,
     &   1.81004368E-04, 1.82651167E-04, 1.80371228E-04, 1.72687869E-04,
     &   1.70079175E-04, 1.71782187E-04, 1.73130157E-04, 1.73512461E-04,
     &   1.72121387E-04, 1.64432354E-04, 1.65266241E-04, 1.65982434E-04,
     &   1.67394594E-04, 1.68948631E-04, 1.68917150E-04, 1.63670299E-04/
  
         DATA ((DAS  (I,J), I=1201,1300), J=2,2) /
     &   1.64485257E-04, 1.62532166E-04, 1.63172239E-04, 1.61912010E-04,
     &   1.62389667E-04, 1.61774779E-04, 1.64213126E-04, 1.64826492E-04,
     &   1.70491137E-04, 1.68047686E-04, 1.68743606E-04, 1.72325963E-04,
     &   1.66771437E-04, 1.70208541E-04, 1.75647898E-04, 1.96250464E-04,
     &   1.84641228E-04, 1.90235298E-04, 1.95574402E-04, 1.81941976E-04,
     &   1.84599496E-04, 1.87239374E-04, 2.09967879E-04, 2.12873940E-04,
     &   2.55107403E-04, 2.59085138E-04, 3.37242711E-04, 4.24353613E-04,
     &   5.68283082E-04, 7.21208143E-04, 4.83411965E-04, 2.73591808E-04,
     &   2.03651755E-04, 1.58025871E-04, 1.23136986E-04, 1.14338944E-04,
     &   1.07970548E-04, 9.92664852E-05, 9.34887375E-05, 9.12407923E-05,
     &   8.92900404E-05, 8.75741201E-05, 8.60474691E-05, 8.46760162E-05,
     &   8.34295103E-05, 8.22960091E-05, 8.12555621E-05, 8.02953952E-05,
     &   7.94051453E-05, 7.85763067E-05, 7.78018239E-05, 7.70757875E-05,
     &   7.63932047E-05, 7.57498228E-05, 7.51419928E-05, 7.45665631E-05,
     &   7.40207945E-05, 7.35022933E-05, 7.30089570E-05, 7.25389307E-05,
     &   7.20905710E-05, 7.16624167E-05, 7.12531647E-05, 7.08616498E-05,
     &   7.04868280E-05, 7.01277622E-05, 6.97836109E-05, 6.94536179E-05,
     &   6.91371045E-05, 6.88334623E-05, 6.85421475E-05, 6.82626765E-05,
     &   6.79946219E-05, 6.77881450E-05, 6.74913173E-05, 6.70298495E-05,
     &   6.66086292E-05, 6.62268793E-05, 6.58847105E-05, 6.55832673E-05,
     &   6.53249773E-05, 6.51139507E-05, 6.49566224E-05, 6.48627973E-05,
     &   6.48474072E-05, 6.49340381E-05, 6.51586230E-05, 6.55842079E-05,
     &   6.63238206E-05, 6.64221687E-05, 6.76036957E-05, 6.99471249E-05,
     &   7.48598579E-05, 8.42913090E-05, 8.85713479E-05, 1.08062590E-04,
     &   1.48703521E-04, 1.68498224E-04, 1.96885887E-04, 2.16107528E-04/
  
         DATA ((DAS  (I,J), I=1301,1400), J=2,2) /
     &   2.40361099E-04, 2.64793582E-04, 2.95504872E-04, 3.13994789E-04,
     &   3.35166391E-04, 3.59632665E-04, 3.88208393E-04, 4.22000642E-04,
     &   4.62552744E-04, 4.86020949E-04, 5.12082688E-04, 5.41187920E-04,
     &   5.73897019E-04, 6.10916861E-04, 6.53152045E-04, 7.01779224E-04,
     &   7.58357691E-04, 8.24998689E-04, 8.52759263E-04, 8.70178215E-04,
     &   8.88330356E-04, 9.07262808E-04, 9.27026816E-04, 9.47678216E-04,
     &   9.69277954E-04, 9.91892689E-04, 1.01559548E-03, 1.04046655E-03,
     &   1.06659424E-03, 1.09407600E-03, 1.12301964E-03, 1.15354471E-03,
     &   1.18578418E-03, 1.21988634E-03, 1.25601709E-03, 1.29436264E-03,
     &   1.33513272E-03, 1.37856436E-03, 1.42492658E-03, 1.47452588E-03,
     &   1.52771305E-03, 1.58489149E-03, 1.64652740E-03, 1.71316251E-03,
     &   1.78543008E-03, 1.86407499E-03, 1.94997956E-03, 2.04419671E-03,
     &   2.14799329E-03, 2.26290738E-03, 2.39082491E-03, 2.53408392E-03,
     &   2.69561866E-03, 2.87916254E-03, 3.08954009E-03, 3.33309693E-03,
     &   3.61835048E-03, 3.95700583E-03, 4.36560075E-03, 4.86828616E-03,
     &   5.50177560E-03, 6.32473143E-03, 7.43704039E-03, 9.02371374E-03,
     &   1.14699880E-02, 1.57318669E-02, 2.50059767E-02, 3.07560453E-02,
     &   5.85808544E-02, 8.15111358E-02, 9.81320893E-02, 1.10992658E-01,
     &   1.21559188E-01, 1.30806062E-01, 1.39385872E-01, 1.45358805E-01,
     &   1.51438791E-01, 1.57418403E-01, 1.60301454E-01, 1.64341994E-01,
     &   1.66763039E-01, 1.69768195E-01, 1.70551354E-01, 1.71709747E-01,
     &   1.72191152E-01, 1.71828333E-01, 1.71274728E-01, 1.70438937E-01,
     &   1.67792144E-01, 1.65936059E-01, 1.63654841E-01, 1.57777254E-01,
     &   1.54128263E-01, 1.49957876E-01, 1.45186342E-01, 1.33998036E-01,
     &   1.27427289E-01, 1.20304007E-01, 1.04112195E-01, 9.51492377E-02/
  
         DATA ((DAS  (I,J), I=1401,1500), J=2,2) /
     &   7.54248992E-02, 5.37102587E-02, 5.73466218E-03, 5.29970594E-02,
     &   7.47674175E-02, 9.44624924E-02, 1.11962892E-01, 1.19830558E-01,
     &   1.26993186E-01, 1.33537703E-01, 1.44866933E-01, 1.49627379E-01,
     &   1.53878948E-01, 1.57560200E-01, 1.63496872E-01, 1.65782917E-01,
     &   1.67685331E-01, 1.70364937E-01, 1.71230201E-01, 1.72113997E-01,
     &   1.72193558E-01, 1.71736228E-01, 1.70604499E-01, 1.68929207E-01,
     &   1.66835276E-01, 1.64422967E-01, 1.60391254E-01, 1.57527219E-01,
     &   1.51535714E-01, 1.45471509E-01, 1.39480469E-01, 1.30895108E-01,
     &   1.21640451E-01, 1.11063896E-01, 9.81906502E-02, 8.15539462E-02,
     &   5.82670580E-02, 3.18016132E-02, 1.81898584E-02, 1.27267609E-02,
     &   9.78544718E-03, 7.94803220E-03, 6.69146385E-03, 5.77798190E-03,
     &   5.08398563E-03, 4.53887112E-03, 4.09938037E-03, 3.73753212E-03,
     &   3.43442580E-03, 3.17683456E-03, 2.95522509E-03, 2.76255255E-03,
     &   2.59349840E-03, 2.44397218E-03, 2.31077641E-03, 2.19137553E-03,
     &   2.08373303E-03, 1.98619447E-03, 1.89740186E-03, 1.81623013E-03,
     &   1.74173926E-03, 1.67313770E-03, 1.60975420E-03, 1.55101579E-03,
     &   1.49643041E-03, 1.44557314E-03, 1.39807513E-03, 1.35361460E-03,
     &   1.31190962E-03, 1.27271211E-03, 1.23580287E-03, 1.20098757E-03,
     &   1.16809324E-03, 1.13696548E-03, 1.10746598E-03, 1.07947053E-03,
     &   1.05286721E-03, 1.02755497E-03, 1.00344227E-03, 9.80446061E-04,
     &   9.58490766E-04, 9.37507487E-04, 9.17433275E-04, 8.98210502E-04,
     &   8.79786309E-04, 8.62112126E-04, 8.45143244E-04, 7.17192726E-04,
     &   6.38795670E-04, 5.63657460E-04, 4.79818698E-04, 4.01481042E-04,
     &   3.24381735E-04, 2.80988603E-04, 2.24642919E-04, 2.05638297E-04,
     &   1.90918912E-04, 1.79191719E-04, 1.69162718E-04, 1.61731163E-04/
  
         DATA ((DAS  (I,J), I=1501,1600), J=2,2) /
     &   1.51812814E-04, 1.42055634E-04, 1.31468278E-04, 1.35441500E-04,
     &   1.48126021E-04, 1.94549093E-04, 2.86569115E-04, 4.19114536E-04,
     &   6.00848947E-04, 8.54729351E-04, 1.49541016E-03, 1.61714857E-03,
     &   1.76056585E-03, 1.80213412E-03, 1.89689422E-03, 2.00219845E-03,
     &   2.11990656E-03, 2.25234311E-03, 2.40245366E-03, 2.57402503E-03,
     &   2.77200876E-03, 3.00300927E-03, 3.27602912E-03, 3.60367514E-03,
     &   4.00415398E-03, 4.50477807E-03, 5.14846328E-03, 6.00673607E-03,
     &   7.20832965E-03, 9.01070562E-03, 1.20144834E-02, 1.80207885E-02,
     &   2.60778316E-02, 2.74301966E-02, 2.89304020E-02, 3.06040762E-02,
     &   3.24831307E-02, 3.46078089E-02, 3.70295925E-02, 3.98154154E-02,
     &   4.30539227E-02, 4.68650371E-02, 5.14150617E-02, 5.69414482E-02,
     &   6.37952851E-02, 7.25182374E-02, 8.39914317E-02, 9.97485797E-02,
     &   1.22709354E-01, 1.59163210E-01, 2.25318237E-01, 3.74979131E-01,
     &   4.27443248E-01, 4.68736491E-01, 5.14761411E-01, 5.53387370E-01,
     &   5.81243624E-01, 6.04868994E-01, 6.15754636E-01, 6.20076560E-01,
     &   6.14640634E-01, 5.95378729E-01, 5.73201552E-01, 5.69005069E-01,
     &   5.66823406E-01, 5.62290211E-01, 5.60412665E-01, 5.58980124E-01,
     &   5.57526543E-01, 5.41806353E-01, 5.14000183E-01, 4.76793189E-01,
     &   4.37371714E-01, 3.86876810E-01, 3.29501230E-01, 2.72384138E-01,
     &   2.38632331E-01, 2.03605362E-01, 1.67461587E-01, 1.15326162E-01,
     &   7.72598786E-02, 3.87452097E-02, 1.55134227E-02, 7.76002256E-03,
     &   3.88294807E-03, 9.35995460E-05, 3.87503673E-03, 7.75211001E-03,
     &   3.87373133E-02, 7.72520343E-02, 1.15318403E-01, 2.85489463E-01,
     &   3.47407226E-01, 4.46620017E-01, 4.84778280E-01, 5.20628700E-01,
     &   5.49935262E-01, 5.71128068E-01, 5.89452927E-01, 6.01741164E-01/
  
         DATA ((DAS  (I,J), I=1601,1700), J=2,2) /
     &   6.11297205E-01, 6.16690830E-01, 6.19638583E-01, 6.19962455E-01,
     &   6.18159527E-01, 6.14917105E-01, 6.04199682E-01, 5.96976238E-01,
     &   5.88967554E-01, 5.81245916E-01, 5.63863278E-01, 5.54349908E-01,
     &   5.38898933E-01, 5.14764964E-01, 4.27447746E-01, 3.59805735E-01,
     &   3.08587148E-01, 2.69240471E-01, 2.38356221E-01, 2.13594627E-01,
     &   1.88870512E-01, 1.50268418E-01, 1.39822235E-01, 1.30717905E-01,
     &   1.22715191E-01, 1.10822248E-01, 9.17284359E-02, 7.82241750E-02,
     &   6.81752500E-02, 6.04088087E-02, 5.42278824E-02, 4.91926272E-02,
     &   4.50119169E-02, 4.14854550E-02, 3.84709484E-02, 3.58645450E-02,
     &   3.35886831E-02, 3.15842725E-02, 2.98055077E-02, 2.82163350E-02,
     &   2.67879899E-02, 1.80267204E-02, 1.20204153E-02, 9.01663570E-03,
     &   6.01266070E-03, 4.51071073E-03, 3.60962183E-03, 3.00897620E-03,
     &   2.58000415E-03, 2.25833548E-03, 2.00820677E-03, 1.80816158E-03,
     &   1.69471285E-03, 1.56235624E-03, 1.44930482E-03, 1.35163156E-03,
     &   1.26640990E-03, 1.19141447E-03, 9.20271001E-04, 7.51147289E-04,
     &   6.36075994E-04, 5.53087840E-04, 4.90998195E-04, 4.43808465E-04,
     &   4.04302754E-04, 3.71959300E-04, 1.84856695E-04, 1.78029099E-04,
     &   1.85552982E-04, 1.89799041E-04, 2.00397883E-04, 2.19106264E-04,
     &   2.30242763E-04, 2.46226689E-04, 2.87797354E-04, 3.57963490E-04,
     &   4.87795934E-04, 7.96765418E-04, 1.09679924E-03, 1.17456619E-03,
     &   1.26435414E-03, 1.36916334E-03, 1.49308872E-03, 1.64186811E-03,
     &   1.82378072E-03, 2.05125331E-03, 2.34381304E-03, 2.73397824E-03,
     &   3.28035620E-03, 4.10010597E-03, 5.46654392E-03, 5.70420782E-03,
     &   5.96345112E-03, 6.24741684E-03, 6.55978177E-03, 6.90499018E-03,
     &   7.28859683E-03, 7.71733494E-03, 8.19960963E-03, 8.74624181E-03/
  
         DATA ((DAS  (I,J), I=1701,1800), J=2,2) /
     &   9.37095962E-03, 1.00916942E-02, 1.09326192E-02, 1.19264106E-02,
     &   1.31187669E-02, 1.45761457E-02, 1.50315368E-02, 1.63977066E-02,
     &   1.87391119E-02, 2.18606319E-02, 2.62292685E-02, 3.27782286E-02,
     &   4.36779315E-02, 6.54074018E-02, 1.29632626E-01, 1.54116375E-01,
     &   2.17377829E-01, 2.65486889E-01, 3.05126780E-01, 3.39724886E-01,
     &   3.70420423E-01, 3.97957290E-01, 4.22554522E-01, 4.45353633E-01,
     &   4.66884651E-01, 4.86561616E-01, 5.03869813E-01, 5.19880094E-01,
     &   5.34315234E-01, 5.46958678E-01, 5.58970934E-01, 5.68810439E-01,
     &   5.76494115E-01, 5.83017770E-01, 5.88039027E-01, 5.91149530E-01,
     &   5.91932088E-01, 5.90609870E-01, 5.86791502E-01, 5.80044571E-01,
     &   5.69900845E-01, 5.58496915E-01, 5.40834494E-01, 5.18365668E-01,
     &   4.90633613E-01, 4.51125426E-01, 4.03548230E-01, 3.39227738E-01,
     &   2.54942602E-01, 3.49292546E-02, 1.04544257E-04, 1.15403880E-01,
     &   2.54938460E-01, 3.39224016E-01, 4.03544944E-01, 4.51122551E-01,
     &   4.90631157E-01, 5.18363569E-01, 5.40832745E-01, 5.58495504E-01,
     &   5.69899704E-01, 5.80043736E-01, 5.86790956E-01, 5.90609595E-01,
     &   5.91932064E-01, 5.91149739E-01, 5.88039486E-01, 5.83018456E-01,
     &   5.76495008E-01, 5.68811520E-01, 5.58972209E-01, 5.46960148E-01,
     &   5.34316877E-01, 5.19881905E-01, 5.03871787E-01, 4.86563743E-01,
     &   4.66886931E-01, 4.45356059E-01, 4.22557085E-01, 3.97959981E-01,
     &   3.70423241E-01, 3.39727825E-01, 3.05129837E-01, 2.65490058E-01,
     &   2.17381108E-01, 1.54119759E-01, 1.31967440E-01, 1.27812575E-01,
     &   1.22658881E-01, 1.08424722E-01, 9.55964051E-02, 6.54073227E-02,
     &   4.36814080E-02, 3.27808156E-02, 2.62321776E-02, 2.18641132E-02,
     &   1.87425932E-02, 1.64009641E-02, 1.45796263E-02, 1.31222469E-02/
  
         DATA ((DAS  (I,J), I=1801,1900), J=2,2) /
     &   1.19297716E-02, 1.09360977E-02, 1.00951718E-02, 9.37436327E-03,
     &   8.74971737E-03, 8.20308401E-03, 5.47000621E-03, 4.10355144E-03,
     &   3.28377942E-03, 2.73737481E-03, 2.34717083E-03, 2.05458414E-03,
     &   1.82708662E-03, 1.49634535E-03, 1.26756620E-03, 1.17774466E-03,
     &   1.09993174E-03, 8.20735700E-04, 6.17509263E-04, 4.97066833E-04,
     &   4.17741724E-04, 3.61752395E-04, 3.20306254E-04, 2.88531051E-04,
     &   2.63518223E-04, 2.43425310E-04, 2.27042435E-04, 2.13539044E-04,
     &   2.02322276E-04, 1.92971365E-04, 1.85188733E-04, 1.78773104E-04,
     &   1.73609701E-04, 1.69680354E-04, 1.67110192E-04, 1.66310176E-04,
     &   1.65911715E-04, 1.62447369E-04, 1.63866364E-04, 1.90340067E-04,
     &   1.96583642E-04, 2.15528283E-04, 2.33044743E-04, 2.47858726E-04,
     &   2.61219480E-04, 2.72523137E-04, 2.82406199E-04, 2.90872452E-04,
     &   2.97883016E-04, 3.03762448E-04, 3.08466565E-04, 3.11958634E-04,
     &   3.14420802E-04, 3.15870513E-04, 3.16223756E-04, 3.15636853E-04,
     &   3.14075495E-04, 3.11456737E-04, 3.07904311E-04, 3.03482135E-04,
     &   2.97861746E-04, 2.91438216E-04, 2.83826788E-04, 2.75136366E-04,
     &   2.65202684E-04, 2.53994314E-04, 2.41519693E-04, 2.27858723E-04,
     &   2.12063997E-04, 1.94573111E-04, 1.75343331E-04, 1.53399837E-04,
     &   1.29622433E-04, 1.17358661E-04, 1.68566685E-04, 1.95882398E-04,
     &   2.17041444E-04, 2.33998125E-04, 2.48520966E-04, 2.61025586E-04,
     &   2.71405069E-04, 2.80535274E-04, 2.88432908E-04, 2.95160310E-04,
     &   3.00799073E-04, 3.05483636E-04, 3.09200480E-04, 3.12188612E-04,
     &   3.14240426E-04, 3.15559492E-04, 3.16118733E-04, 3.15846155E-04,
     &   3.14811453E-04, 3.13022147E-04, 3.10335841E-04, 3.06867481E-04,
     &   3.02592407E-04, 2.97094727E-04, 2.90925109E-04, 2.84022467E-04/
  
         DATA ((DAS  (I,J), I=1901,2000), J=2,2) /
     &   2.75586395E-04, 2.66058097E-04, 2.55405884E-04, 2.42861823E-04,
     &   2.29349374E-04, 2.13324794E-04, 1.96979363E-04, 1.75486794E-04,
     &   1.55569881E-04, 1.54502332E-04, 1.38577498E-04, 1.33880678E-04,
     &   1.32949901E-04, 1.31808334E-04, 1.28617757E-04, 1.26538055E-04,
     &   1.25783342E-04, 1.25385275E-04, 1.25187826E-04, 1.24797205E-04,
     &   1.24228859E-04, 1.23963098E-04, 1.23613917E-04, 1.23534499E-04,
     &   1.23469551E-04, 1.23040588E-04, 1.22737130E-04, 1.22288428E-04,
     &   1.21906439E-04, 1.21566512E-04, 1.21219374E-04, 1.20586743E-04,
     &   1.19958263E-04, 1.19332697E-04, 1.18696518E-04, 1.18075817E-04,
     &   1.17512638E-04, 1.17111354E-04, 1.16273915E-04, 1.15573708E-04,
     &   1.15742753E-04, 1.11539166E-04, 1.07890028E-04, 1.06395336E-04,
     &   1.00194654E-04, 1.05971687E-04, 1.08992914E-04, 1.10494814E-04,
     &   1.13464819E-04, 1.15748250E-04, 1.16046999E-04, 1.16671803E-04,
     &   1.17607023E-04, 1.18248261E-04, 1.18947883E-04, 1.19733434E-04,
     &   1.20551255E-04, 1.21381510E-04, 1.22208586E-04, 1.23044040E-04,
     &   1.23869196E-04, 1.24715119E-04, 1.25589520E-04, 1.26508269E-04,
     &   1.27317043E-04, 1.28092512E-04, 1.28973206E-04, 1.29981351E-04,
     &   1.31176214E-04, 1.32458989E-04, 1.33651591E-04, 1.34963878E-04,
     &   1.36744365E-04, 1.39188049E-04, 1.42358229E-04, 1.46595952E-04,
     &   1.52542867E-04, 1.52655281E-04, 1.48042955E-04, 1.42458347E-04,
     &   1.43047080E-04, 1.45119490E-04, 1.47133664E-04, 1.49092131E-04,
     &   1.50940961E-04, 1.52670672E-04, 1.54330422E-04, 1.55927088E-04,
     &   1.57470766E-04, 1.54509448E-04, 1.51587490E-04, 1.49102813E-04,
     &   1.46971132E-04, 1.45064135E-04, 1.43308140E-04, 1.41733436E-04,
     &   1.40323667E-04, 1.39029635E-04, 1.37833052E-04, 1.36662066E-04/
  
         DATA ((DAS  (I,J), I=2001,2100), J=2,2) /
     &   1.35513446E-04, 1.34451052E-04, 1.33501803E-04, 1.32513841E-04,
     &   1.31517578E-04, 1.30816090E-04, 1.29689818E-04, 1.29175681E-04,
     &   1.26906904E-04, 1.24758951E-04, 1.23064748E-04, 1.22177599E-04,
     &   1.19537120E-04, 1.16626947E-04, 1.14833019E-04, 1.12555127E-04,
     &   1.14701603E-04, 1.16465663E-04, 1.19355015E-04, 1.21997275E-04,
     &   1.22887985E-04, 1.24600082E-04, 1.26778140E-04, 1.29078906E-04,
     &   1.29584939E-04, 1.30717503E-04, 1.31404376E-04, 1.32380762E-04,
     &   1.33348591E-04, 1.34263942E-04, 1.35284720E-04, 1.36377252E-04,
     &   1.37469874E-04, 1.38545888E-04, 1.39724612E-04, 1.40973265E-04,
     &   1.42345429E-04, 1.43849683E-04, 1.45431414E-04, 1.47143029E-04,
     &   1.49098490E-04, 1.51347191E-04, 1.53717428E-04, 1.54141554E-04,
     &   1.55002902E-04, 1.56444955E-04, 1.58699219E-04, 1.62015806E-04,
     &   1.65246459E-04, 1.63611278E-04, 1.61970044E-04, 1.54556028E-04,
     &   1.66663199E-04, 1.74729525E-04, 1.77532048E-04, 1.79626853E-04,
     &   1.81466513E-04, 1.83416857E-04, 1.85471716E-04, 1.87375236E-04,
     &   1.89232168E-04, 1.90738597E-04, 1.92453854E-04, 1.94020316E-04,
     &   1.33366054E-04, 7.27117928E-05, 7.11653890E-05, 6.98767901E-05,
     &   6.88688705E-05, 6.79884388E-05, 6.72726993E-05, 6.66272321E-05,
     &   6.60881574E-05, 6.55907224E-05, 6.51487435E-05, 6.47690940E-05,
     &   6.44100812E-05, 6.40975401E-05, 6.37984531E-05, 6.35352896E-05,
     &   6.32810326E-05, 6.30553674E-05, 6.28356215E-05, 6.26391845E-05,
     &   6.24466454E-05, 6.22734922E-05, 6.21100493E-05, 6.19485768E-05,
     &   6.18022951E-05, 6.16571428E-05, 6.15251086E-05, 6.13935955E-05,
     &   6.12735428E-05, 6.11535666E-05, 6.10437039E-05, 6.09335902E-05,
     &   6.08324809E-05, 6.07308778E-05, 6.06331849E-05, 6.05431576E-05/
  
         DATA ((DAS  (I,J), I=2101,2180), J=2,2) /
     &   6.04523830E-05, 6.03685578E-05, 6.02838706E-05, 6.02055207E-05,
     &   6.01262244E-05, 6.00527378E-05, 5.99782438E-05, 5.99091013E-05,
     &   5.98389079E-05, 5.97736657E-05, 5.97101877E-05, 5.96456188E-05,
     &   5.95854914E-05, 5.95242582E-05, 5.94671723E-05, 5.94089731E-05,
     &   5.93546588E-05, 5.92992294E-05, 5.92474498E-05, 5.91945578E-05,
     &   5.91451039E-05, 5.90945437E-05, 5.90451036E-05, 5.89988197E-05,
     &   5.89514437E-05, 5.88959560E-05, 5.88504620E-05, 5.88078134E-05,
     &   5.87640997E-05, 5.87230924E-05, 5.86810335E-05, 5.86415536E-05,
     &   5.86010365E-05, 5.85629813E-05, 5.85239037E-05, 5.84871800E-05,
     &   5.84510760E-05, 5.84139726E-05, 5.83790772E-05, 5.83431980E-05,
     &   5.83094376E-05, 5.82747091E-05, 5.82420166E-05, 5.82083716E-05,
     &   5.81766854E-05, 5.81440624E-05, 5.81133259E-05, 5.80816682E-05,
     &   5.77655288E-05, 5.74917367E-05, 5.74511799E-05, 5.60979296E-05,
     &   5.56716923E-05, 5.48470863E-05, 5.45113767E-05, 5.44968428E-05,
     &   5.41507929E-05, 5.41498424E-05, 5.39466839E-05, 5.39397303E-05,
     &   5.39355967E-05, 5.38502463E-05, 5.37979885E-05, 5.37889832E-05,
     &   5.37744957E-05, 5.37535370E-05, 5.37391084E-05, 5.37301941E-05,
     &   5.36492627E-05, 5.36454204E-05, 5.36234656E-05, 5.36195030E-05,
     &   5.36019841E-05, 5.35951953E-05, 5.35898513E-05, 5.35849100E-05,
     &   5.35707880E-05, 5.35508946E-05, 5.35426625E-05, 5.34913793E-05/
  
         DATA ((DAS  (I,J), I=   1, 100), J=3,3) /
     &   5.17934175E-06, 5.48448478E-06, 5.81903547E-06, 6.19781990E-06,
     &   6.64938932E-06, 6.91746285E-06, 7.49187404E-06, 8.02120976E-06,
     &   8.33240877E-06, 8.90528755E-06, 8.93947896E-06, 8.94582793E-06,
     &   8.89124759E-06, 8.96546793E-06, 8.83929490E-06, 8.84038355E-06,
     &   8.94513582E-06, 9.22173069E-06, 9.34828494E-06, 9.70454002E-06,
     &   9.92523609E-06, 1.01905752E-05, 1.03621275E-05, 1.06146888E-05,
     &   1.08860803E-05, 1.11375773E-05, 1.14759714E-05, 1.16196087E-05,
     &   1.16822191E-05, 1.19957933E-05, 1.23023028E-05, 1.25844866E-05,
     &   1.29265859E-05, 1.31872955E-05, 1.34652771E-05, 1.37512910E-05,
     &   1.40422946E-05, 1.43433075E-05, 1.46658723E-05, 1.50311767E-05,
     &   1.53221888E-05, 1.57243449E-05, 1.61514440E-05, 1.65081237E-05,
     &   1.70164764E-05, 1.75638675E-05, 1.80007762E-05, 1.85794972E-05,
     &   1.90263837E-05, 1.96361396E-05, 2.28937494E-05, 2.42738182E-05,
     &   2.47318158E-05, 2.56340377E-05, 2.65951255E-05, 2.69208388E-05,
     &   2.79901209E-05, 2.98488703E-05, 3.21207269E-05, 3.43529977E-05,
     &   3.66439491E-05, 3.74936544E-05, 3.89440661E-05, 4.14477477E-05,
     &   4.37808654E-05, 4.65214548E-05, 4.89187692E-05, 5.18424493E-05,
     &   5.27143217E-05, 5.49088944E-05, 5.63049113E-05, 5.79622678E-05,
     &   6.19790907E-05, 6.68912578E-05, 7.27298963E-05, 8.06082895E-05,
     &   9.11759300E-05, 1.06710003E-04, 1.27047511E-04, 1.36531864E-04,
     &   1.71971344E-04, 2.04340326E-04, 2.06464174E-04, 2.21673720E-04,
     &   2.54264597E-04, 3.07668288E-04, 3.51580494E-04, 3.89930724E-04,
     &   4.22502682E-04, 4.40962324E-04, 4.67862470E-04, 4.86096711E-04,
     &   5.01852808E-04, 5.16244118E-04, 5.17192592E-04, 5.18591710E-04,
     &   5.19847327E-04, 5.21121779E-04, 5.22892200E-04, 5.18564972E-04/
  
         DATA ((DAS  (I,J), I= 101, 200), J=3,3) /
     &   5.15615976E-04, 5.04356838E-04, 4.94051617E-04, 4.87920257E-04,
     &   4.72592539E-04, 4.53449440E-04, 4.34687299E-04, 4.16306114E-04,
     &   3.94481474E-04, 3.71301596E-04, 3.37647245E-04, 3.11095623E-04,
     &   2.83731195E-04, 2.54876626E-04, 2.15551054E-04, 1.75950410E-04,
     &   1.31028377E-04, 8.09581988E-05, 1.88038973E-04, 2.39720384E-04,
     &   2.74222809E-04, 3.02090440E-04, 3.26283980E-04, 3.48089132E-04,
     &   3.68263426E-04, 3.87722684E-04, 4.06339295E-04, 4.20627054E-04,
     &   4.34100307E-04, 4.46547687E-04, 4.57808464E-04, 4.67995011E-04,
     &   4.80526803E-04, 4.88137498E-04, 4.94678475E-04, 4.99555735E-04,
     &   5.00817119E-04, 5.02831847E-04, 5.03428241E-04, 5.02559125E-04,
     &   5.01693504E-04, 4.97639426E-04, 4.90543100E-04, 4.83103548E-04,
     &   4.72779342E-04, 4.58043640E-04, 4.42129885E-04, 4.22752120E-04,
     &   4.03391707E-04, 3.77593064E-04, 3.41906495E-04, 3.05814453E-04,
     &   2.98366592E-04, 2.73570661E-04, 2.48774730E-04, 2.33094002E-04,
     &   2.22123465E-04, 2.15154917E-04, 1.92161738E-04, 1.72110178E-04,
     &   1.60312197E-04, 1.43718401E-04, 1.37386070E-04, 1.31684550E-04,
     &   1.26624548E-04, 1.21900017E-04, 1.17403154E-04, 1.15263171E-04,
     &   1.04471456E-04, 9.67879851E-05, 9.11845009E-05, 8.81184016E-05,
     &   8.60420019E-05, 8.45117254E-05, 8.28628084E-05, 8.14152926E-05,
     &   7.94216946E-05, 7.74903302E-05, 7.63181608E-05, 7.59416835E-05,
     &   7.56316034E-05, 7.56841284E-05, 7.65031815E-05, 7.76277585E-05,
     &   7.89823174E-05, 8.02435469E-05, 8.21383721E-05, 8.41562479E-05,
     &   8.67125198E-05, 9.08482054E-05, 9.33407862E-05, 9.53348030E-05,
     &   9.97863710E-05, 1.02635464E-04, 1.07241787E-04, 1.10399139E-04,
     &   1.12549683E-04, 1.14919878E-04, 1.18085572E-04, 1.26988183E-04/
  
         DATA ((DAS  (I,J), I= 201, 300), J=3,3) /
     &   1.39056694E-04, 1.45615950E-04, 1.47964679E-04, 1.50347555E-04,
     &   1.52760869E-04, 1.55212703E-04, 1.57718030E-04, 1.60285618E-04,
     &   1.62941990E-04, 1.65719876E-04, 1.68654108E-04, 1.71772010E-04,
     &   1.75099036E-04, 1.78655012E-04, 1.82463674E-04, 1.86529091E-04,
     &   1.90844785E-04, 1.95507078E-04, 2.00530618E-04, 2.05948248E-04,
     &   2.11797516E-04, 2.18137460E-04, 2.25023138E-04, 2.32530724E-04,
     &   2.40763026E-04, 2.49872354E-04, 2.60108402E-04, 2.71962993E-04,
     &   2.86624145E-04, 3.09070381E-04, 3.31086217E-04, 3.29414279E-04,
     &   3.25006442E-04, 3.05231472E-04, 3.25629842E-04, 3.33494962E-04,
     &   3.43481551E-04, 3.55740538E-04, 3.37980622E-04, 3.72505906E-04,
     &   4.10747682E-04, 4.31883746E-04, 4.14192636E-04, 4.68984674E-04,
     &   5.23776713E-04, 5.73174061E-04, 6.36775679E-04, 7.09238082E-04,
     &   7.64986449E-04, 8.04981303E-04, 8.22187936E-04, 8.16655768E-04,
     &   8.10237197E-04, 8.37011998E-04, 8.57967013E-04, 8.92032928E-04,
     &   9.55815138E-04, 1.03128547E-03, 1.06700221E-03, 1.12282224E-03,
     &   1.14940199E-03, 1.16155920E-03, 1.20515357E-03, 1.25508519E-03,
     &   1.26714679E-03, 1.30244572E-03, 1.31777349E-03, 1.16939768E-03,
     &   1.01269964E-03, 8.72929967E-04, 7.46740926E-04, 4.53769753E-04,
     &   9.61747550E-05, 5.15536409E-04, 8.59188722E-04, 9.82877696E-04,
     &   9.76738478E-04, 9.83705636E-04, 9.92610602E-04, 1.00179288E-03,
     &   9.84524840E-04, 9.61314762E-04, 9.57501082E-04, 9.69884346E-04,
     &   9.85311056E-04, 9.87131743E-04, 9.91739977E-04, 9.78547406E-04,
     &   9.83549599E-04, 1.05525828E-03, 1.13391057E-03, 1.16171327E-03,
     &   1.15112155E-03, 1.13960667E-03, 1.04760129E-03, 9.57330384E-04,
     &   8.94862427E-04, 8.56097200E-04, 8.27340464E-04, 8.06360843E-04/
  
         DATA ((DAS  (I,J), I= 301, 400), J=3,3) /
     &   9.00860014E-04, 7.76668505E-04, 7.64627145E-04, 8.00007753E-04,
     &   7.21114048E-04, 6.85603252E-04, 6.49737751E-04, 5.41400478E-04,
     &   5.33334307E-04, 4.93796664E-04, 4.69378297E-04, 4.44950979E-04,
     &   4.26302427E-04, 4.11290850E-04, 3.96042117E-04, 3.77859293E-04,
     &   3.67147903E-04, 3.62375225E-04, 3.55849207E-04, 3.49042198E-04,
     &   3.43489263E-04, 3.37806659E-04, 3.32022257E-04, 3.30599001E-04,
     &   3.19424179E-04, 3.85337560E-04, 3.85481153E-04, 3.24862814E-04,
     &   3.04174952E-04, 2.92052743E-04, 2.82607458E-04, 2.74826130E-04,
     &   2.68009839E-04, 2.61965915E-04, 2.56526289E-04, 2.51590422E-04,
     &   2.47083986E-04, 2.42948084E-04, 2.39145580E-04, 2.35634147E-04,
     &   2.32390586E-04, 2.22293635E-04, 2.19749108E-04, 2.17327917E-04,
     &   2.15008212E-04, 2.12814954E-04, 2.10714617E-04, 2.08704619E-04,
     &   2.06780354E-04, 2.04937283E-04, 2.03171530E-04, 2.01475753E-04,
     &   1.99847779E-04, 1.98283240E-04, 1.96777747E-04, 1.95388689E-04,
     &   1.87121339E-04, 1.70174653E-04, 1.46905464E-04, 1.32031129E-04,
     &   1.21813585E-04, 1.14732076E-04, 1.09683188E-04, 1.06047229E-04,
     &   1.03681196E-04, 1.03496229E-04, 1.01834280E-04, 1.01685588E-04,
     &   1.01830083E-04, 1.02590214E-04, 1.03991732E-04, 1.04166434E-04,
     &   1.05940281E-04, 1.08111794E-04, 1.09271745E-04, 1.10559177E-04,
     &   1.13490349E-04, 1.16831072E-04, 1.20614623E-04, 1.24651489E-04,
     &   1.27329207E-04, 1.29214640E-04, 1.34298773E-04, 1.39949641E-04,
     &   1.40543126E-04, 1.46194363E-04, 1.53292221E-04, 1.57209273E-04,
     &   1.61365039E-04, 1.70538995E-04, 1.81160164E-04, 1.94023934E-04,
     &   1.98352657E-04, 2.09328400E-04, 2.18035446E-04, 2.27576202E-04,
     &   2.50364467E-04, 2.81277766E-04, 2.85244898E-04, 3.21515591E-04/
  
         DATA ((DAS  (I,J), I= 401, 500), J=3,3) /
     &   3.88887541E-04, 4.02506405E-04, 3.55788830E-04, 3.19947190E-04,
     &   3.06506575E-04, 2.69761605E-04, 2.60963057E-04, 2.56226552E-04,
     &   2.50271396E-04, 2.39650919E-04, 2.28228040E-04, 2.16931426E-04,
     &   2.15753060E-04, 2.05109215E-04, 2.03843066E-04, 1.97743260E-04,
     &   1.93102184E-04, 1.77185047E-04, 1.74442941E-04, 1.55777555E-04,
     &   1.54315754E-04, 1.52862277E-04, 1.38876863E-04, 1.27357153E-04,
     &   1.25488519E-04, 1.16256652E-04, 1.15576125E-04, 1.12400497E-04,
     &   1.11803823E-04, 1.08349229E-04, 1.06533135E-04, 1.00784743E-04,
     &   1.00122410E-04, 9.28734726E-05, 8.54934562E-05, 8.13573333E-05,
     &   8.05562131E-05, 7.11650812E-05, 6.99757175E-05, 6.56536143E-05,
     &   6.38769870E-05, 6.33531372E-05, 6.30765271E-05, 6.29596088E-05,
     &   6.24449258E-05, 6.24700988E-05, 6.28878732E-05, 6.39773985E-05,
     &   6.48717070E-05, 7.03016505E-05, 7.99058492E-05, 8.22325138E-05,
     &   8.34210528E-05, 9.13576331E-05, 9.54962903E-05, 9.97119418E-05,
     &   1.17870472E-04, 1.20232464E-04, 1.26292401E-04, 1.29416797E-04,
     &   1.32115048E-04, 1.32342673E-04, 1.32692561E-04, 1.32707313E-04,
     &   1.32610354E-04, 1.31995020E-04, 1.30683113E-04, 1.29495388E-04,
     &   1.27921951E-04, 1.25912231E-04, 1.25638780E-04, 1.20473768E-04,
     &   1.16952462E-04, 1.14580182E-04, 1.14229183E-04, 1.10843946E-04,
     &   1.10469298E-04, 1.09104492E-04, 1.01602248E-04, 1.03385176E-04,
     &   1.06134052E-04, 1.48083049E-04, 1.74829705E-04, 1.94507654E-04,
     &   2.48763093E-04, 3.03810173E-04, 3.14360378E-04, 3.19883783E-04,
     &   3.28783867E-04, 3.31019149E-04, 3.36827163E-04, 3.38065855E-04,
     &   3.44484889E-04, 3.58009680E-04, 3.77709100E-04, 3.87693902E-04,
     &   5.50853806E-04, 6.53305545E-04, 5.56930809E-04, 3.71816040E-04/
  
         DATA ((DAS  (I,J), I= 501, 600), J=3,3) /
     &   2.95848570E-04, 2.65854731E-04, 2.24007039E-04, 2.19906683E-04,
     &   2.10413763E-04, 2.00361817E-04, 1.84375752E-04, 1.79881862E-04,
     &   1.77073848E-04, 1.76020996E-04, 1.76970115E-04, 1.80145316E-04,
     &   1.86082824E-04, 1.95727971E-04, 2.10786492E-04, 2.34516690E-04,
     &   2.73707647E-04, 2.84533604E-04, 2.96760924E-04, 3.10648123E-04,
     &   3.26520739E-04, 3.44793641E-04, 3.66004158E-04, 3.90859367E-04,
     &   3.96346066E-04, 4.02024511E-04, 4.07904273E-04, 4.13995858E-04,
     &   4.20310051E-04, 4.26858689E-04, 4.33654376E-04, 4.40710623E-04,
     &   4.48041939E-04, 4.55663919E-04, 4.94071818E-04, 5.24046474E-04,
     &   5.40626118E-04, 5.52345234E-04, 5.64640795E-04, 5.77553067E-04,
     &   5.91128286E-04, 6.05417094E-04, 6.20475275E-04, 6.28311991E-04,
     &   6.36364791E-04, 6.44642482E-04, 6.53154231E-04, 6.61910244E-04,
     &   6.70920443E-04, 6.80195925E-04, 6.89748321E-04, 6.99589880E-04,
     &   7.09733608E-04, 7.20193303E-04, 7.30983472E-04, 7.42119931E-04,
     &   7.53619145E-04, 7.65498713E-04, 7.77777487E-04, 7.90475393E-04,
     &   8.03613726E-04, 8.17215602E-04, 8.31305398E-04, 8.45909474E-04,
     &   8.61055674E-04, 8.76774383E-04, 8.93098116E-04, 9.10061898E-04,
     &   9.27703464E-04, 9.46063725E-04, 9.65186708E-04, 9.85120273E-04,
     &   1.00591632E-03, 1.02763131E-03, 1.05032668E-03, 1.07406947E-03,
     &   1.09893300E-03, 1.12499747E-03, 1.15235122E-03, 1.18109104E-03,
     &   1.21132393E-03, 1.24316811E-03, 1.27675461E-03, 1.29424612E-03,
     &   1.31222907E-03, 1.33072428E-03, 1.34975378E-03, 1.36934086E-03,
     &   1.38951019E-03, 1.41028784E-03, 1.43170177E-03, 1.45378131E-03,
     &   1.47655758E-03, 1.50006417E-03, 1.52433634E-03, 1.54941187E-03,
     &   1.57533114E-03, 1.60213712E-03, 1.62987583E-03, 1.65859654E-03/
  
         DATA ((DAS  (I,J), I= 601, 700), J=3,3) /
     &   1.68835201E-03, 1.71919889E-03, 1.75119801E-03, 1.78441482E-03,
     &   1.81891981E-03, 1.85478902E-03, 1.89210461E-03, 1.93095548E-03,
     &   1.97143786E-03, 2.01365633E-03, 2.05772454E-03, 2.10376629E-03,
     &   2.15191671E-03, 2.20232345E-03, 2.25514836E-03, 2.31056914E-03,
     &   2.36878129E-03, 2.43000057E-03, 2.49446537E-03, 2.56244008E-03,
     &   2.63421860E-03, 2.74172996E-03, 2.79053629E-03, 2.87585283E-03,
     &   2.96654082E-03, 3.06312291E-03, 3.16619184E-03, 3.27642260E-03,
     &   3.39458714E-03, 3.52157253E-03, 3.65840315E-03, 3.80626840E-03,
     &   3.96655730E-03, 4.14090220E-03, 4.28008897E-03, 4.71373652E-03,
     &   5.24486316E-03, 5.91046270E-03, 6.76895767E-03, 7.91834144E-03,
     &   9.53650683E-03, 1.19835141E-02, 1.61149311E-02, 2.45805344E-02,
     &   5.16853746E-02, 5.46541513E-02, 5.79834168E-02, 6.17428113E-02,
     &   6.60210628E-02, 7.09329711E-02, 7.66296790E-02, 8.33141735E-02,
     &   9.12653781E-02, 1.00876878E-01, 1.12721625E-01, 1.27664977E-01,
     &   1.47072593E-01, 1.73215376E-01, 1.76332277E-01, 2.46123698E-01,
     &   2.96992555E-01, 3.37862747E-01, 3.73407283E-01, 4.00797193E-01,
     &   4.24729041E-01, 4.43908749E-01, 4.63015986E-01, 4.76141525E-01,
     &   4.88294689E-01, 4.96870398E-01, 5.03940105E-01, 5.07912931E-01,
     &   5.10878384E-01, 5.11130550E-01, 5.09638101E-01, 5.05499301E-01,
     &   5.01026235E-01, 4.91350936E-01, 4.82681946E-01, 4.72040844E-01,
     &   4.59260248E-01, 4.44179594E-01, 4.26651217E-01, 4.06547440E-01,
     &   3.83768504E-01, 3.58251058E-01, 3.29976777E-01, 2.98980535E-01,
     &   2.47608334E-01, 2.10367017E-01, 1.50669787E-01, 8.74175543E-02,
     &   8.73572356E-02, 2.47555515E-01, 2.98931961E-01, 3.44413840E-01,
     &   3.71313895E-01, 4.06512091E-01, 4.26619333E-01, 4.44151157E-01/
  
         DATA ((DAS  (I,J), I= 701, 800), J=3,3) /
     &   4.59235207E-01, 4.72019124E-01, 4.82663452E-01, 4.91335558E-01,
     &   4.98204593E-01, 5.03437488E-01, 5.07195886E-01, 5.09633922E-01,
     &   5.11130027E-01, 5.10880137E-01, 5.08933177E-01, 5.05415556E-01,
     &   5.02352752E-01, 4.94860937E-01, 4.88309886E-01, 4.78686437E-01,
     &   4.68368272E-01, 4.54906347E-01, 4.41182666E-01, 4.22045654E-01,
     &   4.03426879E-01, 3.80679219E-01, 3.55023545E-01, 3.22024218E-01,
     &   2.84194998E-01, 2.36959400E-01, 1.95261108E-01, 1.62870897E-01,
     &   1.39499185E-01, 1.21901355E-01, 1.08198910E-01, 9.72395183E-02,
     &   8.82806910E-02, 8.08238946E-02, 7.45225968E-02, 6.91287415E-02,
     &   6.44602418E-02, 6.03804999E-02, 5.67850837E-02, 5.35928125E-02,
     &   5.07396437E-02, 4.81743873E-02, 4.58556426E-02, 4.37495690E-02,
     &   2.29414027E-02, 1.55491388E-02, 1.17625275E-02, 9.46102489E-03,
     &   7.91429027E-03, 6.80340513E-03, 5.96693759E-03, 5.31441560E-03,
     &   4.79119870E-03, 4.36233755E-03, 4.31154885E-03, 3.95743731E-03,
     &   3.65751643E-03, 3.40024416E-03, 3.17713902E-03, 2.98182871E-03,
     &   2.80943288E-03, 2.65615062E-03, 2.51897768E-03, 2.39550813E-03,
     &   2.28379247E-03, 2.18223433E-03, 2.08951392E-03, 2.00453069E-03,
     &   1.92635957E-03, 1.85421735E-03, 1.78743647E-03, 1.72544458E-03,
     &   1.66774787E-03, 1.61391830E-03, 1.56358290E-03, 1.51641521E-03,
     &   1.47212830E-03, 1.43046874E-03, 1.39121217E-03, 1.35415907E-03,
     &   1.31913142E-03, 1.28596996E-03, 1.25453166E-03, 1.22468777E-03,
     &   1.19632220E-03, 1.16932979E-03, 1.14361518E-03, 1.11909169E-03,
     &   1.09568031E-03, 1.07330906E-03, 1.05191171E-03, 1.03142787E-03,
     &   1.01180207E-03, 9.92983064E-04, 9.74923789E-04, 9.57580905E-04,
     &   9.40914183E-04, 9.24886437E-04, 9.09463202E-04, 8.94612485E-04/
  
         DATA ((DAS  (I,J), I= 801, 900), J=3,3) /
     &   8.80304551E-04, 8.66511734E-04, 8.53208185E-04, 8.40369998E-04,
     &   8.27974833E-04, 8.16001419E-04, 8.04430285E-04, 7.93243069E-04,
     &   7.82422568E-04, 7.71952655E-04, 7.61818200E-04, 7.52005002E-04,
     &   7.42499725E-04, 7.33289724E-04, 7.24363571E-04, 7.15709889E-04,
     &   7.07318388E-04, 6.99179318E-04, 6.91283513E-04, 6.83622400E-04,
     &   6.76187947E-04, 6.68972752E-04, 6.61969648E-04, 6.55172049E-04,
     &   6.48574155E-04, 6.42170614E-04, 6.35956284E-04, 6.29926703E-04,
     &   6.24077962E-04, 6.18406746E-04, 6.12910392E-04, 6.07586734E-04,
     &   6.02435047E-04, 5.97455302E-04, 5.92648520E-04, 5.88017569E-04,
     &   5.83567336E-04, 5.79305423E-04, 5.74592053E-04, 5.69985602E-04,
     &   5.65482435E-04, 5.61078844E-04, 5.56770988E-04, 5.52554580E-04,
     &   5.48423018E-04, 5.44370413E-04, 5.40789029E-04, 5.37220024E-04,
     &   5.33519241E-04, 5.29864206E-04, 5.26291184E-04, 5.22764451E-04,
     &   5.19316992E-04, 5.15940203E-04, 5.12637284E-04, 5.09396565E-04,
     &   5.06226782E-04, 4.08716624E-04, 3.55983783E-04, 3.41158445E-04,
     &   3.56872713E-04, 3.83063160E-04, 4.49905411E-04, 4.91080643E-04,
     &   5.45243004E-04, 5.52908268E-04, 5.93618808E-04, 6.19218373E-04,
     &   6.24061961E-04, 6.94541172E-04, 7.98341407E-04, 8.36149844E-04,
     &   8.78560892E-04, 9.24732480E-04, 9.79594371E-04, 1.03797188E-03,
     &   1.10744346E-03, 1.18996621E-03, 1.28860292E-03, 1.40783347E-03,
     &   1.55420590E-03, 1.73750608E-03, 1.97294958E-03, 2.08684372E-03,
     &   2.21515133E-03, 2.36074440E-03, 2.52731316E-03, 2.71967949E-03,
     &   2.94427213E-03, 3.07127420E-03, 3.20985482E-03, 3.36166000E-03,
     &   3.52866340E-03, 3.71325208E-03, 3.91834081E-03, 4.14752635E-03,
     &   4.40529932E-03, 4.69733968E-03, 5.03093952E-03, 5.41561829E-03/
  
         DATA ((DAS  (I,J), I= 901,1000), J=3,3) /
     &   5.86404328E-03, 6.37044555E-03, 6.70201864E-03, 7.06998335E-03,
     &   7.48066657E-03, 7.94195304E-03, 8.46379446E-03, 9.05893403E-03,
     &   9.74395862E-03, 1.05408652E-02, 1.14794613E-02, 1.26011658E-02,
     &   1.39652685E-02, 1.56597195E-02, 1.78208003E-02, 2.06715319E-02,
     &   2.46035092E-02, 3.03724175E-02, 3.96451056E-02, 5.69333402E-02,
     &   8.41246692E-02, 9.96009383E-02, 1.16481657E-01, 1.58016163E-01,
     &   1.72980065E-01, 1.85330104E-01, 1.95818151E-01, 2.04649686E-01,
     &   2.11895507E-01, 2.18134543E-01, 2.23243100E-01, 2.26899300E-01,
     &   2.30005397E-01, 2.32204237E-01, 2.33508412E-01, 2.33979441E-01,
     &   2.33644948E-01, 2.32730952E-01, 2.30876018E-01, 2.28448746E-01,
     &   2.25176916E-01, 2.20967298E-01, 2.16540852E-01, 2.10339102E-01,
     &   2.04069001E-01, 1.96862418E-01, 1.88673102E-01, 1.77827109E-01,
     &   1.67394017E-01, 1.53881367E-01, 1.41158428E-01, 1.22609006E-01,
     &   1.02365213E-01, 7.21298822E-02, 4.57749003E-02, 1.54197557E-02,
     &   3.61288174E-04, 1.53427805E-02, 3.06186312E-02, 7.20569010E-02,
     &   1.02296677E-01, 1.22544480E-01, 1.41098423E-01, 1.53825009E-01,
     &   1.67342111E-01, 1.77779133E-01, 1.88629775E-01, 1.96823089E-01,
     &   2.04033643E-01, 2.10307658E-01, 2.16513873E-01, 2.20944035E-01,
     &   2.25157842E-01, 2.28433685E-01, 2.30864785E-01, 2.32723862E-01,
     &   2.33641277E-01, 2.33979889E-01, 2.33512676E-01, 2.32212403E-01,
     &   2.30017472E-01, 2.26915217E-01, 2.23262461E-01, 2.18157714E-01,
     &   2.11922416E-01, 2.04680160E-01, 1.95852230E-01, 1.85367738E-01,
     &   1.73021172E-01, 1.58060730E-01, 1.39923944E-01, 1.49770561E-01,
     &   1.28120136E-01, 1.14784814E-01, 1.06722724E-01, 9.00217939E-02,
     &   8.41793036E-02, 7.16023827E-02, 4.63634285E-02, 3.42092507E-02/
  
         DATA ((DAS  (I,J), I=1001,1100), J=3,3) /
     &   2.70894915E-02, 2.24192138E-02, 1.91217989E-02, 1.66702122E-02,
     &   1.47763374E-02, 1.32694754E-02, 1.20420977E-02, 1.10231140E-02,
     &   1.01636500E-02, 9.42900096E-03, 8.79384593E-03, 8.23927670E-03,
     &   7.75089354E-03, 7.31752780E-03, 6.93039611E-03, 6.58248684E-03,
     &   6.03265177E-03, 5.34661456E-03, 4.97990187E-03, 4.38112193E-03,
     &   3.91314379E-03, 3.45517112E-03, 2.80589053E-03, 2.09211622E-03,
     &   1.67067138E-03, 1.49491134E-03, 1.39618458E-03, 1.33223319E-03,
     &   1.28709198E-03, 1.25321678E-03, 1.22666174E-03, 1.20512936E-03,
     &   1.18718472E-03, 1.17186214E-03, 1.15855893E-03, 1.14677947E-03,
     &   1.13619585E-03, 1.12657063E-03, 1.11769374E-03, 1.10941182E-03,
     &   1.10159713E-03, 1.09416460E-03, 1.08701687E-03, 1.08007045E-03,
     &   1.07326610E-03, 1.06656618E-03, 1.05987536E-03, 1.05315840E-03,
     &   1.04634467E-03, 1.03939258E-03, 1.03220731E-03, 1.02470448E-03,
     &   1.01673807E-03, 1.00815705E-03, 9.98654795E-04, 9.87672649E-04,
     &   9.73819043E-04, 9.42675977E-04, 9.15813569E-04, 9.06593522E-04,
     &   9.00455685E-04, 8.95976613E-04, 8.92575137E-04, 8.89951193E-04,
     &   8.87901740E-04, 8.86270691E-04, 8.84945133E-04, 8.83716489E-04,
     &   8.82815716E-04, 8.81807749E-04, 8.80661624E-04, 8.79091559E-04,
     &   8.78340134E-04, 8.77559188E-04, 8.77353460E-04, 8.76422501E-04,
     &   8.74864494E-04, 8.72688973E-04, 8.69825043E-04, 8.66193357E-04,
     &   8.61689727E-04, 8.56197926E-04, 8.49557381E-04, 8.41378605E-04,
     &   8.32050307E-04, 8.20521486E-04, 8.06821419E-04, 7.90440819E-04,
     &   7.70598074E-04, 7.46073072E-04, 7.14681684E-04, 6.71706228E-04,
     &   6.59018983E-04, 6.26545952E-04, 5.83196896E-04, 5.78558327E-04,
     &   5.44366551E-04, 5.31767651E-04, 5.23685414E-04, 5.23352195E-04/
  
         DATA ((DAS  (I,J), I=1101,1200), J=3,3) /
     &   5.24672745E-04, 5.18402148E-04, 5.09302627E-04, 5.03665417E-04,
     &   4.92734542E-04, 4.84297784E-04, 4.77283618E-04, 4.71780806E-04,
     &   4.69696540E-04, 4.63481739E-04, 4.54289117E-04, 4.71867269E-04,
     &   4.71229224E-04, 4.48765218E-04, 4.26301212E-04, 4.03837206E-04,
     &   4.13992625E-04, 4.15465358E-04, 4.11727088E-04, 4.27265463E-04,
     &   4.46262073E-04, 4.72730378E-04, 4.45784348E-04, 4.01749950E-04,
     &   3.97123098E-04, 3.99639164E-04, 3.97888293E-04, 3.90284064E-04,
     &   3.82632803E-04, 4.07513508E-04, 4.62419959E-04, 5.61349797E-04,
     &   6.24219247E-04, 5.40397933E-04, 2.65948812E-04, 2.53786392E-04,
     &   2.55073463E-04, 2.71061799E-04, 2.63826917E-04, 2.51890982E-04,
     &   2.43099071E-04, 2.49150652E-04, 2.58246851E-04, 2.56758739E-04,
     &   2.54097074E-04, 2.48857911E-04, 2.45780274E-04, 2.45548624E-04,
     &   2.45568391E-04, 2.47252608E-04, 2.49069070E-04, 2.51468808E-04,
     &   2.48729167E-04, 2.33833320E-04, 2.27565750E-04, 2.27207413E-04,
     &   2.28082507E-04, 2.35336218E-04, 2.57691268E-04, 3.01062145E-04,
     &   3.08873544E-04, 2.86998766E-04, 2.68589169E-04, 2.49801187E-04,
     &   2.22329643E-04, 2.12228319E-04, 2.24599301E-04, 2.52319984E-04,
     &   2.52302577E-04, 2.09142838E-04, 2.07591809E-04, 2.15130129E-04,
     &   2.44451149E-04, 2.13845426E-04, 2.03611841E-04, 2.02199124E-04,
     &   2.01497303E-04, 2.00834107E-04, 2.00133600E-04, 1.97816433E-04,
     &   2.00485601E-04, 1.99457695E-04, 1.99384861E-04, 2.05460428E-04,
     &   2.27015143E-04, 2.47369160E-04, 2.94427567E-04, 3.20450395E-04,
     &   2.07469347E-04, 1.93330653E-04, 1.85220634E-04, 2.11597204E-04,
     &   2.26496324E-04, 2.99305840E-04, 3.00363871E-04, 2.97099775E-04,
     &   2.92675025E-04, 1.95023647E-04, 1.89557556E-04, 3.26011758E-04/
  
         DATA ((DAS  (I,J), I=1201,1300), J=3,3) /
     &   3.03805297E-04, 2.15404327E-04, 2.01160214E-04, 1.96839566E-04,
     &   1.89417099E-04, 1.86262500E-04, 1.87312971E-04, 1.87539092E-04,
     &   1.83635789E-04, 1.81251319E-04, 1.76931606E-04, 1.75757186E-04,
     &   1.70921018E-04, 1.70693329E-04, 1.71170621E-04, 1.67239772E-04,
     &   1.71727736E-04, 1.83241923E-04, 2.05282648E-04, 1.82801284E-04,
     &   1.60583704E-04, 1.57969682E-04, 1.56924895E-04, 1.54975381E-04,
     &   1.57712638E-04, 1.53558626E-04, 1.48285746E-04, 1.78114241E-04,
     &   1.61755078E-04, 1.44373467E-04, 4.38019745E-04, 6.97119401E-04,
     &   7.83485953E-04, 6.24395772E-04, 4.81599823E-04, 4.40695754E-04,
     &   4.09369325E-04, 3.63940012E-04, 3.32148823E-04, 3.19492884E-04,
     &   3.08419770E-04, 2.98636850E-04, 2.89921812E-04, 2.82102298E-04,
     &   2.75040263E-04, 2.68630837E-04, 2.62783704E-04, 2.57426302E-04,
     &   2.52498431E-04, 2.47949681E-04, 2.43737484E-04, 2.39825626E-04,
     &   2.36183082E-04, 2.32783110E-04, 2.29602529E-04, 2.26621138E-04,
     &   2.23821252E-04, 2.21187318E-04, 2.18705609E-04, 2.16363959E-04,
     &   2.14151556E-04, 2.12058762E-04, 2.10076959E-04, 2.08198427E-04,
     &   2.06416238E-04, 2.04724159E-04, 2.03116583E-04, 2.01588453E-04,
     &   2.00135216E-04, 1.98752766E-04, 1.97437408E-04, 1.96185818E-04,
     &   1.94995019E-04, 1.94084352E-04, 1.92785452E-04, 1.90790905E-04,
     &   1.88997885E-04, 1.87396947E-04, 1.85982661E-04, 1.84753816E-04,
     &   1.83713937E-04, 1.82872204E-04, 1.82244988E-04, 1.81858323E-04,
     &   1.81751987E-04, 1.81987043E-04, 1.82655073E-04, 1.83906396E-04,
     &   1.85995128E-04, 1.86265280E-04, 1.89394010E-04, 1.95111190E-04,
     &   2.05820937E-04, 2.24120323E-04, 2.31971974E-04, 2.66585472E-04,
     &   3.38462076E-04, 3.74082112E-04, 4.25872957E-04, 4.61346679E-04/
  
         DATA ((DAS  (I,J), I=1301,1400), J=3,3) /
     &   5.06491877E-04, 5.52330443E-04, 6.10363083E-04, 6.45485473E-04,
     &   6.85843758E-04, 7.32644552E-04, 7.87492100E-04, 8.52566588E-04,
     &   9.30907862E-04, 9.76348172E-04, 1.02688518E-03, 1.08340538E-03,
     &   1.14701283E-03, 1.21910028E-03, 1.30145012E-03, 1.39638080E-03,
     &   1.50696483E-03, 1.63736234E-03, 1.69172095E-03, 1.72583973E-03,
     &   1.76140254E-03, 1.79850225E-03, 1.83723984E-03, 1.87772532E-03,
     &   1.92007880E-03, 1.96443163E-03, 2.01092776E-03, 2.05972531E-03,
     &   2.11099833E-03, 2.16493887E-03, 2.22175935E-03, 2.28169538E-03,
     &   2.34500897E-03, 2.41199233E-03, 2.48297239E-03, 2.55831608E-03,
     &   2.63843668E-03, 2.72380130E-03, 2.81494004E-03, 2.91245690E-03,
     &   3.01704315E-03, 3.12949368E-03, 3.25072719E-03, 3.38181122E-03,
     &   3.52399364E-03, 3.67874233E-03, 3.84779593E-03, 4.03322932E-03,
     &   4.23753896E-03, 4.46375575E-03, 4.71559609E-03, 4.99766727E-03,
     &   5.31575148E-03, 5.67720574E-03, 6.09153722E-03, 6.57125051E-03,
     &   7.13312991E-03, 7.80024137E-03, 8.60517398E-03, 9.59551928E-03,
     &   1.08436245E-02, 1.24650891E-02, 1.46567486E-02, 1.77831840E-02,
     &   2.26035379E-02, 3.10017004E-02, 4.92769055E-02, 6.06078441E-02,
     &   1.15438923E-01, 1.60625015E-01, 1.93378048E-01, 2.18720921E-01,
     &   2.39543192E-01, 2.57764967E-01, 2.74672235E-01, 2.86442424E-01,
     &   2.98423569E-01, 3.10206919E-01, 3.15888226E-01, 3.23850464E-01,
     &   3.28621346E-01, 3.34543271E-01, 3.36086554E-01, 3.38369269E-01,
     &   3.39317919E-01, 3.38602954E-01, 3.37512025E-01, 3.35865027E-01,
     &   3.30649289E-01, 3.26991709E-01, 3.22496368E-01, 3.10914068E-01,
     &   3.03723410E-01, 2.95505296E-01, 2.86102570E-01, 2.64055033E-01,
     &   2.51106799E-01, 2.37069749E-01, 2.05162368E-01, 1.87500079E-01/
  
         DATA ((DAS  (I,J), I=1401,1500), J=3,3) /
     &   1.48631559E-01, 1.05841001E-01, 1.13025011E-02, 1.04435581E-01,
     &   1.47335935E-01, 1.86146788E-01, 2.20632852E-01, 2.36136777E-01,
     &   2.50251361E-01, 2.63147906E-01, 2.85473147E-01, 2.94854024E-01,
     &   3.03232113E-01, 3.10486344E-01, 3.22185076E-01, 3.26689929E-01,
     &   3.30438803E-01, 3.35719203E-01, 3.37424281E-01, 3.39165879E-01,
     &   3.39322661E-01, 3.38421451E-01, 3.36191281E-01, 3.32889971E-01,
     &   3.28763696E-01, 3.24010028E-01, 3.16065184E-01, 3.10421352E-01,
     &   2.98614566E-01, 2.86664517E-01, 2.74858647E-01, 2.57940440E-01,
     &   2.39703329E-01, 2.18861302E-01, 1.93493448E-01, 1.60709377E-01,
     &   1.14820561E-01, 6.26682179E-02, 3.58453043E-02, 2.50800407E-02,
     &   1.92841755E-02, 1.56636414E-02, 1.31877178E-02, 1.13878773E-02,
     &   1.00205536E-02, 8.94661569E-03, 8.08081970E-03, 7.36802617E-03,
     &   6.77098983E-03, 6.26364605E-03, 5.82720858E-03, 5.44779495E-03,
     &   5.11492453E-03, 4.82053671E-03, 4.55833058E-03, 4.32330960E-03,
     &   4.11146068E-03, 3.91952358E-03, 3.74482229E-03, 3.58513979E-03,
     &   3.43862365E-03, 3.30371409E-03, 3.17908835E-03, 3.06361736E-03,
     &   2.95633150E-03, 2.85639343E-03, 2.76307628E-03, 2.67574601E-03,
     &   2.59384705E-03, 2.51689053E-03, 2.44444454E-03, 2.37612611E-03,
     &   2.31159445E-03, 2.25054526E-03, 2.19270605E-03, 2.13783204E-03,
     &   2.08570271E-03, 2.03611893E-03, 1.98890035E-03, 1.94388332E-03,
     &   1.90091892E-03, 1.85987140E-03, 1.82061674E-03, 1.78304139E-03,
     &   1.74704120E-03, 1.71252048E-03, 1.67939114E-03, 1.43013915E-03,
     &   1.27810902E-03, 1.13320693E-03, 9.73105789E-04, 8.26446311E-04,
     &   6.89100388E-04, 6.10207152E-04, 5.10368476E-04, 4.77443684E-04,
     &   4.41212860E-04, 4.12911019E-04, 3.89799660E-04, 3.70533060E-04/
  
         DATA ((DAS  (I,J), I=1501,1600), J=3,3) /
     &   3.40234621E-04, 3.17543697E-04, 2.58345493E-04, 2.22259358E-04,
     &   2.16410631E-04, 2.47876281E-04, 3.28395985E-04, 4.51001925E-04,
     &   6.25359336E-04, 8.74898723E-04, 1.51332421E-03, 1.63521032E-03,
     &   1.77889808E-03, 1.82056174E-03, 1.91556447E-03, 2.02117555E-03,
     &   2.13926704E-03, 2.27217902E-03, 2.42287559E-03, 2.59516770E-03,
     &   2.79403887E-03, 3.02613375E-03, 3.30051314E-03, 3.62986204E-03,
     &   4.03250296E-03, 4.53591918E-03, 5.18329760E-03, 6.04661378E-03,
     &   7.25541643E-03, 9.06877878E-03, 1.20910986E-02, 1.81348287E-02,
     &   2.62423283E-02, 2.76031749E-02, 2.91127916E-02, 3.07969682E-02,
     &   3.26878168E-02, 3.48258337E-02, 3.72628248E-02, 4.00661447E-02,
     &   4.33249960E-02, 4.71600558E-02, 5.17386730E-02, 5.72997928E-02,
     &   6.41967117E-02, 7.29745015E-02, 8.45198304E-02, 1.00376056E-01,
     &   1.23481214E-01, 1.60164316E-01, 2.26735389E-01, 3.77337524E-01,
     &   4.30131600E-01, 4.71684547E-01, 5.17998929E-01, 5.56867817E-01,
     &   5.84899266E-01, 6.08673223E-01, 6.19627328E-01, 6.23976432E-01,
     &   6.18506319E-01, 5.99123271E-01, 5.76806615E-01, 5.72583740E-01,
     &   5.70388356E-01, 5.65826649E-01, 5.63937296E-01, 5.62495745E-01,
     &   5.61033022E-01, 5.45213964E-01, 5.17232913E-01, 4.79791915E-01,
     &   4.40122509E-01, 3.89310030E-01, 3.31573603E-01, 2.74097292E-01,
     &   2.40133217E-01, 2.04885961E-01, 1.68514880E-01, 1.16051594E-01,
     &   7.77459537E-02, 3.89892169E-02, 1.56118073E-02, 7.81045879E-03,
     &   3.91062775E-03, 1.85330150E-04, 3.90267329E-03, 7.80249814E-03,
     &   3.89812709E-02, 7.77380600E-02, 1.16043786E-01, 2.87285038E-01,
     &   3.49592213E-01, 4.49428976E-01, 4.87827226E-01, 5.23903119E-01,
     &   5.53393998E-01, 5.74720090E-01, 5.93160200E-01, 6.05525721E-01/
  
         DATA ((DAS  (I,J), I=1601,1700), J=3,3) /
     &   6.15141862E-01, 6.20569409E-01, 6.23535701E-01, 6.23861611E-01,
     &   6.22047343E-01, 6.18784529E-01, 6.07999701E-01, 6.00730827E-01,
     &   5.92671774E-01, 5.84901572E-01, 5.67409610E-01, 5.57836408E-01,
     &   5.42288258E-01, 5.18002505E-01, 4.30136126E-01, 3.62068700E-01,
     &   3.10527988E-01, 2.70933855E-01, 2.39855370E-01, 2.14938049E-01,
     &   1.90058444E-01, 1.51213587E-01, 1.40701711E-01, 1.31540127E-01,
     &   1.23487088E-01, 1.11519357E-01, 9.23054823E-02, 7.87163128E-02,
     &   6.86042109E-02, 6.07889479E-02, 5.45691717E-02, 4.95022722E-02,
     &   4.52952920E-02, 4.17466750E-02, 3.87132332E-02, 3.60904612E-02,
     &   3.38003096E-02, 3.17833166E-02, 2.99933885E-02, 2.83942450E-02,
     &   2.69569405E-02, 1.81407983E-02, 1.20970684E-02, 9.07474750E-03,
     &   6.05257871E-03, 4.54187851E-03, 3.63581408E-03, 3.03207685E-03,
     &   2.60110025E-03, 2.27809939E-03, 2.02708213E-03, 1.82645293E-03,
     &   1.71273476E-03, 1.58016382E-03, 1.46701095E-03, 1.36932359E-03,
     &   1.28415360E-03, 1.20925729E-03, 9.39247955E-04, 7.71700530E-04,
     &   6.58153317E-04, 5.76522334E-04, 5.15304350E-04, 4.67925398E-04,
     &   4.30320172E-04, 3.99888112E-04, 2.22542189E-04, 2.20141943E-04,
     &   2.22290211E-04, 2.25848163E-04, 2.31392576E-04, 2.39954253E-04,
     &   2.45878963E-04, 2.53306873E-04, 2.74999149E-04, 3.13211785E-04,
     &   3.90242709E-04, 5.88778543E-04, 7.90346571E-04, 8.43223186E-04,
     &   9.04491458E-04, 9.76250912E-04, 1.06136735E-03, 1.16385309E-03,
     &   1.28949846E-03, 1.44699397E-03, 1.64999676E-03, 1.92125756E-03,
     &   2.30173851E-03, 2.87336597E-03, 3.82725715E-03, 3.99324425E-03,
     &   4.17432065E-03, 4.37268407E-03, 4.59090564E-03, 4.83209292E-03,
     &   5.10012998E-03, 5.39972508E-03, 5.73675549E-03, 6.11878767E-03/
  
         DATA ((DAS  (I,J), I=1701,1800), J=3,3) /
     &   6.55542103E-03, 7.05919388E-03, 7.64700965E-03, 8.34171684E-03,
     &   9.17527042E-03, 1.01941404E-02, 1.05125173E-02, 1.14676639E-02,
     &   1.31046877E-02, 1.52872051E-02, 1.83417664E-02, 2.29209148E-02,
     &   3.05423120E-02, 4.57364038E-02, 9.06455727E-02, 1.07765756E-01,
     &   1.52001159E-01, 1.85641307E-01, 2.13359413E-01, 2.37552065E-01,
     &   2.59015855E-01, 2.78270953E-01, 2.95470518E-01, 3.11412749E-01,
     &   3.26468271E-01, 3.40227350E-01, 3.52330072E-01, 3.63525229E-01,
     &   3.73618972E-01, 3.82459875E-01, 3.90859422E-01, 3.97739676E-01,
     &   4.03112472E-01, 4.07674125E-01, 4.11185229E-01, 4.13360242E-01,
     &   4.13907444E-01, 4.12982886E-01, 4.10312899E-01, 4.05595121E-01,
     &   3.98502141E-01, 3.90527965E-01, 3.78177552E-01, 3.62466269E-01,
     &   3.43074685E-01, 3.15448665E-01, 2.82180406E-01, 2.37204436E-01,
     &   1.78268238E-01, 2.44249668E-02, 2.05024118E-04, 8.06961732E-02,
     &   1.78265342E-01, 2.37201833E-01, 2.82178109E-01, 3.15446654E-01,
     &   3.43072968E-01, 3.62464802E-01, 3.78176329E-01, 3.90526978E-01,
     &   3.98501343E-01, 4.05594538E-01, 4.10312518E-01, 4.12982694E-01,
     &   4.13907428E-01, 4.13360388E-01, 4.11185550E-01, 4.07674604E-01,
     &   4.03113096E-01, 3.97740432E-01, 3.90860313E-01, 3.82460903E-01,
     &   3.73620121E-01, 3.63526496E-01, 3.52331452E-01, 3.40228837E-01,
     &   3.26469865E-01, 3.11414446E-01, 2.95472309E-01, 2.78272835E-01,
     &   2.59017826E-01, 2.37554121E-01, 2.13361551E-01, 1.85643523E-01,
     &   1.52003452E-01, 1.07768122E-01, 9.22781833E-02, 8.93729078E-02,
     &   8.57692055E-02, 7.58160249E-02, 6.68458810E-02, 4.57363487E-02,
     &   3.05447432E-02, 2.29227244E-02, 1.83438015E-02, 1.52896407E-02,
     &   1.31071238E-02, 1.14699442E-02, 1.01965772E-02, 9.17770754E-03/
  
         DATA ((DAS  (I,J), I=1801,1900), J=3,3) /
     &   8.34407157E-03, 7.64944733E-03, 7.06163185E-03, 6.55780825E-03,
     &   6.12122623E-03, 5.73919437E-03, 3.82969912E-03, 2.87581217E-03,
     &   2.30419010E-03, 1.92371573E-03, 1.65246269E-03, 1.44946885E-03,
     &   1.29198347E-03, 1.06387612E-03, 9.07028666E-04, 8.45776350E-04,
     &   7.92916843E-04, 6.05506119E-04, 4.73158000E-04, 3.97945969E-04,
     &   3.50699156E-04, 3.19032469E-04, 2.96825392E-04, 2.80732914E-04,
     &   2.68781897E-04, 2.59746653E-04, 2.52843229E-04, 2.47547313E-04,
     &   2.43492134E-04, 2.40422014E-04, 2.38156625E-04, 2.36568477E-04,
     &   2.35568395E-04, 2.35096026E-04, 2.35113683E-04, 2.35602734E-04,
     &   2.36560378E-04, 2.37995344E-04, 2.44345731E-04, 3.62822790E-04,
     &   3.90764494E-04, 4.44917392E-04, 4.89967914E-04, 5.28081479E-04,
     &   5.60627074E-04, 5.88569320E-04, 6.12468056E-04, 6.32637699E-04,
     &   6.49602731E-04, 6.63614414E-04, 6.74752312E-04, 6.83180562E-04,
     &   6.89080382E-04, 6.92575303E-04, 6.93655190E-04, 6.92415673E-04,
     &   6.88891858E-04, 6.82981578E-04, 6.74815801E-04, 6.64557022E-04,
     &   6.51538086E-04, 6.36600092E-04, 6.18816864E-04, 5.98512023E-04,
     &   5.75194644E-04, 5.48785626E-04, 5.19272116E-04, 4.86730026E-04,
     &   4.48845646E-04, 4.06383290E-04, 3.58941477E-04, 3.03329639E-04,
     &   2.40103869E-04, 2.05404376E-04, 3.42008512E-04, 4.09633105E-04,
     &   4.60869070E-04, 5.01425730E-04, 5.35905299E-04, 5.65397762E-04,
     &   5.89807821E-04, 6.11181504E-04, 6.29630627E-04, 6.45305216E-04,
     &   6.58380782E-04, 6.69264057E-04, 6.77840005E-04, 6.84683709E-04,
     &   6.89395644E-04, 6.92335445E-04, 6.93422009E-04, 6.92657307E-04,
     &   6.90091566E-04, 6.85618437E-04, 6.79208343E-04, 6.70907879E-04,
     &   6.60562044E-04, 6.47308126E-04, 6.32434284E-04, 6.15793254E-04/
  
         DATA ((DAS  (I,J), I=1901,2000), J=3,3) /
     &   5.95534547E-04, 5.72201186E-04, 5.45320655E-04, 5.14318825E-04,
     &   4.78210798E-04, 4.35574683E-04, 3.84096916E-04, 3.19271228E-04,
     &   2.34149379E-04, 2.29586836E-04, 2.21603376E-04, 2.19433987E-04,
     &   2.19362227E-04, 2.20184783E-04, 2.21398550E-04, 2.22758721E-04,
     &   2.24129596E-04, 2.25436511E-04, 2.26628211E-04, 2.27677507E-04,
     &   2.28559739E-04, 2.29261384E-04, 2.29773190E-04, 2.30086331E-04,
     &   2.30193928E-04, 2.30090908E-04, 2.29771748E-04, 2.29233249E-04,
     &   2.28464800E-04, 2.27468566E-04, 2.26233769E-04, 2.24755330E-04,
     &   2.23028671E-04, 2.21040196E-04, 2.18782797E-04, 2.16250911E-04,
     &   2.13428523E-04, 2.10285535E-04, 2.06839372E-04, 2.03029220E-04,
     &   1.98858761E-04, 1.94279643E-04, 1.89238662E-04, 1.83675870E-04,
     &   1.77085251E-04, 1.80941891E-04, 1.85000151E-04, 1.88876138E-04,
     &   1.92546251E-04, 1.96011060E-04, 1.99289441E-04, 2.02366378E-04,
     &   2.05251296E-04, 2.07965623E-04, 2.10492123E-04, 2.12848671E-04,
     &   2.15040308E-04, 2.17061771E-04, 2.18932555E-04, 2.20658101E-04,
     &   2.22217058E-04, 2.23635971E-04, 2.24918886E-04, 2.26051005E-04,
     &   2.27051108E-04, 2.27913276E-04, 2.28650144E-04, 2.29254302E-04,
     &   2.29735957E-04, 2.30094343E-04, 2.30336684E-04, 2.30465510E-04,
     &   2.30486123E-04, 2.30404216E-04, 2.30226808E-04, 2.29962373E-04,
     &   2.29620457E-04, 2.29214140E-04, 2.28755612E-04, 2.28261471E-04,
     &   2.25043114E-04, 2.24745127E-04, 2.24423579E-04, 2.24074695E-04,
     &   2.23697236E-04, 2.23290494E-04, 2.22854328E-04, 2.22384858E-04,
     &   2.21877105E-04, 2.21335156E-04, 2.20754043E-04, 2.20133499E-04,
     &   2.19473670E-04, 2.18775137E-04, 2.18031218E-04, 2.17241778E-04,
     &   2.16415892E-04, 2.15537272E-04, 2.14605506E-04, 2.13631126E-04/
  
         DATA ((DAS  (I,J), I=2001,2100), J=3,3) /
     &   2.12594539E-04, 2.11518478E-04, 2.10382652E-04, 2.09188579E-04,
     &   2.07895348E-04, 2.06580050E-04, 2.05217802E-04, 2.03774732E-04,
     &   2.02258914E-04, 2.00668786E-04, 1.99008462E-04, 1.97250887E-04,
     &   1.95389376E-04, 1.93396984E-04, 1.91222509E-04, 1.88258054E-04,
     &   1.88821797E-04, 1.90031940E-04, 1.91298689E-04, 1.92560583E-04,
     &   1.93797775E-04, 1.94994831E-04, 1.96159245E-04, 1.97280138E-04,
     &   1.98352952E-04, 1.99367451E-04, 2.00345662E-04, 2.01271650E-04,
     &   2.02150229E-04, 2.02977757E-04, 2.03751653E-04, 2.04485022E-04,
     &   2.05160660E-04, 2.05785024E-04, 2.06368756E-04, 2.06892998E-04,
     &   2.07373490E-04, 2.07803722E-04, 2.08183320E-04, 2.08515288E-04,
     &   2.08798505E-04, 2.09032297E-04, 2.09216423E-04, 2.09352038E-04,
     &   2.09437839E-04, 2.09474938E-04, 2.09463191E-04, 2.09402076E-04,
     &   2.09291661E-04, 2.09132230E-04, 2.08923091E-04, 2.07358812E-04,
     &   2.00888081E-04, 1.95905162E-04, 1.93622417E-04, 1.93396108E-04,
     &   1.94860439E-04, 1.97902972E-04, 2.02151076E-04, 2.07972396E-04,
     &   2.15265581E-04, 2.23747269E-04, 2.34409842E-04, 2.46644091E-04,
     &   2.68151025E-04, 2.89657959E-04, 2.79393348E-04, 2.70265935E-04,
     &   2.62724440E-04, 2.55825565E-04, 2.49992151E-04, 2.44552857E-04,
     &   2.39878540E-04, 2.35459288E-04, 2.31448855E-04, 2.27942993E-04,
     &   2.24578227E-04, 2.21612171E-04, 2.18744103E-04, 2.16198670E-04,
     &   2.13722103E-04, 2.11511672E-04, 2.09349858E-04, 2.07411082E-04,
     &   2.05506520E-04, 2.03791385E-04, 2.02171521E-04, 2.00571389E-04,
     &   1.99122889E-04, 1.97687480E-04, 1.96384192E-04, 1.95089028E-04,
     &   1.93909924E-04, 1.92735194E-04, 1.91663151E-04, 1.90592636E-04,
     &   1.89613563E-04, 1.88633849E-04, 1.87696100E-04, 1.86835926E-04/
  
         DATA ((DAS  (I,J), I=2101,2180), J=3,3) /
     &   1.85972766E-04, 1.85179627E-04, 1.84382403E-04, 1.83648673E-04,
     &   1.82910022E-04, 1.82229188E-04, 1.81542805E-04, 1.80909272E-04,
     &   1.80269725E-04, 1.79678661E-04, 1.79106798E-04, 1.78528454E-04,
     &   1.77993011E-04, 1.77450890E-04, 1.76948436E-04, 1.76439322E-04,
     &   1.75966833E-04, 1.75487470E-04, 1.75042295E-04, 1.74590221E-04,
     &   1.74170007E-04, 1.73742902E-04, 1.73327748E-04, 1.72941357E-04,
     &   1.72548141E-04, 1.72167110E-04, 1.71794023E-04, 1.71446252E-04,
     &   1.71091809E-04, 1.70761181E-04, 1.70423963E-04, 1.70109201E-04,
     &   1.69787963E-04, 1.69487912E-04, 1.69181494E-04, 1.68895107E-04,
     &   1.68615051E-04, 1.68328798E-04, 1.68061027E-04, 1.67787177E-04,
     &   1.67530867E-04, 1.67268597E-04, 1.67022996E-04, 1.66771502E-04,
     &   1.66535947E-04, 1.66294672E-04, 1.66068508E-04, 1.65836743E-04,
     &   1.63588072E-04, 1.61738189E-04, 1.61471844E-04, 1.53651425E-04,
     &   1.51566046E-04, 1.47924247E-04, 1.46569645E-04, 1.46505140E-04,
     &   1.45164543E-04, 1.45160937E-04, 1.44399342E-04, 1.44373586E-04,
     &   1.44358324E-04, 1.44044045E-04, 1.43853089E-04, 1.43820309E-04,
     &   1.43767645E-04, 1.43691608E-04, 1.43639363E-04, 1.43607125E-04,
     &   1.43314667E-04, 1.43301944E-04, 1.43224217E-04, 1.43210061E-04,
     &   1.43163938E-04, 1.43122599E-04, 1.43107851E-04, 1.43090331E-04,
     &   1.43035816E-04, 1.42965255E-04, 1.42936104E-04, 1.42755139E-04/


c      ++++ deghadslow23 ++++  

c update 09/24/25 
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Wed Sep 24 16:27:59 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN:  1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
         DATA ((DGS  (I,J), I=   1, 100), J=1,1) /
     &  -1.90879706E-03,-2.03580432E-03,-2.15932505E-03,-2.28840054E-03,
     &  -2.42144103E-03,-2.48715174E-03,-2.58682828E-03,-2.77940188E-03,
     &  -2.86115540E-03,-2.93706033E-03,-3.05580828E-03,-3.16601876E-03,
     &  -3.29289504E-03,-3.38030001E-03,-3.48648402E-03,-3.59420843E-03,
     &  -3.70255612E-03,-3.81138856E-03,-3.89985158E-03,-4.01696817E-03,
     &  -4.10823557E-03,-4.22328524E-03,-4.31589126E-03,-4.43495070E-03,
     &  -4.53316693E-03,-4.63132986E-03,-4.75475544E-03,-4.81896019E-03,
     &  -4.85200461E-03,-4.95312669E-03,-5.05922517E-03,-5.16669682E-03,
     &  -5.27200378E-03,-5.38161008E-03,-5.49536834E-03,-5.61534542E-03,
     &  -5.73406658E-03,-5.85760818E-03,-5.98439491E-03,-6.11751029E-03,
     &  -6.21735419E-03,-6.35093889E-03,-6.48661356E-03,-6.58672201E-03,
     &  -6.72594773E-03,-6.86744095E-03,-6.97869329E-03,-7.13356116E-03,
     &  -7.24714883E-03,-7.41170370E-03,-8.30643161E-03,-9.25218884E-03,
     &  -1.06093197E-02,-1.23456316E-02,-1.29353027E-02,-1.30797426E-02,
     &  -1.35358515E-02,-1.41578613E-02,-1.48009333E-02,-1.54580586E-02,
     &  -1.61066286E-02,-1.63350581E-02,-1.67263862E-02,-1.73902744E-02,
     &  -1.78819347E-02,-1.83963161E-02,-1.87871361E-02,-1.90556149E-02,
     &  -1.90558796E-02,-1.90597041E-02,-1.90289312E-02,-1.88643761E-02,
     &  -1.83913913E-02,-1.74956935E-02,-1.62519319E-02,-1.43807162E-02,
     &  -1.20070371E-02,-9.06020964E-03,-6.07198212E-03,-4.99280731E-03,
     &  -2.08705653E-03,-6.79742705E-04, 8.22677737E-04, 1.99636304E-03,
     &   3.81496196E-03, 5.82761503E-03, 7.00188355E-03, 7.81327162E-03,
     &   8.41098794E-03, 8.91837944E-03, 9.31942066E-03, 9.66814562E-03,
     &   9.96947676E-03, 1.02582211E-02, 1.05385245E-02, 1.09520067E-02,
     &   1.11109296E-02, 1.12722363E-02, 1.14963175E-02, 1.16621649E-02/
  
         DATA ((DGS  (I,J), I= 101, 200), J=1,1) /
     &   1.18097225E-02, 1.19281964E-02, 1.20343335E-02, 1.21268777E-02,
     &   1.22133160E-02, 1.22726744E-02, 1.23308515E-02, 1.23878474E-02,
     &   1.24325829E-02, 1.24726084E-02, 1.25030517E-02, 1.25163412E-02,
     &   1.25300376E-02, 1.25444797E-02, 1.25495461E-02, 1.25439928E-02,
     &   1.25318752E-02, 1.25235455E-02, 1.25912192E-02, 1.26762624E-02,
     &   1.27664992E-02, 1.28681614E-02, 1.29919905E-02, 1.31238611E-02,
     &   1.32703275E-02, 1.34285145E-02, 1.35983420E-02, 1.37789395E-02,
     &   1.39757353E-02, 1.41793601E-02, 1.43857351E-02, 1.46000368E-02,
     &   1.48169247E-02, 1.50157892E-02, 1.52504613E-02, 1.54294220E-02,
     &   1.55814176E-02, 1.56542030E-02, 1.56134716E-02, 1.56701197E-02,
     &   1.58033489E-02, 1.59881238E-02, 1.61818803E-02, 1.63322710E-02,
     &   1.64953748E-02, 1.66668886E-02, 1.68208234E-02, 1.69987634E-02,
     &   1.71891125E-02, 1.73999047E-02, 1.76974491E-02, 1.81894315E-02,
     &   1.83332910E-02, 1.87659640E-02, 1.91986370E-02, 1.95903506E-02,
     &   1.98877276E-02, 2.01615662E-02, 2.03423735E-02, 2.04651989E-02,
     &   2.06330658E-02, 2.08535644E-02, 2.09307060E-02, 2.09516653E-02,
     &   2.09502683E-02, 2.09280769E-02, 2.08729499E-02, 2.08459879E-02,
     &   2.05996778E-02, 2.02378601E-02, 1.97834255E-02, 1.93419775E-02,
     &   1.87653692E-02, 1.81194045E-02, 1.74151070E-02, 1.68020109E-02,
     &   1.60523060E-02, 1.52178202E-02, 1.45334406E-02, 1.41243758E-02,
     &   1.33614574E-02, 1.29999263E-02, 1.21340931E-02, 1.13764815E-02,
     &   1.04133985E-02, 9.56616034E-03, 8.48092354E-03, 7.50721271E-03,
     &   6.46165189E-03, 5.08646010E-03, 4.33759127E-03, 3.82394454E-03,
     &   2.71969729E-03, 2.12771972E-03, 1.48037664E-03, 8.02910235E-04,
     &   7.06131009E-05,-7.04858806E-04,-1.50485351E-03,-3.23343838E-03/
  
         DATA ((DGS  (I,J), I= 201, 300), J=1,1) /
     &  -5.25407592E-03,-6.41847666E-03,-6.85545945E-03,-7.30913469E-03,
     &  -7.78365469E-03,-8.27404952E-03,-8.78307751E-03,-9.31242196E-03,
     &  -9.86362219E-03,-1.04520022E-02,-1.10502558E-02,-1.16765636E-02,
     &  -1.23373742E-02,-1.30282147E-02,-1.37482697E-02,-1.45040418E-02,
     &  -1.52988850E-02,-1.61349968E-02,-1.70171930E-02,-1.79464644E-02,
     &  -1.89312146E-02,-1.99758819E-02,-2.11050072E-02,-2.22982387E-02,
     &  -2.35877597E-02,-2.49891752E-02,-2.65381280E-02,-2.83046998E-02,
     &  -3.03394303E-02,-3.31884771E-02,-3.56570657E-02,-3.55609028E-02,
     &  -3.53073824E-02,-3.53271533E-02,-3.64500409E-02,-3.84440651E-02,
     &  -3.99366985E-02,-4.25637185E-02,-4.57995252E-02,-4.82092929E-02,
     &  -5.11990512E-02,-5.43827847E-02,-5.77388082E-02,-6.20093949E-02,
     &  -6.62799816E-02,-7.17246321E-02,-7.91853640E-02,-8.73127549E-02,
     &  -9.48796492E-02,-1.02747976E-01,-1.13092003E-01,-1.24334510E-01,
     &  -1.35374393E-01,-1.50499910E-01,-1.56438509E-01,-1.63519128E-01,
     &  -1.68973221E-01,-1.74347874E-01,-1.79768506E-01,-1.85421316E-01,
     &  -1.87823935E-01,-1.89848991E-01,-1.83407535E-01,-1.79469362E-01,
     &  -1.94565802E-01,-1.93272305E-01,-1.49005202E-01,-1.69522901E-01,
     &  -1.62044727E-01,-1.42750061E-01,-1.20456156E-01,-9.44329065E-02,
     &  -5.89212419E-02,-2.59683336E-02, 8.55213512E-03, 4.50721988E-02,
     &   8.26855968E-02, 1.14669038E-01, 1.38746029E-01, 1.57816582E-01,
     &   1.74750635E-01, 1.86539452E-01, 1.94173707E-01, 1.98919679E-01,
     &   2.02003358E-01, 2.02996529E-01, 2.00352518E-01, 1.96407809E-01,
     &   1.94348121E-01, 1.90980228E-01, 1.85730973E-01, 1.77302635E-01,
     &   1.74068641E-01, 1.71600658E-01, 1.66591048E-01, 1.62140305E-01,
     &   1.58676674E-01, 1.54263724E-01, 1.50375444E-01, 1.47574041E-01/
  
         DATA ((DGS  (I,J), I= 301, 400), J=1,1) /
     &   1.50277699E-01, 1.42961966E-01, 1.40331992E-01, 1.37499511E-01,
     &   1.28450452E-01, 1.21749393E-01, 1.14775204E-01, 1.06981695E-01,
     &   9.89087190E-02, 9.33315791E-02, 8.88818858E-02, 8.51299644E-02,
     &   8.16912499E-02, 7.85510082E-02, 7.56128532E-02, 7.24553408E-02,
     &   6.91839594E-02, 6.61841515E-02, 6.36714168E-02, 6.14596122E-02,
     &   5.93786090E-02, 5.74649623E-02, 5.53673737E-02, 5.33243395E-02,
     &   5.04941132E-02, 4.61636284E-02, 4.74891960E-02, 4.97965623E-02,
     &   4.86344650E-02, 4.77547987E-02, 4.68598734E-02, 4.60468062E-02,
     &   4.52296544E-02, 4.44200731E-02, 4.36527612E-02, 4.29170218E-02,
     &   4.22023111E-02, 4.15353713E-02, 4.08917565E-02, 4.02699156E-02,
     &   3.96734203E-02, 3.91001853E-02, 3.85578734E-02, 3.79659377E-02,
     &   3.74785117E-02, 3.69514463E-02, 3.64952901E-02, 3.60409389E-02,
     &   3.56769839E-02, 3.51777107E-02, 3.45687741E-02, 3.43081040E-02,
     &   3.38994411E-02, 3.35051411E-02, 3.31242100E-02, 3.27483596E-02,
     &   3.17215188E-02, 2.94955105E-02, 2.60096138E-02, 2.34548248E-02,
     &   2.15123126E-02, 1.99792031E-02, 1.86880902E-02, 1.75920496E-02,
     &   1.66578910E-02, 1.65713652E-02, 1.55000183E-02, 1.47775979E-02,
     &   1.45322553E-02, 1.39478153E-02, 1.33939675E-02, 1.33408166E-02,
     &   1.28749172E-02, 1.23849315E-02, 1.21522570E-02, 1.19261096E-02,
     &   1.15086441E-02, 1.11376813E-02, 1.08000881E-02, 1.04899003E-02,
     &   1.03076254E-02, 1.01838785E-02, 9.88909347E-03, 9.60563374E-03,
     &   9.57818801E-03, 9.35058715E-03, 9.12296865E-03, 9.01667328E-03,
     &   8.90769415E-03, 8.69496305E-03, 8.47460639E-03, 8.25575902E-03,
     &   8.19597307E-03, 8.05434154E-03, 7.96160445E-03, 7.89007335E-03,
     &   7.74791929E-03, 7.60981427E-03, 7.59527621E-03, 7.49227401E-03/
  
         DATA ((DGS  (I,J), I= 401, 500), J=1,1) /
     &   7.26915953E-03, 7.20571504E-03, 7.20831671E-03, 7.22342844E-03,
     &   7.22909534E-03, 7.28318169E-03, 7.30877610E-03, 7.32360630E-03,
     &   7.35047572E-03, 7.40713259E-03, 7.50041860E-03, 7.61173952E-03,
     &   7.62501038E-03, 7.75177838E-03, 7.76479124E-03, 7.83242509E-03,
     &   7.88330117E-03, 8.02914743E-03, 8.04858465E-03, 8.15613469E-03,
     &   8.16295988E-03, 8.17031388E-03, 8.23415486E-03, 8.29466578E-03,
     &   8.30725346E-03, 8.39659437E-03, 8.40497961E-03, 8.45403547E-03,
     &   8.46475050E-03, 8.53213703E-03, 8.56653471E-03, 8.68244098E-03,
     &   8.69407942E-03, 8.82487115E-03, 8.92746820E-03, 8.98540951E-03,
     &   8.99718580E-03, 9.14202266E-03, 9.16879832E-03, 9.32880897E-03,
     &   9.47468862E-03, 9.54119237E-03, 9.58777491E-03, 9.61167688E-03,
     &   9.85381008E-03, 9.90280151E-03, 1.00376049E-02, 1.01634200E-02,
     &   1.02198583E-02, 1.03892913E-02, 1.05383733E-02, 1.05716732E-02,
     &   1.05877826E-02, 1.06873085E-02, 1.07352264E-02, 1.07848985E-02,
     &   1.09810619E-02, 1.10056010E-02, 1.10581933E-02, 1.10823783E-02,
     &   1.11014272E-02, 1.11004355E-02, 1.10978350E-02, 1.10919520E-02,
     &   1.10849889E-02, 1.10583592E-02, 1.10121352E-02, 1.09516332E-02,
     &   1.08426792E-02, 1.07246729E-02, 1.07116311E-02, 1.05376529E-02,
     &   1.04163766E-02, 1.03064241E-02, 1.02882043E-02, 1.01300372E-02,
     &   1.01033257E-02, 1.00213417E-02, 9.79391434E-03, 9.78702166E-03,
     &   9.80081858E-03, 9.86285824E-03, 9.83221252E-03, 9.79317805E-03,
     &   9.66412318E-03, 9.48949850E-03, 9.42174343E-03, 9.35741892E-03,
     &   9.25453269E-03, 9.23028483E-03, 9.16338500E-03, 9.15104633E-03,
     &   9.10227432E-03, 9.04930009E-03, 9.00063181E-03, 8.98466378E-03,
     &   8.83042358E-03, 8.53718517E-03, 8.51444898E-03, 9.24295440E-03/
  
         DATA ((DGS  (I,J), I= 501, 600), J=1,1) /
     &   9.71614499E-03, 9.93631118E-03, 1.02434892E-02, 1.02534660E-02,
     &   1.03531586E-02, 1.04289674E-02, 1.04338405E-02, 1.03550926E-02,
     &   1.02061301E-02, 1.00043605E-02, 9.76547847E-03, 9.44698488E-03,
     &   9.03012572E-03, 8.45843245E-03, 7.64592607E-03, 6.46357581E-03,
     &   4.64914672E-03, 4.17259474E-03, 3.64224748E-03, 3.04870273E-03,
     &   2.38140876E-03, 1.62106619E-03, 7.51264942E-04,-2.55244818E-04,
     &  -4.75963960E-04,-7.03924606E-04,-9.37628246E-04,-1.18081995E-03,
     &  -1.43214586E-03,-1.69203735E-03,-1.96147757E-03,-2.24001285E-03,
     &  -2.52918513E-03,-2.82903811E-03,-4.31393707E-03,-5.47884552E-03,
     &  -6.12091296E-03,-6.57226056E-03,-7.04392274E-03,-7.53815595E-03,
     &  -8.05688624E-03,-8.60271310E-03,-9.17595089E-03,-9.47384314E-03,
     &  -9.77940987E-03,-1.00933080E-02,-1.04159099E-02,-1.07475804E-02,
     &  -1.10884614E-02,-1.14389824E-02,-1.17997705E-02,-1.21711468E-02,
     &  -1.25534603E-02,-1.29473666E-02,-1.33534009E-02,-1.37723354E-02,
     &  -1.42046541E-02,-1.46508211E-02,-1.51114230E-02,-1.55874870E-02,
     &  -1.60794701E-02,-1.65883728E-02,-1.71152587E-02,-1.76611879E-02,
     &  -1.82269826E-02,-1.88137485E-02,-1.94226727E-02,-2.00550870E-02,
     &  -2.07123646E-02,-2.13962697E-02,-2.21073732E-02,-2.28487766E-02,
     &  -2.36218213E-02,-2.44285839E-02,-2.52711778E-02,-2.61525006E-02,
     &  -2.70744461E-02,-2.80400943E-02,-2.90530717E-02,-3.01165116E-02,
     &  -3.12345268E-02,-3.24114748E-02,-3.36521777E-02,-3.42980633E-02,
     &  -3.49619603E-02,-3.56444979E-02,-3.63465490E-02,-3.70689916E-02,
     &  -3.78127570E-02,-3.85789578E-02,-3.93682976E-02,-4.01818661E-02,
     &  -4.10212157E-02,-4.18870941E-02,-4.27811417E-02,-4.37040787E-02,
     &  -4.46602199E-02,-4.56468144E-02,-4.66675279E-02,-4.77241321E-02/
  
         DATA ((DGS  (I,J), I= 601, 700), J=1,1) /
     &  -4.88184374E-02,-4.99527350E-02,-5.11270458E-02,-5.23480806E-02,
     &  -5.36160470E-02,-5.49338414E-02,-5.63046168E-02,-5.77314556E-02,
     &  -5.92181920E-02,-6.07681317E-02,-6.23856850E-02,-6.40755328E-02,
     &  -6.58422267E-02,-6.76918420E-02,-6.96299327E-02,-7.16630198E-02,
     &  -7.37981238E-02,-7.60434129E-02,-7.84073675E-02,-8.08996969E-02,
     &  -8.35324973E-02,-8.74738910E-02,-8.92628760E-02,-9.23901537E-02,
     &  -9.57141521E-02,-9.92540469E-02,-1.03031594E-01,-1.07071475E-01,
     &  -1.11402112E-01,-1.16056144E-01,-1.21071233E-01,-1.26491161E-01,
     &  -1.32366910E-01,-1.38758915E-01,-1.43862860E-01,-1.59769024E-01,
     &  -1.79263785E-01,-2.03720441E-01,-2.35321253E-01,-2.77768572E-01,
     &  -3.37968259E-01,-4.33839411E-01,-5.81777250E-01,-8.92515718E-01,
     &  -1.88922723E+00,-1.99841005E+00,-2.12086520E+00,-2.25936987E+00,
     &  -2.41649116E+00,-2.59715653E+00,-2.80668978E+00,-3.05255711E+00,
     &  -3.34501875E+00,-3.69855112E+00,-4.13422798E+00,-4.68413144E+00,
     &  -5.37561468E+00,-6.35936692E+00,-6.47401466E+00,-9.04115675E+00,
     &  -1.09121903E+01,-1.24155289E+01,-7.74187960E+00,-1.47342815E+01,
     &  -1.50541123E+01,-1.63090347E+01,-1.70163530E+01,-1.75075380E+01,
     &  -1.79610608E+01,-1.82761627E+01,-1.85297553E+01,-1.86681886E+01,
     &  -1.87667594E+01,-1.87722064E+01,-1.87150241E+01,-1.85656126E+01,
     &  -1.84057750E+01,-1.80600824E+01,-1.77490086E+01,-1.73650920E+01,
     &  -1.65669936E+01,-1.57857749E+01,-1.49270344E+01,-1.39957522E+01,
     &  -1.41222975E+01,-1.31759976E+01,-1.21266604E+01,-1.09767654E+01,
     &  -9.07453808E+00,-7.69936396E+00,-5.55698594E+00,-3.18215099E+00,
     &   3.21008622E+00, 9.09632855E+00, 1.09958432E+01, 1.26809859E+01,
     &   1.36780228E+01, 1.49808667E+01, 1.49773550E+01, 1.58261031E+01/
  
         DATA ((DGS  (I,J), I= 701, 800), J=1,1) /
     &   1.65958603E+01, 1.72825231E+01, 1.77725248E+01, 1.81441504E+01,
     &   1.83337881E+01, 1.85224108E+01, 1.86582617E+01, 1.87471489E+01,
     &   1.88037429E+01, 1.45769806E+01, 1.54229422E+01, 1.86048127E+01,
     &   1.84942835E+01, 1.82204143E+01, 1.79786065E+01, 1.76218971E+01,
     &   1.72395929E+01, 1.67428853E+01, 1.63417162E+01, 1.51520213E+01,
     &   1.48522129E+01, 1.40147871E+01, 1.30710822E+01, 1.18573263E+01,
     &   1.03585120E+01, 8.72835345E+00, 7.19455582E+00, 6.00314615E+00,
     &   5.14345985E+00, 4.49616050E+00, 3.99214677E+00, 3.58903193E+00,
     &   3.25950459E+00, 2.98530913E+00, 2.75345273E+00, 2.55505753E+00,
     &   2.38334170E+00, 2.23328447E+00, 2.10104183E+00, 1.98362806E+00,
     &   1.87868761E+00, 1.78433743E+00, 1.69905496E+00, 1.62159525E+00,
     &   8.56383013E-01, 5.84703252E-01, 4.45828470E-01, 3.63623875E-01,
     &   3.03434116E-01, 2.62006373E-01, 2.31050032E-01, 2.06983139E-01,
     &   1.87722087E-01, 1.71952660E-01, 1.70086170E-01, 1.57075699E-01,
     &   1.46061119E-01, 1.36615387E-01, 1.28425164E-01, 1.21255501E-01,
     &   1.14926667E-01, 1.09298943E-01, 1.04261446E-01, 9.97259998E-02,
     &   9.56212204E-02, 9.18869741E-02, 8.84777671E-02, 8.53520099E-02,
     &   8.24756451E-02, 7.98198897E-02, 7.73603824E-02, 7.50758523E-02,
     &   7.29486090E-02, 7.09625380E-02, 6.91040349E-02, 6.73613331E-02,
     &   6.57250740E-02, 6.41838904E-02, 6.27303682E-02, 6.13573542E-02,
     &   6.00582312E-02, 5.88273958E-02, 5.76594702E-02, 5.65498416E-02,
     &   5.54941890E-02, 5.44886607E-02, 5.35297005E-02, 5.26140919E-02,
     &   5.17390688E-02, 5.09019677E-02, 5.01003967E-02, 4.93320836E-02,
     &   4.85949021E-02, 4.78873135E-02, 4.72075040E-02, 4.65536583E-02,
     &   4.59243063E-02, 4.53182249E-02, 4.47328344E-02, 4.41696397E-02/
  
         DATA ((DGS  (I,J), I= 801, 900), J=1,1) /
     &   4.36262504E-02, 4.31016678E-02, 4.25948833E-02, 4.21049991E-02,
     &   4.16310331E-02, 4.11722801E-02, 4.07281052E-02, 4.02978362E-02,
     &   3.98808220E-02, 3.94760976E-02, 3.90838348E-02, 3.87032221E-02,
     &   3.83337366E-02, 3.79748383E-02, 3.76262586E-02, 3.72873991E-02,
     &   3.69580173E-02, 3.66377528E-02, 3.63263328E-02, 3.60233833E-02,
     &   3.57286063E-02, 3.54416735E-02, 3.51625056E-02, 3.48908769E-02,
     &   3.46262903E-02, 3.43689252E-02, 3.41185308E-02, 3.38749724E-02,
     &   3.36381802E-02, 3.34081167E-02, 3.31848181E-02, 3.29683607E-02,
     &   3.27588936E-02, 3.25565906E-02, 3.23618835E-02, 3.21755885E-02,
     &   3.19985274E-02, 3.14476695E-02, 3.12482267E-02, 3.10541641E-02,
     &   3.08627145E-02, 3.06748297E-02, 3.04887889E-02, 3.03078946E-02,
     &   3.01297779E-02, 2.99549838E-02, 2.98016361E-02, 2.96114177E-02,
     &   2.94441326E-02, 2.92834577E-02, 2.91249789E-02, 2.89712123E-02,
     &   2.88198733E-02, 2.86712296E-02, 2.85251056E-02, 2.83822081E-02,
     &   2.82412320E-02, 2.39691855E-02, 2.10293466E-02, 1.84482566E-02,
     &   1.75809945E-02, 1.61355576E-02, 1.45880190E-02, 1.38626857E-02,
     &   1.30272860E-02, 1.29179711E-02, 1.23591562E-02, 1.20243732E-02,
     &   1.19624443E-02, 1.10936829E-02, 9.92683516E-03, 8.85623107E-03,
     &   5.41429848E-03, 7.80373533E-03, 7.79161919E-03, 7.06867296E-03,
     &   6.23675152E-03, 5.28793250E-03, 4.18883518E-03, 2.89305714E-03,
     &   1.33475627E-03,-5.81558848E-04,-3.00445469E-03,-4.16571297E-03,
     &  -5.46758334E-03,-6.93813906E-03,-8.61342575E-03,-1.05405172E-02,
     &  -1.27821818E-02,-1.40469785E-02,-1.54252083E-02,-1.69330857E-02,
     &  -1.85897541E-02,-2.04187143E-02,-2.24484326E-02,-2.47145237E-02,
     &  -2.72607961E-02,-3.01423517E-02,-3.34322062E-02,-3.72231630E-02/
  
         DATA ((DGS  (I,J), I= 901,1000), J=1,1) /
     &  -4.16398631E-02,-4.66249549E-02,-4.98887772E-02,-5.35107266E-02,
     &  -5.75534570E-02,-6.20951780E-02,-6.72348135E-02,-7.30993657E-02,
     &  -7.98546706E-02,-8.77215289E-02,-9.70006455E-02,-1.08112592E-01,
     &  -1.21664623E-01,-1.38568378E-01,-1.60260730E-01,-1.89155048E-01,
     &  -2.29677594E-01,-2.91131643E-01,-3.99833632E-01,-5.92099764E-01,
     &  -8.67389131E-01,-1.02703415E+00,-1.20176986E+00,-1.63272813E+00,
     &  -1.78850047E+00,-1.83820262E+00,-2.02500730E+00,-2.09671062E+00,
     &  -2.19252008E+00,-2.25725291E+00,-2.27181333E+00,-2.31391929E+00,
     &  -2.38084553E+00,-2.40380389E+00,-2.41738488E+00,-2.42222265E+00,
     &  -2.41861143E+00,-2.40896734E+00,-2.38950319E+00,-2.36411608E+00,
     &  -2.33299658E+00,-2.29036708E+00,-2.24000133E+00,-2.17544495E+00,
     &  -2.11008228E+00,-2.03501142E+00,-1.94970960E+00,-1.83674182E+00,
     &  -1.72807917E+00,-1.58734634E+00,-1.45484096E+00,-1.26165800E+00,
     &  -1.05083312E+00,-7.35961158E-01,-4.61501224E-01,-1.45363647E-01,
     &   1.47667585E-02, 1.74899110E-01, 3.33998477E-01, 7.65538256E-01,
     &   1.08045630E+00, 1.29132271E+00, 1.48455253E+00, 1.61709574E+00,
     &   1.75787474E+00, 1.86657815E+00, 1.97959417E+00, 2.06493744E+00,
     &   2.14004948E+00, 2.20545837E+00, 2.27006044E+00, 2.32041151E+00,
     &   2.36308396E+00, 2.39429589E+00, 2.41972152E+00, 2.43922733E+00,
     &   2.44890586E+00, 2.45255875E+00, 2.44775984E+00, 2.43421898E+00,
     &   2.41130129E+00, 2.34411785E+00, 2.30206680E+00, 2.28782643E+00,
     &   2.22313334E+00, 2.12715030E+00, 2.05570405E+00, 1.86972962E+00,
     &   1.81926071E+00, 1.66352342E+00, 1.47523529E+00, 1.57745760E+00,
     &   1.35274716E+00, 1.21452291E+00, 1.13103639E+00, 9.58469991E-01,
     &   8.98295559E-01, 7.73650493E-01, 9.38674524E-01, 3.64242213E-01/
  
         DATA ((DGS  (I,J), I=1001,1100), J=1,1) /
     &   2.86069595E-01, 2.37316377E-01, 2.03656620E-01, 1.78935014E-01,
     &   1.59977392E-01, 1.44963497E-01, 1.32769620E-01, 1.22662056E-01,
     &   1.14138342E-01, 1.06830019E-01, 1.00532304E-01, 9.51271126E-02,
     &   9.03358211E-02, 8.60769935E-02, 8.22725872E-02, 7.88555852E-02,
     &   7.34269362E-02, 6.66512018E-02, 6.30179183E-02, 5.70640206E-02,
     &   5.23870281E-02, 4.77640899E-02, 4.11662448E-02, 3.37437623E-02,
     &   2.90830694E-02, 2.69142466E-02, 2.57860478E-02, 2.49517766E-02,
     &   2.43357416E-02, 2.38361569E-02, 2.34673742E-02, 2.31446096E-02,
     &   2.28719251E-02, 2.26392947E-02, 2.24375767E-02, 2.23055840E-02,
     &   2.21064624E-02, 2.19702839E-02, 2.18501520E-02, 2.17442124E-02,
     &   2.16512701E-02, 2.15696510E-02, 2.14985097E-02, 2.14371530E-02,
     &   2.13849380E-02, 2.13415959E-02, 2.12508908E-02, 2.12807395E-02,
     &   2.12633734E-02, 2.12552545E-02, 2.12550286E-02, 2.12684027E-02,
     &   2.12967970E-02, 2.13385475E-02, 2.14010924E-02, 2.14950051E-02,
     &   2.16448281E-02, 2.21275135E-02, 2.27650005E-02, 2.30685581E-02,
     &   2.33151880E-02, 2.35308177E-02, 2.37257642E-02, 2.39040775E-02,
     &   2.40689816E-02, 2.42231334E-02, 2.43664309E-02, 2.45001994E-02,
     &   2.46221258E-02, 2.47381258E-02, 2.47775677E-02, 2.48847642E-02,
     &   2.49760581E-02, 2.50709386E-02, 2.51380252E-02, 2.52056705E-02,
     &   2.52328946E-02, 2.52455166E-02, 2.52412424E-02, 2.52184555E-02,
     &   2.51753080E-02, 2.51094007E-02, 2.50064241E-02, 2.48808831E-02,
     &   2.47376975E-02, 2.45526521E-02, 2.43219890E-02, 2.40315899E-02,
     &   2.36687586E-02, 2.32054017E-02, 2.25806873E-02, 2.16818437E-02,
     &   2.14134996E-02, 2.07010159E-02, 1.96313165E-02, 1.95211057E-02,
     &   1.87817612E-02, 1.84811018E-02, 1.82418257E-02, 1.80386872E-02/
  
         DATA ((DGS  (I,J), I=1101,1200), J=1,1) /
     &   1.77225771E-02, 1.73868266E-02, 1.73144299E-02, 1.73044344E-02,
     &   1.72473887E-02, 1.71438126E-02, 1.70873312E-02, 1.71046367E-02,
     &   1.73245100E-02, 1.73005793E-02, 1.70595941E-02, 1.69624176E-02,
     &   1.67741136E-02, 1.66125425E-02, 1.64509715E-02, 1.62894005E-02,
     &   1.61750815E-02, 1.58920593E-02, 1.54671990E-02, 1.48814834E-02,
     &   1.45078389E-02, 1.39356409E-02, 1.35624615E-02, 1.37588701E-02,
     &   1.46533182E-02, 1.52650778E-02, 1.66437736E-02, 1.72246218E-02,
     &   1.77000052E-02, 1.82302557E-02, 1.86416734E-02, 1.85575200E-02,
     &   1.84495158E-02, 1.86625322E-02, 1.92823776E-02, 1.88289833E-02,
     &   1.82624655E-02, 1.83626897E-02, 1.85552104E-02, 1.86912935E-02,
     &   1.88888891E-02, 1.89145007E-02, 1.87800642E-02, 1.84924525E-02,
     &   1.83204167E-02, 1.79912214E-02, 1.79509280E-02, 1.81711115E-02,
     &   1.84202404E-02, 1.87310691E-02, 1.88679516E-02, 1.91582319E-02,
     &   1.92807805E-02, 1.91141980E-02, 1.92753839E-02, 1.96367379E-02,
     &   2.00205624E-02, 2.04102462E-02, 2.06424988E-02, 2.08398065E-02,
     &   2.10834323E-02, 2.12687085E-02, 2.14020767E-02, 2.15442763E-02,
     &   2.17468028E-02, 2.19215281E-02, 2.20744048E-02, 2.22313070E-02,
     &   2.19780382E-02, 2.11859759E-02, 2.10123993E-02, 2.11372990E-02,
     &   2.13979664E-02, 2.10928733E-02, 2.10899864E-02, 2.13082275E-02,
     &   2.14474457E-02, 2.02527870E-02, 1.89833705E-02, 1.85594922E-02,
     &   1.82555355E-02, 1.87377392E-02, 1.87494141E-02, 1.85494395E-02,
     &   1.83730164E-02, 1.82700957E-02, 1.81241939E-02, 1.79292081E-02,
     &   1.73846506E-02, 1.74220466E-02, 1.74704639E-02, 1.73732172E-02,
     &   1.73373061E-02, 1.73179311E-02, 1.74032457E-02, 1.74455754E-02,
     &   1.74687617E-02, 1.75316989E-02, 1.75112028E-02, 1.75787356E-02/
  
         DATA ((DGS  (I,J), I=1201,1300), J=1,1) /
     &   1.81940664E-02, 1.88509048E-02, 1.90362534E-02, 1.90912974E-02,
     &   1.91254919E-02, 1.89159568E-02, 1.93500644E-02, 1.98859918E-02,
     &   2.00913297E-02, 2.01765880E-02, 2.03246075E-02, 2.03468049E-02,
     &   2.02026294E-02, 1.99472132E-02, 1.98605785E-02, 2.00431088E-02,
     &   2.00435518E-02, 1.95258517E-02, 1.95525133E-02, 1.98272094E-02,
     &   1.97750035E-02, 1.94968345E-02, 1.93642628E-02, 1.94183115E-02,
     &   1.95970001E-02, 1.96093484E-02, 2.00088776E-02, 2.02183413E-02,
     &   2.06346696E-02, 2.10770183E-02, 2.11430142E-02, 2.12012458E-02,
     &   2.12206563E-02, 2.13585559E-02, 2.16110479E-02, 2.17274255E-02,
     &   2.18392939E-02, 2.20525690E-02, 2.22548335E-02, 2.23525171E-02,
     &   2.24481507E-02, 2.25418743E-02, 2.26338037E-02, 2.27240357E-02,
     &   2.28126527E-02, 2.28997253E-02, 2.29853076E-02, 2.30694673E-02,
     &   2.31522438E-02, 2.32336784E-02, 2.33138071E-02, 2.33926621E-02,
     &   2.34702716E-02, 2.35466605E-02, 2.36218507E-02, 2.36958613E-02,
     &   2.37687089E-02, 2.38404077E-02, 2.39109702E-02, 2.39804059E-02,
     &   2.40487222E-02, 2.41159252E-02, 2.41820187E-02, 2.42470046E-02,
     &   2.43108828E-02, 2.43736513E-02, 2.44353061E-02, 2.44958409E-02,
     &   2.45552476E-02, 2.46135154E-02, 2.46706313E-02, 2.47265798E-02,
     &   2.47813429E-02, 2.48242849E-02, 2.48872222E-02, 2.49880582E-02,
     &   2.50835762E-02, 2.51734239E-02, 2.52571498E-02, 2.53341761E-02,
     &   2.54037560E-02, 2.54649155E-02, 2.55163626E-02, 2.55563497E-02,
     &   2.55824507E-02, 2.55911856E-02, 2.55773699E-02, 2.55328316E-02,
     &   2.54438357E-02, 2.54316729E-02, 2.52850610E-02, 2.50034284E-02,
     &   2.44636046E-02, 2.35571035E-02, 2.31800981E-02, 2.15983082E-02,
     &   1.85711622E-02, 1.71355417E-02, 1.50834063E-02, 1.36912257E-02/
  
         DATA ((DGS  (I,J), I=1301,1400), J=1,1) /
     &   1.19272170E-02, 1.01397016E-02, 7.87631020E-03, 6.50452372E-03,
     &   4.92543734E-03, 3.08975967E-03, 9.31519863E-04,-1.63956413E-03,
     &  -4.75030694E-03,-6.56242200E-03,-8.58444413E-03,-1.08540429E-02,
     &  -1.34183765E-02,-1.63372873E-02,-1.96879163E-02,-2.35716058E-02,
     &  -2.81248773E-02,-3.35400020E-02,-3.58177360E-02,-3.72577639E-02,
     &  -3.87749709E-02,-4.04192489E-02,-4.19888629E-02,-4.36190328E-02,
     &  -3.92888471E-02,-4.71912801E-02,-4.91217257E-02,-5.11539031E-02,
     &  -5.32944662E-02,-5.55512651E-02,-5.79332575E-02,-6.04505344E-02,
     &  -6.31141037E-02,-6.59376084E-02,-6.89343708E-02,-7.21207545E-02,
     &  -7.55148724E-02,-7.91372314E-02,-8.30111335E-02,-8.71631609E-02,
     &  -9.16237683E-02,-9.64279635E-02,-1.01616440E-01,-1.07236219E-01,
     &  -1.13342524E-01,-1.20000316E-01,-1.27286601E-01,-1.35293334E-01,
     &  -1.44131189E-01,-1.53934318E-01,-1.64866353E-01,-1.77140057E-01,
     &  -1.91003392E-01,-2.06787687E-01,-2.24916272E-01,-2.45946978E-01,
     &  -2.70628941E-01,-2.99992423E-01,-3.35494022E-01,-3.79262351E-01,
     &  -4.34535105E-01, 1.36580174E-02,-6.03943399E-01,-7.43236225E-01,
     &  -9.58384143E-01,-1.33371806E+00,-2.14868253E+00,-2.66833491E+00,
     &  -5.15195013E+00,-7.19989132E+00,-8.68609482E+00,-9.83205058E+00,
     &   1.70794995E-02,-1.16003139E+01,-1.23670164E+01,-1.29006016E+01,
     &  -1.34422825E+01,-1.39759930E+01,-1.42332865E+01,-1.45938772E+01,
     &  -1.48122812E+01,-1.50829994E+01,-1.51482690E+01,-1.52681280E+01,
     &  -1.52947860E+01,-1.52624053E+01,-1.52129829E+01,-1.51383760E+01,
     &  -1.43386240E-01,-1.39323037E-01,-1.45330296E+01,-1.40087038E+01,
     &  -1.36831928E+01,-1.33162442E+01,-1.28931728E+01,-1.18872386E+01,
     &  -1.13007314E+01,-1.06651294E+01,-9.22034595E+00,-8.42058349E+00/
  
         DATA ((DGS  (I,J), I=1401,1500), J=1,1) /
     &  -2.54058118E+00,-4.72729876E+00, 5.81309204E-01, 4.79860027E+00,
     &   6.74118897E+00, 8.49859411E+00, 1.00602456E+01, 1.07622522E+01,
     &   1.14013385E+01, 1.19852671E+01, 1.29961075E+01, 1.34208605E+01,
     &   1.38002144E+01, 1.41496007E+01, 1.46624733E+01, 1.48623851E+01,
     &   1.50321269E+01, 1.52711912E+01, 1.53483731E+01, 1.54271758E+01,
     &   1.54342443E+01, 1.53933769E+01, 1.52923363E+01, 1.53580718E+01,
     &   1.52231004E+01, 1.47440606E+01, 1.43921374E+01, 1.41337923E+01,
     &   1.35903920E+01, 1.30491650E+01, 1.25152861E+01, 1.17482973E+01,
     &   1.09230681E+01, 9.97828152E+00, 8.82925566E+00, 7.34421134E+00,
     &   5.26525144E+00, 2.90124037E+00, 1.68381398E+00, 1.19413121E+00,
     &   9.29890484E-01, 7.64433882E-01, 6.51009337E-01, 5.68496272E-01,
     &   5.05397605E-01, 4.55823384E-01, 4.15752866E-01, 3.82675793E-01,
     &   3.54895626E-01, 3.31224295E-01, 3.10804799E-01, 2.93003438E-01,
     &   1.25407573E-01, 2.63456433E-01, 2.51036759E-01, 2.39885849E-01,
     &   2.29800628E-01, 2.20635471E-01, 2.12267815E-01, 2.04595810E-01,
     &   1.97534320E-01, 1.91011603E-01, 1.84966779E-01, 5.35271630E-02,
     &   1.74110116E-01, 1.69214980E-01, 1.64628902E-01, 1.60322620E-01,
     &   1.56270488E-01, 1.52449944E-01, 1.48841066E-01, 1.45426218E-01,
     &   1.42189749E-01, 1.39117765E-01, 1.36197959E-01, 1.33419513E-01,
     &   1.30773157E-01, 1.28251577E-01, 1.25851119E-01, 1.23581973E-01,
     &   1.21434230E-01, 1.19160172E-01, 1.17057420E-01, 1.15052979E-01,
     &   1.13131903E-01, 1.11286074E-01, 1.09509604E-01, 9.58879112E-02,
     &   8.72421566E-02, 7.86134270E-02, 6.83460205E-02, 5.76156723E-02,
     &   4.44799122E-02, 3.90775183E-02, 3.14804124E-02, 2.86688254E-02,
     &   2.99902517E-02, 3.04724710E-02, 3.06490708E-02, 3.06740842E-02/
  
         DATA ((DGS  (I,J), I=1501,1600), J=1,1) /
     &   3.05218269E-02, 3.02732647E-02, 2.90485925E-02, 2.75412660E-02,
     &   2.64076816E-02, 2.45624771E-02, 2.22106767E-02, 1.94539061E-02,
     &   1.58918426E-02, 1.10015091E-02,-1.22933662E-03,-3.54789518E-03,
     &  -6.27806072E-03,-7.06918064E-03,-8.87238325E-03,-1.08759002E-02,
     &  -1.31151055E-02,-1.56342277E-02,-1.84893074E-02,-2.17524242E-02,
     &  -2.55178806E-02,-2.99114894E-02,-3.51049484E-02,-4.13388882E-02,
     &  -4.89613983E-02,-5.84957409E-02,-7.07669934E-02,-8.71586540E-02,
     &  -1.10195096E-01,-1.45256101E-01,-2.02442324E-01,-3.16720661E-01,
     &  -4.70238672E-01,-4.96011433E-01,-5.24602472E-01,-5.56500303E-01,
     &  -5.92313141E-01,-6.32807279E-01,-6.78967585E-01,-7.32064639E-01,
     &  -7.93791551E-01,-8.66433426E-01,-9.53160289E-01,-1.05849833E+00,
     &  -1.18913988E+00,-1.35540992E+00,-1.57410766E+00,-1.87445802E+00,
     &  -2.31212485E+00,-3.00699168E+00,-4.26801324E+00,-7.12086855E+00,
     &  -8.12057845E+00,-8.55557563E+00,-9.77989418E+00,-1.05250594E+01,
     &  -1.10647248E+01,-9.60263924E+00,-8.42886099E+00,-1.26960200E+01,
     &  -1.22698080E+01,-8.46489807E-01,-4.41121129E+00,-4.30877911E+00,
     &  -4.25769287E+00,-1.01676556E+01,-1.01069687E+01,-1.00610675E+01,
     &  -1.00148383E+01,-9.53512952E+00,-8.76085959E+00,-7.83428396E+00,
     &  -6.95140845E+00,-7.32542329E+00,-6.21443132E+00,-5.11659538E+00,
     &  -4.47175132E+00,-3.85404713E+00,-3.16507884E+00,-2.17130280E+00,
     &  -1.44572007E+00, 1.12789456E-01, 1.13123647E-01, 1.13234964E-01,
     &   1.13290608E-01, 1.13346241E-01, 1.13401865E-01, 1.13457479E-01,
     &   1.13902027E-01, 1.14456809E-01, 1.15010583E-01, 5.46886176E+00,
     &   6.60779741E+00, 8.53955665E+00, 9.28711434E+00, 9.98791814E+00,
     &   1.05095405E+01, 1.02331967E+01, 1.08893685E+01, 1.14971279E+01/
  
         DATA ((DGS  (I,J), I=1601,1700), J=1,1) /
     &   1.16791703E+01, 1.17821145E+01, 1.18145414E+01, 1.18124103E+01,
     &   1.17751630E+01, 1.17163867E+01, 8.51519441E+00, 1.14061705E+01,
     &   1.12649703E+01, 1.11253823E+01, 1.07750980E+01, 1.05937602E+01,
     &   1.02992424E+01, 9.82837943E+00, 8.17479913E+00, 6.88634411E+00,
     &   5.90896140E+00, 5.15908194E+00, 4.57040565E+00, 4.01287115E+00,
     &   3.48191374E+00, 2.89130908E+00, 2.69218841E+00, 2.51854706E+00,
     &   2.36556484E+00, 2.13940344E+00, 1.77544684E+00, 1.51803617E+00,
     &   1.32648989E+00, 1.17845630E+00, 1.06063565E+00, 9.64658051E-01,
     &   8.84969537E-01, 8.17750884E-01, 7.60293251E-01, 7.10613554E-01,
     &   6.67234098E-01, 6.29029750E-01, 5.95126165E-01, 5.64834443E-01,
     &   5.37612466E-01, 3.70632874E-01, 2.56183621E-01, 1.98982348E-01,
     &   1.41873992E-01, 1.12861737E-01, 9.56440049E-02, 8.41899658E-02,
     &   7.60167378E-02, 6.98895169E-02, 6.51247711E-02, 6.13130711E-02,
     &   5.91505908E-02, 5.66271432E-02, 5.44706026E-02, 5.26062248E-02,
     &   5.09782773E-02, 4.95443553E-02, 4.43474097E-02, 4.10848480E-02,
     &   3.88416413E-02, 3.72005729E-02, 3.59426834E-02, 3.49325357E-02,
     &   3.41285616E-02, 3.34603672E-02, 2.78263655E-02, 2.62809676E-02,
     &   2.58902944E-02, 2.54369470E-02, 2.48959141E-02, 2.42223530E-02,
     &   2.38153016E-02, 2.33459354E-02, 2.21362048E-02, 2.03103621E-02,
     &   1.71280237E-02, 9.89385391E-03, 2.98433756E-03, 1.20121983E-03,
     &  -8.55385437E-04,-3.25386445E-03,-6.08761521E-03,-9.48749058E-03,
     &  -1.36425035E-02,-1.88367326E-02,-2.55176220E-02,-3.44338438E-02,
     &  -4.69503872E-02,-6.58029387E-02,-9.68297077E-02,-1.02239258E-01,
     &  -1.08140832E-01,-1.14605992E-01,-1.21720096E-01,-1.29607685E-01,
     &  -1.38314194E-01,-1.48077687E-01,-1.59060676E-01,-1.71509581E-01/
  
         DATA ((DGS  (I,J), I=1701,1800), J=1,1) /
     &  -1.85737034E-01,-2.02151408E-01,-2.21303237E-01,-2.43936560E-01,
     &  -2.71092546E-01,-3.04281742E-01,-3.14644320E-01,-3.45770536E-01,
     &  -3.99096172E-01,-4.70188956E-01,-5.69684817E-01,-7.18827161E-01,
     &  -9.67078203E-01,-1.46196716E+00,-2.92469113E+00,-3.48230984E+00,
     &  -4.92308669E+00,-5.62982603E+00,-6.92174321E+00,-7.70820738E+00,
     &  -8.40928015E+00,-9.04468989E+00,-9.59124817E+00,-1.03619690E+01,
     &  -1.05921035E+01, 8.56848716E-02,-1.14837268E+01,-1.18552119E+01,
     &  -1.21708381E+01,-1.24321568E+01,-8.62856102E+00,-1.28690713E+01,
     &  -1.30292261E+01,-1.31759194E+01,-1.33036635E+01,-1.34026036E+01,
     &  -1.36266170E+01,-1.34235421E+01,-1.33365125E+01,-1.24953575E+01,
     &  -1.17846746E+01, 2.63615500E-01,-1.23957600E+01,-1.18514479E+01,
     &  -1.11727883E+01,-1.02081547E+01,-9.06170745E+00,-7.54541460E+00,
     &  -5.77811920E+00, 2.63668560E+00, 2.76307006E-02, 2.65519585E+00,
     &   5.83370628E+00, 7.60737245E+00, 9.14150776E+00, 1.02992605E+01,
     &   8.69487823E+00, 9.64812429E+00, 1.05673600E+01, 1.14405169E+01,
     &   1.21233598E+01, 1.28769101E+01, 1.35454143E+01, 5.12683168E+00,
     &   5.58149323E+00, 6.05494638E+00, 9.49102081E-01, 7.23956560E+00,
     &   7.87627977E+00, 8.54294150E+00, 9.33984832E+00, 1.02753572E+01,
     &   1.12404590E+01, 1.23239381E+01, 1.16763684E+01, 1.07936175E+01,
     &   9.90469001E+00, 9.11370893E+00, 8.52109510E+00, 3.32539824E+00,
     &   8.49145456E+00, 7.75119818E+00, 6.98224582E+00, 6.07254690E+00,
     &   4.97851425E+00, 3.53775302E+00, 3.03323489E+00, 2.93860798E+00,
     &   1.97085417E+00, 2.49700026E+00, 2.20488592E+00, 1.51733058E+00,
     &   1.02252330E+00, 7.74262017E-01, 6.25116375E-01, 5.25633307E-01,
     &   4.54539921E-01, 4.01208689E-01, 3.59727026E-01, 3.26534489E-01/
  
         DATA ((DGS  (I,J), I=1801,1900), J=1,1) /
     &   2.99375114E-01, 2.76743446E-01, 2.57592506E-01, 2.41172286E-01,
     &   2.26946274E-01, 2.14495964E-01, 1.52244038E-01, 1.21118255E-01,
     &   1.02446763E-01, 9.00181442E-02, 8.11013291E-02, 7.43792378E-02,
     &   6.91706421E-02, 6.16038924E-02, 5.63668778E-02, 5.43089572E-02,
     &   5.25249420E-02, 4.61043222E-02, 4.13939438E-02, 3.85668440E-02,
     &   3.66751152E-02, 3.53159502E-02, 3.42878054E-02, 3.34779283E-02,
     &   3.28189247E-02, 3.22659114E-02, 3.13445414E-02, 3.14003956E-02,
     &   3.10547208E-02, 3.07414517E-02, 3.04547266E-02, 3.01899665E-02,
     &   2.99412897E-02, 2.97045968E-02, 2.94755217E-02, 2.92488848E-02,
     &   2.90170081E-02, 2.87593537E-02, 2.85850734E-02, 2.53335831E-02,
     &   2.45667496E-02, 2.36027514E-02, 2.28373188E-02, 2.22050910E-02,
     &   2.21330843E-02, 2.12548800E-02, 2.08445212E-02, 2.05237040E-02,
     &   2.02540320E-02, 2.00305281E-02, 1.99479388E-02, 1.97151397E-02,
     &   1.96181848E-02, 1.95587786E-02, 1.95369099E-02, 1.95508882E-02,
     &   1.95998018E-02, 1.96849702E-02, 1.97820357E-02, 1.99559531E-02,
     &   2.01494430E-02, 2.03722208E-02, 2.06399007E-02, 2.09472297E-02,
     &   2.13022501E-02, 2.17070887E-02, 2.21632579E-02, 2.26714933E-02,
     &   2.32716450E-02, 2.39585693E-02, 2.47518666E-02, 2.57406437E-02,
     &   2.70475552E-02, 3.02416441E-02, 3.32609601E-02, 3.44001451E-02,
     &   3.52255962E-02, 3.58645806E-02, 3.64003437E-02, 3.68541202E-02,
     &   3.72269143E-02, 3.75513681E-02, 3.78299187E-02, 3.80661570E-02,
     &   3.82773899E-02, 3.84224587E-02, 3.85487476E-02, 3.86485856E-02,
     &   3.87158744E-02, 3.87561213E-02, 3.87680476E-02, 3.87517808E-02,
     &   3.87091394E-02, 3.86356379E-02, 3.85320483E-02, 3.83992033E-02,
     &   3.82347655E-02, 3.79812168E-02, 3.76966789E-02, 3.73783345E-02/
  
         DATA ((DGS  (I,J), I=1901,2000), J=1,1) /
     &   3.72045036E-02, 3.68337621E-02, 3.64047815E-02, 3.58950273E-02,
     &   3.53058114E-02, 3.45883097E-02, 3.36853599E-02, 3.24600035E-02,
     &   3.02813303E-02, 3.01645531E-02, 2.95210700E-02, 2.93256867E-02,
     &   2.89328328E-02, 2.87450305E-02, 2.85933268E-02, 2.84666269E-02,
     &   2.83591720E-02, 2.82668112E-02, 2.81466570E-02, 2.81178638E-02,
     &   2.80580484E-02, 2.80067572E-02, 2.79578045E-02, 2.79257433E-02,
     &   2.78954480E-02, 2.78712255E-02, 2.78527512E-02, 2.78399095E-02,
     &   2.77605205E-02, 2.77641494E-02, 2.78344254E-02, 2.78427697E-02,
     &   2.78598125E-02, 2.78821507E-02, 2.79107335E-02, 2.79462701E-02,
     &   2.79894537E-02, 2.80413606E-02, 2.81028645E-02, 2.81764523E-02,
     &   2.82644253E-02, 2.83624144E-02, 2.85082717E-02, 2.86963974E-02,
     &   2.91829353E-02, 2.95462793E-02, 2.97872807E-02, 2.99137384E-02,
     &   3.00157333E-02, 3.01013762E-02, 3.01752099E-02, 3.02392694E-02,
     &   3.02952934E-02, 3.03447052E-02, 3.03879100E-02, 3.04257611E-02,
     &   3.04587304E-02, 3.04870375E-02, 3.05111813E-02, 3.05313758E-02,
     &   3.05475166E-02, 3.05599962E-02, 3.05688844E-02, 3.05741359E-02,
     &   3.05852240E-02, 3.05749544E-02, 3.05692507E-02, 3.05600475E-02,
     &   3.05475702E-02, 3.05314589E-02, 3.05114757E-02, 3.04875611E-02,
     &   3.04592014E-02, 3.04269101E-02, 3.03900296E-02, 3.03829158E-02,
     &   3.03410222E-02, 3.02921735E-02, 3.02346064E-02, 3.01243139E-02,
     &   2.96321916E-02, 2.97084962E-02, 2.96926986E-02, 2.96783740E-02,
     &   2.96655253E-02, 2.96541456E-02, 2.96442179E-02, 2.96356453E-02,
     &   2.96283622E-02, 2.96224042E-02, 2.96104513E-02, 2.96062979E-02,
     &   2.96054555E-02, 2.94575543E-02, 2.94585890E-02, 2.94613432E-02,
     &   2.96092749E-02, 2.96137631E-02, 2.96197066E-02, 2.96272280E-02/
  
         DATA ((DGS  (I,J), I=2001,2100), J=1,1) /
     &   2.96364538E-02, 2.96472417E-02, 2.96598597E-02, 2.96743993E-02,
     &   2.96909473E-02, 2.97097801E-02, 2.97308129E-02, 2.97548168E-02,
     &   2.97820237E-02, 2.98129325E-02, 2.98481036E-02, 2.98891191E-02,
     &   2.99378649E-02, 2.99983331E-02, 3.00802426E-02, 3.02888376E-02,
     &   3.04962204E-02, 3.05793813E-02, 3.06791482E-02, 3.07387880E-02,
     &   3.07896648E-02, 3.07496754E-02, 3.07825237E-02, 3.08118919E-02,
     &   3.08382582E-02, 3.08618217E-02, 3.08834051E-02, 3.09028815E-02,
     &   3.09205415E-02, 3.09364600E-02, 3.09507150E-02, 3.09636396E-02,
     &   3.09751219E-02, 3.09850968E-02, 3.09950284E-02, 3.10022951E-02,
     &   3.10076238E-02, 3.10127183E-02, 3.10166403E-02, 3.10194365E-02,
     &   3.10211014E-02, 3.10216336E-02, 3.10210291E-02, 3.10192801E-02,
     &   3.10164006E-02, 3.10123692E-02, 3.10109042E-02, 3.10033202E-02,
     &   3.09945316E-02, 3.09846224E-02, 3.09733820E-02, 3.09058083E-02,
     &   3.06259972E-02, 3.03121107E-02, 3.01902493E-02, 3.00020726E-02,
     &   2.98445691E-02, 2.96914671E-02, 2.95574584E-02, 2.94241035E-02,
     &   2.92969642E-02, 2.91703493E-02, 2.90382560E-02, 2.89072658E-02,
     &   2.88319504E-02, 2.87566350E-02, 2.88712056E-02, 2.89778285E-02,
     &   2.90700413E-02, 2.91583229E-02, 2.92364354E-02, 2.93126250E-02,
     &   2.93810951E-02, 2.94487593E-02, 2.95129783E-02, 2.95716055E-02,
     &   2.96303334E-02, 2.96843383E-02, 2.97387817E-02, 2.97891298E-02,
     &   2.98401411E-02, 2.98875264E-02, 2.99357279E-02, 2.99806646E-02,
     &   3.00265236E-02, 3.00694020E-02, 3.01113889E-02, 3.01544004E-02,
     &   3.01947559E-02, 3.02361802E-02, 3.02751189E-02, 3.03151573E-02,
     &   3.03528527E-02, 3.03916691E-02, 3.04282634E-02, 3.04659930E-02,
     &   3.05016039E-02, 3.05383593E-02, 3.05746544E-02, 3.06089617E-02/
  
         DATA ((DGS  (I,J), I=2101,2180), J=1,1) /
     &   3.06444202E-02, 3.06779642E-02, 3.07126605E-02, 3.07455072E-02,
     &   3.07795054E-02, 3.08117118E-02, 3.08450673E-02, 3.08766829E-02,
     &   3.09094443E-02, 3.09405127E-02, 3.09713276E-02, 3.10032817E-02,
     &   3.10336048E-02, 3.10650618E-02, 3.10949249E-02, 3.11186846E-02,
     &   3.11507506E-02, 3.11814304E-02, 3.12105847E-02, 3.12408697E-02,
     &   3.12696572E-02, 3.12995695E-02, 3.13292992E-02, 3.13575699E-02,
     &   3.13869564E-02, 3.14149073E-02, 3.14439678E-02, 3.14716145E-02,
     &   3.15003647E-02, 3.15277216E-02, 3.15566996E-02, 3.15835836E-02,
     &   3.16117959E-02, 3.16386125E-02, 3.16665133E-02, 3.16930747E-02,
     &   3.17195150E-02, 3.17470302E-02, 3.17732300E-02, 3.18004986E-02,
     &   3.18264669E-02, 3.18534980E-02, 3.18792433E-02, 3.19809089E-02,
     &   3.20064134E-02, 3.20329234E-02, 3.20581358E-02, 3.20843445E-02,
     &   3.22899125E-02, 3.25592899E-02, 3.26014898E-02, 3.44463528E-02,
     &   3.52641653E-02, 3.73939774E-02, 3.88094871E-02, 3.86420726E-02,
     &   4.02299281E-02, 4.02349576E-02, 4.14240613E-02, 4.14693836E-02,
     &   4.14967302E-02, 4.20866982E-02, 4.24795172E-02, 4.25499955E-02,
     &   4.26651773E-02, 4.28358806E-02, 4.29563159E-02, 4.30319562E-02,
     &   4.37659599E-02, 4.38039116E-02, 4.40270884E-02, 4.40671658E-02,
     &   4.46817883E-02, 4.43126303E-02, 4.44359425E-02, 4.44899087E-02,
     &   4.45768963E-02, 4.48012741E-02, 4.48966483E-02, 4.55277426E-02/
  
         DATA ((DGS  (I,J), I=   1, 100), J=2,2) /
     &   2.31993279E-06, 2.53444500E-06, 2.79242833E-06, 3.16255339E-06,
     &   3.70616609E-06, 3.92967727E-06, 5.45877439E-06, 4.56693720E-06,
     &   4.91047795E-06, 5.31685083E-06, 5.57318406E-06, 6.15087872E-06,
     &   6.30801197E-06, 6.61814111E-06, 6.84340391E-06, 7.06378182E-06,
     &   7.42146876E-06, 7.75925450E-06, 7.88365121E-06, 8.08909693E-06,
     &   8.28335607E-06, 8.54226748E-06, 8.76824560E-06, 8.96248114E-06,
     &   9.16452697E-06, 9.51689201E-06, 9.86675838E-06, 1.00597258E-05,
     &   1.01235996E-05, 1.04228479E-05, 1.08015288E-05, 1.09268948E-05,
     &   1.13104704E-05, 1.16809617E-05, 1.20733375E-05, 1.25074532E-05,
     &   1.29760275E-05, 1.36492967E-05, 1.42393968E-05, 1.48412400E-05,
     &   1.55008528E-05, 1.62938386E-05, 1.72164722E-05, 1.81044485E-05,
     &   1.95810407E-05, 2.18430547E-05, 2.36327656E-05, 2.41704134E-05,
     &   2.40095574E-05, 2.33547668E-05, 2.80294164E-05, 3.33103921E-05,
     &   3.68426931E-05, 3.67293017E-05, 4.10219690E-05, 4.18483581E-05,
     &   3.79710362E-05, 3.47650353E-05, 3.36555057E-05, 3.39414187E-05,
     &   3.52174808E-05, 3.50276621E-05, 3.58139514E-05, 3.54892117E-05,
     &   3.67179290E-05, 3.73949265E-05, 3.90206166E-05, 4.22682195E-05,
     &   4.36674171E-05, 4.38294489E-05, 4.68113897E-05, 4.47406917E-05,
     &   4.53757241E-05, 4.70642732E-05, 4.90377516E-05, 4.92720885E-05,
     &   4.77898934E-05, 4.77658178E-05, 4.77678098E-05, 1.17546978E-04,
     &   9.94359317E-05, 1.02612750E-04, 9.81411479E-05, 9.38670447E-05,
     &   8.07479269E-05, 7.80752410E-05, 8.17184418E-05, 7.40421729E-05,
     &   7.14874266E-05, 6.96562997E-05, 6.64899490E-05, 6.49361331E-05,
     &   6.35934902E-05, 6.26802731E-05, 6.17706061E-05, 6.04287342E-05,
     &   6.01429680E-05, 5.98529153E-05, 5.94499850E-05, 5.87646140E-05/
  
         DATA ((DGS  (I,J), I= 101, 200), J=2,2) /
     &   5.85101200E-05, 5.81891187E-05, 5.79477456E-05, 5.79174186E-05,
     &   5.83570932E-05, 5.79544097E-05, 5.75597397E-05, 5.71730834E-05,
     &   5.62580951E-05, 5.57038996E-05, 5.55340452E-05, 5.46420550E-05,
     &   5.37227588E-05, 5.27534020E-05, 5.23815674E-05, 5.19799194E-05,
     &   5.14056677E-05, 5.07433361E-05, 5.05253433E-05, 5.06645782E-05,
     &   5.07950053E-05, 5.09339022E-05, 5.13834376E-05, 5.22201942E-05,
     &   5.31861198E-05, 5.29558110E-05, 5.32974966E-05, 5.39345186E-05,
     &   5.47990657E-05, 5.46873489E-05, 5.47545125E-05, 5.46568805E-05,
     &   5.48101730E-05, 5.44944188E-05, 5.45038424E-05, 5.43613748E-05,
     &   5.42467625E-05, 5.43627921E-05, 5.42206448E-05, 5.43115188E-05,
     &   5.48399159E-05, 5.47496892E-05, 5.53541905E-05, 5.56542611E-05,
     &   5.62871171E-05, 5.71118913E-05, 5.71714592E-05, 5.93678293E-05,
     &   5.88153399E-05, 5.91497249E-05, 5.77640554E-05, 6.13577815E-05,
     &   6.21674256E-05, 5.01323226E-05, 3.80972197E-05, 3.81152544E-05,
     &   3.79252836E-05, 3.66297009E-05, 3.70138730E-05, 3.71826018E-05,
     &   3.84794192E-05, 4.00439956E-05, 4.09497351E-05, 3.92718054E-05,
     &   3.83654187E-05, 3.76224296E-05, 3.77325779E-05, 3.71499515E-05,
     &   3.57904907E-05, 3.58928923E-05, 3.74547953E-05, 3.79233546E-05,
     &   3.78345875E-05, 3.76310440E-05, 3.79609867E-05, 3.83686497E-05,
     &   3.90130032E-05, 3.97888978E-05, 4.10624484E-05, 4.16725461E-05,
     &   4.30432519E-05, 4.37219405E-05, 4.53985540E-05, 4.70749682E-05,
     &   4.95816049E-05, 5.19808040E-05, 5.55609429E-05, 5.89027858E-05,
     &   6.31078189E-05, 6.84451049E-05, 7.15555875E-05, 7.38202704E-05,
     &   7.89835380E-05, 8.19089149E-05, 8.48704145E-05, 8.85498279E-05,
     &   9.28016398E-05, 9.79091885E-05, 1.02657179E-04, 1.10883598E-04/
  
         DATA ((DGS  (I,J), I= 201, 300), J=2,2) /
     &   1.20071418E-04, 1.26245819E-04, 1.28684941E-04, 1.31281423E-04,
     &   1.34040631E-04, 1.36969621E-04, 1.40069246E-04, 1.43279118E-04,
     &   1.46559276E-04, 1.50009005E-04, 1.53634851E-04, 1.57441113E-04,
     &   1.61431760E-04, 1.65544940E-04, 1.69831789E-04, 1.74389367E-04,
     &   1.79226945E-04, 1.84374152E-04, 1.89875019E-04, 1.95774487E-04,
     &   2.02125450E-04, 2.08989837E-04, 2.16425755E-04, 2.24544913E-04,
     &   2.33430617E-04, 2.43203953E-04, 2.54061835E-04, 2.66211611E-04,
     &   2.80401091E-04, 2.99335049E-04, 3.14385685E-04, 3.17058636E-04,
     &   3.24105508E-04, 3.37184955E-04, 3.47670476E-04, 3.62977954E-04,
     &   3.76912846E-04, 3.92159233E-04, 4.06155810E-04, 4.26648188E-04,
     &   4.42446451E-04, 4.53110518E-04, 4.71225541E-04, 4.73080336E-04,
     &   4.74935130E-04, 4.73982955E-04, 4.68431064E-04, 4.65503278E-04,
     &   4.86450122E-04, 5.63866826E-04, 6.62098392E-04, 7.73954126E-04,
     &   8.43745962E-04, 8.88401414E-04, 8.84938981E-04, 9.08329829E-04,
     &   9.41113463E-04, 9.82326841E-04, 9.61978748E-04, 1.01321423E-03,
     &   1.04633998E-03, 1.04198550E-03, 1.07377352E-03, 1.06982789E-03,
     &   9.97860969E-04, 8.85565387E-04, 7.02277316E-04, 5.86641520E-04,
     &   5.34445289E-04, 4.66823919E-04, 3.81214574E-04, 2.84361486E-04,
     &   2.02786945E-04, 1.80991680E-04, 1.57157345E-04, 3.16583248E-05,
     &   2.68291393E-04, 4.30241972E-04, 4.97543618E-04, 5.81687325E-04,
     &   6.62079818E-04, 7.28177434E-04, 7.85519417E-04, 8.37534444E-04,
     &   8.88269235E-04, 9.46436550E-04, 9.94817910E-04, 9.64491136E-04,
     &   9.82776005E-04, 9.40717851E-04, 9.04807044E-04, 8.68915699E-04,
     &   8.49426249E-04, 8.33729256E-04, 8.19895179E-04, 8.16291711E-04,
     &   8.04346161E-04, 7.95950831E-04, 7.89593841E-04, 7.84595142E-04/
  
         DATA ((DGS  (I,J), I= 301, 400), J=2,2) /
     &   7.58459937E-04, 7.81379749E-04, 7.74344451E-04, 7.72806654E-04,
     &   7.60927938E-04, 7.41044087E-04, 7.07252592E-04, 6.83034566E-04,
     &   5.87185695E-04, 5.40851617E-04, 5.11010090E-04, 4.86145359E-04,
     &   4.63879556E-04, 4.43890555E-04, 4.25274102E-04, 4.06820500E-04,
     &   3.87140391E-04, 3.68749075E-04, 3.53568016E-04, 3.40083677E-04,
     &   3.27253993E-04, 3.16327488E-04, 3.13780727E-04, 2.96869426E-04,
     &   2.90514811E-04, 3.02324752E-04, 2.99191212E-04, 2.74173406E-04,
     &   2.60205448E-04, 2.49298353E-04, 2.39998413E-04, 2.31715099E-04,
     &   2.24237461E-04, 2.17396835E-04, 2.11090814E-04, 2.05245933E-04,
     &   1.99806208E-04, 1.94727445E-04, 1.89974035E-04, 1.85519627E-04,
     &   1.81334315E-04, 1.77375416E-04, 1.73598189E-04, 1.70063856E-04,
     &   1.66649757E-04, 1.63275103E-04, 1.60081149E-04, 1.57067228E-04,
     &   1.54228626E-04, 1.51571469E-04, 1.49101775E-04, 1.46682316E-04,
     &   1.44033065E-04, 1.41484065E-04, 1.39031958E-04, 1.36674199E-04,
     &   1.30449135E-04, 1.18475608E-04, 1.01358616E-04, 9.19017678E-05,
     &   8.31582197E-05, 7.63835351E-05, 7.08449306E-05, 6.69273213E-05,
     &   6.22651575E-05, 6.14587627E-05, 5.61319199E-05, 5.59281301E-05,
     &   5.49666008E-05, 5.22529401E-05, 5.09604749E-05, 5.01993695E-05,
     &   4.89665950E-05, 4.82586507E-05, 4.63162605E-05, 4.71713522E-05,
     &   4.50483695E-05, 4.47812270E-05, 4.37603214E-05, 4.41068255E-05,
     &   4.22874429E-05, 4.33697731E-05, 4.13606620E-05, 4.21544867E-05,
     &   4.15706931E-05, 4.13363557E-05, 4.17139890E-05, 4.03715005E-05,
     &   4.17423850E-05, 4.06295429E-05, 4.05274140E-05, 4.13991896E-05,
     &   4.09151350E-05, 4.34276526E-05, 4.19570872E-05, 4.35949518E-05,
     &   4.35235479E-05, 4.71588522E-05, 4.65401064E-05, 4.58580793E-05/
  
         DATA ((DGS  (I,J), I= 401, 500), J=2,2) /
     &   4.72162931E-05, 5.12593531E-05, 5.32545819E-05, 5.04238675E-05,
     &   4.93623497E-05, 5.07684818E-05, 5.33562262E-05, 5.55465463E-05,
     &   5.57529470E-05, 5.36622059E-05, 5.55044136E-05, 5.56983729E-05,
     &   5.69980578E-05, 6.20357636E-05, 6.06779882E-05, 5.73304734E-05,
     &   5.88284616E-05, 5.56498546E-05, 5.61187105E-05, 6.05362775E-05,
     &   6.12819209E-05, 6.26098917E-05, 6.45952984E-05, 6.27137122E-05,
     &   6.07453283E-05, 6.26492548E-05, 6.26787930E-05, 6.83688109E-05,
     &   6.84673045E-05, 6.69976561E-05, 6.98808748E-05, 6.64656161E-05,
     &   6.76612517E-05, 6.94164042E-05, 7.26546797E-05, 6.86209580E-05,
     &   6.87893122E-05, 6.72202765E-05, 6.96709328E-05, 7.53722789E-05,
     &   7.42610130E-05, 7.55425261E-05, 7.35469525E-05, 7.39574350E-05,
     &   7.24507643E-05, 7.17122439E-05, 7.96224491E-05, 7.51870523E-05,
     &   7.84377182E-05, 7.25533105E-05, 8.09276791E-05, 8.06575718E-05,
     &   8.09566557E-05, 8.21926295E-05, 7.77436528E-05, 7.30965069E-05,
     &   7.15954552E-05, 7.39694862E-05, 7.93216059E-05, 8.01464572E-05,
     &   8.00598080E-05, 7.90933842E-05, 7.94225497E-05, 7.78006610E-05,
     &   7.88348079E-05, 7.90219546E-05, 7.70058641E-05, 7.93429207E-05,
     &   8.37559389E-05, 8.14826693E-05, 8.27502991E-05, 8.33418269E-05,
     &   8.85000287E-05, 9.20695803E-05, 9.26947346E-05, 9.95726700E-05,
     &   1.02281653E-04, 9.92420658E-05, 1.04520829E-04, 1.00421116E-04,
     &   9.89550623E-05, 1.14533952E-04, 1.24508153E-04, 1.25106098E-04,
     &   1.11199833E-04, 1.18645241E-04, 1.24267658E-04, 1.29912427E-04,
     &   1.21617901E-04, 1.23404624E-04, 1.23928598E-04, 1.24735419E-04,
     &   1.28832432E-04, 1.28956215E-04, 1.22658011E-04, 1.20281902E-04,
     &   1.37757624E-04, 1.58563823E-04, 1.62405152E-04, 1.94380332E-04/
  
         DATA ((DGS  (I,J), I= 501, 600), J=2,2) /
     &   2.02516019E-04, 1.90918180E-04, 1.74736763E-04, 1.72291659E-04,
     &   1.40603349E-04, 1.43769029E-04, 1.54853978E-04, 1.51957181E-04,
     &   1.57037373E-04, 1.68442247E-04, 1.84894498E-04, 2.06069540E-04,
     &   2.33330671E-04, 2.69123592E-04, 3.17635743E-04, 3.86426578E-04,
     &   4.90318866E-04, 5.18615774E-04, 5.48904815E-04, 5.83524188E-04,
     &   6.22810216E-04, 6.67566571E-04, 7.18869222E-04, 7.78557993E-04,
     &   7.91601161E-04, 8.05114643E-04, 8.19104612E-04, 8.33586455E-04,
     &   8.48582248E-04, 8.63949944E-04, 8.79891080E-04, 8.96433936E-04,
     &   9.13613848E-04, 9.31438994E-04, 1.02072385E-03, 1.09007514E-03,
     &   1.12830172E-03, 1.15522345E-03, 1.18341108E-03, 1.21297968E-03,
     &   1.24400157E-03, 1.27659802E-03, 1.31088847E-03, 1.32871211E-03,
     &   1.34701797E-03, 1.36581634E-03, 1.38513642E-03, 1.40499090E-03,
     &   1.42541120E-03, 1.44641274E-03, 1.46802946E-03, 1.49027991E-03,
     &   1.51320096E-03, 1.53681471E-03, 1.56115781E-03, 1.58626435E-03,
     &   1.61217067E-03, 1.63891544E-03, 1.66653990E-03, 1.69508805E-03,
     &   1.72460691E-03, 1.75514673E-03, 1.78676130E-03, 1.81950828E-03,
     &   1.85344954E-03, 1.88865151E-03, 1.92518566E-03, 1.96312897E-03,
     &   2.00256448E-03, 2.04358185E-03, 2.08627810E-03, 2.13075834E-03,
     &   2.17713662E-03, 2.22553793E-03, 2.27609652E-03, 2.32895974E-03,
     &   2.38428872E-03, 2.44225994E-03, 2.50306717E-03, 2.56692355E-03,
     &   2.63406417E-03, 2.70474890E-03, 2.77926576E-03, 2.81805956E-03,
     &   2.85793488E-03, 2.89893611E-03, 2.94111302E-03, 2.98451548E-03,
     &   3.02919905E-03, 3.07521992E-03, 3.12264032E-03, 3.17152375E-03,
     &   3.22194022E-03, 3.27396170E-03, 3.32766728E-03, 3.38313882E-03,
     &   3.44046605E-03, 3.49974244E-03, 3.56107024E-03, 3.62455663E-03/
  
         DATA ((DGS  (I,J), I= 601, 700), J=2,2) /
     &   3.69031869E-03, 3.75847966E-03, 3.82917480E-03, 3.90254654E-03,
     &   3.97875048E-03, 4.05795378E-03, 4.14033698E-03, 4.22609547E-03,
     &   4.31544092E-03, 4.40860312E-03, 4.50583189E-03, 4.60739935E-03,
     &   4.71360247E-03, 4.82476592E-03, 4.94124534E-03, 5.06343122E-03,
     &   5.19175372E-03, 5.32668653E-03, 5.46875423E-03, 5.61853756E-03,
     &   5.77668289E-03, 6.01352108E-03, 6.12102460E-03, 6.30892973E-03,
     &   6.50864271E-03, 6.72131204E-03, 6.94824101E-03, 7.19091289E-03,
     &   7.45102497E-03, 7.73052667E-03, 8.03167014E-03, 8.35706940E-03,
     &   8.70977807E-03, 9.09338382E-03, 9.39961079E-03, 1.03535822E-02,
     &   1.15218261E-02, 1.29856587E-02, 1.48734996E-02, 1.74007490E-02,
     &   2.09584350E-02, 2.63380098E-02, 3.54201067E-02, 5.40292272E-02,
     &   1.13609456E-01, 1.20135195E-01, 1.27453328E-01, 1.35716932E-01,
     &   1.45121042E-01, 1.55917999E-01, 1.68440032E-01, 1.83133330E-01,
     &   2.00610997E-01, 2.21738177E-01, 2.47774281E-01, 2.80621461E-01,
     &   3.23281588E-01, 3.80746357E-01, 3.87597656E-01, 5.41006984E-01,
     &   6.52822389E-01, 7.42659610E-01, 8.20790447E-01, 8.80996508E-01,
     &   9.33601363E-01, 9.75760489E-01, 1.01776031E+00, 1.04661170E+00,
     &   1.07332571E+00, 1.09217607E+00, 1.10771607E+00, 1.11644878E+00,
     &   1.12296717E+00, 1.12352146E+00, 1.12024089E+00, 1.11114335E+00,
     &   1.10131106E+00, 1.08004368E+00, 1.06098828E+00, 1.03759795E+00,
     &   1.00950479E+00, 9.76355837E-01, 9.37826520E-01, 8.93636188E-01,
     &   8.43565560E-01, 7.87475381E-01, 7.25325372E-01, 6.57192191E-01,
     &   5.44270380E-01, 4.62409815E-01, 3.31188624E-01, 1.92153036E-01,
     &   1.92020448E-01, 5.44154278E-01, 6.57085419E-01, 7.57059641E-01,
     &   8.16188946E-01, 8.93558486E-01, 9.37756436E-01, 9.76293328E-01/
  
         DATA ((DGS  (I,J), I= 701, 800), J=2,2) /
     &   1.00944974E+00, 1.03755021E+00, 1.06094762E+00, 1.08000987E+00,
     &   1.09510877E+00, 1.10661126E+00, 1.11487263E+00, 1.12023171E+00,
     &   1.12352031E+00, 1.12297103E+00, 1.11869139E+00, 1.11095927E+00,
     &   1.10422689E+00, 1.08775905E+00, 1.07335911E+00, 1.05220570E+00,
     &   1.02952523E+00, 9.99934429E-01, 9.69768256E-01, 9.27702982E-01,
     &   8.86776849E-01, 8.36774969E-01, 7.80380949E-01, 7.07844765E-01,
     &   6.24691935E-01, 5.20862837E-01, 4.29205341E-01, 3.58008033E-01,
     &   3.06634385E-01, 2.67952368E-01, 2.37832837E-01, 2.13742843E-01,
     &   1.94050310E-01, 1.77659406E-01, 1.63808417E-01, 1.51952087E-01,
     &   1.41690169E-01, 1.32722405E-01, 1.24819243E-01, 1.17802239E-01,
     &   1.11530618E-01, 1.05891862E-01, 1.00794965E-01, 9.61655426E-02,
     &   5.04261119E-02, 3.41763165E-02, 2.58521420E-02, 2.07923978E-02,
     &   1.73917144E-02, 1.49490735E-02, 1.31096300E-02, 1.16745162E-02,
     &   1.05236262E-02, 9.58013742E-03, 9.46839211E-03, 8.68919756E-03,
     &   8.02911696E-03, 7.46277949E-03, 6.97154184E-03, 6.54139697E-03,
     &   6.16161728E-03, 5.82384789E-03, 5.52148508E-03, 5.24924028E-03,
     &   5.00282825E-03, 4.77873992E-03, 4.57407421E-03, 4.38641188E-03,
     &   4.21371948E-03, 4.05427536E-03, 3.90661216E-03, 3.76947151E-03,
     &   3.64176809E-03, 3.52256090E-03, 3.41103002E-03, 3.30645777E-03,
     &   3.20821323E-03, 3.11573951E-03, 3.02854323E-03, 2.94618569E-03,
     &   2.86827553E-03, 2.79446248E-03, 2.72443212E-03, 2.65790141E-03,
     &   2.59461486E-03, 2.53434129E-03, 2.47687095E-03, 2.42201315E-03,
     &   2.36959410E-03, 2.31945511E-03, 2.27145097E-03, 2.22544855E-03,
     &   2.18132556E-03, 2.13896949E-03, 2.09827664E-03, 2.05915127E-03,
     &   2.02150486E-03, 1.98525545E-03, 1.95032700E-03, 1.91664893E-03/
  
         DATA ((DGS  (I,J), I= 801, 900), J=2,2) /
     &   1.88415559E-03, 1.85278586E-03, 1.82248274E-03, 1.79319306E-03,
     &   1.76486711E-03, 1.73745839E-03, 1.71092335E-03, 1.68522117E-03,
     &   1.66031353E-03, 1.63616443E-03, 1.61274003E-03, 1.59000849E-03,
     &   1.56793978E-03, 1.54650564E-03, 1.52567935E-03, 1.50543572E-03,
     &   1.48575092E-03, 1.46660243E-03, 1.44796891E-03, 1.42983017E-03,
     &   1.41216707E-03, 1.39496145E-03, 1.37819608E-03, 1.36185461E-03,
     &   1.34592150E-03, 1.33038198E-03, 1.31522200E-03, 1.30042820E-03,
     &   1.28598788E-03, 1.27188891E-03, 1.25811978E-03, 1.24466952E-03,
     &   1.23152767E-03, 1.21868430E-03, 1.20612993E-03, 1.19385557E-03,
     &   1.18185266E-03, 1.17011308E-03, 1.15862915E-03, 1.14739362E-03,
     &   1.13639971E-03, 1.12564109E-03, 1.11511194E-03, 1.10480695E-03,
     &   1.09472160E-03, 1.08485201E-03, 1.07615141E-03, 1.06561487E-03,
     &   1.05621985E-03, 1.04700565E-03, 1.03796720E-03, 1.02909973E-03,
     &   1.02039860E-03, 1.01185937E-03, 1.00347773E-03, 9.95249618E-04,
     &   9.87170244E-04, 7.55681096E-04, 6.04276488E-04, 5.05261945E-04,
     &   4.99853829E-04, 4.90840304E-04, 5.39869699E-04, 5.78889566E-04,
     &   6.35274574E-04, 6.43628906E-04, 6.88222252E-04, 7.16327841E-04,
     &   7.21735088E-04, 7.99962152E-04, 9.13969073E-04, 9.61170842E-04,
     &   1.01653660E-03, 1.07401748E-03, 1.14209976E-03, 1.22018547E-03,
     &   1.31057199E-03, 1.41622638E-03, 1.54119639E-03, 1.69112420E-03,
     &   1.87410350E-03, 2.10219991E-03, 2.39411766E-03, 2.53503146E-03,
     &   2.69362629E-03, 2.87340964E-03, 3.07890944E-03, 3.31604264E-03,
     &   3.59266984E-03, 3.74900371E-03, 3.91952773E-03, 4.10625654E-03,
     &   4.31161257E-03, 4.53851880E-03, 4.79055073E-03, 5.07211473E-03,
     &   5.38871761E-03, 5.74732013E-03, 6.15686297E-03, 6.62901279E-03/
  
         DATA ((DGS  (I,J), I= 901,1000), J=2,2) /
     &   7.17929717E-03, 7.80061556E-03, 8.20738324E-03, 8.65875539E-03,
     &   9.16248772E-03, 9.72824468E-03, 1.03682239E-02, 1.10980449E-02,
     &   1.19380381E-02, 1.29151650E-02, 1.40659604E-02, 1.54411912E-02,
     &   1.71135282E-02, 1.91907709E-02, 2.18399583E-02, 2.53344450E-02,
     &   3.01542050E-02, 3.72254736E-02, 4.85912891E-02, 6.97816736E-02,
     &   1.03110075E-01, 1.22079263E-01, 1.42769849E-01, 1.93678354E-01,
     &   2.12019472E-01, 2.27156799E-01, 2.40011899E-01, 2.50836625E-01,
     &   2.59717757E-01, 2.67364883E-01, 2.73626390E-01, 2.78107758E-01,
     &   2.81914871E-01, 2.84609967E-01, 2.86208481E-01, 2.86785816E-01,
     &   2.86375831E-01, 2.85255556E-01, 2.82981981E-01, 2.80006898E-01,
     &   2.75996649E-01, 2.70836962E-01, 2.65411511E-01, 2.57810087E-01,
     &   2.50124885E-01, 2.41291845E-01, 2.31254279E-01, 2.17960448E-01,
     &   2.05172703E-01, 1.88610369E-01, 1.73015972E-01, 1.50280093E-01,
     &   1.25467415E-01, 8.84080891E-02, 5.61046634E-02, 1.88964699E-02,
     &   2.63164171E-04, 1.88021050E-02, 3.75272306E-02, 8.83186356E-02,
     &   1.25383410E-01, 1.50201003E-01, 1.72942424E-01, 1.88541291E-01,
     &   2.05109083E-01, 2.17901644E-01, 2.31201174E-01, 2.41243640E-01,
     &   2.50081546E-01, 2.57771546E-01, 2.65378442E-01, 2.70808448E-01,
     &   2.75973269E-01, 2.79988437E-01, 2.82968213E-01, 2.85246864E-01,
     &   2.86371331E-01, 2.86786364E-01, 2.86213706E-01, 2.84619975E-01,
     &   2.81929669E-01, 2.78127266E-01, 2.73650120E-01, 2.67393281E-01,
     &   2.59750739E-01, 2.50873976E-01, 2.40053667E-01, 2.27202925E-01,
     &   2.12069855E-01, 1.93732976E-01, 1.71502873E-01, 1.83571789E-01,
     &   1.57035041E-01, 1.40690036E-01, 1.30808385E-01, 1.10338147E-01,
     &   1.03177030E-01, 8.77615255E-02, 5.68260110E-02, 4.19283550E-02/
  
         DATA ((DGS  (I,J), I=1001,1100), J=2,2) /
     &   3.32013235E-02, 2.74765881E-02, 2.34345486E-02, 2.04292246E-02,
     &   1.81074750E-02, 1.62600758E-02, 1.47552306E-02, 1.35058048E-02,
     &   1.24518925E-02, 1.15509574E-02, 1.07719638E-02, 1.00917362E-02,
     &   9.49262089E-03, 8.96093476E-03, 8.48590805E-03, 8.05894811E-03,
     &   7.38402362E-03, 6.54156081E-03, 6.09098450E-03, 5.35470941E-03,
     &   4.77855031E-03, 4.21358921E-03, 3.41156818E-03, 2.52951381E-03,
     &   2.00839482E-03, 1.79178144E-03, 1.67074088E-03, 1.59201602E-03,
     &   1.53641496E-03, 1.49452497E-03, 1.46165517E-03, 1.43497784E-03,
     &   1.41267862E-03, 1.39365457E-03, 1.37709296E-03, 1.36242353E-03,
     &   1.34924882E-03, 1.33722813E-03, 1.32615265E-03, 1.31580428E-03,
     &   1.30600680E-03, 1.29671276E-03, 1.28775395E-03, 1.27903967E-03,
     &   1.27051990E-03, 1.26212029E-03, 1.25375745E-03, 1.24535594E-03,
     &   1.23684147E-03, 1.22815138E-03, 1.21917691E-03, 1.20980071E-03,
     &   1.19985169E-03, 1.18913013E-03, 1.17725814E-03, 1.16353762E-03,
     &   1.14622821E-03, 1.10731269E-03, 1.07414944E-03, 1.06284702E-03,
     &   1.05537821E-03, 1.04998366E-03, 1.04594247E-03, 1.04287648E-03,
     &   1.04054462E-03, 1.03875302E-03, 1.03737706E-03, 1.03629523E-03,
     &   1.03541406E-03, 1.03461294E-03, 1.03384143E-03, 1.03299532E-03,
     &   1.03184612E-03, 1.03065178E-03, 1.02896217E-03, 1.02686240E-03,
     &   1.02417327E-03, 1.02080497E-03, 1.01667907E-03, 1.01157311E-03,
     &   1.00542407E-03, 9.98058557E-04, 9.89188598E-04, 9.78470551E-04,
     &   9.66246091E-04, 9.51454219E-04, 9.33916553E-04, 9.12673159E-04,
     &   8.87256323E-04, 8.54653247E-04, 8.13437839E-04, 7.55976598E-04,
     &   7.39540185E-04, 6.90118112E-04, 6.21382997E-04, 6.14929492E-04,
     &   5.71469404E-04, 5.57213922E-04, 5.45734193E-04, 5.30538080E-04/
  
         DATA ((DGS  (I,J), I=1101,1200), J=2,2) /
     &   5.17419776E-04, 5.05319897E-04, 4.98245464E-04, 4.93962238E-04,
     &   4.83339633E-04, 4.72695751E-04, 4.63544830E-04, 4.54721236E-04,
     &   4.46544277E-04, 4.38751134E-04, 4.31218373E-04, 4.24151905E-04,
     &   4.17422807E-04, 4.11157877E-04, 4.04892947E-04, 3.98628017E-04,
     &   3.92837746E-04, 3.87073127E-04, 3.83170273E-04, 3.78333708E-04,
     &   3.77826089E-04, 3.73441026E-04, 3.70329535E-04, 3.64665188E-04,
     &   3.65866892E-04, 3.64379399E-04, 3.60163865E-04, 3.58792977E-04,
     &   3.53180566E-04, 3.52832318E-04, 3.48930715E-04, 3.49304831E-04,
     &   3.46918070E-04, 3.44216556E-04, 3.39060775E-04, 3.36388740E-04,
     &   3.32560145E-04, 3.32339952E-04, 3.29673429E-04, 3.29995010E-04,
     &   3.26641483E-04, 3.25626159E-04, 3.21473363E-04, 3.21623704E-04,
     &   3.23231752E-04, 3.22509986E-04, 3.17006450E-04, 3.14328610E-04,
     &   3.17513798E-04, 3.17133723E-04, 3.15995675E-04, 3.12482322E-04,
     &   3.11265073E-04, 3.11529969E-04, 3.07663387E-04, 3.07768801E-04,
     &   3.05891892E-04, 3.05657373E-04, 2.99938731E-04, 3.02391964E-04,
     &   3.02004736E-04, 3.03738719E-04, 3.01163847E-04, 3.01973608E-04,
     &   3.02357635E-04, 2.94814398E-04, 2.94173128E-04, 2.93724929E-04,
     &   2.93003559E-04, 2.90665897E-04, 2.90104726E-04, 2.91163872E-04,
     &   2.85354891E-04, 2.87192319E-04, 2.86944872E-04, 2.89008748E-04,
     &   2.86815159E-04, 2.87300774E-04, 2.85903120E-04, 2.90343629E-04,
     &   2.90849282E-04, 2.86641156E-04, 2.81513314E-04, 2.78433038E-04,
     &   2.93511943E-04, 2.96175747E-04, 2.92486852E-04, 2.80057316E-04,
     &   2.75836651E-04, 2.78591164E-04, 2.80770809E-04, 2.81388456E-04,
     &   2.79138120E-04, 2.66700370E-04, 2.68048198E-04, 2.69206291E-04,
     &   2.71490241E-04, 2.74003457E-04, 2.73952399E-04, 2.65465652E-04/
  
         DATA ((DGS  (I,J), I=1201,1300), J=2,2) /
     &   2.66783338E-04, 2.63624059E-04, 2.64659014E-04, 2.62620655E-04,
     &   2.63392791E-04, 2.62397920E-04, 2.66341238E-04, 2.67332933E-04,
     &   2.76495226E-04, 2.72542738E-04, 2.73668053E-04, 2.79462655E-04,
     &   2.70477388E-04, 2.76036342E-04, 2.84834638E-04, 3.18167141E-04,
     &   2.99383093E-04, 3.08432583E-04, 3.17071148E-04, 2.95013510E-04,
     &   2.99312095E-04, 3.03582677E-04, 3.40360020E-04, 3.45062787E-04,
     &   4.13419863E-04, 4.19858751E-04, 5.46393883E-04, 6.87447909E-04,
     &   9.20537231E-04, 1.16819464E-03, 7.83143577E-04, 4.43392642E-04,
     &   3.30142330E-04, 2.56331273E-04, 1.99937971E-04, 1.85730456E-04,
     &   1.75452373E-04, 1.61417017E-04, 1.52113157E-04, 1.48497726E-04,
     &   1.45363101E-04, 1.42608560E-04, 1.40160541E-04, 1.37964058E-04,
     &   1.35970328E-04, 1.34160078E-04, 1.32501174E-04, 1.30973057E-04,
     &   1.29559065E-04, 1.28245546E-04, 1.27021192E-04, 1.25876554E-04,
     &   1.24803670E-04, 1.23795781E-04, 1.22847110E-04, 1.21952694E-04,
     &   1.21108242E-04, 1.20310036E-04, 1.19554838E-04, 1.18839823E-04,
     &   1.18162520E-04, 1.17520770E-04, 1.16912686E-04, 1.16336624E-04,
     &   1.15791154E-04, 1.15275045E-04, 1.14787244E-04, 1.14326867E-04,
     &   1.13893186E-04, 1.13485623E-04, 1.13103744E-04, 1.12747259E-04,
     &   1.12416020E-04, 1.12169196E-04, 1.11829401E-04, 1.11345655E-04,
     &   1.10969180E-04, 1.10707438E-04, 1.10571635E-04, 1.10577742E-04,
     &   1.10748019E-04, 1.11113293E-04, 1.11716458E-04, 1.12617981E-04,
     &   1.13904880E-04, 1.15708674E-04, 1.18221049E-04, 1.21767189E-04,
     &   1.26906067E-04, 1.27541680E-04, 1.34706611E-04, 1.47509473E-04,
     &   1.71592916E-04, 2.12987694E-04, 2.30583090E-04, 3.05756275E-04,
     &   4.50627809E-04, 5.18624184E-04, 6.14679068E-04, 6.79072514E-04/
  
         DATA ((DGS  (I,J), I=1301,1400), J=2,2) /
     &   7.59815374E-04, 8.40735513E-04, 9.42022085E-04, 1.00282783E-03,
     &   1.07232635E-03, 1.15250297E-03, 1.24599669E-03, 1.35639328E-03,
     &   1.48869169E-03, 1.56518286E-03, 1.65007630E-03, 1.74482950E-03,
     &   1.85125764E-03, 1.97165048E-03, 2.10893823E-03, 2.26693240E-03,
     &   2.45068398E-03, 2.66703190E-03, 2.75713370E-03, 2.81366418E-03,
     &   2.87256972E-03, 2.93400296E-03, 2.99812991E-03, 3.06513142E-03,
     &   3.13520492E-03, 3.20856634E-03, 3.28545233E-03, 3.36612280E-03,
     &   3.45086387E-03, 3.53999123E-03, 3.63385410E-03, 3.73283975E-03,
     &   3.83737890E-03, 3.94795191E-03, 4.06509620E-03, 4.18941496E-03,
     &   4.32158752E-03, 4.46238178E-03, 4.61266912E-03, 4.77344242E-03,
     &   4.94583802E-03, 5.13116261E-03, 5.33092636E-03, 5.54688417E-03,
     &   5.78108730E-03, 6.03594873E-03, 6.31432651E-03, 6.61963139E-03,
     &   6.95596715E-03, 7.32831610E-03, 7.74278737E-03, 8.20695462E-03,
     &   8.73032280E-03, 9.32498567E-03, 1.00065714E-02, 1.07956355E-02,
     &   1.17197687E-02, 1.28168874E-02, 1.41405628E-02, 1.57690275E-02,
     &   1.78212085E-02, 2.04871319E-02, 2.40903630E-02, 2.92302126E-02,
     &   3.71545854E-02, 5.09602847E-02, 8.10022085E-02, 9.96285600E-02,
     &   1.89762118E-01, 2.64040682E-01, 3.17881296E-01, 3.59540812E-01,
     &   3.93769198E-01, 4.23722793E-01, 4.51515555E-01, 4.70863805E-01,
     &   4.90558831E-01, 5.09928715E-01, 5.19267845E-01, 5.32356452E-01,
     &   5.40198993E-01, 5.49933660E-01, 5.52470564E-01, 5.56222971E-01,
     &   5.57782395E-01, 5.56607109E-01, 5.54813803E-01, 5.52106410E-01,
     &   5.43532597E-01, 5.37520140E-01, 5.30130541E-01, 5.11091152E-01,
     &   4.99270896E-01, 4.85761672E-01, 4.70305141E-01, 4.34062625E-01,
     &   4.12777862E-01, 3.89703265E-01, 3.37252780E-01, 3.08218881E-01/
  
         DATA ((DGS  (I,J), I=1401,1500), J=2,2) /
     &   2.44325404E-01, 1.73984688E-01, 1.85756358E-02, 1.71674405E-01,
     &   2.42195609E-01, 3.05994292E-01, 3.62683712E-01, 3.88169611E-01,
     &   4.11371663E-01, 4.32571458E-01, 4.69270473E-01, 4.84691088E-01,
     &   4.98463284E-01, 5.10388044E-01, 5.29618829E-01, 5.37024063E-01,
     &   5.43186593E-01, 5.51866700E-01, 5.54669566E-01, 5.57532466E-01,
     &   5.57790189E-01, 5.56308749E-01, 5.52642718E-01, 5.47215909E-01,
     &   5.40432993E-01, 5.32618748E-01, 5.19558735E-01, 5.10281207E-01,
     &   4.90872798E-01, 4.71228888E-01, 4.51821986E-01, 4.24011243E-01,
     &   3.94032437E-01, 3.59771575E-01, 3.18070994E-01, 2.64179359E-01,
     &   1.88745630E-01, 1.03015495E-01, 5.89225462E-02, 4.12257148E-02,
     &   3.16977502E-02, 2.57456681E-02, 2.16751346E-02, 1.87159682E-02,
     &   1.64677863E-02, 1.47018804E-02, 1.32781236E-02, 1.21058759E-02,
     &   1.11239121E-02, 1.02893864E-02, 9.57141715E-03, 8.94718392E-03,
     &   8.39945826E-03, 7.91498987E-03, 7.48342108E-03, 7.09653836E-03,
     &   6.74774486E-03, 6.43168127E-03, 6.14394866E-03, 5.88090257E-03,
     &   5.63949794E-03, 5.41717070E-03, 5.21174646E-03, 5.02136918E-03,
     &   4.84444495E-03, 4.67959730E-03, 4.52563137E-03, 4.38150488E-03,
     &   4.24630453E-03, 4.11922670E-03, 3.99956138E-03, 3.88667900E-03,
     &   3.78001933E-03, 3.67908215E-03, 3.58341950E-03, 3.49262896E-03,
     &   3.40634805E-03, 3.32424936E-03, 3.24603644E-03, 3.17144023E-03,
     &   3.10021592E-03, 3.03214032E-03, 2.96700953E-03, 2.90463687E-03,
     &   2.84485111E-03, 2.78749492E-03, 2.73242348E-03, 2.31700955E-03,
     &   2.06229276E-03, 1.81796388E-03, 1.54499639E-03, 1.28941142E-03,
     &   1.03699409E-03, 8.94271315E-04, 7.07663131E-04, 6.44197255E-04,
     &   5.94768725E-04, 5.55171073E-04, 5.21118706E-04, 4.95752600E-04/
  
         DATA ((DGS  (I,J), I=1501,1600), J=2,2) /
     &   4.61689317E-04, 4.27887892E-04, 3.90886172E-04, 4.05088346E-04,
     &   4.49454276E-04, 6.07534274E-04, 9.13092036E-04, 1.34731543E-03,
     &   1.93915640E-03, 2.76369856E-03, 4.84123383E-03, 5.23580066E-03,
     &   5.70059242E-03, 5.83530187E-03, 6.14237971E-03, 6.48361338E-03,
     &   6.86502724E-03, 7.29415121E-03, 7.78052700E-03, 8.33642124E-03,
     &   8.97787359E-03, 9.72627791E-03, 1.06107963E-02, 1.16722665E-02,
     &   1.29696655E-02, 1.45914671E-02, 1.66766896E-02, 1.94570302E-02,
     &   2.33494970E-02, 2.91880908E-02, 3.89184108E-02, 5.83748806E-02,
     &   8.44743034E-02, 8.88550562E-02, 9.37147111E-02, 9.91362874E-02,
     &   1.05223156E-01, 1.12105679E-01, 1.19950622E-01, 1.28974805E-01,
     &   1.39465378E-01, 1.51810809E-01, 1.66549807E-01, 1.84451556E-01,
     &   2.06653342E-01, 2.34909793E-01, 2.72075161E-01, 3.23117630E-01,
     &   3.97494956E-01, 5.15580707E-01, 7.29878088E-01, 1.21467778E+00,
     &   1.38462590E+00, 1.51838797E+00, 1.66747746E+00, 1.79259934E+00,
     &   1.88283469E+00, 1.95936485E+00, 1.99462694E+00, 2.00862704E+00,
     &   1.99101833E+00, 1.92862284E+00, 1.85678384E+00, 1.84319008E+00,
     &   1.83612298E+00, 1.82143850E+00, 1.81535653E+00, 1.81071607E+00,
     &   1.80600745E+00, 1.75508471E+00, 1.66501160E+00, 1.54448620E+00,
     &   1.41678739E+00, 1.25321818E+00, 1.06736025E+00, 8.82339652E-01,
     &   7.73006713E-01, 6.59543111E-01, 5.42461816E-01, 3.73578426E-01,
     &   2.50269495E-01, 1.25508062E-01, 5.02526791E-02, 2.51366500E-02,
     &   1.25770074E-02, 2.53097361E-04, 1.25513778E-02, 2.51110181E-02,
     &   1.25482483E-01, 2.50244084E-01, 3.73553293E-01, 9.24792008E-01,
     &   1.12536352E+00, 1.44674561E+00, 1.57035247E+00, 1.68648349E+00,
     &   1.78141686E+00, 1.85006716E+00, 1.90942726E+00, 1.94923281E+00/
  
         DATA ((DGS  (I,J), I=1601,1700), J=2,2) /
     &   1.98018789E+00, 1.99765957E+00, 2.00720829E+00, 2.00825742E+00,
     &   2.00241715E+00, 1.99191391E+00, 1.95719674E+00, 1.93379768E+00,
     &   1.90785498E+00, 1.88284212E+00, 1.82653417E+00, 1.79571731E+00,
     &   1.74566664E+00, 1.66748897E+00, 1.38464046E+00, 1.16552628E+00,
     &   9.99612825E-01, 8.72156307E-01, 7.72112303E-01, 6.91901549E-01,
     &   6.11812201E-01, 4.86767619E-01, 4.52929076E-01, 4.23437227E-01,
     &   3.97513864E-01, 3.58988800E-01, 2.97137805E-01, 2.53393161E-01,
     &   2.20841459E-01, 1.95683454E-01, 1.75661441E-01, 1.59350625E-01,
     &   1.45807954E-01, 1.34384604E-01, 1.24619641E-01, 1.16176655E-01,
     &   1.08804400E-01, 1.02311462E-01, 9.65494639E-02, 9.14016153E-02,
     &   8.67747387E-02, 5.83940961E-02, 3.89376264E-02, 2.92073006E-02,
     &   1.94762229E-02, 1.46106866E-02, 1.16915324E-02, 9.74561058E-03,
     &   8.35579480E-03, 7.31356933E-03, 6.50308501E-03, 5.85483756E-03,
     &   5.48718153E-03, 5.05822102E-03, 4.69179654E-03, 4.37518708E-03,
     &   4.09891270E-03, 3.85576470E-03, 2.97638031E-03, 2.42748148E-03,
     &   2.05369146E-03, 1.78384941E-03, 1.58173455E-03, 1.42793634E-03,
     &   1.29901210E-03, 1.19330931E-03, 5.75292311E-04, 5.52297925E-04,
     &   5.77712317E-04, 5.92021153E-04, 6.27613618E-04, 6.90120099E-04,
     &   7.27174253E-04, 7.80194775E-04, 9.17422346E-04, 1.14766281E-03,
     &   1.57142307E-03, 2.57566168E-03, 3.54902479E-03, 3.80119285E-03,
     &   4.09230114E-03, 4.43206835E-03, 4.83375929E-03, 5.31596054E-03,
     &   5.90549117E-03, 6.64260537E-03, 7.59055785E-03, 8.85468588E-03,
     &   1.06248373E-02, 1.32805279E-02, 1.77071170E-02, 1.84770189E-02,
     &   1.93168234E-02, 2.02367118E-02, 2.12485943E-02, 2.23668674E-02,
     &   2.36095247E-02, 2.49983774E-02, 2.65606522E-02, 2.83314015E-02/
  
         DATA ((DGS  (I,J), I=1701,1800), J=2,2) /
     &   3.03550953E-02, 3.26898182E-02, 3.54138766E-02, 3.86331180E-02,
     &   4.24955752E-02, 4.72165252E-02, 4.86916919E-02, 5.31171781E-02,
     &   6.07017739E-02, 7.08134114E-02, 8.49648601E-02, 1.06179077E-01,
     &   1.41486746E-01, 2.11875508E-01, 4.19921661E-01, 4.99232389E-01,
     &   7.04156556E-01, 8.59997247E-01, 9.88403583E-01, 1.10047796E+00,
     &   1.19991066E+00, 1.28911141E+00, 1.36878974E+00, 1.44264338E+00,
     &   1.51238926E+00, 1.57612927E+00, 1.63219608E+00, 1.68405852E+00,
     &   1.73081857E+00, 1.77177474E+00, 1.81068630E+00, 1.84255961E+00,
     &   1.86744951E+00, 1.88858172E+00, 1.90484719E+00, 1.91492310E+00,
     &   1.91745806E+00, 1.91317497E+00, 1.90080605E+00, 1.87895057E+00,
     &   1.84609179E+00, 1.80915080E+00, 1.75193655E+00, 1.67915280E+00,
     &   1.58931978E+00, 1.46134008E+00, 1.30722226E+00, 1.09886754E+00,
     &   8.25840918E-01, 1.13146948E-01, 2.95442685E-04, 3.73830178E-01,
     &   8.25827500E-01, 1.09885548E+00, 1.30721162E+00, 1.46133076E+00,
     &   1.58931182E+00, 1.67914601E+00, 1.75193088E+00, 1.80914623E+00,
     &   1.84608809E+00, 1.87894787E+00, 1.90080428E+00, 1.91317408E+00,
     &   1.91745798E+00, 1.91492378E+00, 1.90484867E+00, 1.88858394E+00,
     &   1.86745240E+00, 1.84256312E+00, 1.81069043E+00, 1.77177951E+00,
     &   1.73082389E+00, 1.68406439E+00, 1.63220247E+00, 1.57613616E+00,
     &   1.51239665E+00, 1.44265124E+00, 1.36879804E+00, 1.28912013E+00,
     &   1.19991978E+00, 1.10048748E+00, 9.88413486E-01, 8.60007515E-01,
     &   7.04167177E-01, 4.99243351E-01, 4.27484873E-01, 4.14025929E-01,
     &   3.97331458E-01, 3.51222443E-01, 3.09667402E-01, 2.11875252E-01,
     &   1.41498007E-01, 1.06187457E-01, 8.49742837E-02, 7.08246884E-02,
     &   6.07130509E-02, 5.31277303E-02, 4.72278000E-02, 4.25068481E-02/
  
         DATA ((DGS  (I,J), I=1801,1900), J=2,2) /
     &   3.86440055E-02, 3.54251448E-02, 3.27010836E-02, 3.03661210E-02,
     &   2.83426602E-02, 2.65719071E-02, 1.77183331E-02, 1.32916900E-02,
     &   1.06359280E-02, 8.86569104E-03, 7.60143829E-03, 6.65339950E-03,
     &   5.91620574E-03, 4.84431695E-03, 4.10271764E-03, 3.81150229E-03,
     &   3.55918709E-03, 2.65347226E-03, 1.99345688E-03, 1.60163855E-03,
     &   1.34305231E-03, 1.16010243E-03, 1.02431201E-03, 9.19902678E-04,
     &   8.37456914E-04, 7.71010491E-04, 7.16649261E-04, 6.71688186E-04,
     &   6.34211898E-04, 6.02863687E-04, 5.76687759E-04, 5.55043379E-04,
     &   5.37575383E-04, 5.24251277E-04, 5.15521927E-04, 5.12806303E-04,
     &   5.11456405E-04, 4.99657401E-04, 5.04456349E-04, 5.93988729E-04,
     &   6.15104101E-04, 6.78443151E-04, 7.36708777E-04, 7.85810517E-04,
     &   8.29983331E-04, 8.67284660E-04, 8.99851941E-04, 9.27719850E-04,
     &   9.50776681E-04, 9.70100765E-04, 9.85554155E-04, 9.97021674E-04,
     &   1.00510511E-03, 1.00986395E-03, 1.01102371E-03, 1.00909779E-03,
     &   1.00397314E-03, 9.95376129E-04, 9.83710711E-04, 9.69183846E-04,
     &   9.50711912E-04, 9.29587476E-04, 9.04537465E-04, 8.75908970E-04,
     &   8.43145434E-04, 8.06121042E-04, 7.64833011E-04, 7.19503959E-04,
     &   6.66914501E-04, 6.08393999E-04, 5.43600439E-04, 4.68835367E-04,
     &   3.86255290E-04, 3.42654618E-04, 5.20626824E-04, 6.12792764E-04,
     &   6.83517071E-04, 7.39898390E-04, 7.88024008E-04, 8.29362282E-04,
     &   8.63615357E-04, 8.93706168E-04, 9.19707822E-04, 9.41838634E-04,
     &   9.60376321E-04, 9.75769288E-04, 9.87977687E-04, 9.97789654E-04,
     &   1.00452569E-03, 1.00885563E-03, 1.01069144E-03, 1.00979716E-03,
     &   1.00640139E-03, 1.00052818E-03, 9.91708776E-04, 9.80318612E-04,
     &   9.66274124E-04, 9.48192264E-04, 9.27900399E-04, 9.05197620E-04/
  
         DATA ((DGS  (I,J), I=1901,2000), J=2,2) /
     &   8.77409243E-04, 8.45986989E-04, 8.10807752E-04, 7.69302534E-04,
     &   7.24483143E-04, 6.71152552E-04, 6.16506462E-04, 5.44146512E-04,
     &   4.76393765E-04, 4.72762209E-04, 4.17800059E-04, 4.01432843E-04,
     &   3.98192307E-04, 3.94204985E-04, 3.82999384E-04, 3.75670998E-04,
     &   3.73011679E-04, 3.71611298E-04, 3.70919773E-04, 3.69542901E-04,
     &   3.67534339E-04, 3.66597394E-04, 3.65363510E-04, 3.65086622E-04,
     &   3.64860774E-04, 3.63341545E-04, 3.62267278E-04, 3.60675606E-04,
     &   3.59320130E-04, 3.58113473E-04, 3.56880316E-04, 3.54627936E-04,
     &   3.52387823E-04, 3.50155585E-04, 3.47882793E-04, 3.45662807E-04,
     &   3.43646667E-04, 3.42209892E-04, 3.39203950E-04, 3.36687562E-04,
     &   3.37300525E-04, 3.22101705E-04, 3.08789240E-04, 3.03305548E-04,
     &   2.80289979E-04, 3.01776274E-04, 3.12869865E-04, 3.18354493E-04,
     &   3.29138004E-04, 3.37381422E-04, 3.38459832E-04, 3.40709393E-04,
     &   3.44069728E-04, 3.46371074E-04, 3.48878427E-04, 3.51689472E-04,
     &   3.54611590E-04, 3.57573731E-04, 3.60520302E-04, 3.63492520E-04,
     &   3.66424090E-04, 3.69425345E-04, 3.72523378E-04, 3.75773914E-04,
     &   3.78632011E-04, 3.81369366E-04, 3.84474153E-04, 3.88023175E-04,
     &   3.92222720E-04, 3.96723676E-04, 4.00901885E-04, 4.05492008E-04,
     &   4.11707193E-04, 4.20215593E-04, 4.31219077E-04, 4.45872286E-04,
     &   4.66339380E-04, 4.66729116E-04, 4.50873360E-04, 4.31587231E-04,
     &   4.33656698E-04, 4.40824385E-04, 4.47777141E-04, 4.54525422E-04,
     &   4.60885430E-04, 4.66826822E-04, 4.72520146E-04, 4.77990166E-04,
     &   4.83272437E-04, 4.73137432E-04, 4.63114483E-04, 4.54572855E-04,
     &   4.47230306E-04, 4.40649800E-04, 4.34579982E-04, 4.29128042E-04,
     &   4.24239834E-04, 4.19746660E-04, 4.15586338E-04, 4.11509650E-04/
  
         DATA ((DGS  (I,J), I=2001,2100), J=2,2) /
     &   4.07505549E-04, 4.03797289E-04, 4.00480075E-04, 3.97023394E-04,
     &   3.93533281E-04, 3.91073540E-04, 3.87118693E-04, 3.85312133E-04,
     &   3.77319644E-04, 3.69728355E-04, 3.63723277E-04, 3.60573207E-04,
     &   3.51165719E-04, 3.40745339E-04, 3.34294210E-04, 3.26071738E-04,
     &   3.33836254E-04, 3.40188086E-04, 3.50541635E-04, 3.59961992E-04,
     &   3.63129188E-04, 3.69202234E-04, 3.76904093E-04, 3.85012791E-04,
     &   3.86793797E-04, 3.90773593E-04, 3.93184817E-04, 3.96608020E-04,
     &   3.99996993E-04, 4.03198483E-04, 4.06764328E-04, 4.10575946E-04,
     &   4.14383030E-04, 4.18127665E-04, 4.22224560E-04, 4.26558786E-04,
     &   4.31315154E-04, 4.36521746E-04, 4.41988244E-04, 4.47894419E-04,
     &   4.54630726E-04, 4.62363008E-04, 4.70497673E-04, 4.71952680E-04,
     &   4.74904893E-04, 4.79842293E-04, 4.87549427E-04, 4.98865855E-04,
     &   5.09865311E-04, 5.04302867E-04, 4.98714063E-04, 4.73390184E-04,
     &   5.14713113E-04, 5.42078531E-04, 5.51571009E-04, 5.58663167E-04,
     &   5.64886761E-04, 5.71478209E-04, 5.78414222E-04, 5.84835661E-04,
     &   5.91095023E-04, 5.96171799E-04, 6.01946596E-04, 6.07217537E-04,
     &   3.89441707E-04, 1.71665877E-04, 1.64782465E-04, 1.58951604E-04,
     &   1.54326529E-04, 1.50238148E-04, 1.46880428E-04, 1.43825845E-04,
     &   1.41255533E-04, 1.38868508E-04, 1.36735695E-04, 1.34895116E-04,
     &   1.33147752E-04, 1.31621565E-04, 1.30157120E-04, 1.28865736E-04,
     &   1.27615899E-04, 1.26505150E-04, 1.25422531E-04, 1.24454180E-04,
     &   1.23504790E-04, 1.22651006E-04, 1.21845326E-04, 1.21049779E-04,
     &   1.20329615E-04, 1.19615697E-04, 1.18967048E-04, 1.18321819E-04,
     &   1.17733697E-04, 1.17146919E-04, 1.16610567E-04, 1.16074023E-04,
     &   1.15582363E-04, 1.15089370E-04, 1.14616449E-04, 1.14181669E-04/
  
         DATA ((DGS  (I,J), I=2101,2180), J=2,2) /
     &   1.13744360E-04, 1.13341559E-04, 1.12935686E-04, 1.12561200E-04,
     &   1.12183243E-04, 1.11833972E-04, 1.11480940E-04, 1.11154238E-04,
     &   1.10823568E-04, 1.10517163E-04, 1.10219948E-04, 1.09918575E-04,
     &   1.09638828E-04, 1.09354853E-04, 1.09090973E-04, 1.08822830E-04,
     &   1.08573415E-04, 1.08319730E-04, 1.08083547E-04, 1.07843105E-04,
     &   1.07619059E-04, 1.07390784E-04, 1.07168352E-04, 1.06960839E-04,
     &   1.06749165E-04, 1.06487123E-04, 1.06285161E-04, 1.06096495E-04,
     &   1.05903799E-04, 1.05723670E-04, 1.05539574E-04, 1.05367377E-04,
     &   1.05191280E-04, 1.05026467E-04, 1.04857825E-04, 1.04699900E-04,
     &   1.04545175E-04, 1.04386728E-04, 1.04238235E-04, 1.04086091E-04,
     &   1.03943435E-04, 1.03797201E-04, 1.03660022E-04, 1.03519338E-04,
     &   1.03387305E-04, 1.03251841E-04, 1.03124652E-04, 1.02994102E-04,
     &   1.01716385E-04, 1.00649736E-04, 1.00495005E-04, 9.58350042E-05,
     &   9.45638143E-05, 9.23338549E-05, 9.15000795E-05, 9.14648265E-05,
     &   9.06444130E-05, 9.06422073E-05, 9.01763623E-05, 9.01606091E-05,
     &   9.01512501E-05, 8.99589675E-05, 8.98421231E-05, 8.98220543E-05,
     &   8.97898090E-05, 8.97432489E-05, 8.97112554E-05, 8.96915137E-05,
     &   8.95131206E-05, 8.95046884E-05, 8.94565699E-05, 8.94478967E-05,
     &   8.94095931E-05, 8.93947683E-05, 8.93831055E-05, 8.93723272E-05,
     &   8.93415532E-05, 8.92982758E-05, 8.92803923E-05, 8.91693110E-05/
  
         DATA ((DGS  (I,J), I=   1, 100), J=3,3) /
     &   9.60702712E-06, 1.02171459E-05, 1.08959142E-05, 1.16829418E-05,
     &   1.26504028E-05, 1.32394818E-05, 1.45227577E-05, 1.53947766E-05,
     &   1.58266801E-05, 1.67130765E-05, 1.65631530E-05, 1.64075635E-05,
     &   1.62397466E-05, 1.60996224E-05, 1.59839002E-05, 1.59321493E-05,
     &   1.61259274E-05, 1.64177671E-05, 1.67537316E-05, 1.72586385E-05,
     &   1.76329284E-05, 1.80255113E-05, 1.82903824E-05, 1.87661328E-05,
     &   1.91850041E-05, 1.95727693E-05, 2.01084787E-05, 2.04228639E-05,
     &   2.05874136E-05, 2.11257475E-05, 2.16660548E-05, 2.22033006E-05,
     &   2.27779223E-05, 2.33073403E-05, 2.38283123E-05, 2.43483864E-05,
     &   2.48668156E-05, 2.54124580E-05, 2.60118683E-05, 2.66663858E-05,
     &   2.71835034E-05, 2.79076800E-05, 2.87079533E-05, 2.93627841E-05,
     &   3.03184176E-05, 3.13488075E-05, 3.21408028E-05, 3.31751724E-05,
     &   3.40142498E-05, 3.51610355E-05, 4.12821545E-05, 4.31228141E-05,
     &   4.17471099E-05, 3.94781426E-05, 4.01090750E-05, 4.05679131E-05,
     &   4.19392492E-05, 4.48091685E-05, 4.84918024E-05, 5.19358037E-05,
     &   5.53118532E-05, 5.65013273E-05, 5.84722326E-05, 6.18007246E-05,
     &   6.46974676E-05, 6.75080592E-05, 6.91965865E-05, 7.04241463E-05,
     &   7.09114394E-05, 7.15997682E-05, 7.18528478E-05, 7.09821274E-05,
     &   7.10578043E-05, 7.09767207E-05, 6.95357946E-05, 6.84769099E-05,
     &   6.62337635E-05, 6.42713797E-05, 6.29428804E-05, 6.32184810E-05,
     &   6.21687923E-05, 6.17706371E-05, 6.23837987E-05, 6.38548883E-05,
     &   6.82829975E-05, 7.71262449E-05, 8.42213496E-05, 8.69764960E-05,
     &   8.87735987E-05, 8.90653001E-05, 8.80619115E-05, 9.12055525E-05,
     &   9.39219537E-05, 1.00154678E-04, 1.07763596E-04, 1.18987695E-04,
     &   1.07007356E-04, 9.48473123E-05, 7.79550344E-05, 6.80772688E-05/
  
         DATA ((DGS  (I,J), I= 101, 200), J=3,3) /
     &   6.10464859E-05, 6.17349810E-05, 6.80636210E-05, 7.79156655E-05,
     &   8.80181677E-05, 9.77224042E-05, 1.07233522E-04, 1.16551520E-04,
     &   1.24206624E-04, 1.30863866E-04, 1.36535284E-04, 1.38313684E-04,
     &   1.40146526E-04, 1.42079175E-04, 1.41216263E-04, 1.37808180E-04,
     &   1.30801880E-04, 1.06332828E-04, 8.39874183E-05, 7.68406699E-05,
     &   7.29628943E-05, 7.06936098E-05, 7.04422307E-05, 7.09113662E-05,
     &   7.24962299E-05, 7.57910174E-05, 8.07872940E-05, 8.77251354E-05,
     &   9.78843739E-05, 1.10845885E-04, 1.25947017E-04, 1.43192712E-04,
     &   1.62115198E-04, 1.81674103E-04, 2.00569616E-04, 2.16875862E-04,
     &   2.27140600E-04, 2.26260530E-04, 2.12682507E-04, 2.01016461E-04,
     &   1.99233927E-04, 1.93711770E-04, 1.88906219E-04, 1.80189441E-04,
     &   1.72531172E-04, 1.64803692E-04, 1.55919635E-04, 1.47116822E-04,
     &   1.41102730E-04, 1.39002228E-04, 1.39065660E-04, 1.41039209E-04,
     &   1.41577864E-04, 1.37900010E-04, 1.34222156E-04, 1.30280448E-04,
     &   1.28962897E-04, 1.25985219E-04, 1.27485201E-04, 1.16896459E-04,
     &   1.20614930E-04, 1.25232925E-04, 1.26176291E-04, 1.25817235E-04,
     &   1.25194805E-04, 1.23581997E-04, 1.21109329E-04, 1.19901356E-04,
     &   1.14395310E-04, 1.13113649E-04, 1.15013054E-04, 1.18736542E-04,
     &   1.25345318E-04, 1.30752756E-04, 1.34624379E-04, 1.36890194E-04,
     &   1.38185728E-04, 1.39635277E-04, 1.41769897E-04, 1.43690382E-04,
     &   1.48041049E-04, 1.50409713E-04, 1.57460923E-04, 1.64305462E-04,
     &   1.72916854E-04, 1.80792897E-04, 1.91496920E-04, 2.01952603E-04,
     &   2.14015926E-04, 2.31675332E-04, 2.41821770E-04, 2.49322245E-04,
     &   2.65667209E-04, 2.74724764E-04, 2.87951542E-04, 2.99094653E-04,
     &   3.08570412E-04, 3.18832775E-04, 3.30963189E-04, 3.61328572E-04/
  
         DATA ((DGS  (I,J), I= 201, 300), J=3,3) /
     &   3.99377683E-04, 4.20591832E-04, 4.28322186E-04, 4.36290539E-04,
     &   4.44453090E-04, 4.52949477E-04, 4.61757309E-04, 4.70922099E-04,
     &   4.80502207E-04, 4.90560265E-04, 5.01160879E-04, 5.12354891E-04,
     &   5.24192385E-04, 5.36722584E-04, 5.49992679E-04, 5.64036338E-04,
     &   5.78889602E-04, 5.94695946E-04, 6.11530415E-04, 6.29484947E-04,
     &   6.48671794E-04, 6.69226769E-04, 6.91317735E-04, 7.15162720E-04,
     &   7.41065487E-04, 7.69473580E-04, 8.01107932E-04, 8.37289489E-04,
     &   8.81052304E-04, 9.44377125E-04, 9.99609155E-04, 9.97627740E-04,
     &   9.92404009E-04, 9.40169676E-04, 1.01454419E-03, 1.04401052E-03,
     &   1.08017383E-03, 1.12238189E-03, 1.06434041E-03, 1.17987641E-03,
     &   1.30688661E-03, 1.37699245E-03, 1.31912284E-03, 1.49923839E-03,
     &   1.67935394E-03, 1.84103594E-03, 2.04875684E-03, 2.28500701E-03,
     &   2.46656965E-03, 2.59674547E-03, 2.65274730E-03, 2.63478208E-03,
     &   2.61392735E-03, 2.70102104E-03, 2.76915930E-03, 2.87990061E-03,
     &   3.08716441E-03, 3.33230389E-03, 3.44828635E-03, 3.62951116E-03,
     &   3.71579250E-03, 3.75525552E-03, 3.89674422E-03, 4.05877796E-03,
     &   4.09791898E-03, 4.21245084E-03, 4.26218172E-03, 3.78071846E-03,
     &   3.27198603E-03, 2.81786679E-03, 2.40742984E-03, 1.45089347E-03,
     &   2.03756313E-04, 1.65327240E-03, 2.77318823E-03, 3.17511462E-03,
     &   3.15516590E-03, 3.17778755E-03, 3.20670023E-03, 3.23651137E-03,
     &   3.18040724E-03, 3.10499075E-03, 3.09258035E-03, 3.13278834E-03,
     &   3.18287770E-03, 3.18876670E-03, 3.20370834E-03, 3.16082301E-03,
     &   3.17703892E-03, 3.40990464E-03, 3.66523466E-03, 3.75542817E-03,
     &   3.72100515E-03, 3.68360286E-03, 3.38481649E-03, 3.09151646E-03,
     &   2.88842135E-03, 2.76229904E-03, 2.66867694E-03, 2.60032386E-03/
  
         DATA ((DGS  (I,J), I= 301, 400), J=3,3) /
     &   2.90758363E-03, 2.50347873E-03, 2.46416364E-03, 2.57922590E-03,
     &   2.32184842E-03, 2.20554746E-03, 2.08796813E-03, 1.73300817E-03,
     &   1.70592812E-03, 1.57541320E-03, 1.49433301E-03, 1.41300592E-03,
     &   1.35057008E-03, 1.30003173E-03, 1.24857801E-03, 1.18718959E-03,
     &   1.15063132E-03, 1.13391382E-03, 1.11128534E-03, 1.08769643E-03,
     &   1.06728501E-03, 1.04739481E-03, 1.02771556E-03, 1.02427634E-03,
     &   9.94459793E-04, 1.24917592E-03, 1.24257946E-03, 1.00460607E-03,
     &   9.27490786E-04, 8.81010554E-04, 8.45167559E-04, 8.15445863E-04,
     &   7.89574531E-04, 7.66638121E-04, 7.45195920E-04, 7.25031335E-04,
     &   7.10028682E-04, 6.94216166E-04, 6.79603186E-04, 6.66061843E-04,
     &   6.53475796E-04, 6.29503409E-04, 6.18644074E-04, 6.08328900E-04,
     &   5.98520898E-04, 5.89131857E-04, 5.80204844E-04, 5.71685555E-04,
     &   5.63495268E-04, 5.55653199E-04, 5.48126142E-04, 5.40887805E-04,
     &   5.33929005E-04, 5.27233742E-04, 5.20785670E-04, 5.14714606E-04,
     &   4.89483941E-04, 4.37514757E-04, 3.64425388E-04, 3.16594578E-04,
     &   2.82499870E-04, 2.56988106E-04, 2.37305799E-04, 2.21881361E-04,
     &   2.10264611E-04, 2.09253638E-04, 1.97307695E-04, 1.90505583E-04,
     &   1.88577057E-04, 1.85216614E-04, 1.83806997E-04, 1.83759168E-04,
     &   1.83534592E-04, 1.82795871E-04, 1.82461259E-04, 1.82722123E-04,
     &   1.84271913E-04, 1.86590274E-04, 1.89562719E-04, 1.91694602E-04,
     &   1.93708803E-04, 1.95221633E-04, 1.99580619E-04, 2.04768675E-04,
     &   2.05311280E-04, 2.10750766E-04, 2.18670484E-04, 2.23552110E-04,
     &   2.28954414E-04, 2.40886875E-04, 2.54859370E-04, 2.73944769E-04,
     &   2.80509801E-04, 2.97868635E-04, 3.12106716E-04, 3.27452611E-04,
     &   3.62347718E-04, 4.09159657E-04, 4.14957357E-04, 4.65169175E-04/
  
         DATA ((DGS  (I,J), I= 401, 500), J=3,3) /
     &   5.37309969E-04, 5.52589021E-04, 5.01929103E-04, 4.57683520E-04,
     &   4.41091427E-04, 3.96736121E-04, 3.84562673E-04, 3.78063931E-04,
     &   3.70167660E-04, 3.56549868E-04, 3.43192393E-04, 3.30822887E-04,
     &   3.29518934E-04, 3.18240918E-04, 3.17020761E-04, 3.11032406E-04,
     &   3.06506973E-04, 2.92440263E-04, 2.89930564E-04, 2.71734711E-04,
     &   2.70185594E-04, 2.68597980E-04, 2.51127908E-04, 2.34745267E-04,
     &   2.31975449E-04, 2.17654778E-04, 2.16539500E-04, 2.11221357E-04,
     &   2.10220864E-04, 2.04477650E-04, 2.01341827E-04, 1.90724597E-04,
     &   1.89475063E-04, 1.76871864E-04, 1.65847610E-04, 1.59985576E-04,
     &   1.58856132E-04, 1.45465503E-04, 1.43599413E-04, 1.35156300E-04,
     &   1.30337600E-04, 1.28688871E-04, 1.27753141E-04, 1.27337564E-04,
     &   1.25358308E-04, 1.25519510E-04, 1.27330168E-04, 1.31145628E-04,
     &   1.33833898E-04, 1.46485908E-04, 1.63746652E-04, 1.67833238E-04,
     &   1.69969041E-04, 1.83910239E-04, 1.91305448E-04, 1.99018344E-04,
     &   2.35022207E-04, 2.40318535E-04, 2.55212692E-04, 2.64205725E-04,
     &   2.75578171E-04, 2.77265068E-04, 2.82216691E-04, 2.85287048E-04,
     &   2.88172651E-04, 2.94728004E-04, 3.01619853E-04, 3.08016076E-04,
     &   3.18112737E-04, 3.30115280E-04, 3.31610606E-04, 3.54847105E-04,
     &   3.74222147E-04, 3.96240727E-04, 4.00608248E-04, 4.40810724E-04,
     &   4.47475033E-04, 4.73932650E-04, 5.53233152E-04, 5.34754732E-04,
     &   5.23033597E-04, 4.48708281E-04, 4.32172939E-04, 4.26225396E-04,
     &   4.18745177E-04, 4.20677586E-04, 4.25406356E-04, 4.30922791E-04,
     &   4.41448514E-04, 4.44280273E-04, 4.51425391E-04, 4.52874636E-04,
     &   4.58681158E-04, 4.65801059E-04, 4.72988185E-04, 4.75989847E-04,
     &   5.15427978E-04, 5.49786624E-04, 5.49737528E-04, 4.12943323E-04/
  
         DATA ((DGS  (I,J), I= 501, 600), J=3,3) /
     &   3.45449799E-04, 3.15793196E-04, 2.74416019E-04, 2.71192552E-04,
     &   2.61270956E-04, 2.52464279E-04, 2.40647487E-04, 2.39106203E-04,
     &   2.39495516E-04, 2.42237385E-04, 2.48060428E-04, 2.57364943E-04,
     &   2.71096454E-04, 2.90829961E-04, 3.19352582E-04, 3.61959750E-04,
     &   4.29631421E-04, 4.48006900E-04, 4.68650315E-04, 4.91979034E-04,
     &   5.18519126E-04, 5.48940960E-04, 5.84113333E-04, 6.25178986E-04,
     &   6.34225932E-04, 6.43582937E-04, 6.53265401E-04, 6.63290559E-04,
     &   6.73675617E-04, 6.84439805E-04, 6.95603509E-04, 7.07188593E-04,
     &   7.19218529E-04, 7.31718549E-04, 7.94648807E-04, 8.43633772E-04,
     &   8.70705320E-04, 8.89833135E-04, 9.09895190E-04, 9.30954831E-04,
     &   9.53087189E-04, 9.76374229E-04, 1.00090609E-03, 1.01366979E-03,
     &   1.02678315E-03, 1.04026043E-03, 1.05411633E-03, 1.06836784E-03,
     &   1.08303050E-03, 1.09812247E-03, 1.11366261E-03, 1.12967074E-03,
     &   1.14616791E-03, 1.16317647E-03, 1.18071974E-03, 1.19882364E-03,
     &   1.21751472E-03, 1.23682145E-03, 1.25677445E-03, 1.27740585E-03,
     &   1.29875003E-03, 1.32084470E-03, 1.34372921E-03, 1.36744642E-03,
     &   1.39204105E-03, 1.41756249E-03, 1.44406341E-03, 1.47160052E-03,
     &   1.50023490E-03, 1.53003291E-03, 1.56106574E-03, 1.59341094E-03,
     &   1.62715256E-03, 1.66238208E-03, 1.69919899E-03, 1.73771189E-03,
     &   1.77803947E-03, 1.82031163E-03, 1.86467158E-03, 1.91127591E-03,
     &   1.96029797E-03, 2.01192924E-03, 2.06638194E-03, 2.09473903E-03,
     &   2.12389193E-03, 2.15387439E-03, 2.18472206E-03, 2.21647269E-03,
     &   2.24916623E-03, 2.28284477E-03, 2.31755387E-03, 2.35334091E-03,
     &   2.39025611E-03, 2.42835415E-03, 2.46769199E-03, 2.50833083E-03,
     &   2.55033614E-03, 2.59377744E-03, 2.63872929E-03, 2.68527149E-03/
  
         DATA ((DGS  (I,J), I= 601, 700), J=3,3) /
     &   2.73348950E-03, 2.78347506E-03, 2.83532670E-03, 2.88915043E-03,
     &   2.94506042E-03, 3.00317982E-03, 3.06364169E-03, 3.12659009E-03,
     &   3.19218075E-03, 3.26058312E-03, 3.33198128E-03, 3.40657574E-03,
     &   3.48458539E-03, 3.56624930E-03, 3.65182967E-03, 3.74161429E-03,
     &   3.83591974E-03, 3.93509563E-03, 4.03952796E-03, 4.14964498E-03,
     &   4.26592268E-03, 4.44008351E-03, 4.51914547E-03, 4.65734963E-03,
     &   4.80425351E-03, 4.96070366E-03, 5.12766011E-03, 5.30621607E-03,
     &   5.49762190E-03, 5.70331429E-03, 5.92495243E-03, 6.16446273E-03,
     &   6.42409493E-03, 6.70649287E-03, 6.93194168E-03, 7.63433984E-03,
     &   8.49462021E-03, 9.57270016E-03, 1.09632044E-02, 1.28248488E-02,
     &   1.54457595E-02, 1.94091117E-02, 2.61006351E-02, 3.98120678E-02,
     &   8.37127357E-02, 8.85211475E-02, 9.39134288E-02, 1.00002373E-01,
     &   1.06931689E-01, 1.14887315E-01, 1.24114049E-01, 1.34940662E-01,
     &   1.47818916E-01, 1.63386285E-01, 1.82570755E-01, 2.06773913E-01,
     &   2.38207663E-01, 2.80550098E-01, 2.85598421E-01, 3.98636831E-01,
     &   4.81027111E-01, 5.47222948E-01, 6.04793031E-01, 6.49155387E-01,
     &   6.87916856E-01, 7.18981472E-01, 7.49928709E-01, 7.71187626E-01,
     &   7.90871626E-01, 8.04761364E-01, 8.16211890E-01, 8.22646519E-01,
     &   8.27449546E-01, 8.27857969E-01, 8.25440708E-01, 8.18737257E-01,
     &   8.11492410E-01, 7.95821710E-01, 7.81780889E-01, 7.64545916E-01,
     &   7.43845690E-01, 7.19420149E-01, 6.91030129E-01, 6.58468834E-01,
     &   6.21574691E-01, 5.80245091E-01, 5.34450353E-01, 4.84246965E-01,
     &   4.01041438E-01, 3.40723146E-01, 2.44033896E-01, 1.41586747E-01,
     &   1.41489051E-01, 4.00955889E-01, 4.84168291E-01, 5.57833496E-01,
     &   6.01402452E-01, 6.58411580E-01, 6.90978488E-01, 7.19374090E-01/
  
         DATA ((DGS  (I,J), I= 701, 800), J=3,3) /
     &   7.43805132E-01, 7.64510736E-01, 7.81750934E-01, 7.95796802E-01,
     &   8.06922307E-01, 8.15397820E-01, 8.21485150E-01, 8.25433940E-01,
     &   8.27857122E-01, 8.27452386E-01, 8.24298972E-01, 8.18601620E-01,
     &   8.13640917E-01, 8.01506719E-01, 7.90896241E-01, 7.75309520E-01,
     &   7.58597597E-01, 7.36793847E-01, 7.14566143E-01, 6.83570680E-01,
     &   6.53414585E-01, 6.16571099E-01, 5.75017615E-01, 5.21569908E-01,
     &   4.60299413E-01, 3.83793780E-01, 3.16256701E-01, 2.63795554E-01,
     &   2.25941313E-01, 1.97438802E-01, 1.75245491E-01, 1.57494996E-01,
     &   1.42984736E-01, 1.30907255E-01, 1.20701291E-01, 1.11965075E-01,
     &   1.04403689E-01, 9.77958911E-02, 9.19725361E-02, 8.68021392E-02,
     &   8.21809730E-02, 7.80261273E-02, 7.42705468E-02, 7.08594211E-02,
     &   3.71572309E-02, 2.51842489E-02, 1.90512012E-02, 1.53235263E-02,
     &   1.28183203E-02, 1.10190436E-02, 9.66423127E-03, 8.60734935E-03,
     &   7.75989888E-03, 7.06527381E-03, 6.98301139E-03, 6.40945642E-03,
     &   5.92367313E-03, 5.50696734E-03, 5.14560198E-03, 4.82925614E-03,
     &   4.55002532E-03, 4.30175339E-03, 4.07957450E-03, 3.87959189E-03,
     &   3.69864809E-03, 3.53415753E-03, 3.38398267E-03, 3.24634101E-03,
     &   3.11973428E-03, 3.00289401E-03, 2.89473898E-03, 2.79434232E-03,
     &   2.70090416E-03, 2.61373133E-03, 2.53221973E-03, 2.45584074E-03,
     &   2.38412968E-03, 2.31667604E-03, 2.25311655E-03, 2.19312810E-03,
     &   2.13642244E-03, 2.08274167E-03, 2.03185422E-03, 1.98355158E-03,
     &   1.93764584E-03, 1.89396674E-03, 1.85235991E-03, 1.81268504E-03,
     &   1.77481426E-03, 1.73863121E-03, 1.70402843E-03, 1.67090837E-03,
     &   1.63918137E-03, 1.60876433E-03, 1.57958121E-03, 1.55156206E-03,
     &   1.52464179E-03, 1.49876031E-03, 1.47386194E-03, 1.44989502E-03/
  
         DATA ((DGS  (I,J), I= 801, 900), J=3,3) /
     &   1.42681156E-03, 1.40456693E-03, 1.38311937E-03, 1.36243051E-03,
     &   1.34246450E-03, 1.32318678E-03, 1.30456621E-03, 1.28657333E-03,
     &   1.26918056E-03, 1.25236209E-03, 1.23609375E-03, 1.22035290E-03,
     &   1.20511834E-03, 1.19036986E-03, 1.17608984E-03, 1.16225997E-03,
     &   1.14886426E-03, 1.13588755E-03, 1.12331563E-03, 1.11113541E-03,
     &   1.09933468E-03, 1.08790252E-03, 1.07682816E-03, 1.06610197E-03,
     &   1.05571611E-03, 1.04566357E-03, 1.03593756E-03, 1.02653282E-03,
     &   1.01744530E-03, 1.00867228E-03, 1.00021256E-03, 9.92066065E-04,
     &   9.84236450E-04, 9.76729067E-04, 9.69551946E-04, 9.62718037E-04,
     &   9.56245685E-04, 9.50160577E-04, 9.42665616E-04, 9.35338639E-04,
     &   9.28173507E-04, 9.21163705E-04, 9.14302201E-04, 9.07580571E-04,
     &   9.00983799E-04, 8.94498731E-04, 8.88755967E-04, 8.83895380E-04,
     &   8.78085290E-04, 8.72304352E-04, 8.66658134E-04, 8.61048156E-04,
     &   8.55570421E-04, 8.50203053E-04, 8.44957496E-04, 8.39803028E-04,
     &   8.34766594E-04, 6.66992491E-04, 5.75889218E-04, 5.47893859E-04,
     &   5.73452740E-04, 6.16050876E-04, 7.26366081E-04, 7.93998866E-04,
     &   8.82686630E-04, 8.95265157E-04, 9.62152373E-04, 1.00424846E-03,
     &   1.01222433E-03, 1.12833452E-03, 1.30023626E-03, 1.36137311E-03,
     &   1.42957385E-03, 1.50409249E-03, 1.59261464E-03, 1.68539751E-03,
     &   1.79675692E-03, 1.92961139E-03, 2.08878242E-03, 2.28145411E-03,
     &   2.51819039E-03, 2.81481472E-03, 3.19595356E-03, 3.38035742E-03,
     &   3.58811315E-03, 3.82387188E-03, 4.09361000E-03, 4.40513689E-03,
     &   4.76886453E-03, 4.97454846E-03, 5.19898684E-03, 5.44484562E-03,
     &   5.71532139E-03, 6.01428038E-03, 6.34644348E-03, 6.71763618E-03,
     &   7.13513172E-03, 7.60812970E-03, 8.14844079E-03, 8.77148324E-03/
  
         DATA ((DGS  (I,J), I= 901,1000), J=3,3) /
     &   9.49777374E-03, 1.03179687E-02, 1.08550021E-02, 1.14509778E-02,
     &   1.21161432E-02, 1.28632690E-02, 1.37084733E-02, 1.46723961E-02,
     &   1.57819022E-02, 1.70726195E-02, 1.85928257E-02, 2.04096058E-02,
     &   2.26189886E-02, 2.53634239E-02, 2.88636411E-02, 3.34808588E-02,
     &   3.98493275E-02, 4.91930011E-02, 6.42116087E-02, 9.22126807E-02,
     &   1.36253403E-01, 1.61319706E-01, 1.88660740E-01, 2.55932540E-01,
     &   2.80168981E-01, 3.00171851E-01, 3.17158928E-01, 3.31463015E-01,
     &   3.43198786E-01, 3.53303907E-01, 3.61578035E-01, 3.67499837E-01,
     &   3.72530661E-01, 3.76092035E-01, 3.78204356E-01, 3.78967262E-01,
     &   3.78425497E-01, 3.76945134E-01, 3.73940770E-01, 3.70009413E-01,
     &   3.64710161E-01, 3.57892008E-01, 3.50722668E-01, 3.40677939E-01,
     &   3.30522503E-01, 3.18850285E-01, 3.05586373E-01, 2.88019547E-01,
     &   2.71121479E-01, 2.49235574E-01, 2.28628732E-01, 1.98584965E-01,
     &   1.65796892E-01, 1.16825920E-01, 7.41397948E-02, 2.49747580E-02,
     &   5.84671560E-04, 2.48500842E-02, 4.95917823E-02, 1.16707715E-01,
     &   1.65685887E-01, 1.98480454E-01, 2.28531544E-01, 2.49144293E-01,
     &   2.71037410E-01, 2.87941841E-01, 3.05516199E-01, 3.18786585E-01,
     &   3.30465235E-01, 3.40627010E-01, 3.50678971E-01, 3.57854330E-01,
     &   3.64679266E-01, 3.69985019E-01, 3.73922577E-01, 3.76933650E-01,
     &   3.78419551E-01, 3.78967987E-01, 3.78211262E-01, 3.76105261E-01,
     &   3.72550217E-01, 3.67525617E-01, 3.61609393E-01, 3.53341435E-01,
     &   3.43242370E-01, 3.31512374E-01, 3.17214124E-01, 3.00232806E-01,
     &   2.80235561E-01, 2.56004722E-01, 2.26629286E-01, 2.42577464E-01,
     &   2.07511125E-01, 1.85912430E-01, 1.72854580E-01, 1.45804743E-01,
     &   1.36341892E-01, 1.15971550E-01, 7.50930102E-02, 5.54073664E-02/
  
         DATA ((DGS  (I,J), I=1001,1100), J=3,3) /
     &   4.38757715E-02, 3.63115049E-02, 3.09708098E-02, 2.70000691E-02,
     &   2.39326323E-02, 2.14920247E-02, 1.95040866E-02, 1.78536759E-02,
     &   1.64616326E-02, 1.52717474E-02, 1.42430084E-02, 1.33447909E-02,
     &   1.25537723E-02, 1.18518631E-02, 1.12248373E-02, 1.06613383E-02,
     &   9.77078448E-03, 8.65962454E-03, 8.06566586E-03, 7.09582741E-03,
     &   6.33784217E-03, 5.59605585E-03, 4.54438449E-03, 3.38819110E-03,
     &   2.70545353E-03, 2.42069203E-03, 2.26072449E-03, 2.15709687E-03,
     &   2.08394553E-03, 2.02904827E-03, 1.98601216E-03, 1.95111478E-03,
     &   1.92203117E-03, 1.89719656E-03, 1.87563443E-03, 1.85654162E-03,
     &   1.83938679E-03, 1.82378517E-03, 1.80939632E-03, 1.79597172E-03,
     &   1.78330434E-03, 1.77125635E-03, 1.75966989E-03, 1.74840970E-03,
     &   1.73737976E-03, 1.72651906E-03, 1.71567304E-03, 1.70478463E-03,
     &   1.69373930E-03, 1.68246965E-03, 1.67082194E-03, 1.65865942E-03,
     &   1.64574533E-03, 1.63183481E-03, 1.61643077E-03, 1.59862748E-03,
     &   1.57616883E-03, 1.52567924E-03, 1.48212539E-03, 1.46717460E-03,
     &   1.45722087E-03, 1.44995642E-03, 1.44443900E-03, 1.44018214E-03,
     &   1.43685666E-03, 1.43420950E-03, 1.43205758E-03, 1.43006278E-03,
     &   1.42859946E-03, 1.42696234E-03, 1.42510119E-03, 1.42255270E-03,
     &   1.42133122E-03, 1.42006176E-03, 1.41972468E-03, 1.41821173E-03,
     &   1.41568205E-03, 1.41215104E-03, 1.40750370E-03, 1.40161130E-03,
     &   1.39430483E-03, 1.38539572E-03, 1.37462343E-03, 1.36135606E-03,
     &   1.34622396E-03, 1.32752204E-03, 1.30529708E-03, 1.27872205E-03,
     &   1.24652741E-03, 1.20673084E-03, 1.15578252E-03, 1.08601160E-03,
     &   1.06540815E-03, 1.01265792E-03, 9.42199248E-04, 9.34658089E-04,
     &   8.79059700E-04, 8.58565997E-04, 8.45413022E-04, 8.44848109E-04/
  
         DATA ((DGS  (I,J), I=1101,1200), J=3,3) /
     &   8.46971781E-04, 8.36759866E-04, 8.21956191E-04, 8.12785885E-04,
     &   7.94994691E-04, 7.81256456E-04, 7.69830273E-04, 7.60861429E-04,
     &   7.57453261E-04, 7.47325761E-04, 7.32351782E-04, 7.60935782E-04,
     &   7.59883066E-04, 7.23295936E-04, 6.86708806E-04, 6.50121676E-04,
     &   6.66653616E-04, 6.69039386E-04, 6.62936389E-04, 6.88234829E-04,
     &   7.19161388E-04, 7.62228559E-04, 7.18366143E-04, 6.46631542E-04,
     &   6.39082763E-04, 6.43180573E-04, 6.40316436E-04, 6.27915860E-04,
     &   6.15431927E-04, 6.55985577E-04, 7.45390877E-04, 9.06251477E-04,
     &   1.00837428E-03, 8.72194050E-04, 4.24468180E-04, 4.04451887E-04,
     &   4.06559302E-04, 4.32838535E-04, 4.20938553E-04, 4.01296299E-04,
     &   3.86803875E-04, 3.96767427E-04, 4.11735448E-04, 4.09281206E-04,
     &   4.04898788E-04, 3.96266591E-04, 3.91188542E-04, 3.90802845E-04,
     &   3.90830406E-04, 3.93601329E-04, 3.96593135E-04, 4.00542623E-04,
     &   3.96026348E-04, 3.71451027E-04, 3.61088388E-04, 3.60492724E-04,
     &   3.61936361E-04, 3.73914239E-04, 4.10756509E-04, 4.81963874E-04,
     &   4.94756702E-04, 4.58899656E-04, 4.28668038E-04, 3.97749959E-04,
     &   3.52388776E-04, 3.35648898E-04, 3.56138520E-04, 4.01889521E-04,
     &   4.01857268E-04, 3.30518454E-04, 3.27942222E-04, 3.40445995E-04,
     &   3.88910771E-04, 3.38310751E-04, 3.21318640E-04, 3.18969069E-04,
     &   3.17800459E-04, 3.16695380E-04, 3.15528251E-04, 3.11670003E-04,
     &   3.16111311E-04, 3.14399910E-04, 3.14277949E-04, 3.24380227E-04,
     &   3.60106328E-04, 3.93708293E-04, 4.71052319E-04, 5.13678538E-04,
     &   3.27719395E-04, 3.04194851E-04, 2.90657815E-04, 3.34575357E-04,
     &   3.59254524E-04, 4.79056149E-04, 4.80792768E-04, 4.75443676E-04,
     &   4.68189467E-04, 3.07033573E-04, 2.97918669E-04, 5.22790527E-04/
  
         DATA ((DGS  (I,J), I=1201,1300), J=3,3) /
     &   4.86438135E-04, 3.40907407E-04, 3.17259265E-04, 3.10069298E-04,
     &   2.97697624E-04, 2.92432682E-04, 2.94190969E-04, 2.94572132E-04,
     &   2.88051197E-04, 2.84062975E-04, 2.76830399E-04, 2.74862203E-04,
     &   2.66748658E-04, 2.66374949E-04, 2.67186634E-04, 2.60584614E-04,
     &   2.68139805E-04, 2.87468333E-04, 3.24202778E-04, 2.86758884E-04,
     &   2.49466943E-04, 2.45073428E-04, 2.43343636E-04, 2.40056781E-04,
     &   2.44741369E-04, 2.37724592E-04, 2.28911662E-04, 2.79314207E-04,
     &   2.51878259E-04, 2.22727565E-04, 7.02550034E-04, 1.12592280E-03,
     &   1.26704706E-03, 1.00890476E-03, 7.76972287E-04, 7.10473051E-04,
     &   6.59520983E-04, 5.85593696E-04, 5.33840350E-04, 5.13237338E-04,
     &   4.95213801E-04, 4.79294782E-04, 4.65119427E-04, 4.52407974E-04,
     &   4.40936336E-04, 4.30534378E-04, 4.21055543E-04, 4.12382146E-04,
     &   4.04416605E-04, 3.97077263E-04, 3.90295235E-04, 3.84011984E-04,
     &   3.78177444E-04, 3.72748543E-04, 3.67688031E-04, 3.62963548E-04,
     &   3.58546865E-04, 3.54413271E-04, 3.50541069E-04, 3.46911163E-04,
     &   3.43506714E-04, 3.40312858E-04, 3.37316463E-04, 3.34505936E-04,
     &   3.31871048E-04, 3.29402801E-04, 3.27093308E-04, 3.24935692E-04,
     &   3.22924009E-04, 3.21053180E-04, 3.19318933E-04, 3.17717765E-04,
     &   3.16246910E-04, 3.15162648E-04, 3.13688625E-04, 3.11636056E-04,
     &   3.10092524E-04, 3.09073375E-04, 3.08607387E-04, 3.08739076E-04,
     &   3.09532252E-04, 3.11075328E-04, 3.13489312E-04, 3.16940027E-04,
     &   3.21657401E-04, 3.27971022E-04, 3.36347483E-04, 3.47521806E-04,
     &   3.62686164E-04, 3.64491570E-04, 3.83975997E-04, 4.15772857E-04,
     &   4.69196344E-04, 5.51701484E-04, 5.85109634E-04, 7.24155535E-04,
     &   9.90686256E-04, 1.11711841E-03, 1.29724720E-03, 1.41886519E-03/
  
         DATA ((DGS  (I,J), I=1301,1400), J=3,3) /
     &   1.57217456E-03, 1.72657865E-03, 1.92071467E-03, 2.03764742E-03,
     &   2.17159640E-03, 2.32646889E-03, 2.50745994E-03, 2.72162995E-03,
     &   2.97882369E-03, 3.12774738E-03, 3.29319200E-03, 3.47802880E-03,
     &   3.68583378E-03, 3.92111810E-03, 4.18965499E-03, 4.49895425E-03,
     &   4.85896816E-03, 5.28317225E-03, 5.45992685E-03, 5.57084717E-03,
     &   5.68644553E-03, 5.80702271E-03, 5.93290582E-03, 6.06445126E-03,
     &   6.20204805E-03, 6.34612168E-03, 6.49713848E-03, 6.65561062E-03,
     &   6.82210188E-03, 6.99723437E-03, 7.18169621E-03, 7.37625059E-03,
     &   7.58174620E-03, 7.79912965E-03, 8.02945995E-03, 8.27392572E-03,
     &   8.53386564E-03, 8.81079289E-03, 9.10642459E-03, 9.42271727E-03,
     &   9.76191018E-03, 1.01265782E-02, 1.05196974E-02, 1.09447257E-02,
     &   1.14057055E-02, 1.19073916E-02, 1.24554161E-02, 1.30565001E-02,
     &   1.37187306E-02, 1.44519255E-02, 1.52681234E-02, 1.61822489E-02,
     &   1.72130322E-02, 1.83843052E-02, 1.97268646E-02, 2.12812168E-02,
     &   2.31017316E-02, 2.52631268E-02, 2.78709691E-02, 3.10794227E-02,
     &   3.51228436E-02, 4.03756951E-02, 4.74755913E-02, 5.76035268E-02,
     &   7.32186082E-02, 1.00423360E-01, 1.59623022E-01, 1.96327701E-01,
     &   3.73943435E-01, 5.20315777E-01, 6.26413404E-01, 7.08507126E-01,
     &   7.75957160E-01, 8.34983348E-01, 8.89751425E-01, 9.27878850E-01,
     &   9.66689631E-01, 1.00485969E+00, 1.02326327E+00, 1.04905552E+00,
     &   1.06450993E+00, 1.08369295E+00, 1.08869214E+00, 1.09608659E+00,
     &   1.09915957E+00, 1.09684357E+00, 1.09330970E+00, 1.08797455E+00,
     &   1.07107909E+00, 1.05923102E+00, 1.04466916E+00, 1.00715037E+00,
     &   9.83857520E-01, 9.57236408E-01, 9.26777955E-01, 8.55358893E-01,
     &   8.13415400E-01, 7.67944882E-01, 6.64586608E-01, 6.07372770E-01/
  
         DATA ((DGS  (I,J), I=1401,1500), J=3,3) /
     &   4.81465107E-01, 3.42852658E-01, 3.66094112E-02, 3.38300049E-01,
     &   4.77268161E-01, 6.02989024E-01, 7.14700485E-01, 7.64922684E-01,
     &   8.10644363E-01, 8.52420418E-01, 9.24739051E-01, 9.55126727E-01,
     &   9.82266050E-01, 1.00576484E+00, 1.04366079E+00, 1.05825346E+00,
     &   1.07039726E+00, 1.08750218E+00, 1.09302547E+00, 1.09866707E+00,
     &   1.09917493E+00, 1.09625563E+00, 1.08903139E+00, 1.07833739E+00,
     &   1.06497105E+00, 1.04957239E+00, 1.02383649E+00, 1.00555431E+00,
     &   9.67308331E-01, 9.28598280E-01, 8.90355275E-01, 8.35551763E-01,
     &   7.76475895E-01, 7.08961864E-01, 6.26787220E-01, 5.20589053E-01,
     &   3.71940360E-01, 2.03001933E-01, 1.16113498E-01, 8.12409466E-02,
     &   6.24658715E-02, 5.07373919E-02, 4.27166735E-02, 3.68860053E-02,
     &   3.24563985E-02, 2.89771622E-02, 2.61721648E-02, 2.38627915E-02,
     &   2.19283933E-02, 2.02845382E-02, 1.88703716E-02, 1.76409237E-02,
     &   1.65622445E-02, 1.56082230E-02, 1.47584485E-02, 1.39967358E-02,
     &   1.33100850E-02, 1.26879353E-02, 1.21216183E-02, 1.16039521E-02,
     &   1.11289363E-02, 1.06915183E-02, 1.02874132E-02, 9.91296362E-03,
     &   9.56502861E-03, 9.24089581E-03, 8.93821065E-03, 8.65491928E-03,
     &   8.38922205E-03, 8.13953534E-03, 7.90446012E-03, 7.68275580E-03,
     &   7.47331843E-03, 7.27516238E-03, 7.08740492E-03, 6.90925312E-03,
     &   6.73999273E-03, 6.57897863E-03, 6.42562671E-03, 6.27940677E-03,
     &   6.13983651E-03, 6.00647618E-03, 5.87892400E-03, 5.75681219E-03,
     &   5.63980341E-03, 5.52758768E-03, 5.41987969E-03, 4.60894298E-03,
     &   4.11363552E-03, 3.64083717E-03, 3.11724978E-03, 2.63590388E-03,
     &   2.18264862E-03, 1.92053752E-03, 1.58580107E-03, 1.47431562E-03,
     &   1.35072887E-03, 1.25336561E-03, 1.17318719E-03, 1.10578532E-03/
  
         DATA ((DGS  (I,J), I=1501,1600), J=3,3) /
     &   9.98499119E-04, 9.16837182E-04, 6.95592178E-04, 5.51088654E-04,
     &   5.27723358E-04, 6.58338520E-04, 9.59732861E-04, 1.38715087E-03,
     &   1.97324357E-03, 2.79682263E-03, 4.88071459E-03, 5.27714774E-03,
     &   5.74420635E-03, 5.87958677E-03, 6.18821692E-03, 6.53121162E-03,
     &   6.91463505E-03, 7.34606745E-03, 7.83511041E-03, 8.39410878E-03,
     &   9.03920573E-03, 9.79192537E-03, 1.06816185E-02, 1.17493759E-02,
     &   1.30545499E-02, 1.46861677E-02, 1.67841254E-02, 1.95815750E-02,
     &   2.34981663E-02, 2.93731205E-02, 3.91642761E-02, 5.87427495E-02,
     &   8.50060943E-02, 8.94143741E-02, 9.43045679E-02, 9.97602173E-02,
     &   1.05885344E-01, 1.12811128E-01, 1.20705385E-01, 1.29786299E-01,
     &   1.40342825E-01, 1.52765875E-01, 1.67597547E-01, 1.85611860E-01,
     &   2.07953255E-01, 2.36387395E-01, 2.73786482E-01, 3.25149948E-01,
     &   3.99995032E-01, 5.18823436E-01, 7.34468575E-01, 1.22231729E+00,
     &   1.39333427E+00, 1.52793761E+00, 1.67796477E+00, 1.80387358E+00,
     &   1.89467644E+00, 1.97168792E+00, 2.00717179E+00, 2.02125993E+00,
     &   2.00354048E+00, 1.94075256E+00, 1.86846175E+00, 1.85478250E+00,
     &   1.84767094E+00, 1.83289411E+00, 1.82677389E+00, 1.82210424E+00,
     &   1.81736601E+00, 1.76612300E+00, 1.67548339E+00, 1.55419998E+00,
     &   1.42569803E+00, 1.26110009E+00, 1.07407325E+00, 8.87889007E-01,
     &   7.77868446E-01, 6.63691246E-01, 5.45873604E-01, 3.75928090E-01,
     &   2.51843688E-01, 1.26297762E-01, 5.05695851E-02, 2.52964442E-02,
     &   1.26595097E-02, 3.88561245E-04, 1.26337258E-02, 2.52706529E-02,
     &   1.26272022E-01, 2.51818117E-01, 3.75902799E-01, 9.30608356E-01,
     &   1.13244132E+00, 1.45584467E+00, 1.58022893E+00, 1.69709033E+00,
     &   1.79262076E+00, 1.86170282E+00, 1.92143626E+00, 1.96149215E+00/
  
         DATA ((DGS  (I,J), I=1601,1700), J=3,3) /
     &   1.99264192E+00, 2.01022349E+00, 2.01983226E+00, 2.02088799E+00,
     &   2.01501099E+00, 2.00444169E+00, 1.96950617E+00, 1.94595995E+00,
     &   1.91985409E+00, 1.89468391E+00, 1.83802183E+00, 1.80701116E+00,
     &   1.75664570E+00, 1.67797635E+00, 1.39334893E+00, 1.17285667E+00,
     &   1.00589974E+00, 8.77641616E-01, 7.76968411E-01, 6.96253193E-01,
     &   6.15660146E-01, 4.89829139E-01, 4.55777781E-01, 4.26100456E-01,
     &   4.00014059E-01, 3.61246710E-01, 2.99006740E-01, 2.54986998E-01,
     &   2.22230592E-01, 1.96914386E-01, 1.76766474E-01, 1.60353099E-01,
     &   1.46725279E-01, 1.35230108E-01, 1.25403756E-01, 1.16907695E-01,
     &   1.09489098E-01, 1.02955349E-01, 9.71571367E-02, 9.19769367E-02,
     &   8.73209852E-02, 5.87620877E-02, 3.91836160E-02, 2.93924586E-02,
     &   1.96009051E-02, 1.47054856E-02, 1.17686780E-02, 9.81120798E-03,
     &   8.41336829E-03, 7.36530028E-03, 6.55041419E-03, 5.89875550E-03,
     &   5.52920697E-03, 5.09817757E-03, 4.73005387E-03, 4.41203250E-03,
     &   4.13456379E-03, 3.89037990E-03, 3.00796454E-03, 2.45761888E-03,
     &   2.08238578E-03, 1.81075042E-03, 1.60546891E-03, 1.44526251E-03,
     &   1.31696973E-03, 1.21217633E-03, 5.59250285E-04, 5.49806118E-04,
     &   5.58921650E-04, 5.73809191E-04, 5.96649536E-04, 6.31242925E-04,
     &   6.54780097E-04, 6.83893375E-04, 7.66872981E-04, 9.07788779E-04,
     &   1.18017477E-03, 1.85270420E-03, 2.51983048E-03, 2.69368389E-03,
     &   2.89474499E-03, 3.12981330E-03, 3.40817060E-03, 3.74281258E-03,
     &   4.15249424E-03, 4.66536521E-03, 5.32566369E-03, 6.20708467E-03,
     &   7.44231583E-03, 9.29674110E-03, 1.23894484E-02, 1.29274778E-02,
     &   1.35143862E-02, 1.41572931E-02, 1.48645269E-02, 1.56461540E-02,
     &   1.65147563E-02, 1.74855853E-02, 1.85776793E-02, 1.98155485E-02/
  
         DATA ((DGS  (I,J), I=1701,1800), J=3,3) /
     &   2.12302885E-02, 2.28625149E-02, 2.47669834E-02, 2.70177075E-02,
     &   2.97181997E-02, 3.30189911E-02, 3.40504102E-02, 3.71446873E-02,
     &   4.24478773E-02, 4.95180963E-02, 5.94131455E-02, 7.42468218E-02,
     &   9.89353183E-02, 1.48154204E-01, 2.93629762E-01, 3.49087587E-01,
     &   4.92380345E-01, 6.01351620E-01, 6.91139487E-01, 7.69507268E-01,
     &   8.39035387E-01, 9.01408838E-01, 9.57123757E-01, 1.00876577E+00,
     &   1.05753544E+00, 1.10210552E+00, 1.14131012E+00, 1.17757484E+00,
     &   1.21027171E+00, 1.23891024E+00, 1.26611907E+00, 1.28840642E+00,
     &   1.30581063E+00, 1.32058729E+00, 1.33196089E+00, 1.33900645E+00,
     &   1.34077902E+00, 1.33778407E+00, 1.32913513E+00, 1.31385273E+00,
     &   1.29087629E+00, 1.26504537E+00, 1.22503842E+00, 1.17414452E+00,
     &   1.11132895E+00, 1.02183940E+00, 9.14072814E-01, 7.68381186E-01,
     &   5.77467877E-01, 7.91190140E-02, 4.86017326E-04, 2.61400420E-01,
     &   5.77458495E-01, 7.68372755E-01, 9.14065372E-01, 1.02183288E+00,
     &   1.11132339E+00, 1.17413977E+00, 1.22503446E+00, 1.26504218E+00,
     &   1.29087370E+00, 1.31385084E+00, 1.32913389E+00, 1.33778345E+00,
     &   1.34077896E+00, 1.33900692E+00, 1.33196193E+00, 1.32058885E+00,
     &   1.30581266E+00, 1.28840887E+00, 1.26612195E+00, 1.23891357E+00,
     &   1.21027543E+00, 1.17757894E+00, 1.14131459E+00, 1.10211034E+00,
     &   1.05754061E+00, 1.00877126E+00, 9.57129561E-01, 9.01414934E-01,
     &   8.39041769E-01, 7.69513927E-01, 6.91146412E-01, 6.01358799E-01,
     &   4.92387772E-01, 3.49095252E-01, 2.98918318E-01, 2.89507187E-01,
     &   2.77833623E-01, 2.45592027E-01, 2.16534796E-01, 1.48154025E-01,
     &   9.89431940E-02, 7.42526838E-02, 5.94197383E-02, 4.95259866E-02,
     &   4.24557693E-02, 3.71520745E-02, 3.30268858E-02, 2.97260956E-02/
  
         DATA ((DGS  (I,J), I=1801,1900), J=3,3) /
     &   2.70253368E-02, 2.47748817E-02, 2.28704145E-02, 2.12380240E-02,
     &   1.98234507E-02, 1.85855829E-02, 1.23973663E-02, 9.30467853E-03,
     &   7.45027827E-03, 6.21507762E-03, 5.33369266E-03, 4.67343572E-03,
     &   4.16061177E-03, 3.41639861E-03, 2.90310528E-03, 2.70211847E-03,
     &   2.52834472E-03, 1.90853944E-03, 1.46444029E-03, 1.20712889E-03,
     &   1.04214541E-03, 9.29294418E-04, 8.48611521E-04, 7.89098596E-04,
     &   7.44195787E-04, 7.09774987E-04, 6.83162581E-04, 6.62544952E-04,
     &   6.46632059E-04, 6.34511803E-04, 6.25532097E-04, 6.19225849E-04,
     &   6.15261990E-04, 6.13413044E-04, 6.13533801E-04, 6.15548717E-04,
     &   6.19439804E-04, 6.25229496E-04, 6.48418832E-04, 1.08105454E-03,
     &   1.18308762E-03, 1.36917508E-03, 1.52204898E-03, 1.65040010E-03,
     &   1.75944582E-03, 1.85273307E-03, 1.93231133E-03, 1.99934028E-03,
     &   2.05563517E-03, 2.10207673E-03, 2.13896117E-03, 2.16685460E-03,
     &   2.18637173E-03, 2.19793054E-03, 2.20150269E-03, 2.19740597E-03,
     &   2.18575481E-03, 2.16620632E-03, 2.13918505E-03, 2.10521689E-03,
     &   2.06207457E-03, 2.01252192E-03, 1.95345466E-03, 1.88590104E-03,
     &   1.80816270E-03, 1.71987950E-03, 1.62087091E-03, 1.51119401E-03,
     &   1.38267670E-03, 1.23723060E-03, 1.07226595E-03, 8.73667788E-04,
     &   6.34640073E-04, 4.90483701E-04, 1.01255300E-03, 1.24845336E-03,
     &   1.42360463E-03, 1.56082642E-03, 1.67675049E-03, 1.77547690E-03,
     &   1.85693760E-03, 1.92810222E-03, 1.98942014E-03, 2.04144426E-03,
     &   2.08479528E-03, 2.12084749E-03, 2.14923800E-03, 2.17188295E-03,
     &   2.18746886E-03, 2.19719125E-03, 2.20078517E-03, 2.19825832E-03,
     &   2.18977599E-03, 2.17498365E-03, 2.15377814E-03, 2.12630565E-03,
     &   2.09204192E-03, 2.04805740E-03, 1.99869700E-03, 1.94347199E-03/
  
         DATA ((DGS  (I,J), I=1901,2000), J=3,3) /
     &   1.87605864E-03, 1.79825009E-03, 1.70836569E-03, 1.60431613E-03,
     &   1.48250013E-03, 1.33754903E-03, 1.16032513E-03, 9.31693095E-04,
     &   6.10663071E-04, 5.93455816E-04, 5.60931867E-04, 5.52073355E-04,
     &   5.51898699E-04, 5.55424229E-04, 5.60545439E-04, 5.66239906E-04,
     &   5.71946465E-04, 5.77361843E-04, 5.82281650E-04, 5.86601449E-04,
     &   5.90226898E-04, 5.93108684E-04, 5.95213972E-04, 5.96510501E-04,
     &   5.96972692E-04, 5.96581058E-04, 5.95312959E-04, 5.93153553E-04,
     &   5.90056598E-04, 5.86025461E-04, 5.81009221E-04, 5.74977479E-04,
     &   5.67899085E-04, 5.59702264E-04, 5.50337279E-04, 5.39755440E-04,
     &   5.27857258E-04, 5.14472805E-04, 4.99621812E-04, 4.82969546E-04,
     &   4.64433133E-04, 4.43661991E-04, 4.20215634E-04, 3.93513906E-04,
     &   3.60548718E-04, 3.80215524E-04, 4.00226617E-04, 4.18825066E-04,
     &   4.36035445E-04, 4.51967874E-04, 4.66790683E-04, 4.80500486E-04,
     &   4.93192013E-04, 5.05000406E-04, 5.15884261E-04, 5.25948678E-04,
     &   5.35237673E-04, 5.43748021E-04, 5.51577502E-04, 5.58761504E-04,
     &   5.65222420E-04, 5.71079818E-04, 5.76357904E-04, 5.81002423E-04,
     &   5.85096010E-04, 5.88618961E-04, 5.91626630E-04, 5.94091787E-04,
     &   5.96058453E-04, 5.97525258E-04, 5.98522976E-04, 5.99062680E-04,
     &   5.99166406E-04, 5.98857326E-04, 5.98163741E-04, 5.97119620E-04,
     &   5.95763171E-04, 5.94146777E-04, 5.92319495E-04, 5.90348226E-04,
     &   5.77446115E-04, 5.76238528E-04, 5.74933095E-04, 5.73514181E-04,
     &   5.71976372E-04, 5.70316399E-04, 5.68533269E-04, 5.66610641E-04,
     &   5.64527507E-04, 5.62299976E-04, 5.59906893E-04, 5.57346305E-04,
     &   5.54617893E-04, 5.51723056E-04, 5.48632939E-04, 5.45345605E-04,
     &   5.41897494E-04, 5.38219017E-04, 5.34306401E-04, 5.30201849E-04/
  
         DATA ((DGS  (I,J), I=2001,2100), J=3,3) /
     &   5.25820410E-04, 5.21255611E-04, 5.16418631E-04, 5.11312439E-04,
     &   5.05756763E-04, 5.00078998E-04, 4.94168271E-04, 4.87872081E-04,
     &   4.81218536E-04, 4.74193085E-04, 4.66805399E-04, 4.58924385E-04,
     &   4.50506090E-04, 4.41410661E-04, 4.31378573E-04, 4.17528645E-04,
     &   4.20247189E-04, 4.25955870E-04, 4.31882892E-04, 4.37743261E-04,
     &   4.43449116E-04, 4.48934293E-04, 4.54237817E-04, 4.59314455E-04,
     &   4.64148004E-04, 4.68696832E-04, 4.73063401E-04, 4.77179757E-04,
     &   4.81070474E-04, 4.84722283E-04, 4.88126519E-04, 4.91343083E-04,
     &   4.94298634E-04, 4.97023504E-04, 4.99565771E-04, 5.01844868E-04,
     &   5.03930656E-04, 5.05796069E-04, 5.07440581E-04, 5.08878151E-04,
     &   5.10104741E-04, 5.11118125E-04, 5.11917825E-04, 5.12509321E-04,
     &   5.12887252E-04, 5.13056687E-04, 5.13017188E-04, 5.12766507E-04,
     &   5.12304808E-04, 5.11633078E-04, 5.10748081E-04, 5.04077933E-04,
     &   4.75998269E-04, 4.53908280E-04, 4.43729510E-04, 4.42917736E-04,
     &   4.49810370E-04, 4.63746730E-04, 4.82777621E-04, 5.08242605E-04,
     &   5.39332663E-04, 5.74558968E-04, 6.17693876E-04, 6.65923218E-04,
     &   7.47727009E-04, 8.29530800E-04, 7.91860163E-04, 7.58032024E-04,
     &   7.29817061E-04, 7.03772790E-04, 6.81559115E-04, 6.60673315E-04,
     &   6.42580412E-04, 6.25342456E-04, 6.09579898E-04, 5.95701419E-04,
     &   5.82289285E-04, 5.70387390E-04, 5.58804580E-04, 5.48460811E-04,
     &   5.38336586E-04, 5.29248032E-04, 5.20309824E-04, 5.12250633E-04,
     &   5.04292611E-04, 4.97090225E-04, 4.90255828E-04, 4.83473294E-04,
     &   4.77305952E-04, 4.71167976E-04, 4.65571782E-04, 4.59988215E-04,
     &   4.54885395E-04, 4.49782669E-04, 4.45109377E-04, 4.40426761E-04,
     &   4.36130012E-04, 4.31816855E-04, 4.27675635E-04, 4.23865932E-04/
  
         DATA ((DGS  (I,J), I=2101,2180), J=3,3) /
     &   4.20032335E-04, 4.16500300E-04, 4.12940975E-04, 4.09657088E-04,
     &   4.06343426E-04, 4.03282282E-04, 4.00189587E-04, 3.97329190E-04,
     &   3.94436018E-04, 3.91757215E-04, 3.89160959E-04, 3.86530880E-04,
     &   3.84092021E-04, 3.81619025E-04, 3.79323704E-04, 3.76993777E-04,
     &   3.74829727E-04, 3.72631561E-04, 3.70587881E-04, 3.68510344E-04,
     &   3.66577327E-04, 3.64610816E-04, 3.62697671E-04, 3.60915679E-04,
     &   3.59100899E-04, 3.57334738E-04, 3.55610443E-04, 3.54002275E-04,
     &   3.52362449E-04, 3.50832133E-04, 3.49270871E-04, 3.47812938E-04,
     &   3.46324590E-04, 3.44934071E-04, 3.43513778E-04, 3.42186145E-04,
     &   3.40887729E-04, 3.39560511E-04, 3.38318963E-04, 3.37049264E-04,
     &   3.35860965E-04, 3.34645164E-04, 3.33506794E-04, 3.32347554E-04,
     &   3.31256134E-04, 3.30138486E-04, 3.29091128E-04, 3.28018164E-04,
     &   3.17629444E-04, 3.09148083E-04, 3.07933401E-04, 2.73681982E-04,
     &   2.65286394E-04, 2.51732945E-04, 2.47103008E-04, 2.46873479E-04,
     &   2.42507171E-04, 2.42495720E-04, 2.40111057E-04, 2.40031602E-04,
     &   2.39984643E-04, 2.39022029E-04, 2.38442706E-04, 2.38343712E-04,
     &   2.38184927E-04, 2.37956232E-04, 2.37799472E-04, 2.37702895E-04,
     &   2.36829556E-04, 2.36794104E-04, 2.36565973E-04, 2.36524206E-04,
     &   2.36418639E-04, 2.36265113E-04, 2.36230003E-04, 2.36178657E-04,
     &   2.36010447E-04, 2.35803995E-04, 2.35718865E-04, 2.35192515E-04/
       save
       RETURN
       END

c      ++++ dalhadshigh23 ++++  

c update 09/24/25 
       subroutine dalhad_timelike1h25
       IMPLICIT NONE
       INTEGER NC,I,J
       PARAMETER(NC=200)
       REAL EMA(NC),DAM(NC,3),DGM(NC,3)
       COMMON /DATM25/EMA,DAM,DGM
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Wed Sep 24 23:13:31 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN:  2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
       DATA  (EMA  (I), I=   1, 100) /
     &   1.3005E+01, 1.3500E+01, 1.4000E+01, 1.4500E+01, 1.5000E+01,
     &   1.6000E+01, 1.7000E+01, 1.8000E+01, 1.9000E+01, 2.0000E+01,
     &   2.1000E+01, 2.2000E+01, 2.3000E+01, 2.4000E+01, 2.5000E+01,
     &   2.6000E+01, 2.7000E+01, 2.8000E+01, 2.9000E+01, 3.0000E+01,
     &   3.1000E+01, 3.2000E+01, 3.3000E+01, 3.4000E+01, 3.5000E+01,
     &   3.6000E+01, 3.7000E+01, 3.8000E+01, 3.9000E+01, 4.0000E+01,
     &   4.1000E+01, 4.2000E+01, 4.3000E+01, 4.4000E+01, 4.5000E+01,
     &   4.6000E+01, 4.7000E+01, 4.8000E+01, 4.9000E+01, 5.0000E+01,
     &   5.1000E+01, 5.2000E+01, 5.3000E+01, 5.4000E+01, 5.5000E+01,
     &   5.6000E+01, 5.7000E+01, 5.8000E+01, 5.9000E+01, 6.0000E+01,
     &   6.1000E+01, 6.2000E+01, 6.3000E+01, 6.4000E+01, 6.5000E+01,
     &   6.6000E+01, 6.7000E+01, 6.8000E+01, 6.9000E+01, 7.0000E+01,
     &   7.1000E+01, 7.2000E+01, 7.3000E+01, 7.4000E+01, 7.5000E+01,
     &   7.6000E+01, 7.7000E+01, 7.8000E+01, 7.9000E+01, 8.0000E+01,
     &   8.1000E+01, 8.2000E+01, 8.3000E+01, 8.4000E+01, 8.5000E+01,
     &   8.6000E+01, 8.7000E+01, 8.8000E+01, 8.9000E+01, 9.0000E+01,
     &   9.1000E+01, 9.2000E+01, 9.3000E+01, 9.4000E+01, 9.5000E+01,
     &   9.6000E+01, 9.7000E+01, 9.8000E+01, 9.9000E+01, 1.0000E+02,
     &   1.0900E+02, 1.1800E+02, 1.2700E+02, 1.3600E+02, 1.4500E+02,
     &   1.5400E+02, 1.6300E+02, 1.7200E+02, 1.8100E+02, 1.9000E+02/
  
       DATA  (EMA  (I), I= 101, 200) /
     &   1.9900E+02, 2.0800E+02, 2.1700E+02, 2.2600E+02, 2.3500E+02,
     &   2.4400E+02, 2.5300E+02, 2.6200E+02, 2.7100E+02, 2.8000E+02,
     &   2.8900E+02, 2.9800E+02, 3.0700E+02, 3.1600E+02, 3.2500E+02,
     &   3.3400E+02, 3.4300E+02, 3.5200E+02, 3.6100E+02, 3.7000E+02,
     &   3.7900E+02, 3.8800E+02, 3.9700E+02, 4.0600E+02, 4.1500E+02,
     &   4.2400E+02, 4.3300E+02, 4.4200E+02, 4.5100E+02, 4.6000E+02,
     &   4.6900E+02, 4.7800E+02, 4.8700E+02, 4.9600E+02, 5.0500E+02,
     &   5.1400E+02, 5.2300E+02, 5.3200E+02, 5.4100E+02, 5.5000E+02,
     &   5.5900E+02, 5.6800E+02, 5.7700E+02, 5.8600E+02, 5.9500E+02,
     &   6.0400E+02, 6.1300E+02, 6.2200E+02, 6.3100E+02, 6.4000E+02,
     &   6.4900E+02, 6.5800E+02, 6.6700E+02, 6.7600E+02, 6.8500E+02,
     &   6.9400E+02, 7.0300E+02, 7.1200E+02, 7.2100E+02, 7.3000E+02,
     &   7.3900E+02, 7.4800E+02, 7.5700E+02, 7.6600E+02, 7.7500E+02,
     &   7.8400E+02, 7.9300E+02, 8.0200E+02, 8.1100E+02, 8.2000E+02,
     &   8.2900E+02, 8.3800E+02, 8.4700E+02, 8.5600E+02, 8.6500E+02,
     &   8.7400E+02, 8.8300E+02, 8.9200E+02, 9.0100E+02, 9.1000E+02,
     &   9.1900E+02, 9.2800E+02, 9.3700E+02, 9.4600E+02, 9.5500E+02,
     &   9.6400E+02, 9.7300E+02, 9.8200E+02, 9.9100E+02, 1.0000E+03,
     &   2.0000E+03, 3.0000E+03, 4.0000E+03, 5.0000E+03, 6.0000E+03,
     &   8.0000E+03, 1.0000E+04, 1.2000E+04, 1.4000E+04, 2.0000E+04/
  
  
         DATA ((DAM  (I,J), I=   1, 100), J=1,1) /
     &   1.5757E-02, 1.6058E-02, 1.6271E-02, 1.6506E-02, 1.6729E-02,
     &   1.7145E-02, 1.7530E-02, 1.7888E-02, 1.8224E-02, 1.8541E-02,
     &   1.8839E-02, 1.9233E-02, 1.9394E-02, 1.9652E-02, 1.9899E-02,
     &   2.0137E-02, 2.0364E-02, 2.0583E-02, 2.0794E-02, 2.0997E-02,
     &   2.1194E-02, 2.1384E-02, 2.1568E-02, 2.1749E-02, 2.1952E-02,
     &   2.2088E-02, 2.2251E-02, 2.2410E-02, 2.2566E-02, 2.2717E-02,
     &   2.2863E-02, 2.3006E-02, 2.3154E-02, 2.3283E-02, 2.3416E-02,
     &   2.3610E-02, 2.3675E-02, 2.3800E-02, 2.3922E-02, 2.4042E-02,
     &   2.4160E-02, 2.4275E-02, 2.4388E-02, 2.4523E-02, 2.4608E-02,
     &   2.4715E-02, 2.4820E-02, 2.5046E-02, 2.5024E-02, 2.5124E-02,
     &   2.5221E-02, 2.5318E-02, 2.5413E-02, 2.5506E-02, 2.5598E-02,
     &   2.5688E-02, 2.5777E-02, 2.5865E-02, 2.5951E-02, 2.6036E-02,
     &   2.6120E-02, 2.6203E-02, 2.6285E-02, 2.6365E-02, 2.6445E-02,
     &   2.6523E-02, 2.6600E-02, 2.6677E-02, 2.6752E-02, 2.6826E-02,
     &   2.6900E-02, 2.6972E-02, 2.7044E-02, 2.7115E-02, 2.7185E-02,
     &   2.7254E-02, 2.7323E-02, 2.7390E-02, 2.7457E-02, 2.7523E-02,
     &   2.7588E-02, 2.7653E-02, 2.7717E-02, 2.7780E-02, 2.7843E-02,
     &   2.7905E-02, 2.7966E-02, 2.8027E-02, 2.8087E-02, 2.8146E-02,
     &   2.8655E-02, 2.9125E-02, 2.9559E-02, 2.9964E-02, 3.0344E-02,
     &   3.0700E-02, 3.1037E-02, 3.1356E-02, 3.1658E-02, 3.1946E-02/
  
         DATA ((DAM  (I,J), I= 101, 200), J=1,1) /
     &   3.2221E-02, 3.2485E-02, 3.2737E-02, 3.2979E-02, 3.3212E-02,
     &   3.3437E-02, 3.3654E-02, 3.3863E-02, 3.4066E-02, 3.4263E-02,
     &   3.4453E-02, 3.4638E-02, 3.4818E-02, 3.4993E-02, 3.5163E-02,
     &   3.5329E-02, 3.5490E-02, 3.5648E-02, 3.5804E-02, 3.5956E-02,
     &   3.6105E-02, 3.6250E-02, 3.6392E-02, 3.6532E-02, 3.6669E-02,
     &   3.6803E-02, 3.6935E-02, 3.7065E-02, 3.7193E-02, 3.7318E-02,
     &   3.7442E-02, 3.7564E-02, 3.7684E-02, 3.7802E-02, 3.7913E-02,
     &   3.8016E-02, 3.8118E-02, 3.8218E-02, 3.8316E-02, 3.8412E-02,
     &   3.8507E-02, 3.8601E-02, 3.8693E-02, 3.8783E-02, 3.8873E-02,
     &   3.8961E-02, 3.9047E-02, 3.9132E-02, 3.9216E-02, 3.9299E-02,
     &   3.9381E-02, 3.9462E-02, 3.9541E-02, 3.9620E-02, 3.9697E-02,
     &   3.9773E-02, 3.9849E-02, 3.9923E-02, 3.9996E-02, 4.0069E-02,
     &   4.0141E-02, 4.0211E-02, 4.0281E-02, 4.0351E-02, 4.0419E-02,
     &   4.0486E-02, 4.0553E-02, 4.0619E-02, 4.0684E-02, 4.0749E-02,
     &   4.0813E-02, 4.0876E-02, 4.0938E-02, 4.1000E-02, 4.1061E-02,
     &   4.1122E-02, 4.1182E-02, 4.1241E-02, 4.1300E-02, 4.1358E-02,
     &   4.1415E-02, 4.1472E-02, 4.1529E-02, 4.1584E-02, 4.1640E-02,
     &   4.1695E-02, 4.1749E-02, 4.1803E-02, 4.1856E-02, 4.1909E-02,
     &   4.5956E-02, 4.8319E-02, 4.9996E-02, 5.1296E-02, 5.2356E-02,
     &   5.4030E-02, 5.5328E-02, 5.6387E-02, 5.7284E-02, 5.9356E-02/
  
  
         DATA ((DAM  (I,J), I=   1, 100), J=2,2) /
     &   5.8896E-05, 5.8082E-05, 5.7492E-05, 5.7036E-05, 5.6668E-05,
     &   5.6098E-05, 5.5672E-05, 5.5338E-05, 5.5069E-05, 5.4847E-05,
     &   5.4661E-05, 5.4504E-05, 5.4369E-05, 5.4252E-05, 5.4151E-05,
     &   5.4062E-05, 5.3983E-05, 5.3913E-05, 5.3850E-05, 5.3794E-05,
     &   5.3744E-05, 5.3698E-05, 5.3657E-05, 5.3620E-05, 5.3585E-05,
     &   5.3554E-05, 5.3525E-05, 5.3499E-05, 5.3474E-05, 5.3452E-05,
     &   5.3431E-05, 5.3411E-05, 5.3393E-05, 5.3377E-05, 5.3361E-05,
     &   5.3346E-05, 5.3333E-05, 5.3320E-05, 5.3308E-05, 5.3297E-05,
     &   5.3286E-05, 5.3276E-05, 5.3267E-05, 5.3258E-05, 5.3249E-05,
     &   5.3241E-05, 5.3234E-05, 5.3227E-05, 5.3220E-05, 5.3213E-05,
     &   5.3207E-05, 5.3201E-05, 5.3196E-05, 5.3191E-05, 5.3186E-05,
     &   5.3181E-05, 5.3176E-05, 5.3172E-05, 5.3167E-05, 5.3163E-05,
     &   5.3160E-05, 5.3156E-05, 5.3152E-05, 5.3149E-05, 5.3146E-05,
     &   5.3143E-05, 5.3139E-05, 5.3137E-05, 5.3134E-05, 5.3131E-05,
     &   5.3129E-05, 5.3126E-05, 5.3124E-05, 5.3121E-05, 5.3119E-05,
     &   5.3117E-05, 5.3115E-05, 5.3113E-05, 5.3111E-05, 5.3109E-05,
     &   5.3107E-05, 5.3105E-05, 5.3104E-05, 5.3102E-05, 5.3100E-05,
     &   5.3099E-05, 5.3097E-05, 5.3096E-05, 5.3095E-05, 5.3093E-05,
     &   5.3083E-05, 5.3074E-05, 5.3068E-05, 5.3062E-05, 5.3058E-05,
     &   5.3054E-05, 5.3051E-05, 5.3049E-05, 5.3047E-05, 5.3045E-05/
  
         DATA ((DAM  (I,J), I= 101, 200), J=2,2) /
     &   5.3043E-05, 5.3042E-05, 5.3040E-05, 5.3039E-05, 5.3038E-05,
     &   5.3037E-05, 5.3037E-05, 5.3036E-05, 5.3035E-05, 5.3035E-05,
     &   5.3034E-05, 5.3034E-05, 5.3033E-05, 5.3033E-05, 5.3032E-05,
     &   5.3032E-05, 5.3032E-05, 5.3032E-05, 5.3031E-05, 5.3031E-05,
     &   5.3031E-05, 5.3031E-05, 5.3030E-05, 5.3030E-05, 5.3030E-05,
     &   5.3030E-05, 5.3030E-05, 5.3030E-05, 5.3029E-05, 5.3029E-05,
     &   5.3029E-05, 5.3029E-05, 5.3029E-05, 5.3029E-05, 5.3029E-05,
     &   5.3029E-05, 5.3029E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05,
     &   5.3028E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05,
     &   5.3028E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05,
     &   5.3028E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05, 5.3028E-05,
     &   5.3028E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05, 5.3027E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05/
  
  
         DATA ((DAM  (I,J), I=   1, 100), J=3,3) /
     &   1.7217E-04, 1.6584E-04, 1.6174E-04, 1.5886E-04, 1.5670E-04,
     &   1.5365E-04, 1.5157E-04, 1.5004E-04, 1.4886E-04, 1.4792E-04,
     &   1.4716E-04, 1.4654E-04, 1.4600E-04, 1.4555E-04, 1.4516E-04,
     &   1.4483E-04, 1.4453E-04, 1.4427E-04, 1.4404E-04, 1.4384E-04,
     &   1.4366E-04, 1.4349E-04, 1.4334E-04, 1.4321E-04, 1.4309E-04,
     &   1.4298E-04, 1.4287E-04, 1.4278E-04, 1.4270E-04, 1.4262E-04,
     &   1.4254E-04, 1.4248E-04, 1.4241E-04, 1.4235E-04, 1.4230E-04,
     &   1.4226E-04, 1.4220E-04, 1.4216E-04, 1.4212E-04, 1.4208E-04,
     &   1.4204E-04, 1.4201E-04, 1.4198E-04, 1.4195E-04, 1.4192E-04,
     &   1.4189E-04, 1.4186E-04, 1.4186E-04, 1.4182E-04, 1.4180E-04,
     &   1.4178E-04, 1.4176E-04, 1.4174E-04, 1.4172E-04, 1.4170E-04,
     &   1.4169E-04, 1.4167E-04, 1.4166E-04, 1.4164E-04, 1.4163E-04,
     &   1.4162E-04, 1.4160E-04, 1.4159E-04, 1.4158E-04, 1.4157E-04,
     &   1.4156E-04, 1.4155E-04, 1.4154E-04, 1.4153E-04, 1.4152E-04,
     &   1.4151E-04, 1.4151E-04, 1.4150E-04, 1.4149E-04, 1.4148E-04,
     &   1.4148E-04, 1.4147E-04, 1.4146E-04, 1.4146E-04, 1.4145E-04,
     &   1.4144E-04, 1.4144E-04, 1.4143E-04, 1.4143E-04, 1.4142E-04,
     &   1.4142E-04, 1.4141E-04, 1.4141E-04, 1.4140E-04, 1.4140E-04,
     &   1.4137E-04, 1.4134E-04, 1.4132E-04, 1.4131E-04, 1.4129E-04,
     &   1.4128E-04, 1.4128E-04, 1.4127E-04, 1.4126E-04, 1.4126E-04/
  
         DATA ((DAM  (I,J), I= 101, 200), J=3,3) /
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4126E-04, 1.4126E-04,
     &   1.4128E-04, 1.4129E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4131E-04, 1.4132E-04, 1.4132E-04, 1.4133E-04, 1.4134E-04/
  

c      ++++ deghadshigh23 ++++  

c update 09/25/25 
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 01:22:55 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN:  2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
         DATA ((DGM  (I,J), I=   1, 100), J=1,1) /
     &   3.1415E-02, 3.2084E-02, 3.2559E-02, 3.3071E-02, 3.3554E-02,
     &   3.4446E-02, 3.5264E-02, 3.6022E-02, 3.6729E-02, 3.7394E-02,
     &   3.8020E-02, 3.8840E-02, 3.9178E-02, 3.9716E-02, 4.0230E-02,
     &   4.0725E-02, 4.1195E-02, 4.1649E-02, 4.2087E-02, 4.2509E-02,
     &   4.2916E-02, 4.3310E-02, 4.3691E-02, 4.4067E-02, 4.4486E-02,
     &   4.4767E-02, 4.5105E-02, 4.5434E-02, 4.5756E-02, 4.6068E-02,
     &   4.6370E-02, 4.6666E-02, 4.6973E-02, 4.7238E-02, 4.7514E-02,
     &   4.7915E-02, 4.8048E-02, 4.8306E-02, 4.8559E-02, 4.8806E-02,
     &   4.9049E-02, 4.9287E-02, 4.9520E-02, 4.9798E-02, 4.9974E-02,
     &   5.0194E-02, 5.0411E-02, 5.0882E-02, 5.0833E-02, 5.1038E-02,
     &   5.1240E-02, 5.1439E-02, 5.1635E-02, 5.1827E-02, 5.2017E-02,
     &   5.2203E-02, 5.2387E-02, 5.2568E-02, 5.2746E-02, 5.2922E-02,
     &   5.3095E-02, 5.3266E-02, 5.3434E-02, 5.3600E-02, 5.3764E-02,
     &   5.3926E-02, 5.4085E-02, 5.4243E-02, 5.4398E-02, 5.4552E-02,
     &   5.4703E-02, 5.4853E-02, 5.5001E-02, 5.5147E-02, 5.5291E-02,
     &   5.5434E-02, 5.5575E-02, 5.5714E-02, 5.5852E-02, 5.5988E-02,
     &   5.6123E-02, 5.6256E-02, 5.6388E-02, 5.6518E-02, 5.6648E-02,
     &   5.6775E-02, 5.6902E-02, 5.7027E-02, 5.7150E-02, 5.7273E-02,
     &   5.8324E-02, 5.9291E-02, 6.0187E-02, 6.1023E-02, 6.1805E-02,
     &   6.2540E-02, 6.3234E-02, 6.3891E-02, 6.4515E-02, 6.5109E-02/
  
         DATA ((DGM  (I,J), I= 101, 200), J=1,1) /
     &   6.5676E-02, 6.6218E-02, 6.6739E-02, 6.7238E-02, 6.7719E-02,
     &   6.8182E-02, 6.8629E-02, 6.9061E-02, 6.9479E-02, 6.9884E-02,
     &   7.0277E-02, 7.0658E-02, 7.1029E-02, 7.1389E-02, 7.1740E-02,
     &   7.2082E-02, 7.2414E-02, 7.2740E-02, 7.3062E-02, 7.3375E-02,
     &   7.3681E-02, 7.3981E-02, 7.4274E-02, 7.4562E-02, 7.4844E-02,
     &   7.5121E-02, 7.5393E-02, 7.5661E-02, 7.5924E-02, 7.6183E-02,
     &   7.6438E-02, 7.6689E-02, 7.6936E-02, 7.7181E-02, 7.7408E-02,
     &   7.7621E-02, 7.7831E-02, 7.8037E-02, 7.8239E-02, 7.8439E-02,
     &   7.8634E-02, 7.8827E-02, 7.9017E-02, 7.9204E-02, 7.9387E-02,
     &   7.9569E-02, 7.9747E-02, 7.9923E-02, 8.0096E-02, 8.0267E-02,
     &   8.0435E-02, 8.0602E-02, 8.0765E-02, 8.0927E-02, 8.1086E-02,
     &   8.1244E-02, 8.1399E-02, 8.1553E-02, 8.1704E-02, 8.1854E-02,
     &   8.2002E-02, 8.2147E-02, 8.2292E-02, 8.2434E-02, 8.2575E-02,
     &   8.2714E-02, 8.2852E-02, 8.2988E-02, 8.3122E-02, 8.3255E-02,
     &   8.3387E-02, 8.3517E-02, 8.3646E-02, 8.3773E-02, 8.3899E-02,
     &   8.4024E-02, 8.4147E-02, 8.4270E-02, 8.4390E-02, 8.4510E-02,
     &   8.4629E-02, 8.4746E-02, 8.4863E-02, 8.4978E-02, 8.5092E-02,
     &   8.5205E-02, 8.5317E-02, 8.5428E-02, 8.5537E-02, 8.5646E-02,
     &   9.3989E-02, 9.8861E-02, 1.0232E-01, 1.0500E-01, 1.0718E-01,
     &   1.1063E-01, 1.1331E-01, 1.1549E-01, 1.1734E-01, 1.2161E-01/
  
  
         DATA ((DGM  (I,J), I=   1, 100), J=2,2) /
     &   1.0649E-04, 1.0299E-04, 1.0065E-04, 9.8962E-05, 9.7677E-05,
     &   9.5835E-05, 9.4564E-05, 9.3627E-05, 9.2906E-05, 9.2334E-05,
     &   9.1868E-05, 9.1482E-05, 9.1158E-05, 9.0882E-05, 9.0644E-05,
     &   9.0438E-05, 9.0258E-05, 9.0099E-05, 8.9959E-05, 8.9834E-05,
     &   8.9722E-05, 8.9621E-05, 8.9530E-05, 8.9448E-05, 8.9373E-05,
     &   8.9305E-05, 8.9242E-05, 8.9185E-05, 8.9132E-05, 8.9084E-05,
     &   8.9039E-05, 8.8997E-05, 8.8959E-05, 8.8923E-05, 8.8890E-05,
     &   8.8858E-05, 8.8829E-05, 8.8802E-05, 8.8777E-05, 8.8753E-05,
     &   8.8730E-05, 8.8709E-05, 8.8689E-05, 8.8670E-05, 8.8652E-05,
     &   8.8635E-05, 8.8620E-05, 8.8604E-05, 8.8590E-05, 8.8577E-05,
     &   8.8564E-05, 8.8551E-05, 8.8540E-05, 8.8529E-05, 8.8518E-05,
     &   8.8508E-05, 8.8498E-05, 8.8489E-05, 8.8480E-05, 8.8472E-05,
     &   8.8463E-05, 8.8456E-05, 8.8448E-05, 8.8441E-05, 8.8434E-05,
     &   8.8428E-05, 8.8421E-05, 8.8415E-05, 8.8410E-05, 8.8404E-05,
     &   8.8399E-05, 8.8393E-05, 8.8388E-05, 8.8383E-05, 8.8379E-05,
     &   8.8374E-05, 8.8370E-05, 8.8366E-05, 8.8362E-05, 8.8358E-05,
     &   8.8354E-05, 8.8350E-05, 8.8347E-05, 8.8343E-05, 8.8340E-05,
     &   8.8337E-05, 8.8334E-05, 8.8331E-05, 8.8328E-05, 8.8325E-05,
     &   8.8303E-05, 8.8285E-05, 8.8272E-05, 8.8261E-05, 8.8252E-05,
     &   8.8244E-05, 8.8238E-05, 8.8232E-05, 8.8228E-05, 8.8224E-05/
  
         DATA ((DGM  (I,J), I= 101, 200), J=2,2) /
     &   8.8221E-05, 8.8218E-05, 8.8215E-05, 8.8213E-05, 8.8211E-05,
     &   8.8209E-05, 8.8207E-05, 8.8206E-05, 8.8204E-05, 8.8203E-05,
     &   8.8202E-05, 8.8201E-05, 8.8200E-05, 8.8199E-05, 8.8199E-05,
     &   8.8198E-05, 8.8197E-05, 8.8197E-05, 8.8196E-05, 8.8196E-05,
     &   8.8195E-05, 8.8195E-05, 8.8194E-05, 8.8194E-05, 8.8194E-05,
     &   8.8193E-05, 8.8193E-05, 8.8193E-05, 8.8192E-05, 8.8192E-05,
     &   8.8192E-05, 8.8192E-05, 8.8191E-05, 8.8191E-05, 8.8191E-05,
     &   8.8191E-05, 8.8191E-05, 8.8190E-05, 8.8190E-05, 8.8190E-05,
     &   8.8190E-05, 8.8190E-05, 8.8190E-05, 8.8190E-05, 8.8189E-05,
     &   8.8189E-05, 8.8189E-05, 8.8189E-05, 8.8189E-05, 8.8189E-05,
     &   8.8189E-05, 8.8189E-05, 8.8189E-05, 8.8189E-05, 8.8188E-05,
     &   8.8188E-05, 8.8188E-05, 8.8188E-05, 8.8188E-05, 8.8188E-05,
     &   8.8188E-05, 8.8188E-05, 8.8188E-05, 8.8188E-05, 8.8188E-05,
     &   8.8188E-05, 8.8188E-05, 8.8188E-05, 8.8188E-05, 8.8188E-05,
     &   8.8188E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05,
     &   8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05,
     &   8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05,
     &   8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05, 8.8187E-05,
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05,
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05/
  
  
         DATA ((DGM  (I,J), I=   1, 100), J=3,3) /
     &   3.5733E-04, 3.2802E-04, 3.0915E-04, 2.9613E-04, 2.8663E-04,
     &   2.7368E-04, 2.6529E-04, 2.5941E-04, 2.5506E-04, 2.5173E-04,
     &   2.4910E-04, 2.4701E-04, 2.4522E-04, 2.4375E-04, 2.4251E-04,
     &   2.4145E-04, 2.4052E-04, 2.3972E-04, 2.3902E-04, 2.3840E-04,
     &   2.3785E-04, 2.3736E-04, 2.3692E-04, 2.3652E-04, 2.3618E-04,
     &   2.3583E-04, 2.3554E-04, 2.3527E-04, 2.3502E-04, 2.3479E-04,
     &   2.3458E-04, 2.3439E-04, 2.3422E-04, 2.3404E-04, 2.3389E-04,
     &   2.3378E-04, 2.3361E-04, 2.3348E-04, 2.3337E-04, 2.3326E-04,
     &   2.3316E-04, 2.3306E-04, 2.3297E-04, 2.3290E-04, 2.3280E-04,
     &   2.3273E-04, 2.3266E-04, 2.3266E-04, 2.3252E-04, 2.3246E-04,
     &   2.3241E-04, 2.3235E-04, 2.3230E-04, 2.3225E-04, 2.3220E-04,
     &   2.3216E-04, 2.3211E-04, 2.3207E-04, 2.3204E-04, 2.3200E-04,
     &   2.3196E-04, 2.3193E-04, 2.3190E-04, 2.3187E-04, 2.3184E-04,
     &   2.3181E-04, 2.3178E-04, 2.3175E-04, 2.3173E-04, 2.3170E-04,
     &   2.3168E-04, 2.3166E-04, 2.3164E-04, 2.3162E-04, 2.3160E-04,
     &   2.3158E-04, 2.3156E-04, 2.3154E-04, 2.3152E-04, 2.3151E-04,
     &   2.3149E-04, 2.3148E-04, 2.3146E-04, 2.3145E-04, 2.3143E-04,
     &   2.3142E-04, 2.3141E-04, 2.3139E-04, 2.3138E-04, 2.3137E-04,
     &   2.3128E-04, 2.3121E-04, 2.3116E-04, 2.3111E-04, 2.3108E-04,
     &   2.3105E-04, 2.3103E-04, 2.3101E-04, 2.3100E-04, 2.3098E-04/
  
         DATA ((DGM  (I,J), I= 101, 200), J=3,3) /
     &   2.3097E-04, 2.3096E-04, 2.3096E-04, 2.3095E-04, 2.3095E-04,
     &   2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04,
     &   2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04,
     &   2.3094E-04, 2.3094E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04,
     &   2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04,
     &   2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3096E-04, 2.3096E-04,
     &   2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04,
     &   2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3097E-04,
     &   2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04,
     &   2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04,
     &   2.3097E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3104E-04, 2.3107E-04, 2.3110E-04, 2.3112E-04, 2.3112E-04,
     &   2.3115E-04, 2.3117E-04, 2.3117E-04, 2.3119E-04, 2.3122E-04/
  
       save
       RETURN
       END

      
