CCCCCCCCCCCCCCCCCCCCCCCCCCCCC -*- Mode: Fortran -*- CCCCCCCCCCCCCCCCCCCCCCCCCCC
CC hadr5x23_complex.f -- 
CC Author          : Fred Jegerlehner
CC Created On      : Tue Sep 23 11:03:25 2025
CC Last Modified By: Fred Jegerlehner
CC Last Modified On: Tue Sep 30 10:41:44 2025
CC RCS: $Id$
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC Copyright (C) 2025 Friedrich Jegerlehner
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
c;;
      subroutine chadr5x25(e,st2,cder,cerrdersta,cerrdersys,
     &     cdeg,cerrdegsta,cerrdegsys)
c Provides real part of 5 flavor hadronic contribution to photon vacuum polarization
c single precision HADR5 ; double precision DHADR5
c ******************************************************************
c *                                                                *
c *      subroutine for the evaluation of the light hadron         *
c *           contributions to Delta_r  and  Delta_g               *
c *                    using fits to the                           *
c *          QED vacuum polarization from e^+ e^- data             *
c *                                                                *
c *    F. Jegerlehner, Institut fr Physik                         *
c *                    Humboldt-Universitt zu Berlin              *
c *                    Newtonstrae 15, D-12489 Berlin, Germany    *
c *    E-mail: fjeger@physik.hu-berlin.de                          *
c *    Phone :   +49-3375 500 277                                  *
c *                                                                *
c *    Reference: F. Jegerlehner, Z. Phys. C32 (1986) 195          *
c *               H. Burkhardt et al., Z. Phys. C42 (1989) 497     *
c *               S. Eidelman, F. Jegerlehner, Z. Phys. C (1995)   *
c *               F. Jegerlehner,                                  *
c *                    Nucl.Phys.Proc.Suppl.131:213-222,2004       *
c *                    Nucl.Phys.Proc.Suppl.162:22-32,2006         *
c *                    Nucl.Phys.Proc.Suppl.181-182:135-140,2008   *
c *                                                                *
c ******************************************************************
c       VERSION: 21/10/2025
c
C  Notation: E energy ( momentum transfer ): E>0 timelike , E<0 spacelike
c      sin2ell=0.23153 ! pm 0.00016 LEPEEWG Phys Rep 427 (2006) 257
C            st2 is sin^2(Theta); st2=0.23153 is the reference value
C  the routine returns the hadronic contribution of 5 flavors (u,d,s,c,b)
C                 to   DER=Delta_r with hadronic error ERRDER
C                and   DEG=Delta_g with hadronic error ERRDEG
C  The effective value of the fine structure constant alphaQED at energy
C  E is alphaQED(E)=alphaQED(0)/(1-Delta_r) ,similarly for the SU(2)
C  coupling alphaSU2(E)=alphaSU2(0)/(1-Delta_g), where Delta_r(g) is the
C  sum of leptonic, hadronic contributions (top to be added).
C
      IMPLICIT NONE
      INTEGER NA,NB,NC,IJ,I,ini
      PARAMETER(NA=979,NB=2193,NC=200)
      real e,st2,der,errdersta,errdersys,deg,errdegsta,errdegsys,fac
      real null,one
      real dal(3),dg2(3)
      complex *8 cal(3),cg2(3)
      complex *8 cder,cdeg,cerrdersta,cerrdegsta,
     &     cerrdersys,cerrdegsys
      complex *8 cnull,cone,cfac
      REAL ETA(NA),DAT(NA,3),DGT(NA,3)
      REAL ESA(NB)
      COMPLEX *8 CAS(NB,3),CGS(NB,3)
      REAL EMA(NC)
      COMPLEX *8 CAM(NC,3),CGM(NC,3)
      REAL XXX(NC),YGG(NC,3),Y3G(NC,3)
      REAL    RDEN,RNUM
      COMPLEX *8 CDEN,CNUM
      COMMON /DATM25c/EMA,CAM,CGM
      COMMON /DATT25r/ETA,DAT,DGT
      COMMON /DATS25c/ESA,CAS,CGS
      COMMON /DATH25r/XXX,YGG,Y3G
      data ini/0/
C initialize data

      call ralhad_spacelike25

      call ralhad_spacelike1h25

      call calhad_timelike25c    ! complex version

      call calhad_timelike1h25c  ! complex version


c     boundaries of data sets
c space-like high region            -2.0000E+04  - -1.0000E+03    (XXX,YGG)  [200]
c space-like and unphysical region  -1.0000E+03  - +0.27700001D0  (ETA,DAT)  [979]
c time-like R data range            0.27914036D0 - 40.00000000D0  (ESA,CAS) [2193]
c time-like1 pQCD range             1.3000E+01D0 -  2.0000E+04    (EMA,CAM)  [200]
c 2 pion threshold at 0.27914....
c XXX(1) --- XXX(NC),ETA(1) --- ETA(NA),ESA(1) --- ESA(NB),EMA(1) --- EMA(NC)      
      null=0.0
      one =1.0
      cnull=CMPLX(null,null)
      cone =CMPLX(one ,null)
      if (st2.eq.null) then
         st2=0.23153d0
      endif
      fac=0.23153d0/st2
      cfac=CMPLX(fac,null)
      if (e.eq.null) then
        der=null
        errdersta=null
        errdersys=null
        deg=null
        errdegsta=null
        errdegsys=null
        cder=cnull
        cerrdersta=cnull
        cerrdersys=cnull
        cdeg=cnull
        cerrdegsta=cnull
        cerrdegsys=cnull
        return
c first bridge cracks between regions
      else if ((e.ge.XXX(NC)).and.(e.lt.ETA(1))) then
         RDEN=(ETA(1)-XXX(NC))
         RNUM=(E-XXX(NC))
        DO I=1,3
        dal(i)=YGG(NC,I)
     &    +(DAT(1,I)-YGG(NC,I))/RDEN*RNUM
        dg2(i)=Y3G(NC,I)
     &       +(DAT(1,I)-Y3G(NC,I))/RDEN*RNUM
        ENDDO
        cder=CMPLX(dal(1))
        cerrdersta=CMPLX(dal(2))
        cerrdersys=CMPLX(dal(3))
        cdeg=CMPLX(dg2(1)*fac)
        cerrdegsta=CMPLX(dg2(2)*fac)
        cerrdegsys=CMPLX(dg2(3)*fac)
        return
      else if ((e.ge.ETA(NA)).and.(e.lt.ESA(1))) then
        CDEN=CMPLX((ESA(1)-ETA(NA)))
        CNUM=CMPLX((E-ETA(NA)))
        DO I=1,3
        cal(i)=CMPLX(DAT(NA,I))
     &    +(CAS(1,I)-CMPLX(DAT(NA,I)))/CDEN*CNUM
        cg2(i)=CMPLX(DGT(NA,I))
     &    +(CGS(1,I)-CMPLX(DGT(NA,I)))/CDEN*CNUM
        ENDDO
        cder=cal(1)
        cerrdersta=cal(2)
        cerrdersys=cal(3)
        cdeg=cg2(1)*cfac
        cerrdegsta=cg2(2)*cfac
        cerrdegsys=cg2(3)*cfac
        return
      else if ((e.lt.ETA(NA)).and.(e.ge.ETA(1))) then
        ij=NA
        do while (ETA(ij).gt.e)
          ij=ij-1
        enddo
        RDEN=(ETA(IJ+1)-ETA(IJ))
        RNUM=(E-ETA(IJ))
        DO I=1,3
        dal(i)=DAT(IJ,I)
     &    +(DAT(IJ+1,I)-DAT(IJ,I))/RDEN*RNUM
        dg2(i)=DGT(IJ,I)
     &    +(DGT(IJ+1,I)-DGT(IJ,I))/RDEN*RNUM
        ENDDO
        cder=CMPLX(dal(1))
        cerrdersta=CMPLX(dal(2))
        cerrdersys=CMPLX(dal(3))
        cdeg=CMPLX(dg2(1)*fac)
        cerrdegsta=CMPLX(dg2(2)*fac)
        cerrdegsys=CMPLX(dg2(3)*fac)
        return
      else if ((e.lt.EMA(NC)).and.(e.ge.EMA(1))) then
        ij=NC
        do while (EMA(ij).gt.e)
          ij=ij-1
        enddo
        CDEN=CMPLX((EMA(IJ+1)-EMA(IJ)))
        CNUM=CMPLX((E-EMA(IJ)))
        DO I=1,3
        cal(i)=CAM(IJ,I)
     &      +(CAM(IJ+1,I)-CAM(IJ,I))/CDEN*CNUM
        cg2(i)=CGM(IJ,I)
     &      +(CGM(IJ+1,I)-CGM(IJ,I))/CDEN*CNUM
        ENDDO
        cder=cal(1)
        cerrdersta=cal(2)
        cerrdersys=cal(3)
        cdeg=cg2(1)*cfac
        cerrdegsta=cg2(2)*cfac
        cerrdegsys=cg2(3)*cfac
        return
c### end point
      else if (e.eq.EMA(NC)) then
         ij=NC
         DO I=1,3
            cal(i)=CAM(IJ,I)
            cg2(i)=CGM(IJ,I)
         ENDDO
         cder=cal(1)
         cerrdersta=cal(2)
         cerrdersys=cal(3)
         cdeg=cg2(1)*cfac
         cerrdegsta=cg2(2)*cfac
         cerrdegsys=cg2(3)*cfac
         return
c ##        
      else if ((e.lt.ESA(NB)).and.(e.ge.ESA(1))) then
        if ((e.gt.3.96).and.(e.lt.4.52).and.(ini.eq.0)) then
c           write (*,*) ' ******************************************'
c           write (*,*) ' * Note: fluctuations in the Psi(4,5,6)   *'
c           write (*,*) ' * region are because we are using the    *'
c           write (*,*) ' * CB and BES data without any smoothing  *'
c           write (*,*) ' *********** FJ@HU Berlin *****************'
           ini=1
        endif
        ij=NB
        do while (ESA(ij).gt.e)
          ij=ij-1
        enddo
        CDEN=CMPLX((ESA(IJ+1)-ESA(IJ)))
        CNUM=CMPLX((E-ESA(IJ)))
        DO I=1,3
        cal(i)=CAS(IJ,I)
     &    +(CAS(IJ+1,I)-CAS(IJ,I))/CDEN*CNUM
        cg2(i)=CGS(IJ,I)
     &       +(CGS(IJ+1,I)-CGS(IJ,I))/CDEN*CNUM
        ENDDO
        cder=cal(1)
        cerrdersta=cal(2)
        cerrdersys=cal(3)
        cdeg=cg2(1)*cfac
        cerrdegsta=cg2(2)*cfac
        cerrdegsys=cg2(3)*cfac
        return
      else if ((e.lt.XXX(NC)).and.(e.ge.XXX(1))) then
        ij=NC
        do while (XXX(ij).gt.e)
          ij=ij-1
        enddo
        RDEN=(XXX(IJ+1)-XXX(IJ))
        RNUM=(E-XXX(IJ))
        DO I=1,3
        dal(i)=YGG(IJ,I)
     &    +(YGG(IJ+1,I)-YGG(IJ,I))/RDEN*RNUM
        dg2(i)=Y3G(IJ,I)
     &       +(Y3G(IJ+1,I)-Y3G(IJ,I))/RDEN*RNUM
        ENDDO
        cder=CMPLX(dal(1))
        cerrdersta=CMPLX(dal(2))
        cerrdersys=CMPLX(dal(3))
        cdeg=CMPLX(dg2(1)*fac)
        cerrdegsta=CMPLX(dg2(2)*fac)
        cerrdegsys=CMPLX(dg2(3)*fac)
        return
      else
         if (ini.le.10) then
            write(*,*) ' <chadr5x25> out of range! e=',e
            ini=ini+1
            if (ini.eq.10) write(*,*) ' Warning: continuing anyway ...'
         endif
      endif
      return
      end

       subroutine dchadr5x25(de,dst2,dcder,dcerrdersta,dcerrdersys,
     &     dcdeg,dcerrdegsta,dcerrdegsys)
c **********************************************************************
c *    F. Jegerlehner, University of Silesia, PL-40007 Katowice, Poland *
c **********************************************************************
c Converts chadr5x to double complex precision variables in dchadr5x
c
       implicit none
       double precision de,dst2
       double complex dcder,dcdeg,dcerrdersta,dcerrdersys,
     &      dcerrdegsta,dcerrdegsys
       real    se,sst2
       complex *8 cder,cdeg,cerrdersta,cerrdersys,
     &      cerrdegsta,cerrdegsys
       se  =sngl(de)
       sst2=sngl(dst2)
       call chadr5x25(se,sst2,cder,cerrdersta,cerrdersys,cdeg,
     &      cerrdegsta,cerrdegsys)
       dcder   =dcmplx(cder)
       dcdeg   =dcmplx(cdeg)
       dcerrdersta=dcmplx(cerrdersta)
       dcerrdersys=dcmplx(cerrdersys)
       dcerrdegsta=dcmplx(cerrdegsta)
       dcerrdegsys=dcmplx(cerrdegsys)
       return
       end
c
c Following datasets obtained with run parameters specified in the header
c
C      include 'dalhadt23_5.f'   ! including deghadt23_5.f
C
C      include 'dalhadthigh23_5.f' ! including deghadthigh23_5.f
C
C      include 'dalhadslow23_5.f' ! including deghadslow23_5.f
C
C      include 'dalhadshigh23_5.f'  ! including deghadshigh23_5.f


c      ++++ dalhadt23 ++++  

c update 09/25/25 
       subroutine ralhad_spacelike25
       IMPLICIT NONE
       INTEGER NA,I,J
       PARAMETER(NA=979)
       REAL ETA(NA),DAT(NA,3),DGT(NA,3)
       COMMON /DATT25r/ETA,DAT,DGT
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 14:28:50 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
       DATA  (ETA  (I), I=   1, 100) /
     &  -1.0000E+03,-9.9000E+02,-9.8000E+02,-9.7000E+02,-9.6000E+02,
     &  -9.5000E+02,-9.4000E+02,-9.3000E+02,-9.2000E+02,-9.1000E+02,
     &  -9.0000E+02,-8.9000E+02,-8.8000E+02,-8.7000E+02,-8.6000E+02,
     &  -8.5000E+02,-8.4000E+02,-8.3000E+02,-8.2000E+02,-8.1000E+02,
     &  -8.0000E+02,-7.9000E+02,-7.8000E+02,-7.7000E+02,-7.6000E+02,
     &  -7.5000E+02,-7.4000E+02,-7.3000E+02,-7.2000E+02,-7.1000E+02,
     &  -7.0000E+02,-6.9000E+02,-6.8000E+02,-6.7000E+02,-6.6000E+02,
     &  -6.5000E+02,-6.4000E+02,-6.3000E+02,-6.2000E+02,-6.1000E+02,
     &  -6.0000E+02,-5.9000E+02,-5.8000E+02,-5.7000E+02,-5.6000E+02,
     &  -5.5000E+02,-5.4000E+02,-5.3000E+02,-5.2000E+02,-5.1000E+02,
     &  -5.0000E+02,-4.9000E+02,-4.8000E+02,-4.7000E+02,-4.6000E+02,
     &  -4.5000E+02,-4.4000E+02,-4.3000E+02,-4.2000E+02,-4.1000E+02,
     &  -4.0000E+02,-3.9000E+02,-3.8000E+02,-3.7000E+02,-3.6000E+02,
     &  -3.5000E+02,-3.4000E+02,-3.3000E+02,-3.2000E+02,-3.1000E+02,
     &  -3.0000E+02,-2.9000E+02,-2.8000E+02,-2.7000E+02,-2.6000E+02,
     &  -2.5000E+02,-2.4000E+02,-2.3000E+02,-2.2000E+02,-2.1000E+02,
     &  -2.0000E+02,-1.9000E+02,-1.8000E+02,-1.7000E+02,-1.6000E+02,
     &  -1.5000E+02,-1.4000E+02,-1.3000E+02,-1.2000E+02,-1.1000E+02,
     &  -1.0000E+02,-9.9000E+01,-9.8000E+01,-9.7000E+01,-9.6000E+01,
     &  -9.5000E+01,-9.4000E+01,-9.3000E+01,-9.2000E+01,-9.1000E+01/
  
       DATA  (ETA  (I), I= 101, 200) /
     &  -9.0000E+01,-8.9000E+01,-8.8000E+01,-8.7000E+01,-8.6000E+01,
     &  -8.5000E+01,-8.4000E+01,-8.3000E+01,-8.2000E+01,-8.1000E+01,
     &  -8.0000E+01,-7.9000E+01,-7.8000E+01,-7.7000E+01,-7.6000E+01,
     &  -7.5000E+01,-7.4000E+01,-7.3000E+01,-7.2000E+01,-7.1000E+01,
     &  -7.0000E+01,-6.9000E+01,-6.8000E+01,-6.7000E+01,-6.6000E+01,
     &  -6.5000E+01,-6.4000E+01,-6.3000E+01,-6.2000E+01,-6.1000E+01,
     &  -6.0000E+01,-5.9000E+01,-5.8000E+01,-5.7000E+01,-5.6000E+01,
     &  -5.5000E+01,-5.4000E+01,-5.3000E+01,-5.2000E+01,-5.1000E+01,
     &  -5.0000E+01,-4.9000E+01,-4.8000E+01,-4.7000E+01,-4.6000E+01,
     &  -4.5000E+01,-4.4000E+01,-4.3000E+01,-4.2000E+01,-4.1000E+01,
     &  -4.0000E+01,-3.9000E+01,-3.8000E+01,-3.7000E+01,-3.6000E+01,
     &  -3.5000E+01,-3.4000E+01,-3.3000E+01,-3.2000E+01,-3.1000E+01,
     &  -3.0000E+01,-2.9000E+01,-2.8000E+01,-2.7000E+01,-2.6000E+01,
     &  -2.5000E+01,-2.4000E+01,-2.3000E+01,-2.2000E+01,-2.1000E+01,
     &  -2.0000E+01,-1.9000E+01,-1.8000E+01,-1.7000E+01,-1.6000E+01,
     &  -1.5000E+01,-1.4000E+01,-1.3000E+01,-1.2000E+01,-1.1000E+01,
     &  -1.0000E+01,-9.9100E+00,-9.8200E+00,-9.7300E+00,-9.6400E+00,
     &  -9.5500E+00,-9.4600E+00,-9.3700E+00,-9.2800E+00,-9.1900E+00,
     &  -9.1000E+00,-9.0100E+00,-8.9200E+00,-8.8300E+00,-8.7400E+00,
     &  -8.6500E+00,-8.5600E+00,-8.4700E+00,-8.3800E+00,-8.2900E+00/
  
       DATA  (ETA  (I), I= 201, 300) /
     &  -8.2000E+00,-8.1100E+00,-8.0200E+00,-7.9300E+00,-7.8400E+00,
     &  -7.7500E+00,-7.6600E+00,-7.5700E+00,-7.4800E+00,-7.3900E+00,
     &  -7.3000E+00,-7.2100E+00,-7.1200E+00,-7.0300E+00,-6.9400E+00,
     &  -6.8500E+00,-6.7600E+00,-6.6700E+00,-6.5800E+00,-6.4900E+00,
     &  -6.4000E+00,-6.3100E+00,-6.2200E+00,-6.1300E+00,-6.0400E+00,
     &  -5.9500E+00,-5.8600E+00,-5.7700E+00,-5.6800E+00,-5.5900E+00,
     &  -5.5000E+00,-5.4100E+00,-5.3200E+00,-5.2300E+00,-5.1400E+00,
     &  -5.0500E+00,-4.9600E+00,-4.8700E+00,-4.7800E+00,-4.6900E+00,
     &  -4.6000E+00,-4.5100E+00,-4.4200E+00,-4.3300E+00,-4.2400E+00,
     &  -4.1500E+00,-4.0600E+00,-3.9700E+00,-3.8800E+00,-3.7900E+00,
     &  -3.7000E+00,-3.6100E+00,-3.5200E+00,-3.4300E+00,-3.3400E+00,
     &  -3.2500E+00,-3.1600E+00,-3.0700E+00,-2.9800E+00,-2.8900E+00,
     &  -2.8000E+00,-2.7100E+00,-2.6200E+00,-2.5300E+00,-2.4400E+00,
     &  -2.3500E+00,-2.2600E+00,-2.1700E+00,-2.0800E+00,-1.9900E+00,
     &  -1.9000E+00,-1.8100E+00,-1.7200E+00,-1.6300E+00,-1.5400E+00,
     &  -1.4500E+00,-1.3600E+00,-1.2700E+00,-1.1800E+00,-1.0900E+00,
     &  -1.0000E+00,-9.9100E-01,-9.8200E-01,-9.7300E-01,-9.6400E-01,
     &  -9.5500E-01,-9.4600E-01,-9.3700E-01,-9.2800E-01,-9.1900E-01,
     &  -9.1000E-01,-9.0100E-01,-8.9200E-01,-8.8300E-01,-8.7400E-01,
     &  -8.6500E-01,-8.5600E-01,-8.4700E-01,-8.3800E-01,-8.2900E-01/
  
       DATA  (ETA  (I), I= 301, 400) /
     &  -8.2000E-01,-8.1100E-01,-8.0200E-01,-7.9300E-01,-7.8400E-01,
     &  -7.7500E-01,-7.6600E-01,-7.5700E-01,-7.4800E-01,-7.3900E-01,
     &  -7.3000E-01,-7.2100E-01,-7.1200E-01,-7.0300E-01,-6.9400E-01,
     &  -6.8500E-01,-6.7600E-01,-6.6700E-01,-6.5800E-01,-6.4900E-01,
     &  -6.4000E-01,-6.3100E-01,-6.2200E-01,-6.1300E-01,-6.0400E-01,
     &  -5.9500E-01,-5.8600E-01,-5.7700E-01,-5.6800E-01,-5.5900E-01,
     &  -5.5000E-01,-5.4100E-01,-5.3200E-01,-5.2300E-01,-5.1400E-01,
     &  -5.0500E-01,-4.9600E-01,-4.8700E-01,-4.7800E-01,-4.6900E-01,
     &  -4.6000E-01,-4.5100E-01,-4.4200E-01,-4.3300E-01,-4.2400E-01,
     &  -4.1500E-01,-4.0600E-01,-3.9700E-01,-3.8800E-01,-3.7900E-01,
     &  -3.7000E-01,-3.6100E-01,-3.5200E-01,-3.4300E-01,-3.3400E-01,
     &  -3.2500E-01,-3.1600E-01,-3.0700E-01,-2.9800E-01,-2.8900E-01,
     &  -2.8000E-01,-2.7100E-01,-2.6200E-01,-2.5300E-01,-2.4400E-01,
     &  -2.3500E-01,-2.2600E-01,-2.1700E-01,-2.0800E-01,-1.9900E-01,
     &  -1.9000E-01,-1.8100E-01,-1.7200E-01,-1.6300E-01,-1.5400E-01,
     &  -1.4500E-01,-1.3600E-01,-1.2700E-01,-1.1800E-01,-1.0900E-01,
     &  -1.0000E-01,-9.9100E-02,-9.8200E-02,-9.7300E-02,-9.6400E-02,
     &  -9.5500E-02,-9.4600E-02,-9.3700E-02,-9.2800E-02,-9.1900E-02,
     &  -9.1000E-02,-9.0100E-02,-8.9200E-02,-8.8300E-02,-8.7400E-02,
     &  -8.6500E-02,-8.5600E-02,-8.4700E-02,-8.3800E-02,-8.2900E-02/
  
       DATA  (ETA  (I), I= 401, 500) /
     &  -8.2000E-02,-8.1100E-02,-8.0200E-02,-7.9300E-02,-7.8400E-02,
     &  -7.7500E-02,-7.6600E-02,-7.5700E-02,-7.4800E-02,-7.3900E-02,
     &  -7.3000E-02,-7.2100E-02,-7.1200E-02,-7.0300E-02,-6.9400E-02,
     &  -6.8500E-02,-6.7600E-02,-6.6700E-02,-6.5800E-02,-6.4900E-02,
     &  -6.4000E-02,-6.3100E-02,-6.2200E-02,-6.1300E-02,-6.0400E-02,
     &  -5.9500E-02,-5.8600E-02,-5.7700E-02,-5.6800E-02,-5.5900E-02,
     &  -5.5000E-02,-5.4100E-02,-5.3200E-02,-5.2300E-02,-5.1400E-02,
     &  -5.0500E-02,-4.9600E-02,-4.8700E-02,-4.7800E-02,-4.6900E-02,
     &  -4.6000E-02,-4.5100E-02,-4.4200E-02,-4.3300E-02,-4.2400E-02,
     &  -4.1500E-02,-4.0600E-02,-3.9700E-02,-3.8800E-02,-3.7900E-02,
     &  -3.7000E-02,-3.6100E-02,-3.5200E-02,-3.4300E-02,-3.3400E-02,
     &  -3.2500E-02,-3.1600E-02,-3.0700E-02,-2.9800E-02,-2.8900E-02,
     &  -2.8000E-02,-2.7100E-02,-2.6200E-02,-2.5300E-02,-2.4400E-02,
     &  -2.3500E-02,-2.2600E-02,-2.1700E-02,-2.0800E-02,-1.9900E-02,
     &  -1.9000E-02,-1.8100E-02,-1.7200E-02,-1.6300E-02,-1.5400E-02,
     &  -1.4500E-02,-1.3600E-02,-1.2700E-02,-1.1800E-02,-1.0900E-02,
     &  -1.0000E-02,-9.9100E-03,-9.8200E-03,-9.7300E-03,-9.6400E-03,
     &  -9.5500E-03,-9.4600E-03,-9.3700E-03,-9.2800E-03,-9.1900E-03,
     &  -9.1000E-03,-9.0100E-03,-8.9200E-03,-8.8300E-03,-8.7400E-03,
     &  -8.6500E-03,-8.5600E-03,-8.4700E-03,-8.3800E-03,-8.2900E-03/
  
       DATA  (ETA  (I), I= 501, 600) /
     &  -8.2000E-03,-8.1100E-03,-8.0200E-03,-7.9300E-03,-7.8400E-03,
     &  -7.7500E-03,-7.6600E-03,-7.5700E-03,-7.4800E-03,-7.3900E-03,
     &  -7.3000E-03,-7.2100E-03,-7.1200E-03,-7.0300E-03,-6.9400E-03,
     &  -6.8500E-03,-6.7600E-03,-6.6700E-03,-6.5800E-03,-6.4900E-03,
     &  -6.4000E-03,-6.3100E-03,-6.2200E-03,-6.1300E-03,-6.0400E-03,
     &  -5.9500E-03,-5.8600E-03,-5.7700E-03,-5.6800E-03,-5.5900E-03,
     &  -5.5000E-03,-5.4100E-03,-5.3200E-03,-5.2300E-03,-5.1400E-03,
     &  -5.0500E-03,-4.9600E-03,-4.8700E-03,-4.7800E-03,-4.6900E-03,
     &  -4.6000E-03,-4.5100E-03,-4.4200E-03,-4.3300E-03,-4.2400E-03,
     &  -4.1500E-03,-4.0600E-03,-3.9700E-03,-3.8800E-03,-3.7900E-03,
     &  -3.7000E-03,-3.6100E-03,-3.5200E-03,-3.4300E-03,-3.3400E-03,
     &  -3.2500E-03,-3.1600E-03,-3.0700E-03,-2.9800E-03,-2.8900E-03,
     &  -2.8000E-03,-2.7100E-03,-2.6200E-03,-2.5300E-03,-2.4400E-03,
     &  -2.3500E-03,-2.2600E-03,-2.1700E-03,-2.0800E-03,-1.9900E-03,
     &  -1.9000E-03,-1.8100E-03,-1.7200E-03,-1.6300E-03,-1.5400E-03,
     &  -1.4500E-03,-1.3600E-03,-1.2700E-03,-1.1800E-03,-1.0900E-03,
     &  -1.0000E-03,-9.9100E-04,-9.8200E-04,-9.7300E-04,-9.6400E-04,
     &  -9.5500E-04,-9.4600E-04,-9.3700E-04,-9.2800E-04,-9.1900E-04,
     &  -9.1000E-04,-9.0100E-04,-8.9200E-04,-8.8300E-04,-8.7400E-04,
     &  -8.6500E-04,-8.5600E-04,-8.4700E-04,-8.3800E-04,-8.2900E-04/
  
       DATA  (ETA  (I), I= 601, 700) /
     &  -8.2000E-04,-8.1100E-04,-8.0200E-04,-7.9300E-04,-7.8400E-04,
     &  -7.7500E-04,-7.6600E-04,-7.5700E-04,-7.4800E-04,-7.3900E-04,
     &  -7.3000E-04,-7.2100E-04,-7.1200E-04,-7.0300E-04,-6.9400E-04,
     &  -6.8500E-04,-6.7600E-04,-6.6700E-04,-6.5800E-04,-6.4900E-04,
     &  -6.4000E-04,-6.3100E-04,-6.2200E-04,-6.1300E-04,-6.0400E-04,
     &  -5.9500E-04,-5.8600E-04,-5.7700E-04,-5.6800E-04,-5.5900E-04,
     &  -5.5000E-04,-5.4100E-04,-5.3200E-04,-5.2300E-04,-5.1400E-04,
     &  -5.0500E-04,-4.9600E-04,-4.8700E-04,-4.7800E-04,-4.6900E-04,
     &  -4.6000E-04,-4.5100E-04,-4.4200E-04,-4.3300E-04,-4.2400E-04,
     &  -4.1500E-04,-4.0600E-04,-3.9700E-04,-3.8800E-04,-3.7900E-04,
     &  -3.7000E-04,-3.6100E-04,-3.5200E-04,-3.4300E-04,-3.3400E-04,
     &  -3.2500E-04,-3.1600E-04,-3.0700E-04,-2.9800E-04,-2.8900E-04,
     &  -2.8000E-04,-2.7100E-04,-2.6200E-04,-2.5300E-04,-2.4400E-04,
     &  -2.3500E-04,-2.2600E-04,-2.1700E-04,-2.0800E-04,-1.9900E-04,
     &  -1.9000E-04,-1.8100E-04,-1.7200E-04,-1.6300E-04,-1.5400E-04,
     &  -1.4500E-04,-1.3600E-04,-1.2700E-04,-1.1800E-04,-1.0900E-04,
     &  -1.0000E-04,-9.9100E-05,-9.8200E-05,-9.7300E-05,-9.6400E-05,
     &  -9.5500E-05,-9.4600E-05,-9.3700E-05,-9.2800E-05,-9.1900E-05,
     &  -9.1000E-05,-9.0100E-05,-8.9200E-05,-8.8300E-05,-8.7400E-05,
     &  -8.6500E-05,-8.5600E-05,-8.4700E-05,-8.3800E-05,-8.2900E-05/
  
       DATA  (ETA  (I), I= 701, 800) /
     &  -8.2000E-05,-8.1100E-05,-8.0200E-05,-7.9300E-05,-7.8400E-05,
     &  -7.7500E-05,-7.6600E-05,-7.5700E-05,-7.4800E-05,-7.3900E-05,
     &  -7.3000E-05,-7.2100E-05,-7.1200E-05,-7.0300E-05,-6.9400E-05,
     &  -6.8500E-05,-6.7600E-05,-6.6700E-05,-6.5800E-05,-6.4900E-05,
     &  -6.4000E-05,-6.3100E-05,-6.2200E-05,-6.1300E-05,-6.0400E-05,
     &  -5.9500E-05,-5.8600E-05,-5.7700E-05,-5.6800E-05,-5.5900E-05,
     &  -5.5000E-05,-5.4100E-05,-5.3200E-05,-5.2300E-05,-5.1400E-05,
     &  -5.0500E-05,-4.9600E-05,-4.8700E-05,-4.7800E-05,-4.6900E-05,
     &  -4.6000E-05,-4.5100E-05,-4.4200E-05,-4.3300E-05,-4.2400E-05,
     &  -4.1500E-05,-4.0600E-05,-3.9700E-05,-3.8800E-05,-3.7900E-05,
     &  -3.7000E-05,-3.6100E-05,-3.5200E-05,-3.4300E-05,-3.3400E-05,
     &  -3.2500E-05,-3.1600E-05,-3.0700E-05,-2.9800E-05,-2.8900E-05,
     &  -2.8000E-05,-2.7100E-05,-2.6200E-05,-2.5300E-05,-2.4400E-05,
     &  -2.3500E-05,-2.2600E-05,-2.1700E-05,-2.0800E-05,-1.9900E-05,
     &  -1.9000E-05,-1.8100E-05,-1.7200E-05,-1.6300E-05,-1.5400E-05,
     &  -1.4500E-05,-1.3600E-05,-1.2700E-05,-1.1800E-05,-1.0900E-05,
     &  -1.0000E-05,-9.9100E-06,-9.8200E-06,-9.7300E-06,-9.6400E-06,
     &  -9.5500E-06,-9.4600E-06,-9.3700E-06,-9.2800E-06,-9.1900E-06,
     &  -9.1000E-06,-9.0100E-06,-8.9200E-06,-8.8300E-06,-8.7400E-06,
     &  -8.6500E-06,-8.5600E-06,-8.4700E-06,-8.3800E-06,-8.2900E-06/
  
       DATA  (ETA  (I), I= 801, 900) /
     &  -8.2000E-06,-8.1100E-06,-8.0200E-06,-7.9300E-06,-7.8400E-06,
     &  -7.7500E-06,-7.6600E-06,-7.5700E-06,-7.4800E-06,-7.3900E-06,
     &  -7.3000E-06,-7.2100E-06,-7.1200E-06,-7.0300E-06,-6.9400E-06,
     &  -6.8500E-06,-6.7600E-06,-6.6700E-06,-6.5800E-06,-6.4900E-06,
     &  -6.4000E-06,-6.3100E-06,-6.2200E-06,-6.1300E-06,-6.0400E-06,
     &  -5.9500E-06,-5.8600E-06,-5.7700E-06,-5.6800E-06,-5.5900E-06,
     &  -5.5000E-06,-5.4100E-06,-5.3200E-06,-5.2300E-06,-5.1400E-06,
     &  -5.0500E-06,-4.9600E-06,-4.8700E-06,-4.7800E-06,-4.6900E-06,
     &  -4.6000E-06,-4.5100E-06,-4.4200E-06,-4.3300E-06,-4.2400E-06,
     &  -4.1500E-06,-4.0600E-06,-3.9700E-06,-3.8800E-06,-3.7900E-06,
     &  -3.7000E-06,-3.6100E-06,-3.5200E-06,-3.4300E-06,-3.3400E-06,
     &  -3.2500E-06,-3.1600E-06,-3.0700E-06,-2.9800E-06,-2.8900E-06,
     &  -2.8000E-06,-2.7100E-06,-2.6200E-06,-2.5300E-06,-2.4400E-06,
     &  -2.3500E-06,-2.2600E-06,-2.1700E-06,-2.0800E-06,-1.9900E-06,
     &  -1.9000E-06,-1.8100E-06,-1.7200E-06,-1.6300E-06,-1.5400E-06,
     &  -1.4500E-06,-1.3600E-06,-1.2700E-06,-1.1800E-06,-1.0900E-06,
     &  -1.0000E-06, 0.0000E+00, 1.0000E-06, 3.0010E-03, 6.0010E-03,
     &   9.0010E-03, 1.2000E-02, 1.5000E-02, 1.8000E-02, 2.1000E-02,
     &   2.4000E-02, 2.7000E-02, 3.0000E-02, 3.3000E-02, 3.6000E-02,
     &   3.9000E-02, 4.2000E-02, 4.5000E-02, 4.8000E-02, 5.1000E-02/
  
       DATA  (ETA  (I), I= 901, 979) /
     &   5.4000E-02, 5.7000E-02, 6.0000E-02, 6.3000E-02, 6.6000E-02,
     &   6.9000E-02, 7.2000E-02, 7.5000E-02, 7.8000E-02, 8.1000E-02,
     &   8.4000E-02, 8.7000E-02, 9.0000E-02, 9.3000E-02, 9.6000E-02,
     &   9.9000E-02, 1.0200E-01, 1.0500E-01, 1.0800E-01, 1.1100E-01,
     &   1.1400E-01, 1.1700E-01, 1.2000E-01, 1.2300E-01, 1.2600E-01,
     &   1.2900E-01, 1.3200E-01, 1.3500E-01, 1.3800E-01, 1.4100E-01,
     &   1.4400E-01, 1.4700E-01, 1.5000E-01, 1.5300E-01, 1.5600E-01,
     &   1.5900E-01, 1.6200E-01, 1.6500E-01, 1.6800E-01, 1.7100E-01,
     &   1.7400E-01, 1.7700E-01, 1.8000E-01, 1.8300E-01, 1.8600E-01,
     &   1.8900E-01, 1.9200E-01, 1.9500E-01, 1.9800E-01, 2.0100E-01,
     &   2.0400E-01, 2.0700E-01, 2.1000E-01, 2.1300E-01, 2.1600E-01,
     &   2.1900E-01, 2.2200E-01, 2.2500E-01, 2.2800E-01, 2.3100E-01,
     &   2.3400E-01, 2.3700E-01, 2.4000E-01, 2.4300E-01, 2.4600E-01,
     &   2.4900E-01, 2.5200E-01, 2.5500E-01, 2.5800E-01, 2.6100E-01,
     &   2.6400E-01, 2.6700E-01, 2.7000E-01, 2.7100E-01, 2.7300E-01,
     &   0.27370000D0, 0.27599999D0, 0.27630001D0, 0.27700001D0/
  
         DATA ((DAT  (I,J), I=   1, 100), J=1,1) /
     &   4.1057E-02, 4.1005E-02, 4.0953E-02, 4.0901E-02, 4.0847E-02,
     &   4.0794E-02, 4.0739E-02, 4.0684E-02, 4.0628E-02, 4.0572E-02,
     &   4.0515E-02, 4.0457E-02, 4.0398E-02, 4.0339E-02, 4.0279E-02,
     &   4.0218E-02, 4.0156E-02, 4.0094E-02, 4.0030E-02, 3.9966E-02,
     &   3.9901E-02, 3.9835E-02, 3.9768E-02, 3.9700E-02, 3.9631E-02,
     &   3.9561E-02, 3.9490E-02, 3.9418E-02, 3.9345E-02, 3.9271E-02,
     &   3.9195E-02, 3.9118E-02, 3.9040E-02, 3.8961E-02, 3.8881E-02,
     &   3.8799E-02, 3.8715E-02, 3.8630E-02, 3.8544E-02, 3.8456E-02,
     &   3.8367E-02, 3.8275E-02, 3.8182E-02, 3.8088E-02, 3.7991E-02,
     &   3.7893E-02, 3.7792E-02, 3.7690E-02, 3.7585E-02, 3.7478E-02,
     &   3.7369E-02, 3.7257E-02, 3.7143E-02, 3.7026E-02, 3.6906E-02,
     &   3.6784E-02, 3.6658E-02, 3.6530E-02, 3.6398E-02, 3.6263E-02,
     &   3.6124E-02, 3.5981E-02, 3.5835E-02, 3.5684E-02, 3.5529E-02,
     &   3.5369E-02, 3.5204E-02, 3.5034E-02, 3.4859E-02, 3.4677E-02,
     &   3.4489E-02, 3.4295E-02, 3.4094E-02, 3.3885E-02, 3.3667E-02,
     &   3.3441E-02, 3.3205E-02, 3.2959E-02, 3.2701E-02, 3.2431E-02,
     &   3.2148E-02, 3.1850E-02, 3.1535E-02, 3.1201E-02, 3.0847E-02,
     &   3.0470E-02, 3.0066E-02, 2.9632E-02, 2.9162E-02, 2.8651E-02,
     &   2.8091E-02, 2.8032E-02, 2.7972E-02, 2.7912E-02, 2.7851E-02,
     &   2.7789E-02, 2.7727E-02, 2.7664E-02, 2.7600E-02, 2.7536E-02/
  
         DATA ((DAT  (I,J), I= 101, 200), J=1,1) /
     &   2.7471E-02, 2.7405E-02, 2.7339E-02, 2.7271E-02, 2.7203E-02,
     &   2.7134E-02, 2.7065E-02, 2.6994E-02, 2.6923E-02, 2.6850E-02,
     &   2.6777E-02, 2.6703E-02, 2.6628E-02, 2.6552E-02, 2.6475E-02,
     &   2.6397E-02, 2.6317E-02, 2.6237E-02, 2.6156E-02, 2.6073E-02,
     &   2.5990E-02, 2.5905E-02, 2.5819E-02, 2.5731E-02, 2.5643E-02,
     &   2.5552E-02, 2.5461E-02, 2.5368E-02, 2.5274E-02, 2.5178E-02,
     &   2.5080E-02, 2.4981E-02, 2.4880E-02, 2.4777E-02, 2.4673E-02,
     &   2.4566E-02, 2.4458E-02, 2.4347E-02, 2.4235E-02, 2.4120E-02,
     &   2.4003E-02, 2.3884E-02, 2.3762E-02, 2.3638E-02, 2.3511E-02,
     &   2.3381E-02, 2.3248E-02, 2.3112E-02, 2.2973E-02, 2.2831E-02,
     &   2.2685E-02, 2.2535E-02, 2.2382E-02, 2.2224E-02, 2.2063E-02,
     &   2.1896E-02, 2.1725E-02, 2.1549E-02, 2.1367E-02, 2.1180E-02,
     &   2.0986E-02, 2.0786E-02, 2.0579E-02, 2.0365E-02, 2.0143E-02,
     &   1.9912E-02, 1.9671E-02, 1.9421E-02, 1.9160E-02, 1.8887E-02,
     &   1.8601E-02, 1.8300E-02, 1.7984E-02, 1.7650E-02, 1.7297E-02,
     &   1.6922E-02, 1.6522E-02, 1.6094E-02, 1.5634E-02, 1.5136E-02,
     &   1.4593E-02, 1.4542E-02, 1.4490E-02, 1.4438E-02, 1.4386E-02,
     &   1.4333E-02, 1.4279E-02, 1.4225E-02, 1.4171E-02, 1.4116E-02,
     &   1.4060E-02, 1.4004E-02, 1.3948E-02, 1.3891E-02, 1.3833E-02,
     &   1.3775E-02, 1.3717E-02, 1.3658E-02, 1.3598E-02, 1.3538E-02/
  
         DATA ((DAT  (I,J), I= 201, 300), J=1,1) /
     &   1.3477E-02, 1.3415E-02, 1.3353E-02, 1.3290E-02, 1.3227E-02,
     &   1.3163E-02, 1.3098E-02, 1.3032E-02, 1.2966E-02, 1.2899E-02,
     &   1.2831E-02, 1.2763E-02, 1.2694E-02, 1.2624E-02, 1.2553E-02,
     &   1.2482E-02, 1.2409E-02, 1.2336E-02, 1.2262E-02, 1.2187E-02,
     &   1.2111E-02, 1.2034E-02, 1.1956E-02, 1.1877E-02, 1.1797E-02,
     &   1.1716E-02, 1.1634E-02, 1.1551E-02, 1.1467E-02, 1.1381E-02,
     &   1.1295E-02, 1.1207E-02, 1.1118E-02, 1.1028E-02, 1.0936E-02,
     &   1.0843E-02, 1.0748E-02, 1.0652E-02, 1.0555E-02, 1.0456E-02,
     &   1.0355E-02, 1.0253E-02, 1.0149E-02, 1.0044E-02, 9.9361E-03,
     &   9.8268E-03, 9.7155E-03, 9.6022E-03, 9.4869E-03, 9.3694E-03,
     &   9.2496E-03, 9.1276E-03, 9.0031E-03, 8.8761E-03, 8.7464E-03,
     &   8.6141E-03, 8.4789E-03, 8.3407E-03, 8.1994E-03, 8.0548E-03,
     &   7.9068E-03, 7.7551E-03, 7.5996E-03, 7.4401E-03, 7.2763E-03,
     &   7.1079E-03, 6.9346E-03, 6.7569E-03, 6.5728E-03, 6.3827E-03,
     &   6.1859E-03, 5.9821E-03, 5.7704E-03, 5.5502E-03, 5.3206E-03,
     &   5.0806E-03, 4.8290E-03, 4.5645E-03, 4.2858E-03, 3.9912E-03,
     &   3.6791E-03, 3.6469E-03, 3.6145E-03, 3.5819E-03, 3.5491E-03,
     &   3.5161E-03, 3.4829E-03, 3.4495E-03, 3.4159E-03, 3.3821E-03,
     &   3.3481E-03, 3.3139E-03, 3.2795E-03, 3.2449E-03, 3.2101E-03,
     &   3.1751E-03, 3.1398E-03, 3.1044E-03, 3.0688E-03, 3.0329E-03/
  
         DATA ((DAT  (I,J), I= 301, 400), J=1,1) /
     &   2.9969E-03, 2.9607E-03, 2.9242E-03, 2.8876E-03, 2.8507E-03,
     &   2.8136E-03, 2.7763E-03, 2.7388E-03, 2.7011E-03, 2.6633E-03,
     &   2.6252E-03, 2.5869E-03, 2.5484E-03, 2.5098E-03, 2.4709E-03,
     &   2.4319E-03, 2.3926E-03, 2.3532E-03, 2.3137E-03, 2.2739E-03,
     &   2.2340E-03, 2.1940E-03, 2.1537E-03, 2.1134E-03, 2.0729E-03,
     &   2.0322E-03, 1.9915E-03, 1.9506E-03, 1.9096E-03, 1.8685E-03,
     &   1.8273E-03, 1.7861E-03, 1.7447E-03, 1.7034E-03, 1.6619E-03,
     &   1.6205E-03, 1.5790E-03, 1.5375E-03, 1.4960E-03, 1.4546E-03,
     &   1.4132E-03, 1.3719E-03, 1.3306E-03, 1.2895E-03, 1.2484E-03,
     &   1.2076E-03, 1.1668E-03, 1.1263E-03, 1.0860E-03, 1.0459E-03,
     &   1.0060E-03, 9.6647E-04, 9.2723E-04, 8.8833E-04, 8.4981E-04,
     &   8.1168E-04, 7.7399E-04, 7.3676E-04, 7.0003E-04, 6.6383E-04,
     &   6.2819E-04, 5.9314E-04, 5.5874E-04, 5.2500E-04, 4.9197E-04,
     &   4.5968E-04, 4.2818E-04, 3.9749E-04, 3.6767E-04, 3.3874E-04,
     &   3.1077E-04, 2.8374E-04, 2.5773E-04, 2.3277E-04, 2.0889E-04,
     &   1.8614E-04, 1.6455E-04, 1.4415E-04, 1.2498E-04, 1.0708E-04,
     &   9.0462E-05, 8.8873E-05, 8.7297E-05, 8.5734E-05, 8.4185E-05,
     &   8.2649E-05, 8.1126E-05, 7.9617E-05, 7.8121E-05, 7.6639E-05,
     &   7.5170E-05, 7.3715E-05, 7.2273E-05, 7.0845E-05, 6.9430E-05,
     &   6.8029E-05, 6.6642E-05, 6.5268E-05, 6.3908E-05, 6.2562E-05/
  
         DATA ((DAT  (I,J), I= 401, 500), J=1,1) /
     &   6.1229E-05, 5.9910E-05, 5.8605E-05, 5.7314E-05, 5.6037E-05,
     &   5.4773E-05, 5.3523E-05, 5.2288E-05, 5.1066E-05, 4.9858E-05,
     &   4.8664E-05, 4.7484E-05, 4.6318E-05, 4.5166E-05, 4.4029E-05,
     &   4.2905E-05, 4.1795E-05, 4.0700E-05, 3.9619E-05, 3.8552E-05,
     &   3.7499E-05, 3.6460E-05, 3.5436E-05, 3.4425E-05, 3.3430E-05,
     &   3.2448E-05, 3.1481E-05, 3.0528E-05, 2.9589E-05, 2.8665E-05,
     &   2.7755E-05, 2.6859E-05, 2.5978E-05, 2.5112E-05, 2.4260E-05,
     &   2.3422E-05, 2.2599E-05, 2.1790E-05, 2.0996E-05, 2.0216E-05,
     &   1.9451E-05, 1.8701E-05, 1.7965E-05, 1.7243E-05, 1.6537E-05,
     &   1.5845E-05, 1.5167E-05, 1.4504E-05, 1.3856E-05, 1.3223E-05,
     &   1.2604E-05, 1.2000E-05, 1.1410E-05, 1.0836E-05, 1.0276E-05,
     &   9.7308E-06, 9.2005E-06, 8.6849E-06, 8.1840E-06, 7.6980E-06,
     &   7.2268E-06, 6.7704E-06, 6.3288E-06, 5.9020E-06, 5.4901E-06,
     &   5.0930E-06, 4.7108E-06, 4.3434E-06, 3.9909E-06, 3.6533E-06,
     &   3.3306E-06, 3.0227E-06, 2.7298E-06, 2.4517E-06, 2.1886E-06,
     &   1.9404E-06, 1.7071E-06, 1.4887E-06, 1.2852E-06, 1.0967E-06,
     &   9.2310E-07, 9.0656E-07, 8.9017E-07, 8.7393E-07, 8.5784E-07,
     &   8.4190E-07, 8.2611E-07, 8.1047E-07, 7.9498E-07, 7.7964E-07,
     &   7.6445E-07, 7.4940E-07, 7.3451E-07, 7.1976E-07, 7.0517E-07,
     &   6.9072E-07, 6.7643E-07, 6.6228E-07, 6.4828E-07, 6.3443E-07/
  
         DATA ((DAT  (I,J), I= 501, 600), J=1,1) /
     &   6.2073E-07, 6.0718E-07, 5.9379E-07, 5.8053E-07, 5.6743E-07,
     &   5.5448E-07, 5.4168E-07, 5.2903E-07, 5.1653E-07, 5.0417E-07,
     &   4.9197E-07, 4.7991E-07, 4.6801E-07, 4.5625E-07, 4.4465E-07,
     &   4.3319E-07, 4.2188E-07, 4.1072E-07, 3.9972E-07, 3.8886E-07,
     &   3.7815E-07, 3.6759E-07, 3.5718E-07, 3.4692E-07, 3.3681E-07,
     &   3.2684E-07, 3.1703E-07, 3.0737E-07, 2.9786E-07, 2.8849E-07,
     &   2.7928E-07, 2.7021E-07, 2.6130E-07, 2.5253E-07, 2.4392E-07,
     &   2.3545E-07, 2.2713E-07, 2.1897E-07, 2.1095E-07, 2.0308E-07,
     &   1.9536E-07, 1.8779E-07, 1.8037E-07, 1.7310E-07, 1.6598E-07,
     &   1.5901E-07, 1.5219E-07, 1.4551E-07, 1.3899E-07, 1.3262E-07,
     &   1.2640E-07, 1.2032E-07, 1.1440E-07, 1.0862E-07, 1.0300E-07,
     &   9.7521E-08, 9.2194E-08, 8.7018E-08, 8.1990E-08, 7.7113E-08,
     &   7.2385E-08, 6.7806E-08, 6.3378E-08, 5.9098E-08, 5.4968E-08,
     &   5.0988E-08, 4.7158E-08, 4.3476E-08, 3.9945E-08, 3.6563E-08,
     &   3.3331E-08, 3.0248E-08, 2.7314E-08, 2.4531E-08, 2.1897E-08,
     &   1.9412E-08, 1.7077E-08, 1.4892E-08, 1.2856E-08, 1.0970E-08,
     &   9.2329E-09, 9.0675E-09, 8.9035E-09, 8.7411E-09, 8.5801E-09,
     &   8.4206E-09, 8.2627E-09, 8.1062E-09, 7.9512E-09, 7.7977E-09,
     &   7.6458E-09, 7.4953E-09, 7.3463E-09, 7.1988E-09, 7.0528E-09,
     &   6.9083E-09, 6.7653E-09, 6.6238E-09, 6.4838E-09, 6.3452E-09/
  
         DATA ((DAT  (I,J), I= 601, 700), J=1,1) /
     &   6.2082E-09, 6.0727E-09, 5.9386E-09, 5.8061E-09, 5.6751E-09,
     &   5.5455E-09, 5.4175E-09, 5.2909E-09, 5.1658E-09, 5.0423E-09,
     &   4.9202E-09, 4.7996E-09, 4.6806E-09, 4.5630E-09, 4.4469E-09,
     &   4.3323E-09, 4.2192E-09, 4.1076E-09, 3.9975E-09, 3.8889E-09,
     &   3.7818E-09, 3.6762E-09, 3.5721E-09, 3.4694E-09, 3.3683E-09,
     &   3.2687E-09, 3.1705E-09, 3.0739E-09, 2.9788E-09, 2.8851E-09,
     &   2.7930E-09, 2.7023E-09, 2.6131E-09, 2.5255E-09, 2.4393E-09,
     &   2.3546E-09, 2.2714E-09, 2.1898E-09, 2.1096E-09, 2.0309E-09,
     &   1.9537E-09, 1.8780E-09, 1.8038E-09, 1.7311E-09, 1.6599E-09,
     &   1.5901E-09, 1.5219E-09, 1.4552E-09, 1.3900E-09, 1.3262E-09,
     &   1.2640E-09, 1.2032E-09, 1.1440E-09, 1.0862E-09, 1.0300E-09,
     &   9.7523E-10, 9.2196E-10, 8.7019E-10, 8.1992E-10, 7.7114E-10,
     &   7.2386E-10, 6.7807E-10, 6.3378E-10, 5.9099E-10, 5.4969E-10,
     &   5.0989E-10, 4.7158E-10, 4.3477E-10, 3.9945E-10, 3.6563E-10,
     &   3.3331E-10, 3.0248E-10, 2.7315E-10, 2.4531E-10, 2.1897E-10,
     &   1.9412E-10, 1.7077E-10, 1.4892E-10, 1.2856E-10, 1.0970E-10,
     &   9.2329E-11, 9.0675E-11, 8.9035E-11, 8.7411E-11, 8.5801E-11,
     &   8.4207E-11, 8.2627E-11, 8.1062E-11, 7.9512E-11, 7.7978E-11,
     &   7.6458E-11, 7.4953E-11, 7.3463E-11, 7.1988E-11, 7.0528E-11,
     &   6.9083E-11, 6.7653E-11, 6.6238E-11, 6.4838E-11, 6.3452E-11/
  
         DATA ((DAT  (I,J), I= 701, 800), J=1,1) /
     &   6.2082E-11, 6.0727E-11, 5.9386E-11, 5.8061E-11, 5.6751E-11,
     &   5.5455E-11, 5.4175E-11, 5.2909E-11, 5.1659E-11, 5.0423E-11,
     &   4.9202E-11, 4.7996E-11, 4.6806E-11, 4.5630E-11, 4.4469E-11,
     &   4.3323E-11, 4.2192E-11, 4.1076E-11, 3.9975E-11, 3.8889E-11,
     &   3.7818E-11, 3.6762E-11, 3.5721E-11, 3.4694E-11, 3.3683E-11,
     &   3.2687E-11, 3.1705E-11, 3.0739E-11, 2.9788E-11, 2.8851E-11,
     &   2.7930E-11, 2.7023E-11, 2.6131E-11, 2.5255E-11, 2.4393E-11,
     &   2.3546E-11, 2.2714E-11, 2.1898E-11, 2.1096E-11, 2.0309E-11,
     &   1.9537E-11, 1.8780E-11, 1.8038E-11, 1.7311E-11, 1.6599E-11,
     &   1.5901E-11, 1.5219E-11, 1.4552E-11, 1.3900E-11, 1.3262E-11,
     &   1.2640E-11, 1.2032E-11, 1.1440E-11, 1.0862E-11, 1.0300E-11,
     &   9.7523E-12, 9.2196E-12, 8.7019E-12, 8.1992E-12, 7.7114E-12,
     &   7.2386E-12, 6.7807E-12, 6.3378E-12, 5.9099E-12, 5.4969E-12,
     &   5.0989E-12, 4.7158E-12, 4.3477E-12, 3.9945E-12, 3.6563E-12,
     &   3.3331E-12, 3.0248E-12, 2.7315E-12, 2.4531E-12, 2.1897E-12,
     &   1.9412E-12, 1.7077E-12, 1.4892E-12, 1.2856E-12, 1.0970E-12,
     &   9.2329E-13, 9.0675E-13, 8.9035E-13, 8.7411E-13, 8.5801E-13,
     &   8.4207E-13, 8.2627E-13, 8.1062E-13, 7.9512E-13, 7.7978E-13,
     &   7.6458E-13, 7.4953E-13, 7.3463E-13, 7.1988E-13, 7.0528E-13,
     &   6.9083E-13, 6.7653E-13, 6.6238E-13, 6.4838E-13, 6.3452E-13/
  
         DATA ((DAT  (I,J), I= 801, 900), J=1,1) /
     &   6.2082E-13, 6.0727E-13, 5.9386E-13, 5.8061E-13, 5.6751E-13,
     &   5.5455E-13, 5.4175E-13, 5.2909E-13, 5.1659E-13, 5.0423E-13,
     &   4.9202E-13, 4.7996E-13, 4.6806E-13, 4.5630E-13, 4.4469E-13,
     &   4.3323E-13, 4.2192E-13, 4.1076E-13, 3.9975E-13, 3.8889E-13,
     &   3.7818E-13, 3.6762E-13, 3.5721E-13, 3.4694E-13, 3.3683E-13,
     &   3.2687E-13, 3.1705E-13, 3.0739E-13, 2.9788E-13, 2.8851E-13,
     &   2.7930E-13, 2.7023E-13, 2.6131E-13, 2.5255E-13, 2.4393E-13,
     &   2.3546E-13, 2.2714E-13, 2.1898E-13, 2.1096E-13, 2.0309E-13,
     &   1.9537E-13, 1.8780E-13, 1.8038E-13, 1.7311E-13, 1.6599E-13,
     &   1.5901E-13, 1.5219E-13, 1.4552E-13, 1.3900E-13, 1.3262E-13,
     &   1.2640E-13, 1.2032E-13, 1.1440E-13, 1.0862E-13, 1.0300E-13,
     &   9.7523E-14, 9.2196E-14, 8.7019E-14, 8.1992E-14, 7.7114E-14,
     &   7.2386E-14, 6.7807E-14, 6.3378E-14, 5.9099E-14, 5.4969E-14,
     &   5.0989E-14, 4.7158E-14, 4.3477E-14, 3.9945E-14, 3.6563E-14,
     &   3.3331E-14, 3.0248E-14, 2.7315E-14, 2.4531E-14, 2.1897E-14,
     &   1.9412E-14, 1.7077E-14, 1.4892E-14, 1.2856E-14, 1.0970E-14,
     &   9.2329E-15, 0.0000E+00,-9.2329E-15,-8.3153E-08,-3.3252E-07,
     &  -7.4816E-07,-1.3299E-06,-2.0784E-06,-2.9935E-06,-4.0755E-06,
     &  -5.3246E-06,-6.7411E-06,-8.3253E-06,-1.0078E-05,-1.1998E-05,
     &  -1.4088E-05,-1.6347E-05,-1.8776E-05,-2.1376E-05,-2.4146E-05/
  
         DATA ((DAT  (I,J), I= 901, 979), J=1,1) /
     &  -2.7089E-05,-3.0204E-05,-3.3492E-05,-3.6953E-05,-4.0590E-05,
     &  -4.4402E-05,-4.8391E-05,-5.2557E-05,-5.6902E-05,-6.1426E-05,
     &  -6.6131E-05,-7.1018E-05,-7.6088E-05,-8.1342E-05,-8.6782E-05,
     &  -9.2409E-05,-9.8224E-05,-1.0423E-04,-1.1044E-04,-1.1683E-04,
     &  -1.2341E-04,-1.3020E-04,-1.3718E-04,-1.4436E-04,-1.5174E-04,
     &  -1.5933E-04,-1.6713E-04,-1.7513E-04,-1.8335E-04,-1.9177E-04,
     &  -2.0042E-04,-2.0928E-04,-2.1837E-04,-2.2768E-04,-2.3722E-04,
     &  -2.4699E-04,-2.5699E-04,-2.6723E-04,-2.7771E-04,-2.8843E-04,
     &  -2.9940E-04,-3.1063E-04,-3.2211E-04,-3.3385E-04,-3.4586E-04,
     &  -3.5814E-04,-3.7069E-04,-3.8353E-04,-3.9665E-04,-4.0996E-04,
     &  -4.2367E-04,-4.3768E-04,-4.5201E-04,-4.6662E-04,-4.8159E-04,
     &  -4.9690E-04,-5.1255E-04,-5.2857E-04,-5.4494E-04,-5.6170E-04,
     &  -5.7885E-04,-5.9640E-04,-6.1450E-04,-6.3291E-04,-6.5179E-04,
     &  -6.7114E-04,-6.9099E-04,-7.1138E-04,-7.3233E-04,-7.5389E-04,
     &  -7.7610E-04,-7.9903E-04,-8.2184E-04,-8.2993E-04,-8.4670E-04,
     &  -8.52603215E-04,-8.73193004E-04,-8.75854969E-04,-8.82135543E-04/
  
         DATA ((DAT  (I,J), I=   1, 100), J=2,2) /
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05, 5.3025E-05,
     &   5.3025E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05,
     &   5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05,
     &   5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05, 5.3024E-05,
     &   5.3023E-05, 5.3023E-05, 5.3023E-05, 5.3023E-05, 5.3023E-05,
     &   5.3023E-05, 5.3023E-05, 5.3023E-05, 5.3022E-05, 5.3022E-05,
     &   5.3022E-05, 5.3022E-05, 5.3022E-05, 5.3021E-05, 5.3021E-05,
     &   5.3021E-05, 5.3020E-05, 5.3020E-05, 5.3020E-05, 5.3019E-05,
     &   5.3019E-05, 5.3018E-05, 5.3018E-05, 5.3017E-05, 5.3016E-05,
     &   5.3015E-05, 5.3015E-05, 5.3013E-05, 5.3012E-05, 5.3011E-05,
     &   5.3009E-05, 5.3008E-05, 5.3006E-05, 5.3003E-05, 5.3000E-05,
     &   5.2996E-05, 5.2992E-05, 5.2987E-05, 5.2980E-05, 5.2971E-05,
     &   5.2959E-05, 5.2958E-05, 5.2957E-05, 5.2955E-05, 5.2954E-05,
     &   5.2952E-05, 5.2951E-05, 5.2949E-05, 5.2947E-05, 5.2946E-05/
  
         DATA ((DAT  (I,J), I= 101, 200), J=2,2) /
     &   5.2944E-05, 5.2942E-05, 5.2940E-05, 5.2938E-05, 5.2936E-05,
     &   5.2934E-05, 5.2932E-05, 5.2929E-05, 5.2927E-05, 5.2925E-05,
     &   5.2922E-05, 5.2919E-05, 5.2917E-05, 5.2914E-05, 5.2911E-05,
     &   5.2908E-05, 5.2905E-05, 5.2901E-05, 5.2898E-05, 5.2894E-05,
     &   5.2890E-05, 5.2886E-05, 5.2882E-05, 5.2878E-05, 5.2873E-05,
     &   5.2869E-05, 5.2864E-05, 5.2859E-05, 5.2853E-05, 5.2848E-05,
     &   5.2842E-05, 5.2835E-05, 5.2829E-05, 5.2822E-05, 5.2815E-05,
     &   5.2807E-05, 5.2799E-05, 5.2790E-05, 5.2781E-05, 5.2772E-05,
     &   5.2761E-05, 5.2751E-05, 5.2739E-05, 5.2727E-05, 5.2714E-05,
     &   5.2700E-05, 5.2685E-05, 5.2669E-05, 5.2652E-05, 5.2634E-05,
     &   5.2615E-05, 5.2594E-05, 5.2571E-05, 5.2547E-05, 5.2520E-05,
     &   5.2491E-05, 5.2460E-05, 5.2426E-05, 5.2389E-05, 5.2348E-05,
     &   5.2303E-05, 5.2254E-05, 5.2200E-05, 5.2139E-05, 5.2072E-05,
     &   5.1997E-05, 5.1913E-05, 5.1818E-05, 5.1710E-05, 5.1588E-05,
     &   5.1448E-05, 5.1287E-05, 5.1101E-05, 5.0883E-05, 5.0627E-05,
     &   5.0322E-05, 4.9957E-05, 4.9515E-05, 4.8971E-05, 4.8295E-05,
     &   4.7439E-05, 4.7351E-05, 4.7262E-05, 4.7170E-05, 4.7075E-05,
     &   4.6979E-05, 4.6881E-05, 4.6780E-05, 4.6676E-05, 4.6570E-05,
     &   4.6462E-05, 4.6351E-05, 4.6237E-05, 4.6120E-05, 4.6001E-05,
     &   4.5878E-05, 4.5753E-05, 4.5624E-05, 4.5492E-05, 4.5356E-05/
  
         DATA ((DAT  (I,J), I= 201, 300), J=2,2) /
     &   4.5217E-05, 4.5074E-05, 4.4928E-05, 4.4777E-05, 4.4623E-05,
     &   4.4464E-05, 4.4301E-05, 4.4134E-05, 4.3962E-05, 4.3785E-05,
     &   4.3603E-05, 4.3417E-05, 4.3225E-05, 4.3027E-05, 4.2824E-05,
     &   4.2615E-05, 4.2400E-05, 4.2179E-05, 4.1951E-05, 4.1717E-05,
     &   4.1476E-05, 4.1227E-05, 4.0971E-05, 4.0707E-05, 4.0436E-05,
     &   4.0156E-05, 3.9867E-05, 3.9570E-05, 3.9263E-05, 3.8947E-05,
     &   3.8621E-05, 3.8285E-05, 3.7939E-05, 3.7581E-05, 3.7213E-05,
     &   3.6832E-05, 3.6440E-05, 3.6035E-05, 3.5618E-05, 3.5187E-05,
     &   3.4742E-05, 3.4283E-05, 3.3810E-05, 3.3322E-05, 3.2819E-05,
     &   3.2300E-05, 3.1764E-05, 3.1213E-05, 3.0644E-05, 3.0058E-05,
     &   2.9454E-05, 2.8833E-05, 2.8193E-05, 2.7535E-05, 2.6858E-05,
     &   2.6163E-05, 2.5449E-05, 2.4717E-05, 2.3966E-05, 2.3198E-05,
     &   2.2411E-05, 2.1608E-05, 2.0788E-05, 1.9952E-05, 1.9103E-05,
     &   1.8240E-05, 1.7365E-05, 1.6481E-05, 1.5589E-05, 1.4691E-05,
     &   1.3790E-05, 1.2890E-05, 1.1992E-05, 1.1100E-05, 1.0219E-05,
     &   9.3504E-06, 8.4995E-06, 7.6698E-06, 6.8650E-06, 6.0884E-06,
     &   5.3431E-06, 5.2704E-06, 5.1980E-06, 5.1259E-06, 5.0542E-06,
     &   4.9829E-06, 4.9119E-06, 4.8412E-06, 4.7709E-06, 4.7010E-06,
     &   4.6314E-06, 4.5621E-06, 4.4932E-06, 4.4247E-06, 4.3565E-06,
     &   4.2887E-06, 4.2212E-06, 4.1541E-06, 4.0873E-06, 4.0210E-06/
  
         DATA ((DAT  (I,J), I= 301, 400), J=2,2) /
     &   3.9549E-06, 3.8893E-06, 3.8240E-06, 3.7590E-06, 3.6944E-06,
     &   3.6302E-06, 3.5664E-06, 3.5029E-06, 3.4398E-06, 3.3770E-06,
     &   3.3146E-06, 3.2526E-06, 3.1909E-06, 3.1296E-06, 3.0687E-06,
     &   3.0081E-06, 2.9479E-06, 2.8880E-06, 2.8285E-06, 2.7694E-06,
     &   2.7107E-06, 2.6523E-06, 2.5943E-06, 2.5366E-06, 2.4793E-06,
     &   2.4224E-06, 2.3659E-06, 2.3097E-06, 2.2539E-06, 2.1985E-06,
     &   2.1434E-06, 2.0887E-06, 2.0344E-06, 1.9805E-06, 1.9270E-06,
     &   1.8739E-06, 1.8212E-06, 1.7689E-06, 1.7170E-06, 1.6655E-06,
     &   1.6144E-06, 1.5637E-06, 1.5135E-06, 1.4638E-06, 1.4145E-06,
     &   1.3656E-06, 1.3172E-06, 1.2693E-06, 1.2220E-06, 1.1751E-06,
     &   1.1287E-06, 1.0829E-06, 1.0377E-06, 9.9301E-07, 9.4894E-07,
     &   9.0548E-07, 8.6266E-07, 8.2050E-07, 7.7902E-07, 7.3824E-07,
     &   6.9820E-07, 6.5892E-07, 6.2043E-07, 5.8276E-07, 5.4593E-07,
     &   5.0999E-07, 4.7495E-07, 4.4087E-07, 4.0776E-07, 3.7567E-07,
     &   3.4464E-07, 3.1470E-07, 2.8588E-07, 2.5823E-07, 2.3179E-07,
     &   2.0658E-07, 1.8266E-07, 1.6006E-07, 1.3881E-07, 1.1895E-07,
     &   1.0052E-07, 9.8757E-08, 9.7009E-08, 9.5275E-08, 9.3555E-08,
     &   9.1851E-08, 9.0161E-08, 8.8486E-08, 8.6826E-08, 8.5181E-08,
     &   8.3550E-08, 8.1935E-08, 8.0334E-08, 7.8748E-08, 7.7178E-08,
     &   7.5622E-08, 7.4082E-08, 7.2557E-08, 7.1046E-08, 6.9551E-08/
  
         DATA ((DAT  (I,J), I= 401, 500), J=2,2) /
     &   6.8071E-08, 6.6607E-08, 6.5157E-08, 6.3723E-08, 6.2305E-08,
     &   6.0901E-08, 5.9513E-08, 5.8140E-08, 5.6783E-08, 5.5441E-08,
     &   5.4115E-08, 5.2804E-08, 5.1509E-08, 5.0229E-08, 4.8965E-08,
     &   4.7716E-08, 4.6483E-08, 4.5266E-08, 4.4064E-08, 4.2878E-08,
     &   4.1708E-08, 4.0554E-08, 3.9415E-08, 3.8292E-08, 3.7185E-08,
     &   3.6094E-08, 3.5019E-08, 3.3959E-08, 3.2916E-08, 3.1888E-08,
     &   3.0876E-08, 2.9881E-08, 2.8901E-08, 2.7938E-08, 2.6990E-08,
     &   2.6058E-08, 2.5143E-08, 2.4244E-08, 2.3361E-08, 2.2493E-08,
     &   2.1643E-08, 2.0808E-08, 1.9989E-08, 1.9187E-08, 1.8401E-08,
     &   1.7631E-08, 1.6877E-08, 1.6140E-08, 1.5419E-08, 1.4714E-08,
     &   1.4026E-08, 1.3354E-08, 1.2698E-08, 1.2059E-08, 1.1436E-08,
     &   1.0829E-08, 1.0239E-08, 9.6656E-09, 9.1083E-09, 8.5675E-09,
     &   8.0431E-09, 7.5352E-09, 7.0438E-09, 6.5689E-09, 6.1105E-09,
     &   5.6686E-09, 5.2432E-09, 4.8344E-09, 4.4421E-09, 4.0663E-09,
     &   3.7071E-09, 3.3645E-09, 3.0384E-09, 2.7290E-09, 2.4361E-09,
     &   2.1598E-09, 1.9001E-09, 1.6570E-09, 1.4306E-09, 1.2207E-09,
     &   1.0275E-09, 1.0091E-09, 9.9087E-10, 9.7279E-10, 9.5488E-10,
     &   9.3714E-10, 9.1956E-10, 9.0215E-10, 8.8491E-10, 8.6783E-10,
     &   8.5092E-10, 8.3417E-10, 8.1760E-10, 8.0118E-10, 7.8494E-10,
     &   7.6886E-10, 7.5294E-10, 7.3720E-10, 7.2162E-10, 7.0620E-10/
  
         DATA ((DAT  (I,J), I= 501, 600), J=2,2) /
     &   6.9095E-10, 6.7587E-10, 6.6096E-10, 6.4621E-10, 6.3162E-10,
     &   6.1721E-10, 6.0296E-10, 5.8887E-10, 5.7496E-10, 5.6121E-10,
     &   5.4762E-10, 5.3420E-10, 5.2095E-10, 5.0787E-10, 4.9495E-10,
     &   4.8219E-10, 4.6961E-10, 4.5719E-10, 4.4494E-10, 4.3285E-10,
     &   4.2093E-10, 4.0917E-10, 3.9759E-10, 3.8616E-10, 3.7491E-10,
     &   3.6382E-10, 3.5290E-10, 3.4214E-10, 3.3155E-10, 3.2113E-10,
     &   3.1087E-10, 3.0078E-10, 2.9086E-10, 2.8110E-10, 2.7151E-10,
     &   2.6209E-10, 2.5283E-10, 2.4374E-10, 2.3481E-10, 2.2605E-10,
     &   2.1746E-10, 2.0904E-10, 2.0078E-10, 1.9268E-10, 1.8476E-10,
     &   1.7700E-10, 1.6940E-10, 1.6198E-10, 1.5472E-10, 1.4762E-10,
     &   1.4069E-10, 1.3393E-10, 1.2734E-10, 1.2091E-10, 1.1465E-10,
     &   1.0855E-10, 1.0262E-10, 9.6862E-11, 9.1267E-11, 8.5837E-11,
     &   8.0574E-11, 7.5478E-11, 7.0548E-11, 6.5784E-11, 6.1187E-11,
     &   5.6757E-11, 5.2493E-11, 4.8395E-11, 4.4464E-11, 4.0700E-11,
     &   3.7102E-11, 3.3670E-11, 3.0405E-11, 2.7306E-11, 2.4374E-11,
     &   2.1608E-11, 1.9009E-11, 1.6577E-11, 1.4310E-11, 1.2211E-11,
     &   1.0277E-11, 1.0093E-11, 9.9108E-12, 9.7300E-12, 9.5508E-12,
     &   9.3733E-12, 9.1975E-12, 9.0233E-12, 8.8508E-12, 8.6800E-12,
     &   8.5108E-12, 8.3433E-12, 8.1774E-12, 8.0133E-12, 7.8507E-12,
     &   7.6899E-12, 7.5307E-12, 7.3732E-12, 7.2173E-12, 7.0631E-12/
  
         DATA ((DAT  (I,J), I= 601, 700), J=2,2) /
     &   6.9106E-12, 6.7597E-12, 6.6105E-12, 6.4630E-12, 6.3171E-12,
     &   6.1729E-12, 6.0304E-12, 5.8895E-12, 5.7503E-12, 5.6128E-12,
     &   5.4769E-12, 5.3427E-12, 5.2101E-12, 5.0792E-12, 4.9500E-12,
     &   4.8225E-12, 4.6966E-12, 4.5724E-12, 4.4498E-12, 4.3289E-12,
     &   4.2097E-12, 4.0921E-12, 3.9762E-12, 3.8620E-12, 3.7494E-12,
     &   3.6385E-12, 3.5293E-12, 3.4217E-12, 3.3158E-12, 3.2115E-12,
     &   3.1089E-12, 3.0080E-12, 2.9088E-12, 2.8112E-12, 2.7153E-12,
     &   2.6210E-12, 2.5284E-12, 2.4375E-12, 2.3482E-12, 2.2607E-12,
     &   2.1747E-12, 2.0905E-12, 2.0079E-12, 1.9269E-12, 1.8477E-12,
     &   1.7700E-12, 1.6941E-12, 1.6198E-12, 1.5472E-12, 1.4763E-12,
     &   1.4070E-12, 1.3394E-12, 1.2734E-12, 1.2091E-12, 1.1465E-12,
     &   1.0856E-12, 1.0263E-12, 9.6865E-13, 9.1268E-13, 8.5839E-13,
     &   8.0576E-13, 7.5479E-13, 7.0549E-13, 6.5785E-13, 6.1188E-13,
     &   5.6758E-13, 5.2493E-13, 4.8396E-13, 4.4465E-13, 4.0700E-13,
     &   3.7102E-13, 3.3670E-13, 3.0405E-13, 2.7306E-13, 2.4374E-13,
     &   2.1608E-13, 1.9009E-13, 1.6577E-13, 1.4310E-13, 1.2211E-13,
     &   1.0278E-13, 1.0093E-13, 9.9109E-14, 9.7300E-14, 9.5509E-14,
     &   9.3734E-14, 9.1975E-14, 9.0233E-14, 8.8508E-14, 8.6800E-14,
     &   8.5108E-14, 8.3433E-14, 8.1775E-14, 8.0133E-14, 7.8507E-14,
     &   7.6899E-14, 7.5307E-14, 7.3732E-14, 7.2173E-14, 7.0631E-14/
  
         DATA ((DAT  (I,J), I= 701, 800), J=2,2) /
     &   6.9106E-14, 6.7597E-14, 6.6105E-14, 6.4630E-14, 6.3171E-14,
     &   6.1729E-14, 6.0304E-14, 5.8895E-14, 5.7503E-14, 5.6128E-14,
     &   5.4769E-14, 5.3427E-14, 5.2101E-14, 5.0792E-14, 4.9500E-14,
     &   4.8225E-14, 4.6966E-14, 4.5724E-14, 4.4498E-14, 4.3289E-14,
     &   4.2097E-14, 4.0921E-14, 3.9762E-14, 3.8620E-14, 3.7494E-14,
     &   3.6385E-14, 3.5293E-14, 3.4217E-14, 3.3158E-14, 3.2115E-14,
     &   3.1089E-14, 3.0080E-14, 2.9088E-14, 2.8112E-14, 2.7153E-14,
     &   2.6210E-14, 2.5284E-14, 2.4375E-14, 2.3482E-14, 2.2607E-14,
     &   2.1747E-14, 2.0905E-14, 2.0079E-14, 1.9269E-14, 1.8477E-14,
     &   1.7700E-14, 1.6941E-14, 1.6198E-14, 1.5472E-14, 1.4763E-14,
     &   1.4070E-14, 1.3394E-14, 1.2734E-14, 1.2091E-14, 1.1465E-14,
     &   1.0856E-14, 1.0263E-14, 9.6865E-15, 9.1268E-15, 8.5839E-15,
     &   8.0576E-15, 7.5479E-15, 7.0549E-15, 6.5785E-15, 6.1188E-15,
     &   5.6758E-15, 5.2493E-15, 4.8396E-15, 4.4465E-15, 4.0700E-15,
     &   3.7102E-15, 3.3670E-15, 3.0405E-15, 2.7306E-15, 2.4374E-15,
     &   2.1608E-15, 1.9009E-15, 1.6577E-15, 1.4310E-15, 1.2211E-15,
     &   1.0278E-15, 1.0093E-15, 9.9109E-16, 9.7300E-16, 9.5509E-16,
     &   9.3734E-16, 9.1975E-16, 9.0233E-16, 8.8508E-16, 8.6800E-16,
     &   8.5108E-16, 8.3433E-16, 8.1775E-16, 8.0133E-16, 7.8507E-16,
     &   7.6899E-16, 7.5307E-16, 7.3732E-16, 7.2173E-16, 7.0631E-16/
  
         DATA ((DAT  (I,J), I= 801, 900), J=2,2) /
     &   6.9106E-16, 6.7597E-16, 6.6105E-16, 6.4630E-16, 6.3171E-16,
     &   6.1729E-16, 6.0304E-16, 5.8895E-16, 5.7503E-16, 5.6128E-16,
     &   5.4769E-16, 5.3427E-16, 5.2101E-16, 5.0792E-16, 4.9500E-16,
     &   4.8225E-16, 4.6966E-16, 4.5724E-16, 4.4498E-16, 4.3289E-16,
     &   4.2097E-16, 4.0921E-16, 3.9762E-16, 3.8620E-16, 3.7494E-16,
     &   3.6385E-16, 3.5293E-16, 3.4217E-16, 3.3158E-16, 3.2115E-16,
     &   3.1089E-16, 3.0080E-16, 2.9088E-16, 2.8112E-16, 2.7153E-16,
     &   2.6210E-16, 2.5284E-16, 2.4375E-16, 2.3482E-16, 2.2607E-16,
     &   2.1747E-16, 2.0905E-16, 2.0079E-16, 1.9269E-16, 1.8477E-16,
     &   1.7700E-16, 1.6941E-16, 1.6198E-16, 1.5472E-16, 1.4763E-16,
     &   1.4070E-16, 1.3394E-16, 1.2734E-16, 1.2091E-16, 1.1465E-16,
     &   1.0856E-16, 1.0263E-16, 9.6865E-17, 9.1268E-17, 8.5839E-17,
     &   8.0576E-17, 7.5479E-17, 7.0549E-17, 6.5785E-17, 6.1188E-17,
     &   5.6758E-17, 5.2493E-17, 4.8396E-17, 4.4465E-17, 4.0700E-17,
     &   3.7102E-17, 3.3670E-17, 3.0405E-17, 2.7306E-17, 2.4374E-17,
     &   2.1608E-17, 1.9009E-17, 1.6577E-17, 1.4310E-17, 1.2211E-17,
     &   1.0278E-17, 0.0000E+00, 1.0278E-17, 9.2561E-11, 3.7014E-10,
     &   8.3282E-10, 1.4805E-09, 2.3136E-09, 3.3324E-09, 4.5370E-09,
     &   5.9277E-09, 7.5049E-09, 9.2690E-09, 1.1220E-08, 1.3360E-08,
     &   1.5687E-08, 1.8204E-08, 2.0910E-08, 2.3806E-08, 2.6894E-08/
  
         DATA ((DAT  (I,J), I= 901, 979), J=2,2) /
     &   3.0173E-08, 3.3645E-08, 3.7311E-08, 4.1171E-08, 4.5227E-08,
     &   4.9479E-08, 5.3930E-08, 5.8579E-08, 6.3429E-08, 6.8481E-08,
     &   7.3736E-08, 7.9196E-08, 8.4861E-08, 9.0735E-08, 9.6818E-08,
     &   1.0311E-07, 1.0962E-07, 1.1634E-07, 1.2329E-07, 1.3045E-07,
     &   1.3783E-07, 1.4544E-07, 1.5327E-07, 1.6133E-07, 1.6963E-07,
     &   1.7816E-07, 1.8693E-07, 1.9594E-07, 2.0519E-07, 2.1469E-07,
     &   2.2445E-07, 2.3446E-07, 2.4472E-07, 2.5526E-07, 2.6606E-07,
     &   2.7713E-07, 2.8848E-07, 3.0012E-07, 3.1204E-07, 3.2426E-07,
     &   3.3677E-07, 3.4960E-07, 3.6274E-07, 3.7619E-07, 3.8998E-07,
     &   4.0410E-07, 4.1857E-07, 4.3339E-07, 4.4858E-07, 4.6414E-07,
     &   4.8009E-07, 4.9644E-07, 5.1319E-07, 5.3038E-07, 5.4800E-07,
     &   5.6609E-07, 5.8465E-07, 6.0371E-07, 6.2328E-07, 6.4340E-07,
     &   6.6409E-07, 6.8539E-07, 7.0731E-07, 7.2990E-07, 7.5321E-07,
     &   7.7729E-07, 8.0218E-07, 8.2796E-07, 8.5470E-07, 8.8250E-07,
     &   9.1146E-07, 9.4171E-07, 9.7343E-07, 9.8437E-07, 1.0068E-06,
     &   1.01490278E-06, 1.04221637E-06, 1.04587782E-06, 1.05451612E-06/
  
         DATA ((DAT  (I,J), I=   1, 100), J=3,3) /
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04,
     &   1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4123E-04, 1.4122E-04,
     &   1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04,
     &   1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04,
     &   1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4122E-04, 1.4121E-04,
     &   1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4121E-04,
     &   1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4121E-04, 1.4120E-04,
     &   1.4120E-04, 1.4120E-04, 1.4120E-04, 1.4120E-04, 1.4120E-04,
     &   1.4120E-04, 1.4119E-04, 1.4119E-04, 1.4119E-04, 1.4119E-04,
     &   1.4119E-04, 1.4118E-04, 1.4118E-04, 1.4118E-04, 1.4118E-04,
     &   1.4117E-04, 1.4117E-04, 1.4117E-04, 1.4116E-04, 1.4116E-04,
     &   1.4116E-04, 1.4115E-04, 1.4115E-04, 1.4114E-04, 1.4113E-04,
     &   1.4113E-04, 1.4112E-04, 1.4111E-04, 1.4110E-04, 1.4109E-04,
     &   1.4107E-04, 1.4105E-04, 1.4103E-04, 1.4101E-04, 1.4097E-04,
     &   1.4093E-04, 1.4092E-04, 1.4092E-04, 1.4091E-04, 1.4091E-04,
     &   1.4090E-04, 1.4090E-04, 1.4089E-04, 1.4088E-04, 1.4088E-04/
  
         DATA ((DAT  (I,J), I= 101, 200), J=3,3) /
     &   1.4087E-04, 1.4087E-04, 1.4086E-04, 1.4085E-04, 1.4084E-04,
     &   1.4084E-04, 1.4083E-04, 1.4082E-04, 1.4081E-04, 1.4080E-04,
     &   1.4079E-04, 1.4078E-04, 1.4077E-04, 1.4076E-04, 1.4075E-04,
     &   1.4074E-04, 1.4073E-04, 1.4072E-04, 1.4071E-04, 1.4069E-04,
     &   1.4068E-04, 1.4067E-04, 1.4065E-04, 1.4064E-04, 1.4062E-04,
     &   1.4061E-04, 1.4059E-04, 1.4057E-04, 1.4055E-04, 1.4053E-04,
     &   1.4051E-04, 1.4049E-04, 1.4047E-04, 1.4044E-04, 1.4042E-04,
     &   1.4039E-04, 1.4036E-04, 1.4033E-04, 1.4030E-04, 1.4027E-04,
     &   1.4023E-04, 1.4020E-04, 1.4016E-04, 1.4012E-04, 1.4007E-04,
     &   1.4003E-04, 1.3998E-04, 1.3992E-04, 1.3987E-04, 1.3980E-04,
     &   1.3974E-04, 1.3967E-04, 1.3959E-04, 1.3951E-04, 1.3942E-04,
     &   1.3933E-04, 1.3922E-04, 1.3911E-04, 1.3899E-04, 1.3886E-04,
     &   1.3871E-04, 1.3855E-04, 1.3837E-04, 1.3818E-04, 1.3796E-04,
     &   1.3772E-04, 1.3745E-04, 1.3715E-04, 1.3682E-04, 1.3643E-04,
     &   1.3600E-04, 1.3551E-04, 1.3494E-04, 1.3428E-04, 1.3352E-04,
     &   1.3263E-04, 1.3157E-04, 1.3031E-04, 1.2880E-04, 1.2695E-04,
     &   1.2468E-04, 1.2445E-04, 1.2421E-04, 1.2397E-04, 1.2373E-04,
     &   1.2348E-04, 1.2323E-04, 1.2297E-04, 1.2270E-04, 1.2243E-04,
     &   1.2216E-04, 1.2187E-04, 1.2159E-04, 1.2129E-04, 1.2099E-04,
     &   1.2068E-04, 1.2037E-04, 1.2005E-04, 1.1972E-04, 1.1939E-04/
  
         DATA ((DAT  (I,J), I= 201, 300), J=3,3) /
     &   1.1905E-04, 1.1870E-04, 1.1834E-04, 1.1797E-04, 1.1760E-04,
     &   1.1722E-04, 1.1682E-04, 1.1642E-04, 1.1601E-04, 1.1560E-04,
     &   1.1517E-04, 1.1473E-04, 1.1428E-04, 1.1382E-04, 1.1335E-04,
     &   1.1287E-04, 1.1237E-04, 1.1187E-04, 1.1135E-04, 1.1082E-04,
     &   1.1028E-04, 1.0973E-04, 1.0916E-04, 1.0857E-04, 1.0798E-04,
     &   1.0737E-04, 1.0674E-04, 1.0610E-04, 1.0544E-04, 1.0476E-04,
     &   1.0407E-04, 1.0336E-04, 1.0264E-04, 1.0189E-04, 1.0113E-04,
     &   1.0035E-04, 9.9542E-05, 9.8719E-05, 9.7875E-05, 9.7009E-05,
     &   9.6122E-05, 9.5211E-05, 9.4277E-05, 9.3318E-05, 9.2334E-05,
     &   9.1325E-05, 9.0289E-05, 8.9226E-05, 8.8134E-05, 8.7012E-05,
     &   8.5861E-05, 8.4677E-05, 8.3461E-05, 8.2210E-05, 8.0924E-05,
     &   7.9601E-05, 7.8238E-05, 7.6835E-05, 7.5389E-05, 7.3899E-05,
     &   7.2360E-05, 7.0772E-05, 6.9131E-05, 6.7434E-05, 6.5679E-05,
     &   6.3861E-05, 6.1976E-05, 6.0022E-05, 5.7995E-05, 5.5889E-05,
     &   5.3703E-05, 5.1432E-05, 4.9072E-05, 4.6623E-05, 4.4081E-05,
     &   4.1447E-05, 3.8723E-05, 3.5910E-05, 3.3015E-05, 3.0047E-05,
     &   2.7016E-05, 2.6710E-05, 2.6404E-05, 2.6097E-05, 2.5790E-05,
     &   2.5482E-05, 2.5174E-05, 2.4866E-05, 2.4557E-05, 2.4248E-05,
     &   2.3939E-05, 2.3629E-05, 2.3319E-05, 2.3009E-05, 2.2699E-05,
     &   2.2389E-05, 2.2078E-05, 2.1767E-05, 2.1456E-05, 2.1145E-05/
  
         DATA ((DAT  (I,J), I= 301, 400), J=3,3) /
     &   2.0834E-05, 2.0523E-05, 2.0212E-05, 1.9901E-05, 1.9590E-05,
     &   1.9280E-05, 1.8969E-05, 1.8658E-05, 1.8348E-05, 1.8038E-05,
     &   1.7728E-05, 1.7418E-05, 1.7109E-05, 1.6800E-05, 1.6491E-05,
     &   1.6183E-05, 1.5875E-05, 1.5568E-05, 1.5262E-05, 1.4956E-05,
     &   1.4650E-05, 1.4346E-05, 1.4042E-05, 1.3739E-05, 1.3436E-05,
     &   1.3135E-05, 1.2834E-05, 1.2535E-05, 1.2237E-05, 1.1939E-05,
     &   1.1643E-05, 1.1349E-05, 1.1055E-05, 1.0763E-05, 1.0473E-05,
     &   1.0183E-05, 9.8959E-06, 9.6101E-06, 9.3261E-06, 9.0439E-06,
     &   8.7637E-06, 8.4854E-06, 8.2093E-06, 7.9354E-06, 7.6638E-06,
     &   7.3946E-06, 7.1280E-06, 6.8639E-06, 6.6026E-06, 6.3442E-06,
     &   6.0887E-06, 5.8363E-06, 5.5871E-06, 5.3412E-06, 5.0989E-06,
     &   4.8601E-06, 4.6251E-06, 4.3940E-06, 4.1669E-06, 3.9441E-06,
     &   3.7256E-06, 3.5115E-06, 3.3022E-06, 3.0977E-06, 2.8981E-06,
     &   2.7037E-06, 2.5147E-06, 2.3311E-06, 2.1532E-06, 1.9812E-06,
     &   1.8151E-06, 1.6553E-06, 1.5018E-06, 1.3549E-06, 1.2146E-06,
     &   1.0813E-06, 9.5498E-07, 8.3588E-07, 7.2416E-07, 6.1994E-07,
     &   5.2340E-07, 5.1417E-07, 5.0502E-07, 4.9595E-07, 4.8696E-07,
     &   4.7804E-07, 4.6921E-07, 4.6045E-07, 4.5177E-07, 4.4317E-07,
     &   4.3465E-07, 4.2621E-07, 4.1785E-07, 4.0957E-07, 4.0137E-07,
     &   3.9325E-07, 3.8521E-07, 3.7724E-07, 3.6936E-07, 3.6156E-07/
  
         DATA ((DAT  (I,J), I= 401, 500), J=3,3) /
     &   3.5384E-07, 3.4620E-07, 3.3864E-07, 3.3116E-07, 3.2377E-07,
     &   3.1645E-07, 3.0922E-07, 3.0206E-07, 2.9499E-07, 2.8800E-07,
     &   2.8109E-07, 2.7426E-07, 2.6751E-07, 2.6085E-07, 2.5427E-07,
     &   2.4777E-07, 2.4135E-07, 2.3501E-07, 2.2876E-07, 2.2259E-07,
     &   2.1650E-07, 2.1049E-07, 2.0457E-07, 1.9873E-07, 1.9298E-07,
     &   1.8730E-07, 1.8171E-07, 1.7620E-07, 1.7078E-07, 1.6544E-07,
     &   1.6018E-07, 1.5501E-07, 1.4992E-07, 1.4491E-07, 1.3999E-07,
     &   1.3515E-07, 1.3040E-07, 1.2573E-07, 1.2114E-07, 1.1664E-07,
     &   1.1222E-07, 1.0789E-07, 1.0364E-07, 9.9475E-08, 9.5396E-08,
     &   9.1401E-08, 8.7490E-08, 8.3665E-08, 7.9924E-08, 7.6268E-08,
     &   7.2698E-08, 6.9212E-08, 6.5811E-08, 6.2495E-08, 5.9265E-08,
     &   5.6120E-08, 5.3060E-08, 5.0085E-08, 4.7196E-08, 4.4393E-08,
     &   4.1674E-08, 3.9042E-08, 3.6495E-08, 3.4033E-08, 3.1657E-08,
     &   2.9367E-08, 2.7163E-08, 2.5044E-08, 2.3011E-08, 2.1064E-08,
     &   1.9203E-08, 1.7428E-08, 1.5739E-08, 1.4136E-08, 1.2618E-08,
     &   1.1187E-08, 9.8419E-09, 8.5828E-09, 7.4097E-09, 6.3227E-09,
     &   5.3219E-09, 5.2265E-09, 5.1321E-09, 5.0384E-09, 4.9457E-09,
     &   4.8538E-09, 4.7627E-09, 4.6726E-09, 4.5832E-09, 4.4948E-09,
     &   4.4072E-09, 4.3205E-09, 4.2346E-09, 4.1496E-09, 4.0654E-09,
     &   3.9821E-09, 3.8997E-09, 3.8182E-09, 3.7375E-09, 3.6576E-09/
  
         DATA ((DAT  (I,J), I= 501, 600), J=3,3) /
     &   3.5786E-09, 3.5005E-09, 3.4233E-09, 3.3469E-09, 3.2714E-09,
     &   3.1967E-09, 3.1229E-09, 3.0499E-09, 2.9778E-09, 2.9066E-09,
     &   2.8363E-09, 2.7668E-09, 2.6981E-09, 2.6304E-09, 2.5634E-09,
     &   2.4974E-09, 2.4322E-09, 2.3679E-09, 2.3044E-09, 2.2418E-09,
     &   2.1801E-09, 2.1192E-09, 2.0592E-09, 2.0000E-09, 1.9417E-09,
     &   1.8843E-09, 1.8277E-09, 1.7720E-09, 1.7172E-09, 1.6632E-09,
     &   1.6101E-09, 1.5578E-09, 1.5064E-09, 1.4559E-09, 1.4062E-09,
     &   1.3574E-09, 1.3094E-09, 1.2624E-09, 1.2161E-09, 1.1708E-09,
     &   1.1263E-09, 1.0826E-09, 1.0399E-09, 9.9794E-10, 9.5688E-10,
     &   9.1669E-10, 8.7737E-10, 8.3890E-10, 8.0130E-10, 7.6455E-10,
     &   7.2868E-10, 6.9366E-10, 6.5950E-10, 6.2621E-10, 5.9378E-10,
     &   5.6221E-10, 5.3151E-10, 5.0166E-10, 4.7268E-10, 4.4456E-10,
     &   4.1730E-10, 3.9091E-10, 3.6537E-10, 3.4070E-10, 3.1690E-10,
     &   2.9395E-10, 2.7187E-10, 2.5064E-10, 2.3028E-10, 2.1079E-10,
     &   1.9215E-10, 1.7438E-10, 1.5747E-10, 1.4142E-10, 1.2624E-10,
     &   1.1191E-10, 9.8450E-11, 8.5851E-11, 7.4115E-11, 6.3240E-11,
     &   5.3228E-11, 5.2274E-11, 5.1329E-11, 5.0393E-11, 4.9465E-11,
     &   4.8545E-11, 4.7635E-11, 4.6733E-11, 4.5839E-11, 4.4954E-11,
     &   4.4078E-11, 4.3211E-11, 4.2352E-11, 4.1501E-11, 4.0660E-11,
     &   3.9827E-11, 3.9002E-11, 3.8186E-11, 3.7379E-11, 3.6581E-11/
  
         DATA ((DAT  (I,J), I= 601, 700), J=3,3) /
     &   3.5791E-11, 3.5009E-11, 3.4236E-11, 3.3472E-11, 3.2717E-11,
     &   3.1970E-11, 3.1232E-11, 3.0502E-11, 2.9781E-11, 2.9069E-11,
     &   2.8365E-11, 2.7670E-11, 2.6984E-11, 2.6306E-11, 2.5637E-11,
     &   2.4976E-11, 2.4324E-11, 2.3681E-11, 2.3046E-11, 2.2420E-11,
     &   2.1802E-11, 2.1193E-11, 2.0593E-11, 2.0001E-11, 1.9418E-11,
     &   1.8844E-11, 1.8278E-11, 1.7721E-11, 1.7173E-11, 1.6633E-11,
     &   1.6101E-11, 1.5579E-11, 1.5065E-11, 1.4559E-11, 1.4063E-11,
     &   1.3574E-11, 1.3095E-11, 1.2624E-11, 1.2162E-11, 1.1708E-11,
     &   1.1263E-11, 1.0827E-11, 1.0399E-11, 9.9797E-12, 9.5691E-12,
     &   9.1672E-12, 8.7739E-12, 8.3892E-12, 8.0132E-12, 7.6457E-12,
     &   7.2869E-12, 6.9367E-12, 6.5952E-12, 6.2622E-12, 5.9379E-12,
     &   5.6222E-12, 5.3151E-12, 5.0167E-12, 4.7269E-12, 4.4457E-12,
     &   4.1731E-12, 3.9091E-12, 3.6538E-12, 3.4071E-12, 3.1690E-12,
     &   2.9395E-12, 2.7187E-12, 2.5065E-12, 2.3029E-12, 2.1079E-12,
     &   1.9215E-12, 1.7438E-12, 1.5747E-12, 1.4142E-12, 1.2624E-12,
     &   1.1191E-12, 9.8451E-13, 8.5852E-13, 7.4115E-13, 6.3240E-13,
     &   5.3228E-13, 5.2274E-13, 5.1329E-13, 5.0393E-13, 4.9465E-13,
     &   4.8545E-13, 4.7635E-13, 4.6733E-13, 4.5839E-13, 4.4954E-13,
     &   4.4078E-13, 4.3211E-13, 4.2352E-13, 4.1501E-13, 4.0660E-13,
     &   3.9827E-13, 3.9002E-13, 3.8186E-13, 3.7379E-13, 3.6581E-13/
  
         DATA ((DAT  (I,J), I= 701, 800), J=3,3) /
     &   3.5791E-13, 3.5009E-13, 3.4237E-13, 3.3472E-13, 3.2717E-13,
     &   3.1970E-13, 3.1232E-13, 3.0502E-13, 2.9781E-13, 2.9069E-13,
     &   2.8365E-13, 2.7670E-13, 2.6984E-13, 2.6306E-13, 2.5637E-13,
     &   2.4976E-13, 2.4324E-13, 2.3681E-13, 2.3046E-13, 2.2420E-13,
     &   2.1802E-13, 2.1193E-13, 2.0593E-13, 2.0001E-13, 1.9418E-13,
     &   1.8844E-13, 1.8278E-13, 1.7721E-13, 1.7173E-13, 1.6633E-13,
     &   1.6102E-13, 1.5579E-13, 1.5065E-13, 1.4559E-13, 1.4063E-13,
     &   1.3574E-13, 1.3095E-13, 1.2624E-13, 1.2162E-13, 1.1708E-13,
     &   1.1263E-13, 1.0827E-13, 1.0399E-13, 9.9797E-14, 9.5691E-14,
     &   9.1672E-14, 8.7739E-14, 8.3892E-14, 8.0132E-14, 7.6457E-14,
     &   7.2869E-14, 6.9367E-14, 6.5952E-14, 6.2622E-14, 5.9379E-14,
     &   5.6222E-14, 5.3151E-14, 5.0167E-14, 4.7269E-14, 4.4457E-14,
     &   4.1731E-14, 3.9091E-14, 3.6538E-14, 3.4071E-14, 3.1690E-14,
     &   2.9395E-14, 2.7187E-14, 2.5065E-14, 2.3029E-14, 2.1079E-14,
     &   1.9215E-14, 1.7438E-14, 1.5747E-14, 1.4142E-14, 1.2624E-14,
     &   1.1191E-14, 9.8451E-15, 8.5852E-15, 7.4115E-15, 6.3240E-15,
     &   5.3228E-15, 5.2274E-15, 5.1329E-15, 5.0393E-15, 4.9465E-15,
     &   4.8545E-15, 4.7635E-15, 4.6733E-15, 4.5839E-15, 4.4954E-15,
     &   4.4078E-15, 4.3211E-15, 4.2352E-15, 4.1501E-15, 4.0660E-15,
     &   3.9827E-15, 3.9002E-15, 3.8186E-15, 3.7379E-15, 3.6581E-15/
  
         DATA ((DAT  (I,J), I= 801, 900), J=3,3) /
     &   3.5791E-15, 3.5009E-15, 3.4237E-15, 3.3472E-15, 3.2717E-15,
     &   3.1970E-15, 3.1232E-15, 3.0502E-15, 2.9781E-15, 2.9069E-15,
     &   2.8365E-15, 2.7670E-15, 2.6984E-15, 2.6306E-15, 2.5637E-15,
     &   2.4976E-15, 2.4324E-15, 2.3681E-15, 2.3046E-15, 2.2420E-15,
     &   2.1802E-15, 2.1193E-15, 2.0593E-15, 2.0001E-15, 1.9418E-15,
     &   1.8844E-15, 1.8278E-15, 1.7721E-15, 1.7173E-15, 1.6633E-15,
     &   1.6102E-15, 1.5579E-15, 1.5065E-15, 1.4559E-15, 1.4063E-15,
     &   1.3574E-15, 1.3095E-15, 1.2624E-15, 1.2162E-15, 1.1708E-15,
     &   1.1263E-15, 1.0827E-15, 1.0399E-15, 9.9797E-16, 9.5691E-16,
     &   9.1672E-16, 8.7739E-16, 8.3892E-16, 8.0132E-16, 7.6457E-16,
     &   7.2869E-16, 6.9367E-16, 6.5952E-16, 6.2622E-16, 5.9379E-16,
     &   5.6222E-16, 5.3151E-16, 5.0167E-16, 4.7269E-16, 4.4457E-16,
     &   4.1731E-16, 3.9091E-16, 3.6538E-16, 3.4071E-16, 3.1690E-16,
     &   2.9395E-16, 2.7187E-16, 2.5065E-16, 2.3029E-16, 2.1079E-16,
     &   1.9215E-16, 1.7438E-16, 1.5747E-16, 1.4142E-16, 1.2624E-16,
     &   1.1191E-16, 9.8451E-17, 8.5852E-17, 7.4115E-17, 6.3240E-17,
     &   5.3228E-17, 0.0000E+00, 5.3228E-17, 4.7938E-10, 1.9170E-09,
     &   4.3130E-09, 7.6668E-09, 1.1981E-08, 1.7256E-08, 2.3492E-08,
     &   3.0690E-08, 3.8852E-08, 4.7980E-08, 5.8075E-08, 6.9139E-08,
     &   8.1174E-08, 9.4183E-08, 1.0817E-07, 1.2313E-07, 1.3908E-07/
  
         DATA ((DAT  (I,J), I= 901, 979), J=3,3) /
     &   1.5601E-07, 1.7392E-07, 1.9283E-07, 2.1274E-07, 2.3364E-07,
     &   2.5555E-07, 2.7846E-07, 3.0239E-07, 3.2733E-07, 3.5330E-07,
     &   3.8029E-07, 4.0832E-07, 4.3738E-07, 4.6750E-07, 4.9866E-07,
     &   5.3088E-07, 5.6417E-07, 5.9853E-07, 6.3397E-07, 6.7050E-07,
     &   7.0813E-07, 7.4686E-07, 7.8671E-07, 8.2768E-07, 8.6978E-07,
     &   9.1303E-07, 9.5744E-07, 1.0030E-06, 1.0498E-06, 1.0977E-06,
     &   1.1468E-06, 1.1972E-06, 1.2488E-06, 1.3016E-06, 1.3557E-06,
     &   1.4111E-06, 1.4677E-06, 1.5257E-06, 1.5849E-06, 1.6456E-06,
     &   1.7076E-06, 1.7709E-06, 1.8357E-06, 1.9019E-06, 1.9696E-06,
     &   2.0387E-06, 2.1094E-06, 2.1816E-06, 2.2553E-06, 2.3306E-06,
     &   2.4076E-06, 2.4862E-06, 2.5665E-06, 2.6486E-06, 2.7324E-06,
     &   2.8180E-06, 2.9056E-06, 2.9950E-06, 3.0864E-06, 3.1798E-06,
     &   3.2754E-06, 3.3731E-06, 3.4731E-06, 3.5753E-06, 3.6800E-06,
     &   3.7873E-06, 3.8971E-06, 4.0097E-06, 4.1251E-06, 4.2436E-06,
     &   4.3653E-06, 4.4903E-06, 4.6190E-06, 4.6627E-06, 4.7515E-06,
     &   4.78304724E-06, 4.88823283E-06, 4.90214533E-06, 4.93478289E-06/

c      ++++ deghadt23 ++++  

c update 09/25/25 
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 20:52:28 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -1, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
         DATA ((DGT  (I,J), I=   1, 100), J=1,1) /
     &   8.3890E-02, 8.3784E-02, 8.3677E-02, 8.3568E-02, 8.3459E-02,
     &   8.3348E-02, 8.3235E-02, 8.3122E-02, 8.3007E-02, 8.2890E-02,
     &   8.2772E-02, 8.2653E-02, 8.2532E-02, 8.2410E-02, 8.2286E-02,
     &   8.2161E-02, 8.2034E-02, 8.1905E-02, 8.1774E-02, 8.1642E-02,
     &   8.1507E-02, 8.1371E-02, 8.1233E-02, 8.1093E-02, 8.0951E-02,
     &   8.0807E-02, 8.0661E-02, 8.0512E-02, 8.0361E-02, 8.0208E-02,
     &   8.0052E-02, 7.9894E-02, 7.9733E-02, 7.9570E-02, 7.9404E-02,
     &   7.9235E-02, 7.9063E-02, 7.8888E-02, 7.8710E-02, 7.8529E-02,
     &   7.8344E-02, 7.8156E-02, 7.7965E-02, 7.7769E-02, 7.7570E-02,
     &   7.7367E-02, 7.7160E-02, 7.6949E-02, 7.6733E-02, 7.6512E-02,
     &   7.6287E-02, 7.6057E-02, 7.5821E-02, 7.5580E-02, 7.5334E-02,
     &   7.5081E-02, 7.4823E-02, 7.4558E-02, 7.4286E-02, 7.4007E-02,
     &   7.3721E-02, 7.3427E-02, 7.3125E-02, 7.2814E-02, 7.2494E-02,
     &   7.2165E-02, 7.1825E-02, 7.1474E-02, 7.1113E-02, 7.0739E-02,
     &   7.0352E-02, 6.9951E-02, 6.9536E-02, 6.9105E-02, 6.8657E-02,
     &   6.8190E-02, 6.7704E-02, 6.7197E-02, 6.6666E-02, 6.6110E-02,
     &   6.5525E-02, 6.4910E-02, 6.4261E-02, 6.3574E-02, 6.2844E-02,
     &   6.2066E-02, 6.1234E-02, 6.0339E-02, 5.9371E-02, 5.8318E-02,
     &   5.7163E-02, 5.7042E-02, 5.6919E-02, 5.6794E-02, 5.6669E-02,
     &   5.6542E-02, 5.6413E-02, 5.6284E-02, 5.6152E-02, 5.6020E-02/
  
         DATA ((DGT  (I,J), I= 101, 200), J=1,1) /
     &   5.5886E-02, 5.5750E-02, 5.5613E-02, 5.5474E-02, 5.5334E-02,
     &   5.5192E-02, 5.5049E-02, 5.4903E-02, 5.4756E-02, 5.4607E-02,
     &   5.4456E-02, 5.4304E-02, 5.4149E-02, 5.3992E-02, 5.3833E-02,
     &   5.3673E-02, 5.3509E-02, 5.3344E-02, 5.3177E-02, 5.3007E-02,
     &   5.2834E-02, 5.2659E-02, 5.2482E-02, 5.2302E-02, 5.2119E-02,
     &   5.1934E-02, 5.1745E-02, 5.1554E-02, 5.1359E-02, 5.1162E-02,
     &   5.0961E-02, 5.0756E-02, 5.0549E-02, 5.0337E-02, 5.0122E-02,
     &   4.9903E-02, 4.9680E-02, 4.9452E-02, 4.9221E-02, 4.8985E-02,
     &   4.8744E-02, 4.8498E-02, 4.8248E-02, 4.7992E-02, 4.7730E-02,
     &   4.7463E-02, 4.7190E-02, 4.6910E-02, 4.6624E-02, 4.6332E-02,
     &   4.6032E-02, 4.5724E-02, 4.5409E-02, 4.5085E-02, 4.4752E-02,
     &   4.4410E-02, 4.4058E-02, 4.3696E-02, 4.3323E-02, 4.2939E-02,
     &   4.2541E-02, 4.2131E-02, 4.1706E-02, 4.1267E-02, 4.0811E-02,
     &   4.0338E-02, 3.9845E-02, 3.9333E-02, 3.8798E-02, 3.8240E-02,
     &   3.7655E-02, 3.7042E-02, 3.6397E-02, 3.5716E-02, 3.4997E-02,
     &   3.4234E-02, 3.3422E-02, 3.2554E-02, 3.1622E-02, 3.0616E-02,
     &   2.9523E-02, 2.9420E-02, 2.9316E-02, 2.9211E-02, 2.9105E-02,
     &   2.8998E-02, 2.8891E-02, 2.8782E-02, 2.8673E-02, 2.8562E-02,
     &   2.8451E-02, 2.8339E-02, 2.8225E-02, 2.8111E-02, 2.7995E-02,
     &   2.7879E-02, 2.7761E-02, 2.7642E-02, 2.7523E-02, 2.7402E-02/
  
         DATA ((DGT  (I,J), I= 201, 300), J=1,1) /
     &   2.7279E-02, 2.7156E-02, 2.7031E-02, 2.6906E-02, 2.6778E-02,
     &   2.6650E-02, 2.6520E-02, 2.6389E-02, 2.6257E-02, 2.6123E-02,
     &   2.5988E-02, 2.5851E-02, 2.5713E-02, 2.5573E-02, 2.5431E-02,
     &   2.5288E-02, 2.5144E-02, 2.4997E-02, 2.4849E-02, 2.4699E-02,
     &   2.4548E-02, 2.4394E-02, 2.4239E-02, 2.4081E-02, 2.3922E-02,
     &   2.3760E-02, 2.3597E-02, 2.3431E-02, 2.3263E-02, 2.3093E-02,
     &   2.2920E-02, 2.2745E-02, 2.2568E-02, 2.2388E-02, 2.2205E-02,
     &   2.2019E-02, 2.1831E-02, 2.1640E-02, 2.1446E-02, 2.1249E-02,
     &   2.1048E-02, 2.0845E-02, 2.0638E-02, 2.0427E-02, 2.0213E-02,
     &   1.9995E-02, 1.9773E-02, 1.9547E-02, 1.9317E-02, 1.9083E-02,
     &   1.8844E-02, 1.8600E-02, 1.8351E-02, 1.8097E-02, 1.7838E-02,
     &   1.7574E-02, 1.7303E-02, 1.7026E-02, 1.6743E-02, 1.6453E-02,
     &   1.6156E-02, 1.5851E-02, 1.5539E-02, 1.5218E-02, 1.4888E-02,
     &   1.4548E-02, 1.4198E-02, 1.3837E-02, 1.3464E-02, 1.3079E-02,
     &   1.2679E-02, 1.2265E-02, 1.1834E-02, 1.1385E-02, 1.0916E-02,
     &   1.0424E-02, 9.9090E-03, 9.3665E-03, 8.7941E-03, 8.1886E-03,
     &   7.5469E-03, 7.4807E-03, 7.4140E-03, 7.3469E-03, 7.2794E-03,
     &   7.2115E-03, 7.1432E-03, 7.0745E-03, 7.0054E-03, 6.9359E-03,
     &   6.8660E-03, 6.7956E-03, 6.7248E-03, 6.6537E-03, 6.5821E-03,
     &   6.5100E-03, 6.4376E-03, 6.3647E-03, 6.2914E-03, 6.2177E-03/
  
         DATA ((DGT  (I,J), I= 301, 400), J=1,1) /
     &   6.1436E-03, 6.0690E-03, 5.9940E-03, 5.9186E-03, 5.8428E-03,
     &   5.7666E-03, 5.6899E-03, 5.6129E-03, 5.5354E-03, 5.4575E-03,
     &   5.3793E-03, 5.3006E-03, 5.2215E-03, 5.1421E-03, 5.0623E-03,
     &   4.9821E-03, 4.9015E-03, 4.8206E-03, 4.7393E-03, 4.6577E-03,
     &   4.5757E-03, 4.4935E-03, 4.4109E-03, 4.3281E-03, 4.2449E-03,
     &   4.1615E-03, 4.0779E-03, 3.9940E-03, 3.9099E-03, 3.8256E-03,
     &   3.7412E-03, 3.6566E-03, 3.5718E-03, 3.4870E-03, 3.4020E-03,
     &   3.3171E-03, 3.2320E-03, 3.1470E-03, 3.0621E-03, 2.9771E-03,
     &   2.8933E-03, 2.8086E-03, 2.7241E-03, 2.6398E-03, 2.5557E-03,
     &   2.4720E-03, 2.3885E-03, 2.3055E-03, 2.2229E-03, 2.1408E-03,
     &   2.0592E-03, 1.9801E-03, 1.8998E-03, 1.8201E-03, 1.7413E-03,
     &   1.6633E-03, 1.5862E-03, 1.5100E-03, 1.4348E-03, 1.3608E-03,
     &   1.2879E-03, 1.2162E-03, 1.1459E-03, 1.0769E-03, 1.0094E-03,
     &   9.4059E-04, 8.7614E-04, 8.1337E-04, 7.5235E-04, 6.9317E-04,
     &   6.3589E-04, 5.8061E-04, 5.2739E-04, 4.7632E-04, 4.2747E-04,
     &   3.8092E-04, 3.3674E-04, 2.9500E-04, 2.5578E-04, 2.1914E-04,
     &   1.8514E-04, 1.8189E-04, 1.7866E-04, 1.7547E-04, 1.7230E-04,
     &   1.6915E-04, 1.6604E-04, 1.6295E-04, 1.5989E-04, 1.5685E-04,
     &   1.5385E-04, 1.5087E-04, 1.4792E-04, 1.4500E-04, 1.4210E-04,
     &   1.3923E-04, 1.3639E-04, 1.3358E-04, 1.3080E-04, 1.2804E-04/
  
         DATA ((DGT  (I,J), I= 401, 500), J=1,1) /
     &   1.2532E-04, 1.2262E-04, 1.1995E-04, 1.1730E-04, 1.1469E-04,
     &   1.1210E-04, 1.0955E-04, 1.0702E-04, 1.0452E-04, 1.0205E-04,
     &   9.9602E-05, 9.7187E-05, 9.4801E-05, 9.2444E-05, 9.0115E-05,
     &   8.7816E-05, 8.5545E-05, 8.3303E-05, 8.1090E-05, 7.8906E-05,
     &   7.6752E-05, 7.4626E-05, 7.2529E-05, 7.0462E-05, 6.8424E-05,
     &   6.6414E-05, 6.4435E-05, 6.2484E-05, 6.0563E-05, 5.8671E-05,
     &   5.6809E-05, 5.4976E-05, 5.3173E-05, 5.1399E-05, 4.9655E-05,
     &   4.7940E-05, 4.6256E-05, 4.4600E-05, 4.2975E-05, 4.1379E-05,
     &   3.9813E-05, 3.8277E-05, 3.6771E-05, 3.5294E-05, 3.3848E-05,
     &   3.2431E-05, 3.1045E-05, 2.9688E-05, 2.8361E-05, 2.7065E-05,
     &   2.5798E-05, 2.4562E-05, 2.3356E-05, 2.2179E-05, 2.1033E-05,
     &   1.9918E-05, 1.8832E-05, 1.7777E-05, 1.6752E-05, 1.5757E-05,
     &   1.4792E-05, 1.3858E-05, 1.2954E-05, 1.2081E-05, 1.1238E-05,
     &   1.0425E-05, 9.6424E-06, 8.8905E-06, 8.1690E-06, 7.4779E-06,
     &   6.8173E-06, 6.1872E-06, 5.5876E-06, 5.0184E-06, 4.4798E-06,
     &   3.9717E-06, 3.4942E-06, 3.0472E-06, 2.6307E-06, 2.2448E-06,
     &   1.8895E-06, 1.8556E-06, 1.8221E-06, 1.7888E-06, 1.7559E-06,
     &   1.7233E-06, 1.6910E-06, 1.6590E-06, 1.6272E-06, 1.5958E-06,
     &   1.5647E-06, 1.5339E-06, 1.5035E-06, 1.4733E-06, 1.4434E-06,
     &   1.4138E-06, 1.3846E-06, 1.3556E-06, 1.3270E-06, 1.2986E-06/
  
         DATA ((DGT  (I,J), I= 501, 600), J=1,1) /
     &   1.2706E-06, 1.2428E-06, 1.2154E-06, 1.1883E-06, 1.1615E-06,
     &   1.1350E-06, 1.1088E-06, 1.0829E-06, 1.0573E-06, 1.0320E-06,
     &   1.0070E-06, 9.8233E-07, 9.5796E-07, 9.3390E-07, 9.1014E-07,
     &   8.8669E-07, 8.6355E-07, 8.4071E-07, 8.1818E-07, 7.9595E-07,
     &   7.7403E-07, 7.5241E-07, 7.3111E-07, 7.1010E-07, 6.8941E-07,
     &   6.6902E-07, 6.4893E-07, 6.2915E-07, 6.0968E-07, 5.9051E-07,
     &   5.7165E-07, 5.5310E-07, 5.3485E-07, 5.1691E-07, 4.9927E-07,
     &   4.8194E-07, 4.6492E-07, 4.4820E-07, 4.3179E-07, 4.1568E-07,
     &   3.9988E-07, 3.8439E-07, 3.6920E-07, 3.5432E-07, 3.3974E-07,
     &   3.2547E-07, 3.1151E-07, 2.9785E-07, 2.8450E-07, 2.7146E-07,
     &   2.5872E-07, 2.4628E-07, 2.3416E-07, 2.2234E-07, 2.1082E-07,
     &   1.9961E-07, 1.8871E-07, 1.7812E-07, 1.6783E-07, 1.5784E-07,
     &   1.4816E-07, 1.3879E-07, 1.2973E-07, 1.2097E-07, 1.1251E-07,
     &   1.0437E-07, 9.6527E-08, 8.8992E-08, 8.1763E-08, 7.4841E-08,
     &   6.8224E-08, 6.1914E-08, 5.5910E-08, 5.0212E-08, 4.4820E-08,
     &   3.9735E-08, 3.4955E-08, 3.0482E-08, 2.6315E-08, 2.2454E-08,
     &   1.8899E-08, 1.8560E-08, 1.8225E-08, 1.7892E-08, 1.7563E-08,
     &   1.7236E-08, 1.6913E-08, 1.6593E-08, 1.6275E-08, 1.5961E-08,
     &   1.5650E-08, 1.5342E-08, 1.5037E-08, 1.4735E-08, 1.4436E-08,
     &   1.4141E-08, 1.3848E-08, 1.3558E-08, 1.3272E-08, 1.2988E-08/
  
         DATA ((DGT  (I,J), I= 601, 700), J=1,1) /
     &   1.2708E-08, 1.2430E-08, 1.2156E-08, 1.1884E-08, 1.1616E-08,
     &   1.1351E-08, 1.1089E-08, 1.0830E-08, 1.0574E-08, 1.0321E-08,
     &   1.0071E-08, 9.8244E-09, 9.5806E-09, 9.3400E-09, 9.1023E-09,
     &   8.8678E-09, 8.6363E-09, 8.4079E-09, 8.1825E-09, 7.9602E-09,
     &   7.7409E-09, 7.5248E-09, 7.3116E-09, 7.1016E-09, 6.8946E-09,
     &   6.6906E-09, 6.4898E-09, 6.2920E-09, 6.0972E-09, 5.9055E-09,
     &   5.7169E-09, 5.5313E-09, 5.3488E-09, 5.1694E-09, 4.9930E-09,
     &   4.8197E-09, 4.6494E-09, 4.4822E-09, 4.3181E-09, 4.1570E-09,
     &   3.9990E-09, 3.8440E-09, 3.6921E-09, 3.5433E-09, 3.3976E-09,
     &   3.2548E-09, 3.1152E-09, 2.9786E-09, 2.8451E-09, 2.7146E-09,
     &   2.5872E-09, 2.4629E-09, 2.3416E-09, 2.2234E-09, 2.1083E-09,
     &   1.9962E-09, 1.8872E-09, 1.7812E-09, 1.6783E-09, 1.5784E-09,
     &   1.4817E-09, 1.3879E-09, 1.2973E-09, 1.2097E-09, 1.1252E-09,
     &   1.0437E-09, 9.6528E-10, 8.8993E-10, 8.1764E-10, 7.4841E-10,
     &   6.8225E-10, 6.1914E-10, 5.5910E-10, 5.0212E-10, 4.4820E-10,
     &   3.9735E-10, 3.4955E-10, 3.0482E-10, 2.6315E-10, 2.2454E-10,
     &   1.8899E-10, 1.8560E-10, 1.8225E-10, 1.7892E-10, 1.7563E-10,
     &   1.7236E-10, 1.6913E-10, 1.6593E-10, 1.6275E-10, 1.5961E-10,
     &   1.5650E-10, 1.5342E-10, 1.5037E-10, 1.4735E-10, 1.4436E-10,
     &   1.4141E-10, 1.3848E-10, 1.3558E-10, 1.3272E-10, 1.2988E-10/
  
         DATA ((DGT  (I,J), I= 701, 800), J=1,1) /
     &   1.2708E-10, 1.2430E-10, 1.2156E-10, 1.1885E-10, 1.1616E-10,
     &   1.1351E-10, 1.1089E-10, 1.0830E-10, 1.0574E-10, 1.0321E-10,
     &   1.0071E-10, 9.8244E-11, 9.5806E-11, 9.3400E-11, 9.1023E-11,
     &   8.8678E-11, 8.6363E-11, 8.4079E-11, 8.1825E-11, 7.9602E-11,
     &   7.7410E-11, 7.5248E-11, 7.3116E-11, 7.1016E-11, 6.8946E-11,
     &   6.6907E-11, 6.4898E-11, 6.2920E-11, 6.0972E-11, 5.9055E-11,
     &   5.7169E-11, 5.5313E-11, 5.3488E-11, 5.1694E-11, 4.9930E-11,
     &   4.8197E-11, 4.6494E-11, 4.4822E-11, 4.3181E-11, 4.1570E-11,
     &   3.9990E-11, 3.8440E-11, 3.6921E-11, 3.5433E-11, 3.3976E-11,
     &   3.2548E-11, 3.1152E-11, 2.9786E-11, 2.8451E-11, 2.7146E-11,
     &   2.5872E-11, 2.4629E-11, 2.3416E-11, 2.2234E-11, 2.1083E-11,
     &   1.9962E-11, 1.8872E-11, 1.7812E-11, 1.6783E-11, 1.5784E-11,
     &   1.4817E-11, 1.3879E-11, 1.2973E-11, 1.2097E-11, 1.1252E-11,
     &   1.0437E-11, 9.6528E-12, 8.8993E-12, 8.1764E-12, 7.4841E-12,
     &   6.8225E-12, 6.1914E-12, 5.5910E-12, 5.0212E-12, 4.4820E-12,
     &   3.9735E-12, 3.4955E-12, 3.0482E-12, 2.6315E-12, 2.2454E-12,
     &   1.8899E-12, 1.8560E-12, 1.8225E-12, 1.7892E-12, 1.7563E-12,
     &   1.7236E-12, 1.6913E-12, 1.6593E-12, 1.6275E-12, 1.5961E-12,
     &   1.5650E-12, 1.5342E-12, 1.5037E-12, 1.4735E-12, 1.4436E-12,
     &   1.4141E-12, 1.3848E-12, 1.3558E-12, 1.3272E-12, 1.2988E-12/
  
         DATA ((DGT  (I,J), I= 801, 900), J=1,1) /
     &   1.2708E-12, 1.2430E-12, 1.2156E-12, 1.1885E-12, 1.1616E-12,
     &   1.1351E-12, 1.1089E-12, 1.0830E-12, 1.0574E-12, 1.0321E-12,
     &   1.0071E-12, 9.8244E-13, 9.5806E-13, 9.3400E-13, 9.1023E-13,
     &   8.8678E-13, 8.6363E-13, 8.4079E-13, 8.1825E-13, 7.9602E-13,
     &   7.7410E-13, 7.5248E-13, 7.3116E-13, 7.1016E-13, 6.8946E-13,
     &   6.6907E-13, 6.4898E-13, 6.2920E-13, 6.0972E-13, 5.9055E-13,
     &   5.7169E-13, 5.5313E-13, 5.3488E-13, 5.1694E-13, 4.9930E-13,
     &   4.8197E-13, 4.6494E-13, 4.4822E-13, 4.3181E-13, 4.1570E-13,
     &   3.9990E-13, 3.8440E-13, 3.6921E-13, 3.5433E-13, 3.3976E-13,
     &   3.2548E-13, 3.1152E-13, 2.9786E-13, 2.8451E-13, 2.7146E-13,
     &   2.5872E-13, 2.4629E-13, 2.3416E-13, 2.2234E-13, 2.1083E-13,
     &   1.9962E-13, 1.8872E-13, 1.7812E-13, 1.6783E-13, 1.5784E-13,
     &   1.4817E-13, 1.3879E-13, 1.2973E-13, 1.2097E-13, 1.1252E-13,
     &   1.0437E-13, 9.6528E-14, 8.8993E-14, 8.1764E-14, 7.4841E-14,
     &   6.8225E-14, 6.1914E-14, 5.5910E-14, 5.0212E-14, 4.4820E-14,
     &   3.9735E-14, 3.4955E-14, 3.0482E-14, 2.6315E-14, 2.2454E-14,
     &   1.8899E-14, 0.0000E+00,-1.8899E-14,-1.7021E-07,-6.8064E-07,
     &  -1.5314E-06,-2.7223E-06,-4.2542E-06,-6.1274E-06,-8.3421E-06,
     &  -1.0899E-05,-1.3798E-05,-1.7041E-05,-2.0628E-05,-2.4560E-05,
     &  -2.8838E-05,-3.3462E-05,-3.8434E-05,-4.3755E-05,-4.9427E-05/
  
         DATA ((DGT  (I,J), I= 901, 979), J=1,1) /
     &  -5.5450E-05,-6.1826E-05,-6.8557E-05,-7.5644E-05,-8.3089E-05,
     &  -9.0893E-05,-9.9059E-05,-1.0759E-04,-1.1623E-04,-1.2548E-04,
     &  -1.3510E-04,-1.4509E-04,-1.5546E-04,-1.6620E-04,-1.7733E-04,
     &  -1.8883E-04,-2.0073E-04,-2.1301E-04,-2.2569E-04,-2.3876E-04,
     &  -2.5223E-04,-2.6611E-04,-2.8039E-04,-2.9508E-04,-3.1019E-04,
     &  -3.2572E-04,-3.4168E-04,-3.5806E-04,-3.7487E-04,-3.9213E-04,
     &  -4.0983E-04,-4.2797E-04,-4.4658E-04,-4.6564E-04,-4.8517E-04,
     &  -5.0518E-04,-5.2566E-04,-5.4664E-04,-5.6810E-04,-5.9007E-04,
     &  -6.1255E-04,-6.3555E-04,-6.5908E-04,-6.8314E-04,-7.0775E-04,
     &  -7.3292E-04,-7.5865E-04,-7.8497E-04,-8.1187E-04,-8.3938E-04,
     &  -8.6750E-04,-8.9625E-04,-9.2565E-04,-9.5571E-04,-9.8644E-04,
     &  -1.0179E-03,-1.0500E-03,-1.0829E-03,-1.1166E-03,-1.1510E-03,
     &  -1.1862E-03,-1.2223E-03,-1.2592E-03,-1.2971E-03,-1.3359E-03,
     &  -1.3757E-03,-1.4166E-03,-1.4585E-03,-1.5016E-03,-1.5471E-03,
     &  -1.5928E-03,-1.6401E-03,-1.6891E-03,-1.7058E-03,-1.7400E-03,
     &  -1.75225092E-03,-1.79342320E-03,-1.79893043E-03,-1.81180031E-03/
  
         DATA ((DGT  (I,J), I=   1, 100), J=2,2) /
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05,
     &   8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05,
     &   8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8183E-05,
     &   8.8183E-05, 8.8183E-05, 8.8183E-05, 8.8182E-05, 8.8182E-05,
     &   8.8182E-05, 8.8182E-05, 8.8182E-05, 8.8182E-05, 8.8182E-05,
     &   8.8182E-05, 8.8182E-05, 8.8181E-05, 8.8181E-05, 8.8181E-05,
     &   8.8181E-05, 8.8181E-05, 8.8181E-05, 8.8180E-05, 8.8180E-05,
     &   8.8180E-05, 8.8180E-05, 8.8179E-05, 8.8179E-05, 8.8179E-05,
     &   8.8179E-05, 8.8178E-05, 8.8178E-05, 8.8178E-05, 8.8177E-05,
     &   8.8177E-05, 8.8176E-05, 8.8176E-05, 8.8175E-05, 8.8175E-05,
     &   8.8174E-05, 8.8174E-05, 8.8173E-05, 8.8172E-05, 8.8171E-05,
     &   8.8170E-05, 8.8169E-05, 8.8168E-05, 8.8167E-05, 8.8165E-05,
     &   8.8163E-05, 8.8161E-05, 8.8159E-05, 8.8157E-05, 8.8154E-05,
     &   8.8151E-05, 8.8147E-05, 8.8143E-05, 8.8138E-05, 8.8131E-05,
     &   8.8124E-05, 8.8115E-05, 8.8104E-05, 8.8090E-05, 8.8071E-05,
     &   8.8048E-05, 8.8045E-05, 8.8042E-05, 8.8039E-05, 8.8036E-05,
     &   8.8033E-05, 8.8030E-05, 8.8026E-05, 8.8023E-05, 8.8019E-05/
  
         DATA ((DGT  (I,J), I= 101, 200), J=2,2) /
     &   8.8016E-05, 8.8012E-05, 8.8008E-05, 8.8004E-05, 8.8000E-05,
     &   8.7995E-05, 8.7991E-05, 8.7986E-05, 8.7981E-05, 8.7976E-05,
     &   8.7971E-05, 8.7965E-05, 8.7960E-05, 8.7954E-05, 8.7948E-05,
     &   8.7942E-05, 8.7935E-05, 8.7928E-05, 8.7921E-05, 8.7914E-05,
     &   8.7906E-05, 8.7898E-05, 8.7889E-05, 8.7880E-05, 8.7871E-05,
     &   8.7862E-05, 8.7852E-05, 8.7841E-05, 8.7830E-05, 8.7818E-05,
     &   8.7806E-05, 8.7793E-05, 8.7780E-05, 8.7766E-05, 8.7751E-05,
     &   8.7735E-05, 8.7719E-05, 8.7701E-05, 8.7683E-05, 8.7663E-05,
     &   8.7643E-05, 8.7621E-05, 8.7598E-05, 8.7573E-05, 8.7547E-05,
     &   8.7519E-05, 8.7489E-05, 8.7457E-05, 8.7423E-05, 8.7386E-05,
     &   8.7347E-05, 8.7305E-05, 8.7260E-05, 8.7211E-05, 8.7158E-05,
     &   8.7101E-05, 8.7039E-05, 8.6971E-05, 8.6897E-05, 8.6817E-05,
     &   8.6729E-05, 8.6632E-05, 8.6526E-05, 8.6408E-05, 8.6278E-05,
     &   8.6133E-05, 8.5971E-05, 8.5789E-05, 8.5585E-05, 8.5354E-05,
     &   8.5091E-05, 8.4791E-05, 8.4446E-05, 8.4046E-05, 8.3580E-05,
     &   8.3031E-05, 8.2381E-05, 8.1600E-05, 8.0653E-05, 7.9488E-05,
     &   7.8033E-05, 7.7884E-05, 7.7733E-05, 7.7577E-05, 7.7419E-05,
     &   7.7257E-05, 7.7091E-05, 7.6921E-05, 7.6748E-05, 7.6570E-05,
     &   7.6389E-05, 7.6203E-05, 7.6013E-05, 7.5818E-05, 7.5618E-05,
     &   7.5414E-05, 7.5205E-05, 7.4990E-05, 7.4770E-05, 7.4545E-05/
  
         DATA ((DGT  (I,J), I= 201, 300), J=2,2) /
     &   7.4314E-05, 7.4078E-05, 7.3835E-05, 7.3586E-05, 7.3331E-05,
     &   7.3069E-05, 7.2800E-05, 7.2524E-05, 7.2240E-05, 7.1949E-05,
     &   7.1651E-05, 7.1344E-05, 7.1028E-05, 7.0704E-05, 7.0371E-05,
     &   7.0029E-05, 6.9677E-05, 6.9315E-05, 6.8942E-05, 6.8559E-05,
     &   6.8165E-05, 6.7759E-05, 6.7342E-05, 6.6912E-05, 6.6469E-05,
     &   6.6014E-05, 6.5544E-05, 6.5060E-05, 6.4562E-05, 6.4049E-05,
     &   6.3520E-05, 6.2974E-05, 6.2412E-05, 6.1833E-05, 6.1235E-05,
     &   6.0619E-05, 5.9984E-05, 5.9329E-05, 5.8653E-05, 5.7956E-05,
     &   5.7238E-05, 5.6497E-05, 5.5733E-05, 5.4945E-05, 5.4132E-05,
     &   5.3295E-05, 5.2431E-05, 5.1542E-05, 5.0625E-05, 4.9681E-05,
     &   4.8709E-05, 4.7708E-05, 4.6678E-05, 4.5620E-05, 4.4531E-05,
     &   4.3414E-05, 4.2266E-05, 4.1089E-05, 3.9884E-05, 3.8649E-05,
     &   3.7387E-05, 3.6097E-05, 3.4782E-05, 3.3442E-05, 3.2079E-05,
     &   3.0696E-05, 2.9294E-05, 2.7876E-05, 2.6446E-05, 2.5007E-05,
     &   2.3563E-05, 2.2118E-05, 2.0675E-05, 1.9241E-05, 1.7820E-05,
     &   1.6416E-05, 1.5035E-05, 1.3680E-05, 1.2357E-05, 1.1067E-05,
     &   9.8147E-06, 9.6915E-06, 9.5688E-06, 9.4464E-06, 9.3244E-06,
     &   9.2028E-06, 9.0817E-06, 8.9609E-06, 8.8405E-06, 8.7205E-06,
     &   8.6009E-06, 8.4817E-06, 8.3629E-06, 8.2445E-06, 8.1265E-06,
     &   8.0089E-06, 7.8917E-06, 7.7749E-06, 7.6585E-06, 7.5425E-06/
  
         DATA ((DGT  (I,J), I= 301, 400), J=2,2) /
     &   7.4269E-06, 7.3117E-06, 7.1969E-06, 7.0826E-06, 6.9686E-06,
     &   6.8550E-06, 6.7419E-06, 6.6292E-06, 6.5168E-06, 6.4049E-06,
     &   6.2934E-06, 6.1824E-06, 6.0717E-06, 5.9614E-06, 5.8516E-06,
     &   5.7422E-06, 5.6332E-06, 5.5247E-06, 5.4165E-06, 5.3089E-06,
     &   5.2016E-06, 5.0948E-06, 4.9884E-06, 4.8825E-06, 4.7770E-06,
     &   4.6720E-06, 4.5675E-06, 4.4634E-06, 4.3598E-06, 4.2567E-06,
     &   4.1541E-06, 4.0520E-06, 3.9504E-06, 3.8493E-06, 3.7488E-06,
     &   3.6488E-06, 3.5493E-06, 3.4505E-06, 3.3522E-06, 3.2545E-06,
     &   3.1575E-06, 3.0610E-06, 2.9653E-06, 2.8702E-06, 2.7759E-06,
     &   2.6822E-06, 2.5893E-06, 2.4972E-06, 2.4059E-06, 2.3155E-06,
     &   2.2259E-06, 2.1372E-06, 2.0495E-06, 1.9628E-06, 1.8771E-06,
     &   1.7924E-06, 1.7089E-06, 1.6266E-06, 1.5454E-06, 1.4656E-06,
     &   1.3871E-06, 1.3099E-06, 1.2342E-06, 1.1600E-06, 1.0874E-06,
     &   1.0165E-06, 9.4724E-07, 8.7979E-07, 8.1421E-07, 7.5057E-07,
     &   6.8895E-07, 6.2943E-07, 5.7210E-07, 5.1703E-07, 4.6430E-07,
     &   4.1401E-07, 3.6623E-07, 3.2105E-07, 2.7854E-07, 2.3878E-07,
     &   2.0185E-07, 1.9832E-07, 1.9481E-07, 1.9134E-07, 1.8789E-07,
     &   1.8447E-07, 1.8108E-07, 1.7773E-07, 1.7440E-07, 1.7110E-07,
     &   1.6783E-07, 1.6459E-07, 1.6138E-07, 1.5820E-07, 1.5505E-07,
     &   1.5193E-07, 1.4884E-07, 1.4578E-07, 1.4274E-07, 1.3975E-07/
  
         DATA ((DGT  (I,J), I= 401, 500), J=2,2) /
     &   1.3678E-07, 1.3384E-07, 1.3093E-07, 1.2805E-07, 1.2520E-07,
     &   1.2238E-07, 1.1960E-07, 1.1684E-07, 1.1412E-07, 1.1142E-07,
     &   1.0876E-07, 1.0613E-07, 1.0353E-07, 1.0096E-07, 9.8420E-08,
     &   9.5913E-08, 9.3437E-08, 9.0992E-08, 8.8579E-08, 8.6197E-08,
     &   8.3846E-08, 8.1527E-08, 7.9240E-08, 7.6984E-08, 7.4760E-08,
     &   7.2568E-08, 7.0407E-08, 6.8278E-08, 6.6182E-08, 6.4117E-08,
     &   6.2084E-08, 6.0083E-08, 5.8114E-08, 5.6178E-08, 5.4273E-08,
     &   5.2401E-08, 5.0561E-08, 4.8754E-08, 4.6978E-08, 4.5235E-08,
     &   4.3525E-08, 4.1847E-08, 4.0201E-08, 3.8588E-08, 3.7008E-08,
     &   3.5460E-08, 3.3945E-08, 3.2462E-08, 3.1013E-08, 2.9596E-08,
     &   2.8211E-08, 2.6860E-08, 2.5541E-08, 2.4256E-08, 2.3003E-08,
     &   2.1783E-08, 2.0597E-08, 1.9443E-08, 1.8322E-08, 1.7234E-08,
     &   1.6180E-08, 1.5158E-08, 1.4170E-08, 1.3214E-08, 1.2292E-08,
     &   1.1403E-08, 1.0548E-08, 9.7254E-09, 8.9363E-09, 8.1804E-09,
     &   7.4579E-09, 6.7686E-09, 6.1127E-09, 5.4902E-09, 4.9010E-09,
     &   4.3452E-09, 3.8227E-09, 3.3337E-09, 2.8781E-09, 2.4560E-09,
     &   2.0672E-09, 2.0302E-09, 1.9935E-09, 1.9571E-09, 1.9211E-09,
     &   1.8854E-09, 1.8501E-09, 1.8150E-09, 1.7803E-09, 1.7460E-09,
     &   1.7120E-09, 1.6783E-09, 1.6449E-09, 1.6119E-09, 1.5792E-09,
     &   1.5469E-09, 1.5148E-09, 1.4832E-09, 1.4518E-09, 1.4208E-09/
  
         DATA ((DGT  (I,J), I= 501, 600), J=2,2) /
     &   1.3901E-09, 1.3598E-09, 1.3298E-09, 1.3001E-09, 1.2708E-09,
     &   1.2418E-09, 1.2131E-09, 1.1848E-09, 1.1568E-09, 1.1291E-09,
     &   1.1018E-09, 1.0748E-09, 1.0481E-09, 1.0218E-09, 9.9578E-10,
     &   9.7013E-10, 9.4480E-10, 9.1982E-10, 8.9517E-10, 8.7085E-10,
     &   8.4686E-10, 8.2322E-10, 7.9990E-10, 7.7692E-10, 7.5428E-10,
     &   7.3197E-10, 7.1000E-10, 6.8836E-10, 6.6705E-10, 6.4608E-10,
     &   6.2545E-10, 6.0515E-10, 5.8518E-10, 5.6555E-10, 5.4626E-10,
     &   5.2729E-10, 5.0867E-10, 4.9038E-10, 4.7242E-10, 4.5480E-10,
     &   4.3751E-10, 4.2056E-10, 4.0394E-10, 3.8766E-10, 3.7172E-10,
     &   3.5610E-10, 3.4083E-10, 3.2588E-10, 3.1128E-10, 2.9700E-10,
     &   2.8307E-10, 2.6946E-10, 2.5619E-10, 2.4326E-10, 2.3066E-10,
     &   2.1840E-10, 2.0647E-10, 1.9488E-10, 1.8362E-10, 1.7270E-10,
     &   1.6211E-10, 1.5185E-10, 1.4194E-10, 1.3235E-10, 1.2310E-10,
     &   1.1419E-10, 1.0561E-10, 9.7367E-11, 8.9458E-11, 8.1884E-11,
     &   7.4645E-11, 6.7741E-11, 6.1172E-11, 5.4938E-11, 4.9039E-11,
     &   4.3474E-11, 3.8245E-11, 3.3351E-11, 2.8791E-11, 2.4567E-11,
     &   2.0677E-11, 2.0307E-11, 1.9940E-11, 1.9576E-11, 1.9215E-11,
     &   1.8858E-11, 1.8505E-11, 1.8154E-11, 1.7807E-11, 1.7463E-11,
     &   1.7123E-11, 1.6786E-11, 1.6452E-11, 1.6122E-11, 1.5795E-11,
     &   1.5471E-11, 1.5151E-11, 1.4834E-11, 1.4521E-11, 1.4210E-11/
  
         DATA ((DGT  (I,J), I= 601, 700), J=2,2) /
     &   1.3904E-11, 1.3600E-11, 1.3300E-11, 1.3003E-11, 1.2710E-11,
     &   1.2419E-11, 1.2133E-11, 1.1849E-11, 1.1569E-11, 1.1292E-11,
     &   1.1019E-11, 1.0749E-11, 1.0482E-11, 1.0219E-11, 9.9590E-12,
     &   9.7024E-12, 9.4491E-12, 9.1992E-12, 8.9526E-12, 8.7094E-12,
     &   8.4695E-12, 8.2330E-12, 7.9998E-12, 7.7700E-12, 7.5435E-12,
     &   7.3204E-12, 7.1006E-12, 6.8841E-12, 6.6711E-12, 6.4613E-12,
     &   6.2549E-12, 6.0519E-12, 5.8522E-12, 5.6559E-12, 5.4629E-12,
     &   5.2733E-12, 5.0870E-12, 4.9041E-12, 4.7245E-12, 4.5482E-12,
     &   4.3754E-12, 4.2058E-12, 4.0396E-12, 3.8768E-12, 3.7173E-12,
     &   3.5612E-12, 3.4084E-12, 3.2590E-12, 3.1129E-12, 2.9701E-12,
     &   2.8308E-12, 2.6947E-12, 2.5620E-12, 2.4327E-12, 2.3067E-12,
     &   2.1841E-12, 2.0648E-12, 1.9488E-12, 1.8362E-12, 1.7270E-12,
     &   1.6211E-12, 1.5186E-12, 1.4194E-12, 1.3235E-12, 1.2311E-12,
     &   1.1419E-12, 1.0561E-12, 9.7368E-13, 8.9459E-13, 8.1885E-13,
     &   7.4646E-13, 6.7742E-13, 6.1172E-13, 5.4938E-13, 4.9039E-13,
     &   4.3474E-13, 3.8245E-13, 3.3351E-13, 2.8791E-13, 2.4567E-13,
     &   2.0678E-13, 2.0307E-13, 1.9940E-13, 1.9576E-13, 1.9216E-13,
     &   1.8858E-13, 1.8505E-13, 1.8154E-13, 1.7807E-13, 1.7463E-13,
     &   1.7123E-13, 1.6786E-13, 1.6452E-13, 1.6122E-13, 1.5795E-13,
     &   1.5471E-13, 1.5151E-13, 1.4834E-13, 1.4521E-13, 1.4210E-13/
  
         DATA ((DGT  (I,J), I= 701, 800), J=2,2) /
     &   1.3904E-13, 1.3600E-13, 1.3300E-13, 1.3003E-13, 1.2710E-13,
     &   1.2419E-13, 1.2133E-13, 1.1849E-13, 1.1569E-13, 1.1292E-13,
     &   1.1019E-13, 1.0749E-13, 1.0482E-13, 1.0219E-13, 9.9590E-14,
     &   9.7024E-14, 9.4491E-14, 9.1992E-14, 8.9526E-14, 8.7094E-14,
     &   8.4695E-14, 8.2330E-14, 7.9998E-14, 7.7700E-14, 7.5435E-14,
     &   7.3204E-14, 7.1006E-14, 6.8841E-14, 6.6711E-14, 6.4613E-14,
     &   6.2549E-14, 6.0519E-14, 5.8522E-14, 5.6559E-14, 5.4629E-14,
     &   5.2733E-14, 5.0870E-14, 4.9041E-14, 4.7245E-14, 4.5482E-14,
     &   4.3754E-14, 4.2058E-14, 4.0396E-14, 3.8768E-14, 3.7173E-14,
     &   3.5612E-14, 3.4084E-14, 3.2590E-14, 3.1129E-14, 2.9701E-14,
     &   2.8308E-14, 2.6947E-14, 2.5620E-14, 2.4327E-14, 2.3067E-14,
     &   2.1841E-14, 2.0648E-14, 1.9488E-14, 1.8362E-14, 1.7270E-14,
     &   1.6211E-14, 1.5186E-14, 1.4194E-14, 1.3235E-14, 1.2311E-14,
     &   1.1419E-14, 1.0561E-14, 9.7368E-15, 8.9459E-15, 8.1885E-15,
     &   7.4646E-15, 6.7742E-15, 6.1172E-15, 5.4938E-15, 4.9039E-15,
     &   4.3474E-15, 3.8245E-15, 3.3351E-15, 2.8791E-15, 2.4567E-15,
     &   2.0678E-15, 2.0307E-15, 1.9940E-15, 1.9576E-15, 1.9216E-15,
     &   1.8858E-15, 1.8505E-15, 1.8154E-15, 1.7807E-15, 1.7463E-15,
     &   1.7123E-15, 1.6786E-15, 1.6452E-15, 1.6122E-15, 1.5795E-15,
     &   1.5471E-15, 1.5151E-15, 1.4834E-15, 1.4521E-15, 1.4210E-15/
  
         DATA ((DGT  (I,J), I= 801, 900), J=2,2) /
     &   1.3904E-15, 1.3600E-15, 1.3300E-15, 1.3003E-15, 1.2710E-15,
     &   1.2419E-15, 1.2133E-15, 1.1849E-15, 1.1569E-15, 1.1292E-15,
     &   1.1019E-15, 1.0749E-15, 1.0482E-15, 1.0219E-15, 9.9590E-16,
     &   9.7024E-16, 9.4491E-16, 9.1992E-16, 8.9526E-16, 8.7094E-16,
     &   8.4695E-16, 8.2330E-16, 7.9998E-16, 7.7700E-16, 7.5435E-16,
     &   7.3204E-16, 7.1006E-16, 6.8841E-16, 6.6711E-16, 6.4613E-16,
     &   6.2549E-16, 6.0519E-16, 5.8522E-16, 5.6559E-16, 5.4629E-16,
     &   5.2733E-16, 5.0870E-16, 4.9041E-16, 4.7245E-16, 4.5482E-16,
     &   4.3754E-16, 4.2058E-16, 4.0396E-16, 3.8768E-16, 3.7173E-16,
     &   3.5612E-16, 3.4084E-16, 3.2590E-16, 3.1129E-16, 2.9701E-16,
     &   2.8308E-16, 2.6947E-16, 2.5620E-16, 2.4327E-16, 2.3067E-16,
     &   2.1841E-16, 2.0648E-16, 1.9488E-16, 1.8362E-16, 1.7270E-16,
     &   1.6211E-16, 1.5186E-16, 1.4194E-16, 1.3235E-16, 1.2311E-16,
     &   1.1419E-16, 1.0561E-16, 9.7368E-17, 8.9459E-17, 8.1885E-17,
     &   7.4646E-17, 6.7742E-17, 6.1172E-17, 5.4938E-17, 4.9039E-17,
     &   4.3474E-17, 3.8245E-17, 3.3351E-17, 2.8791E-17, 2.4567E-17,
     &   2.0678E-17, 0.0000E+00, 2.0678E-17, 1.8623E-10, 7.4471E-10,
     &   1.6756E-09, 2.9786E-09, 4.6551E-09, 6.7049E-09, 9.1288E-09,
     &   1.1927E-08, 1.5101E-08, 1.8652E-08, 2.2579E-08, 2.6885E-08,
     &   3.1571E-08, 3.6637E-08, 4.2086E-08, 4.7918E-08, 5.4136E-08/
  
         DATA ((DGT  (I,J), I= 901, 979), J=2,2) /
     &   6.0741E-08, 6.7735E-08, 7.5120E-08, 8.2899E-08, 9.1072E-08,
     &   9.9644E-08, 1.0862E-07, 1.1799E-07, 1.2777E-07, 1.3796E-07,
     &   1.4856E-07, 1.5958E-07, 1.7102E-07, 1.8288E-07, 1.9516E-07,
     &   2.0787E-07, 2.2102E-07, 2.3461E-07, 2.4864E-07, 2.6312E-07,
     &   2.7805E-07, 2.9344E-07, 3.0930E-07, 3.2562E-07, 3.4242E-07,
     &   3.5970E-07, 3.7748E-07, 3.9574E-07, 4.1451E-07, 4.3379E-07,
     &   4.5359E-07, 4.7392E-07, 4.9478E-07, 5.1619E-07, 5.3815E-07,
     &   5.6068E-07, 5.8378E-07, 6.0748E-07, 6.3177E-07, 6.5668E-07,
     &   6.8221E-07, 7.0838E-07, 7.3521E-07, 7.6271E-07, 7.9089E-07,
     &   8.1979E-07, 8.4941E-07, 8.7978E-07, 9.1092E-07, 9.4285E-07,
     &   9.7560E-07, 1.0092E-06, 1.0437E-06, 1.0790E-06, 1.1154E-06,
     &   1.1526E-06, 1.1910E-06, 1.2304E-06, 1.2708E-06, 1.3125E-06,
     &   1.3554E-06, 1.3996E-06, 1.4452E-06, 1.4922E-06, 1.5408E-06,
     &   1.5911E-06, 1.6431E-06, 1.6971E-06, 1.7532E-06, 1.8116E-06,
     &   1.8726E-06, 1.9365E-06, 2.0036E-06, 2.0267E-06, 2.0744E-06,
     &   2.09154496E-06, 2.14965468E-06, 2.15745443E-06, 2.17586566E-06/
  
         DATA ((DGT  (I,J), I=   1, 100), J=3,3) /
     &   2.3094E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04, 2.3093E-04,
     &   2.3092E-04, 2.3092E-04, 2.3092E-04, 2.3092E-04, 2.3092E-04,
     &   2.3092E-04, 2.3092E-04, 2.3092E-04, 2.3091E-04, 2.3091E-04,
     &   2.3091E-04, 2.3091E-04, 2.3091E-04, 2.3091E-04, 2.3091E-04,
     &   2.3090E-04, 2.3090E-04, 2.3090E-04, 2.3090E-04, 2.3090E-04,
     &   2.3090E-04, 2.3089E-04, 2.3089E-04, 2.3089E-04, 2.3089E-04,
     &   2.3089E-04, 2.3089E-04, 2.3088E-04, 2.3088E-04, 2.3088E-04,
     &   2.3088E-04, 2.3087E-04, 2.3087E-04, 2.3087E-04, 2.3087E-04,
     &   2.3087E-04, 2.3086E-04, 2.3086E-04, 2.3086E-04, 2.3085E-04,
     &   2.3085E-04, 2.3085E-04, 2.3085E-04, 2.3084E-04, 2.3084E-04,
     &   2.3083E-04, 2.3083E-04, 2.3083E-04, 2.3082E-04, 2.3082E-04,
     &   2.3081E-04, 2.3081E-04, 2.3080E-04, 2.3080E-04, 2.3079E-04,
     &   2.3079E-04, 2.3078E-04, 2.3078E-04, 2.3077E-04, 2.3076E-04,
     &   2.3075E-04, 2.3074E-04, 2.3074E-04, 2.3073E-04, 2.3071E-04,
     &   2.3070E-04, 2.3069E-04, 2.3068E-04, 2.3066E-04, 2.3064E-04,
     &   2.3062E-04, 2.3060E-04, 2.3057E-04, 2.3054E-04, 2.3051E-04,
     &   2.3047E-04, 2.3042E-04, 2.3036E-04, 2.3029E-04, 2.3020E-04,
     &   2.3008E-04, 2.3006E-04, 2.3005E-04, 2.3004E-04, 2.3002E-04,
     &   2.3000E-04, 2.2999E-04, 2.2997E-04, 2.2996E-04, 2.2994E-04/
  
         DATA ((DGT  (I,J), I= 101, 200), J=3,3) /
     &   2.2992E-04, 2.2990E-04, 2.2988E-04, 2.2986E-04, 2.2984E-04,
     &   2.2982E-04, 2.2980E-04, 2.2978E-04, 2.2976E-04, 2.2973E-04,
     &   2.2971E-04, 2.2968E-04, 2.2966E-04, 2.2963E-04, 2.2960E-04,
     &   2.2957E-04, 2.2954E-04, 2.2951E-04, 2.2947E-04, 2.2944E-04,
     &   2.2940E-04, 2.2937E-04, 2.2933E-04, 2.2929E-04, 2.2924E-04,
     &   2.2920E-04, 2.2915E-04, 2.2910E-04, 2.2905E-04, 2.2900E-04,
     &   2.2894E-04, 2.2889E-04, 2.2883E-04, 2.2876E-04, 2.2869E-04,
     &   2.2862E-04, 2.2855E-04, 2.2847E-04, 2.2839E-04, 2.2830E-04,
     &   2.2821E-04, 2.2811E-04, 2.2801E-04, 2.2790E-04, 2.2778E-04,
     &   2.2765E-04, 2.2752E-04, 2.2738E-04, 2.2723E-04, 2.2707E-04,
     &   2.2690E-04, 2.2672E-04, 2.2652E-04, 2.2631E-04, 2.2608E-04,
     &   2.2584E-04, 2.2557E-04, 2.2528E-04, 2.2497E-04, 2.2463E-04,
     &   2.2426E-04, 2.2386E-04, 2.2342E-04, 2.2293E-04, 2.2240E-04,
     &   2.2181E-04, 2.2116E-04, 2.2043E-04, 2.1963E-04, 2.1873E-04,
     &   2.1772E-04, 2.1658E-04, 2.1529E-04, 2.1382E-04, 2.1214E-04,
     &   2.1021E-04, 2.0798E-04, 2.0538E-04, 2.0233E-04, 1.9871E-04,
     &   1.9436E-04, 1.9393E-04, 1.9349E-04, 1.9304E-04, 1.9258E-04,
     &   1.9212E-04, 1.9165E-04, 1.9117E-04, 1.9068E-04, 1.9018E-04,
     &   1.8967E-04, 1.8915E-04, 1.8862E-04, 1.8808E-04, 1.8754E-04,
     &   1.8698E-04, 1.8641E-04, 1.8583E-04, 1.8524E-04, 1.8464E-04/
  
         DATA ((DGT  (I,J), I= 201, 300), J=3,3) /
     &   1.8402E-04, 1.8339E-04, 1.8275E-04, 1.8210E-04, 1.8144E-04,
     &   1.8076E-04, 1.8006E-04, 1.7936E-04, 1.7864E-04, 1.7790E-04,
     &   1.7715E-04, 1.7638E-04, 1.7560E-04, 1.7479E-04, 1.7398E-04,
     &   1.7314E-04, 1.7229E-04, 1.7142E-04, 1.7053E-04, 1.6962E-04,
     &   1.6869E-04, 1.6774E-04, 1.6677E-04, 1.6577E-04, 1.6476E-04,
     &   1.6372E-04, 1.6266E-04, 1.6158E-04, 1.6047E-04, 1.5934E-04,
     &   1.5818E-04, 1.5699E-04, 1.5578E-04, 1.5454E-04, 1.5328E-04,
     &   1.5198E-04, 1.5065E-04, 1.4930E-04, 1.4791E-04, 1.4649E-04,
     &   1.4505E-04, 1.4356E-04, 1.4205E-04, 1.4050E-04, 1.3891E-04,
     &   1.3729E-04, 1.3563E-04, 1.3393E-04, 1.3220E-04, 1.3042E-04,
     &   1.2860E-04, 1.2675E-04, 1.2485E-04, 1.2290E-04, 1.2091E-04,
     &   1.1887E-04, 1.1679E-04, 1.1465E-04, 1.1246E-04, 1.1021E-04,
     &   1.0791E-04, 1.0555E-04, 1.0312E-04, 1.0063E-04, 9.8064E-05,
     &   9.5425E-05, 9.2706E-05, 8.9902E-05, 8.7008E-05, 8.4018E-05,
     &   8.0924E-05, 7.7722E-05, 7.4403E-05, 7.0962E-05, 6.7392E-05,
     &   6.3687E-05, 5.9842E-05, 5.5855E-05, 5.1722E-05, 4.7446E-05,
     &   4.3031E-05, 4.2582E-05, 4.2132E-05, 4.1681E-05, 4.1229E-05,
     &   4.0775E-05, 4.0320E-05, 3.9863E-05, 3.9406E-05, 3.8947E-05,
     &   3.8488E-05, 3.8027E-05, 3.7565E-05, 3.7102E-05, 3.6638E-05,
     &   3.6172E-05, 3.5706E-05, 3.5239E-05, 3.4771E-05, 3.4302E-05/
  
         DATA ((DGT  (I,J), I= 301, 400), J=3,3) /
     &   3.3832E-05, 3.3361E-05, 3.2890E-05, 3.2417E-05, 3.1944E-05,
     &   3.1470E-05, 3.0995E-05, 3.0520E-05, 3.0044E-05, 2.9568E-05,
     &   2.9091E-05, 2.8613E-05, 2.8135E-05, 2.7657E-05, 2.7179E-05,
     &   2.6700E-05, 2.6221E-05, 2.5742E-05, 2.5263E-05, 2.4783E-05,
     &   2.4304E-05, 2.3825E-05, 2.3347E-05, 2.2868E-05, 2.2390E-05,
     &   2.1912E-05, 2.1435E-05, 2.0959E-05, 2.0483E-05, 2.0008E-05,
     &   1.9534E-05, 1.9061E-05, 1.8589E-05, 1.8118E-05, 1.7649E-05,
     &   1.7182E-05, 1.6715E-05, 1.6251E-05, 1.5789E-05, 1.5329E-05,
     &   1.4870E-05, 1.4415E-05, 1.3962E-05, 1.3511E-05, 1.3064E-05,
     &   1.2619E-05, 1.2178E-05, 1.1740E-05, 1.1306E-05, 1.0875E-05,
     &   1.0449E-05, 1.0027E-05, 9.6099E-06, 9.1973E-06, 8.7897E-06,
     &   8.3874E-06, 7.9906E-06, 7.5996E-06, 7.2147E-06, 6.8361E-06,
     &   6.4643E-06, 6.0993E-06, 5.7417E-06, 5.3916E-06, 5.0494E-06,
     &   4.7154E-06, 4.3900E-06, 4.0735E-06, 3.7662E-06, 3.4685E-06,
     &   3.1806E-06, 2.9031E-06, 2.6362E-06, 2.3802E-06, 2.1356E-06,
     &   1.9026E-06, 1.6816E-06, 1.4729E-06, 1.2768E-06, 1.0938E-06,
     &   9.2397E-07, 9.0773E-07, 8.9162E-07, 8.7566E-07, 8.5982E-07,
     &   8.4413E-07, 8.2857E-07, 8.1315E-07, 7.9787E-07, 7.8272E-07,
     &   7.6772E-07, 7.5285E-07, 7.3812E-07, 7.2352E-07, 7.0907E-07,
     &   6.9476E-07, 6.8058E-07, 6.6655E-07, 6.5266E-07, 6.3890E-07/
  
         DATA ((DGT  (I,J), I= 401, 500), J=3,3) /
     &   6.2529E-07, 6.1182E-07, 5.9849E-07, 5.8530E-07, 5.7225E-07,
     &   5.5934E-07, 5.4658E-07, 5.3395E-07, 5.2147E-07, 5.0914E-07,
     &   4.9694E-07, 4.8489E-07, 4.7298E-07, 4.6122E-07, 4.4960E-07,
     &   4.3812E-07, 4.2679E-07, 4.1560E-07, 4.0456E-07, 3.9366E-07,
     &   3.8291E-07, 3.7230E-07, 3.6184E-07, 3.5152E-07, 3.4135E-07,
     &   3.3133E-07, 3.2145E-07, 3.1172E-07, 3.0213E-07, 2.9269E-07,
     &   2.8340E-07, 2.7426E-07, 2.6526E-07, 2.5641E-07, 2.4771E-07,
     &   2.3915E-07, 2.3075E-07, 2.2249E-07, 2.1438E-07, 2.0642E-07,
     &   1.9861E-07, 1.9094E-07, 1.8343E-07, 1.7606E-07, 1.6885E-07,
     &   1.6178E-07, 1.5486E-07, 1.4809E-07, 1.4148E-07, 1.3501E-07,
     &   1.2869E-07, 1.2252E-07, 1.1650E-07, 1.1064E-07, 1.0492E-07,
     &   9.9354E-08, 9.3939E-08, 8.8675E-08, 8.3561E-08, 7.8598E-08,
     &   7.3787E-08, 6.9127E-08, 6.4618E-08, 6.0261E-08, 5.6055E-08,
     &   5.2000E-08, 4.8098E-08, 4.4347E-08, 4.0748E-08, 3.7301E-08,
     &   3.4005E-08, 3.0862E-08, 2.7871E-08, 2.5032E-08, 2.2346E-08,
     &   1.9811E-08, 1.7429E-08, 1.5199E-08, 1.3122E-08, 1.1197E-08,
     &   9.4249E-09, 9.2560E-09, 9.0887E-09, 8.9229E-09, 8.7586E-09,
     &   8.5959E-09, 8.4347E-09, 8.2750E-09, 8.1168E-09, 7.9601E-09,
     &   7.8050E-09, 7.6514E-09, 7.4994E-09, 7.3488E-09, 7.1998E-09,
     &   7.0523E-09, 6.9063E-09, 6.7619E-09, 6.6190E-09, 6.4776E-09/
  
         DATA ((DGT  (I,J), I= 501, 600), J=3,3) /
     &   6.3377E-09, 6.1994E-09, 6.0626E-09, 5.9273E-09, 5.7935E-09,
     &   5.6613E-09, 5.5306E-09, 5.4014E-09, 5.2737E-09, 5.1476E-09,
     &   5.0230E-09, 4.8999E-09, 4.7784E-09, 4.6583E-09, 4.5398E-09,
     &   4.4229E-09, 4.3074E-09, 4.1935E-09, 4.0811E-09, 3.9702E-09,
     &   3.8609E-09, 3.7531E-09, 3.6468E-09, 3.5420E-09, 3.4388E-09,
     &   3.3371E-09, 3.2369E-09, 3.1382E-09, 3.0411E-09, 2.9455E-09,
     &   2.8514E-09, 2.7589E-09, 2.6679E-09, 2.5784E-09, 2.4904E-09,
     &   2.4039E-09, 2.3190E-09, 2.2356E-09, 2.1538E-09, 2.0734E-09,
     &   1.9946E-09, 1.9173E-09, 1.8416E-09, 1.7674E-09, 1.6947E-09,
     &   1.6235E-09, 1.5538E-09, 1.4857E-09, 1.4191E-09, 1.3540E-09,
     &   1.2905E-09, 1.2285E-09, 1.1680E-09, 1.1090E-09, 1.0516E-09,
     &   9.9569E-10, 9.4131E-10, 8.8845E-10, 8.3712E-10, 7.8732E-10,
     &   7.3905E-10, 6.9230E-10, 6.4709E-10, 6.0339E-10, 5.6123E-10,
     &   5.2059E-10, 4.8148E-10, 4.4390E-10, 4.0784E-10, 3.7331E-10,
     &   3.4031E-10, 3.0883E-10, 2.7888E-10, 2.5046E-10, 2.2357E-10,
     &   1.9820E-10, 1.7436E-10, 1.5204E-10, 1.3126E-10, 1.1200E-10,
     &   9.4268E-11, 9.2579E-11, 9.0905E-11, 8.9246E-11, 8.7603E-11,
     &   8.5975E-11, 8.4362E-11, 8.2764E-11, 8.1182E-11, 7.9615E-11,
     &   7.8063E-11, 7.6527E-11, 7.5006E-11, 7.3500E-11, 7.2009E-11,
     &   7.0534E-11, 6.9074E-11, 6.7629E-11, 6.6199E-11, 6.4785E-11/
  
         DATA ((DGT  (I,J), I= 601, 700), J=3,3) /
     &   6.3386E-11, 6.2002E-11, 6.0634E-11, 5.9280E-11, 5.7942E-11,
     &   5.6620E-11, 5.5312E-11, 5.4020E-11, 5.2743E-11, 5.1482E-11,
     &   5.0235E-11, 4.9004E-11, 4.7789E-11, 4.6588E-11, 4.5403E-11,
     &   4.4233E-11, 4.3078E-11, 4.1939E-11, 4.0815E-11, 3.9706E-11,
     &   3.8612E-11, 3.7534E-11, 3.6471E-11, 3.5423E-11, 3.4391E-11,
     &   3.3373E-11, 3.2371E-11, 3.1385E-11, 3.0413E-11, 2.9457E-11,
     &   2.8516E-11, 2.7591E-11, 2.6680E-11, 2.5785E-11, 2.4905E-11,
     &   2.4041E-11, 2.3191E-11, 2.2357E-11, 2.1539E-11, 2.0735E-11,
     &   1.9947E-11, 1.9174E-11, 1.8417E-11, 1.7674E-11, 1.6947E-11,
     &   1.6235E-11, 1.5539E-11, 1.4858E-11, 1.4192E-11, 1.3541E-11,
     &   1.2905E-11, 1.2285E-11, 1.1680E-11, 1.1091E-11, 1.0516E-11,
     &   9.9571E-12, 9.4132E-12, 8.8847E-12, 8.3714E-12, 7.8734E-12,
     &   7.3906E-12, 6.9232E-12, 6.4709E-12, 6.0340E-12, 5.6124E-12,
     &   5.2060E-12, 4.8148E-12, 4.4390E-12, 4.0784E-12, 3.7331E-12,
     &   3.4031E-12, 3.0883E-12, 2.7888E-12, 2.5046E-12, 2.2357E-12,
     &   1.9820E-12, 1.7436E-12, 1.5205E-12, 1.3126E-12, 1.1200E-12,
     &   9.4268E-13, 9.2579E-13, 9.0905E-13, 8.9246E-13, 8.7603E-13,
     &   8.5975E-13, 8.4362E-13, 8.2765E-13, 8.1182E-13, 7.9615E-13,
     &   7.8064E-13, 7.6527E-13, 7.5006E-13, 7.3500E-13, 7.2009E-13,
     &   7.0534E-13, 6.9074E-13, 6.7629E-13, 6.6199E-13, 6.4785E-13/
  
         DATA ((DGT  (I,J), I= 701, 800), J=3,3) /
     &   6.3386E-13, 6.2002E-13, 6.0634E-13, 5.9280E-13, 5.7943E-13,
     &   5.6620E-13, 5.5312E-13, 5.4020E-13, 5.2743E-13, 5.1482E-13,
     &   5.0236E-13, 4.9004E-13, 4.7789E-13, 4.6588E-13, 4.5403E-13,
     &   4.4233E-13, 4.3078E-13, 4.1939E-13, 4.0815E-13, 3.9706E-13,
     &   3.8612E-13, 3.7534E-13, 3.6471E-13, 3.5423E-13, 3.4391E-13,
     &   3.3373E-13, 3.2371E-13, 3.1385E-13, 3.0413E-13, 2.9457E-13,
     &   2.8516E-13, 2.7591E-13, 2.6680E-13, 2.5785E-13, 2.4905E-13,
     &   2.4041E-13, 2.3191E-13, 2.2358E-13, 2.1539E-13, 2.0735E-13,
     &   1.9947E-13, 1.9174E-13, 1.8417E-13, 1.7674E-13, 1.6947E-13,
     &   1.6235E-13, 1.5539E-13, 1.4858E-13, 1.4192E-13, 1.3541E-13,
     &   1.2905E-13, 1.2285E-13, 1.1680E-13, 1.1091E-13, 1.0516E-13,
     &   9.9571E-14, 9.4132E-14, 8.8847E-14, 8.3714E-14, 7.8734E-14,
     &   7.3906E-14, 6.9232E-14, 6.4709E-14, 6.0340E-14, 5.6124E-14,
     &   5.2060E-14, 4.8148E-14, 4.4390E-14, 4.0784E-14, 3.7331E-14,
     &   3.4031E-14, 3.0883E-14, 2.7888E-14, 2.5046E-14, 2.2357E-14,
     &   1.9820E-14, 1.7436E-14, 1.5205E-14, 1.3126E-14, 1.1200E-14,
     &   9.4268E-15, 9.2579E-15, 9.0905E-15, 8.9246E-15, 8.7603E-15,
     &   8.5975E-15, 8.4362E-15, 8.2765E-15, 8.1182E-15, 7.9615E-15,
     &   7.8064E-15, 7.6527E-15, 7.5006E-15, 7.3500E-15, 7.2009E-15,
     &   7.0534E-15, 6.9074E-15, 6.7629E-15, 6.6199E-15, 6.4785E-15/
  
         DATA ((DGT  (I,J), I= 801, 900), J=3,3) /
     &   6.3386E-15, 6.2002E-15, 6.0634E-15, 5.9280E-15, 5.7943E-15,
     &   5.6620E-15, 5.5312E-15, 5.4020E-15, 5.2743E-15, 5.1482E-15,
     &   5.0236E-15, 4.9004E-15, 4.7789E-15, 4.6588E-15, 4.5403E-15,
     &   4.4233E-15, 4.3078E-15, 4.1939E-15, 4.0815E-15, 3.9706E-15,
     &   3.8612E-15, 3.7534E-15, 3.6471E-15, 3.5423E-15, 3.4391E-15,
     &   3.3373E-15, 3.2371E-15, 3.1385E-15, 3.0413E-15, 2.9457E-15,
     &   2.8516E-15, 2.7591E-15, 2.6680E-15, 2.5785E-15, 2.4905E-15,
     &   2.4041E-15, 2.3191E-15, 2.2357E-15, 2.1539E-15, 2.0735E-15,
     &   1.9947E-15, 1.9174E-15, 1.8417E-15, 1.7674E-15, 1.6947E-15,
     &   1.6235E-15, 1.5539E-15, 1.4858E-15, 1.4192E-15, 1.3541E-15,
     &   1.2905E-15, 1.2285E-15, 1.1680E-15, 1.1091E-15, 1.0516E-15,
     &   9.9571E-16, 9.4132E-16, 8.8847E-16, 8.3714E-16, 7.8734E-16,
     &   7.3906E-16, 6.9232E-16, 6.4709E-16, 6.0340E-16, 5.6124E-16,
     &   5.2060E-16, 4.8148E-16, 4.4390E-16, 4.0784E-16, 3.7331E-16,
     &   3.4031E-16, 3.0883E-16, 2.7888E-16, 2.5046E-16, 2.2357E-16,
     &   1.9820E-16, 1.7436E-16, 1.5205E-16, 1.3126E-16, 1.1200E-16,
     &   9.4268E-17, 0.0000E+00, 9.4268E-17, 8.4900E-10, 3.3950E-09,
     &   7.6387E-09, 1.3579E-08, 2.1220E-08, 3.0563E-08, 4.1610E-08,
     &   5.4363E-08, 6.8825E-08, 8.5000E-08, 1.0289E-07, 1.2250E-07,
     &   1.4384E-07, 1.6690E-07, 1.9170E-07, 2.1824E-07, 2.4652E-07/
  
         DATA ((DGT  (I,J), I= 901, 979), J=3,3) /
     &   2.7656E-07, 3.0836E-07, 3.4193E-07, 3.7727E-07, 4.1440E-07,
     &   4.5331E-07, 4.9403E-07, 5.3657E-07, 5.8092E-07, 6.2711E-07,
     &   6.7515E-07, 7.2504E-07, 7.7680E-07, 8.3044E-07, 8.8598E-07,
     &   9.4343E-07, 1.0028E-06, 1.0641E-06, 1.1274E-06, 1.1927E-06,
     &   1.2599E-06, 1.3292E-06, 1.4005E-06, 1.4738E-06, 1.5492E-06,
     &   1.6267E-06, 1.7064E-06, 1.7882E-06, 1.8721E-06, 1.9583E-06,
     &   2.0466E-06, 2.1372E-06, 2.2302E-06, 2.3254E-06, 2.4230E-06,
     &   2.5229E-06, 2.6253E-06, 2.7301E-06, 2.8374E-06, 2.9473E-06,
     &   3.0598E-06, 3.1748E-06, 3.2926E-06, 3.4131E-06, 3.5364E-06,
     &   3.6625E-06, 3.7915E-06, 3.9235E-06, 4.0585E-06, 4.1966E-06,
     &   4.3379E-06, 4.4825E-06, 4.6304E-06, 4.7817E-06, 4.9366E-06,
     &   5.0951E-06, 5.2574E-06, 5.4235E-06, 5.5936E-06, 5.7679E-06,
     &   5.9465E-06, 6.1296E-06, 6.3173E-06, 6.5098E-06, 6.7074E-06,
     &   6.9103E-06, 7.1188E-06, 7.3331E-06, 7.5536E-06, 7.7807E-06,
     &   8.0148E-06, 8.2564E-06, 8.5060E-06, 8.5911E-06, 8.7643E-06,
     &   8.82586563E-06, 9.03197622E-06, 9.05929956E-06, 9.12345572E-06/
       save
       RETURN
       END

c      ++++ dalhadthigh23 ++++  

c update 09/25/25 
       subroutine ralhad_spacelike1h25
       IMPLICIT NONE
       INTEGER NC,I,J
       PARAMETER(NC=200)
       REAL XXX(NC),YGG(NC,3),Y3G(NC,3)
       COMMON /DATH25r/XXX,YGG,Y3G
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 22:59:02 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1,-2.0000E+04,-1.0000E+03, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
       DATA  (XXX  (I), I=   1, 100) /
     &  -2.0000E+04,-1.9701E+04,-1.9407E+04,-1.9117E+04,-1.8831E+04,
     &  -1.8550E+04,-1.8273E+04,-1.8000E+04,-1.7731E+04,-1.7466E+04,
     &  -1.7205E+04,-1.6948E+04,-1.6695E+04,-1.6445E+04,-1.6199E+04,
     &  -1.5957E+04,-1.5719E+04,-1.5484E+04,-1.5253E+04,-1.5025E+04,
     &  -1.4800E+04,-1.4579E+04,-1.4361E+04,-1.4147E+04,-1.3935E+04,
     &  -1.3727E+04,-1.3522E+04,-1.3320E+04,-1.3121E+04,-1.2925E+04,
     &  -1.2732E+04,-1.2542E+04,-1.2354E+04,-1.2170E+04,-1.1988E+04,
     &  -1.1809E+04,-1.1632E+04,-1.1459E+04,-1.1287E+04,-1.1119E+04,
     &  -1.0953E+04,-1.0789E+04,-1.0628E+04,-1.0469E+04,-1.0313E+04,
     &  -1.0158E+04,-1.0007E+04,-9.8572E+03,-9.7099E+03,-9.5648E+03,
     &  -9.4219E+03,-9.2811E+03,-9.1424E+03,-9.0058E+03,-8.8713E+03,
     &  -8.7387E+03,-8.6082E+03,-8.4796E+03,-8.3529E+03,-8.2281E+03,
     &  -8.1051E+03,-7.9840E+03,-7.8647E+03,-7.7472E+03,-7.6315E+03,
     &  -7.5174E+03,-7.4051E+03,-7.2945E+03,-7.1855E+03,-7.0781E+03,
     &  -6.9724E+03,-6.8682E+03,-6.7656E+03,-6.6645E+03,-6.5649E+03,
     &  -6.4668E+03,-6.3702E+03,-6.2750E+03,-6.1813E+03,-6.0889E+03,
     &  -5.9980E+03,-5.9083E+03,-5.8201E+03,-5.7331E+03,-5.6474E+03,
     &  -5.5631E+03,-5.4799E+03,-5.3981E+03,-5.3174E+03,-5.2380E+03,
     &  -5.1597E+03,-5.0826E+03,-5.0067E+03,-4.9319E+03,-4.8582E+03,
     &  -4.7856E+03,-4.7141E+03,-4.6437E+03,-4.5743E+03,-4.5059E+03/
  
       DATA  (XXX  (I), I= 101, 200) /
     &  -4.4386E+03,-4.3723E+03,-4.3070E+03,-4.2426E+03,-4.1792E+03,
     &  -4.1168E+03,-4.0553E+03,-3.9947E+03,-3.9350E+03,-3.8762E+03,
     &  -3.8183E+03,-3.7612E+03,-3.7050E+03,-3.6497E+03,-3.5951E+03,
     &  -3.5414E+03,-3.4885E+03,-3.4364E+03,-3.3850E+03,-3.3345E+03,
     &  -3.2847E+03,-3.2356E+03,-3.1872E+03,-3.1396E+03,-3.0927E+03,
     &  -3.0465E+03,-3.0010E+03,-2.9561E+03,-2.9120E+03,-2.8685E+03,
     &  -2.8256E+03,-2.7834E+03,-2.7418E+03,-2.7008E+03,-2.6605E+03,
     &  -2.6207E+03,-2.5816E+03,-2.5430E+03,-2.5050E+03,-2.4676E+03,
     &  -2.4307E+03,-2.3944E+03,-2.3586E+03,-2.3234E+03,-2.2887E+03,
     &  -2.2545E+03,-2.2208E+03,-2.1876E+03,-2.1549E+03,-2.1227E+03,
     &  -2.0910E+03,-2.0598E+03,-2.0290E+03,-1.9987E+03,-1.9688E+03,
     &  -1.9394E+03,-1.9104E+03,-1.8819E+03,-1.8538E+03,-1.8261E+03,
     &  -1.7988E+03,-1.7719E+03,-1.7454E+03,-1.7193E+03,-1.6937E+03,
     &  -1.6683E+03,-1.6434E+03,-1.6189E+03,-1.5947E+03,-1.5709E+03,
     &  -1.5474E+03,-1.5243E+03,-1.5015E+03,-1.4791E+03,-1.4570E+03,
     &  -1.4352E+03,-1.4137E+03,-1.3926E+03,-1.3718E+03,-1.3513E+03,
     &  -1.3311E+03,-1.3112E+03,-1.2916E+03,-1.2723E+03,-1.2533E+03,
     &  -1.2346E+03,-1.2162E+03,-1.1980E+03,-1.1801E+03,-1.1625E+03,
     &  -1.1451E+03,-1.1280E+03,-1.1111E+03,-1.0945E+03,-1.0782E+03,
     &  -1.0621E+03,-1.0462E+03,-1.0306E+03,-1.0152E+03,-1.0000E+03/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=1,1) /
     &   5.7093E-02, 5.7007E-02, 5.6920E-02, 5.6834E-02, 5.6747E-02,
     &   5.6661E-02, 5.6574E-02, 5.6488E-02, 5.6402E-02, 5.6315E-02,
     &   5.6229E-02, 5.6143E-02, 5.6057E-02, 5.5970E-02, 5.5884E-02,
     &   5.5798E-02, 5.5712E-02, 5.5626E-02, 5.5540E-02, 5.5454E-02,
     &   5.5368E-02, 5.5282E-02, 5.5196E-02, 5.5110E-02, 5.5024E-02,
     &   5.4938E-02, 5.4852E-02, 5.4766E-02, 5.4681E-02, 5.4595E-02,
     &   5.4509E-02, 5.4424E-02, 5.4338E-02, 5.4253E-02, 5.4167E-02,
     &   5.4082E-02, 5.3996E-02, 5.3911E-02, 5.3825E-02, 5.3740E-02,
     &   5.3655E-02, 5.3570E-02, 5.3485E-02, 5.3399E-02, 5.3314E-02,
     &   5.3229E-02, 5.3144E-02, 5.3059E-02, 5.2975E-02, 5.2890E-02,
     &   5.2805E-02, 5.2720E-02, 5.2636E-02, 5.2551E-02, 5.2467E-02,
     &   5.2382E-02, 5.2298E-02, 5.2213E-02, 5.2129E-02, 5.2045E-02,
     &   5.1961E-02, 5.1877E-02, 5.1793E-02, 5.1709E-02, 5.1625E-02,
     &   5.1541E-02, 5.1457E-02, 5.1374E-02, 5.1290E-02, 5.1207E-02,
     &   5.1123E-02, 5.1040E-02, 5.0957E-02, 5.0874E-02, 5.0790E-02,
     &   5.0707E-02, 5.0624E-02, 5.0542E-02, 5.0459E-02, 5.0376E-02,
     &   5.0293E-02, 5.0211E-02, 5.0129E-02, 5.0046E-02, 4.9964E-02,
     &   4.9882E-02, 4.9800E-02, 4.9718E-02, 4.9636E-02, 4.9554E-02,
     &   4.9472E-02, 4.9391E-02, 4.9309E-02, 4.9228E-02, 4.9147E-02,
     &   4.9065E-02, 4.8984E-02, 4.8903E-02, 4.8823E-02, 4.8742E-02/
  
         DATA ((YGG  (I,J), I= 101, 200), J=1,1) /
     &   4.8661E-02, 4.8581E-02, 4.8500E-02, 4.8420E-02, 4.8339E-02,
     &   4.8259E-02, 4.8179E-02, 4.8099E-02, 4.8020E-02, 4.7940E-02,
     &   4.7860E-02, 4.7781E-02, 4.7701E-02, 4.7622E-02, 4.7543E-02,
     &   4.7464E-02, 4.7385E-02, 4.7306E-02, 4.7228E-02, 4.7149E-02,
     &   4.7070E-02, 4.6992E-02, 4.6914E-02, 4.6836E-02, 4.6758E-02,
     &   4.6680E-02, 4.6602E-02, 4.6524E-02, 4.6446E-02, 4.6369E-02,
     &   4.6291E-02, 4.6214E-02, 4.6137E-02, 4.6060E-02, 4.5983E-02,
     &   4.5906E-02, 4.5829E-02, 4.5752E-02, 4.5676E-02, 4.5599E-02,
     &   4.5523E-02, 4.5446E-02, 4.5370E-02, 4.5294E-02, 4.5218E-02,
     &   4.5141E-02, 4.5065E-02, 4.4990E-02, 4.4914E-02, 4.4838E-02,
     &   4.4762E-02, 4.4687E-02, 4.4611E-02, 4.4535E-02, 4.4460E-02,
     &   4.4384E-02, 4.4309E-02, 4.4234E-02, 4.4158E-02, 4.4083E-02,
     &   4.4008E-02, 4.3933E-02, 4.3857E-02, 4.3782E-02, 4.3707E-02,
     &   4.3632E-02, 4.3557E-02, 4.3482E-02, 4.3407E-02, 4.3331E-02,
     &   4.3256E-02, 4.3181E-02, 4.3106E-02, 4.3031E-02, 4.2956E-02,
     &   4.2880E-02, 4.2805E-02, 4.2730E-02, 4.2654E-02, 4.2579E-02,
     &   4.2504E-02, 4.2428E-02, 4.2353E-02, 4.2277E-02, 4.2201E-02,
     &   4.2126E-02, 4.2050E-02, 4.1974E-02, 4.1898E-02, 4.1822E-02,
     &   4.1746E-02, 4.1670E-02, 4.1594E-02, 4.1517E-02, 4.1441E-02,
     &   4.1364E-02, 4.1288E-02, 4.1211E-02, 4.1134E-02, 4.1057E-02/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=2,2) /
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05/
  
         DATA ((YGG  (I,J), I= 101, 200), J=2,2) /
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3026E-05,
     &   5.3026E-05, 5.3026E-05, 5.3026E-05, 5.3025E-05, 5.3025E-05/
  
  
         DATA ((YGG  (I,J), I=   1, 100), J=3,3) /
     &   1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04,
     &   1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04, 1.4132E-04,
     &   1.4132E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4131E-04,
     &   1.4131E-04, 1.4131E-04, 1.4131E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04,
     &   1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4130E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04, 1.4129E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04/
  
         DATA ((YGG  (I,J), I= 101, 200), J=3,3) /
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04, 1.4128E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04,
     &   1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4127E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4126E-04,
     &   1.4126E-04, 1.4126E-04, 1.4126E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04, 1.4125E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04,
     &   1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04, 1.4124E-04/

c      ++++ deghadthigh23 ++++  

c update 09/25/25 
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Thu Sep 25 23:16:08 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN: -2, Ismooth: 0, IGS: 0, DSET: WAVE, iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1,-2.0000E+04,-1.0000E+03, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 2,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000
  
  
  
         DATA ((Y3G  (I,J), I=   1, 100), J=1,1) /
     &   1.1695E-01, 1.1677E-01, 1.1659E-01, 1.1641E-01, 1.1624E-01,
     &   1.1606E-01, 1.1588E-01, 1.1570E-01, 1.1552E-01, 1.1535E-01,
     &   1.1517E-01, 1.1499E-01, 1.1481E-01, 1.1463E-01, 1.1446E-01,
     &   1.1428E-01, 1.1410E-01, 1.1392E-01, 1.1375E-01, 1.1357E-01,
     &   1.1339E-01, 1.1321E-01, 1.1304E-01, 1.1286E-01, 1.1268E-01,
     &   1.1251E-01, 1.1233E-01, 1.1215E-01, 1.1198E-01, 1.1180E-01,
     &   1.1162E-01, 1.1145E-01, 1.1127E-01, 1.1109E-01, 1.1092E-01,
     &   1.1074E-01, 1.1056E-01, 1.1039E-01, 1.1021E-01, 1.1004E-01,
     &   1.0986E-01, 1.0968E-01, 1.0951E-01, 1.0933E-01, 1.0916E-01,
     &   1.0898E-01, 1.0881E-01, 1.0863E-01, 1.0846E-01, 1.0828E-01,
     &   1.0811E-01, 1.0793E-01, 1.0776E-01, 1.0759E-01, 1.0741E-01,
     &   1.0724E-01, 1.0706E-01, 1.0689E-01, 1.0672E-01, 1.0654E-01,
     &   1.0637E-01, 1.0620E-01, 1.0602E-01, 1.0585E-01, 1.0568E-01,
     &   1.0550E-01, 1.0533E-01, 1.0516E-01, 1.0499E-01, 1.0481E-01,
     &   1.0464E-01, 1.0447E-01, 1.0430E-01, 1.0413E-01, 1.0396E-01,
     &   1.0378E-01, 1.0361E-01, 1.0344E-01, 1.0327E-01, 1.0310E-01,
     &   1.0293E-01, 1.0276E-01, 1.0259E-01, 1.0242E-01, 1.0225E-01,
     &   1.0208E-01, 1.0191E-01, 1.0174E-01, 1.0158E-01, 1.0141E-01,
     &   1.0124E-01, 1.0107E-01, 1.0090E-01, 1.0073E-01, 1.0057E-01,
     &   1.0040E-01, 1.0023E-01, 1.0007E-01, 9.9899E-02, 9.9732E-02/
  
         DATA ((Y3G  (I,J), I= 101, 200), J=1,1) /
     &   9.9566E-02, 9.9400E-02, 9.9234E-02, 9.9069E-02, 9.8903E-02,
     &   9.8738E-02, 9.8573E-02, 9.8408E-02, 9.8244E-02, 9.8079E-02,
     &   9.7915E-02, 9.7751E-02, 9.7588E-02, 9.7424E-02, 9.7261E-02,
     &   9.7098E-02, 9.6936E-02, 9.6773E-02, 9.6611E-02, 9.6449E-02,
     &   9.6287E-02, 9.6125E-02, 9.5964E-02, 9.5803E-02, 9.5642E-02,
     &   9.5481E-02, 9.5321E-02, 9.5161E-02, 9.5001E-02, 9.4841E-02,
     &   9.4681E-02, 9.4522E-02, 9.4363E-02, 9.4204E-02, 9.4045E-02,
     &   9.3886E-02, 9.3728E-02, 9.3570E-02, 9.3412E-02, 9.3254E-02,
     &   9.3096E-02, 9.2939E-02, 9.2781E-02, 9.2624E-02, 9.2467E-02,
     &   9.2310E-02, 9.2154E-02, 9.1997E-02, 9.1841E-02, 9.1685E-02,
     &   9.1529E-02, 9.1373E-02, 9.1217E-02, 9.1061E-02, 9.0905E-02,
     &   9.0750E-02, 9.0594E-02, 9.0439E-02, 9.0284E-02, 9.0129E-02,
     &   8.9974E-02, 8.9818E-02, 8.9663E-02, 8.9508E-02, 8.9354E-02,
     &   8.9199E-02, 8.9044E-02, 8.8889E-02, 8.8734E-02, 8.8579E-02,
     &   8.8424E-02, 8.8269E-02, 8.8114E-02, 8.7959E-02, 8.7804E-02,
     &   8.7649E-02, 8.7494E-02, 8.7339E-02, 8.7184E-02, 8.7028E-02,
     &   8.6873E-02, 8.6717E-02, 8.6561E-02, 8.6406E-02, 8.6250E-02,
     &   8.6094E-02, 8.5937E-02, 8.5781E-02, 8.5624E-02, 8.5468E-02,
     &   8.5311E-02, 8.5154E-02, 8.4997E-02, 8.4839E-02, 8.4682E-02,
     &   8.4524E-02, 8.4366E-02, 8.4207E-02, 8.4049E-02, 8.3890E-02/
  
  
         DATA ((Y3G  (I,J), I=   1, 100), J=2,2) /
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05,
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05,
     &   8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8186E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05/
  
         DATA ((Y3G  (I,J), I= 101, 200), J=2,2) /
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05,
     &   8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8185E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05,
     &   8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05, 8.8184E-05/
  
  
         DATA ((Y3G  (I,J), I=   1, 100), J=3,3) /
     &   2.3117E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04,
     &   2.3116E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04, 2.3116E-04,
     &   2.3116E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04,
     &   2.3115E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04, 2.3115E-04,
     &   2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04,
     &   2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04, 2.3114E-04,
     &   2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3113E-04,
     &   2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3113E-04, 2.3112E-04,
     &   2.3112E-04, 2.3112E-04, 2.3112E-04, 2.3112E-04, 2.3112E-04,
     &   2.3112E-04, 2.3112E-04, 2.3112E-04, 2.3111E-04, 2.3111E-04,
     &   2.3111E-04, 2.3111E-04, 2.3111E-04, 2.3111E-04, 2.3111E-04,
     &   2.3111E-04, 2.3111E-04, 2.3111E-04, 2.3110E-04, 2.3110E-04,
     &   2.3110E-04, 2.3110E-04, 2.3110E-04, 2.3110E-04, 2.3110E-04,
     &   2.3110E-04, 2.3110E-04, 2.3109E-04, 2.3109E-04, 2.3109E-04,
     &   2.3109E-04, 2.3109E-04, 2.3109E-04, 2.3109E-04, 2.3109E-04,
     &   2.3109E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04,
     &   2.3108E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04, 2.3108E-04,
     &   2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3107E-04,
     &   2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3107E-04, 2.3106E-04,
     &   2.3106E-04, 2.3106E-04, 2.3106E-04, 2.3106E-04, 2.3106E-04/
  
         DATA ((Y3G  (I,J), I= 101, 200), J=3,3) /
     &   2.3106E-04, 2.3106E-04, 2.3106E-04, 2.3105E-04, 2.3105E-04,
     &   2.3105E-04, 2.3105E-04, 2.3105E-04, 2.3105E-04, 2.3105E-04,
     &   2.3105E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04,
     &   2.3104E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04, 2.3104E-04,
     &   2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3103E-04,
     &   2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3103E-04, 2.3102E-04,
     &   2.3102E-04, 2.3102E-04, 2.3102E-04, 2.3102E-04, 2.3102E-04,
     &   2.3102E-04, 2.3102E-04, 2.3101E-04, 2.3101E-04, 2.3101E-04,
     &   2.3101E-04, 2.3101E-04, 2.3101E-04, 2.3101E-04, 2.3101E-04,
     &   2.3101E-04, 2.3100E-04, 2.3100E-04, 2.3100E-04, 2.3100E-04,
     &   2.3100E-04, 2.3100E-04, 2.3100E-04, 2.3100E-04, 2.3099E-04,
     &   2.3099E-04, 2.3099E-04, 2.3099E-04, 2.3099E-04, 2.3099E-04,
     &   2.3099E-04, 2.3099E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04, 2.3098E-04,
     &   2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3097E-04,
     &   2.3097E-04, 2.3097E-04, 2.3097E-04, 2.3096E-04, 2.3096E-04,
     &   2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04, 2.3096E-04,
     &   2.3096E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3095E-04,
     &   2.3095E-04, 2.3095E-04, 2.3095E-04, 2.3094E-04, 2.3094E-04,
     &   2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04, 2.3094E-04/
  
       save
       RETURN
       END

c      ++++ dalhadslow23 ++++  

c update 09/24/25 
       subroutine calhad_timelike25c 
       IMPLICIT NONE
       INTEGER NB,I,J
       PARAMETER(NB=2193)
       REAL ESA(NB)
       COMPLEX *8 CAS(NB,3),CGS(NB,3)
       COMMON /DATS25c/ESA,CAS,CGS
  
c******************************************************************************
c*                                                                            *
c*    --- intRdatx ---                              Wed Sep 24 12:55:38 2025  *
c*                                                                            *
c***************************# FJ@HU Berlin #***********************************
  
c  "Delta alpha"               Update version (19/10/2023) 
  
c ISCAN:  1, Ismooth: 0, IGS: 0, DSET:     , iplot: 0 itestflavorspl: 0
c IKE,Emin,Emax,NP,N,EPSREL:  1, 6.0000E-01, 1.4000E+00, 100, 10, 1.00E-02, 
c ALS(sta)(sys):  0.1184( 0.0007)( 0.0000), MZINP:   91.1876, MTOP:    172.90
c NF,IOR,ICHK: 5,4,2,ISU2: 0,NFL: 5,INAG: 1,inotail: 0, sin2W_ref: 0.23153
c CHPTCUT,EC,ECUT: 0.3180,   5.20,  11.50  sin2W_eff: 0.23153 s2W_ref/eff: 1.000

  
       DATA  (ESA  (I), I=   1, 100) /
     &   0.27914036D0, 0.28500000D0,
     &   0.29100000D0, 0.29700000D0,
     &   0.30300000D0, 0.30900000D0,
     &   0.31500000D0, 0.32600000D0,
     &   0.33100000D0, 0.33600000D0,
     &   0.34100000D0, 0.34600000D0,
     &   0.35200000D0, 0.35600000D0,
     &   0.36100000D0, 0.36600000D0,
     &   0.37100000D0, 0.37600000D0,
     &   0.38000000D0, 0.38500000D0,
     &   0.38900000D0, 0.39400000D0,
     &   0.39800000D0, 0.40300000D0,
     &   0.40700000D0, 0.41100000D0,
     &   0.41600000D0, 0.41871100D0,
     &   0.42000000D0, 0.42400000D0,
     &   0.42800000D0, 0.43200000D0,
     &   0.43600000D0, 0.44000000D0,
     &   0.44400000D0, 0.44800000D0,
     &   0.45200000D0, 0.45600000D0,
     &   0.46000000D0, 0.46400000D0,
     &   0.46700000D0, 0.47100000D0,
     &   0.47500000D0, 0.47800000D0,
     &   0.48200000D0, 0.48600000D0,
     &   0.48900000D0, 0.49300000D0,
     &   0.49600000D0, 0.50000000D0,
     &   0.52000000D0, 0.54000000D0,
     &   0.56600000D0, 0.59200000D0,
     &   0.60000000D0, 0.60200000D0,
     &   0.60800000D0, 0.61600000D0,
     &   0.62400000D0, 0.63200000D0,
     &   0.64000000D0, 0.64300000D0,
     &   0.64800000D0, 0.65600000D0,
     &   0.66300000D0, 0.67100000D0,
     &   0.67800000D0, 0.68600000D0,
     &   0.68800000D0, 0.69300000D0,
     &   0.69600000D0, 0.70000000D0,
     &   0.70700000D0, 0.71400000D0,
     &   0.72100000D0, 0.72800000D0,
     &   0.73500000D0, 0.74200000D0,
     &   0.74800000D0, 0.75000000D0,
     &   0.75500000D0, 0.75744000D0,
     &   0.76007300D0, 0.76207300D0,
     &   0.76507300D0, 0.76851700D0,
     &   0.77060500D0, 0.77205400D0,
     &   0.77314300D0, 0.77400300D0,
     &   0.77470900D0, 0.77530500D0,
     &   0.77582000D0, 0.77627100D0,
     &   0.77667300D0, 0.77726600D0,
     &   0.77746600D0, 0.77766900D0,
     &   0.77795100D0, 0.77821500D0/
       DATA  (ESA  (I), I= 101, 200) /
     &   0.77846300D0, 0.77869800D0,
     &   0.77892200D0, 0.77913700D0,
     &   0.77934400D0, 0.77954500D0,
     &   0.77974200D0, 0.77993500D0,
     &   0.78012700D0, 0.78031800D0,
     &   0.78051000D0, 0.78070600D0,
     &   0.78090800D0, 0.78112100D0,
     &   0.78135100D0, 0.78161200D0,
     &   0.78193600D0, 0.78268000D0,
     &   0.78341500D0, 0.78373400D0,
     &   0.78399100D0, 0.78421700D0,
     &   0.78442600D0, 0.78462500D0,
     &   0.78481700D0, 0.78500500D0,
     &   0.78519100D0, 0.78537800D0,
     &   0.78556600D0, 0.78575600D0,
     &   0.78595100D0, 0.78615100D0,
     &   0.78635800D0, 0.78657300D0,
     &   0.78679800D0, 0.78703400D0,
     &   0.78728400D0, 0.78755000D0,
     &   0.78773500D0, 0.78793500D0,
     &   0.78814300D0, 0.78847900D0,
     &   0.78884800D0, 0.78925800D0,
     &   0.78971900D0, 0.79024600D0,
     &   0.79085900D0, 0.79158800D0,
     &   0.79248000D0, 0.79361500D0,
     &   0.79513900D0, 0.79736300D0,
     &   0.79800000D0, 0.80000000D0,
     &   0.80200000D0, 0.80400000D0,
     &   0.80600000D0, 0.80800000D0,
     &   0.81200000D0, 0.81400000D0,
     &   0.81600000D0, 0.82000000D0,
     &   0.82200000D0, 0.82400000D0,
     &   0.82600000D0, 0.82800000D0,
     &   0.83000000D0, 0.83100000D0,
     &   0.83700000D0, 0.84300000D0,
     &   0.84900000D0, 0.85400000D0,
     &   0.86000000D0, 0.86600000D0,
     &   0.87200000D0, 0.87700000D0,
     &   0.88300000D0, 0.88900000D0,
     &   0.89400000D0, 0.89700000D0,
     &   0.90250000D0, 0.90500000D0,
     &   0.91100000D0, 0.91600000D0,
     &   0.92200000D0, 0.92700000D0,
     &   0.93300000D0, 0.93800000D0,
     &   0.94300000D0, 0.94900000D0,
     &   0.95200000D0, 0.95400000D0,
     &   0.95800000D0, 0.96000000D0,
     &   0.96200000D0, 0.96400000D0,
     &   0.96600000D0, 0.96800000D0,
     &   0.97000000D0, 0.97400000D0/
       DATA  (ESA  (I), I= 201, 300) /
     &   0.97800000D0, 0.98000000D0,
     &   0.98070000D0, 0.98140000D0,
     &   0.98210000D0, 0.98280000D0,
     &   0.98350000D0, 0.98420000D0,
     &   0.98490000D0, 0.98560000D0,
     &   0.98630000D0, 0.98700000D0,
     &   0.98770000D0, 0.98840000D0,
     &   0.98910000D0, 0.98980000D0,
     &   0.99050000D0, 0.99120000D0,
     &   0.99190000D0, 0.99260000D0,
     &   0.99330000D0, 0.99400000D0,
     &   0.99470000D0, 0.99540000D0,
     &   0.99610000D0, 0.99680000D0,
     &   0.99750000D0, 0.99820000D0,
     &   0.99890000D0, 0.99960000D0,
     &   0.99990000D0, 1.00001000D0,
     &   1.00030000D0, 1.00100000D0,
     &   1.00170000D0, 1.00240000D0,
     &   1.00310000D0, 1.00380000D0,
     &   1.00450000D0, 1.00520000D0,
     &   1.00590000D0, 1.00660000D0,
     &   1.00730000D0, 1.00800000D0,
     &   1.00870000D0, 1.00940000D0,
     &   1.01010000D0, 1.01080000D0,
     &   1.01150000D0, 1.01220000D0,
     &   1.01290000D0, 1.01360000D0,
     &   1.01430000D0, 1.01500000D0,
     &   1.01520000D0, 1.01540000D0,
     &   1.01560000D0, 1.01580000D0,
     &   1.01600000D0, 1.01620000D0,
     &   1.01640000D0, 1.01660000D0,
     &   1.01680000D0, 1.01700000D0,
     &   1.01720000D0, 1.01740000D0,
     &   1.01770000D0, 1.01790000D0,
     &   1.01800000D0, 1.01820000D0,
     &   1.01840000D0, 1.01860000D0,
     &   1.01880000D0, 1.01900000D0,
     &   1.01920000D0, 1.01940000D0,
     &   1.01960000D0, 1.01980000D0,
     &   1.02000000D0, 1.02020000D0,
     &   1.02040000D0, 1.02060000D0,
     &   1.02080000D0, 1.02100000D0,
     &   1.02120000D0, 1.02140000D0,
     &   1.02160000D0, 1.02180000D0,
     &   1.02200000D0, 1.02220000D0,
     &   1.02240000D0, 1.02270000D0,
     &   1.02290000D0, 1.02300000D0,
     &   1.02320000D0, 1.02340000D0,
     &   1.02360000D0, 1.02380000D0,
     &   1.02400000D0, 1.02420000D0/
       DATA  (ESA  (I), I= 301, 400) /
     &   1.02440000D0, 1.02460000D0,
     &   1.02480000D0, 1.02500000D0,
     &   1.02570000D0, 1.02640000D0,
     &   1.02710000D0, 1.02780000D0,
     &   1.02850000D0, 1.02920000D0,
     &   1.02990000D0, 1.03060000D0,
     &   1.03130000D0, 1.03200000D0,
     &   1.03270000D0, 1.03340000D0,
     &   1.03410000D0, 1.03480000D0,
     &   1.03550000D0, 1.03620000D0,
     &   1.03690000D0, 1.03760000D0,
     &   1.03830000D0, 1.03900000D0,
     &   1.03970000D0, 1.03999000D0,
     &   1.04001000D0, 1.04040000D0,
     &   1.04110000D0, 1.04180000D0,
     &   1.04250000D0, 1.04320000D0,
     &   1.04390000D0, 1.04460000D0,
     &   1.04530000D0, 1.04600000D0,
     &   1.04670000D0, 1.04740000D0,
     &   1.04810000D0, 1.04880000D0,
     &   1.04950000D0, 1.05020000D0,
     &   1.05090000D0, 1.05160000D0,
     &   1.05230000D0, 1.05300000D0,
     &   1.05370000D0, 1.05440000D0,
     &   1.05510000D0, 1.05580000D0,
     &   1.05650000D0, 1.05720000D0,
     &   1.05790000D0, 1.05860000D0,
     &   1.05930000D0, 1.06000000D0,
     &   1.06200000D0, 1.06700000D0,
     &   1.07700000D0, 1.08700000D0,
     &   1.09700000D0, 1.10700000D0,
     &   1.11700000D0, 1.12700000D0,
     &   1.13700000D0, 1.13800000D0,
     &   1.15200000D0, 1.16300000D0,
     &   1.16700000D0, 1.17700000D0,
     &   1.18700000D0, 1.18800000D0,
     &   1.19700000D0, 1.20700000D0,
     &   1.21200000D0, 1.21700000D0,
     &   1.22700000D0, 1.23700000D0,
     &   1.24700000D0, 1.25700000D0,
     &   1.26300000D0, 1.26700000D0,
     &   1.27700000D0, 1.28700000D0,
     &   1.28800000D0, 1.29700000D0,
     &   1.30700000D0, 1.31200000D0,
     &   1.31700000D0, 1.32700000D0,
     &   1.33700000D0, 1.34700000D0,
     &   1.35000000D0, 1.35700000D0,
     &   1.36200000D0, 1.36700000D0,
     &   1.37700000D0, 1.38700000D0,
     &   1.38800000D0, 1.39500000D0/
       DATA  (ESA  (I), I= 401, 500) /
     &   1.41000000D0, 1.41900000D0,
     &   1.42700000D0, 1.43500000D0,
     &   1.43800000D0, 1.45200000D0,
     &   1.45700000D0, 1.46000000D0,
     &   1.46400000D0, 1.47200000D0,
     &   1.48100000D0, 1.49000000D0,
     &   1.49100000D0, 1.50000000D0,
     &   1.50100000D0, 1.50600000D0,
     &   1.51000000D0, 1.52300000D0,
     &   1.52500000D0, 1.53800000D0,
     &   1.53900000D0, 1.54000000D0,
     &   1.55000000D0, 1.56000000D0,
     &   1.56200000D0, 1.57400000D0,
     &   1.57500000D0, 1.58000000D0,
     &   1.58100000D0, 1.58700000D0,
     &   1.59000000D0, 1.59900000D0,
     &   1.60000000D0, 1.61000000D0,
     &   1.61900000D0, 1.62400000D0,
     &   1.62500000D0, 1.63800000D0,
     &   1.64000000D0, 1.65000000D0,
     &   1.65700000D0, 1.66000000D0,
     &   1.66200000D0, 1.66300000D0,
     &   1.67300000D0, 1.67500000D0,
     &   1.68100000D0, 1.68700000D0,
     &   1.69000000D0, 1.70000000D0,
     &   1.71000000D0, 1.71200000D0,
     &   1.71300000D0, 1.71900000D0,
     &   1.72200000D0, 1.72500000D0,
     &   1.73800000D0, 1.74000000D0,
     &   1.74600000D0, 1.75000000D0,
     &   1.75600000D0, 1.75700000D0,
     &   1.76000000D0, 1.76200000D0,
     &   1.76400000D0, 1.76900000D0,
     &   1.77500000D0, 1.78100000D0,
     &   1.79000000D0, 1.79900000D0,
     &   1.80000000D0, 1.81200000D0,
     &   1.81900000D0, 1.82500000D0,
     &   1.82600000D0, 1.83400000D0,
     &   1.83500000D0, 1.83800000D0,
     &   1.84500000D0, 1.85700000D0,
     &   1.85900000D0, 1.87400000D0,
     &   1.88100000D0, 1.88600000D0,
     &   1.90000000D0, 1.91900000D0,
     &   1.92500000D0, 1.93000000D0,
     &   1.93800000D0, 1.94000000D0,
     &   1.94500000D0, 1.94600000D0,
     &   1.95000000D0, 1.95500000D0,
     &   1.96000000D0, 1.96200000D0,
     &   1.98100000D0, 1.99050000D0,
     &   2.00500000D0, 2.05000000D0/
       DATA  (ESA  (I), I= 501, 600) /
     &   2.10000000D0, 2.15010000D0,
     &   2.22000000D0, 2.23240000D0,
     &   2.26000000D0, 2.30000000D0,
     &   2.40000000D0, 2.45000000D0,
     &   2.50000000D0, 2.55000000D0,
     &   2.60000000D0, 2.65000000D0,
     &   2.70000000D0, 2.75000000D0,
     &   2.80000000D0, 2.85000000D0,
     &   2.90000000D0, 2.91000000D0,
     &   2.92000000D0, 2.93000000D0,
     &   2.94000000D0, 2.95000000D0,
     &   2.96000000D0, 2.97000000D0,
     &   2.97200000D0, 2.97400000D0,
     &   2.97600000D0, 2.97800000D0,
     &   2.98000000D0, 2.98200000D0,
     &   2.98400000D0, 2.98600000D0,
     &   2.98800000D0, 2.99000000D0,
     &   2.99900000D0, 3.00500000D0,
     &   3.00800000D0, 3.01000000D0,
     &   3.01200000D0, 3.01400000D0,
     &   3.01600000D0, 3.01800000D0,
     &   3.02000000D0, 3.02100000D0,
     &   3.02200000D0, 3.02300000D0,
     &   3.02400000D0, 3.02500000D0,
     &   3.02600000D0, 3.02700000D0,
     &   3.02800000D0, 3.02900000D0,
     &   3.03000000D0, 3.03100000D0,
     &   3.03200000D0, 3.03300000D0,
     &   3.03400000D0, 3.03500000D0,
     &   3.03600000D0, 3.03700000D0,
     &   3.03800000D0, 3.03900000D0,
     &   3.04000000D0, 3.04100000D0,
     &   3.04200000D0, 3.04300000D0,
     &   3.04400000D0, 3.04500000D0,
     &   3.04600000D0, 3.04700000D0,
     &   3.04800000D0, 3.04900000D0,
     &   3.05000000D0, 3.05100000D0,
     &   3.05200000D0, 3.05300000D0,
     &   3.05400000D0, 3.05500000D0,
     &   3.05600000D0, 3.05700000D0,
     &   3.05800000D0, 3.05900000D0,
     &   3.06000000D0, 3.06050000D0,
     &   3.06100000D0, 3.06150000D0,
     &   3.06200000D0, 3.06250000D0,
     &   3.06300000D0, 3.06350000D0,
     &   3.06400000D0, 3.06450000D0,
     &   3.06500000D0, 3.06550000D0,
     &   3.06600000D0, 3.06650000D0,
     &   3.06700000D0, 3.06750000D0,
     &   3.06800000D0, 3.06850000D0/
       DATA  (ESA  (I), I= 601, 700) /
     &   3.06900000D0, 3.06950000D0,
     &   3.07000000D0, 3.07050000D0,
     &   3.07100000D0, 3.07150000D0,
     &   3.07200000D0, 3.07250000D0,
     &   3.07300000D0, 3.07350000D0,
     &   3.07400000D0, 3.07450000D0,
     &   3.07500000D0, 3.07550000D0,
     &   3.07600000D0, 3.07650000D0,
     &   3.07700000D0, 3.07750000D0,
     &   3.07800000D0, 3.07850000D0,
     &   3.07900000D0, 3.07970000D0,
     &   3.08000000D0, 3.08050000D0,
     &   3.08100000D0, 3.08150000D0,
     &   3.08200000D0, 3.08250000D0,
     &   3.08300000D0, 3.08350000D0,
     &   3.08400000D0, 3.08450000D0,
     &   3.08500000D0, 3.08550000D0,
     &   3.08587000D0, 3.08688300D0,
     &   3.08789600D0, 3.08890900D0,
     &   3.08992200D0, 3.09093500D0,
     &   3.09194800D0, 3.09296100D0,
     &   3.09397400D0, 3.09498700D0,
     &   3.09600000D0, 3.09605000D0,
     &   3.09610000D0, 3.09615000D0,
     &   3.09620000D0, 3.09625000D0,
     &   3.09630000D0, 3.09635000D0,
     &   3.09640000D0, 3.09645000D0,
     &   3.09650000D0, 3.09655000D0,
     &   3.09660000D0, 3.09665000D0,
     &   3.09665500D0, 3.09673500D0,
     &   3.09677100D0, 3.09679300D0,
     &   3.09680900D0, 3.09682000D0,
     &   3.09682900D0, 3.09683600D0,
     &   3.09684300D0, 3.09684800D0,
     &   3.09685300D0, 3.09685700D0,
     &   3.09686100D0, 3.09686400D0,
     &   3.09686800D0, 3.09687000D0,
     &   3.09687300D0, 3.09687600D0,
     &   3.09687800D0, 3.09688100D0,
     &   3.09688300D0, 3.09688500D0,
     &   3.09688700D0, 3.09688900D0,
     &   3.09689100D0, 3.09689300D0,
     &   3.09689500D0, 3.09689700D0,
     &   3.09689900D0, 3.09690100D0,
     &   3.09690400D0, 3.09690600D0,
     &   3.09690900D0, 3.09691200D0,
     &   3.09692000D0, 3.09692800D0,
     &   3.09693100D0, 3.09693400D0,
     &   3.09693600D0, 3.09693900D0,
     &   3.09694100D0, 3.09694300D0/
       DATA  (ESA  (I), I= 701, 800) /
     &   3.09694500D0, 3.09694700D0,
     &   3.09694900D0, 3.09695100D0,
     &   3.09695300D0, 3.09695500D0,
     &   3.09695700D0, 3.09695900D0,
     &   3.09696200D0, 3.09696400D0,
     &   3.09696700D0, 3.09697000D0,
     &   3.09697200D0, 3.09697600D0,
     &   3.09697900D0, 3.09698300D0,
     &   3.09698700D0, 3.09699200D0,
     &   3.09699700D0, 3.09700400D0,
     &   3.09701100D0, 3.09702000D0,
     &   3.09703100D0, 3.09704700D0,
     &   3.09706900D0, 3.09710500D0,
     &   3.09715000D0, 3.09720000D0,
     &   3.09725000D0, 3.09730000D0,
     &   3.09735000D0, 3.09740000D0,
     &   3.09745000D0, 3.09750000D0,
     &   3.09755000D0, 3.09760000D0,
     &   3.09765000D0, 3.09770000D0,
     &   3.09775000D0, 3.09780000D0,
     &   3.09785000D0, 3.09790000D0,
     &   3.09795000D0, 3.09800000D0,
     &   3.09898700D0, 3.09997400D0,
     &   3.10096100D0, 3.10194800D0,
     &   3.10293500D0, 3.10392200D0,
     &   3.10490900D0, 3.10589600D0,
     &   3.10688300D0, 3.10787000D0,
     &   3.10800000D0, 3.10900000D0,
     &   3.11000000D0, 3.11100000D0,
     &   3.11200000D0, 3.11300000D0,
     &   3.11400000D0, 3.11500000D0,
     &   3.11600000D0, 3.11700000D0,
     &   3.11800000D0, 3.11900000D0,
     &   3.12000000D0, 3.12100000D0,
     &   3.12200000D0, 3.12300000D0,
     &   3.12400000D0, 3.12500000D0,
     &   3.12600000D0, 3.12700000D0,
     &   3.12800000D0, 3.12900000D0,
     &   3.13000000D0, 3.13100000D0,
     &   3.13200000D0, 3.13300000D0,
     &   3.13400000D0, 3.13500000D0,
     &   3.13600000D0, 3.13700000D0,
     &   3.13800000D0, 3.13900000D0,
     &   3.14000000D0, 3.14100000D0,
     &   3.14200000D0, 3.14300000D0,
     &   3.14400000D0, 3.14500000D0,
     &   3.14600000D0, 3.14700000D0,
     &   3.14800000D0, 3.14900000D0,
     &   3.15000000D0, 3.15100000D0,
     &   3.15200000D0, 3.15300000D0/
       DATA  (ESA  (I), I= 801, 900) /
     &   3.15400000D0, 3.15500000D0,
     &   3.15600000D0, 3.15700000D0,
     &   3.15800000D0, 3.15900000D0,
     &   3.16000000D0, 3.16100000D0,
     &   3.16200000D0, 3.16300000D0,
     &   3.16400000D0, 3.16500000D0,
     &   3.16600000D0, 3.16700000D0,
     &   3.16800000D0, 3.16900000D0,
     &   3.17000000D0, 3.17100000D0,
     &   3.17200000D0, 3.17300000D0,
     &   3.17400000D0, 3.17500000D0,
     &   3.17600000D0, 3.17700000D0,
     &   3.17800000D0, 3.17900000D0,
     &   3.18000000D0, 3.18100000D0,
     &   3.18200000D0, 3.18300000D0,
     &   3.18400000D0, 3.18500000D0,
     &   3.18600000D0, 3.18700000D0,
     &   3.18800000D0, 3.18900000D0,
     &   3.19000000D0, 3.19100000D0,
     &   3.19200000D0, 3.19300000D0,
     &   3.19400000D0, 3.19500000D0,
     &   3.19600000D0, 3.19700000D0,
     &   3.19800000D0, 3.19900000D0,
     &   3.19990000D0, 3.20100000D0,
     &   3.20200000D0, 3.20300000D0,
     &   3.20400000D0, 3.20500000D0,
     &   3.20600000D0, 3.20700000D0,
     &   3.20800000D0, 3.20900000D0,
     &   3.21000000D0, 3.25000000D0,
     &   3.30000000D0, 3.37000000D0,
     &   3.40000000D0, 3.45000000D0,
     &   3.50000000D0, 3.52000000D0,
     &   3.54000000D0, 3.54240000D0,
     &   3.55380000D0, 3.56000000D0,
     &   3.56110000D0, 3.57500000D0,
     &   3.59000000D0, 3.59500000D0,
     &   3.60020000D0, 3.60500000D0,
     &   3.61000000D0, 3.61500000D0,
     &   3.62000000D0, 3.62500000D0,
     &   3.63000000D0, 3.63500000D0,
     &   3.64000000D0, 3.64500000D0,
     &   3.65000000D0, 3.65200000D0,
     &   3.65400000D0, 3.65600000D0,
     &   3.65800000D0, 3.66000000D0,
     &   3.66200000D0, 3.66300000D0,
     &   3.66400000D0, 3.66500000D0,
     &   3.66600000D0, 3.66700000D0,
     &   3.66800000D0, 3.66900000D0,
     &   3.67000000D0, 3.67100000D0,
     &   3.67200000D0, 3.67300000D0/
       DATA  (ESA  (I), I= 901,1000) /
     &   3.67400000D0, 3.67496000D0,
     &   3.67551000D0, 3.67606000D0,
     &   3.67661000D0, 3.67716000D0,
     &   3.67771000D0, 3.67826000D0,
     &   3.67881000D0, 3.67936000D0,
     &   3.67991000D0, 3.68046000D0,
     &   3.68101000D0, 3.68156000D0,
     &   3.68211000D0, 3.68266000D0,
     &   3.68321000D0, 3.68376000D0,
     &   3.68431000D0, 3.68486000D0,
     &   3.68527300D0, 3.68541000D0,
     &   3.68552000D0, 3.68569900D0,
     &   3.68574600D0, 3.68578100D0,
     &   3.68580900D0, 3.68583200D0,
     &   3.68585100D0, 3.68586800D0,
     &   3.68588300D0, 3.68589500D0,
     &   3.68590700D0, 3.68591800D0,
     &   3.68592800D0, 3.68593700D0,
     &   3.68594600D0, 3.68595300D0,
     &   3.68596100D0, 3.68596800D0,
     &   3.68597500D0, 3.68598200D0,
     &   3.68598800D0, 3.68599500D0,
     &   3.68600100D0, 3.68600700D0,
     &   3.68601300D0, 3.68602000D0,
     &   3.68602600D0, 3.68603300D0,
     &   3.68603900D0, 3.68604700D0,
     &   3.68605500D0, 3.68606600D0,
     &   3.68607500D0, 3.68608500D0,
     &   3.68609000D0, 3.68609500D0,
     &   3.68610000D0, 3.68611400D0,
     &   3.68612500D0, 3.68613300D0,
     &   3.68614100D0, 3.68614700D0,
     &   3.68615400D0, 3.68616000D0,
     &   3.68616700D0, 3.68617300D0,
     &   3.68617900D0, 3.68618500D0,
     &   3.68619200D0, 3.68619800D0,
     &   3.68620500D0, 3.68621200D0,
     &   3.68621900D0, 3.68622700D0,
     &   3.68623400D0, 3.68624300D0,
     &   3.68625200D0, 3.68626200D0,
     &   3.68627300D0, 3.68628500D0,
     &   3.68629700D0, 3.68631200D0,
     &   3.68632900D0, 3.68634800D0,
     &   3.68637100D0, 3.68639900D0,
     &   3.68643400D0, 3.68648100D0,
     &   3.68654800D0, 3.68651000D0,
     &   3.68660000D0, 3.68667000D0,
     &   3.68672000D0, 3.68685000D0,
     &   3.68690700D0, 3.68706000D0,
     &   3.68761000D0, 3.68816000D0/
       DATA  (ESA  (I), I=1001,1100) /
     &   3.68871000D0, 3.68926000D0,
     &   3.68981000D0, 3.69036000D0,
     &   3.69091000D0, 3.69146000D0,
     &   3.69201000D0, 3.69256000D0,
     &   3.69311000D0, 3.69366000D0,
     &   3.69421000D0, 3.69476000D0,
     &   3.69531000D0, 3.69586000D0,
     &   3.69641000D0, 3.69696000D0,
     &   3.69796000D0, 3.69950000D0,
     &   3.70050000D0, 3.70250000D0,
     &   3.70450000D0, 3.70700000D0,
     &   3.71200000D0, 3.72128100D0,
     &   3.73082800D0, 3.73660200D0,
     &   3.74060200D0, 3.74360300D0,
     &   3.74597300D0, 3.74791700D0,
     &   3.74955600D0, 3.75096800D0,
     &   3.75220600D0, 3.75330900D0,
     &   3.75430100D0, 3.75520500D0,
     &   3.75603600D0, 3.75680500D0,
     &   3.75752300D0, 3.75819800D0,
     &   3.75883700D0, 3.75944400D0,
     &   3.76002600D0, 3.76058600D0,
     &   3.76112800D0, 3.76165500D0,
     &   3.76217200D0, 3.76268100D0,
     &   3.76318700D0, 3.76369200D0,
     &   3.76420200D0, 3.76472200D0,
     &   3.76526100D0, 3.76582800D0,
     &   3.76644200D0, 3.76713800D0,
     &   3.76800500D0, 3.77000000D0,
     &   3.77199500D0, 3.77286200D0,
     &   3.77355800D0, 3.77417200D0,
     &   3.77474000D0, 3.77527800D0,
     &   3.77579800D0, 3.77630800D0,
     &   3.77681400D0, 3.77731900D0,
     &   3.77782800D0, 3.77834500D0,
     &   3.77887200D0, 3.77941400D0,
     &   3.77997400D0, 3.78055600D0,
     &   3.78116300D0, 3.78180200D0,
     &   3.78247700D0, 3.78319500D0,
     &   3.78396400D0, 3.78479500D0,
     &   3.78569900D0, 3.78669100D0,
     &   3.78779400D0, 3.78903200D0,
     &   3.79044400D0, 3.79208300D0,
     &   3.79402700D0, 3.79639700D0,
     &   3.79939800D0, 3.80339800D0,
     &   3.80917200D0, 3.81871900D0,
     &   3.82200000D0, 3.83200000D0,
     &   3.85000000D0, 3.85200000D0,
     &   3.86700000D0, 3.87300000D0,
     &   3.87800000D0, 3.88400000D0/
       DATA  (ESA  (I), I=1101,1200) /
     &   3.89000000D0, 3.89600000D0,
     &   3.90000000D0, 3.90200000D0,
     &   3.90800000D0, 3.91400000D0,
     &   3.92000000D0, 3.92600000D0,
     &   3.93200000D0, 3.93800000D0,
     &   3.94400000D0, 3.95000000D0,
     &   3.95600000D0, 3.96200000D0,
     &   3.96800000D0, 3.97400000D0,
     &   3.98000000D0, 3.98600000D0,
     &   3.99200000D0, 3.99800000D0,
     &   4.00000000D0, 4.00400000D0,
     &   4.01000000D0, 4.01600000D0,
     &   4.02000000D0, 4.02200000D0,
     &   4.02800000D0, 4.03000000D0,
     &   4.03400000D0, 4.04000000D0,
     &   4.04600000D0, 4.05000000D0,
     &   4.05200000D0, 4.05800000D0,
     &   4.06400000D0, 4.07000000D0,
     &   4.07600000D0, 4.08200000D0,
     &   4.08800000D0, 4.09000000D0,
     &   4.09400000D0, 4.10000000D0,
     &   4.10500000D0, 4.10900000D0,
     &   4.11000000D0, 4.11300000D0,
     &   4.11800000D0, 4.12100000D0,
     &   4.12500000D0, 4.12900000D0,
     &   4.13000000D0, 4.13300000D0,
     &   4.13600000D0, 4.14100000D0,
     &   4.14700000D0, 4.15000000D0,
     &   4.15300000D0, 4.15900000D0,
     &   4.16500000D0, 4.17100000D0,
     &   4.17700000D0, 4.18000000D0,
     &   4.18200000D0, 4.18500000D0,
     &   4.19000000D0, 4.19500000D0,
     &   4.19900000D0, 4.20100000D0,
     &   4.20800000D0, 4.21200000D0,
     &   4.21400000D0, 4.22000000D0,
     &   4.22600000D0, 4.23200000D0,
     &   4.23800000D0, 4.24000000D0,
     &   4.24400000D0, 4.25000000D0,
     &   4.25600000D0, 4.26200000D0,
     &   4.26800000D0, 4.27400000D0,
     &   4.28000000D0, 4.29200000D0,
     &   4.30000000D0, 4.30400000D0,
     &   4.31000000D0, 4.31600000D0,
     &   4.32800000D0, 4.33000000D0,
     &   4.34000000D0, 4.35000000D0,
     &   4.35200000D0, 4.36400000D0,
     &   4.37600000D0, 4.38000000D0,
     &   4.38200000D0, 4.38800000D0,
     &   4.39000000D0, 4.39400000D0/
       DATA  (ESA  (I), I=1201,1300) /
     &   4.40000000D0, 4.40600000D0,
     &   4.41000000D0, 4.41200000D0,
     &   4.41800000D0, 4.42400000D0,
     &   4.43000000D0, 4.43600000D0,
     &   4.44000000D0, 4.44200000D0,
     &   4.44800000D0, 4.45000000D0,
     &   4.46000000D0, 4.47200000D0,
     &   4.48400000D0, 4.49600000D0,
     &   4.50450000D0, 4.54000000D0,
     &   4.55000000D0, 4.57000000D0,
     &   4.60000000D0, 4.62000000D0,
     &   4.65000000D0, 4.66000000D0,
     &   4.70000000D0, 4.71000000D0,
     &   4.80000000D0, 4.90000000D0,
     &   4.98000000D0, 5.06500000D0,
     &   5.15000000D0, 5.22500000D0,
     &   5.25000000D0, 5.30000000D0,
     &   5.40000000D0, 5.45000000D0,
     &   5.50000000D0, 5.60000000D0,
     &   5.70000000D0, 5.75000000D0,
     &   5.80000000D0, 5.85000000D0,
     &   5.90000000D0, 5.95000000D0,
     &   6.00000000D0, 6.05000000D0,
     &   6.10000000D0, 6.15000000D0,
     &   6.20000000D0, 6.25000000D0,
     &   6.30000000D0, 6.35000000D0,
     &   6.40000000D0, 6.45000000D0,
     &   6.50000000D0, 6.55000000D0,
     &   6.60000000D0, 6.65000000D0,
     &   6.70000000D0, 6.75000000D0,
     &   6.80000000D0, 6.85000000D0,
     &   6.90000000D0, 6.95000000D0,
     &   7.00000000D0, 7.05000000D0,
     &   7.10000000D0, 7.15000000D0,
     &   7.20000000D0, 7.25000000D0,
     &   7.30000000D0, 7.35000000D0,
     &   7.40000000D0, 7.44000000D0,
     &   7.50000000D0, 7.60000000D0,
     &   7.70000000D0, 7.80000000D0,
     &   7.90000000D0, 8.00000000D0,
     &   8.10000000D0, 8.20000000D0,
     &   8.30000000D0, 8.40000000D0,
     &   8.50000000D0, 8.60000000D0,
     &   8.70000000D0, 8.80000000D0,
     &   8.90000000D0, 8.91000000D0,
     &   9.00000000D0, 9.10000000D0,
     &   9.20000000D0, 9.28000000D0,
     &   9.30000000D0, 9.35000000D0,
     &   9.39000000D0, 9.40000000D0,
     &   9.41000000D0, 9.41500000D0/
       DATA  (ESA  (I), I=1301,1400) /
     &   9.42000000D0, 9.42400000D0,
     &   9.42800000D0, 9.43000000D0,
     &   9.43200000D0, 9.43400000D0,
     &   9.43600000D0, 9.43800000D0,
     &   9.44000000D0, 9.44100000D0,
     &   9.44200000D0, 9.44300000D0,
     &   9.44400000D0, 9.44500000D0,
     &   9.44600000D0, 9.44700000D0,
     &   9.44800000D0, 9.44900000D0,
     &   9.44937000D0, 9.44959000D0,
     &   9.44981000D0, 9.45003000D0,
     &   9.45025000D0, 9.45047000D0,
     &   9.45069000D0, 9.45091000D0,
     &   9.45113000D0, 9.45135000D0,
     &   9.45157000D0, 9.45179000D0,
     &   9.45201000D0, 9.45223000D0,
     &   9.45245000D0, 9.45267000D0,
     &   9.45289000D0, 9.45311000D0,
     &   9.45333000D0, 9.45355000D0,
     &   9.45377000D0, 9.45399000D0,
     &   9.45421000D0, 9.45443000D0,
     &   9.45465000D0, 9.45487000D0,
     &   9.45509000D0, 9.45531000D0,
     &   9.45553000D0, 9.45575000D0,
     &   9.45597000D0, 9.45619000D0,
     &   9.45641000D0, 9.45663000D0,
     &   9.45685000D0, 9.45707000D0,
     &   9.45729000D0, 9.45751000D0,
     &   9.45773000D0, 9.45795000D0,
     &   9.45817000D0, 9.45839000D0,
     &   9.45861000D0, 9.45883000D0,
     &   9.45905000D0, 9.45927000D0,
     &   9.45949000D0, 9.45971000D0,
     &   9.45993000D0, 9.46000000D0,
     &   9.46014595D0, 9.46019268D0,
     &   9.46021366D0, 9.46022606D0,
     &   9.46023464D0, 9.46024132D0,
     &   9.46024704D0, 9.46025085D0,
     &   9.46025467D0, 9.46025848D0,
     &   9.46026039D0, 9.46026325D0,
     &   9.46026516D0, 9.46026802D0,
     &   9.46026897D0, 9.46027088D0,
     &   9.46027279D0, 9.46027470D0,
     &   9.46027565D0, 9.46027660D0,
     &   9.46027851D0, 9.46027946D0,
     &   9.46028042D0, 9.46028233D0,
     &   9.46028328D0, 9.46028423D0,
     &   9.46028519D0, 9.46028709D0,
     &   9.46028805D0, 9.46028900D0,
     &   9.46029091D0, 9.46029186D0/
       DATA  (ESA  (I), I=1401,1500) /
     &   9.46029377D0, 9.46029568D0,
     &   9.46030045D0, 9.46030426D0,
     &   9.46030617D0, 9.46030807D0,
     &   9.46030998D0, 9.46031094D0,
     &   9.46031189D0, 9.46031284D0,
     &   9.46031475D0, 9.46031570D0,
     &   9.46031666D0, 9.46031761D0,
     &   9.46031952D0, 9.46032047D0,
     &   9.46032143D0, 9.46032333D0,
     &   9.46032429D0, 9.46032619D0,
     &   9.46032715D0, 9.46032906D0,
     &   9.46033096D0, 9.46033287D0,
     &   9.46033478D0, 9.46033669D0,
     &   9.46033955D0, 9.46034145D0,
     &   9.46034527D0, 9.46034908D0,
     &   9.46035290D0, 9.46035862D0,
     &   9.46036530D0, 9.46037388D0,
     &   9.46038628D0, 9.46040726D0,
     &   9.46045494D0, 9.46059000D0,
     &   9.46081000D0, 9.46103000D0,
     &   9.46125000D0, 9.46147000D0,
     &   9.46169000D0, 9.46191000D0,
     &   9.46213000D0, 9.46235000D0,
     &   9.46257000D0, 9.46279000D0,
     &   9.46301000D0, 9.46323000D0,
     &   9.46345000D0, 9.46367000D0,
     &   9.46389000D0, 9.46411000D0,
     &   9.46433000D0, 9.46455000D0,
     &   9.46477000D0, 9.46499000D0,
     &   9.46521000D0, 9.46543000D0,
     &   9.46565000D0, 9.46587000D0,
     &   9.46609000D0, 9.46631000D0,
     &   9.46653000D0, 9.46675000D0,
     &   9.46697000D0, 9.46719000D0,
     &   9.46741000D0, 9.46763000D0,
     &   9.46785000D0, 9.46807000D0,
     &   9.46829000D0, 9.46851000D0,
     &   9.46873000D0, 9.46895000D0,
     &   9.46917000D0, 9.46939000D0,
     &   9.46961000D0, 9.46983000D0,
     &   9.47005000D0, 9.47027000D0,
     &   9.47049000D0, 9.47071000D0,
     &   9.47093000D0, 9.47115000D0,
     &   9.47137000D0, 9.47337000D0,
     &   9.47500000D0, 9.47700000D0,
     &   9.48000000D0, 9.48400000D0,
     &   9.49000000D0, 9.49500000D0,
     &   9.50500000D0, 9.51000000D0,
     &   9.51500000D0, 9.52000000D0,
     &   9.52500000D0, 9.53000000D0/
       DATA  (ESA  (I), I=1501,1600) /
     &   9.54000000D0, 9.55000000D0,
     &   9.60000000D0, 9.70000000D0,
     &   9.80000000D0, 9.90000000D0,
     &   9.95000000D0, 9.97500000D0,
     &   9.99000000D0,10.00000000D0,
     &  10.01000000D0,10.01100000D0,
     &  10.01200000D0,10.01226000D0,
     &  10.01281000D0,10.01336000D0,
     &  10.01391000D0,10.01446000D0,
     &  10.01501000D0,10.01556000D0,
     &  10.01611000D0,10.01666000D0,
     &  10.01721000D0,10.01776000D0,
     &  10.01831000D0,10.01886000D0,
     &  10.01941000D0,10.01996000D0,
     &  10.02051000D0,10.02106000D0,
     &  10.02161000D0,10.02216000D0,
     &  10.02250000D0,10.02253750D0,
     &  10.02257500D0,10.02261250D0,
     &  10.02265000D0,10.02268750D0,
     &  10.02272500D0,10.02276250D0,
     &  10.02280000D0,10.02283750D0,
     &  10.02287500D0,10.02291250D0,
     &  10.02295000D0,10.02298750D0,
     &  10.02302500D0,10.02306250D0,
     &  10.02310000D0,10.02313750D0,
     &  10.02317500D0,10.02321250D0,
     &  10.02322000D0,10.02322500D0,
     &  10.02323000D0,10.02323400D0,
     &  10.02323700D0,10.02324000D0,
     &  10.02324200D0,10.02324400D0,
     &  10.02324600D0,10.02324800D0,
     &  10.02324930D0,10.02324950D0,
     &  10.02324960D0,10.02324980D0,
     &  10.02324988D0,10.02324994D0,
     &  10.02325000D0,10.02325060D0,
     &  10.02325150D0,10.02325250D0,
     &  10.02325340D0,10.02325440D0,
     &  10.02325540D0,10.02325630D0,
     &  10.02325680D0,10.02325730D0,
     &  10.02325780D0,10.02325850D0,
     &  10.02325900D0,10.02325950D0,
     &  10.02325980D0,10.02325990D0,
     &  10.02325995D0,10.02326000D0,
     &  10.02326005D0,10.02326010D0,
     &  10.02326050D0,10.02326100D0,
     &  10.02326150D0,10.02326390D0,
     &  10.02326490D0,10.02326680D0,
     &  10.02326770D0,10.02326870D0,
     &  10.02326970D0,10.02327060D0,
     &  10.02327160D0,10.02327250D0/
       DATA  (ESA  (I), I=1601,1700) /
     &  10.02327350D0,10.02327440D0,
     &  10.02327540D0,10.02327630D0,
     &  10.02327730D0,10.02327820D0,
     &  10.02328010D0,10.02328110D0,
     &  10.02328210D0,10.02328300D0,
     &  10.02328490D0,10.02328590D0,
     &  10.02328750D0,10.02329000D0,
     &  10.02330000D0,10.02331000D0,
     &  10.02332000D0,10.02333000D0,
     &  10.02334000D0,10.02335000D0,
     &  10.02336250D0,10.02339000D0,
     &  10.02340000D0,10.02341000D0,
     &  10.02342000D0,10.02343750D0,
     &  10.02347500D0,10.02351250D0,
     &  10.02355000D0,10.02358750D0,
     &  10.02362500D0,10.02366250D0,
     &  10.02370000D0,10.02373750D0,
     &  10.02377500D0,10.02381250D0,
     &  10.02385000D0,10.02388750D0,
     &  10.02392500D0,10.02396250D0,
     &  10.02400000D0,10.02436000D0,
     &  10.02491000D0,10.02546000D0,
     &  10.02656000D0,10.02766000D0,
     &  10.02876000D0,10.02986000D0,
     &  10.03096000D0,10.03206000D0,
     &  10.03316000D0,10.03426000D0,
     &  10.03500000D0,10.03600000D0,
     &  10.03700000D0,10.03800000D0,
     &  10.03900000D0,10.04000000D0,
     &  10.04500000D0,10.05000000D0,
     &  10.05500000D0,10.06000000D0,
     &  10.06500000D0,10.07000000D0,
     &  10.07500000D0,10.08000000D0,
     &  10.20000000D0,10.25000000D0,
     &  10.26000000D0,10.27000000D0,
     &  10.28000000D0,10.29000000D0,
     &  10.29500000D0,10.30000000D0,
     &  10.31000000D0,10.32000000D0,
     &  10.33000000D0,10.34000000D0,
     &  10.34420000D0,10.34493333D0,
     &  10.34566667D0,10.34640000D0,
     &  10.34713333D0,10.34786667D0,
     &  10.34860000D0,10.34933333D0,
     &  10.35006667D0,10.35080000D0,
     &  10.35153333D0,10.35226667D0,
     &  10.35300000D0,10.35309167D0,
     &  10.35318333D0,10.35327500D0,
     &  10.35336667D0,10.35345833D0,
     &  10.35355000D0,10.35364167D0,
     &  10.35373333D0,10.35382500D0/
       DATA  (ESA  (I), I=1701,1800) /
     &  10.35391667D0,10.35400833D0,
     &  10.35410000D0,10.35419167D0,
     &  10.35428333D0,10.35437500D0,
     &  10.35440000D0,10.35446667D0,
     &  10.35455833D0,10.35465000D0,
     &  10.35474167D0,10.35483334D0,
     &  10.35492500D0,10.35501667D0,
     &  10.35510834D0,10.35512330D0,
     &  10.35514660D0,10.35515710D0,
     &  10.35516340D0,10.35516780D0,
     &  10.35517110D0,10.35517370D0,
     &  10.35517580D0,10.35517760D0,
     &  10.35517920D0,10.35518060D0,
     &  10.35518180D0,10.35518290D0,
     &  10.35518390D0,10.35518480D0,
     &  10.35518570D0,10.35518650D0,
     &  10.35518720D0,10.35518790D0,
     &  10.35518860D0,10.35518930D0,
     &  10.35518990D0,10.35519050D0,
     &  10.35519110D0,10.35519170D0,
     &  10.35519230D0,10.35519280D0,
     &  10.35519340D0,10.35519400D0,
     &  10.35519460D0,10.35519530D0,
     &  10.35519600D0,10.35519680D0,
     &  10.35519770D0,10.35519970D0,
     &  10.35520000D0,10.35520100D0,
     &  10.35520230D0,10.35520320D0,
     &  10.35520400D0,10.35520470D0,
     &  10.35520540D0,10.35520600D0,
     &  10.35520660D0,10.35520720D0,
     &  10.35520770D0,10.35520830D0,
     &  10.35520890D0,10.35520950D0,
     &  10.35521010D0,10.35521070D0,
     &  10.35521140D0,10.35521210D0,
     &  10.35521280D0,10.35521350D0,
     &  10.35521430D0,10.35521520D0,
     &  10.35521610D0,10.35521710D0,
     &  10.35521820D0,10.35521940D0,
     &  10.35522080D0,10.35522240D0,
     &  10.35522420D0,10.35522630D0,
     &  10.35522890D0,10.35523220D0,
     &  10.35523660D0,10.35524290D0,
     &  10.35525340D0,10.35527670D0,
     &  10.35529000D0,10.35529300D0,
     &  10.35529700D0,10.35531000D0,
     &  10.35532500D0,10.35538334D0,
     &  10.35547500D0,10.35556667D0,
     &  10.35565834D0,10.35575000D0,
     &  10.35584167D0,10.35593334D0,
     &  10.35602500D0,10.35611667D0/
       DATA  (ESA  (I), I=1801,1900) /
     &  10.35620834D0,10.35630000D0,
     &  10.35639167D0,10.35648334D0,
     &  10.35657500D0,10.35666667D0,
     &  10.35740000D0,10.35813333D0,
     &  10.35886667D0,10.35960000D0,
     &  10.36033333D0,10.36106667D0,
     &  10.36180000D0,10.36326667D0,
     &  10.36473333D0,10.36546667D0,
     &  10.36620000D0,10.37000000D0,
     &  10.37500000D0,10.38000000D0,
     &  10.38500000D0,10.39000000D0,
     &  10.39500000D0,10.40000000D0,
     &  10.40500000D0,10.41000000D0,
     &  10.41500000D0,10.42000000D0,
     &  10.42500000D0,10.43000000D0,
     &  10.43500000D0,10.44000000D0,
     &  10.44500000D0,10.45000000D0,
     &  10.45500000D0,10.46000000D0,
     &  10.46500000D0,10.47000000D0,
     &  10.47300000D0,10.52897000D0,
     &  10.54217000D0,10.54889000D0,
     &  10.55317000D0,10.55622000D0,
     &  10.55855000D0,10.56042000D0,
     &  10.56197000D0,10.56328000D0,
     &  10.56442000D0,10.56543000D0,
     &  10.56633000D0,10.56714000D0,
     &  10.56788000D0,10.56857000D0,
     &  10.56921000D0,10.56980000D0,
     &  10.57036000D0,10.57090000D0,
     &  10.57141000D0,10.57189000D0,
     &  10.57237000D0,10.57282000D0,
     &  10.57327000D0,10.57371000D0,
     &  10.57415000D0,10.57459000D0,
     &  10.57503000D0,10.57547000D0,
     &  10.57594000D0,10.57643000D0,
     &  10.57695000D0,10.57755000D0,
     &  10.57829000D0,10.58000000D0,
     &  10.58171000D0,10.58245000D0,
     &  10.58305000D0,10.58357000D0,
     &  10.58406000D0,10.58453000D0,
     &  10.58497000D0,10.58541000D0,
     &  10.58585000D0,10.58629000D0,
     &  10.58673000D0,10.58718000D0,
     &  10.58763000D0,10.58811000D0,
     &  10.58859000D0,10.58910000D0,
     &  10.58964000D0,10.59020000D0,
     &  10.59079000D0,10.59143000D0,
     &  10.59212000D0,10.59286000D0,
     &  10.59367000D0,10.59457000D0,
     &  10.59558000D0,10.59671000D0/
       DATA  (ESA  (I), I=1901,2000) /
     &  10.59803000D0,10.59958000D0,
     &  10.60145000D0,10.60378000D0,
     &  10.60683000D0,10.61111000D0,
     &  10.61783000D0,10.63103000D0,
     &  10.68700000D0,10.69000000D0,
     &  10.71309000D0,10.72975000D0,
     &  10.74256000D0,10.75286000D0,
     &  10.76141000D0,10.76869000D0,
     &  10.77500000D0,10.78057000D0,
     &  10.78554000D0,10.79004000D0,
     &  10.79414000D0,10.79791000D0,
     &  10.80141000D0,10.80468000D0,
     &  10.80775000D0,10.81065000D0,
     &  10.81341000D0,10.81604000D0,
     &  10.81858000D0,10.82102000D0,
     &  10.82339000D0,10.82570000D0,
     &  10.82796000D0,10.83019000D0,
     &  10.83240000D0,10.83460000D0,
     &  10.83681000D0,10.83906000D0,
     &  10.84135000D0,10.84374000D0,
     &  10.84626000D0,10.84900000D0,
     &  10.85212000D0,10.85601000D0,
     &  10.86500000D0,10.87288000D0,
     &  10.87627000D0,10.87895000D0,
     &  10.88128000D0,10.88340000D0,
     &  10.88539000D0,10.88728000D0,
     &  10.88910000D0,10.89088000D0,
     &  10.89262000D0,10.89434000D0,
     &  10.89605000D0,10.89775000D0,
     &  10.89946000D0,10.90119000D0,
     &  10.90292000D0,10.90468000D0,
     &  10.90648000D0,10.90830000D0,
     &  10.91017000D0,10.91208000D0,
     &  10.91406000D0,10.91609000D0,
     &  10.91820000D0,10.92038000D0,
     &  10.92266000D0,10.92504000D0,
     &  10.92754000D0,10.93017000D0,
     &  10.93295000D0,10.93590000D0,
     &  10.93905000D0,10.94242000D0,
     &  10.94606000D0,10.95000000D0,
     &  10.97500000D0,10.97638000D0,
     &  10.97771000D0,10.97900000D0,
     &  10.98025000D0,10.98146000D0,
     &  10.98263000D0,10.98377000D0,
     &  10.98489000D0,10.98598000D0,
     &  10.98705000D0,10.98810000D0,
     &  10.98913000D0,10.99014000D0,
     &  10.99114000D0,10.99213000D0,
     &  10.99310000D0,10.99407000D0,
     &  10.99504000D0,10.99600000D0/
       DATA  (ESA  (I), I=2001,2100) /
     &  10.99697000D0,10.99793000D0,
     &  10.99890000D0,10.99988000D0,
     &  11.00087000D0,11.00188000D0,
     &  11.00290000D0,11.00396000D0,
     &  11.00506000D0,11.00621000D0,
     &  11.00742000D0,11.00873000D0,
     &  11.01018000D0,11.01186000D0,
     &  11.01399000D0,11.01900000D0,
     &  11.02401000D0,11.02614000D0,
     &  11.02782000D0,11.02927000D0,
     &  11.03058000D0,11.03179000D0,
     &  11.03294000D0,11.03404000D0,
     &  11.03510000D0,11.03612000D0,
     &  11.03713000D0,11.03812000D0,
     &  11.03910000D0,11.04007000D0,
     &  11.04103000D0,11.04200000D0,
     &  11.04296000D0,11.04392000D0,
     &  11.04490000D0,11.04587000D0,
     &  11.04686000D0,11.04786000D0,
     &  11.04887000D0,11.04990000D0,
     &  11.05095000D0,11.05202000D0,
     &  11.05311000D0,11.05423000D0,
     &  11.05537000D0,11.05654000D0,
     &  11.05775000D0,11.05900000D0,
     &  11.06029000D0,11.06162000D0,
     &  11.06300000D0,11.07000000D0,
     &  11.09200000D0,11.11500000D0,
     &  11.13700000D0,11.16000000D0,
     &  11.18200000D0,11.20500000D0,
     &  11.22700000D0,11.25000000D0,
     &  11.27300000D0,11.29500000D0,
     &  11.31800000D0,11.34000000D0,
     &  11.36300000D0,11.38500000D0,
     &  11.40800000D0,11.43000000D0,
     &  11.45300000D0,11.47500000D0,
     &  11.49800000D0,11.52000000D0,
     &  11.54200000D0,11.56500000D0,
     &  11.58700000D0,11.61000000D0,
     &  11.63200000D0,11.65500000D0,
     &  11.67700000D0,11.70000000D0,
     &  11.72200000D0,11.74500000D0,
     &  11.76700000D0,11.79000000D0,
     &  11.81200000D0,11.83500000D0,
     &  11.85800000D0,11.88000000D0,
     &  11.90300000D0,11.92500000D0,
     &  11.94800000D0,11.97000000D0,
     &  11.99300000D0,12.01500000D0,
     &  12.03800000D0,12.06000000D0,
     &  12.08300000D0,12.10500000D0,
     &  12.12700000D0,12.15000000D0/
       DATA  (ESA  (I), I=2101,2193) /
     &  12.17200000D0,12.19500000D0,
     &  12.21700000D0,12.24000000D0,
     &  12.26200000D0,12.28500000D0,
     &  12.30700000D0,12.33000000D0,
     &  12.35200000D0,12.37500000D0,
     &  12.39800000D0,12.42000000D0,
     &  12.44300000D0,12.46500000D0,
     &  12.48800000D0,12.51000000D0,
     &  12.53300000D0,12.55500000D0,
     &  12.57800000D0,12.60000000D0,
     &  12.62300000D0,12.64500000D0,
     &  12.66700000D0,12.69000000D0,
     &  12.71200000D0,12.73500000D0,
     &  12.75700000D0,12.78000000D0,
     &  12.80200000D0,12.82500000D0,
     &  12.84700000D0,12.87000000D0,
     &  12.89200000D0,12.91500000D0,
     &  12.93800000D0,12.96000000D0,
     &  12.98300000D0,13.00500000D0,
     &  13.02800000D0,13.05000000D0,
     &  13.07300000D0,13.09500000D0,
     &  13.11800000D0,13.14000000D0,
     &  13.16300000D0,13.18500000D0,
     &  13.20800000D0,13.23000000D0,
     &  13.25200000D0,13.27500000D0,
     &  13.29700000D0,13.32000000D0,
     &  13.34200000D0,13.36500000D0,
     &  13.38700000D0,13.41000000D0,
     &  13.43200000D0,13.45500000D0,
     &  13.47700000D0,13.50000000D0,
     &  13.75000000D0,14.00000000D0,
     &  14.04000000D0,16.00000000D0,
     &  17.00000000D0,20.00000000D0,
     &  21.95000000D0,22.05000000D0,
     &  25.00000000D0,25.01000000D0,
     &  27.50000000D0,27.60000000D0,
     &  27.66000000D0,29.00000000D0,
     &  29.93000000D0,30.10000000D0,
     &  30.38000000D0,30.80000000D0,
     &  31.10000000D0,31.29000000D0,
     &  33.20000000D0,33.30000000D0,
     &  33.89000000D0,34.00000000D0,
     &  34.50000000D0,34.70000000D0,
     &  34.86000000D0,35.01000000D0,
     &  35.45000000D0,36.10000000D0,
     &  36.38000000D0,38.29000000D0,
     &  40.00000000D0/
  
         DATA ((CAS  (I,J), I=   1, 100), J=1,1) /
     &  (-9.0192E-04,-0.0000E+00),(-9.5930E-04,-5.3224E-06),
     &  (-1.0203E-03,-1.5273E-05),(-1.0809E-03,-2.8153E-05),
     &  (-1.1442E-03,-4.3420E-05),(-1.2057E-03,-6.0692E-05),
     &  (-1.2577E-03,-7.9766E-05),(-1.3491E-03,-1.3083E-04),
     &  (-1.3922E-03,-1.4890E-04),(-1.4331E-03,-1.6334E-04),
     &  (-1.4889E-03,-1.7976E-04),(-1.5421E-03,-2.0929E-04),
     &  (-1.6057E-03,-2.3614E-04),(-1.6487E-03,-2.5054E-04),
     &  (-1.7002E-03,-2.8216E-04),(-1.7517E-03,-2.9540E-04),
     &  (-1.8041E-03,-3.2629E-04),(-1.8562E-03,-3.4366E-04),
     &  (-1.9009E-03,-3.6900E-04),(-1.9578E-03,-3.9917E-04),
     &  (-2.0043E-03,-4.2330E-04),(-2.0615E-03,-4.3507E-04),
     &  (-2.1067E-03,-4.5764E-04),(-2.1620E-03,-5.0430E-04),
     &  (-2.2122E-03,-5.3246E-04),(-2.2633E-03,-5.4385E-04),
     &  (-2.3223E-03,-5.6462E-04),(-2.3559E-03,-5.7596E-04),
     &  (-2.3700E-03,-5.9522E-04),(-2.4215E-03,-6.0836E-04),
     &  (-2.4752E-03,-6.5141E-04),(-2.5268E-03,-6.7053E-04),
     &  (-2.5803E-03,-6.9359E-04),(-2.6336E-03,-7.2487E-04),
     &  (-2.6901E-03,-7.5309E-04),(-2.7490E-03,-7.8014E-04),
     &  (-2.8091E-03,-7.9483E-04),(-2.8709E-03,-8.1331E-04),
     &  (-2.9336E-03,-8.5063E-04),(-3.0001E-03,-8.8429E-04),
     &  (-3.0506E-03,-9.1022E-04),(-3.1197E-03,-9.4632E-04),
     &  (-3.1858E-03,-9.9439E-04),(-3.2368E-03,-1.0285E-03),
     &  (-3.3053E-03,-1.0686E-03),(-3.3763E-03,-1.1020E-03),
     &  (-3.4293E-03,-1.1294E-03),(-3.5065E-03,-1.1659E-03),
     &  (-3.5679E-03,-1.1716E-03),(-3.6452E-03,-1.2002E-03),
     &  (-4.0935E-03,-1.4375E-03),(-4.5670E-03,-1.7876E-03),
     &  (-5.2658E-03,-2.2497E-03),(-6.1513E-03,-2.8988E-03),
     &  (-6.4568E-03,-3.2145E-03),(-6.5369E-03,-3.2789E-03),
     &  (-6.7753E-03,-3.4743E-03),(-7.0987E-03,-3.8324E-03),
     &  (-7.4371E-03,-4.2430E-03),(-7.7876E-03,-4.7007E-03),
     &  (-8.1329E-03,-5.1391E-03),(-8.2590E-03,-5.3576E-03),
     &  (-8.4799E-03,-5.7391E-03),(-8.8380E-03,-6.3567E-03),
     &  (-9.1361E-03,-6.9548E-03),(-9.4550E-03,-7.7828E-03),
     &  (-9.7075E-03,-8.6135E-03),(-9.9465E-03,-9.6007E-03),
     &  (-9.9726E-03,-9.8365E-03),(-1.0049E-02,-1.0631E-02),
     &  (-1.0089E-02,-1.1191E-02),(-1.0102E-02,-1.1766E-02),
     &  (-1.0002E-02,-1.2890E-02),(-9.7572E-03,-1.4200E-02),
     &  (-9.3757E-03,-1.5489E-02),(-8.7697E-03,-1.6680E-02),
     &  (-7.9759E-03,-1.7998E-02),(-7.0471E-03,-1.9211E-02),
     &  (-6.2010E-03,-2.0086E-02),(-5.9334E-03,-2.0372E-02),
     &  (-5.4617E-03,-2.0863E-02),(-5.6009E-03,-2.1654E-02),
     &  (-5.0170E-03,-2.1999E-02),(-4.8621E-03,-2.2311E-02),
     &  (-4.7708E-03,-2.2857E-02),(-5.1390E-03,-2.3670E-02),
     &  (-5.6217E-03,-2.4672E-02),(-6.0438E-03,-2.5692E-02),
     &  (-6.4669E-03,-2.6612E-02),(-6.7681E-03,-2.7803E-02),
     &  (-6.8746E-03,-2.8774E-02),(-7.0061E-03,-2.9784E-02),
     &  (-7.1198E-03,-3.0828E-02),(-6.9854E-03,-3.1738E-02),
     &  (-7.0899E-03,-3.2552E-02),(-7.2441E-03,-3.3822E-02),
     &  (-6.8990E-03,-3.4293E-02),(-6.5488E-03,-3.4778E-02),
     &  (-6.0623E-03,-3.5449E-02),(-5.8169E-03,-3.6257E-02)/
  
         DATA ((CAS  (I,J), I= 101, 200), J=1,1) /
     &  (-5.5276E-03,-3.7030E-02),(-5.2427E-03,-3.7752E-02),
     &  (-4.9038E-03,-3.8473E-02),(-4.5382E-03,-3.9156E-02),
     &  (-4.1330E-03,-3.9877E-02),(-3.4728E-03,-4.0512E-02),
     &  (-2.8258E-03,-4.1199E-02),(-2.1919E-03,-4.1816E-02),
     &  (-1.5037E-03,-4.2465E-02),(-7.6993E-04,-4.3108E-02),
     &  ( 7.5349E-04,-4.3758E-02),( 1.4330E-03,-4.4397E-02),
     &  ( 2.1332E-03,-4.5080E-02),( 2.8716E-03,-4.5424E-02),
     &  ( 4.5336E-03,-4.5475E-02),( 5.8926E-03,-4.5535E-02),
     &  ( 7.4994E-03,-4.5598E-02),( 1.1756E-02,-4.5769E-02),
     &  ( 1.6194E-02,-4.4008E-02),( 1.7835E-02,-4.2617E-02),
     &  ( 1.8796E-02,-4.1503E-02),( 1.9529E-02,-4.0529E-02),
     &  ( 2.0131E-02,-3.9618E-02),( 2.0618E-02,-3.8752E-02),
     &  ( 2.1067E-02,-3.7906E-02),( 2.1383E-02,-3.7060E-02),
     &  ( 2.1692E-02,-3.6387E-02),( 2.2005E-02,-3.5707E-02),
     &  ( 2.2228E-02,-3.5020E-02),( 2.2443E-02,-3.4319E-02),
     &  ( 2.2567E-02,-3.3583E-02),( 2.2694E-02,-3.2845E-02),
     &  ( 2.2816E-02,-3.2091E-02),( 2.2936E-02,-3.1281E-02),
     &  ( 2.3129E-02,-3.0468E-02),( 2.3135E-02,-2.9614E-02),
     &  ( 2.3024E-02,-2.8948E-02),( 2.3038E-02,-2.8249E-02),
     &  ( 2.2903E-02,-2.7743E-02),( 2.2840E-02,-2.7234E-02),
     &  ( 2.2816E-02,-2.6659E-02),( 2.2673E-02,-2.5774E-02),
     &  ( 2.2350E-02,-2.4792E-02),( 2.2013E-02,-2.3974E-02),
     &  ( 2.1600E-02,-2.3238E-02),( 2.0946E-02,-2.2402E-02),
     &  ( 2.0626E-02,-2.1421E-02),( 2.0045E-02,-2.0623E-02),
     &  ( 1.9462E-02,-1.9749E-02),( 1.8640E-02,-1.8707E-02),
     &  ( 1.7571E-02,-1.7899E-02),( 1.6755E-02,-1.7005E-02),
     &  ( 1.6556E-02,-1.6724E-02),( 1.5962E-02,-1.5938E-02),
     &  ( 1.5368E-02,-1.5544E-02),( 1.5042E-02,-1.5091E-02),
     &  ( 1.4856E-02,-1.4591E-02),( 1.4643E-02,-1.4065E-02),
     &  ( 1.4047E-02,-1.3173E-02),( 1.3877E-02,-1.2825E-02),
     &  ( 1.3657E-02,-1.2475E-02),( 1.3460E-02,-1.1820E-02),
     &  ( 1.3338E-02,-1.1562E-02),( 1.3224E-02,-1.1253E-02),
     &  ( 1.3090E-02,-1.0961E-02),( 1.2988E-02,-1.0694E-02),
     &  ( 1.2844E-02,-1.0378E-02),( 1.2778E-02,-1.0209E-02),
     &  ( 1.2417E-02,-9.3539E-03),( 1.2054E-02,-8.5853E-03),
     &  ( 1.1700E-02,-7.9642E-03),( 1.1392E-02,-7.5137E-03),
     &  ( 1.1034E-02,-6.9882E-03),( 1.0662E-02,-6.4707E-03),
     &  ( 1.0279E-02,-5.9342E-03),( 9.9535E-03,-5.5443E-03),
     &  ( 9.5528E-03,-5.1675E-03),( 9.1489E-03,-4.8524E-03),
     &  ( 8.8138E-03,-4.6267E-03),( 8.6271E-03,-4.5076E-03),
     &  ( 8.2720E-03,-4.2622E-03),( 8.1092E-03,-4.1468E-03),
     &  ( 7.7218E-03,-3.8849E-03),( 7.3947E-03,-3.6760E-03),
     &  ( 6.9857E-03,-3.4897E-03),( 6.6298E-03,-3.3235E-03),
     &  ( 6.1807E-03,-3.1673E-03),( 5.7827E-03,-3.0317E-03),
     &  ( 5.3688E-03,-2.9322E-03),( 4.8378E-03,-2.8029E-03),
     &  ( 4.5567E-03,-2.7552E-03),( 4.3688E-03,-2.7198E-03),
     &  ( 3.9688E-03,-2.6447E-03),( 3.7521E-03,-2.6063E-03),
     &  ( 3.5191E-03,-2.5766E-03),( 3.2726E-03,-2.5623E-03),
     &  ( 3.0101E-03,-2.5648E-03),( 2.7391E-03,-2.5396E-03),
     &  ( 2.4707E-03,-2.5096E-03),( 1.8903E-03,-2.5842E-03)/
  
         DATA ((CAS  (I,J), I= 201, 300), J=1,1) /
     &  ( 1.1993E-03,-2.5114E-03),( 7.9681E-04,-2.4644E-03),
     &  ( 6.4237E-04,-2.4562E-03),( 4.9025E-04,-2.4628E-03),
     &  ( 3.3094E-04,-2.4805E-03),( 1.6348E-04,-2.4982E-03),
     &  (-3.6133E-06,-2.4962E-03),(-1.8242E-04,-2.4862E-03),
     &  (-3.6217E-04,-2.4763E-03),(-5.4503E-04,-2.4996E-03),
     &  (-7.3260E-04,-2.5284E-03),(-9.2795E-04,-2.5572E-03),
     &  (-1.1267E-03,-2.6793E-03),(-1.3323E-03,-2.7065E-03),
     &  (-1.5407E-03,-2.6723E-03),(-1.7570E-03,-2.6963E-03),
     &  (-1.9844E-03,-2.7204E-03),(-2.2195E-03,-2.7410E-03),
     &  (-2.4639E-03,-2.7530E-03),(-2.7154E-03,-2.7650E-03),
     &  (-2.9848E-03,-2.7857E-03),(-3.1932E-03,-2.8180E-03),
     &  (-3.5464E-03,-2.8503E-03),(-3.8904E-03,-2.8781E-03),
     &  (-4.2353E-03,-2.9024E-03),(-4.6046E-03,-2.9268E-03),
     &  (-4.9992E-03,-2.9640E-03),(-5.4255E-03,-3.0085E-03),
     &  (-5.8829E-03,-3.0591E-03),(-6.3740E-03,-3.1096E-03),
     &  (-6.5783E-03,-3.1313E-03),(-6.6574E-03,-3.1664E-03),
     &  (-6.8660E-03,-3.1974E-03),(-7.3992E-03,-3.2723E-03),
     &  (-7.9641E-03,-3.3472E-03),(-8.7126E-03,-3.4223E-03),
     &  (-9.1706E-03,-3.4972E-03),(-1.0170E-02,-3.5687E-03),
     &  (-1.1247E-02,-3.8273E-03),(-1.2058E-02,-4.1400E-03),
     &  (-1.3066E-02,-4.4886E-03),(-1.4057E-02,-4.8371E-03),
     &  (-1.5127E-02,-5.1986E-03),(-1.6476E-02,-5.5767E-03),
     &  (-1.7825E-02,-5.9668E-03),(-1.9556E-02,-6.4505E-03),
     &  (-2.1868E-02,-6.9342E-03),(-2.4438E-02,-8.3393E-03),
     &  (-2.6777E-02,-1.0269E-02),(-2.9208E-02,-1.2199E-02),
     &  (-3.2434E-02,-1.4128E-02),(-3.5906E-02,-1.7637E-02),
     &  (-3.9329E-02,-2.1597E-02),(-4.4006E-02,-2.5681E-02),
     &  (-4.5879E-02,-2.7682E-02),(-4.8034E-02,-2.9682E-02),
     &  (-4.9729E-02,-3.2253E-02),(-5.1375E-02,-3.5300E-02),
     &  (-5.3053E-02,-3.9473E-02),(-5.4812E-02,-4.3646E-02),
     &  (-5.5543E-02,-4.7819E-02),(-5.6173E-02,-5.1991E-02),
     &  (-5.4192E-02,-5.6255E-02),(-5.2982E-02,-6.2248E-02),
     &  (-5.7630E-02,-6.8241E-02),(-5.7221E-02,-7.5154E-02),
     &  (-4.3562E-02,-8.6256E-02),(-4.9899E-02,-9.3614E-02),
     &  (-4.7617E-02,-9.7296E-02),(-4.1644E-02,-1.0430E-01),
     &  (-3.4766E-02,-1.1103E-01),(-2.6734E-02,-1.1735E-01),
     &  (-1.5773E-02,-1.2077E-01),(-5.5965E-03,-1.2350E-01),
     &  ( 5.0725E-03,-1.2443E-01),( 1.6349E-02,-1.2435E-01),
     &  ( 2.7955E-02,-1.2120E-01),( 3.7808E-02,-1.1502E-01),
     &  ( 4.5246E-02,-1.0834E-01),( 5.1133E-02,-1.0166E-01),
     &  ( 5.6358E-02,-9.4978E-02),( 5.9999E-02,-8.7293E-02),
     &  ( 6.2345E-02,-8.0564E-02),( 6.3814E-02,-7.4213E-02),
     &  ( 6.4767E-02,-6.7862E-02),( 6.5063E-02,-6.1511E-02),
     &  ( 6.4233E-02,-5.6488E-02),( 6.3037E-02,-5.2038E-02),
     &  ( 6.2405E-02,-4.7813E-02),( 6.1338E-02,-4.4052E-02),
     &  ( 5.9717E-02,-4.0955E-02),( 5.7143E-02,-3.7237E-02),
     &  ( 5.6139E-02,-3.4759E-02),( 5.5375E-02,-3.3520E-02),
     &  ( 5.3832E-02,-3.1042E-02),( 5.2466E-02,-2.9409E-02),
     &  ( 5.1395E-02,-2.8231E-02),( 5.0034E-02,-2.7053E-02),
     &  ( 4.8826E-02,-2.5875E-02),( 4.7969E-02,-2.4697E-02)/
  
         DATA ((CAS  (I,J), I= 301, 400), J=1,1) /
     &  ( 4.8797E-02,-2.3519E-02),( 4.6535E-02,-2.2341E-02),
     &  ( 4.5723E-02,-2.1163E-02),( 4.4856E-02,-1.9985E-02),
     &  ( 4.2057E-02,-1.7603E-02),( 3.9998E-02,-1.5221E-02),
     &  ( 3.7851E-02,-1.2839E-02),( 3.5457E-02,-1.0824E-02),
     &  ( 3.2977E-02,-9.8843E-03),( 3.1268E-02,-9.3254E-03),
     &  ( 2.9911E-02,-8.7665E-03),( 2.8759E-02,-8.2078E-03),
     &  ( 2.7728E-02,-7.6489E-03),( 2.6800E-02,-7.0899E-03),
     &  ( 2.5901E-02,-6.5313E-03),( 2.4971E-02,-5.9723E-03),
     &  ( 2.4003E-02,-5.5634E-03),( 2.3127E-02,-5.3757E-03),
     &  ( 2.2406E-02,-5.2010E-03),( 2.1780E-02,-5.0311E-03),
     &  ( 2.1209E-02,-4.8614E-03),( 2.0712E-02,-4.6917E-03),
     &  ( 2.0194E-02,-4.5158E-03),( 1.9760E-02,-4.3322E-03),
     &  ( 1.9322E-02,-4.1418E-03),( 1.9194E-02,-4.0412E-03),
     &  ( 1.9403E-02,-4.0313E-03),( 1.8945E-02,-3.9960E-03),
     &  ( 1.8376E-02,-3.9325E-03),( 1.7940E-02,-3.8691E-03),
     &  ( 1.7571E-02,-3.8056E-03),( 1.7240E-02,-3.7421E-03),
     &  ( 1.6935E-02,-3.6787E-03),( 1.6632E-02,-3.6152E-03),
     &  ( 1.6353E-02,-3.5497E-03),( 1.6098E-02,-3.4816E-03),
     &  ( 1.5834E-02,-3.4134E-03),( 1.5603E-02,-3.3453E-03),
     &  ( 1.5377E-02,-3.2771E-03),( 1.5125E-02,-3.2089E-03),
     &  ( 1.4949E-02,-3.1408E-03),( 1.4755E-02,-3.0615E-03),
     &  ( 1.4546E-02,-3.0326E-03),( 1.4368E-02,-3.0036E-03),
     &  ( 1.4191E-02,-2.9746E-03),( 1.4021E-02,-2.9456E-03),
     &  ( 1.3861E-02,-2.9166E-03),( 1.3717E-02,-2.8877E-03),
     &  ( 1.3525E-02,-2.8592E-03),( 1.3382E-02,-2.8338E-03),
     &  ( 1.3250E-02,-2.8085E-03),( 1.3109E-02,-2.7831E-03),
     &  ( 1.2927E-02,-2.7577E-03),( 1.2838E-02,-2.7323E-03),
     &  ( 1.2711E-02,-2.7070E-03),( 1.2585E-02,-2.6721E-03),
     &  ( 1.2236E-02,-2.5598E-03),( 1.1474E-02,-2.4546E-03),
     &  ( 1.0278E-02,-2.3120E-03),( 9.3960E-03,-2.2671E-03),
     &  ( 8.7137E-03,-2.2204E-03),( 8.1669E-03,-2.1569E-03),
     &  ( 7.6996E-03,-2.1306E-03),( 7.2943E-03,-2.1028E-03),
     &  ( 6.9423E-03,-2.1302E-03),( 6.9097E-03,-2.1350E-03),
     &  ( 6.4990E-03,-2.1849E-03),( 6.2162E-03,-2.1916E-03),
     &  ( 6.1187E-03,-2.1903E-03),( 5.8834E-03,-2.2237E-03),
     &  ( 5.6584E-03,-2.2450E-03),( 5.6370E-03,-2.2462E-03),
     &  ( 5.4464E-03,-2.2769E-03),( 5.2488E-03,-2.3408E-03),
     &  ( 5.1544E-03,-2.3769E-03),( 5.0607E-03,-2.3916E-03),
     &  ( 4.8935E-03,-2.4558E-03),( 4.7397E-03,-2.5255E-03),
     &  ( 4.5995E-03,-2.6032E-03),( 4.4715E-03,-2.6466E-03),
     &  ( 4.3967E-03,-2.6878E-03),( 4.3456E-03,-2.7106E-03),
     &  ( 4.2212E-03,-2.7526E-03),( 4.0976E-03,-2.8095E-03),
     &  ( 4.0852E-03,-2.8152E-03),( 3.9853E-03,-2.9227E-03),
     &  ( 3.8912E-03,-3.0256E-03),( 3.8482E-03,-3.0726E-03),
     &  ( 3.8039E-03,-3.0999E-03),( 3.7164E-03,-3.1349E-03),
     &  ( 3.6144E-03,-3.2263E-03),( 3.5130E-03,-3.2975E-03),
     &  ( 3.4895E-03,-3.3327E-03),( 3.4260E-03,-3.4417E-03),
     &  ( 3.3865E-03,-3.5071E-03),( 3.3532E-03,-3.5792E-03),
     &  ( 3.2883E-03,-3.6848E-03),( 3.2205E-03,-3.7471E-03),
     &  ( 3.2133E-03,-3.7528E-03),( 3.1629E-03,-3.8280E-03)/
  
         DATA ((CAS  (I,J), I= 401, 500), J=1,1) /
     &  ( 3.0809E-03,-4.0732E-03),( 3.0720E-03,-4.2276E-03),
     &  ( 3.1056E-03,-4.3565E-03),( 3.0760E-03,-4.4392E-03),
     &  ( 3.0649E-03,-4.4708E-03),( 3.1486E-03,-4.6290E-03),
     &  ( 3.1602E-03,-4.6825E-03),( 3.1689E-03,-4.7165E-03),
     &  ( 3.1821E-03,-4.7627E-03),( 3.2136E-03,-4.8576E-03),
     &  ( 3.2595E-03,-4.9622E-03),( 3.3161E-03,-5.0522E-03),
     &  ( 3.3230E-03,-5.0595E-03),( 3.3700E-03,-5.1252E-03),
     &  ( 3.3771E-03,-5.1325E-03),( 3.4120E-03,-5.1690E-03),
     &  ( 3.4380E-03,-5.1981E-03),( 3.5114E-03,-5.2322E-03),
     &  ( 3.5199E-03,-5.2346E-03),( 3.5605E-03,-5.2784E-03),
     &  ( 3.5629E-03,-5.2857E-03),( 3.5655E-03,-5.2906E-03),
     &  ( 3.5833E-03,-5.3465E-03),( 3.5957E-03,-5.4025E-03),
     &  ( 3.5987E-03,-5.4146E-03),( 3.6166E-03,-5.5192E-03),
     &  ( 3.6184E-03,-5.5290E-03),( 3.6285E-03,-5.5752E-03),
     &  ( 3.6314E-03,-5.5849E-03),( 3.6508E-03,-5.6409E-03),
     &  ( 3.6632E-03,-5.6749E-03),( 3.7042E-03,-5.7746E-03),
     &  ( 3.7119E-03,-5.7844E-03),( 3.7854E-03,-5.8963E-03),
     &  ( 3.8551E-03,-5.9498E-03),( 3.9025E-03,-5.9741E-03),
     &  ( 3.9128E-03,-5.9765E-03),( 4.0680E-03,-6.1906E-03),
     &  ( 4.0971E-03,-6.2076E-03),( 4.2735E-03,-6.3000E-03),
     &  ( 4.4169E-03,-6.3633E-03),( 4.4781E-03,-6.3900E-03),
     &  ( 4.5200E-03,-6.4071E-03),( 4.5408E-03,-6.4168E-03),
     &  ( 4.7570E-03,-6.3317E-03),( 4.8008E-03,-6.3146E-03),
     &  ( 4.9231E-03,-6.2903E-03),( 5.0524E-03,-6.2660E-03),
     &  ( 5.0976E-03,-6.2271E-03),( 5.2321E-03,-6.0471E-03),
     &  ( 5.3253E-03,-5.8671E-03),( 5.3446E-03,-5.8306E-03),
     &  ( 5.3535E-03,-5.8354E-03),( 5.4092E-03,-5.8622E-03),
     &  ( 5.4312E-03,-5.8744E-03),( 5.4536E-03,-5.8865E-03),
     &  ( 5.5585E-03,-5.6336E-03),( 5.5693E-03,-5.5995E-03),
     &  ( 5.5939E-03,-5.5022E-03),( 5.6003E-03,-5.4365E-03),
     &  ( 5.6001E-03,-5.3392E-03),( 5.6014E-03,-5.3222E-03),
     &  ( 5.5973E-03,-5.2736E-03),( 5.5928E-03,-5.2395E-03),
     &  ( 5.5879E-03,-5.2103E-03),( 5.5694E-03,-5.1422E-03),
     &  ( 5.5443E-03,-5.0595E-03),( 5.5160E-03,-5.0060E-03),
     &  ( 5.4693E-03,-4.9306E-03),( 5.4201E-03,-4.8600E-03),
     &  ( 5.4146E-03,-4.8503E-03),( 5.3263E-03,-4.7579E-03),
     &  ( 5.2484E-03,-4.6776E-03),( 5.1677E-03,-4.6119E-03),
     &  ( 5.1523E-03,-4.6144E-03),( 5.0325E-03,-4.6338E-03),
     &  ( 5.0190E-03,-4.6363E-03),( 4.9836E-03,-4.6265E-03),
     &  ( 4.9681E-03,-4.8114E-03),( 4.9813E-03,-4.7141E-03),
     &  ( 4.9777E-03,-4.6995E-03),( 4.9082E-03,-4.6946E-03),
     &  ( 4.8588E-03,-4.6727E-03),( 4.8296E-03,-4.6557E-03),
     &  ( 4.7189E-03,-4.6971E-03),( 4.6121E-03,-4.7603E-03),
     &  ( 4.5885E-03,-4.7725E-03),( 4.5734E-03,-4.7992E-03),
     &  ( 4.5547E-03,-4.8406E-03),( 4.5502E-03,-4.8430E-03),
     &  ( 4.5367E-03,-4.8479E-03),( 4.5340E-03,-4.8503E-03),
     &  ( 4.5250E-03,-4.8552E-03),( 4.5100E-03,-4.8625E-03),
     &  ( 4.4877E-03,-4.8673E-03),( 4.4823E-03,-4.8698E-03),
     &  ( 4.3481E-03,-4.9111E-03),( 4.1718E-03,-5.0413E-03),
     &  ( 4.2620E-03,-5.2322E-03),( 4.5178E-03,-5.4560E-03)/
  
         DATA ((CAS  (I,J), I= 501, 600), J=1,1) /
     &  ( 4.6565E-03,-5.5071E-03),( 4.7100E-03,-5.5240E-03),
     &  ( 4.7846E-03,-5.4329E-03),( 4.7792E-03,-5.5068E-03),
     &  ( 4.8027E-03,-5.4923E-03),( 4.8053E-03,-5.4747E-03),
     &  ( 4.7225E-03,-5.4317E-03),( 4.6391E-03,-5.4098E-03),
     &  ( 4.5185E-03,-5.3879E-03),( 4.3669E-03,-5.3933E-03),
     &  ( 4.1897E-03,-5.3952E-03),( 3.9641E-03,-5.3952E-03),
     &  ( 3.6776E-03,-5.3952E-03),( 3.2968E-03,-5.3806E-03),
     &  ( 2.7706E-03,-5.3660E-03),( 2.0193E-03,-5.3521E-03),
     &  ( 8.8101E-04,-5.3514E-03),( 5.8285E-04,-5.3524E-03),
     &  ( 2.5146E-04,-5.3533E-03),(-1.1897E-04,-5.3543E-03),
     &  (-5.3513E-04,-5.3553E-03),(-1.0085E-03,-5.3563E-03),
     &  (-1.5496E-03,-5.3572E-03),(-2.1750E-03,-5.3582E-03),
     &  (-2.3121E-03,-5.3584E-03),(-2.4536E-03,-5.3586E-03),
     &  (-2.5996E-03,-5.3588E-03),(-2.7506E-03,-5.3590E-03),
     &  (-2.9066E-03,-5.3592E-03),(-3.0679E-03,-5.3594E-03),
     &  (-3.2351E-03,-5.3596E-03),(-3.4079E-03,-5.3598E-03),
     &  (-3.5872E-03,-5.3600E-03),(-3.7732E-03,-5.3601E-03),
     &  (-4.6953E-03,-5.3610E-03),(-5.4167E-03,-5.3622E-03),
     &  (-5.8140E-03,-5.3628E-03),(-6.0935E-03,-5.3632E-03),
     &  (-6.3856E-03,-5.3636E-03),(-6.6917E-03,-5.3640E-03),
     &  (-7.0129E-03,-5.3645E-03),(-7.3503E-03,-5.3649E-03),
     &  (-7.7052E-03,-5.3653E-03),(-7.8896E-03,-5.3655E-03),
     &  (-8.0787E-03,-5.3657E-03),(-8.2730E-03,-5.3659E-03),
     &  (-8.4727E-03,-5.3661E-03),(-8.6779E-03,-5.3663E-03),
     &  (-8.8889E-03,-5.3665E-03),(-9.1058E-03,-5.3668E-03),
     &  (-9.3290E-03,-5.3670E-03),(-9.5588E-03,-5.3672E-03),
     &  (-9.7954E-03,-5.3674E-03),(-1.0039E-02,-5.3676E-03),
     &  (-1.0290E-02,-5.3678E-03),(-1.0549E-02,-5.3680E-03),
     &  (-1.0817E-02,-5.3682E-03),(-1.1093E-02,-5.3684E-03),
     &  (-1.1378E-02,-5.3684E-03),(-1.1672E-02,-5.3684E-03),
     &  (-1.1976E-02,-5.3684E-03),(-1.2291E-02,-5.3684E-03),
     &  (-1.2617E-02,-5.3684E-03),(-1.2954E-02,-5.3684E-03),
     &  (-1.3304E-02,-5.3684E-03),(-1.3667E-02,-5.3684E-03),
     &  (-1.4043E-02,-5.3684E-03),(-1.4434E-02,-5.3684E-03),
     &  (-1.4841E-02,-5.3684E-03),(-1.5263E-02,-5.3684E-03),
     &  (-1.5703E-02,-5.3684E-03),(-1.6161E-02,-5.3684E-03),
     &  (-1.6639E-02,-5.3684E-03),(-1.7137E-02,-5.3674E-03),
     &  (-1.7658E-02,-5.3665E-03),(-1.8203E-02,-5.3655E-03),
     &  (-1.8772E-02,-5.3645E-03),(-1.9369E-02,-5.3636E-03),
     &  (-1.9995E-02,-5.3626E-03),(-2.0652E-02,-5.3616E-03),
     &  (-2.1342E-02,-5.3606E-03),(-2.2070E-02,-5.3597E-03),
     &  (-2.2836E-02,-5.3587E-03),(-2.3235E-02,-5.3591E-03),
     &  (-2.3645E-02,-5.3595E-03),(-2.4067E-02,-5.3600E-03),
     &  (-2.4501E-02,-5.3604E-03),(-2.4947E-02,-5.3608E-03),
     &  (-2.5406E-02,-5.3612E-03),(-2.5880E-02,-5.3617E-03),
     &  (-2.6367E-02,-5.3621E-03),(-2.6870E-02,-5.3625E-03),
     &  (-2.7388E-02,-5.3629E-03),(-2.7923E-02,-5.3634E-03),
     &  (-2.8475E-02,-5.3638E-03),(-2.9046E-02,-5.3642E-03),
     &  (-2.9636E-02,-5.3646E-03),(-3.0245E-02,-5.3651E-03),
     &  (-3.0875E-02,-5.3655E-03),(-3.1528E-02,-5.3659E-03)/
  
         DATA ((CAS  (I,J), I= 601, 700), J=1,1) /
     &  (-3.2204E-02,-5.3664E-03),(-3.2904E-02,-5.3668E-03),
     &  (-3.3631E-02,-5.3672E-03),(-3.4384E-02,-5.3676E-03),
     &  (-3.5167E-02,-5.3681E-03),(-3.5981E-02,-5.3685E-03),
     &  (-3.6828E-02,-5.3689E-03),(-3.7710E-02,-5.3693E-03),
     &  (-3.8627E-02,-5.3698E-03),(-3.9584E-02,-5.3702E-03),
     &  (-4.0583E-02,-5.3706E-03),(-4.1627E-02,-5.3710E-03),
     &  (-4.2718E-02,-5.3715E-03),(-4.3860E-02,-5.3719E-03),
     &  (-4.5057E-02,-5.3723E-03),(-4.6313E-02,-5.3727E-03),
     &  (-4.7631E-02,-5.3732E-03),(-4.9018E-02,-5.3736E-03),
     &  (-5.0478E-02,-5.3740E-03),(-5.2017E-02,-5.3744E-03),
     &  (-5.3642E-02,-5.3749E-03),(-5.6076E-02,-5.3755E-03),
     &  (-5.7181E-02,-5.3757E-03),(-5.9112E-02,-5.3754E-03),
     &  (-6.1164E-02,-5.3750E-03),(-6.3350E-02,-5.3746E-03),
     &  (-6.5683E-02,-5.3743E-03),(-6.8177E-02,-5.3739E-03),
     &  (-7.0851E-02,-5.3735E-03),(-7.3725E-02,-5.3732E-03),
     &  (-7.6822E-02,-5.3728E-03),(-8.0169E-02,-5.3724E-03),
     &  (-8.3797E-02,-5.3721E-03),(-8.7743E-02,-5.3717E-03),
     &  (-9.0895E-02,-5.3714E-03),(-1.0072E-01,-5.3707E-03),
     &  (-1.1275E-01,-5.3700E-03),(-1.2785E-01,-5.3692E-03),
     &  (-1.4736E-01,-5.3685E-03),(-1.7357E-01,-5.3680E-03),
     &  (-2.1074E-01,-5.3675E-03),(-2.6993E-01,-5.3670E-03),
     &  (-3.6127E-01,-1.1435E-02),(-5.5313E-01,-1.9491E-02),
     &  (-1.1685E+00,-6.7944E-02),(-1.2359E+00,-7.5360E-02),
     &  (-1.3115E+00,-8.4176E-02),(-1.3970E+00,-9.4766E-02),
     &  (-1.4941E+00,-1.0764E-01),(-1.6056E+00,-1.2350E-01),
     &  (-1.7350E+00,-1.4335E-01),(-1.8868E+00,-1.6864E-01),
     &  (-2.0673E+00,-2.0156E-01),(-2.2856E+00,-2.4550E-01),
     &  (-2.5546E+00,-3.0595E-01),(-2.8941E+00,-3.9232E-01),
     &  (-3.3211E+00,-5.2169E-01),(-3.9284E+00,-7.2779E-01),
     &  (-3.9992E+00,-7.5488E-01),(-5.5842E+00,-1.5140E+00),
     &  (-6.7394E+00,-2.2778E+00),(-7.6676E+00,-3.0529E+00),
     &  (-4.7820E+00,-3.8772E+00),(-9.0992E+00,-4.6374E+00),
     &  (-9.2967E+00,-5.4218E+00),(-1.0071E+01,-6.1617E+00),
     &  (-1.0508E+01,-7.0425E+00),(-1.0811E+01,-7.7741E+00),
     &  (-1.1091E+01,-8.6047E+00),(-1.1286E+01,-9.3490E+00),
     &  (-1.1443E+01,-1.0171E+01),(-1.1528E+01,-1.0842E+01),
     &  (-1.1589E+01,-1.1814E+01),(-1.1592E+01,-1.2333E+01),
     &  (-1.1557E+01,-1.3155E+01),(-1.1465E+01,-1.4026E+01),
     &  (-1.1366E+01,-1.4634E+01),(-1.1153E+01,-1.5581E+01),
     &  (-1.0961E+01,-1.6233E+01),(-1.0724E+01,-1.6900E+01),
     &  (-1.0231E+01,-1.7576E+01),(-9.7484E+00,-1.8257E+01),
     &  (-9.2182E+00,-1.8940E+01),(-8.6432E+00,-1.9616E+01),
     &  (-8.7214E+00,-2.0280E+01),(-8.1371E+00,-2.0925E+01),
     &  (-7.4892E+00,-2.1540E+01),(-6.7793E+00,-2.2119E+01),
     &  (-5.6048E+00,-2.2897E+01),(-4.7558E+00,-2.3343E+01),
     &  (-3.4330E+00,-2.3883E+01),(-1.9668E+00,-2.4245E+01),
     &  ( 1.9799E+00,-2.4246E+01),( 5.6141E+00,-2.2898E+01),
     &  ( 6.7869E+00,-2.2120E+01),( 7.8273E+00,-2.1237E+01),
     &  ( 8.4429E+00,-2.0607E+01),( 9.2473E+00,-1.9617E+01),
     &  ( 9.2451E+00,-1.8941E+01),( 9.7692E+00,-1.8259E+01)/
  
         DATA ((CAS  (I,J), I= 701, 800), J=1,1) /
     &  ( 1.0244E+01,-1.7577E+01),( 1.0668E+01,-1.6901E+01),
     &  ( 1.0971E+01,-1.6235E+01),( 1.1200E+01,-1.5582E+01),
     &  ( 1.1317E+01,-1.4946E+01),( 1.1434E+01,-1.4329E+01),
     &  ( 1.1518E+01,-1.3732E+01),( 1.1573E+01,-1.3156E+01),
     &  ( 1.1608E+01,-1.2335E+01),( 8.9979E+00,-1.1815E+01),
     &  ( 9.5203E+00,-1.1078E+01),( 1.1485E+01,-1.0391E+01),
     &  ( 1.1417E+01,-9.9592E+00),( 1.1247E+01,-9.1570E+00),
     &  ( 1.1098E+01,-8.6059E+00),( 1.0878E+01,-7.9330E+00),
     &  ( 1.0642E+01,-7.3252E+00),( 1.0335E+01,-6.6470E+00),
     &  ( 1.0088E+01,-6.0491E+00),( 9.3530E+00,-5.3270E+00),
     &  ( 9.1679E+00,-4.7175E+00),( 8.6508E+00,-4.0670E+00),
     &  ( 8.0682E+00,-3.4309E+00),( 7.3188E+00,-2.7331E+00),
     &  ( 6.3934E+00,-2.0665E+00),( 5.3869E+00,-1.3966E+00),
     &  ( 4.4399E+00,-9.3134E-01),( 3.7043E+00,-6.4177E-01),
     &  ( 3.1736E+00,-4.6886E-01),( 2.7739E+00,-3.5766E-01),
     &  ( 2.4627E+00,-2.8204E-01),( 2.2138E+00,-2.2833E-01),
     &  ( 2.0104E+00,-1.8884E-01),( 1.8411E+00,-1.5897E-01),
     &  ( 1.6979E+00,-1.3582E-01),( 1.5754E+00,-1.1754E-01),
     &  ( 1.4694E+00,-1.0284E-01),( 1.3768E+00,-9.0850E-02),
     &  ( 1.2951E+00,-8.0941E-02),( 1.2226E+00,-7.2660E-02),
     &  ( 1.1578E+00,-6.5668E-02),( 1.0996E+00,-5.9711E-02),
     &  ( 1.0469E+00,-5.4595E-02),( 9.9912E-01,-5.0168E-02),
     &  ( 5.2666E-01,-1.7667E-02),( 3.5892E-01,-1.1013E-02),
     &  ( 2.7318E-01,-5.3633E-03),( 2.2243E-01,-5.3630E-03),
     &  ( 1.8526E-01,-5.3627E-03),( 1.5968E-01,-5.3624E-03),
     &  ( 1.4057E-01,-5.3621E-03),( 1.2571E-01,-5.3618E-03),
     &  ( 1.1382E-01,-5.3615E-03),( 1.0408E-01,-5.3613E-03),
     &  ( 1.0293E-01,-5.3612E-03),( 9.4896E-02,-5.3609E-03),
     &  ( 8.8095E-02,-5.3606E-03),( 8.2263E-02,-5.3603E-03),
     &  ( 7.7206E-02,-5.3601E-03),( 7.2778E-02,-5.3598E-03),
     &  ( 6.8870E-02,-5.3595E-03),( 6.5395E-02,-5.3592E-03),
     &  ( 6.2285E-02,-5.3589E-03),( 5.9484E-02,-5.3586E-03),
     &  ( 5.6949E-02,-5.3583E-03),( 5.4643E-02,-5.3580E-03),
     &  ( 5.2538E-02,-5.3577E-03),( 5.0607E-02,-5.3574E-03),
     &  ( 4.8831E-02,-5.3571E-03),( 4.7191E-02,-5.3568E-03),
     &  ( 4.5672E-02,-5.3565E-03),( 4.4261E-02,-5.3563E-03),
     &  ( 4.2947E-02,-5.3560E-03),( 4.1720E-02,-5.3557E-03),
     &  ( 4.0572E-02,-5.3554E-03),( 3.9496E-02,-5.3551E-03),
     &  ( 3.8485E-02,-5.3548E-03),( 3.7533E-02,-5.3545E-03),
     &  ( 3.6635E-02,-5.3542E-03),( 3.5787E-02,-5.3539E-03),
     &  ( 3.4984E-02,-5.3536E-03),( 3.4224E-02,-5.3533E-03),
     &  ( 3.3502E-02,-5.3530E-03),( 3.2817E-02,-5.3528E-03),
     &  ( 3.2164E-02,-5.3525E-03),( 3.1543E-02,-5.3522E-03),
     &  ( 3.0951E-02,-5.3519E-03),( 3.0385E-02,-5.3516E-03),
     &  ( 2.9844E-02,-5.3513E-03),( 2.9327E-02,-5.3510E-03),
     &  ( 2.8831E-02,-5.3507E-03),( 2.8356E-02,-5.3504E-03),
     &  ( 2.7901E-02,-5.3501E-03),( 2.7463E-02,-5.3498E-03),
     &  ( 2.7043E-02,-5.3495E-03),( 2.6639E-02,-5.3493E-03),
     &  ( 2.6250E-02,-5.3490E-03),( 2.5875E-02,-5.3487E-03),
     &  ( 2.5513E-02,-5.3484E-03),( 2.5165E-02,-5.3481E-03)/
  
         DATA ((CAS  (I,J), I= 801, 900), J=1,1) /
     &  ( 2.4829E-02,-5.3478E-03),( 2.4504E-02,-5.3475E-03),
     &  ( 2.4191E-02,-5.3472E-03),( 2.3887E-02,-5.3469E-03),
     &  ( 2.3594E-02,-5.3466E-03),( 2.3310E-02,-5.3463E-03),
     &  ( 2.3035E-02,-5.3460E-03),( 2.2769E-02,-5.3457E-03),
     &  ( 2.2511E-02,-5.3455E-03),( 2.2261E-02,-5.3452E-03),
     &  ( 2.2018E-02,-5.3449E-03),( 2.1782E-02,-5.3446E-03),
     &  ( 2.1553E-02,-5.3443E-03),( 2.1331E-02,-5.3440E-03),
     &  ( 2.1115E-02,-5.3437E-03),( 2.0905E-02,-5.3434E-03),
     &  ( 2.0701E-02,-5.3431E-03),( 2.0502E-02,-5.3428E-03),
     &  ( 2.0309E-02,-5.3425E-03),( 2.0121E-02,-5.3422E-03),
     &  ( 1.9938E-02,-5.3420E-03),( 1.9760E-02,-5.3417E-03),
     &  ( 1.9586E-02,-5.3414E-03),( 1.9417E-02,-5.3411E-03),
     &  ( 1.9253E-02,-5.3408E-03),( 1.9093E-02,-5.3405E-03),
     &  ( 1.8936E-02,-5.3402E-03),( 1.8785E-02,-5.3399E-03),
     &  ( 1.8637E-02,-5.3396E-03),( 1.8493E-02,-5.3393E-03),
     &  ( 1.8353E-02,-5.3390E-03),( 1.8217E-02,-5.3387E-03),
     &  ( 1.8085E-02,-5.3385E-03),( 1.7957E-02,-5.3382E-03),
     &  ( 1.7833E-02,-5.3379E-03),( 1.7714E-02,-5.3376E-03),
     &  ( 1.7600E-02,-5.3373E-03),( 1.7313E-02,-5.3370E-03),
     &  ( 1.7190E-02,-5.3367E-03),( 1.7070E-02,-5.3364E-03),
     &  ( 1.6952E-02,-5.3361E-03),( 1.6836E-02,-5.3358E-03),
     &  ( 1.6721E-02,-5.3355E-03),( 1.6610E-02,-5.3352E-03),
     &  ( 1.6500E-02,-5.3349E-03),( 1.6392E-02,-5.3347E-03),
     &  ( 1.6297E-02,-5.3344E-03),( 1.6181E-02,-5.3353E-03),
     &  ( 1.6078E-02,-5.3362E-03),( 1.5978E-02,-5.3371E-03),
     &  ( 1.5881E-02,-5.3381E-03),( 1.5785E-02,-5.3390E-03),
     &  ( 1.5692E-02,-5.3399E-03),( 1.5600E-02,-5.3408E-03),
     &  ( 1.5509E-02,-5.3418E-03),( 1.5420E-02,-5.3427E-03),
     &  ( 1.5333E-02,-5.3436E-03),( 1.2697E-02,-5.3806E-03),
     &  ( 1.0847E-02,-5.4268E-03),( 9.2109E-03,-5.4183E-03),
     &  ( 8.6612E-03,-5.4146E-03),( 7.7448E-03,-5.4098E-03),
     &  ( 6.7665E-03,-5.4122E-03),( 6.3085E-03,-5.4157E-03),
     &  ( 5.7809E-03,-5.4192E-03),( 5.7117E-03,-5.4199E-03),
     &  ( 5.3583E-03,-5.4314E-03),( 5.1466E-03,-5.4233E-03),
     &  ( 5.1075E-03,-5.4219E-03),( 4.5588E-03,-5.4243E-03),
     &  ( 3.8217E-03,-5.4268E-03),( 3.5324E-03,-5.4268E-03),
     &  ( 3.1984E-03,-5.4582E-03),( 2.8800E-03,-5.4536E-03),
     &  ( 2.4835E-03,-5.4497E-03),( 2.0355E-03,-5.4458E-03),
     &  ( 1.5276E-03,-5.4419E-03),( 9.4557E-04,-5.4380E-03),
     &  ( 2.6954E-04,-5.4341E-03),(-5.2869E-04,-5.4377E-03),
     &  (-1.4895E-03,-5.4414E-03),(-2.6718E-03,-5.4450E-03),
     &  (-4.1672E-03,-5.4487E-03),(-4.8840E-03,-5.4531E-03),
     &  (-5.6876E-03,-5.4574E-03),(-6.5955E-03,-5.4618E-03),
     &  (-7.6297E-03,-5.4662E-03),(-8.8195E-03,-5.4706E-03),
     &  (-1.0204E-02,-5.4754E-03),(-1.0984E-02,-5.4779E-03),
     &  (-1.1835E-02,-5.4803E-03),(-1.2766E-02,-5.4827E-03),
     &  (-1.3789E-02,-5.4852E-03),(-1.4918E-02,-5.4876E-03),
     &  (-1.6172E-02,-5.4900E-03),(-1.7571E-02,-5.4925E-03),
     &  (-1.9143E-02,-5.4949E-03),(-2.0922E-02,-5.4973E-03),
     &  (-2.2953E-02,-5.4910E-03),(-2.5294E-02,-5.4847E-03)/
  
         DATA ((CAS  (I,J), I= 901,1000), J=1,1) /
     &  (-2.8021E-02,-5.4784E-03),(-3.1099E-02,-5.4724E-03),
     &  (-3.3114E-02,-5.4689E-03),(-3.5350E-02,-5.4654E-03),
     &  (-3.7846E-02,-5.4620E-03),(-4.0651E-02,-5.4585E-03),
     &  (-4.3824E-02,-5.4551E-03),(-4.7445E-02,-5.4516E-03),
     &  (-5.1616E-02,-5.4481E-03),(-5.6473E-02,-5.4447E-03),
     &  (-6.2202E-02,-5.4412E-03),(-6.9063E-02,-5.4377E-03),
     &  (-7.7430E-02,-5.4343E-03),(-8.7866E-02,-5.4308E-03),
     &  (-1.0126E-01,-5.4273E-03),(-1.1910E-01,-5.4239E-03),
     &  (-1.4412E-01,-5.4204E-03),(-1.8206E-01,-5.4169E-03),
     &  (-2.4918E-01,-5.4135E-03),(-3.6788E-01,-5.3100E-02),
     &  (-5.3785E-01,-1.1151E-01),(-6.3642E-01,-1.5635E-01),
     &  (-7.4430E-01,-2.1601E-01),(-1.0104E+00,-4.2193E-01),
     &  (-1.1066E+00,-5.2368E-01),(-1.1372E+00,-6.2358E-01),
     &  (-1.2526E+00,-7.2366E-01),(-1.2968E+00,-8.2297E-01),
     &  (-1.3560E+00,-9.1922E-01),(-1.3960E+00,-1.0182E+00),
     &  (-1.4050E+00,-1.1170E+00),(-1.4310E+00,-1.2047E+00),
     &  (-1.4723E+00,-1.3009E+00),(-1.4865E+00,-1.3969E+00),
     &  (-1.4948E+00,-1.4911E+00),(-1.4978E+00,-1.5816E+00),
     &  (-1.4956E+00,-1.6778E+00),(-1.4896E+00,-1.7563E+00),
     &  (-1.4776E+00,-1.8501E+00),(-1.4619E+00,-1.9354E+00),
     &  (-1.4427E+00,-2.0236E+00),(-1.4164E+00,-2.1142E+00),
     &  (-1.3853E+00,-2.1935E+00),(-1.3455E+00,-2.2874E+00),
     &  (-1.3051E+00,-2.3687E+00),(-1.2588E+00,-2.4500E+00),
     &  (-1.2061E+00,-2.5308E+00),(-1.1363E+00,-2.6236E+00),
     &  (-1.0693E+00,-2.7010E+00),(-9.8236E-01,-2.7877E+00),
     &  (-9.0055E-01,-2.8579E+00),(-7.8128E-01,-2.9438E+00),
     &  (-6.5111E-01,-3.0192E+00),(-4.5671E-01,-3.1019E+00),
     &  (-2.8725E-01,-3.1485E+00),(-9.2062E-02,-3.1757E+00),
     &  ( 6.8043E-03,-3.1792E+00),( 1.0567E-01,-3.1757E+00),
     &  ( 2.0390E-01,-3.1655E+00),( 4.7034E-01,-3.1020E+00),
     &  ( 6.6478E-01,-3.0195E+00),( 7.9497E-01,-2.9441E+00),
     &  ( 9.1427E-01,-2.8582E+00),( 9.9610E-01,-2.7880E+00),
     &  ( 1.0830E+00,-2.7014E+00),( 1.1501E+00,-2.6240E+00),
     &  ( 1.2199E+00,-2.5312E+00),( 1.2726E+00,-2.4504E+00),
     &  ( 1.3190E+00,-2.3691E+00),( 1.3594E+00,-2.2879E+00),
     &  ( 1.3993E+00,-2.1940E+00),( 1.4303E+00,-2.1146E+00),
     &  ( 1.4567E+00,-2.0240E+00),( 1.4760E+00,-1.9359E+00),
     &  ( 1.4917E+00,-1.8506E+00),( 1.5037E+00,-1.7568E+00),
     &  ( 1.5097E+00,-1.6782E+00),( 1.5119E+00,-1.5821E+00),
     &  ( 1.5090E+00,-1.4915E+00),( 1.5006E+00,-1.3973E+00),
     &  ( 1.4865E+00,-1.3013E+00),( 1.4450E+00,-1.2052E+00),
     &  ( 1.4190E+00,-1.1174E+00),( 1.4102E+00,-1.0186E+00),
     &  ( 1.3703E+00,-9.1961E-01),( 1.3110E+00,-8.2334E-01),
     &  ( 1.2669E+00,-7.2401E-01),( 1.1521E+00,-6.2391E-01),
     &  ( 1.1209E+00,-5.2398E-01),( 1.0248E+00,-4.2220E-01),
     &  ( 9.1312E-01,-3.2040E-01),( 9.7163E-01,-3.7307E-01),
     &  ( 8.3289E-01,-2.6443E-01),( 7.4755E-01,-2.0946E-01),
     &  ( 6.9600E-01,-1.8007E-01),( 5.8946E-01,-1.2754E-01),
     &  ( 5.5231E-01,-1.1165E-01),( 4.7535E-01,-8.1521E-02),
     &  ( 5.7724E-01,-5.3927E-03),( 2.2257E-01,-5.3892E-03)/
  
         DATA ((CAS  (I,J), I=1001,1100), J=1,1) /
     &  ( 1.7431E-01,-5.3857E-03),( 1.4421E-01,-5.3823E-03),
     &  ( 1.2343E-01,-5.3788E-03),( 1.0816E-01,-5.3753E-03),
     &  ( 9.6459E-02,-5.3719E-03),( 8.7189E-02,-5.3684E-03),
     &  ( 7.9660E-02,-5.3649E-03),( 7.3420E-02,-5.3615E-03),
     &  ( 6.8157E-02,-5.3588E-03),( 6.3645E-02,-5.3594E-03),
     &  ( 5.9756E-02,-5.4692E-03),( 5.6419E-02,-5.4713E-03),
     &  ( 5.3461E-02,-5.4734E-03),( 5.0831E-02,-5.4756E-03),
     &  ( 4.8482E-02,-5.4778E-03),( 4.6372E-02,-5.4801E-03),
     &  ( 4.3021E-02,-5.4843E-03),( 3.8837E-02,-5.4910E-03),
     &  ( 3.6594E-02,-5.5003E-03),( 3.2917E-02,-5.5291E-03),
     &  ( 3.0030E-02,-5.5585E-03),( 2.7175E-02,-5.5963E-03),
     &  ( 2.3101E-02,-5.6673E-03),( 1.8516E-02,-5.7954E-03),
     &  ( 1.5638E-02,-5.9856E-03),( 1.4297E-02,-6.2173E-03),
     &  ( 1.3600E-02,-6.4087E-03),( 1.3084E-02,-6.5762E-03),
     &  ( 1.2704E-02,-6.7280E-03),( 1.2395E-02,-6.8685E-03),
     &  ( 1.2167E-02,-7.0007E-03),( 1.1967E-02,-7.1075E-03),
     &  ( 1.1799E-02,-7.2038E-03),( 1.1655E-02,-7.2987E-03),
     &  ( 1.1530E-02,-7.3920E-03),( 1.1448E-02,-7.4842E-03),
     &  ( 1.1325E-02,-7.5755E-03),( 1.1241E-02,-7.6657E-03),
     &  ( 1.1167E-02,-7.7553E-03),( 1.1101E-02,-7.8444E-03),
     &  ( 1.1044E-02,-7.9332E-03),( 1.0993E-02,-8.0217E-03),
     &  ( 1.0949E-02,-8.1102E-03),( 1.0911E-02,-8.1988E-03),
     &  ( 1.0879E-02,-8.2877E-03),( 1.0852E-02,-8.3770E-03),
     &  ( 1.0796E-02,-8.4671E-03),( 1.0814E-02,-8.5583E-03),
     &  ( 1.0803E-02,-8.6509E-03),( 1.0798E-02,-8.7451E-03),
     &  ( 1.0798E-02,-8.8416E-03),( 1.0806E-02,-8.9410E-03),
     &  ( 1.0824E-02,-9.0446E-03),( 1.0849E-02,-9.1533E-03),
     &  ( 1.0888E-02,-9.2697E-03),( 1.0946E-02,-9.3983E-03),
     &  ( 1.1038E-02,-9.5505E-03),( 1.1336E-02,-9.8423E-03),
     &  ( 1.1729E-02,-1.0009E-02),( 1.1916E-02,-1.0032E-02),
     &  ( 1.2068E-02,-1.0027E-02),( 1.2201E-02,-1.0006E-02),
     &  ( 1.2322E-02,-9.9724E-03),( 1.2432E-02,-9.9292E-03),
     &  ( 1.2533E-02,-9.8776E-03),( 1.2628E-02,-9.8184E-03),
     &  ( 1.2717E-02,-9.7520E-03),( 1.2799E-02,-9.6790E-03),
     &  ( 1.2874E-02,-9.5997E-03),( 1.2946E-02,-9.5143E-03),
     &  ( 1.2970E-02,-9.4230E-03),( 1.3036E-02,-9.3258E-03),
     &  ( 1.3092E-02,-9.2230E-03),( 1.3151E-02,-9.1145E-03),
     &  ( 1.3192E-02,-9.0009E-03),( 1.3234E-02,-8.8817E-03),
     &  ( 1.3251E-02,-8.7575E-03),( 1.3258E-02,-8.6282E-03),
     &  ( 1.3255E-02,-8.4940E-03),( 1.3241E-02,-8.3549E-03),
     &  ( 1.3214E-02,-8.2113E-03),( 1.3173E-02,-8.0635E-03),
     &  ( 1.3110E-02,-7.9113E-03),( 1.3032E-02,-7.7555E-03),
     &  ( 1.2943E-02,-7.5962E-03),( 1.2829E-02,-7.4338E-03),
     &  ( 1.2686E-02,-7.2689E-03),( 1.2506E-02,-7.1021E-03),
     &  ( 1.2281E-02,-6.9342E-03),( 1.1994E-02,-6.7662E-03),
     &  ( 1.1607E-02,-6.6000E-03),( 1.1050E-02,-6.4797E-03),
     &  ( 1.0884E-02,-6.4593E-03),( 1.0442E-02,-6.4317E-03),
     &  ( 9.7777E-03,-6.4533E-03),( 9.7092E-03,-6.4642E-03),
     &  ( 9.2494E-03,-6.5491E-03),( 9.0624E-03,-6.5856E-03),
     &  ( 8.9136E-03,-6.6583E-03),( 8.7868E-03,-6.7467E-03)/
  
         DATA ((CAS  (I,J), I=1101,1200), J=1,1) /
     &  ( 8.5903E-03,-6.7260E-03),( 8.3817E-03,-6.9396E-03),
     &  ( 8.3361E-03,-7.0825E-03),( 8.3295E-03,-7.1228E-03),
     &  ( 8.2929E-03,-7.2444E-03),( 8.2276E-03,-7.3251E-03),
     &  ( 8.1914E-03,-7.4506E-03),( 8.2008E-03,-7.5761E-03),
     &  ( 8.3352E-03,-7.6175E-03),( 8.3191E-03,-7.4905E-03),
     &  ( 8.1690E-03,-7.4715E-03),( 8.1076E-03,-7.5065E-03),
     &  ( 7.9902E-03,-7.3942E-03),( 7.8892E-03,-7.4516E-03),
     &  ( 7.7881E-03,-7.8485E-03),( 7.6871E-03,-7.9186E-03),
     &  ( 7.6152E-03,-7.8252E-03),( 7.4390E-03,-7.8194E-03),
     &  ( 7.1757E-03,-7.8398E-03),( 6.8135E-03,-7.9128E-03),
     &  ( 6.5826E-03,-7.9371E-03),( 6.2287E-03,-8.4100E-03),
     &  ( 5.9965E-03,-9.1193E-03),( 6.1155E-03,-1.0176E-02),
     &  ( 6.6664E-03,-1.0880E-02),( 7.0434E-03,-1.0939E-02),
     &  ( 7.8930E-03,-1.1086E-02),( 8.2512E-03,-1.1090E-02),
     &  ( 8.5438E-03,-1.0630E-02),( 8.8698E-03,-1.0486E-02),
     &  ( 9.1223E-03,-1.0094E-02),( 9.0693E-03,-9.8320E-03),
     &  ( 9.0021E-03,-9.8616E-03),( 9.1320E-03,-9.9507E-03),
     &  ( 9.5132E-03,-9.6067E-03),( 9.2319E-03,-9.0463E-03),
     &  ( 8.8807E-03,-9.3032E-03),( 8.9412E-03,-9.5007E-03),
     &  ( 9.0586E-03,-9.5795E-03),( 9.1421E-03,-9.6057E-03),
     &  ( 9.2631E-03,-9.4841E-03),( 9.2774E-03,-9.3017E-03),
     &  ( 9.1932E-03,-9.1630E-03),( 9.0147E-03,-9.0521E-03),
     &  ( 8.9083E-03,-9.0244E-03),( 8.7043E-03,-9.2470E-03),
     &  ( 8.6783E-03,-9.6179E-03),( 8.8136E-03,-9.7962E-03),
     &  ( 8.9665E-03,-9.9159E-03),( 9.1574E-03,-1.0036E-02),
     &  ( 9.2417E-03,-1.0065E-02),( 9.4202E-03,-9.9677E-03),
     &  ( 9.4951E-03,-9.8699E-03),( 9.3911E-03,-9.7875E-03),
     &  ( 9.4891E-03,-1.0075E-02),( 9.7115E-03,-1.0219E-02),
     &  ( 9.9478E-03,-1.0125E-02),( 1.0187E-02,-9.9363E-03),
     &  ( 1.0329E-02,-9.7955E-03),( 1.0450E-02,-9.6724E-03),
     &  ( 1.0599E-02,-9.5907E-03),( 1.0712E-02,-9.5498E-03),
     &  ( 1.0794E-02,-9.4739E-03),( 1.0881E-02,-9.3601E-03),
     &  ( 1.1005E-02,-9.1703E-03),( 1.1112E-02,-8.9514E-03),
     &  ( 1.1205E-02,-8.7763E-03),( 1.1302E-02,-8.6318E-03),
     &  ( 1.1144E-02,-7.9269E-03),( 1.0654E-02,-7.8184E-03),
     &  ( 1.0546E-02,-7.9113E-03),( 1.0622E-02,-8.1901E-03),
     &  ( 1.0781E-02,-7.8529E-03),( 1.0592E-02,-7.6214E-03),
     &  ( 1.0588E-02,-7.6009E-03),( 1.0723E-02,-7.5941E-03),
     &  ( 1.0808E-02,-7.0512E-03),( 1.0069E-02,-6.2198E-03),
     &  ( 9.2838E-03,-6.7111E-03),( 9.0207E-03,-7.0468E-03),
     &  ( 8.8316E-03,-7.4803E-03),( 9.1280E-03,-7.6330E-03),
     &  ( 9.1339E-03,-7.5674E-03),( 9.0077E-03,-7.5776E-03),
     &  ( 8.8970E-03,-7.5844E-03),( 8.8325E-03,-7.6029E-03),
     &  ( 8.7411E-03,-7.6306E-03),( 8.6193E-03,-7.6335E-03),
     &  ( 8.2805E-03,-7.9838E-03),( 8.3031E-03,-8.0709E-03),
     &  ( 8.3308E-03,-8.2144E-03),( 8.2685E-03,-8.3506E-03),
     &  ( 8.2459E-03,-8.4002E-03),( 8.2313E-03,-8.6911E-03),
     &  ( 8.2813E-03,-8.9684E-03),( 8.3066E-03,-9.0609E-03),
     &  ( 8.3205E-03,-9.1090E-03),( 8.3580E-03,-9.2535E-03),
     &  ( 8.3449E-03,-9.3017E-03),( 8.3858E-03,-9.5420E-03)/
  
         DATA ((CAS  (I,J), I=1201,1300), J=1,1) /
     &  ( 8.7644E-03,-9.9025E-03),( 9.1686E-03,-9.7157E-03),
     &  ( 9.2822E-03,-9.5912E-03),( 9.3157E-03,-9.5391E-03),
     &  ( 9.3355E-03,-9.3829E-03),( 9.2048E-03,-9.5070E-03),
     &  ( 9.4716E-03,-9.7712E-03),( 9.8012E-03,-9.5975E-03),
     &  ( 9.9271E-03,-9.4817E-03),( 9.9793E-03,-9.4107E-03),
     &  ( 1.0069E-02,-9.1976E-03),( 1.0083E-02,-9.1266E-03),
     &  ( 9.9915E-03,-8.7763E-03),( 9.8312E-03,-8.7427E-03),
     &  ( 9.7752E-03,-8.7228E-03),( 9.8854E-03,-8.7301E-03),
     &  ( 9.8838E-03,-8.6624E-03),( 9.5567E-03,-8.5160E-03),
     &  ( 9.5711E-03,-8.7082E-03),( 9.7366E-03,-8.7276E-03),
     &  ( 9.6981E-03,-8.3141E-03),( 9.5223E-03,-8.3384E-03),
     &  ( 9.4344E-03,-8.6474E-03),( 9.4657E-03,-8.7447E-03),
     &  ( 9.5680E-03,-8.7374E-03),( 9.5737E-03,-8.7325E-03),
     &  ( 9.8028E-03,-9.0074E-03),( 9.9132E-03,-8.7057E-03),
     &  ( 1.0156E-02,-9.2020E-03),( 1.0414E-02,-8.8684E-03),
     &  ( 1.0440E-02,-8.6838E-03),( 1.0463E-02,-8.9360E-03),
     &  ( 1.0471E-02,-8.9306E-03),( 1.0548E-02,-8.9203E-03),
     &  ( 1.0688E-02,-8.9009E-03),( 1.0752E-02,-8.8918E-03),
     &  ( 1.0813E-02,-8.8831E-03),( 1.0930E-02,-8.8668E-03),
     &  ( 1.1041E-02,-8.8517E-03),( 1.1094E-02,-8.8446E-03),
     &  ( 1.1147E-02,-8.8378E-03),( 1.1198E-02,-8.8312E-03),
     &  ( 1.1248E-02,-8.8248E-03),( 1.1298E-02,-8.8187E-03),
     &  ( 1.1346E-02,-8.8128E-03),( 1.1394E-02,-8.8071E-03),
     &  ( 1.1441E-02,-8.8016E-03),( 1.1487E-02,-8.7963E-03),
     &  ( 1.1533E-02,-8.7911E-03),( 1.1577E-02,-8.7861E-03),
     &  ( 1.1622E-02,-8.7813E-03),( 1.1665E-02,-8.7766E-03),
     &  ( 1.1708E-02,-8.7721E-03),( 1.1750E-02,-8.7677E-03),
     &  ( 1.1792E-02,-8.7635E-03),( 1.1833E-02,-8.7594E-03),
     &  ( 1.1874E-02,-8.7554E-03),( 1.1914E-02,-8.7515E-03),
     &  ( 1.1953E-02,-8.7477E-03),( 1.1992E-02,-8.7440E-03),
     &  ( 1.2031E-02,-8.7405E-03),( 1.2069E-02,-8.7370E-03),
     &  ( 1.2106E-02,-8.7336E-03),( 1.2143E-02,-8.7303E-03),
     &  ( 1.2180E-02,-8.7271E-03),( 1.2216E-02,-8.7240E-03),
     &  ( 1.2251E-02,-8.7210E-03),( 1.2286E-02,-8.7180E-03),
     &  ( 1.2320E-02,-8.7151E-03),( 1.2354E-02,-8.7123E-03),
     &  ( 1.2388E-02,-8.7096E-03),( 1.2421E-02,-8.7069E-03),
     &  ( 1.2453E-02,-8.7043E-03),( 1.2479E-02,-8.7022E-03),
     &  ( 1.2517E-02,-8.6992E-03),( 1.2578E-02,-8.6944E-03),
     &  ( 1.2638E-02,-8.6898E-03),( 1.2695E-02,-8.6854E-03),
     &  ( 1.2749E-02,-8.6812E-03),( 1.2802E-02,-8.6771E-03),
     &  ( 1.2851E-02,-8.6732E-03),( 1.2898E-02,-8.6695E-03),
     &  ( 1.2941E-02,-8.6659E-03),( 1.2981E-02,-8.6625E-03),
     &  ( 1.3015E-02,-8.6591E-03),( 1.3044E-02,-8.6559E-03),
     &  ( 1.3066E-02,-8.6528E-03),( 1.3078E-02,-8.6498E-03),
     &  ( 1.3076E-02,-8.6469E-03),( 1.3074E-02,-8.6466E-03),
     &  ( 1.3051E-02,-8.6441E-03),( 1.2989E-02,-8.6414E-03),
     &  ( 1.2847E-02,-8.6388E-03),( 1.2586E-02,-8.6367E-03),
     &  ( 1.2475E-02,-8.6362E-03),( 1.1998E-02,-8.6350E-03),
     &  ( 1.1073E-02,-8.6340E-03),( 1.0632E-02,-8.6338E-03),
     &  ( 1.0001E-02,-8.6335E-03),( 9.5724E-03,-8.6334E-03)/
  
         DATA ((CAS  (I,J), I=1301,1400), J=1,1) /
     &  ( 9.0290E-03,-8.6333E-03),( 8.4781E-03,-8.6332E-03),
     &  ( 7.7803E-03,-8.6331E-03),( 7.3573E-03,-8.6330E-03),
     &  ( 6.8703E-03,-8.6330E-03),( 6.3041E-03,-8.6329E-03),
     &  ( 5.6383E-03,-8.6329E-03),( 4.8450E-03,-8.6329E-03),
     &  ( 3.8852E-03,-8.6328E-03),( 3.3260E-03,-8.6328E-03),
     &  ( 2.7020E-03,-8.6328E-03),( 2.0016E-03,-8.6327E-03),
     &  ( 1.2102E-03,-8.6327E-03),( 3.0931E-04,-8.6327E-03),
     &  (-7.2483E-04,-8.6327E-03),(-1.9235E-03,-8.6326E-03),
     &  (-3.3289E-03,-8.6326E-03),(-5.0004E-03,-8.6326E-03),
     &  (-5.7035E-03,-8.6326E-03),(-6.1479E-03,-8.6326E-03),
     &  (-6.6163E-03,-8.6326E-03),(-7.1238E-03,-8.6326E-03),
     &  (-7.6083E-03,-8.7060E-03),(-8.1115E-03,-8.7093E-03),
     &  (-6.7747E-03,-8.7128E-03),(-9.2142E-03,-8.7166E-03),
     &  (-9.8101E-03,-8.7207E-03),(-1.0437E-02,-8.7251E-03),
     &  (-1.1098E-02,-8.7299E-03),(-1.1795E-02,-8.7350E-03),
     &  (-1.2530E-02,-8.7405E-03),(-1.3307E-02,-8.7464E-03),
     &  (-1.4129E-02,-8.7529E-03),(-1.5001E-02,-8.7600E-03),
     &  (-1.5926E-02,-8.7676E-03),(-1.6910E-02,-8.7760E-03),
     &  (-1.7957E-02,-8.7853E-03),(-1.9076E-02,-8.7954E-03),
     &  (-2.0271E-02,-8.8065E-03),(-2.1553E-02,-8.8189E-03),
     &  (-2.2930E-02,-8.8326E-03),(-2.4413E-02,-8.8479E-03),
     &  (-2.6015E-02,-8.8650E-03),(-2.7750E-02,-8.8843E-03),
     &  (-2.9635E-02,-8.9060E-03),(-3.1690E-02,-8.9307E-03),
     &  (-3.3939E-02,-8.9588E-03),(-3.6411E-02,-8.9912E-03),
     &  (-3.9139E-02,-9.0286E-03),(-4.2165E-02,-9.0721E-03),
     &  (-4.5540E-02,-9.1233E-03),(-4.9329E-02,-9.1840E-03),
     &  (-5.3609E-02,-9.2566E-03),(-5.8481E-02,-9.3446E-03),
     &  (-6.4078E-02,-9.4525E-03),(-7.0570E-02,-9.5870E-03),
     &  (-7.8189E-02,-9.7575E-03),(-8.7254E-02,-9.9780E-03),
     &  (-9.8214E-02,-1.0270E-02),(-1.1173E-01,-1.0670E-02),
     &  (-1.2879E-01,-1.1235E-02),( 9.5720E-03,-1.2072E-02),
     &  (-1.8109E-01,-1.3389E-02),(-2.2409E-01,-1.5636E-02),
     &  (-2.9050E-01,-1.9954E-02),(-4.0637E-01,-2.9951E-02),
     &  (-6.5796E-01,-6.2670E-02),(-8.1838E-01,-8.5647E-03),
     &  (-1.5851E+00,-8.5648E-03),(-2.2173E+00,-8.5649E-03),
     &  (-2.6761E+00,-8.5649E-03),(-3.0299E+00,-8.5649E-03),
     &  ( 1.0628E-02,-8.5649E-03),(-3.5757E+00,-8.5649E-03),
     &  (-3.8124E+00,-8.5649E-03),(-3.9771E+00,-8.5649E-03),
     &  (-4.1444E+00,-8.5649E-03),(-4.3091E+00,-8.5649E-03),
     &  (-4.3886E+00,-8.5649E-03),(-4.4999E+00,-8.5649E-03),
     &  (-4.5673E+00,-8.5649E-03),(-4.6509E+00,-8.5649E-03),
     &  (-4.6710E+00,-8.5649E-03),(-4.7080E+00,-8.5649E-03),
     &  (-4.7162E+00,-8.5649E-03),(-4.7063E+00,-8.5649E-03),
     &  (-4.6910E+00,-8.5649E-03),(-4.6680E+00,-8.5649E-03),
     &  (-3.8908E-02,-8.5649E-03),(-3.7654E-02,-8.5649E-03),
     &  (-4.4811E+00,-8.5649E-03),(-4.3192E+00,-8.5650E-03),
     &  (-4.2187E+00,-8.5650E-03),(-4.1055E+00,-8.5650E-03),
     &  (-3.9749E+00,-8.5650E-03),(-3.6643E+00,-8.5650E-03),
     &  (-3.4833E+00,-8.5650E-03),(-3.2870E+00,-8.5650E-03),
     &  (-2.8410E+00,-8.5650E-03),(-2.5941E+00,-8.5650E-03)/
  
         DATA ((CAS  (I,J), I=1401,1500), J=1,1) /
     &  (-7.7894E-01,-8.5650E-03),(-1.4540E+00,-8.5650E-03),
     &  ( 1.8481E-01,-8.5650E-03),( 1.4867E+00,-8.5650E-03),
     &  ( 2.0864E+00,-8.5650E-03),( 2.6289E+00,-8.5650E-03),
     &  ( 3.1110E+00,-8.5650E-03),( 3.3277E+00,-8.5650E-03),
     &  ( 3.5250E+00,-8.5650E-03),( 3.7053E+00,-8.5650E-03),
     &  ( 4.0173E+00,-8.5650E-03),( 4.1485E+00,-8.5650E-03),
     &  ( 4.2656E+00,-8.5650E-03),( 4.3734E+00,-8.5650E-03),
     &  ( 4.5318E+00,-8.5650E-03),( 4.5935E+00,-8.5650E-03),
     &  ( 4.6459E+00,-8.5650E-03),( 4.7197E+00,-8.5650E-03),
     &  ( 4.7435E+00,-8.5650E-03),( 4.7678E+00,-8.5650E-03),
     &  ( 4.7700E+00,-8.5650E-03),( 4.7574E+00,-8.5650E-03),
     &  ( 4.7262E+00,-8.5650E-03),( 4.7465E+00,-8.5650E-03),
     &  ( 4.7048E+00,-8.5650E-03),( 4.5569E+00,-8.5650E-03),
     &  ( 4.4483E+00,-8.5650E-03),( 4.3686E+00,-8.5650E-03),
     &  ( 4.2008E+00,-8.5650E-03),( 4.0337E+00,-8.5650E-03),
     &  ( 3.8689E+00,-8.5650E-03),( 3.6321E+00,-8.5650E-03),
     &  ( 3.3774E+00,-8.5650E-03),( 3.0857E+00,-8.5650E-03),
     &  ( 2.7310E+00,-8.5651E-03),( 2.2726E+00,-8.5651E-03),
     &  ( 1.6308E+00,-8.5651E-03),( 9.0099E-01,-8.5653E-03),
     &  ( 5.2516E-01,-8.5655E-03),( 3.7399E-01,-8.5657E-03),
     &  ( 2.9242E-01,-8.5660E-03),( 2.4134E-01,-8.5662E-03),
     &  ( 2.0633E-01,-8.5664E-03),( 1.8086E-01,-8.5666E-03),
     &  ( 1.6138E-01,-8.5669E-03),( 1.4607E-01,-8.5671E-03),
     &  ( 1.3370E-01,-8.5673E-03),( 1.2349E-01,-8.5675E-03),
     &  ( 1.1492E-01,-8.5678E-03),( 1.0761E-01,-8.5680E-03),
     &  ( 1.0130E-01,-8.5682E-03),( 9.5809E-02,-8.5685E-03),
     &  ( 4.4071E-02,-8.5687E-03),( 8.6688E-02,-8.5689E-03),
     &  ( 8.2854E-02,-8.5691E-03),( 7.9412E-02,-8.5694E-03),
     &  ( 7.6298E-02,-8.5696E-03),( 7.3469E-02,-8.5698E-03),
     &  ( 7.0886E-02,-8.5700E-03),( 6.8517E-02,-8.5703E-03),
     &  ( 6.6338E-02,-8.5705E-03),( 6.4324E-02,-8.5707E-03),
     &  ( 6.2458E-02,-8.5710E-03),( 2.1882E-02,-8.5712E-03),
     &  ( 5.9107E-02,-8.5714E-03),( 5.7596E-02,-8.5716E-03),
     &  ( 5.6180E-02,-8.5719E-03),( 5.4851E-02,-8.5721E-03),
     &  ( 5.3600E-02,-8.5723E-03),( 5.2420E-02,-8.5725E-03),
     &  ( 5.1306E-02,-8.5728E-03),( 5.0252E-02,-8.5730E-03),
     &  ( 4.9253E-02,-8.5732E-03),( 4.8305E-02,-8.5735E-03),
     &  ( 4.7403E-02,-8.5737E-03),( 4.6546E-02,-8.5739E-03),
     &  ( 4.5729E-02,-8.5741E-03),( 4.4951E-02,-8.5744E-03),
     &  ( 4.4210E-02,-8.5746E-03),( 4.3509E-02,-8.5748E-03),
     &  ( 4.2846E-02,-8.5750E-03),( 4.2144E-02,-8.5753E-03),
     &  ( 4.1495E-02,-8.5755E-03),( 4.0876E-02,-8.5757E-03),
     &  ( 4.0283E-02,-8.5760E-03),( 3.9714E-02,-8.5762E-03),
     &  ( 3.9165E-02,-8.5764E-03),( 3.4961E-02,-8.5785E-03),
     &  ( 3.2292E-02,-8.5802E-03),( 2.9629E-02,-8.5822E-03),
     &  ( 2.6460E-02,-8.5853E-03),( 2.3148E-02,-8.5895E-03),
     &  ( 1.9095E-02,-8.5957E-03),( 1.7428E-02,-8.6008E-03),
     &  ( 1.5085E-02,-8.6048E-03),( 1.4218E-02,-8.6036E-03),
     &  ( 1.4627E-02,-8.6013E-03),( 1.4778E-02,-8.5990E-03),
     &  ( 1.4833E-02,-8.5967E-03),( 1.4842E-02,-8.5944E-03)/
  
         DATA ((CAS  (I,J), I=1501,1600), J=1,1) /
     &  ( 1.4797E-02,-8.5898E-03),( 1.4723E-02,-8.5852E-03),
     &  ( 1.4357E-02,-8.5622E-03),( 1.3914E-02,-8.5403E-03),
     &  ( 1.3587E-02,-8.5574E-03),( 1.3040E-02,-8.5136E-03),
     &  ( 1.2325E-02,-8.5416E-03),( 1.1480E-02,-8.5555E-03),
     &  ( 1.0383E-02,-8.5639E-03),( 8.8759E-03,-8.5695E-03),
     &  ( 5.1023E-03,-8.5653E-03),( 4.3868E-03,-8.5648E-03),
     &  ( 3.5442E-03,-8.5644E-03),( 3.3000E-03,-8.5643E-03),
     &  ( 2.7435E-03,-8.5641E-03),( 2.1251E-03,-8.5638E-03),
     &  ( 1.4340E-03,-8.5636E-03),( 6.5644E-04,-8.5634E-03),
     &  (-2.2482E-04,-8.5631E-03),(-1.2320E-03,-8.5629E-03),
     &  (-2.3943E-03,-8.5627E-03),(-3.7506E-03,-8.5624E-03),
     &  (-5.3537E-03,-8.5622E-03),(-7.2780E-03,-8.5620E-03),
     &  (-9.6310E-03,-8.5617E-03),(-1.2574E-02,-8.5615E-03),
     &  (-1.6362E-02,-8.5613E-03),(-2.1422E-02,-8.5610E-03),
     &  (-2.8534E-02,-8.5608E-03),(-3.9357E-02,-8.5606E-03),
     &  (-5.7011E-02,-9.2973E-03),(-9.2289E-02,-1.0218E-02),
     &  (-1.3968E-01,-1.2033E-02),(-1.4764E-01,-1.2403E-02),
     &  (-1.5646E-01,-1.2835E-02),(-1.6631E-01,-1.3345E-02),
     &  (-1.7737E-01,-1.3951E-02),(-1.8987E-01,-1.4679E-02),
     &  (-2.0412E-01,-1.5567E-02),(-2.2051E-01,-1.6662E-02),
     &  (-2.3956E-01,-1.8035E-02),(-2.6199E-01,-1.9789E-02),
     &  (-2.8876E-01,-2.2079E-02),(-3.2128E-01,-2.5148E-02),
     &  (-3.6161E-01,-2.9394E-02),(-4.1294E-01,-3.5501E-02),
     &  (-4.8045E-01,-4.4743E-02),(-5.7317E-01,-5.9691E-02),
     &  (-7.0828E-01,-8.6204E-02),(-9.2279E-01,-1.4010E-01),
     &  (-1.3121E+00,-2.7693E-01),(-2.1928E+00,-8.0779E-01),
     &  (-2.5014E+00,-1.0904E+00),(-2.6357E+00,-1.3644E+00),
     &  (-3.0136E+00,-1.7457E+00),(-3.2437E+00,-2.1634E+00),
     &  (-3.4103E+00,-2.5671E+00),(-2.9589E+00,-3.0705E+00),
     &  (-2.5966E+00,-3.4719E+00),(-3.9139E+00,-3.9322E+00),
     &  (-3.7823E+00,-4.4534E+00),(-2.5583E-01,-5.0317E+00),
     &  (-3.0862E+00,-5.4321E+00),(-3.0862E+00,-5.4949E+00),
     &  (-3.0862E+00,-5.5265E+00),(-3.0862E+00,-5.5897E+00),
     &  (-3.0862E+00,-5.6150E+00),(-3.0862E+00,-5.6340E+00),
     &  (-3.0862E+00,-5.6531E+00),(-2.9381E+00,-5.8440E+00),
     &  (-2.6991E+00,-6.1307E+00),(-2.4130E+00,-6.4447E+00),
     &  (-2.1405E+00,-6.7177E+00),(-2.2559E+00,-7.0028E+00),
     &  (-1.9130E+00,-7.2605E+00),(-1.5740E+00,-7.4616E+00),
     &  (-1.1843E+00,-7.5583E+00),(-1.1843E+00,-7.6430E+00),
     &  (-6.6481E-01,-7.7148E+00),(-6.6481E-01,-7.7922E+00),
     &  ( 4.0304E-02,-7.8301E+00),( 4.0304E-02,-7.8531E+00),
     &  ( 4.0647E-02,-7.8595E+00),( 4.0647E-02,-7.8604E+00),
     &  ( 4.0647E-02,-7.8606E+00),( 4.0647E-02,-7.8607E+00),
     &  ( 4.0647E-02,-7.8606E+00),( 4.0647E-02,-7.8604E+00),
     &  ( 4.0647E-02,-7.8531E+00),( 4.0989E-02,-7.8301E+00),
     &  ( 4.0989E-02,-7.7922E+00),( 1.6938E+00,-7.4198E+00),
     &  ( 2.0454E+00,-7.1867E+00),( 2.6417E+00,-6.6582E+00),
     &  ( 2.8725E+00,-6.3826E+00),( 3.0888E+00,-6.0672E+00),
     &  ( 3.2499E+00,-5.7485E+00),( 3.1645E+00,-5.4635E+00),
     &  ( 3.3671E+00,-5.1532E+00),( 3.5547E+00,-4.8823E+00)/
  
         DATA ((CAS  (I,J), I=1601,1700), J=1,1) /
     &  ( 3.6109E+00,-4.5930E+00),( 3.6427E+00,-4.3444E+00),
     &  ( 3.6527E+00,-4.0822E+00),( 3.6521E+00,-3.8593E+00),
     &  ( 3.6406E+00,-3.6261E+00),( 3.6224E+00,-3.4292E+00),
     &  ( 2.6342E+00,-3.0519E+00),( 3.5266E+00,-2.8730E+00),
     &  ( 3.4831E+00,-2.7067E+00),( 3.4400E+00,-2.5671E+00),
     &  ( 3.3318E+00,-2.3012E+00),( 3.2758E+00,-2.1755E+00),
     &  ( 3.1849E+00,-1.9926E+00),( 3.0396E+00,-1.7458E+00),
     &  ( 2.5291E+00,-1.0905E+00),( 2.1313E+00,-7.3712E-01),
     &  ( 1.8296E+00,-5.2927E-01),( 1.5981E+00,-3.9797E-01),
     &  ( 1.4164E+00,-3.1021E-01),( 1.2443E+00,-2.4884E-01),
     &  ( 1.0804E+00,-1.9512E-01),( 8.9805E-01,-1.2559E-01),
     &  ( 8.3658E-01,-1.0968E-01),( 7.8298E-01,-9.6789E-02),
     &  ( 7.3575E-01,-8.6211E-02),( 6.6593E-01,-7.1772E-02),
     &  ( 5.5358E-01,-5.1755E-02),( 4.7411E-01,-3.9925E-02),
     &  ( 4.1498E-01,-3.2361E-02),( 3.6928E-01,-2.7235E-02),
     &  ( 3.3291E-01,-2.3602E-02),( 3.0328E-01,-2.0934E-02),
     &  ( 2.7868E-01,-1.8917E-02),( 2.5793E-01,-1.7356E-02),
     &  ( 2.4019E-01,-1.6123E-02),( 2.2486E-01,-1.5132E-02),
     &  ( 2.1146E-01,-1.4324E-02),( 1.9967E-01,-1.3656E-02),
     &  ( 1.8920E-01,-1.3097E-02),( 1.7985E-01,-1.2626E-02),
     &  ( 1.7145E-01,-1.2225E-02),( 1.1990E-01,-1.0219E-02),
     &  ( 8.4571E-02,-9.2966E-03),( 6.6912E-02,-8.9737E-03),
     &  ( 4.9283E-02,-8.5582E-03),( 4.0327E-02,-8.5578E-03),
     &  ( 3.5012E-02,-8.5573E-03),( 3.1476E-02,-8.5568E-03),
     &  ( 2.8953E-02,-8.5563E-03),( 2.7062E-02,-8.5559E-03),
     &  ( 2.5591E-02,-8.5554E-03),( 2.4415E-02,-8.5549E-03),
     &  ( 2.3748E-02,-8.5546E-03),( 2.2969E-02,-8.5542E-03),
     &  ( 2.2303E-02,-8.5538E-03),( 2.1728E-02,-8.5533E-03),
     &  ( 2.1226E-02,-8.5529E-03),( 2.0783E-02,-8.5525E-03),
     &  ( 1.9180E-02,-8.5505E-03),( 1.8174E-02,-8.5484E-03),
     &  ( 1.7482E-02,-8.5464E-03),( 1.6977E-02,-8.5444E-03),
     &  ( 1.6590E-02,-8.5424E-03),( 1.6279E-02,-8.5403E-03),
     &  ( 1.6032E-02,-8.5383E-03),( 1.5827E-02,-8.5363E-03),
     &  ( 1.4113E-02,-8.5063E-03),( 1.3647E-02,-8.5124E-03),
     &  ( 1.3529E-02,-8.5136E-03),( 1.3391E-02,-8.5148E-03),
     &  ( 1.3226E-02,-8.5160E-03),( 1.3020E-02,-8.5172E-03),
     &  ( 1.2896E-02,-8.5178E-03),( 1.2752E-02,-8.5184E-03),
     &  ( 1.2380E-02,-8.5304E-03),( 1.1819E-02,-8.5423E-03),
     &  ( 1.0839E-02,-8.5542E-03),( 8.6075E-03,-8.5661E-03),
     &  ( 6.4754E-03,-8.5711E-03),( 5.9251E-03,-8.5720E-03),
     &  ( 5.2903E-03,-8.5729E-03),( 4.5501E-03,-8.5737E-03),
     &  ( 3.6754E-03,-8.5746E-03),( 2.6260E-03,-8.5755E-03),
     &  ( 1.3435E-03,-8.5764E-03),(-2.5986E-04,-8.5772E-03),
     &  (-2.3221E-03,-8.5781E-03),(-5.0745E-03,-8.5790E-03),
     &  (-8.9383E-03,-8.5799E-03),(-1.4758E-02,-8.6882E-03),
     &  (-2.4336E-02,-8.7726E-03),(-2.6006E-02,-8.7897E-03),
     &  (-2.7828E-02,-8.8092E-03),(-2.9824E-02,-8.8314E-03),
     &  (-3.2020E-02,-8.8571E-03),(-3.4455E-02,-8.8870E-03),
     &  (-3.7142E-02,-8.9219E-03),(-4.0157E-02,-8.9632E-03),
     &  (-4.3547E-02,-9.0124E-03),(-4.7390E-02,-9.0717E-03)/
  
         DATA ((CAS  (I,J), I=1701,1800), J=1,1) /
     &  (-5.1782E-02,-9.1442E-03),(-5.6849E-02,-9.2340E-03),
     &  (-6.2762E-02,-9.3472E-03),(-6.9749E-02,-9.4926E-03),
     &  (-7.8132E-02,-9.6837E-03),(-8.8378E-02,-9.9419E-03),
     &  (-9.1577E-02,-1.0028E-02),(-1.0119E-01,-1.0303E-02),
     &  (-1.1765E-01,-1.0829E-02),(-1.3959E-01,-1.1640E-02),
     &  (-1.7031E-01,-1.2985E-02),(-2.1635E-01,-1.5459E-02),
     &  (-2.9299E-01,-2.0799E-02),(-4.4576E-01,-3.6024E-02),
     &  (-8.9732E-01,-1.1736E-01),(-1.0695E+00,-1.6313E-01),
     &  (-1.5142E+00,-3.2167E-01),(-1.7324E+00,-4.8455E-01),
     &  (-2.1312E+00,-6.4978E-01),(-2.3740E+00,-8.2004E-01),
     &  (-2.5904E+00,-9.9439E-01),(-2.7866E+00,-1.1724E+00),
     &  (-2.9553E+00,-1.3515E+00),(-3.1933E+00,-1.5377E+00),
     &  (-3.2643E+00,-1.7350E+00),( 3.2008E-02,-1.9376E+00),
     &  (-3.5395E+00,-2.1379E+00),(-3.6542E+00,-2.3469E+00),
     &  (-3.7517E+00,-2.5611E+00),(-3.8323E+00,-2.7762E+00),
     &  (-2.6581E+00,-3.0150E+00),(-3.9672E+00,-3.2492E+00),
     &  (-4.0167E+00,-3.4726E+00),(-4.1014E+00,-3.7145E+00),
     &  (-4.1014E+00,-3.9759E+00),(-4.1319E+00,-4.2578E+00),
     &  (-4.1384E+00,-4.5162E+00),(-4.1384E+00,-4.7902E+00),
     &  (-3.8518E+00,-5.0795E+00),(-3.8518E+00,-5.3836E+00),
     &  (-3.6325E+00,-5.7011E+00),(-3.8211E+00,-5.9746E+00),
     &  (-3.8211E+00,-6.3111E+00),(-3.6531E+00,-6.6534E+00),
     &  (-3.1458E+00,-6.9967E+00),(-3.1458E+00,-7.3909E+00),
     &  (-2.7919E+00,-7.7680E+00),(-2.3238E+00,-8.1619E+00),
     &  (-1.7782E+00,-8.5338E+00),( 1.4086E-02,-8.9629E+00),
     &  ( 1.4086E-02,-8.9707E+00),( 8.2523E-01,-8.8848E+00),
     &  ( 1.8065E+00,-8.5339E+00),( 2.8276E+00,-8.1619E+00),
     &  ( 2.8276E+00,-7.7680E+00),( 3.1850E+00,-7.3909E+00),
     &  ( 2.9840E+00,-6.9967E+00),( 2.9840E+00,-6.6534E+00),
     &  ( 3.2678E+00,-6.3112E+00),( 3.7481E+00,-5.9746E+00),
     &  ( 3.7481E+00,-5.7011E+00),( 3.9807E+00,-5.3836E+00),
     &  ( 1.5882E+00,-5.0796E+00),( 1.5882E+00,-4.7902E+00),
     &  ( 1.8748E+00,-4.5162E+00),( 1.8748E+00,-4.2578E+00),
     &  ( 2.9855E-01,-3.9759E+00),( 2.2405E+00,-3.7145E+00),
     &  ( 2.6428E+00,-3.4726E+00),( 2.6428E+00,-3.2492E+00),
     &  ( 2.8888E+00,-3.0150E+00),( 3.1776E+00,-2.7762E+00),
     &  ( 3.4756E+00,-2.5611E+00),( 3.8100E+00,-2.3469E+00),
     &  ( 3.6101E+00,-2.1379E+00),( 3.3376E+00,-1.9376E+00),
     &  ( 3.0632E+00,-1.7350E+00),( 2.8190E+00,-1.5378E+00),
     &  ( 2.6361E+00,-1.3516E+00),( 1.0321E+00,-1.1724E+00),
     &  ( 2.6269E+00,-9.9441E-01),( 2.3984E+00,-8.2006E-01),
     &  ( 2.1610E+00,-6.4980E-01),( 1.8802E+00,-4.8457E-01),
     &  ( 1.5425E+00,-3.2168E-01),( 1.0977E+00,-1.6313E-01),
     &  ( 9.4194E-01,-1.2136E-01),( 9.1272E-01,-1.1429E-01),
     &  ( 6.1397E-01,-1.0584E-01),( 7.7640E-01,-8.4397E-02),
     &  ( 6.8622E-01,-6.7406E-02),( 4.7397E-01,-3.6024E-02),
     &  ( 3.2122E-01,-2.0802E-02),( 2.4458E-01,-1.5461E-02),
     &  ( 1.9853E-01,-1.2987E-02),( 1.6782E-01,-1.1643E-02),
     &  ( 1.4588E-01,-1.0832E-02),( 1.2941E-01,-1.0305E-02),
     &  ( 1.1661E-01,-9.9446E-03),( 1.0636E-01,-9.6865E-03)/
  
         DATA ((CAS  (I,J), I=1801,1900), J=1,1) /
     &  ( 9.7976E-02,-9.4955E-03),( 9.0989E-02,-9.3503E-03),
     &  ( 8.5077E-02,-9.2373E-03),( 8.0008E-02,-9.1477E-03),
     &  ( 7.5617E-02,-9.0754E-03),( 7.1773E-02,-9.0162E-03),
     &  ( 5.2556E-02,-8.7781E-03),( 4.2947E-02,-8.6953E-03),
     &  ( 3.7183E-02,-8.6575E-03),( 3.3347E-02,-8.6373E-03),
     &  ( 3.0594E-02,-8.5904E-03),( 2.8519E-02,-8.5912E-03),
     &  ( 2.6911E-02,-8.5921E-03),( 2.4576E-02,-8.5939E-03),
     &  ( 2.2959E-02,-8.5956E-03),( 2.2324E-02,-8.5965E-03),
     &  ( 2.1774E-02,-8.5973E-03),( 1.9792E-02,-8.6019E-03),
     &  ( 1.8339E-02,-8.6078E-03),( 1.7467E-02,-8.6138E-03),
     &  ( 1.6885E-02,-8.6198E-03),( 1.6466E-02,-8.6257E-03),
     &  ( 1.6150E-02,-8.6317E-03),( 1.5901E-02,-8.6376E-03),
     &  ( 1.5698E-02,-8.6380E-03),( 1.5529E-02,-8.6384E-03),
     &  ( 1.5245E-02,-8.6537E-03),( 1.5263E-02,-8.6544E-03),
     &  ( 1.5158E-02,-8.6551E-03),( 1.5062E-02,-8.6559E-03),
     &  ( 1.4975E-02,-8.6567E-03),( 1.4894E-02,-8.6574E-03),
     &  ( 1.4818E-02,-8.6582E-03),( 1.4746E-02,-8.6590E-03),
     &  ( 1.4676E-02,-8.6599E-03),( 1.4607E-02,-8.6607E-03),
     &  ( 1.4537E-02,-8.6616E-03),( 1.4458E-02,-8.6624E-03),
     &  ( 1.4405E-02,-8.7205E-03),( 1.3413E-02,-8.9270E-03),
     &  ( 1.3179E-02,-9.1278E-03),( 1.2883E-02,-9.3285E-03),
     &  ( 1.2648E-02,-9.5293E-03),( 1.2453E-02,-9.7301E-03),
     &  ( 1.2432E-02,-9.9308E-03),( 1.2161E-02,-1.0132E-02),
     &  ( 1.2035E-02,-1.0333E-02),( 1.1936E-02,-1.0533E-02),
     &  ( 1.1853E-02,-1.0733E-02),( 1.1784E-02,-1.0933E-02),
     &  ( 1.1759E-02,-1.1132E-02),( 1.1687E-02,-1.1330E-02),
     &  ( 1.1657E-02,-1.1527E-02),( 1.1639E-02,-1.1724E-02),
     &  ( 1.1632E-02,-1.1921E-02),( 1.1637E-02,-1.2113E-02),
     &  ( 1.1652E-02,-1.2305E-02),( 1.1679E-02,-1.2500E-02),
     &  ( 1.1709E-02,-1.2690E-02),( 1.1762E-02,-1.2875E-02),
     &  ( 1.1822E-02,-1.3066E-02),( 1.1891E-02,-1.3247E-02),
     &  ( 1.1974E-02,-1.3431E-02),( 1.2069E-02,-1.3611E-02),
     &  ( 1.2179E-02,-1.3791E-02),( 1.2304E-02,-1.3968E-02),
     &  ( 1.2445E-02,-1.4141E-02),( 1.2602E-02,-1.4307E-02),
     &  ( 1.2787E-02,-1.4475E-02),( 1.2999E-02,-1.4636E-02),
     &  ( 1.3244E-02,-1.4788E-02),( 1.3549E-02,-1.4935E-02),
     &  ( 1.3953E-02,-1.5066E-02),( 1.4939E-02,-1.5123E-02),
     &  ( 1.5872E-02,-1.4838E-02),( 1.6224E-02,-1.4626E-02),
     &  ( 1.6479E-02,-1.4426E-02),( 1.6676E-02,-1.4237E-02),
     &  ( 1.6842E-02,-1.4049E-02),( 1.6982E-02,-1.3862E-02),
     &  ( 1.7097E-02,-1.3684E-02),( 1.7197E-02,-1.3504E-02),
     &  ( 1.7283E-02,-1.3325E-02),( 1.7356E-02,-1.3148E-02),
     &  ( 1.7422E-02,-1.2973E-02),( 1.7466E-02,-1.2798E-02),
     &  ( 1.7506E-02,-1.2627E-02),( 1.7536E-02,-1.2451E-02),
     &  ( 1.7557E-02,-1.2281E-02),( 1.7570E-02,-1.2108E-02),
     &  ( 1.7574E-02,-1.1934E-02),( 1.7569E-02,-1.1762E-02),
     &  ( 1.7556E-02,-1.1592E-02),( 1.7533E-02,-1.1419E-02),
     &  ( 1.7501E-02,-1.1245E-02),( 1.7460E-02,-1.1073E-02),
     &  ( 1.7410E-02,-1.0901E-02),( 1.7332E-02,-1.0727E-02),
     &  ( 1.7244E-02,-1.0553E-02),( 1.7146E-02,-1.0380E-02)/
  
         DATA ((CAS  (I,J), I=1901,2000), J=1,1) /
     &  ( 1.7093E-02,-1.0204E-02),( 1.6979E-02,-1.0028E-02),
     &  ( 1.6847E-02,-9.8518E-03),( 1.6690E-02,-9.6748E-03),
     &  ( 1.6509E-02,-9.4968E-03),( 1.6288E-02,-9.3177E-03),
     &  ( 1.6011E-02,-9.1380E-03),( 1.5635E-02,-8.9658E-03),
     &  ( 1.4974E-02,-8.7628E-03),( 1.4939E-02,-8.7663E-03),
     &  ( 1.4745E-02,-8.7986E-03),( 1.4688E-02,-8.8305E-03),
     &  ( 1.4570E-02,-8.8619E-03),( 1.4514E-02,-8.8931E-03),
     &  ( 1.4469E-02,-8.9242E-03),( 1.4431E-02,-8.9551E-03),
     &  ( 1.4399E-02,-8.9860E-03),( 1.4372E-02,-9.0168E-03),
     &  ( 1.4336E-02,-9.0475E-03),( 1.4328E-02,-9.0783E-03),
     &  ( 1.4310E-02,-9.1089E-03),( 1.4295E-02,-9.1396E-03),
     &  ( 1.4281E-02,-9.1702E-03),( 1.4271E-02,-9.2009E-03),
     &  ( 1.4263E-02,-9.2315E-03),( 1.4256E-02,-9.2621E-03),
     &  ( 1.4251E-02,-9.2928E-03),( 1.4247E-02,-9.3234E-03),
     &  ( 1.4223E-02,-9.3542E-03),( 1.4225E-02,-9.3849E-03),
     &  ( 1.4247E-02,-9.4157E-03),( 1.4250E-02,-9.4465E-03),
     &  ( 1.4256E-02,-9.4772E-03),( 1.4263E-02,-9.5081E-03),
     &  ( 1.4273E-02,-9.5391E-03),( 1.4284E-02,-9.5700E-03),
     &  ( 1.4298E-02,-9.6011E-03),( 1.4314E-02,-9.6323E-03),
     &  ( 1.4334E-02,-9.6635E-03),( 1.4357E-02,-9.6950E-03),
     &  ( 1.4385E-02,-9.7266E-03),( 1.4415E-02,-9.7585E-03),
     &  ( 1.4461E-02,-9.7909E-03),( 1.4520E-02,-9.8241E-03),
     &  ( 1.4672E-02,-9.8624E-03),( 1.4786E-02,-9.8472E-03),
     &  ( 1.4861E-02,-9.8275E-03),( 1.4900E-02,-9.8071E-03),
     &  ( 1.4932E-02,-9.7864E-03),( 1.4959E-02,-9.7654E-03),
     &  ( 1.4982E-02,-9.7443E-03),( 1.5003E-02,-9.7231E-03),
     &  ( 1.5020E-02,-9.7018E-03),( 1.5036E-02,-9.6805E-03),
     &  ( 1.5050E-02,-9.6592E-03),( 1.5062E-02,-9.6378E-03),
     &  ( 1.5072E-02,-9.6165E-03),( 1.5081E-02,-9.5953E-03),
     &  ( 1.5089E-02,-9.5740E-03),( 1.5096E-02,-9.5527E-03),
     &  ( 1.5101E-02,-9.5316E-03),( 1.5105E-02,-9.5105E-03),
     &  ( 1.5108E-02,-9.4894E-03),( 1.5110E-02,-9.4686E-03),
     &  ( 1.5114E-02,-9.4478E-03),( 1.5111E-02,-9.4273E-03),
     &  ( 1.5110E-02,-9.4067E-03),( 1.5107E-02,-9.3865E-03),
     &  ( 1.5104E-02,-9.3665E-03),( 1.5100E-02,-9.3468E-03),
     &  ( 1.5094E-02,-9.3274E-03),( 1.5087E-02,-9.3084E-03),
     &  ( 1.5079E-02,-9.2898E-03),( 1.5069E-02,-9.2719E-03),
     &  ( 1.5058E-02,-9.2546E-03),( 1.5057E-02,-9.2381E-03),
     &  ( 1.5045E-02,-9.2227E-03),( 1.5030E-02,-9.2087E-03),
     &  ( 1.5013E-02,-9.1964E-03),( 1.4980E-02,-9.1864E-03),
     &  ( 1.4833E-02,-9.2079E-03),( 1.4857E-02,-9.2138E-03),
     &  ( 1.4852E-02,-9.2199E-03),( 1.4848E-02,-9.2263E-03),
     &  ( 1.4844E-02,-9.2330E-03),( 1.4841E-02,-9.2398E-03),
     &  ( 1.4838E-02,-9.2468E-03),( 1.4836E-02,-9.2539E-03),
     &  ( 1.4834E-02,-9.2613E-03),( 1.4832E-02,-9.2687E-03),
     &  ( 1.4829E-02,-9.2763E-03),( 1.4828E-02,-9.2841E-03),
     &  ( 1.4828E-02,-9.2919E-03),( 1.4782E-02,-9.2998E-03),
     &  ( 1.4783E-02,-9.3078E-03),( 1.4784E-02,-9.3159E-03),
     &  ( 1.4830E-02,-9.3240E-03),( 1.4831E-02,-9.3322E-03),
     &  ( 1.4833E-02,-9.3405E-03),( 1.4836E-02,-9.3488E-03)/
  
         DATA ((CAS  (I,J), I=2001,2100), J=1,1) /
     &  ( 1.4839E-02,-9.3572E-03),( 1.4842E-02,-9.3656E-03),
     &  ( 1.4846E-02,-9.3740E-03),( 1.4851E-02,-9.3825E-03),
     &  ( 1.4856E-02,-9.3910E-03),( 1.4862E-02,-9.3996E-03),
     &  ( 1.4869E-02,-9.4080E-03),( 1.4877E-02,-9.4165E-03),
     &  ( 1.4885E-02,-9.4250E-03),( 1.4895E-02,-9.4335E-03),
     &  ( 1.4906E-02,-9.4419E-03),( 1.4919E-02,-9.4502E-03),
     &  ( 1.4934E-02,-9.4584E-03),( 1.4953E-02,-9.4664E-03),
     &  ( 1.4979E-02,-9.4738E-03),( 1.5045E-02,-9.4778E-03),
     &  ( 1.5110E-02,-9.4615E-03),( 1.5136E-02,-9.4488E-03),
     &  ( 1.5167E-02,-9.4366E-03),( 1.5186E-02,-9.4247E-03),
     &  ( 1.5202E-02,-9.4129E-03),( 1.5189E-02,-9.4013E-03),
     &  ( 1.5200E-02,-9.3897E-03),( 1.5209E-02,-9.3782E-03),
     &  ( 1.5217E-02,-9.3667E-03),( 1.5225E-02,-9.3554E-03),
     &  ( 1.5232E-02,-9.3440E-03),( 1.5238E-02,-9.3326E-03),
     &  ( 1.5244E-02,-9.3213E-03),( 1.5249E-02,-9.3100E-03),
     &  ( 1.5253E-02,-9.2987E-03),( 1.5258E-02,-9.2873E-03),
     &  ( 1.5261E-02,-9.2760E-03),( 1.5265E-02,-9.2648E-03),
     &  ( 1.5268E-02,-9.2534E-03),( 1.5270E-02,-9.2422E-03),
     &  ( 1.5272E-02,-9.2309E-03),( 1.5274E-02,-9.2196E-03),
     &  ( 1.5275E-02,-9.2084E-03),( 1.5276E-02,-9.1970E-03),
     &  ( 1.5277E-02,-9.1857E-03),( 1.5277E-02,-9.1743E-03),
     &  ( 1.5277E-02,-9.1630E-03),( 1.5277E-02,-9.1516E-03),
     &  ( 1.5276E-02,-9.1403E-03),( 1.5275E-02,-9.1289E-03),
     &  ( 1.5275E-02,-9.1175E-03),( 1.5273E-02,-9.1061E-03),
     &  ( 1.5271E-02,-9.0946E-03),( 1.5268E-02,-9.0832E-03),
     &  ( 1.5265E-02,-9.0717E-03),( 1.5245E-02,-9.0197E-03),
     &  ( 1.5163E-02,-8.9087E-03),( 1.5071E-02,-8.8446E-03),
     &  ( 1.5038E-02,-8.8082E-03),( 1.4984E-02,-8.7839E-03),
     &  ( 1.4940E-02,-8.7683E-03),( 1.4897E-02,-8.7567E-03),
     &  ( 1.4860E-02,-8.7487E-03),( 1.4823E-02,-8.7426E-03),
     &  ( 1.4789E-02,-8.7379E-03),( 1.4754E-02,-8.7346E-03),
     &  ( 1.4718E-02,-8.7319E-03),( 1.4682E-02,-8.7300E-03),
     &  ( 1.4683E-02,-8.7285E-03),( 1.4684E-02,-8.7274E-03),
     &  ( 1.4685E-02,-8.7266E-03),( 1.4686E-02,-8.7068E-03),
     &  ( 1.4687E-02,-8.7081E-03),( 1.4688E-02,-8.7093E-03),
     &  ( 1.4688E-02,-8.7105E-03),( 1.4689E-02,-9.5209E-03),
     &  ( 1.4690E-02,-9.5203E-03),( 1.4691E-02,-9.5196E-03),
     &  ( 1.4692E-02,-9.5190E-03),( 1.4693E-02,-9.5184E-03),
     &  ( 1.4694E-02,-9.5178E-03),( 1.4695E-02,-9.5172E-03),
     &  ( 1.4735E-02,-9.5166E-03),( 1.4772E-02,-9.5160E-03),
     &  ( 1.4805E-02,-9.5155E-03),( 1.4836E-02,-9.5149E-03),
     &  ( 1.4865E-02,-9.5143E-03),( 1.4893E-02,-9.5137E-03),
     &  ( 1.4918E-02,-9.5131E-03),( 1.4943E-02,-9.5126E-03),
     &  ( 1.4967E-02,-9.5120E-03),( 1.4989E-02,-9.5114E-03),
     &  ( 1.5012E-02,-9.5108E-03),( 1.5033E-02,-9.5103E-03),
     &  ( 1.5054E-02,-9.5097E-03),( 1.5073E-02,-9.5092E-03),
     &  ( 1.5093E-02,-9.5086E-03),( 1.5112E-02,-9.5081E-03),
     &  ( 1.5131E-02,-9.5075E-03),( 1.5149E-02,-9.5070E-03),
     &  ( 1.5167E-02,-9.5064E-03),( 1.5185E-02,-9.5059E-03),
     &  ( 1.5202E-02,-9.5054E-03),( 1.5219E-02,-9.5049E-03)/
  
         DATA ((CAS  (I,J), I=2101,2193), J=1,1) /
     &  ( 1.5236E-02,-9.5043E-03),( 1.5253E-02,-9.5038E-03),
     &  ( 1.5269E-02,-9.5033E-03),( 1.5285E-02,-9.5027E-03),
     &  ( 1.5301E-02,-9.5022E-03),( 1.5317E-02,-9.5017E-03),
     &  ( 1.5332E-02,-9.5012E-03),( 1.5348E-02,-9.5007E-03),
     &  ( 1.5363E-02,-9.5002E-03),( 1.5378E-02,-9.4997E-03),
     &  ( 1.5393E-02,-9.4991E-03),( 1.5408E-02,-9.4986E-03),
     &  ( 1.5423E-02,-9.4981E-03),( 1.5437E-02,-9.4976E-03),
     &  ( 1.5452E-02,-9.4971E-03),( 1.5466E-02,-9.4967E-03),
     &  ( 1.5480E-02,-9.4962E-03),( 1.5494E-02,-9.4957E-03),
     &  ( 1.5509E-02,-9.4952E-03),( 1.5522E-02,-9.4947E-03),
     &  ( 1.5536E-02,-9.4942E-03),( 1.5550E-02,-9.4937E-03),
     &  ( 1.5563E-02,-9.4933E-03),( 1.5577E-02,-9.4928E-03),
     &  ( 1.5590E-02,-9.4923E-03),( 1.5604E-02,-9.4918E-03),
     &  ( 1.5617E-02,-9.4914E-03),( 1.5628E-02,-9.4909E-03),
     &  ( 1.5641E-02,-9.4904E-03),( 1.5654E-02,-9.4899E-03),
     &  ( 1.5667E-02,-9.4895E-03),( 1.5680E-02,-9.4890E-03),
     &  ( 1.5693E-02,-9.4886E-03),( 1.5706E-02,-9.4881E-03),
     &  ( 1.5719E-02,-9.4876E-03),( 1.5732E-02,-9.4872E-03),
     &  ( 1.5744E-02,-9.4867E-03),( 1.5757E-02,-9.4863E-03),
     &  ( 1.5771E-02,-9.4858E-03),( 1.5784E-02,-9.4854E-03),
     &  ( 1.5798E-02,-9.4849E-03),( 1.5812E-02,-9.4845E-03),
     &  ( 1.5826E-02,-9.4840E-03),( 1.5839E-02,-9.4836E-03),
     &  ( 1.5853E-02,-9.4832E-03),( 1.5866E-02,-9.4827E-03),
     &  ( 1.5880E-02,-9.4823E-03),( 1.5894E-02,-9.4819E-03),
     &  ( 1.5907E-02,-9.4814E-03),( 1.5921E-02,-9.4810E-03),
     &  ( 1.5935E-02,-9.4806E-03),( 1.5949E-02,-9.4802E-03),
     &  ( 1.5962E-02,-9.4797E-03),( 1.5976E-02,-9.4793E-03),
     &  ( 1.5989E-02,-9.4789E-03),( 1.6003E-02,-9.4785E-03),
     &  ( 1.6017E-02,-9.4781E-03),( 1.6031E-02,-9.4776E-03),
     &  ( 1.6044E-02,-9.4772E-03),( 1.6058E-02,-9.4768E-03),
     &  ( 1.6165E-02,-9.4723E-03),( 1.6271E-02,-9.4680E-03),
     &  ( 1.6290E-02,-9.4674E-03),( 1.7145E-02,-9.4393E-03),
     &  ( 1.7530E-02,-9.4279E-03),( 1.8541E-02,-9.4013E-03),
     &  ( 1.9213E-02,-9.3882E-03),( 1.9241E-02,-9.3876E-03),
     &  ( 1.9899E-02,-9.3721E-03),( 1.9901E-02,-9.3720E-03),
     &  ( 2.0473E-02,-9.3615E-03),( 2.0495E-02,-9.3611E-03),
     &  ( 2.0509E-02,-9.3608E-03),( 2.0794E-02,-9.3559E-03),
     &  ( 2.0983E-02,-9.3528E-03),( 2.1017E-02,-9.3522E-03),
     &  ( 2.1072E-02,-9.3513E-03),( 2.1155E-02,-9.3500E-03),
     &  ( 2.1213E-02,-9.3490E-03),( 2.1249E-02,-9.3485E-03),
     &  ( 2.1604E-02,-9.3429E-03),( 2.1622E-02,-9.3427E-03),
     &  ( 2.1729E-02,-9.3411E-03),( 2.1749E-02,-9.3408E-03),
     &  ( 2.1851E-02,-9.3395E-03),( 2.1891E-02,-9.3390E-03),
     &  ( 2.1924E-02,-9.3386E-03),( 2.1953E-02,-9.3382E-03),
     &  ( 2.2013E-02,-9.3371E-03),( 2.2104E-02,-9.3355E-03),
     &  ( 2.2150E-02,-9.3349E-03),( 2.2455E-02,-9.3306E-03),
     &  ( 2.2717E-02,-9.3270E-03)/
  
         DATA ((CAS  (I,J), I=   1, 100), J=2,2) /
     &  ( 1.0830E-06, 0.0000E+00),( 1.1710E-06, 3.1386E-08),
     &  ( 1.2807E-06, 1.9729E-07),( 1.4248E-06, 4.6112E-07),
     &  ( 1.6335E-06, 8.7973E-07),( 1.8597E-06, 1.4178E-06),
     &  ( 2.5577E-06, 2.0754E-06),( 2.1428E-06, 5.6641E-06),
     &  ( 2.3037E-06, 6.0116E-06),( 2.5091E-06, 6.3973E-06),
     &  ( 2.6371E-06, 6.7622E-06),( 2.9080E-06, 7.6622E-06),
     &  ( 2.9983E-06, 8.3920E-06),( 3.1106E-06, 9.0001E-06),
     &  ( 3.1732E-06, 1.0824E-05),( 3.3172E-06, 1.1043E-05),
     &  ( 3.4922E-06, 9.7785E-06),( 3.6924E-06, 1.0557E-05),
     &  ( 3.7661E-06, 1.1189E-05),( 3.7999E-06, 1.1676E-05),
     &  ( 3.8879E-06, 1.2065E-05),( 4.0270E-06, 1.2114E-05),
     &  ( 4.1387E-06, 1.1919E-05),( 4.2296E-06, 1.2308E-05),
     &  ( 4.3239E-06, 1.3184E-05),( 4.4827E-06, 1.3184E-05),
     &  ( 4.6446E-06, 1.3427E-05),( 4.7338E-06, 1.3559E-05),
     &  ( 4.7618E-06, 1.3865E-05),( 4.9020E-06, 1.3865E-05),
     &  ( 5.0820E-06, 1.4838E-05),( 5.1399E-06, 1.4351E-05),
     &  ( 5.3169E-06, 1.4643E-05),( 5.4945E-06, 1.5568E-05),
     &  ( 5.6692E-06, 1.6054E-05),( 5.8668E-06, 1.6735E-05),
     &  ( 6.0921E-06, 1.6638E-05),( 6.4024E-06, 1.6541E-05),
     &  ( 6.6803E-06, 1.7270E-05),( 6.9653E-06, 1.7854E-05),
     &  ( 7.2702E-06, 1.8292E-05),( 7.6229E-06, 1.8876E-05),
     &  ( 8.0525E-06, 1.9703E-05),( 8.4617E-06, 2.0287E-05),
     &  ( 9.1253E-06, 2.0724E-05),( 1.0138E-05, 2.1284E-05),
     &  ( 1.0996E-05, 2.1649E-05),( 1.1277E-05, 2.2135E-05),
     &  ( 1.1216E-05, 2.1430E-05),( 1.0930E-05, 2.1527E-05),
     &  ( 1.3041E-05, 2.6757E-05),( 1.5487E-05, 2.9433E-05),
     &  ( 1.7127E-05, 3.4298E-05),( 1.7296E-05, 3.5271E-05),
     &  ( 1.9129E-05, 3.3811E-05),( 1.9688E-05, 3.2595E-05),
     &  ( 1.7939E-05, 3.4784E-05),( 1.6469E-05, 3.6292E-05),
     &  ( 1.6064E-05, 3.6681E-05),( 1.6290E-05, 3.7533E-05),
     &  ( 1.6968E-05, 3.8992E-05),( 1.6923E-05, 4.0889E-05),
     &  ( 1.7351E-05, 4.1498E-05),( 1.7341E-05, 4.3711E-05),
     &  ( 1.8028E-05, 4.5025E-05),( 1.8515E-05, 4.8819E-05),
     &  ( 1.9434E-05, 5.1811E-05),( 2.1137E-05, 5.4827E-05),
     &  ( 2.1828E-05, 5.4852E-05),( 2.2110E-05, 5.5849E-05),
     &  ( 2.3552E-05, 5.8902E-05),( 2.2863E-05, 6.0690E-05),
     &  ( 2.3593E-05, 6.4071E-05),( 2.4894E-05, 6.7914E-05),
     &  ( 2.6477E-05, 7.2219E-05),( 2.7603E-05, 7.8544E-05),
     &  ( 2.8515E-05, 8.6157E-05),( 3.0785E-05, 8.9903E-05),
     &  ( 3.3840E-05, 9.5401E-05),( 6.2504E-05, 9.5085E-05),
     &  ( 5.8396E-05, 9.5157E-05),( 6.2647E-05, 9.5228E-05),
     &  ( 6.3033E-05, 9.3063E-05),( 6.4320E-05, 9.2402E-05),
     &  ( 6.7745E-05, 9.2219E-05),( 7.9505E-05, 9.3864E-05),
     &  ( 9.7627E-05, 9.4359E-05),( 1.0366E-04, 9.6998E-05),
     &  ( 1.1651E-04, 1.0061E-04),( 1.2563E-04, 1.0488E-04),
     &  ( 1.3494E-04, 1.0907E-04),( 1.4322E-04, 1.1622E-04),
     &  ( 1.5038E-04, 1.2667E-04),( 1.5288E-04, 1.3691E-04),
     &  ( 1.5486E-04, 1.4673E-04),( 1.5778E-04, 1.6238E-04),
     &  ( 1.5552E-04, 1.6804E-04),( 1.5323E-04, 1.7395E-04),
     &  ( 1.5004E-04, 1.8253E-04),( 1.4546E-04, 1.9608E-04)/
  
         DATA ((CAS  (I,J), I= 101, 200), J=2,2) /
     &  ( 1.3938E-04, 2.0990E-04),( 1.3216E-04, 2.2310E-04),
     &  ( 1.1914E-04, 2.3623E-04),( 1.0363E-04, 2.4217E-04),
     &  ( 9.1602E-05, 2.4411E-04),( 8.2317E-05, 2.4606E-04),
     &  ( 7.3217E-05, 2.4794E-04),( 6.4302E-05, 2.4992E-04),
     &  ( 5.5553E-05, 2.5176E-04),( 4.7906E-05, 2.5359E-04),
     &  ( 4.0685E-05, 2.5543E-04),( 3.6632E-05, 2.5745E-04),
     &  ( 3.2455E-05, 2.5930E-04),( 2.8050E-05, 2.5450E-04),
     &  ( 3.6774E-05, 2.4386E-04),( 4.5382E-05, 2.3180E-04),
     &  ( 5.3216E-05, 2.1706E-04),( 5.3640E-05, 1.8286E-04),
     &  ( 4.2176E-05, 1.7533E-04),( 3.9187E-05, 1.8040E-04),
     &  ( 4.0008E-05, 1.8452E-04),( 4.2140E-05, 1.8827E-04),
     &  ( 4.5263E-05, 1.9170E-04),( 4.9784E-05, 1.9495E-04),
     &  ( 5.5633E-05, 1.9829E-04),( 6.4983E-05, 2.0136E-04),
     &  ( 7.4241E-05, 1.9761E-04),( 8.1484E-05, 1.9385E-04),
     &  ( 8.6321E-05, 1.9030E-04),( 9.1482E-05, 1.8651E-04),
     &  ( 9.5975E-05, 1.8241E-04),( 1.0018E-04, 1.7865E-04),
     &  ( 1.0446E-04, 1.7453E-04),( 1.1421E-04, 1.7027E-04),
     &  ( 1.1346E-04, 1.6601E-04),( 1.1727E-04, 1.6113E-04),
     &  ( 1.0297E-04, 1.5504E-04),( 1.2460E-04, 1.4892E-04),
     &  ( 1.2667E-04, 1.4431E-04),( 1.2845E-04, 1.3990E-04),
     &  ( 1.2978E-04, 1.3496E-04),( 1.3110E-04, 1.2751E-04),
     &  ( 1.3151E-04, 1.1954E-04),( 1.3034E-04, 1.1166E-04),
     &  ( 1.2999E-04, 1.0363E-04),( 1.2575E-04, 9.4807E-05),
     &  ( 1.1918E-04, 8.5454E-05),( 1.1019E-04, 8.0649E-05),
     &  ( 1.0312E-04, 7.6769E-05),( 8.5825E-05, 7.1869E-05),
     &  ( 8.5231E-05, 6.8589E-05),( 7.2521E-05, 6.6308E-05),
     &  ( 7.0834E-05, 6.5364E-05),( 6.2912E-05, 6.2991E-05),
     &  ( 5.4990E-05, 6.2647E-05),( 4.9311E-05, 6.1603E-05),
     &  ( 4.5865E-05, 5.9018E-05),( 4.3236E-05, 5.7837E-05),
     &  ( 3.8584E-05, 5.8014E-05),( 3.6066E-05, 5.6871E-05),
     &  ( 3.4340E-05, 5.5886E-05),( 3.1698E-05, 5.1945E-05),
     &  ( 3.0790E-05, 5.1386E-05),( 2.9377E-05, 5.1106E-05),
     &  ( 2.8289E-05, 5.0084E-05),( 2.7316E-05, 4.8600E-05),
     &  ( 2.6641E-05, 4.7688E-05),( 2.6140E-05, 4.7676E-05),
     &  ( 2.3979E-05, 4.3614E-05),( 2.2602E-05, 4.1352E-05),
     &  ( 2.1957E-05, 3.8238E-05),( 2.1323E-05, 3.7995E-05),
     &  ( 2.0517E-05, 3.4687E-05),( 1.9786E-05, 3.2984E-05),
     &  ( 1.9293E-05, 3.0454E-05),( 1.8957E-05, 2.9116E-05),
     &  ( 1.8642E-05, 2.8289E-05),( 1.8382E-05, 2.8289E-05),
     &  ( 1.8463E-05, 2.7243E-05),( 1.8421E-05, 2.6538E-05),
     &  ( 1.8481E-05, 2.5297E-05),( 1.8530E-05, 2.4495E-05),
     &  ( 1.8678E-05, 2.3838E-05),( 1.8888E-05, 2.2573E-05),
     &  ( 1.9331E-05, 2.5225E-05),( 1.9794E-05, 2.5735E-05),
     &  ( 2.0625E-05, 2.4884E-05),( 2.1352E-05, 2.3765E-05),
     &  ( 2.2508E-05, 2.3376E-05),( 2.3813E-05, 2.2257E-05),
     &  ( 2.4684E-05, 2.4714E-05),( 2.5338E-05, 2.4738E-05),
     &  ( 2.6909E-05, 2.4179E-05),( 2.7747E-05, 2.3704E-05),
     &  ( 2.8495E-05, 2.1916E-05),( 2.9643E-05, 2.0870E-05),
     &  ( 3.1266E-05, 2.7085E-05),( 3.3511E-05, 2.9189E-05),
     &  ( 3.5172E-05, 2.9506E-05),( 3.6601E-05, 4.9865E-05)/
  
         DATA ((CAS  (I,J), I= 201, 300), J=2,2) /
     &  ( 3.8365E-05, 5.1738E-05),( 4.0241E-05, 4.9768E-05),
     &  ( 4.1009E-05, 4.8133E-05),( 4.1834E-05, 4.6664E-05),
     &  ( 4.2714E-05, 4.5319E-05),( 4.3649E-05, 4.3974E-05),
     &  ( 4.4636E-05, 4.4216E-05),( 4.5630E-05, 4.5093E-05),
     &  ( 4.6596E-05, 4.5970E-05),( 4.7621E-05, 4.5336E-05),
     &  ( 4.8707E-05, 4.4451E-05),( 4.9862E-05, 4.3565E-05),
     &  ( 5.1082E-05, 4.3701E-05),( 5.2309E-05, 4.3740E-05),
     &  ( 5.3582E-05, 4.3784E-05),( 5.4961E-05, 4.4295E-05),
     &  ( 5.6407E-05, 4.4806E-05),( 5.7946E-05, 4.4803E-05),
     &  ( 5.9604E-05, 4.3518E-05),( 6.1392E-05, 4.2232E-05),
     &  ( 6.3324E-05, 4.1567E-05),( 6.5423E-05, 4.1729E-05),
     &  ( 6.7704E-05, 4.1890E-05),( 7.0207E-05, 4.2407E-05),
     &  ( 7.2961E-05, 4.3191E-05),( 7.6020E-05, 4.3974E-05),
     &  ( 7.9430E-05, 4.5742E-05),( 8.3299E-05, 4.8436E-05),
     &  ( 8.7750E-05, 5.2460E-05),( 9.3436E-05, 5.6484E-05),
     &  ( 9.7139E-05, 5.8209E-05),( 9.8001E-05, 5.6716E-05),
     &  ( 1.0027E-04, 5.6601E-05),( 1.0449E-04, 5.6501E-05),
     &  ( 1.0774E-04, 5.6640E-05),( 1.1245E-04, 5.6952E-05),
     &  ( 1.1767E-04, 5.7549E-05),( 1.2234E-04, 5.8354E-05),
     &  ( 1.2662E-04, 5.9563E-05),( 1.3289E-04, 6.1731E-05),
     &  ( 1.3773E-04, 6.5809E-05),( 1.4099E-04, 7.0247E-05),
     &  ( 1.4653E-04, 7.5613E-05),( 1.4710E-04, 8.1934E-05),
     &  ( 1.4766E-04, 8.8425E-05),( 1.4736E-04, 9.3164E-05),
     &  ( 1.4565E-04, 9.8021E-05),( 1.4474E-04, 9.6137E-05),
     &  ( 1.5115E-04, 9.1051E-05),( 1.7489E-04, 8.6096E-05),
     &  ( 2.0507E-04, 8.1293E-05),( 2.3945E-04, 1.0834E-04),
     &  ( 2.6094E-04, 1.4528E-04),( 2.7470E-04, 1.8472E-04),
     &  ( 2.7364E-04, 1.9171E-04),( 2.8086E-04, 1.9873E-04),
     &  ( 2.9095E-04, 2.1071E-04),( 3.0366E-04, 2.2582E-04),
     &  ( 2.9740E-04, 2.4741E-04),( 3.1319E-04, 2.6933E-04),
     &  ( 3.2338E-04, 2.9107E-04),( 3.2202E-04, 3.1287E-04),
     &  ( 3.3181E-04, 3.4145E-04),( 3.3059E-04, 3.9226E-04),
     &  ( 3.0839E-04, 4.4320E-04),( 2.7375E-04, 4.7413E-04),
     &  ( 2.1726E-04, 5.0823E-04),( 1.8165E-04, 5.2347E-04),
     &  ( 1.6558E-04, 5.1548E-04),( 1.4479E-04, 5.2588E-04),
     &  ( 1.1850E-04, 5.3508E-04),( 8.8870E-05, 5.4233E-04),
     &  ( 6.4140E-05, 5.3675E-04),( 5.7573E-05, 5.3215E-04),
     &  ( 5.0432E-05, 5.6435E-04),( 1.6862E-05, 6.1743E-04),
     &  ( 8.3952E-05, 6.0603E-04),( 1.3352E-04, 5.6506E-04),
     &  ( 1.5420E-04, 5.4397E-04),( 1.8009E-04, 5.2265E-04),
     &  ( 2.0485E-04, 5.0158E-04),( 2.2521E-04, 4.7785E-04),
     &  ( 2.4288E-04, 4.5535E-04),( 2.5892E-04, 4.3334E-04),
     &  ( 2.7456E-04, 4.1111E-04),( 2.9249E-04, 3.8913E-04),
     &  ( 3.0741E-04, 3.5343E-04),( 2.9806E-04, 3.1900E-04),
     &  ( 3.0370E-04, 2.8634E-04),( 2.9074E-04, 2.6382E-04),
     &  ( 2.7967E-04, 2.4971E-04),( 2.6861E-04, 2.3467E-04),
     &  ( 2.6261E-04, 2.2466E-04),( 2.5777E-04, 2.1967E-04),
     &  ( 2.5352E-04, 2.0969E-04),( 2.5242E-04, 2.0234E-04),
     &  ( 2.4875E-04, 1.9618E-04),( 2.4619E-04, 1.9003E-04),
     &  ( 2.4425E-04, 1.8412E-04),( 2.4268E-04, 1.7800E-04)/
  
         DATA ((CAS  (I,J), I= 301, 400), J=2,2) /
     &  ( 2.3463E-04, 1.7212E-04),( 2.4171E-04, 1.6603E-04),
     &  ( 2.3953E-04, 1.6018E-04),( 2.3905E-04, 1.5413E-04),
     &  ( 2.3539E-04, 1.3126E-04),( 2.2927E-04, 1.0903E-04),
     &  ( 2.1891E-04, 8.7914E-05),( 2.1148E-04, 7.0883E-05),
     &  ( 1.8202E-04, 6.5035E-05),( 1.6779E-04, 6.2644E-05),
     &  ( 1.5864E-04, 6.0554E-05),( 1.5101E-04, 5.8618E-05),
     &  ( 1.4419E-04, 5.6851E-05),( 1.3807E-04, 5.5159E-05),
     &  ( 1.3237E-04, 5.3792E-05),( 1.2673E-04, 5.2644E-05),
     &  ( 1.2071E-04, 5.1864E-05),( 1.1508E-04, 5.1604E-05),
     &  ( 1.1044E-04, 5.1259E-05),( 1.0632E-04, 5.0877E-05),
     &  ( 1.0140E-04, 5.0575E-05),( 9.7992E-05, 5.0265E-05),
     &  ( 9.7126E-05, 4.9997E-05),( 9.1748E-05, 4.9790E-05),
     &  ( 8.9213E-05, 4.9568E-05),( 8.9820E-05, 4.9506E-05),
     &  ( 8.9518E-05, 5.1033E-05),( 8.4648E-05, 5.0392E-05),
     &  ( 8.0660E-05, 4.9242E-05),( 7.7493E-05, 4.8092E-05),
     &  ( 7.4739E-05, 4.6942E-05),( 7.2269E-05, 4.5792E-05),
     &  ( 7.0023E-05, 4.4642E-05),( 6.7961E-05, 4.3493E-05),
     &  ( 6.6056E-05, 4.2510E-05),( 6.4288E-05, 4.1751E-05),
     &  ( 6.2641E-05, 4.0993E-05),( 6.1104E-05, 4.0234E-05),
     &  ( 5.9667E-05, 3.9475E-05),( 5.8322E-05, 3.8716E-05),
     &  ( 5.7059E-05, 3.7957E-05),( 5.5866E-05, 3.7945E-05),
     &  ( 5.4730E-05, 3.8112E-05),( 5.3678E-05, 3.8279E-05),
     &  ( 5.2656E-05, 3.8446E-05),( 5.1633E-05, 3.8613E-05),
     &  ( 5.0670E-05, 3.8780E-05),( 4.9767E-05, 3.8946E-05),
     &  ( 4.8924E-05, 3.9080E-05),( 4.8143E-05, 3.9012E-05),
     &  ( 4.7430E-05, 3.8944E-05),( 4.6725E-05, 3.8876E-05),
     &  ( 4.5909E-05, 3.8809E-05),( 4.5124E-05, 3.8741E-05),
     &  ( 4.4371E-05, 3.8673E-05),( 4.3649E-05, 4.0262E-05),
     &  ( 4.1757E-05, 4.6971E-05),( 3.8320E-05, 4.6946E-05),
     &  ( 3.3485E-05, 4.4465E-05),( 3.1153E-05, 3.9089E-05),
     &  ( 2.8921E-05, 3.7265E-05),( 2.7178E-05, 3.7022E-05),
     &  ( 2.5778E-05, 3.7216E-05),( 2.4999E-05, 3.6462E-05),
     &  ( 2.3508E-05, 3.4127E-05),( 2.3171E-05, 3.3981E-05),
     &  ( 2.1422E-05, 3.8506E-05),( 2.2073E-05, 3.3154E-05),
     &  ( 2.1825E-05, 3.3276E-05),( 2.0955E-05, 3.1816E-05),
     &  ( 2.0757E-05, 3.3227E-05),( 2.0411E-05, 3.3252E-05),
     &  ( 2.0169E-05, 3.0868E-05),( 2.0244E-05, 3.1671E-05),
     &  ( 1.9401E-05, 3.2108E-05),( 2.0086E-05, 3.1062E-05),
     &  ( 1.9331E-05, 3.1719E-05),( 1.9556E-05, 3.0722E-05),
     &  ( 1.9263E-05, 3.1379E-05),( 1.9712E-05, 3.1987E-05),
     &  ( 1.8879E-05, 3.2668E-05),( 1.9604E-05, 3.2327E-05),
     &  ( 1.8755E-05, 3.1257E-05),( 1.9424E-05, 3.0235E-05),
     &  ( 1.9125E-05, 3.0138E-05),( 1.9169E-05, 3.0138E-05),
     &  ( 1.9584E-05, 3.1354E-05),( 1.8915E-05, 3.1792E-05),
     &  ( 1.9776E-05, 3.1671E-05),( 1.9321E-05, 3.0673E-05),
     &  ( 1.9405E-05, 3.1452E-05),( 1.9969E-05, 3.2327E-05),
     &  ( 1.9714E-05, 3.2230E-05),( 2.1100E-05, 3.1306E-05),
     &  ( 2.0313E-05, 3.1962E-05),( 2.1188E-05, 3.3738E-05),
     &  ( 2.1304E-05, 3.4176E-05),( 2.3264E-05, 3.8603E-05),
     &  ( 2.2956E-05, 3.8554E-05),( 2.2605E-05, 3.9527E-05)/
  
         DATA ((CAS  (I,J), I= 401, 500), J=2,2) /
     &  ( 2.3495E-05, 4.7753E-05),( 2.5545E-05, 5.3514E-05),
     &  ( 2.6613E-05, 5.3514E-05),( 2.5353E-05, 5.3514E-05),
     &  ( 2.4881E-05, 5.3514E-05),( 2.5585E-05, 5.5946E-05),
     &  ( 2.6873E-05, 5.5946E-05),( 2.7981E-05, 5.8379E-05),
     &  ( 2.8090E-05, 5.8379E-05),( 2.7045E-05, 5.8379E-05),
     &  ( 2.8024E-05, 5.8379E-05),( 2.8085E-05, 5.8379E-05),
     &  ( 2.8722E-05, 5.8379E-05),( 3.1055E-05, 6.0811E-05),
     &  ( 3.0384E-05, 6.0811E-05),( 2.8754E-05, 6.0811E-05),
     &  ( 2.9526E-05, 6.0811E-05),( 2.7969E-05, 6.0811E-05),
     &  ( 2.8179E-05, 6.0811E-05),( 3.0213E-05, 6.3244E-05),
     &  ( 3.0550E-05, 6.3244E-05),( 3.1151E-05, 6.3244E-05),
     &  ( 3.2267E-05, 6.3244E-05),( 3.1477E-05, 6.5676E-05),
     &  ( 3.0612E-05, 6.5676E-05),( 3.1693E-05, 7.0541E-05),
     &  ( 3.1735E-05, 7.0541E-05),( 3.4520E-05, 7.0541E-05),
     &  ( 3.4580E-05, 7.0541E-05),( 3.4083E-05, 7.2974E-05),
     &  ( 3.5589E-05, 7.2974E-05),( 3.4299E-05, 7.5406E-05),
     &  ( 3.4934E-05, 7.5406E-05),( 3.6201E-05, 7.7838E-05),
     &  ( 3.8146E-05, 8.0271E-05),( 3.6151E-05, 8.2703E-05),
     &  ( 3.6250E-05, 8.2703E-05),( 3.5610E-05, 9.2433E-05),
     &  ( 3.6972E-05, 9.2433E-05),( 4.0172E-05, 9.4866E-05),
     &  ( 3.9654E-05, 9.4866E-05),( 4.0471E-05, 9.4866E-05),
     &  ( 3.9396E-05, 9.7298E-05),( 3.9603E-05, 9.7298E-05),
     &  ( 3.8968E-05, 9.2433E-05),( 3.8586E-05, 9.2433E-05),
     &  ( 4.2688E-05, 9.4866E-05),( 4.0163E-05, 9.9730E-05),
     &  ( 4.1797E-05, 9.9730E-05),( 3.8958E-05, 9.7298E-05),
     &  ( 4.3662E-05, 9.4866E-05),( 4.3547E-05, 9.4866E-05),
     &  ( 4.3704E-05, 9.4866E-05),( 4.4127E-05, 9.7298E-05),
     &  ( 4.1711E-05, 9.9730E-05),( 3.9266E-05, 1.0216E-04),
     &  ( 3.8648E-05, 9.7298E-05),( 3.9952E-05, 9.7298E-05),
     &  ( 4.2907E-05, 9.4866E-05),( 4.3337E-05, 9.4866E-05),
     &  ( 4.3346E-05, 9.2433E-05),( 4.2867E-05, 9.2433E-05),
     &  ( 4.3099E-05, 9.2433E-05),( 4.2290E-05, 9.0001E-05),
     &  ( 4.2874E-05, 9.0001E-05),( 4.3020E-05, 9.2433E-05),
     &  ( 4.1908E-05, 9.4866E-05),( 4.3128E-05, 9.7298E-05),
     &  ( 4.5487E-05, 9.7298E-05),( 4.4638E-05, 9.4866E-05),
     &  ( 4.5383E-05, 9.4866E-05),( 4.6204E-05, 8.7568E-05),
     &  ( 4.9197E-05, 9.2433E-05),( 5.1825E-05, 9.4866E-05),
     &  ( 5.2410E-05, 9.2433E-05),( 5.7206E-05, 9.0001E-05),
     &  ( 5.9261E-05, 9.0001E-05),( 5.7230E-05, 9.0001E-05),
     &  ( 5.6234E-05, 1.4108E-04),( 5.4278E-05, 1.3865E-04),
     &  ( 5.3817E-05, 1.3622E-04),( 6.1199E-05, 1.3622E-04),
     &  ( 6.5487E-05, 1.3378E-04),( 6.5309E-05, 1.3135E-04),
     &  ( 5.7357E-05, 1.2649E-04),( 5.9606E-05, 1.2162E-04),
     &  ( 6.2134E-05, 1.1919E-04),( 6.4497E-05, 1.1676E-04),
     &  ( 6.0378E-05, 1.1433E-04),( 6.1069E-05, 1.1433E-04),
     &  ( 6.1158E-05, 1.1433E-04),( 6.1476E-05, 1.1433E-04),
     &  ( 6.3356E-05, 1.1433E-04),( 6.3318E-05, 1.1189E-04),
     &  ( 6.0011E-05, 1.1189E-04),( 5.8704E-05, 1.1189E-04),
     &  ( 6.4563E-05, 1.0946E-04),( 7.2613E-05, 9.8514E-05),
     &  ( 7.1342E-05, 9.0129E-05),( 8.2917E-05, 9.7298E-05)/
  
         DATA ((CAS  (I,J), I= 501, 600), J=2,2) /
     &  ( 8.9052E-05, 9.9730E-05),( 8.7780E-05, 9.9730E-05),
     &  ( 8.6006E-05, 9.7298E-05),( 8.5311E-05, 4.8649E-05),
     &  ( 7.2708E-05, 4.8975E-05),( 7.5373E-05, 4.9741E-05),
     &  ( 8.3861E-05, 5.3514E-05),( 8.5366E-05, 4.6217E-05),
     &  ( 9.0539E-05, 3.8919E-05),( 9.8732E-05, 3.8919E-05),
     &  ( 1.0960E-04, 3.8919E-05),( 1.2327E-04, 3.8919E-05),
     &  ( 1.4065E-04, 3.8919E-05),( 1.6326E-04, 3.8919E-05),
     &  ( 1.9372E-04, 3.8919E-05),( 2.3673E-04, 3.8919E-05),
     &  ( 3.0164E-04, 3.8919E-05),( 3.1908E-04, 3.8676E-05),
     &  ( 3.3808E-04, 3.8433E-05),( 3.5961E-04, 3.8189E-05),
     &  ( 3.8396E-04, 3.7946E-05),( 4.1168E-04, 3.7703E-05),
     &  ( 4.4345E-04, 3.7460E-05),( 4.8034E-04, 3.7216E-05),
     &  ( 4.8841E-04, 3.7168E-05),( 4.9676E-04, 3.7119E-05),
     &  ( 5.0540E-04, 3.7071E-05),( 5.1434E-04, 3.7022E-05),
     &  ( 5.2359E-04, 3.6973E-05),( 5.3311E-04, 3.6925E-05),
     &  ( 5.4297E-04, 3.6876E-05),( 5.5321E-04, 3.6827E-05),
     &  ( 5.6383E-04, 3.6779E-05),( 5.7484E-04, 3.6730E-05),
     &  ( 6.3002E-04, 3.6511E-05),( 6.7285E-04, 3.6834E-05),
     &  ( 6.9644E-04, 3.7043E-05),( 7.1307E-04, 3.7182E-05),
     &  ( 7.3048E-04, 3.7321E-05),( 7.4874E-04, 3.7460E-05),
     &  ( 7.6790E-04, 3.7599E-05),( 7.8803E-04, 3.7738E-05),
     &  ( 8.0921E-04, 3.7877E-05),( 8.2022E-04, 3.7946E-05),
     &  ( 8.3153E-04, 3.8016E-05),( 8.4314E-04, 3.8085E-05),
     &  ( 8.5507E-04, 3.8155E-05),( 8.6733E-04, 3.8224E-05),
     &  ( 8.7994E-04, 3.8294E-05),( 8.9291E-04, 3.8363E-05),
     &  ( 9.0626E-04, 3.8433E-05),( 9.2000E-04, 3.8502E-05),
     &  ( 9.3415E-04, 3.8572E-05),( 9.4873E-04, 3.8641E-05),
     &  ( 9.6377E-04, 3.8711E-05),( 9.7927E-04, 3.8780E-05),
     &  ( 9.9527E-04, 3.8850E-05),( 1.0118E-03, 3.8919E-05),
     &  ( 1.0288E-03, 3.9081E-05),( 1.0465E-03, 3.9244E-05),
     &  ( 1.0647E-03, 3.9406E-05),( 1.0836E-03, 3.9568E-05),
     &  ( 1.1031E-03, 3.9730E-05),( 1.1233E-03, 3.9892E-05),
     &  ( 1.1443E-03, 4.0054E-05),( 1.1660E-03, 4.0217E-05),
     &  ( 1.1885E-03, 4.0379E-05),( 1.2120E-03, 4.0541E-05),
     &  ( 1.2363E-03, 4.0703E-05),( 1.2617E-03, 4.0865E-05),
     &  ( 1.2880E-03, 4.1027E-05),( 1.3155E-03, 4.1190E-05),
     &  ( 1.3441E-03, 4.1352E-05),( 1.3740E-03, 4.1352E-05),
     &  ( 1.4052E-03, 4.1352E-05),( 1.4379E-03, 4.1352E-05),
     &  ( 1.4720E-03, 4.1352E-05),( 1.5078E-03, 4.1352E-05),
     &  ( 1.5454E-03, 4.1352E-05),( 1.5848E-03, 4.1352E-05),
     &  ( 1.6262E-03, 4.1352E-05),( 1.6699E-03, 4.1352E-05),
     &  ( 1.7159E-03, 4.1352E-05),( 1.7399E-03, 4.1291E-05),
     &  ( 1.7645E-03, 4.1230E-05),( 1.7898E-03, 4.1169E-05),
     &  ( 1.8158E-03, 4.1108E-05),( 1.8426E-03, 4.1048E-05),
     &  ( 1.8702E-03, 4.0987E-05),( 1.8986E-03, 4.0926E-05),
     &  ( 1.9279E-03, 4.0865E-05),( 1.9581E-03, 4.0804E-05),
     &  ( 1.9892E-03, 4.0744E-05),( 2.0213E-03, 4.0683E-05),
     &  ( 2.0545E-03, 4.0622E-05),( 2.0887E-03, 4.0561E-05),
     &  ( 2.1241E-03, 4.0500E-05),( 2.1607E-03, 4.0439E-05),
     &  ( 2.1986E-03, 4.0379E-05),( 2.2378E-03, 4.0318E-05)/
  
         DATA ((CAS  (I,J), I= 601, 700), J=2,2) /
     &  ( 2.2784E-03, 4.0257E-05),( 2.3205E-03, 4.0196E-05),
     &  ( 2.3641E-03, 4.0135E-05),( 2.4094E-03, 4.0075E-05),
     &  ( 2.4565E-03, 4.0014E-05),( 2.5054E-03, 3.9953E-05),
     &  ( 2.5563E-03, 3.9892E-05),( 2.6092E-03, 3.9831E-05),
     &  ( 2.6644E-03, 3.9771E-05),( 2.7219E-03, 3.9710E-05),
     &  ( 2.7819E-03, 3.9649E-05),( 2.8446E-03, 3.9588E-05),
     &  ( 2.9102E-03, 3.9527E-05),( 2.9788E-03, 3.9467E-05),
     &  ( 3.0508E-03, 3.9406E-05),( 3.1262E-03, 3.9345E-05),
     &  ( 3.2054E-03, 3.9284E-05),( 3.2887E-03, 3.9223E-05),
     &  ( 3.3765E-03, 3.9162E-05),( 3.4689E-03, 3.9102E-05),
     &  ( 3.5666E-03, 3.9041E-05),( 3.7128E-03, 3.8956E-05),
     &  ( 3.7792E-03, 3.8919E-05),( 3.8952E-03, 3.8919E-05),
     &  ( 4.0185E-03, 3.8919E-05),( 4.1498E-03, 3.8919E-05),
     &  ( 4.2899E-03, 3.8919E-05),( 4.4397E-03, 3.8919E-05),
     &  ( 4.6003E-03, 3.8919E-05),( 4.7729E-03, 3.8919E-05),
     &  ( 4.9588E-03, 3.8919E-05),( 5.1597E-03, 3.8919E-05),
     &  ( 5.3775E-03, 3.8919E-05),( 5.6144E-03, 3.8919E-05),
     &  ( 5.8034E-03, 3.8919E-05),( 6.3924E-03, 3.8919E-05),
     &  ( 7.1137E-03, 3.8919E-05),( 8.0175E-03, 3.8919E-05),
     &  ( 9.1831E-03, 3.8919E-05),( 1.0743E-02, 3.8919E-05),
     &  ( 1.2940E-02, 3.8919E-05),( 1.6261E-02, 3.8919E-05),
     &  ( 2.1869E-02, 3.4809E-04),( 3.3358E-02, 8.0606E-04),
     &  ( 7.0144E-02, 3.5672E-03),( 7.4173E-02, 3.9899E-03),
     &  ( 7.8691E-02, 4.4924E-03),( 8.3793E-02, 5.0960E-03),
     &  ( 8.9600E-02, 5.8297E-03),( 9.6266E-02, 6.7338E-03),
     &  ( 1.0400E-01, 7.8652E-03),( 1.1307E-01, 9.3069E-03),
     &  ( 1.2386E-01, 1.1183E-02),( 1.3690E-01, 1.3688E-02),
     &  ( 1.5298E-01, 1.7134E-02),( 1.7326E-01, 2.2056E-02),
     &  ( 1.9960E-01, 2.9430E-02),( 2.3508E-01, 4.1178E-02),
     &  ( 2.3931E-01, 4.2722E-02),( 3.3402E-01, 8.5991E-02),
     &  ( 4.0306E-01, 1.2953E-01),( 4.5853E-01, 1.7371E-01),
     &  ( 5.0677E-01, 2.2069E-01),( 5.4394E-01, 2.6403E-01),
     &  ( 5.7642E-01, 3.0874E-01),( 6.0245E-01, 3.5091E-01),
     &  ( 6.2838E-01, 4.0112E-01),( 6.4619E-01, 4.4282E-01),
     &  ( 6.6269E-01, 4.9016E-01),( 6.7432E-01, 5.3259E-01),
     &  ( 6.8392E-01, 5.7945E-01),( 6.8931E-01, 6.1771E-01),
     &  ( 6.9333E-01, 6.7309E-01),( 6.9368E-01, 7.0270E-01),
     &  ( 6.9165E-01, 7.4953E-01),( 6.8603E-01, 7.9920E-01),
     &  ( 6.7996E-01, 8.3382E-01),( 6.6683E-01, 8.8781E-01),
     &  ( 6.5507E-01, 9.2500E-01),( 6.4063E-01, 9.6297E-01),
     &  ( 6.2328E-01, 1.0015E+00),( 6.0282E-01, 1.0404E+00),
     &  ( 5.7903E-01, 1.0793E+00),( 5.5174E-01, 1.1178E+00),
     &  ( 5.2083E-01, 1.1557E+00),( 4.8620E-01, 1.1924E+00),
     &  ( 4.4783E-01, 1.2275E+00),( 4.0576E-01, 1.2605E+00),
     &  ( 3.3604E-01, 1.3048E+00),( 2.8550E-01, 1.3303E+00),
     &  ( 2.0448E-01, 1.3610E+00),( 1.1864E-01, 1.3817E+00),
     &  ( 1.1856E-01, 1.3817E+00),( 3.3597E-01, 1.3049E+00),
     &  ( 4.0569E-01, 1.2605E+00),( 4.6742E-01, 1.2102E+00),
     &  ( 5.0393E-01, 1.1743E+00),( 5.5169E-01, 1.1179E+00),
     &  ( 5.7898E-01, 1.0793E+00),( 6.0278E-01, 1.0404E+00)/
  
         DATA ((CAS  (I,J), I= 701, 800), J=2,2) /
     &  ( 6.2325E-01, 1.0016E+00),( 6.4060E-01, 9.6304E-01),
     &  ( 6.5504E-01, 9.2507E-01),( 6.6681E-01, 8.8788E-01),
     &  ( 6.7613E-01, 8.5163E-01),( 6.8324E-01, 8.1644E-01),
     &  ( 6.8834E-01, 7.8241E-01),( 6.9165E-01, 7.4961E-01),
     &  ( 6.9368E-01, 7.0278E-01),( 6.9334E-01, 6.7316E-01),
     &  ( 6.9069E-01, 6.3115E-01),( 6.8592E-01, 5.9197E-01),
     &  ( 6.8176E-01, 5.6737E-01),( 6.7160E-01, 5.2165E-01),
     &  ( 6.6271E-01, 4.9023E-01),( 6.4965E-01, 4.5188E-01),
     &  ( 6.3564E-01, 4.1723E-01),( 6.1737E-01, 3.7858E-01),
     &  ( 5.9875E-01, 3.4449E-01),( 5.7278E-01, 3.0334E-01),
     &  ( 5.4751E-01, 2.6859E-01),( 5.1664E-01, 2.3151E-01),
     &  ( 4.8182E-01, 1.9526E-01),( 4.3703E-01, 1.5548E-01),
     &  ( 3.8569E-01, 1.1748E-01),( 3.2159E-01, 7.9300E-02),
     &  ( 2.6500E-01, 5.2780E-02),( 2.2104E-01, 3.6275E-02),
     &  ( 1.8932E-01, 2.6419E-02),( 1.6544E-01, 2.0081E-02),
     &  ( 1.4684E-01, 1.5771E-02),( 1.3197E-01, 1.2709E-02),
     &  ( 1.1981E-01, 1.0458E-02),( 1.0969E-01, 8.7554E-03),
     &  ( 1.0114E-01, 7.4363E-03),( 9.3817E-02, 6.3940E-03),
     &  ( 8.7481E-02, 5.5562E-03),( 8.1945E-02, 4.8728E-03),
     &  ( 7.7065E-02, 4.3080E-03),( 7.2733E-02, 3.8360E-03),
     &  ( 6.8860E-02, 3.4375E-03),( 6.5379E-02, 3.0980E-03),
     &  ( 6.2232E-02, 2.8064E-03),( 5.9374E-02, 2.5541E-03),
     &  ( 3.1134E-02, 7.0234E-04),( 2.1101E-02, 3.2438E-04),
     &  ( 1.5961E-02, 3.8943E-05),( 1.2837E-02, 3.8967E-05),
     &  ( 1.0738E-02, 3.8991E-05),( 9.2297E-03, 3.9015E-05),
     &  ( 8.0940E-03, 3.9039E-05),( 7.2080E-03, 3.9063E-05),
     &  ( 6.4974E-03, 3.9087E-05),( 5.9149E-03, 3.9111E-05),
     &  ( 5.8459E-03, 3.9114E-05),( 5.3648E-03, 3.9138E-05),
     &  ( 4.9573E-03, 3.9162E-05),( 4.6076E-03, 3.9187E-05),
     &  ( 4.3043E-03, 3.9211E-05),( 4.0387E-03, 3.9235E-05),
     &  ( 3.8042E-03, 3.9260E-05),( 3.5957E-03, 3.9284E-05),
     &  ( 3.4090E-03, 3.9308E-05),( 3.2409E-03, 3.9333E-05),
     &  ( 3.0888E-03, 3.9357E-05),( 2.9504E-03, 3.9381E-05),
     &  ( 2.8241E-03, 3.9406E-05),( 2.7082E-03, 3.9430E-05),
     &  ( 2.6016E-03, 3.9454E-05),( 2.5031E-03, 3.9479E-05),
     &  ( 2.4120E-03, 3.9503E-05),( 2.3273E-03, 3.9527E-05),
     &  ( 2.2484E-03, 3.9552E-05),( 2.1748E-03, 3.9576E-05),
     &  ( 2.1060E-03, 3.9600E-05),( 2.0414E-03, 3.9625E-05),
     &  ( 1.9807E-03, 3.9649E-05),( 1.9236E-03, 3.9673E-05),
     &  ( 1.8698E-03, 3.9698E-05),( 1.8190E-03, 3.9722E-05),
     &  ( 1.7708E-03, 3.9746E-05),( 1.7253E-03, 3.9771E-05),
     &  ( 1.6820E-03, 3.9795E-05),( 1.6410E-03, 3.9819E-05),
     &  ( 1.6019E-03, 3.9844E-05),( 1.5647E-03, 3.9868E-05),
     &  ( 1.5292E-03, 3.9892E-05),( 1.4953E-03, 3.9917E-05),
     &  ( 1.4629E-03, 3.9941E-05),( 1.4320E-03, 3.9965E-05),
     &  ( 1.4023E-03, 3.9989E-05),( 1.3739E-03, 4.0014E-05),
     &  ( 1.3467E-03, 4.0038E-05),( 1.3205E-03, 4.0062E-05),
     &  ( 1.2954E-03, 4.0087E-05),( 1.2713E-03, 4.0111E-05),
     &  ( 1.2480E-03, 4.0135E-05),( 1.2256E-03, 4.0160E-05),
     &  ( 1.2041E-03, 4.0184E-05),( 1.1833E-03, 4.0208E-05)/
  
         DATA ((CAS  (I,J), I= 801, 900), J=2,2) /
     &  ( 1.1632E-03, 4.0233E-05),( 1.1438E-03, 4.0257E-05),
     &  ( 1.1251E-03, 4.0281E-05),( 1.1070E-03, 4.0306E-05),
     &  ( 1.0895E-03, 4.0330E-05),( 1.0726E-03, 4.0354E-05),
     &  ( 1.0562E-03, 4.0379E-05),( 1.0404E-03, 4.0403E-05),
     &  ( 1.0250E-03, 4.0427E-05),( 1.0101E-03, 4.0452E-05),
     &  ( 9.9559E-04, 4.0476E-05),( 9.8155E-04, 4.0500E-05),
     &  ( 9.6792E-04, 4.0525E-05),( 9.5469E-04, 4.0549E-05),
     &  ( 9.4182E-04, 4.0573E-05),( 9.2932E-04, 4.0598E-05),
     &  ( 9.1716E-04, 4.0622E-05),( 9.0534E-04, 4.0646E-05),
     &  ( 8.9383E-04, 4.0671E-05),( 8.8262E-04, 4.0695E-05),
     &  ( 8.7171E-04, 4.0719E-05),( 8.6109E-04, 4.0744E-05),
     &  ( 8.5073E-04, 4.0768E-05),( 8.4063E-04, 4.0792E-05),
     &  ( 8.3079E-04, 4.0817E-05),( 8.2119E-04, 4.0841E-05),
     &  ( 8.1183E-04, 4.0865E-05),( 8.0268E-04, 4.0889E-05),
     &  ( 7.9376E-04, 4.0914E-05),( 7.8505E-04, 4.0938E-05),
     &  ( 7.7654E-04, 4.0962E-05),( 7.6823E-04, 4.0987E-05),
     &  ( 7.6011E-04, 4.1011E-05),( 7.5217E-04, 4.1035E-05),
     &  ( 7.4441E-04, 4.1060E-05),( 7.3682E-04, 4.1084E-05),
     &  ( 7.2940E-04, 4.1108E-05),( 7.2213E-04, 4.1133E-05),
     &  ( 7.1503E-04, 4.1157E-05),( 7.0808E-04, 4.1181E-05),
     &  ( 7.0128E-04, 4.1206E-05),( 6.9462E-04, 4.1230E-05),
     &  ( 6.8810E-04, 4.1254E-05),( 6.8171E-04, 4.1279E-05),
     &  ( 6.7546E-04, 4.1303E-05),( 6.6934E-04, 4.1327E-05),
     &  ( 6.6394E-04, 4.1349E-05),( 6.5743E-04, 4.1449E-05),
     &  ( 6.5163E-04, 4.1546E-05),( 6.4594E-04, 4.1644E-05),
     &  ( 6.4036E-04, 4.1741E-05),( 6.3488E-04, 4.1838E-05),
     &  ( 6.2951E-04, 4.1935E-05),( 6.2424E-04, 4.2033E-05),
     &  ( 6.1906E-04, 4.2130E-05),( 6.1398E-04, 4.2227E-05),
     &  ( 6.0899E-04, 4.2325E-05),( 4.6543E-04, 4.6217E-05),
     &  ( 3.7110E-04, 5.1081E-05),( 3.0963E-04, 5.1081E-05),
     &  ( 3.0637E-04, 5.1081E-05),( 3.0093E-04, 4.8649E-05),
     &  ( 3.3188E-04, 4.8649E-05),( 3.5635E-04, 4.8649E-05),
     &  ( 3.9144E-04, 4.8649E-05),( 3.9659E-04, 4.8771E-05),
     &  ( 4.2417E-04, 5.1081E-05),( 4.4164E-04, 5.1081E-05),
     &  ( 4.4498E-04, 5.1081E-05),( 4.9350E-04, 5.1081E-05),
     &  ( 5.6398E-04, 5.1081E-05),( 5.9312E-04, 5.1081E-05),
     &  ( 6.2729E-04, 4.3784E-05),( 6.6284E-04, 4.4045E-05),
     &  ( 7.0492E-04, 4.4479E-05),( 7.5318E-04, 4.4913E-05),
     &  ( 8.0901E-04, 4.5348E-05),( 8.7427E-04, 4.5782E-05),
     &  ( 9.5145E-04, 4.6217E-05),( 1.0440E-03, 4.6825E-05),
     &  ( 1.1570E-03, 4.7433E-05),( 1.2979E-03, 4.8041E-05),
     &  ( 1.4781E-03, 4.8649E-05),( 1.5651E-03, 4.8649E-05),
     &  ( 1.6630E-03, 4.8649E-05),( 1.7740E-03, 4.8649E-05),
     &  ( 1.9009E-03, 4.8649E-05),( 2.0473E-03, 4.8649E-05),
     &  ( 2.2181E-03, 4.8649E-05),( 2.3147E-03, 4.8649E-05),
     &  ( 2.4199E-03, 4.8649E-05),( 2.5352E-03, 4.8649E-05),
     &  ( 2.6620E-03, 4.8649E-05),( 2.8021E-03, 4.8649E-05),
     &  ( 2.9577E-03, 4.8649E-05),( 3.1316E-03, 4.8649E-05),
     &  ( 3.3270E-03, 4.8649E-05),( 3.5485E-03, 4.8649E-05),
     &  ( 3.8013E-03, 4.9312E-05),( 4.0928E-03, 4.9976E-05)/
  
         DATA ((CAS  (I,J), I= 901,1000), J=2,2) /
     &  ( 4.4326E-03, 5.0639E-05),( 4.8162E-03, 5.1276E-05),
     &  ( 5.0673E-03, 5.1641E-05),( 5.3460E-03, 5.2006E-05),
     &  ( 5.6570E-03, 5.2371E-05),( 6.0063E-03, 5.2736E-05),
     &  ( 6.4015E-03, 5.3100E-05),( 6.8521E-03, 5.3465E-05),
     &  ( 7.3707E-03, 5.3830E-05),( 7.9740E-03, 5.4195E-05),
     &  ( 8.6845E-03, 5.4560E-05),( 9.5336E-03, 5.4925E-05),
     &  ( 1.0566E-02, 5.5290E-05),( 1.1849E-02, 5.5654E-05),
     &  ( 1.3484E-02, 5.6019E-05),( 1.5642E-02, 5.6384E-05),
     &  ( 1.8618E-02, 5.6749E-05),( 2.2984E-02, 5.7114E-05),
     &  ( 3.0001E-02, 5.7479E-05),( 4.3084E-02, 5.3416E-03),
     &  ( 6.3662E-02, 1.1884E-02),( 7.5373E-02, 1.6906E-02),
     &  ( 8.8148E-02, 2.3588E-02),( 1.1958E-01, 4.6651E-02),
     &  ( 1.3090E-01, 5.8047E-02),( 1.4025E-01, 6.9236E-02),
     &  ( 1.4819E-01, 8.0444E-02),( 1.5487E-01, 9.1568E-02),
     &  ( 1.6035E-01, 1.0235E-01),( 1.6507E-01, 1.1343E-01),
     &  ( 1.6894E-01, 1.2450E-01),( 1.7171E-01, 1.3432E-01),
     &  ( 1.7406E-01, 1.4509E-01),( 1.7572E-01, 1.5585E-01),
     &  ( 1.7671E-01, 1.6640E-01),( 1.7707E-01, 1.7654E-01),
     &  ( 1.7681E-01, 1.8730E-01),( 1.7612E-01, 1.9610E-01),
     &  ( 1.7472E-01, 2.0661E-01),( 1.7288E-01, 2.1616E-01),
     &  ( 1.7040E-01, 2.2604E-01),( 1.6722E-01, 2.3618E-01),
     &  ( 1.6387E-01, 2.4507E-01),( 1.5918E-01, 2.5559E-01),
     &  ( 1.5443E-01, 2.6468E-01),( 1.4898E-01, 2.7379E-01),
     &  ( 1.4278E-01, 2.8285E-01),( 1.3457E-01, 2.9324E-01),
     &  ( 1.2668E-01, 3.0191E-01),( 1.1645E-01, 3.1162E-01),
     &  ( 1.0682E-01, 3.1948E-01),( 9.2785E-02, 3.2911E-01),
     &  ( 7.7465E-02, 3.3755E-01),( 5.4584E-02, 3.4681E-01),
     &  ( 3.4640E-02, 3.5203E-01),( 1.1667E-02, 3.5507E-01),
     &  ( 1.6205E-04, 3.5546E-01),( 1.1609E-02, 3.5508E-01),
     &  ( 2.3170E-02, 3.5393E-01),( 5.4529E-02, 3.4682E-01),
     &  ( 7.7413E-02, 3.3758E-01),( 9.2736E-02, 3.2914E-01),
     &  ( 1.0678E-01, 3.1951E-01),( 1.1641E-01, 3.1166E-01),
     &  ( 1.2664E-01, 3.0195E-01),( 1.3454E-01, 2.9329E-01),
     &  ( 1.4275E-01, 2.8289E-01),( 1.4895E-01, 2.7384E-01),
     &  ( 1.5440E-01, 2.6473E-01),( 1.5915E-01, 2.5564E-01),
     &  ( 1.6385E-01, 2.4512E-01),( 1.6720E-01, 2.3624E-01),
     &  ( 1.7039E-01, 2.2609E-01),( 1.7287E-01, 2.1621E-01),
     &  ( 1.7471E-01, 2.0666E-01),( 1.7612E-01, 1.9616E-01),
     &  ( 1.7681E-01, 1.8736E-01),( 1.7707E-01, 1.7659E-01),
     &  ( 1.7671E-01, 1.6645E-01),( 1.7573E-01, 1.5590E-01),
     &  ( 1.7407E-01, 1.4514E-01),( 1.7172E-01, 1.3437E-01),
     &  ( 1.6896E-01, 1.2454E-01),( 1.6509E-01, 1.1347E-01),
     &  ( 1.6037E-01, 1.0239E-01),( 1.5489E-01, 9.1609E-02),
     &  ( 1.4821E-01, 8.0484E-02),( 1.4028E-01, 6.9273E-02),
     &  ( 1.3093E-01, 5.8081E-02),( 1.1961E-01, 4.6682E-02),
     &  ( 1.0643E-01, 3.5281E-02),( 1.1334E-01, 4.1180E-02),
     &  ( 9.6956E-02, 2.9011E-02),( 8.6864E-02, 2.2855E-02),
     &  ( 8.0763E-02, 1.9564E-02),( 6.8124E-02, 1.3680E-02),
     &  ( 6.3703E-02, 1.1900E-02),( 5.4185E-02, 8.5262E-03),
     &  ( 3.5085E-02, 5.9668E-05),( 2.5887E-02, 6.0033E-05)/
  
         DATA ((CAS  (I,J), I=1001,1100), J=2,2) /
     &  ( 2.0499E-02, 6.0398E-05),( 1.6964E-02, 6.0763E-05),
     &  ( 1.4469E-02, 6.1127E-05),( 1.2613E-02, 6.1492E-05),
     &  ( 1.1180E-02, 6.1857E-05),( 1.0039E-02, 6.2222E-05),
     &  ( 9.1101E-03, 6.2587E-05),( 8.3387E-03, 6.2952E-05),
     &  ( 7.6880E-03, 6.3244E-05),( 7.1317E-03, 6.3244E-05),
     &  ( 6.6507E-03, 6.4458E-05),( 6.2308E-03, 6.4492E-05),
     &  ( 5.8609E-03, 6.4527E-05),( 5.5326E-03, 6.4564E-05),
     &  ( 5.2393E-03, 6.4602E-05),( 4.9757E-03, 6.4641E-05),
     &  ( 4.5590E-03, 6.4716E-05),( 4.0388E-03, 6.4842E-05),
     &  ( 3.7606E-03, 6.6353E-05),( 3.3060E-03, 7.2234E-05),
     &  ( 2.9503E-03, 7.8132E-05),( 2.6015E-03, 8.5531E-05),
     &  ( 2.1063E-03, 9.7806E-05),( 1.5617E-03, 1.1388E-04),
     &  ( 1.2400E-03, 1.3128E-04),( 1.1062E-03, 1.3848E-04),
     &  ( 1.0315E-03, 1.4554E-04),( 9.8287E-04, 1.5270E-04),
     &  ( 9.4854E-04, 1.6003E-04),( 9.2268E-04, 1.6753E-04),
     &  ( 9.0238E-04, 1.7519E-04),( 8.8591E-04, 1.8286E-04),
     &  ( 8.7214E-04, 1.9063E-04),( 8.6039E-04, 1.9854E-04),
     &  ( 8.5017E-04, 2.0656E-04),( 8.4111E-04, 2.1469E-04),
     &  ( 8.3298E-04, 2.2292E-04),( 8.2555E-04, 2.3121E-04),
     &  ( 8.1872E-04, 2.3959E-04),( 8.1233E-04, 2.4805E-04),
     &  ( 8.0628E-04, 2.5659E-04),( 8.0054E-04, 2.6520E-04),
     &  ( 7.9501E-04, 2.7391E-04),( 7.8962E-04, 2.8272E-04),
     &  ( 7.8436E-04, 2.9163E-04),( 7.7918E-04, 3.0066E-04),
     &  ( 7.7401E-04, 3.0984E-04),( 7.6883E-04, 3.1918E-04),
     &  ( 7.6357E-04, 3.2874E-04),( 7.5820E-04, 3.3851E-04),
     &  ( 7.5266E-04, 3.4858E-04),( 7.4687E-04, 3.5901E-04),
     &  ( 7.4073E-04, 3.6992E-04),( 7.3411E-04, 3.8143E-04),
     &  ( 7.2678E-04, 3.9380E-04),( 7.1831E-04, 4.0754E-04),
     &  ( 7.0762E-04, 4.2385E-04),( 6.8359E-04, 4.5532E-04),
     &  ( 6.6311E-04, 4.7332E-04),( 6.5613E-04, 4.7577E-04),
     &  ( 6.5152E-04, 4.7521E-04),( 6.4819E-04, 4.7287E-04),
     &  ( 6.4569E-04, 4.6921E-04),( 6.4380E-04, 4.6450E-04),
     &  ( 6.4236E-04, 4.5887E-04),( 6.4125E-04, 4.5243E-04),
     &  ( 6.4041E-04, 4.4522E-04),( 6.3974E-04, 4.3732E-04),
     &  ( 6.3919E-04, 4.2876E-04),( 6.3870E-04, 4.1956E-04),
     &  ( 6.3822E-04, 4.0977E-04),( 6.3770E-04, 3.9938E-04),
     &  ( 6.3699E-04, 3.8843E-04),( 6.3625E-04, 3.7695E-04),
     &  ( 6.3521E-04, 3.6498E-04),( 6.3391E-04, 3.5251E-04),
     &  ( 6.3225E-04, 3.3960E-04),( 6.3017E-04, 3.2630E-04),
     &  ( 6.2763E-04, 3.1264E-04),( 6.2447E-04, 2.9866E-04),
     &  ( 6.2068E-04, 2.8444E-04),( 6.1613E-04, 2.7009E-04),
     &  ( 6.1065E-04, 2.5565E-04),( 6.0403E-04, 2.4130E-04),
     &  ( 5.9648E-04, 2.2716E-04),( 5.8735E-04, 2.1344E-04),
     &  ( 5.7652E-04, 2.0037E-04),( 5.6340E-04, 1.8825E-04),
     &  ( 5.4771E-04, 1.7746E-04),( 5.2758E-04, 1.6832E-04),
     &  ( 5.0212E-04, 1.6145E-04),( 4.6664E-04, 1.5736E-04),
     &  ( 4.5649E-04, 1.5696E-04),( 4.2597E-04, 1.5994E-04),
     &  ( 3.8352E-04, 1.6606E-04),( 3.7954E-04, 1.6600E-04),
     &  ( 3.5270E-04, 1.6814E-04),( 3.4389E-04, 1.7051E-04),
     &  ( 3.3680E-04, 1.7047E-04),( 3.2742E-04, 1.7043E-04)/
  
         DATA ((CAS  (I,J), I=1101,1200), J=2,2) /
     &  ( 3.1931E-04, 1.6797E-04),( 3.1184E-04, 1.7232E-04),
     &  ( 3.0747E-04, 1.7523E-04),( 3.0483E-04, 1.7652E-04),
     &  ( 2.9826E-04, 1.8040E-04),( 2.9169E-04, 1.8422E-04),
     &  ( 2.8604E-04, 1.8811E-04),( 2.8059E-04, 1.9200E-04),
     &  ( 2.7554E-04, 1.9216E-04),( 2.7072E-04, 1.8487E-04),
     &  ( 2.6607E-04, 1.8341E-04),( 2.6171E-04, 1.8487E-04),
     &  ( 2.5755E-04, 1.8049E-04),( 2.5368E-04, 1.8049E-04),
     &  ( 2.4981E-04, 1.8924E-04),( 2.4594E-04, 1.9411E-04),
     &  ( 2.4236E-04, 1.9703E-04),( 2.3880E-04, 1.9995E-04),
     &  ( 2.3639E-04, 2.0141E-04),( 2.3340E-04, 1.9995E-04),
     &  ( 2.3309E-04, 1.9946E-04),( 2.3038E-04, 2.0238E-04),
     &  ( 2.2846E-04, 2.0676E-04),( 2.2496E-04, 2.0676E-04),
     &  ( 2.2570E-04, 2.0676E-04),( 2.2478E-04, 2.1649E-04),
     &  ( 2.2218E-04, 2.4811E-04),( 2.2133E-04, 2.6270E-04),
     &  ( 2.1786E-04, 2.3699E-04),( 2.1765E-04, 2.4325E-04),
     &  ( 2.1524E-04, 2.4325E-04),( 2.1547E-04, 2.4325E-04),
     &  ( 2.1399E-04, 2.4665E-04),( 2.1233E-04, 2.5687E-04),
     &  ( 2.0914E-04, 2.6222E-04),( 2.0749E-04, 2.6514E-04),
     &  ( 2.0512E-04, 2.7243E-04),( 2.0499E-04, 2.7146E-04),
     &  ( 2.0334E-04, 2.5395E-04),( 2.0354E-04, 2.4811E-04),
     &  ( 2.0147E-04, 2.4714E-04),( 2.0084E-04, 2.4568E-04),
     &  ( 1.9827E-04, 2.4811E-04),( 1.9837E-04, 2.5006E-04),
     &  ( 1.9936E-04, 2.5054E-04),( 1.9892E-04, 2.7170E-04),
     &  ( 1.9551E-04, 3.0698E-04),( 1.9386E-04, 3.1476E-04),
     &  ( 1.9583E-04, 2.8946E-04),( 1.9559E-04, 2.6416E-04),
     &  ( 1.9489E-04, 2.5784E-04),( 1.9272E-04, 2.6003E-04),
     &  ( 1.9197E-04, 2.6222E-04),( 1.9213E-04, 2.6879E-04),
     &  ( 1.8974E-04, 2.9068E-04),( 1.8981E-04, 3.0162E-04),
     &  ( 1.8865E-04, 2.9433E-04),( 1.8850E-04, 2.7973E-04),
     &  ( 1.8497E-04, 2.8216E-04),( 1.8649E-04, 2.8970E-04),
     &  ( 1.8625E-04, 3.0576E-04),( 1.8732E-04, 3.1379E-04),
     &  ( 1.8573E-04, 3.1038E-04),( 1.8623E-04, 3.0527E-04),
     &  ( 1.8647E-04, 2.9676E-04),( 1.8180E-04, 3.0041E-04),
     &  ( 1.8141E-04, 3.0333E-04),( 1.8113E-04, 3.0284E-04),
     &  ( 1.8068E-04, 2.9433E-04),( 1.7924E-04, 2.8703E-04),
     &  ( 1.7889E-04, 2.8216E-04),( 1.7955E-04, 2.6757E-04),
     &  ( 1.7596E-04, 2.5881E-04),( 1.7709E-04, 2.5200E-04),
     &  ( 1.7694E-04, 2.4908E-04),( 1.7822E-04, 2.4811E-04),
     &  ( 1.7686E-04, 2.3838E-04),( 1.7716E-04, 2.4325E-04),
     &  ( 1.7630E-04, 2.4957E-04),( 1.7904E-04, 2.6903E-04),
     &  ( 1.7936E-04, 2.9092E-04),( 1.7676E-04, 2.9579E-04),
     &  ( 1.7359E-04, 3.0162E-04),( 1.7168E-04, 2.9141E-04),
     &  ( 1.8100E-04, 2.8460E-04),( 1.8265E-04, 2.6027E-04),
     &  ( 1.8037E-04, 2.2379E-04),( 1.7269E-04, 2.2670E-04),
     &  ( 1.7008E-04, 2.4422E-04),( 1.7178E-04, 2.4811E-04),
     &  ( 1.7313E-04, 2.5297E-04),( 1.7351E-04, 2.3352E-04),
     &  ( 1.7212E-04, 2.3546E-04),( 1.6443E-04, 2.5395E-04),
     &  ( 1.6527E-04, 2.8606E-04),( 1.6598E-04, 2.9676E-04),
     &  ( 1.6739E-04, 2.8995E-04),( 1.6895E-04, 2.6952E-04),
     &  ( 1.6892E-04, 2.6270E-04),( 1.6367E-04, 2.5103E-04)/
  
         DATA ((CAS  (I,J), I=1201,1300), J=2,2) /
     &  ( 1.6449E-04, 2.3352E-04),( 1.6253E-04, 2.1162E-04),
     &  ( 1.6317E-04, 1.9703E-04),( 1.6191E-04, 2.0043E-04),
     &  ( 1.6239E-04, 2.1065E-04),( 1.6177E-04, 2.3060E-04),
     &  ( 1.6421E-04, 2.5541E-04),( 1.6483E-04, 2.7730E-04),
     &  ( 1.7049E-04, 2.9189E-04),( 1.6805E-04, 2.8703E-04),
     &  ( 1.6874E-04, 2.7243E-04),( 1.7233E-04, 2.6757E-04),
     &  ( 1.6677E-04, 2.8460E-04),( 1.7021E-04, 2.6270E-04),
     &  ( 1.7565E-04, 2.3789E-04),( 1.9625E-04, 2.0724E-04),
     &  ( 1.8464E-04, 2.0031E-04),( 1.9024E-04, 2.4811E-04),
     &  ( 1.9557E-04, 2.3838E-04),( 1.8194E-04, 2.1892E-04),
     &  ( 1.8460E-04, 1.9460E-04),( 1.8724E-04, 1.9216E-04),
     &  ( 2.0997E-04, 2.1162E-04),( 2.1287E-04, 2.1892E-04),
     &  ( 2.5511E-04, 2.3595E-04),( 2.5909E-04, 2.4081E-04),
     &  ( 3.3724E-04, 2.5541E-04),( 4.2435E-04, 4.7190E-04),
     &  ( 5.6828E-04, 3.0406E-04),( 7.2121E-04, 5.5715E-04),
     &  ( 4.8341E-04, 6.5676E-04),( 2.7359E-04, 0.0000E+00),
     &  ( 2.0365E-04, 0.0000E+00),( 1.5803E-04, 0.0000E+00),
     &  ( 1.2314E-04, 0.0000E+00),( 1.1434E-04, 0.0000E+00),
     &  ( 1.0797E-04, 0.0000E+00),( 9.9266E-05, 0.0000E+00),
     &  ( 9.3489E-05, 0.0000E+00),( 9.1241E-05, 0.0000E+00),
     &  ( 8.9290E-05, 0.0000E+00),( 8.7574E-05, 0.0000E+00),
     &  ( 8.6047E-05, 0.0000E+00),( 8.4676E-05, 0.0000E+00),
     &  ( 8.3430E-05, 0.0000E+00),( 8.2296E-05, 0.0000E+00),
     &  ( 8.1256E-05, 0.0000E+00),( 8.0295E-05, 0.0000E+00),
     &  ( 7.9405E-05, 0.0000E+00),( 7.8576E-05, 0.0000E+00),
     &  ( 7.7802E-05, 0.0000E+00),( 7.7076E-05, 0.0000E+00),
     &  ( 7.6393E-05, 0.0000E+00),( 7.5750E-05, 0.0000E+00),
     &  ( 7.5142E-05, 0.0000E+00),( 7.4567E-05, 0.0000E+00),
     &  ( 7.4021E-05, 0.0000E+00),( 7.3502E-05, 0.0000E+00),
     &  ( 7.3009E-05, 0.0000E+00),( 7.2539E-05, 0.0000E+00),
     &  ( 7.2091E-05, 0.0000E+00),( 7.1662E-05, 0.0000E+00),
     &  ( 7.1253E-05, 0.0000E+00),( 7.0862E-05, 0.0000E+00),
     &  ( 7.0487E-05, 0.0000E+00),( 7.0128E-05, 0.0000E+00),
     &  ( 6.9784E-05, 0.0000E+00),( 6.9454E-05, 0.0000E+00),
     &  ( 6.9137E-05, 0.0000E+00),( 6.8833E-05, 0.0000E+00),
     &  ( 6.8542E-05, 0.0000E+00),( 6.8263E-05, 0.0000E+00),
     &  ( 6.7995E-05, 0.0000E+00),( 6.7788E-05, 0.0000E+00),
     &  ( 6.7491E-05, 0.0000E+00),( 6.7030E-05, 0.0000E+00),
     &  ( 6.6609E-05, 0.0000E+00),( 6.6227E-05, 0.0000E+00),
     &  ( 6.5885E-05, 0.0000E+00),( 6.5583E-05, 0.0000E+00),
     &  ( 6.5325E-05, 0.0000E+00),( 6.5114E-05, 0.0000E+00),
     &  ( 6.4957E-05, 0.0000E+00),( 6.4863E-05, 0.0000E+00),
     &  ( 6.4847E-05, 0.0000E+00),( 6.4934E-05, 0.0000E+00),
     &  ( 6.5159E-05, 0.0000E+00),( 6.5584E-05, 0.0000E+00),
     &  ( 6.6324E-05, 0.0000E+00),( 6.6422E-05, 0.0000E+00),
     &  ( 6.7604E-05, 0.0000E+00),( 6.9947E-05, 0.0000E+00),
     &  ( 7.4860E-05, 0.0000E+00),( 8.4291E-05, 0.0000E+00),
     &  ( 8.8571E-05, 0.0000E+00),( 1.0806E-04, 0.0000E+00),
     &  ( 1.4870E-04, 0.0000E+00),( 1.6850E-04, 0.0000E+00),
     &  ( 1.9689E-04, 0.0000E+00),( 2.1611E-04, 0.0000E+00)/
  
         DATA ((CAS  (I,J), I=1301,1400), J=2,2) /
     &  ( 2.4036E-04, 0.0000E+00),( 2.6479E-04, 0.0000E+00),
     &  ( 2.9550E-04, 0.0000E+00),( 3.1399E-04, 0.0000E+00),
     &  ( 3.3517E-04, 0.0000E+00),( 3.5963E-04, 0.0000E+00),
     &  ( 3.8821E-04, 0.0000E+00),( 4.2200E-04, 0.0000E+00),
     &  ( 4.6255E-04, 0.0000E+00),( 4.8602E-04, 0.0000E+00),
     &  ( 5.1208E-04, 0.0000E+00),( 5.4119E-04, 0.0000E+00),
     &  ( 5.7390E-04, 0.0000E+00),( 6.1092E-04, 0.0000E+00),
     &  ( 6.5315E-04, 0.0000E+00),( 7.0178E-04, 0.0000E+00),
     &  ( 7.5836E-04, 0.0000E+00),( 8.2500E-04, 0.0000E+00),
     &  ( 8.5276E-04, 0.0000E+00),( 8.7018E-04, 0.0000E+00),
     &  ( 8.8833E-04, 0.0000E+00),( 9.0726E-04, 0.0000E+00),
     &  ( 9.2703E-04, 2.4958E-06),( 9.4768E-04, 2.6090E-06),
     &  ( 9.6928E-04, 2.7300E-06),( 9.9189E-04, 2.8596E-06),
     &  ( 1.0156E-03, 2.9987E-06),( 1.0405E-03, 3.1481E-06),
     &  ( 1.0666E-03, 3.3090E-06),( 1.0941E-03, 3.4826E-06),
     &  ( 1.1230E-03, 3.6701E-06),( 1.1535E-03, 3.8732E-06),
     &  ( 1.1858E-03, 4.0936E-06),( 1.2199E-03, 4.3334E-06),
     &  ( 1.2560E-03, 4.5949E-06),( 1.2944E-03, 4.8807E-06),
     &  ( 1.3351E-03, 5.1940E-06),( 1.3786E-03, 5.5385E-06),
     &  ( 1.4249E-03, 5.9184E-06),( 1.4745E-03, 6.3387E-06),
     &  ( 1.5277E-03, 6.8054E-06),( 1.5849E-03, 7.3256E-06),
     &  ( 1.6465E-03, 7.9077E-06),( 1.7132E-03, 8.5620E-06),
     &  ( 1.7854E-03, 9.3010E-06),( 1.8641E-03, 1.0140E-05),
     &  ( 1.9500E-03, 1.1098E-05),( 2.0442E-03, 1.2197E-05),
     &  ( 2.1480E-03, 1.3469E-05),( 2.2629E-03, 1.4951E-05),
     &  ( 2.3908E-03, 1.6691E-05),( 2.5341E-03, 1.8753E-05),
     &  ( 2.6956E-03, 2.1222E-05),( 2.8792E-03, 2.4213E-05),
     &  ( 3.0895E-03, 2.7884E-05),( 3.3331E-03, 3.2457E-05),
     &  ( 3.6184E-03, 3.8253E-05),( 3.9570E-03, 4.5753E-05),
     &  ( 4.3656E-03, 5.5695E-05),( 4.8683E-03, 6.9266E-05),
     &  ( 5.5018E-03, 8.8475E-05),( 6.3247E-03, 1.1694E-04),
     &  ( 7.4370E-03, 1.6171E-04),( 9.0237E-03, 2.3813E-04),
     &  ( 1.1470E-02, 3.8492E-04),( 1.5732E-02, 7.2484E-04),
     &  ( 2.5006E-02, 1.8373E-03),( 3.0756E-02, 7.2974E-05),
     &  ( 5.8581E-02, 7.3009E-05),( 8.1511E-02, 7.3020E-05),
     &  ( 9.8132E-02, 7.3025E-05),( 1.1099E-01, 7.3029E-05),
     &  ( 1.2156E-01, 7.3031E-05),( 1.3081E-01, 7.3032E-05),
     &  ( 1.3939E-01, 7.3034E-05),( 1.4536E-01, 7.3035E-05),
     &  ( 1.5144E-01, 7.3035E-05),( 1.5742E-01, 7.3036E-05),
     &  ( 1.6030E-01, 7.3037E-05),( 1.6434E-01, 7.3038E-05),
     &  ( 1.6676E-01, 7.3038E-05),( 1.6977E-01, 7.3039E-05),
     &  ( 1.7055E-01, 7.3039E-05),( 1.7171E-01, 7.3039E-05),
     &  ( 1.7219E-01, 7.3040E-05),( 1.7183E-01, 7.3040E-05),
     &  ( 1.7127E-01, 7.3041E-05),( 1.7044E-01, 7.3041E-05),
     &  ( 1.6779E-01, 7.3041E-05),( 1.6594E-01, 7.3042E-05),
     &  ( 1.6365E-01, 7.3042E-05),( 1.5778E-01, 7.3042E-05),
     &  ( 1.5413E-01, 7.3042E-05),( 1.4996E-01, 7.3043E-05),
     &  ( 1.4519E-01, 7.3043E-05),( 1.3400E-01, 7.3043E-05),
     &  ( 1.2743E-01, 7.3044E-05),( 1.2030E-01, 7.3044E-05),
     &  ( 1.0411E-01, 7.3044E-05),( 9.5149E-02, 7.3045E-05)/
  
         DATA ((CAS  (I,J), I=1401,1500), J=2,2) /
     &  ( 7.5425E-02, 7.3045E-05),( 5.3710E-02, 7.3045E-05),
     &  ( 5.7347E-03, 7.3047E-05),( 5.2997E-02, 7.3048E-05),
     &  ( 7.4767E-02, 7.3048E-05),( 9.4462E-02, 7.3048E-05),
     &  ( 1.1196E-01, 7.3049E-05),( 1.1983E-01, 7.3049E-05),
     &  ( 1.2699E-01, 7.3049E-05),( 1.3354E-01, 7.3050E-05),
     &  ( 1.4487E-01, 7.3050E-05),( 1.4963E-01, 7.3050E-05),
     &  ( 1.5388E-01, 7.3051E-05),( 1.5756E-01, 7.3051E-05),
     &  ( 1.6350E-01, 7.3051E-05),( 1.6578E-01, 7.3051E-05),
     &  ( 1.6769E-01, 7.3052E-05),( 1.7036E-01, 7.3052E-05),
     &  ( 1.7123E-01, 7.3052E-05),( 1.7211E-01, 7.3053E-05),
     &  ( 1.7219E-01, 7.3053E-05),( 1.7174E-01, 7.3054E-05),
     &  ( 1.7060E-01, 7.3054E-05),( 1.6893E-01, 7.3054E-05),
     &  ( 1.6684E-01, 7.3055E-05),( 1.6442E-01, 7.3055E-05),
     &  ( 1.6039E-01, 7.3056E-05),( 1.5753E-01, 7.3057E-05),
     &  ( 1.5154E-01, 7.3058E-05),( 1.4547E-01, 7.3058E-05),
     &  ( 1.3948E-01, 7.3059E-05),( 1.3090E-01, 7.3061E-05),
     &  ( 1.2164E-01, 7.3062E-05),( 1.1106E-01, 7.3064E-05),
     &  ( 9.8191E-02, 7.3067E-05),( 8.1554E-02, 7.3073E-05),
     &  ( 5.8267E-02, 7.3084E-05),( 3.1802E-02, 7.3117E-05),
     &  ( 1.8190E-02, 7.3171E-05),( 1.2727E-02, 7.3224E-05),
     &  ( 9.7854E-03, 7.3278E-05),( 7.9480E-03, 7.3331E-05),
     &  ( 6.6915E-03, 7.3385E-05),( 5.7780E-03, 7.3438E-05),
     &  ( 5.0840E-03, 7.3492E-05),( 4.5389E-03, 7.3545E-05),
     &  ( 4.0994E-03, 7.3599E-05),( 3.7375E-03, 7.3652E-05),
     &  ( 3.4344E-03, 7.3706E-05),( 3.1768E-03, 7.3759E-05),
     &  ( 2.9552E-03, 7.3813E-05),( 2.7626E-03, 7.3866E-05),
     &  ( 2.5935E-03, 7.3920E-05),( 2.4440E-03, 7.3973E-05),
     &  ( 2.3108E-03, 7.4027E-05),( 2.1914E-03, 7.4080E-05),
     &  ( 2.0837E-03, 7.4134E-05),( 1.9862E-03, 7.4187E-05),
     &  ( 1.8974E-03, 7.4241E-05),( 1.8162E-03, 7.4294E-05),
     &  ( 1.7417E-03, 7.4348E-05),( 1.6731E-03, 7.4401E-05),
     &  ( 1.6098E-03, 7.4455E-05),( 1.5510E-03, 7.4508E-05),
     &  ( 1.4964E-03, 7.4562E-05),( 1.4456E-03, 7.4615E-05),
     &  ( 1.3981E-03, 7.4669E-05),( 1.3536E-03, 7.4722E-05),
     &  ( 1.3119E-03, 7.4776E-05),( 1.2727E-03, 7.4829E-05),
     &  ( 1.2358E-03, 7.4883E-05),( 1.2010E-03, 7.4937E-05),
     &  ( 1.1681E-03, 7.4990E-05),( 1.1370E-03, 7.5044E-05),
     &  ( 1.1075E-03, 7.5097E-05),( 1.0795E-03, 7.5151E-05),
     &  ( 1.0529E-03, 7.5204E-05),( 1.0276E-03, 7.5258E-05),
     &  ( 1.0034E-03, 7.5311E-05),( 9.8045E-04, 7.5365E-05),
     &  ( 9.5849E-04, 7.5418E-05),( 9.3751E-04, 7.5472E-05),
     &  ( 9.1743E-04, 7.5525E-05),( 8.9821E-04, 7.5579E-05),
     &  ( 8.7979E-04, 7.5632E-05),( 8.6211E-04, 7.5686E-05),
     &  ( 8.4514E-04, 7.5739E-05),( 7.1719E-04, 7.6226E-05),
     &  ( 6.3880E-04, 7.6622E-05),( 5.6366E-04, 7.7109E-05),
     &  ( 4.7982E-04, 7.7838E-05),( 4.0148E-04, 7.8811E-05),
     &  ( 3.2438E-04, 8.0271E-05),( 2.8099E-04, 8.1487E-05),
     &  ( 2.2464E-04, 8.2703E-05),( 2.0564E-04, 8.2703E-05),
     &  ( 1.9092E-04, 8.2974E-05),( 1.7919E-04, 8.3244E-05),
     &  ( 1.6916E-04, 8.3514E-05),( 1.6173E-04, 8.3784E-05)/
  
         DATA ((CAS  (I,J), I=1501,1600), J=2,2) /
     &  ( 1.5181E-04, 8.4325E-05),( 1.4206E-04, 8.4866E-05),
     &  ( 1.3147E-04, 8.7568E-05),( 1.3544E-04, 9.0001E-05),
     &  ( 1.4813E-04, 9.0001E-05),( 1.9455E-04, 9.2433E-05),
     &  ( 2.8657E-04, 9.7298E-05),( 4.1911E-04, 9.9730E-05),
     &  ( 6.0085E-04, 1.0119E-04),( 8.5473E-04, 1.0216E-04),
     &  ( 1.4954E-03, 1.0277E-04),( 1.6171E-03, 1.0283E-04),
     &  ( 1.7606E-03, 1.0289E-04),( 1.8021E-03, 1.0291E-04),
     &  ( 1.8969E-03, 1.0294E-04),( 2.0022E-03, 1.0298E-04),
     &  ( 2.1199E-03, 1.0301E-04),( 2.2523E-03, 1.0304E-04),
     &  ( 2.4025E-03, 1.0308E-04),( 2.5740E-03, 1.0311E-04),
     &  ( 2.7720E-03, 1.0314E-04),( 3.0030E-03, 1.0318E-04),
     &  ( 3.2760E-03, 1.0321E-04),( 3.6037E-03, 1.0324E-04),
     &  ( 4.0042E-03, 1.0328E-04),( 4.5048E-03, 1.0331E-04),
     &  ( 5.1485E-03, 1.0334E-04),( 6.0067E-03, 1.0338E-04),
     &  ( 7.2083E-03, 1.0341E-04),( 9.0107E-03, 1.0344E-04),
     &  ( 1.2014E-02, 1.5633E-04),( 1.8021E-02, 2.8326E-04),
     &  ( 2.6078E-02, 5.6191E-04),( 2.7430E-02, 6.1979E-04),
     &  ( 2.8930E-02, 6.8763E-04),( 3.0604E-02, 7.6779E-04),
     &  ( 3.2483E-02, 8.6336E-04),( 3.4608E-02, 9.7851E-04),
     &  ( 3.7030E-02, 1.1189E-03),( 3.9815E-02, 1.2924E-03),
     &  ( 4.3054E-02, 1.5101E-03),( 4.6865E-02, 1.7885E-03),
     &  ( 5.1415E-02, 2.1521E-03),( 5.6941E-02, 2.6396E-03),
     &  ( 6.3795E-02, 3.3142E-03),( 7.2518E-02, 4.2850E-03),
     &  ( 8.3991E-02, 5.7542E-03),( 9.9749E-02, 8.1306E-03),
     &  ( 1.2271E-01, 1.2346E-02),( 1.5916E-01, 2.0915E-02),
     &  ( 2.2532E-01, 4.2671E-02),( 3.7498E-01, 1.2708E-01),
     &  ( 4.2744E-01, 1.7202E-01),( 4.6874E-01, 2.1558E-01),
     &  ( 5.1476E-01, 2.7621E-01),( 5.5339E-01, 3.4262E-01),
     &  ( 5.8124E-01, 4.0681E-01),( 6.0487E-01, 4.8684E-01),
     &  ( 6.1575E-01, 5.5067E-01),( 6.2008E-01, 6.2385E-01),
     &  ( 6.1464E-01, 7.0672E-01),( 5.9538E-01, 7.9867E-01),
     &  ( 5.5753E-01, 8.6234E-01),( 5.5753E-01, 8.7234E-01),
     &  ( 5.5753E-01, 8.7735E-01),( 5.5753E-01, 8.8740E-01),
     &  ( 5.5753E-01, 8.9142E-01),( 5.5753E-01, 8.9445E-01),
     &  ( 5.5753E-01, 8.9747E-01),( 5.4181E-01, 9.2784E-01),
     &  ( 5.1400E-01, 9.7342E-01),( 4.7679E-01, 1.0234E+00),
     &  ( 4.3737E-01, 1.0667E+00),( 3.8688E-01, 1.1121E+00),
     &  ( 3.2950E-01, 1.1531E+00),( 2.7238E-01, 1.1850E+00),
     &  ( 2.0361E-01, 1.2004E+00),( 2.0361E-01, 1.2139E+00),
     &  ( 1.1533E-01, 1.2253E+00),( 1.1533E-01, 1.2376E+00),
     &  ( 3.8745E-02, 1.2436E+00),( 3.8745E-02, 1.2473E+00),
     &  ( 3.8737E-02, 1.2483E+00),( 3.8737E-02, 1.2484E+00),
     &  ( 3.8737E-02, 1.2485E+00),( 3.8737E-02, 1.2485E+00),
     &  ( 3.8737E-02, 1.2485E+00),( 3.8737E-02, 1.2484E+00),
     &  ( 3.8737E-02, 1.2473E+00),( 1.1532E-01, 1.2436E+00),
     &  ( 1.1532E-01, 1.2376E+00),( 2.8549E-01, 1.1784E+00),
     &  ( 3.4741E-01, 1.1413E+00),( 4.4662E-01, 1.0573E+00),
     &  ( 4.8478E-01, 1.0135E+00),( 5.2063E-01, 9.6332E-01),
     &  ( 5.4994E-01, 9.1265E-01),( 5.7113E-01, 8.6734E-01),
     &  ( 5.8945E-01, 8.1800E-01),( 6.0174E-01, 7.7493E-01)/
  
         DATA ((CAS  (I,J), I=1601,1700), J=2,2) /
     &  ( 6.1130E-01, 7.2892E-01),( 6.1669E-01, 6.8939E-01),
     &  ( 6.1964E-01, 6.4771E-01),( 6.1996E-01, 6.1227E-01),
     &  ( 6.1816E-01, 5.7520E-01),( 6.1492E-01, 5.4388E-01),
     &  ( 6.0420E-01, 4.8389E-01),( 5.9698E-01, 4.5545E-01),
     &  ( 5.8897E-01, 4.2900E-01),( 5.8125E-01, 4.0681E-01),
     &  ( 5.6386E-01, 3.6453E-01),( 5.5435E-01, 3.4455E-01),
     &  ( 5.3890E-01, 3.1545E-01),( 5.1476E-01, 2.7622E-01),
     &  ( 4.2745E-01, 1.7202E-01),( 3.5981E-01, 1.1584E-01),
     &  ( 3.0859E-01, 8.2792E-02),( 2.6924E-01, 6.1917E-02),
     &  ( 2.3836E-01, 4.7963E-02),( 2.1359E-01, 3.8205E-02),
     &  ( 1.8887E-01, 2.9663E-02),( 1.5027E-01, 1.8608E-02),
     &  ( 1.3982E-01, 1.6078E-02),( 1.3072E-01, 1.4029E-02),
     &  ( 1.2272E-01, 1.2347E-02),( 1.1082E-01, 1.0051E-02),
     &  ( 9.1728E-02, 6.8689E-03),( 7.8224E-02, 4.9883E-03),
     &  ( 6.8175E-02, 3.7859E-03),( 6.0409E-02, 2.9712E-03),
     &  ( 5.4228E-02, 2.3940E-03),( 4.9193E-02, 1.9702E-03),
     &  ( 4.5012E-02, 1.6501E-03),( 4.1485E-02, 1.4025E-03),
     &  ( 3.8471E-02, 1.2070E-03),( 3.5865E-02, 1.0501E-03),
     &  ( 3.3589E-02, 9.2235E-04),( 3.1584E-02, 8.1692E-04),
     &  ( 2.9806E-02, 7.2897E-04),( 2.8216E-02, 6.5488E-04),
     &  ( 2.6788E-02, 5.9193E-04),( 1.8027E-02, 2.8347E-04),
     &  ( 1.2020E-02, 1.5655E-04),( 9.0166E-03, 1.2293E-04),
     &  ( 6.0127E-03, 1.0378E-04),( 4.5107E-03, 1.0384E-04),
     &  ( 3.6096E-03, 1.0391E-04),( 3.0090E-03, 1.0398E-04),
     &  ( 2.5800E-03, 1.0405E-04),( 2.2583E-03, 1.0411E-04),
     &  ( 2.0082E-03, 1.0418E-04),( 1.8082E-03, 1.0425E-04),
     &  ( 1.6947E-03, 1.0429E-04),( 1.5624E-03, 1.0435E-04),
     &  ( 1.4493E-03, 1.0441E-04),( 1.3516E-03, 1.0447E-04),
     &  ( 1.2664E-03, 1.0453E-04),( 1.1914E-03, 1.0460E-04),
     &  ( 9.2027E-04, 1.0480E-04),( 7.5115E-04, 1.0500E-04),
     &  ( 6.3608E-04, 1.0520E-04),( 5.5309E-04, 1.0541E-04),
     &  ( 4.9100E-04, 1.0561E-04),( 4.4381E-04, 1.0581E-04),
     &  ( 4.0430E-04, 1.0601E-04),( 3.7196E-04, 1.0622E-04),
     &  ( 1.8486E-04, 1.0703E-04),( 1.7803E-04, 1.1554E-04),
     &  ( 1.8555E-04, 1.1724E-04),( 1.8980E-04, 1.1895E-04),
     &  ( 2.0040E-04, 1.2065E-04),( 2.1911E-04, 1.2235E-04),
     &  ( 2.3024E-04, 1.2320E-04),( 2.4623E-04, 1.2405E-04),
     &  ( 2.8780E-04, 1.2089E-04),( 3.5796E-04, 1.1773E-04),
     &  ( 4.8780E-04, 1.1457E-04),( 7.9677E-04, 1.1141E-04),
     &  ( 1.0968E-03, 1.1008E-04),( 1.1746E-03, 1.0985E-04),
     &  ( 1.2644E-03, 1.0961E-04),( 1.3692E-03, 1.0938E-04),
     &  ( 1.4931E-03, 1.0915E-04),( 1.6419E-03, 1.0892E-04),
     &  ( 1.8238E-03, 1.0869E-04),( 2.0513E-03, 1.0845E-04),
     &  ( 2.3438E-03, 1.0822E-04),( 2.7340E-03, 1.0799E-04),
     &  ( 3.2804E-03, 1.0776E-04),( 4.1001E-03, 1.0847E-04),
     &  ( 5.4665E-03, 1.1026E-04),( 5.7042E-03, 1.1078E-04),
     &  ( 5.9635E-03, 1.1142E-04),( 6.2474E-03, 1.1223E-04),
     &  ( 6.5598E-03, 1.1325E-04),( 6.9050E-03, 1.1456E-04),
     &  ( 7.2886E-03, 1.1626E-04),( 7.7173E-03, 1.1846E-04),
     &  ( 8.1996E-03, 1.2137E-04),( 8.7462E-03, 1.2525E-04)/
  
         DATA ((CAS  (I,J), I=1701,1800), J=2,2) /
     &  ( 9.3710E-03, 1.3049E-04),( 1.0092E-02, 1.3764E-04),
     &  ( 1.0933E-02, 1.4755E-04),( 1.1926E-02, 1.6145E-04),
     &  ( 1.3119E-02, 1.8125E-04),( 1.4576E-02, 2.0994E-04),
     &  ( 1.5032E-02, 2.1988E-04),( 1.6398E-02, 2.5243E-04),
     &  ( 1.8739E-02, 3.1722E-04),( 2.1861E-02, 4.2033E-04),
     &  ( 2.6229E-02, 5.9501E-04),( 3.2778E-02, 9.2062E-04),
     &  ( 4.3678E-02, 1.6281E-03),( 6.5407E-02, 3.6510E-03),
     &  ( 1.2963E-01, 1.4467E-02),( 1.5412E-01, 2.0554E-02),
     &  ( 2.1738E-01, 4.1641E-02),( 2.6549E-01, 6.3304E-02),
     &  ( 3.0513E-01, 8.5280E-02),( 3.3972E-01, 1.0792E-01),
     &  ( 3.7042E-01, 1.3111E-01),( 3.9796E-01, 1.5478E-01),
     &  ( 4.2255E-01, 1.7861E-01),( 4.4535E-01, 2.0338E-01),
     &  ( 4.6688E-01, 2.2961E-01),( 4.8656E-01, 2.5656E-01),
     &  ( 5.0387E-01, 2.8320E-01),( 5.1988E-01, 3.1100E-01),
     &  ( 5.3432E-01, 3.3948E-01),( 5.4696E-01, 3.6809E-01),
     &  ( 5.5897E-01, 3.9985E-01),( 5.6881E-01, 4.3100E-01),
     &  ( 5.7649E-01, 4.6071E-01),( 5.8804E-01, 4.9288E-01),
     &  ( 5.8804E-01, 5.2765E-01),( 5.9115E-01, 5.6515E-01),
     &  ( 5.9061E-01, 5.9951E-01),( 5.9061E-01, 6.3595E-01),
     &  ( 5.8004E-01, 6.7444E-01),( 5.8004E-01, 7.1487E-01),
     &  ( 5.6990E-01, 7.5710E-01),( 5.4083E-01, 7.9348E-01),
     &  ( 5.4083E-01, 8.3824E-01),( 5.1837E-01, 8.8375E-01),
     &  ( 4.5113E-01, 9.2942E-01),( 4.5113E-01, 9.8185E-01),
     &  ( 4.0355E-01, 1.0320E+00),( 3.3923E-01, 1.0844E+00),
     &  ( 2.5494E-01, 1.1339E+00),( 1.0454E-04, 1.1909E+00),
     &  ( 1.0454E-04, 1.1920E+00),( 1.1540E-01, 1.1805E+00),
     &  ( 2.5494E-01, 1.1339E+00),( 4.0354E-01, 1.0844E+00),
     &  ( 4.0354E-01, 1.0320E+00),( 4.5112E-01, 9.8185E-01),
     &  ( 5.1836E-01, 9.2942E-01),( 5.1836E-01, 8.8376E-01),
     &  ( 5.4083E-01, 8.3824E-01),( 5.6990E-01, 7.9348E-01),
     &  ( 5.6990E-01, 7.5711E-01),( 5.8004E-01, 7.1488E-01),
     &  ( 5.9061E-01, 6.7444E-01),( 5.9061E-01, 6.3596E-01),
     &  ( 5.9115E-01, 5.9952E-01),( 5.9115E-01, 5.6515E-01),
     &  ( 5.8804E-01, 5.2766E-01),( 5.8302E-01, 4.9289E-01),
     &  ( 5.6881E-01, 4.6072E-01),( 5.6881E-01, 4.3101E-01),
     &  ( 5.5897E-01, 3.9986E-01),( 5.4696E-01, 3.6810E-01),
     &  ( 5.3432E-01, 3.3949E-01),( 5.1988E-01, 3.1100E-01),
     &  ( 5.0387E-01, 2.8320E-01),( 4.8656E-01, 2.5656E-01),
     &  ( 4.6689E-01, 2.2961E-01),( 4.4536E-01, 2.0338E-01),
     &  ( 4.2256E-01, 1.7862E-01),( 3.9796E-01, 1.5479E-01),
     &  ( 3.7042E-01, 1.3111E-01),( 3.3973E-01, 1.0793E-01),
     &  ( 3.0513E-01, 8.5281E-02),( 2.6549E-01, 6.3306E-02),
     &  ( 2.1738E-01, 4.1642E-02),( 1.5412E-01, 2.0555E-02),
     &  ( 1.3197E-01, 1.5000E-02),( 1.2781E-01, 1.4059E-02),
     &  ( 1.2266E-01, 1.2936E-02),( 1.0842E-01, 1.0084E-02),
     &  ( 9.5596E-02, 7.8240E-03),( 6.5407E-02, 3.6510E-03),
     &  ( 4.3681E-02, 1.6284E-03),( 3.2781E-02, 9.2074E-04),
     &  ( 2.6232E-02, 5.9509E-04),( 2.1864E-02, 4.2037E-04),
     &  ( 1.8743E-02, 3.1719E-04),( 1.6401E-02, 2.5231E-04),
     &  ( 1.4580E-02, 2.0975E-04),( 1.3122E-02, 1.8097E-04)/
  
         DATA ((CAS  (I,J), I=1801,1900), J=2,2) /
     &  ( 1.1930E-02, 1.6108E-04),( 1.0936E-02, 1.4709E-04),
     &  ( 1.0095E-02, 1.3709E-04),( 9.3744E-03, 1.2985E-04),
     &  ( 8.7497E-03, 1.2454E-04),( 8.2031E-03, 1.2058E-04),
     &  ( 5.4700E-03, 1.0892E-04),( 4.1036E-03, 1.0664E-04),
     &  ( 3.2838E-03, 1.0584E-04),( 2.7374E-03, 1.0540E-04),
     &  ( 2.3472E-03, 1.0498E-04),( 2.0546E-03, 1.0474E-04),
     &  ( 1.8271E-03, 1.0451E-04),( 1.4963E-03, 1.0405E-04),
     &  ( 1.2676E-03, 1.0359E-04),( 1.1777E-03, 1.0335E-04),
     &  ( 1.0999E-03, 1.0312E-04),( 8.2074E-04, 1.0192E-04),
     &  ( 6.1751E-04, 1.0034E-04),( 4.9707E-04, 9.8758E-05),
     &  ( 4.1774E-04, 9.7176E-05),( 3.6175E-04, 9.5595E-05),
     &  ( 3.2031E-04, 9.4014E-05),( 2.8853E-04, 9.2433E-05),
     &  ( 2.6352E-04, 9.3799E-05),( 2.4343E-04, 9.5165E-05),
     &  ( 2.2704E-04, 9.6547E-05),( 2.1354E-04, 9.7913E-05),
     &  ( 2.0232E-04, 9.9280E-05),( 1.9297E-04, 1.0065E-04),
     &  ( 1.8519E-04, 1.0201E-04),( 1.7877E-04, 1.0338E-04),
     &  ( 1.7361E-04, 1.0475E-04),( 1.6968E-04, 1.0611E-04),
     &  ( 1.6711E-04, 1.0748E-04),( 1.6631E-04, 1.0885E-04),
     &  ( 1.6591E-04, 1.1021E-04),( 1.6245E-04, 1.1158E-04),
     &  ( 1.6387E-04, 1.1252E-04),( 1.9034E-04, 1.2980E-04),
     &  ( 1.9658E-04, 1.3769E-04),( 2.1553E-04, 1.4592E-04),
     &  ( 2.3304E-04, 1.5536E-04),( 2.4786E-04, 1.6605E-04),
     &  ( 2.6122E-04, 1.7786E-04),( 2.7252E-04, 1.9066E-04),
     &  ( 2.8241E-04, 2.0428E-04),( 2.9087E-04, 2.1848E-04),
     &  ( 2.9788E-04, 2.3324E-04),( 3.0376E-04, 2.4851E-04),
     &  ( 3.0847E-04, 2.6407E-04),( 3.1196E-04, 2.7982E-04),
     &  ( 3.1442E-04, 2.9575E-04),( 3.1587E-04, 3.1203E-04),
     &  ( 3.1622E-04, 3.2838E-04),( 3.1564E-04, 3.4454E-04),
     &  ( 3.1408E-04, 3.6085E-04),( 3.1146E-04, 3.7743E-04),
     &  ( 3.0790E-04, 3.9382E-04),( 3.0348E-04, 4.0984E-04),
     &  ( 2.9786E-04, 4.2635E-04),( 2.9144E-04, 4.4219E-04),
     &  ( 2.8383E-04, 4.5828E-04),( 2.7514E-04, 4.7413E-04),
     &  ( 2.6520E-04, 4.8996E-04),( 2.5399E-04, 5.0562E-04),
     &  ( 2.4152E-04, 5.2093E-04),( 2.2786E-04, 5.3569E-04),
     &  ( 2.1206E-04, 5.5063E-04),( 1.9457E-04, 5.6501E-04),
     &  ( 1.7534E-04, 5.7860E-04),( 1.5340E-04, 5.9172E-04),
     &  ( 1.2962E-04, 6.0343E-04),( 1.1736E-04, 6.0863E-04),
     &  ( 1.6857E-04, 5.8318E-04),( 1.9588E-04, 5.6437E-04),
     &  ( 2.1704E-04, 5.4659E-04),( 2.3400E-04, 5.2982E-04),
     &  ( 2.4852E-04, 5.1319E-04),( 2.6103E-04, 4.9674E-04),
     &  ( 2.7141E-04, 4.8110E-04),( 2.8054E-04, 4.6539E-04),
     &  ( 2.8843E-04, 4.4977E-04),( 2.9516E-04, 4.3434E-04),
     &  ( 3.0080E-04, 4.1922E-04),( 3.0548E-04, 4.0415E-04),
     &  ( 3.0920E-04, 3.8956E-04),( 3.1219E-04, 3.7458E-04),
     &  ( 3.1424E-04, 3.6025E-04),( 3.1556E-04, 3.4577E-04),
     &  ( 3.1612E-04, 3.3129E-04),( 3.1585E-04, 3.1721E-04),
     &  ( 3.1481E-04, 3.0339E-04),( 3.1302E-04, 2.8955E-04),
     &  ( 3.1034E-04, 2.7591E-04),( 3.0687E-04, 2.6267E-04),
     &  ( 3.0259E-04, 2.4972E-04),( 2.9709E-04, 2.3705E-04),
     &  ( 2.9093E-04, 2.2475E-04),( 2.8402E-04, 2.1310E-04)/
  
         DATA ((CAS  (I,J), I=1901,2000), J=2,2) /
     &  ( 2.7559E-04, 2.0188E-04),( 2.6606E-04, 1.9140E-04),
     &  ( 2.5541E-04, 1.8181E-04),( 2.4286E-04, 1.7331E-04),
     &  ( 2.2935E-04, 1.6611E-04),( 2.1332E-04, 1.6056E-04),
     &  ( 1.9698E-04, 1.5720E-04),( 1.7549E-04, 1.5736E-04),
     &  ( 1.5557E-04, 1.7121E-04),( 1.5450E-04, 1.7206E-04),
     &  ( 1.3858E-04, 1.7861E-04),( 1.3388E-04, 1.8347E-04),
     &  ( 1.3295E-04, 1.8733E-04),( 1.3181E-04, 1.9056E-04),
     &  ( 1.2862E-04, 1.9337E-04),( 1.2654E-04, 1.9588E-04),
     &  ( 1.2578E-04, 1.9819E-04),( 1.2539E-04, 2.0035E-04),
     &  ( 1.2519E-04, 2.0239E-04),( 1.2480E-04, 2.0437E-04),
     &  ( 1.2423E-04, 2.0628E-04),( 1.2396E-04, 2.0815E-04),
     &  ( 1.2361E-04, 2.1001E-04),( 1.2353E-04, 2.1185E-04),
     &  ( 1.2347E-04, 2.1368E-04),( 1.2304E-04, 2.1551E-04),
     &  ( 1.2274E-04, 2.1736E-04),( 1.2229E-04, 2.1921E-04),
     &  ( 1.2191E-04, 2.2110E-04),( 1.2157E-04, 2.2299E-04),
     &  ( 1.2122E-04, 2.2491E-04),( 1.2059E-04, 2.2686E-04),
     &  ( 1.1996E-04, 2.2884E-04),( 1.1933E-04, 2.3085E-04),
     &  ( 1.1870E-04, 2.3290E-04),( 1.1808E-04, 2.3498E-04),
     &  ( 1.1751E-04, 2.3711E-04),( 1.1711E-04, 2.3929E-04),
     &  ( 1.1627E-04, 2.4151E-04),( 1.1557E-04, 2.4380E-04),
     &  ( 1.1574E-04, 2.4616E-04),( 1.1154E-04, 2.4862E-04),
     &  ( 1.0789E-04, 2.5121E-04),( 1.0640E-04, 2.5403E-04),
     &  ( 1.0019E-04, 2.5822E-04),( 1.0597E-04, 2.5886E-04),
     &  ( 1.0899E-04, 2.5834E-04),( 1.1049E-04, 2.5767E-04),
     &  ( 1.1346E-04, 2.5693E-04),( 1.1575E-04, 2.5616E-04),
     &  ( 1.1605E-04, 2.5537E-04),( 1.1667E-04, 2.5459E-04),
     &  ( 1.1761E-04, 2.5382E-04),( 1.1825E-04, 2.5305E-04),
     &  ( 1.1895E-04, 2.5231E-04),( 1.1973E-04, 2.5158E-04),
     &  ( 1.2055E-04, 2.5088E-04),( 1.2138E-04, 2.5021E-04),
     &  ( 1.2221E-04, 2.4957E-04),( 1.2304E-04, 2.4896E-04),
     &  ( 1.2387E-04, 2.4838E-04),( 1.2472E-04, 2.4784E-04),
     &  ( 1.2559E-04, 2.4733E-04),( 1.2651E-04, 2.4687E-04),
     &  ( 1.2732E-04, 2.4645E-04),( 1.2809E-04, 2.4607E-04),
     &  ( 1.2897E-04, 2.4575E-04),( 1.2998E-04, 2.4547E-04),
     &  ( 1.3118E-04, 2.4525E-04),( 1.3246E-04, 2.4508E-04),
     &  ( 1.3365E-04, 2.4498E-04),( 1.3496E-04, 2.4495E-04),
     &  ( 1.3674E-04, 2.4499E-04),( 1.3919E-04, 2.4511E-04),
     &  ( 1.4236E-04, 2.4532E-04),( 1.4660E-04, 2.4563E-04),
     &  ( 1.5254E-04, 2.4605E-04),( 1.5266E-04, 2.4661E-04),
     &  ( 1.4804E-04, 2.4733E-04),( 1.4246E-04, 2.4823E-04),
     &  ( 1.4305E-04, 2.5781E-04),( 1.4512E-04, 2.5859E-04),
     &  ( 1.4713E-04, 2.5939E-04),( 1.4909E-04, 2.6020E-04),
     &  ( 1.5094E-04, 2.6101E-04),( 1.5267E-04, 2.6183E-04),
     &  ( 1.5433E-04, 2.6266E-04),( 1.5593E-04, 2.6349E-04),
     &  ( 1.5747E-04, 2.6434E-04),( 1.5451E-04, 2.6520E-04),
     &  ( 1.5159E-04, 2.6607E-04),( 1.4910E-04, 2.6695E-04),
     &  ( 1.4697E-04, 2.6784E-04),( 1.4506E-04, 2.6874E-04),
     &  ( 1.4331E-04, 2.6965E-04),( 1.4173E-04, 2.7058E-04),
     &  ( 1.4032E-04, 2.7151E-04),( 1.3903E-04, 2.7245E-04),
     &  ( 1.3783E-04, 2.7342E-04),( 1.3666E-04, 2.7439E-04)/
  
         DATA ((CAS  (I,J), I=2001,2100), J=2,2) /
     &  ( 1.3551E-04, 2.7539E-04),( 1.3445E-04, 2.7639E-04),
     &  ( 1.3350E-04, 2.7741E-04),( 1.3251E-04, 2.7845E-04),
     &  ( 1.3152E-04, 2.7950E-04),( 1.3082E-04, 2.8058E-04),
     &  ( 1.2969E-04, 2.8166E-04),( 1.2918E-04, 2.8277E-04),
     &  ( 1.2691E-04, 2.8391E-04),( 1.2476E-04, 2.8507E-04),
     &  ( 1.2306E-04, 2.8625E-04),( 1.2218E-04, 2.8748E-04),
     &  ( 1.1954E-04, 2.8875E-04),( 1.1663E-04, 2.9010E-04),
     &  ( 1.1483E-04, 2.9157E-04),( 1.1256E-04, 2.9379E-04),
     &  ( 1.1470E-04, 2.9413E-04),( 1.1647E-04, 2.9374E-04),
     &  ( 1.1936E-04, 2.9325E-04),( 1.2200E-04, 2.9272E-04),
     &  ( 1.2289E-04, 2.9216E-04),( 1.2460E-04, 2.9160E-04),
     &  ( 1.2678E-04, 2.9102E-04),( 1.2908E-04, 2.9045E-04),
     &  ( 1.2958E-04, 2.8988E-04),( 1.3072E-04, 2.8932E-04),
     &  ( 1.3140E-04, 2.8877E-04),( 1.3238E-04, 2.8822E-04),
     &  ( 1.3335E-04, 2.8769E-04),( 1.3426E-04, 2.8716E-04),
     &  ( 1.3528E-04, 2.8666E-04),( 1.3638E-04, 2.8616E-04),
     &  ( 1.3747E-04, 2.8567E-04),( 1.3855E-04, 2.8521E-04),
     &  ( 1.3972E-04, 2.8475E-04),( 1.4097E-04, 2.8432E-04),
     &  ( 1.4235E-04, 2.8391E-04),( 1.4385E-04, 2.8351E-04),
     &  ( 1.4543E-04, 2.8313E-04),( 1.4714E-04, 2.8276E-04),
     &  ( 1.4910E-04, 2.8235E-04),( 1.5135E-04, 2.8195E-04),
     &  ( 1.5372E-04, 2.8157E-04),( 1.5414E-04, 2.8121E-04),
     &  ( 1.5500E-04, 2.8087E-04),( 1.5644E-04, 2.8055E-04),
     &  ( 1.5870E-04, 2.8026E-04),( 1.6202E-04, 2.7998E-04),
     &  ( 1.6525E-04, 2.7973E-04),( 1.6361E-04, 2.7951E-04),
     &  ( 1.6197E-04, 2.7931E-04),( 1.5456E-04, 2.7875E-04),
     &  ( 1.6666E-04, 2.8010E-04),( 1.7473E-04, 2.8360E-04),
     &  ( 1.7753E-04, 2.8756E-04),( 1.7963E-04, 2.9192E-04),
     &  ( 1.8147E-04, 2.9618E-04),( 1.8342E-04, 3.0067E-04),
     &  ( 1.8547E-04, 3.0498E-04),( 1.8738E-04, 3.0950E-04),
     &  ( 1.8923E-04, 3.1403E-04),( 1.9074E-04, 3.1836E-04),
     &  ( 1.9245E-04, 3.2290E-04),( 1.9402E-04, 3.2723E-04),
     &  ( 1.8530E-04, 3.3177E-04),( 1.7696E-04, 3.3611E-04),
     &  ( 1.6824E-04, 3.4064E-04),( 1.5990E-04, 3.4498E-04),
     &  ( 1.5118E-04, 3.4951E-04),( 1.4284E-04, 3.5385E-04),
     &  ( 1.3412E-04, 3.5839E-04),( 1.2554E-04, 0.0000E+00),
     &  ( 1.1693E-04, 0.0000E+00),( 1.0793E-04, 0.0000E+00),
     &  ( 9.9321E-05, 0.0000E+00),( 9.0321E-05, 0.0000E+00),
     &  ( 8.1712E-05, 0.0000E+00),( 7.2712E-05, 0.0000E+00),
     &  ( 7.1165E-05, 0.0000E+00),( 6.9877E-05, 0.0000E+00),
     &  ( 6.8869E-05, 0.0000E+00),( 6.7988E-05, 0.0000E+00),
     &  ( 6.7273E-05, 0.0000E+00),( 6.6627E-05, 0.0000E+00),
     &  ( 6.6088E-05, 0.0000E+00),( 6.5591E-05, 0.0000E+00),
     &  ( 6.5149E-05, 0.0000E+00),( 6.4769E-05, 0.0000E+00),
     &  ( 6.4410E-05, 0.0000E+00),( 6.4098E-05, 0.0000E+00),
     &  ( 6.3798E-05, 0.0000E+00),( 6.3535E-05, 0.0000E+00),
     &  ( 6.3281E-05, 0.0000E+00),( 6.3055E-05, 0.0000E+00),
     &  ( 6.2836E-05, 0.0000E+00),( 6.2639E-05, 0.0000E+00),
     &  ( 6.2447E-05, 0.0000E+00),( 6.2273E-05, 0.0000E+00),
     &  ( 6.2110E-05, 0.0000E+00),( 6.1949E-05, 0.0000E+00)/
  
         DATA ((CAS  (I,J), I=2101,2193), J=2,2) /
     &  ( 6.1802E-05, 0.0000E+00),( 6.1657E-05, 0.0000E+00),
     &  ( 6.1525E-05, 0.0000E+00),( 6.1394E-05, 0.0000E+00),
     &  ( 6.1274E-05, 0.0000E+00),( 6.1154E-05, 0.0000E+00),
     &  ( 6.1044E-05, 0.0000E+00),( 6.0934E-05, 0.0000E+00),
     &  ( 6.0832E-05, 0.0000E+00),( 6.0731E-05, 0.0000E+00),
     &  ( 6.0633E-05, 0.0000E+00),( 6.0543E-05, 0.0000E+00),
     &  ( 6.0452E-05, 0.0000E+00),( 6.0369E-05, 0.0000E+00),
     &  ( 6.0284E-05, 0.0000E+00),( 6.0206E-05, 0.0000E+00),
     &  ( 6.0126E-05, 0.0000E+00),( 6.0053E-05, 0.0000E+00),
     &  ( 5.9978E-05, 0.0000E+00),( 5.9909E-05, 0.0000E+00),
     &  ( 5.9839E-05, 0.0000E+00),( 5.9774E-05, 0.0000E+00),
     &  ( 5.9710E-05, 0.0000E+00),( 5.9646E-05, 0.0000E+00),
     &  ( 5.9585E-05, 0.0000E+00),( 5.9524E-05, 0.0000E+00),
     &  ( 5.9467E-05, 0.0000E+00),( 5.9409E-05, 0.0000E+00),
     &  ( 5.9355E-05, 0.0000E+00),( 5.9299E-05, 0.0000E+00),
     &  ( 5.9247E-05, 0.0000E+00),( 5.9195E-05, 0.0000E+00),
     &  ( 5.9145E-05, 0.0000E+00),( 5.9095E-05, 0.0000E+00),
     &  ( 5.9045E-05, 0.0000E+00),( 5.8999E-05, 0.0000E+00),
     &  ( 5.8951E-05, 0.0000E+00),( 5.8896E-05, 0.0000E+00),
     &  ( 5.8858E-05, 0.0000E+00),( 5.8822E-05, 0.0000E+00),
     &  ( 5.8784E-05, 0.0000E+00),( 5.8748E-05, 0.0000E+00),
     &  ( 5.8710E-05, 0.0000E+00),( 5.8674E-05, 0.0000E+00),
     &  ( 5.8636E-05, 0.0000E+00),( 5.8600E-05, 0.0000E+00),
     &  ( 5.8562E-05, 0.0000E+00),( 5.8526E-05, 0.0000E+00),
     &  ( 5.8490E-05, 0.0000E+00),( 5.8452E-05, 0.0000E+00),
     &  ( 5.8416E-05, 0.0000E+00),( 5.8378E-05, 0.0000E+00),
     &  ( 5.8342E-05, 0.0000E+00),( 5.8304E-05, 0.0000E+00),
     &  ( 5.8268E-05, 0.0000E+00),( 5.8230E-05, 0.0000E+00),
     &  ( 5.8194E-05, 0.0000E+00),( 5.8156E-05, 0.0000E+00),
     &  ( 5.8120E-05, 0.0000E+00),( 5.8082E-05, 0.0000E+00),
     &  ( 5.7787E-05, 0.0000E+00),( 5.7492E-05, 0.0000E+00),
     &  ( 5.7456E-05, 0.0000E+00),( 5.6098E-05, 0.0000E+00),
     &  ( 5.5672E-05, 0.0000E+00),( 5.4847E-05, 0.0000E+00),
     &  ( 5.4512E-05, 0.0000E+00),( 5.4497E-05, 0.0000E+00),
     &  ( 5.4151E-05, 0.0000E+00),( 5.4150E-05, 0.0000E+00),
     &  ( 5.3948E-05, 0.0000E+00),( 5.3941E-05, 0.0000E+00),
     &  ( 5.3937E-05, 0.0000E+00),( 5.3850E-05, 0.0000E+00),
     &  ( 5.3798E-05, 0.0000E+00),( 5.3789E-05, 0.0000E+00),
     &  ( 5.3775E-05, 0.0000E+00),( 5.3754E-05, 0.0000E+00),
     &  ( 5.3739E-05, 0.0000E+00),( 5.3731E-05, 0.0000E+00),
     &  ( 5.3650E-05, 0.0000E+00),( 5.3646E-05, 0.0000E+00),
     &  ( 5.3624E-05, 0.0000E+00),( 5.3620E-05, 0.0000E+00),
     &  ( 5.3602E-05, 0.0000E+00),( 5.3596E-05, 0.0000E+00),
     &  ( 5.3590E-05, 0.0000E+00),( 5.3585E-05, 0.0000E+00),
     &  ( 5.3571E-05, 0.0000E+00),( 5.3551E-05, 0.0000E+00),
     &  ( 5.3543E-05, 0.0000E+00),( 5.3492E-05, 0.0000E+00),
     &  ( 5.3452E-05, 0.0000E+00)/
  
         DATA ((CAS  (I,J), I=   1, 100), J=3,3) /
     &  ( 5.0380E-06, 0.0000E+00),( 5.3301E-06, 5.1507E-12),
     &  ( 5.6518E-06, 3.4316E-10),( 6.0084E-06, 1.2926E-09),
     &  ( 6.4236E-06, 3.5116E-09),( 6.9175E-06, 7.7238E-09),
     &  ( 7.4919E-06, 1.4769E-08),( 8.0212E-06, 2.5712E-06),
     &  ( 8.3324E-06, 1.9383E-06),( 8.9053E-06, 2.5770E-06),
     &  ( 8.9395E-06, 2.4109E-06),( 8.9458E-06, 3.7762E-06),
     &  ( 8.8912E-06, 4.4917E-06),( 8.9655E-06, 4.3194E-06),
     &  ( 8.8393E-06, 2.9211E-06),( 8.8404E-06, 3.3728E-06),
     &  ( 8.9451E-06, 2.7284E-06),( 9.2217E-06, 3.1589E-06),
     &  ( 9.3483E-06, 3.4317E-06),( 9.7045E-06, 3.7681E-06),
     &  ( 9.9252E-06, 4.0433E-06),( 1.0191E-05, 3.4649E-06),
     &  ( 1.0362E-05, 3.8424E-06),( 1.0615E-05, 4.1231E-06),
     &  ( 1.0886E-05, 4.6601E-06),( 1.1138E-05, 3.8722E-06),
     &  ( 1.1476E-05, 3.6870E-06),( 1.1620E-05, 3.5424E-06),
     &  ( 1.1682E-05, 3.8927E-06),( 1.1996E-05, 2.7863E-06),
     &  ( 1.2302E-05, 3.7521E-06),( 1.2584E-05, 3.8140E-06),
     &  ( 1.2927E-05, 3.9729E-06),( 1.3187E-05, 4.1463E-06),
     &  ( 1.3465E-05, 4.2022E-06),( 1.3751E-05, 4.5373E-06),
     &  ( 1.4042E-05, 4.5718E-06),( 1.4343E-05, 4.6261E-06),
     &  ( 1.4666E-05, 4.8571E-06),( 1.5031E-05, 5.0564E-06),
     &  ( 1.5322E-05, 4.9425E-06),( 1.5724E-05, 5.0098E-06),
     &  ( 1.6151E-05, 5.2702E-06),( 1.6508E-05, 5.4327E-06),
     &  ( 1.7016E-05, 5.4842E-06),( 1.7564E-05, 5.5873E-06),
     &  ( 1.8001E-05, 5.6921E-06),( 1.8579E-05, 5.8294E-06),
     &  ( 1.9026E-05, 5.7969E-06),( 1.9636E-05, 5.8808E-06),
     &  ( 2.2894E-05, 8.3876E-06),( 2.4274E-05, 1.4158E-05),
     &  ( 2.4732E-05, 1.6479E-05),( 2.5634E-05, 1.9277E-05),
     &  ( 2.6595E-05, 1.6940E-05),( 2.6921E-05, 1.5444E-05),
     &  ( 2.7990E-05, 1.6225E-05),( 2.9849E-05, 1.6709E-05),
     &  ( 3.2121E-05, 1.7608E-05),( 3.4353E-05, 1.8897E-05),
     &  ( 3.6644E-05, 2.0351E-05),( 3.7494E-05, 2.1323E-05),
     &  ( 3.8944E-05, 2.2210E-05),( 4.1448E-05, 2.4346E-05),
     &  ( 4.3781E-05, 2.5802E-05),( 4.6521E-05, 2.8485E-05),
     &  ( 4.8919E-05, 3.1095E-05),( 5.1842E-05, 3.7731E-05),
     &  ( 5.2714E-05, 3.7871E-05),( 5.4909E-05, 3.5614E-05),
     &  ( 5.6305E-05, 3.7993E-05),( 5.7962E-05, 4.0122E-05),
     &  ( 6.1979E-05, 5.4395E-05),( 6.6891E-05, 4.8281E-05),
     &  ( 7.2730E-05, 5.1887E-05),( 8.0608E-05, 5.4378E-05),
     &  ( 9.1176E-05, 5.9393E-05),( 1.0671E-04, 6.3779E-05),
     &  ( 1.2705E-04, 6.8896E-05),( 1.3653E-04, 6.9062E-05),
     &  ( 1.7197E-04, 7.4481E-05),( 2.0434E-04, 1.0657E-04),
     &  ( 2.0646E-04, 1.1007E-04),( 2.2167E-04, 1.1660E-04),
     &  ( 2.5426E-04, 1.2925E-04),( 3.0767E-04, 1.6846E-04),
     &  ( 3.5158E-04, 2.0607E-04),( 3.8993E-04, 2.4791E-04),
     &  ( 4.2250E-04, 2.8833E-04),( 4.4096E-04, 3.3648E-04),
     &  ( 4.6786E-04, 3.7809E-04),( 4.8610E-04, 4.2215E-04),
     &  ( 5.0185E-04, 4.6891E-04),( 5.1624E-04, 5.1141E-04),
     &  ( 5.1719E-04, 5.5080E-04),( 5.1859E-04, 6.1341E-04),
     &  ( 5.1985E-04, 6.3668E-04),( 5.2112E-04, 6.6104E-04),
     &  ( 5.2289E-04, 6.9541E-04),( 5.1856E-04, 7.3851E-04)/
  
         DATA ((CAS  (I,J), I= 101, 200), J=3,3) /
     &  ( 5.1562E-04, 7.8139E-04),( 5.0436E-04, 8.2259E-04),
     &  ( 4.9405E-04, 8.6412E-04),( 4.8792E-04, 8.9222E-04),
     &  ( 4.7259E-04, 9.1485E-04),( 4.5345E-04, 9.3509E-04),
     &  ( 4.3469E-04, 9.5703E-04),( 4.1631E-04, 9.7701E-04),
     &  ( 3.9448E-04, 9.9814E-04),( 3.7130E-04, 1.0192E-03),
     &  ( 3.3765E-04, 1.0408E-03),( 3.1110E-04, 1.0622E-03),
     &  ( 2.8373E-04, 1.0852E-03),( 2.5488E-04, 1.0945E-03),
     &  ( 2.1555E-04, 1.0918E-03),( 1.7595E-04, 1.0887E-03),
     &  ( 1.3103E-04, 1.0847E-03),( 8.0958E-05, 1.0760E-03),
     &  ( 1.8804E-04, 1.0399E-03),( 2.3972E-04, 1.0150E-03),
     &  ( 2.7422E-04, 9.9480E-04),( 3.0209E-04, 9.7689E-04),
     &  ( 3.2628E-04, 9.5981E-04),( 3.4809E-04, 9.4335E-04),
     &  ( 3.6826E-04, 9.2697E-04),( 3.8772E-04, 9.0975E-04),
     &  ( 4.0634E-04, 8.8483E-04),( 4.2063E-04, 8.5999E-04),
     &  ( 4.3410E-04, 8.3518E-04),( 4.4655E-04, 8.1023E-04),
     &  ( 4.5781E-04, 7.8436E-04),( 4.6800E-04, 7.5882E-04),
     &  ( 4.8053E-04, 7.3309E-04),( 4.8814E-04, 7.0592E-04),
     &  ( 4.9468E-04, 6.7905E-04),( 4.9956E-04, 6.5002E-04),
     &  ( 5.0082E-04, 6.1954E-04),( 5.0283E-04, 5.8829E-04),
     &  ( 5.0343E-04, 5.6632E-04),( 5.0256E-04, 5.4442E-04),
     &  ( 5.0169E-04, 5.2045E-04),( 4.9764E-04, 4.8436E-04),
     &  ( 4.9054E-04, 4.4592E-04),( 4.8310E-04, 4.1390E-04),
     &  ( 4.7278E-04, 3.8503E-04),( 4.5804E-04, 3.5352E-04),
     &  ( 4.4213E-04, 3.1817E-04),( 4.2275E-04, 2.8862E-04),
     &  ( 4.0339E-04, 2.5698E-04),( 3.7759E-04, 2.2137E-04),
     &  ( 3.4191E-04, 1.9667E-04),( 3.0581E-04, 1.6399E-04),
     &  ( 2.9837E-04, 1.5445E-04),( 2.7357E-04, 1.3053E-04),
     &  ( 2.4877E-04, 1.1628E-04),( 2.3309E-04, 1.0864E-04),
     &  ( 2.2212E-04, 9.9942E-05),( 2.1515E-04, 9.0579E-05),
     &  ( 1.9216E-04, 7.7192E-05),( 1.7211E-04, 7.9641E-05),
     &  ( 1.6031E-04, 7.8158E-05),( 1.4372E-04, 6.4952E-05),
     &  ( 1.3739E-04, 6.2552E-05),( 1.3168E-04, 5.9135E-05),
     &  ( 1.2662E-04, 5.6945E-05),( 1.2190E-04, 5.5289E-05),
     &  ( 1.1740E-04, 5.6612E-05),( 1.1526E-04, 5.8598E-05),
     &  ( 1.0447E-04, 4.7144E-05),( 9.6788E-05, 4.2583E-05),
     &  ( 9.1184E-05, 4.6670E-05),( 8.8118E-05, 4.4331E-05),
     &  ( 8.6042E-05, 4.8917E-05),( 8.4512E-05, 4.4712E-05),
     &  ( 8.2863E-05, 4.1005E-05),( 8.1415E-05, 3.6370E-05),
     &  ( 7.9422E-05, 3.4881E-05),( 7.7490E-05, 2.8629E-05),
     &  ( 7.6318E-05, 3.1647E-05),( 7.5942E-05, 3.4303E-05),
     &  ( 7.5632E-05, 3.7423E-05),( 7.5684E-05, 3.6948E-05),
     &  ( 7.6503E-05, 3.6207E-05),( 7.7628E-05, 3.6209E-05),
     &  ( 7.8982E-05, 3.7305E-05),( 8.0244E-05, 3.4831E-05),
     &  ( 8.2138E-05, 3.5157E-05),( 8.4156E-05, 3.6471E-05),
     &  ( 8.6713E-05, 4.0582E-05),( 9.0848E-05, 4.8883E-05),
     &  ( 9.3341E-05, 4.7335E-05),( 9.5335E-05, 4.8712E-05),
     &  ( 9.9786E-05, 5.2047E-05),( 1.0264E-04, 5.3338E-05),
     &  ( 1.0724E-04, 5.7356E-05),( 1.1040E-04, 6.1188E-05),
     &  ( 1.1255E-04, 4.9679E-05),( 1.1492E-04, 4.7999E-05),
     &  ( 1.1809E-04, 4.9640E-05),( 1.2699E-04, 6.5148E-05)/
  
         DATA ((CAS  (I,J), I= 201, 300), J=3,3) /
     &  ( 1.3906E-04, 6.9240E-05),( 1.4562E-04, 5.6114E-05),
     &  ( 1.4796E-04, 5.4604E-05),( 1.5035E-04, 5.2867E-05),
     &  ( 1.5276E-04, 5.0929E-05),( 1.5521E-04, 4.8957E-05),
     &  ( 1.5772E-04, 4.9056E-05),( 1.6029E-04, 4.9983E-05),
     &  ( 1.6294E-04, 5.0901E-05),( 1.6572E-04, 5.2133E-05),
     &  ( 1.6865E-04, 5.3433E-05),( 1.7177E-04, 5.4749E-05),
     &  ( 1.7510E-04, 5.4945E-05),( 1.7866E-04, 5.6036E-05),
     &  ( 1.8246E-04, 5.8034E-05),( 1.8653E-04, 6.1142E-05),
     &  ( 1.9084E-04, 6.4296E-05),( 1.9551E-04, 6.6395E-05),
     &  ( 2.0053E-04, 6.5751E-05),( 2.0595E-04, 6.5099E-05),
     &  ( 2.1180E-04, 6.5200E-05),( 2.1814E-04, 6.6321E-05),
     &  ( 2.2502E-04, 6.7450E-05),( 2.3253E-04, 6.8826E-05),
     &  ( 2.4076E-04, 7.0394E-05),( 2.4987E-04, 7.1980E-05),
     &  ( 2.6011E-04, 7.3817E-05),( 2.7196E-04, 7.5549E-05),
     &  ( 2.8662E-04, 7.6728E-05),( 3.0907E-04, 7.7904E-05),
     &  ( 3.3109E-04, 7.8407E-05),( 3.2941E-04, 6.1498E-05),
     &  ( 3.2501E-04, 6.2349E-05),( 3.0523E-04, 6.4480E-05),
     &  ( 3.2563E-04, 6.6606E-05),( 3.3349E-04, 6.8777E-05),
     &  ( 3.4348E-04, 7.0994E-05),( 3.5574E-04, 7.2911E-05),
     &  ( 3.3798E-04, 7.4506E-05),( 3.7251E-04, 7.7294E-05),
     &  ( 4.1075E-04, 8.3612E-05),( 4.3188E-04, 8.9936E-05),
     &  ( 4.1419E-04, 9.6167E-05),( 4.6898E-04, 1.0222E-04),
     &  ( 5.2378E-04, 1.0893E-04),( 5.7317E-04, 1.2214E-04),
     &  ( 6.3678E-04, 1.3599E-04),( 7.0924E-04, 1.9592E-04),
     &  ( 7.6499E-04, 2.7382E-04),( 8.0498E-04, 3.6395E-04),
     &  ( 8.2219E-04, 4.6633E-04),( 8.1666E-04, 5.5419E-04),
     &  ( 8.1024E-04, 6.1391E-04),( 8.3701E-04, 6.4253E-04),
     &  ( 8.5797E-04, 6.4341E-04),( 8.9203E-04, 6.3716E-04),
     &  ( 9.5582E-04, 6.6166E-04),( 1.0313E-03, 7.0314E-04),
     &  ( 1.0670E-03, 7.8771E-04),( 1.1228E-03, 8.7258E-04),
     &  ( 1.1494E-03, 9.5774E-04),( 1.1616E-03, 1.0432E-03),
     &  ( 1.2052E-03, 1.0989E-03),( 1.2551E-03, 1.2304E-03),
     &  ( 1.2671E-03, 1.3648E-03),( 1.3024E-03, 1.5150E-03),
     &  ( 1.3178E-03, 1.8157E-03),( 1.1694E-03, 2.2399E-03),
     &  ( 1.0127E-03, 2.2438E-03),( 8.7293E-04, 2.3459E-03),
     &  ( 7.4674E-04, 2.5274E-03),( 4.5377E-04, 2.8512E-03),
     &  ( 9.6175E-05, 2.9444E-03),( 5.1554E-04, 2.8113E-03),
     &  ( 8.5919E-04, 2.5138E-03),( 9.8288E-04, 2.1132E-03),
     &  ( 9.7674E-04, 1.9195E-03),( 9.8371E-04, 1.7669E-03),
     &  ( 9.9261E-04, 1.6481E-03),( 1.0018E-03, 1.5312E-03),
     &  ( 9.8452E-04, 1.4164E-03),( 9.6131E-04, 1.3531E-03),
     &  ( 9.5750E-04, 1.3084E-03),( 9.6988E-04, 1.2607E-03),
     &  ( 9.8531E-04, 1.2035E-03),( 9.8713E-04, 1.1369E-03),
     &  ( 9.9174E-04, 1.1038E-03),( 9.7855E-04, 1.0321E-03),
     &  ( 9.8355E-04, 1.0615E-03),( 1.0553E-03, 1.0404E-03),
     &  ( 1.1339E-03, 9.5876E-04),( 1.1617E-03, 7.6709E-04),
     &  ( 1.1511E-03, 6.5092E-04),( 1.1396E-03, 5.9631E-04),
     &  ( 1.0476E-03, 4.9405E-04),( 9.5733E-04, 4.5999E-04),
     &  ( 8.9486E-04, 4.5815E-04),( 8.5610E-04, 4.5492E-04),
     &  ( 8.2734E-04, 4.5031E-04),( 8.0636E-04, 4.4431E-04)/
  
         DATA ((CAS  (I,J), I= 301, 400), J=3,3) /
     &  ( 9.0086E-04, 4.3693E-04),( 7.7667E-04, 4.2818E-04),
     &  ( 7.6463E-04, 4.1802E-04),( 8.0001E-04, 4.0648E-04),
     &  ( 7.2111E-04, 3.5462E-04),( 6.8560E-04, 3.0368E-04),
     &  ( 6.4974E-04, 2.5366E-04),( 5.4140E-04, 1.9401E-04),
     &  ( 5.3333E-04, 1.8383E-04),( 4.9380E-04, 1.8138E-04),
     &  ( 4.6938E-04, 1.7794E-04),( 4.4495E-04, 1.7358E-04),
     &  ( 4.2630E-04, 1.6827E-04),( 4.1129E-04, 1.6201E-04),
     &  ( 3.9604E-04, 1.5480E-04),( 3.7786E-04, 1.4662E-04),
     &  ( 3.6715E-04, 1.5500E-04),( 3.6238E-04, 1.4878E-04),
     &  ( 3.5585E-04, 1.4355E-04),( 3.4904E-04, 1.3873E-04),
     &  ( 3.4349E-04, 1.3391E-04),( 3.3781E-04, 1.2910E-04),
     &  ( 3.3202E-04, 1.2587E-04),( 3.3060E-04, 1.2450E-04),
     &  ( 3.1942E-04, 1.1882E-04),( 3.8534E-04, 1.2820E-04),
     &  ( 3.8548E-04, 1.3017E-04),( 3.2486E-04, 1.2750E-04),
     &  ( 3.0417E-04, 1.2277E-04),( 2.9205E-04, 1.1813E-04),
     &  ( 2.8261E-04, 1.1358E-04),( 2.7483E-04, 1.0911E-04),
     &  ( 2.6801E-04, 1.0473E-04),( 2.6197E-04, 1.0044E-04),
     &  ( 2.5653E-04, 9.6790E-05),( 2.5159E-04, 9.3930E-05),
     &  ( 2.4708E-04, 9.1109E-05),( 2.4295E-04, 8.8328E-05),
     &  ( 2.3915E-04, 8.5586E-05),( 2.3563E-04, 8.2882E-05),
     &  ( 2.3239E-04, 8.0219E-05),( 2.2229E-04, 1.0482E-04),
     &  ( 2.1975E-04, 1.0327E-04),( 2.1733E-04, 1.0172E-04),
     &  ( 2.1501E-04, 1.0019E-04),( 2.1281E-04, 9.8673E-05),
     &  ( 2.1071E-04, 9.7163E-05),( 2.0870E-04, 9.5664E-05),
     &  ( 2.0678E-04, 9.4179E-05),( 2.0494E-04, 9.2724E-05),
     &  ( 2.0317E-04, 9.1281E-05),( 2.0148E-04, 8.9848E-05),
     &  ( 1.9985E-04, 8.8427E-05),( 1.9828E-04, 8.7017E-05),
     &  ( 1.9678E-04, 8.5618E-05),( 1.9539E-04, 8.8038E-05),
     &  ( 1.8712E-04, 9.9141E-05),( 1.7017E-04, 1.0106E-04),
     &  ( 1.4691E-04, 9.8632E-05),( 1.3203E-04, 9.0753E-05),
     &  ( 1.2181E-04, 8.5684E-05),( 1.1473E-04, 9.4386E-05),
     &  ( 1.0968E-04, 9.0168E-05),( 1.0605E-04, 8.7644E-05),
     &  ( 1.0368E-04, 9.1854E-05),( 1.0350E-04, 9.1997E-05),
     &  ( 1.0183E-04, 9.3514E-05),( 1.0169E-04, 8.8737E-05),
     &  ( 1.0183E-04, 8.9364E-05),( 1.0259E-04, 9.7664E-05),
     &  ( 1.0399E-04, 9.4221E-05),( 1.0417E-04, 9.4027E-05),
     &  ( 1.0594E-04, 8.4655E-05),( 1.0811E-04, 8.0407E-05),
     &  ( 1.0927E-04, 7.7915E-05),( 1.1056E-04, 7.2632E-05),
     &  ( 1.1349E-04, 8.5683E-05),( 1.1683E-04, 8.7434E-05),
     &  ( 1.2061E-04, 7.6638E-05),( 1.2465E-04, 7.6355E-05),
     &  ( 1.2733E-04, 8.0150E-05),( 1.2921E-04, 8.5139E-05),
     &  ( 1.3430E-04, 8.3403E-05),( 1.3995E-04, 8.1589E-05),
     &  ( 1.4054E-04, 8.2092E-05),( 1.4619E-04, 8.6132E-05),
     &  ( 1.5329E-04, 9.4157E-05),( 1.5721E-04, 9.6696E-05),
     &  ( 1.6137E-04, 9.8856E-05),( 1.7054E-04, 9.9158E-05),
     &  ( 1.8116E-04, 1.0834E-04),( 1.9402E-04, 1.2184E-04),
     &  ( 1.9835E-04, 1.2777E-04),( 2.0933E-04, 1.2321E-04),
     &  ( 2.1804E-04, 1.2008E-04),( 2.2758E-04, 1.1113E-04),
     &  ( 2.5036E-04, 1.2027E-04),( 2.8128E-04, 1.3699E-04),
     &  ( 2.8524E-04, 1.3630E-04),( 3.2152E-04, 1.3547E-04)/
  
         DATA ((CAS  (I,J), I= 401, 500), J=3,3) /
     &  ( 3.8889E-04, 2.3818E-04),( 4.0251E-04, 2.4520E-04),
     &  ( 3.5579E-04, 2.5268E-04),( 3.1995E-04, 2.6191E-04),
     &  ( 3.0651E-04, 2.6378E-04),( 2.6976E-04, 2.6848E-04),
     &  ( 2.6096E-04, 2.7158E-04),( 2.5623E-04, 2.7356E-04),
     &  ( 2.5027E-04, 2.7624E-04),( 2.3965E-04, 2.8660E-04),
     &  ( 2.2823E-04, 2.9277E-04),( 2.1693E-04, 3.0313E-04),
     &  ( 2.1575E-04, 3.0357E-04),( 2.0511E-04, 3.0751E-04),
     &  ( 2.0384E-04, 3.0795E-04),( 1.9774E-04, 3.1014E-04),
     &  ( 1.9310E-04, 3.1709E-04),( 1.7719E-04, 3.2440E-04),
     &  ( 1.7444E-04, 3.2978E-04),( 1.5578E-04, 3.4310E-04),
     &  ( 1.5432E-04, 3.4357E-04),( 1.5286E-04, 3.4389E-04),
     &  ( 1.3888E-04, 3.4218E-04),( 1.2736E-04, 3.4036E-04),
     &  ( 1.2549E-04, 3.4112E-04),( 1.1626E-04, 3.3667E-04),
     &  ( 1.1558E-04, 3.3727E-04),( 1.1240E-04, 3.4009E-04),
     &  ( 1.1180E-04, 3.4068E-04),( 1.0835E-04, 3.4409E-04),
     &  ( 1.0653E-04, 3.4617E-04),( 1.0078E-04, 3.5225E-04),
     &  ( 1.0012E-04, 3.5285E-04),( 9.2873E-05, 3.5967E-04),
     &  ( 8.5493E-05, 3.6889E-04),( 8.1357E-05, 3.7039E-04),
     &  ( 8.0556E-05, 3.7652E-04),( 7.1165E-05, 3.7144E-04),
     &  ( 6.9976E-05, 3.7246E-04),( 6.5654E-05, 3.7170E-04),
     &  ( 6.3877E-05, 3.6907E-04),( 6.3353E-05, 3.7062E-04),
     &  ( 6.3077E-05, 3.6520E-04),( 6.2960E-05, 3.6576E-04),
     &  ( 6.2445E-05, 3.6724E-04),( 6.2470E-05, 3.6625E-04),
     &  ( 6.2888E-05, 3.7113E-04),( 6.3977E-05, 3.7596E-04),
     &  ( 6.4872E-05, 3.7985E-04),( 7.0302E-05, 3.8701E-04),
     &  ( 7.9906E-05, 3.9309E-04),( 8.2233E-05, 3.9065E-04),
     &  ( 8.3421E-05, 3.9098E-04),( 9.1358E-05, 3.9277E-04),
     &  ( 9.5496E-05, 3.8771E-04),( 9.9712E-05, 3.8851E-04),
     &  ( 1.1787E-04, 3.7745E-04),( 1.2023E-04, 3.7517E-04),
     &  ( 1.2629E-04, 3.6315E-04),( 1.2942E-04, 3.5337E-04),
     &  ( 1.3212E-04, 3.4171E-04),( 1.3234E-04, 3.4062E-04),
     &  ( 1.3269E-04, 3.3223E-04),( 1.3271E-04, 3.3009E-04),
     &  ( 1.3261E-04, 3.2825E-04),( 1.3200E-04, 3.2396E-04),
     &  ( 1.3068E-04, 3.2381E-04),( 1.2950E-04, 3.2539E-04),
     &  ( 1.2792E-04, 3.2542E-04),( 1.2591E-04, 3.2076E-04),
     &  ( 1.2564E-04, 3.2012E-04),( 1.2047E-04, 3.1878E-04),
     &  ( 1.1695E-04, 3.1808E-04),( 1.1458E-04, 3.2283E-04),
     &  ( 1.1423E-04, 3.2301E-04),( 1.1084E-04, 3.3363E-04),
     &  ( 1.1047E-04, 3.3381E-04),( 1.0910E-04, 3.3311E-04),
     &  ( 1.0160E-04, 3.4642E-04),( 1.0339E-04, 4.0070E-04),
     &  ( 1.0613E-04, 4.1356E-04),( 1.4808E-04, 4.3660E-04),
     &  ( 1.7483E-04, 4.4858E-04),( 1.9451E-04, 4.5626E-04),
     &  ( 2.4876E-04, 4.5092E-04),( 3.0381E-04, 4.2843E-04),
     &  ( 3.1436E-04, 4.2475E-04),( 3.1988E-04, 4.0793E-04),
     &  ( 3.2878E-04, 3.8241E-04),( 3.3102E-04, 3.8744E-04),
     &  ( 3.3683E-04, 3.9268E-04),( 3.3807E-04, 3.9287E-04),
     &  ( 3.4448E-04, 4.0298E-04),( 3.5801E-04, 4.0845E-04),
     &  ( 3.7771E-04, 4.1859E-04),( 3.8769E-04, 4.2367E-04),
     &  ( 5.5085E-04, 4.4691E-04),( 6.5331E-04, 2.9743E-04),
     &  ( 5.5693E-04, 1.3025E-04),( 3.7182E-04, 9.8208E-05)/
  
         DATA ((CAS  (I,J), I= 501, 600), J=3,3) /
     &  ( 2.9585E-04, 9.3620E-05),( 2.6585E-04, 8.8384E-05),
     &  ( 2.2401E-04, 8.6926E-05),( 2.1991E-04, 5.5068E-05),
     &  ( 2.1041E-04, 5.5658E-05),( 2.0036E-04, 5.7204E-05),
     &  ( 1.8438E-04, 5.9748E-05),( 1.7988E-04, 5.6803E-05),
     &  ( 1.7707E-04, 5.3879E-05),( 1.7602E-04, 5.3933E-05),
     &  ( 1.7697E-04, 5.3952E-05),( 1.8015E-04, 5.3952E-05),
     &  ( 1.8608E-04, 5.3952E-05),( 1.9573E-04, 5.3806E-05),
     &  ( 2.1079E-04, 5.3660E-05),( 2.3452E-04, 5.3521E-05),
     &  ( 2.7371E-04, 5.3514E-05),( 2.8453E-04, 5.3524E-05),
     &  ( 2.9676E-04, 5.3533E-05),( 3.1065E-04, 5.3543E-05),
     &  ( 3.2652E-04, 5.3553E-05),( 3.4479E-04, 5.3563E-05),
     &  ( 3.6600E-04, 5.3572E-05),( 3.9086E-04, 5.3582E-05),
     &  ( 3.9635E-04, 5.3584E-05),( 4.0202E-04, 5.3586E-05),
     &  ( 4.0790E-04, 5.3588E-05),( 4.1400E-04, 5.3590E-05),
     &  ( 4.2031E-04, 5.3592E-05),( 4.2686E-04, 5.3594E-05),
     &  ( 4.3365E-04, 5.3596E-05),( 4.4071E-04, 5.3598E-05),
     &  ( 4.4804E-04, 5.3600E-05),( 4.5566E-04, 5.3601E-05),
     &  ( 4.9407E-04, 5.3610E-05),( 5.2405E-04, 5.3622E-05),
     &  ( 5.4063E-04, 5.3628E-05),( 5.5235E-04, 5.3632E-05),
     &  ( 5.6464E-04, 5.3636E-05),( 5.7755E-04, 5.3640E-05),
     &  ( 5.9113E-04, 5.3645E-05),( 6.0542E-04, 5.3649E-05),
     &  ( 6.2048E-04, 5.3653E-05),( 6.2831E-04, 5.3655E-05),
     &  ( 6.3636E-04, 5.3657E-05),( 6.4464E-04, 5.3659E-05),
     &  ( 6.5315E-04, 5.3661E-05),( 6.6191E-04, 5.3663E-05),
     &  ( 6.7092E-04, 5.3665E-05),( 6.8020E-04, 5.3668E-05),
     &  ( 6.8975E-04, 5.3670E-05),( 6.9959E-04, 5.3672E-05),
     &  ( 7.0973E-04, 5.3674E-05),( 7.2019E-04, 5.3676E-05),
     &  ( 7.3098E-04, 5.3678E-05),( 7.4212E-04, 5.3680E-05),
     &  ( 7.5362E-04, 5.3682E-05),( 7.6550E-04, 5.3684E-05),
     &  ( 7.7778E-04, 5.3684E-05),( 7.9048E-04, 5.3684E-05),
     &  ( 8.0361E-04, 5.3684E-05),( 8.1722E-04, 5.3684E-05),
     &  ( 8.3131E-04, 5.3684E-05),( 8.4591E-04, 5.3684E-05),
     &  ( 8.6106E-04, 5.3684E-05),( 8.7677E-04, 5.3684E-05),
     &  ( 8.9310E-04, 5.3684E-05),( 9.1006E-04, 5.3684E-05),
     &  ( 9.2770E-04, 5.3684E-05),( 9.4606E-04, 5.3684E-05),
     &  ( 9.6519E-04, 5.3684E-05),( 9.8512E-04, 5.3684E-05),
     &  ( 1.0059E-03, 5.3684E-05),( 1.0276E-03, 5.3674E-05),
     &  ( 1.0503E-03, 5.3665E-05),( 1.0741E-03, 5.3655E-05),
     &  ( 1.0989E-03, 5.3645E-05),( 1.1250E-03, 5.3636E-05),
     &  ( 1.1524E-03, 5.3626E-05),( 1.1811E-03, 5.3616E-05),
     &  ( 1.2113E-03, 5.3606E-05),( 1.2432E-03, 5.3597E-05),
     &  ( 1.2768E-03, 5.3587E-05),( 1.2942E-03, 5.3591E-05),
     &  ( 1.3122E-03, 5.3595E-05),( 1.3307E-03, 5.3600E-05),
     &  ( 1.3498E-03, 5.3604E-05),( 1.3693E-03, 5.3608E-05),
     &  ( 1.3895E-03, 5.3612E-05),( 1.4103E-03, 5.3617E-05),
     &  ( 1.4317E-03, 5.3621E-05),( 1.4538E-03, 5.3625E-05),
     &  ( 1.4766E-03, 5.3629E-05),( 1.5001E-03, 5.3634E-05),
     &  ( 1.5243E-03, 5.3638E-05),( 1.5494E-03, 5.3642E-05),
     &  ( 1.5753E-03, 5.3646E-05),( 1.6021E-03, 5.3651E-05),
     &  ( 1.6299E-03, 5.3655E-05),( 1.6586E-03, 5.3659E-05)/
  
         DATA ((CAS  (I,J), I= 601, 700), J=3,3) /
     &  ( 1.6884E-03, 5.3664E-05),( 1.7192E-03, 5.3668E-05),
     &  ( 1.7512E-03, 5.3672E-05),( 1.7844E-03, 5.3676E-05),
     &  ( 1.8189E-03, 5.3681E-05),( 1.8548E-03, 5.3685E-05),
     &  ( 1.8921E-03, 5.3689E-05),( 1.9310E-03, 5.3693E-05),
     &  ( 1.9714E-03, 5.3698E-05),( 2.0137E-03, 5.3702E-05),
     &  ( 2.0577E-03, 5.3706E-05),( 2.1038E-03, 5.3710E-05),
     &  ( 2.1519E-03, 5.3715E-05),( 2.2023E-03, 5.3719E-05),
     &  ( 2.2551E-03, 5.3723E-05),( 2.3106E-03, 5.3727E-05),
     &  ( 2.3688E-03, 5.3732E-05),( 2.4300E-03, 5.3736E-05),
     &  ( 2.4945E-03, 5.3740E-05),( 2.5624E-03, 5.3744E-05),
     &  ( 2.6342E-03, 5.3749E-05),( 2.7417E-03, 5.3755E-05),
     &  ( 2.7905E-03, 5.3757E-05),( 2.8759E-03, 5.3754E-05),
     &  ( 2.9665E-03, 5.3750E-05),( 3.0631E-03, 5.3746E-05),
     &  ( 3.1662E-03, 5.3743E-05),( 3.2764E-03, 5.3739E-05),
     &  ( 3.3946E-03, 5.3735E-05),( 3.5216E-03, 5.3732E-05),
     &  ( 3.6584E-03, 5.3728E-05),( 3.8063E-03, 5.3724E-05),
     &  ( 3.9666E-03, 5.3721E-05),( 4.1409E-03, 5.3717E-05),
     &  ( 4.2801E-03, 5.3714E-05),( 4.7137E-03, 5.3707E-05),
     &  ( 5.2449E-03, 5.3700E-05),( 5.9105E-03, 5.3692E-05),
     &  ( 6.7690E-03, 5.3685E-05),( 7.9183E-03, 5.3680E-05),
     &  ( 9.5365E-03, 5.3675E-05),( 1.1984E-02, 5.3670E-05),
     &  ( 1.6115E-02, 3.0854E-04),( 2.4581E-02, 6.4691E-04),
     &  ( 5.1685E-02, 2.6819E-03),( 5.4654E-02, 2.9934E-03),
     &  ( 5.7983E-02, 3.3637E-03),( 6.1743E-02, 3.8085E-03),
     &  ( 6.6021E-02, 4.3491E-03),( 7.0933E-02, 5.0153E-03),
     &  ( 7.6630E-02, 5.8490E-03),( 8.3314E-02, 6.9113E-03),
     &  ( 9.1265E-02, 8.2939E-03),( 1.0088E-01, 1.0139E-02),
     &  ( 1.1272E-01, 1.2678E-02),( 1.2766E-01, 1.6306E-02),
     &  ( 1.4707E-01, 2.1739E-02),( 1.7322E-01, 3.0395E-02),
     &  ( 1.7633E-01, 3.1533E-02),( 2.4612E-01, 6.3416E-02),
     &  ( 2.9699E-01, 9.5495E-02),( 3.3786E-01, 1.2805E-01),
     &  ( 3.7341E-01, 1.6267E-01),( 4.0080E-01, 1.9460E-01),
     &  ( 4.2473E-01, 2.2754E-01),( 4.4391E-01, 2.5862E-01),
     &  ( 4.6302E-01, 2.9561E-01),( 4.7614E-01, 3.2634E-01),
     &  ( 4.8829E-01, 3.6123E-01),( 4.9687E-01, 3.9248E-01),
     &  ( 5.0394E-01, 4.2702E-01),( 5.0791E-01, 4.5521E-01),
     &  ( 5.1088E-01, 4.9602E-01),( 5.1113E-01, 5.1783E-01),
     &  ( 5.0964E-01, 5.5234E-01),( 5.0550E-01, 5.8894E-01),
     &  ( 5.0103E-01, 6.1445E-01),( 4.9135E-01, 6.5423E-01),
     &  ( 4.8268E-01, 6.8163E-01),( 4.7204E-01, 7.0961E-01),
     &  ( 4.5926E-01, 7.3801E-01),( 4.4418E-01, 7.6664E-01),
     &  ( 4.2665E-01, 7.9529E-01),( 4.0655E-01, 8.2371E-01),
     &  ( 3.8377E-01, 8.5161E-01),( 3.5825E-01, 8.7866E-01),
     &  ( 3.2998E-01, 9.0452E-01),( 2.9898E-01, 9.2881E-01),
     &  ( 2.4761E-01, 9.6150E-01),( 2.1037E-01, 9.8024E-01),
     &  ( 1.5067E-01, 1.0029E+00),( 8.7418E-02, 1.0181E+00),
     &  ( 8.7357E-02, 1.0181E+00),( 2.4756E-01, 9.6153E-01),
     &  ( 2.9893E-01, 9.2885E-01),( 3.4441E-01, 8.9180E-01),
     &  ( 3.7131E-01, 8.6530E-01),( 4.0651E-01, 8.2376E-01),
     &  ( 4.2662E-01, 7.9534E-01),( 4.4415E-01, 7.6669E-01)/
  
         DATA ((CAS  (I,J), I= 701, 800), J=3,3) /
     &  ( 4.5924E-01, 7.3806E-01),( 4.7202E-01, 7.0966E-01),
     &  ( 4.8266E-01, 6.8169E-01),( 4.9134E-01, 6.5428E-01),
     &  ( 4.9820E-01, 6.2757E-01),( 5.0344E-01, 6.0164E-01),
     &  ( 5.0720E-01, 5.7657E-01),( 5.0963E-01, 5.5240E-01),
     &  ( 5.1113E-01, 5.1789E-01),( 5.1088E-01, 4.9607E-01),
     &  ( 5.0893E-01, 4.6511E-01),( 5.0542E-01, 4.3624E-01),
     &  ( 5.0235E-01, 4.1811E-01),( 4.9486E-01, 3.8442E-01),
     &  ( 4.8831E-01, 3.6127E-01),( 4.7869E-01, 3.3302E-01),
     &  ( 4.6837E-01, 3.0748E-01),( 4.5491E-01, 2.7900E-01),
     &  ( 4.4118E-01, 2.5389E-01),( 4.2205E-01, 2.2356E-01),
     &  ( 4.0343E-01, 1.9796E-01),( 3.8068E-01, 1.7064E-01),
     &  ( 3.5502E-01, 1.4393E-01),( 3.2202E-01, 1.1462E-01),
     &  ( 2.8420E-01, 8.6621E-02),( 2.3696E-01, 5.8486E-02),
     &  ( 1.9526E-01, 3.8944E-02),( 1.6287E-01, 2.6783E-02),
     &  ( 1.3950E-01, 1.9520E-02),( 1.2190E-01, 1.4850E-02),
     &  ( 1.0820E-01, 1.1674E-02),( 9.7240E-02, 9.4184E-03),
     &  ( 8.8281E-02, 7.7597E-03),( 8.0824E-02, 6.5049E-03),
     &  ( 7.4523E-02, 5.5330E-03),( 6.9129E-02, 4.7649E-03),
     &  ( 6.4460E-02, 4.1476E-03),( 6.0380E-02, 3.6440E-03),
     &  ( 5.6785E-02, 3.2279E-03),( 5.3593E-02, 2.8800E-03),
     &  ( 5.0740E-02, 2.5864E-03),( 4.8174E-02, 2.3362E-03),
     &  ( 4.5856E-02, 2.1213E-03),( 4.3750E-02, 1.9354E-03),
     &  ( 2.2941E-02, 5.7036E-04),( 1.5549E-02, 2.9092E-04),
     &  ( 1.1763E-02, 5.3684E-05),( 9.4610E-03, 5.3734E-05),
     &  ( 7.9143E-03, 5.3784E-05),( 6.8034E-03, 5.3834E-05),
     &  ( 5.9669E-03, 5.3884E-05),( 5.3144E-03, 5.3934E-05),
     &  ( 4.7912E-03, 5.3984E-05),( 4.3623E-03, 5.4035E-05),
     &  ( 4.3115E-03, 5.4041E-05),( 3.9574E-03, 5.4092E-05),
     &  ( 3.6575E-03, 5.4142E-05),( 3.4002E-03, 5.4193E-05),
     &  ( 3.1771E-03, 5.4244E-05),( 2.9818E-03, 5.4294E-05),
     &  ( 2.8094E-03, 5.4345E-05),( 2.6562E-03, 5.4396E-05),
     &  ( 2.5190E-03, 5.4446E-05),( 2.3955E-03, 5.4497E-05),
     &  ( 2.2838E-03, 5.4547E-05),( 2.1822E-03, 5.4598E-05),
     &  ( 2.0895E-03, 5.4649E-05),( 2.0045E-03, 5.4699E-05),
     &  ( 1.9264E-03, 5.4750E-05),( 1.8542E-03, 5.4800E-05),
     &  ( 1.7874E-03, 5.4851E-05),( 1.7254E-03, 5.4902E-05),
     &  ( 1.6677E-03, 5.4952E-05),( 1.6139E-03, 5.5003E-05),
     &  ( 1.5636E-03, 5.5053E-05),( 1.5164E-03, 5.5104E-05),
     &  ( 1.4721E-03, 5.5154E-05),( 1.4305E-03, 5.5205E-05),
     &  ( 1.3912E-03, 5.5255E-05),( 1.3542E-03, 5.5306E-05),
     &  ( 1.3191E-03, 5.5357E-05),( 1.2860E-03, 5.5407E-05),
     &  ( 1.2545E-03, 5.5458E-05),( 1.2247E-03, 5.5508E-05),
     &  ( 1.1963E-03, 5.5559E-05),( 1.1693E-03, 5.5609E-05),
     &  ( 1.1436E-03, 5.5660E-05),( 1.1191E-03, 5.5710E-05),
     &  ( 1.0957E-03, 5.5760E-05),( 1.0733E-03, 5.5811E-05),
     &  ( 1.0519E-03, 5.5861E-05),( 1.0314E-03, 5.5912E-05),
     &  ( 1.0118E-03, 5.5962E-05),( 9.9298E-04, 5.6013E-05),
     &  ( 9.7492E-04, 5.6063E-05),( 9.5758E-04, 5.6114E-05),
     &  ( 9.4091E-04, 5.6164E-05),( 9.2489E-04, 5.6214E-05),
     &  ( 9.0946E-04, 5.6265E-05),( 8.9461E-04, 5.6315E-05)/
  
         DATA ((CAS  (I,J), I= 801, 900), J=3,3) /
     &  ( 8.8030E-04, 5.6366E-05),( 8.6651E-04, 5.6416E-05),
     &  ( 8.5321E-04, 5.6467E-05),( 8.4037E-04, 5.6517E-05),
     &  ( 8.2797E-04, 5.6567E-05),( 8.1600E-04, 5.6618E-05),
     &  ( 8.0443E-04, 5.6668E-05),( 7.9324E-04, 5.6718E-05),
     &  ( 7.8242E-04, 5.6769E-05),( 7.7195E-04, 5.6819E-05),
     &  ( 7.6182E-04, 5.6869E-05),( 7.5201E-04, 5.6920E-05),
     &  ( 7.4250E-04, 5.6970E-05),( 7.3329E-04, 5.7020E-05),
     &  ( 7.2436E-04, 5.7071E-05),( 7.1571E-04, 5.7121E-05),
     &  ( 7.0732E-04, 5.7171E-05),( 6.9918E-04, 5.7222E-05),
     &  ( 6.9128E-04, 5.7272E-05),( 6.8362E-04, 5.7322E-05),
     &  ( 6.7619E-04, 5.7373E-05),( 6.6897E-04, 5.7423E-05),
     &  ( 6.6197E-04, 5.7473E-05),( 6.5517E-04, 5.7523E-05),
     &  ( 6.4857E-04, 5.7574E-05),( 6.4217E-04, 5.7624E-05),
     &  ( 6.3596E-04, 5.7674E-05),( 6.2993E-04, 5.7724E-05),
     &  ( 6.2408E-04, 5.7775E-05),( 6.1841E-04, 5.7825E-05),
     &  ( 6.1291E-04, 5.7875E-05),( 6.0759E-04, 5.7925E-05),
     &  ( 6.0244E-04, 5.7976E-05),( 5.9746E-04, 5.8026E-05),
     &  ( 5.9265E-04, 5.8076E-05),( 5.8802E-04, 5.8126E-05),
     &  ( 5.8357E-04, 5.8176E-05),( 5.7931E-04, 5.8227E-05),
     &  ( 5.7459E-04, 5.8277E-05),( 5.6999E-04, 5.8327E-05),
     &  ( 5.6548E-04, 5.8377E-05),( 5.6108E-04, 5.8427E-05),
     &  ( 5.5677E-04, 5.8477E-05),( 5.5255E-04, 5.8528E-05),
     &  ( 5.4842E-04, 5.8578E-05),( 5.4437E-04, 5.8628E-05),
     &  ( 5.4079E-04, 5.8673E-05),( 5.3722E-04, 5.8955E-05),
     &  ( 5.3352E-04, 5.9232E-05),( 5.2986E-04, 5.9509E-05),
     &  ( 5.2629E-04, 5.9786E-05),( 5.2276E-04, 6.0064E-05),
     &  ( 5.1932E-04, 6.0341E-05),( 5.1594E-04, 6.0618E-05),
     &  ( 5.1264E-04, 6.0896E-05),( 5.0940E-04, 6.1174E-05),
     &  ( 5.0623E-04, 6.1451E-05),( 4.0872E-04, 7.2638E-05),
     &  ( 3.5598E-04, 8.6829E-05),( 3.4116E-04, 9.4278E-05),
     &  ( 3.5687E-04, 9.7463E-05),( 3.8306E-04, 9.7376E-05),
     &  ( 4.4991E-04, 9.2007E-05),( 4.9108E-04, 8.9488E-05),
     &  ( 5.4524E-04, 8.6965E-05),( 5.5291E-04, 8.6989E-05),
     &  ( 5.9362E-04, 9.7494E-05),( 6.1922E-04, 9.2971E-05),
     &  ( 6.2406E-04, 9.2173E-05),( 6.9454E-04, 9.2213E-05),
     &  ( 7.9834E-04, 9.2256E-05),( 8.3615E-04, 9.2256E-05),
     &  ( 8.7856E-04, 8.1873E-05),( 9.2473E-04, 8.2973E-05),
     &  ( 9.7959E-04, 8.4860E-05),( 1.0380E-03, 8.6744E-05),
     &  ( 1.1074E-03, 8.8625E-05),( 1.1900E-03, 9.0504E-05),
     &  ( 1.2886E-03, 9.2380E-05),( 1.4078E-03, 9.2442E-05),
     &  ( 1.5542E-03, 9.2504E-05),( 1.7375E-03, 9.2566E-05),
     &  ( 1.9729E-03, 9.2628E-05),( 2.0868E-03, 9.3793E-05),
     &  ( 2.2152E-03, 9.4960E-05),( 2.3607E-03, 9.6128E-05),
     &  ( 2.5273E-03, 9.7298E-05),( 2.7197E-03, 9.8470E-05),
     &  ( 2.9443E-03, 1.0075E-04),( 3.0713E-03, 1.0189E-04),
     &  ( 3.2099E-03, 1.0303E-04),( 3.3617E-03, 1.0417E-04),
     &  ( 3.5287E-03, 1.0532E-04),( 3.7133E-03, 1.0646E-04),
     &  ( 3.9183E-03, 1.0760E-04),( 4.1475E-03, 1.0875E-04),
     &  ( 4.4053E-03, 1.0990E-04),( 4.6973E-03, 1.0995E-04),
     &  ( 5.0309E-03, 1.0907E-04),( 5.4156E-03, 1.0820E-04)/
  
         DATA ((CAS  (I,J), I= 901,1000), J=3,3) /
     &  ( 5.8640E-03, 1.0733E-04),( 6.3704E-03, 1.0649E-04),
     &  ( 6.7020E-03, 1.0601E-04),( 7.0700E-03, 1.0554E-04),
     &  ( 7.4807E-03, 1.0506E-04),( 7.9420E-03, 1.0459E-04),
     &  ( 8.4638E-03, 1.0411E-04),( 9.0589E-03, 1.0363E-04),
     &  ( 9.7440E-03, 1.0316E-04),( 1.0541E-02, 1.0269E-04),
     &  ( 1.1479E-02, 1.0221E-04),( 1.2601E-02, 1.0174E-04),
     &  ( 1.3965E-02, 1.0127E-04),( 1.5660E-02, 1.0080E-04),
     &  ( 1.7821E-02, 1.0032E-04),( 2.0672E-02, 9.9853E-05),
     &  ( 2.4604E-02, 9.9383E-05),( 3.0372E-02, 9.8913E-05),
     &  ( 3.9645E-02, 9.8444E-05),( 5.6933E-02, 7.1562E-03),
     &  ( 8.4125E-02, 1.5802E-02),( 9.9601E-02, 2.2438E-02),
     &  ( 1.1648E-01, 3.1267E-02),( 1.5802E-01, 6.1743E-02),
     &  ( 1.7298E-01, 7.6802E-02),( 1.8533E-01, 9.1588E-02),
     &  ( 1.9582E-01, 1.0640E-01),( 2.0465E-01, 1.2110E-01),
     &  ( 2.1190E-01, 1.3534E-01),( 2.1813E-01, 1.4999E-01),
     &  ( 2.2324E-01, 1.6461E-01),( 2.2690E-01, 1.7760E-01),
     &  ( 2.3001E-01, 1.9183E-01),( 2.3220E-01, 2.0604E-01),
     &  ( 2.3351E-01, 2.1998E-01),( 2.3398E-01, 2.3338E-01),
     &  ( 2.3364E-01, 2.4761E-01),( 2.3273E-01, 2.5923E-01),
     &  ( 2.3088E-01, 2.7311E-01),( 2.2845E-01, 2.8574E-01),
     &  ( 2.2518E-01, 2.9879E-01),( 2.2097E-01, 3.1220E-01),
     &  ( 2.1654E-01, 3.2394E-01),( 2.1034E-01, 3.3784E-01),
     &  ( 2.0407E-01, 3.4986E-01),( 1.9686E-01, 3.6189E-01),
     &  ( 1.8867E-01, 3.7386E-01),( 1.7783E-01, 3.8760E-01),
     &  ( 1.6739E-01, 3.9905E-01),( 1.5388E-01, 4.1188E-01),
     &  ( 1.4116E-01, 4.2226E-01),( 1.2261E-01, 4.3499E-01),
     &  ( 1.0237E-01, 4.4614E-01),( 7.2130E-02, 4.5838E-01),
     &  ( 4.5775E-02, 4.6527E-01),( 1.5420E-02, 4.6930E-01),
     &  ( 3.6129E-04, 4.6981E-01),( 1.5343E-02, 4.6931E-01),
     &  ( 3.0619E-02, 4.6779E-01),( 7.2057E-02, 4.5840E-01),
     &  ( 1.0230E-01, 4.4618E-01),( 1.2254E-01, 4.3503E-01),
     &  ( 1.4110E-01, 4.2231E-01),( 1.5383E-01, 4.1193E-01),
     &  ( 1.6734E-01, 3.9911E-01),( 1.7778E-01, 3.8765E-01),
     &  ( 1.8863E-01, 3.7392E-01),( 1.9682E-01, 3.6196E-01),
     &  ( 2.0403E-01, 3.4992E-01),( 2.1031E-01, 3.3790E-01),
     &  ( 2.1651E-01, 3.2400E-01),( 2.2094E-01, 3.1227E-01),
     &  ( 2.2516E-01, 2.9885E-01),( 2.2843E-01, 2.8581E-01),
     &  ( 2.3086E-01, 2.7318E-01),( 2.3272E-01, 2.5930E-01),
     &  ( 2.3364E-01, 2.4767E-01),( 2.3398E-01, 2.3345E-01),
     &  ( 2.3351E-01, 2.2004E-01),( 2.3221E-01, 2.0610E-01),
     &  ( 2.3002E-01, 1.9189E-01),( 2.2692E-01, 1.7766E-01),
     &  ( 2.2326E-01, 1.6467E-01),( 2.1816E-01, 1.5005E-01),
     &  ( 2.1192E-01, 1.3540E-01),( 2.0468E-01, 1.2115E-01),
     &  ( 1.9585E-01, 1.0645E-01),( 1.8537E-01, 9.1636E-02),
     &  ( 1.7302E-01, 7.6847E-02),( 1.5806E-01, 6.1783E-02),
     &  ( 1.4064E-01, 4.6717E-02),( 1.4977E-01, 5.4512E-02),
     &  ( 1.2812E-01, 3.8433E-02),( 1.1478E-01, 3.0298E-02),
     &  ( 1.0672E-01, 2.5948E-02),( 9.0022E-02, 1.8174E-02),
     &  ( 8.4179E-02, 1.5821E-02),( 7.1602E-02, 1.1363E-02),
     &  ( 4.6363E-02, 9.5639E-05),( 3.4209E-02, 9.5173E-05)/
  
         DATA ((CAS  (I,J), I=1001,1100), J=3,3) /
     &  ( 2.7089E-02, 9.4708E-05),( 2.2419E-02, 9.4243E-05),
     &  ( 1.9122E-02, 9.3779E-05),( 1.6670E-02, 9.3316E-05),
     &  ( 1.4776E-02, 9.2853E-05),( 1.3269E-02, 9.2390E-05),
     &  ( 1.2042E-02, 9.1928E-05),( 1.1023E-02, 9.1467E-05),
     &  ( 1.0164E-02, 9.1100E-05),( 9.4290E-03, 9.1109E-05),
     &  ( 8.7938E-03, 1.0772E-04),( 8.2393E-03, 1.0796E-04),
     &  ( 7.7509E-03, 1.0821E-04),( 7.3175E-03, 1.0847E-04),
     &  ( 6.9304E-03, 1.0873E-04),( 6.5825E-03, 1.0899E-04),
     &  ( 6.0327E-03, 1.0949E-04),( 5.3466E-03, 1.1029E-04),
     &  ( 4.9799E-03, 1.1226E-04),( 4.3811E-03, 1.1914E-04),
     &  ( 3.9131E-03, 1.2617E-04),( 3.4552E-03, 1.3516E-04),
     &  ( 2.8059E-03, 1.6033E-04),( 2.0921E-03, 2.2877E-04),
     &  ( 1.6707E-03, 3.0062E-04),( 1.4949E-03, 3.0634E-04),
     &  ( 1.3962E-03, 3.1458E-04),( 1.3322E-03, 3.2419E-04),
     &  ( 1.2871E-03, 3.3460E-04),( 1.2532E-03, 3.4550E-04),
     &  ( 1.2267E-03, 3.5670E-04),( 1.2051E-03, 3.7038E-04),
     &  ( 1.1872E-03, 3.8483E-04),( 1.1719E-03, 3.9908E-04),
     &  ( 1.1586E-03, 4.1312E-04),( 1.1468E-03, 4.2700E-04),
     &  ( 1.1362E-03, 4.4075E-04),( 1.1266E-03, 4.5435E-04),
     &  ( 1.1177E-03, 4.6787E-04),( 1.1094E-03, 4.8131E-04),
     &  ( 1.1016E-03, 4.9471E-04),( 1.0942E-03, 5.0806E-04),
     &  ( 1.0870E-03, 5.2143E-04),( 1.0801E-03, 5.3481E-04),
     &  ( 1.0733E-03, 5.4824E-04),( 1.0666E-03, 5.6174E-04),
     &  ( 1.0599E-03, 5.7537E-04),( 1.0532E-03, 5.8914E-04),
     &  ( 1.0463E-03, 6.0314E-04),( 1.0394E-03, 6.1738E-04),
     &  ( 1.0322E-03, 6.3198E-04),( 1.0247E-03, 6.4701E-04),
     &  ( 1.0167E-03, 6.6267E-04),( 1.0082E-03, 6.7911E-04),
     &  ( 9.9865E-04, 6.9671E-04),( 9.8767E-04, 7.1616E-04),
     &  ( 9.7382E-04, 7.3916E-04),( 9.4268E-04, 7.8323E-04),
     &  ( 9.1581E-04, 8.0825E-04),( 9.0659E-04, 8.1160E-04),
     &  ( 9.0046E-04, 8.1076E-04),( 8.9598E-04, 8.0744E-04),
     &  ( 8.9258E-04, 8.0228E-04),( 8.8995E-04, 7.9565E-04),
     &  ( 8.8790E-04, 7.8773E-04),( 8.8627E-04, 7.7864E-04),
     &  ( 8.8495E-04, 7.6847E-04),( 8.8372E-04, 7.5731E-04),
     &  ( 8.8282E-04, 7.4519E-04),( 8.8181E-04, 7.3211E-04),
     &  ( 8.8066E-04, 7.1816E-04),( 8.7909E-04, 7.0331E-04),
     &  ( 8.7834E-04, 6.8759E-04),( 8.7756E-04, 6.7103E-04),
     &  ( 8.7735E-04, 6.5366E-04),( 8.7642E-04, 6.3545E-04),
     &  ( 8.7486E-04, 6.1646E-04),( 8.7269E-04, 5.9671E-04),
     &  ( 8.6983E-04, 5.7620E-04),( 8.6619E-04, 5.5493E-04),
     &  ( 8.6169E-04, 5.3296E-04),( 8.5620E-04, 5.1035E-04),
     &  ( 8.4956E-04, 4.8705E-04),( 8.4138E-04, 4.6319E-04),
     &  ( 8.3205E-04, 4.3876E-04),( 8.2052E-04, 4.1384E-04),
     &  ( 8.0682E-04, 3.8848E-04),( 7.9044E-04, 3.6278E-04),
     &  ( 7.7060E-04, 3.3680E-04),( 7.4607E-04, 3.1070E-04),
     &  ( 7.1468E-04, 2.8460E-04),( 6.7171E-04, 2.6015E-04),
     &  ( 6.5902E-04, 2.5477E-04),( 6.2655E-04, 2.4368E-04),
     &  ( 5.8320E-04, 2.4727E-04),( 5.7856E-04, 2.5330E-04),
     &  ( 5.4437E-04, 2.5896E-04),( 5.3177E-04, 2.5924E-04),
     &  ( 5.2369E-04, 2.5223E-04),( 5.2335E-04, 2.4371E-04)/
  
         DATA ((CAS  (I,J), I=1101,1200), J=3,3) /
     &  ( 5.2467E-04, 2.6227E-04),( 5.1840E-04, 2.8218E-04),
     &  ( 5.0930E-04, 2.9596E-04),( 5.0367E-04, 2.9698E-04),
     &  ( 4.9273E-04, 3.0007E-04),( 4.8430E-04, 2.9691E-04),
     &  ( 4.7728E-04, 3.0051E-04),( 4.7178E-04, 3.0405E-04),
     &  ( 4.6970E-04, 3.1079E-04),( 4.6348E-04, 3.2359E-04),
     &  ( 4.5429E-04, 3.2277E-04),( 4.7187E-04, 3.1527E-04),
     &  ( 4.7123E-04, 4.0816E-04),( 4.4877E-04, 4.3368E-04),
     &  ( 4.2630E-04, 3.2022E-04),( 4.0384E-04, 2.9299E-04),
     &  ( 4.1399E-04, 3.1301E-04),( 4.1547E-04, 3.2216E-04),
     &  ( 4.1173E-04, 3.2300E-04),( 4.2727E-04, 3.0702E-04),
     &  ( 4.4626E-04, 3.0161E-04),( 4.7273E-04, 3.5658E-04),
     &  ( 4.4578E-04, 4.4684E-04),( 4.0175E-04, 4.3146E-04),
     &  ( 3.9712E-04, 4.1345E-04),( 3.9964E-04, 4.1567E-04),
     &  ( 3.9789E-04, 4.2497E-04),( 3.9028E-04, 4.3249E-04),
     &  ( 3.8263E-04, 4.1002E-04),( 4.0751E-04, 3.7751E-04),
     &  ( 4.6242E-04, 3.8760E-04),( 5.6135E-04, 3.9328E-04),
     &  ( 6.2422E-04, 5.0886E-04),( 5.4040E-04, 8.5974E-04),
     &  ( 2.6595E-04, 8.5308E-04),( 2.5379E-04, 6.7847E-04),
     &  ( 2.5507E-04, 6.1959E-04),( 2.7106E-04, 5.3394E-04),
     &  ( 2.6383E-04, 4.0042E-04),( 2.5189E-04, 3.5541E-04),
     &  ( 2.4310E-04, 3.5091E-04),( 2.4915E-04, 3.4416E-04),
     &  ( 2.5825E-04, 3.8027E-04),( 2.5676E-04, 4.0825E-04),
     &  ( 2.5410E-04, 4.1512E-04),( 2.4886E-04, 4.1149E-04),
     &  ( 2.4578E-04, 4.0395E-04),( 2.4555E-04, 3.9969E-04),
     &  ( 2.4557E-04, 3.9664E-04),( 2.4725E-04, 3.9339E-04),
     &  ( 2.4907E-04, 3.9255E-04),( 2.5147E-04, 4.0967E-04),
     &  ( 2.4873E-04, 4.2638E-04),( 2.3383E-04, 4.4141E-04),
     &  ( 2.2757E-04, 3.9998E-04),( 2.2721E-04, 3.7809E-04),
     &  ( 2.2808E-04, 3.6246E-04),( 2.3534E-04, 3.3187E-04),
     &  ( 2.5769E-04, 3.3794E-04),( 3.0106E-04, 3.6755E-04),
     &  ( 3.0887E-04, 4.7953E-04),( 2.8700E-04, 5.3479E-04),
     &  ( 2.6859E-04, 5.4759E-04),( 2.4980E-04, 5.6628E-04),
     &  ( 2.2233E-04, 5.9607E-04),( 2.1223E-04, 5.9079E-04),
     &  ( 2.2460E-04, 5.8626E-04),( 2.5232E-04, 5.5502E-04),
     &  ( 2.5230E-04, 3.5988E-04),( 2.0914E-04, 3.4088E-04),
     &  ( 2.0759E-04, 3.7341E-04),( 2.1513E-04, 4.7502E-04),
     &  ( 2.4445E-04, 3.5652E-04),( 2.1385E-04, 2.8199E-04),
     &  ( 2.0361E-04, 2.8123E-04),( 2.0220E-04, 2.8098E-04),
     &  ( 2.0150E-04, 2.9474E-04),( 2.0083E-04, 3.1721E-04),
     &  ( 2.0013E-04, 3.2750E-04),( 1.9782E-04, 2.7060E-04),
     &  ( 2.0049E-04, 2.7378E-04),( 1.9946E-04, 2.8242E-04),
     &  ( 1.9938E-04, 2.7999E-04),( 2.0546E-04, 2.5309E-04),
     &  ( 2.2702E-04, 2.3512E-04),( 2.4737E-04, 2.4785E-04),
     &  ( 2.9443E-04, 2.6707E-04),( 3.2045E-04, 3.9542E-04),
     &  ( 2.0747E-04, 4.9659E-04),( 1.9333E-04, 5.0039E-04),
     &  ( 1.8522E-04, 3.3679E-04),( 2.1160E-04, 2.8392E-04),
     &  ( 2.2650E-04, 2.9401E-04),( 2.9931E-04, 3.8589E-04),
     &  ( 3.0036E-04, 5.4349E-04),( 2.9710E-04, 5.9802E-04),
     &  ( 2.9268E-04, 6.5585E-04),( 1.9502E-04, 8.3282E-04),
     &  ( 1.8956E-04, 8.9296E-04),( 3.2601E-04, 6.9848E-04)/
  
         DATA ((CAS  (I,J), I=1201,1300), J=3,3) /
     &  ( 3.0381E-04, 3.8620E-04),( 2.1540E-04, 3.8474E-04),
     &  ( 2.0116E-04, 3.8365E-04),( 1.9684E-04, 3.8347E-04),
     &  ( 1.8942E-04, 3.8282E-04),( 1.8626E-04, 3.8218E-04),
     &  ( 1.8731E-04, 3.8108E-04),( 1.8754E-04, 3.5703E-04),
     &  ( 1.8364E-04, 3.4134E-04),( 1.8125E-04, 3.3878E-04),
     &  ( 1.7693E-04, 3.3111E-04),( 1.7576E-04, 3.2856E-04),
     &  ( 1.7092E-04, 3.1595E-04),( 1.7069E-04, 3.3047E-04),
     &  ( 1.7117E-04, 3.3670E-04),( 1.6724E-04, 3.2650E-04),
     &  ( 1.7173E-04, 3.7508E-04),( 1.8324E-04, 6.5573E-04),
     &  ( 2.0528E-04, 3.8316E-04),( 1.8280E-04, 3.1419E-04),
     &  ( 1.6058E-04, 3.1594E-04),( 1.5797E-04, 3.1686E-04),
     &  ( 1.5692E-04, 4.1507E-04),( 1.5498E-04, 4.8096E-04),
     &  ( 1.5771E-04, 3.4076E-04),( 1.5356E-04, 3.4057E-04),
     &  ( 1.4829E-04, 4.6838E-04),( 1.7811E-04, 5.9199E-04),
     &  ( 1.6176E-04, 4.1409E-04),( 1.4437E-04, 9.1078E-04),
     &  ( 4.3802E-04, 1.1289E-03),( 6.9712E-04, 2.3400E-05),
     &  ( 7.8349E-04, 2.3054E-05),( 6.2440E-04, 2.2392E-05),
     &  ( 4.8160E-04, 2.1187E-05),( 4.4070E-04, 2.0637E-05),
     &  ( 4.0937E-04, 2.0119E-05),( 3.6394E-04, 1.9171E-05),
     &  ( 3.3215E-04, 1.8325E-05),( 3.1949E-04, 1.7937E-05),
     &  ( 3.0842E-04, 1.7569E-05),( 2.9864E-04, 1.7221E-05),
     &  ( 2.8992E-04, 1.6892E-05),( 2.8210E-04, 1.6579E-05),
     &  ( 2.7504E-04, 1.6282E-05),( 2.6863E-04, 1.6001E-05),
     &  ( 2.6278E-04, 1.5733E-05),( 2.5743E-04, 1.5478E-05),
     &  ( 2.5250E-04, 1.5236E-05),( 2.4795E-04, 1.5006E-05),
     &  ( 2.4374E-04, 1.4786E-05),( 2.3983E-04, 1.4577E-05),
     &  ( 2.3618E-04, 1.4377E-05),( 2.3278E-04, 1.4187E-05),
     &  ( 2.2960E-04, 1.4005E-05),( 2.2662E-04, 1.3831E-05),
     &  ( 2.2382E-04, 1.3665E-05),( 2.2119E-04, 1.3506E-05),
     &  ( 2.1871E-04, 1.3354E-05),( 2.1636E-04, 1.3208E-05),
     &  ( 2.1415E-04, 1.3069E-05),( 2.1206E-04, 1.2935E-05),
     &  ( 2.1008E-04, 1.2806E-05),( 2.0820E-04, 1.2683E-05),
     &  ( 2.0642E-04, 1.2565E-05),( 2.0472E-04, 1.2451E-05),
     &  ( 2.0312E-04, 1.2342E-05),( 2.0159E-04, 1.2237E-05),
     &  ( 2.0014E-04, 1.2135E-05),( 1.9875E-04, 1.2038E-05),
     &  ( 1.9744E-04, 1.1944E-05),( 1.9619E-04, 1.1853E-05),
     &  ( 1.9500E-04, 1.1766E-05),( 1.9408E-04, 1.1698E-05),
     &  ( 1.9279E-04, 1.1601E-05),( 1.9079E-04, 1.1446E-05),
     &  ( 1.8900E-04, 1.1302E-05),( 1.8740E-04, 1.1166E-05),
     &  ( 1.8598E-04, 1.1040E-05),( 1.8475E-04, 1.0920E-05),
     &  ( 1.8371E-04, 1.0808E-05),( 1.8287E-04, 1.0702E-05),
     &  ( 1.8224E-04, 1.0602E-05),( 1.8186E-04, 1.0507E-05),
     &  ( 1.8175E-04, 1.0417E-05),( 1.8199E-04, 1.0332E-05),
     &  ( 1.8266E-04, 1.0250E-05),( 1.8391E-04, 1.0173E-05),
     &  ( 1.8600E-04, 1.0099E-05),( 1.8627E-04, 1.0092E-05),
     &  ( 1.8939E-04, 1.0029E-05),( 1.9511E-04, 9.9610E-06),
     &  ( 2.0582E-04, 9.8962E-06),( 2.2412E-04, 9.8463E-06),
     &  ( 2.3197E-04, 9.8341E-06),( 2.6659E-04, 9.8040E-06),
     &  ( 3.3846E-04, 9.7803E-06),( 3.7408E-04, 9.7744E-06),
     &  ( 4.2587E-04, 9.7686E-06),( 4.6135E-04, 9.7657E-06)/
  
         DATA ((CAS  (I,J), I=1301,1400), J=3,3) /
     &  ( 5.0649E-04, 9.7627E-06),( 5.5233E-04, 9.7604E-06),
     &  ( 6.1036E-04, 9.7581E-06),( 6.4549E-04, 9.7569E-06),
     &  ( 6.8584E-04, 9.7558E-06),( 7.3264E-04, 9.7546E-06),
     &  ( 7.8749E-04, 9.7535E-06),( 8.5257E-04, 9.7523E-06),
     &  ( 9.3091E-04, 9.7512E-06),( 9.7635E-04, 9.7506E-06),
     &  ( 1.0269E-03, 9.7500E-06),( 1.0834E-03, 9.7494E-06),
     &  ( 1.1470E-03, 9.7489E-06),( 1.2191E-03, 9.7483E-06),
     &  ( 1.3015E-03, 9.7477E-06),( 1.3964E-03, 9.7471E-06),
     &  ( 1.5070E-03, 9.7466E-06),( 1.6374E-03, 9.7460E-06),
     &  ( 1.6917E-03, 9.7458E-06),( 1.7258E-03, 9.7456E-06),
     &  ( 1.7614E-03, 9.7455E-06),( 1.7985E-03, 9.7454E-06),
     &  ( 1.8372E-03, 1.4664E-05),( 1.8777E-03, 1.4886E-05),
     &  ( 1.9201E-03, 1.5125E-05),( 1.9644E-03, 1.5380E-05),
     &  ( 2.0109E-03, 1.5654E-05),( 2.0597E-03, 1.5948E-05),
     &  ( 2.1110E-03, 1.6265E-05),( 2.1649E-03, 1.6607E-05),
     &  ( 2.2218E-03, 1.6977E-05),( 2.2817E-03, 1.7377E-05),
     &  ( 2.3450E-03, 1.7811E-05),( 2.4120E-03, 1.8283E-05),
     &  ( 2.4830E-03, 1.8798E-05),( 2.5583E-03, 1.9361E-05),
     &  ( 2.6384E-03, 1.9979E-05),( 2.7238E-03, 2.0657E-05),
     &  ( 2.8149E-03, 2.1406E-05),( 2.9125E-03, 2.2234E-05),
     &  ( 3.0170E-03, 2.3154E-05),( 3.1295E-03, 2.4179E-05),
     &  ( 3.2507E-03, 2.5326E-05),( 3.3818E-03, 2.6615E-05),
     &  ( 3.5240E-03, 2.8071E-05),( 3.6787E-03, 2.9724E-05),
     &  ( 3.8478E-03, 3.1611E-05),( 4.0332E-03, 3.3778E-05),
     &  ( 4.2375E-03, 3.6285E-05),( 4.4638E-03, 3.9204E-05),
     &  ( 4.7156E-03, 4.2633E-05),( 4.9977E-03, 4.6696E-05),
     &  ( 5.3158E-03, 5.1562E-05),( 5.6772E-03, 5.7456E-05),
     &  ( 6.0915E-03, 6.4689E-05),( 6.5713E-03, 7.3700E-05),
     &  ( 7.1331E-03, 8.5122E-05),( 7.8002E-03, 9.9901E-05),
     &  ( 8.6052E-03, 1.1949E-04),( 9.5955E-03, 1.4624E-04),
     &  ( 1.0844E-02, 1.8409E-04),( 1.2465E-02, 2.4018E-04),
     &  ( 1.4657E-02, 3.2841E-04),( 1.7783E-02, 4.7900E-04),
     &  ( 2.2604E-02, 7.6826E-04),( 3.1002E-02, 1.4381E-03),
     &  ( 4.9277E-02, 3.6302E-03),( 6.0608E-02, 1.4560E-04),
     &  ( 1.1544E-01, 1.4560E-04),( 1.6063E-01, 1.4560E-04),
     &  ( 1.9338E-01, 1.4560E-04),( 2.1872E-01, 1.4560E-04),
     &  ( 2.3954E-01, 1.4560E-04),( 2.5776E-01, 1.4560E-04),
     &  ( 2.7467E-01, 1.4560E-04),( 2.8644E-01, 1.4560E-04),
     &  ( 2.9842E-01, 1.4560E-04),( 3.1021E-01, 1.4560E-04),
     &  ( 3.1589E-01, 1.4560E-04),( 3.2385E-01, 1.4560E-04),
     &  ( 3.2862E-01, 1.4560E-04),( 3.3454E-01, 1.4560E-04),
     &  ( 3.3609E-01, 1.4560E-04),( 3.3837E-01, 1.4560E-04),
     &  ( 3.3932E-01, 1.4560E-04),( 3.3860E-01, 1.4560E-04),
     &  ( 3.3751E-01, 1.4560E-04),( 3.3587E-01, 1.4560E-04),
     &  ( 3.3065E-01, 1.4560E-04),( 3.2699E-01, 1.4560E-04),
     &  ( 3.2250E-01, 1.4560E-04),( 3.1091E-01, 1.4560E-04),
     &  ( 3.0372E-01, 1.4560E-04),( 2.9551E-01, 1.4560E-04),
     &  ( 2.8610E-01, 1.4560E-04),( 2.6406E-01, 1.4560E-04),
     &  ( 2.5111E-01, 1.4560E-04),( 2.3707E-01, 1.4560E-04),
     &  ( 2.0516E-01, 1.4560E-04),( 1.8750E-01, 1.4560E-04)/
  
         DATA ((CAS  (I,J), I=1401,1500), J=3,3) /
     &  ( 1.4863E-01, 1.4560E-04),( 1.0584E-01, 1.4560E-04),
     &  ( 1.1303E-02, 1.4560E-04),( 1.0444E-01, 1.4560E-04),
     &  ( 1.4734E-01, 1.4560E-04),( 1.8615E-01, 1.4560E-04),
     &  ( 2.2063E-01, 1.4560E-04),( 2.3614E-01, 1.4560E-04),
     &  ( 2.5025E-01, 1.4560E-04),( 2.6315E-01, 1.4560E-04),
     &  ( 2.8547E-01, 1.4560E-04),( 2.9485E-01, 1.4560E-04),
     &  ( 3.0323E-01, 1.4560E-04),( 3.1049E-01, 1.4560E-04),
     &  ( 3.2219E-01, 1.4560E-04),( 3.2669E-01, 1.4560E-04),
     &  ( 3.3044E-01, 1.4560E-04),( 3.3572E-01, 1.4560E-04),
     &  ( 3.3742E-01, 1.4560E-04),( 3.3917E-01, 1.4560E-04),
     &  ( 3.3932E-01, 1.4560E-04),( 3.3842E-01, 1.4560E-04),
     &  ( 3.3619E-01, 1.4561E-04),( 3.3289E-01, 1.4561E-04),
     &  ( 3.2876E-01, 1.4561E-04),( 3.2401E-01, 1.4561E-04),
     &  ( 3.1607E-01, 1.4561E-04),( 3.1042E-01, 1.4561E-04),
     &  ( 2.9861E-01, 1.4561E-04),( 2.8666E-01, 1.4561E-04),
     &  ( 2.7486E-01, 1.4561E-04),( 2.5794E-01, 1.4561E-04),
     &  ( 2.3970E-01, 1.4561E-04),( 2.1886E-01, 1.4561E-04),
     &  ( 1.9349E-01, 1.4561E-04),( 1.6071E-01, 1.4561E-04),
     &  ( 1.1482E-01, 1.4561E-04),( 6.2668E-02, 1.4561E-04),
     &  ( 3.5845E-02, 1.4561E-04),( 2.5080E-02, 1.4562E-04),
     &  ( 1.9284E-02, 1.4562E-04),( 1.5664E-02, 1.4563E-04),
     &  ( 1.3188E-02, 1.4563E-04),( 1.1388E-02, 1.4563E-04),
     &  ( 1.0021E-02, 1.4564E-04),( 8.9466E-03, 1.4564E-04),
     &  ( 8.0808E-03, 1.4564E-04),( 7.3680E-03, 1.4565E-04),
     &  ( 6.7710E-03, 1.4565E-04),( 6.2636E-03, 1.4566E-04),
     &  ( 5.8272E-03, 1.4566E-04),( 5.4478E-03, 1.4566E-04),
     &  ( 5.1149E-03, 1.4567E-04),( 4.8205E-03, 1.4567E-04),
     &  ( 4.5583E-03, 1.4568E-04),( 4.3233E-03, 1.4568E-04),
     &  ( 4.1115E-03, 1.4568E-04),( 3.9195E-03, 1.4569E-04),
     &  ( 3.7448E-03, 1.4569E-04),( 3.5851E-03, 1.4569E-04),
     &  ( 3.4386E-03, 1.4570E-04),( 3.3037E-03, 1.4570E-04),
     &  ( 3.1791E-03, 1.4571E-04),( 3.0636E-03, 1.4571E-04),
     &  ( 2.9563E-03, 1.4571E-04),( 2.8564E-03, 1.4572E-04),
     &  ( 2.7631E-03, 1.4572E-04),( 2.6757E-03, 1.4573E-04),
     &  ( 2.5938E-03, 1.4573E-04),( 2.5169E-03, 1.4573E-04),
     &  ( 2.4444E-03, 1.4574E-04),( 2.3761E-03, 1.4574E-04),
     &  ( 2.3116E-03, 1.4574E-04),( 2.2505E-03, 1.4575E-04),
     &  ( 2.1927E-03, 1.4575E-04),( 2.1378E-03, 1.4576E-04),
     &  ( 2.0857E-03, 1.4576E-04),( 2.0361E-03, 1.4576E-04),
     &  ( 1.9889E-03, 1.4577E-04),( 1.9439E-03, 1.4577E-04),
     &  ( 1.9009E-03, 1.4578E-04),( 1.8599E-03, 1.4578E-04),
     &  ( 1.8206E-03, 1.4578E-04),( 1.7830E-03, 1.4579E-04),
     &  ( 1.7470E-03, 1.4579E-04),( 1.7125E-03, 1.4580E-04),
     &  ( 1.6794E-03, 1.4580E-04),( 1.4301E-03, 1.4583E-04),
     &  ( 1.2781E-03, 1.4586E-04),( 1.1332E-03, 1.4590E-04),
     &  ( 9.7311E-04, 1.4595E-04),( 8.2645E-04, 1.4602E-04),
     &  ( 6.8910E-04, 1.4613E-04),( 6.1021E-04, 1.4621E-04),
     &  ( 5.1037E-04, 1.4628E-04),( 4.7744E-04, 1.4626E-04),
     &  ( 4.4121E-04, 1.4574E-04),( 4.1291E-04, 1.4523E-04),
     &  ( 3.8980E-04, 1.4471E-04),( 3.7053E-04, 1.4419E-04)/
  
         DATA ((CAS  (I,J), I=1501,1600), J=3,3) /
     &  ( 3.4023E-04, 1.4316E-04),( 3.1754E-04, 1.4213E-04),
     &  ( 2.5835E-04, 1.3700E-04),( 2.2226E-04, 1.3665E-04),
     &  ( 2.1641E-04, 1.3692E-04),( 2.4788E-04, 1.3622E-04),
     &  ( 3.2840E-04, 1.3666E-04),( 4.5100E-04, 1.3689E-04),
     &  ( 6.2536E-04, 1.3702E-04),( 8.7490E-04, 1.3711E-04),
     &  ( 1.5133E-03, 1.3704E-04),( 1.6352E-03, 1.3704E-04),
     &  ( 1.7789E-03, 1.3703E-04),( 1.8206E-03, 1.3703E-04),
     &  ( 1.9156E-03, 1.3703E-04),( 2.0212E-03, 1.3702E-04),
     &  ( 2.1393E-03, 1.3702E-04),( 2.2722E-03, 1.3701E-04),
     &  ( 2.4229E-03, 1.3701E-04),( 2.5952E-03, 1.3701E-04),
     &  ( 2.7940E-03, 1.3700E-04),( 3.0261E-03, 1.3700E-04),
     &  ( 3.3005E-03, 1.3700E-04),( 3.6299E-03, 1.3699E-04),
     &  ( 4.0325E-03, 1.3699E-04),( 4.5359E-03, 1.3698E-04),
     &  ( 5.1833E-03, 1.3698E-04),( 6.0466E-03, 1.3698E-04),
     &  ( 7.2554E-03, 1.3697E-04),( 9.0688E-03, 1.3697E-04),
     &  ( 1.2091E-02, 2.5488E-04),( 1.8135E-02, 4.0229E-04),
     &  ( 2.6242E-02, 6.9272E-04),( 2.7603E-02, 7.5189E-04),
     &  ( 2.9113E-02, 8.2103E-04),( 3.0797E-02, 9.0252E-04),
     &  ( 3.2688E-02, 9.9948E-04),( 3.4826E-02, 1.1161E-03),
     &  ( 3.7263E-02, 1.2580E-03),( 4.0066E-02, 1.4333E-03),
     &  ( 4.3325E-02, 1.6530E-03),( 4.7160E-02, 1.9337E-03),
     &  ( 5.1739E-02, 2.3001E-03),( 5.7300E-02, 2.7912E-03),
     &  ( 6.4197E-02, 3.4704E-03),( 7.2975E-02, 4.4476E-03),
     &  ( 8.4520E-02, 5.9264E-03),( 1.0038E-01, 8.3180E-03),
     &  ( 1.2348E-01, 1.2560E-02),( 1.6016E-01, 2.1183E-02),
     &  ( 2.2674E-01, 4.3076E-02),( 3.7734E-01, 1.2801E-01),
     &  ( 4.3013E-01, 1.7324E-01),( 4.7168E-01, 2.1708E-01),
     &  ( 5.1800E-01, 2.7809E-01),( 5.5687E-01, 3.4491E-01),
     &  ( 5.8490E-01, 4.0950E-01),( 6.0867E-01, 4.9004E-01),
     &  ( 6.1963E-01, 5.5427E-01),( 6.2398E-01, 6.2791E-01),
     &  ( 6.1851E-01, 7.1131E-01),( 5.9912E-01, 8.0383E-01),
     &  ( 5.6103E-01, 8.6790E-01),( 5.6103E-01, 8.7796E-01),
     &  ( 5.6103E-01, 8.8300E-01),( 5.6103E-01, 8.9311E-01),
     &  ( 5.6103E-01, 8.9717E-01),( 5.6103E-01, 9.0021E-01),
     &  ( 5.6103E-01, 9.0326E-01),( 5.4521E-01, 9.3381E-01),
     &  ( 5.1723E-01, 9.7968E-01),( 4.7979E-01, 1.0299E+00),
     &  ( 4.4012E-01, 1.0736E+00),( 3.8931E-01, 1.1192E+00),
     &  ( 3.3157E-01, 1.1605E+00),( 2.7410E-01, 1.1926E+00),
     &  ( 2.0489E-01, 1.2081E+00),( 2.0489E-01, 1.2217E+00),
     &  ( 1.1605E-01, 1.2331E+00),( 1.1605E-01, 1.2455E+00),
     &  ( 3.8989E-02, 1.2516E+00),( 3.8989E-02, 1.2553E+00),
     &  ( 3.8981E-02, 1.2563E+00),( 3.8981E-02, 1.2564E+00),
     &  ( 3.8981E-02, 1.2565E+00),( 3.8981E-02, 1.2565E+00),
     &  ( 3.8981E-02, 1.2565E+00),( 3.8981E-02, 1.2564E+00),
     &  ( 3.8981E-02, 1.2553E+00),( 1.1604E-01, 1.2516E+00),
     &  ( 1.1604E-01, 1.2455E+00),( 2.8729E-01, 1.1859E+00),
     &  ( 3.4959E-01, 1.1486E+00),( 4.4943E-01, 1.0641E+00),
     &  ( 4.8783E-01, 1.0200E+00),( 5.2390E-01, 9.6952E-01),
     &  ( 5.5339E-01, 9.1852E-01),( 5.7472E-01, 8.7293E-01),
     &  ( 5.9316E-01, 8.2328E-01),( 6.0553E-01, 7.7994E-01)/
  
         DATA ((CAS  (I,J), I=1601,1700), J=3,3) /
     &  ( 6.1514E-01, 7.3364E-01),( 6.2057E-01, 6.9387E-01),
     &  ( 6.2354E-01, 6.5192E-01),( 6.2386E-01, 6.1625E-01),
     &  ( 6.2205E-01, 5.7895E-01),( 6.1878E-01, 5.4744E-01),
     &  ( 6.0800E-01, 4.8707E-01),( 6.0073E-01, 4.5845E-01),
     &  ( 5.9267E-01, 4.3184E-01),( 5.8490E-01, 4.0951E-01),
     &  ( 5.6741E-01, 3.6696E-01),( 5.5784E-01, 3.4685E-01),
     &  ( 5.4229E-01, 3.1758E-01),( 5.1800E-01, 2.7809E-01),
     &  ( 4.3014E-01, 1.7324E-01),( 3.6207E-01, 1.1671E-01),
     &  ( 3.1053E-01, 8.3450E-02),( 2.7093E-01, 6.2443E-02),
     &  ( 2.3986E-01, 4.8401E-02),( 2.1494E-01, 3.8582E-02),
     &  ( 1.9006E-01, 2.9986E-02),( 1.5121E-01, 1.8862E-02),
     &  ( 1.4070E-01, 1.6316E-02),( 1.3154E-01, 1.4254E-02),
     &  ( 1.2349E-01, 1.2561E-02),( 1.1152E-01, 1.0251E-02),
     &  ( 9.2305E-02, 7.0483E-03),( 7.8716E-02, 5.1555E-03),
     &  ( 6.8604E-02, 3.9452E-03),( 6.0789E-02, 3.1250E-03),
     &  ( 5.4569E-02, 2.5437E-03),( 4.9502E-02, 2.1168E-03),
     &  ( 4.5295E-02, 1.7942E-03),( 4.1747E-02, 1.5444E-03),
     &  ( 3.8713E-02, 1.3471E-03),( 3.6090E-02, 1.1885E-03),
     &  ( 3.3800E-02, 1.0592E-03),( 3.1783E-02, 9.5236E-04),
     &  ( 2.9993E-02, 8.6305E-04),( 2.8394E-02, 7.8765E-04),
     &  ( 2.6957E-02, 7.2341E-04),( 1.8141E-02, 4.0245E-04),
     &  ( 1.2097E-02, 2.5498E-04),( 9.0747E-03, 2.0335E-04),
     &  ( 6.0526E-03, 1.3693E-04),( 4.5419E-03, 1.3692E-04),
     &  ( 3.6358E-03, 1.3692E-04),( 3.0321E-03, 1.3691E-04),
     &  ( 2.6011E-03, 1.3690E-04),( 2.2781E-03, 1.3689E-04),
     &  ( 2.0271E-03, 1.3689E-04),( 1.8265E-03, 1.3688E-04),
     &  ( 1.7127E-03, 1.3687E-04),( 1.5802E-03, 1.3687E-04),
     &  ( 1.4670E-03, 1.3686E-04),( 1.3693E-03, 1.3685E-04),
     &  ( 1.2842E-03, 1.3685E-04),( 1.2093E-03, 1.3684E-04),
     &  ( 9.3925E-04, 1.3681E-04),( 7.7170E-04, 1.3678E-04),
     &  ( 6.5815E-04, 1.3674E-04),( 5.7652E-04, 1.3671E-04),
     &  ( 5.1530E-04, 1.3668E-04),( 4.6793E-04, 1.3665E-04),
     &  ( 4.3032E-04, 1.3661E-04),( 3.9989E-04, 1.3658E-04),
     &  ( 2.2254E-04, 1.3610E-04),( 2.2014E-04, 1.3620E-04),
     &  ( 2.2229E-04, 1.3622E-04),( 2.2585E-04, 1.3624E-04),
     &  ( 2.3139E-04, 1.3626E-04),( 2.3995E-04, 1.3628E-04),
     &  ( 2.4588E-04, 1.3629E-04),( 2.5331E-04, 1.3630E-04),
     &  ( 2.7500E-04, 1.3904E-04),( 3.1321E-04, 1.4180E-04),
     &  ( 3.9024E-04, 1.4457E-04),( 5.8878E-04, 1.4734E-04),
     &  ( 7.9035E-04, 1.4850E-04),( 8.4322E-04, 1.4871E-04),
     &  ( 9.0449E-04, 1.4891E-04),( 9.7625E-04, 1.4911E-04),
     &  ( 1.0614E-03, 1.4932E-04),( 1.1639E-03, 1.4952E-04),
     &  ( 1.2895E-03, 1.4973E-04),( 1.4470E-03, 1.4993E-04),
     &  ( 1.6500E-03, 1.5013E-04),( 1.9213E-03, 1.5034E-04),
     &  ( 2.3017E-03, 1.5054E-04),( 2.8734E-03, 1.6074E-04),
     &  ( 3.8273E-03, 1.6872E-04),( 3.9932E-03, 1.7032E-04),
     &  ( 4.1743E-03, 1.7214E-04),( 4.3727E-03, 1.7423E-04),
     &  ( 4.5909E-03, 1.7664E-04),( 4.8321E-03, 1.7943E-04),
     &  ( 5.1001E-03, 1.8269E-04),( 5.3997E-03, 1.8654E-04),
     &  ( 5.7368E-03, 1.9113E-04),( 6.1188E-03, 1.9667E-04)/
  
         DATA ((CAS  (I,J), I=1701,1800), J=3,3) /
     &  ( 6.5554E-03, 2.0342E-04),( 7.0592E-03, 2.1179E-04),
     &  ( 7.6470E-03, 2.2233E-04),( 8.3417E-03, 2.3587E-04),
     &  ( 9.1753E-03, 2.5366E-04),( 1.0194E-02, 2.7769E-04),
     &  ( 1.0513E-02, 2.8572E-04),( 1.1468E-02, 3.1128E-04),
     &  ( 1.3105E-02, 3.6025E-04),( 1.5287E-02, 4.3569E-04),
     &  ( 1.8342E-02, 5.6075E-04),( 2.2921E-02, 7.9087E-04),
     &  ( 3.0542E-02, 1.2875E-03),( 4.5736E-02, 2.7034E-03),
     &  ( 9.0646E-02, 1.0268E-02),( 1.0777E-01, 1.4524E-02),
     &  ( 1.5200E-01, 2.9269E-02),( 1.8564E-01, 4.4417E-02),
     &  ( 2.1336E-01, 5.9783E-02),( 2.3755E-01, 7.5617E-02),
     &  ( 2.5902E-01, 9.1832E-02),( 2.7827E-01, 1.0838E-01),
     &  ( 2.9547E-01, 1.2505E-01),( 3.1141E-01, 1.4236E-01),
     &  ( 3.2647E-01, 1.6071E-01),( 3.4023E-01, 1.7955E-01),
     &  ( 3.5233E-01, 1.9818E-01),( 3.6353E-01, 2.1761E-01),
     &  ( 3.7362E-01, 2.3753E-01),( 3.8246E-01, 2.5754E-01),
     &  ( 3.9086E-01, 2.7975E-01),( 3.9774E-01, 3.0153E-01),
     &  ( 4.0311E-01, 3.2231E-01),( 4.1119E-01, 3.4480E-01),
     &  ( 4.1119E-01, 3.6911E-01),( 4.1336E-01, 3.9533E-01),
     &  ( 4.1298E-01, 4.1936E-01),( 4.1298E-01, 4.4484E-01),
     &  ( 4.0560E-01, 4.7175E-01),( 4.0560E-01, 5.0003E-01),
     &  ( 3.9850E-01, 5.2955E-01),( 3.7818E-01, 5.5499E-01),
     &  ( 3.7818E-01, 5.8629E-01),( 3.6247E-01, 6.1811E-01),
     &  ( 3.1545E-01, 6.5004E-01),( 3.1545E-01, 6.8671E-01),
     &  ( 2.8218E-01, 7.2178E-01),( 2.3720E-01, 7.5841E-01),
     &  ( 1.7827E-01, 7.9300E-01),( 2.0502E-04, 8.3291E-01),
     &  ( 2.0502E-04, 8.3363E-01),( 8.0696E-02, 8.2564E-01),
     &  ( 1.7827E-01, 7.9300E-01),( 2.8218E-01, 7.5841E-01),
     &  ( 2.8218E-01, 7.2178E-01),( 3.1545E-01, 6.8671E-01),
     &  ( 3.6246E-01, 6.5005E-01),( 3.6246E-01, 6.1812E-01),
     &  ( 3.7818E-01, 5.8629E-01),( 3.9850E-01, 5.5499E-01),
     &  ( 3.9850E-01, 5.2956E-01),( 4.0559E-01, 5.0003E-01),
     &  ( 4.1298E-01, 4.7175E-01),( 4.1298E-01, 4.4484E-01),
     &  ( 4.1336E-01, 4.1936E-01),( 4.1336E-01, 3.9533E-01),
     &  ( 4.1119E-01, 3.6911E-01),( 4.0767E-01, 3.4480E-01),
     &  ( 3.9774E-01, 3.2231E-01),( 3.9774E-01, 3.0153E-01),
     &  ( 3.9086E-01, 2.7975E-01),( 3.8246E-01, 2.5754E-01),
     &  ( 3.7362E-01, 2.3754E-01),( 3.6353E-01, 2.1762E-01),
     &  ( 3.5233E-01, 1.9818E-01),( 3.4023E-01, 1.7955E-01),
     &  ( 3.2647E-01, 1.6071E-01),( 3.1141E-01, 1.4237E-01),
     &  ( 2.9547E-01, 1.2505E-01),( 2.7827E-01, 1.0839E-01),
     &  ( 2.5902E-01, 9.1833E-02),( 2.3755E-01, 7.5619E-02),
     &  ( 2.1336E-01, 5.9784E-02),( 1.8564E-01, 4.4418E-02),
     &  ( 1.5200E-01, 2.9270E-02),( 1.0777E-01, 1.4525E-02),
     &  ( 9.2278E-02, 1.0640E-02),( 8.9373E-02, 9.9821E-03),
     &  ( 8.5769E-02, 9.1967E-03),( 7.5816E-02, 7.2021E-03),
     &  ( 6.6846E-02, 5.6220E-03),( 4.5736E-02, 2.7035E-03),
     &  ( 3.0545E-02, 1.2879E-03),( 2.2923E-02, 7.9117E-04),
     &  ( 1.8344E-02, 5.6109E-04),( 1.5290E-02, 4.3608E-04),
     &  ( 1.3107E-02, 3.6069E-04),( 1.1470E-02, 3.1175E-04),
     &  ( 1.0197E-02, 2.7821E-04),( 9.1777E-03, 2.5422E-04)/
  
         DATA ((CAS  (I,J), I=1801,1900), J=3,3) /
     &  ( 8.3441E-03, 2.3648E-04),( 7.6494E-03, 2.2299E-04),
     &  ( 7.0616E-03, 2.1250E-04),( 6.5578E-03, 2.0418E-04),
     &  ( 6.1212E-03, 1.9747E-04),( 5.7392E-03, 1.9198E-04),
     &  ( 3.8297E-03, 1.6996E-04),( 2.8758E-03, 1.6239E-04),
     &  ( 2.3042E-03, 1.5899E-04),( 1.9237E-03, 1.5724E-04),
     &  ( 1.6525E-03, 1.5299E-04),( 1.4495E-03, 1.5320E-04),
     &  ( 1.2920E-03, 1.5340E-04),( 1.0639E-03, 1.5381E-04),
     &  ( 9.0703E-04, 1.5422E-04),( 8.4578E-04, 1.5443E-04),
     &  ( 7.9292E-04, 1.5463E-04),( 6.0551E-04, 1.5569E-04),
     &  ( 4.7316E-04, 1.5709E-04),( 3.9795E-04, 1.5849E-04),
     &  ( 3.5070E-04, 1.5990E-04),( 3.1903E-04, 1.6130E-04),
     &  ( 2.9683E-04, 1.6271E-04),( 2.8073E-04, 1.6412E-04),
     &  ( 2.6878E-04, 1.6512E-04),( 2.5975E-04, 1.6612E-04),
     &  ( 2.5284E-04, 1.7085E-04),( 2.4755E-04, 1.7195E-04),
     &  ( 2.4349E-04, 1.7304E-04),( 2.4042E-04, 1.7414E-04),
     &  ( 2.3816E-04, 1.7524E-04),( 2.3657E-04, 1.7635E-04),
     &  ( 2.3557E-04, 1.7746E-04),( 2.3510E-04, 1.7857E-04),
     &  ( 2.3511E-04, 1.7969E-04),( 2.3560E-04, 1.8081E-04),
     &  ( 2.3656E-04, 1.8194E-04),( 2.3800E-04, 1.8307E-04),
     &  ( 2.4435E-04, 1.9572E-04),( 3.6282E-04, 2.4935E-04),
     &  ( 3.9076E-04, 2.9367E-04),( 4.4492E-04, 3.3672E-04),
     &  ( 4.8997E-04, 3.7932E-04),( 5.2808E-04, 4.2168E-04),
     &  ( 5.6063E-04, 4.6388E-04),( 5.8857E-04, 5.0608E-04),
     &  ( 6.1247E-04, 5.4822E-04),( 6.3264E-04, 5.9002E-04),
     &  ( 6.4960E-04, 6.3184E-04),( 6.6361E-04, 6.7373E-04),
     &  ( 6.7475E-04, 7.1535E-04),( 6.8318E-04, 7.5658E-04),
     &  ( 6.8908E-04, 7.9761E-04),( 6.9258E-04, 8.3890E-04),
     &  ( 6.9366E-04, 8.7990E-04),( 6.9242E-04, 9.2001E-04),
     &  ( 6.8889E-04, 9.6012E-04),( 6.8298E-04, 1.0006E-03),
     &  ( 6.7482E-04, 1.0404E-03),( 6.6456E-04, 1.0790E-03),
     &  ( 6.5154E-04, 1.1186E-03),( 6.3660E-04, 1.1565E-03),
     &  ( 6.1882E-04, 1.1947E-03),( 5.9851E-04, 1.2323E-03),
     &  ( 5.7519E-04, 1.2698E-03),( 5.4879E-04, 1.3067E-03),
     &  ( 5.1927E-04, 1.3427E-03),( 4.8673E-04, 1.3774E-03),
     &  ( 4.4885E-04, 1.4124E-03),( 4.0638E-04, 1.4460E-03),
     &  ( 3.5894E-04, 1.4778E-03),( 3.0333E-04, 1.5084E-03),
     &  ( 2.4010E-04, 1.5358E-03),( 2.0540E-04, 1.5481E-03),
     &  ( 3.4201E-04, 1.4890E-03),( 4.0963E-04, 1.4452E-03),
     &  ( 4.6087E-04, 1.4037E-03),( 5.0143E-04, 1.3644E-03),
     &  ( 5.3591E-04, 1.3254E-03),( 5.6540E-04, 1.2866E-03),
     &  ( 5.8981E-04, 1.2497E-03),( 6.1118E-04, 1.2125E-03),
     &  ( 6.2963E-04, 1.1753E-03),( 6.4531E-04, 1.1385E-03),
     &  ( 6.5838E-04, 1.1022E-03),( 6.6926E-04, 1.0658E-03),
     &  ( 6.7784E-04, 1.0305E-03),( 6.8468E-04, 9.9392E-04),
     &  ( 6.8940E-04, 9.5871E-04),( 6.9234E-04, 9.2284E-04),
     &  ( 6.9342E-04, 8.8665E-04),( 6.9266E-04, 8.5107E-04),
     &  ( 6.9009E-04, 8.1574E-04),( 6.8562E-04, 7.7983E-04),
     &  ( 6.7921E-04, 7.4385E-04),( 6.7091E-04, 7.0823E-04),
     &  ( 6.6056E-04, 6.7255E-04),( 6.4731E-04, 6.3663E-04),
     &  ( 6.3243E-04, 6.0052E-04),( 6.1579E-04, 5.6481E-04)/
  
         DATA ((CAS  (I,J), I=1901,2000), J=3,3) /
     &  ( 5.9553E-04, 5.2853E-04),( 5.7220E-04, 4.9225E-04),
     &  ( 5.4532E-04, 4.5591E-04),( 5.1432E-04, 4.1956E-04),
     &  ( 4.7821E-04, 3.8315E-04),( 4.3557E-04, 3.4676E-04),
     &  ( 3.8410E-04, 3.1074E-04),( 3.1927E-04, 2.7825E-04),
     &  ( 2.3415E-04, 2.4832E-04),( 2.2959E-04, 2.4975E-04),
     &  ( 2.2160E-04, 2.6216E-04),( 2.1943E-04, 2.7324E-04),
     &  ( 2.1936E-04, 2.8351E-04),( 2.2018E-04, 2.9327E-04),
     &  ( 2.2140E-04, 3.0266E-04),( 2.2276E-04, 3.1178E-04),
     &  ( 2.2413E-04, 3.2070E-04),( 2.2544E-04, 3.2947E-04),
     &  ( 2.2663E-04, 3.3811E-04),( 2.2768E-04, 3.4666E-04),
     &  ( 2.2856E-04, 3.5512E-04),( 2.2926E-04, 3.6351E-04),
     &  ( 2.2977E-04, 3.7186E-04),( 2.3009E-04, 3.8016E-04),
     &  ( 2.3019E-04, 3.8842E-04),( 2.3009E-04, 3.9665E-04),
     &  ( 2.2977E-04, 4.0486E-04),( 2.2923E-04, 4.1303E-04),
     &  ( 2.2846E-04, 4.2123E-04),( 2.2747E-04, 4.2938E-04),
     &  ( 2.2623E-04, 4.3754E-04),( 2.2476E-04, 4.4570E-04),
     &  ( 2.2303E-04, 4.5385E-04),( 2.2104E-04, 4.6202E-04),
     &  ( 2.1878E-04, 4.7020E-04),( 2.1625E-04, 4.7839E-04),
     &  ( 2.1343E-04, 4.8659E-04),( 2.1029E-04, 4.9486E-04),
     &  ( 2.0684E-04, 5.0313E-04),( 2.0303E-04, 5.1149E-04),
     &  ( 1.9886E-04, 5.1991E-04),( 1.9428E-04, 5.2845E-04),
     &  ( 1.8924E-04, 5.3720E-04),( 1.8368E-04, 5.4630E-04),
     &  ( 1.7709E-04, 5.5779E-04),( 1.8094E-04, 5.5569E-04),
     &  ( 1.8500E-04, 5.5151E-04),( 1.8888E-04, 5.4700E-04),
     &  ( 1.9255E-04, 5.4234E-04),( 1.9601E-04, 5.3759E-04),
     &  ( 1.9929E-04, 5.3275E-04),( 2.0237E-04, 5.2789E-04),
     &  ( 2.0525E-04, 5.2300E-04),( 2.0797E-04, 5.1807E-04),
     &  ( 2.1049E-04, 5.1315E-04),( 2.1285E-04, 5.0823E-04),
     &  ( 2.1504E-04, 5.0330E-04),( 2.1706E-04, 4.9841E-04),
     &  ( 2.1893E-04, 4.9351E-04),( 2.2066E-04, 4.8860E-04),
     &  ( 2.2222E-04, 4.8376E-04),( 2.2364E-04, 4.7893E-04),
     &  ( 2.2492E-04, 4.7411E-04),( 2.2605E-04, 4.6937E-04),
     &  ( 2.2705E-04, 4.6466E-04),( 2.2791E-04, 4.6002E-04),
     &  ( 2.2865E-04, 4.5542E-04),( 2.2925E-04, 4.5092E-04),
     &  ( 2.2974E-04, 4.4649E-04),( 2.3009E-04, 4.4218E-04),
     &  ( 2.3034E-04, 4.3798E-04),( 2.3047E-04, 4.3392E-04),
     &  ( 2.3049E-04, 4.3003E-04),( 2.3040E-04, 4.2634E-04),
     &  ( 2.3023E-04, 4.2289E-04),( 2.2996E-04, 4.1975E-04),
     &  ( 2.2962E-04, 4.1697E-04),( 2.2921E-04, 4.1466E-04),
     &  ( 2.2876E-04, 4.1293E-04),( 2.2826E-04, 4.1198E-04),
     &  ( 2.2504E-04, 4.3018E-04),( 2.2475E-04, 4.3254E-04),
     &  ( 2.2442E-04, 4.3497E-04),( 2.2407E-04, 4.3747E-04),
     &  ( 2.2370E-04, 4.4001E-04),( 2.2329E-04, 4.4260E-04),
     &  ( 2.2285E-04, 4.4521E-04),( 2.2238E-04, 4.4786E-04),
     &  ( 2.2188E-04, 4.5057E-04),( 2.2134E-04, 4.5329E-04),
     &  ( 2.2075E-04, 4.5605E-04),( 2.2013E-04, 4.5883E-04),
     &  ( 2.1947E-04, 4.6163E-04),( 2.1878E-04, 4.6444E-04),
     &  ( 2.1803E-04, 4.6728E-04),( 2.1724E-04, 4.7015E-04),
     &  ( 2.1642E-04, 4.7300E-04),( 2.1554E-04, 4.7589E-04),
     &  ( 2.1461E-04, 4.7880E-04),( 2.1363E-04, 4.8171E-04)/
  
         DATA ((CAS  (I,J), I=2001,2100), J=3,3) /
     &  ( 2.1259E-04, 4.8467E-04),( 2.1152E-04, 4.8759E-04),
     &  ( 2.1038E-04, 4.9055E-04),( 2.0919E-04, 4.9351E-04),
     &  ( 2.0790E-04, 4.9648E-04),( 2.0658E-04, 4.9947E-04),
     &  ( 2.0522E-04, 5.0242E-04),( 2.0377E-04, 5.0541E-04),
     &  ( 2.0226E-04, 5.0842E-04),( 2.0067E-04, 5.1142E-04),
     &  ( 1.9901E-04, 5.1440E-04),( 1.9725E-04, 5.1740E-04),
     &  ( 1.9539E-04, 5.2038E-04),( 1.9340E-04, 5.2336E-04),
     &  ( 1.9122E-04, 5.2629E-04),( 1.8826E-04, 5.2894E-04),
     &  ( 1.8882E-04, 5.2522E-04),( 1.9003E-04, 5.2180E-04),
     &  ( 1.9130E-04, 5.1842E-04),( 1.9256E-04, 5.1507E-04),
     &  ( 1.9380E-04, 5.1173E-04),( 1.9499E-04, 5.0841E-04),
     &  ( 1.9616E-04, 5.0508E-04),( 1.9728E-04, 5.0176E-04),
     &  ( 1.9835E-04, 4.9844E-04),( 1.9937E-04, 4.9515E-04),
     &  ( 2.0035E-04, 4.9184E-04),( 2.0127E-04, 4.8853E-04),
     &  ( 2.0215E-04, 4.8522E-04),( 2.0298E-04, 4.8192E-04),
     &  ( 2.0375E-04, 4.7863E-04),( 2.0449E-04, 4.7530E-04),
     &  ( 2.0516E-04, 4.7201E-04),( 2.0579E-04, 4.6874E-04),
     &  ( 2.0637E-04, 4.6541E-04),( 2.0689E-04, 4.6214E-04),
     &  ( 2.0737E-04, 4.5884E-04),( 2.0780E-04, 4.5555E-04),
     &  ( 2.0818E-04, 4.5227E-04),( 2.0852E-04, 4.4898E-04),
     &  ( 2.0880E-04, 4.4562E-04),( 2.0903E-04, 4.4225E-04),
     &  ( 2.0922E-04, 4.3890E-04),( 2.0935E-04, 4.3553E-04),
     &  ( 2.0944E-04, 4.3218E-04),( 2.0947E-04, 4.2884E-04),
     &  ( 2.0946E-04, 4.2548E-04),( 2.0940E-04, 4.2211E-04),
     &  ( 2.0929E-04, 4.1875E-04),( 2.0913E-04, 4.1540E-04),
     &  ( 2.0892E-04, 4.1205E-04),( 2.0736E-04, 3.9694E-04),
     &  ( 2.0089E-04, 3.6571E-04),( 1.9591E-04, 3.4911E-04),
     &  ( 1.9362E-04, 3.4088E-04),( 1.9340E-04, 3.3647E-04),
     &  ( 1.9486E-04, 3.3454E-04),( 1.9790E-04, 3.3398E-04),
     &  ( 2.0215E-04, 3.3435E-04),( 2.0797E-04, 3.3538E-04),
     &  ( 2.1527E-04, 3.3686E-04),( 2.2375E-04, 3.3860E-04),
     &  ( 2.3441E-04, 3.4065E-04),( 2.4664E-04, 3.4280E-04),
     &  ( 2.4974E-04, 3.4519E-04),( 2.5269E-04, 3.4759E-04),
     &  ( 2.5578E-04, 3.5019E-04),( 2.5874E-04, 3.4750E-04),
     &  ( 2.6183E-04, 3.5066E-04),( 2.6479E-04, 3.5369E-04),
     &  ( 2.6788E-04, 3.5686E-04),( 2.7093E-04, 1.7204E-05),
     &  ( 2.7398E-04, 1.7120E-05),( 2.7717E-04, 1.7032E-05),
     &  ( 2.8022E-04, 1.6950E-05),( 2.8341E-04, 1.6865E-05),
     &  ( 2.8647E-04, 1.6785E-05),( 2.8966E-04, 1.6703E-05),
     &  ( 2.7939E-04, 1.6625E-05),( 2.7027E-04, 1.6545E-05),
     &  ( 2.6272E-04, 1.6469E-05),( 2.5583E-04, 1.6391E-05),
     &  ( 2.4999E-04, 1.6317E-05),( 2.4455E-04, 1.6241E-05),
     &  ( 2.3988E-04, 1.6169E-05),( 2.3546E-04, 1.6095E-05),
     &  ( 2.3145E-04, 1.6022E-05),( 2.2794E-04, 1.5954E-05),
     &  ( 2.2458E-04, 1.5882E-05),( 2.2161E-04, 1.5815E-05),
     &  ( 2.1874E-04, 1.5746E-05),( 2.1620E-04, 1.5680E-05),
     &  ( 2.1372E-04, 1.5613E-05),( 2.1151E-04, 1.5549E-05),
     &  ( 2.0935E-04, 1.5483E-05),( 2.0741E-04, 1.5421E-05),
     &  ( 2.0551E-04, 1.5357E-05),( 2.0379E-04, 1.5296E-05),
     &  ( 2.0217E-04, 1.5236E-05),( 2.0057E-04, 1.5174E-05)/
  
         DATA ((CAS  (I,J), I=2101,2193), J=3,3) /
     &  ( 1.9912E-04, 1.5115E-05),( 1.9769E-04, 1.5055E-05),
     &  ( 1.9638E-04, 1.4998E-05),( 1.9509E-04, 1.4939E-05),
     &  ( 1.9391E-04, 1.4883E-05),( 1.9274E-04, 1.4825E-05),
     &  ( 1.9166E-04, 1.4771E-05),( 1.9059E-04, 1.4714E-05),
     &  ( 1.8961E-04, 1.4661E-05),( 1.8863E-04, 1.4606E-05),
     &  ( 1.8770E-04, 1.4552E-05),( 1.8684E-04, 1.4500E-05),
     &  ( 1.8597E-04, 1.4447E-05),( 1.8518E-04, 1.4397E-05),
     &  ( 1.8438E-04, 1.4345E-05),( 1.8365E-04, 1.4296E-05),
     &  ( 1.8291E-04, 1.4245E-05),( 1.8223E-04, 1.4197E-05),
     &  ( 1.8154E-04, 1.4147E-05),( 1.8091E-04, 1.4100E-05),
     &  ( 1.8027E-04, 1.4051E-05),( 1.7968E-04, 1.4005E-05),
     &  ( 1.7911E-04, 1.3960E-05),( 1.7853E-04, 1.3913E-05),
     &  ( 1.7799E-04, 1.3868E-05),( 1.7745E-04, 1.3822E-05),
     &  ( 1.7695E-04, 1.3778E-05),( 1.7644E-04, 1.3733E-05),
     &  ( 1.7597E-04, 1.3691E-05),( 1.7549E-04, 1.3646E-05),
     &  ( 1.7504E-04, 1.3605E-05),( 1.7459E-04, 1.3561E-05),
     &  ( 1.7417E-04, 1.3520E-05),( 1.7374E-04, 1.3478E-05),
     &  ( 1.7333E-04, 1.3436E-05),( 1.7294E-04, 1.3396E-05),
     &  ( 1.7255E-04, 1.3355E-05),( 1.7217E-04, 1.3316E-05),
     &  ( 1.7188E-04, 1.3276E-05),( 1.7159E-04, 1.3238E-05),
     &  ( 1.7130E-04, 1.3198E-05),( 1.7102E-04, 1.3161E-05),
     &  ( 1.7072E-04, 1.3122E-05),( 1.7044E-04, 1.3086E-05),
     &  ( 1.7015E-04, 1.3048E-05),( 1.6987E-04, 1.3012E-05),
     &  ( 1.6957E-04, 1.2975E-05),( 1.6929E-04, 1.2940E-05),
     &  ( 1.6901E-04, 1.2905E-05),( 1.6872E-04, 1.2869E-05),
     &  ( 1.6844E-04, 1.2834E-05),( 1.6814E-04, 1.2799E-05),
     &  ( 1.6786E-04, 1.2765E-05),( 1.6757E-04, 1.2731E-05),
     &  ( 1.6729E-04, 1.2698E-05),( 1.6699E-04, 1.2663E-05),
     &  ( 1.6671E-04, 1.2631E-05),( 1.6642E-04, 1.2598E-05),
     &  ( 1.6613E-04, 1.2566E-05),( 1.6584E-04, 1.2533E-05),
     &  ( 1.6379E-04, 1.2195E-05),( 1.6174E-04, 1.1889E-05),
     &  ( 1.6151E-04, 1.1842E-05),( 1.5365E-04, 1.0203E-05),
     &  ( 1.5157E-04, 9.6708E-06),( 1.4792E-04, 8.6433E-06),
     &  ( 1.4657E-04, 8.2159E-06),( 1.4651E-04, 8.1970E-06),
     &  ( 1.4516E-04, 7.7295E-06),( 1.4516E-04, 7.7281E-06),
     &  ( 1.4440E-04, 7.4273E-06),( 1.4437E-04, 7.4165E-06),
     &  ( 1.4436E-04, 7.4100E-06),( 1.4404E-04, 7.2730E-06),
     &  ( 1.4385E-04, 7.1852E-06),( 1.4382E-04, 7.1697E-06),
     &  ( 1.4377E-04, 7.1446E-06),( 1.4370E-04, 7.1078E-06),
     &  ( 1.4364E-04, 7.0820E-06),( 1.4361E-04, 7.0659E-06),
     &  ( 1.4331E-04, 6.9138E-06),( 1.4330E-04, 6.9063E-06),
     &  ( 1.4322E-04, 6.8627E-06),( 1.4321E-04, 6.8547E-06),
     &  ( 1.4315E-04, 6.8189E-06),( 1.4313E-04, 6.8049E-06),
     &  ( 1.4311E-04, 6.7937E-06),( 1.4309E-04, 6.7834E-06),
     &  ( 1.4304E-04, 6.7534E-06),( 1.4297E-04, 6.7103E-06),
     &  ( 1.4294E-04, 6.6921E-06),( 1.4276E-04, 6.5741E-06),
     &  ( 1.4262E-04, 6.4762E-06)/

  
         DATA ((CGS  (I,J), I=   1, 100), J=1,1) /
     &  (-1.8527E-03,-0.0000E+00),(-1.9715E-03,-1.1494E-05),
     &  (-2.0976E-03,-3.2982E-05),(-2.2239E-03,-6.0797E-05),
     &  (-2.3549E-03,-9.3767E-05),(-2.4872E-03,-1.3107E-04),
     &  (-2.5868E-03,-1.7226E-04),(-2.7794E-03,-2.7653E-04),
     &  (-2.8612E-03,-3.1178E-04),(-2.9371E-03,-3.4950E-04),
     &  (-3.0558E-03,-3.9715E-04),(-3.1660E-03,-4.4432E-04),
     &  (-3.2929E-03,-4.9866E-04),(-3.3803E-03,-5.3307E-04),
     &  (-3.4865E-03,-5.9399E-04),(-3.5942E-03,-6.3423E-04),
     &  (-3.7026E-03,-6.9117E-04),(-3.8114E-03,-7.3672E-04),
     &  (-3.8999E-03,-7.8648E-04),(-4.0170E-03,-8.5109E-04),
     &  (-4.1082E-03,-8.8521E-04),(-4.2233E-03,-9.3526E-04),
     &  (-4.3159E-03,-9.9437E-04),(-4.4350E-03,-1.0738E-03),
     &  (-4.5332E-03,-1.1237E-03),(-4.6313E-03,-1.1606E-03),
     &  (-4.7548E-03,-1.2114E-03),(-4.8190E-03,-1.2517E-03),
     &  (-4.8520E-03,-1.2708E-03),(-4.9531E-03,-1.3204E-03),
     &  (-5.0592E-03,-1.3785E-03),(-5.1667E-03,-1.4308E-03),
     &  (-5.2720E-03,-1.4854E-03),(-5.3816E-03,-1.5486E-03),
     &  (-5.4954E-03,-1.6076E-03),(-5.6153E-03,-1.6551E-03),
     &  (-5.7341E-03,-1.6973E-03),(-5.8576E-03,-1.7460E-03),
     &  (-5.9844E-03,-1.8182E-03),(-6.1175E-03,-1.8912E-03),
     &  (-6.2174E-03,-1.9473E-03),(-6.3509E-03,-2.0285E-03),
     &  (-6.4866E-03,-2.1261E-03),(-6.5867E-03,-2.1942E-03),
     &  (-6.7259E-03,-2.2784E-03),(-6.8674E-03,-2.3522E-03),
     &  (-6.9787E-03,-2.3981E-03),(-7.1336E-03,-2.4594E-03),
     &  (-7.2471E-03,-2.5032E-03),(-7.4117E-03,-2.5559E-03),
     &  (-8.3064E-03,-3.0476E-03),(-9.2522E-03,-3.8249E-03),
     &  (-1.0609E-02,-4.8003E-03),(-1.2346E-02,-6.2057E-03),
     &  (-1.2935E-02,-6.8738E-03),(-1.3080E-02,-7.0112E-03),
     &  (-1.3536E-02,-7.4276E-03),(-1.4158E-02,-8.1562E-03),
     &  (-1.4801E-02,-9.0268E-03),(-1.5458E-02,-9.9964E-03),
     &  (-1.6107E-02,-1.0924E-02),(-1.6335E-02,-1.1386E-02),
     &  (-1.6726E-02,-1.2192E-02),(-1.7390E-02,-1.3496E-02),
     &  (-1.7882E-02,-1.4757E-02),(-1.8396E-02,-1.6501E-02),
     &  (-1.8787E-02,-1.8247E-02),(-1.9056E-02,-2.0317E-02),
     &  (-1.9056E-02,-2.0810E-02),(-1.9060E-02,-2.2473E-02),
     &  (-1.9029E-02,-2.3645E-02),(-1.8864E-02,-2.4841E-02),
     &  (-1.8391E-02,-2.7172E-02),(-1.7496E-02,-2.9881E-02),
     &  (-1.6252E-02,-3.2520E-02),(-1.4381E-02,-3.4925E-02),
     &  (-1.2007E-02,-3.7549E-02),(-9.0602E-03,-3.9890E-02),
     &  (-6.0720E-03,-4.1480E-02),(-4.9928E-03,-4.1976E-02),
     &  (-2.0871E-03,-4.2692E-02),(-6.7974E-04,-4.2627E-02),
     &  ( 8.2268E-04,-4.2826E-02),( 1.9964E-03,-4.2940E-02),
     &  ( 3.8150E-03,-4.2828E-02),( 5.8276E-03,-4.2425E-02),
     &  ( 7.0019E-03,-4.2040E-02),( 7.8133E-03,-4.1906E-02),
     &  ( 8.4110E-03,-4.1832E-02),( 8.9184E-03,-4.1683E-02),
     &  ( 9.3194E-03,-4.1561E-02),( 9.6681E-03,-4.1434E-02),
     &  ( 9.9695E-03,-4.1304E-02),( 1.0258E-02,-4.1191E-02),
     &  ( 1.0539E-02,-4.1090E-02),( 1.0952E-02,-4.0945E-02),
     &  ( 1.1111E-02,-4.0897E-02),( 1.1272E-02,-4.0849E-02),
     &  ( 1.1496E-02,-4.0782E-02),( 1.1662E-02,-4.0600E-02)/
  
         DATA ((CGS  (I,J), I= 101, 200), J=1,1) /
     &  ( 1.1810E-02,-4.0402E-02),( 1.1928E-02,-4.0215E-02),
     &  ( 1.2034E-02,-4.0037E-02),( 1.2127E-02,-3.9881E-02),
     &  ( 1.2213E-02,-3.9740E-02),( 1.2273E-02,-3.9604E-02),
     &  ( 1.2331E-02,-3.9470E-02),( 1.2388E-02,-3.9338E-02),
     &  ( 1.2433E-02,-3.9207E-02),( 1.2473E-02,-3.9077E-02),
     &  ( 1.2503E-02,-3.8947E-02),( 1.2516E-02,-3.8813E-02),
     &  ( 1.2530E-02,-3.8676E-02),( 1.2544E-02,-3.8615E-02),
     &  ( 1.2550E-02,-3.8617E-02),( 1.2544E-02,-3.8620E-02),
     &  ( 1.2532E-02,-3.8624E-02),( 1.2524E-02,-3.8632E-02),
     &  ( 1.2591E-02,-3.8687E-02),( 1.2676E-02,-3.8726E-02),
     &  ( 1.2766E-02,-3.8758E-02),( 1.2868E-02,-3.8785E-02),
     &  ( 1.2992E-02,-3.8811E-02),( 1.3124E-02,-3.8835E-02),
     &  ( 1.3270E-02,-3.8859E-02),( 1.3429E-02,-3.8880E-02),
     &  ( 1.3598E-02,-3.8829E-02),( 1.3779E-02,-3.8777E-02),
     &  ( 1.3976E-02,-3.8725E-02),( 1.4179E-02,-3.8672E-02),
     &  ( 1.4386E-02,-3.8618E-02),( 1.4600E-02,-3.8563E-02),
     &  ( 1.4817E-02,-3.8505E-02),( 1.5016E-02,-3.8446E-02),
     &  ( 1.5250E-02,-3.8384E-02),( 1.5429E-02,-3.8310E-02),
     &  ( 1.5581E-02,-3.8177E-02),( 1.5654E-02,-3.8037E-02),
     &  ( 1.5613E-02,-3.7939E-02),( 1.5670E-02,-3.7833E-02),
     &  ( 1.5803E-02,-3.7723E-02),( 1.5988E-02,-3.7545E-02),
     &  ( 1.6182E-02,-3.7350E-02),( 1.6332E-02,-3.7080E-02),
     &  ( 1.6495E-02,-3.6739E-02),( 1.6667E-02,-3.6351E-02),
     &  ( 1.6821E-02,-3.5898E-02),( 1.6999E-02,-3.5555E-02),
     &  ( 1.7189E-02,-3.5192E-02),( 1.7400E-02,-3.4782E-02),
     &  ( 1.7697E-02,-3.4266E-02),( 1.8189E-02,-3.3415E-02),
     &  ( 1.8333E-02,-3.3144E-02),( 1.8766E-02,-3.2395E-02),
     &  ( 1.9199E-02,-3.1638E-02),( 1.9590E-02,-3.0862E-02),
     &  ( 1.9888E-02,-3.0022E-02),( 2.0162E-02,-2.9172E-02),
     &  ( 2.0342E-02,-2.7587E-02),( 2.0465E-02,-2.6894E-02),
     &  ( 2.0633E-02,-2.6212E-02),( 2.0854E-02,-2.4948E-02),
     &  ( 2.0931E-02,-2.4409E-02),( 2.0952E-02,-2.3734E-02),
     &  ( 2.0950E-02,-2.3103E-02),( 2.0928E-02,-2.2532E-02),
     &  ( 2.0873E-02,-2.1861E-02),( 2.0846E-02,-2.1505E-02),
     &  ( 2.0600E-02,-1.9714E-02),( 2.0238E-02,-1.8078E-02),
     &  ( 1.9783E-02,-1.6716E-02),( 1.9342E-02,-1.5738E-02),
     &  ( 1.8765E-02,-1.4604E-02),( 1.8119E-02,-1.3499E-02),
     &  ( 1.7415E-02,-1.2356E-02),( 1.6802E-02,-1.1539E-02),
     &  ( 1.6052E-02,-1.0729E-02),( 1.5218E-02,-1.0042E-02),
     &  ( 1.4533E-02,-9.5415E-03),( 1.4124E-02,-9.2808E-03),
     &  ( 1.3361E-02,-8.7466E-03),( 1.3000E-02,-8.4955E-03),
     &  ( 1.2134E-02,-7.9254E-03),( 1.1376E-02,-7.4740E-03),
     &  ( 1.0413E-02,-7.0657E-03),( 9.5662E-03,-6.6970E-03),
     &  ( 8.4809E-03,-6.3487E-03),( 7.5072E-03,-6.0542E-03),
     &  ( 6.4617E-03,-5.8041E-03),( 5.0865E-03,-5.4725E-03),
     &  ( 4.3376E-03,-5.3669E-03),( 3.8239E-03,-5.2816E-03),
     &  ( 2.7197E-03,-5.1044E-03),( 2.1277E-03,-5.0087E-03),
     &  ( 1.4804E-03,-4.9247E-03),( 8.0291E-04,-4.8264E-03),
     &  ( 7.0613E-05,-4.8142E-03),(-7.0486E-04,-4.7481E-03),
     &  (-1.5049E-03,-4.6654E-03),(-3.2334E-03,-4.7559E-03)/
  
         DATA ((CGS  (I,J), I= 201, 300), J=1,1) /
     &  (-5.2541E-03,-4.5396E-03),(-6.4185E-03,-4.4118E-03),
     &  (-6.8555E-03,-4.3747E-03),(-7.3091E-03,-4.3699E-03),
     &  (-7.7837E-03,-4.3893E-03),(-8.2740E-03,-4.4087E-03),
     &  (-8.7831E-03,-4.3680E-03),(-9.3124E-03,-4.3033E-03),
     &  (-9.8636E-03,-4.2385E-03),(-1.0452E-02,-4.2452E-03),
     &  (-1.1050E-02,-4.2638E-03),(-1.1677E-02,-4.2824E-03),
     &  (-1.2337E-02,-4.2337E-03),(-1.3028E-02,-4.1907E-03),
     &  (-1.3748E-02,-4.1623E-03),(-1.4504E-02,-4.1960E-03),
     &  (-1.5299E-02,-4.2296E-03),(-1.6135E-02,-4.2507E-03),
     &  (-1.7017E-02,-4.2403E-03),(-1.7946E-02,-4.2300E-03),
     &  (-1.8931E-02,-4.2403E-03),(-1.9976E-02,-4.2781E-03),
     &  (-2.1105E-02,-4.3160E-03),(-2.2298E-02,-4.3434E-03),
     &  (-2.3588E-02,-4.3630E-03),(-2.4989E-02,-4.3826E-03),
     &  (-2.6538E-02,-4.4351E-03),(-2.8305E-02,-4.5084E-03),
     &  (-3.0339E-02,-4.6009E-03),(-3.3188E-02,-4.6935E-03),
     &  (-3.5657E-02,-4.7332E-03),(-3.5561E-02,-7.9897E-03),
     &  (-3.5307E-02,-8.0459E-03),(-3.5327E-02,-8.1816E-03),
     &  (-3.6450E-02,-8.3174E-03),(-3.8444E-02,-8.4537E-03),
     &  (-3.9937E-02,-8.5895E-03),(-4.2564E-02,-8.7162E-03),
     &  (-4.5800E-02,-9.3359E-03),(-4.8209E-02,-1.0098E-02),
     &  (-5.1199E-02,-1.0955E-02),(-5.4383E-02,-1.1812E-02),
     &  (-5.7739E-02,-1.2702E-02),(-6.2009E-02,-1.3637E-02),
     &  (-6.6280E-02,-1.4603E-02),(-7.1725E-02,-1.5816E-02),
     &  (-7.9185E-02,-1.7029E-02),(-8.7313E-02,-2.0668E-02),
     &  (-9.4880E-02,-2.5688E-02),(-1.0275E-01,-3.0708E-02),
     &  (-1.1309E-01,-3.5728E-02),(-1.2433E-01,-4.4907E-02),
     &  (-1.3537E-01,-5.5274E-02),(-1.5050E-01,-6.5968E-02),
     &  (-1.5644E-01,-7.1222E-02),(-1.6352E-01,-7.6474E-02),
     &  (-1.6897E-01,-8.3229E-02),(-1.7435E-01,-9.1238E-02),
     &  (-1.7977E-01,-1.0221E-01),(-1.8542E-01,-1.1318E-01),
     &  (-1.8782E-01,-1.2416E-01),(-1.8985E-01,-1.3513E-01),
     &  (-1.8341E-01,-1.4634E-01),(-1.7947E-01,-1.6211E-01),
     &  (-1.9457E-01,-1.7788E-01),(-1.9327E-01,-1.9607E-01),
     &  (-1.4901E-01,-2.2528E-01),(-1.6952E-01,-2.4464E-01),
     &  (-1.6204E-01,-2.5433E-01),(-1.4275E-01,-2.7275E-01),
     &  (-1.2046E-01,-2.9046E-01),(-9.4433E-02,-3.0709E-01),
     &  (-5.8921E-02,-3.1609E-01),(-2.5968E-02,-3.2326E-01),
     &  ( 8.5521E-03,-3.2568E-01),( 4.5072E-02,-3.2548E-01),
     &  ( 8.2686E-02,-3.1717E-01),( 1.1467E-01,-3.0085E-01),
     &  ( 1.3875E-01,-2.8325E-01),( 1.5782E-01,-2.6564E-01),
     &  ( 1.7475E-01,-2.4804E-01),( 1.8654E-01,-2.2779E-01),
     &  ( 1.9417E-01,-2.1005E-01),( 1.9892E-01,-1.9331E-01),
     &  ( 2.0200E-01,-1.7657E-01),( 2.0300E-01,-1.5983E-01),
     &  ( 2.0035E-01,-1.4659E-01),( 1.9641E-01,-1.3485E-01),
     &  ( 1.9435E-01,-1.2371E-01),( 1.9098E-01,-1.1379E-01),
     &  ( 1.8573E-01,-1.0562E-01),( 1.7730E-01,-9.5807E-02),
     &  ( 1.7407E-01,-8.9266E-02),( 1.7160E-01,-8.5994E-02),
     &  ( 1.6659E-01,-7.9453E-02),( 1.6214E-01,-7.5136E-02),
     &  ( 1.5868E-01,-7.2019E-02),( 1.5426E-01,-6.8902E-02),
     &  ( 1.5038E-01,-6.5784E-02),( 1.4757E-01,-6.2667E-02)/
  
         DATA ((CGS  (I,J), I= 301, 400), J=1,1) /
     &  ( 1.5028E-01,-5.9549E-02),( 1.4296E-01,-5.6432E-02),
     &  ( 1.4033E-01,-5.3314E-02),( 1.3750E-01,-5.0197E-02),
     &  ( 1.2845E-01,-4.3860E-02),( 1.2175E-01,-3.7523E-02),
     &  ( 1.1478E-01,-3.1186E-02),( 1.0698E-01,-2.5813E-02),
     &  ( 9.8909E-02,-2.3275E-02),( 9.3332E-02,-2.1739E-02),
     &  ( 8.8882E-02,-2.0203E-02),( 8.5130E-02,-1.8668E-02),
     &  ( 8.1691E-02,-1.7132E-02),( 7.8551E-02,-1.5595E-02),
     &  ( 7.5613E-02,-1.4060E-02),( 7.2455E-02,-1.2524E-02),
     &  ( 6.9184E-02,-1.1383E-02),( 6.6184E-02,-1.0824E-02),
     &  ( 6.3671E-02,-1.0302E-02),( 6.1460E-02,-9.7930E-03),
     &  ( 5.9379E-02,-9.2847E-03),( 5.7465E-02,-8.7763E-03),
     &  ( 5.5367E-02,-8.2514E-03),( 5.3324E-02,-7.7062E-03),
     &  ( 5.0494E-02,-7.1430E-03),( 4.6164E-02,-6.8527E-03),
     &  ( 4.7489E-02,-1.1078E-02),( 4.9797E-02,-1.0966E-02),
     &  ( 4.8634E-02,-1.0765E-02),( 4.7755E-02,-1.0563E-02),
     &  ( 4.6860E-02,-1.0362E-02),( 4.6047E-02,-1.0161E-02),
     &  ( 4.5230E-02,-9.9595E-03),( 4.4420E-02,-9.7582E-03),
     &  ( 4.3653E-02,-9.5503E-03),( 4.2917E-02,-9.3333E-03),
     &  ( 4.2202E-02,-9.1164E-03),( 4.1535E-02,-8.8995E-03),
     &  ( 4.0892E-02,-8.6825E-03),( 4.0270E-02,-8.4656E-03),
     &  ( 3.9673E-02,-8.2487E-03),( 3.9100E-02,-7.9754E-03),
     &  ( 3.8558E-02,-7.8840E-03),( 3.7966E-02,-7.7925E-03),
     &  ( 3.7479E-02,-7.7011E-03),( 3.6951E-02,-7.6096E-03),
     &  ( 3.6495E-02,-7.5182E-03),( 3.6041E-02,-7.4267E-03),
     &  ( 3.5677E-02,-7.3365E-03),( 3.5178E-02,-7.2538E-03),
     &  ( 3.4569E-02,-7.1711E-03),( 3.4308E-02,-7.0883E-03),
     &  ( 3.3899E-02,-7.0056E-03),( 3.3505E-02,-6.9229E-03),
     &  ( 3.3124E-02,-6.8402E-03),( 3.2748E-02,-6.7165E-03),
     &  ( 3.1722E-02,-6.3097E-03),( 2.9496E-02,-5.9365E-03),
     &  ( 2.6010E-02,-5.4293E-03),( 2.3455E-02,-5.2418E-03),
     &  ( 2.1512E-02,-5.0637E-03),( 1.9979E-02,-4.8225E-03),
     &  ( 1.8688E-02,-4.7028E-03),( 1.7592E-02,-4.5982E-03),
     &  ( 1.6658E-02,-4.6536E-03),( 1.6571E-02,-4.6668E-03),
     &  ( 1.5500E-02,-4.7088E-03),( 1.4778E-02,-4.7201E-03),
     &  ( 1.4532E-02,-4.7075E-03),( 1.3948E-02,-4.7461E-03),
     &  ( 1.3394E-02,-4.7512E-03),( 1.3341E-02,-4.7492E-03),
     &  ( 1.2875E-02,-4.8174E-03),( 1.2385E-02,-4.8871E-03),
     &  ( 1.2152E-02,-4.9410E-03),( 1.1926E-02,-4.9705E-03),
     &  ( 1.1509E-02,-5.0953E-03),( 1.1138E-02,-5.2661E-03),
     &  ( 1.0800E-02,-5.3942E-03),( 1.0490E-02,-5.4403E-03),
     &  ( 1.0308E-02,-5.5166E-03),( 1.0184E-02,-5.5716E-03),
     &  ( 9.8891E-03,-5.6547E-03),( 9.6056E-03,-5.7775E-03),
     &  ( 9.5782E-03,-5.7890E-03),( 9.3506E-03,-5.9888E-03),
     &  ( 9.1230E-03,-6.1458E-03),( 9.0167E-03,-6.2175E-03),
     &  ( 8.9077E-03,-6.2877E-03),( 8.6950E-03,-6.3863E-03),
     &  ( 8.4746E-03,-6.6124E-03),( 8.2558E-03,-6.7256E-03),
     &  ( 8.1960E-03,-6.7853E-03),( 8.0543E-03,-7.0005E-03),
     &  ( 7.9616E-03,-7.1166E-03),( 7.8901E-03,-7.2469E-03),
     &  ( 7.7479E-03,-7.5105E-03),( 7.6098E-03,-7.6439E-03),
     &  ( 7.5953E-03,-7.6555E-03),( 7.4923E-03,-7.7482E-03)/
  
         DATA ((CGS  (I,J), I= 401, 500), J=1,1) /
     &  ( 7.2692E-03,-8.1159E-03),( 7.2057E-03,-8.4365E-03),
     &  ( 7.2083E-03,-8.7383E-03),( 7.2234E-03,-8.9717E-03),
     &  ( 7.2291E-03,-9.0592E-03),( 7.2832E-03,-9.3299E-03),
     &  ( 7.3088E-03,-9.4266E-03),( 7.3236E-03,-9.4846E-03),
     &  ( 7.3505E-03,-9.5722E-03),( 7.4071E-03,-9.7680E-03),
     &  ( 7.5004E-03,-9.9954E-03),( 7.6117E-03,-1.0186E-02),
     &  ( 7.6250E-03,-1.0199E-02),( 7.7518E-03,-1.0310E-02),
     &  ( 7.7648E-03,-1.0322E-02),( 7.8324E-03,-1.0383E-02),
     &  ( 7.8833E-03,-1.0433E-02),( 8.0291E-03,-1.0509E-02),
     &  ( 8.0486E-03,-1.0517E-02),( 8.1561E-03,-1.0615E-02),
     &  ( 8.1630E-03,-1.0623E-02),( 8.1703E-03,-1.0632E-02),
     &  ( 8.2342E-03,-1.0712E-02),( 8.2947E-03,-1.0792E-02),
     &  ( 8.3073E-03,-1.0808E-02),( 8.3966E-03,-1.1004E-02),
     &  ( 8.4050E-03,-1.1020E-02),( 8.4540E-03,-1.1087E-02),
     &  ( 8.4648E-03,-1.1100E-02),( 8.5321E-03,-1.1181E-02),
     &  ( 8.5665E-03,-1.1205E-02),( 8.6824E-03,-1.1279E-02),
     &  ( 8.6941E-03,-1.1287E-02),( 8.8249E-03,-1.1369E-02),
     &  ( 8.9275E-03,-1.1372E-02),( 8.9854E-03,-1.1364E-02),
     &  ( 8.9972E-03,-1.1362E-02),( 9.1420E-03,-1.1504E-02),
     &  ( 9.1688E-03,-1.1531E-02),( 9.3288E-03,-1.1663E-02),
     &  ( 9.4747E-03,-1.1756E-02),( 9.5412E-03,-1.1796E-02),
     &  ( 9.5878E-03,-1.1823E-02),( 9.6117E-03,-1.1836E-02),
     &  ( 9.8538E-03,-1.1804E-02),( 9.9028E-03,-1.1797E-02),
     &  ( 1.0038E-02,-1.1724E-02),( 1.0163E-02,-1.1650E-02),
     &  ( 1.0220E-02,-1.1615E-02),( 1.0389E-02,-1.1503E-02),
     &  ( 1.0538E-02,-1.1390E-02),( 1.0572E-02,-1.1368E-02),
     &  ( 1.0588E-02,-1.1368E-02),( 1.0687E-02,-1.1371E-02),
     &  ( 1.0735E-02,-1.1372E-02),( 1.0785E-02,-1.1374E-02),
     &  ( 1.0981E-02,-1.1069E-02),( 1.1006E-02,-1.1018E-02),
     &  ( 1.1058E-02,-1.0863E-02),( 1.1082E-02,-1.0761E-02),
     &  ( 1.1101E-02,-1.0606E-02),( 1.1100E-02,-1.0581E-02),
     &  ( 1.1098E-02,-1.0504E-02),( 1.1092E-02,-1.0452E-02),
     &  ( 1.1085E-02,-1.0403E-02),( 1.1058E-02,-1.0286E-02),
     &  ( 1.1012E-02,-1.0145E-02),( 1.0952E-02,-1.0057E-02),
     &  ( 1.0843E-02,-9.9345E-03),( 1.0725E-02,-9.8434E-03),
     &  ( 1.0712E-02,-9.8332E-03),( 1.0538E-02,-9.7117E-03),
     &  ( 1.0416E-02,-9.6153E-03),( 1.0306E-02,-9.5327E-03),
     &  ( 1.0288E-02,-9.5327E-03),( 1.0130E-02,-9.5326E-03),
     &  ( 1.0103E-02,-9.5326E-03),( 1.0021E-02,-9.5515E-03),
     &  ( 9.7939E-03,-9.6841E-03),( 9.7870E-03,-9.9114E-03),
     &  ( 9.8008E-03,-9.9493E-03),( 9.8629E-03,-9.9278E-03),
     &  ( 9.8322E-03,-9.9043E-03),( 9.7932E-03,-9.8903E-03),
     &  ( 9.6641E-03,-9.8876E-03),( 9.4895E-03,-9.9149E-03),
     &  ( 9.4217E-03,-9.9390E-03),( 9.3574E-03,-9.9522E-03),
     &  ( 9.2545E-03,-9.9732E-03),( 9.2303E-03,-9.9964E-03),
     &  ( 9.1634E-03,-1.0054E-02),( 9.1510E-03,-1.0066E-02),
     &  ( 9.1023E-03,-1.0112E-02),( 9.0493E-03,-1.0170E-02),
     &  ( 9.0006E-03,-1.0228E-02),( 8.9847E-03,-1.0251E-02),
     &  ( 8.8304E-03,-1.0481E-02),( 8.5372E-03,-1.0617E-02),
     &  ( 8.5144E-03,-1.1016E-02),( 9.2430E-03,-1.1724E-02)/
  
         DATA ((CGS  (I,J), I= 501, 600), J=1,1) /
     &  ( 9.7161E-03,-1.1898E-02),( 9.9363E-03,-1.1929E-02),
     &  ( 1.0243E-02,-1.1733E-02),( 1.0253E-02,-1.1892E-02),
     &  ( 1.0353E-02,-1.1861E-02),( 1.0429E-02,-1.1823E-02),
     &  ( 1.0434E-02,-1.1730E-02),( 1.0355E-02,-1.1683E-02),
     &  ( 1.0206E-02,-1.1635E-02),( 1.0004E-02,-1.1647E-02),
     &  ( 9.7655E-03,-1.1651E-02),( 9.4470E-03,-1.1651E-02),
     &  ( 9.0301E-03,-1.1651E-02),( 8.4584E-03,-1.1620E-02),
     &  ( 7.6459E-03,-1.1588E-02),( 6.4636E-03,-1.1558E-02),
     &  ( 4.6491E-03,-1.1557E-02),( 4.1726E-03,-1.1559E-02),
     &  ( 3.6422E-03,-1.1561E-02),( 3.0487E-03,-1.1563E-02),
     &  ( 2.3814E-03,-1.1565E-02),( 1.6211E-03,-1.1567E-02),
     &  ( 7.5126E-04,-1.1569E-02),(-2.5524E-04,-1.1571E-02),
     &  (-4.7596E-04,-1.1572E-02),(-7.0392E-04,-1.1572E-02),
     &  (-9.3763E-04,-1.1573E-02),(-1.1808E-03,-1.1573E-02),
     &  (-1.4321E-03,-1.1573E-02),(-1.6920E-03,-1.1574E-02),
     &  (-1.9615E-03,-1.1574E-02),(-2.2400E-03,-1.1575E-02),
     &  (-2.5292E-03,-1.1575E-02),(-2.8290E-03,-1.1575E-02),
     &  (-4.3139E-03,-1.1577E-02),(-5.4788E-03,-1.1580E-02),
     &  (-6.1209E-03,-1.1581E-02),(-6.5723E-03,-1.1582E-02),
     &  (-7.0439E-03,-1.1583E-02),(-7.5382E-03,-1.1584E-02),
     &  (-8.0569E-03,-1.1585E-02),(-8.6027E-03,-1.1586E-02),
     &  (-9.1760E-03,-1.1587E-02),(-9.4738E-03,-1.1587E-02),
     &  (-9.7794E-03,-1.1588E-02),(-1.0093E-02,-1.1588E-02),
     &  (-1.0416E-02,-1.1588E-02),(-1.0748E-02,-1.1589E-02),
     &  (-1.1088E-02,-1.1589E-02),(-1.1439E-02,-1.1590E-02),
     &  (-1.1800E-02,-1.1590E-02),(-1.2171E-02,-1.1591E-02),
     &  (-1.2553E-02,-1.1591E-02),(-1.2947E-02,-1.1592E-02),
     &  (-1.3353E-02,-1.1592E-02),(-1.3772E-02,-1.1592E-02),
     &  (-1.4205E-02,-1.1593E-02),(-1.4651E-02,-1.1593E-02),
     &  (-1.5111E-02,-1.1593E-02),(-1.5587E-02,-1.1593E-02),
     &  (-1.6079E-02,-1.1593E-02),(-1.6588E-02,-1.1593E-02),
     &  (-1.7115E-02,-1.1593E-02),(-1.7661E-02,-1.1593E-02),
     &  (-1.8227E-02,-1.1593E-02),(-1.8814E-02,-1.1593E-02),
     &  (-1.9423E-02,-1.1593E-02),(-2.0055E-02,-1.1593E-02),
     &  (-2.0712E-02,-1.1593E-02),(-2.1396E-02,-1.1593E-02),
     &  (-2.2107E-02,-1.1593E-02),(-2.2849E-02,-1.1593E-02),
     &  (-2.3622E-02,-1.1593E-02),(-2.4429E-02,-1.1591E-02),
     &  (-2.5271E-02,-1.1589E-02),(-2.6153E-02,-1.1587E-02),
     &  (-2.7074E-02,-1.1585E-02),(-2.8040E-02,-1.1583E-02),
     &  (-2.9053E-02,-1.1581E-02),(-3.0117E-02,-1.1579E-02),
     &  (-3.1235E-02,-1.1577E-02),(-3.2411E-02,-1.1574E-02),
     &  (-3.3652E-02,-1.1572E-02),(-3.4298E-02,-1.1573E-02),
     &  (-3.4962E-02,-1.1574E-02),(-3.5644E-02,-1.1575E-02),
     &  (-3.6347E-02,-1.1576E-02),(-3.7069E-02,-1.1577E-02),
     &  (-3.7813E-02,-1.1578E-02),(-3.8579E-02,-1.1579E-02),
     &  (-3.9368E-02,-1.1580E-02),(-4.0182E-02,-1.1581E-02),
     &  (-4.1021E-02,-1.1582E-02),(-4.1887E-02,-1.1582E-02),
     &  (-4.2781E-02,-1.1583E-02),(-4.3704E-02,-1.1584E-02),
     &  (-4.4660E-02,-1.1585E-02),(-4.5647E-02,-1.1586E-02),
     &  (-4.6668E-02,-1.1587E-02),(-4.7724E-02,-1.1588E-02)/
  
         DATA ((CGS  (I,J), I= 601, 700), J=1,1) /
     &  (-4.8818E-02,-1.1589E-02),(-4.9953E-02,-1.1590E-02),
     &  (-5.1127E-02,-1.1591E-02),(-5.2348E-02,-1.1592E-02),
     &  (-5.3616E-02,-1.1593E-02),(-5.4934E-02,-1.1593E-02),
     &  (-5.6305E-02,-1.1594E-02),(-5.7731E-02,-1.1595E-02),
     &  (-5.9218E-02,-1.1596E-02),(-6.0768E-02,-1.1597E-02),
     &  (-6.2386E-02,-1.1598E-02),(-6.4076E-02,-1.1599E-02),
     &  (-6.5842E-02,-1.1600E-02),(-6.7692E-02,-1.1601E-02),
     &  (-6.9630E-02,-1.1602E-02),(-7.1663E-02,-1.1603E-02),
     &  (-7.3798E-02,-1.1604E-02),(-7.6043E-02,-1.1605E-02),
     &  (-7.8407E-02,-1.1605E-02),(-8.0900E-02,-1.1606E-02),
     &  (-8.3532E-02,-1.1607E-02),(-8.7474E-02,-1.1609E-02),
     &  (-8.9263E-02,-1.1609E-02),(-9.2390E-02,-1.1608E-02),
     &  (-9.5714E-02,-1.1608E-02),(-9.9254E-02,-1.1607E-02),
     &  (-1.0303E-01,-1.1606E-02),(-1.0707E-01,-1.1605E-02),
     &  (-1.1140E-01,-1.1604E-02),(-1.1606E-01,-1.1604E-02),
     &  (-1.2107E-01,-1.1603E-02),(-1.2649E-01,-1.1602E-02),
     &  (-1.3237E-01,-1.1601E-02),(-1.3876E-01,-1.1600E-02),
     &  (-1.4386E-01,-1.1600E-02),(-1.5977E-01,-1.1598E-02),
     &  (-1.7926E-01,-1.1597E-02),(-2.0372E-01,-1.1595E-02),
     &  (-2.3532E-01,-1.1593E-02),(-2.7777E-01,-1.1592E-02),
     &  (-3.3797E-01,-1.1591E-02),(-4.3384E-01,-1.1590E-02),
     &  (-5.8178E-01,-2.4694E-02),(-8.9252E-01,-4.2092E-02),
     &  (-1.8892E+00,-1.4673E-01),(-1.9984E+00,-1.6274E-01),
     &  (-2.1209E+00,-1.8178E-01),(-2.2594E+00,-2.0465E-01),
     &  (-2.4165E+00,-2.3245E-01),(-2.5972E+00,-2.6670E-01),
     &  (-2.8067E+00,-3.0957E-01),(-3.0526E+00,-3.6419E-01),
     &  (-3.3450E+00,-4.3528E-01),(-3.6986E+00,-5.3016E-01),
     &  (-4.1342E+00,-6.6072E-01),(-4.6841E+00,-8.4723E-01),
     &  (-5.3756E+00,-1.1266E+00),(-6.3594E+00,-1.5717E+00),
     &  (-6.4740E+00,-1.6302E+00),(-9.0412E+00,-3.2695E+00),
     &  (-1.0912E+01,-4.9190E+00),(-1.2416E+01,-6.5929E+00),
     &  (-7.7419E+00,-8.3730E+00),(-1.4734E+01,-1.0015E+01),
     &  (-1.5054E+01,-1.1709E+01),(-1.6309E+01,-1.3307E+01),
     &  (-1.7016E+01,-1.5209E+01),(-1.7508E+01,-1.6789E+01),
     &  (-1.7961E+01,-1.8582E+01),(-1.8276E+01,-2.0190E+01),
     &  (-1.8530E+01,-2.1965E+01),(-1.8668E+01,-2.3415E+01),
     &  (-1.8767E+01,-2.5513E+01),(-1.8772E+01,-2.6635E+01),
     &  (-1.8715E+01,-2.8409E+01),(-1.8566E+01,-3.0291E+01),
     &  (-1.8406E+01,-3.1602E+01),(-1.8060E+01,-3.3648E+01),
     &  (-1.7749E+01,-3.5057E+01),(-1.7365E+01,-3.6495E+01),
     &  (-1.6567E+01,-3.7956E+01),(-1.5786E+01,-3.9428E+01),
     &  (-1.4927E+01,-4.0901E+01),(-1.3996E+01,-4.2362E+01),
     &  (-1.4122E+01,-4.3797E+01),(-1.3176E+01,-4.5187E+01),
     &  (-1.2127E+01,-4.6517E+01),(-1.0977E+01,-4.7766E+01),
     &  (-9.0745E+00,-4.9447E+01),(-7.6994E+00,-5.0411E+01),
     &  (-5.5570E+00,-5.1576E+01),(-3.1822E+00,-5.2359E+01),
     &  ( 3.2101E+00,-5.2359E+01),( 9.0963E+00,-4.9449E+01),
     &  ( 1.0996E+01,-4.7768E+01),( 1.2681E+01,-4.5863E+01),
     &  ( 1.3678E+01,-4.4501E+01),( 1.4981E+01,-4.2365E+01),
     &  ( 1.4977E+01,-4.0904E+01),( 1.5826E+01,-3.9430E+01)/
  
         DATA ((CGS  (I,J), I= 701, 800), J=1,1) /
     &  ( 1.6596E+01,-3.7958E+01),( 1.7283E+01,-3.6498E+01),
     &  ( 1.7773E+01,-3.5060E+01),( 1.8144E+01,-3.3651E+01),
     &  ( 1.8334E+01,-3.2277E+01),( 1.8522E+01,-3.0944E+01),
     &  ( 1.8658E+01,-2.9655E+01),( 1.8747E+01,-2.8412E+01),
     &  ( 1.8804E+01,-2.6638E+01),( 1.4577E+01,-2.5516E+01),
     &  ( 1.5423E+01,-2.3924E+01),( 1.8605E+01,-2.2439E+01),
     &  ( 1.8494E+01,-2.1507E+01),( 1.8220E+01,-1.9775E+01),
     &  ( 1.7979E+01,-1.8585E+01),( 1.7622E+01,-1.7132E+01),
     &  ( 1.7240E+01,-1.5819E+01),( 1.6743E+01,-1.4355E+01),
     &  ( 1.6342E+01,-1.3063E+01),( 1.5152E+01,-1.1504E+01),
     &  ( 1.4852E+01,-1.0188E+01),( 1.4015E+01,-8.7828E+00),
     &  ( 1.3071E+01,-7.4093E+00),( 1.1857E+01,-5.9022E+00),
     &  ( 1.0359E+01,-4.4627E+00),( 8.7284E+00,-3.0160E+00),
     &  ( 7.1946E+00,-2.0113E+00),( 6.0031E+00,-1.3859E+00),
     &  ( 5.1435E+00,-1.0125E+00),( 4.4962E+00,-7.7238E-01),
     &  ( 3.9921E+00,-6.0908E-01),( 3.5890E+00,-4.9310E-01),
     &  ( 3.2595E+00,-4.0781E-01),( 2.9853E+00,-3.4330E-01),
     &  ( 2.7535E+00,-2.9332E-01),( 2.5551E+00,-2.5383E-01),
     &  ( 2.3833E+00,-2.2209E-01),( 2.2333E+00,-1.9619E-01),
     &  ( 2.1010E+00,-1.7480E-01),( 1.9836E+00,-1.5691E-01),
     &  ( 1.8787E+00,-1.4181E-01),( 1.7843E+00,-1.2895E-01),
     &  ( 1.6991E+00,-1.1790E-01),( 1.6216E+00,-1.0834E-01),
     &  ( 8.5638E-01,-3.8153E-02),( 5.8470E-01,-2.3784E-02),
     &  ( 4.4583E-01,-1.1582E-02),( 3.6362E-01,-1.1582E-02),
     &  ( 3.0343E-01,-1.1581E-02),( 2.6201E-01,-1.1580E-02),
     &  ( 2.3105E-01,-1.1580E-02),( 2.0698E-01,-1.1579E-02),
     &  ( 1.8772E-01,-1.1579E-02),( 1.7195E-01,-1.1578E-02),
     &  ( 1.7009E-01,-1.1578E-02),( 1.5708E-01,-1.1577E-02),
     &  ( 1.4606E-01,-1.1577E-02),( 1.3662E-01,-1.1576E-02),
     &  ( 1.2843E-01,-1.1575E-02),( 1.2126E-01,-1.1575E-02),
     &  ( 1.1493E-01,-1.1574E-02),( 1.0930E-01,-1.1573E-02),
     &  ( 1.0426E-01,-1.1573E-02),( 9.9726E-02,-1.1572E-02),
     &  ( 9.5621E-02,-1.1572E-02),( 9.1887E-02,-1.1571E-02),
     &  ( 8.8478E-02,-1.1570E-02),( 8.5352E-02,-1.1570E-02),
     &  ( 8.2476E-02,-1.1569E-02),( 7.9820E-02,-1.1568E-02),
     &  ( 7.7360E-02,-1.1568E-02),( 7.5076E-02,-1.1567E-02),
     &  ( 7.2949E-02,-1.1566E-02),( 7.0963E-02,-1.1566E-02),
     &  ( 6.9104E-02,-1.1565E-02),( 6.7361E-02,-1.1565E-02),
     &  ( 6.5725E-02,-1.1564E-02),( 6.4184E-02,-1.1563E-02),
     &  ( 6.2730E-02,-1.1563E-02),( 6.1357E-02,-1.1562E-02),
     &  ( 6.0058E-02,-1.1561E-02),( 5.8827E-02,-1.1561E-02),
     &  ( 5.7659E-02,-1.1560E-02),( 5.6550E-02,-1.1560E-02),
     &  ( 5.5494E-02,-1.1559E-02),( 5.4489E-02,-1.1558E-02),
     &  ( 5.3530E-02,-1.1558E-02),( 5.2614E-02,-1.1557E-02),
     &  ( 5.1739E-02,-1.1556E-02),( 5.0902E-02,-1.1556E-02),
     &  ( 5.0100E-02,-1.1555E-02),( 4.9332E-02,-1.1554E-02),
     &  ( 4.8595E-02,-1.1554E-02),( 4.7887E-02,-1.1553E-02),
     &  ( 4.7208E-02,-1.1553E-02),( 4.6554E-02,-1.1552E-02),
     &  ( 4.5924E-02,-1.1551E-02),( 4.5318E-02,-1.1551E-02),
     &  ( 4.4733E-02,-1.1550E-02),( 4.4170E-02,-1.1549E-02)/
  
         DATA ((CGS  (I,J), I= 801, 900), J=1,1) /
     &  ( 4.3626E-02,-1.1549E-02),( 4.3102E-02,-1.1548E-02),
     &  ( 4.2595E-02,-1.1548E-02),( 4.2105E-02,-1.1547E-02),
     &  ( 4.1631E-02,-1.1546E-02),( 4.1172E-02,-1.1546E-02),
     &  ( 4.0728E-02,-1.1545E-02),( 4.0298E-02,-1.1544E-02),
     &  ( 3.9881E-02,-1.1544E-02),( 3.9476E-02,-1.1543E-02),
     &  ( 3.9084E-02,-1.1543E-02),( 3.8703E-02,-1.1542E-02),
     &  ( 3.8334E-02,-1.1541E-02),( 3.7975E-02,-1.1541E-02),
     &  ( 3.7626E-02,-1.1540E-02),( 3.7287E-02,-1.1539E-02),
     &  ( 3.6958E-02,-1.1539E-02),( 3.6638E-02,-1.1538E-02),
     &  ( 3.6326E-02,-1.1537E-02),( 3.6023E-02,-1.1537E-02),
     &  ( 3.5729E-02,-1.1536E-02),( 3.5442E-02,-1.1536E-02),
     &  ( 3.5163E-02,-1.1535E-02),( 3.4891E-02,-1.1534E-02),
     &  ( 3.4626E-02,-1.1534E-02),( 3.4369E-02,-1.1533E-02),
     &  ( 3.4119E-02,-1.1532E-02),( 3.3875E-02,-1.1532E-02),
     &  ( 3.3638E-02,-1.1531E-02),( 3.3408E-02,-1.1531E-02),
     &  ( 3.3185E-02,-1.1530E-02),( 3.2968E-02,-1.1529E-02),
     &  ( 3.2759E-02,-1.1529E-02),( 3.2557E-02,-1.1528E-02),
     &  ( 3.2362E-02,-1.1527E-02),( 3.2176E-02,-1.1527E-02),
     &  ( 3.1999E-02,-1.1526E-02),( 3.1448E-02,-1.1525E-02),
     &  ( 3.1248E-02,-1.1525E-02),( 3.1054E-02,-1.1524E-02),
     &  ( 3.0863E-02,-1.1524E-02),( 3.0675E-02,-1.1523E-02),
     &  ( 3.0489E-02,-1.1522E-02),( 3.0308E-02,-1.1522E-02),
     &  ( 3.0130E-02,-1.1521E-02),( 2.9955E-02,-1.1520E-02),
     &  ( 2.9802E-02,-1.1520E-02),( 2.9611E-02,-1.1522E-02),
     &  ( 2.9444E-02,-1.1524E-02),( 2.9283E-02,-1.1526E-02),
     &  ( 2.9125E-02,-1.1528E-02),( 2.8971E-02,-1.1530E-02),
     &  ( 2.8820E-02,-1.1532E-02),( 2.8671E-02,-1.1534E-02),
     &  ( 2.8525E-02,-1.1536E-02),( 2.8382E-02,-1.1538E-02),
     &  ( 2.8241E-02,-1.1540E-02),( 2.3969E-02,-1.1620E-02),
     &  ( 2.1029E-02,-1.1719E-02),( 1.8448E-02,-1.1701E-02),
     &  ( 1.7581E-02,-1.1693E-02),( 1.6136E-02,-1.1683E-02),
     &  ( 1.4588E-02,-1.1688E-02),( 1.3863E-02,-1.1695E-02),
     &  ( 1.3027E-02,-1.1703E-02),( 1.2918E-02,-1.1704E-02),
     &  ( 1.2359E-02,-1.1729E-02),( 1.2024E-02,-1.1712E-02),
     &  ( 1.1962E-02,-1.1709E-02),( 1.1094E-02,-1.1714E-02),
     &  ( 9.9268E-03,-1.1719E-02),( 8.8562E-03,-1.1719E-02),
     &  ( 5.4143E-03,-1.1787E-02),( 7.8037E-03,-1.1777E-02),
     &  ( 7.7916E-03,-1.1769E-02),( 7.0687E-03,-1.1761E-02),
     &  ( 6.2368E-03,-1.1752E-02),( 5.2879E-03,-1.1744E-02),
     &  ( 4.1888E-03,-1.1735E-02),( 2.8931E-03,-1.1743E-02),
     &  ( 1.3348E-03,-1.1751E-02),(-5.8156E-04,-1.1759E-02),
     &  (-3.0045E-03,-1.1767E-02),(-4.1657E-03,-1.1776E-02),
     &  (-5.4676E-03,-1.1786E-02),(-6.9381E-03,-1.1795E-02),
     &  (-8.6134E-03,-1.1805E-02),(-1.0541E-02,-1.1814E-02),
     &  (-1.2782E-02,-1.1824E-02),(-1.4047E-02,-1.1830E-02),
     &  (-1.5425E-02,-1.1835E-02),(-1.6933E-02,-1.1840E-02),
     &  (-1.8590E-02,-1.1845E-02),(-2.0419E-02,-1.1851E-02),
     &  (-2.2448E-02,-1.1856E-02),(-2.4715E-02,-1.1861E-02),
     &  (-2.7261E-02,-1.1867E-02),(-3.0142E-02,-1.1872E-02),
     &  (-3.3432E-02,-1.1858E-02),(-3.7223E-02,-1.1845E-02)/
  
         DATA ((CGS  (I,J), I= 901,1000), J=1,1) /
     &  (-4.1640E-02,-1.1831E-02),(-4.6625E-02,-1.1818E-02),
     &  (-4.9889E-02,-1.1810E-02),(-5.3511E-02,-1.1803E-02),
     &  (-5.7553E-02,-1.1795E-02),(-6.2095E-02,-1.1788E-02),
     &  (-6.7235E-02,-1.1780E-02),(-7.3099E-02,-1.1773E-02),
     &  (-7.9855E-02,-1.1765E-02),(-8.7722E-02,-1.1758E-02),
     &  (-9.7001E-02,-1.1750E-02),(-1.0811E-01,-1.1743E-02),
     &  (-1.2166E-01,-1.1736E-02),(-1.3857E-01,-1.1728E-02),
     &  (-1.6026E-01,-1.1721E-02),(-1.8916E-01,-1.1713E-02),
     &  (-2.2968E-01,-1.1706E-02),(-2.9113E-01,-1.1698E-02),
     &  (-3.9983E-01,-1.1691E-02),(-5.9210E-01,-1.1467E-01),
     &  (-8.6739E-01,-2.4082E-01),(-1.0270E+00,-3.3765E-01),
     &  (-1.2018E+00,-4.6649E-01),(-1.6327E+00,-9.1118E-01),
     &  (-1.7885E+00,-1.1309E+00),(-1.8382E+00,-1.3467E+00),
     &  (-2.0250E+00,-1.5628E+00),(-2.0967E+00,-1.7772E+00),
     &  (-2.1925E+00,-1.9851E+00),(-2.2573E+00,-2.1988E+00),
     &  (-2.2718E+00,-2.4122E+00),(-2.3139E+00,-2.6017E+00),
     &  (-2.3808E+00,-2.8093E+00),(-2.4038E+00,-3.0166E+00),
     &  (-2.4174E+00,-3.2201E+00),(-2.4222E+00,-3.4156E+00),
     &  (-2.4186E+00,-3.6232E+00),(-2.4090E+00,-3.7929E+00),
     &  (-2.3895E+00,-3.9954E+00),(-2.3641E+00,-4.1796E+00),
     &  (-2.3330E+00,-4.3700E+00),(-2.2904E+00,-4.5657E+00),
     &  (-2.2400E+00,-4.7370E+00),(-2.1754E+00,-4.9398E+00),
     &  (-2.1101E+00,-5.1152E+00),(-2.0350E+00,-5.2908E+00),
     &  (-1.9497E+00,-5.4654E+00),(-1.8367E+00,-5.6659E+00),
     &  (-1.7281E+00,-5.8330E+00),(-1.5873E+00,-6.0202E+00),
     &  (-1.4548E+00,-6.1717E+00),(-1.2617E+00,-6.3574E+00),
     &  (-1.0508E+00,-6.5202E+00),(-7.3596E-01,-6.6986E+00),
     &  (-4.6150E-01,-6.7993E+00),(-1.4536E-01,-6.8581E+00),
     &  ( 1.4767E-02,-6.8655E+00),( 1.7490E-01,-6.8582E+00),
     &  ( 3.3400E-01,-6.8361E+00),( 7.6554E-01,-6.6990E+00),
     &  ( 1.0805E+00,-6.5207E+00),( 1.2913E+00,-6.3580E+00),
     &  ( 1.4846E+00,-6.1723E+00),( 1.6171E+00,-6.0209E+00),
     &  ( 1.7579E+00,-5.8338E+00),( 1.8666E+00,-5.6667E+00),
     &  ( 1.9796E+00,-5.4663E+00),( 2.0649E+00,-5.2917E+00),
     &  ( 2.1400E+00,-5.1161E+00),( 2.2055E+00,-4.9408E+00),
     &  ( 2.2701E+00,-4.7379E+00),( 2.3204E+00,-4.5667E+00),
     &  ( 2.3631E+00,-4.3710E+00),( 2.3943E+00,-4.1806E+00),
     &  ( 2.4197E+00,-3.9964E+00),( 2.4392E+00,-3.7939E+00),
     &  ( 2.4489E+00,-3.6242E+00),( 2.4526E+00,-3.4166E+00),
     &  ( 2.4478E+00,-3.2210E+00),( 2.4342E+00,-3.0176E+00),
     &  ( 2.4113E+00,-2.8102E+00),( 2.3441E+00,-2.6026E+00),
     &  ( 2.3021E+00,-2.4131E+00),( 2.2878E+00,-2.1996E+00),
     &  ( 2.2231E+00,-1.9859E+00),( 2.1272E+00,-1.7780E+00),
     &  ( 2.0557E+00,-1.5635E+00),( 1.8697E+00,-1.3474E+00),
     &  ( 1.8193E+00,-1.1316E+00),( 1.6635E+00,-9.1176E-01),
     &  ( 1.4827E+00,-6.9193E-01),( 1.5775E+00,-8.0567E-01),
     &  ( 1.3527E+00,-5.7104E-01),( 1.2145E+00,-4.5234E-01),
     &  ( 1.1310E+00,-3.8888E-01),( 9.5847E-01,-2.7543E-01),
     &  ( 8.9830E-01,-2.4111E-01),( 7.7365E-01,-1.7605E-01),
     &  ( 9.3867E-01,-1.1646E-02),( 3.6424E-01,-1.1638E-02)/
  
         DATA ((CGS  (I,J), I=1001,1100), J=1,1) /
     &  ( 2.8607E-01,-1.1631E-02),( 2.3732E-01,-1.1623E-02),
     &  ( 2.0366E-01,-1.1616E-02),( 1.7894E-01,-1.1608E-02),
     &  ( 1.5998E-01,-1.1601E-02),( 1.4496E-01,-1.1593E-02),
     &  ( 1.3277E-01,-1.1586E-02),( 1.2266E-01,-1.1578E-02),
     &  ( 1.1414E-01,-1.1573E-02),( 1.0683E-01,-1.1574E-02),
     &  ( 1.0053E-01,-1.1811E-02),( 9.5127E-02,-1.1815E-02),
     &  ( 9.0336E-02,-1.1820E-02),( 8.6077E-02,-1.1825E-02),
     &  ( 8.2273E-02,-1.1830E-02),( 7.8856E-02,-1.1835E-02),
     &  ( 7.3427E-02,-1.1844E-02),( 6.6651E-02,-1.1858E-02),
     &  ( 6.3018E-02,-1.1878E-02),( 5.7064E-02,-1.1940E-02),
     &  ( 5.2387E-02,-1.2004E-02),( 4.7764E-02,-1.2085E-02),
     &  ( 4.1166E-02,-1.2239E-02),( 3.3744E-02,-1.2515E-02),
     &  ( 2.9083E-02,-1.2926E-02),( 2.6914E-02,-1.3427E-02),
     &  ( 2.5786E-02,-1.3840E-02),( 2.4952E-02,-1.4202E-02),
     &  ( 2.4336E-02,-1.4529E-02),( 2.3836E-02,-1.4833E-02),
     &  ( 2.3467E-02,-1.5118E-02),( 2.3145E-02,-1.5349E-02),
     &  ( 2.2872E-02,-1.5557E-02),( 2.2639E-02,-1.5762E-02),
     &  ( 2.2438E-02,-1.5963E-02),( 2.2306E-02,-1.6163E-02),
     &  ( 2.2106E-02,-1.6360E-02),( 2.1970E-02,-1.6555E-02),
     &  ( 2.1850E-02,-1.6748E-02),( 2.1744E-02,-1.6940E-02),
     &  ( 2.1651E-02,-1.7132E-02),( 2.1570E-02,-1.7323E-02),
     &  ( 2.1499E-02,-1.7514E-02),( 2.1437E-02,-1.7706E-02),
     &  ( 2.1385E-02,-1.7898E-02),( 2.1342E-02,-1.8090E-02),
     &  ( 2.1251E-02,-1.8285E-02),( 2.1281E-02,-1.8482E-02),
     &  ( 2.1263E-02,-1.8682E-02),( 2.1255E-02,-1.8885E-02),
     &  ( 2.1255E-02,-1.9094E-02),( 2.1268E-02,-1.9309E-02),
     &  ( 2.1297E-02,-1.9532E-02),( 2.1339E-02,-1.9767E-02),
     &  ( 2.1401E-02,-2.0018E-02),( 2.1495E-02,-2.0296E-02),
     &  ( 2.1645E-02,-2.0625E-02),( 2.2128E-02,-2.1255E-02),
     &  ( 2.2765E-02,-2.1615E-02),( 2.3069E-02,-2.1664E-02),
     &  ( 2.3315E-02,-2.1654E-02),( 2.3531E-02,-2.1608E-02),
     &  ( 2.3726E-02,-2.1536E-02),( 2.3904E-02,-2.1443E-02),
     &  ( 2.4069E-02,-2.1331E-02),( 2.4223E-02,-2.1203E-02),
     &  ( 2.4366E-02,-2.1060E-02),( 2.4500E-02,-2.0902E-02),
     &  ( 2.4622E-02,-2.0731E-02),( 2.4738E-02,-2.0546E-02),
     &  ( 2.4778E-02,-2.0349E-02),( 2.4885E-02,-2.0140E-02),
     &  ( 2.4976E-02,-1.9917E-02),( 2.5071E-02,-1.9683E-02),
     &  ( 2.5138E-02,-1.9438E-02),( 2.5206E-02,-1.9181E-02),
     &  ( 2.5233E-02,-1.8912E-02),( 2.5246E-02,-1.8633E-02),
     &  ( 2.5241E-02,-1.8343E-02),( 2.5218E-02,-1.8043E-02),
     &  ( 2.5175E-02,-1.7733E-02),( 2.5109E-02,-1.7413E-02),
     &  ( 2.5006E-02,-1.7085E-02),( 2.4881E-02,-1.6748E-02),
     &  ( 2.4738E-02,-1.6404E-02),( 2.4553E-02,-1.6054E-02),
     &  ( 2.4322E-02,-1.5698E-02),( 2.4032E-02,-1.5337E-02),
     &  ( 2.3669E-02,-1.4975E-02),( 2.3205E-02,-1.4612E-02),
     &  ( 2.2581E-02,-1.4253E-02),( 2.1682E-02,-1.3993E-02),
     &  ( 2.1413E-02,-1.3949E-02),( 2.0701E-02,-1.3889E-02),
     &  ( 1.9631E-02,-1.3936E-02),( 1.9521E-02,-1.3960E-02),
     &  ( 1.8782E-02,-1.4143E-02),( 1.8481E-02,-1.4222E-02),
     &  ( 1.8242E-02,-1.4379E-02),( 1.8039E-02,-1.4570E-02)/
  
         DATA ((CGS  (I,J), I=1101,1200), J=1,1) /
     &  ( 1.7723E-02,-1.4525E-02),( 1.7387E-02,-1.4986E-02),
     &  ( 1.7314E-02,-1.5295E-02),( 1.7304E-02,-1.5382E-02),
     &  ( 1.7247E-02,-1.5645E-02),( 1.7144E-02,-1.5819E-02),
     &  ( 1.7087E-02,-1.6090E-02),( 1.7105E-02,-1.6361E-02),
     &  ( 1.7325E-02,-1.6450E-02),( 1.7301E-02,-1.6176E-02),
     &  ( 1.7060E-02,-1.6135E-02),( 1.6962E-02,-1.6211E-02),
     &  ( 1.6774E-02,-1.5968E-02),( 1.6613E-02,-1.6092E-02),
     &  ( 1.6451E-02,-1.6949E-02),( 1.6289E-02,-1.7101E-02),
     &  ( 1.6175E-02,-1.6899E-02),( 1.5892E-02,-1.6886E-02),
     &  ( 1.5467E-02,-1.6930E-02),( 1.4881E-02,-1.7088E-02),
     &  ( 1.4508E-02,-1.5482E-02),( 1.3936E-02,-1.6248E-02),
     &  ( 1.3562E-02,-1.7397E-02),( 1.3759E-02,-1.9109E-02),
     &  ( 1.4653E-02,-2.0249E-02),( 1.5265E-02,-2.0344E-02),
     &  ( 1.6644E-02,-2.0583E-02),( 1.7225E-02,-2.0588E-02),
     &  ( 1.7700E-02,-1.9844E-02),( 1.8230E-02,-1.9611E-02),
     &  ( 1.8642E-02,-1.8975E-02),( 1.8558E-02,-1.8551E-02),
     &  ( 1.8450E-02,-1.8600E-02),( 1.8663E-02,-1.8744E-02),
     &  ( 1.9282E-02,-1.8187E-02),( 1.8829E-02,-1.7279E-02),
     &  ( 1.8262E-02,-1.7695E-02),( 1.8363E-02,-1.8015E-02),
     &  ( 1.8555E-02,-1.8143E-02),( 1.8691E-02,-1.8185E-02),
     &  ( 1.8889E-02,-1.7988E-02),( 1.8915E-02,-1.7693E-02),
     &  ( 1.8780E-02,-1.7468E-02),( 1.8492E-02,-1.7288E-02),
     &  ( 1.8320E-02,-1.7243E-02),( 1.7991E-02,-1.7604E-02),
     &  ( 1.7951E-02,-1.8205E-02),( 1.8171E-02,-1.8494E-02),
     &  ( 1.8420E-02,-1.8687E-02),( 1.8731E-02,-1.8881E-02),
     &  ( 1.8868E-02,-1.8930E-02),( 1.9158E-02,-1.8771E-02),
     &  ( 1.9281E-02,-1.8613E-02),( 1.9114E-02,-1.8479E-02),
     &  ( 1.9275E-02,-1.8945E-02),( 1.9637E-02,-1.9178E-02),
     &  ( 2.0021E-02,-1.9025E-02),( 2.0410E-02,-1.8720E-02),
     &  ( 2.0642E-02,-1.8492E-02),( 2.0840E-02,-1.8293E-02),
     &  ( 2.1083E-02,-1.8161E-02),( 2.1269E-02,-1.8094E-02),
     &  ( 2.1402E-02,-1.7972E-02),( 2.1544E-02,-1.7787E-02),
     &  ( 2.1747E-02,-1.7480E-02),( 2.1922E-02,-1.7125E-02),
     &  ( 2.2074E-02,-1.6842E-02),( 2.2231E-02,-1.6608E-02),
     &  ( 2.1978E-02,-1.5466E-02),( 2.1186E-02,-1.5290E-02),
     &  ( 2.1012E-02,-1.5441E-02),( 2.1137E-02,-1.5892E-02),
     &  ( 2.1398E-02,-1.5346E-02),( 2.1093E-02,-1.4971E-02),
     &  ( 2.1090E-02,-1.4938E-02),( 2.1308E-02,-1.4927E-02),
     &  ( 2.1447E-02,-1.4048E-02),( 2.0253E-02,-1.2701E-02),
     &  ( 1.8983E-02,-1.3497E-02),( 1.8559E-02,-1.4040E-02),
     &  ( 1.8256E-02,-1.4743E-02),( 1.8738E-02,-1.4990E-02),
     &  ( 1.8749E-02,-1.4884E-02),( 1.8549E-02,-1.4900E-02),
     &  ( 1.8373E-02,-1.4911E-02),( 1.8270E-02,-1.4941E-02),
     &  ( 1.8124E-02,-1.4986E-02),( 1.7929E-02,-1.4991E-02),
     &  ( 1.7385E-02,-1.5558E-02),( 1.7422E-02,-1.5699E-02),
     &  ( 1.7470E-02,-1.5932E-02),( 1.7373E-02,-1.6152E-02),
     &  ( 1.7337E-02,-1.6233E-02),( 1.7318E-02,-1.6704E-02),
     &  ( 1.7403E-02,-1.7153E-02),( 1.7446E-02,-1.7303E-02),
     &  ( 1.7469E-02,-1.7381E-02),( 1.7532E-02,-1.7615E-02),
     &  ( 1.7511E-02,-1.7693E-02),( 1.7579E-02,-1.8082E-02)/
  
         DATA ((CGS  (I,J), I=1201,1300), J=1,1) /
     &  ( 1.8194E-02,-1.8666E-02),( 1.8851E-02,-1.8363E-02),
     &  ( 1.9036E-02,-1.8161E-02),( 1.9091E-02,-1.8077E-02),
     &  ( 1.9125E-02,-1.7824E-02),( 1.8916E-02,-1.8025E-02),
     &  ( 1.9350E-02,-1.8453E-02),( 1.9886E-02,-1.8172E-02),
     &  ( 2.0091E-02,-1.7984E-02),( 2.0177E-02,-1.7869E-02),
     &  ( 2.0325E-02,-1.7524E-02),( 2.0347E-02,-1.7409E-02),
     &  ( 2.0203E-02,-1.6842E-02),( 1.9947E-02,-1.6787E-02),
     &  ( 1.9861E-02,-1.6755E-02),( 2.0043E-02,-1.6767E-02),
     &  ( 2.0044E-02,-1.6657E-02),( 1.9526E-02,-1.6420E-02),
     &  ( 1.9553E-02,-1.6731E-02),( 1.9827E-02,-1.6763E-02),
     &  ( 1.9775E-02,-1.6093E-02),( 1.9497E-02,-1.6132E-02),
     &  ( 1.9364E-02,-1.6633E-02),( 1.9418E-02,-1.6790E-02),
     &  ( 1.9597E-02,-1.6779E-02),( 1.9609E-02,-1.6771E-02),
     &  ( 2.0009E-02,-1.7216E-02),( 2.0218E-02,-1.6727E-02),
     &  ( 2.0635E-02,-1.7531E-02),( 2.1077E-02,-1.6991E-02),
     &  ( 2.1143E-02,-1.6692E-02),( 2.1201E-02,-1.7287E-02),
     &  ( 2.1221E-02,-1.7278E-02),( 2.1359E-02,-1.7261E-02),
     &  ( 2.1611E-02,-1.7229E-02),( 2.1727E-02,-1.7214E-02),
     &  ( 2.1839E-02,-1.7199E-02),( 2.2053E-02,-1.7172E-02),
     &  ( 2.2255E-02,-1.7146E-02),( 2.2353E-02,-1.7134E-02),
     &  ( 2.2448E-02,-1.7123E-02),( 2.2542E-02,-1.7112E-02),
     &  ( 2.2634E-02,-1.7101E-02),( 2.2724E-02,-1.7091E-02),
     &  ( 2.2813E-02,-1.7081E-02),( 2.2900E-02,-1.7071E-02),
     &  ( 2.2985E-02,-1.7062E-02),( 2.3069E-02,-1.7053E-02),
     &  ( 2.3152E-02,-1.7044E-02),( 2.3234E-02,-1.7036E-02),
     &  ( 2.3314E-02,-1.7028E-02),( 2.3393E-02,-1.7020E-02),
     &  ( 2.3470E-02,-1.7012E-02),( 2.3547E-02,-1.7005E-02),
     &  ( 2.3622E-02,-1.6997E-02),( 2.3696E-02,-1.6990E-02),
     &  ( 2.3769E-02,-1.6983E-02),( 2.3840E-02,-1.6977E-02),
     &  ( 2.3911E-02,-1.6970E-02),( 2.3980E-02,-1.6964E-02),
     &  ( 2.4049E-02,-1.6958E-02),( 2.4116E-02,-1.6952E-02),
     &  ( 2.4182E-02,-1.6946E-02),( 2.4247E-02,-1.6941E-02),
     &  ( 2.4311E-02,-1.6935E-02),( 2.4374E-02,-1.6930E-02),
     &  ( 2.4435E-02,-1.6925E-02),( 2.4496E-02,-1.6919E-02),
     &  ( 2.4555E-02,-1.6914E-02),( 2.4614E-02,-1.6910E-02),
     &  ( 2.4671E-02,-1.6905E-02),( 2.4727E-02,-1.6900E-02),
     &  ( 2.4781E-02,-1.6896E-02),( 2.4824E-02,-1.6892E-02),
     &  ( 2.4887E-02,-1.6887E-02),( 2.4988E-02,-1.6879E-02),
     &  ( 2.5084E-02,-1.6871E-02),( 2.5173E-02,-1.6863E-02),
     &  ( 2.5257E-02,-1.6855E-02),( 2.5334E-02,-1.6848E-02),
     &  ( 2.5404E-02,-1.6842E-02),( 2.5465E-02,-1.6835E-02),
     &  ( 2.5516E-02,-1.6829E-02),( 2.5556E-02,-1.6823E-02),
     &  ( 2.5582E-02,-1.6817E-02),( 2.5591E-02,-1.6811E-02),
     &  ( 2.5577E-02,-1.6806E-02),( 2.5533E-02,-1.6800E-02),
     &  ( 2.5444E-02,-1.6795E-02),( 2.5432E-02,-1.6795E-02),
     &  ( 2.5285E-02,-1.6790E-02),( 2.5003E-02,-1.6785E-02),
     &  ( 2.4464E-02,-1.6781E-02),( 2.3557E-02,-1.6777E-02),
     &  ( 2.3180E-02,-1.6776E-02),( 2.1598E-02,-1.6774E-02),
     &  ( 1.8571E-02,-1.6772E-02),( 1.7136E-02,-1.6772E-02),
     &  ( 1.5083E-02,-1.6771E-02),( 1.3691E-02,-1.6771E-02)/
  
         DATA ((CGS  (I,J), I=1301,1400), J=1,1) /
     &  ( 1.1927E-02,-1.6771E-02),( 1.0140E-02,-1.6771E-02),
     &  ( 7.8763E-03,-1.6771E-02),( 6.5045E-03,-1.6770E-02),
     &  ( 4.9254E-03,-1.6770E-02),( 3.0898E-03,-1.6770E-02),
     &  ( 9.3152E-04,-1.6770E-02),(-1.6396E-03,-1.6770E-02),
     &  (-4.7503E-03,-1.6770E-02),(-6.5624E-03,-1.6770E-02),
     &  (-8.5844E-03,-1.6770E-02),(-1.0854E-02,-1.6770E-02),
     &  (-1.3418E-02,-1.6770E-02),(-1.6337E-02,-1.6770E-02),
     &  (-1.9688E-02,-1.6770E-02),(-2.3572E-02,-1.6770E-02),
     &  (-2.8125E-02,-1.6770E-02),(-3.3540E-02,-1.6770E-02),
     &  (-3.5818E-02,-1.6770E-02),(-3.7258E-02,-1.6770E-02),
     &  (-3.8775E-02,-1.6770E-02),(-4.0419E-02,-1.6770E-02),
     &  (-4.1989E-02,-1.6888E-02),(-4.3619E-02,-1.6894E-02),
     &  (-3.9289E-02,-1.6900E-02),(-4.7191E-02,-1.6906E-02),
     &  (-4.9122E-02,-1.6912E-02),(-5.1154E-02,-1.6919E-02),
     &  (-5.3294E-02,-1.6927E-02),(-5.5551E-02,-1.6935E-02),
     &  (-5.7933E-02,-1.6944E-02),(-6.0451E-02,-1.6954E-02),
     &  (-6.3114E-02,-1.6964E-02),(-6.5938E-02,-1.6976E-02),
     &  (-6.8934E-02,-1.6988E-02),(-7.2121E-02,-1.7002E-02),
     &  (-7.5515E-02,-1.7017E-02),(-7.9137E-02,-1.7033E-02),
     &  (-8.3011E-02,-1.7051E-02),(-8.7163E-02,-1.7071E-02),
     &  (-9.1624E-02,-1.7094E-02),(-9.6428E-02,-1.7118E-02),
     &  (-1.0162E-01,-1.7146E-02),(-1.0724E-01,-1.7177E-02),
     &  (-1.1334E-01,-1.7212E-02),(-1.2000E-01,-1.7252E-02),
     &  (-1.2729E-01,-1.7298E-02),(-1.3529E-01,-1.7350E-02),
     &  (-1.4413E-01,-1.7411E-02),(-1.5393E-01,-1.7482E-02),
     &  (-1.6487E-01,-1.7564E-02),(-1.7714E-01,-1.7663E-02),
     &  (-1.9100E-01,-1.7780E-02),(-2.0679E-01,-1.7923E-02),
     &  (-2.2492E-01,-1.8098E-02),(-2.4595E-01,-1.8315E-02),
     &  (-2.7063E-01,-1.8592E-02),(-2.9999E-01,-1.8949E-02),
     &  (-3.3549E-01,-1.9422E-02),(-3.7926E-01,-2.0069E-02),
     &  (-4.3454E-01,-2.0984E-02),( 1.3658E-02,-2.2340E-02),
     &  (-6.0394E-01,-2.4473E-02),(-7.4324E-01,-2.8113E-02),
     &  (-9.5838E-01,-3.5106E-02),(-1.3337E+00,-5.1298E-02),
     &  (-2.1487E+00,-1.0429E-01),(-2.6683E+00,-1.6660E-02),
     &  (-5.1520E+00,-1.6660E-02),(-7.1999E+00,-1.6660E-02),
     &  (-8.6861E+00,-1.6660E-02),(-9.8321E+00,-1.6660E-02),
     &  ( 1.7079E-02,-1.6660E-02),(-1.1600E+01,-1.6660E-02),
     &  (-1.2367E+01,-1.6660E-02),(-1.2901E+01,-1.6660E-02),
     &  (-1.3442E+01,-1.6660E-02),(-1.3976E+01,-1.6660E-02),
     &  (-1.4233E+01,-1.6660E-02),(-1.4594E+01,-1.6660E-02),
     &  (-1.4812E+01,-1.6660E-02),(-1.5083E+01,-1.6660E-02),
     &  (-1.5148E+01,-1.6660E-02),(-1.5268E+01,-1.6660E-02),
     &  (-1.5295E+01,-1.6660E-02),(-1.5262E+01,-1.6660E-02),
     &  (-1.5213E+01,-1.6660E-02),(-1.5138E+01,-1.6660E-02),
     &  (-1.4339E-01,-1.6660E-02),(-1.3932E-01,-1.6660E-02),
     &  (-1.4533E+01,-1.6660E-02),(-1.4009E+01,-1.6660E-02),
     &  (-1.3683E+01,-1.6660E-02),(-1.3316E+01,-1.6660E-02),
     &  (-1.2893E+01,-1.6660E-02),(-1.1887E+01,-1.6660E-02),
     &  (-1.1301E+01,-1.6660E-02),(-1.0665E+01,-1.6660E-02),
     &  (-9.2203E+00,-1.6660E-02),(-8.4206E+00,-1.6660E-02)/
  
         DATA ((CGS  (I,J), I=1401,1500), J=1,1) /
     &  (-2.5406E+00,-1.6660E-02),(-4.7273E+00,-1.6660E-02),
     &  ( 5.8131E-01,-1.6660E-02),( 4.7986E+00,-1.6660E-02),
     &  ( 6.7412E+00,-1.6660E-02),( 8.4986E+00,-1.6660E-02),
     &  ( 1.0060E+01,-1.6660E-02),( 1.0762E+01,-1.6660E-02),
     &  ( 1.1401E+01,-1.6660E-02),( 1.1985E+01,-1.6660E-02),
     &  ( 1.2996E+01,-1.6660E-02),( 1.3421E+01,-1.6660E-02),
     &  ( 1.3800E+01,-1.6660E-02),( 1.4150E+01,-1.6660E-02),
     &  ( 1.4662E+01,-1.6660E-02),( 1.4862E+01,-1.6660E-02),
     &  ( 1.5032E+01,-1.6660E-02),( 1.5271E+01,-1.6660E-02),
     &  ( 1.5348E+01,-1.6660E-02),( 1.5427E+01,-1.6660E-02),
     &  ( 1.5434E+01,-1.6660E-02),( 1.5393E+01,-1.6660E-02),
     &  ( 1.5292E+01,-1.6660E-02),( 1.5358E+01,-1.6660E-02),
     &  ( 1.5223E+01,-1.6660E-02),( 1.4744E+01,-1.6660E-02),
     &  ( 1.4392E+01,-1.6660E-02),( 1.4134E+01,-1.6660E-02),
     &  ( 1.3590E+01,-1.6660E-02),( 1.3049E+01,-1.6660E-02),
     &  ( 1.2515E+01,-1.6660E-02),( 1.1748E+01,-1.6660E-02),
     &  ( 1.0923E+01,-1.6660E-02),( 9.9783E+00,-1.6660E-02),
     &  ( 8.8293E+00,-1.6660E-02),( 7.3442E+00,-1.6660E-02),
     &  ( 5.2653E+00,-1.6660E-02),( 2.9012E+00,-1.6661E-02),
     &  ( 1.6838E+00,-1.6661E-02),( 1.1941E+00,-1.6661E-02),
     &  ( 9.2989E-01,-1.6662E-02),( 7.6443E-01,-1.6662E-02),
     &  ( 6.5101E-01,-1.6662E-02),( 5.6850E-01,-1.6663E-02),
     &  ( 5.0540E-01,-1.6663E-02),( 4.5582E-01,-1.6663E-02),
     &  ( 4.1575E-01,-1.6664E-02),( 3.8268E-01,-1.6664E-02),
     &  ( 3.5490E-01,-1.6665E-02),( 3.3122E-01,-1.6665E-02),
     &  ( 3.1080E-01,-1.6665E-02),( 2.9300E-01,-1.6666E-02),
     &  ( 1.2541E-01,-1.6666E-02),( 2.6346E-01,-1.6666E-02),
     &  ( 2.5104E-01,-1.6667E-02),( 2.3989E-01,-1.6667E-02),
     &  ( 2.2980E-01,-1.6668E-02),( 2.2064E-01,-1.6668E-02),
     &  ( 2.1227E-01,-1.6668E-02),( 2.0460E-01,-1.6669E-02),
     &  ( 1.9753E-01,-1.6669E-02),( 1.9101E-01,-1.6669E-02),
     &  ( 1.8497E-01,-1.6670E-02),( 5.3527E-02,-1.6670E-02),
     &  ( 1.7411E-01,-1.6670E-02),( 1.6921E-01,-1.6671E-02),
     &  ( 1.6463E-01,-1.6671E-02),( 1.6032E-01,-1.6672E-02),
     &  ( 1.5627E-01,-1.6672E-02),( 1.5245E-01,-1.6672E-02),
     &  ( 1.4884E-01,-1.6673E-02),( 1.4543E-01,-1.6673E-02),
     &  ( 1.4219E-01,-1.6673E-02),( 1.3912E-01,-1.6674E-02),
     &  ( 1.3620E-01,-1.6674E-02),( 1.3342E-01,-1.6675E-02),
     &  ( 1.3077E-01,-1.6675E-02),( 1.2825E-01,-1.6675E-02),
     &  ( 1.2585E-01,-1.6676E-02),( 1.2358E-01,-1.6676E-02),
     &  ( 1.2143E-01,-1.6676E-02),( 1.1916E-01,-1.6677E-02),
     &  ( 1.1706E-01,-1.6677E-02),( 1.1505E-01,-1.6677E-02),
     &  ( 1.1313E-01,-1.6678E-02),( 1.1129E-01,-1.6678E-02),
     &  ( 1.0951E-01,-1.6679E-02),( 9.5888E-02,-1.6682E-02),
     &  ( 8.7242E-02,-1.6685E-02),( 7.8613E-02,-1.6688E-02),
     &  ( 6.8346E-02,-1.6693E-02),( 5.7616E-02,-1.6700E-02),
     &  ( 4.4480E-02,-1.6710E-02),( 3.9078E-02,-1.6718E-02),
     &  ( 3.1480E-02,-1.6724E-02),( 2.8669E-02,-1.6722E-02),
     &  ( 2.9990E-02,-1.6719E-02),( 3.0472E-02,-1.6715E-02),
     &  ( 3.0649E-02,-1.6711E-02),( 3.0674E-02,-1.6707E-02)/
  
         DATA ((CGS  (I,J), I=1501,1600), J=1,1) /
     &  ( 3.0522E-02,-1.6700E-02),( 3.0273E-02,-1.6692E-02),
     &  ( 2.9049E-02,-1.6655E-02),( 2.7541E-02,-1.6619E-02),
     &  ( 2.6408E-02,-1.6646E-02),( 2.4562E-02,-1.6575E-02),
     &  ( 2.2211E-02,-1.6620E-02),( 1.9454E-02,-1.6643E-02),
     &  ( 1.5892E-02,-1.6656E-02),( 1.1002E-02,-1.6665E-02),
     &  (-1.2293E-03,-1.6658E-02),(-3.5479E-03,-1.6658E-02),
     &  (-6.2781E-03,-1.6657E-02),(-7.0692E-03,-1.6657E-02),
     &  (-8.8724E-03,-1.6656E-02),(-1.0876E-02,-1.6656E-02),
     &  (-1.3115E-02,-1.6656E-02),(-1.5634E-02,-1.6655E-02),
     &  (-1.8489E-02,-1.6655E-02),(-2.1752E-02,-1.6655E-02),
     &  (-2.5518E-02,-1.6654E-02),(-2.9911E-02,-1.6654E-02),
     &  (-3.5105E-02,-1.6653E-02),(-4.1339E-02,-1.6653E-02),
     &  (-4.8961E-02,-1.6653E-02),(-5.8496E-02,-1.6652E-02),
     &  (-7.0767E-02,-1.6652E-02),(-8.7159E-02,-1.6651E-02),
     &  (-1.1020E-01,-1.6651E-02),(-1.4526E-01,-1.6651E-02),
     &  (-2.0244E-01,-1.7844E-02),(-3.1672E-01,-1.9336E-02),
     &  (-4.7024E-01,-2.2276E-02),(-4.9601E-01,-2.2875E-02),
     &  (-5.2460E-01,-2.3574E-02),(-5.5650E-01,-2.4399E-02),
     &  (-5.9231E-01,-2.5381E-02),(-6.3281E-01,-2.6561E-02),
     &  (-6.7897E-01,-2.7998E-02),(-7.3206E-01,-2.9772E-02),
     &  (-7.9379E-01,-3.1996E-02),(-8.6643E-01,-3.4837E-02),
     &  (-9.5316E-01,-3.8547E-02),(-1.0585E+00,-4.3518E-02),
     &  (-1.1891E+00,-5.0393E-02),(-1.3554E+00,-6.0286E-02),
     &  (-1.5741E+00,-7.5255E-02),(-1.8745E+00,-9.9465E-02),
     &  (-2.3121E+00,-1.4241E-01),(-3.0070E+00,-2.2970E-01),
     &  (-4.2680E+00,-4.5132E-01),(-7.1209E+00,-1.3111E+00),
     &  (-8.1206E+00,-1.7689E+00),(-8.5556E+00,-2.2127E+00),
     &  (-9.7799E+00,-2.8303E+00),(-1.0525E+01,-3.5068E+00),
     &  (-1.1065E+01,-4.1606E+00),(-9.6026E+00,-4.9759E+00),
     &  (-8.4289E+00,-5.6261E+00),(-1.2696E+01,-6.3716E+00),
     &  (-1.2270E+01,-7.2157E+00),(-8.4649E-01,-8.1524E+00),
     &  (-1.0015E+01,-8.8009E+00),(-1.0015E+01,-8.9027E+00),
     &  (-1.0015E+01,-8.9538E+00),(-1.0015E+01,-9.0561E+00),
     &  (-1.0015E+01,-9.0972E+00),(-1.0015E+01,-9.1280E+00),
     &  (-1.0015E+01,-9.1588E+00),(-9.5351E+00,-9.4681E+00),
     &  (-8.7609E+00,-9.9324E+00),(-7.8343E+00,-1.0441E+01),
     &  (-6.9514E+00,-1.0883E+01),(-7.3254E+00,-1.1345E+01),
     &  (-6.2144E+00,-1.1762E+01),(-5.1166E+00,-1.2088E+01),
     &  (-3.8540E+00,-1.2245E+01),(-3.8540E+00,-1.2382E+01),
     &  (-2.1713E+00,-1.2498E+01),(-2.1713E+00,-1.2624E+01),
     &  ( 1.1279E-01,-1.2685E+01),( 1.1279E-01,-1.2722E+01),
     &  ( 1.1390E-01,-1.2732E+01),( 1.1390E-01,-1.2734E+01),
     &  ( 1.1390E-01,-1.2734E+01),( 1.1390E-01,-1.2734E+01),
     &  ( 1.1390E-01,-1.2734E+01),( 1.1390E-01,-1.2734E+01),
     &  ( 1.1390E-01,-1.2722E+01),( 1.1501E-01,-1.2685E+01),
     &  ( 1.1501E-01,-1.2624E+01),( 5.4689E+00,-1.2020E+01),
     &  ( 6.6078E+00,-1.1643E+01),( 8.5396E+00,-1.0787E+01),
     &  ( 9.2871E+00,-1.0341E+01),( 9.9879E+00,-9.8296E+00),
     &  ( 1.0510E+01,-9.3134E+00),( 1.0233E+01,-8.8519E+00),
     &  ( 1.0889E+01,-8.3492E+00),( 1.1497E+01,-7.9105E+00)/
  
         DATA ((CGS  (I,J), I=1601,1700), J=1,1) /
     &  ( 1.1679E+01,-7.4418E+00),( 1.1782E+01,-7.0392E+00),
     &  ( 1.1815E+01,-6.6146E+00),( 1.1812E+01,-6.2535E+00),
     &  ( 1.1775E+01,-5.8759E+00),( 1.1716E+01,-5.5570E+00),
     &  ( 8.5152E+00,-4.9458E+00),( 1.1406E+01,-4.6561E+00),
     &  ( 1.1265E+01,-4.3867E+00),( 1.1125E+01,-4.1607E+00),
     &  ( 1.0775E+01,-3.7300E+00),( 1.0594E+01,-3.5264E+00),
     &  ( 1.0299E+01,-3.2300E+00),( 9.8284E+00,-2.8303E+00),
     &  ( 8.1748E+00,-1.7690E+00),( 6.8863E+00,-1.1967E+00),
     &  ( 5.9090E+00,-8.6002E-01),( 5.1591E+00,-6.4736E-01),
     &  ( 4.5704E+00,-5.0522E-01),( 4.0129E+00,-4.0582E-01),
     &  ( 3.4819E+00,-3.1881E-01),( 2.8913E+00,-2.0620E-01),
     &  ( 2.6922E+00,-1.8042E-01),( 2.5185E+00,-1.5955E-01),
     &  ( 2.3656E+00,-1.4242E-01),( 2.1394E+00,-1.1903E-01),
     &  ( 1.7754E+00,-8.6612E-02),( 1.5180E+00,-6.7451E-02),
     &  ( 1.3265E+00,-5.5200E-02),( 1.1785E+00,-4.6897E-02),
     &  ( 1.0606E+00,-4.1012E-02),( 9.6466E-01,-3.6691E-02),
     &  ( 8.8497E-01,-3.3425E-02),( 8.1775E-01,-3.0896E-02),
     &  ( 7.6029E-01,-2.8899E-02),( 7.1061E-01,-2.7294E-02),
     &  ( 6.6723E-01,-2.5985E-02),( 6.2903E-01,-2.4903E-02),
     &  ( 5.9513E-01,-2.3999E-02),( 5.6483E-01,-2.3236E-02),
     &  ( 5.3761E-01,-2.2585E-02),( 3.7063E-01,-1.9336E-02),
     &  ( 2.5618E-01,-1.7843E-02),( 1.9898E-01,-1.7320E-02),
     &  ( 1.4187E-01,-1.6647E-02),( 1.1286E-01,-1.6646E-02),
     &  ( 9.5644E-02,-1.6645E-02),( 8.4190E-02,-1.6645E-02),
     &  ( 7.6017E-02,-1.6644E-02),( 6.9890E-02,-1.6643E-02),
     &  ( 6.5125E-02,-1.6642E-02),( 6.1313E-02,-1.6642E-02),
     &  ( 5.9151E-02,-1.6641E-02),( 5.6627E-02,-1.6640E-02),
     &  ( 5.4471E-02,-1.6640E-02),( 5.2606E-02,-1.6639E-02),
     &  ( 5.0978E-02,-1.6638E-02),( 4.9544E-02,-1.6638E-02),
     &  ( 4.4347E-02,-1.6634E-02),( 4.1085E-02,-1.6631E-02),
     &  ( 3.8842E-02,-1.6628E-02),( 3.7201E-02,-1.6624E-02),
     &  ( 3.5943E-02,-1.6621E-02),( 3.4933E-02,-1.6618E-02),
     &  ( 3.4129E-02,-1.6614E-02),( 3.3460E-02,-1.6611E-02),
     &  ( 2.7826E-02,-1.6562E-02),( 2.6281E-02,-1.6572E-02),
     &  ( 2.5890E-02,-1.6574E-02),( 2.5437E-02,-1.6576E-02),
     &  ( 2.4896E-02,-1.6578E-02),( 2.4222E-02,-1.6580E-02),
     &  ( 2.3815E-02,-1.6581E-02),( 2.3346E-02,-1.6581E-02),
     &  ( 2.2136E-02,-1.6601E-02),( 2.0310E-02,-1.6620E-02),
     &  ( 1.7128E-02,-1.6639E-02),( 9.8939E-03,-1.6659E-02),
     &  ( 2.9843E-03,-1.6667E-02),( 1.2012E-03,-1.6668E-02),
     &  (-8.5539E-04,-1.6669E-02),(-3.2539E-03,-1.6671E-02),
     &  (-6.0876E-03,-1.6672E-02),(-9.4875E-03,-1.6674E-02),
     &  (-1.3643E-02,-1.6675E-02),(-1.8837E-02,-1.6677E-02),
     &  (-2.5518E-02,-1.6678E-02),(-3.4434E-02,-1.6679E-02),
     &  (-4.6950E-02,-1.6681E-02),(-6.5803E-02,-1.6856E-02),
     &  (-9.6830E-02,-1.6993E-02),(-1.0224E-01,-1.7021E-02),
     &  (-1.0814E-01,-1.7052E-02),(-1.1461E-01,-1.7088E-02),
     &  (-1.2172E-01,-1.7130E-02),(-1.2961E-01,-1.7178E-02),
     &  (-1.3831E-01,-1.7235E-02),(-1.4808E-01,-1.7302E-02),
     &  (-1.5906E-01,-1.7381E-02),(-1.7151E-01,-1.7477E-02)/
  
         DATA ((CGS  (I,J), I=1701,1800), J=1,1) /
     &  (-1.8574E-01,-1.7595E-02),(-2.0215E-01,-1.7740E-02),
     &  (-2.2130E-01,-1.7924E-02),(-2.4394E-01,-1.8159E-02),
     &  (-2.7109E-01,-1.8469E-02),(-3.0428E-01,-1.8887E-02),
     &  (-3.1464E-01,-1.9027E-02),(-3.4577E-01,-1.9472E-02),
     &  (-3.9910E-01,-2.0324E-02),(-4.7019E-01,-2.1638E-02),
     &  (-5.6968E-01,-2.3815E-02),(-7.1883E-01,-2.7823E-02),
     &  (-9.6708E-01,-3.6472E-02),(-1.4620E+00,-6.1130E-02),
     &  (-2.9247E+00,-1.9286E-01),(-3.4823E+00,-2.6699E-01),
     &  (-4.9231E+00,-5.2378E-01),(-5.6298E+00,-7.8760E-01),
     &  (-6.9217E+00,-1.0552E+00),(-7.7082E+00,-1.3310E+00),
     &  (-8.4093E+00,-1.6134E+00),(-9.0447E+00,-1.9016E+00),
     &  (-9.5912E+00,-2.1918E+00),(-1.0362E+01,-2.4934E+00),
     &  (-1.0592E+01,-2.8129E+00),( 8.5685E-02,-3.1410E+00),
     &  (-1.1484E+01,-3.4655E+00),(-1.1855E+01,-3.8040E+00),
     &  (-1.2171E+01,-4.1509E+00),(-1.2432E+01,-4.4993E+00),
     &  (-8.6286E+00,-4.8861E+00),(-1.2869E+01,-5.2654E+00),
     &  (-1.3029E+01,-5.6272E+00),(-1.3304E+01,-6.0190E+00),
     &  (-1.3304E+01,-6.4424E+00),(-1.3403E+01,-6.8990E+00),
     &  (-1.3424E+01,-7.3175E+00),(-1.3424E+01,-7.7612E+00),
     &  (-1.2495E+01,-8.2299E+00),(-1.2495E+01,-8.7224E+00),
     &  (-1.1785E+01,-9.2366E+00),(-1.2396E+01,-9.6796E+00),
     &  (-1.2396E+01,-1.0225E+01),(-1.1851E+01,-1.0779E+01),
     &  (-1.0208E+01,-1.1335E+01),(-1.0208E+01,-1.1974E+01),
     &  (-9.0617E+00,-1.2584E+01),(-7.5454E+00,-1.3222E+01),
     &  (-5.7781E+00,-1.3825E+01),( 2.7631E-02,-1.4520E+01),
     &  ( 2.7631E-02,-1.4532E+01),( 2.6552E+00,-1.4393E+01),
     &  ( 5.8337E+00,-1.3825E+01),( 9.1415E+00,-1.3222E+01),
     &  ( 9.1415E+00,-1.2584E+01),( 1.0299E+01,-1.1974E+01),
     &  ( 9.6481E+00,-1.1335E+01),( 9.6481E+00,-1.0779E+01),
     &  ( 1.0567E+01,-1.0225E+01),( 1.2123E+01,-9.6796E+00),
     &  ( 1.2123E+01,-9.2367E+00),( 1.2877E+01,-8.7224E+00),
     &  ( 5.1268E+00,-8.2299E+00),( 5.1268E+00,-7.7613E+00),
     &  ( 6.0549E+00,-7.3175E+00),( 6.0549E+00,-6.8990E+00),
     &  ( 9.4910E-01,-6.4424E+00),( 7.2396E+00,-6.0190E+00),
     &  ( 8.5429E+00,-5.6273E+00),( 8.5429E+00,-5.2654E+00),
     &  ( 9.3398E+00,-4.8861E+00),( 1.0275E+01,-4.4993E+00),
     &  ( 1.1240E+01,-4.1509E+00),( 1.2324E+01,-3.8040E+00),
     &  ( 1.1676E+01,-3.4655E+00),( 1.0794E+01,-3.1410E+00),
     &  ( 9.9047E+00,-2.8129E+00),( 9.1137E+00,-2.4934E+00),
     &  ( 8.5211E+00,-2.1919E+00),( 3.3254E+00,-1.9017E+00),
     &  ( 8.4915E+00,-1.6134E+00),( 7.7512E+00,-1.3310E+00),
     &  ( 6.9822E+00,-1.0552E+00),( 6.0725E+00,-7.8762E-01),
     &  ( 4.9785E+00,-5.2380E-01),( 3.5378E+00,-2.6700E-01),
     &  ( 3.0332E+00,-1.9935E-01),( 2.9386E+00,-1.8789E-01),
     &  ( 1.9709E+00,-1.7421E-01),( 2.4970E+00,-1.3948E-01),
     &  ( 2.2049E+00,-1.1196E-01),( 1.5173E+00,-6.1131E-02),
     &  ( 1.0225E+00,-3.6476E-02),( 7.7426E-01,-2.7826E-02),
     &  ( 6.2512E-01,-2.3819E-02),( 5.2563E-01,-2.1641E-02),
     &  ( 4.5454E-01,-2.0328E-02),( 4.0121E-01,-1.9476E-02),
     &  ( 3.5973E-01,-1.8891E-02),( 3.2653E-01,-1.8473E-02)/
  
         DATA ((CGS  (I,J), I=1801,1900), J=1,1) /
     &  ( 2.9938E-01,-1.8164E-02),( 2.7674E-01,-1.7929E-02),
     &  ( 2.5759E-01,-1.7746E-02),( 2.4117E-01,-1.7600E-02),
     &  ( 2.2695E-01,-1.7483E-02),( 2.1450E-01,-1.7388E-02),
     &  ( 1.5224E-01,-1.7002E-02),( 1.2112E-01,-1.6868E-02),
     &  ( 1.0245E-01,-1.6806E-02),( 9.0018E-02,-1.6774E-02),
     &  ( 8.1101E-02,-1.6698E-02),( 7.4379E-02,-1.6699E-02),
     &  ( 6.9171E-02,-1.6701E-02),( 6.1604E-02,-1.6703E-02),
     &  ( 5.6367E-02,-1.6706E-02),( 5.4309E-02,-1.6708E-02),
     &  ( 5.2525E-02,-1.6709E-02),( 4.6104E-02,-1.6716E-02),
     &  ( 4.1394E-02,-1.6726E-02),( 3.8567E-02,-1.6736E-02),
     &  ( 3.6675E-02,-1.6745E-02),( 3.5316E-02,-1.6755E-02),
     &  ( 3.4288E-02,-1.6765E-02),( 3.3478E-02,-1.6774E-02),
     &  ( 3.2819E-02,-1.6775E-02),( 3.2266E-02,-1.6775E-02),
     &  ( 3.1345E-02,-1.6800E-02),( 3.1400E-02,-1.6801E-02),
     &  ( 3.1055E-02,-1.6802E-02),( 3.0741E-02,-1.6804E-02),
     &  ( 3.0455E-02,-1.6805E-02),( 3.0190E-02,-1.6806E-02),
     &  ( 2.9941E-02,-1.6807E-02),( 2.9705E-02,-1.6809E-02),
     &  ( 2.9476E-02,-1.6810E-02),( 2.9249E-02,-1.6811E-02),
     &  ( 2.9017E-02,-1.6813E-02),( 2.8759E-02,-1.6814E-02),
     &  ( 2.8585E-02,-1.6908E-02),( 2.5334E-02,-1.7736E-02),
     &  ( 2.4567E-02,-1.8387E-02),( 2.3603E-02,-1.9037E-02),
     &  ( 2.2837E-02,-1.9688E-02),( 2.2205E-02,-2.0338E-02),
     &  ( 2.2133E-02,-2.0988E-02),( 2.1255E-02,-2.1640E-02),
     &  ( 2.0845E-02,-2.2291E-02),( 2.0524E-02,-2.2939E-02),
     &  ( 2.0254E-02,-2.3586E-02),( 2.0031E-02,-2.4236E-02),
     &  ( 1.9948E-02,-2.4881E-02),( 1.9715E-02,-2.5521E-02),
     &  ( 1.9618E-02,-2.6158E-02),( 1.9559E-02,-2.6799E-02),
     &  ( 1.9537E-02,-2.7435E-02),( 1.9551E-02,-2.8058E-02),
     &  ( 1.9600E-02,-2.8681E-02),( 1.9685E-02,-2.9310E-02),
     &  ( 1.9782E-02,-2.9927E-02),( 1.9956E-02,-3.0527E-02),
     &  ( 2.0149E-02,-3.1143E-02),( 2.0372E-02,-3.1731E-02),
     &  ( 2.0640E-02,-3.2326E-02),( 2.0947E-02,-3.2910E-02),
     &  ( 2.1302E-02,-3.3492E-02),( 2.1707E-02,-3.4066E-02),
     &  ( 2.2163E-02,-3.4625E-02),( 2.2671E-02,-3.5164E-02),
     &  ( 2.3272E-02,-3.5708E-02),( 2.3959E-02,-3.6230E-02),
     &  ( 2.4752E-02,-3.6723E-02),( 2.5741E-02,-3.7198E-02),
     &  ( 2.7048E-02,-3.7622E-02),( 3.0242E-02,-3.7808E-02),
     &  ( 3.3261E-02,-3.6883E-02),( 3.4400E-02,-3.6199E-02),
     &  ( 3.5226E-02,-3.5550E-02),( 3.5865E-02,-3.4937E-02),
     &  ( 3.6400E-02,-3.4327E-02),( 3.6854E-02,-3.3723E-02),
     &  ( 3.7227E-02,-3.3146E-02),( 3.7551E-02,-3.2565E-02),
     &  ( 3.7830E-02,-3.1985E-02),( 3.8066E-02,-3.1410E-02),
     &  ( 3.8277E-02,-3.0843E-02),( 3.8422E-02,-3.0276E-02),
     &  ( 3.8549E-02,-2.9724E-02),( 3.8649E-02,-2.9153E-02),
     &  ( 3.8716E-02,-2.8603E-02),( 3.8756E-02,-2.8043E-02),
     &  ( 3.8768E-02,-2.7478E-02),( 3.8752E-02,-2.6922E-02),
     &  ( 3.8709E-02,-2.6370E-02),( 3.8636E-02,-2.5809E-02),
     &  ( 3.8532E-02,-2.5246E-02),( 3.8399E-02,-2.4690E-02),
     &  ( 3.8235E-02,-2.4131E-02),( 3.7981E-02,-2.3569E-02),
     &  ( 3.7697E-02,-2.3004E-02),( 3.7378E-02,-2.2444E-02)/
  
         DATA ((CGS  (I,J), I=1901,2000), J=1,1) /
     &  ( 3.7205E-02,-2.1875E-02),( 3.6834E-02,-2.1305E-02),
     &  ( 3.6405E-02,-2.0733E-02),( 3.5895E-02,-2.0160E-02),
     &  ( 3.5306E-02,-1.9584E-02),( 3.4588E-02,-1.9004E-02),
     &  ( 3.3685E-02,-1.8422E-02),( 3.2460E-02,-1.7864E-02),
     &  ( 3.0281E-02,-1.7208E-02),( 3.0165E-02,-1.7219E-02),
     &  ( 2.9521E-02,-1.7325E-02),( 2.9326E-02,-1.7428E-02),
     &  ( 2.8933E-02,-1.7530E-02),( 2.8745E-02,-1.7632E-02),
     &  ( 2.8593E-02,-1.7732E-02),( 2.8467E-02,-1.7833E-02),
     &  ( 2.8359E-02,-1.7933E-02),( 2.8267E-02,-1.8033E-02),
     &  ( 2.8147E-02,-1.8133E-02),( 2.8118E-02,-1.8232E-02),
     &  ( 2.8058E-02,-1.8332E-02),( 2.8007E-02,-1.8431E-02),
     &  ( 2.7958E-02,-1.8530E-02),( 2.7926E-02,-1.8630E-02),
     &  ( 2.7895E-02,-1.8729E-02),( 2.7871E-02,-1.8828E-02),
     &  ( 2.7853E-02,-1.8928E-02),( 2.7840E-02,-1.9027E-02),
     &  ( 2.7761E-02,-1.9127E-02),( 2.7764E-02,-1.9226E-02),
     &  ( 2.7834E-02,-1.9326E-02),( 2.7843E-02,-1.9426E-02),
     &  ( 2.7860E-02,-1.9526E-02),( 2.7882E-02,-1.9626E-02),
     &  ( 2.7911E-02,-1.9726E-02),( 2.7946E-02,-1.9826E-02),
     &  ( 2.7989E-02,-1.9927E-02),( 2.8041E-02,-2.0028E-02),
     &  ( 2.8103E-02,-2.0129E-02),( 2.8176E-02,-2.0231E-02),
     &  ( 2.8264E-02,-2.0334E-02),( 2.8362E-02,-2.0437E-02),
     &  ( 2.8508E-02,-2.0542E-02),( 2.8696E-02,-2.0650E-02),
     &  ( 2.9183E-02,-2.0774E-02),( 2.9546E-02,-2.0725E-02),
     &  ( 2.9787E-02,-2.0661E-02),( 2.9914E-02,-2.0595E-02),
     &  ( 3.0016E-02,-2.0528E-02),( 3.0101E-02,-2.0460E-02),
     &  ( 3.0175E-02,-2.0392E-02),( 3.0239E-02,-2.0323E-02),
     &  ( 3.0295E-02,-2.0255E-02),( 3.0345E-02,-2.0185E-02),
     &  ( 3.0388E-02,-2.0116E-02),( 3.0426E-02,-2.0047E-02),
     &  ( 3.0459E-02,-1.9978E-02),( 3.0487E-02,-1.9910E-02),
     &  ( 3.0511E-02,-1.9841E-02),( 3.0531E-02,-1.9772E-02),
     &  ( 3.0548E-02,-1.9703E-02),( 3.0560E-02,-1.9635E-02),
     &  ( 3.0569E-02,-1.9567E-02),( 3.0574E-02,-1.9499E-02),
     &  ( 3.0585E-02,-1.9432E-02),( 3.0575E-02,-1.9366E-02),
     &  ( 3.0569E-02,-1.9299E-02),( 3.0560E-02,-1.9234E-02),
     &  ( 3.0548E-02,-1.9169E-02),( 3.0531E-02,-1.9105E-02),
     &  ( 3.0511E-02,-1.9042E-02),( 3.0488E-02,-1.8981E-02),
     &  ( 3.0459E-02,-1.8921E-02),( 3.0427E-02,-1.8863E-02),
     &  ( 3.0390E-02,-1.8807E-02),( 3.0383E-02,-1.8754E-02),
     &  ( 3.0341E-02,-1.8704E-02),( 3.0292E-02,-1.8658E-02),
     &  ( 3.0235E-02,-1.8619E-02),( 3.0124E-02,-1.8586E-02),
     &  ( 2.9632E-02,-1.8657E-02),( 2.9708E-02,-1.8676E-02),
     &  ( 2.9693E-02,-1.8695E-02),( 2.9678E-02,-1.8716E-02),
     &  ( 2.9666E-02,-1.8738E-02),( 2.9654E-02,-1.8760E-02),
     &  ( 2.9644E-02,-1.8783E-02),( 2.9636E-02,-1.8806E-02),
     &  ( 2.9628E-02,-1.8830E-02),( 2.9622E-02,-1.8854E-02),
     &  ( 2.9610E-02,-1.8878E-02),( 2.9606E-02,-1.8904E-02),
     &  ( 2.9605E-02,-1.8929E-02),( 2.9458E-02,-1.8954E-02),
     &  ( 2.9459E-02,-1.8980E-02),( 2.9461E-02,-1.9007E-02),
     &  ( 2.9609E-02,-1.9033E-02),( 2.9614E-02,-1.9059E-02),
     &  ( 2.9620E-02,-1.9086E-02),( 2.9627E-02,-1.9113E-02)/
  
         DATA ((CGS  (I,J), I=2001,2100), J=1,1) /
     &  ( 2.9636E-02,-1.9141E-02),( 2.9647E-02,-1.9168E-02),
     &  ( 2.9660E-02,-1.9195E-02),( 2.9674E-02,-1.9223E-02),
     &  ( 2.9691E-02,-1.9250E-02),( 2.9710E-02,-1.9278E-02),
     &  ( 2.9731E-02,-1.9305E-02),( 2.9755E-02,-1.9333E-02),
     &  ( 2.9782E-02,-1.9361E-02),( 2.9813E-02,-1.9388E-02),
     &  ( 2.9848E-02,-1.9415E-02),( 2.9889E-02,-1.9442E-02),
     &  ( 2.9938E-02,-1.9469E-02),( 2.9998E-02,-1.9495E-02),
     &  ( 3.0080E-02,-1.9519E-02),( 3.0289E-02,-1.9532E-02),
     &  ( 3.0496E-02,-1.9479E-02),( 3.0579E-02,-1.9438E-02),
     &  ( 3.0679E-02,-1.9398E-02),( 3.0739E-02,-1.9360E-02),
     &  ( 3.0790E-02,-1.9322E-02),( 3.0750E-02,-1.9284E-02),
     &  ( 3.0783E-02,-1.9247E-02),( 3.0812E-02,-1.9209E-02),
     &  ( 3.0838E-02,-1.9172E-02),( 3.0862E-02,-1.9136E-02),
     &  ( 3.0883E-02,-1.9099E-02),( 3.0903E-02,-1.9062E-02),
     &  ( 3.0921E-02,-1.9025E-02),( 3.0936E-02,-1.8988E-02),
     &  ( 3.0951E-02,-1.8952E-02),( 3.0964E-02,-1.8915E-02),
     &  ( 3.0975E-02,-1.8879E-02),( 3.0985E-02,-1.8842E-02),
     &  ( 3.0995E-02,-1.8805E-02),( 3.1002E-02,-1.8769E-02),
     &  ( 3.1008E-02,-1.8733E-02),( 3.1013E-02,-1.8696E-02),
     &  ( 3.1017E-02,-1.8660E-02),( 3.1019E-02,-1.8623E-02),
     &  ( 3.1021E-02,-1.8586E-02),( 3.1022E-02,-1.8549E-02),
     &  ( 3.1021E-02,-1.8513E-02),( 3.1019E-02,-1.8476E-02),
     &  ( 3.1016E-02,-1.8439E-02),( 3.1012E-02,-1.8402E-02),
     &  ( 3.1011E-02,-1.8366E-02),( 3.1003E-02,-1.8328E-02),
     &  ( 3.0995E-02,-1.8291E-02),( 3.0985E-02,-1.8254E-02),
     &  ( 3.0973E-02,-1.8217E-02),( 3.0906E-02,-1.8049E-02),
     &  ( 3.0626E-02,-1.7690E-02),( 3.0312E-02,-1.7483E-02),
     &  ( 3.0190E-02,-1.7365E-02),( 3.0002E-02,-1.7287E-02),
     &  ( 2.9845E-02,-1.7237E-02),( 2.9691E-02,-1.7200E-02),
     &  ( 2.9557E-02,-1.7175E-02),( 2.9424E-02,-1.7155E-02),
     &  ( 2.9297E-02,-1.7141E-02),( 2.9170E-02,-1.7130E-02),
     &  ( 2.9038E-02,-1.7122E-02),( 2.8907E-02,-1.7116E-02),
     &  ( 2.8896E-02,-1.7112E-02),( 2.8886E-02,-1.7109E-02),
     &  ( 2.8875E-02,-1.7107E-02),( 2.8865E-02,-1.7043E-02),
     &  ( 2.8854E-02,-1.7048E-02),( 2.8844E-02,-1.7052E-02),
     &  ( 2.8833E-02,-1.7056E-02),( 2.8822E-02,-1.9682E-02),
     &  ( 2.8812E-02,-1.9680E-02),( 2.8800E-02,-1.9679E-02),
     &  ( 2.8790E-02,-1.9677E-02),( 2.8779E-02,-1.9676E-02),
     &  ( 2.8768E-02,-1.9674E-02),( 2.8757E-02,-1.9673E-02),
     &  ( 2.8871E-02,-1.9671E-02),( 2.8978E-02,-1.9670E-02),
     &  ( 2.9070E-02,-1.9668E-02),( 2.9158E-02,-1.9667E-02),
     &  ( 2.9236E-02,-1.9665E-02),( 2.9313E-02,-1.9664E-02),
     &  ( 2.9381E-02,-1.9662E-02),( 2.9449E-02,-1.9661E-02),
     &  ( 2.9513E-02,-1.9659E-02),( 2.9572E-02,-1.9658E-02),
     &  ( 2.9630E-02,-1.9657E-02),( 2.9684E-02,-1.9655E-02),
     &  ( 2.9739E-02,-1.9654E-02),( 2.9789E-02,-1.9652E-02),
     &  ( 2.9840E-02,-1.9651E-02),( 2.9888E-02,-1.9650E-02),
     &  ( 2.9936E-02,-1.9648E-02),( 2.9981E-02,-1.9647E-02),
     &  ( 3.0027E-02,-1.9646E-02),( 3.0069E-02,-1.9644E-02),
     &  ( 3.0111E-02,-1.9643E-02),( 3.0154E-02,-1.9642E-02)/
  
         DATA ((CGS  (I,J), I=2101,2193), J=1,1) /
     &  ( 3.0195E-02,-1.9640E-02),( 3.0236E-02,-1.9639E-02),
     &  ( 3.0275E-02,-1.9638E-02),( 3.0315E-02,-1.9636E-02),
     &  ( 3.0353E-02,-1.9635E-02),( 3.0392E-02,-1.9634E-02),
     &  ( 3.0428E-02,-1.9632E-02),( 3.0466E-02,-1.9631E-02),
     &  ( 3.0502E-02,-1.9630E-02),( 3.0538E-02,-1.9629E-02),
     &  ( 3.0575E-02,-1.9627E-02),( 3.0609E-02,-1.9626E-02),
     &  ( 3.0644E-02,-1.9625E-02),( 3.0678E-02,-1.9624E-02),
     &  ( 3.0713E-02,-1.9622E-02),( 3.0746E-02,-1.9621E-02),
     &  ( 3.0780E-02,-1.9620E-02),( 3.0812E-02,-1.9619E-02),
     &  ( 3.0845E-02,-1.9617E-02),( 3.0877E-02,-1.9616E-02),
     &  ( 3.0909E-02,-1.9615E-02),( 3.0941E-02,-1.9614E-02),
     &  ( 3.0971E-02,-1.9613E-02),( 3.1003E-02,-1.9611E-02),
     &  ( 3.1034E-02,-1.9610E-02),( 3.1065E-02,-1.9609E-02),
     &  ( 3.1095E-02,-1.9608E-02),( 3.1119E-02,-1.9607E-02),
     &  ( 3.1151E-02,-1.9605E-02),( 3.1181E-02,-1.9604E-02),
     &  ( 3.1211E-02,-1.9603E-02),( 3.1241E-02,-1.9602E-02),
     &  ( 3.1270E-02,-1.9601E-02),( 3.1300E-02,-1.9600E-02),
     &  ( 3.1329E-02,-1.9599E-02),( 3.1358E-02,-1.9597E-02),
     &  ( 3.1387E-02,-1.9596E-02),( 3.1415E-02,-1.9595E-02),
     &  ( 3.1446E-02,-1.9594E-02),( 3.1476E-02,-1.9593E-02),
     &  ( 3.1507E-02,-1.9592E-02),( 3.1537E-02,-1.9591E-02),
     &  ( 3.1568E-02,-1.9590E-02),( 3.1597E-02,-1.9588E-02),
     &  ( 3.1629E-02,-1.9587E-02),( 3.1658E-02,-1.9586E-02),
     &  ( 3.1689E-02,-1.9585E-02),( 3.1719E-02,-1.9584E-02),
     &  ( 3.1749E-02,-1.9583E-02),( 3.1780E-02,-1.9582E-02),
     &  ( 3.1810E-02,-1.9581E-02),( 3.1841E-02,-1.9580E-02),
     &  ( 3.1870E-02,-1.9579E-02),( 3.1902E-02,-1.9578E-02),
     &  ( 3.1931E-02,-1.9577E-02),( 3.1962E-02,-1.9576E-02),
     &  ( 3.1992E-02,-1.9575E-02),( 3.2023E-02,-1.9574E-02),
     &  ( 3.2053E-02,-1.9573E-02),( 3.2084E-02,-1.9571E-02),
     &  ( 3.2321E-02,-1.9560E-02),( 3.2559E-02,-1.9550E-02),
     &  ( 3.2600E-02,-1.9548E-02),( 3.4446E-02,-1.9478E-02),
     &  ( 3.5264E-02,-1.9450E-02),( 3.7394E-02,-1.9386E-02),
     &  ( 3.8799E-02,-1.9355E-02),( 3.8857E-02,-1.9353E-02),
     &  ( 4.0230E-02,-1.9317E-02),( 4.0235E-02,-1.9317E-02),
     &  ( 4.1422E-02,-1.9293E-02),( 4.1467E-02,-1.9292E-02),
     &  ( 4.1495E-02,-1.9291E-02),( 4.2087E-02,-1.9281E-02),
     &  ( 4.2479E-02,-1.9274E-02),( 4.2550E-02,-1.9272E-02),
     &  ( 4.2664E-02,-1.9270E-02),( 4.2835E-02,-1.9268E-02),
     &  ( 4.2955E-02,-1.9265E-02),( 4.3030E-02,-1.9264E-02),
     &  ( 4.3766E-02,-1.9252E-02),( 4.3804E-02,-1.9252E-02),
     &  ( 4.4026E-02,-1.9249E-02),( 4.4067E-02,-1.9248E-02),
     &  ( 4.4276E-02,-1.9245E-02),( 4.4360E-02,-1.9244E-02),
     &  ( 4.4427E-02,-1.9243E-02),( 4.4489E-02,-1.9243E-02),
     &  ( 4.4612E-02,-1.9240E-02),( 4.4801E-02,-1.9237E-02),
     &  ( 4.4895E-02,-1.9236E-02),( 4.5527E-02,-1.9227E-02),
     &  ( 4.6068E-02,-1.9220E-02)/
  
         DATA ((CGS  (I,J), I=   1, 100), J=2,2) /
     &  ( 2.2367E-06, 0.0000E+00),( 2.4259E-06, 6.7781E-08),
     &  ( 2.6634E-06, 4.2607E-07),( 2.9775E-06, 9.9581E-07),
     &  ( 3.4344E-06, 1.8998E-06),( 3.9297E-06, 3.0618E-06),
     &  ( 5.4588E-06, 4.4820E-06),( 4.5669E-06, 1.2071E-05),
     &  ( 4.9105E-06, 1.3069E-05),( 5.3169E-06, 1.4131E-05),
     &  ( 5.5732E-06, 1.5444E-05),( 6.1509E-06, 1.6747E-05),
     &  ( 6.3080E-06, 1.8259E-05),( 6.6181E-06, 1.9226E-05),
     &  ( 6.8434E-06, 2.2672E-05),( 7.0638E-06, 2.3071E-05),
     &  ( 7.4215E-06, 2.1873E-05),( 7.7593E-06, 2.3050E-05),
     &  ( 7.8837E-06, 2.4059E-05),( 8.0891E-06, 2.5214E-05),
     &  ( 8.2834E-06, 2.5467E-05),( 8.5423E-06, 2.5530E-05),
     &  ( 8.7682E-06, 2.5971E-05),( 8.9625E-06, 2.7084E-05),
     &  ( 9.1645E-06, 2.7883E-05),( 9.5169E-06, 2.8345E-05),
     &  ( 9.8668E-06, 2.8954E-05),( 1.0060E-05, 2.9695E-05),
     &  ( 1.0124E-05, 3.0047E-05),( 1.0423E-05, 3.0712E-05),
     &  ( 1.0802E-05, 3.0930E-05),( 1.0927E-05, 3.1224E-05),
     &  ( 1.1310E-05, 3.2148E-05),( 1.1681E-05, 3.3724E-05),
     &  ( 1.2073E-05, 3.5069E-05),( 1.2507E-05, 3.5657E-05),
     &  ( 1.2976E-05, 3.5867E-05),( 1.3649E-05, 3.6246E-05),
     &  ( 1.4239E-05, 3.7506E-05),( 1.4841E-05, 3.8683E-05),
     &  ( 1.5501E-05, 3.9524E-05),( 1.6294E-05, 4.0826E-05),
     &  ( 1.7216E-05, 4.2759E-05),( 1.8104E-05, 4.3579E-05),
     &  ( 1.9581E-05, 4.4755E-05),( 2.1843E-05, 4.5680E-05),
     &  ( 2.3633E-05, 4.5932E-05),( 2.4170E-05, 4.6268E-05),
     &  ( 2.4010E-05, 4.7732E-05),( 2.3355E-05, 5.2915E-05),
     &  ( 2.8029E-05, 5.7468E-05),( 3.3310E-05, 6.3456E-05),
     &  ( 3.6843E-05, 7.2649E-05),( 3.6729E-05, 7.6379E-05),
     &  ( 4.1022E-05, 7.3017E-05),( 4.1848E-05, 7.0390E-05),
     &  ( 3.7971E-05, 7.4908E-05),( 3.4765E-05, 7.7954E-05),
     &  ( 3.3656E-05, 7.8690E-05),( 3.3941E-05, 8.0476E-05),
     &  ( 3.5217E-05, 8.3628E-05),( 3.5028E-05, 8.7620E-05),
     &  ( 3.5814E-05, 8.8881E-05),( 3.5489E-05, 9.3608E-05),
     &  ( 3.6718E-05, 9.6340E-05),( 3.7395E-05, 1.0432E-04),
     &  ( 3.9021E-05, 1.1063E-04),( 4.2268E-05, 1.1693E-04),
     &  ( 4.3667E-05, 1.1693E-04),( 4.3829E-05, 1.1903E-04),
     &  ( 4.6811E-05, 1.2549E-04),( 4.4741E-05, 1.2922E-04),
     &  ( 4.5376E-05, 1.3616E-04),( 4.7064E-05, 1.4404E-04),
     &  ( 4.9038E-05, 1.5286E-04),( 4.9272E-05, 1.6578E-04),
     &  ( 4.7790E-05, 1.8123E-04),( 4.7766E-05, 1.8816E-04),
     &  ( 4.7768E-05, 1.9856E-04),( 1.1755E-04, 1.9751E-04),
     &  ( 9.9436E-05, 1.9625E-04),( 1.0261E-04, 1.9547E-04),
     &  ( 9.8141E-05, 1.9002E-04),( 9.3867E-05, 1.8767E-04),
     &  ( 8.0748E-05, 1.8558E-04),( 7.8075E-05, 1.8521E-04),
     &  ( 8.1718E-05, 1.8376E-04),( 7.4042E-05, 1.8417E-04),
     &  ( 7.1487E-05, 1.8505E-04),( 6.9656E-05, 1.8464E-04),
     &  ( 6.6490E-05, 1.8431E-04),( 6.4936E-05, 1.8375E-04),
     &  ( 6.3593E-05, 1.8305E-04),( 6.2680E-05, 1.8243E-04),
     &  ( 6.1771E-05, 1.8188E-04),( 6.0429E-05, 1.7912E-04),
     &  ( 6.0143E-05, 1.7737E-04),( 5.9853E-05, 1.7560E-04),
     &  ( 5.9450E-05, 1.7315E-04),( 5.8765E-05, 1.7310E-04)/
  
         DATA ((CGS  (I,J), I= 101, 200), J=2,2) /
     &  ( 5.8510E-05, 1.7355E-04),( 5.8189E-05, 1.7397E-04),
     &  ( 5.7948E-05, 1.7437E-04),( 5.7917E-05, 1.7521E-04),
     &  ( 5.8357E-05, 1.7628E-04),( 5.7954E-05, 1.7731E-04),
     &  ( 5.7560E-05, 1.7832E-04),( 5.7173E-05, 1.7932E-04),
     &  ( 5.6258E-05, 1.8031E-04),( 5.5704E-05, 1.8129E-04),
     &  ( 5.5534E-05, 1.8228E-04),( 5.4642E-05, 1.8329E-04),
     &  ( 5.3723E-05, 1.8433E-04),( 5.2753E-05, 1.8497E-04),
     &  ( 5.2382E-05, 1.8530E-04),( 5.1980E-05, 1.8567E-04),
     &  ( 5.1406E-05, 1.8613E-04),( 5.0743E-05, 1.8718E-04),
     &  ( 5.0525E-05, 1.8844E-04),( 5.0665E-05, 1.8906E-04),
     &  ( 5.0795E-05, 1.8956E-04),( 5.0934E-05, 1.9000E-04),
     &  ( 5.1383E-05, 1.9041E-04),( 5.2220E-05, 1.9080E-04),
     &  ( 5.3186E-05, 1.9117E-04),( 5.2956E-05, 1.9154E-04),
     &  ( 5.3297E-05, 1.9199E-04),( 5.3935E-05, 1.9244E-04),
     &  ( 5.4799E-05, 1.9289E-04),( 5.4687E-05, 1.9335E-04),
     &  ( 5.4755E-05, 1.9382E-04),( 5.4657E-05, 1.9431E-04),
     &  ( 5.4810E-05, 1.9481E-04),( 5.4494E-05, 1.9533E-04),
     &  ( 5.4504E-05, 1.9587E-04),( 5.4361E-05, 1.9638E-04),
     &  ( 5.4247E-05, 1.9655E-04),( 5.4363E-05, 1.9673E-04),
     &  ( 5.4221E-05, 1.9686E-04),( 5.4312E-05, 1.9700E-04),
     &  ( 5.4840E-05, 1.9714E-04),( 5.4750E-05, 1.9737E-04),
     &  ( 5.5354E-05, 1.9762E-04),( 5.5654E-05, 1.9530E-04),
     &  ( 5.6287E-05, 1.9096E-04),( 5.7112E-05, 1.8601E-04),
     &  ( 5.7171E-05, 1.8024E-04),( 5.9368E-05, 1.7549E-04),
     &  ( 5.8815E-05, 1.7029E-04),( 5.9150E-05, 1.6461E-04),
     &  ( 5.7764E-05, 1.6243E-04),( 6.1358E-05, 1.5542E-04),
     &  ( 6.2167E-05, 1.5291E-04),( 5.0132E-05, 1.4698E-04),
     &  ( 3.8097E-05, 1.4577E-04),( 3.8115E-05, 1.4236E-04),
     &  ( 3.7925E-05, 1.3553E-04),( 3.6630E-05, 1.3227E-04),
     &  ( 3.7014E-05, 1.2891E-04),( 3.7183E-05, 1.2628E-04),
     &  ( 3.8479E-05, 1.2392E-04),( 4.0044E-05, 1.1467E-04),
     &  ( 4.0950E-05, 1.1341E-04),( 3.9272E-05, 1.1268E-04),
     &  ( 3.8365E-05, 1.1016E-04),( 3.7622E-05, 1.0690E-04),
     &  ( 3.7733E-05, 1.0427E-04),( 3.7150E-05, 1.0348E-04),
     &  ( 3.5790E-05, 9.5604E-05),( 3.5893E-05, 9.0351E-05),
     &  ( 3.7455E-05, 8.3102E-05),( 3.7923E-05, 8.1421E-05),
     &  ( 3.7835E-05, 7.5013E-05),( 3.7631E-05, 7.0180E-05),
     &  ( 3.7961E-05, 6.5347E-05),( 3.8369E-05, 6.0514E-05),
     &  ( 3.9013E-05, 5.9884E-05),( 3.9789E-05, 5.8203E-05),
     &  ( 4.1062E-05, 5.6837E-05),( 4.1673E-05, 5.4526E-05),
     &  ( 4.3043E-05, 5.1768E-05),( 4.3722E-05, 4.9693E-05),
     &  ( 4.5399E-05, 4.6857E-05),( 4.7075E-05, 4.4125E-05),
     &  ( 4.9582E-05, 5.2005E-05),( 5.1981E-05, 5.1269E-05),
     &  ( 5.5561E-05, 4.8117E-05),( 5.8903E-05, 4.3810E-05),
     &  ( 6.3108E-05, 4.1814E-05),( 6.8445E-05, 4.0133E-05),
     &  ( 7.1556E-05, 4.0343E-05),( 7.3820E-05, 4.0343E-05),
     &  ( 7.8984E-05, 3.8767E-05),( 8.1909E-05, 3.6561E-05),
     &  ( 8.4870E-05, 3.4565E-05),( 8.8550E-05, 3.4250E-05),
     &  ( 9.2802E-05, 4.9273E-05),( 9.7909E-05, 5.0114E-05),
     &  ( 1.0266E-04, 5.0954E-05),( 1.1088E-04, 9.9649E-05)/
  
         DATA ((CGS  (I,J), I= 201, 300), J=2,2) /
     &  ( 1.2007E-04, 1.0065E-04),( 1.2625E-04, 9.2873E-05),
     &  ( 1.2868E-04, 9.1181E-05),( 1.3128E-04, 8.9616E-05),
     &  ( 1.3404E-04, 8.8145E-05),( 1.3697E-04, 8.6674E-05),
     &  ( 1.4007E-04, 8.8329E-05),( 1.4328E-04, 9.1234E-05),
     &  ( 1.4656E-04, 9.4139E-05),( 1.5001E-04, 9.2663E-05),
     &  ( 1.5363E-04, 9.0457E-05),( 1.5744E-04, 8.8250E-05),
     &  ( 1.6143E-04, 8.7368E-05),( 1.6554E-04, 8.5981E-05),
     &  ( 1.6983E-04, 8.4673E-05),( 1.7439E-04, 8.6107E-05),
     &  ( 1.7923E-04, 8.7541E-05),( 1.8437E-04, 8.7862E-05),
     &  ( 1.8988E-04, 8.5398E-05),( 1.9577E-04, 8.2934E-05),
     &  ( 2.0213E-04, 8.1873E-05),( 2.0899E-04, 8.2682E-05),
     &  ( 2.1643E-04, 8.3491E-05),( 2.2454E-04, 8.5077E-05),
     &  ( 2.3343E-04, 8.7247E-05),( 2.4320E-04, 8.9416E-05),
     &  ( 2.5406E-04, 9.5657E-05),( 2.6621E-04, 1.0608E-04),
     &  ( 2.8040E-04, 1.2288E-04),( 2.9934E-04, 1.3967E-04),
     &  ( 3.1439E-04, 1.4687E-04),( 3.1706E-04, 9.0734E-05),
     &  ( 3.2411E-04, 9.0686E-05),( 3.3718E-04, 9.1328E-05),
     &  ( 3.4767E-04, 9.2979E-05),( 3.6298E-04, 9.5313E-05),
     &  ( 3.7691E-04, 9.8748E-05),( 3.9216E-04, 1.0295E-04),
     &  ( 4.0616E-04, 1.0886E-04),( 4.2665E-04, 1.1775E-04),
     &  ( 4.4245E-04, 1.3223E-04),( 4.5311E-04, 1.4726E-04),
     &  ( 4.7123E-04, 1.6469E-04),( 4.7308E-04, 1.8450E-04),
     &  ( 4.7494E-04, 2.0425E-04),( 4.7398E-04, 2.1839E-04),
     &  ( 4.6843E-04, 2.3269E-04),( 4.6550E-04, 2.2723E-04),
     &  ( 4.8645E-04, 2.1225E-04),( 5.6387E-04, 1.9742E-04),
     &  ( 6.6210E-04, 1.8280E-04),( 7.7395E-04, 2.6269E-04),
     &  ( 8.4375E-04, 3.6606E-04),( 8.8840E-04, 4.7358E-04),
     &  ( 8.8494E-04, 4.9251E-04),( 9.0833E-04, 5.1146E-04),
     &  ( 9.4111E-04, 5.4374E-04),( 9.8233E-04, 5.8432E-04),
     &  ( 9.6198E-04, 6.4212E-04),( 1.0132E-03, 7.0063E-04),
     &  ( 1.0463E-03, 7.5857E-04),( 1.0420E-03, 8.1656E-04),
     &  ( 1.0738E-03, 8.9245E-04),( 1.0698E-03, 1.0272E-03),
     &  ( 9.9786E-04, 1.1620E-03),( 8.8557E-04, 1.2438E-03),
     &  ( 7.0228E-04, 1.3339E-03),( 5.8664E-04, 1.3742E-03),
     &  ( 5.3445E-04, 1.3531E-03),( 4.6682E-04, 1.3806E-03),
     &  ( 3.8121E-04, 1.4049E-03),( 2.8436E-04, 1.4241E-03),
     &  ( 2.0279E-04, 1.4093E-03),( 1.8099E-04, 1.3972E-03),
     &  ( 1.5716E-04, 1.4823E-03),( 3.1658E-05, 1.6224E-03),
     &  ( 2.6829E-04, 1.5923E-03),( 4.3024E-04, 1.4841E-03),
     &  ( 4.9754E-04, 1.4285E-03),( 5.8169E-04, 1.3722E-03),
     &  ( 6.6208E-04, 1.3165E-03),( 7.2818E-04, 1.2538E-03),
     &  ( 7.8552E-04, 1.1943E-03),( 8.3753E-04, 1.1362E-03),
     &  ( 8.8827E-04, 1.0773E-03),( 9.4644E-04, 1.0192E-03),
     &  ( 9.9482E-04, 9.2461E-04),( 9.6449E-04, 8.3330E-04),
     &  ( 9.8278E-04, 7.4653E-04),( 9.4072E-04, 6.8660E-04),
     &  ( 9.0481E-04, 6.4900E-04),( 8.6892E-04, 6.0887E-04),
     &  ( 8.4943E-04, 5.8213E-04),( 8.3373E-04, 5.6877E-04),
     &  ( 8.1990E-04, 5.4206E-04),( 8.1629E-04, 5.2234E-04),
     &  ( 8.0435E-04, 5.0582E-04),( 7.9595E-04, 4.8930E-04),
     &  ( 7.8959E-04, 4.7342E-04),( 7.8460E-04, 4.5693E-04)/
  
         DATA ((CGS  (I,J), I= 301, 400), J=2,2) /
     &  ( 7.5846E-04, 4.4107E-04),( 7.8138E-04, 4.2460E-04),
     &  ( 7.7434E-04, 4.0877E-04),( 7.7281E-04, 3.9233E-04),
     &  ( 7.6093E-04, 3.2953E-04),( 7.4104E-04, 2.6733E-04),
     &  ( 7.0725E-04, 2.0628E-04),( 6.8303E-04, 1.5401E-04),
     &  ( 5.8719E-04, 1.3462E-04),( 5.4085E-04, 1.2621E-04),
     &  ( 5.1101E-04, 1.1861E-04),( 4.8615E-04, 1.1132E-04),
     &  ( 4.6388E-04, 1.0440E-04),( 4.4389E-04, 9.7516E-05),
     &  ( 4.2527E-04, 9.1651E-05),( 4.0682E-04, 8.6460E-05),
     &  ( 3.8714E-04, 8.2696E-05),( 3.6875E-04, 8.1034E-05),
     &  ( 3.5357E-04, 7.9469E-05),( 3.4008E-04, 7.7917E-05),
     &  ( 3.2725E-04, 7.6713E-05),( 3.1633E-04, 7.5465E-05),
     &  ( 3.1378E-04, 7.4391E-05),( 2.9687E-04, 7.3595E-05),
     &  ( 2.9051E-04, 7.2815E-05),( 3.0232E-04, 7.2530E-05),
     &  ( 2.9919E-04, 1.4341E-04),( 2.7417E-04, 1.4106E-04),
     &  ( 2.6021E-04, 1.3684E-04),( 2.4930E-04, 1.3263E-04),
     &  ( 2.4000E-04, 1.2841E-04),( 2.3172E-04, 1.2420E-04),
     &  ( 2.2424E-04, 1.1998E-04),( 2.1740E-04, 1.1577E-04),
     &  ( 2.1109E-04, 1.1210E-04),( 2.0525E-04, 1.0916E-04),
     &  ( 1.9981E-04, 1.0622E-04),( 1.9473E-04, 1.0327E-04),
     &  ( 1.8997E-04, 1.0033E-04),( 1.8552E-04, 9.7390E-05),
     &  ( 1.8133E-04, 9.4449E-05),( 1.7738E-04, 9.3554E-05),
     &  ( 1.7360E-04, 9.4466E-05),( 1.7006E-04, 9.5378E-05),
     &  ( 1.6665E-04, 9.6289E-05),( 1.6328E-04, 9.7201E-05),
     &  ( 1.6008E-04, 9.8113E-05),( 1.5707E-04, 9.9025E-05),
     &  ( 1.5423E-04, 9.9744E-05),( 1.5157E-04, 9.9305E-05),
     &  ( 1.4910E-04, 9.8866E-05),( 1.4668E-04, 9.8426E-05),
     &  ( 1.4403E-04, 9.7987E-05),( 1.4148E-04, 9.7548E-05),
     &  ( 1.3903E-04, 9.7108E-05),( 1.3667E-04, 1.0313E-04),
     &  ( 1.3045E-04, 1.2880E-04),( 1.1848E-04, 1.2639E-04),
     &  ( 1.0136E-04, 1.2019E-04),( 9.1902E-05, 9.5289E-05),
     &  ( 8.3158E-05, 8.9931E-05),( 7.6384E-05, 8.4468E-05),
     &  ( 7.0845E-05, 8.4048E-05),( 6.6927E-05, 8.1737E-05),
     &  ( 6.2265E-05, 7.7009E-05),( 6.1459E-05, 7.6904E-05),
     &  ( 5.6132E-05, 8.4048E-05),( 5.5928E-05, 7.3542E-05),
     &  ( 5.4967E-05, 7.4172E-05),( 5.2253E-05, 7.0390E-05),
     &  ( 5.0960E-05, 7.1966E-05),( 5.0199E-05, 7.1861E-05),
     &  ( 4.8967E-05, 6.6398E-05),( 4.8259E-05, 6.5347E-05),
     &  ( 4.6316E-05, 6.5662E-05),( 4.7171E-05, 6.3981E-05),
     &  ( 4.5048E-05, 6.5032E-05),( 4.4781E-05, 6.3456E-05),
     &  ( 4.3760E-05, 6.3561E-05),( 4.4107E-05, 6.3036E-05),
     &  ( 4.2287E-05, 6.4717E-05),( 4.3370E-05, 6.4402E-05),
     &  ( 4.1361E-05, 6.2511E-05),( 4.2154E-05, 6.0409E-05),
     &  ( 4.1571E-05, 6.0094E-05),( 4.1336E-05, 5.9674E-05),
     &  ( 4.1714E-05, 6.0514E-05),( 4.0372E-05, 6.0935E-05),
     &  ( 4.1742E-05, 6.0935E-05),( 4.0630E-05, 5.8834E-05),
     &  ( 4.0527E-05, 6.0830E-05),( 4.1399E-05, 6.2195E-05),
     &  ( 4.0915E-05, 6.1880E-05),( 4.3428E-05, 6.0620E-05),
     &  ( 4.1957E-05, 6.2090E-05),( 4.3595E-05, 6.5242E-05),
     &  ( 4.3524E-05, 6.9445E-05),( 4.7159E-05, 8.0056E-05),
     &  ( 4.6540E-05, 7.9845E-05),( 4.5858E-05, 7.9110E-05)/
  
         DATA ((CGS  (I,J), I= 401, 500), J=2,2) /
     &  ( 4.7216E-05, 9.5960E-05),( 5.1259E-05, 1.0243E-04),
     &  ( 5.3255E-05, 1.0501E-04),( 5.0424E-05, 1.0650E-04),
     &  ( 4.9362E-05, 1.0706E-04),( 5.0768E-05, 1.1061E-04),
     &  ( 5.3356E-05, 1.1188E-04),( 5.5547E-05, 1.1264E-04),
     &  ( 5.5753E-05, 1.1359E-04),( 5.3662E-05, 1.1533E-04),
     &  ( 5.5504E-05, 1.1646E-04),( 5.5698E-05, 1.1776E-04),
     &  ( 5.6998E-05, 1.1803E-04),( 6.2036E-05, 1.2050E-04),
     &  ( 6.0678E-05, 1.2078E-04),( 5.7330E-05, 1.2215E-04),
     &  ( 5.8828E-05, 1.2325E-04),( 5.5650E-05, 1.2591E-04),
     &  ( 5.6119E-05, 1.2628E-04),( 6.0536E-05, 1.3069E-04),
     &  ( 6.1282E-05, 1.3108E-04),( 6.2610E-05, 1.3147E-04),
     &  ( 6.4595E-05, 1.3537E-04),( 6.2714E-05, 1.3927E-04),
     &  ( 6.0745E-05, 1.4004E-04),( 6.2649E-05, 1.4518E-04),
     &  ( 6.2679E-05, 1.4561E-04),( 6.8369E-05, 1.4675E-04),
     &  ( 6.8467E-05, 1.4698E-04),( 6.6998E-05, 1.4834E-04),
     &  ( 6.9881E-05, 1.4908E-04),( 6.6466E-05, 1.5127E-04),
     &  ( 6.7661E-05, 1.5151E-04),( 6.9416E-05, 1.5395E-04),
     &  ( 7.2655E-05, 1.5676E-04),( 6.8621E-05, 1.5841E-04),
     &  ( 6.8789E-05, 1.5875E-04),( 6.7220E-05, 1.6946E-04),
     &  ( 6.9671E-05, 1.7023E-04),( 7.5372E-05, 1.7405E-04),
     &  ( 7.4261E-05, 1.7673E-04),( 7.5543E-05, 1.7787E-04),
     &  ( 7.3547E-05, 1.7864E-04),( 7.3957E-05, 1.7902E-04),
     &  ( 7.2451E-05, 1.7963E-04),( 7.1712E-05, 1.7976E-04),
     &  ( 7.9622E-05, 1.8179E-04),( 7.5187E-05, 1.8383E-04),
     &  ( 7.8438E-05, 1.8404E-04),( 7.2553E-05, 1.8338E-04),
     &  ( 8.0928E-05, 1.8273E-04),( 8.0658E-05, 1.8259E-04),
     &  ( 8.0957E-05, 1.8289E-04),( 8.2193E-05, 1.8469E-04),
     &  ( 7.7744E-05, 1.8558E-04),( 7.3097E-05, 1.8648E-04),
     &  ( 7.1595E-05, 1.8363E-04),( 7.3969E-05, 1.8277E-04),
     &  ( 7.9322E-05, 1.8017E-04),( 8.0146E-05, 1.7844E-04),
     &  ( 8.0060E-05, 1.7585E-04),( 7.9093E-05, 1.7542E-04),
     &  ( 7.9423E-05, 1.7412E-04),( 7.7801E-05, 1.7326E-04),
     &  ( 7.8835E-05, 1.7290E-04),( 7.9022E-05, 1.7330E-04),
     &  ( 7.7006E-05, 1.7377E-04),( 7.9343E-05, 1.7484E-04),
     &  ( 8.3756E-05, 1.7556E-04),( 8.1483E-05, 1.7319E-04),
     &  ( 8.2750E-05, 1.7293E-04),( 8.3342E-05, 1.6978E-04),
     &  ( 8.8500E-05, 1.7068E-04),( 9.2070E-05, 1.7146E-04),
     &  ( 9.2695E-05, 1.7128E-04),( 9.9573E-05, 1.6988E-04),
     &  ( 1.0228E-04, 1.6971E-04),( 9.9242E-05, 1.7290E-04),
     &  ( 1.0452E-04, 1.9773E-04),( 1.0042E-04, 2.4029E-04),
     &  ( 9.8955E-05, 2.4739E-04),( 1.1453E-04, 2.5648E-04),
     &  ( 1.2451E-04, 2.5591E-04),( 1.2511E-04, 2.5555E-04),
     &  ( 1.1120E-04, 2.5580E-04),( 1.1865E-04, 2.5587E-04),
     &  ( 1.2427E-04, 2.5551E-04),( 1.2991E-04, 2.5470E-04),
     &  ( 1.2162E-04, 2.5340E-04),( 1.2340E-04, 2.5154E-04),
     &  ( 1.2393E-04, 2.4688E-04),( 1.2474E-04, 2.4595E-04),
     &  ( 1.2883E-04, 2.4222E-04),( 1.2896E-04, 2.3755E-04),
     &  ( 1.2266E-04, 2.3289E-04),( 1.2028E-04, 2.3103E-04),
     &  ( 1.3776E-04, 2.0917E-04),( 1.5856E-04, 1.9684E-04),
     &  ( 1.6241E-04, 2.1161E-04),( 1.9438E-04, 2.4452E-04)/
  
         DATA ((CGS  (I,J), I= 501, 600), J=2,2) /
     &  ( 2.0252E-04, 2.4689E-04),( 1.9092E-04, 2.1537E-04),
     &  ( 1.7474E-04, 2.1012E-04),( 1.7229E-04, 1.0506E-04),
     &  ( 1.4060E-04, 1.0576E-04),( 1.4377E-04, 1.0742E-04),
     &  ( 1.5485E-04, 1.1557E-04),( 1.5196E-04, 9.9807E-05),
     &  ( 1.5704E-04, 8.4048E-05),( 1.6844E-04, 8.4048E-05),
     &  ( 1.8489E-04, 8.4048E-05),( 2.0607E-04, 8.4048E-05),
     &  ( 2.3333E-04, 8.4048E-05),( 2.6912E-04, 8.4048E-05),
     &  ( 3.1764E-04, 8.4048E-05),( 3.8643E-04, 8.4048E-05),
     &  ( 4.9032E-04, 8.4048E-05),( 5.1862E-04, 8.3523E-05),
     &  ( 5.4890E-04, 8.2997E-05),( 5.8352E-04, 8.2472E-05),
     &  ( 6.2281E-04, 8.1947E-05),( 6.6757E-04, 8.1421E-05),
     &  ( 7.1887E-04, 8.0896E-05),( 7.7856E-04, 8.0371E-05),
     &  ( 7.9160E-04, 8.0266E-05),( 8.0511E-04, 8.0161E-05),
     &  ( 8.1910E-04, 8.0056E-05),( 8.3359E-04, 7.9951E-05),
     &  ( 8.4858E-04, 7.9845E-05),( 8.6395E-04, 7.9740E-05),
     &  ( 8.7989E-04, 7.9635E-05),( 8.9643E-04, 7.9530E-05),
     &  ( 9.1361E-04, 7.9425E-05),( 9.3144E-04, 7.9320E-05),
     &  ( 1.0207E-03, 7.8847E-05),( 1.0901E-03, 7.9545E-05),
     &  ( 1.1283E-03, 7.9996E-05),( 1.1552E-03, 8.0296E-05),
     &  ( 1.1834E-03, 8.0596E-05),( 1.2130E-03, 8.0896E-05),
     &  ( 1.2440E-03, 8.1196E-05),( 1.2766E-03, 8.1496E-05),
     &  ( 1.3109E-03, 8.1797E-05),( 1.3287E-03, 8.1947E-05),
     &  ( 1.3470E-03, 8.2097E-05),( 1.3658E-03, 8.2247E-05),
     &  ( 1.3851E-03, 8.2397E-05),( 1.4050E-03, 8.2547E-05),
     &  ( 1.4254E-03, 8.2697E-05),( 1.4464E-03, 8.2847E-05),
     &  ( 1.4680E-03, 8.2997E-05),( 1.4903E-03, 8.3147E-05),
     &  ( 1.5132E-03, 8.3297E-05),( 1.5368E-03, 8.3448E-05),
     &  ( 1.5612E-03, 8.3598E-05),( 1.5863E-03, 8.3748E-05),
     &  ( 1.6122E-03, 8.3898E-05),( 1.6389E-03, 8.4048E-05),
     &  ( 1.6665E-03, 8.4398E-05),( 1.6951E-03, 8.4748E-05),
     &  ( 1.7246E-03, 8.5098E-05),( 1.7551E-03, 8.5449E-05),
     &  ( 1.7868E-03, 8.5799E-05),( 1.8195E-03, 8.6149E-05),
     &  ( 1.8534E-03, 8.6499E-05),( 1.8887E-03, 8.6849E-05),
     &  ( 1.9252E-03, 8.7200E-05),( 1.9631E-03, 8.7550E-05),
     &  ( 2.0026E-03, 8.7900E-05),( 2.0436E-03, 8.8250E-05),
     &  ( 2.0863E-03, 8.8600E-05),( 2.1308E-03, 8.8951E-05),
     &  ( 2.1771E-03, 8.9301E-05),( 2.2255E-03, 8.9301E-05),
     &  ( 2.2761E-03, 8.9301E-05),( 2.3290E-03, 8.9301E-05),
     &  ( 2.3843E-03, 8.9301E-05),( 2.4423E-03, 8.9301E-05),
     &  ( 2.5031E-03, 8.9301E-05),( 2.5669E-03, 8.9301E-05),
     &  ( 2.6341E-03, 8.9301E-05),( 2.7047E-03, 8.9301E-05),
     &  ( 2.7793E-03, 8.9301E-05),( 2.8181E-03, 8.9170E-05),
     &  ( 2.8579E-03, 8.9038E-05),( 2.8989E-03, 8.8907E-05),
     &  ( 2.9411E-03, 8.8776E-05),( 2.9845E-03, 8.8644E-05),
     &  ( 3.0292E-03, 8.8513E-05),( 3.0752E-03, 8.8382E-05),
     &  ( 3.1226E-03, 8.8250E-05),( 3.1715E-03, 8.8119E-05),
     &  ( 3.2219E-03, 8.7988E-05),( 3.2740E-03, 8.7856E-05),
     &  ( 3.3277E-03, 8.7725E-05),( 3.3831E-03, 8.7594E-05),
     &  ( 3.4405E-03, 8.7462E-05),( 3.4997E-03, 8.7331E-05),
     &  ( 3.5611E-03, 8.7200E-05),( 3.6246E-03, 8.7068E-05)/
  
         DATA ((CGS  (I,J), I= 601, 700), J=2,2) /
     &  ( 3.6903E-03, 8.6937E-05),( 3.7585E-03, 8.6806E-05),
     &  ( 3.8292E-03, 8.6674E-05),( 3.9025E-03, 8.6543E-05),
     &  ( 3.9788E-03, 8.6412E-05),( 4.0580E-03, 8.6280E-05),
     &  ( 4.1403E-03, 8.6149E-05),( 4.2261E-03, 8.6018E-05),
     &  ( 4.3154E-03, 8.5886E-05),( 4.4086E-03, 8.5755E-05),
     &  ( 4.5058E-03, 8.5624E-05),( 4.6074E-03, 8.5492E-05),
     &  ( 4.7136E-03, 8.5361E-05),( 4.8248E-03, 8.5230E-05),
     &  ( 4.9412E-03, 8.5098E-05),( 5.0634E-03, 8.4967E-05),
     &  ( 5.1918E-03, 8.4836E-05),( 5.3267E-03, 8.4705E-05),
     &  ( 5.4688E-03, 8.4573E-05),( 5.6185E-03, 8.4442E-05),
     &  ( 5.7767E-03, 8.4311E-05),( 6.0135E-03, 8.4127E-05),
     &  ( 6.1210E-03, 8.4048E-05),( 6.3089E-03, 8.4048E-05),
     &  ( 6.5086E-03, 8.4048E-05),( 6.7213E-03, 8.4048E-05),
     &  ( 6.9482E-03, 8.4048E-05),( 7.1909E-03, 8.4048E-05),
     &  ( 7.4510E-03, 8.4048E-05),( 7.7305E-03, 8.4048E-05),
     &  ( 8.0317E-03, 8.4048E-05),( 8.3571E-03, 8.4048E-05),
     &  ( 8.7098E-03, 8.4048E-05),( 9.0934E-03, 8.4048E-05),
     &  ( 9.3996E-03, 8.4048E-05),( 1.0354E-02, 8.4048E-05),
     &  ( 1.1522E-02, 8.4048E-05),( 1.2986E-02, 8.4048E-05),
     &  ( 1.4873E-02, 8.4048E-05),( 1.7401E-02, 8.4048E-05),
     &  ( 2.0958E-02, 8.4048E-05),( 2.6338E-02, 8.4048E-05),
     &  ( 3.5420E-02, 7.5171E-04),( 5.4029E-02, 1.7407E-03),
     &  ( 1.1361E-01, 7.7034E-03),( 1.2014E-01, 8.6164E-03),
     &  ( 1.2745E-01, 9.7015E-03),( 1.3572E-01, 1.1005E-02),
     &  ( 1.4512E-01, 1.2590E-02),( 1.5592E-01, 1.4542E-02),
     &  ( 1.6844E-01, 1.6985E-02),( 1.8313E-01, 2.0099E-02),
     &  ( 2.0061E-01, 2.4151E-02),( 2.2174E-01, 2.9559E-02),
     &  ( 2.4777E-01, 3.7001E-02),( 2.8062E-01, 4.7632E-02),
     &  ( 3.2328E-01, 6.3556E-02),( 3.8075E-01, 8.8926E-02),
     &  ( 3.8760E-01, 9.2261E-02),( 5.4101E-01, 1.8570E-01),
     &  ( 6.5282E-01, 2.7972E-01),( 7.4266E-01, 3.7514E-01),
     &  ( 8.2079E-01, 4.7660E-01),( 8.8100E-01, 5.7018E-01),
     &  ( 9.3360E-01, 6.6673E-01),( 9.7576E-01, 7.5781E-01),
     &  ( 1.0178E+00, 8.6623E-01),( 1.0466E+00, 9.5629E-01),
     &  ( 1.0733E+00, 1.0585E+00),( 1.0922E+00, 1.1501E+00),
     &  ( 1.1077E+00, 1.2513E+00),( 1.1164E+00, 1.3340E+00),
     &  ( 1.1230E+00, 1.4536E+00),( 1.1235E+00, 1.5175E+00),
     &  ( 1.1202E+00, 1.6187E+00),( 1.1111E+00, 1.7259E+00),
     &  ( 1.1013E+00, 1.8007E+00),( 1.0800E+00, 1.9173E+00),
     &  ( 1.0610E+00, 1.9976E+00),( 1.0376E+00, 2.0796E+00),
     &  ( 1.0095E+00, 2.1628E+00),( 9.7636E-01, 2.2467E+00),
     &  ( 9.3783E-01, 2.3307E+00),( 8.9364E-01, 2.4140E+00),
     &  ( 8.4357E-01, 2.4957E+00),( 7.8748E-01, 2.5750E+00),
     &  ( 7.2533E-01, 2.6508E+00),( 6.5719E-01, 2.7220E+00),
     &  ( 5.4427E-01, 2.8178E+00),( 4.6241E-01, 2.8728E+00),
     &  ( 3.3119E-01, 2.9392E+00),( 1.9215E-01, 2.9838E+00),
     &  ( 1.9202E-01, 2.9838E+00),( 5.4415E-01, 2.8179E+00),
     &  ( 6.5709E-01, 2.7221E+00),( 7.5706E-01, 2.6135E+00),
     &  ( 8.1619E-01, 2.5359E+00),( 8.9356E-01, 2.4141E+00),
     &  ( 9.3776E-01, 2.3308E+00),( 9.7629E-01, 2.2469E+00)/
  
         DATA ((CGS  (I,J), I= 701, 800), J=2,2) /
     &  ( 1.0094E+00, 2.1630E+00),( 1.0376E+00, 2.0797E+00),
     &  ( 1.0609E+00, 1.9977E+00),( 1.0800E+00, 1.9174E+00),
     &  ( 1.0951E+00, 1.8391E+00),( 1.1066E+00, 1.7631E+00),
     &  ( 1.1149E+00, 1.6897E+00),( 1.1202E+00, 1.6188E+00),
     &  ( 1.1235E+00, 1.5177E+00),( 1.1230E+00, 1.4537E+00),
     &  ( 1.1187E+00, 1.3630E+00),( 1.1110E+00, 1.2784E+00),
     &  ( 1.1042E+00, 1.2253E+00),( 1.0878E+00, 1.1265E+00),
     &  ( 1.0734E+00, 1.0587E+00),( 1.0522E+00, 9.7585E-01),
     &  ( 1.0295E+00, 9.0102E-01),( 9.9993E-01, 8.1755E-01),
     &  ( 9.6977E-01, 7.4395E-01),( 9.2770E-01, 6.5507E-01),
     &  ( 8.8678E-01, 5.8003E-01),( 8.3677E-01, 4.9996E-01),
     &  ( 7.8038E-01, 4.2167E-01),( 7.0784E-01, 3.3576E-01),
     &  ( 6.2469E-01, 2.5371E-01),( 5.2086E-01, 1.7125E-01),
     &  ( 4.2921E-01, 1.1398E-01),( 3.5801E-01, 7.8338E-02),
     &  ( 3.0663E-01, 5.7053E-02),( 2.6795E-01, 4.3365E-02),
     &  ( 2.3783E-01, 3.4057E-02),( 2.1374E-01, 2.7446E-02),
     &  ( 1.9405E-01, 2.2585E-02),( 1.7766E-01, 1.8908E-02),
     &  ( 1.6381E-01, 1.6059E-02),( 1.5195E-01, 1.3808E-02),
     &  ( 1.4169E-01, 1.1999E-02),( 1.3272E-01, 1.0523E-02),
     &  ( 1.2482E-01, 9.3034E-03),( 1.1780E-01, 8.2841E-03),
     &  ( 1.1153E-01, 7.4235E-03),( 1.0589E-01, 6.6903E-03),
     &  ( 1.0079E-01, 6.0605E-03),( 9.6166E-02, 5.5157E-03),
     &  ( 5.0426E-02, 1.5167E-03),( 3.4176E-02, 7.0050E-04),
     &  ( 2.5852E-02, 8.4098E-05),( 2.0792E-02, 8.4150E-05),
     &  ( 1.7392E-02, 8.4202E-05),( 1.4949E-02, 8.4254E-05),
     &  ( 1.3110E-02, 8.4306E-05),( 1.1675E-02, 8.4358E-05),
     &  ( 1.0524E-02, 8.4409E-05),( 9.5801E-03, 8.4461E-05),
     &  ( 9.4684E-03, 8.4468E-05),( 8.6892E-03, 8.4521E-05),
     &  ( 8.0291E-03, 8.4573E-05),( 7.4628E-03, 8.4626E-05),
     &  ( 6.9715E-03, 8.4678E-05),( 6.5414E-03, 8.4731E-05),
     &  ( 6.1616E-03, 8.4783E-05),( 5.8238E-03, 8.4836E-05),
     &  ( 5.5215E-03, 8.4888E-05),( 5.2492E-03, 8.4941E-05),
     &  ( 5.0028E-03, 8.4993E-05),( 4.7787E-03, 8.5046E-05),
     &  ( 4.5741E-03, 8.5098E-05),( 4.3864E-03, 8.5151E-05),
     &  ( 4.2137E-03, 8.5204E-05),( 4.0543E-03, 8.5256E-05),
     &  ( 3.9066E-03, 8.5309E-05),( 3.7695E-03, 8.5361E-05),
     &  ( 3.6418E-03, 8.5414E-05),( 3.5226E-03, 8.5466E-05),
     &  ( 3.4110E-03, 8.5519E-05),( 3.3065E-03, 8.5571E-05),
     &  ( 3.2082E-03, 8.5624E-05),( 3.1157E-03, 8.5676E-05),
     &  ( 3.0285E-03, 8.5729E-05),( 2.9462E-03, 8.5781E-05),
     &  ( 2.8683E-03, 8.5834E-05),( 2.7945E-03, 8.5886E-05),
     &  ( 2.7244E-03, 8.5939E-05),( 2.6579E-03, 8.5991E-05),
     &  ( 2.5946E-03, 8.6044E-05),( 2.5343E-03, 8.6097E-05),
     &  ( 2.4769E-03, 8.6149E-05),( 2.4220E-03, 8.6202E-05),
     &  ( 2.3696E-03, 8.6254E-05),( 2.3195E-03, 8.6307E-05),
     &  ( 2.2715E-03, 8.6359E-05),( 2.2254E-03, 8.6412E-05),
     &  ( 2.1813E-03, 8.6464E-05),( 2.1390E-03, 8.6517E-05),
     &  ( 2.0983E-03, 8.6569E-05),( 2.0592E-03, 8.6622E-05),
     &  ( 2.0215E-03, 8.6674E-05),( 1.9853E-03, 8.6727E-05),
     &  ( 1.9503E-03, 8.6779E-05),( 1.9166E-03, 8.6832E-05)/
  
         DATA ((CGS  (I,J), I= 801, 900), J=2,2) /
     &  ( 1.8842E-03, 8.6885E-05),( 1.8528E-03, 8.6937E-05),
     &  ( 1.8225E-03, 8.6990E-05),( 1.7932E-03, 8.7042E-05),
     &  ( 1.7649E-03, 8.7095E-05),( 1.7375E-03, 8.7147E-05),
     &  ( 1.7109E-03, 8.7200E-05),( 1.6852E-03, 8.7252E-05),
     &  ( 1.6603E-03, 8.7305E-05),( 1.6362E-03, 8.7357E-05),
     &  ( 1.6127E-03, 8.7410E-05),( 1.5900E-03, 8.7462E-05),
     &  ( 1.5679E-03, 8.7515E-05),( 1.5465E-03, 8.7567E-05),
     &  ( 1.5257E-03, 8.7620E-05),( 1.5054E-03, 8.7672E-05),
     &  ( 1.4858E-03, 8.7725E-05),( 1.4666E-03, 8.7778E-05),
     &  ( 1.4480E-03, 8.7830E-05),( 1.4298E-03, 8.7883E-05),
     &  ( 1.4122E-03, 8.7935E-05),( 1.3950E-03, 8.7988E-05),
     &  ( 1.3782E-03, 8.8040E-05),( 1.3619E-03, 8.8093E-05),
     &  ( 1.3459E-03, 8.8145E-05),( 1.3304E-03, 8.8198E-05),
     &  ( 1.3152E-03, 8.8250E-05),( 1.3004E-03, 8.8303E-05),
     &  ( 1.2860E-03, 8.8355E-05),( 1.2719E-03, 8.8408E-05),
     &  ( 1.2581E-03, 8.8460E-05),( 1.2447E-03, 8.8513E-05),
     &  ( 1.2315E-03, 8.8565E-05),( 1.2187E-03, 8.8618E-05),
     &  ( 1.2061E-03, 8.8671E-05),( 1.1939E-03, 8.8723E-05),
     &  ( 1.1819E-03, 8.8776E-05),( 1.1701E-03, 8.8828E-05),
     &  ( 1.1586E-03, 8.8881E-05),( 1.1474E-03, 8.8933E-05),
     &  ( 1.1364E-03, 8.8986E-05),( 1.1256E-03, 8.9038E-05),
     &  ( 1.1151E-03, 8.9091E-05),( 1.1048E-03, 8.9143E-05),
     &  ( 1.0947E-03, 8.9196E-05),( 1.0849E-03, 8.9248E-05),
     &  ( 1.0762E-03, 8.9296E-05),( 1.0656E-03, 8.9511E-05),
     &  ( 1.0562E-03, 8.9721E-05),( 1.0470E-03, 8.9931E-05),
     &  ( 1.0380E-03, 9.0141E-05),( 1.0291E-03, 9.0351E-05),
     &  ( 1.0204E-03, 9.0562E-05),( 1.0119E-03, 9.0772E-05),
     &  ( 1.0035E-03, 9.0982E-05),( 9.9525E-04, 9.1192E-05),
     &  ( 9.8717E-04, 9.1402E-05),( 7.5568E-04, 9.9807E-05),
     &  ( 6.0428E-04, 1.1031E-04),( 5.0526E-04, 1.1031E-04),
     &  ( 4.9985E-04, 1.1031E-04),( 4.9084E-04, 1.0506E-04),
     &  ( 5.3987E-04, 1.0506E-04),( 5.7889E-04, 1.0506E-04),
     &  ( 6.3527E-04, 1.0506E-04),( 6.4363E-04, 1.0532E-04),
     &  ( 6.8822E-04, 1.1031E-04),( 7.1633E-04, 1.1031E-04),
     &  ( 7.2174E-04, 1.1031E-04),( 7.9996E-04, 1.1031E-04),
     &  ( 9.1397E-04, 1.1031E-04),( 9.6117E-04, 1.1031E-04),
     &  ( 1.0165E-03, 9.4554E-05),( 1.0740E-03, 9.5117E-05),
     &  ( 1.1421E-03, 9.6055E-05),( 1.2202E-03, 9.6993E-05),
     &  ( 1.3106E-03, 9.7931E-05),( 1.4162E-03, 9.8869E-05),
     &  ( 1.5412E-03, 9.9807E-05),( 1.6911E-03, 1.0112E-04),
     &  ( 1.8741E-03, 1.0243E-04),( 2.1022E-03, 1.0375E-04),
     &  ( 2.3941E-03, 1.0506E-04),( 2.5350E-03, 1.0506E-04),
     &  ( 2.6936E-03, 1.0506E-04),( 2.8734E-03, 1.0506E-04),
     &  ( 3.0789E-03, 1.0506E-04),( 3.3160E-03, 1.0506E-04),
     &  ( 3.5927E-03, 1.0506E-04),( 3.7490E-03, 1.0506E-04),
     &  ( 3.9195E-03, 1.0506E-04),( 4.1063E-03, 1.0506E-04),
     &  ( 4.3116E-03, 1.0506E-04),( 4.5385E-03, 1.0506E-04),
     &  ( 4.7906E-03, 1.0506E-04),( 5.0721E-03, 1.0506E-04),
     &  ( 5.3887E-03, 1.0506E-04),( 5.7473E-03, 1.0506E-04),
     &  ( 6.1569E-03, 1.0649E-04),( 6.6290E-03, 1.0793E-04)/
  
         DATA ((CGS  (I,J), I= 901,1000), J=2,2) /
     &  ( 7.1793E-03, 1.0936E-04),( 7.8006E-03, 1.1073E-04),
     &  ( 8.2074E-03, 1.1152E-04),( 8.6588E-03, 1.1231E-04),
     &  ( 9.1625E-03, 1.1310E-04),( 9.7282E-03, 1.1388E-04),
     &  ( 1.0368E-02, 1.1467E-04),( 1.1098E-02, 1.1546E-04),
     &  ( 1.1938E-02, 1.1625E-04),( 1.2915E-02, 1.1704E-04),
     &  ( 1.4066E-02, 1.1782E-04),( 1.5441E-02, 1.1861E-04),
     &  ( 1.7114E-02, 1.1940E-04),( 1.9191E-02, 1.2019E-04),
     &  ( 2.1840E-02, 1.2098E-04),( 2.5334E-02, 1.2176E-04),
     &  ( 3.0154E-02, 1.2255E-04),( 3.7225E-02, 1.2334E-04),
     &  ( 4.8591E-02, 1.2413E-04),( 6.9782E-02, 1.1536E-02),
     &  ( 1.0311E-01, 2.5664E-02),( 1.2208E-01, 3.6510E-02),
     &  ( 1.4277E-01, 5.0939E-02),( 1.9368E-01, 1.0074E-01),
     &  ( 2.1202E-01, 1.2535E-01),( 2.2716E-01, 1.4952E-01),
     &  ( 2.4001E-01, 1.7372E-01),( 2.5084E-01, 1.9774E-01),
     &  ( 2.5972E-01, 2.2102E-01),( 2.6736E-01, 2.4496E-01),
     &  ( 2.7363E-01, 2.6886E-01),( 2.7811E-01, 2.9008E-01),
     &  ( 2.8191E-01, 3.1333E-01),( 2.8461E-01, 3.3656E-01),
     &  ( 2.8621E-01, 3.5934E-01),( 2.8679E-01, 3.8124E-01),
     &  ( 2.8638E-01, 4.0449E-01),( 2.8526E-01, 4.2350E-01),
     &  ( 2.8298E-01, 4.4617E-01),( 2.8001E-01, 4.6681E-01),
     &  ( 2.7600E-01, 4.8813E-01),( 2.7084E-01, 5.1005E-01),
     &  ( 2.6541E-01, 5.2923E-01),( 2.5781E-01, 5.5195E-01),
     &  ( 2.5012E-01, 5.7160E-01),( 2.4129E-01, 5.9127E-01),
     &  ( 2.3125E-01, 6.1082E-01),( 2.1796E-01, 6.3327E-01),
     &  ( 2.0517E-01, 6.5199E-01),( 1.8861E-01, 6.7295E-01),
     &  ( 1.7302E-01, 6.8992E-01),( 1.5028E-01, 7.1072E-01),
     &  ( 1.2547E-01, 7.2895E-01),( 8.8408E-02, 7.4894E-01),
     &  ( 5.6105E-02, 7.6022E-01),( 1.8896E-02, 7.6680E-01),
     &  ( 2.6316E-04, 7.6763E-01),( 1.8802E-02, 7.6681E-01),
     &  ( 3.7527E-02, 7.6433E-01),( 8.8319E-02, 7.4898E-01),
     &  ( 1.2538E-01, 7.2901E-01),( 1.5020E-01, 7.1079E-01),
     &  ( 1.7294E-01, 6.9000E-01),( 1.8854E-01, 6.7303E-01),
     &  ( 2.0511E-01, 6.5208E-01),( 2.1790E-01, 6.3336E-01),
     &  ( 2.3120E-01, 6.1092E-01),( 2.4124E-01, 5.9137E-01),
     &  ( 2.5008E-01, 5.7170E-01),( 2.5777E-01, 5.5206E-01),
     &  ( 2.6538E-01, 5.2934E-01),( 2.7081E-01, 5.1016E-01),
     &  ( 2.7597E-01, 4.8824E-01),( 2.7999E-01, 4.6692E-01),
     &  ( 2.8297E-01, 4.4629E-01),( 2.8525E-01, 4.2361E-01),
     &  ( 2.8637E-01, 4.0460E-01),( 2.8679E-01, 3.8136E-01),
     &  ( 2.8621E-01, 3.5945E-01),( 2.8462E-01, 3.3667E-01),
     &  ( 2.8193E-01, 3.1344E-01),( 2.7813E-01, 2.9018E-01),
     &  ( 2.7365E-01, 2.6896E-01),( 2.6739E-01, 2.4505E-01),
     &  ( 2.5975E-01, 2.2112E-01),( 2.5087E-01, 1.9783E-01),
     &  ( 2.4005E-01, 1.7381E-01),( 2.2720E-01, 1.4960E-01),
     &  ( 2.1207E-01, 1.2543E-01),( 1.9373E-01, 1.0081E-01),
     &  ( 1.7238E-01, 7.6190E-02),( 1.8357E-01, 8.8929E-02),
     &  ( 1.5704E-01, 6.2651E-02),( 1.4069E-01, 4.9357E-02),
     &  ( 1.3081E-01, 4.2249E-02),( 1.1034E-01, 2.9543E-02),
     &  ( 1.0318E-01, 2.5699E-02),( 8.7762E-02, 1.8413E-02),
     &  ( 5.6826E-02, 1.2886E-04),( 4.1928E-02, 1.2964E-04)/
  
         DATA ((CGS  (I,J), I=1001,1100), J=2,2) /
     &  ( 3.3201E-02, 1.3043E-04),( 2.7477E-02, 1.3122E-04),
     &  ( 2.3435E-02, 1.3201E-04),( 2.0429E-02, 1.3280E-04),
     &  ( 1.8107E-02, 1.3358E-04),( 1.6260E-02, 1.3437E-04),
     &  ( 1.4755E-02, 1.3516E-04),( 1.3506E-02, 1.3595E-04),
     &  ( 1.2452E-02, 1.3658E-04),( 1.1551E-02, 1.3658E-04),
     &  ( 1.0772E-02, 1.3920E-04),( 1.0092E-02, 1.3927E-04),
     &  ( 9.4926E-03, 1.3935E-04),( 8.9609E-03, 1.3943E-04),
     &  ( 8.4859E-03, 1.3951E-04),( 8.0589E-03, 1.3960E-04),
     &  ( 7.3840E-03, 1.3976E-04),( 6.5416E-03, 1.4003E-04),
     &  ( 6.0910E-03, 1.4329E-04),( 5.3547E-03, 1.5599E-04),
     &  ( 4.7786E-03, 1.6873E-04),( 4.2136E-03, 1.8471E-04),
     &  ( 3.4116E-03, 2.1122E-04),( 2.5295E-03, 2.4594E-04),
     &  ( 2.0084E-03, 2.8351E-04),( 1.7918E-03, 2.9906E-04),
     &  ( 1.6707E-03, 3.1430E-04),( 1.5920E-03, 3.2977E-04),
     &  ( 1.5364E-03, 3.4558E-04),( 1.4945E-03, 3.6178E-04),
     &  ( 1.4617E-03, 3.7834E-04),( 1.4350E-03, 3.9490E-04),
     &  ( 1.4127E-03, 4.1167E-04),( 1.3937E-03, 4.2876E-04),
     &  ( 1.3771E-03, 4.4608E-04),( 1.3624E-03, 4.6364E-04),
     &  ( 1.3492E-03, 4.8140E-04),( 1.3372E-03, 4.9931E-04),
     &  ( 1.3262E-03, 5.1741E-04),( 1.3158E-03, 5.3567E-04),
     &  ( 1.3060E-03, 5.5412E-04),( 1.2967E-03, 5.7271E-04),
     &  ( 1.2878E-03, 5.9152E-04),( 1.2790E-03, 6.1054E-04),
     &  ( 1.2705E-03, 6.2979E-04),( 1.2621E-03, 6.4928E-04),
     &  ( 1.2538E-03, 6.6911E-04),( 1.2454E-03, 6.8929E-04),
     &  ( 1.2368E-03, 7.0992E-04),( 1.2282E-03, 7.3103E-04),
     &  ( 1.2192E-03, 7.5278E-04),( 1.2098E-03, 7.7529E-04),
     &  ( 1.1999E-03, 7.9886E-04),( 1.1891E-03, 8.2371E-04),
     &  ( 1.1773E-03, 8.5043E-04),( 1.1635E-03, 8.8009E-04),
     &  ( 1.1462E-03, 9.1532E-04),( 1.1073E-03, 9.8328E-04),
     &  ( 1.0741E-03, 1.0222E-03),( 1.0628E-03, 1.0275E-03),
     &  ( 1.0554E-03, 1.0262E-03),( 1.0500E-03, 1.0212E-03),
     &  ( 1.0459E-03, 1.0133E-03),( 1.0429E-03, 1.0031E-03),
     &  ( 1.0405E-03, 9.9095E-04),( 1.0388E-03, 9.7703E-04),
     &  ( 1.0374E-03, 9.6147E-04),( 1.0363E-03, 9.4442E-04),
     &  ( 1.0354E-03, 9.2593E-04),( 1.0346E-03, 9.0606E-04),
     &  ( 1.0338E-03, 8.8491E-04),( 1.0330E-03, 8.6248E-04),
     &  ( 1.0318E-03, 8.3884E-04),( 1.0307E-03, 8.1403E-04),
     &  ( 1.0290E-03, 7.8818E-04),( 1.0269E-03, 7.6126E-04),
     &  ( 1.0242E-03, 7.3339E-04),( 1.0208E-03, 7.0466E-04),
     &  ( 1.0167E-03, 6.7516E-04),( 1.0116E-03, 6.4496E-04),
     &  ( 1.0054E-03, 6.1427E-04),( 9.9806E-04, 5.8326E-04),
     &  ( 9.8919E-04, 5.5208E-04),( 9.7847E-04, 5.2109E-04),
     &  ( 9.6625E-04, 4.9057E-04),( 9.5145E-04, 4.6093E-04),
     &  ( 9.3392E-04, 4.3270E-04),( 9.1267E-04, 4.0654E-04),
     &  ( 8.8726E-04, 3.8324E-04),( 8.5465E-04, 3.6350E-04),
     &  ( 8.1344E-04, 3.4866E-04),( 7.5598E-04, 3.3983E-04),
     &  ( 7.3954E-04, 3.3897E-04),( 6.9012E-04, 3.4541E-04),
     &  ( 6.2138E-04, 3.5861E-04),( 6.1493E-04, 3.5848E-04),
     &  ( 5.7147E-04, 3.6311E-04),( 5.5721E-04, 3.6822E-04),
     &  ( 5.4573E-04, 3.6814E-04),( 5.3054E-04, 3.6805E-04)/
  
         DATA ((CGS  (I,J), I=1101,1200), J=2,2) /
     &  ( 5.1742E-04, 3.6274E-04),( 5.0532E-04, 3.7214E-04),
     &  ( 4.9825E-04, 3.7842E-04),( 4.9396E-04, 3.8121E-04),
     &  ( 4.8334E-04, 3.8958E-04),( 4.7270E-04, 3.9783E-04),
     &  ( 4.6354E-04, 4.0623E-04),( 4.5472E-04, 4.1464E-04),
     &  ( 4.4654E-04, 4.1499E-04),( 4.3875E-04, 3.9923E-04),
     &  ( 4.3122E-04, 3.9608E-04),( 4.2415E-04, 3.9923E-04),
     &  ( 4.1742E-04, 3.8977E-04),( 4.1116E-04, 3.8977E-04),
     &  ( 4.0489E-04, 4.0868E-04),( 3.9863E-04, 4.1919E-04),
     &  ( 3.9284E-04, 4.2549E-04),( 3.8707E-04, 4.3180E-04),
     &  ( 3.8317E-04, 4.3495E-04),( 3.7833E-04, 4.3180E-04),
     &  ( 3.7783E-04, 3.9496E-04),( 3.7344E-04, 4.0070E-04),
     &  ( 3.7033E-04, 4.0931E-04),( 3.6467E-04, 4.0924E-04),
     &  ( 3.6587E-04, 4.0920E-04),( 3.6438E-04, 4.2844E-04),
     &  ( 3.6016E-04, 4.9094E-04),( 3.5879E-04, 5.1980E-04),
     &  ( 3.5318E-04, 4.6887E-04),( 3.5283E-04, 4.8117E-04),
     &  ( 3.4893E-04, 4.8110E-04),( 3.4930E-04, 4.8106E-04),
     &  ( 3.4692E-04, 4.8777E-04),( 3.4422E-04, 5.0790E-04),
     &  ( 3.3906E-04, 5.1841E-04),( 3.3639E-04, 5.2411E-04),
     &  ( 3.3256E-04, 5.3846E-04),( 3.3234E-04, 5.3646E-04),
     &  ( 3.2967E-04, 5.0179E-04),( 3.3000E-04, 4.9023E-04),
     &  ( 3.2664E-04, 4.8826E-04),( 3.2563E-04, 4.8532E-04),
     &  ( 3.2147E-04, 4.9007E-04),( 3.2162E-04, 4.9387E-04),
     &  ( 3.2323E-04, 4.9482E-04),( 3.2251E-04, 5.3658E-04),
     &  ( 3.1701E-04, 6.0617E-04),( 3.1433E-04, 6.2150E-04),
     &  ( 3.1751E-04, 5.7151E-04),( 3.1713E-04, 5.2152E-04),
     &  ( 3.1600E-04, 5.0902E-04),( 3.1248E-04, 5.1331E-04),
     &  ( 3.1127E-04, 5.1760E-04),( 3.1153E-04, 5.3051E-04),
     &  ( 3.0766E-04, 5.7365E-04),( 3.0777E-04, 5.9522E-04),
     &  ( 3.0589E-04, 5.8078E-04),( 3.0566E-04, 5.5192E-04),
     &  ( 2.9994E-04, 5.5665E-04),( 3.0239E-04, 5.7147E-04),
     &  ( 3.0200E-04, 6.0307E-04),( 3.0374E-04, 6.1886E-04),
     &  ( 3.0116E-04, 6.1212E-04),( 3.0197E-04, 6.0202E-04),
     &  ( 3.0236E-04, 5.8517E-04),( 2.9481E-04, 5.9231E-04),
     &  ( 2.9417E-04, 5.9803E-04),( 2.9372E-04, 5.9704E-04),
     &  ( 2.9300E-04, 5.8019E-04),( 2.9067E-04, 5.6576E-04),
     &  ( 2.9010E-04, 5.5615E-04),( 2.9116E-04, 5.2733E-04),
     &  ( 2.8535E-04, 5.1002E-04),( 2.8719E-04, 4.9655E-04),
     &  ( 2.8694E-04, 4.9075E-04),( 2.8901E-04, 4.8881E-04),
     &  ( 2.8682E-04, 4.6961E-04),( 2.8730E-04, 4.7915E-04),
     &  ( 2.8590E-04, 4.9156E-04),( 2.9034E-04, 5.2984E-04),
     &  ( 2.9085E-04, 5.7290E-04),( 2.8664E-04, 5.8242E-04),
     &  ( 2.8151E-04, 5.9386E-04),( 2.7843E-04, 5.7364E-04),
     &  ( 2.9351E-04, 5.6016E-04),( 2.9618E-04, 5.1225E-04),
     &  ( 2.9249E-04, 4.4040E-04),( 2.8006E-04, 4.4611E-04),
     &  ( 2.7584E-04, 4.8049E-04),( 2.7859E-04, 4.8813E-04),
     &  ( 2.8077E-04, 4.9763E-04),( 2.8139E-04, 4.5929E-04),
     &  ( 2.7914E-04, 4.6310E-04),( 2.6670E-04, 4.9938E-04),
     &  ( 2.6805E-04, 5.6242E-04),( 2.6921E-04, 5.8344E-04),
     &  ( 2.7149E-04, 5.7003E-04),( 2.7400E-04, 5.2982E-04),
     &  ( 2.7395E-04, 5.1642E-04),( 2.6547E-04, 4.9344E-04)/
  
         DATA ((CGS  (I,J), I=1201,1300), J=2,2) /
     &  ( 2.6678E-04, 4.5898E-04),( 2.6362E-04, 4.1592E-04),
     &  ( 2.6466E-04, 3.8721E-04),( 2.6262E-04, 3.9389E-04),
     &  ( 2.6339E-04, 4.1394E-04),( 2.6240E-04, 4.5310E-04),
     &  ( 2.6634E-04, 5.0182E-04),( 2.6733E-04, 5.4479E-04),
     &  ( 2.7650E-04, 5.7343E-04),( 2.7254E-04, 5.6386E-04),
     &  ( 2.7367E-04, 5.3515E-04),( 2.7946E-04, 5.2559E-04),
     &  ( 2.7048E-04, 5.5897E-04),( 2.7604E-04, 5.1590E-04),
     &  ( 2.8483E-04, 4.6711E-04),( 3.1817E-04, 4.0687E-04),
     &  ( 2.9938E-04, 3.9323E-04),( 3.0843E-04, 4.8687E-04),
     &  ( 3.1707E-04, 4.6773E-04),( 2.9501E-04, 4.2946E-04),
     &  ( 2.9931E-04, 3.8163E-04),( 3.0358E-04, 3.7679E-04),
     &  ( 3.4036E-04, 4.1483E-04),( 3.4506E-04, 4.2910E-04),
     &  ( 4.1342E-04, 4.6232E-04),( 4.1986E-04, 4.7181E-04),
     &  ( 5.4639E-04, 5.0006E-04),( 6.8745E-04, 9.2328E-04),
     &  ( 9.2054E-04, 5.9461E-04),( 1.1682E-03, 1.0891E-03),
     &  ( 7.8314E-04, 1.2832E-03),( 4.4339E-04, 0.0000E+00),
     &  ( 3.3014E-04, 0.0000E+00),( 2.5633E-04, 0.0000E+00),
     &  ( 1.9994E-04, 0.0000E+00),( 1.8573E-04, 0.0000E+00),
     &  ( 1.7545E-04, 0.0000E+00),( 1.6142E-04, 0.0000E+00),
     &  ( 1.5211E-04, 0.0000E+00),( 1.4850E-04, 0.0000E+00),
     &  ( 1.4536E-04, 0.0000E+00),( 1.4261E-04, 0.0000E+00),
     &  ( 1.4016E-04, 0.0000E+00),( 1.3796E-04, 0.0000E+00),
     &  ( 1.3597E-04, 0.0000E+00),( 1.3416E-04, 0.0000E+00),
     &  ( 1.3250E-04, 0.0000E+00),( 1.3097E-04, 0.0000E+00),
     &  ( 1.2956E-04, 0.0000E+00),( 1.2825E-04, 0.0000E+00),
     &  ( 1.2702E-04, 0.0000E+00),( 1.2588E-04, 0.0000E+00),
     &  ( 1.2480E-04, 0.0000E+00),( 1.2380E-04, 0.0000E+00),
     &  ( 1.2285E-04, 0.0000E+00),( 1.2195E-04, 0.0000E+00),
     &  ( 1.2111E-04, 0.0000E+00),( 1.2031E-04, 0.0000E+00),
     &  ( 1.1955E-04, 0.0000E+00),( 1.1884E-04, 0.0000E+00),
     &  ( 1.1816E-04, 0.0000E+00),( 1.1752E-04, 0.0000E+00),
     &  ( 1.1691E-04, 0.0000E+00),( 1.1634E-04, 0.0000E+00),
     &  ( 1.1579E-04, 0.0000E+00),( 1.1528E-04, 0.0000E+00),
     &  ( 1.1479E-04, 0.0000E+00),( 1.1433E-04, 0.0000E+00),
     &  ( 1.1389E-04, 0.0000E+00),( 1.1349E-04, 0.0000E+00),
     &  ( 1.1310E-04, 0.0000E+00),( 1.1275E-04, 0.0000E+00),
     &  ( 1.1242E-04, 0.0000E+00),( 1.1217E-04, 0.0000E+00),
     &  ( 1.1183E-04, 0.0000E+00),( 1.1135E-04, 0.0000E+00),
     &  ( 1.1097E-04, 0.0000E+00),( 1.1071E-04, 0.0000E+00),
     &  ( 1.1057E-04, 0.0000E+00),( 1.1058E-04, 0.0000E+00),
     &  ( 1.1075E-04, 0.0000E+00),( 1.1111E-04, 0.0000E+00),
     &  ( 1.1172E-04, 0.0000E+00),( 1.1262E-04, 0.0000E+00),
     &  ( 1.1390E-04, 0.0000E+00),( 1.1571E-04, 0.0000E+00),
     &  ( 1.1822E-04, 0.0000E+00),( 1.2177E-04, 0.0000E+00),
     &  ( 1.2691E-04, 0.0000E+00),( 1.2754E-04, 0.0000E+00),
     &  ( 1.3471E-04, 0.0000E+00),( 1.4751E-04, 0.0000E+00),
     &  ( 1.7159E-04, 0.0000E+00),( 2.1299E-04, 0.0000E+00),
     &  ( 2.3058E-04, 0.0000E+00),( 3.0576E-04, 0.0000E+00),
     &  ( 4.5063E-04, 0.0000E+00),( 5.1862E-04, 0.0000E+00),
     &  ( 6.1468E-04, 0.0000E+00),( 6.7907E-04, 0.0000E+00)/
  
         DATA ((CGS  (I,J), I=1301,1400), J=2,2) /
     &  ( 7.5982E-04, 0.0000E+00),( 8.4074E-04, 0.0000E+00),
     &  ( 9.4202E-04, 0.0000E+00),( 1.0028E-03, 0.0000E+00),
     &  ( 1.0723E-03, 0.0000E+00),( 1.1525E-03, 0.0000E+00),
     &  ( 1.2460E-03, 0.0000E+00),( 1.3564E-03, 0.0000E+00),
     &  ( 1.4887E-03, 0.0000E+00),( 1.5652E-03, 0.0000E+00),
     &  ( 1.6501E-03, 0.0000E+00),( 1.7448E-03, 0.0000E+00),
     &  ( 1.8513E-03, 0.0000E+00),( 1.9717E-03, 0.0000E+00),
     &  ( 2.1089E-03, 0.0000E+00),( 2.2669E-03, 0.0000E+00),
     &  ( 2.4507E-03, 0.0000E+00),( 2.6670E-03, 0.0000E+00),
     &  ( 2.7571E-03, 0.0000E+00),( 2.8137E-03, 0.0000E+00),
     &  ( 2.8726E-03, 0.0000E+00),( 2.9340E-03, 0.0000E+00),
     &  ( 2.9981E-03, 4.8471E-06),( 3.0651E-03, 5.0669E-06),
     &  ( 3.1352E-03, 5.3019E-06),( 3.2086E-03, 5.5536E-06),
     &  ( 3.2855E-03, 5.8237E-06),( 3.3661E-03, 6.1139E-06),
     &  ( 3.4509E-03, 6.4264E-06),( 3.5400E-03, 6.7634E-06),
     &  ( 3.6339E-03, 7.1277E-06),( 3.7328E-03, 7.5221E-06),
     &  ( 3.8374E-03, 7.9502E-06),( 3.9480E-03, 8.4159E-06),
     &  ( 4.0651E-03, 8.9236E-06),( 4.1894E-03, 9.4787E-06),
     &  ( 4.3216E-03, 1.0087E-05),( 4.4624E-03, 1.0756E-05),
     &  ( 4.6127E-03, 1.1494E-05),( 4.7734E-03, 1.2310E-05),
     &  ( 4.9458E-03, 1.3217E-05),( 5.1312E-03, 1.4227E-05),
     &  ( 5.3309E-03, 1.5357E-05),( 5.5469E-03, 1.6628E-05),
     &  ( 5.7811E-03, 1.8063E-05),( 6.0359E-03, 1.9693E-05),
     &  ( 6.3143E-03, 2.1552E-05),( 6.6196E-03, 2.3689E-05),
     &  ( 6.9560E-03, 2.6159E-05),( 7.3283E-03, 2.9036E-05),
     &  ( 7.7428E-03, 3.2415E-05),( 8.2070E-03, 3.6420E-05),
     &  ( 8.7303E-03, 4.1216E-05),( 9.3250E-03, 4.7024E-05),
     &  ( 1.0007E-02, 5.4153E-05),( 1.0796E-02, 6.3033E-05),
     &  ( 1.1720E-02, 7.4291E-05),( 1.2817E-02, 8.8856E-05),
     &  ( 1.4141E-02, 1.0816E-04),( 1.5769E-02, 1.3452E-04),
     &  ( 1.7821E-02, 1.7183E-04),( 2.0487E-02, 2.2710E-04),
     &  ( 2.4090E-02, 3.1406E-04),( 2.9230E-02, 4.6248E-04),
     &  ( 3.7155E-02, 7.4755E-04),( 5.0960E-02, 1.4077E-03),
     &  ( 8.1002E-02, 3.5681E-03),( 9.9629E-02, 1.4172E-04),
     &  ( 1.8976E-01, 1.4179E-04),( 2.6404E-01, 1.4181E-04),
     &  ( 3.1788E-01, 1.4182E-04),( 3.5954E-01, 1.4183E-04),
     &  ( 3.9377E-01, 1.4183E-04),( 4.2372E-01, 1.4184E-04),
     &  ( 4.5152E-01, 1.4184E-04),( 4.7086E-01, 1.4184E-04),
     &  ( 4.9056E-01, 1.4184E-04),( 5.0993E-01, 1.4184E-04),
     &  ( 5.1927E-01, 1.4184E-04),( 5.3236E-01, 1.4185E-04),
     &  ( 5.4020E-01, 1.4185E-04),( 5.4993E-01, 1.4185E-04),
     &  ( 5.5247E-01, 1.4185E-04),( 5.5622E-01, 1.4185E-04),
     &  ( 5.5778E-01, 1.4185E-04),( 5.5661E-01, 1.4185E-04),
     &  ( 5.5481E-01, 1.4185E-04),( 5.5211E-01, 1.4185E-04),
     &  ( 5.4353E-01, 1.4185E-04),( 5.3752E-01, 1.4185E-04),
     &  ( 5.3013E-01, 1.4185E-04),( 5.1109E-01, 1.4185E-04),
     &  ( 4.9927E-01, 1.4185E-04),( 4.8576E-01, 1.4186E-04),
     &  ( 4.7031E-01, 1.4186E-04),( 4.3406E-01, 1.4186E-04),
     &  ( 4.1278E-01, 1.4186E-04),( 3.8970E-01, 1.4186E-04),
     &  ( 3.3725E-01, 1.4186E-04),( 3.0822E-01, 1.4186E-04)/
  
         DATA ((CGS  (I,J), I=1401,1500), J=2,2) /
     &  ( 2.4433E-01, 1.4186E-04),( 1.7398E-01, 1.4186E-04),
     &  ( 1.8576E-02, 1.4186E-04),( 1.7167E-01, 1.4186E-04),
     &  ( 2.4220E-01, 1.4187E-04),( 3.0599E-01, 1.4187E-04),
     &  ( 3.6268E-01, 1.4187E-04),( 3.8817E-01, 1.4187E-04),
     &  ( 4.1137E-01, 1.4187E-04),( 4.3257E-01, 1.4187E-04),
     &  ( 4.6927E-01, 1.4187E-04),( 4.8469E-01, 1.4187E-04),
     &  ( 4.9846E-01, 1.4187E-04),( 5.1039E-01, 1.4187E-04),
     &  ( 5.2962E-01, 1.4187E-04),( 5.3702E-01, 1.4187E-04),
     &  ( 5.4319E-01, 1.4187E-04),( 5.5187E-01, 1.4187E-04),
     &  ( 5.5467E-01, 1.4187E-04),( 5.5753E-01, 1.4188E-04),
     &  ( 5.5779E-01, 1.4188E-04),( 5.5631E-01, 1.4188E-04),
     &  ( 5.5264E-01, 1.4188E-04),( 5.4722E-01, 1.4188E-04),
     &  ( 5.4043E-01, 1.4188E-04),( 5.3262E-01, 1.4188E-04),
     &  ( 5.1956E-01, 1.4188E-04),( 5.1028E-01, 1.4188E-04),
     &  ( 4.9087E-01, 1.4188E-04),( 4.7123E-01, 1.4189E-04),
     &  ( 4.5182E-01, 1.4189E-04),( 4.2401E-01, 1.4189E-04),
     &  ( 3.9403E-01, 1.4189E-04),( 3.5977E-01, 1.4190E-04),
     &  ( 3.1807E-01, 1.4190E-04),( 2.6418E-01, 1.4191E-04),
     &  ( 1.8875E-01, 1.4194E-04),( 1.0302E-01, 1.4200E-04),
     &  ( 5.8923E-02, 1.4210E-04),( 4.1226E-02, 1.4221E-04),
     &  ( 3.1698E-02, 1.4231E-04),( 2.5746E-02, 1.4242E-04),
     &  ( 2.1675E-02, 1.4252E-04),( 1.8716E-02, 1.4262E-04),
     &  ( 1.6468E-02, 1.4273E-04),( 1.4702E-02, 1.4283E-04),
     &  ( 1.3278E-02, 1.4294E-04),( 1.2106E-02, 1.4304E-04),
     &  ( 1.1124E-02, 1.4314E-04),( 1.0289E-02, 1.4325E-04),
     &  ( 9.5714E-03, 1.4335E-04),( 8.9472E-03, 1.4345E-04),
     &  ( 8.3995E-03, 1.4356E-04),( 7.9150E-03, 1.4366E-04),
     &  ( 7.4834E-03, 1.4377E-04),( 7.0965E-03, 1.4387E-04),
     &  ( 6.7477E-03, 1.4397E-04),( 6.4317E-03, 1.4408E-04),
     &  ( 6.1439E-03, 1.4418E-04),( 5.8809E-03, 1.4429E-04),
     &  ( 5.6395E-03, 1.4439E-04),( 5.4172E-03, 1.4449E-04),
     &  ( 5.2117E-03, 1.4460E-04),( 5.0214E-03, 1.4470E-04),
     &  ( 4.8444E-03, 1.4481E-04),( 4.6796E-03, 1.4491E-04),
     &  ( 4.5256E-03, 1.4501E-04),( 4.3815E-03, 1.4512E-04),
     &  ( 4.2463E-03, 1.4522E-04),( 4.1192E-03, 1.4533E-04),
     &  ( 3.9996E-03, 1.4543E-04),( 3.8867E-03, 1.4553E-04),
     &  ( 3.7800E-03, 1.4564E-04),( 3.6791E-03, 1.4574E-04),
     &  ( 3.5834E-03, 1.4585E-04),( 3.4926E-03, 1.4595E-04),
     &  ( 3.4063E-03, 1.4605E-04),( 3.3242E-03, 1.4616E-04),
     &  ( 3.2460E-03, 1.4626E-04),( 3.1714E-03, 1.4637E-04),
     &  ( 3.1002E-03, 1.4647E-04),( 3.0321E-03, 1.4657E-04),
     &  ( 2.9670E-03, 1.4668E-04),( 2.9046E-03, 1.4678E-04),
     &  ( 2.8449E-03, 1.4688E-04),( 2.7875E-03, 1.4699E-04),
     &  ( 2.7324E-03, 1.4709E-04),( 2.3170E-03, 1.4804E-04),
     &  ( 2.0623E-03, 1.4881E-04),( 1.8180E-03, 1.4975E-04),
     &  ( 1.5450E-03, 1.5117E-04),( 1.2894E-03, 1.5306E-04),
     &  ( 1.0370E-03, 1.5589E-04),( 8.9427E-04, 1.5826E-04),
     &  ( 7.0766E-04, 1.6062E-04),( 6.4420E-04, 1.6062E-04),
     &  ( 5.9477E-04, 1.6114E-04),( 5.5517E-04, 1.6167E-04),
     &  ( 5.2112E-04, 1.6219E-04),( 4.9575E-04, 1.6272E-04)/
  
         DATA ((CGS  (I,J), I=1501,1600), J=2,2) /
     &  ( 4.6169E-04, 1.6377E-04),( 4.2789E-04, 1.6482E-04),
     &  ( 3.9089E-04, 1.7007E-04),( 4.0509E-04, 1.7480E-04),
     &  ( 4.4945E-04, 1.7480E-04),( 6.0753E-04, 1.7953E-04),
     &  ( 9.1309E-04, 1.8898E-04),( 1.3473E-03, 1.9370E-04),
     &  ( 1.9392E-03, 1.9654E-04),( 2.7637E-03, 1.9843E-04),
     &  ( 4.8412E-03, 1.9961E-04),( 5.2358E-03, 1.9973E-04),
     &  ( 5.7006E-03, 1.9985E-04),( 5.8353E-03, 1.9988E-04),
     &  ( 6.1424E-03, 1.9994E-04),( 6.4836E-03, 2.0001E-04),
     &  ( 6.8650E-03, 2.0007E-04),( 7.2942E-03, 2.0014E-04),
     &  ( 7.7805E-03, 2.0020E-04),( 8.3364E-03, 2.0027E-04),
     &  ( 8.9779E-03, 2.0033E-04),( 9.7263E-03, 2.0040E-04),
     &  ( 1.0611E-02, 2.0046E-04),( 1.1672E-02, 2.0053E-04),
     &  ( 1.2970E-02, 2.0059E-04),( 1.4591E-02, 2.0066E-04),
     &  ( 1.6677E-02, 2.0072E-04),( 1.9457E-02, 2.0079E-04),
     &  ( 2.3349E-02, 2.0085E-04),( 2.9188E-02, 2.0092E-04),
     &  ( 3.8918E-02, 3.0364E-04),( 5.8375E-02, 5.5018E-04),
     &  ( 8.4474E-02, 1.0914E-03),( 8.8855E-02, 1.2038E-03),
     &  ( 9.3715E-02, 1.3356E-03),( 9.9136E-02, 1.4913E-03),
     &  ( 1.0522E-01, 1.6769E-03),( 1.1211E-01, 1.9006E-03),
     &  ( 1.1995E-01, 2.1732E-03),( 1.2897E-01, 2.5101E-03),
     &  ( 1.3947E-01, 2.9331E-03),( 1.5181E-01, 3.4738E-03),
     &  ( 1.6655E-01, 4.1801E-03),( 1.8445E-01, 5.1270E-03),
     &  ( 2.0665E-01, 6.4372E-03),( 2.3491E-01, 8.3227E-03),
     &  ( 2.7208E-01, 1.1176E-02),( 3.2312E-01, 1.5792E-02),
     &  ( 3.9749E-01, 2.3979E-02),( 5.1558E-01, 4.0624E-02),
     &  ( 7.2988E-01, 8.2880E-02),( 1.2147E+00, 2.4682E-01),
     &  ( 1.3846E+00, 3.3411E-01),( 1.5184E+00, 4.1873E-01),
     &  ( 1.6675E+00, 5.3649E-01),( 1.7926E+00, 6.6547E-01),
     &  ( 1.8828E+00, 7.9014E-01),( 1.9594E+00, 9.4559E-01),
     &  ( 1.9946E+00, 1.0696E+00),( 2.0086E+00, 1.2117E+00),
     &  ( 1.9910E+00, 1.3727E+00),( 1.9286E+00, 1.5513E+00),
     &  ( 1.8060E+00, 1.6749E+00),( 1.8060E+00, 1.6943E+00),
     &  ( 1.8060E+00, 1.7041E+00),( 1.8060E+00, 1.7236E+00),
     &  ( 1.8060E+00, 1.7314E+00),( 1.8060E+00, 1.7373E+00),
     &  ( 1.8060E+00, 1.7432E+00),( 1.7551E+00, 1.8021E+00),
     &  ( 1.6650E+00, 1.8907E+00),( 1.5445E+00, 1.9877E+00),
     &  ( 1.4168E+00, 2.0719E+00),( 1.2532E+00, 2.1600E+00),
     &  ( 1.0674E+00, 2.2396E+00),( 8.8234E-01, 2.3017E+00),
     &  ( 6.5954E-01, 2.3316E+00),( 6.5954E-01, 2.3577E+00),
     &  ( 3.7358E-01, 2.3799E+00),( 3.7358E-01, 2.4038E+00),
     &  ( 1.2551E-01, 2.4155E+00),( 1.2551E-01, 2.4226E+00),
     &  ( 1.2548E-01, 2.4246E+00),( 1.2548E-01, 2.4249E+00),
     &  ( 1.2548E-01, 2.4249E+00),( 1.2548E-01, 2.4250E+00),
     &  ( 1.2548E-01, 2.4249E+00),( 1.2548E-01, 2.4249E+00),
     &  ( 1.2548E-01, 2.4226E+00),( 3.7355E-01, 2.4155E+00),
     &  ( 3.7355E-01, 2.4038E+00),( 9.2479E-01, 2.2888E+00),
     &  ( 1.1254E+00, 2.2168E+00),( 1.4467E+00, 2.0536E+00),
     &  ( 1.5704E+00, 1.9685E+00),( 1.6865E+00, 1.8711E+00),
     &  ( 1.7814E+00, 1.7726E+00),( 1.8501E+00, 1.6846E+00),
     &  ( 1.9094E+00, 1.5888E+00),( 1.9492E+00, 1.5051E+00)/
  
         DATA ((CGS  (I,J), I=1601,1700), J=2,2) /
     &  ( 1.9802E+00, 1.4158E+00),( 1.9977E+00, 1.3390E+00),
     &  ( 2.0072E+00, 1.2580E+00),( 2.0083E+00, 1.1892E+00),
     &  ( 2.0024E+00, 1.1172E+00),( 1.9919E+00, 1.0564E+00),
     &  ( 1.9572E+00, 9.3986E-01),( 1.9338E+00, 8.8461E-01),
     &  ( 1.9079E+00, 8.3325E-01),( 1.8828E+00, 7.9015E-01),
     &  ( 1.8265E+00, 7.0803E-01),( 1.7957E+00, 6.6921E-01),
     &  ( 1.7457E+00, 6.1271E-01),( 1.6675E+00, 5.3650E-01),
     &  ( 1.3846E+00, 3.3412E-01),( 1.1655E+00, 2.2500E-01),
     &  ( 9.9961E-01, 1.6081E-01),( 8.7216E-01, 1.2026E-01),
     &  ( 7.7211E-01, 9.3158E-02),( 6.9190E-01, 7.4205E-02),
     &  ( 6.1181E-01, 5.7614E-02),( 4.8677E-01, 3.6142E-02),
     &  ( 4.5293E-01, 3.1228E-02),( 4.2344E-01, 2.7248E-02),
     &  ( 3.9751E-01, 2.3982E-02),( 3.5899E-01, 1.9523E-02),
     &  ( 2.9714E-01, 1.3342E-02),( 2.5339E-01, 9.6887E-03),
     &  ( 2.2084E-01, 7.3534E-03),( 1.9568E-01, 5.7710E-03),
     &  ( 1.7566E-01, 4.6498E-03),( 1.5935E-01, 3.8268E-03),
     &  ( 1.4581E-01, 3.2051E-03),( 1.3438E-01, 2.7241E-03),
     &  ( 1.2462E-01, 2.3444E-03),( 1.1618E-01, 2.0397E-03),
     &  ( 1.0880E-01, 1.7915E-03),( 1.0231E-01, 1.5867E-03),
     &  ( 9.6549E-02, 1.4159E-03),( 9.1402E-02, 1.2720E-03),
     &  ( 8.6775E-02, 1.1497E-03),( 5.8394E-02, 5.5059E-04),
     &  ( 3.8938E-02, 3.0407E-04),( 2.9207E-02, 2.3876E-04),
     &  ( 1.9476E-02, 2.0157E-04),( 1.4611E-02, 2.0170E-04),
     &  ( 1.1692E-02, 2.0183E-04),( 9.7456E-03, 2.0196E-04),
     &  ( 8.3558E-03, 2.0209E-04),( 7.3136E-03, 2.0222E-04),
     &  ( 6.5031E-03, 2.0235E-04),( 5.8548E-03, 2.0248E-04),
     &  ( 5.4872E-03, 2.0257E-04),( 5.0582E-03, 2.0268E-04),
     &  ( 4.6918E-03, 2.0280E-04),( 4.3752E-03, 2.0292E-04),
     &  ( 4.0989E-03, 2.0304E-04),( 3.8558E-03, 2.0316E-04),
     &  ( 2.9764E-03, 2.0355E-04),( 2.4275E-03, 2.0394E-04),
     &  ( 2.0537E-03, 2.0434E-04),( 1.7838E-03, 2.0473E-04),
     &  ( 1.5817E-03, 2.0513E-04),( 1.4279E-03, 2.0552E-04),
     &  ( 1.2990E-03, 2.0591E-04),( 1.1933E-03, 2.0631E-04),
     &  ( 5.7529E-04, 2.0789E-04),( 5.5230E-04, 2.2442E-04),
     &  ( 5.7771E-04, 2.2773E-04),( 5.9202E-04, 2.3104E-04),
     &  ( 6.2761E-04, 2.3435E-04),( 6.9012E-04, 2.3766E-04),
     &  ( 7.2717E-04, 2.3931E-04),( 7.8019E-04, 2.4096E-04),
     &  ( 9.1742E-04, 2.3482E-04),( 1.1477E-03, 2.2868E-04),
     &  ( 1.5714E-03, 2.2254E-04),( 2.5757E-03, 2.1640E-04),
     &  ( 3.5490E-03, 2.1382E-04),( 3.8012E-03, 2.1337E-04),
     &  ( 4.0923E-03, 2.1292E-04),( 4.4321E-03, 2.1246E-04),
     &  ( 4.8338E-03, 2.1201E-04),( 5.3160E-03, 2.1156E-04),
     &  ( 5.9055E-03, 2.1111E-04),( 6.6426E-03, 2.1066E-04),
     &  ( 7.5906E-03, 2.1021E-04),( 8.8547E-03, 2.0976E-04),
     &  ( 1.0625E-02, 2.0931E-04),( 1.3281E-02, 2.1070E-04),
     &  ( 1.7707E-02, 2.1417E-04),( 1.8477E-02, 2.1517E-04),
     &  ( 1.9317E-02, 2.1642E-04),( 2.0237E-02, 2.1799E-04),
     &  ( 2.1249E-02, 2.1998E-04),( 2.2367E-02, 2.2253E-04),
     &  ( 2.3610E-02, 2.2582E-04),( 2.4998E-02, 2.3010E-04),
     &  ( 2.6561E-02, 2.3575E-04),( 2.8331E-02, 2.4329E-04)/
  
         DATA ((CGS  (I,J), I=1701,1800), J=2,2) /
     &  ( 3.0355E-02, 2.5346E-04),( 3.2690E-02, 2.6735E-04),
     &  ( 3.5414E-02, 2.8659E-04),( 3.8633E-02, 3.1360E-04),
     &  ( 4.2496E-02, 3.5205E-04),( 4.7217E-02, 4.0778E-04),
     &  ( 4.8692E-02, 4.2711E-04),( 5.3117E-02, 4.9031E-04),
     &  ( 6.0702E-02, 6.1617E-04),( 7.0813E-02, 8.1646E-04),
     &  ( 8.4965E-02, 1.1558E-03),( 1.0618E-01, 1.7882E-03),
     &  ( 1.4149E-01, 3.1625E-03),( 2.1188E-01, 7.0918E-03),
     &  ( 4.1992E-01, 2.8101E-02),( 4.9923E-01, 3.9925E-02),
     &  ( 7.0416E-01, 8.0883E-02),( 8.6000E-01, 1.2296E-01),
     &  ( 9.8840E-01, 1.6565E-01),( 1.1005E+00, 2.0963E-01),
     &  ( 1.1999E+00, 2.5467E-01),( 1.2891E+00, 3.0065E-01),
     &  ( 1.3688E+00, 3.4694E-01),( 1.4426E+00, 3.9504E-01),
     &  ( 1.5124E+00, 4.4600E-01),( 1.5761E+00, 4.9834E-01),
     &  ( 1.6322E+00, 5.5009E-01),( 1.6841E+00, 6.0408E-01),
     &  ( 1.7308E+00, 6.5941E-01),( 1.7718E+00, 7.1499E-01),
     &  ( 1.8107E+00, 7.7668E-01),( 1.8426E+00, 8.3718E-01),
     &  ( 1.8674E+00, 8.9489E-01),( 1.9048E+00, 9.5738E-01),
     &  ( 1.9048E+00, 1.0249E+00),( 1.9149E+00, 1.0977E+00),
     &  ( 1.9132E+00, 1.1645E+00),( 1.9132E+00, 1.2353E+00),
     &  ( 1.8790E+00, 1.3100E+00),( 1.8790E+00, 1.3886E+00),
     &  ( 1.8461E+00, 1.4706E+00),( 1.7519E+00, 1.5413E+00),
     &  ( 1.7519E+00, 1.6282E+00),( 1.6792E+00, 1.7166E+00),
     &  ( 1.4613E+00, 1.8053E+00),( 1.4613E+00, 1.9072E+00),
     &  ( 1.3072E+00, 2.0046E+00),( 1.0989E+00, 2.1063E+00),
     &  ( 8.2584E-01, 2.2024E+00),( 2.9544E-04, 2.3133E+00),
     &  ( 2.9544E-04, 2.3153E+00),( 3.7383E-01, 2.2931E+00),
     &  ( 8.2583E-01, 2.2024E+00),( 1.3072E+00, 2.1063E+00),
     &  ( 1.3072E+00, 2.0046E+00),( 1.4613E+00, 1.9072E+00),
     &  ( 1.6791E+00, 1.8053E+00),( 1.6791E+00, 1.7166E+00),
     &  ( 1.7519E+00, 1.6282E+00),( 1.8461E+00, 1.5413E+00),
     &  ( 1.8461E+00, 1.4706E+00),( 1.8789E+00, 1.3886E+00),
     &  ( 1.9132E+00, 1.3100E+00),( 1.9132E+00, 1.2353E+00),
     &  ( 1.9149E+00, 1.1645E+00),( 1.9149E+00, 1.0977E+00),
     &  ( 1.9048E+00, 1.0249E+00),( 1.8886E+00, 9.5738E-01),
     &  ( 1.8426E+00, 8.9490E-01),( 1.8426E+00, 8.3719E-01),
     &  ( 1.8107E+00, 7.7668E-01),( 1.7718E+00, 7.1499E-01),
     &  ( 1.7308E+00, 6.5942E-01),( 1.6841E+00, 6.0409E-01),
     &  ( 1.6322E+00, 5.5010E-01),( 1.5761E+00, 4.9834E-01),
     &  ( 1.5124E+00, 4.4600E-01),( 1.4427E+00, 3.9505E-01),
     &  ( 1.3688E+00, 3.4694E-01),( 1.2891E+00, 3.0066E-01),
     &  ( 1.1999E+00, 2.5468E-01),( 1.1005E+00, 2.0964E-01),
     &  ( 9.8841E-01, 1.6565E-01),( 8.6001E-01, 1.2297E-01),
     &  ( 7.0417E-01, 8.0886E-02),( 4.9924E-01, 3.9927E-02),
     &  ( 4.2748E-01, 2.9136E-02),( 4.1403E-01, 2.7308E-02),
     &  ( 3.9733E-01, 2.5127E-02),( 3.5122E-01, 1.9586E-02),
     &  ( 3.0967E-01, 1.5197E-02),( 2.1188E-01, 7.0917E-03),
     &  ( 1.4150E-01, 3.1630E-03),( 1.0619E-01, 1.7885E-03),
     &  ( 8.4974E-02, 1.1559E-03),( 7.0825E-02, 8.1653E-04),
     &  ( 6.0713E-02, 6.1611E-04),( 5.3128E-02, 4.9009E-04),
     &  ( 4.7228E-02, 4.0741E-04),( 4.2507E-02, 3.5151E-04)/
  
         DATA ((CGS  (I,J), I=1801,1900), J=2,2) /
     &  ( 3.8644E-02, 3.1288E-04),( 3.5425E-02, 2.8570E-04),
     &  ( 3.2701E-02, 2.6629E-04),( 3.0366E-02, 2.5223E-04),
     &  ( 2.8343E-02, 2.4190E-04),( 2.6572E-02, 2.3421E-04),
     &  ( 1.7718E-02, 2.1156E-04),( 1.3292E-02, 2.0713E-04),
     &  ( 1.0636E-02, 2.0558E-04),( 8.8657E-03, 2.0473E-04),
     &  ( 7.6014E-03, 2.0391E-04),( 6.6534E-03, 2.0346E-04),
     &  ( 5.9162E-03, 2.0301E-04),( 4.8443E-03, 2.0211E-04),
     &  ( 4.1027E-03, 2.0120E-04),( 3.8115E-03, 2.0075E-04),
     &  ( 3.5592E-03, 2.0030E-04),( 2.6535E-03, 1.9797E-04),
     &  ( 1.9935E-03, 1.9490E-04),( 1.6016E-03, 1.9183E-04),
     &  ( 1.3431E-03, 1.8876E-04),( 1.1601E-03, 1.8569E-04),
     &  ( 1.0243E-03, 1.8261E-04),( 9.1990E-04, 1.7954E-04),
     &  ( 8.3746E-04, 1.8220E-04),( 7.7101E-04, 1.8485E-04),
     &  ( 7.1665E-04, 1.8753E-04),( 6.7169E-04, 1.9019E-04),
     &  ( 6.3421E-04, 1.9284E-04),( 6.0286E-04, 1.9550E-04),
     &  ( 5.7669E-04, 1.9815E-04),( 5.5504E-04, 2.0081E-04),
     &  ( 5.3758E-04, 2.0346E-04),( 5.2425E-04, 2.0612E-04),
     &  ( 5.1552E-04, 2.0877E-04),( 5.1281E-04, 2.1143E-04),
     &  ( 5.1146E-04, 2.1408E-04),( 4.9966E-04, 2.1674E-04),
     &  ( 5.0446E-04, 2.1857E-04),( 5.9399E-04, 2.6871E-04),
     &  ( 6.1510E-04, 2.8503E-04),( 6.7844E-04, 3.0208E-04),
     &  ( 7.3671E-04, 3.2161E-04),( 7.8581E-04, 3.4373E-04),
     &  ( 8.2998E-04, 3.6818E-04),( 8.6728E-04, 3.9468E-04),
     &  ( 8.9985E-04, 4.2288E-04),( 9.2772E-04, 4.5226E-04),
     &  ( 9.5078E-04, 4.8283E-04),( 9.7010E-04, 5.1444E-04),
     &  ( 9.8555E-04, 5.4665E-04),( 9.9702E-04, 5.7924E-04),
     &  ( 1.0051E-03, 6.1223E-04),( 1.0099E-03, 6.4591E-04),
     &  ( 1.0110E-03, 6.7976E-04),( 1.0091E-03, 7.1323E-04),
     &  ( 1.0040E-03, 7.4698E-04),( 9.9538E-04, 7.8131E-04),
     &  ( 9.8371E-04, 8.1524E-04),( 9.6918E-04, 8.4839E-04),
     &  ( 9.5071E-04, 8.8257E-04),( 9.2959E-04, 9.1536E-04),
     &  ( 9.0454E-04, 9.4867E-04),( 8.7591E-04, 9.8148E-04),
     &  ( 8.4315E-04, 1.0142E-03),( 8.0612E-04, 1.0467E-03),
     &  ( 7.6483E-04, 1.0783E-03),( 7.1950E-04, 1.1089E-03),
     &  ( 6.6691E-04, 1.1398E-03),( 6.0839E-04, 1.1696E-03),
     &  ( 5.4360E-04, 1.1977E-03),( 4.6884E-04, 1.2249E-03),
     &  ( 3.8626E-04, 1.2491E-03),( 3.4265E-04, 1.2599E-03),
     &  ( 5.2063E-04, 1.2072E-03),( 6.1279E-04, 1.1683E-03),
     &  ( 6.8352E-04, 1.1315E-03),( 7.3990E-04, 1.0967E-03),
     &  ( 7.8802E-04, 1.0623E-03),( 8.2936E-04, 1.0283E-03),
     &  ( 8.6362E-04, 9.9588E-04),( 8.9371E-04, 9.6337E-04),
     &  ( 9.1971E-04, 9.3102E-04),( 9.4184E-04, 8.9909E-04),
     &  ( 9.6038E-04, 8.6778E-04),( 9.7577E-04, 8.3659E-04),
     &  ( 9.8798E-04, 8.0639E-04),( 9.9779E-04, 7.7538E-04),
     &  ( 1.0045E-03, 7.4571E-04),( 1.0089E-03, 7.1574E-04),
     &  ( 1.0107E-03, 6.8577E-04),( 1.0098E-03, 6.5662E-04),
     &  ( 1.0064E-03, 6.2802E-04),( 1.0005E-03, 5.9936E-04),
     &  ( 9.9171E-04, 5.7113E-04),( 9.8032E-04, 5.4373E-04),
     &  ( 9.6627E-04, 5.1692E-04),( 9.4819E-04, 4.9069E-04),
     &  ( 9.2790E-04, 4.6523E-04),( 9.0520E-04, 4.4111E-04)/
  
         DATA ((CGS  (I,J), I=1901,2000), J=2,2) /
     &  ( 8.7741E-04, 4.1788E-04),( 8.4599E-04, 3.9620E-04),
     &  ( 8.1081E-04, 3.7634E-04),( 7.6930E-04, 3.5874E-04),
     &  ( 7.2448E-04, 3.4383E-04),( 6.7115E-04, 3.3234E-04),
     &  ( 6.1651E-04, 3.2539E-04),( 5.4415E-04, 3.2572E-04),
     &  ( 4.7639E-04, 3.5437E-04),( 4.7276E-04, 3.5611E-04),
     &  ( 4.1780E-04, 3.6967E-04),( 4.0143E-04, 3.7971E-04),
     &  ( 3.9819E-04, 3.8769E-04),( 3.9420E-04, 3.9438E-04),
     &  ( 3.8300E-04, 4.0018E-04),( 3.7567E-04, 4.0539E-04),
     &  ( 3.7301E-04, 4.1016E-04),( 3.7161E-04, 4.1462E-04),
     &  ( 3.7092E-04, 4.1885E-04),( 3.6954E-04, 4.2293E-04),
     &  ( 3.6753E-04, 4.2689E-04),( 3.6660E-04, 4.3077E-04),
     &  ( 3.6536E-04, 4.3460E-04),( 3.6509E-04, 4.3841E-04),
     &  ( 3.6486E-04, 4.4220E-04),( 3.6334E-04, 4.4599E-04),
     &  ( 3.6227E-04, 4.4981E-04),( 3.6068E-04, 4.5365E-04),
     &  ( 3.5932E-04, 4.5754E-04),( 3.5811E-04, 4.6146E-04),
     &  ( 3.5688E-04, 4.6544E-04),( 3.5463E-04, 4.6947E-04),
     &  ( 3.5239E-04, 4.7356E-04),( 3.5016E-04, 4.7773E-04),
     &  ( 3.4788E-04, 4.8197E-04),( 3.4566E-04, 4.8628E-04),
     &  ( 3.4365E-04, 4.9067E-04),( 3.4221E-04, 4.9519E-04),
     &  ( 3.3920E-04, 4.9978E-04),( 3.3669E-04, 5.0453E-04),
     &  ( 3.3730E-04, 5.0940E-04),( 3.2210E-04, 5.1448E-04),
     &  ( 3.0879E-04, 5.1984E-04),( 3.0331E-04, 5.2567E-04),
     &  ( 2.8029E-04, 5.3434E-04),( 3.0178E-04, 5.3566E-04),
     &  ( 3.1287E-04, 5.3459E-04),( 3.1835E-04, 5.3319E-04),
     &  ( 3.2914E-04, 5.3166E-04),( 3.3738E-04, 5.3007E-04),
     &  ( 3.3846E-04, 5.2844E-04),( 3.4071E-04, 5.2682E-04),
     &  ( 3.4407E-04, 5.2522E-04),( 3.4637E-04, 5.2364E-04),
     &  ( 3.4888E-04, 5.2210E-04),( 3.5169E-04, 5.2060E-04),
     &  ( 3.5461E-04, 5.1915E-04),( 3.5757E-04, 5.1776E-04),
     &  ( 3.6052E-04, 5.1643E-04),( 3.6349E-04, 5.1516E-04),
     &  ( 3.6642E-04, 5.1396E-04),( 3.6943E-04, 5.1284E-04),
     &  ( 3.7252E-04, 5.1179E-04),( 3.7577E-04, 5.1084E-04),
     &  ( 3.7863E-04, 5.0996E-04),( 3.8137E-04, 5.0919E-04),
     &  ( 3.8447E-04, 5.0851E-04),( 3.8802E-04, 5.0794E-04),
     &  ( 3.9222E-04, 5.0748E-04),( 3.9672E-04, 5.0714E-04),
     &  ( 4.0090E-04, 5.0693E-04),( 4.0549E-04, 5.0685E-04),
     &  ( 4.1171E-04, 5.0693E-04),( 4.2022E-04, 5.0718E-04),
     &  ( 4.3122E-04, 5.0762E-04),( 4.4587E-04, 5.0826E-04),
     &  ( 4.6634E-04, 5.0913E-04),( 4.6673E-04, 5.1028E-04),
     &  ( 4.5087E-04, 5.1176E-04),( 4.3159E-04, 5.1364E-04),
     &  ( 4.3366E-04, 5.3344E-04),( 4.4082E-04, 5.3507E-04),
     &  ( 4.4778E-04, 5.3671E-04),( 4.5453E-04, 5.3838E-04),
     &  ( 4.6089E-04, 5.4006E-04),( 4.6683E-04, 5.4176E-04),
     &  ( 4.7252E-04, 5.4347E-04),( 4.7799E-04, 5.4520E-04),
     &  ( 4.8327E-04, 5.4696E-04),( 4.7314E-04, 5.4873E-04),
     &  ( 4.6311E-04, 5.5053E-04),( 4.5457E-04, 5.5235E-04),
     &  ( 4.4723E-04, 5.5419E-04),( 4.4065E-04, 5.5605E-04),
     &  ( 4.3458E-04, 5.5794E-04),( 4.2913E-04, 5.5985E-04),
     &  ( 4.2424E-04, 5.6177E-04),( 4.1975E-04, 5.6374E-04),
     &  ( 4.1559E-04, 5.6574E-04),( 4.1151E-04, 5.6775E-04)/
  
         DATA ((CGS  (I,J), I=2001,2100), J=2,2) /
     &  ( 4.0751E-04, 5.6982E-04),( 4.0380E-04, 5.7189E-04),
     &  ( 4.0048E-04, 5.7400E-04),( 3.9702E-04, 5.7615E-04),
     &  ( 3.9353E-04, 5.7832E-04),( 3.9107E-04, 5.8054E-04),
     &  ( 3.8712E-04, 5.8278E-04),( 3.8531E-04, 5.8508E-04),
     &  ( 3.7732E-04, 5.8743E-04),( 3.6973E-04, 5.8983E-04),
     &  ( 3.6372E-04, 5.9228E-04),( 3.6057E-04, 5.9481E-04),
     &  ( 3.5117E-04, 5.9745E-04),( 3.4075E-04, 6.0023E-04),
     &  ( 3.3429E-04, 6.0328E-04),( 3.2607E-04, 6.0787E-04),
     &  ( 3.3384E-04, 6.0856E-04),( 3.4019E-04, 6.0777E-04),
     &  ( 3.5054E-04, 6.0675E-04),( 3.5996E-04, 6.0565E-04),
     &  ( 3.6313E-04, 6.0450E-04),( 3.6920E-04, 6.0333E-04),
     &  ( 3.7690E-04, 6.0214E-04),( 3.8501E-04, 6.0095E-04),
     &  ( 3.8679E-04, 5.9978E-04),( 3.9077E-04, 5.9862E-04),
     &  ( 3.9318E-04, 5.9747E-04),( 3.9661E-04, 5.9634E-04),
     &  ( 4.0000E-04, 5.9523E-04),( 4.0320E-04, 5.9415E-04),
     &  ( 4.0676E-04, 5.9310E-04),( 4.1058E-04, 5.9206E-04),
     &  ( 4.1438E-04, 5.9107E-04),( 4.1813E-04, 5.9011E-04),
     &  ( 4.2222E-04, 5.8916E-04),( 4.2656E-04, 5.8827E-04),
     &  ( 4.3132E-04, 5.8741E-04),( 4.3652E-04, 5.8658E-04),
     &  ( 4.4199E-04, 5.8579E-04),( 4.4789E-04, 5.8504E-04),
     &  ( 4.5463E-04, 5.8419E-04),( 4.6236E-04, 5.8336E-04),
     &  ( 4.7050E-04, 5.8257E-04),( 4.7195E-04, 5.8183E-04),
     &  ( 4.7490E-04, 5.8112E-04),( 4.7984E-04, 5.8047E-04),
     &  ( 4.8755E-04, 5.7985E-04),( 4.9887E-04, 5.7928E-04),
     &  ( 5.0987E-04, 5.7877E-04),( 5.0430E-04, 5.7830E-04),
     &  ( 4.9871E-04, 5.7788E-04),( 4.7339E-04, 5.7673E-04),
     &  ( 5.1471E-04, 5.7950E-04),( 5.4208E-04, 5.8674E-04),
     &  ( 5.5157E-04, 5.9492E-04),( 5.5866E-04, 6.0394E-04),
     &  ( 5.6489E-04, 6.1273E-04),( 5.7148E-04, 6.2201E-04),
     &  ( 5.7841E-04, 6.3093E-04),( 5.8484E-04, 6.4027E-04),
     &  ( 5.9110E-04, 6.4963E-04),( 5.9617E-04, 6.5858E-04),
     &  ( 6.0195E-04, 6.6795E-04),( 6.0722E-04, 6.7691E-04),
     &  ( 5.7591E-04, 6.8628E-04),( 5.4597E-04, 6.9524E-04),
     &  ( 5.1466E-04, 7.0462E-04),( 4.8472E-04, 7.1357E-04),
     &  ( 4.5341E-04, 7.2295E-04),( 4.2347E-04, 7.3192E-04),
     &  ( 3.9216E-04, 7.4129E-04),( 3.6134E-04, 0.0000E+00),
     &  ( 3.3043E-04, 0.0000E+00),( 2.9812E-04, 0.0000E+00),
     &  ( 2.6721E-04, 0.0000E+00),( 2.3489E-04, 0.0000E+00),
     &  ( 2.0398E-04, 0.0000E+00),( 1.7167E-04, 0.0000E+00),
     &  ( 1.6478E-04, 0.0000E+00),( 1.5895E-04, 0.0000E+00),
     &  ( 1.5433E-04, 0.0000E+00),( 1.5024E-04, 0.0000E+00),
     &  ( 1.4688E-04, 0.0000E+00),( 1.4383E-04, 0.0000E+00),
     &  ( 1.4126E-04, 0.0000E+00),( 1.3887E-04, 0.0000E+00),
     &  ( 1.3674E-04, 0.0000E+00),( 1.3490E-04, 0.0000E+00),
     &  ( 1.3315E-04, 0.0000E+00),( 1.3162E-04, 0.0000E+00),
     &  ( 1.3016E-04, 0.0000E+00),( 1.2887E-04, 0.0000E+00),
     &  ( 1.2762E-04, 0.0000E+00),( 1.2651E-04, 0.0000E+00),
     &  ( 1.2542E-04, 0.0000E+00),( 1.2445E-04, 0.0000E+00),
     &  ( 1.2350E-04, 0.0000E+00),( 1.2265E-04, 0.0000E+00),
     &  ( 1.2185E-04, 0.0000E+00),( 1.2105E-04, 0.0000E+00)/
  
         DATA ((CGS  (I,J), I=2101,2193), J=2,2) /
     &  ( 1.2033E-04, 0.0000E+00),( 1.1962E-04, 0.0000E+00),
     &  ( 1.1897E-04, 0.0000E+00),( 1.1832E-04, 0.0000E+00),
     &  ( 1.1773E-04, 0.0000E+00),( 1.1715E-04, 0.0000E+00),
     &  ( 1.1661E-04, 0.0000E+00),( 1.1607E-04, 0.0000E+00),
     &  ( 1.1558E-04, 0.0000E+00),( 1.1509E-04, 0.0000E+00),
     &  ( 1.1462E-04, 0.0000E+00),( 1.1418E-04, 0.0000E+00),
     &  ( 1.1374E-04, 0.0000E+00),( 1.1334E-04, 0.0000E+00),
     &  ( 1.1294E-04, 0.0000E+00),( 1.1256E-04, 0.0000E+00),
     &  ( 1.1218E-04, 0.0000E+00),( 1.1183E-04, 0.0000E+00),
     &  ( 1.1148E-04, 0.0000E+00),( 1.1115E-04, 0.0000E+00),
     &  ( 1.1082E-04, 0.0000E+00),( 1.1052E-04, 0.0000E+00),
     &  ( 1.1022E-04, 0.0000E+00),( 1.0992E-04, 0.0000E+00),
     &  ( 1.0964E-04, 0.0000E+00),( 1.0935E-04, 0.0000E+00),
     &  ( 1.0909E-04, 0.0000E+00),( 1.0882E-04, 0.0000E+00),
     &  ( 1.0857E-04, 0.0000E+00),( 1.0832E-04, 0.0000E+00),
     &  ( 1.0808E-04, 0.0000E+00),( 1.0784E-04, 0.0000E+00),
     &  ( 1.0762E-04, 0.0000E+00),( 1.0739E-04, 0.0000E+00),
     &  ( 1.0717E-04, 0.0000E+00),( 1.0696E-04, 0.0000E+00),
     &  ( 1.0675E-04, 0.0000E+00),( 1.0649E-04, 0.0000E+00),
     &  ( 1.0633E-04, 0.0000E+00),( 1.0617E-04, 0.0000E+00),
     &  ( 1.0601E-04, 0.0000E+00),( 1.0585E-04, 0.0000E+00),
     &  ( 1.0569E-04, 0.0000E+00),( 1.0554E-04, 0.0000E+00),
     &  ( 1.0537E-04, 0.0000E+00),( 1.0522E-04, 0.0000E+00),
     &  ( 1.0505E-04, 0.0000E+00),( 1.0490E-04, 0.0000E+00),
     &  ( 1.0474E-04, 0.0000E+00),( 1.0458E-04, 0.0000E+00),
     &  ( 1.0443E-04, 0.0000E+00),( 1.0426E-04, 0.0000E+00),
     &  ( 1.0411E-04, 0.0000E+00),( 1.0394E-04, 0.0000E+00),
     &  ( 1.0379E-04, 0.0000E+00),( 1.0363E-04, 0.0000E+00),
     &  ( 1.0347E-04, 0.0000E+00),( 1.0331E-04, 0.0000E+00),
     &  ( 1.0315E-04, 0.0000E+00),( 1.0299E-04, 0.0000E+00),
     &  ( 1.0182E-04, 0.0000E+00),( 1.0065E-04, 0.0000E+00),
     &  ( 1.0051E-04, 0.0000E+00),( 9.5835E-05, 0.0000E+00),
     &  ( 9.4564E-05, 0.0000E+00),( 9.2334E-05, 0.0000E+00),
     &  ( 9.1501E-05, 0.0000E+00),( 9.1466E-05, 0.0000E+00),
     &  ( 9.0644E-05, 0.0000E+00),( 9.0642E-05, 0.0000E+00),
     &  ( 9.0178E-05, 0.0000E+00),( 9.0163E-05, 0.0000E+00),
     &  ( 9.0153E-05, 0.0000E+00),( 8.9959E-05, 0.0000E+00),
     &  ( 8.9843E-05, 0.0000E+00),( 8.9823E-05, 0.0000E+00),
     &  ( 8.9791E-05, 0.0000E+00),( 8.9744E-05, 0.0000E+00),
     &  ( 8.9712E-05, 0.0000E+00),( 8.9693E-05, 0.0000E+00),
     &  ( 8.9514E-05, 0.0000E+00),( 8.9505E-05, 0.0000E+00),
     &  ( 8.9457E-05, 0.0000E+00),( 8.9448E-05, 0.0000E+00),
     &  ( 8.9411E-05, 0.0000E+00),( 8.9396E-05, 0.0000E+00),
     &  ( 8.9384E-05, 0.0000E+00),( 8.9372E-05, 0.0000E+00),
     &  ( 8.9342E-05, 0.0000E+00),( 8.9299E-05, 0.0000E+00),
     &  ( 8.9281E-05, 0.0000E+00),( 8.9170E-05, 0.0000E+00),
     &  ( 8.9084E-05, 0.0000E+00)/
  
         DATA ((CGS  (I,J), I=   1, 100), J=3,3) /
     &  ( 9.3276E-06, 0.0000E+00),( 9.9085E-06, 1.1123E-11),
     &  ( 1.0557E-05, 7.4107E-10),( 1.1289E-05, 2.7914E-09),
     &  ( 1.2167E-05, 7.5836E-09),( 1.3239E-05, 1.6680E-08),
     &  ( 1.4523E-05, 3.1895E-08),( 1.5395E-05, 5.6708E-06),
     &  ( 1.5827E-05, 5.6562E-06),( 1.6713E-05, 5.7364E-06),
     &  ( 1.6563E-05, 6.8421E-06),( 1.6408E-05, 7.9382E-06),
     &  ( 1.6240E-05, 8.8671E-06),( 1.6100E-05, 9.1902E-06),
     &  ( 1.5984E-05, 6.9366E-06),( 1.5932E-05, 6.9460E-06),
     &  ( 1.6126E-05, 6.1735E-06),( 1.6418E-05, 6.7572E-06),
     &  ( 1.6754E-05, 7.3142E-06),( 1.7259E-05, 8.0343E-06),
     &  ( 1.7633E-05, 7.7757E-06),( 1.8026E-05, 7.9572E-06),
     &  ( 1.8290E-05, 8.3189E-06),( 1.8766E-05, 9.1146E-06),
     &  ( 1.9185E-05, 9.1244E-06),( 1.9573E-05, 8.3908E-06),
     &  ( 2.0108E-05, 8.0484E-06),( 2.0423E-05, 8.2278E-06),
     &  ( 2.0587E-05, 8.3111E-06),( 2.1126E-05, 7.4294E-06),
     &  ( 2.1666E-05, 7.8188E-06),( 2.2203E-05, 8.1497E-06),
     &  ( 2.2778E-05, 8.5312E-06),( 2.3307E-05, 8.8579E-06),
     &  ( 2.3828E-05, 9.2725E-06),( 2.4348E-05, 9.5467E-06),
     &  ( 2.4867E-05, 9.7360E-06),( 2.5412E-05, 9.9555E-06),
     &  ( 2.6012E-05, 1.0382E-05),( 2.6666E-05, 1.0496E-05),
     &  ( 2.7184E-05, 1.0590E-05),( 2.7908E-05, 1.0800E-05),
     &  ( 2.8708E-05, 1.1268E-05),( 2.9363E-05, 1.1471E-05),
     &  ( 3.0318E-05, 1.1681E-05),( 3.1349E-05, 1.1921E-05),
     &  ( 3.2141E-05, 1.2067E-05),( 3.3175E-05, 1.2258E-05),
     &  ( 3.4014E-05, 1.2716E-05),( 3.5161E-05, 1.4211E-05),
     &  ( 4.1282E-05, 1.7158E-05),( 4.3123E-05, 3.0293E-05),
     &  ( 4.1747E-05, 3.4850E-05),( 3.9478E-05, 4.1268E-05),
     &  ( 4.0109E-05, 3.6018E-05),( 4.0568E-05, 3.2882E-05),
     &  ( 4.1939E-05, 3.4538E-05),( 4.4809E-05, 3.5561E-05),
     &  ( 4.8492E-05, 3.7461E-05),( 5.1936E-05, 4.0186E-05),
     &  ( 5.5312E-05, 4.3257E-05),( 5.6501E-05, 4.5315E-05),
     &  ( 5.8472E-05, 4.7184E-05),( 6.1801E-05, 5.1690E-05),
     &  ( 6.4697E-05, 5.4749E-05),( 6.7508E-05, 6.0393E-05),
     &  ( 6.9197E-05, 6.5873E-05),( 7.0424E-05, 7.9846E-05),
     &  ( 7.0911E-05, 8.0119E-05),( 7.1600E-05, 7.5285E-05),
     &  ( 7.1853E-05, 8.0273E-05),( 7.0982E-05, 8.4707E-05),
     &  ( 7.1058E-05, 1.1467E-04),( 7.0977E-05, 1.0160E-04),
     &  ( 6.9536E-05, 1.0894E-04),( 6.8477E-05, 1.1385E-04),
     &  ( 6.6234E-05, 1.2391E-04),( 6.4271E-05, 1.3243E-04),
     &  ( 6.2943E-05, 1.4228E-04),( 6.3218E-05, 1.4230E-04),
     &  ( 6.2169E-05, 1.5241E-04),( 6.1771E-05, 1.4745E-04),
     &  ( 6.2384E-05, 1.4716E-04),( 6.3855E-05, 1.4676E-04),
     &  ( 6.8283E-05, 1.4593E-04),( 7.7126E-05, 1.5668E-04),
     &  ( 8.4221E-05, 1.6918E-04),( 8.6976E-05, 1.8275E-04),
     &  ( 8.8774E-05, 1.9673E-04),( 8.9065E-05, 2.1180E-04),
     &  ( 8.8062E-05, 2.2409E-04),( 9.1206E-05, 2.3743E-04),
     &  ( 9.3922E-05, 2.5137E-04),( 1.0015E-04, 2.6350E-04),
     &  ( 1.0776E-04, 2.7425E-04),( 1.1899E-04, 2.9265E-04),
     &  ( 1.0701E-04, 2.9992E-04),( 9.4847E-05, 3.0727E-04),
     &  ( 7.7955E-05, 3.1747E-04),( 6.8077E-05, 3.3055E-04)/
  
         DATA ((CGS  (I,J), I= 101, 200), J=3,3) /
     &  ( 6.1046E-05, 3.4347E-04),( 6.1735E-05, 3.5559E-04),
     &  ( 6.8064E-05, 3.6701E-04),( 7.7916E-05, 3.6682E-04),
     &  ( 8.8018E-05, 3.6059E-04),( 9.7722E-05, 3.5457E-04),
     &  ( 1.0723E-04, 3.4871E-04),( 1.1655E-04, 3.4299E-04),
     &  ( 1.2421E-04, 3.3733E-04),( 1.3086E-04, 3.3174E-04),
     &  ( 1.3654E-04, 3.2614E-04),( 1.3831E-04, 3.2046E-04),
     &  ( 1.4015E-04, 3.1464E-04),( 1.4208E-04, 3.0339E-04),
     &  ( 1.4122E-04, 2.8702E-04),( 1.3781E-04, 2.6844E-04),
     &  ( 1.3080E-04, 2.4538E-04),( 1.0633E-04, 1.9240E-04),
     &  ( 8.3987E-05, 1.9946E-04),( 7.6841E-05, 2.2245E-04),
     &  ( 7.2963E-05, 2.4101E-04),( 7.0694E-05, 2.5735E-04),
     &  ( 7.0442E-05, 2.7249E-04),( 7.0911E-05, 2.8692E-04),
     &  ( 7.2496E-05, 3.0086E-04),( 7.5791E-05, 3.1404E-04),
     &  ( 8.0787E-05, 3.0966E-04),( 8.7725E-05, 3.0525E-04),
     &  ( 9.7884E-05, 3.0084E-04),( 1.1085E-04, 2.9639E-04),
     &  ( 1.2595E-04, 2.9184E-04),( 1.4319E-04, 2.8717E-04),
     &  ( 1.6212E-04, 2.8236E-04),( 1.8167E-04, 2.7738E-04),
     &  ( 2.0057E-04, 2.7218E-04),( 2.1688E-04, 2.6575E-04),
     &  ( 2.2714E-04, 2.5276E-04),( 2.2626E-04, 2.3903E-04),
     &  ( 2.1268E-04, 2.2954E-04),( 2.0102E-04, 2.1933E-04),
     &  ( 1.9923E-04, 2.0876E-04),( 1.9371E-04, 1.9182E-04),
     &  ( 1.8891E-04, 1.7339E-04),( 1.8019E-04, 1.6333E-04),
     &  ( 1.7253E-04, 1.5887E-04),( 1.6480E-04, 1.5383E-04),
     &  ( 1.5592E-04, 1.4807E-04),( 1.4712E-04, 1.4327E-04),
     &  ( 1.4110E-04, 1.3804E-04),( 1.3900E-04, 1.3939E-04),
     &  ( 1.3907E-04, 1.5356E-04),( 1.4104E-04, 1.3433E-04),
     &  ( 1.4158E-04, 1.2860E-04),( 1.3790E-04, 1.2472E-04),
     &  ( 1.3422E-04, 1.1295E-04),( 1.3028E-04, 1.1018E-04),
     &  ( 1.2896E-04, 1.0478E-04),( 1.2599E-04, 9.8600E-05),
     &  ( 1.2749E-04, 9.5453E-05),( 1.1690E-04, 1.0758E-04),
     &  ( 1.2061E-04, 1.1101E-04),( 1.2523E-04, 9.3929E-05),
     &  ( 1.2618E-04, 9.1291E-05),( 1.2582E-04, 8.5559E-05),
     &  ( 1.2519E-04, 8.2823E-05),( 1.2358E-04, 8.0551E-05),
     &  ( 1.2111E-04, 7.8591E-05),( 1.1990E-04, 7.7849E-05),
     &  ( 1.1440E-04, 7.1758E-05),( 1.1311E-04, 6.5804E-05),
     &  ( 1.1501E-04, 7.5555E-05),( 1.1874E-04, 7.4600E-05),
     &  ( 1.2535E-04, 8.1344E-05),( 1.3075E-04, 7.6133E-05),
     &  ( 1.3462E-04, 6.5365E-05),( 1.3689E-04, 6.1964E-05),
     &  ( 1.3819E-04, 5.4396E-05),( 1.3964E-04, 4.5087E-05),
     &  ( 1.4177E-04, 4.7326E-05),( 1.4369E-04, 5.4385E-05),
     &  ( 1.4804E-04, 5.9827E-05),( 1.5041E-04, 5.8619E-05),
     &  ( 1.5746E-04, 5.8886E-05),( 1.6431E-04, 5.7101E-05),
     &  ( 1.7292E-04, 5.4830E-05),( 1.8079E-04, 5.2907E-05),
     &  ( 1.9150E-04, 5.4598E-05),( 2.0195E-04, 5.9089E-05),
     &  ( 2.1402E-04, 6.4774E-05),( 2.3168E-04, 7.1251E-05),
     &  ( 2.4182E-04, 7.6156E-05),( 2.4932E-04, 7.8009E-05),
     &  ( 2.6567E-04, 8.3713E-05),( 2.7472E-04, 8.5924E-05),
     &  ( 2.8795E-04, 8.8398E-05),( 2.9909E-04, 9.1847E-05),
     &  ( 3.0857E-04, 6.7639E-05),( 3.1883E-04, 6.9512E-05),
     &  ( 3.3096E-04, 7.1520E-05),( 3.6133E-04, 9.3715E-05)/
  
         DATA ((CGS  (I,J), I= 201, 300), J=3,3) /
     &  ( 3.9938E-04, 9.7829E-05),( 4.2059E-04, 6.9397E-05),
     &  ( 4.2832E-04, 6.8508E-05),( 4.3629E-04, 6.7602E-05),
     &  ( 4.4445E-04, 6.6673E-05),( 4.5295E-04, 6.5733E-05),
     &  ( 4.6176E-04, 6.5902E-05),( 4.7092E-04, 6.6477E-05),
     &  ( 4.8050E-04, 6.7005E-05),( 4.9056E-04, 6.8004E-05),
     &  ( 5.0116E-04, 6.9093E-05),( 5.1235E-04, 7.0189E-05),
     &  ( 5.2419E-04, 7.1257E-05),( 5.3672E-04, 7.3639E-05),
     &  ( 5.4999E-04, 7.6849E-05),( 5.6404E-04, 7.9321E-05),
     &  ( 5.7889E-04, 8.1822E-05),( 5.9470E-04, 8.3237E-05),
     &  ( 6.1153E-04, 8.1877E-05),( 6.2948E-04, 8.0522E-05),
     &  ( 6.4867E-04, 7.9967E-05),( 6.6923E-04, 8.0472E-05),
     &  ( 6.9132E-04, 8.0973E-05),( 7.1516E-04, 8.2169E-05),
     &  ( 7.4107E-04, 8.3899E-05),( 7.6947E-04, 8.5641E-05),
     &  ( 8.0111E-04, 8.7926E-05),( 8.3729E-04, 8.9969E-05),
     &  ( 8.8105E-04, 9.0782E-05),( 9.4438E-04, 9.1553E-05),
     &  ( 9.9961E-04, 9.1871E-05),( 9.9763E-04, 1.5996E-04),
     &  ( 9.9240E-04, 1.6179E-04),( 9.4017E-04, 1.6641E-04),
     &  ( 1.0145E-03, 1.7104E-04),( 1.0440E-03, 1.7579E-04),
     &  ( 1.0802E-03, 1.8067E-04),( 1.1224E-03, 1.8477E-04),
     &  ( 1.0643E-03, 1.8796E-04),( 1.1799E-03, 1.9427E-04),
     &  ( 1.3069E-03, 2.0982E-04),( 1.3770E-03, 2.2537E-04),
     &  ( 1.3191E-03, 2.4066E-04),( 1.4992E-03, 2.5544E-04),
     &  ( 1.6794E-03, 2.7195E-04),( 1.8410E-03, 3.0553E-04),
     &  ( 2.0488E-03, 3.4077E-04),( 2.2850E-03, 4.9732E-04),
     &  ( 2.4666E-03, 7.0115E-04),( 2.5967E-03, 9.3713E-04),
     &  ( 2.6527E-03, 1.2054E-03),( 2.6348E-03, 1.4355E-03),
     &  ( 2.6139E-03, 1.5915E-03),( 2.7010E-03, 1.6656E-03),
     &  ( 2.7692E-03, 1.6675E-03),( 2.8799E-03, 1.6506E-03),
     &  ( 3.0872E-03, 1.7147E-03),( 3.3323E-03, 1.8235E-03),
     &  ( 3.4483E-03, 2.0458E-03),( 3.6295E-03, 2.2689E-03),
     &  ( 3.7158E-03, 2.4928E-03),( 3.7553E-03, 2.7175E-03),
     &  ( 3.8967E-03, 2.8635E-03),( 4.0588E-03, 3.2095E-03),
     &  ( 4.0979E-03, 3.5628E-03),( 4.2125E-03, 3.9579E-03),
     &  ( 4.2622E-03, 4.7490E-03),( 3.7807E-03, 5.8659E-03),
     &  ( 3.2720E-03, 5.8759E-03),( 2.8179E-03, 6.1437E-03),
     &  ( 2.4074E-03, 6.6208E-03),( 1.4509E-03, 7.4727E-03),
     &  ( 2.0376E-04, 7.7171E-03),( 1.6533E-03, 7.3662E-03),
     &  ( 2.7732E-03, 6.5819E-03),( 3.1751E-03, 5.5260E-03),
     &  ( 3.1552E-03, 5.0151E-03),( 3.1778E-03, 4.6125E-03),
     &  ( 3.2067E-03, 4.2986E-03),( 3.2365E-03, 3.9899E-03),
     &  ( 3.1804E-03, 3.6866E-03),( 3.1050E-03, 3.5188E-03),
     &  ( 3.0926E-03, 3.3999E-03),( 3.1328E-03, 3.2730E-03),
     &  ( 3.1829E-03, 3.1211E-03),( 3.1888E-03, 2.9444E-03),
     &  ( 3.2037E-03, 2.8559E-03),( 3.1608E-03, 2.6661E-03),
     &  ( 3.1770E-03, 2.7423E-03),( 3.4099E-03, 2.6857E-03),
     &  ( 3.6652E-03, 2.4695E-03),( 3.7554E-03, 1.9628E-03),
     &  ( 3.7210E-03, 1.6557E-03),( 3.6836E-03, 1.5112E-03),
     &  ( 3.3848E-03, 1.2407E-03),( 3.0915E-03, 1.1496E-03),
     &  ( 2.8884E-03, 1.1434E-03),( 2.7623E-03, 1.1335E-03),
     &  ( 2.6687E-03, 1.1199E-03),( 2.6003E-03, 1.1027E-03)/
  
         DATA ((CGS  (I,J), I= 301, 400), J=3,3) /
     &  ( 2.9076E-03, 1.0818E-03),( 2.5035E-03, 1.0573E-03),
     &  ( 2.4642E-03, 1.0291E-03),( 2.5792E-03, 9.9720E-04),
     &  ( 2.3218E-03, 8.5977E-04),( 2.2055E-03, 7.2484E-04),
     &  ( 2.0880E-03, 5.9240E-04),( 1.7330E-03, 4.3468E-04),
     &  ( 1.7059E-03, 4.0737E-04),( 1.5754E-03, 4.0042E-04),
     &  ( 1.4943E-03, 3.9096E-04),( 1.4130E-03, 3.7913E-04),
     &  ( 1.3506E-03, 3.6486E-04),( 1.3000E-03, 3.4815E-04),
     &  ( 1.2486E-03, 3.2900E-04),( 1.1872E-03, 3.0735E-04),
     &  ( 1.1506E-03, 3.2922E-04),( 1.1339E-03, 3.1271E-04),
     &  ( 1.1113E-03, 2.9772E-04),( 1.0877E-03, 2.8337E-04),
     &  ( 1.0673E-03, 2.6901E-04),( 1.0474E-03, 2.5465E-04),
     &  ( 1.0277E-03, 2.4447E-04),( 1.0243E-03, 2.3916E-04),
     &  ( 9.9446E-04, 2.2249E-04),( 1.2492E-03, 2.4650E-04),
     &  ( 1.2426E-03, 3.6402E-04),( 1.0046E-03, 3.5487E-04),
     &  ( 9.2749E-04, 3.3872E-04),( 8.8101E-04, 3.2294E-04),
     &  ( 8.4517E-04, 3.0751E-04),( 8.1545E-04, 2.9244E-04),
     &  ( 7.8957E-04, 2.7774E-04),( 7.6664E-04, 2.6339E-04),
     &  ( 7.4520E-04, 2.5096E-04),( 7.2503E-04, 2.4086E-04),
     &  ( 7.1003E-04, 2.3096E-04),( 6.9422E-04, 2.2126E-04),
     &  ( 6.7960E-04, 2.1177E-04),( 6.6606E-04, 2.0249E-04),
     &  ( 6.5348E-04, 1.9341E-04),( 6.2950E-04, 2.7143E-04),
     &  ( 6.1864E-04, 2.6676E-04),( 6.0833E-04, 2.6213E-04),
     &  ( 5.9852E-04, 2.5753E-04),( 5.8913E-04, 2.5297E-04),
     &  ( 5.8020E-04, 2.4845E-04),( 5.7169E-04, 2.4396E-04),
     &  ( 5.6350E-04, 2.3943E-04),( 5.5565E-04, 2.3449E-04),
     &  ( 5.4813E-04, 2.2959E-04),( 5.4089E-04, 2.2475E-04),
     &  ( 5.3393E-04, 2.1995E-04),( 5.2723E-04, 2.1521E-04),
     &  ( 5.2079E-04, 2.1052E-04),( 5.1471E-04, 2.1822E-04),
     &  ( 4.8948E-04, 2.5258E-04),( 4.3751E-04, 2.5687E-04),
     &  ( 3.6443E-04, 2.3818E-04),( 3.1659E-04, 2.0852E-04),
     &  ( 2.8250E-04, 1.9733E-04),( 2.5699E-04, 2.2362E-04),
     &  ( 2.3731E-04, 2.0791E-04),( 2.2188E-04, 1.9138E-04),
     &  ( 2.1026E-04, 1.9797E-04),( 2.0925E-04, 1.9787E-04),
     &  ( 1.9731E-04, 1.9852E-04),( 1.9051E-04, 1.9961E-04),
     &  ( 1.8858E-04, 2.0261E-04),( 1.8522E-04, 2.2012E-04),
     &  ( 1.8381E-04, 1.9927E-04),( 1.8376E-04, 1.9876E-04),
     &  ( 1.8353E-04, 1.8007E-04),( 1.8280E-04, 1.7686E-04),
     &  ( 1.8246E-04, 1.6493E-04),( 1.8272E-04, 1.5493E-04),
     &  ( 1.8427E-04, 1.9337E-04),( 1.8659E-04, 1.8416E-04),
     &  ( 1.8956E-04, 1.5729E-04),( 1.9169E-04, 1.5309E-04),
     &  ( 1.9371E-04, 1.6329E-04),( 1.9522E-04, 1.7818E-04),
     &  ( 1.9958E-04, 1.7015E-04),( 2.0477E-04, 1.5928E-04),
     &  ( 2.0531E-04, 1.5966E-04),( 2.1075E-04, 1.7433E-04),
     &  ( 2.1867E-04, 1.9771E-04),( 2.2355E-04, 2.0481E-04),
     &  ( 2.2895E-04, 2.1045E-04),( 2.4089E-04, 2.0832E-04),
     &  ( 2.5486E-04, 2.0650E-04),( 2.7394E-04, 2.5073E-04),
     &  ( 2.8051E-04, 2.6904E-04),( 2.9787E-04, 2.5769E-04),
     &  ( 3.1211E-04, 2.4930E-04),( 3.2745E-04, 2.2813E-04),
     &  ( 3.6235E-04, 2.4274E-04),( 4.0916E-04, 2.6096E-04),
     &  ( 4.1496E-04, 2.5868E-04),( 4.6517E-04, 2.5623E-04)/
  
         DATA ((CGS  (I,J), I= 401, 500), J=3,3) /
     &  ( 5.3731E-04, 2.6886E-04),( 5.5259E-04, 2.8376E-04),
     &  ( 5.0193E-04, 3.0140E-04),( 4.5768E-04, 3.2314E-04),
     &  ( 4.4109E-04, 3.3148E-04),( 3.9674E-04, 3.3692E-04),
     &  ( 3.8456E-04, 3.3880E-04),( 3.7806E-04, 3.3991E-04),
     &  ( 3.7017E-04, 3.4335E-04),( 3.5655E-04, 3.5428E-04),
     &  ( 3.4319E-04, 3.6533E-04),( 3.3082E-04, 3.7614E-04),
     &  ( 3.2952E-04, 3.7743E-04),( 3.1824E-04, 3.8913E-04),
     &  ( 3.1702E-04, 3.9044E-04),( 3.1103E-04, 3.9703E-04),
     &  ( 3.0651E-04, 4.0233E-04),( 2.9244E-04, 4.1531E-04),
     &  ( 2.8993E-04, 4.1712E-04),( 2.7173E-04, 4.5583E-04),
     &  ( 2.7019E-04, 4.5669E-04),( 2.6860E-04, 4.5754E-04),
     &  ( 2.5113E-04, 4.6618E-04),( 2.3475E-04, 4.7488E-04),
     &  ( 2.3198E-04, 4.7663E-04),( 2.1765E-04, 4.7104E-04),
     &  ( 2.1654E-04, 4.7055E-04),( 2.1122E-04, 4.7997E-04),
     &  ( 2.1022E-04, 4.8186E-04),( 2.0448E-04, 4.9329E-04),
     &  ( 2.0134E-04, 4.9757E-04),( 1.9072E-04, 5.1050E-04),
     &  ( 1.8948E-04, 5.1195E-04),( 1.7687E-04, 5.2647E-04),
     &  ( 1.6585E-04, 5.3592E-04),( 1.5999E-04, 5.4057E-04),
     &  ( 1.5886E-04, 5.4150E-04),( 1.4547E-04, 5.5313E-04),
     &  ( 1.4360E-04, 5.5534E-04),( 1.3516E-04, 5.6643E-04),
     &  ( 1.3034E-04, 5.7427E-04),( 1.2869E-04, 5.7764E-04),
     &  ( 1.2775E-04, 5.7989E-04),( 1.2734E-04, 5.8102E-04),
     &  ( 1.2536E-04, 5.8721E-04),( 1.2552E-04, 5.8844E-04),
     &  ( 1.2733E-04, 5.9505E-04),( 1.3115E-04, 6.0153E-04),
     &  ( 1.3383E-04, 6.0276E-04),( 1.4649E-04, 6.0348E-04),
     &  ( 1.6375E-04, 6.0408E-04),( 1.6783E-04, 6.0419E-04),
     &  ( 1.6997E-04, 6.0509E-04),( 1.8391E-04, 6.1049E-04),
     &  ( 1.9131E-04, 6.1319E-04),( 1.9902E-04, 6.1590E-04),
     &  ( 2.3502E-04, 6.0096E-04),( 2.4032E-04, 5.9668E-04),
     &  ( 2.5521E-04, 5.8392E-04),( 2.6421E-04, 5.7548E-04),
     &  ( 2.7558E-04, 5.6293E-04),( 2.7727E-04, 5.6085E-04),
     &  ( 2.8222E-04, 5.5463E-04),( 2.8529E-04, 5.5050E-04),
     &  ( 2.8817E-04, 5.4710E-04),( 2.9473E-04, 5.4041E-04),
     &  ( 3.0162E-04, 5.3241E-04),( 3.0802E-04, 5.2766E-04),
     &  ( 3.1811E-04, 5.2191E-04),( 3.3012E-04, 5.2089E-04),
     &  ( 3.3161E-04, 5.2077E-04),( 3.5485E-04, 5.1929E-04),
     &  ( 3.7422E-04, 5.2242E-04),( 3.9624E-04, 5.2497E-04),
     &  ( 4.0061E-04, 5.2563E-04),( 4.4081E-04, 5.3097E-04),
     &  ( 4.4748E-04, 5.3163E-04),( 4.7393E-04, 5.2311E-04),
     &  ( 5.5323E-04, 4.5287E-04),( 5.3475E-04, 3.2753E-04),
     &  ( 5.2303E-04, 3.0604E-04),( 4.4871E-04, 2.7279E-04),
     &  ( 4.3217E-04, 2.7218E-04),( 4.2623E-04, 2.7172E-04),
     &  ( 4.1875E-04, 2.7351E-04),( 4.2068E-04, 2.7568E-04),
     &  ( 4.2541E-04, 2.7571E-04),( 4.3092E-04, 2.7485E-04),
     &  ( 4.4145E-04, 2.7347E-04),( 4.4428E-04, 2.7164E-04),
     &  ( 4.5143E-04, 2.6704E-04),( 4.5287E-04, 2.6611E-04),
     &  ( 4.5868E-04, 2.6236E-04),( 4.6580E-04, 2.5762E-04),
     &  ( 4.7299E-04, 2.5280E-04),( 4.7599E-04, 2.5085E-04),
     &  ( 5.1543E-04, 2.3064E-04),( 5.4979E-04, 2.1920E-04),
     &  ( 5.4974E-04, 1.8795E-04),( 4.1294E-04, 1.5804E-04)/
  
         DATA ((CGS  (I,J), I= 501, 600), J=3,3) /
     &  ( 3.4545E-04, 1.4278E-04),( 3.1579E-04, 1.9087E-04),
     &  ( 2.7442E-04, 1.8772E-04),( 2.7119E-04, 1.1892E-04),
     &  ( 2.6127E-04, 1.2020E-04),( 2.5246E-04, 1.2353E-04),
     &  ( 2.4065E-04, 1.2903E-04),( 2.3911E-04, 1.2267E-04),
     &  ( 2.3950E-04, 1.1635E-04),( 2.4224E-04, 1.1647E-04),
     &  ( 2.4806E-04, 1.1651E-04),( 2.5736E-04, 1.1651E-04),
     &  ( 2.7110E-04, 1.1651E-04),( 2.9083E-04, 1.1620E-04),
     &  ( 3.1935E-04, 1.1588E-04),( 3.6196E-04, 1.1558E-04),
     &  ( 4.2963E-04, 1.1557E-04),( 4.4801E-04, 1.1559E-04),
     &  ( 4.6865E-04, 1.1561E-04),( 4.9198E-04, 1.1563E-04),
     &  ( 5.1852E-04, 1.1565E-04),( 5.4894E-04, 1.1567E-04),
     &  ( 5.8411E-04, 1.1569E-04),( 6.2518E-04, 1.1571E-04),
     &  ( 6.3423E-04, 1.1572E-04),( 6.4358E-04, 1.1572E-04),
     &  ( 6.5327E-04, 1.1573E-04),( 6.6329E-04, 1.1573E-04),
     &  ( 6.7368E-04, 1.1573E-04),( 6.8444E-04, 1.1574E-04),
     &  ( 6.9560E-04, 1.1574E-04),( 7.0719E-04, 1.1575E-04),
     &  ( 7.1922E-04, 1.1575E-04),( 7.3172E-04, 1.1575E-04),
     &  ( 7.9465E-04, 1.1577E-04),( 8.4363E-04, 1.1580E-04),
     &  ( 8.7071E-04, 1.1581E-04),( 8.8983E-04, 1.1582E-04),
     &  ( 9.0990E-04, 1.1583E-04),( 9.3095E-04, 1.1584E-04),
     &  ( 9.5309E-04, 1.1585E-04),( 9.7637E-04, 1.1586E-04),
     &  ( 1.0009E-03, 1.1587E-04),( 1.0137E-03, 1.1587E-04),
     &  ( 1.0268E-03, 1.1588E-04),( 1.0403E-03, 1.1588E-04),
     &  ( 1.0541E-03, 1.1588E-04),( 1.0684E-03, 1.1589E-04),
     &  ( 1.0830E-03, 1.1589E-04),( 1.0981E-03, 1.1590E-04),
     &  ( 1.1137E-03, 1.1590E-04),( 1.1297E-03, 1.1591E-04),
     &  ( 1.1462E-03, 1.1591E-04),( 1.1632E-03, 1.1592E-04),
     &  ( 1.1807E-03, 1.1592E-04),( 1.1988E-03, 1.1592E-04),
     &  ( 1.2175E-03, 1.1593E-04),( 1.2368E-03, 1.1593E-04),
     &  ( 1.2568E-03, 1.1593E-04),( 1.2774E-03, 1.1593E-04),
     &  ( 1.2988E-03, 1.1593E-04),( 1.3208E-03, 1.1593E-04),
     &  ( 1.3437E-03, 1.1593E-04),( 1.3674E-03, 1.1593E-04),
     &  ( 1.3920E-03, 1.1593E-04),( 1.4176E-03, 1.1593E-04),
     &  ( 1.4441E-03, 1.1593E-04),( 1.4716E-03, 1.1593E-04),
     &  ( 1.5002E-03, 1.1593E-04),( 1.5300E-03, 1.1593E-04),
     &  ( 1.5611E-03, 1.1593E-04),( 1.5934E-03, 1.1593E-04),
     &  ( 1.6272E-03, 1.1593E-04),( 1.6624E-03, 1.1591E-04),
     &  ( 1.6992E-03, 1.1589E-04),( 1.7377E-03, 1.1587E-04),
     &  ( 1.7780E-03, 1.1585E-04),( 1.8203E-03, 1.1583E-04),
     &  ( 1.8647E-03, 1.1581E-04),( 1.9113E-03, 1.1579E-04),
     &  ( 1.9603E-03, 1.1577E-04),( 2.0119E-03, 1.1574E-04),
     &  ( 2.0664E-03, 1.1572E-04),( 2.0947E-03, 1.1573E-04),
     &  ( 2.1239E-03, 1.1574E-04),( 2.1539E-03, 1.1575E-04),
     &  ( 2.1847E-03, 1.1576E-04),( 2.2165E-03, 1.1577E-04),
     &  ( 2.2492E-03, 1.1578E-04),( 2.2828E-03, 1.1579E-04),
     &  ( 2.3176E-03, 1.1580E-04),( 2.3533E-03, 1.1581E-04),
     &  ( 2.3903E-03, 1.1582E-04),( 2.4284E-03, 1.1582E-04),
     &  ( 2.4677E-03, 1.1583E-04),( 2.5083E-03, 1.1584E-04),
     &  ( 2.5503E-03, 1.1585E-04),( 2.5938E-03, 1.1586E-04),
     &  ( 2.6387E-03, 1.1587E-04),( 2.6853E-03, 1.1588E-04)/
  
         DATA ((CGS  (I,J), I= 601, 700), J=3,3) /
     &  ( 2.7335E-03, 1.1589E-04),( 2.7835E-03, 1.1590E-04),
     &  ( 2.8353E-03, 1.1591E-04),( 2.8892E-03, 1.1592E-04),
     &  ( 2.9451E-03, 1.1593E-04),( 3.0032E-03, 1.1593E-04),
     &  ( 3.0636E-03, 1.1594E-04),( 3.1266E-03, 1.1595E-04),
     &  ( 3.1922E-03, 1.1596E-04),( 3.2606E-03, 1.1597E-04),
     &  ( 3.3320E-03, 1.1598E-04),( 3.4066E-03, 1.1599E-04),
     &  ( 3.4846E-03, 1.1600E-04),( 3.5662E-03, 1.1601E-04),
     &  ( 3.6518E-03, 1.1602E-04),( 3.7416E-03, 1.1603E-04),
     &  ( 3.8359E-03, 1.1604E-04),( 3.9351E-03, 1.1605E-04),
     &  ( 4.0395E-03, 1.1605E-04),( 4.1496E-03, 1.1606E-04),
     &  ( 4.2659E-03, 1.1607E-04),( 4.4401E-03, 1.1609E-04),
     &  ( 4.5191E-03, 1.1609E-04),( 4.6573E-03, 1.1608E-04),
     &  ( 4.8043E-03, 1.1608E-04),( 4.9607E-03, 1.1607E-04),
     &  ( 5.1277E-03, 1.1606E-04),( 5.3062E-03, 1.1605E-04),
     &  ( 5.4976E-03, 1.1604E-04),( 5.7033E-03, 1.1604E-04),
     &  ( 5.9250E-03, 1.1603E-04),( 6.1645E-03, 1.1602E-04),
     &  ( 6.4241E-03, 1.1601E-04),( 6.7065E-03, 1.1600E-04),
     &  ( 6.9319E-03, 1.1600E-04),( 7.6343E-03, 1.1598E-04),
     &  ( 8.4946E-03, 1.1597E-04),( 9.5727E-03, 1.1595E-04),
     &  ( 1.0963E-02, 1.1593E-04),( 1.2825E-02, 1.1592E-04),
     &  ( 1.5446E-02, 1.1591E-04),( 1.9409E-02, 1.1590E-04),
     &  ( 2.6101E-02, 6.6631E-04),( 3.9812E-02, 1.3970E-03),
     &  ( 8.3713E-02, 5.7918E-03),( 8.8521E-02, 6.4645E-03),
     &  ( 9.3913E-02, 7.2641E-03),( 1.0000E-01, 8.2246E-03),
     &  ( 1.0693E-01, 9.3922E-03),( 1.1489E-01, 1.0831E-02),
     &  ( 1.2411E-01, 1.2631E-02),( 1.3494E-01, 1.4925E-02),
     &  ( 1.4782E-01, 1.7911E-02),( 1.6339E-01, 2.1896E-02),
     &  ( 1.8257E-01, 2.7379E-02),( 2.0677E-01, 3.5213E-02),
     &  ( 2.3821E-01, 4.6947E-02),( 2.8055E-01, 6.5640E-02),
     &  ( 2.8560E-01, 6.8098E-02),( 3.9864E-01, 1.3695E-01),
     &  ( 4.8103E-01, 2.0623E-01),( 5.4722E-01, 2.7653E-01),
     &  ( 6.0479E-01, 3.5130E-01),( 6.4916E-01, 4.2025E-01),
     &  ( 6.8792E-01, 4.9139E-01),( 7.1898E-01, 5.5851E-01),
     &  ( 7.4993E-01, 6.3839E-01),( 7.7119E-01, 7.0475E-01),
     &  ( 7.9087E-01, 7.8008E-01),( 8.0476E-01, 8.4759E-01),
     &  ( 8.1621E-01, 9.2216E-01),( 8.2265E-01, 9.8304E-01),
     &  ( 8.2745E-01, 1.0712E+00),( 8.2786E-01, 1.1183E+00),
     &  ( 8.2544E-01, 1.1928E+00),( 8.1874E-01, 1.2718E+00),
     &  ( 8.1149E-01, 1.3269E+00),( 7.9582E-01, 1.4128E+00),
     &  ( 7.8178E-01, 1.4720E+00),( 7.6455E-01, 1.5324E+00),
     &  ( 7.4385E-01, 1.5938E+00),( 7.1942E-01, 1.6556E+00),
     &  ( 6.9103E-01, 1.7175E+00),( 6.5847E-01, 1.7788E+00),
     &  ( 6.2157E-01, 1.8391E+00),( 5.8025E-01, 1.8975E+00),
     &  ( 5.3445E-01, 1.9533E+00),( 4.8425E-01, 2.0058E+00),
     &  ( 4.0104E-01, 2.0764E+00),( 3.4072E-01, 2.1169E+00),
     &  ( 2.4403E-01, 2.1658E+00),( 1.4159E-01, 2.1987E+00),
     &  ( 1.4149E-01, 2.1987E+00),( 4.0096E-01, 2.0765E+00),
     &  ( 4.8417E-01, 2.0059E+00),( 5.5783E-01, 1.9259E+00),
     &  ( 6.0140E-01, 1.8687E+00),( 6.5841E-01, 1.7789E+00),
     &  ( 6.9098E-01, 1.7176E+00),( 7.1937E-01, 1.6557E+00)/
  
         DATA ((CGS  (I,J), I= 701, 800), J=3,3) /
     &  ( 7.4381E-01, 1.5939E+00),( 7.6451E-01, 1.5326E+00),
     &  ( 7.8175E-01, 1.4721E+00),( 7.9580E-01, 1.4130E+00),
     &  ( 8.0692E-01, 1.3553E+00),( 8.1540E-01, 1.2993E+00),
     &  ( 8.2149E-01, 1.2451E+00),( 8.2543E-01, 1.1929E+00),
     &  ( 8.2786E-01, 1.1184E+00),( 8.2745E-01, 1.0713E+00),
     &  ( 8.2430E-01, 1.0044E+00),( 8.1860E-01, 9.4208E-01),
     &  ( 8.1364E-01, 9.0294E-01),( 8.0151E-01, 8.3018E-01),
     &  ( 7.9090E-01, 7.8019E-01),( 7.7531E-01, 7.1916E-01),
     &  ( 7.5860E-01, 6.6403E-01),( 7.3679E-01, 6.0252E-01),
     &  ( 7.1457E-01, 5.4829E-01),( 6.8357E-01, 4.8280E-01),
     &  ( 6.5341E-01, 4.2751E-01),( 6.1657E-01, 3.6851E-01),
     &  ( 5.7502E-01, 3.1082E-01),( 5.2157E-01, 2.4752E-01),
     &  ( 4.6030E-01, 1.8706E-01),( 3.8379E-01, 1.2630E-01),
     &  ( 3.1626E-01, 8.4102E-02),( 2.6380E-01, 5.7838E-02),
     &  ( 2.2594E-01, 4.2155E-02),( 1.9744E-01, 3.2069E-02),
     &  ( 1.7525E-01, 2.5211E-02),( 1.5749E-01, 2.0339E-02),
     &  ( 1.4298E-01, 1.6757E-02),( 1.3091E-01, 1.4048E-02),
     &  ( 1.2070E-01, 1.1949E-02),( 1.1197E-01, 1.0290E-02),
     &  ( 1.0440E-01, 8.9570E-03),( 9.7796E-02, 7.8694E-03),
     &  ( 9.1973E-02, 6.9707E-03),( 8.6802E-02, 6.2196E-03),
     &  ( 8.2181E-02, 5.5854E-03),( 7.8026E-02, 5.0451E-03),
     &  ( 7.4271E-02, 4.5811E-03),( 7.0859E-02, 4.1796E-03),
     &  ( 3.7157E-02, 1.2317E-03),( 2.5184E-02, 6.2826E-04),
     &  ( 1.9051E-02, 1.1593E-04),( 1.5324E-02, 1.1604E-04),
     &  ( 1.2818E-02, 1.1615E-04),( 1.1019E-02, 1.1626E-04),
     &  ( 9.6642E-03, 1.1637E-04),( 8.6073E-03, 1.1647E-04),
     &  ( 7.7599E-03, 1.1658E-04),( 7.0653E-03, 1.1669E-04),
     &  ( 6.9830E-03, 1.1670E-04),( 6.4095E-03, 1.1681E-04),
     &  ( 5.9237E-03, 1.1692E-04),( 5.5070E-03, 1.1703E-04),
     &  ( 5.1456E-03, 1.1714E-04),( 4.8293E-03, 1.1725E-04),
     &  ( 4.5500E-03, 1.1736E-04),( 4.3018E-03, 1.1747E-04),
     &  ( 4.0796E-03, 1.1758E-04),( 3.8796E-03, 1.1769E-04),
     &  ( 3.6986E-03, 1.1780E-04),( 3.5342E-03, 1.1791E-04),
     &  ( 3.3840E-03, 1.1802E-04),( 3.2463E-03, 1.1813E-04),
     &  ( 3.1197E-03, 1.1823E-04),( 3.0029E-03, 1.1834E-04),
     &  ( 2.8947E-03, 1.1845E-04),( 2.7943E-03, 1.1856E-04),
     &  ( 2.7009E-03, 1.1867E-04),( 2.6137E-03, 1.1878E-04),
     &  ( 2.5322E-03, 1.1889E-04),( 2.4558E-03, 1.1900E-04),
     &  ( 2.3841E-03, 1.1911E-04),( 2.3167E-03, 1.1922E-04),
     &  ( 2.2531E-03, 1.1933E-04),( 2.1931E-03, 1.1944E-04),
     &  ( 2.1364E-03, 1.1955E-04),( 2.0827E-03, 1.1965E-04),
     &  ( 2.0319E-03, 1.1976E-04),( 1.9836E-03, 1.1987E-04),
     &  ( 1.9376E-03, 1.1998E-04),( 1.8940E-03, 1.2009E-04),
     &  ( 1.8524E-03, 1.2020E-04),( 1.8127E-03, 1.2031E-04),
     &  ( 1.7748E-03, 1.2042E-04),( 1.7386E-03, 1.2053E-04),
     &  ( 1.7040E-03, 1.2064E-04),( 1.6709E-03, 1.2074E-04),
     &  ( 1.6392E-03, 1.2085E-04),( 1.6088E-03, 1.2096E-04),
     &  ( 1.5796E-03, 1.2107E-04),( 1.5516E-03, 1.2118E-04),
     &  ( 1.5246E-03, 1.2129E-04),( 1.4988E-03, 1.2140E-04),
     &  ( 1.4739E-03, 1.2151E-04),( 1.4499E-03, 1.2162E-04)/
  
         DATA ((CGS  (I,J), I= 801, 900), J=3,3) /
     &  ( 1.4268E-03, 1.2172E-04),( 1.4046E-03, 1.2183E-04),
     &  ( 1.3831E-03, 1.2194E-04),( 1.3624E-03, 1.2205E-04),
     &  ( 1.3425E-03, 1.2216E-04),( 1.3232E-03, 1.2227E-04),
     &  ( 1.3046E-03, 1.2238E-04),( 1.2866E-03, 1.2249E-04),
     &  ( 1.2692E-03, 1.2259E-04),( 1.2524E-03, 1.2270E-04),
     &  ( 1.2361E-03, 1.2281E-04),( 1.2204E-03, 1.2292E-04),
     &  ( 1.2051E-03, 1.2303E-04),( 1.1904E-03, 1.2314E-04),
     &  ( 1.1761E-03, 1.2325E-04),( 1.1623E-03, 1.2336E-04),
     &  ( 1.1489E-03, 1.2346E-04),( 1.1359E-03, 1.2357E-04),
     &  ( 1.1233E-03, 1.2368E-04),( 1.1111E-03, 1.2379E-04),
     &  ( 1.0993E-03, 1.2390E-04),( 1.0879E-03, 1.2401E-04),
     &  ( 1.0768E-03, 1.2412E-04),( 1.0661E-03, 1.2422E-04),
     &  ( 1.0557E-03, 1.2433E-04),( 1.0457E-03, 1.2444E-04),
     &  ( 1.0359E-03, 1.2455E-04),( 1.0265E-03, 1.2466E-04),
     &  ( 1.0174E-03, 1.2477E-04),( 1.0087E-03, 1.2488E-04),
     &  ( 1.0002E-03, 1.2498E-04),( 9.9207E-04, 1.2509E-04),
     &  ( 9.8424E-04, 1.2520E-04),( 9.7673E-04, 1.2531E-04),
     &  ( 9.6955E-04, 1.2542E-04),( 9.6272E-04, 1.2553E-04),
     &  ( 9.5625E-04, 1.2563E-04),( 9.5016E-04, 1.2574E-04),
     &  ( 9.4267E-04, 1.2585E-04),( 9.3534E-04, 1.2596E-04),
     &  ( 9.2817E-04, 1.2607E-04),( 9.2116E-04, 1.2618E-04),
     &  ( 9.1430E-04, 1.2628E-04),( 9.0758E-04, 1.2639E-04),
     &  ( 9.0098E-04, 1.2650E-04),( 8.9450E-04, 1.2661E-04),
     &  ( 8.8876E-04, 1.2671E-04),( 8.8390E-04, 1.2732E-04),
     &  ( 8.7809E-04, 1.2791E-04),( 8.7230E-04, 1.2851E-04),
     &  ( 8.6666E-04, 1.2911E-04),( 8.6105E-04, 1.2971E-04),
     &  ( 8.5557E-04, 1.3031E-04),( 8.5020E-04, 1.3091E-04),
     &  ( 8.4496E-04, 1.3151E-04),( 8.3980E-04, 1.3211E-04),
     &  ( 8.3477E-04, 1.3271E-04),( 6.6699E-04, 1.5686E-04),
     &  ( 5.7589E-04, 1.8751E-04),( 5.4789E-04, 2.0360E-04),
     &  ( 5.7345E-04, 2.1048E-04),( 6.1605E-04, 2.1029E-04),
     &  ( 7.2637E-04, 1.9869E-04),( 7.9400E-04, 1.9325E-04),
     &  ( 8.8269E-04, 1.8780E-04),( 8.9527E-04, 1.8786E-04),
     &  ( 9.6215E-04, 2.1054E-04),( 1.0042E-03, 2.0078E-04),
     &  ( 1.0122E-03, 1.9905E-04),( 1.1283E-03, 1.9914E-04),
     &  ( 1.3002E-03, 1.9923E-04),( 1.3614E-03, 1.9923E-04),
     &  ( 1.4296E-03, 1.7681E-04),( 1.5041E-03, 1.7918E-04),
     &  ( 1.5926E-03, 1.8326E-04),( 1.6854E-03, 1.8733E-04),
     &  ( 1.7968E-03, 1.9139E-04),( 1.9296E-03, 1.9545E-04),
     &  ( 2.0888E-03, 1.9950E-04),( 2.2815E-03, 1.9963E-04),
     &  ( 2.5182E-03, 1.9977E-04),( 2.8148E-03, 1.9990E-04),
     &  ( 3.1960E-03, 2.0003E-04),( 3.3804E-03, 2.0255E-04),
     &  ( 3.5881E-03, 2.0507E-04),( 3.8239E-03, 2.0759E-04),
     &  ( 4.0936E-03, 2.1012E-04),( 4.4051E-03, 2.1265E-04),
     &  ( 4.7689E-03, 2.1757E-04),( 4.9745E-03, 2.2003E-04),
     &  ( 5.1990E-03, 2.2250E-04),( 5.4448E-03, 2.2496E-04),
     &  ( 5.7153E-03, 2.2743E-04),( 6.0143E-03, 2.2990E-04),
     &  ( 6.3464E-03, 2.3238E-04),( 6.7176E-03, 2.3485E-04),
     &  ( 7.1351E-03, 2.3733E-04),( 7.6081E-03, 2.3744E-04),
     &  ( 8.1484E-03, 2.3555E-04),( 8.7715E-03, 2.3366E-04)/
  
         DATA ((CGS  (I,J), I= 901,1000), J=3,3) /
     &  ( 9.4978E-03, 2.3178E-04),( 1.0318E-02, 2.2998E-04),
     &  ( 1.0855E-02, 2.2894E-04),( 1.1451E-02, 2.2791E-04),
     &  ( 1.2116E-02, 2.2688E-04),( 1.2863E-02, 2.2586E-04),
     &  ( 1.3708E-02, 2.2483E-04),( 1.4672E-02, 2.2380E-04),
     &  ( 1.5782E-02, 2.2278E-04),( 1.7073E-02, 2.2176E-04),
     &  ( 1.8593E-02, 2.2073E-04),( 2.0410E-02, 2.1971E-04),
     &  ( 2.2619E-02, 2.1869E-04),( 2.5363E-02, 2.1767E-04),
     &  ( 2.8864E-02, 2.1665E-04),( 3.3481E-02, 2.1564E-04),
     &  ( 3.9849E-02, 2.1462E-04),( 4.9193E-02, 2.1361E-04),
     &  ( 6.4212E-02, 2.1259E-04),( 9.2213E-02, 1.5454E-02),
     &  ( 1.3625E-01, 3.4124E-02),( 1.6132E-01, 4.8455E-02),
     &  ( 1.8866E-01, 6.7523E-02),( 2.5593E-01, 1.3334E-01),
     &  ( 2.8017E-01, 1.6586E-01),( 3.0017E-01, 1.9779E-01),
     &  ( 3.1716E-01, 2.2977E-01),( 3.3146E-01, 2.6152E-01),
     &  ( 3.4320E-01, 2.9228E-01),( 3.5330E-01, 3.2390E-01),
     &  ( 3.6158E-01, 3.5549E-01),( 3.6750E-01, 3.8353E-01),
     &  ( 3.7253E-01, 4.1426E-01),( 3.7609E-01, 4.4495E-01),
     &  ( 3.7820E-01, 4.7505E-01),( 3.7897E-01, 5.0400E-01),
     &  ( 3.7843E-01, 5.3472E-01),( 3.7695E-01, 5.5983E-01),
     &  ( 3.7394E-01, 5.8980E-01),( 3.7001E-01, 6.1707E-01),
     &  ( 3.6471E-01, 6.4524E-01),( 3.5789E-01, 6.7421E-01),
     &  ( 3.5072E-01, 6.9956E-01),( 3.4068E-01, 7.2958E-01),
     &  ( 3.3052E-01, 7.5553E-01),( 3.1885E-01, 7.8153E-01),
     &  ( 3.0559E-01, 8.0737E-01),( 2.8802E-01, 8.3703E-01),
     &  ( 2.7112E-01, 8.6177E-01),( 2.4924E-01, 8.8947E-01),
     &  ( 2.2863E-01, 9.1189E-01),( 1.9858E-01, 9.3938E-01),
     &  ( 1.6580E-01, 9.6347E-01),( 1.1683E-01, 9.8988E-01),
     &  ( 7.4140E-02, 1.0048E+00),( 2.4975E-02, 1.0135E+00),
     &  ( 5.8467E-04, 1.0146E+00),( 2.4850E-02, 1.0135E+00),
     &  ( 4.9592E-02, 1.0102E+00),( 1.1671E-01, 9.8993E-01),
     &  ( 1.6569E-01, 9.6354E-01),( 1.9848E-01, 9.3946E-01),
     &  ( 2.2853E-01, 9.1199E-01),( 2.4914E-01, 8.8958E-01),
     &  ( 2.7104E-01, 8.6189E-01),( 2.8794E-01, 8.3715E-01),
     &  ( 3.0552E-01, 8.0750E-01),( 3.1879E-01, 7.8166E-01),
     &  ( 3.3047E-01, 7.5567E-01),( 3.4063E-01, 7.2972E-01),
     &  ( 3.5068E-01, 6.9970E-01),( 3.5785E-01, 6.7435E-01),
     &  ( 3.6468E-01, 6.4539E-01),( 3.6999E-01, 6.1722E-01),
     &  ( 3.7392E-01, 5.8994E-01),( 3.7693E-01, 5.5998E-01),
     &  ( 3.7842E-01, 5.3486E-01),( 3.7897E-01, 5.0414E-01),
     &  ( 3.7821E-01, 4.7520E-01),( 3.7611E-01, 4.4509E-01),
     &  ( 3.7255E-01, 4.1440E-01),( 3.6753E-01, 3.8366E-01),
     &  ( 3.6161E-01, 3.5562E-01),( 3.5334E-01, 3.2403E-01),
     &  ( 3.4324E-01, 2.9240E-01),( 3.3151E-01, 2.6163E-01),
     &  ( 3.1721E-01, 2.2988E-01),( 3.0023E-01, 1.9789E-01),
     &  ( 2.8024E-01, 1.6595E-01),( 2.5600E-01, 1.3342E-01),
     &  ( 2.2779E-01, 1.0089E-01),( 2.4258E-01, 1.1772E-01),
     &  ( 2.0751E-01, 8.2997E-02),( 1.8591E-01, 6.5430E-02),
     &  ( 1.7285E-01, 5.6037E-02),( 1.4580E-01, 3.9247E-02),
     &  ( 1.3634E-01, 3.4167E-02),( 1.1597E-01, 2.4538E-02),
     &  ( 7.5093E-02, 2.0654E-04),( 5.5407E-02, 2.0553E-04)/
  
         DATA ((CGS  (I,J), I=1001,1100), J=3,3) /
     &  ( 4.3876E-02, 2.0453E-04),( 3.6312E-02, 2.0352E-04),
     &  ( 3.0971E-02, 2.0252E-04),( 2.7000E-02, 2.0152E-04),
     &  ( 2.3933E-02, 2.0052E-04),( 2.1492E-02, 1.9952E-04),
     &  ( 1.9504E-02, 1.9852E-04),( 1.7854E-02, 1.9753E-04),
     &  ( 1.6462E-02, 1.9673E-04),( 1.5272E-02, 1.9676E-04),
     &  ( 1.4243E-02, 2.3263E-04),( 1.3345E-02, 2.3315E-04),
     &  ( 1.2554E-02, 2.3369E-04),( 1.1852E-02, 2.3424E-04),
     &  ( 1.1225E-02, 2.3480E-04),( 1.0661E-02, 2.3538E-04),
     &  ( 9.7708E-03, 2.3645E-04),( 8.6596E-03, 2.3818E-04),
     &  ( 8.0657E-03, 2.4243E-04),( 7.0958E-03, 2.5730E-04),
     &  ( 6.3378E-03, 2.7246E-04),( 5.5961E-03, 2.9188E-04),
     &  ( 4.5444E-03, 3.4624E-04),( 3.3882E-03, 4.9404E-04),
     &  ( 2.7055E-03, 6.4920E-04),( 2.4207E-03, 6.6155E-04),
     &  ( 2.2607E-03, 6.7934E-04),( 2.1571E-03, 7.0010E-04),
     &  ( 2.0839E-03, 7.2258E-04),( 2.0290E-03, 7.4612E-04),
     &  ( 1.9860E-03, 7.7031E-04),( 1.9511E-03, 7.9984E-04),
     &  ( 1.9220E-03, 8.3106E-04),( 1.8972E-03, 8.6184E-04),
     &  ( 1.8756E-03, 8.9215E-04),( 1.8565E-03, 9.2213E-04),
     &  ( 1.8394E-03, 9.5181E-04),( 1.8238E-03, 9.8120E-04),
     &  ( 1.8094E-03, 1.0104E-03),( 1.7960E-03, 1.0394E-03),
     &  ( 1.7833E-03, 1.0684E-03),( 1.7713E-03, 1.0972E-03),
     &  ( 1.7597E-03, 1.1260E-03),( 1.7484E-03, 1.1550E-03),
     &  ( 1.7374E-03, 1.1840E-03),( 1.7265E-03, 1.2131E-03),
     &  ( 1.7157E-03, 1.2425E-03),( 1.7048E-03, 1.2723E-03),
     &  ( 1.6937E-03, 1.3025E-03),( 1.6825E-03, 1.3333E-03),
     &  ( 1.6708E-03, 1.3648E-03),( 1.6587E-03, 1.3973E-03),
     &  ( 1.6457E-03, 1.4311E-03),( 1.6318E-03, 1.4666E-03),
     &  ( 1.6164E-03, 1.5046E-03),( 1.5986E-03, 1.5466E-03),
     &  ( 1.5762E-03, 1.5962E-03),( 1.5257E-03, 1.6914E-03),
     &  ( 1.4821E-03, 1.7454E-03),( 1.4672E-03, 1.7527E-03),
     &  ( 1.4572E-03, 1.7509E-03),( 1.4500E-03, 1.7437E-03),
     &  ( 1.4444E-03, 1.7326E-03),( 1.4402E-03, 1.7182E-03),
     &  ( 1.4369E-03, 1.7011E-03),( 1.4342E-03, 1.6815E-03),
     &  ( 1.4321E-03, 1.6596E-03),( 1.4301E-03, 1.6355E-03),
     &  ( 1.4286E-03, 1.6093E-03),( 1.4270E-03, 1.5810E-03),
     &  ( 1.4251E-03, 1.5509E-03),( 1.4226E-03, 1.5188E-03),
     &  ( 1.4213E-03, 1.4849E-03),( 1.4201E-03, 1.4491E-03),
     &  ( 1.4197E-03, 1.4116E-03),( 1.4182E-03, 1.3723E-03),
     &  ( 1.4157E-03, 1.3313E-03),( 1.4122E-03, 1.2886E-03),
     &  ( 1.4075E-03, 1.2443E-03),( 1.4016E-03, 1.1984E-03),
     &  ( 1.3943E-03, 1.1510E-03),( 1.3854E-03, 1.1021E-03),
     &  ( 1.3746E-03, 1.0518E-03),( 1.3614E-03, 1.0003E-03),
     &  ( 1.3462E-03, 9.4753E-04),( 1.3275E-03, 8.9370E-04),
     &  ( 1.3053E-03, 8.3894E-04),( 1.2787E-03, 7.8343E-04),
     &  ( 1.2465E-03, 7.2734E-04),( 1.2067E-03, 6.7096E-04),
     &  ( 1.1558E-03, 6.1461E-04),( 1.0860E-03, 5.6181E-04),
     &  ( 1.0654E-03, 5.5018E-04),( 1.0127E-03, 5.2623E-04),
     &  ( 9.4220E-04, 5.3399E-04),( 9.3466E-04, 5.4702E-04),
     &  ( 8.7906E-04, 5.5924E-04),( 8.5857E-04, 5.5983E-04),
     &  ( 8.4541E-04, 5.4470E-04),( 8.4485E-04, 5.2630E-04)/
  
         DATA ((CGS  (I,J), I=1101,1200), J=3,3) /
     &  ( 8.4697E-04, 5.6638E-04),( 8.3676E-04, 6.0939E-04),
     &  ( 8.2196E-04, 6.3913E-04),( 8.1279E-04, 6.4134E-04),
     &  ( 7.9499E-04, 6.4802E-04),( 7.8126E-04, 6.4119E-04),
     &  ( 7.6983E-04, 6.4896E-04),( 7.6086E-04, 6.5662E-04),
     &  ( 7.5745E-04, 6.7117E-04),( 7.4733E-04, 6.9881E-04),
     &  ( 7.3235E-04, 6.9704E-04),( 7.6094E-04, 6.8085E-04),
     &  ( 7.5988E-04, 8.8144E-04),( 7.2330E-04, 9.3656E-04),
     &  ( 6.8671E-04, 6.9153E-04),( 6.5012E-04, 6.3272E-04),
     &  ( 6.6665E-04, 6.7596E-04),( 6.6904E-04, 6.9571E-04),
     &  ( 6.6294E-04, 6.9753E-04),( 6.8823E-04, 6.6301E-04),
     &  ( 7.1916E-04, 5.9723E-04),( 7.6223E-04, 7.0601E-04),
     &  ( 7.1837E-04, 8.8459E-04),( 6.4663E-04, 8.5400E-04),
     &  ( 6.3908E-04, 8.1828E-04),( 6.4318E-04, 8.2263E-04),
     &  ( 6.4032E-04, 8.4091E-04),( 6.2792E-04, 8.5574E-04),
     &  ( 6.1543E-04, 8.1120E-04),( 6.5599E-04, 7.4676E-04),
     &  ( 7.4539E-04, 7.6661E-04),( 9.0625E-04, 7.7778E-04),
     &  ( 1.0084E-03, 1.0063E-03),( 8.7219E-04, 1.7000E-03),
     &  ( 4.2447E-04, 1.6865E-03),( 4.0445E-04, 1.3412E-03),
     &  ( 4.0656E-04, 1.2246E-03),( 4.3284E-04, 1.0552E-03),
     &  ( 4.2094E-04, 7.9121E-04),( 4.0130E-04, 7.0224E-04),
     &  ( 3.8680E-04, 6.9329E-04),( 3.9677E-04, 6.7987E-04),
     &  ( 4.1174E-04, 7.5110E-04),( 4.0928E-04, 8.0631E-04),
     &  ( 4.0490E-04, 8.1986E-04),( 3.9627E-04, 8.1264E-04),
     &  ( 3.9119E-04, 7.9767E-04),( 3.9080E-04, 7.8919E-04),
     &  ( 3.9083E-04, 7.8311E-04),( 3.9360E-04, 7.7664E-04),
     &  ( 3.9659E-04, 7.7497E-04),( 4.0054E-04, 8.0871E-04),
     &  ( 3.9603E-04, 8.4165E-04),( 3.7145E-04, 8.7123E-04),
     &  ( 3.6109E-04, 7.8935E-04),( 3.6049E-04, 7.4612E-04),
     &  ( 3.6194E-04, 7.1523E-04),( 3.7391E-04, 6.5480E-04),
     &  ( 4.1076E-04, 6.6670E-04),( 4.8196E-04, 7.2502E-04),
     &  ( 4.9476E-04, 9.4581E-04),( 4.5890E-04, 1.0547E-03),
     &  ( 4.2867E-04, 1.0799E-03),( 3.9775E-04, 1.1167E-03),
     &  ( 3.5239E-04, 1.1754E-03),( 3.3565E-04, 1.1649E-03),
     &  ( 3.5614E-04, 1.1558E-03),( 4.0189E-04, 1.0942E-03),
     &  ( 4.0186E-04, 7.0941E-04),( 3.3052E-04, 6.7191E-04),
     &  ( 3.2794E-04, 7.3601E-04),( 3.4045E-04, 9.3619E-04),
     &  ( 3.8891E-04, 7.0257E-04),( 3.3831E-04, 5.5564E-04),
     &  ( 3.2132E-04, 5.5409E-04),( 3.1897E-04, 5.5358E-04),
     &  ( 3.1780E-04, 5.8064E-04),( 3.1670E-04, 6.2484E-04),
     &  ( 3.1553E-04, 6.4506E-04),( 3.1167E-04, 5.3292E-04),
     &  ( 3.1611E-04, 5.3914E-04),( 3.1440E-04, 5.5611E-04),
     &  ( 3.1428E-04, 5.5127E-04),( 3.2438E-04, 4.9821E-04),
     &  ( 3.6011E-04, 4.6277E-04),( 3.9371E-04, 4.8781E-04),
     &  ( 4.7105E-04, 5.2559E-04),( 5.1368E-04, 7.7810E-04),
     &  ( 3.2772E-04, 9.7702E-04),( 3.0419E-04, 9.8447E-04),
     &  ( 2.9066E-04, 6.6250E-04),( 3.3458E-04, 5.5842E-04),
     &  ( 3.5925E-04, 5.7825E-04),( 4.7906E-04, 7.5883E-04),
     &  ( 4.8079E-04, 1.0686E-03),( 4.7544E-04, 1.1757E-03),
     &  ( 4.6819E-04, 1.2894E-03),( 3.0703E-04, 1.6372E-03),
     &  ( 2.9792E-04, 1.7554E-03),( 5.2279E-04, 1.3730E-03)/
  
         DATA ((CGS  (I,J), I=1201,1300), J=3,3) /
     &  ( 4.8644E-04, 7.5908E-04),( 3.4091E-04, 7.5616E-04),
     &  ( 3.1726E-04, 7.5396E-04),( 3.1007E-04, 7.5360E-04),
     &  ( 2.9770E-04, 7.5227E-04),( 2.9243E-04, 7.5095E-04),
     &  ( 2.9419E-04, 7.4872E-04),( 2.9457E-04, 7.0142E-04),
     &  ( 2.8805E-04, 6.7057E-04),( 2.8406E-04, 6.6553E-04),
     &  ( 2.7683E-04, 6.5042E-04),( 2.7486E-04, 6.4538E-04),
     &  ( 2.6675E-04, 6.2054E-04),( 2.6637E-04, 6.4898E-04),
     &  ( 2.6719E-04, 6.6111E-04),( 2.6058E-04, 6.4101E-04),
     &  ( 2.6814E-04, 7.3631E-04),( 2.8747E-04, 1.2868E-03),
     &  ( 3.2420E-04, 7.5180E-04),( 2.8676E-04, 6.1636E-04),
     &  ( 2.4947E-04, 6.1960E-04),( 2.4507E-04, 6.2129E-04),
     &  ( 2.4334E-04, 8.1364E-04),( 2.4006E-04, 9.4271E-04),
     &  ( 2.4474E-04, 6.6768E-04),( 2.3772E-04, 6.6725E-04),
     &  ( 2.2891E-04, 9.1704E-04),( 2.7931E-04, 1.1583E-03),
     &  ( 2.5188E-04, 8.0979E-04),( 2.2273E-04, 1.7803E-03),
     &  ( 7.0255E-04, 2.2057E-03),( 1.1259E-03, 4.5259E-05),
     &  ( 1.2670E-03, 4.4592E-05),( 1.0089E-03, 4.3320E-05),
     &  ( 7.7697E-04, 4.1000E-05),( 7.1047E-04, 3.9942E-05),
     &  ( 6.5952E-04, 3.8945E-05),( 5.8559E-04, 3.7118E-05),
     &  ( 5.3384E-04, 3.5489E-05),( 5.1324E-04, 3.4740E-05),
     &  ( 4.9521E-04, 3.4032E-05),( 4.7929E-04, 3.3361E-05),
     &  ( 4.6512E-04, 3.2725E-05),( 4.5241E-04, 3.2122E-05),
     &  ( 4.4094E-04, 3.1550E-05),( 4.3053E-04, 3.1007E-05),
     &  ( 4.2106E-04, 3.0491E-05),( 4.1238E-04, 3.0000E-05),
     &  ( 4.0442E-04, 2.9533E-05),( 3.9708E-04, 2.9088E-05),
     &  ( 3.9030E-04, 2.8664E-05),( 3.8401E-04, 2.8261E-05),
     &  ( 3.7818E-04, 2.7875E-05),( 3.7275E-04, 2.7508E-05),
     &  ( 3.6769E-04, 2.7157E-05),( 3.6296E-04, 2.6821E-05),
     &  ( 3.5855E-04, 2.6500E-05),( 3.5441E-04, 2.6194E-05),
     &  ( 3.5054E-04, 2.5900E-05),( 3.4691E-04, 2.5619E-05),
     &  ( 3.4351E-04, 2.5349E-05),( 3.4031E-04, 2.5091E-05),
     &  ( 3.3732E-04, 2.4843E-05),( 3.3451E-04, 2.4605E-05),
     &  ( 3.3187E-04, 2.4376E-05),( 3.2940E-04, 2.4156E-05),
     &  ( 3.2709E-04, 2.3945E-05),( 3.2494E-04, 2.3742E-05),
     &  ( 3.2292E-04, 2.3546E-05),( 3.2105E-04, 2.3358E-05),
     &  ( 3.1932E-04, 2.3176E-05),( 3.1772E-04, 2.3002E-05),
     &  ( 3.1625E-04, 2.2833E-05),( 3.1516E-04, 2.2702E-05),
     &  ( 3.1369E-04, 2.2513E-05),( 3.1164E-04, 2.2214E-05),
     &  ( 3.1009E-04, 2.1935E-05),( 3.0907E-04, 2.1674E-05),
     &  ( 3.0861E-04, 2.1429E-05),( 3.0874E-04, 2.1198E-05),
     &  ( 3.0953E-04, 2.0981E-05),( 3.1108E-04, 2.0776E-05),
     &  ( 3.1349E-04, 2.0583E-05),( 3.1694E-04, 2.0399E-05),
     &  ( 3.2166E-04, 2.0226E-05),( 3.2797E-04, 2.0060E-05),
     &  ( 3.3635E-04, 1.9903E-05),( 3.4752E-04, 1.9754E-05),
     &  ( 3.6269E-04, 1.9611E-05),( 3.6449E-04, 1.9597E-05),
     &  ( 3.8398E-04, 1.9474E-05),( 4.1577E-04, 1.9343E-05),
     &  ( 4.6920E-04, 1.9218E-05),( 5.5170E-04, 1.9122E-05),
     &  ( 5.8511E-04, 1.9098E-05),( 7.2416E-04, 1.9040E-05),
     &  ( 9.9069E-04, 1.8994E-05),( 1.1171E-03, 1.8983E-05),
     &  ( 1.2972E-03, 1.8971E-05),( 1.4189E-03, 1.8966E-05)/
  
         DATA ((CGS  (I,J), I=1301,1400), J=3,3) /
     &  ( 1.5722E-03, 1.8960E-05),( 1.7266E-03, 1.8955E-05),
     &  ( 1.9207E-03, 1.8951E-05),( 2.0376E-03, 1.8949E-05),
     &  ( 2.1716E-03, 1.8946E-05),( 2.3265E-03, 1.8944E-05),
     &  ( 2.5075E-03, 1.8942E-05),( 2.7216E-03, 1.8940E-05),
     &  ( 2.9788E-03, 1.8938E-05),( 3.1277E-03, 1.8936E-05),
     &  ( 3.2932E-03, 1.8935E-05),( 3.4780E-03, 1.8934E-05),
     &  ( 3.6858E-03, 1.8933E-05),( 3.9211E-03, 1.8932E-05),
     &  ( 4.1897E-03, 1.8931E-05),( 4.4990E-03, 1.8930E-05),
     &  ( 4.8590E-03, 1.8929E-05),( 5.2832E-03, 1.8928E-05),
     &  ( 5.4599E-03, 1.8927E-05),( 5.5708E-03, 1.8927E-05),
     &  ( 5.6864E-03, 1.8927E-05),( 5.8070E-03, 1.8926E-05),
     &  ( 5.9329E-03, 2.8478E-05),( 6.0645E-03, 2.8911E-05),
     &  ( 6.2020E-03, 2.9373E-05),( 6.3461E-03, 2.9869E-05),
     &  ( 6.4971E-03, 3.0401E-05),( 6.6556E-03, 3.0973E-05),
     &  ( 6.8221E-03, 3.1588E-05),( 6.9972E-03, 3.2252E-05),
     &  ( 7.1817E-03, 3.2970E-05),( 7.3763E-03, 3.3747E-05),
     &  ( 7.5817E-03, 3.4590E-05),( 7.7991E-03, 3.5508E-05),
     &  ( 8.0295E-03, 3.6508E-05),( 8.2739E-03, 3.7602E-05),
     &  ( 8.5339E-03, 3.8800E-05),( 8.8108E-03, 4.0119E-05),
     &  ( 9.1064E-03, 4.1572E-05),( 9.4227E-03, 4.3180E-05),
     &  ( 9.7619E-03, 4.4966E-05),( 1.0127E-02, 4.6957E-05),
     &  ( 1.0520E-02, 4.9184E-05),( 1.0945E-02, 5.1688E-05),
     &  ( 1.1406E-02, 5.4516E-05),( 1.1907E-02, 5.7727E-05),
     &  ( 1.2455E-02, 6.1391E-05),( 1.3056E-02, 6.5600E-05),
     &  ( 1.3719E-02, 7.0468E-05),( 1.4452E-02, 7.6137E-05),
     &  ( 1.5268E-02, 8.2796E-05),( 1.6182E-02, 9.0688E-05),
     &  ( 1.7213E-02, 1.0014E-04),( 1.8384E-02, 1.1158E-04),
     &  ( 1.9727E-02, 1.2563E-04),( 2.1281E-02, 1.4313E-04),
     &  ( 2.3102E-02, 1.6531E-04),( 2.5263E-02, 1.9402E-04),
     &  ( 2.7871E-02, 2.3206E-04),( 3.1079E-02, 2.8400E-04),
     &  ( 3.5123E-02, 3.5751E-04),( 4.0376E-02, 4.6644E-04),
     &  ( 4.7476E-02, 6.3780E-04),( 5.7604E-02, 9.3027E-04),
     &  ( 7.3219E-02, 1.4920E-03),( 1.0042E-01, 2.7929E-03),
     &  ( 1.5962E-01, 7.0503E-03),( 1.9633E-01, 2.8277E-04),
     &  ( 3.7394E-01, 2.8277E-04),( 5.2032E-01, 2.8277E-04),
     &  ( 6.2641E-01, 2.8277E-04),( 7.0851E-01, 2.8277E-04),
     &  ( 7.7596E-01, 2.8277E-04),( 8.3498E-01, 2.8277E-04),
     &  ( 8.8975E-01, 2.8277E-04),( 9.2788E-01, 2.8278E-04),
     &  ( 9.6669E-01, 2.8278E-04),( 1.0049E+00, 2.8278E-04),
     &  ( 1.0233E+00, 2.8278E-04),( 1.0491E+00, 2.8278E-04),
     &  ( 1.0645E+00, 2.8278E-04),( 1.0837E+00, 2.8278E-04),
     &  ( 1.0887E+00, 2.8278E-04),( 1.0961E+00, 2.8278E-04),
     &  ( 1.0992E+00, 2.8278E-04),( 1.0968E+00, 2.8278E-04),
     &  ( 1.0933E+00, 2.8278E-04),( 1.0880E+00, 2.8278E-04),
     &  ( 1.0711E+00, 2.8278E-04),( 1.0592E+00, 2.8278E-04),
     &  ( 1.0447E+00, 2.8278E-04),( 1.0072E+00, 2.8278E-04),
     &  ( 9.8386E-01, 2.8278E-04),( 9.5724E-01, 2.8278E-04),
     &  ( 9.2678E-01, 2.8278E-04),( 8.5536E-01, 2.8278E-04),
     &  ( 8.1342E-01, 2.8278E-04),( 7.6794E-01, 2.8278E-04),
     &  ( 6.6459E-01, 2.8278E-04),( 6.0737E-01, 2.8278E-04)/
  
         DATA ((CGS  (I,J), I=1401,1500), J=3,3) /
     &  ( 4.8147E-01, 2.8278E-04),( 3.4285E-01, 2.8278E-04),
     &  ( 3.6609E-02, 2.8278E-04),( 3.3830E-01, 2.8278E-04),
     &  ( 4.7727E-01, 2.8278E-04),( 6.0299E-01, 2.8278E-04),
     &  ( 7.1470E-01, 2.8278E-04),( 7.6492E-01, 2.8278E-04),
     &  ( 8.1064E-01, 2.8278E-04),( 8.5242E-01, 2.8278E-04),
     &  ( 9.2474E-01, 2.8278E-04),( 9.5513E-01, 2.8278E-04),
     &  ( 9.8227E-01, 2.8278E-04),( 1.0058E+00, 2.8278E-04),
     &  ( 1.0437E+00, 2.8278E-04),( 1.0583E+00, 2.8278E-04),
     &  ( 1.0704E+00, 2.8278E-04),( 1.0875E+00, 2.8278E-04),
     &  ( 1.0930E+00, 2.8278E-04),( 1.0987E+00, 2.8278E-04),
     &  ( 1.0992E+00, 2.8278E-04),( 1.0963E+00, 2.8278E-04),
     &  ( 1.0890E+00, 2.8278E-04),( 1.0783E+00, 2.8278E-04),
     &  ( 1.0650E+00, 2.8278E-04),( 1.0496E+00, 2.8278E-04),
     &  ( 1.0238E+00, 2.8278E-04),( 1.0056E+00, 2.8278E-04),
     &  ( 9.6731E-01, 2.8278E-04),( 9.2860E-01, 2.8278E-04),
     &  ( 8.9036E-01, 2.8278E-04),( 8.3555E-01, 2.8278E-04),
     &  ( 7.7648E-01, 2.8278E-04),( 7.0896E-01, 2.8278E-04),
     &  ( 6.2679E-01, 2.8278E-04),( 5.2059E-01, 2.8278E-04),
     &  ( 3.7194E-01, 2.8278E-04),( 2.0300E-01, 2.8279E-04),
     &  ( 1.1611E-01, 2.8279E-04),( 8.1241E-02, 2.8280E-04),
     &  ( 6.2466E-02, 2.8281E-04),( 5.0737E-02, 2.8282E-04),
     &  ( 4.2717E-02, 2.8282E-04),( 3.6886E-02, 2.8283E-04),
     &  ( 3.2456E-02, 2.8284E-04),( 2.8977E-02, 2.8285E-04),
     &  ( 2.6172E-02, 2.8285E-04),( 2.3863E-02, 2.8286E-04),
     &  ( 2.1928E-02, 2.8287E-04),( 2.0285E-02, 2.8288E-04),
     &  ( 1.8870E-02, 2.8288E-04),( 1.7641E-02, 2.8289E-04),
     &  ( 1.6562E-02, 2.8290E-04),( 1.5608E-02, 2.8291E-04),
     &  ( 1.4758E-02, 2.8291E-04),( 1.3997E-02, 2.8292E-04),
     &  ( 1.3310E-02, 2.8293E-04),( 1.2688E-02, 2.8294E-04),
     &  ( 1.2122E-02, 2.8294E-04),( 1.1604E-02, 2.8295E-04),
     &  ( 1.1129E-02, 2.8296E-04),( 1.0692E-02, 2.8297E-04),
     &  ( 1.0287E-02, 2.8297E-04),( 9.9130E-03, 2.8298E-04),
     &  ( 9.5650E-03, 2.8299E-04),( 9.2409E-03, 2.8300E-04),
     &  ( 8.9382E-03, 2.8300E-04),( 8.6549E-03, 2.8301E-04),
     &  ( 8.3892E-03, 2.8302E-04),( 8.1395E-03, 2.8303E-04),
     &  ( 7.9045E-03, 2.8303E-04),( 7.6828E-03, 2.8304E-04),
     &  ( 7.4733E-03, 2.8305E-04),( 7.2752E-03, 2.8306E-04),
     &  ( 7.0874E-03, 2.8307E-04),( 6.9093E-03, 2.8307E-04),
     &  ( 6.7400E-03, 2.8308E-04),( 6.5790E-03, 2.8309E-04),
     &  ( 6.4256E-03, 2.8310E-04),( 6.2794E-03, 2.8310E-04),
     &  ( 6.1398E-03, 2.8311E-04),( 6.0065E-03, 2.8312E-04),
     &  ( 5.8789E-03, 2.8313E-04),( 5.7568E-03, 2.8313E-04),
     &  ( 5.6398E-03, 2.8314E-04),( 5.5276E-03, 2.8315E-04),
     &  ( 5.4199E-03, 2.8316E-04),( 4.6089E-03, 2.8322E-04),
     &  ( 4.1136E-03, 2.8328E-04),( 3.6408E-03, 2.8335E-04),
     &  ( 3.1172E-03, 2.8345E-04),( 2.6359E-03, 2.8359E-04),
     &  ( 2.1826E-03, 2.8379E-04),( 1.9205E-03, 2.8396E-04),
     &  ( 1.5858E-03, 2.8409E-04),( 1.4743E-03, 2.8405E-04),
     &  ( 1.3507E-03, 2.8305E-04),( 1.2534E-03, 2.8205E-04),
     &  ( 1.1732E-03, 2.8105E-04),( 1.1058E-03, 2.8004E-04)/
  
         DATA ((CGS  (I,J), I=1501,1600), J=3,3) /
     &  ( 9.9850E-04, 2.7804E-04),( 9.1684E-04, 2.7604E-04),
     &  ( 6.9559E-04, 2.6607E-04),( 5.5109E-04, 2.6539E-04),
     &  ( 5.2772E-04, 2.6592E-04),( 6.5834E-04, 2.6457E-04),
     &  ( 9.5973E-04, 2.6544E-04),( 1.3872E-03, 2.6588E-04),
     &  ( 1.9732E-03, 2.6614E-04),( 2.7968E-03, 2.6631E-04),
     &  ( 4.8807E-03, 2.6618E-04),( 5.2771E-03, 2.6617E-04),
     &  ( 5.7442E-03, 2.6615E-04),( 5.8796E-03, 2.6615E-04),
     &  ( 6.1882E-03, 2.6614E-04),( 6.5312E-03, 2.6614E-04),
     &  ( 6.9146E-03, 2.6613E-04),( 7.3461E-03, 2.6612E-04),
     &  ( 7.8351E-03, 2.6611E-04),( 8.3941E-03, 2.6611E-04),
     &  ( 9.0392E-03, 2.6610E-04),( 9.7919E-03, 2.6609E-04),
     &  ( 1.0682E-02, 2.6609E-04),( 1.1749E-02, 2.6608E-04),
     &  ( 1.3055E-02, 2.6607E-04),( 1.4686E-02, 2.6606E-04),
     &  ( 1.6784E-02, 2.6606E-04),( 1.9582E-02, 2.6605E-04),
     &  ( 2.3498E-02, 2.6604E-04),( 2.9373E-02, 2.6603E-04),
     &  ( 3.9164E-02, 4.9506E-04),( 5.8743E-02, 7.8137E-04),
     &  ( 8.5006E-02, 1.3455E-03),( 8.9414E-02, 1.4604E-03),
     &  ( 9.4305E-02, 1.5947E-03),( 9.9760E-02, 1.7530E-03),
     &  ( 1.0589E-01, 1.9413E-03),( 1.1281E-01, 2.1678E-03),
     &  ( 1.2071E-01, 2.4435E-03),( 1.2979E-01, 2.7838E-03),
     &  ( 1.4034E-01, 3.2106E-03),( 1.5277E-01, 3.7557E-03),
     &  ( 1.6760E-01, 4.4675E-03),( 1.8561E-01, 5.4213E-03),
     &  ( 2.0795E-01, 6.7405E-03),( 2.3639E-01, 8.6386E-03),
     &  ( 2.7379E-01, 1.1511E-02),( 3.2515E-01, 1.6156E-02),
     &  ( 4.0000E-01, 2.4395E-02),( 5.1882E-01, 4.1145E-02),
     &  ( 7.3447E-01, 8.3667E-02),( 1.2223E+00, 2.4864E-01),
     &  ( 1.3933E+00, 3.3648E-01),( 1.5279E+00, 4.2163E-01),
     &  ( 1.6780E+00, 5.4013E-01),( 1.8039E+00, 6.6992E-01),
     &  ( 1.8947E+00, 7.9538E-01),( 1.9717E+00, 9.5181E-01),
     &  ( 2.0072E+00, 1.0766E+00),( 2.0213E+00, 1.2196E+00),
     &  ( 2.0035E+00, 1.3816E+00),( 1.9408E+00, 1.5613E+00),
     &  ( 1.8174E+00, 1.6857E+00),( 1.8174E+00, 1.7053E+00),
     &  ( 1.8174E+00, 1.7151E+00),( 1.8174E+00, 1.7347E+00),
     &  ( 1.8174E+00, 1.7426E+00),( 1.8174E+00, 1.7485E+00),
     &  ( 1.8174E+00, 1.7544E+00),( 1.7661E+00, 1.8137E+00),
     &  ( 1.6755E+00, 1.9028E+00),( 1.5542E+00, 2.0004E+00),
     &  ( 1.4257E+00, 2.0852E+00),( 1.2611E+00, 2.1739E+00),
     &  ( 1.0741E+00, 2.2539E+00),( 8.8789E-01, 2.3164E+00),
     &  ( 6.6369E-01, 2.3465E+00),( 6.6369E-01, 2.3728E+00),
     &  ( 3.7593E-01, 2.3951E+00),( 3.7593E-01, 2.4192E+00),
     &  ( 1.2630E-01, 2.4310E+00),( 1.2630E-01, 2.4381E+00),
     &  ( 1.2627E-01, 2.4401E+00),( 1.2627E-01, 2.4404E+00),
     &  ( 1.2627E-01, 2.4404E+00),( 1.2627E-01, 2.4405E+00),
     &  ( 1.2627E-01, 2.4404E+00),( 1.2627E-01, 2.4404E+00),
     &  ( 1.2627E-01, 2.4381E+00),( 3.7590E-01, 2.4310E+00),
     &  ( 3.7590E-01, 2.4192E+00),( 9.3061E-01, 2.3035E+00),
     &  ( 1.1324E+00, 2.2310E+00),( 1.4558E+00, 2.0667E+00),
     &  ( 1.5802E+00, 1.9811E+00),( 1.6971E+00, 1.8831E+00),
     &  ( 1.7926E+00, 1.7840E+00),( 1.8617E+00, 1.6955E+00),
     &  ( 1.9214E+00, 1.5991E+00),( 1.9615E+00, 1.5149E+00)/
  
         DATA ((CGS  (I,J), I=1601,1700), J=3,3) /
     &  ( 1.9926E+00, 1.4250E+00),( 2.0102E+00, 1.3477E+00),
     &  ( 2.0198E+00, 1.2662E+00),( 2.0209E+00, 1.1969E+00),
     &  ( 2.0150E+00, 1.1245E+00),( 2.0044E+00, 1.0633E+00),
     &  ( 1.9695E+00, 9.4604E-01),( 1.9460E+00, 8.9044E-01),
     &  ( 1.9199E+00, 8.3876E-01),( 1.8947E+00, 7.9539E-01),
     &  ( 1.8380E+00, 7.1275E-01),( 1.8070E+00, 6.7369E-01),
     &  ( 1.7566E+00, 6.1683E-01),( 1.6780E+00, 5.4014E-01),
     &  ( 1.3933E+00, 3.3649E-01),( 1.1729E+00, 2.2668E-01),
     &  ( 1.0059E+00, 1.6209E-01),( 8.7764E-01, 1.2128E-01),
     &  ( 7.7697E-01, 9.4009E-02),( 6.9625E-01, 7.4937E-02),
     &  ( 6.1566E-01, 5.8242E-02),( 4.8983E-01, 3.6635E-02),
     &  ( 4.5578E-01, 3.1690E-02),( 4.2610E-01, 2.7685E-02),
     &  ( 4.0001E-01, 2.4398E-02),( 3.6125E-01, 1.9910E-02),
     &  ( 2.9901E-01, 1.3690E-02),( 2.5499E-01, 1.0014E-02),
     &  ( 2.2223E-01, 7.6628E-03),( 1.9691E-01, 6.0698E-03),
     &  ( 1.7677E-01, 4.9407E-03),( 1.6035E-01, 4.1116E-03),
     &  ( 1.4673E-01, 3.4849E-03),( 1.3523E-01, 2.9997E-03),
     &  ( 1.2540E-01, 2.6165E-03),( 1.1691E-01, 2.3085E-03),
     &  ( 1.0949E-01, 2.0573E-03),( 1.0296E-01, 1.8498E-03),
     &  ( 9.7157E-02, 1.6763E-03),( 9.1977E-02, 1.5298E-03),
     &  ( 8.7321E-02, 1.4051E-03),( 5.8762E-02, 7.8168E-04),
     &  ( 3.9184E-02, 4.9524E-04),( 2.9392E-02, 3.9496E-04),
     &  ( 1.9601E-02, 2.6596E-04),( 1.4705E-02, 2.6595E-04),
     &  ( 1.1769E-02, 2.6593E-04),( 9.8112E-03, 2.6592E-04),
     &  ( 8.4134E-03, 2.6590E-04),( 7.3653E-03, 2.6589E-04),
     &  ( 6.5504E-03, 2.6588E-04),( 5.8988E-03, 2.6586E-04),
     &  ( 5.5292E-03, 2.6585E-04),( 5.0982E-03, 2.6584E-04),
     &  ( 4.7301E-03, 2.6582E-04),( 4.4120E-03, 2.6581E-04),
     &  ( 4.1346E-03, 2.6580E-04),( 3.8904E-03, 2.6579E-04),
     &  ( 3.0080E-03, 2.6572E-04),( 2.4576E-03, 2.6566E-04),
     &  ( 2.0824E-03, 2.6560E-04),( 1.8108E-03, 2.6553E-04),
     &  ( 1.6055E-03, 2.6547E-04),( 1.4453E-03, 2.6541E-04),
     &  ( 1.3170E-03, 2.6535E-04),( 1.2122E-03, 2.6528E-04),
     &  ( 5.5925E-04, 2.6436E-04),( 5.4981E-04, 2.6455E-04),
     &  ( 5.5892E-04, 2.6459E-04),( 5.7381E-04, 2.6462E-04),
     &  ( 5.9665E-04, 2.6466E-04),( 6.3124E-04, 2.6470E-04),
     &  ( 6.5478E-04, 2.6472E-04),( 6.8389E-04, 2.6474E-04),
     &  ( 7.6687E-04, 2.7008E-04),( 9.0779E-04, 2.7544E-04),
     &  ( 1.1802E-03, 2.8080E-04),( 1.8527E-03, 2.8619E-04),
     &  ( 2.5198E-03, 2.8845E-04),( 2.6937E-03, 2.8885E-04),
     &  ( 2.8947E-03, 2.8924E-04),( 3.1298E-03, 2.8964E-04),
     &  ( 3.4082E-03, 2.9004E-04),( 3.7428E-03, 2.9043E-04),
     &  ( 4.1525E-03, 2.9083E-04),( 4.6654E-03, 2.9122E-04),
     &  ( 5.3257E-03, 2.9162E-04),( 6.2071E-03, 2.9202E-04),
     &  ( 7.4423E-03, 2.9241E-04),( 9.2967E-03, 3.1222E-04),
     &  ( 1.2389E-02, 3.2771E-04),( 1.2927E-02, 3.3083E-04),
     &  ( 1.3514E-02, 3.3437E-04),( 1.4157E-02, 3.3843E-04),
     &  ( 1.4865E-02, 3.4310E-04),( 1.5646E-02, 3.4852E-04),
     &  ( 1.6515E-02, 3.5486E-04),( 1.7486E-02, 3.6234E-04),
     &  ( 1.8578E-02, 3.7126E-04),( 1.9816E-02, 3.8201E-04)/
  
         DATA ((CGS  (I,J), I=1701,1800), J=3,3) /
     &  ( 2.1230E-02, 3.9513E-04),( 2.2863E-02, 4.1139E-04),
     &  ( 2.4767E-02, 4.3186E-04),( 2.7018E-02, 4.5815E-04),
     &  ( 2.9718E-02, 4.9271E-04),( 3.3019E-02, 5.3939E-04),
     &  ( 3.4050E-02, 5.5498E-04),( 3.7145E-02, 6.0463E-04),
     &  ( 4.2448E-02, 6.9975E-04),( 4.9518E-02, 8.4628E-04),
     &  ( 5.9413E-02, 1.0892E-03),( 7.4247E-02, 1.5362E-03),
     &  ( 9.8935E-02, 2.5009E-03),( 1.4815E-01, 5.2511E-03),
     &  ( 2.9363E-01, 1.9944E-02),( 3.4909E-01, 2.8211E-02),
     &  ( 4.9238E-01, 5.6852E-02),( 6.0135E-01, 8.6275E-02),
     &  ( 6.9114E-01, 1.1612E-01),( 7.6951E-01, 1.4688E-01),
     &  ( 8.3904E-01, 1.7837E-01),( 9.0141E-01, 2.1053E-01),
     &  ( 9.5712E-01, 2.4289E-01),( 1.0088E+00, 2.7653E-01),
     &  ( 1.0575E+00, 3.1216E-01),( 1.1021E+00, 3.4876E-01),
     &  ( 1.1413E+00, 3.8494E-01),( 1.1776E+00, 4.2270E-01),
     &  ( 1.2103E+00, 4.6139E-01),( 1.2389E+00, 5.0025E-01),
     &  ( 1.2661E+00, 5.4338E-01),( 1.2884E+00, 5.8569E-01),
     &  ( 1.3058E+00, 6.2605E-01),( 1.3320E+00, 6.6974E-01),
     &  ( 1.3320E+00, 7.1696E-01),( 1.3390E+00, 7.6789E-01),
     &  ( 1.3378E+00, 8.1456E-01),( 1.3378E+00, 8.6406E-01),
     &  ( 1.3139E+00, 9.1633E-01),( 1.3139E+00, 9.7125E-01),
     &  ( 1.2909E+00, 1.0286E+00),( 1.2250E+00, 1.0780E+00),
     &  ( 1.2250E+00, 1.1388E+00),( 1.1741E+00, 1.2006E+00),
     &  ( 1.0218E+00, 1.2626E+00),( 1.0218E+00, 1.3339E+00),
     &  ( 9.1407E-01, 1.4020E+00),( 7.6838E-01, 1.4731E+00),
     &  ( 5.7747E-01, 1.5403E+00),( 4.8602E-04, 1.6178E+00),
     &  ( 4.8602E-04, 1.6193E+00),( 2.6140E-01, 1.6037E+00),
     &  ( 5.7746E-01, 1.5403E+00),( 9.1407E-01, 1.4731E+00),
     &  ( 9.1407E-01, 1.4020E+00),( 1.0218E+00, 1.3339E+00),
     &  ( 1.1741E+00, 1.2627E+00),( 1.1741E+00, 1.2006E+00),
     &  ( 1.2250E+00, 1.1388E+00),( 1.2909E+00, 1.0780E+00),
     &  ( 1.2909E+00, 1.0286E+00),( 1.3139E+00, 9.7126E-01),
     &  ( 1.3378E+00, 9.1633E-01),( 1.3378E+00, 8.6406E-01),
     &  ( 1.3390E+00, 8.1457E-01),( 1.3390E+00, 7.6789E-01),
     &  ( 1.3320E+00, 7.1697E-01),( 1.3206E+00, 6.6974E-01),
     &  ( 1.2884E+00, 6.2605E-01),( 1.2884E+00, 5.8570E-01),
     &  ( 1.2661E+00, 5.4339E-01),( 1.2389E+00, 5.0025E-01),
     &  ( 1.2103E+00, 4.6139E-01),( 1.1776E+00, 4.2270E-01),
     &  ( 1.1413E+00, 3.8495E-01),( 1.1021E+00, 3.4876E-01),
     &  ( 1.0575E+00, 3.1216E-01),( 1.0088E+00, 2.7653E-01),
     &  ( 9.5713E-01, 2.4289E-01),( 9.0141E-01, 2.1053E-01),
     &  ( 8.3904E-01, 1.7838E-01),( 7.6951E-01, 1.4688E-01),
     &  ( 6.9115E-01, 1.1613E-01),( 6.0136E-01, 8.6278E-02),
     &  ( 4.9239E-01, 5.6854E-02),( 3.4910E-01, 2.8213E-02),
     &  ( 2.9892E-01, 2.0667E-02),( 2.8951E-01, 1.9389E-02),
     &  ( 2.7783E-01, 1.7864E-02),( 2.4559E-01, 1.3989E-02),
     &  ( 2.1653E-01, 1.0920E-02),( 1.4815E-01, 5.2513E-03),
     &  ( 9.8943E-02, 2.5015E-03),( 7.4253E-02, 1.5368E-03),
     &  ( 5.9420E-02, 1.0899E-03),( 4.9526E-02, 8.4705E-04),
     &  ( 4.2456E-02, 7.0060E-04),( 3.7152E-02, 6.0555E-04),
     &  ( 3.3027E-02, 5.4040E-04),( 2.9726E-02, 4.9380E-04)/
  
         DATA ((CGS  (I,J), I=1801,1900), J=3,3) /
     &  ( 2.7025E-02, 4.5934E-04),( 2.4775E-02, 4.3314E-04),
     &  ( 2.2870E-02, 4.1276E-04),( 2.1238E-02, 3.9659E-04),
     &  ( 1.9823E-02, 3.8356E-04),( 1.8586E-02, 3.7291E-04),
     &  ( 1.2397E-02, 3.3014E-04),( 9.3047E-03, 3.1542E-04),
     &  ( 7.4503E-03, 3.0883E-04),( 6.2151E-03, 3.0542E-04),
     &  ( 5.3337E-03, 2.9718E-04),( 4.6734E-03, 2.9757E-04),
     &  ( 4.1606E-03, 2.9797E-04),( 3.4164E-03, 2.9877E-04),
     &  ( 2.9031E-03, 2.9956E-04),( 2.7021E-03, 2.9996E-04),
     &  ( 2.5283E-03, 3.0036E-04),( 1.9085E-03, 3.0242E-04),
     &  ( 1.4644E-03, 3.0514E-04),( 1.2071E-03, 3.0786E-04),
     &  ( 1.0421E-03, 3.1059E-04),( 9.2929E-04, 3.1331E-04),
     &  ( 8.4861E-04, 3.1604E-04),( 7.8910E-04, 3.1878E-04),
     &  ( 7.4420E-04, 3.2073E-04),( 7.0977E-04, 3.2268E-04),
     &  ( 6.8316E-04, 3.3187E-04),( 6.6254E-04, 3.3399E-04),
     &  ( 6.4663E-04, 3.3612E-04),( 6.3451E-04, 3.3826E-04),
     &  ( 6.2553E-04, 3.4040E-04),( 6.1923E-04, 3.4254E-04),
     &  ( 6.1526E-04, 3.4470E-04),( 6.1341E-04, 3.4686E-04),
     &  ( 6.1353E-04, 3.4903E-04),( 6.1555E-04, 3.5121E-04),
     &  ( 6.1944E-04, 3.5340E-04),( 6.2523E-04, 3.5560E-04),
     &  ( 6.4842E-04, 3.8018E-04),( 1.0811E-03, 5.1621E-04),
     &  ( 1.1831E-03, 6.0794E-04),( 1.3692E-03, 6.9705E-04),
     &  ( 1.5220E-03, 7.8524E-04),( 1.6504E-03, 8.7292E-04),
     &  ( 1.7594E-03, 9.6028E-04),( 1.8527E-03, 1.0476E-03),
     &  ( 1.9323E-03, 1.1349E-03),( 1.9993E-03, 1.2214E-03),
     &  ( 2.0556E-03, 1.3080E-03),( 2.1021E-03, 1.3947E-03),
     &  ( 2.1390E-03, 1.4808E-03),( 2.1669E-03, 1.5662E-03),
     &  ( 2.1864E-03, 1.6511E-03),( 2.1979E-03, 1.7366E-03),
     &  ( 2.2015E-03, 1.8214E-03),( 2.1974E-03, 1.9045E-03),
     &  ( 2.1858E-03, 1.9875E-03),( 2.1662E-03, 2.0713E-03),
     &  ( 2.1392E-03, 2.1536E-03),( 2.1052E-03, 2.2336E-03),
     &  ( 2.0621E-03, 2.3156E-03),( 2.0125E-03, 2.3939E-03),
     &  ( 1.9535E-03, 2.4732E-03),( 1.8859E-03, 2.5510E-03),
     &  ( 1.8082E-03, 2.6285E-03),( 1.7199E-03, 2.7050E-03),
     &  ( 1.6209E-03, 2.7795E-03),( 1.5112E-03, 2.8513E-03),
     &  ( 1.3827E-03, 2.9237E-03),( 1.2372E-03, 2.9934E-03),
     &  ( 1.0723E-03, 3.0591E-03),( 8.7367E-04, 3.1225E-03),
     &  ( 6.3464E-04, 3.1791E-03),( 4.9048E-04, 3.2046E-03),
     &  ( 1.0126E-03, 3.0823E-03),( 1.2485E-03, 2.9916E-03),
     &  ( 1.4236E-03, 2.9057E-03),( 1.5608E-03, 2.8244E-03),
     &  ( 1.6768E-03, 2.7435E-03),( 1.7755E-03, 2.6633E-03),
     &  ( 1.8569E-03, 2.5869E-03),( 1.9281E-03, 2.5098E-03),
     &  ( 1.9894E-03, 2.4329E-03),( 2.0414E-03, 2.3566E-03),
     &  ( 2.0848E-03, 2.2815E-03),( 2.1208E-03, 2.2063E-03),
     &  ( 2.1492E-03, 2.1331E-03),( 2.1719E-03, 2.0574E-03),
     &  ( 2.1875E-03, 1.9845E-03),( 2.1972E-03, 1.9103E-03),
     &  ( 2.2008E-03, 1.8354E-03),( 2.1983E-03, 1.7617E-03),
     &  ( 2.1898E-03, 1.6886E-03),( 2.1750E-03, 1.6143E-03),
     &  ( 2.1538E-03, 1.5398E-03),( 2.1263E-03, 1.4660E-03),
     &  ( 2.0920E-03, 1.3922E-03),( 2.0481E-03, 1.3178E-03),
     &  ( 1.9987E-03, 1.2431E-03),( 1.9435E-03, 1.1692E-03)/
  
         DATA ((CGS  (I,J), I=1901,2000), J=3,3) /
     &  ( 1.8761E-03, 1.0941E-03),( 1.7983E-03, 1.0189E-03),
     &  ( 1.7084E-03, 9.4371E-04),( 1.6043E-03, 8.6848E-04),
     &  ( 1.4825E-03, 7.9310E-04),( 1.3375E-03, 7.1777E-04),
     &  ( 1.1603E-03, 6.4321E-04),( 9.3169E-04, 5.7594E-04),
     &  ( 6.1066E-04, 5.1397E-04),( 5.9346E-04, 5.1691E-04),
     &  ( 5.6093E-04, 5.4258E-04),( 5.5207E-04, 5.6550E-04),
     &  ( 5.5190E-04, 5.8676E-04),( 5.5542E-04, 6.0694E-04),
     &  ( 5.6055E-04, 6.2637E-04),( 5.6624E-04, 6.4525E-04),
     &  ( 5.7195E-04, 6.6370E-04),( 5.7736E-04, 6.8184E-04),
     &  ( 5.8228E-04, 6.9971E-04),( 5.8660E-04, 7.1741E-04),
     &  ( 5.9023E-04, 7.3492E-04),( 5.9311E-04, 7.5228E-04),
     &  ( 5.9521E-04, 7.6955E-04),( 5.9651E-04, 7.8673E-04),
     &  ( 5.9697E-04, 8.0382E-04),( 5.9658E-04, 8.2084E-04),
     &  ( 5.9531E-04, 8.3783E-04),( 5.9315E-04, 8.5473E-04),
     &  ( 5.9006E-04, 8.7171E-04),( 5.8603E-04, 8.8858E-04),
     &  ( 5.8101E-04, 9.0547E-04),( 5.7498E-04, 9.2235E-04),
     &  ( 5.6790E-04, 9.3921E-04),( 5.5970E-04, 9.5611E-04),
     &  ( 5.5034E-04, 9.7304E-04),( 5.3976E-04, 9.8997E-04),
     &  ( 5.2786E-04, 1.0069E-03),( 5.1447E-04, 1.0241E-03),
     &  ( 4.9962E-04, 1.0412E-03),( 4.8297E-04, 1.0585E-03),
     &  ( 4.6443E-04, 1.0759E-03),( 4.4366E-04, 1.0936E-03),
     &  ( 4.2022E-04, 1.1117E-03),( 3.9351E-04, 1.1305E-03),
     &  ( 3.6055E-04, 1.1543E-03),( 3.8022E-04, 1.1499E-03),
     &  ( 4.0023E-04, 1.1412E-03),( 4.1883E-04, 1.1319E-03),
     &  ( 4.3604E-04, 1.1223E-03),( 4.5197E-04, 1.1124E-03),
     &  ( 4.6679E-04, 1.1024E-03),( 4.8050E-04, 1.0924E-03),
     &  ( 4.9319E-04, 1.0822E-03),( 5.0500E-04, 1.0720E-03),
     &  ( 5.1588E-04, 1.0619E-03),( 5.2595E-04, 1.0517E-03),
     &  ( 5.3524E-04, 1.0415E-03),( 5.4375E-04, 1.0313E-03),
     &  ( 5.5158E-04, 1.0212E-03),( 5.5876E-04, 1.0110E-03),
     &  ( 5.6522E-04, 1.0010E-03),( 5.7108E-04, 9.9104E-04),
     &  ( 5.7636E-04, 9.8106E-04),( 5.8100E-04, 9.7125E-04),
     &  ( 5.8510E-04, 9.6150E-04),( 5.8862E-04, 9.5190E-04),
     &  ( 5.9163E-04, 9.4237E-04),( 5.9409E-04, 9.3306E-04),
     &  ( 5.9606E-04, 9.2389E-04),( 5.9753E-04, 9.1497E-04),
     &  ( 5.9852E-04, 9.0627E-04),( 5.9906E-04, 8.9788E-04),
     &  ( 5.9917E-04, 8.8982E-04),( 5.9886E-04, 8.8219E-04),
     &  ( 5.9816E-04, 8.7506E-04),( 5.9712E-04, 8.6855E-04),
     &  ( 5.9576E-04, 8.6279E-04),( 5.9415E-04, 8.5800E-04),
     &  ( 5.9232E-04, 8.5443E-04),( 5.9035E-04, 8.5246E-04),
     &  ( 5.7745E-04, 8.9010E-04),( 5.7624E-04, 8.9499E-04),
     &  ( 5.7493E-04, 9.0002E-04),( 5.7351E-04, 9.0518E-04),
     &  ( 5.7198E-04, 9.1044E-04),( 5.7032E-04, 9.1579E-04),
     &  ( 5.6853E-04, 9.2120E-04),( 5.6661E-04, 9.2668E-04),
     &  ( 5.6453E-04, 9.3228E-04),( 5.6230E-04, 9.3791E-04),
     &  ( 5.5991E-04, 9.4361E-04),( 5.5735E-04, 9.4937E-04),
     &  ( 5.5462E-04, 9.5517E-04),( 5.5172E-04, 9.6098E-04),
     &  ( 5.4863E-04, 9.6686E-04),( 5.4535E-04, 9.7279E-04),
     &  ( 5.4190E-04, 9.7869E-04),( 5.3822E-04, 9.8466E-04),
     &  ( 5.3431E-04, 9.9070E-04),( 5.3020E-04, 9.9671E-04)/
  
         DATA ((CGS  (I,J), I=2001,2100), J=3,3) /
     &  ( 5.2582E-04, 1.0028E-03),( 5.2126E-04, 1.0089E-03),
     &  ( 5.1642E-04, 1.0150E-03),( 5.1131E-04, 1.0211E-03),
     &  ( 5.0576E-04, 1.0273E-03),( 5.0008E-04, 1.0334E-03),
     &  ( 4.9417E-04, 1.0396E-03),( 4.8787E-04, 1.0457E-03),
     &  ( 4.8122E-04, 1.0520E-03),( 4.7419E-04, 1.0582E-03),
     &  ( 4.6681E-04, 1.0643E-03),( 4.5892E-04, 1.0705E-03),
     &  ( 4.5051E-04, 1.0767E-03),( 4.4141E-04, 1.0829E-03),
     &  ( 4.3138E-04, 1.0889E-03),( 4.1753E-04, 1.0944E-03),
     &  ( 4.2025E-04, 1.0867E-03),( 4.2596E-04, 1.0796E-03),
     &  ( 4.3188E-04, 1.0726E-03),( 4.3774E-04, 1.0657E-03),
     &  ( 4.4345E-04, 1.0588E-03),( 4.4893E-04, 1.0519E-03),
     &  ( 4.5424E-04, 1.0450E-03),( 4.5931E-04, 1.0382E-03),
     &  ( 4.6415E-04, 1.0313E-03),( 4.6870E-04, 1.0245E-03),
     &  ( 4.7306E-04, 1.0176E-03),( 4.7718E-04, 1.0108E-03),
     &  ( 4.8107E-04, 1.0039E-03),( 4.8472E-04, 9.9710E-04),
     &  ( 4.8813E-04, 9.9030E-04),( 4.9134E-04, 9.8341E-04),
     &  ( 4.9430E-04, 9.7661E-04),( 4.9702E-04, 9.6983E-04),
     &  ( 4.9957E-04, 9.6294E-04),( 5.0184E-04, 9.5618E-04),
     &  ( 5.0393E-04, 9.4935E-04),( 5.0580E-04, 9.4254E-04),
     &  ( 5.0744E-04, 9.3575E-04),( 5.0888E-04, 9.2894E-04),
     &  ( 5.1010E-04, 9.2199E-04),( 5.1112E-04, 9.1502E-04),
     &  ( 5.1192E-04, 9.0808E-04),( 5.1251E-04, 9.0111E-04),
     &  ( 5.1289E-04, 8.9419E-04),( 5.1306E-04, 8.8727E-04),
     &  ( 5.1302E-04, 8.8032E-04),( 5.1277E-04, 8.7335E-04),
     &  ( 5.1230E-04, 8.6639E-04),( 5.1163E-04, 8.5946E-04),
     &  ( 5.1075E-04, 8.5253E-04),( 5.0408E-04, 8.2127E-04),
     &  ( 4.7600E-04, 7.5664E-04),( 4.5391E-04, 7.2227E-04),
     &  ( 4.4373E-04, 7.0524E-04),( 4.4292E-04, 6.9610E-04),
     &  ( 4.4981E-04, 6.9211E-04),( 4.6375E-04, 6.9094E-04),
     &  ( 4.8278E-04, 6.9169E-04),( 5.0824E-04, 6.9380E-04),
     &  ( 5.3933E-04, 6.9686E-04),( 5.7456E-04, 7.0044E-04),
     &  ( 6.1769E-04, 7.0468E-04),( 6.6592E-04, 7.0911E-04),
     &  ( 6.7768E-04, 7.1404E-04),( 6.8893E-04, 7.1899E-04),
     &  ( 7.0069E-04, 7.2436E-04),( 7.1194E-04, 7.1879E-04),
     &  ( 7.2370E-04, 7.2533E-04),( 7.3495E-04, 7.3158E-04),
     &  ( 7.4670E-04, 7.3812E-04),( 7.5828E-04, 3.5585E-05),
     &  ( 7.6989E-04, 3.5409E-05),( 7.8203E-04, 3.5228E-05),
     &  ( 7.9364E-04, 3.5057E-05),( 8.0578E-04, 3.4881E-05),
     &  ( 8.1739E-04, 3.4715E-05),( 8.2953E-04, 3.4544E-05),
     &  ( 7.9186E-04, 3.4383E-05),( 7.5803E-04, 3.4217E-05),
     &  ( 7.2982E-04, 3.4060E-05),( 7.0377E-04, 3.3898E-05),
     &  ( 6.8156E-04, 3.3745E-05),( 6.6067E-04, 3.3587E-05),
     &  ( 6.4258E-04, 3.3439E-05),( 6.2534E-04, 3.3285E-05),
     &  ( 6.0958E-04, 3.3134E-05),( 5.9570E-04, 3.2991E-05),
     &  ( 5.8229E-04, 3.2843E-05),( 5.7039E-04, 3.2704E-05),
     &  ( 5.5880E-04, 3.2560E-05),( 5.4846E-04, 3.2425E-05),
     &  ( 5.3834E-04, 3.2285E-05),( 5.2925E-04, 3.2152E-05),
     &  ( 5.2031E-04, 3.2016E-05),( 5.1225E-04, 3.1887E-05),
     &  ( 5.0429E-04, 3.1753E-05),( 4.9709E-04, 3.1627E-05),
     &  ( 4.9026E-04, 3.1503E-05),( 4.8347E-04, 3.1374E-05)/
  
         DATA ((CGS  (I,J), I=2101,2193), J=3,3) /
     &  ( 4.7731E-04, 3.1253E-05),( 4.7117E-04, 3.1128E-05),
     &  ( 4.6557E-04, 3.1009E-05),( 4.5999E-04, 3.0887E-05),
     &  ( 4.5489E-04, 3.0771E-05),( 4.4978E-04, 3.0651E-05),
     &  ( 4.4511E-04, 3.0538E-05),( 4.4043E-04, 3.0422E-05),
     &  ( 4.3613E-04, 3.0311E-05),( 4.3182E-04, 3.0197E-05),
     &  ( 4.2768E-04, 3.0084E-05),( 4.2387E-04, 2.9977E-05),
     &  ( 4.2003E-04, 2.9867E-05),( 4.1650E-04, 2.9763E-05),
     &  ( 4.1294E-04, 2.9655E-05),( 4.0966E-04, 2.9553E-05),
     &  ( 4.0634E-04, 2.9448E-05),( 4.0328E-04, 2.9348E-05),
     &  ( 4.0019E-04, 2.9245E-05),( 3.9733E-04, 2.9147E-05),
     &  ( 3.9444E-04, 2.9047E-05),( 3.9176E-04, 2.8951E-05),
     &  ( 3.8916E-04, 2.8857E-05),( 3.8653E-04, 2.8759E-05),
     &  ( 3.8409E-04, 2.8667E-05),( 3.8162E-04, 2.8571E-05),
     &  ( 3.7932E-04, 2.8481E-05),( 3.7699E-04, 2.8387E-05),
     &  ( 3.7483E-04, 2.8299E-05),( 3.7263E-04, 2.8207E-05),
     &  ( 3.7059E-04, 2.8120E-05),( 3.6851E-04, 2.8031E-05),
     &  ( 3.6658E-04, 2.7946E-05),( 3.6461E-04, 2.7858E-05),
     &  ( 3.6270E-04, 2.7771E-05),( 3.6092E-04, 2.7689E-05),
     &  ( 3.5910E-04, 2.7603E-05),( 3.5733E-04, 2.7523E-05),
     &  ( 3.5597E-04, 2.7439E-05),( 3.5467E-04, 2.7360E-05),
     &  ( 3.5330E-04, 2.7278E-05),( 3.5200E-04, 2.7201E-05),
     &  ( 3.5064E-04, 2.7121E-05),( 3.4934E-04, 2.7045E-05),
     &  ( 3.4797E-04, 2.6966E-05),( 3.4667E-04, 2.6892E-05),
     &  ( 3.4531E-04, 2.6815E-05),( 3.4401E-04, 2.6741E-05),
     &  ( 3.4270E-04, 2.6669E-05),( 3.4134E-04, 2.6594E-05),
     &  ( 3.4004E-04, 2.6523E-05),( 3.3868E-04, 2.6450E-05),
     &  ( 3.3738E-04, 2.6380E-05),( 3.3601E-04, 2.6308E-05),
     &  ( 3.3471E-04, 2.6240E-05),( 3.3335E-04, 2.6169E-05),
     &  ( 3.3205E-04, 2.6102E-05),( 3.3068E-04, 2.6033E-05),
     &  ( 3.2938E-04, 2.5967E-05),( 3.2802E-04, 2.5899E-05),
     &  ( 3.1858E-04, 2.5198E-05),( 3.0915E-04, 2.4563E-05),
     &  ( 3.0811E-04, 2.4466E-05),( 2.7368E-04, 2.1067E-05),
     &  ( 2.6529E-04, 1.9964E-05),( 2.5173E-04, 1.7835E-05),
     &  ( 2.4711E-04, 1.6949E-05),( 2.4692E-04, 1.6910E-05),
     &  ( 2.4251E-04, 1.5942E-05),( 2.4250E-04, 1.5939E-05),
     &  ( 2.4012E-04, 1.5317E-05),( 2.4004E-04, 1.5295E-05),
     &  ( 2.3999E-04, 1.5281E-05),( 2.3902E-04, 1.4998E-05),
     &  ( 2.3844E-04, 1.4816E-05),( 2.3834E-04, 1.4784E-05),
     &  ( 2.3819E-04, 1.4733E-05),( 2.3796E-04, 1.4656E-05),
     &  ( 2.3780E-04, 1.4603E-05),( 2.3771E-04, 1.4570E-05),
     &  ( 2.3684E-04, 1.4256E-05),( 2.3680E-04, 1.4240E-05),
     &  ( 2.3656E-04, 1.4150E-05),( 2.3652E-04, 1.4133E-05),
     &  ( 2.3635E-04, 1.4059E-05),( 2.3628E-04, 1.4030E-05),
     &  ( 2.3623E-04, 1.4007E-05),( 2.3618E-04, 1.3986E-05),
     &  ( 2.3602E-04, 1.3924E-05),( 2.3580E-04, 1.3835E-05),
     &  ( 2.3572E-04, 1.3798E-05),( 2.3520E-04, 1.3554E-05),
     &  ( 2.3479E-04, 1.3352E-05)/
       save
       RETURN
       END
      
c     ++++ dalhadshigh23 ++++  

c update 21/10/25 
       subroutine calhad_timelike1h25c
       
       IMPLICIT NONE
       INTEGER NC,I,J
       PARAMETER(NC=200)
       REAL EMA(NC)
       COMPLEX *8 CAM(NC,3),CGM(NC,3)
       COMMON /DATM25c/EMA,CAM,CGM

  
       DATA  (EMA  (I), I=   1, 100) /
     &   1.3000E+01, 1.3500E+01,
     &   1.4000E+01, 1.4500E+01,
     &   1.5000E+01, 1.6000E+01,
     &   1.7000E+01, 1.8000E+01,
     &   1.9000E+01, 2.0000E+01,
     &   2.1000E+01, 2.2000E+01,
     &   2.3000E+01, 2.4000E+01,
     &   2.5000E+01, 2.6000E+01,
     &   2.7000E+01, 2.8000E+01,
     &   2.9000E+01, 3.0000E+01,
     &   3.1000E+01, 3.2000E+01,
     &   3.3000E+01, 3.4000E+01,
     &   3.5000E+01, 3.6000E+01,
     &   3.7000E+01, 3.8000E+01,
     &   3.9000E+01, 4.0000E+01,
     &   4.1000E+01, 4.2000E+01,
     &   4.3000E+01, 4.4000E+01,
     &   4.5000E+01, 4.6000E+01,
     &   4.7000E+01, 4.8000E+01,
     &   4.9000E+01, 5.0000E+01,
     &   5.1000E+01, 5.2000E+01,
     &   5.3000E+01, 5.4000E+01,
     &   5.5000E+01, 5.6000E+01,
     &   5.7000E+01, 5.8000E+01,
     &   5.9000E+01, 6.0000E+01,
     &   6.1000E+01, 6.2000E+01,
     &   6.3000E+01, 6.4000E+01,
     &   6.5000E+01, 6.6000E+01,
     &   6.7000E+01, 6.8000E+01,
     &   6.9000E+01, 7.0000E+01,
     &   7.1000E+01, 7.2000E+01,
     &   7.3000E+01, 7.4000E+01,
     &   7.5000E+01, 7.6000E+01,
     &   7.7000E+01, 7.8000E+01,
     &   7.9000E+01, 8.0000E+01,
     &   8.1000E+01, 8.2000E+01,
     &   8.3000E+01, 8.4000E+01,
     &   8.5000E+01, 8.6000E+01,
     &   8.7000E+01, 8.8000E+01,
     &   8.9000E+01, 9.0000E+01,
     &   9.1000E+01, 9.2000E+01,
     &   9.3000E+01, 9.4000E+01,
     &   9.5000E+01, 9.6000E+01,
     &   9.7000E+01, 9.8000E+01,
     &   9.9000E+01, 1.0000E+02,
     &   1.0900E+02, 1.1800E+02,
     &   1.2700E+02, 1.3600E+02,
     &   1.4500E+02, 1.5400E+02,
     &   1.6300E+02, 1.7200E+02,
     &   1.8100E+02, 1.9000E+02/
       DATA  (EMA  (I), I= 101, 200) /
     &   1.9900E+02, 2.0800E+02,
     &   2.1700E+02, 2.2600E+02,
     &   2.3500E+02, 2.4400E+02,
     &   2.5300E+02, 2.6200E+02,
     &   2.7100E+02, 2.8000E+02,
     &   2.8900E+02, 2.9800E+02,
     &   3.0700E+02, 3.1600E+02,
     &   3.2500E+02, 3.3400E+02,
     &   3.4300E+02, 3.5200E+02,
     &   3.6100E+02, 3.7000E+02,
     &   3.7900E+02, 3.8800E+02,
     &   3.9700E+02, 4.0600E+02,
     &   4.1500E+02, 4.2400E+02,
     &   4.3300E+02, 4.4200E+02,
     &   4.5100E+02, 4.6000E+02,
     &   4.6900E+02, 4.7800E+02,
     &   4.8700E+02, 4.9600E+02,
     &   5.0500E+02, 5.1400E+02,
     &   5.2300E+02, 5.3200E+02,
     &   5.4100E+02, 5.5000E+02,
     &   5.5900E+02, 5.6800E+02,
     &   5.7700E+02, 5.8600E+02,
     &   5.9500E+02, 6.0400E+02,
     &   6.1300E+02, 6.2200E+02,
     &   6.3100E+02, 6.4000E+02,
     &   6.4900E+02, 6.5800E+02,
     &   6.6700E+02, 6.7600E+02,
     &   6.8500E+02, 6.9400E+02,
     &   7.0300E+02, 7.1200E+02,
     &   7.2100E+02, 7.3000E+02,
     &   7.3900E+02, 7.4800E+02,
     &   7.5700E+02, 7.6600E+02,
     &   7.7500E+02, 7.8400E+02,
     &   7.9300E+02, 8.0200E+02,
     &   8.1100E+02, 8.2000E+02,
     &   8.2900E+02, 8.3800E+02,
     &   8.4700E+02, 8.5600E+02,
     &   8.6500E+02, 8.7400E+02,
     &   8.8300E+02, 8.9200E+02,
     &   9.0100E+02, 9.1000E+02,
     &   9.1900E+02, 9.2800E+02,
     &   9.3700E+02, 9.4600E+02,
     &   9.5500E+02, 9.6400E+02,
     &   9.7300E+02, 9.8200E+02,
     &   9.9100E+02, 1.0000E+03,
     &   2.0000E+03, 3.0000E+03,
     &   4.0000E+03, 5.0000E+03,
     &   6.0000E+03, 8.0000E+03,
     &   1.0000E+04, 1.2000E+04,
     &   1.4000E+04, 2.0000E+04/
  
         DATA ((CAM  (I,J), I=   1, 100), J=1,1) /
     &  ( 1.5754E-02,-9.4864E-03),( 1.6058E-02,-9.4768E-03),
     &  ( 1.6271E-02,-9.4680E-03),( 1.6506E-02,-9.4600E-03),
     &  ( 1.6729E-02,-9.4525E-03),( 1.7145E-02,-9.4393E-03),
     &  ( 1.7530E-02,-9.4279E-03),( 1.7888E-02,-9.4179E-03),
     &  ( 1.8224E-02,-9.4091E-03),( 1.8541E-02,-9.4013E-03),
     &  ( 1.8839E-02,-9.3943E-03),( 1.9233E-02,-9.3879E-03),
     &  ( 1.9394E-02,-9.3822E-03),( 1.9652E-02,-9.3769E-03),
     &  ( 1.9899E-02,-9.3721E-03),( 2.0137E-02,-9.3676E-03),
     &  ( 2.0364E-02,-9.3634E-03),( 2.0583E-02,-9.3596E-03),
     &  ( 2.0794E-02,-9.3559E-03),( 2.0997E-02,-9.3525E-03),
     &  ( 2.1194E-02,-9.3494E-03),( 2.1384E-02,-9.3463E-03),
     &  ( 2.1568E-02,-9.3435E-03),( 2.1749E-02,-9.3408E-03),
     &  ( 2.1952E-02,-9.3382E-03),( 2.2088E-02,-9.3358E-03),
     &  ( 2.2251E-02,-9.3334E-03),( 2.2410E-02,-9.3312E-03),
     &  ( 2.2566E-02,-9.3291E-03),( 2.2717E-02,-9.3270E-03),
     &  ( 2.2863E-02,-9.3251E-03),( 2.3006E-02,-9.3232E-03),
     &  ( 2.3154E-02,-9.3214E-03),( 2.3283E-02,-9.3196E-03),
     &  ( 2.3416E-02,-9.3179E-03),( 2.3610E-02,-9.3163E-03),
     &  ( 2.3675E-02,-9.3147E-03),( 2.3800E-02,-9.3132E-03),
     &  ( 2.3922E-02,-9.3117E-03),( 2.4042E-02,-9.3103E-03),
     &  ( 2.4160E-02,-9.3089E-03),( 2.4275E-02,-9.3075E-03),
     &  ( 2.4388E-02,-9.3062E-03),( 2.4523E-02,-9.3049E-03),
     &  ( 2.4608E-02,-9.3037E-03),( 2.4715E-02,-9.3025E-03),
     &  ( 2.4820E-02,-9.3013E-03),( 2.5046E-02,-9.3002E-03),
     &  ( 2.5024E-02,-9.2991E-03),( 2.5124E-02,-9.2980E-03),
     &  ( 2.5221E-02,-9.2969E-03),( 2.5318E-02,-9.2959E-03),
     &  ( 2.5413E-02,-9.2949E-03),( 2.5506E-02,-9.2939E-03),
     &  ( 2.5598E-02,-9.2929E-03),( 2.5688E-02,-9.2920E-03),
     &  ( 2.5777E-02,-9.2910E-03),( 2.5865E-02,-9.2901E-03),
     &  ( 2.5951E-02,-9.2892E-03),( 2.6036E-02,-9.2884E-03),
     &  ( 2.6120E-02,-9.2875E-03),( 2.6203E-02,-9.2867E-03),
     &  ( 2.6285E-02,-9.2859E-03),( 2.6365E-02,-9.2851E-03),
     &  ( 2.6445E-02,-9.2843E-03),( 2.6523E-02,-9.2835E-03),
     &  ( 2.6600E-02,-9.2827E-03),( 2.6677E-02,-9.2820E-03),
     &  ( 2.6752E-02,-9.2813E-03),( 2.6826E-02,-9.2805E-03),
     &  ( 2.6900E-02,-9.2798E-03),( 2.6972E-02,-9.2791E-03),
     &  ( 2.7044E-02,-9.2784E-03),( 2.7115E-02,-9.2778E-03),
     &  ( 2.7185E-02,-9.2771E-03),( 2.7254E-02,-9.2765E-03),
     &  ( 2.7323E-02,-9.2758E-03),( 2.7390E-02,-9.2752E-03),
     &  ( 2.7457E-02,-9.2746E-03),( 2.7523E-02,-9.2740E-03),
     &  ( 2.7588E-02,-9.2734E-03),( 2.7653E-02,-9.2728E-03),
     &  ( 2.7717E-02,-9.2722E-03),( 2.7780E-02,-9.2716E-03),
     &  ( 2.7843E-02,-9.2710E-03),( 2.7905E-02,-9.2705E-03),
     &  ( 2.7966E-02,-9.2699E-03),( 2.8027E-02,-9.2694E-03),
     &  ( 2.8087E-02,-9.2689E-03),( 2.8146E-02,-9.2683E-03),
     &  ( 2.8655E-02,-9.2639E-03),( 2.9125E-02,-9.2599E-03),
     &  ( 2.9559E-02,-9.2563E-03),( 2.9964E-02,-9.2530E-03),
     &  ( 3.0344E-02,-9.2500E-03),( 3.0700E-02,-9.2473E-03),
     &  ( 3.1037E-02,-9.2447E-03),( 3.1356E-02,-9.2424E-03),
     &  ( 3.1658E-02,-9.2402E-03),( 3.1946E-02,-9.2381E-03)/
  
         DATA ((CAM  (I,J), I= 101, 200), J=1,1) /
     &  ( 3.2221E-02,-9.2361E-03),( 3.2485E-02,-9.2343E-03),
     &  ( 3.2737E-02,-9.2326E-03),( 3.2979E-02,-9.2309E-03),
     &  ( 3.3212E-02,-9.2294E-03),( 3.3437E-02,-9.2279E-03),
     &  ( 3.3654E-02,-9.2265E-03),( 3.3863E-02,-9.2251E-03),
     &  ( 3.4066E-02,-9.2239E-03),( 3.4263E-02,-9.2226E-03),
     &  ( 3.4453E-02,-9.2214E-03),( 3.4638E-02,-9.2203E-03),
     &  ( 3.4818E-02,-9.2192E-03),( 3.4993E-02,-9.2182E-03),
     &  ( 3.5163E-02,-9.2172E-03),( 3.5329E-02,-9.2162E-03),
     &  ( 3.5490E-02,-9.2153E-03),( 3.5648E-02,-9.2173E-03),
     &  ( 3.5804E-02,-9.2164E-03),( 3.5956E-02,-9.2156E-03),
     &  ( 3.6105E-02,-9.2147E-03),( 3.6250E-02,-9.2139E-03),
     &  ( 3.6392E-02,-9.2131E-03),( 3.6532E-02,-9.2124E-03),
     &  ( 3.6669E-02,-9.2116E-03),( 3.6803E-02,-9.2109E-03),
     &  ( 3.6935E-02,-9.2102E-03),( 3.7065E-02,-9.2095E-03),
     &  ( 3.7193E-02,-9.2089E-03),( 3.7318E-02,-9.2082E-03),
     &  ( 3.7442E-02,-9.2076E-03),( 3.7564E-02,-9.2070E-03),
     &  ( 3.7684E-02,-9.2064E-03),( 3.7802E-02,-9.2058E-03),
     &  ( 3.7913E-02,-9.2052E-03),( 3.8016E-02,-9.2047E-03),
     &  ( 3.8118E-02,-9.2041E-03),( 3.8218E-02,-9.2036E-03),
     &  ( 3.8316E-02,-9.2031E-03),( 3.8412E-02,-9.2026E-03),
     &  ( 3.8507E-02,-9.2021E-03),( 3.8601E-02,-9.2016E-03),
     &  ( 3.8693E-02,-9.2011E-03),( 3.8783E-02,-9.2007E-03),
     &  ( 3.8873E-02,-9.2002E-03),( 3.8961E-02,-9.1997E-03),
     &  ( 3.9047E-02,-9.1993E-03),( 3.9132E-02,-9.1989E-03),
     &  ( 3.9216E-02,-9.1984E-03),( 3.9299E-02,-9.1980E-03),
     &  ( 3.9381E-02,-9.1976E-03),( 3.9462E-02,-9.1972E-03),
     &  ( 3.9541E-02,-9.1968E-03),( 3.9620E-02,-9.1964E-03),
     &  ( 3.9697E-02,-9.1960E-03),( 3.9773E-02,-9.1957E-03),
     &  ( 3.9849E-02,-9.1953E-03),( 3.9923E-02,-9.1949E-03),
     &  ( 3.9996E-02,-9.1946E-03),( 4.0069E-02,-9.1942E-03),
     &  ( 4.0141E-02,-9.1939E-03),( 4.0211E-02,-9.1935E-03),
     &  ( 4.0281E-02,-9.1932E-03),( 4.0351E-02,-9.1929E-03),
     &  ( 4.0419E-02,-9.1925E-03),( 4.0486E-02,-9.1922E-03),
     &  ( 4.0553E-02,-9.1919E-03),( 4.0619E-02,-9.1916E-03),
     &  ( 4.0684E-02,-9.1913E-03),( 4.0749E-02,-9.1909E-03),
     &  ( 4.0813E-02,-9.1906E-03),( 4.0876E-02,-9.1903E-03),
     &  ( 4.0938E-02,-9.1901E-03),( 4.1000E-02,-9.1898E-03),
     &  ( 4.1061E-02,-9.1895E-03),( 4.1122E-02,-9.1892E-03),
     &  ( 4.1182E-02,-9.1889E-03),( 4.1241E-02,-9.1886E-03),
     &  ( 4.1300E-02,-9.1884E-03),( 4.1358E-02,-9.1881E-03),
     &  ( 4.1415E-02,-9.1878E-03),( 4.1472E-02,-9.1876E-03),
     &  ( 4.1529E-02,-9.1873E-03),( 4.1584E-02,-9.1870E-03),
     &  ( 4.1640E-02,-9.1868E-03),( 4.1695E-02,-9.1865E-03),
     &  ( 4.1749E-02,-9.1863E-03),( 4.1803E-02,-9.1860E-03),
     &  ( 4.1856E-02,-9.1858E-03),( 4.1909E-02,-9.1856E-03),
     &  ( 4.5956E-02,-9.1684E-03),( 4.8319E-02,-9.1593E-03),
     &  ( 4.9996E-02,-9.1533E-03),( 5.1296E-02,-9.1489E-03),
     &  ( 5.2356E-02,-9.1454E-03),( 5.4030E-02,-9.1401E-03),
     &  ( 5.5328E-02,-9.1361E-03),( 5.6387E-02,-9.1330E-03),
     &  ( 5.7284E-02,-9.1304E-03),( 5.9356E-02,-9.1247E-03)/
  
  
         DATA ((CAM  (I,J), I=   1, 100), J=2,2) /
     &  ( 5.8909E-05, 0.0000E+00),( 5.8082E-05, 0.0000E+00),
     &  ( 5.7492E-05, 0.0000E+00),( 5.7036E-05, 0.0000E+00),
     &  ( 5.6668E-05, 0.0000E+00),( 5.6098E-05, 0.0000E+00),
     &  ( 5.5672E-05, 0.0000E+00),( 5.5338E-05, 0.0000E+00),
     &  ( 5.5069E-05, 0.0000E+00),( 5.4847E-05, 0.0000E+00),
     &  ( 5.4661E-05, 0.0000E+00),( 5.4504E-05, 0.0000E+00),
     &  ( 5.4369E-05, 0.0000E+00),( 5.4252E-05, 0.0000E+00),
     &  ( 5.4151E-05, 0.0000E+00),( 5.4062E-05, 0.0000E+00),
     &  ( 5.3983E-05, 0.0000E+00),( 5.3913E-05, 0.0000E+00),
     &  ( 5.3850E-05, 0.0000E+00),( 5.3794E-05, 0.0000E+00),
     &  ( 5.3744E-05, 0.0000E+00),( 5.3698E-05, 0.0000E+00),
     &  ( 5.3657E-05, 0.0000E+00),( 5.3620E-05, 0.0000E+00),
     &  ( 5.3585E-05, 0.0000E+00),( 5.3554E-05, 0.0000E+00),
     &  ( 5.3525E-05, 0.0000E+00),( 5.3499E-05, 0.0000E+00),
     &  ( 5.3474E-05, 0.0000E+00),( 5.3452E-05, 0.0000E+00),
     &  ( 5.3431E-05, 0.0000E+00),( 5.3411E-05, 0.0000E+00),
     &  ( 5.3393E-05, 0.0000E+00),( 5.3377E-05, 0.0000E+00),
     &  ( 5.3361E-05, 0.0000E+00),( 5.3346E-05, 0.0000E+00),
     &  ( 5.3333E-05, 0.0000E+00),( 5.3320E-05, 0.0000E+00),
     &  ( 5.3308E-05, 0.0000E+00),( 5.3297E-05, 0.0000E+00),
     &  ( 5.3286E-05, 0.0000E+00),( 5.3276E-05, 0.0000E+00),
     &  ( 5.3267E-05, 0.0000E+00),( 5.3258E-05, 0.0000E+00),
     &  ( 5.3249E-05, 0.0000E+00),( 5.3241E-05, 0.0000E+00),
     &  ( 5.3234E-05, 0.0000E+00),( 5.3227E-05, 0.0000E+00),
     &  ( 5.3220E-05, 0.0000E+00),( 5.3213E-05, 0.0000E+00),
     &  ( 5.3207E-05, 0.0000E+00),( 5.3201E-05, 0.0000E+00),
     &  ( 5.3196E-05, 0.0000E+00),( 5.3191E-05, 0.0000E+00),
     &  ( 5.3186E-05, 0.0000E+00),( 5.3181E-05, 0.0000E+00),
     &  ( 5.3176E-05, 0.0000E+00),( 5.3172E-05, 0.0000E+00),
     &  ( 5.3167E-05, 0.0000E+00),( 5.3163E-05, 0.0000E+00),
     &  ( 5.3160E-05, 0.0000E+00),( 5.3156E-05, 0.0000E+00),
     &  ( 5.3152E-05, 0.0000E+00),( 5.3149E-05, 0.0000E+00),
     &  ( 5.3146E-05, 0.0000E+00),( 5.3143E-05, 0.0000E+00),
     &  ( 5.3139E-05, 0.0000E+00),( 5.3137E-05, 0.0000E+00),
     &  ( 5.3134E-05, 0.0000E+00),( 5.3131E-05, 0.0000E+00),
     &  ( 5.3129E-05, 0.0000E+00),( 5.3126E-05, 0.0000E+00),
     &  ( 5.3124E-05, 0.0000E+00),( 5.3121E-05, 0.0000E+00),
     &  ( 5.3119E-05, 0.0000E+00),( 5.3117E-05, 0.0000E+00),
     &  ( 5.3115E-05, 0.0000E+00),( 5.3113E-05, 0.0000E+00),
     &  ( 5.3111E-05, 0.0000E+00),( 5.3109E-05, 0.0000E+00),
     &  ( 5.3107E-05, 0.0000E+00),( 5.3105E-05, 0.0000E+00),
     &  ( 5.3104E-05, 0.0000E+00),( 5.3102E-05, 0.0000E+00),
     &  ( 5.3100E-05, 0.0000E+00),( 5.3099E-05, 0.0000E+00),
     &  ( 5.3097E-05, 0.0000E+00),( 5.3096E-05, 0.0000E+00),
     &  ( 5.3095E-05, 0.0000E+00),( 5.3093E-05, 0.0000E+00),
     &  ( 5.3083E-05, 0.0000E+00),( 5.3074E-05, 0.0000E+00),
     &  ( 5.3068E-05, 0.0000E+00),( 5.3062E-05, 0.0000E+00),
     &  ( 5.3058E-05, 0.0000E+00),( 5.3054E-05, 0.0000E+00),
     &  ( 5.3051E-05, 0.0000E+00),( 5.3049E-05, 0.0000E+00),
     &  ( 5.3047E-05, 0.0000E+00),( 5.3045E-05, 0.0000E+00)/
  
         DATA ((CAM  (I,J), I= 101, 200), J=2,2) /
     &  ( 5.3043E-05, 0.0000E+00),( 5.3042E-05, 0.0000E+00),
     &  ( 5.3040E-05, 0.0000E+00),( 5.3039E-05, 0.0000E+00),
     &  ( 5.3038E-05, 0.0000E+00),( 5.3037E-05, 0.0000E+00),
     &  ( 5.3037E-05, 0.0000E+00),( 5.3036E-05, 0.0000E+00),
     &  ( 5.3035E-05, 0.0000E+00),( 5.3035E-05, 0.0000E+00),
     &  ( 5.3034E-05, 0.0000E+00),( 5.3034E-05, 0.0000E+00),
     &  ( 5.3033E-05, 0.0000E+00),( 5.3033E-05, 0.0000E+00),
     &  ( 5.3032E-05, 0.0000E+00),( 5.3032E-05, 0.0000E+00),
     &  ( 5.3032E-05, 0.0000E+00),( 5.3032E-05, 0.0000E+00),
     &  ( 5.3031E-05, 0.0000E+00),( 5.3031E-05, 0.0000E+00),
     &  ( 5.3031E-05, 0.0000E+00),( 5.3031E-05, 0.0000E+00),
     &  ( 5.3030E-05, 0.0000E+00),( 5.3030E-05, 0.0000E+00),
     &  ( 5.3030E-05, 0.0000E+00),( 5.3030E-05, 0.0000E+00),
     &  ( 5.3030E-05, 0.0000E+00),( 5.3030E-05, 0.0000E+00),
     &  ( 5.3029E-05, 0.0000E+00),( 5.3029E-05, 0.0000E+00),
     &  ( 5.3029E-05, 0.0000E+00),( 5.3029E-05, 0.0000E+00),
     &  ( 5.3029E-05, 0.0000E+00),( 5.3029E-05, 0.0000E+00),
     &  ( 5.3029E-05, 0.0000E+00),( 5.3029E-05, 0.0000E+00),
     &  ( 5.3029E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3028E-05, 0.0000E+00),( 5.3028E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3027E-05, 0.0000E+00),( 5.3027E-05, 0.0000E+00),
     &  ( 5.3026E-05, 0.0000E+00),( 5.3026E-05, 0.0000E+00),
     &  ( 5.3026E-05, 0.0000E+00),( 5.3026E-05, 0.0000E+00),
     &  ( 5.3026E-05, 0.0000E+00),( 5.3026E-05, 0.0000E+00),
     &  ( 5.3026E-05, 0.0000E+00),( 5.3026E-05, 0.0000E+00),
     &  ( 5.3026E-05, 0.0000E+00),( 5.3026E-05, 0.0000E+00)/
  
  
         DATA ((CAM  (I,J), I=   1, 100), J=3,3) /
     &  ( 1.7225E-04, 1.3325E-05),( 1.6584E-04, 1.2533E-05),
     &  ( 1.6174E-04, 1.1889E-05),( 1.5886E-04, 1.1356E-05),
     &  ( 1.5670E-04, 1.0909E-05),( 1.5365E-04, 1.0203E-05),
     &  ( 1.5157E-04, 9.6708E-06),( 1.5004E-04, 9.2553E-06),
     &  ( 1.4886E-04, 8.9204E-06),( 1.4792E-04, 8.6433E-06),
     &  ( 1.4716E-04, 8.4087E-06),( 1.4654E-04, 8.2064E-06),
     &  ( 1.4600E-04, 8.0290E-06),( 1.4555E-04, 7.8713E-06),
     &  ( 1.4516E-04, 7.7295E-06),( 1.4483E-04, 7.6007E-06),
     &  ( 1.4453E-04, 7.4828E-06),( 1.4427E-04, 7.3740E-06),
     &  ( 1.4404E-04, 7.2730E-06),( 1.4384E-04, 7.1788E-06),
     &  ( 1.4366E-04, 7.0905E-06),( 1.4349E-04, 7.0075E-06),
     &  ( 1.4334E-04, 6.9290E-06),( 1.4321E-04, 6.8547E-06),
     &  ( 1.4309E-04, 6.7841E-06),( 1.4298E-04, 6.7168E-06),
     &  ( 1.4287E-04, 6.6527E-06),( 1.4278E-04, 6.5914E-06),
     &  ( 1.4270E-04, 6.5326E-06),( 1.4262E-04, 6.4762E-06),
     &  ( 1.4254E-04, 6.4221E-06),( 1.4248E-04, 6.3700E-06),
     &  ( 1.4241E-04, 6.3198E-06),( 1.4235E-04, 6.2714E-06),
     &  ( 1.4230E-04, 6.2246E-06),( 1.4226E-04, 6.1795E-06),
     &  ( 1.4220E-04, 6.1358E-06),( 1.4216E-04, 6.0935E-06),
     &  ( 1.4212E-04, 6.0525E-06),( 1.4208E-04, 6.0127E-06),
     &  ( 1.4204E-04, 5.9742E-06),( 1.4201E-04, 5.9367E-06),
     &  ( 1.4198E-04, 5.9003E-06),( 1.4195E-04, 5.8649E-06),
     &  ( 1.4192E-04, 5.8305E-06),( 1.4189E-04, 5.7970E-06),
     &  ( 1.4186E-04, 5.7643E-06),( 1.4186E-04, 5.7325E-06),
     &  ( 1.4182E-04, 5.7015E-06),( 1.4180E-04, 5.6712E-06),
     &  ( 1.4178E-04, 5.6417E-06),( 1.4176E-04, 5.6129E-06),
     &  ( 1.4174E-04, 5.5847E-06),( 1.4172E-04, 5.5572E-06),
     &  ( 1.4170E-04, 5.5303E-06),( 1.4169E-04, 5.5040E-06),
     &  ( 1.4167E-04, 5.4783E-06),( 1.4166E-04, 5.4532E-06),
     &  ( 1.4164E-04, 5.4285E-06),( 1.4163E-04, 5.4044E-06),
     &  ( 1.4162E-04, 5.3808E-06),( 1.4160E-04, 5.3576E-06),
     &  ( 1.4159E-04, 5.3350E-06),( 1.4158E-04, 5.3127E-06),
     &  ( 1.4157E-04, 5.2909E-06),( 1.4156E-04, 5.2695E-06),
     &  ( 1.4155E-04, 5.2485E-06),( 1.4154E-04, 5.2279E-06),
     &  ( 1.4153E-04, 5.2077E-06),( 1.4152E-04, 5.1878E-06),
     &  ( 1.4151E-04, 5.1683E-06),( 1.4151E-04, 5.1492E-06),
     &  ( 1.4150E-04, 5.1304E-06),( 1.4149E-04, 5.1119E-06),
     &  ( 1.4148E-04, 5.0937E-06),( 1.4148E-04, 5.0758E-06),
     &  ( 1.4147E-04, 5.0582E-06),( 1.4146E-04, 5.0409E-06),
     &  ( 1.4146E-04, 5.0239E-06),( 1.4145E-04, 5.0072E-06),
     &  ( 1.4144E-04, 4.9907E-06),( 1.4144E-04, 4.9745E-06),
     &  ( 1.4143E-04, 4.9585E-06),( 1.4143E-04, 4.9428E-06),
     &  ( 1.4142E-04, 4.9273E-06),( 1.4142E-04, 4.9121E-06),
     &  ( 1.4141E-04, 4.8971E-06),( 1.4141E-04, 4.8823E-06),
     &  ( 1.4140E-04, 4.8677E-06),( 1.4140E-04, 4.8533E-06),
     &  ( 1.4137E-04, 4.7326E-06),( 1.4134E-04, 4.6254E-06),
     &  ( 1.4132E-04, 4.5293E-06),( 1.4131E-04, 4.4425E-06),
     &  ( 1.4129E-04, 4.3636E-06),( 1.4128E-04, 4.2913E-06),
     &  ( 1.4128E-04, 4.2249E-06),( 1.4127E-04, 4.1635E-06),
     &  ( 1.4126E-04, 4.1065E-06),( 1.4126E-04, 4.0534E-06)/
  
         DATA ((CAM  (I,J), I= 101, 200), J=3,3) /
     &  ( 1.4125E-04, 4.0038E-06),( 1.4125E-04, 3.9573E-06),
     &  ( 1.4125E-04, 3.9136E-06),( 1.4125E-04, 3.8723E-06),
     &  ( 1.4124E-04, 3.8334E-06),( 1.4124E-04, 3.7965E-06),
     &  ( 1.4124E-04, 3.7615E-06),( 1.4124E-04, 3.7282E-06),
     &  ( 1.4124E-04, 3.6965E-06),( 1.4124E-04, 3.6663E-06),
     &  ( 1.4124E-04, 3.6374E-06),( 1.4124E-04, 3.6098E-06),
     &  ( 1.4124E-04, 3.5833E-06),( 1.4124E-04, 3.5579E-06),
     &  ( 1.4124E-04, 3.5335E-06),( 1.4124E-04, 3.5100E-06),
     &  ( 1.4124E-04, 3.4875E-06),( 1.4124E-04, 3.4856E-06),
     &  ( 1.4124E-04, 3.4637E-06),( 1.4124E-04, 3.4426E-06),
     &  ( 1.4124E-04, 3.4223E-06),( 1.4124E-04, 3.4029E-06),
     &  ( 1.4124E-04, 3.3841E-06),( 1.4124E-04, 3.3660E-06),
     &  ( 1.4124E-04, 3.3484E-06),( 1.4124E-04, 3.3315E-06),
     &  ( 1.4124E-04, 3.3151E-06),( 1.4124E-04, 3.2992E-06),
     &  ( 1.4124E-04, 3.2838E-06),( 1.4124E-04, 3.2689E-06),
     &  ( 1.4124E-04, 3.2543E-06),( 1.4124E-04, 3.2402E-06),
     &  ( 1.4124E-04, 3.2264E-06),( 1.4124E-04, 3.2131E-06),
     &  ( 1.4124E-04, 3.2000E-06),( 1.4124E-04, 3.1873E-06),
     &  ( 1.4124E-04, 3.1749E-06),( 1.4124E-04, 3.1629E-06),
     &  ( 1.4124E-04, 3.1510E-06),( 1.4124E-04, 3.1395E-06),
     &  ( 1.4124E-04, 3.1283E-06),( 1.4124E-04, 3.1172E-06),
     &  ( 1.4124E-04, 3.1065E-06),( 1.4124E-04, 3.0959E-06),
     &  ( 1.4124E-04, 3.0856E-06),( 1.4124E-04, 3.0755E-06),
     &  ( 1.4124E-04, 3.0656E-06),( 1.4124E-04, 3.0559E-06),
     &  ( 1.4124E-04, 3.0464E-06),( 1.4124E-04, 3.0370E-06),
     &  ( 1.4124E-04, 3.0279E-06),( 1.4124E-04, 3.0189E-06),
     &  ( 1.4125E-04, 3.0101E-06),( 1.4125E-04, 3.0015E-06),
     &  ( 1.4125E-04, 2.9930E-06),( 1.4125E-04, 2.9846E-06),
     &  ( 1.4125E-04, 2.9764E-06),( 1.4125E-04, 2.9683E-06),
     &  ( 1.4125E-04, 2.9604E-06),( 1.4125E-04, 2.9526E-06),
     &  ( 1.4125E-04, 2.9449E-06),( 1.4125E-04, 2.9374E-06),
     &  ( 1.4125E-04, 2.9300E-06),( 1.4125E-04, 2.9227E-06),
     &  ( 1.4125E-04, 2.9155E-06),( 1.4125E-04, 2.9084E-06),
     &  ( 1.4125E-04, 2.9014E-06),( 1.4125E-04, 2.8946E-06),
     &  ( 1.4125E-04, 2.8878E-06),( 1.4125E-04, 2.8811E-06),
     &  ( 1.4125E-04, 2.8746E-06),( 1.4125E-04, 2.8681E-06),
     &  ( 1.4125E-04, 2.8617E-06),( 1.4125E-04, 2.8554E-06),
     &  ( 1.4125E-04, 2.8492E-06),( 1.4125E-04, 2.8431E-06),
     &  ( 1.4125E-04, 2.8370E-06),( 1.4125E-04, 2.8311E-06),
     &  ( 1.4125E-04, 2.8252E-06),( 1.4125E-04, 2.8194E-06),
     &  ( 1.4125E-04, 2.8136E-06),( 1.4125E-04, 2.8080E-06),
     &  ( 1.4125E-04, 2.8024E-06),( 1.4125E-04, 2.7969E-06),
     &  ( 1.4125E-04, 2.7914E-06),( 1.4125E-04, 2.7861E-06),
     &  ( 1.4125E-04, 2.7807E-06),( 1.4125E-04, 2.7755E-06),
     &  ( 1.4126E-04, 2.7703E-06),( 1.4126E-04, 2.7652E-06),
     &  ( 1.4128E-04, 2.4109E-06),( 1.4129E-04, 2.2342E-06),
     &  ( 1.4130E-04, 2.1202E-06),( 1.4130E-04, 2.0377E-06),
     &  ( 1.4130E-04, 1.9738E-06),( 1.4131E-04, 1.8789E-06),
     &  ( 1.4132E-04, 1.8098E-06),( 1.4132E-04, 1.7562E-06),
     &  ( 1.4133E-04, 1.7127E-06),( 1.4134E-04, 1.6180E-06)/
  
  
         DATA ((CGM  (I,J), I=   1, 100), J=1,1) /
     &  ( 3.1409E-02,-1.9595E-02),( 3.2084E-02,-1.9571E-02),
     &  ( 3.2559E-02,-1.9550E-02),( 3.3071E-02,-1.9529E-02),
     &  ( 3.3554E-02,-1.9511E-02),( 3.4446E-02,-1.9478E-02),
     &  ( 3.5264E-02,-1.9450E-02),( 3.6022E-02,-1.9426E-02),
     &  ( 3.6729E-02,-1.9404E-02),( 3.7394E-02,-1.9386E-02),
     &  ( 3.8020E-02,-1.9369E-02),( 3.8840E-02,-1.9354E-02),
     &  ( 3.9178E-02,-1.9340E-02),( 3.9716E-02,-1.9328E-02),
     &  ( 4.0230E-02,-1.9317E-02),( 4.0725E-02,-1.9307E-02),
     &  ( 4.1195E-02,-1.9297E-02),( 4.1649E-02,-1.9289E-02),
     &  ( 4.2087E-02,-1.9281E-02),( 4.2509E-02,-1.9273E-02),
     &  ( 4.2916E-02,-1.9266E-02),( 4.3310E-02,-1.9260E-02),
     &  ( 4.3691E-02,-1.9254E-02),( 4.4067E-02,-1.9248E-02),
     &  ( 4.4486E-02,-1.9243E-02),( 4.4767E-02,-1.9238E-02),
     &  ( 4.5105E-02,-1.9233E-02),( 4.5434E-02,-1.9228E-02),
     &  ( 4.5756E-02,-1.9224E-02),( 4.6068E-02,-1.9220E-02),
     &  ( 4.6370E-02,-1.9216E-02),( 4.6666E-02,-1.9213E-02),
     &  ( 4.6973E-02,-1.9210E-02),( 4.7238E-02,-1.9206E-02),
     &  ( 4.7514E-02,-1.9203E-02),( 4.7915E-02,-1.9201E-02),
     &  ( 4.8048E-02,-1.9198E-02),( 4.8306E-02,-1.9195E-02),
     &  ( 4.8559E-02,-1.9193E-02),( 4.8806E-02,-1.9191E-02),
     &  ( 4.9049E-02,-1.9189E-02),( 4.9287E-02,-1.9187E-02),
     &  ( 4.9520E-02,-1.9185E-02),( 4.9798E-02,-1.9183E-02),
     &  ( 4.9974E-02,-1.9181E-02),( 5.0194E-02,-1.9180E-02),
     &  ( 5.0411E-02,-1.9178E-02),( 5.0882E-02,-1.9177E-02),
     &  ( 5.0833E-02,-1.9175E-02),( 5.1038E-02,-1.9174E-02),
     &  ( 5.1240E-02,-1.9173E-02),( 5.1439E-02,-1.9172E-02),
     &  ( 5.1635E-02,-1.9171E-02),( 5.1827E-02,-1.9170E-02),
     &  ( 5.2017E-02,-1.9170E-02),( 5.2203E-02,-1.9169E-02),
     &  ( 5.2387E-02,-1.9168E-02),( 5.2568E-02,-1.9168E-02),
     &  ( 5.2746E-02,-1.9167E-02),( 5.2922E-02,-1.9167E-02),
     &  ( 5.3095E-02,-1.9167E-02),( 5.3266E-02,-1.9166E-02),
     &  ( 5.3434E-02,-1.9166E-02),( 5.3600E-02,-1.9166E-02),
     &  ( 5.3764E-02,-1.9166E-02),( 5.3926E-02,-1.9166E-02),
     &  ( 5.4085E-02,-1.9166E-02),( 5.4243E-02,-1.9166E-02),
     &  ( 5.4398E-02,-1.9166E-02),( 5.4552E-02,-1.9166E-02),
     &  ( 5.4703E-02,-1.9167E-02),( 5.4853E-02,-1.9167E-02),
     &  ( 5.5001E-02,-1.9167E-02),( 5.5147E-02,-1.9168E-02),
     &  ( 5.5291E-02,-1.9168E-02),( 5.5434E-02,-1.9169E-02),
     &  ( 5.5575E-02,-1.9170E-02),( 5.5714E-02,-1.9170E-02),
     &  ( 5.5852E-02,-1.9171E-02),( 5.5988E-02,-1.9172E-02),
     &  ( 5.6123E-02,-1.9173E-02),( 5.6256E-02,-1.9174E-02),
     &  ( 5.6388E-02,-1.9175E-02),( 5.6518E-02,-1.9175E-02),
     &  ( 5.6648E-02,-1.9177E-02),( 5.6775E-02,-1.9178E-02),
     &  ( 5.6902E-02,-1.9179E-02),( 5.7027E-02,-1.9180E-02),
     &  ( 5.7150E-02,-1.9181E-02),( 5.7273E-02,-1.9182E-02),
     &  ( 5.8324E-02,-1.9196E-02),( 5.9291E-02,-1.9213E-02),
     &  ( 6.0187E-02,-1.9234E-02),( 6.1023E-02,-1.9258E-02),
     &  ( 6.1805E-02,-1.9285E-02),( 6.2540E-02,-1.9316E-02),
     &  ( 6.3234E-02,-1.9349E-02),( 6.3891E-02,-1.9386E-02),
     &  ( 6.4515E-02,-1.9426E-02),( 6.5109E-02,-1.9469E-02)/
  
         DATA ((CGM  (I,J), I= 101, 200), J=1,1) /
     &  ( 6.5676E-02,-1.9515E-02),( 6.6218E-02,-1.9564E-02),
     &  ( 6.6739E-02,-1.9615E-02),( 6.7238E-02,-1.9670E-02),
     &  ( 6.7719E-02,-1.9728E-02),( 6.8182E-02,-1.9789E-02),
     &  ( 6.8629E-02,-1.9852E-02),( 6.9061E-02,-1.9919E-02),
     &  ( 6.9479E-02,-1.9988E-02),( 6.9884E-02,-2.0061E-02),
     &  ( 7.0277E-02,-2.0136E-02),( 7.0658E-02,-2.0215E-02),
     &  ( 7.1029E-02,-2.0296E-02),( 7.1389E-02,-2.0380E-02),
     &  ( 7.1740E-02,-2.0467E-02),( 7.2082E-02,-2.0557E-02),
     &  ( 7.2414E-02,-2.0650E-02),( 7.2740E-02,-1.8999E-02),
     &  ( 7.3062E-02,-1.8997E-02),( 7.3375E-02,-1.8995E-02),
     &  ( 7.3681E-02,-1.8993E-02),( 7.3981E-02,-1.8992E-02),
     &  ( 7.4274E-02,-1.8990E-02),( 7.4562E-02,-1.8989E-02),
     &  ( 7.4844E-02,-1.8987E-02),( 7.5121E-02,-1.8986E-02),
     &  ( 7.5393E-02,-1.8984E-02),( 7.5661E-02,-1.8983E-02),
     &  ( 7.5924E-02,-1.8982E-02),( 7.6183E-02,-1.8980E-02),
     &  ( 7.6438E-02,-1.8979E-02),( 7.6689E-02,-1.8978E-02),
     &  ( 7.6936E-02,-1.8977E-02),( 7.7181E-02,-1.8975E-02),
     &  ( 7.7408E-02,-1.8974E-02),( 7.7621E-02,-1.8973E-02),
     &  ( 7.7831E-02,-1.8972E-02),( 7.8037E-02,-1.8971E-02),
     &  ( 7.8239E-02,-1.8970E-02),( 7.8439E-02,-1.8969E-02),
     &  ( 7.8634E-02,-1.8968E-02),( 7.8827E-02,-1.8967E-02),
     &  ( 7.9017E-02,-1.8966E-02),( 7.9204E-02,-1.8965E-02),
     &  ( 7.9387E-02,-1.8964E-02),( 7.9569E-02,-1.8963E-02),
     &  ( 7.9747E-02,-1.8962E-02),( 7.9923E-02,-1.8961E-02),
     &  ( 8.0096E-02,-1.8960E-02),( 8.0267E-02,-1.8960E-02),
     &  ( 8.0435E-02,-1.8959E-02),( 8.0602E-02,-1.8958E-02),
     &  ( 8.0765E-02,-1.8957E-02),( 8.0927E-02,-1.8956E-02),
     &  ( 8.1086E-02,-1.8956E-02),( 8.1244E-02,-1.8955E-02),
     &  ( 8.1399E-02,-1.8954E-02),( 8.1553E-02,-1.8953E-02),
     &  ( 8.1704E-02,-1.8953E-02),( 8.1854E-02,-1.8952E-02),
     &  ( 8.2002E-02,-1.8951E-02),( 8.2147E-02,-1.8950E-02),
     &  ( 8.2292E-02,-1.8950E-02),( 8.2434E-02,-1.8949E-02),
     &  ( 8.2575E-02,-1.8948E-02),( 8.2714E-02,-1.8948E-02),
     &  ( 8.2852E-02,-1.8947E-02),( 8.2988E-02,-1.8946E-02),
     &  ( 8.3122E-02,-1.8946E-02),( 8.3255E-02,-1.8945E-02),
     &  ( 8.3387E-02,-1.8945E-02),( 8.3517E-02,-1.8944E-02),
     &  ( 8.3646E-02,-1.8943E-02),( 8.3773E-02,-1.8943E-02),
     &  ( 8.3899E-02,-1.8942E-02),( 8.4024E-02,-1.8942E-02),
     &  ( 8.4147E-02,-1.8941E-02),( 8.4270E-02,-1.8940E-02),
     &  ( 8.4390E-02,-1.8940E-02),( 8.4510E-02,-1.8939E-02),
     &  ( 8.4629E-02,-1.8939E-02),( 8.4746E-02,-1.8938E-02),
     &  ( 8.4863E-02,-1.8938E-02),( 8.4978E-02,-1.8937E-02),
     &  ( 8.5092E-02,-1.8937E-02),( 8.5205E-02,-1.8936E-02),
     &  ( 8.5317E-02,-1.8936E-02),( 8.5428E-02,-1.8935E-02),
     &  ( 8.5537E-02,-1.8935E-02),( 8.5646E-02,-1.8934E-02),
     &  ( 9.3989E-02,-1.8897E-02),( 9.8861E-02,-1.8874E-02),
     &  ( 1.0232E-01,-1.8853E-02),( 1.0500E-01,-1.8833E-02),
     &  ( 1.0718E-01,-1.8811E-02),( 1.1063E-01,-1.8760E-02),
     &  ( 1.1331E-01,-1.8697E-02),( 1.1549E-01,-1.8621E-02),
     &  ( 1.1734E-01,-1.8530E-02),( 1.2161E-01,-1.8166E-02)/
  
  
         DATA ((CGM  (I,J), I=   1, 100), J=2,2) /
     &  ( 1.0655E-04, 0.0000E+00),( 1.0299E-04, 0.0000E+00),
     &  ( 1.0065E-04, 0.0000E+00),( 9.8962E-05, 0.0000E+00),
     &  ( 9.7677E-05, 0.0000E+00),( 9.5835E-05, 0.0000E+00),
     &  ( 9.4564E-05, 0.0000E+00),( 9.3627E-05, 0.0000E+00),
     &  ( 9.2906E-05, 0.0000E+00),( 9.2334E-05, 0.0000E+00),
     &  ( 9.1868E-05, 0.0000E+00),( 9.1482E-05, 0.0000E+00),
     &  ( 9.1158E-05, 0.0000E+00),( 9.0882E-05, 0.0000E+00),
     &  ( 9.0644E-05, 0.0000E+00),( 9.0438E-05, 0.0000E+00),
     &  ( 9.0258E-05, 0.0000E+00),( 9.0099E-05, 0.0000E+00),
     &  ( 8.9959E-05, 0.0000E+00),( 8.9834E-05, 0.0000E+00),
     &  ( 8.9722E-05, 0.0000E+00),( 8.9621E-05, 0.0000E+00),
     &  ( 8.9530E-05, 0.0000E+00),( 8.9448E-05, 0.0000E+00),
     &  ( 8.9373E-05, 0.0000E+00),( 8.9305E-05, 0.0000E+00),
     &  ( 8.9242E-05, 0.0000E+00),( 8.9185E-05, 0.0000E+00),
     &  ( 8.9132E-05, 0.0000E+00),( 8.9084E-05, 0.0000E+00),
     &  ( 8.9039E-05, 0.0000E+00),( 8.8997E-05, 0.0000E+00),
     &  ( 8.8959E-05, 0.0000E+00),( 8.8923E-05, 0.0000E+00),
     &  ( 8.8890E-05, 0.0000E+00),( 8.8858E-05, 0.0000E+00),
     &  ( 8.8829E-05, 0.0000E+00),( 8.8802E-05, 0.0000E+00),
     &  ( 8.8777E-05, 0.0000E+00),( 8.8753E-05, 0.0000E+00),
     &  ( 8.8730E-05, 0.0000E+00),( 8.8709E-05, 0.0000E+00),
     &  ( 8.8689E-05, 0.0000E+00),( 8.8670E-05, 0.0000E+00),
     &  ( 8.8652E-05, 0.0000E+00),( 8.8635E-05, 0.0000E+00),
     &  ( 8.8620E-05, 0.0000E+00),( 8.8604E-05, 0.0000E+00),
     &  ( 8.8590E-05, 0.0000E+00),( 8.8577E-05, 0.0000E+00),
     &  ( 8.8564E-05, 0.0000E+00),( 8.8551E-05, 0.0000E+00),
     &  ( 8.8540E-05, 0.0000E+00),( 8.8529E-05, 0.0000E+00),
     &  ( 8.8518E-05, 0.0000E+00),( 8.8508E-05, 0.0000E+00),
     &  ( 8.8498E-05, 0.0000E+00),( 8.8489E-05, 0.0000E+00),
     &  ( 8.8480E-05, 0.0000E+00),( 8.8472E-05, 0.0000E+00),
     &  ( 8.8463E-05, 0.0000E+00),( 8.8456E-05, 0.0000E+00),
     &  ( 8.8448E-05, 0.0000E+00),( 8.8441E-05, 0.0000E+00),
     &  ( 8.8434E-05, 0.0000E+00),( 8.8428E-05, 0.0000E+00),
     &  ( 8.8421E-05, 0.0000E+00),( 8.8415E-05, 0.0000E+00),
     &  ( 8.8410E-05, 0.0000E+00),( 8.8404E-05, 0.0000E+00),
     &  ( 8.8399E-05, 0.0000E+00),( 8.8393E-05, 0.0000E+00),
     &  ( 8.8388E-05, 0.0000E+00),( 8.8383E-05, 0.0000E+00),
     &  ( 8.8379E-05, 0.0000E+00),( 8.8374E-05, 0.0000E+00),
     &  ( 8.8370E-05, 0.0000E+00),( 8.8366E-05, 0.0000E+00),
     &  ( 8.8362E-05, 0.0000E+00),( 8.8358E-05, 0.0000E+00),
     &  ( 8.8354E-05, 0.0000E+00),( 8.8350E-05, 0.0000E+00),
     &  ( 8.8347E-05, 0.0000E+00),( 8.8343E-05, 0.0000E+00),
     &  ( 8.8340E-05, 0.0000E+00),( 8.8337E-05, 0.0000E+00),
     &  ( 8.8334E-05, 0.0000E+00),( 8.8331E-05, 0.0000E+00),
     &  ( 8.8328E-05, 0.0000E+00),( 8.8325E-05, 0.0000E+00),
     &  ( 8.8303E-05, 0.0000E+00),( 8.8285E-05, 0.0000E+00),
     &  ( 8.8272E-05, 0.0000E+00),( 8.8261E-05, 0.0000E+00),
     &  ( 8.8252E-05, 0.0000E+00),( 8.8244E-05, 0.0000E+00),
     &  ( 8.8238E-05, 0.0000E+00),( 8.8232E-05, 0.0000E+00),
     &  ( 8.8228E-05, 0.0000E+00),( 8.8224E-05, 0.0000E+00)/
  
         DATA ((CGM  (I,J), I= 101, 200), J=2,2) /
     &  ( 8.8221E-05, 0.0000E+00),( 8.8218E-05, 0.0000E+00),
     &  ( 8.8215E-05, 0.0000E+00),( 8.8213E-05, 0.0000E+00),
     &  ( 8.8211E-05, 0.0000E+00),( 8.8209E-05, 0.0000E+00),
     &  ( 8.8207E-05, 0.0000E+00),( 8.8206E-05, 0.0000E+00),
     &  ( 8.8204E-05, 0.0000E+00),( 8.8203E-05, 0.0000E+00),
     &  ( 8.8202E-05, 0.0000E+00),( 8.8201E-05, 0.0000E+00),
     &  ( 8.8200E-05, 0.0000E+00),( 8.8199E-05, 0.0000E+00),
     &  ( 8.8199E-05, 0.0000E+00),( 8.8198E-05, 0.0000E+00),
     &  ( 8.8197E-05, 0.0000E+00),( 8.8197E-05, 0.0000E+00),
     &  ( 8.8196E-05, 0.0000E+00),( 8.8196E-05, 0.0000E+00),
     &  ( 8.8195E-05, 0.0000E+00),( 8.8195E-05, 0.0000E+00),
     &  ( 8.8194E-05, 0.0000E+00),( 8.8194E-05, 0.0000E+00),
     &  ( 8.8194E-05, 0.0000E+00),( 8.8193E-05, 0.0000E+00),
     &  ( 8.8193E-05, 0.0000E+00),( 8.8193E-05, 0.0000E+00),
     &  ( 8.8192E-05, 0.0000E+00),( 8.8192E-05, 0.0000E+00),
     &  ( 8.8192E-05, 0.0000E+00),( 8.8192E-05, 0.0000E+00),
     &  ( 8.8191E-05, 0.0000E+00),( 8.8191E-05, 0.0000E+00),
     &  ( 8.8191E-05, 0.0000E+00),( 8.8191E-05, 0.0000E+00),
     &  ( 8.8191E-05, 0.0000E+00),( 8.8190E-05, 0.0000E+00),
     &  ( 8.8190E-05, 0.0000E+00),( 8.8190E-05, 0.0000E+00),
     &  ( 8.8190E-05, 0.0000E+00),( 8.8190E-05, 0.0000E+00),
     &  ( 8.8190E-05, 0.0000E+00),( 8.8190E-05, 0.0000E+00),
     &  ( 8.8189E-05, 0.0000E+00),( 8.8189E-05, 0.0000E+00),
     &  ( 8.8189E-05, 0.0000E+00),( 8.8189E-05, 0.0000E+00),
     &  ( 8.8189E-05, 0.0000E+00),( 8.8189E-05, 0.0000E+00),
     &  ( 8.8189E-05, 0.0000E+00),( 8.8189E-05, 0.0000E+00),
     &  ( 8.8189E-05, 0.0000E+00),( 8.8189E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8188E-05, 0.0000E+00),
     &  ( 8.8188E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8187E-05, 0.0000E+00),( 8.8187E-05, 0.0000E+00),
     &  ( 8.8186E-05, 0.0000E+00),( 8.8186E-05, 0.0000E+00),
     &  ( 8.8186E-05, 0.0000E+00),( 8.8186E-05, 0.0000E+00),
     &  ( 8.8186E-05, 0.0000E+00),( 8.8186E-05, 0.0000E+00),
     &  ( 8.8186E-05, 0.0000E+00),( 8.8186E-05, 0.0000E+00),
     &  ( 8.8186E-05, 0.0000E+00),( 8.8186E-05, 0.0000E+00)/
  
  
         DATA ((CGM  (I,J), I=   1, 100), J=3,3) /
     &  ( 3.5774E-04, 2.7541E-05),( 3.2802E-04, 2.5899E-05),
     &  ( 3.0915E-04, 2.4563E-05),( 2.9613E-04, 2.3458E-05),
     &  ( 2.8663E-04, 2.2531E-05),( 2.7368E-04, 2.1067E-05),
     &  ( 2.6529E-04, 1.9964E-05),( 2.5941E-04, 1.9103E-05),
     &  ( 2.5506E-04, 1.8409E-05),( 2.5173E-04, 1.7835E-05),
     &  ( 2.4910E-04, 1.7349E-05),( 2.4701E-04, 1.6930E-05),
     &  ( 2.4522E-04, 1.6562E-05),( 2.4375E-04, 1.6236E-05),
     &  ( 2.4251E-04, 1.5942E-05),( 2.4145E-04, 1.5676E-05),
     &  ( 2.4052E-04, 1.5432E-05),( 2.3972E-04, 1.5207E-05),
     &  ( 2.3902E-04, 1.4998E-05),( 2.3840E-04, 1.4803E-05),
     &  ( 2.3785E-04, 1.4621E-05),( 2.3736E-04, 1.4449E-05),
     &  ( 2.3692E-04, 1.4287E-05),( 2.3652E-04, 1.4133E-05),
     &  ( 2.3618E-04, 1.3987E-05),( 2.3583E-04, 1.3849E-05),
     &  ( 2.3554E-04, 1.3716E-05),( 2.3527E-04, 1.3589E-05),
     &  ( 2.3502E-04, 1.3468E-05),( 2.3479E-04, 1.3352E-05),
     &  ( 2.3458E-04, 1.3240E-05),( 2.3439E-04, 1.3132E-05),
     &  ( 2.3422E-04, 1.3029E-05),( 2.3404E-04, 1.2929E-05),
     &  ( 2.3389E-04, 1.2832E-05),( 2.3378E-04, 1.2739E-05),
     &  ( 2.3361E-04, 1.2649E-05),( 2.3348E-04, 1.2562E-05),
     &  ( 2.3337E-04, 1.2477E-05),( 2.3326E-04, 1.2395E-05),
     &  ( 2.3316E-04, 1.2316E-05),( 2.3306E-04, 1.2238E-05),
     &  ( 2.3297E-04, 1.2163E-05),( 2.3290E-04, 1.2090E-05),
     &  ( 2.3280E-04, 1.2019E-05),( 2.3273E-04, 1.1950E-05),
     &  ( 2.3266E-04, 1.1883E-05),( 2.3266E-04, 1.1817E-05),
     &  ( 2.3252E-04, 1.1753E-05),( 2.3246E-04, 1.1691E-05),
     &  ( 2.3241E-04, 1.1630E-05),( 2.3235E-04, 1.1570E-05),
     &  ( 2.3230E-04, 1.1512E-05),( 2.3225E-04, 1.1455E-05),
     &  ( 2.3220E-04, 1.1400E-05),( 2.3216E-04, 1.1346E-05),
     &  ( 2.3211E-04, 1.1293E-05),( 2.3207E-04, 1.1241E-05),
     &  ( 2.3204E-04, 1.1190E-05),( 2.3200E-04, 1.1140E-05),
     &  ( 2.3196E-04, 1.1092E-05),( 2.3193E-04, 1.1044E-05),
     &  ( 2.3190E-04, 1.0997E-05),( 2.3187E-04, 1.0951E-05),
     &  ( 2.3184E-04, 1.0906E-05),( 2.3181E-04, 1.0862E-05),
     &  ( 2.3178E-04, 1.0819E-05),( 2.3175E-04, 1.0776E-05),
     &  ( 2.3173E-04, 1.0735E-05),( 2.3170E-04, 1.0694E-05),
     &  ( 2.3168E-04, 1.0654E-05),( 2.3166E-04, 1.0614E-05),
     &  ( 2.3164E-04, 1.0575E-05),( 2.3162E-04, 1.0537E-05),
     &  ( 2.3160E-04, 1.0500E-05),( 2.3158E-04, 1.0463E-05),
     &  ( 2.3156E-04, 1.0426E-05),( 2.3154E-04, 1.0391E-05),
     &  ( 2.3152E-04, 1.0356E-05),( 2.3151E-04, 1.0321E-05),
     &  ( 2.3149E-04, 1.0287E-05),( 2.3148E-04, 1.0254E-05),
     &  ( 2.3146E-04, 1.0221E-05),( 2.3145E-04, 1.0189E-05),
     &  ( 2.3143E-04, 1.0157E-05),( 2.3142E-04, 1.0125E-05),
     &  ( 2.3141E-04, 1.0094E-05),( 2.3139E-04, 1.0064E-05),
     &  ( 2.3138E-04, 1.0034E-05),( 2.3137E-04, 1.0004E-05),
     &  ( 2.3128E-04, 9.7552E-06),( 2.3121E-04, 9.5342E-06),
     &  ( 2.3116E-04, 9.3361E-06),( 2.3111E-04, 9.1572E-06),
     &  ( 2.3108E-04, 8.9944E-06),( 2.3105E-04, 8.8455E-06),
     &  ( 2.3103E-04, 8.7085E-06),( 2.3101E-04, 8.5819E-06),
     &  ( 2.3100E-04, 8.4644E-06),( 2.3098E-04, 8.3550E-06)/
  
         DATA ((CGM  (I,J), I= 101, 200), J=3,3) /
     &  ( 2.3097E-04, 8.2528E-06),( 2.3096E-04, 8.1569E-06),
     &  ( 2.3096E-04, 8.0667E-06),( 2.3095E-04, 7.9818E-06),
     &  ( 2.3095E-04, 7.9015E-06),( 2.3094E-04, 7.8254E-06),
     &  ( 2.3094E-04, 7.7533E-06),( 2.3094E-04, 7.6847E-06),
     &  ( 2.3093E-04, 7.6194E-06),( 2.3093E-04, 7.5571E-06),
     &  ( 2.3093E-04, 7.4975E-06),( 2.3093E-04, 7.4406E-06),
     &  ( 2.3093E-04, 7.3860E-06),( 2.3093E-04, 7.3336E-06),
     &  ( 2.3093E-04, 7.2833E-06),( 2.3093E-04, 7.2350E-06),
     &  ( 2.3093E-04, 7.1884E-06),( 2.3093E-04, 6.8775E-06),
     &  ( 2.3093E-04, 6.8141E-06),( 2.3093E-04, 6.7570E-06),
     &  ( 2.3093E-04, 6.7053E-06),( 2.3093E-04, 6.6579E-06),
     &  ( 2.3093E-04, 6.6139E-06),( 2.3093E-04, 6.5726E-06),
     &  ( 2.3093E-04, 6.5336E-06),( 2.3093E-04, 6.4966E-06),
     &  ( 2.3093E-04, 6.4613E-06),( 2.3093E-04, 6.4275E-06),
     &  ( 2.3093E-04, 6.3951E-06),( 2.3093E-04, 6.3640E-06),
     &  ( 2.3093E-04, 6.3340E-06),( 2.3094E-04, 6.3050E-06),
     &  ( 2.3094E-04, 6.2770E-06),( 2.3094E-04, 6.2499E-06),
     &  ( 2.3094E-04, 6.2236E-06),( 2.3094E-04, 6.1981E-06),
     &  ( 2.3094E-04, 6.1733E-06),( 2.3094E-04, 6.1491E-06),
     &  ( 2.3094E-04, 6.1257E-06),( 2.3094E-04, 6.1028E-06),
     &  ( 2.3094E-04, 6.0805E-06),( 2.3094E-04, 6.0587E-06),
     &  ( 2.3095E-04, 6.0374E-06),( 2.3095E-04, 6.0166E-06),
     &  ( 2.3095E-04, 5.9963E-06),( 2.3095E-04, 5.9765E-06),
     &  ( 2.3095E-04, 5.9571E-06),( 2.3095E-04, 5.9380E-06),
     &  ( 2.3095E-04, 5.9194E-06),( 2.3095E-04, 5.9012E-06),
     &  ( 2.3095E-04, 5.8833E-06),( 2.3095E-04, 5.8657E-06),
     &  ( 2.3095E-04, 5.8485E-06),( 2.3096E-04, 5.8316E-06),
     &  ( 2.3096E-04, 5.8151E-06),( 2.3096E-04, 5.7988E-06),
     &  ( 2.3096E-04, 5.7828E-06),( 2.3096E-04, 5.7671E-06),
     &  ( 2.3096E-04, 5.7517E-06),( 2.3096E-04, 5.7365E-06),
     &  ( 2.3096E-04, 5.7216E-06),( 2.3096E-04, 5.7069E-06),
     &  ( 2.3096E-04, 5.6925E-06),( 2.3096E-04, 5.6783E-06),
     &  ( 2.3097E-04, 5.6643E-06),( 2.3097E-04, 5.6505E-06),
     &  ( 2.3097E-04, 5.6370E-06),( 2.3097E-04, 5.6237E-06),
     &  ( 2.3097E-04, 5.6105E-06),( 2.3097E-04, 5.5976E-06),
     &  ( 2.3097E-04, 5.5848E-06),( 2.3097E-04, 5.5722E-06),
     &  ( 2.3097E-04, 5.5598E-06),( 2.3097E-04, 5.5476E-06),
     &  ( 2.3097E-04, 5.5356E-06),( 2.3097E-04, 5.5237E-06),
     &  ( 2.3098E-04, 5.5119E-06),( 2.3098E-04, 5.5004E-06),
     &  ( 2.3098E-04, 5.4890E-06),( 2.3098E-04, 5.4777E-06),
     &  ( 2.3098E-04, 5.4666E-06),( 2.3098E-04, 5.4556E-06),
     &  ( 2.3098E-04, 5.4448E-06),( 2.3098E-04, 5.4341E-06),
     &  ( 2.3098E-04, 5.4235E-06),( 2.3098E-04, 5.4131E-06),
     &  ( 2.3098E-04, 5.4028E-06),( 2.3098E-04, 5.3926E-06),
     &  ( 2.3098E-04, 5.3825E-06),( 2.3098E-04, 5.3726E-06),
     &  ( 2.3104E-04, 4.6852E-06),( 2.3107E-04, 4.3419E-06),
     &  ( 2.3110E-04, 4.1205E-06),( 2.3112E-04, 3.9602E-06),
     &  ( 2.3112E-04, 3.8359E-06),( 2.3115E-04, 3.6514E-06),
     &  ( 2.3117E-04, 3.5173E-06),( 2.3117E-04, 3.4131E-06),
     &  ( 2.3119E-04, 3.3286E-06),( 2.3122E-04, 3.1446E-06)/
  
       save
       RETURN
       END
