      program testalpha_complex
C calculates Delta alpha from 5 quark sector, using tabled in hadr5n23.f 
      implicit none
      character*3 contributionflag
      integer i,n,ier,Ismooth, IORIN,NFIN
      real e,emin,emax,de,dst2 
      double precision st2,als,mtop
      double precision s,error,null,rerr,ierr
      double complex funalpqedcx,cggvap,
     &     calperror,calperrorsta,calperrorsys
      double complex funalp2SMcx,cegvapx,
     &     calp2error,calp2errorsta,calp2errorsys
      double complex cggvapx,cerrder,cerrdersta,cerrdersys,
     &     calept,cahadr,caltop,cDalphaweak1MSb,
     &     cglept,cghadr,cgetop,cDalpha2weak1MSb
      double complex cone,calp,cvpt_new,cvpt_hig,cvpt_low,alphac,alphah
     &     ,alphal,alphact,alphaht,alphalt,alpha2c
      real alpha,alpha2,dimagalp,dimagalp2,
     &     erralp,erralp2,errimagalp,errimagalp2
      double complex r1c,r1l,r1h
      double precision reno,renl,renh
      external cggvapx,cegvapx,funalpqedcx,funalp2SMcx
      include '../common.h'
c detailed results available via the following commons:
      common /cres/calept,cahadr,caltop,cDalphaweak1MSb  ! complex results delta alpha from leptons,hadrons,top quark and weak
      common /cesg/cglept,cghadr,cgetop,cDalpha2weak1MSb ! the same for delta alpha_2
      common /parm/st2,als,mtop
      call constants()
C LEPTONflag=all,had,lep,ele,muo,tau -> iLEP=-3,-2,-1,1,2,3
C Default: 
C      LEPTONflag='all'
C      iLEP  = -3  ! for sum of leptons + quarks              
c the parameter xMW [provided via common.h] allows to change W threshold default M_W, e.g. to xMW=2.d0*MW
c      xMW=null is set in constants ! default M_W
C      common /cres/calept,cahadr,caltop,cDalphaweak1MSb  ! complex results
C     set common param here
      null=0.0d0
      calp=DCMPLX(alp,null)
      als=0.1189d0     ! +/- 0.0017
      st2=0.23153d0    ! Reference value for weak mixing parameter used in calculation SU(2) coupling shift deg
      mtop=172.4d0
      contributionflag='all'
      LEPTONflag=contributionflag
      iLEP=LFLAG(LEPTONflag)
      xMW=2.d0*MW
      dst2=st2
      n=300
      n=200
      n=400
      write (1,*) '      4.00000 '
      write (1,*) '      1.00000 '
      write (1,*) '   ',float(n-1)
      write (1,*) 'c energy(GeV),    Re alpha    ,  Re tot_error'
      write (2,*) '      4.00000 '
      write (2,*) '      1.00000 '
      write (2,*) '   ',float(n-1)
      write (2,*) 'c energy(GeV),    Re alpha_2  , Re  tot_error'
      write (3,*) '      4.00000 '
      write (3,*) '      1.00000 '
      write (3,*) '   ',float(n-1)
      write (3,*) 'c energy(GeV),    Im alpha    ,  Im tot_error'
      write (4,*) '      4.00000 '
      write (4,*) '      1.00000 '
      write (4,*) '   ',float(n-1)
      write (4,*) 'c energy(GeV),    Im alpha_2   , Im  tot_error'
      write (7,*) '      4.00000 '
      write (7,*) '      1.00000 '
      write (7,*) '   ',float(n-1)
      write (7,*) 'c energy(GeV),  |alpha(0)/alpha(s)|^2 ,   tot_error'
      write (8,*) '      4.00000 '
      write (8,*) '      1.00000 '
      write (8,*) '   ',float(n-1)
      write (8,*) 'c energy(GeV),  Re alpha(s)/alpha2(s),kappa=.../st2'
      emin= -120.00d0
      emax= 0.0d0
      emin=-0.5d0
      emax= 0.98d0
C      emin= 0.5d0
C     emax= 0.8d0
      write (*,*) ' specify energy range: enter emin,emax'
      read (*,*)  emin,emax
      de=(emax-emin)/n
      ier=0
      e=emin
      do i=1,n 
         s=e*abs(e)
         alphac  = funalpqedcx(s,calperror,calperrorsta,calperrorsys,
     &        contributionflag,Wtopflag)
         alpha2c = funalp2SMcx(s,calp2error,calp2errorsta,calp2errorsys,
     &        contributionflag,Wtopflag)
         alpha =REAL(alphac)
         alpha2=REAL(alpha2c)
         dimagalp =AIMAG(alphac)
         dimagalp2=AIMAG(alpha2c)
         erralp =REAL(calperror)
         erralp2=REAL(calp2error)
         errimagalp =AIMAG(calperror)
         errimagalp2=AIMAG(calp2error)
c e^+ e^- cross sections grow with |alpha(s)|^2 relative to the low energy alpha; 
C undresssing from vacuum polarization (screening) effects is given by         
         alphah=alphac+calperror
         alphal=alphac-calperror
         r1c=calp/alphac
         r1h=calp/alphah
         r1l=calp/alphal
         reno=r1c*DCONJG(r1c)   ! undressing factor
         renh=r1h*DCONJG(r1h)   ! + error
         renl=r1l*DCONJG(r1l)   ! - error
         write (1,98) e,alpha,erralp,erralp
         write (2,98) e,alpha2,erralp2,erralp2
         write (3,98) e,dimagalp,errimagalp,errimagalp
         write (4,98) e,dimagalp2,errimagalp2,errimagalp2
         write (7,98) e,reno,renl,renh
         write (8,98) e,alpha/alpha2,alpha/alpha2/st2
         e=e+de
      enddo
      write (*,*) ' Results: Re alpha on fort.1, Re alpha_2 on fort.2'
      write (*,*) '          Im alpha on fort.3, Im alpha_2 on fort.4'
      write (*,*) '          |alpha(0)/alpha(s)|^2 on fort.7'
      write (*,*) ' sin^2_eff = DREAL(alpha(s)/alpha_2(s)) on fort.8'
 98   format(4(2x,1pe12.5))
      end
