#!/bin/csh -fx
if ("$1" == "") then
set emin = 0.3
else
set emin= ($1)
endif
if ("$2" == "") then
set emax = 1.06
else
set emax= ($2)
endif

make -f make_testalpha prog=testhadr5x
make -f make_testalpha prog=testchadr5x


echo $emin, $emax > hadr5x23.inp

echo ' run testhadr5x'
time ./testchadr5x < hadr5x23.inp 
time ./testhadr5x < hadr5x23.inp 

echo "Results in fort.1,2,3,4 ..."

cat testhadr5x_gnu.in > gnuplo.in
cat >> gnuplo.in <<_EOF_
set ylabel "{/Symbol D}{/Symbol a}^{(5)}_{had}(E)" 
plot "fort.1" skip 3 using 1:2 with lines ls 2 t "chadr5x23",\
  "fort.11" skip 3 using 1:2 with lines ls 1 t "hadr5x23"
pause -1
clear
_EOF_

gnuplot -persist gnuplo.in


echo -n "Next figure? press RETURN"
set ans1=$<


cat testhadr5x_gnu.in > gnuplo.in
cat >> gnuplo.in <<_EOF_
set ylabel "{/Symbol D}{/Symbol a}^{(5)}_{2 had}(E)" 
plot "fort.2" skip 3 using 1:2 with lines ls 2 t "chadr5x23",\
  "fort.12" skip 3 using 1:2 with lines ls 1 t "hadr5x23"
pause -1
clear
_EOF_

gnuplot -persist gnuplo.in


exit 0
usage:
testhad5x_gnu.sh
exit 2

