      program testsin2theta_complex
C     calculates low energy sin2theta with sin2theta(M_Z) as input
c      using hadronic cintributions tabled in hadr5x23_complex.f 
c calculating sin^2 Theta using alphaQED package with hadronic contributions as tabled in hadr5n23.f
c using on-shell Møller scattering corrections for the SM boson contribution
c as calculated by A. Czarnecki and W. Marciano  Int.J.Mod.Phys. A15 (2000) 2365-2376  [hep-ph/0003049] 
c produces data for sin^2 Theta plot shown at the end of alphaQED17.pdf updated hadr5n23.f
      implicit none
      character*3 contributionflag
      integer i,j,n,Nall,Nhigh,irange,nlow,IORIN,NFIN
      parameter(Nall=2193)
      real *8 X(Nall)
      INTEGER NA,NB
      PARAMETER(NA=979,NB=200)
      REAL ETX(NA),ESX(NB)
      double precision null,one,ha,two,four,sin2w,cos2w,alpfac,
     &     fivethird,mw2,mz2,Q,Q2,q0,q1,x0,x1,xxx,dx,
     &     sin2wofq,sin2wofqn,
     &     e,s,als,st2,mtop,alpha_2wz
      double precision kappac,kappaCM,kappasav,dkappaf,dkappab,
     &     sin2w0,sin2wz,kappa0,dkappab0,sin2wzrelnew,big,
     &     kappah,kappal,sin2wofqh,sin2wofql,qx
      double precision xx(13),sl(13),sh(13)
      real*8 alp2,weaksav,weak2sav,
     &     kappahW,kappalW,kappacW,sin2wofqnW,sin2wofqhW,sin2wofqlW
      double precision deltavertbox,cw2,mu2,sin2thetae,sin2thetaeW,
     &     sin2thetanumue,sin2relthetanumue
      double precision sin2wofqT,sin2wofqnT,sin2wofqhT,sin2wofqlT
      double complex funsin2thetaSM,ckappac,cerror,cerrorsta,cerrorsys,
     &     ckappacW,sin2thetaLEP
      double complex calept,cahadr,caltop,cDalphaweak1MSb,
     &               cglept,cghadr,cgetop,cDalpha2weak1MSb
      double precision  renoZ
      external funsin2thetaSM
********************* part to be included in main program **************
      include '../common.h'
      common /parm/st2,als,mtop
      common /cres/calept,cahadr,caltop,cDalphaweak1MSb
      common /cesg/cglept,cghadr,cgetop,cDalpha2weak1MSb
c allowes to change W threshold default 2 M_W
      null=0.d0
      call constants()
c      sin2ell=0.23153 ! pm 0.00016 LEPEEWG Phys Rep 427 (2006) 257
      als=0.1189d0     ! +/- 0.0017
      st2=0.23153d0    ! Reference value for weak mixing parameter used in calculation SU(2) coupling shift deg
      mtop=171.3d0
      IORIN=4
      NFIN =5
      contributionflag='all'
      LEPTONflag=contributionflag
      iLEP=LFLAG(LEPTONflag)
      include'../xRdat-extended.f'
c sin2theta tuning normalization (corresponds to determination of SU(2)
c coupling alpha_2=g^2/(4pi) (for which no Thomson limit type
c experimental determination is available)
C alpha_2 at MW scale = sqrt(2)*Gmu*MW2/pi =  3.3914391807516084E-002
      sin2wz=0.23153d0  ! LEP 1 2006 update = st2
      sin2w0=0.238375d0 ! low energy value adapted to LEP sin2wz at Z scale
      sin2wzrelnew=sin2wz/0.232377d0/0.998105407
      sin2relthetanumue=sin2wz/0.240038d0/0.998105407    
c ckeck top entry of fort.1  entry column3 / entry column 2 if they do not agree     
      kappa0=0.237501d0/0.237337d0/0.997677326 ! normalization of effective pQCD at low momenta    
      one=1.d0
      null=0.d0
      ha=0.5d0
      two=2.d0
      four=4.d0
      fivethird=5.d0/3.d0
c alp,mw,mz in common/constants
      alp2=alp/st2
      mw2=mw*mw
      mz2=mz*mz
      alpha_2wz=sqrt(2.d0)*gmu*mw2/pi
      write (*,*) ' alpha_2 at MW scale',alpha_2wz
      sin2w=0.23073d0  ! =/-0.00028  Czarnecki & Marciano sin2 theta_W(M_Z) MSbar
      sin2w=sin2wz
      st2=sin2w0
      cos2w=one-sin2w
      alpfac=alp*0.5d0/pi/sin2w
c     LEP reference value reset
      s=MZ**2
         sin2thetaLEP=funsin2thetaSM(s,cerror,cerrorsta,cerrorsys,
     &     'all',0)
      renoZ=st2/DREAL(sin2thetaLEP)
      write (*,*) ' ini sin2thataLEP,reno',DREAL(sin2thetaLEP),renoZ
      n=500
      nhigh=n
      nlow=0
      q0=0.0020d0
c irange flag: 0=space-like, 1=time-like
      irange=1
      irange=0
c     irange=-1
      write (*,*) ' Enter irange flag: 0=space-like, 1=time-like'
      read  (*,*) irange
      if (irange.eq.1) then
c use resonance scan
         nlow=20
         n=nlow+Nall+Nhigh
      else if (irange.eq.-1) then
c standard however with time-like running couplings
         n=2000
         nhigh=n
      else if (irange.eq.0) then
c standard space-like channel
         n=2000
         nhigh=n
      endif
c precalculate kappa(M_Z)
c      q0=mz
      qx=999.990d0
      q1=1400.00d0
      qx=q1
      x0=log10(q0)
      x1=log10(q1)
      dx=(x1-x0)/n
      xxx=x0
      write (1,*) '      4.0000'
      write (1,*) '      1.0000'
      write (1,*) '  ',float(n+1)
      write (1,*) ' sin2 of hadr5n data table central,'
      write (1,*) ' at 1000 GeV match to pQCD anaytic: cenral,high,low'
      write (3,*) '      2.0000'
      write (3,*) '      1.0000'
      write (3,*) '  ',float(n+1)
      write (7,*) '      2.0000'
      write (7,*) '      1.0000'
      write (7,*) '  ',float(n+1)
      write (8,*) '      3.0000'
      write (8,*) '      1.0000'
      write (8,*) '  ',float(n+1)
      write (8,*) ' VP effects only from hadr5n central high low'
      write (9,*) '      4.0000'
      write (9,*) '      1.0000'
      write (9,*) '  ',float(n+1)
      write (9,*) ' including nu_mu-e scattering vertex + box:',
     &     'no W, with W, VP only no W, VP only with W'
      big=1.d6
c resonance raster mode
      if (irange.eq.1) then
         x0=log10(q0)
         x1=log10(X(1))
         dx=(x1-x0)/nlow
         xxx=x0
         do j=1,nlow
            Q=10.d0**xxx
            Q2=Q*Q
            s=-Q2
            call kappa_MoellerScattering(sin2w,Q2,kappaCM,
     &           dkappab,dkappaf,dkappab0)
C            sin2wofq=sin2w*kappaCM*renoZ
            sin2wofq=sin2w*kappaCM*kappa0
            kappasav=kappaCM*kappa0
            e=-Q
C Attentione! dggvapx and degvapx return complete fermion contribution
            Wtopflag=0
            ckappac=funsin2thetaSM(-s,cerror,cerrorsta,cerrorsys,
     &           contributionflag,Wtopflag)/st2
            kappac=DREAL(ckappac)
     &           +dkappab-dkappab0
            kappah=kappac+DREAL(cerror)
            kappal=kappac-DREAL(cerror)
            Wtopflag=2
            ckappacW=funsin2thetaSM(-s,cerror,cerrorsta,cerrorsys,
     &           contributionflag,Wtopflag)/st2
            kappacW=DREAL(ckappacW)
            kappahW=kappacW+DREAL(cerror)
            kappalW=kappacW-DREAL(cerror)
c include neutrino charge radius
            mu2=ml(2)**2
            cw2=cos2w
            sin2thetanumue=st2
            deltavertbox=alp2/4.d0/pi*(2.d0/3.d0*(dlog(MW2/mu2)+1.d0)
     &           +(24.d0*cw2**2-14.d0*cw2+9.d0)/(4.d0*cw2))
            sin2thetae =(kappac+deltavertbox)*sin2thetanumue
            sin2thetaeW=(kappacW+deltavertbox)*sin2thetanumue
            weaksav =DREAL(cDalphaweak1MSb)
            weak2sav=DREAL(cDalpha2weak1MSb)
            sin2wofqn=st2*kappac*sin2wzrelnew
            sin2wofqh=st2*kappah*sin2wzrelnew
            sin2wofql=st2*kappal*sin2wzrelnew
            write (3,124) Q,kappasav,kappac,dkappab-dkappab0
c C & M effective pQCD, using hadr5n23.f central high low
            if (Q.lt.1000.d0) then
               sin2wofqT =sin2wofq 
               sin2wofqnT=sin2wofqn
               sin2wofqhT=sin2wofqh
               sin2wofqlT=sin2wofql
            endif
            if (Q.ge.1000.d0) then
C               write (*,*) sin2wofqT,sin2wofqnT,sin2wofqhT,sin2wofqlT
c in the timelike region hadr5n data table ends at 1000. GeV
c match it to pQCD anaytic
               sin2wofqn =sin2wofqnT/sin2wofqT*sin2wofq 
               sin2wofqh =sin2wofqhT/sin2wofqT*sin2wofq 
               sin2wofql =sin2wofqlT/sin2wofqT*sin2wofq 
            endif
            write (1,124) Q,sin2wofq,sin2wofqn,sin2wofqh,sin2wofql
            sin2wofqnW=st2*kappacW*sin2wzrelnew
            sin2wofqhW=st2*kappahW*sin2wzrelnew
            sin2wofqlW=st2*kappalW*sin2wzrelnew
c VP effects only from hadr5n23.f central high low
            write (8,124) Q,sin2wofqnW,sin2wofqhW,sin2wofqlW
c including nu_mu-e scattering vertex + box: no W, with W, VP only no W, VP only with W
            write (9,124) Q,sin2thetae*sin2relthetanumue,
     &           sin2thetaeW*sin2relthetanumue,
     &           kappac*st2*sin2wzrelnew,kappacW*st2*sin2wzrelnew
            xxx=xxx+dx
         enddo
         do j=1,Nall
            e=x(j)
            Q=e
            s=e*e 
            Q2=Q*Q
            s=-Q2
            call kappa_MoellerScattering(sin2w,Q2,kappaCM,
     &           dkappab,dkappaf,dkappab0)
            sin2wofq=sin2w*kappaCM*kappa0
            kappasav=kappaCM*kappa0
            e=-Q
C Attentione! dggvapx and degvapx return complete fermion contribution
            Wtopflag=0
            ckappac=funsin2thetaSM(-s,cerror,cerrorsta,cerrorsys,
     &           contributionflag,Wtopflag)/st2
            kappac=DREAL(ckappac)
     &           +dkappab-dkappab0
            kappah=kappac+DREAL(cerror)
            kappal=kappac-DREAL(cerror)
            Wtopflag=2
            ckappacW=funsin2thetaSM(-s,cerror,cerrorsta,cerrorsys,
     &           contributionflag,Wtopflag)/st2
            kappacW=DREAL(ckappacW)
            kappahW=kappacW+DREAL(cerror)
            kappalW=kappacW-DREAL(cerror)
c include neutrino charge radius
            mu2=ml(2)**2
            cw2=cos2w
            sin2thetanumue=st2
            deltavertbox=alp2/4.d0/pi*(2.d0/3.d0*(dlog(MW2/mu2)+1.d0)
     &           +(24.d0*cw2**2-14.d0*cw2+9.d0)/(4.d0*cw2))
            sin2thetae =(kappac+deltavertbox)*sin2thetanumue
            sin2thetaeW=(kappacW+deltavertbox)*sin2thetanumue
            weaksav=DREAL(cDalphaweak1MSb)
            weak2sav=DREAL(cDalpha2weak1MSb)
            sin2wofqn=st2*kappac*sin2wzrelnew
            sin2wofqh=st2*kappah*sin2wzrelnew
            sin2wofql=st2*kappal*sin2wzrelnew
            write (3,124) Q,kappasav,kappac,dkappab-dkappab0
c C & M effective pQCD, using hadr5n23.f central high low
            if (Q.lt.1000.d0) then
               sin2wofqT =sin2wofq 
               sin2wofqnT=sin2wofqn
               sin2wofqhT=sin2wofqh
               sin2wofqlT=sin2wofql
            endif
            if (Q.ge.1000.d0) then
C               write (*,*) sin2wofqT,sin2wofqnT,sin2wofqhT,sin2wofqlT
c in the timelike region hadr5n data table ends at 1000. GeV
c match it to pQCD anaytic
               sin2wofqn =sin2wofqnT/sin2wofqT*sin2wofq 
               sin2wofqh =sin2wofqhT/sin2wofqT*sin2wofq 
               sin2wofql =sin2wofqlT/sin2wofqT*sin2wofq 
            endif
            write (1,124) Q,sin2wofq,sin2wofqn,sin2wofqh,sin2wofql
            sin2wofqnW=st2*kappacW*sin2wzrelnew
            sin2wofqhW=st2*kappahW*sin2wzrelnew
            sin2wofqlW=st2*kappalW*sin2wzrelnew
c VP effects only from hadr5x23_complex.f central high low
            write (8,124) Q,sin2wofqnW,sin2wofqhW,sin2wofqlW
c including nu_mu-e scattering vertex + box: no W, with W, VP only no W, VP only with W
            write (9,124) Q,sin2thetae*sin2relthetanumue,
     &           sin2thetaeW*sin2relthetanumue,
     &           kappac*st2*sin2wzrelnew,kappacW*st2*sin2wzrelnew
         enddo
      endif
      if (irange.eq.1) q0=x(Nall)
      x0=log10(q0)
      x1=log10(q1)
      dx=(x1-x0)/nhigh
      xxx=x0
      if (irange.eq.1) xxx=xxx+dx
      do j=1,nhigh+1
         Q=10.d0**xxx
C         if (j.eq.nhigh+2) Q=mz
         Q2=Q*Q
         s=-Q2
         call kappa_MoellerScattering(sin2w,Q2,kappaCM,
     &        dkappab,dkappaf,dkappab0)
         sin2wofq=sin2w*kappaCM*kappa0
         kappasav=kappaCM*kappa0
         e=-Q
C Attentione! dggvapx and degvapx return complete fermion contribution
         if (Q.le.qx) then
            Wtopflag=0
            if (irange.eq.0) then
               ckappac=funsin2thetaSM(s,cerror,cerrorsta,cerrorsys,
     &              contributionflag,Wtopflag)/st2
            else
               ckappac=funsin2thetaSM(-s,cerror,cerrorsta,cerrorsys,
     &              contributionflag,Wtopflag)/st2
            endif
            kappac=DREAL(ckappac)
     &           +dkappab-dkappab0
            kappah=kappac+DREAL(cerror)
            kappal=kappac-DREAL(cerror)
            Wtopflag=2
            if (irange.eq.0) then
               ckappacW=funsin2thetaSM(s,cerror,cerrorsta,cerrorsys,
     &              contributionflag,Wtopflag)/st2
            else
               ckappacW=funsin2thetaSM(-s,cerror,cerrorsta,cerrorsys,
     &              contributionflag,Wtopflag)/st2
            endif
            kappacW=DREAL(ckappacW)
            kappahW=kappacW+DREAL(cerror)
            kappalW=kappacW-DREAL(cerror)
c include neutrino charge radius
            mu2=ml(2)**2
            cw2=cos2w
            sin2thetanumue=st2
            deltavertbox=alp2/4.d0/pi*(2.d0/3.d0*(dlog(MW2/mu2)+1.d0)
     &           +(24.d0*cw2**2-14.d0*cw2+9.d0)/(4.d0*cw2))
            sin2thetae =(kappac+deltavertbox)*sin2thetanumue
            sin2thetaeW=(kappacW+deltavertbox)*sin2thetanumue
            weaksav=DREAL(cDalphaweak1MSb)
            weak2sav=DREAL(cDalpha2weak1MSb)
            sin2wofqn=st2*kappac*sin2wzrelnew
            sin2wofqh=st2*kappah*sin2wzrelnew
            sin2wofql=st2*kappal*sin2wzrelnew
         else
            sin2wofqn=sin2wofq
            sin2wofqh=sin2wofq
            sin2wofql=sin2wofq
         endif
c         del=(sin2wofqh-sin2wql)/2.d0
C         write (7,124) abs(Q),alphac,alphal,alphah,alphacs
         write (3,124) Q,kappasav,kappac,dkappab-dkappab0
c C & M effective pQCD, using hadr5n12.f central high low
            if (Q.lt.1000.d0) then
               sin2wofqT =sin2wofq 
               sin2wofqnT=sin2wofqn
               sin2wofqhT=sin2wofqh
               sin2wofqlT=sin2wofql
            endif
            if (Q.ge.1000.d0) then
C               write (*,*) sin2wofqT,sin2wofqnT,sin2wofqhT,sin2wofqlT
c in the timelike region hadr5n data table ends at 1000. GeV
c match it to pQCD anaytic
               sin2wofqn =sin2wofqnT/sin2wofqT*sin2wofq 
               sin2wofqh =sin2wofqhT/sin2wofqT*sin2wofq 
               sin2wofql =sin2wofqlT/sin2wofqT*sin2wofq 
            endif
         write (1,124) Q,sin2wofq,sin2wofqn,sin2wofqh,sin2wofql
         sin2wofqnW=st2*kappacW*sin2wzrelnew
         sin2wofqhW=st2*kappahW*sin2wzrelnew
         sin2wofqlW=st2*kappalW*sin2wzrelnew
c VP effects only from hadr5n23.f central high low
         write (8,124) Q,sin2wofqnW,sin2wofqhW,sin2wofqlW
c including nu_mu-e scattering vertex + box: no W, with W, VP only no W, VP only with W
         write (9,124) Q,sin2thetae*sin2relthetanumue,
     &        sin2thetaeW*sin2relthetanumue,
     &        kappac*st2*sin2wzrelnew,kappacW*st2*sin2wzrelnew
         xxx=xxx+dx
      enddo
C   90.614071    0.230994    0.231094    0.231094    0.231094
C   91.260696    0.230992    0.231091    0.231091    0.231091
C      write (*,*) (0.231094+(0.231091-0.231094)/(91.260696-90.614071)
C     &     *(91.188-90.614071))/0.231530
C      write (*,*) (0.230994+(0.230992-0.230994)/(91.260696-90.614071)
C     &     *(91.188-90.614071))/0.231530
c for plotting purpose: header for graphx ploting program
c data to compare with 6 true experimental points 4 future expectations
c    ! Cs APV
c    ! Q_weak (ep)
c    ! Moller SLAC E 158
c    ! eDIS  
c    ! nu-DIS NuTeV
c    ! LEP 1
c    ! SLD A_LR
c    ! Tevatron            
c    ! LHC
c    ! project Moller Jlab
c    ! project Qweak Jlab
c    ! project PV-DIS Jlab
c    ! project ILC        
c energies in GeV
      xx(1) =    0.002400    ! Cs APV              
      xx(2) =    0.157000    ! Q_weak (ep)         
      xx(3) =    0.161245    ! Moller SLAC E 158   
      xx(4) =    1.000000    ! eDIS                
      xx(5) =   20.000000    ! nu-DIS NuTeV        
      xx(6) =   91.187600    ! LEP 1               
      xx(7) =   91.187600    ! SLD A_LR            
      xx(8) =   75.187600    ! Tevatron   2018         
      xx(9) =  107.089314    ! LHC
      xx(10) =   0.089314    ! project Moller Jlab
      xx(11)=    0.161655    ! project Qweak Jlab 
      xx(12)=    1.888311    ! project PV-DIS Jlab
      xx(13)= 1000.000000    ! project ILC        
c     sin^2 Theta central values
      sl(1) = 0.238100
      sl(2) = 0.237700
      sl(3) = 0.239700
      sl(4) = 0.235060
      sl(5) = 0.236000
      sl(6) = 0.231530
      sl(7) = 0.230980
      sl(8) = 0.231300
      sl(9) = 0.231700
      sl(10)= 0.237950
      sl(11)= 0.237850
      sl(12)= 0.236200
      sl(13)= 0.238000
c errors
      sh(1) = 0.002000
      sh(2) = 0.001100
      sh(3) = 0.001300
      sh(4) = 0.004400
      sh(5) = 0.001600
      sh(6) = 0.000160
      sh(7) = 0.000260
      sh(8) = 0.000330
      sh(9) = 0.000360
      sh(10)= 0.000250
      sh(11)= 0.000750
      sh(12)= 0.000600
      sh(13)= 0.000250
      write (2,*) '      3.0000'
      write (2,*) '     13.0000'
      write (2,*) '      1.0000'
      write (2,*) ' sin^2 theta experimental data'
      write (4,*) '      3.0000'
      write (4,*) '      1.0000'
      write (4,*) '      1.0000'
      write (4,*) ' LEP 1 renormalization reference point'
      do i=1,13
         write (2,124) xx(i),sl(i),sh(i),sh(i)
      enddo
      i=6  ! LEP 1 renormalization reference point
      write (4,124) xx(i),sl(i),sh(i),sh(i)
124   format(1x,f11.6,4(1x,f11.6))
      stop
      end
